/****************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *                                                                          *
 *      This is the server software for The Isles, called NiMUD 4.0.        *
 *    Copyright (c) 1994-1999 by Herb Gilliland.  All rights reserved.      *
 *                                                                          *
 *  Much time and thought has gone into this software and you are           *
 *  benefitting.  We hope that you share your changes too.  What goes       *
 *  around, comes around.                                                   *
 *                                                                          *
 ****************************************************************************
 *   Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *   Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 ****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"

/*
 * Syntax:  clear
 */
void do_clear ( CHAR_DATA *ch, char *argument )
{
    if ( !HAS_ANSI(ch) )
    send_to_char( "You do not have ansi support enabled.\n\r", ch );
    else
    send_to_char( CLRSCR, ch );

    return;
}

void do_blank ( CHAR_DATA *ch, char *argument )
{
    do_config( ch, "blank" );
}

void do_brief ( CHAR_DATA *ch, char *argument )
{
    do_config( ch, "-brief" );
}

void do_compact ( CHAR_DATA *ch, char *argument )
{
    do_config( ch, "compact" );
}

void do_holylight ( CHAR_DATA *ch, char *argument )
{
    do_config( ch, "holylight" );
}

void do_translate ( CHAR_DATA *ch, char *argument )
{
    do_config( ch, "translate" );
}


/*
 * Syntax:  pager
 *          pager [number]
 */
void do_pager ( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    int lines;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        if ( ch->pagelen == 0 )
        {
            ch->pagelen = 22;
            send_to_char( "Pager on; defaulted to 22 lines per page.\n\r", ch );
            return;
        }

        send_to_char( "Pager off.\n\r", ch );
        ch->pagelen = 0;
        return;
    }

	lines = atoi( arg );

    if ( lines < 0 || lines > 500 )
    {
    send_to_char( "Invalid page length value.\n\r", ch );
	return;
    }

    ch->pagelen = lines;
    sprintf( buf, "Pager set to %d lines.\n\r", lines );
    send_to_char( buf, ch );
    return;
}


/*
 * Originally coded by Morgenes for Aldara Mud
 * Syntax:  prompt
 *          prompt all
 *          prompt [text]
 */
void do_prompt( CHAR_DATA *ch, char *argument )
{
   char buf[MAX_STRING_LENGTH];
   char buf2[MAX_STRING_LENGTH];

   if( argument[0] == '\0' )
   {
      if (!IS_SET(ch->act2, PLR_PROMPT))
      {
         send_to_char( "Prompt ON.\n\r", ch );
         SET_BIT(ch->act2, PLR_PROMPT);
      }
      else
      {
         REMOVE_BIT( ch->act2, PLR_PROMPT );
         send_to_char( "Prompt OFF.\n\r", ch );
      }
      return;
   }

   if( !strcmp( argument, "all" ) )
      strcpy( buf, "< %h %m > " );
   else
   {
      if ( strlen(argument) > 100 )
         argument[100] = '\0';
      strcpy( buf, argument );
      smash_tilde( buf );
   }

   free_string( ch->prompt );
   ch->prompt = str_dup( buf );
   sprintf( buf2, "Prompt set to '%s'.\n\r", ch->prompt );
   send_to_char( buf2, ch );

   if (!IS_SET(ch->act2, PLR_PROMPT))
         SET_BIT(ch->act2, PLR_PROMPT);

   return;
}
 

/*
 * Syntax:  password [old] [new]
 */
void do_password( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char *pArg;
    char *pwdnew;
    char *p;
    char cEnd;

    if ( IS_NPC(ch) )
	return;

    /*
     * Can't use one_argument here because it smashes case.
     * So we just steal all its code.  Bleagh.
     */
    pArg = arg1;
    while ( isspace(*argument) )
	argument++;

    cEnd = ' ';
    if ( *argument == '\'' || *argument == '"' )
	cEnd = *argument++;

    while ( *argument != '\0' )
    {
	if ( *argument == cEnd )
	{
	    argument++;
	    break;
	}
	*pArg++ = *argument++;
    }
    *pArg = '\0';

    pArg = arg2;
    while ( isspace(*argument) )
	argument++;

    cEnd = ' ';
    if ( *argument == '\'' || *argument == '"' )
	cEnd = *argument++;

    while ( *argument != '\0' )
    {
	if ( *argument == cEnd )
	{
	    argument++;
	    break;
	}
	*pArg++ = *argument++;
    }
    *pArg = '\0';

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
	send_to_char( "Syntax: password <old> <new>.\n\r", ch );
	return;
    }

    if ( strcmp( crypt( arg1, PC(ch,pwd) ), PC(ch,pwd) ) )
    {
	WAIT_STATE( ch, 40 );
	send_to_char( "Wrong password.  Wait 10 seconds.\n\r", ch );
	return;
    }

    if ( strlen(arg2) < 5 )
    {
	send_to_char(
	    "New password must be at least five characters long.\n\r", ch );
	return;
    }

    /*
     * No tilde allowed because of player file format.
     */
    pwdnew = crypt( arg2, ch->name );
    for ( p = pwdnew; *p != '\0'; p++ )
    {
	if ( *p == '~' )
	{
	    send_to_char(
		"New password not acceptable, try again.\n\r", ch );
	    return;
	}
    }

    free_string( PC(ch,pwd) );
    PC(ch,pwd) = str_dup( pwdnew );
    save_char_obj( ch );
    send_to_char( "Ok.\n\r", ch );
    return;
}


/*
 * Syntax:  ansi
 *          ansi colors
 *          ansi [keyword] [#]
 *          ansi [keyword] [color]
 */
void do_ansi( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    int c;
    int c2;

    if ( IS_NPC(ch) || !HAS_ANSI(ch) )
    {
        do_help( ch, "ansi" );
        return;
    }

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' )
    {
        send_to_char( "[Keyword  ]  Color Sample\n\r", ch );

        sprintf( buf, "[Rooms    ]  Room titles appear %s%s%s.\n\r",
                  color_table[PC(ch,colors[COLOR_ROOM_TITLE])].code,
                  color_table[PC(ch,colors[COLOR_ROOM_TITLE])].name,
                  color_table[19].code );
        send_to_char( buf, ch );
        if ( IS_IMMORTAL(ch) )
        {
        sprintf( buf, "[Immtalk  ]  The immortal channel appears in %s%s%s.\n\r",
                  color_table[PC(ch,colors[COLOR_IMMTALK])].code,
                  color_table[PC(ch,colors[COLOR_IMMTALK])].name,
                  color_table[19].code );
        send_to_char( buf, ch );
        }
        sprintf( buf, "[Spoken   ]  Spoken communications are shown in %s%s%s.\n\r",
                  color_table[PC(ch,colors[COLOR_COMM])].code,
                  color_table[PC(ch,colors[COLOR_COMM])].name,
                  color_table[19].code );
        send_to_char( buf, ch );
        return;
    };

    if ( !str_prefix( arg1, "colors" ) )
    {
        send_to_char( "Colors:\n\r", ch );
        for ( c = 0; c < 20; c++ )
        {
            sprintf( buf, "[%2d] %s%s%s\n\r",
                          c,
                          c != 0 ? color_table[c].code : "",
                          c == 0 ? "(black)" : color_table[c].name,
                          NTEXT );
            send_to_char( buf, ch );
        }
        return;
    }

    c = -1;
    if ( !str_prefix( arg1, "rooms" ) )      c = COLOR_ROOM_TITLE;
    if ( !str_prefix( arg1, "immtalk" ) )    c = COLOR_IMMTALK;
    if ( !str_prefix( arg1, "spoken" ) )     c = COLOR_COMM;
    
    if ( c < 0 )
    {
        send_to_char( "Configure which color?\n\r", ch );
        return;
    }

    if ( arg2[0] == '\0' )
    {
        send_to_char( "Set it to what color?\n\r", ch );
        return;
    }

    if ( !is_number( arg2 ) )
    {
        for ( c2 = 0; color_table[c2].name[0] != ' '; c2++ )
        {
            if ( !str_prefix( arg2, color_table[c2].name ) )
            break;
        }
    }
    else c2 = atoi( arg2 );

    sprintf( buf, "Invalid color index.\n\r" );

    if ( c2 < 20
      && c2 >= 0 )
    {
        PC(ch,colors[c]) = c2;
        sprintf( buf, "Set to %s%s%s.\n\r",
                 color_table[c2].code,
                 color_table[c2].name, NTEXT );
    };

    send_to_char( buf, ch );
    return;
}


/*
 * Syntax:  config
 *          config [keyword]
 *          config [+/-][keyword]
 */
void do_config( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];

    if ( IS_NPC(ch) )
	return;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        send_to_char( "[ Keyword  ] Option\n\r", ch );

    send_to_char(  IS_SET(ch->act2, PLR_AUTOEXIT)
        ? "[*EXITS    ] You automatically see exits.\n\r"
        : "[ exits    ] You don't automatically see exits.\n\r"
        , ch );

    send_to_char(  IS_SET(ch->act2, PLR_BLANK)
        ? "[*BLANK    ] You have a blank line before your prompt.\n\r"
        : "[ blank    ] You have no blank line before your prompt.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_BRIEF)
        ? "[*BRIEF    ] You see brief descriptions.\n\r"
        : "[ brief    ] You see long descriptions.\n\r"
	    , ch );
         
    send_to_char(  IS_SET(ch->act2, PLR_COMBINE)
        ? "[*COMPACT  ] You see object lists in combined format.\n\r"
        : "[ compact  ] You see object lists in single format.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_PROMPT)
        ? "[*PROMPT   ] You have a prompt.\n\r"
        : "[ prompt   ] You don't have a prompt.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_ANSI)
        ? "[*ANSI     ] You receive ansi color codes.\n\r"
        : "[ ansi     ] You don't receive ansi color codes.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_TELNET_GA)
        ? "[*TELNETGA ] You receive a telnet GA sequence.\n\r"
        : "[ telnetga ] You don't receive a telnet GA sequence.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_SILENCE)
        ? "[*SILENCE  ] You are silenced.\n\r"
	    : ""
	    , ch );

    send_to_char( !IS_SET(ch->act2, PLR_NO_EMOTE)
        ? ""
        : "[ emote    ] You can't emote.\n\r"
        , ch );

    if ( ch->pagelen == 0 )
    send_to_char( "[ pager    ] You are not using the pager.\n\r", ch );
    else
    {
        sprintf( buf, "[    %-3d   ] You are using the pager.\n\r", ch->pagelen );
        send_to_char( buf, ch );
    }

if ( IS_IMMORTAL(ch) )
{
    send_to_char( IS_SET(ch->act2, CHANNEL_IMMTALK )
        ? "[*IMMTALK  ] You are listening to the immortal banter.\n\r"
        : "[ immtalk  ] You are deaf to the immortal banter.\n\r"
	    , ch );

    send_to_char( IS_SET(ch->act2, CHANNEL_WISHES )
        ? "[*WISHES   ] You are listening to mortal wishes.\n\r"
        : "[ wishes   ] You are deaf to mortal wishes.\n\r"
	    , ch );

    send_to_char( IS_SET(ch->act2, WIZ_EQUIPMENT )
        ? "[*EQUIPMENT] You see equipment lists when looking at someone.\n\r"
        : "[ equipment] You do not see equipment lists when looking at someone.\n\r"
	    , ch );

    send_to_char( IS_SET(ch->act2, WIZ_HOLYLIGHT )
        ? "[*HOLYLIGHT] A holy light surrounds you.\n\r"
        : "[ holylight] You are not using holylight.\n\r"
	    , ch );

    send_to_char( IS_SET(ch->act, WIZ_NOTIFY)
        ? "[*NOTIFY   ] You view immortal notifications.\n\r"
        : "[ notify   ] You do not view immortal notifications.\n\r"
	, ch );

    send_to_char( IS_SET(ch->act2, WIZ_TRANSLATE)
	? "[*TRANSLATE] You understand all speech automatically.\n\r"
	: "[ translate] You do not understand all speech automatically.\n\r"
        , ch );
}

    }
    else
    {
    char arg2[MAX_STRING_LENGTH];
	bool fSet;
    int bit = 0;
    int *act_var = &ch->act2;

    fSet = arg[0] == '+';
    if ( arg[0] == '-' || arg[0] == '+' )
    {
                sprintf( arg2, "%c", arg[0] );
                sprintf( arg, "%s", arg+1 );
    }
    
         if ( !str_prefix( arg, "exits"    ) ) bit = PLR_AUTOEXIT;
    else if ( !str_prefix( arg, "blank"    ) ) bit = PLR_BLANK;
    else if ( !str_prefix( arg, "brief"    ) ) bit = PLR_BRIEF;
    else if ( !str_prefix( arg, "compact"  ) ) bit = PLR_COMBINE;
    else if ( !str_prefix( arg, "prompt"   ) ) bit = PLR_PROMPT;
    else if ( !str_prefix( arg, "ansi"     ) ) bit = PLR_ANSI;
    else if ( !str_prefix( arg, "telnetga" ) ) bit = PLR_TELNET_GA;
    else if ( is_number( arg ) )
    {
         int pagelen;

         pagelen = atoi( arg );
         if ( pagelen >= 0 && pagelen < 500 )
         {
              sprintf( arg, "Pager set to %d lines.\n\r", pagelen );
              send_to_char( arg, ch );
              ch->pagelen = pagelen;
              return;
         }
         else
         {
              send_to_char( "Pager can only pause up to 500 lines.\n\r", ch );
              return;
         }
    }
    else
    if ( IS_IMMORTAL(ch) )
    {
        if ( !str_prefix( arg, "notify" ) )
        {
            bit = WIZ_NOTIFY;
            act_var = &ch->act;
        }
        else if ( !str_prefix( arg, "holylight" ) ) bit = WIZ_HOLYLIGHT;
        else if ( !str_prefix( arg, "equipment" ) ) bit = WIZ_EQUIPMENT;
        else if ( !str_prefix( arg, "immtalk"   ) ) bit = CHANNEL_IMMTALK;
        else if ( !str_prefix( arg, "wishes"    ) ) bit = CHANNEL_WISHES;
	else if ( !str_prefix( arg, "translate" ) ) bit = WIZ_TRANSLATE;
	else
        {
            send_to_char( "Set which option?\n\r", ch );
            return;
        }
    }
	else
	{
        send_to_char( "Set which option?\n\r", ch );
	    return;
	}

        if ( fSet )
        {
            sprintf( buf, "Enabled.\n\r" );
            SET_BIT    (*act_var, bit);
        }
        else
        if ( !fSet && arg2[0] == '-' )
        {
            sprintf( buf, "Disabled.\n\r" );
            REMOVE_BIT (*act_var, bit);
        }
        else
        {
            if (IS_SET(ch->act2, bit))
            {
            sprintf( buf, "Disabled.\n\r" );
            REMOVE_BIT (*act_var, bit);
            }
            else
            {
            sprintf( buf, "Enabled.\n\r" );
            SET_BIT    (*act_var, bit);
            }
        }

    send_to_char( buf, ch );
    }

    return;
}


/*
 * Syntax:  notify
 *          notify [keyword]
 */
void do_notify( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];

    smash_tilde( argument );
    argument = one_argument( argument, arg1 );

    if ( !str_cmp(arg1, "death")
      || !str_cmp(arg1, "deaths") )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY_DEATH) )
       {
          send_to_char( "Death notification is now OFF.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY_DEATH);
          return;
       }
       else
       {
          send_to_char( "Death notification is now ON.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY_DEATH);
          return;
       }
    }
    else
    if ( !str_cmp(arg1, "script")
      || !str_cmp(arg1, "scripts") )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY_SCRIPT) )
       {
          send_to_char( "Script track notification is now OFF.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY_SCRIPT);
          return;
       }
       else
       {
          send_to_char( "Script track notification is now ON.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY_SCRIPT);
          return;
       }
    }

    if ( !str_cmp(arg1, "notify") )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY) )
       {
          send_to_char( "Notify is now INACTIVE.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY);
          return;
       }
       else
       {
          send_to_char( "Notify is now ACTIVE.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY);
          return;
       }
    }
    else
    if ( !str_cmp(arg1, "bug")
      || !str_cmp(arg1, "bugs") )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY_BUG) )
       {
          send_to_char( "Bug notification is now OFF.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY_BUG);
          return;
       }
       else
       {
          send_to_char( "Bug notification is now ON.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY_BUG);
          return;
       }
    }
    else
    if ( !str_cmp(arg1, "log")
      || !str_cmp(arg1, "logs") )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY_LOG) )
       {
          send_to_char( "Log notification is now OFF.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY_LOG);
          return;
       }
       else
       {
          send_to_char( "Log notification is now ON.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY_LOG);
          if ( IS_SET( ch->act, WIZ_NOTIFY_BUG ) ) REMOVE_BIT(ch->act, WIZ_NOTIFY_BUG);
          return;

       }
    }
    else
    if ( !str_cmp(arg1, "login")
      || !str_cmp(arg1, "logins") )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY_LOGIN) )
       {
          send_to_char( "Login notify is now OFF.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY_LOGIN);
          return;
       }
       else
       {
          send_to_char( "Login notify is now ON.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY_LOGIN);
          return;
       }
    }
    else
    {
        send_to_char( "[ Keyword  ] Option\n\r", ch );

    send_to_char(  IS_SET(ch->act, WIZ_NOTIFY_LOGIN)
        ? "[*LOGINS   ] You are monitoring player logins.\n\r"
        : "[ logins   ] You don't monitor player logins.\n\r"
        , ch );

    send_to_char(  IS_SET(ch->act, WIZ_NOTIFY_BUG)
        ? "[*BUGS     ] You see all bug reports.\n\r"
        : "[ bugs     ] You are currently ignoring bug reports.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act, WIZ_NOTIFY_SCRIPT)
        ? "[*SCRIPTS  ] You are tracking script procedures.\n\r"
        : "[ scripts  ] You are not tracking script procedures.\n\r"
	    , ch );
         
    send_to_char(  IS_SET(ch->act, WIZ_NOTIFY_LOG)
        ? "[*LOGS     ] You are viewing log entries.\n\r"
        : "[ logs     ] You are not viewing log entries.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act, WIZ_NOTIFY_DEATH)
        ? "[*DEATHS   ] You are notified of player deaths.\n\r"
        : "[ deaths   ] You are not notified of player deaths.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act, WIZ_NOTIFY)
        ? "[*NOTIFY   ] Notify is currently active.\n\r"
        : "[ notify   ] Notify has been rendered inactive.\n\r"
	    , ch );

        return;
    }

    return;
}


