/*****************************************************************************
 * Locke's   __ -based on merc v2.2-____        NIM Server Software          *
 * ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION     *
 * |  /   \  __|  \__/  |  | |  |     O|        documentation release        *
 * |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999            *
 * |    |  ||  |  |__|  |       |     D|                                     *
 * |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud   *
 *   n a m e l e s s i n c a r n a t e          dedicated to chris cool      *
 *****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "script.h"
#include "skills.h"
#include "comm.h"

/*
 * Syntax:  smote [text]
 *          in text, #<keyword> gets replaced with "smote", e.g.
 *          smote hello #greet have a nice day -->
 *          "Hello," you greet, "Have a nice day"
 *          if no #<keyword> is found, it defaults to "say"
 */
void do_smote( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *mob;
    char *c, *point = "";
    char *message, *tailer;
    int smote = 0;	/* Defaults to "say" */

    const char * const smote_table[] =
    {
    "say",      "state",     "declare",    "greet",     "hail",
    "speak",    "report",    "remark",     "comment",   "continue",
    "chuckle",  "laugh",     "sneer",      "grin",      "smile",
    "exclaim",  "shout",     "yell",       "scream",    "grimace",
    "boom",     "thunder",   "roar",       "storm",     "blare",
    "bellow",   "demand",    "warn",       "advise",    "suggest",
    "observe",  "whisper",   "sob",        "sigh",      "coo",
    "groan",    "croak",     "rasp",       "agree",     "decide",
    "disagree", "object",    "decline",    "utter",     "mumble",
    "mutter",   "murmur",    "grunt",      "stutter",   "ask",
    "respond",  "muse",      "ponder",     "wonder",    "ruminate",
    "grumble",  "growl",     "snap",       "snarl",     "spit",
    "retort",   "squeak",    "whimper",    "whine",     "beg",
    "pray",     "explain",   "offer",      "inquire",   "sing",
	""
    };


    if ( MTD(argument) )
    {
        send_to_char( "Smote what?\n\r", ch );
        return;
    }

    /* Grab the '#' keyword */
    for ( c = argument; *c; c++ )
    {
	if ( *c == '#' )
	{
	    char keyword[ MAX_INPUT_LENGTH ];
	    register int i;
	    *c++ = '\0';
	    for( i = 0, keyword[0] = '\0'; *c && !isspace(*c); keyword[i++] = *c++ );
	    keyword[i] = '\0';
	    point = c;
	    if ( keyword[0] != '\0' )
	    {
		for( i = 0; smote_table[i][0] != '\0'; i++ )
		{
		    if ( !str_prefix(keyword, smote_table[i]) )
		    {
			smote = i;
			break;
		    }
		}
	    }
	    break;
	}
    }
    /* Strip leading blanks */
    while( *argument && isspace(*argument) ) argument++;
    while( *point && isspace(*point) ) point++;

    if ( MTD(argument) && MTP(point) )
    {
	send_to_char( "Invalid or missing argument.\n\r", ch );
	return;
    }
	    
    /* Strip tailing blanks from the first part... */
    for( c = &argument[strlen(argument)-1]; *c && isspace(*c) ; c-- )
	*c = '\0';
    tailer = ispunct(*c) ? "" : ",";

    if ( !MTD(argument) )
    	sprintf( buf, "\"%s%s\" you ", capitalize(argument), tailer );
    else
	sprintf( buf, "You " );
    strcat( buf, smote_table[smote] );
    if ( !MTP(point) )
    	sprintf( &buf[strlen(buf)], ",  \"%s\"", capitalize(point) );
    else
	strcat( buf, "." );
    message = format_indent( str_dup(buf), "   ", 74, FALSE );
    sprintf( buf, "%sIn %s:\n\r  $t%s",
             color_table[GET_PC(ch,colors[COLOR_COMM],7)].act_code,
             lang_table[ch->speaking].name,
             HAS_ANSI(ch) ? ANSI_NORMAL : "" );
    act( buf, ch, message, NULL, TO_CHAR  );
    free_string( message );

    for ( mob = ch->in_room->people;  mob != NULL;  mob = mob->next_in_room )
    {
        if ( mob != ch && mob->desc != NULL )
        {
	    if ( !MTD(argument) )
	    {
	        sprintf( buf, "\"%s%s\" %s ",
		capitalize(garble_text( argument,
                  check_speech( mob, ch, *lang_table[ch->speaking].pgsn )) ),
		tailer,
		PERS(ch, mob) );
	    }
	    else
	        sprintf( buf, "%s ", capitalize(PERS(ch, mob)) );

    	    strcat( buf, smote_table[smote] );
	    if ( !MTP(point) )
	    {
    	    	sprintf( &buf[strlen(buf)], "s,  \"%s\"",
		capitalize(garble_text( point,
                  check_speech( mob, ch, *lang_table[ch->speaking].pgsn)) ) );
	    }
	    else
		strcat( buf, "s." );
    	    message = format_indent( str_dup(buf), "   ", 74, FALSE );

            sprintf( buf, "%sIn %s:\n\r  $t%s",
                      color_table[GET_PC(mob,colors[COLOR_COMM],7)].act_code,
                      !IS_NPC(mob) && PC(mob, learned)[*lang_table[ch->speaking].pgsn] <= 0 ?
                      "a strange, foreign tongue" : lang_table[ch->speaking].name,
            	      HAS_ANSI(mob) ? ANSI_NORMAL : "" );
                      
	    act( buf, mob, message, ch, TO_CHAR );
    	    free_string( message );
	}

        if ( IS_NPC(ch) && IS_NPC(mob)
          && mob->pIndexData->vnum == ch->pIndexData->vnum ) 
            continue;

        script_update( mob, TYPE_MOB, TRIG_SAY, ch, NULL, argument, NULL );
    }

    trigger_list( ch->in_room->contents, TRIG_SAY, ch, NULL, argument, NULL );
    trigger_list( ch->carrying, TRIG_SAY, ch, NULL, argument, NULL );
    return;
}


/*
 * Syntax:  immtalk
 *          immtalk [text]
 */
void do_immtalk( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *och;
    char arg[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    char *message;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        TOGGLE_BIT(ch->act2, CHANNEL_IMMTALK);

        if ( IS_SET(ch->act2, CHANNEL_IMMTALK) )
             send_to_char( "Immtalk on.\n\r", ch );
        else send_to_char( "Immtalk off.\n\r", ch );
        return;
    }

    message = format_indent( str_dup(argument), "   ", 74, FALSE );

    for ( och = char_list;  och != NULL;  och = och->next )
    {
        if ( !IS_IMMORTAL(och)
          || !IS_SET(och->act2,CHANNEL_IMMTALK)
          || IS_NPC(och) )
        continue;

        if ( och->desc != NULL )
        {

            sprintf( buf, "%s%s--\n\r   %s%s\n\r",
                   HAS_ANSI(och) ?
                       color_table[PC(och,colors)[COLOR_IMMTALK]].code : "",
                   och==ch ? "You" :
                     can_see(och, ch) ? STR(ch,name) : "Someone", message,
                   HAS_ANSI(och) ? ANSI_NORMAL : "" );
            send_to_char( buf, och );
        }
    }

    free_string( message );
    return;
}


/*
 * Syntax:  contact [person] [text]
 */
void do_contact( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *victim;
    char *message;
    int position;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' || argument[0] == '\0' )
    {
        send_to_char( "Contact whom for what?\n\r", ch );
        return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL
      && victim->desc != NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    message = format_indent( str_dup(argument), "   ", 74, FALSE );

    if ( victim != ch )
    {
    sprintf( buf, "%sYour message echos in $N's mind:\n\r   \"$t\"$R",
             color_table[GET_PC(ch,colors[COLOR_COMM],7)].act_code );
    act( buf, ch, message, victim, TO_CHAR );
    }

    sprintf( buf, "%sYour thoughts unfocus as a message from\n\r$N echos in your mind:\n\r   \"$t\"$R",
             color_table[GET_PC(victim,colors[COLOR_COMM],7)].act_code );

    position            = victim->position;
    victim->position    = POS_STANDING;
    act( buf, victim, message, ch, TO_CHAR );
    victim->position    = position;

    free_string(message);
    return;
}


/*
 * Syntax:  contact [person] [text]
 */
void do_whisper( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *victim;
    char *message;
    int position;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' || argument[0] == '\0' )
    {
        send_to_char( "Whisper to whom what?\n\r", ch );
        return;
    }

    if ( ( victim = get_char_room( ch, arg ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    message = format_indent( str_dup(argument), "   ", 74, FALSE );

    if ( victim != ch )
    {
    sprintf( buf, "%sYou whisper to $N in %s:\n\r   \"$t\"$R",
             color_table[GET_PC(ch,colors[COLOR_COMM],7)].act_code,
             lang_table[ch->speaking].name );
    act( buf, ch, message, victim, TO_CHAR );
    }

    act( "$n whispers something to $N.", ch, NULL, victim, TO_ROOM );

    sprintf( buf, "%s$n whispers to you in %s:\n\r   \"$t\"$R",
             color_table[GET_PC(victim,colors[COLOR_COMM],7)].act_code,
             lang_table[ch->speaking].name );

    position            = victim->position;
    victim->position    = POS_STANDING;
    act( buf, victim,
         garble_text( message,
           check_speech( victim, ch, *lang_table[ch->speaking].pgsn ) ),
         ch, TO_CHAR );
    victim->position    = position;

    free_string(message);
    return;
}



/*
 * Syntax:  wish
 *          wish [person] [text]
 *          wish all [text]
 */
void do_wish( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *och;
    char arg[MAX_INPUT_LENGTH];
    bool fAll = FALSE;
    char buf[MAX_STRING_LENGTH];
    char *message;

    argument = one_argument( argument, arg );

    if ( IS_IMMORTAL(ch) )
    {
        TOGGLE_BIT(ch->act2, CHANNEL_WISHES);

        if ( IS_SET(ch->act2, CHANNEL_WISHES) )
             send_to_char( "Wishes on.\n\r", ch );
        else send_to_char( "Wishes off.\n\r", ch );
        return;
    }

    if ( (och = get_char_world( ch, arg )) == NULL
      && !str_cmp( arg, "all" ) )
    fAll = TRUE;

    if ( ( och == NULL
        || !IS_SET(och->act2,CHANNEL_WISHES) )
      && !fAll )
    {
        send_to_char( "That immortal is not available.\n\r", ch );
        return;
    }


    message = format_indent( str_dup(argument), "   ", 74, FALSE );

    for ( och = char_list;  och != NULL;  och = och->next )
    {
        if ( och->desc != NULL )
        {
            if ( ch != och )
            if ( IS_NPC(ch)
              || IS_NPC(och)
              || !IS_IMMORTAL(och)
              || !IS_SET(och->act2,CHANNEL_WISHES) )
            continue;

	            sprintf( buf, "%s%s wish%s:\n\r%s   %s\n\r",
        	           HAS_ANSI(och) ?
               	           color_table[PC(och,colors)
               	           [IS_IMMORTAL(och) ? COLOR_IMMTALK : COLOR_COMM]].code : "",
                 	   och==ch ? "You" : NAME(ch),
             	           och==ch ? "" : "es",
                           message,
                    HAS_ANSI(och) ? ANSI_NORMAL : "" );
                    send_to_char( buf, och );
        }
    }

    free_string( message );
    return;
}




void shout( CHAR_DATA *ch, CHAR_DATA *rch, char *message, int dir )
{
    char buf[MAX_STRING_LENGTH];

    if ( ch == rch )
    {
        sprintf( buf, "%sYou shout, in %s:\n\r  \"$t\"$R",
                 color_table[GET_PC(ch,colors[COLOR_COMM],7)].act_code,
                 lang_table[ch->speaking].name );
        act( buf, ch, message, NULL, TO_CHAR );
        return;
    }

    if ( rch->in_room != ch->in_room )
        sprintf( buf, "%sYou hear %s shout in %s from %s:\n\r   \"%s\"%s\n\r",
                 HAS_ANSI(rch) ? color_table[PC(rch,colors[COLOR_COMM])].code : "",
                 (ch->sex == SEX_MALE)   ? "a man"       :
                 (ch->sex == SEX_FEMALE) ? "a woman"     : "someone",
                 GET_PC(rch,learned[*lang_table[ch->speaking].pgsn],100) > 0 ?
                   lang_table[ch->speaking].name : "a strange, foreign tongue",
                 dir_rev[rev_dir[dir]],
                 garble_text( message,
                     check_speech( rch, ch, *lang_table[ch->speaking].pgsn ) ),
                 HAS_ANSI(rch) ? ANSI_NORMAL : "" );
        else
        sprintf( buf, "%s%s shouts, in %s:\n\r   \"%s\"%s\n\r",
                 HAS_ANSI(rch) ? color_table[PC(rch,colors[COLOR_COMM])].code : "",
                 capitalize(PERS(ch, rch)),
                 GET_PC(rch,learned[*lang_table[ch->speaking].pgsn],100) > 0 ?
                   lang_table[ch->speaking].name : "a strange, foreign tongue",
                 garble_text( message,
                     check_speech( rch, ch, *lang_table[ch->speaking].pgsn ) ),
                 HAS_ANSI(rch) ? ANSI_NORMAL : "" );

    send_to_char( buf, rch );

    return;
}



/*
 * Syntax:  shout [text]
 */
void do_shout( CHAR_DATA *ch, char *argument )
{
    int door;
    ROOM_INDEX_DATA *pRoom;
    CHAR_DATA *rch;
    char *message;

    if ( *argument == '\0' )
    {
        send_to_char( "Shout what?\n\r", ch );
        return;
    }

    message = format_indent( str_dup(argument), "   ", 74, FALSE );

    pRoom = ch->in_room;

    for ( rch = char_list;  rch != NULL;  rch = rch->next )
    {
        if ( (door=find_first_step(rch->in_room, pRoom, 3)) >= 0
          || rch->in_room == pRoom )
            shout( ch, rch, message, door );
    }

    free_string( message );
    return;
}


void say_to( CHAR_DATA *ch, CHAR_DATA *victim, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char *verb;
    char *message;

    if ( argument[0] == '\0' )
    {
        send_to_char( "Say what?\n\r", ch );
        return;
    }

    switch ( argument[strlen(argument)-1] )
    {
        default: verb = "say";     break;
       case '!': verb = "exclaim"; break;
       case '?': verb = "ask";     break;
    }

    message = format_indent( str_dup(argument), "   ", 74, FALSE );

    sprintf( buf, "%sYou %s to %s in %s:\n\r  \"$t\"%s",
             color_table[GET_PC(victim,colors[COLOR_COMM],7)].act_code,
             verb,
             NAME(victim),
             lang_table[ch->speaking].name,
             HAS_ANSI(ch) ? ANSI_NORMAL : "" );
    act( buf, ch, message, NULL, TO_CHAR  );

    sprintf( buf, "%s%s %ss %syou in %s:\n\r   \"$t\"%s",
                  color_table[GET_PC(victim,colors[COLOR_COMM],7)].act_code,
                  capitalize(PERS(ch, victim)),
                  verb,
                  verb[0] != 'a' ? "to " : "",
                 GET_PC(victim,learned[*lang_table[ch->speaking].pgsn],100) > 0 ?
                   lang_table[ch->speaking].name : "a strange, foreign tongue",
                  HAS_ANSI(victim) ? ANSI_NORMAL : "" );
                      
    if ( victim != ch && victim->desc != NULL )
    act( buf, victim,
         garble_text( message,
           check_speech( victim, ch, *lang_table[ch->speaking].pgsn ) ),
         NULL, TO_CHAR );

    script_update( victim, TYPE_MOB, TRIG_SAY, ch, NULL, argument, NULL );
    free_string( message );
    return;
}





/*
 * Syntax:  say [text]
 */
void do_say( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *mob;
    char *verb;
    char *message;

    if ( argument[0] == '\0' )
    {
        send_to_char( "Say what?\n\r", ch );
        return;
    }
    /*
     * Guest character support.
     * Force guests to speak OOC.
     */
    if ( !IS_NPC(ch) && !str_cmp( ch->name, "guest" ) )
    {
        do_ooc( ch, argument );
        return;
    }

    switch ( argument[strlen(argument)-1] )
    {
        default: verb = "say";     break;
       case '!': verb = "exclaim"; break;
       case '?': verb = "ask";     break;
    }

    message = format_indent( str_dup(argument), "   ", 74, FALSE );

    sprintf( buf, "%sYou %s, in %s:\n\r  \"$t\"%s",
             color_table[GET_PC(ch,colors[COLOR_COMM],7)].act_code,
             verb,
             lang_table[ch->speaking].name,
             HAS_ANSI(ch) ? ANSI_NORMAL : "" );
    act( buf, ch, message, NULL, TO_CHAR  );

    for ( mob = ch->in_room->people;  mob != NULL;  mob = mob->next_in_room )
    {
        sprintf( buf, "%s%s %ss, in %s:\n\r   \"$t\"%s",
                      color_table[GET_PC(mob,colors[COLOR_COMM],7)].act_code,
                      capitalize(PERS(ch, mob)),
                      verb,
                 GET_PC(mob,learned[*lang_table[ch->speaking].pgsn],100) > 0 ?
                   lang_table[ch->speaking].name : "a strange, foreign tongue",
                      HAS_ANSI(mob) ? ANSI_NORMAL : "" );
                      
        if ( mob != ch && mob->desc != NULL )
            act( buf, mob,
                 garble_text( message,
                  check_speech( mob, ch, *lang_table[ch->speaking].pgsn ) ),
                 NULL, TO_CHAR );

        if ( IS_NPC(ch) && IS_NPC(mob)
          && mob->pIndexData->vnum == ch->pIndexData->vnum ) 
            continue;

        script_update( mob, TYPE_MOB, TRIG_SAY, ch, NULL, argument, NULL );
    }

    free_string( message );

    script_update( ch->in_room, TYPE_ROOM, TRIG_SAY, ch, NULL, argument, NULL );
    trigger_list( ch->in_room->contents, TRIG_SAY, ch, NULL, argument, NULL );
    trigger_list( ch->carrying, TRIG_SAY, ch, NULL, argument, NULL );
    return;
}

/*
 * Syntax:  talk [text]
 * Only to those sitting at your furniture.
 */
void do_talk( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *mob;
    char *verb;
    char *message;

    if ( argument[0] == '\0' )
    {
        send_to_char( "Talk by saying what?\n\r", ch );
        return;
    }
    /*
     * Guest character support.
     * Force guests to speak OOC.
     */
    if ( !IS_NPC(ch) && !str_cmp( ch->name, "guest" ) )
    {
        do_ooc( ch, argument );
        return;
    }

    if ( ch->furniture == NULL )
    {
        send_to_char( "You aren't sitting at or on anything.\n\r", ch );
        do_say( ch, argument );
        return;
    }

    switch ( argument[strlen(argument)-1] )
    {
        default: verb = "say";     break;
       case '!': verb = "exclaim"; break;
       case '?': verb = "ask";     break;
    }

    message = format_indent( str_dup(argument), "   ", 74, FALSE );

    sprintf( buf, "%sFrom %s, you %s, in %s:\n\r  \"$t\"%s",
             STR(ch->furniture, short_descr),
             color_table[GET_PC(ch,colors[COLOR_COMM],7)].act_code,
             verb,
             lang_table[ch->speaking].name,
             HAS_ANSI(ch) ? ANSI_NORMAL : "" );
    act( buf, ch, message, NULL, TO_CHAR  );

    for ( mob = ch->in_room->people;  mob != NULL;  mob = mob->next_in_room )
    {
        sprintf( buf, "%sFrom %s, %s %ss, in %s:\n\r   \"$t\"%s",
                      STR(ch->furniture, short_descr),
                      color_table[GET_PC(mob,colors[COLOR_COMM],7)].act_code,
                      capitalize(PERS(ch, mob)),
                      verb,
                 GET_PC(mob,learned[*lang_table[ch->speaking].pgsn],100) > 0 ?
                   lang_table[ch->speaking].name : "a strange, foreign tongue",
                      HAS_ANSI(mob) ? ANSI_NORMAL : "" );
                      
        if ( mob != ch && mob->desc != NULL && mob->furniture == ch->furniture )
            act( buf, mob,
                 garble_text( message,
                  check_speech( mob, ch, *lang_table[ch->speaking].pgsn ) ),
                 NULL, TO_CHAR );

        if ( IS_NPC(ch) && IS_NPC(mob)
          && mob->pIndexData->vnum == ch->pIndexData->vnum ) 
            continue;

        script_update( mob, TYPE_MOB, TRIG_SAY, ch, NULL, argument, NULL );
    }

    free_string( message );

    script_update( ch->in_room, TYPE_ROOM, TRIG_SAY, ch, NULL, argument, NULL );
    trigger_list( ch->in_room->contents, TRIG_SAY, ch, NULL, argument, NULL );
    trigger_list( ch->carrying, TRIG_SAY, ch, NULL, argument, NULL );
    return;
}

/*
 * Syntax:  say [text]
 */
void do_ooc( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *mob;
    char *verb;
    char *message;

    if ( argument[0] == '\0' )
    {
        send_to_char( "Say what?\n\r", ch );
        return;
    }

    switch ( argument[strlen(argument)-1] )
    {
        default: verb = "say";     break;
       case '!': verb = "exclaim"; break;
       case '?': verb = "ask";     break;
    }

    message = format_indent( str_dup(argument), "   ", 74, FALSE );

    sprintf( buf, "%sYou %s, out-of-character:\n\r  \"$t\"%s",
             color_table[GET_PC(ch,colors[COLOR_COMM],7)].act_code,
             verb,
             HAS_ANSI(ch) ? ANSI_NORMAL : "" );
    act( buf, ch, message, NULL, TO_CHAR  );

    for ( mob = ch->in_room->people;  mob != NULL;  mob = mob->next_in_room )
    {
        sprintf( buf, "%s%s %ss, out-of-character:\n\r   \"$t\"%s",
                      color_table[GET_PC(mob,colors[COLOR_COMM],7)].act_code,
                      capitalize(PERS(ch, mob)),
                      verb,
                      HAS_ANSI(mob) ? ANSI_NORMAL : "" );
                      
        if ( mob != ch && mob->desc != NULL )
            act( buf, mob, message, NULL, TO_CHAR );

        if ( IS_NPC(ch) && IS_NPC(mob)
          && mob->pIndexData->vnum == ch->pIndexData->vnum ) 
            continue;
    }

    free_string( message );
    return;
}



/*
 * Syntax: speak [language]
 */
void do_speak( CHAR_DATA *ch, char *argument )
{
    int x;

    if ( MTD(argument) )
    {
        send_to_char( "Speak which language?\n\r", ch );
        return;
    }

    for ( x = 0; x < MAX_LANGUAGE; x++ )
    {
        if ( !str_prefix( argument, lang_table[x].name )
          && (IS_NPC(ch) || PC(ch,learned)[*lang_table[x].pgsn] > 0) )
        {
            ch->speaking = x;
            send_to_char( "You now speak ", ch );
            send_to_char( lang_table[x].name, ch );
            send_to_char( ".\n\r", ch );
            return;
        }
    }

    send_to_char( "You know not of that language.\n\r", ch );
    return;
}


/*
 * Syntax: emote [action]
 */
void do_emote( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char *plast;

    if ( !IS_NPC(ch) && IS_SET(ch->act2, PLR_NO_EMOTE) )
    {
        send_to_char( "You can't show your emotions.\n\r", ch );
        return;
    }

    if ( argument[0] == '\0' )
    {
        send_to_char( "Emote what?\n\r", ch );
        return;
    }

    for ( plast = argument; *plast != '\0'; plast++ );

    strcpy( buf, argument );
    if ( isalpha(plast[-1]) )
        strcat( buf, "." );


    plast = format_indent( str_dup(buf), "", 76-strlen(NAME(ch)), FALSE );
    plast[0] = buf[0];

    act( "$n $T", ch, NULL, plast, TO_ROOM );

    if (ch->desc != NULL)
    act( "$t $T", ch, capitalize(NAME(ch)), plast, TO_CHAR );

    free_string( plast );
    return;
}


/*
 * Syntax:  bug [report]
 */
void do_bug( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];

    sprintf( buf, "Notify> BUG: [%5d] %s- %s",
             ch->in_room->vnum, STR(ch,name), argument );
    NOTIFY( buf, LEVEL_IMMORTAL, WIZ_NOTIFY_BUG );

    append_file( ch, BUG_FILE, argument );
    send_to_char( "Ok.  Thanks.\n\r", ch );
    return;
}


/*
 * Syntax:  idea [suggestion]
 */
void do_idea( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];

    sprintf( buf, "Notify> IDEA: [%5d] %s- %s",
             ch->in_room->vnum, STR(ch,name), argument );
    NOTIFY( buf, LEVEL_IMMORTAL, WIZ_NOTIFY_BUG );

    append_file( ch, IDEA_FILE, argument );
    send_to_char( "Ok.  Thanks.\n\r", ch );
    return;
}


/*
 * Syntax:  typo [error]
 */
void do_typo( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];

    sprintf( buf, "Notify> TYPO: [%5d] %s- %s",
             ch->in_room->vnum, STR(ch,name), argument );
    NOTIFY( buf, LEVEL_IMMORTAL, WIZ_NOTIFY_BUG );

    append_file( ch, TYPO_FILE, argument );
    send_to_char( "Ok.  Thanks.\n\r", ch );
    return;
}



void do_qui( CHAR_DATA *ch, char *argument )
{
    send_to_char( "If you want to QUIT, you have to spell it out.\n\r", ch );
    return;
}


/*
 * Syntax:  quit
 */
void do_quit( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    char buf[MAX_STRING_LENGTH];

    if ( IS_NPC(ch) )
    {
        do_return( ch, "" );
        return;
    }

    if ( ch->position == POS_FIGHTING )
    {
        send_to_char( "No way! You are fighting.\n\r", ch );
        return;
    }

    if ( ch->position  < POS_STUNNED  )
    {
        send_to_char( "You're not DEAD yet.\n\r", ch );
        return;
    }

    if ( GET_PC(ch,level,0) > 1 ) do_help( ch, "FAREWELL" );

    stop_idling( ch );

    sprintf( log_buf, "%s (%s) has left the game.", ch->name, ch->short_descr );
    log_string( log_buf );

    sprintf( buf, "Notify>  %s (%s) has left the game.", ch->name, ch->short_descr );
    NOTIFY( buf, LEVEL_IMMORTAL, WIZ_NOTIFY_LOGIN );

    act( "$n has left the game.", ch, NULL, NULL, TO_NOTVICT );

    sprintf( buf, "%s", STR(ch,name) );
    save_char_obj( ch );
    d = ch->desc;

    extract_char( ch, TRUE );

    if ( str_cmp( buf, "guest" ) && !str_cmp( argument, "menu" ) )
    {
        load_char_obj( d, buf );
        ch = d->character;
        print_login_menu( ch );
        d->connected = CON_LOGIN_MENU;
        return;
    }

    /*
     * After extract_char the ch is no longer valid!
     */
    if ( d != NULL ) close_socket( d );
    return;
}



/*
 * Syntax:  save
 */
void do_save( CHAR_DATA *ch, char *argument )
{
    if ( IS_NPC(ch) )
        return;

    save_char_obj( ch );
    send_to_char( "Saved ", ch );
    send_to_char( NAME(ch), ch );
    send_to_char( ".\n\r", ch );
    return;
}


/*
 * Syntax:  follow [person]
 *          follow self
 */
void do_follow( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        send_to_char( "Follow whom?\n\r", ch );
        return;
    }

    if ( ( victim = get_char_room( ch, arg ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    if ( IS_AFFECTED(ch, AFF_CHARM) && ch->master != NULL )
    {
        act( "But you'd rather follow $N!", ch, NULL, ch->master, TO_CHAR );
        return;
    }

    if ( victim == ch )
    {
        if ( ch->master == NULL )
        {
            send_to_char( "You already follow yourself.\n\r", ch );
            return;
        }
        stop_follower( ch );
        return;
    }
    
    if ( ch->master != NULL )
        stop_follower( ch );

    add_follower( ch, victim );
    return;
}



void add_follower( CHAR_DATA *ch, CHAR_DATA *master )
{
    if ( ch->master != NULL )
    {
        bug( "Add_follower: non-null master.", 0 );
        return;
    }

    ch->master        = master;
    if ( (!IS_NPC(ch)      && ch->desc      && !CONNECTED(ch->desc))
      || (!IS_NPC(master)  && master->desc  && !CONNECTED(master->desc)) )
    return;

    if ( can_see( master, ch ) )
    act( "$n now follows you.", ch, NULL, master, TO_VICT );

    act( "You now follow $N.",  ch, NULL, master, TO_CHAR );

    return;
}



void stop_follower( CHAR_DATA *ch )
{
    if ( ch->master == NULL )
    {
        bug( "Stop_follower: null master.", 0 );
        return;
    }

    if ( IS_AFFECTED(ch, AFF_CHARM) )
    {
        REMOVE_BIT( ch->affected_by, AFF_CHARM );
        affect_strip( ch, gsn_charm_person );
    }

    if ( can_see( ch->master, ch ) )
    act( "$n stops following you.",     ch, NULL, ch->master, TO_VICT    );
    act( "You stop following $N.",      ch, NULL, ch->master, TO_CHAR    );

    ch->master = NULL;
    return;
}



void die_follower( CHAR_DATA *ch )
{
    CHAR_DATA *fch;

    if ( ch->master != NULL )
        stop_follower( ch );

    for ( fch = char_list; fch != NULL; fch = fch->next )
    {
        if ( fch->master == ch )
            stop_follower( fch );
    }

    return;
}



/*
 * Syntax:  order [person] [action]
 */
void do_order( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char arg_cmd[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    CHAR_DATA *och;
    CHAR_DATA *och_next;
    bool found;
    bool fAll;

    argument = one_argument( argument, arg );
    one_argument( argument, arg_cmd );

    if ( arg[0] == '\0' || argument[0] == '\0' )
    {
        send_to_char( "Order whom to do what?\n\r", ch );
        return;
    }

    if ( IS_AFFECTED( ch, AFF_CHARM ) )
    {
        send_to_char( "You feel like taking, not giving, orders.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg, "all" ) )
    {
        fAll   = TRUE;
        victim = NULL;
    }
    else
    {
        fAll   = FALSE;
        if ( ( victim = get_char_room( ch, arg ) ) == NULL )
        {
            send_to_char( "They aren't here.\n\r", ch );
            return;
        }

        if ( victim == ch )
        {
            send_to_char( "Aye aye, right away!\n\r", ch );
            return;
        }

        if ( !IS_AFFECTED(victim, AFF_CHARM) || victim->master != ch )
        {
            send_to_char( "Do it yourself!\n\r", ch );
            return;
        }
    }

    if ( str_prefix( arg_cmd, "get"    )
      && str_prefix( arg_cmd, "drop"   )
      && str_prefix( arg_cmd, "wear"   )
      && str_prefix( arg_cmd, "sheath" )
      && str_prefix( arg_cmd, "draw"   )
      && str_prefix( arg_cmd, "stand"  )
      && str_prefix( arg_cmd, "remove" )
      && str_prefix( arg_cmd, "wield"  )
      && str_prefix( arg_cmd, "hold"   ) )
    {
        send_to_char( "You can't order them to do that.\n\r", ch );
        return;
    }


    found = FALSE;
    for ( och = ch->in_room->people; och != NULL; och = och_next )
    {
        och_next = och->next_in_room;

        if ( IS_AFFECTED(och, AFF_CHARM)
        &&   och->master == ch
        && ( fAll || och == victim ) )
        {
            found = TRUE;
            act( "$n orders you to '$t'.", ch, argument, och, TO_VICT );
            interpret( och, argument );
        }
    }

    if ( found )
    send_to_char( "Ok.\n\r", ch );
    else
    send_to_char( "You have no followers here.\n\r", ch );
    return;
}




