/****************************************************************************
 *                                                                          *
 ****************************************************************************
 * Locke's   __ -based on merc v2.2-____        NIM Server Software         *
 * ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION    *
 * |  /   \  __|  \__/  |  | |  |     O|        documentation release       *
 * |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999           *
 * |    |  ||  |  |__|  |       |     D|                                    *
 * |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud  *
 *   n a m e l e s s i n c a r n a t e          dedicated to chris cool     *
 ****************************************************************************
 *      This is the server software for The Isles, called NiMUD 3.0.
 *    Copyright (c) 1994-1999 by Herb Gilliland.  All rights reserved.      *
 *                                                                          *
 *  Much time and thought has gone into this software and you are           *
 *  benefitting.  We hope that you share your changes too.  What goes       *
 *  around, comes around.                                                   *
 *                                                                          *
 ****************************************************************************
 *   Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *   Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 ****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "comm.h"
#include "skills.h"


char *  const   where_name  [] =
{
    "<as earring>",
    "<as earring>",
    "<placed on head>",
    "<fastened to helm>",
    "<tied about forehead>",
    "<over face>",
    "<piercing nose>",
    "<around neck>",
    "<around neck>",
    "<as shirt>",
    "<on body>",
    "<strapped to back>",
    "<on legs>",
    "<as pants>",
    "<as stockings>",
    "<on feet>",
    "<around ankle>",
    "<around ankle>",
    "<on arms>",
    "<around wrist>",
    "<around wrist>",
    "<on hands>",
    "<on finger>",
    "<on finger>",
    "<as shield>",
    "<about body>",
    "<floating nearby>",
    "<worn about waist>",
    "<over loins>",
    "<pinned on garment>",
    "<thrust through belt>",
    "<thrust through belt>",
    "<thrust through belt>",
    "<thrust through belt>",
    "<thrust through belt>",
    "<held in hand>",
    "<held in hand>",
    "<slung over shoulder>",
    "<slung over shoulder>",
    "<wield primary>",
    "<wield secondary>",
    "<fastened to waist>",
    "<fastened to waist>",
    "<fastened to waist>",
    "<on shoulders>",
};




#define MAX_ITERATION       (IS_IMMORTAL(ch) ? 16 : 4)      /* for old ver */



void show_room_to_char( CHAR_DATA *ch, ROOM_INDEX_DATA *pRoom, 
                        int dist, int dir )
{
    CHAR_DATA *rch;
    char buf[MAX_STRING_LENGTH];
    char *p;
    int count;

    /*
     * Count the number of people.
     */
    count = 0;
    for ( rch = pRoom->people; rch != NULL;  rch = rch->next_in_room )
    {
       if ( rch != ch && can_see( ch, rch ) )
       {
           count++;
           if ( IS_NPC(ch) && IS_SET(ch->act, ACT_NOSCAN) )  count--;
       }
    }
    
    if ( room_is_dark( pRoom )
      || !check_blind( ch )
      || count <= 0 )
    return;
    
    switch ( dist )
    {
       case 1: sprintf( buf, "Nearby to the %s you can see", dir_name[dir] ); break;
       case 2: sprintf( buf, "%s of here, you see", capitalize(dir_name[dir]) ); break;
       case 3: sprintf( buf, "In the distance to the %s is", dir_name[dir] ); break;
       case 4: sprintf( buf, "Far away %s from you is",      dir_name[dir] ); break;
      default: break;
    }       
    
    for( rch = pRoom->people;  rch != NULL;  rch = rch->next_in_room )
    {        
        if ( !can_see( ch, rch )
          || (IS_NPC(ch) && IS_SET(ch->act, ACT_NOSCAN))
          || ch == rch )
        continue;
        
        if ( --count < 0 ) break;

        strcat( buf, " " );
        strcat( buf, STR(rch,short_descr) );

        if ( count > 1 )
        strcat( buf, "," );
        
        if ( count == 1 )
        strcat( buf, " and" );        
        
        if ( count == 0 )
        strcat( buf, ".\n\r" );
    }
        
    p = format_string( str_dup(buf) );    
    page_to_char( buf, ch );
    free_string( p );
    return;
}        



/*
 * Brand new version.
 */
void scan_direction( CHAR_DATA *ch, int dir )
{ 
    ROOM_INDEX_DATA *pRoom;
    EXIT_DATA *pExit;
    char buf[MAX_STRING_LENGTH];
    int dist;
    
    if ( (pExit = ch->in_room->exit[dir]) == NULL
      || IS_SET(pExit->exit_info, EX_CLOSED) )
    return;    

    for( dist = 1; dist < 5; dist++ )
    {
        if ( (pRoom = pExit->to_room) == NULL )
        break;
        
        show_room_to_char( ch, pRoom, dist, dir );

        if ( (pExit = pRoom->exit[dir]) == NULL )
        break;

        if ( IS_SET(pExit->exit_info, EX_CLOSED)
          || IS_SET(pExit->exit_info, EX_CONCEALED) )
        {
            if ( !IS_SET(pExit->exit_info, EX_CONCEALED) )
            {
                sprintf( buf, "A closed %s%s blocks your view.\n\r",
                         pExit->keyword,
                         dist == 1 ? " nearby"          :
                         dist == 2 ? " close by"        :
                         dist == 3 ? " in the distance" : "" );
                page_to_char( buf, ch );
            }

            break;
        }
        else
        if ( IS_SET(pExit->exit_info, EX_ISDOOR)
          && !IS_SET(pExit->exit_info, EX_CONCEALED) )
        {
            sprintf( buf, "You can see an opened %s%s.\n\r",
                     pExit->keyword,
                     dist == 1 ? " nearby"          :
                     dist == 2 ? " close by"        :
                     dist == 3 ? " in the distance" : "" );
            page_to_char( buf, ch );
        }
        else
        if ( !IS_SET(pExit->exit_info, EX_ISDOOR)
          && !IS_SET(pExit->exit_info, EX_CONCEALED)
          && !MTD(pExit->keyword) )
        {
            sprintf( buf, "You are able to peer through a%s %s.\n\r",
                     IS_VOWEL(pExit->keyword[0]) ? "n" : "",
                     pExit->keyword );
            page_to_char( buf, ch );
        }
    }
    
    return;
}




char *format_obj_to_char( OBJ_DATA *obj, CHAR_DATA *ch, bool fShort )
{
    static char buf[MAX_STRING_LENGTH];
    char pre[MAX_STRING_LENGTH];

    buf[0] = '\0';

    if ( fShort )
    {
        pre[0] = '\0';
        if ( IS_OBJ_STAT(obj, ITEM_INVIS)     ) strcat( pre, "invisible "  );
        if ( IS_AFFECTED(ch, AFF_DETECT_MAGIC)
          && IS_OBJ_STAT(obj, ITEM_MAGIC)     ) strcat( pre, "shimmering " );
        if ( IS_OBJ_STAT(obj, ITEM_GLOW)      ) strcat( pre, "glowing "    );
        if ( IS_OBJ_STAT(obj, ITEM_HUM)       ) strcat( pre, "humming "    );

        if ( TOO_BIG(ch,obj)   && (obj->carried_by == ch
          || IS_SET(obj->extra_flags, ITEM_INVENTORY)) ) strcat(pre, "loose " );
        else
        if ( TOO_SMALL(ch,obj) && (obj->carried_by == ch
          || IS_SET(obj->extra_flags, ITEM_INVENTORY)) ) strcat(pre, "tight " );

        switch ( obj->item_type )
        {
            default: break;
    case ITEM_LIGHT:
         if( obj->value[1] )
         {
            int percent = PERCENTAGE( obj->value[0], obj->value[1] );
            if ( obj->value[1] < obj->value[0] ) percent = 100;

            if ( !obj->value[0] && VAL_SET(obj,3,LIGHT_FILLABLE) )
            strcat( pre, "empty " );
            else
            strcat( pre,
             !IS_LIT(obj)  ? "unlit "    :
             percent <  10 ? "very dim " :
             percent <  20 ? "dim "      :
                             "lit " );
         }
        break;
    case ITEM_DRINK_CON: if ( !obj->value[0] ) strcat( pre, "empty " ); break;
    case ITEM_ARMOR:
         if( obj->value[0] )
         {
            int percent;

            percent = PERCENTAGE( obj->value[0], obj->pIndexData->value[0] );
            strcat( pre,
             percent <  10 ? "destroyed "     :
             percent <  20 ? "poor "          :
             percent <  30 ? "badly damaged " :
             percent <  40 ? "damaged "       :
             percent <  50 ? "worn "          :
             percent <  80 ? "somewhat used " :
                             "new " );
         }
        break;
    case ITEM_GEM:
         if( obj->value[1] )
         {
            int percent;
            percent = PERCENTAGE( obj->value[1], obj->value[2] );

            strcat( pre,
             percent <  10 ? "darkened " :
             percent <  20 ? "pulsing "  :
                             "" );
         }
        break;
        }

        if ( pre[0] != '\0' )
        {
            sprintf( buf, "%s %s%s", IS_VOWEL(pre[0]) ? "an" : "a", pre,
                     smash_article( STR(obj, short_descr) ) );
        }
        else
        strcat( buf, STR(obj,short_descr) );

        if ( obj->item_type == ITEM_DRINK_CON
          && IS_SET(obj->extra_flags, ITEM_INVENTORY)
          && obj->value[0] != 0 )
        {
            if ( obj->value[2] < 0 || obj->value[2] >= LIQ_MAX )
            {
                obj->value[2] = 0;
                bug( "Invalid liquid on object %d.", obj->pIndexData->vnum );
            }

            strcat( buf, " of " );
            strcat( buf, liq_table[obj->value[2]].liq_name );
        }
    }
    else
    {
        CHAR_DATA *puller;

        if ( IS_OBJ_STAT(obj, ITEM_INVIS)     )   strcat( buf, "(Invisible) ");
        if ( IS_AFFECTED(ch, AFF_DETECT_EVIL)
          && IS_OBJ_STAT(obj, ITEM_EVIL)   )   strcat( buf, "(Red Aura) "    );
        if ( IS_AFFECTED(ch, AFF_DETECT_MAGIC)
          && IS_OBJ_STAT(obj, ITEM_MAGIC)  )   strcat( buf, "(Yellow Glow) " );
        if ( IS_OBJ_STAT(obj, ITEM_GLOW)      )   strcat( buf, "(Glowing) "  );
        if ( IS_OBJ_STAT(obj, ITEM_HUM)       )   strcat( buf, "(Humming) "  );

        if ( (puller = hitched( obj )) == NULL )
        {
            if ( ch->furniture == obj )
            {
                strcat( buf, capitalize(STR(obj,short_descr)) );
                strcat( buf, " upon which you are " );
                strcat( buf, position_name( ch->position ) );
                strcat( buf, " is here.\n\r" );
            }
            else
            strcat( buf, STR(obj, description) );
        }
        else
        {
            strcat( buf, capitalize(STR(obj, short_descr)) );
            strcat( buf, " is hitched to " );
            strcat( buf, PERS(puller, ch) );
            strcat( buf, ".\n\r" );
        }       
        
        if ( obj->item_type == ITEM_FURNITURE 
          && obj->contains != NULL )
        {
            char xbuf[MAX_STRING_LENGTH];

            if ( obj->contains->next_content != NULL
              && can_see_obj(ch, obj->contains)
              && can_see_obj(ch, obj->contains->next_content) )
             sprintf( xbuf, "   A few items are on %s.\n\r",
                     STR(obj,short_descr) );
            else
            if ( can_see_obj(ch, obj->contains) )
             sprintf( xbuf, "   %s is on %s.\n\r",
                     capitalize(STR(obj->contains,short_descr)),
                     STR(obj,short_descr) );

            strcat( buf, xbuf );
        }
    }

    return buf;
}




/*
 * Show a list to a character.
 * Can coalesce duplicated items.
 */
void show_list_to_char( OBJ_DATA *list, CHAR_DATA *ch, bool fShort, bool fShowNothing )
{
    char buf[MAX_STRING_LENGTH];
    char **prgpstrShow;
    int *prgnShow;
    char *pstrShow;
    OBJ_DATA **lastobj;
    OBJ_DATA *obj;
    int nShow;
    int iShow;
    int count;
    bool fCombine;

    if ( ch->desc == NULL )
        return;
    
    /*
     * Alloc space for output lines.
     */
    count = 0;
    for ( obj = list; obj != NULL; obj = obj->next_content ) count++;
    prgpstrShow	= alloc_mem( count * sizeof(char *) );
    prgnShow    = alloc_mem( count * sizeof(int)    );
    lastobj     = alloc_mem( count * sizeof(OBJ_DATA *) );
    nShow       = 0;

    /*
     * Format the list of objects.
     */
    for ( obj = list; obj != NULL; obj = obj->next_content )
    {
        if ( obj->wear_loc == WEAR_NONE
          && can_see_obj( ch, obj )
          && hitched(obj) == NULL )
        {
	    if ( obj->item_type == ITEM_FURNITURE
	    &&   obj->value[0]/100 > 0
            &&  (OCCUPADO(obj) || ch->furniture == obj) )
		continue;
            pstrShow = str_dup( format_obj_to_char( obj, ch, fShort ) );
            fCombine = FALSE;

            if ( IS_NPC(ch) || IS_SET(ch->act2, PLR_COMBINE) )
            {
                /*
                 * Look for duplicates, case sensitive.
                 * Matches tend to be near end so run loop backwards.
                 */
                for ( iShow = nShow - 1; iShow >= 0 && iShow < count; iShow-- )
                {
                    if ( !strcmp( prgpstrShow[iShow], pstrShow )
                      && obj->item_type != ITEM_MONEY )
                    {
                    ++prgnShow[iShow];
                    lastobj[iShow] = obj;
                    fCombine = TRUE;
                    break;
                    }
                }
            }

            /*
             * Couldn't combine, or didn't want to.
             */
            if ( !fCombine )
            {
                 prgpstrShow [nShow] = str_dup( pstrShow );
                 prgnShow    [nShow] = 1;
                 lastobj     [nShow] = obj;
                 nShow++;
            }

            free_string( pstrShow );
        }
    }

    /*
     * Output the formatted list.
     */
    for ( iShow = 0; iShow < nShow; iShow++ )
    {
        if ( fShort )
        send_to_char( " ", ch );

        if ( IS_NPC(ch) || IS_SET(ch->act2, PLR_COMBINE) )
        {
            if ( prgnShow[iShow] > 1 )
            {
                if (fShort) sprintf( buf, "%s ", numberize(prgnShow[iShow]) );
                else
                {
                    char *pt;

                    pt = STR(lastobj[iShow], description_plural);
                    if ( MTD(pt) )
                    {
                         sprintf( buf, "%s %s are here.\n\r",
                                       numberize(prgnShow[iShow]),
                                       pluralize(STR(lastobj[iShow],short_descr))  );
                         buf[0] = UPPER(buf[0]);
                    }
                    else buf[0] = '\0';
                }
                send_to_char( buf, ch );
            }
        }

        if (fShort)
        {
            send_to_char( prgnShow[iShow] > 1 ? pluralize( STR(lastobj[iShow],short_descr) ) :
                                                prgpstrShow[iShow],
                          ch );
            send_to_char( "\n\r", ch );
        }
        else
        {
            if ( buf[0] == '\0' && prgnShow[iShow] > 1 )
            {
                sprintf( buf, STR(lastobj[iShow], description_plural),
                              numberize(prgnShow[iShow]) );
                send_to_char( capitalize(buf), ch );
            }
            else
            if ( prgnShow[iShow] <= 1 )
            send_to_char( capitalize(prgpstrShow[iShow]), ch );
        }

        free_string( prgpstrShow[iShow] );
        lastobj[iShow] = NULL;
    }

    if ( fShowNothing && nShow == 0 )
    {
        if ( IS_NPC(ch) || IS_SET(ch->act2, PLR_COMBINE) )
            send_to_char( "     ", ch );
        send_to_char( "Nothing.\n\r", ch );
    }

    /*
     * Clean up.
     */
    free_mem( prgpstrShow, count * sizeof(char *)      );
    free_mem( prgnShow,    count * sizeof(int)         );
    free_mem( lastobj,     count * sizeof(OBJ_DATA *)  );

    return;
}



/*
 * Show a list to a character.
 * Can coalesce duplicated items.
 */
char *show_list_to_char2( OBJ_DATA *list, CHAR_DATA *ch, char *prefix )
{
    static char final[MAX_STRING_LENGTH*4];
    char **prgpstrShow;
    int *prgnShow;
    char *pstrShow;
    OBJ_DATA **lastobj;
    OBJ_DATA *obj;
    int nShow;
    int iShow;
    int count;
    bool fCombine;

    if ( ch->desc == NULL )
        return "";
    
    /*
     * Alloc space for output lines.
     */
    count = 0;
    for ( obj = list; obj != NULL; obj = obj->next_content ) count++;
    prgpstrShow = alloc_mem( count * sizeof(char *) );
    prgnShow    = alloc_mem( count * sizeof(int)    );
    lastobj     = alloc_mem( count * sizeof(OBJ_DATA *) );
    nShow       = 0;

    /*
     * Format the list of objects.
     */
    for ( obj = list; obj != NULL; obj = obj->next_content )
    {
        if ( obj->wear_loc == WEAR_NONE
          && can_see_obj( ch, obj )
          && hitched(obj) == NULL )
        {
	    if ( obj->item_type == ITEM_FURNITURE
	    &&   obj->value[0]/100 > 0
            &&  (OCCUPADO(obj) || ch->furniture == obj) )
		continue;
            pstrShow = str_dup( format_obj_to_char( obj, ch, TRUE ) );
            fCombine = FALSE;

            if ( IS_NPC(ch) || IS_SET(ch->act2, PLR_COMBINE) )
            {
                /*
                 * Look for duplicates, case sensitive.
                 * Matches tend to be near end so run loop backwards.
                 */
                for ( iShow = nShow - 1; iShow >= 0 && iShow < count; iShow-- )
                {
                    if ( !strcmp( prgpstrShow[iShow], pstrShow )
                      && obj->item_type != ITEM_MONEY )
                    {
                    ++prgnShow[iShow];
                    lastobj[iShow] = obj;
                    fCombine = TRUE;
                    break;
                    }
                }
            }

            /*
             * Couldn't combine, or didn't want to.
             */
            if ( !fCombine )
            {
                 prgpstrShow [nShow] = str_dup( pstrShow );
                 prgnShow    [nShow] = 1;
                 lastobj     [nShow] = obj;
                 nShow++;
            }

            free_string( pstrShow );
        }
    }

    /*
     * Output the formatted list.
     */

    sprintf( final, nShow == 1 ? prefix
                              : replace_string( prefix, " is ", " are " ) );
    
    for ( iShow = 0; iShow < nShow; iShow++ )
    {
        if ( iShow == nShow-1 && nShow != 1 )
        strcat( final, "and " );

        if ( prgnShow[iShow] > 1 )
        {
            strcat( final, numberize(prgnShow[iShow]) );
            strcat( final, " " );
            strcat( final, pluralize( STR(lastobj[iShow],short_descr) ) );
        }
        else
        strcat( final, prgpstrShow[iShow] );

        if ( iShow != nShow-1 )
        strcat( final, ", " );


        free_string( prgpstrShow[iShow] );
        lastobj[iShow] = NULL;
    }

    if ( nShow == 0 ) strcat( final, "nothing" );
    
    strcat( final, ". " );

    {
        char *p;
        p = format_string( str_dup( final ) );
        sprintf( final, "%s", p );
        free_string( p );
    }

    /*
     * Clean up.
     */
    free_mem( prgpstrShow, count * sizeof(char *)      );
    free_mem( prgnShow,    count * sizeof(int)         );
    free_mem( lastobj,     count * sizeof(OBJ_DATA *)  );
    
    return final;
}



void show_peek_to_char( OBJ_DATA *list, CHAR_DATA *ch, bool fShort,
                        bool fShowNothing, int percent )
{
    char buf[MAX_STRING_LENGTH];
    char **prgpstrShow;
    int *prgnShow;
    char *pstrShow;
    OBJ_DATA **lastobj;
    OBJ_DATA *obj;
    int nShow;
    int iShow;
    int count;
    bool fCombine;

    if ( ch->desc == NULL )
	return;
    
    /*
     * Alloc space for output lines.
     */
    count = 0;
    for ( obj = list; obj != NULL; obj = obj->next_content )
	count++;
    prgpstrShow	= alloc_mem( count * sizeof(char *) );
    prgnShow    = alloc_mem( count * sizeof(int)    );
    lastobj     = alloc_mem( count * sizeof(OBJ_DATA *) );
    nShow	= 0;

    /*
     * Format the list of objects.
     */
    for ( obj = list; obj != NULL; obj = obj->next_content )
    {
        bool fHitched = (hitched(obj) != NULL ? TRUE : FALSE);

    if ( obj->wear_loc == WEAR_NONE
      && can_see_obj( ch, obj )
      && percent > number_percent( )
      && occupant(obj)
      && !fHitched )
	{
        pstrShow = percent > number_percent( ) ?
                   format_obj_to_char( obj, ch, fShort ) : "something";
	    fCombine = FALSE;

        if ( IS_NPC(ch) || IS_SET(ch->act2, PLR_COMBINE) )
        {
		/*
		 * Look for duplicates, case sensitive.
         * Matches tend to be near end so run loop backwards.
		 */
		for ( iShow = nShow - 1; iShow >= 0; iShow-- )
		{
            if ( ( !strcmp( prgpstrShow[iShow], pstrShow )
                 || lastobj[iShow] == obj )
               && obj->item_type != ITEM_MONEY )
		    {
            ++prgnShow[iShow];
            lastobj[iShow] = obj;
			fCombine = TRUE;
			break;
		    }
		}
	    }

	    /*
	     * Couldn't combine, or didn't want to.
	     */
	    if ( !fCombine )
	    {
		prgpstrShow [nShow] = str_dup( pstrShow );
		prgnShow    [nShow] = 1;
        lastobj     [nShow] = obj;
		nShow++;
	    }
	}
    }

    /*
     * Output the formatted list.
     */
    for ( iShow = 0; iShow < nShow; iShow++ )
    {
    if ( IS_NPC(ch) || IS_SET(ch->act2, PLR_COMBINE) )
	{
        if ( prgnShow[iShow] > 1 )
	    {
        if (fShort) sprintf( buf, "%s ", numberize( prgnShow[iShow] ) );
        else
        {
            char *pt;
            pt = STR(lastobj[iShow], description_plural);

            if ( pt == NULL || pt[0] == '\0' )
            {
                sprintf( buf, "%s %s are here.\n\r", 
                numberize( prgnShow[iShow] ), pluralize( STR(lastobj[iShow],short_descr) ) );
                buf[0] = UPPER(buf[0]);
            }
            else
            {
                buf[0] = '\0';
            }
        }
        send_to_char( buf, ch );
	    }
	}

    if (fShort)
    {
      send_to_char( prgnShow[iShow] > 1 ? pluralize( STR(lastobj[iShow],short_descr) ) :
                    prgpstrShow[iShow], ch );
      send_to_char( "\n\r", ch );
    }
    else
    {
        if ( buf[0] == '\0' && prgnShow[iShow] > 1 )
        {
            sprintf( buf, STR(lastobj[iShow], description_plural), numberize( prgnShow[iShow] ) );
            send_to_char( capitalize(buf), ch );
        }
        else
        if ( prgnShow[iShow] <= 1 )
        send_to_char( capitalize(prgpstrShow[iShow]), ch );
    }
        free_string( prgpstrShow[iShow] );
        lastobj[iShow] = NULL;
    }

    if ( fShowNothing && nShow == 0 )
    {
    if ( IS_NPC(ch) || IS_SET(ch->act2, PLR_COMBINE) )
        send_to_char( "     ", ch );
    send_to_char( "Nothing.\n\r", ch );
    }

    /*
     * Clean up.
     */
    free_mem( prgpstrShow, count * sizeof(char *)      );
    free_mem( prgnShow,    count * sizeof(int)         );
    free_mem( lastobj,     count * sizeof(OBJ_DATA *)  );

    return;
}



/*
 *  Shows a mob/player to character (look in room)
 */
void show_char_to_char_0( CHAR_DATA *victim, CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    char *p;

    buf[0] = '\0';
    if ( victim == NULL || ch == NULL ) return;

    if ( victim->rider != NULL )
        return;

    if ( victim->riding == ch )
        return;

/*    send_to_char( "MOB/PLR ", ch );       */

    if ( IS_AFFECTED(victim, AFF_INVISIBLE)   ) strcat( buf, "(Invisible) "   );
    if ( IS_AFFECTED(victim, AFF_HIDE)        ) strcat( buf, "(Hiding) "      );
    if ( IS_AFFECTED(victim, AFF_CHARM)       ) strcat( buf, "(Charmed) "     );
    if ( IS_AFFECTED(victim, AFF_PASS_DOOR)   ) strcat( buf, "(Translucent) " );
    if ( IS_AFFECTED(victim, AFF_FAERIE_FIRE) ) strcat( buf, "(Pink Aura) "   );
    if ( IS_AFFECTED(victim, AFF_SANCTUARY)   ) strcat( buf, "(White Aura) "  );
    if ( !IS_NPC(victim)
      && IS_AFFECTED(victim, AFF_FLYING)      ) strcat( buf, "(Floating) "    );
    if ( !IS_NPC(victim)
      && victim->desc == NULL                 ) strcat( buf, "(Linkless) "    );

    if ( victim->position == POS_STANDING
      && victim->riding   == NULL
      && victim->furniture == NULL
      && STR(victim, long_descr)[0] != '\0' )
    {
    strcat( buf, STR(victim, long_descr) );

    p = format_string( str_dup( capitalize(buf) ) );
    send_to_char( p, ch );
    free_string( p );

	return;
    }

    strcat( buf, capitalize( PERS( victim, ch ) ) );

    switch ( victim->position )
    {
    case POS_DEAD:     strcat( buf, " is dead" );               break;
    case POS_MORTAL:   strcat( buf, " is mortally wounded" );   break;
    case POS_INCAP:    strcat( buf, " is incapacitated" );      break;
    case POS_STUNNED:  strcat( buf, " is lying here stunned" ); break;
    case POS_SLEEPING: strcat( buf, " is sleeping" );           break;
    case POS_SITTING:  strcat( buf, " is sitting" );            break;
    case POS_RESTING:  strcat( buf, " is resting" );            break;
    case POS_STANDING:
     if ( victim->rider == ch ) strcat( buf, " that you are riding" );
     strcat( buf, " is here" );
     break;
    case POS_FIGHTING:
      strcat( buf, " is here, fighting " );
      if ( victim->fighting == NULL )
          strcat( buf, "thin air" );
      else if ( victim->fighting == ch )
          strcat( buf, "YOU" );
      else if ( victim->in_room == victim->fighting->in_room )
      {
          strcat( buf, PERS( victim->fighting, ch ) );
      }
      else
          strcat( buf, "someone who left" );
     break;
    }

    if ( victim->riding != NULL && victim->riding->in_room == victim->in_room )
    {
        sprintf( buf2, ", mounted on %s.\n\r",
                          PERS(victim->riding, ch) );
        strcat( buf, buf2 );
    }
    else
    {
    if ( victim->furniture != NULL )
    {
        sprintf( buf2, " on %s.\n\r", can_see_obj( ch, victim->furniture ) ?
                                      STR(victim->furniture, short_descr)  :
                                      "something" );
        strcat( buf, buf2 );
    }
    else
    strcat( buf, ".\n\r" );
    }

    p = format_string( str_dup(capitalize(buf)) );
    send_to_char( p, ch );
    free_string( p );

    if ( victim->hitched_to != NULL && can_see_obj( ch, victim->hitched_to ) )
    {
        sprintf( buf, "  %s has been hitched to %s.\n\r", NAME(victim),
                 STR(victim->hitched_to,short_descr) );
        send_to_char( buf, ch );
    }
    return;
}



/*
 * Shows the generated object description to a character.
 * (Once again I must say, Thanks to Kalgen for this AWESOME idea)
 * Thanks to Morgenes for the bug fixes/improvements.
 *                                    - Locke
 * Locations not displayed:
 * on belt (sheathed)
 * stockings (if wearing pants/leggings)
 * nose (if wearing something on face)
 * ankles (if wearing stockings)
 * shirt (if body wear)
 * loins (if wearing pants/leggings)
 */
void show_equipment( CHAR_DATA *ch, CHAR_DATA *tch )
{
   OBJ_DATA *obj;
   OBJ_DATA *obj2;
   char buf[MAX_STRING_LENGTH];
   char descr[MAX_STRING_LENGTH];
   char *finalstr;
   bool fBool;
   int oType;
   char *p1;
   char *p2;

   buf[0] = '\0';
   descr[0] = '\0';

   fBool = FALSE;

   p1 = NULL;
   p2 = NULL;

   if( ( ( obj = get_eq_char( ch, WEAR_FINGER_L ) ) != NULL
    && can_see_obj( tch, obj ) )
    && ( ( obj2 = get_eq_char( ch, WEAR_FINGER_R ) ) != NULL
    && can_see_obj( tch, obj2 ) )
    && !strcmp( (p1 = str_dup(format_obj_to_char(obj,  ch, TRUE))),
                (p2 = str_dup(format_obj_to_char(obj2, ch, TRUE))) ) )
   {
      sprintf( buf, "%s is wearing two %s on %s fingers",
                    HE_SHE( ch ),  pluralize( STR(obj,short_descr) ),   HIS_HER( ch ) );
      strcat( descr, buf );
   }
   else
   {
      if( ( obj = get_eq_char( ch, WEAR_FINGER_L ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "On %s left hand, %s has placed %s",
          HIS_HER( ch ), HE_SHE( ch ), PERSO(obj, ch) );
         strcat( descr, buf );
         fBool = TRUE;
      }
     
      if( ( obj = get_eq_char( ch, WEAR_FINGER_R ) ) != NULL
       && can_see_obj( tch, obj ) )
      { 
         if( fBool )
            sprintf( buf, ", while %s encircles a finger on %s right",
             PERSO(obj, ch), HIS_HER( ch ) );
         else
            sprintf( buf, "On %s right hand %s %s",
             HIS_HER( ch ), is_are( PERSO(obj, ch) ), PERSO(obj, ch) );
         strcat( descr, buf );
      }
   }

   free_string( p1 );
   free_string( p2 );
   p1 = NULL;
   p2 = NULL;

   if( ( obj = get_eq_char( ch, WEAR_HANDS ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      if( descr[0] != '\0' )
         sprintf( buf, ", with %s covering %s hands.",
          format_obj_to_char(obj, ch, TRUE), HIS_HER(ch) );
      else
         sprintf( buf, "%s %s worn on %s hands.",
          format_obj_to_char(obj, ch, TRUE), is_are( format_obj_to_char(obj, ch, TRUE) ), HIS_HER( ch ) );
      strcat( descr, buf );
   }
   else if( descr[0] != '\0' )
      strcat( descr, ".  " );

   fBool = FALSE;

   if( ( obj = get_eq_char( ch, WEAR_HEAD ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s is wearing %s on %s head.  ",
       HE_SHE( ch ), format_obj_to_char(obj, ch, TRUE), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( obj = get_eq_char( ch, WEAR_FOREHEAD ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "Around %s forehead, %s has wrapped %s.",
       HIS_HER(ch), HE_SHE(ch), PERSO(obj, ch) );
      strcat( descr, buf );
   }

   if( ( ( obj = get_eq_char( ch, WEAR_NECK_1 ) ) != NULL
    && can_see_obj( tch, obj ) )
    && ( ( obj2 = get_eq_char( ch, WEAR_NECK_2 ) ) != NULL
    && can_see_obj( tch, obj2 ) )
    && !str_cmp( (p1 = str_dup(format_obj_to_char(obj,  ch, TRUE))),
                 (p2 = str_dup(format_obj_to_char(obj2, ch, TRUE))) ) )
   {
      sprintf( buf, "Two %s are clasped around %s neck.  ",
       pluralize( STR(obj, short_descr) ), HIS_HER( ch ) );
      strcat( descr, buf );
   }
   else
   {
      if( ( obj = get_eq_char( ch, WEAR_NECK_1 ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( get_eq_char( ch, WEAR_NECK_2 ) == NULL )
            sprintf( buf, "%s %s worn about %s neck.  ",
             PERSO(obj,ch), is_are( PERSO(obj,ch) ),
             HIS_HER( ch ) );
         else
            sprintf( buf, "%s and ", PERSO(obj,ch) );
         strcat( descr, buf );
         fBool = TRUE;
      }
   
      if( ( obj = get_eq_char( ch, WEAR_NECK_2 ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( fBool )
            sprintf( buf, "%s are worn about %s neck.  ",
             PERSO(obj,ch), HIS_HER( ch ) );
         else
            sprintf( buf, "%s %s worn about %s neck.  ",
             PERSO(obj,ch), is_are( PERSO(obj,ch) ), HIS_HER( ch ) );
         strcat( descr, buf );
      }
   }

   free_string( p1 );
   free_string( p2 );
   p1 = NULL;
   p2 = NULL;

   fBool = FALSE;

   if( ( ( obj = get_eq_char( ch, WEAR_EAR_L ) ) != NULL
    && can_see_obj( tch, obj ) )
    && ( ( obj2 = get_eq_char( ch, WEAR_EAR_R ) ) != NULL
    && can_see_obj( tch, obj2 ) )
    && !str_cmp( (p1 = str_dup(format_obj_to_char(obj,  ch, TRUE))),
                 (p2 = str_dup(format_obj_to_char(obj2, ch, TRUE))) ) )
   {
      sprintf( buf, "%s has a pair of %s on %s ears.",
       HE_SHE( ch ), pluralize( STR(obj, short_descr) ), HIS_HER( ch ) );
      strcat( descr, buf );
   } 
   else
   {
      if( ( obj = get_eq_char( ch, WEAR_EAR_L ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "%s pierces %s left ear",
          PERSO(obj,ch), HIS_HER( ch ) );
         strcat( descr, buf );
         fBool = TRUE;
      }
      if( ( obj = get_eq_char( ch, WEAR_EAR_R ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( fBool )
            sprintf( buf, " and %s %s worn on %s right",
             PERSO(obj,ch), is_are( PERSO(obj,ch) ), HIS_HER( ch ) );
         else
            sprintf( buf, "%s right ear is pierced with %s",
             HIS_HER( ch ), PERSO(obj,ch) );
         strcat( descr, buf );
      }
      if( fBool || get_eq_char( ch, WEAR_EAR_R ) )
         strcat( descr, ".  " );
   }

   free_string( p1 );
   free_string( p2 );
   p1 = NULL;
   p2 = NULL;

   if( ( obj = get_eq_char( ch, WEAR_NOSE ) ) != NULL
    && can_see_obj( tch, obj )
    && get_eq_char( ch, WEAR_FACE ) == NULL )
   {
      sprintf( buf, "%s %s piercing %s nose.",
       format_obj_to_char(obj, ch, TRUE), is_are( format_obj_to_char(obj, ch, TRUE) ), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( obj = get_eq_char( ch, WEAR_FACE ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s covers %s face.", format_obj_to_char(obj, ch, TRUE), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   fBool = FALSE;
   
   if( ( obj = get_eq_char( ch, WEAR_ABOUT ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s %s draped over %s ",
       format_obj_to_char(obj, ch, TRUE), is_are( format_obj_to_char(obj, ch, TRUE) ), HIS_HER( ch ) );
      strcat( descr, buf );
      if( ( obj = get_eq_char( ch, WEAR_BODY ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "%s.  ",
          smash_article( format_obj_to_char(obj, ch, TRUE) ) );
      }
      else
      if( ( obj = get_eq_char( ch, WEAR_SHIRT ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "%s.  ",
          smash_article( format_obj_to_char(obj, ch, TRUE) ) );
      }
      else
         sprintf( buf, "naked chest.  " );
      strcat( descr, buf );
   }
   else if( ( obj = get_eq_char( ch, WEAR_BODY ) ) != NULL 
    && (get_eq_char( tch, WEAR_SHIRT ) == NULL 
     || get_eq_char( tch, WEAR_PANTS ) == NULL)
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s %s being worn on %s body.",
       format_obj_to_char(obj, ch, TRUE), is_are( format_obj_to_char(obj, ch, TRUE) ), HIS_HER( ch ) );
      strcat( descr, buf );
   }
   
   if( ( obj = get_eq_char( ch, WEAR_SHIRT ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s fits over %s torso.",
       format_obj_to_char(obj, ch, TRUE), HIS_HER( ch ) );
      strcat( descr, buf );
   }
  
   if( ( obj = get_eq_char( ch, WEAR_ARMS ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s %s protecting %s arms.  ",
       format_obj_to_char(obj, ch, TRUE), is_are( format_obj_to_char(obj, ch, TRUE) ), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( obj = get_eq_char( ch, WEAR_PANTS ) ) != NULL
    && can_see_obj( tch, obj )
    && get_eq_char( ch, WEAR_LEGS ) == NULL )
   {
      sprintf( buf, "%s is wearing %s on %s legs.  ",
       HE_SHE( ch ), format_obj_to_char(obj, ch, TRUE), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( obj2 = get_eq_char( ch, WEAR_LEGS ) ) != NULL
    && can_see_obj( tch, obj2 ) )
   {
      if ( obj == NULL )
      sprintf( buf, "%s is wearing %s on %s legs.  ",
       HE_SHE( ch ), format_obj_to_char(obj2, ch, TRUE), HIS_HER( ch ) );
      else
      sprintf( buf, "%s %s worn over %s on %s legs.  ",
       format_obj_to_char(obj2, ch, TRUE), is_are( format_obj_to_char(obj2, ch, TRUE) ),
       format_obj_to_char(obj, ch, TRUE), HIS_HER( ch ) );

      strcat( descr, buf );
   }

   if( ( obj = get_eq_char( ch, WEAR_STOCKING ) ) != NULL
    && can_see_obj( tch, obj )
    && get_eq_char( ch, WEAR_PANTS ) == NULL )
   {
      sprintf( buf, "%s has pulled %s onto %s legs.  ",
       HE_SHE( ch ), format_obj_to_char(obj, ch, TRUE), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( obj = get_eq_char( ch, WEAR_FEET ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s wears %s as footwear.  ",
       HE_SHE( ch ), format_obj_to_char(obj, ch, TRUE) );
      strcat( descr, buf );
   }

   if( descr[0] != '\0' )
   {
      send_to_char( "\n\r", tch );
      send_to_char( "   ", tch );

      finalstr = format_string( str_dup( descr ) );
      send_to_char( finalstr, tch );
      free_string( finalstr );

      descr[0] = '\0';
   }

   if( ( ( obj = get_eq_char( ch, WEAR_WRIST_L ) ) != NULL
    && can_see_obj( tch, obj ) )
    && ( ( obj2 = get_eq_char( ch, WEAR_WRIST_R ) ) != NULL
    && can_see_obj( tch, obj2 ) )
    && !str_cmp( (p1 = str_dup(format_obj_to_char(obj,  ch, TRUE))),
                 (p2 = str_dup(format_obj_to_char(obj2, ch, TRUE))) ) )
   {
      sprintf( buf, "Two %s are on each wrist.  ", pluralize( STR(obj, short_descr) ) );
      strcat( descr, buf );
   }
   else
   {
      if( ( obj = get_eq_char( ch, WEAR_WRIST_L ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "Encircling %s left wrist, %s %s",
          HIS_HER( ch ), is_are( format_obj_to_char(obj, ch, TRUE) ), format_obj_to_char(obj, ch, TRUE) );
         strcat( descr, buf );
         fBool = TRUE;
      }
    
      if( ( obj = get_eq_char( ch, WEAR_WRIST_R ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( fBool )
            sprintf( buf, " and %s on %s right.  ",
             format_obj_to_char(obj, ch, TRUE), HIS_HER( ch ) );
         else
            sprintf( buf,
             "Encircling %s right wrist %s %s.  ",
             HIS_HER( ch ), is_are( format_obj_to_char(obj, ch, TRUE) ), format_obj_to_char(obj, ch, TRUE) );
         strcat( descr, buf );
      }
      else if( fBool )
         strcat( descr, ".  " );
   }

   free_string( p1 );
   free_string( p2 );
   p1 = NULL;
   p2 = NULL;

   if ( get_eq_char( ch, WEAR_STOCKING ) == NULL )
   {

   fBool = FALSE;

   if( ( ( obj = get_eq_char( ch, WEAR_ANKLE_L ) ) != NULL
    && can_see_obj( tch, obj ) )
    && ( ( obj2 = get_eq_char( ch, WEAR_ANKLE_R ) ) != NULL
    && can_see_obj( tch, obj2 ) )
    && !str_cmp( (p1 = str_dup(format_obj_to_char(obj,  ch, TRUE))),
                 (p2 = str_dup(format_obj_to_char(obj2, ch, TRUE))) ) )
   {
      sprintf( buf, "%s has two %s fastened around %s ankles.",
       HE_SHE( ch ), pluralize( STR(obj, short_descr) ), HIS_HER( ch ) );
      strcat( descr, buf );
   } 
   else
   {
      if( ( obj = get_eq_char( ch, WEAR_ANKLE_L ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "%s %s fastened around %s left ankle",
          format_obj_to_char(obj, ch, TRUE), is_are( format_obj_to_char(obj, ch, TRUE) ), HIS_HER( ch ) );
         strcat( descr, buf );
         fBool = TRUE;
      }
      if( ( obj = get_eq_char( ch, WEAR_ANKLE_R ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( fBool )
            sprintf( buf, " and %s %s around %s right",
             format_obj_to_char(obj, ch, TRUE), is_are( format_obj_to_char(obj, ch, TRUE) ), HIS_HER( ch ) );
         else
            sprintf( buf, "Around %s right ankle %s %s",
            HIS_HER( ch ), is_are( format_obj_to_char(obj, ch, TRUE) ), format_obj_to_char(obj, ch, TRUE) );
         strcat( descr, buf );
      }
      if( fBool || get_eq_char( ch, WEAR_ANKLE_R ) )
         strcat( descr, ".  " );
   }

   }

   fBool = FALSE;

   if( ( ( obj = get_eq_char( ch, WEAR_SHOULDER_L ) ) != NULL
    && can_see_obj( tch, obj ) )
    && ( ( obj2 = get_eq_char( ch, WEAR_SHOULDER_R ) ) != NULL
    && can_see_obj( tch, obj2 ) )
    && !str_cmp( (p1 = str_dup(format_obj_to_char(obj,  ch, TRUE))),
                 (p2 = str_dup(format_obj_to_char(obj2, ch, TRUE))) ) )
   {
      sprintf( buf, "%s has two %s slung over %s shoulders.",
       HE_SHE( ch ), pluralize( STR(obj,short_descr) ), HIS_HER( ch ) );
      strcat( descr, buf );
   } 
   else
   {
      if( ( obj = get_eq_char( ch, WEAR_SHOULDER_L ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "%s %s slung over %s left shoulder",
          format_obj_to_char(obj, ch, TRUE), is_are( format_obj_to_char(obj, ch, TRUE) ), HIS_HER( ch ) );
         strcat( descr, buf );
         fBool = TRUE;
      }
      if( ( obj = get_eq_char( ch, WEAR_SHOULDER_R ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( fBool )
            sprintf( buf, " and %s %s slung over %s right",
             format_obj_to_char(obj, ch, TRUE), is_are( format_obj_to_char(obj, ch, TRUE) ), HIS_HER( ch ) );
         else
            sprintf( buf, "Over %s right shoulder %s %s",
            HIS_HER( ch ), is_are( format_obj_to_char(obj, ch, TRUE) ), format_obj_to_char(obj, ch, TRUE) );
         strcat( descr, buf );
      }
      if( fBool || get_eq_char( ch, WEAR_SHOULDER_R ) )
         strcat( descr, ".  " );
   }

   free_string( p1 );
   free_string( p2 );
   p1 = NULL;
   p2 = NULL;

   fBool = FALSE;

   obj  = get_eq_char( ch, WEAR_HOLD_1 );
   if ( !obj )  obj  = get_eq_char( ch, WEAR_WIELD_1 );

   obj2 = get_eq_char( ch, WEAR_HOLD_2 );
   if ( !obj2 ) obj2 = get_eq_char( ch, WEAR_WIELD_2 );

   if( obj != NULL     && can_see_obj( tch, obj )
    && obj2 != NULL    && can_see_obj( tch, obj2 )
    && (obj->wear_loc == obj2->wear_loc-1)
    && !str_cmp( (p1 = str_dup(format_obj_to_char(obj,  ch, TRUE))),
                 (p2 = str_dup(format_obj_to_char(obj2, ch, TRUE))) ) )
   {
      sprintf( buf, "Two %s are %s in %s hands.",
                       pluralize( STR(obj, short_descr) ),
                       obj->wear_loc == WEAR_WIELD_1 ? "wielded" : "held",
                       HIS_HER( ch ) );
      strcat( descr, buf );
   }
   else
   if ( obj != NULL 
        && can_see_obj( tch, obj ) 
        && obj->wear_loc == WEAR_WIELD_1
        && IS_SET(obj->wear_flags, ITEM_TWO_HANDED) )
   {
        sprintf( buf, "%s %s gripped in both %s hands.\n\r",
                      format_obj_to_char( obj, ch, TRUE ),
                      is_are( format_obj_to_char( obj, ch, TRUE ) ),
                      HIS_HER( ch ) );
        strcat( descr, buf );
   }
   else  
   {
      oType = ITEM_TRASH;
      if( obj != NULL && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "%s %s %s in one hand",
             format_obj_to_char(obj, ch, TRUE),
             is_are( format_obj_to_char(obj, ch, TRUE) ),
             obj->wear_loc == WEAR_WIELD_1 ? "being wielded" : "held" );
         strcat( descr, buf );
         fBool = TRUE;
      }

      if( obj2 != NULL && can_see_obj( tch, obj2 ) )
      {
         if( fBool )
         {
            if ( obj->wear_loc == (obj2->wear_loc-1) )
            sprintf( buf, ", with %s in the other.",
                     format_obj_to_char(obj2, ch, TRUE) );
            else
            sprintf( buf, ", and %s %s %s in the other.  ",
                format_obj_to_char(obj2, ch, TRUE),
                is_are( format_obj_to_char(obj2, ch, TRUE) ),
                obj2->wear_loc == WEAR_WIELD_2 ? "wielded" : "held" );
         }
         else
         {
            sprintf( buf, "%s %s being %s.  ",
                format_obj_to_char(obj2, ch, TRUE),
                is_are( format_obj_to_char(obj2, ch, TRUE) ),
                obj2->wear_loc == WEAR_WIELD_2 ? "wielded" : "held" );
         } 
         strcat( descr, buf );
      }
      else
      if( fBool ) strcat( descr, ".  " );
   }

   free_string( p1 );
   free_string( p2 );
   p1 = NULL;
   p2 = NULL;

   if( ( obj = get_eq_char( ch, WEAR_BACK ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s is strapped to %s back.  ",
        format_obj_to_char(obj, ch, TRUE), HIS_HER( ch ) );
      strcat( descr, buf );
   }
   
   fBool = FALSE;
   
   if( ( obj = get_eq_char( ch, WEAR_FLOATING ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s is floating near %s head.  ",
       format_obj_to_char(obj, ch, TRUE), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( obj = get_eq_char( ch, WEAR_WAIST ) ) != NULL
    && can_see_obj( tch, obj )
    && (get_eq_char( ch, WEAR_LOIN ) == NULL 
     && get_eq_char( ch, WEAR_PANTS ) == NULL) )
   {
      sprintf( buf, "%s fits snugly around %s waist.  ",
       format_obj_to_char(obj, ch, TRUE), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( obj = get_eq_char( ch, WEAR_SHOULDERS ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s is wearing %s.  ",
       format_obj_to_char(obj, ch, TRUE), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( obj2 = get_eq_char( ch, WEAR_LOIN ) ) != NULL
    && can_see_obj( tch, obj2 )
    && get_eq_char( ch, WEAR_PANTS ) == NULL )
   {
      sprintf( buf, "%s %s wrapped loosely below %s %s.  ",
       format_obj_to_char(obj2, ch, TRUE), is_are( format_obj_to_char(obj2, ch, TRUE) ),
       HIS_HER( ch ), obj ? smash_article(format_obj_to_char(obj, ch, TRUE)) : "waist" );
      strcat( descr, buf );
   }

   if( ( obj = get_eq_char( ch, WEAR_SHIELD ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s serves to protect %s from attacks.  ",
        format_obj_to_char(obj, ch, TRUE), HIM_HER( ch ) );
      strcat( descr, buf );
   }
   
   if( descr[0] != '\0' )
   {
      send_to_char( "\n\r", tch );
      send_to_char( "   ", tch );

      finalstr = format_string( str_dup( descr ) );
      send_to_char( finalstr, tch );
      free_string( finalstr );
   }

   return;
}



void show_equipment_table( CHAR_DATA *ch, CHAR_DATA *victim )
{
    OBJ_DATA *obj;
    char buf[MAX_STRING_LENGTH];
    int iWear;
    bool found = FALSE;

    if ( ch != victim )
       act( "$N is using:", ch, NULL, victim, TO_CHAR );
  else send_to_char( "You are using:\n\r", ch );

    for ( iWear = 0; iWear < MAX_WEAR; iWear++ )
    {

    if ( ( obj = get_eq_char( victim, iWear ) ) == NULL )
        continue;

    sprintf( buf, "%-24s %s\n\r", iWear == WEAR_WIELD_1
                               && IS_SET(obj->wear_flags, ITEM_TWO_HANDED)
                                 ? "<wielded both hands>" : where_name[iWear],
                                  can_see_obj( ch, obj ) ?
                                      format_obj_to_char(obj, ch, TRUE)
                                      : "something" );
    send_to_char( buf, ch );
	found = TRUE;
    }

    if ( !found )  send_to_char( "     Nothing.\n\r", ch );
    return;
}



/*
 * Shows the actually character (look at someone)
 */
void show_char_to_char_1( CHAR_DATA *victim, CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];
    char final[MAX_STRING_LENGTH];

    if ( can_see( victim, ch ) )
    {
         act( "$n looks at you.", ch, NULL, victim, TO_VICT    );
         if ( ch != victim )
         act( "$n looks at $N.",  ch, NULL, victim, TO_NOTVICT );
         else act( "$n looks $mself over.", ch, NULL, NULL, TO_NOTVICT );
    }

    if ( !MTD(STR(victim,description)) )
    send_to_char( STR(victim, description), ch );

    show_equipment( victim, ch );

    send_to_char( "\n\r",   ch );

    final[0] = '\0';

    sprintf( buf, "     %s looks %s.\n\r",
                        capitalize(PERS( victim, ch )),
                                  STRING_HITS(victim) );
    strcat( final, buf );

    switch ( victim->position )
    {
        case POS_DEAD:
          sprintf( buf, "%s is dead. ", capitalize(PERS(victim,ch)) );
          strcat( final, buf );
         break;
        case POS_MORTAL:
          sprintf( buf, "%s has wounds that may bring death. ",
                   capitalize(PERS(victim,ch)) );
          strcat( final, buf );
         break;
        case POS_INCAP:
          sprintf( buf, "%s has been rendered incapacitated. ",
                   capitalize(PERS(victim,ch)) );
          strcat( final, buf );
         break;
        case POS_STUNNED:
          sprintf( buf, "%s is stunned. ",
                   capitalize(PERS(victim,ch)) );
          strcat( final, buf );
         break;
        case POS_SLEEPING:
          if ( victim->furniture )
          sprintf( buf, "%s is fast asleep upon %s. ",
                        capitalize(HE_SHE(victim)), PERSO(victim->furniture,ch) );
          else
          sprintf( buf, "%s is fast asleep. ",
                        capitalize(HE_SHE(victim)) );
          strcat( final, buf );
         break;
        case POS_SITTING:
          if ( victim->furniture )
          sprintf( buf, "%s is sitting on %s. ",
                        capitalize(HE_SHE(victim)), PERSO(victim->furniture,ch) );
          else
          sprintf( buf, "%s is sitting. ",
                        capitalize(HE_SHE(victim)) );
          strcat( final, buf );
         break;
        case POS_RESTING:
          if ( victim->furniture )
          sprintf( buf, "%s rests on %s. ",
                        capitalize(HE_SHE(victim)), PERSO(victim->furniture,ch) );
          else
          sprintf( buf, "%s is resting. ",
                        capitalize(HE_SHE(victim)) );
          strcat( final, buf );
         break;
        case POS_FIGHTING:
          if ( victim->fighting != NULL )
          {
          sprintf( buf, "     %s is fighting with %s.\n\r",
                        PERS( victim, ch ),  PERS( victim->fighting, ch ) );
          strcat( final, buf );
          }
         break;
          default:  break;
    }

    sprintf( buf, "%s stands the height of %s handspans",
             capitalize(HE_SHE(victim)),
             numberize( victim->size/2 ) );

    strcat( final, buf );

    if ( ch->size != victim->size )
    {
        sprintf( buf, ", which is roughly %s halfspans %s than you.\n\r",
             numberize( abs(ch->size - victim->size) ),
             ch->size - victim->size > 0 ? "shorter" : "taller" );
        strcat( final, buf );
    }
    else
    strcat( final, ".\n\r" );

    if ( !IS_NPC(victim) )
    {
        int age = PERCENTAGE(GET_AGE(victim),race_table[victim->race].base_age);
        sprintf( buf, "%s is a%s %s.\n\r",
                 capitalize(NAME(victim)),
                 age < 30 ? " young" :
                 age < 40 ? " matured" :
                 age < 60 ? " middle-aged" :
                 age < 80 ? "n aging" :
                 age < 90 ? "n elderly" : "n ancient",
                 race_table[victim->race].race_name );
        strcat( final, buf );
    }
    
    if ( victim->riding != NULL )
    {
        sprintf( buf, "     %s rides atop %s.\n\r", HE_SHE(victim), NAME(victim->riding) );
	strcat( final, buf );
    }
    else
    if ( victim->rider != NULL )
    {
        sprintf( buf, "     %s is being ridden by %s.\n\r", HE_SHE(victim), capitalize(NAME(victim->rider)) );
	strcat( final, buf );
    }

    if ( GET_PC(victim,condition[COND_DRUNK],0) > 50 )
    {
        sprintf( buf, " %s looks a bit tipsy and smells of drink.\n\r",
                 HE_SHE(victim) );
        strcat( final, buf );
    }

	{
		char *p;
                p = format_string( str_dup(final) );
		send_to_char( "   ", ch );
		send_to_char( p, ch );
		free_string( p );
	}

    send_to_char( "\n\r", ch );

    if ( (IS_IMMORTAL(ch) && IS_SET(ch->act2, WIZ_EQUIPMENT)) )
    {
       show_equipment_table( ch, victim );
       show_inventory( victim, ch, FALSE );
    }

    return;
}


 /*
  *  Show whose in the room (all mobs/players)
  */
void show_char_to_char( CHAR_DATA *list, CHAR_DATA *ch )
{
    CHAR_DATA *rch;
    bool fDark = 0;

    for ( rch = list; rch != NULL; rch = rch->next_in_room )
    {
        if ( rch == ch )
            continue;

        if ( !IS_NPC(rch)
        &&   GET_PC(rch,wizinvis,0) >= GET_PC(ch,level,0)
        &&   get_trust( ch ) < get_trust( rch ) )
             continue;

        if ( can_see( ch, rch ) )
        {
             show_char_to_char_0( rch, ch );
        }
        else
        if ( room_is_dark( ch->in_room ) && IS_AFFECTED(rch, AFF_INFRARED) )
        fDark++;
    }

    if ( fDark > 0 )
    {
        char buf[MAX_STRING_LENGTH];

        sprintf( buf, "%s red eyes stare at you from the darkness.\n\r",
                      numberize( fDark * 2 ) );
        send_to_char( buf, ch );
    }
    return;
}

 
bool check_blind( CHAR_DATA *ch )
{
    if ( !IS_NPC(ch) && IS_SET(ch->act2, WIZ_HOLYLIGHT) )
    return TRUE;

    if ( IS_AFFECTED(ch, AFF_BLIND) )
    {
    send_to_char( "You can't see a thing!\n\r", ch );
    return FALSE;
    }

    return TRUE;
}

bool char_look_list( CHAR_DATA *ch, OBJ_DATA *list, char *arg )
{
    OBJ_DATA *obj;
    char *pdesc;
    char buf[MAX_STRING_LENGTH];
    char argnew[MAX_STRING_LENGTH];
    int count;
    int number;
    
    number = number_argument( arg, argnew );
    count  = 0;

    for ( obj = list; obj != NULL; obj = obj->next_content )
    {
        if ( can_see_obj( ch, obj ) )
        {
            pdesc = get_extra_descr( arg, obj->extra_descr );
            if ( pdesc == NULL )
            pdesc = get_extra_descr( arg, obj->pIndexData->extra_descr );

            if ( pdesc != NULL )
            {
                    page_to_char( pdesc, ch );
                    return TRUE;
            }
        }

        if ( is_name( argnew, STR(obj, name) ) && ++count == number )
        {
            char fub[MAX_STRING_LENGTH];
            
            page_to_char( STR(obj, real_description), ch );
            switch ( obj->item_type )
            {
              default:
                break;

              case ITEM_LIGHT:
                 if( obj->value[1] )
                 {
                     int percent = PERCENTAGE( obj->value[0], obj->value[1] );

                     sprintf( buf, "\n\r%s %s %s\n\r",
                                  capitalize( STR(obj, short_descr) ),
                                  is_are( STR(obj, short_descr) ),
                       !IS_LIT(obj)  ? "extinguished."              :
                       percent <  10 ? "flickering and sputtering." :
                       percent <  20 ? "flickering."                :
                       percent <  30 ? "flickering slightly."       :
                       percent <  40 ? "providing ample light."     :
                                       "glowing brightly." );
                     send_to_char( buf, ch );
                 }
              break;

              case ITEM_BOARD:
                  do_note( ch, "list" );
                break;

              case ITEM_DRINK_CON:
                 if ( obj->value[1] <= 0 )
                     {
                         send_to_char( "It is empty.\n\r", ch );
                         break;
                     }
              break;

              case ITEM_ARMOR:
                    if( obj->value[1] )
                    {
                       int percent;

                       percent = PERCENTAGE( obj->value[1], obj->value[2] );
                       sprintf( buf, "\n\r%s %s\n\r",
                                     capitalize( STR(obj, short_descr) ),
                        percent <  10 ? "is in pieces." :
                        percent <  20 ? "is nearly destroyed." :
                        percent <  30 ? "is heavily damaged." :
                        percent <  40 ? "is in poor shape." :
                        percent <  50 ? "looks worn." :
                        percent <  60 ? "is starting to look rather worn." :
                        percent <  70 ? "looks well used." :
                        percent <  80 ? "is slightly damaged." :
                        percent <  90 ? "is in fair shape." :
                        percent < 100 ? "is in good shape." :
                                        "looks excellent." );
                       send_to_char( buf, ch );
                    }
              case ITEM_CLOTHING:
              		if ( obj->carried_by != ch
              		  || obj->wear_loc <= WEAR_BELT_1 )
              		{
                    if ( TOO_BIG(ch, obj) )
                    send_to_char( "It looks too big for you to wear.\n\r", ch );
               else if ( TOO_SMALL(ch, obj) )
                    send_to_char( "It looks too small for you to wear.\n\r", ch );
               else send_to_char( "You could probably wear it.\n\r", ch );
                    }
              break;

            case ITEM_GEM:
             if( obj->value[1] )
             {
                int percent = PERCENTAGE( obj->value[1], obj->value[2] );

                sprintf( buf, "\n\r%s %s\n\r",
                         capitalize( STR(obj, short_descr) ),
                         percent <  10 ? "is dimly flickering."   :
                         percent <  20 ? "is slowly pulsating."   :
                         percent <  30 ? "is quickly pulstating." :
                         percent <  40 ? "is glowing."            :
                         percent <  50 ? "glows brightly."
                                       : "radiates with energy."    );
                send_to_char( buf, ch );
             }
            break;
            }

            if ( obj->item_type == ITEM_FURNITURE && obj->contains != NULL )
            {
                sprintf( fub, "On %s is ", format_obj_to_char( obj, ch, TRUE ) );
                page_to_char( show_list_to_char2( obj->contains, ch, fub ), ch );
            }

            if ( has_occupant( obj ) )
            show_occupants_to_char( obj, ch );
            return TRUE;
        }
    }

    return FALSE;
}




/*
 * Syntax:  look
 *          look auto
 *          look [direction]
 *          look [object]
 *          look [person]
 *          look [description]
 */
void do_look( CHAR_DATA *ch, char *argument )
{
    char buf  [MAX_STRING_LENGTH];
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    EXIT_DATA *pexit;
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    int door;

/*    if ( ch->desc == NULL )
    return;   */

    if ( ch->position < POS_SLEEPING )
    {
	send_to_char( "You can't see anything but stars!\n\r", ch );
	return;
    }

    if ( ch->position == POS_SLEEPING )
    {
	send_to_char( "You can't see anything, you're sleeping!\n\r", ch );
	return;
    }

    if ( !check_blind( ch ) )
	return;

    if ( !IS_NPC(ch)
      && !IS_SET(ch->act, WIZ_HOLYLIGHT)
      && room_is_dark( ch->in_room ) )
    {
        bool fLight = FALSE;
        int direction = 0;
        int count = 0;
        EXIT_DATA *pExit;
        char buf[MAX_INPUT_LENGTH];

        buf[0] = '\0';
        for( direction = 0; direction < MAX_DIR; direction++ )
        {
             pExit = ch->in_room->exit[direction];
             if ( pExit != NULL
               && !IS_SET(pExit->exit_info, EX_CLOSED)
               && pExit->to_room != NULL
               && !room_is_dark( pExit->to_room ) ) 
             count++;
        }

        for( direction = 0;  direction < MAX_DIR; direction++ )
        {
             pExit = ch->in_room->exit[direction];
             if ( pExit != NULL 
               && !IS_SET(pExit->exit_info, EX_CLOSED)
               && pExit->to_room != NULL
               && !room_is_dark( pExit->to_room ) )
             {
                  strcat( buf, dir_name[direction] );
                  fLight = TRUE;
                  switch( --count ) 
                  {
                        case 1: strcat( buf, " and " ); break;
                        case 0: break;
                       default: strcat( buf, ", " ); break;
                  }
             }
        }

        if (!fLight)
        {
             send_to_char( "   You are surrounded by darkness.\n\r", ch );
        }
        else
        {
             act( "You can see light to the $t.", ch, buf, NULL, TO_CHAR);
        }

        show_char_to_char( ch->in_room->people, ch );
        return;
    }

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || !str_cmp( arg1, "auto" ) )
    {
	/* 'look' or 'look auto' */
    if ( HAS_ANSI(ch) )
    {
    ansi_color( NTEXT, ch );
    ansi_color( color_table[PC(ch,colors[COLOR_ROOM_TITLE])].code, ch );
    }

    send_to_char( ch->in_room->name, ch );

    if ( !IS_NPC(ch) && IS_SET(ch->act2, PLR_AUTOEXIT) )
        do_exits( ch, "auto" );

    if ( HAS_ANSI(ch) )
    {
    ansi_color( NTEXT, ch );
    ansi_color( GREY, ch );
    }

    if ( IS_SET(ch->in_room->room_flags, ROOM_SAVE) )
    send_to_char( "*", ch );
    
    send_to_char( "\n\r", ch );

	if ( arg1[0] == '\0'
    || ( !IS_NPC(ch) && !IS_SET(ch->act2, PLR_BRIEF) ) )
    {
        ROOM_INDEX_DATA *template;
        
        template = get_room_index( ch->in_room->template );
        if ( template != NULL && !MTD( template->description ) )
        {
            send_to_char( "   ", ch );  /*indent*/
            send_to_char( template->description, ch );
        }
    }

    /*
     * Worldgen
     */
    if ( ch->in_room->terrain != 0 )
            show_terrain( ch, ch->in_room );

    {
        if ( !MTD(ch->in_room->description) )
        send_to_char( "   ", ch ); /* indent */
        send_to_char( ch->in_room->description, ch );
    }

    ansi_color( NTEXT, ch );

	show_list_to_char( ch->in_room->contents, ch, FALSE, FALSE );
	show_char_to_char( ch->in_room->people,   ch );

    ansi_color( NTEXT, ch );

	return;
    }

    if ( !str_cmp( arg1, "i" ) || !str_cmp( arg1, "in" ) )
    {
        /* 'look in' */
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Look in what?\n\r", ch );
            return;
        }

        if ( ( obj = get_obj_here( ch, arg2 ) ) == NULL )
        {
            send_to_char( "You do not see that here.\n\r", ch );
            return;
        }

        switch ( obj->item_type )
        {
        default: send_to_char( "That is not a container.\n\r", ch );       
            break;

        case ITEM_LIGHT:
             if ( obj->value[1] != 0 )
             {
             int percent = PERCENTAGE(obj->value[0], obj->value[1]);

             if ( obj->value[0] <= 0 )
             {
                 send_to_char( "It is empty.\n\r", ch );
                 break;
             }
             else
             {
             sprintf( buf, "It %s fuel.\n\r",
             percent < 10 ? "contains a low amount of"      :
             percent < 40 ? "contains less than half its capacity of" :
             percent < 70 ? "contains an ample amount of"   :
             percent < 90 ? "is mostly filled with"         : "is full of" );
             send_to_char( buf, ch );
             }
             }
             else send_to_char( "It contains nothing.\n\r", ch );
        break;

        case ITEM_DRINK_CON:
             if ( obj->value[1] <= 0 )
                 {
                     send_to_char( "It is empty.\n\r", ch );
                     break;
                 }
             else
             {
             int percent = PERCENTAGE(obj->value[0], obj->value[1]);

             sprintf( buf, "It %s of a%s %s liquid.\n\r",
                      percent < 10 ? "has but a drop"         :
                      percent < 40 ? "is less than half full" :
                      percent < 60 ? "is half full"           :
                      percent < 70 ? "is near full"           : "full",
                      IS_VOWEL(liq_table[obj->value[2]].liq_color[0]) ? "n" : "",
                      liq_table[obj->value[2]].liq_color );
             send_to_char( buf, ch );
             }
        break;

        case ITEM_CONTAINER:
        case ITEM_CORPSE_NPC:
        case ITEM_CORPSE_PC:
            if ( IS_SET(obj->value[1], CONT_CLOSED) )
            {
                send_to_char( "It is closed.\n\r", ch );
                break;
            }

            if ( obj->item_type == ITEM_CONTAINER )
            {
                 sprintf( buf, "%s contains ",
                     format_obj_to_char( obj, ch, TRUE ) );
                 buf[0] = UPPER(buf[0]);
            }
            else
            {
            	act( "$n searches the remains of $p.", ch, obj, NULL, TO_ROOM );
            	sprintf( buf, "Searching the remains of %s reveals ",
                     format_obj_to_char( obj, ch, TRUE ) );
            }

            page_to_char( show_list_to_char2( obj->contains, ch, buf ), ch );
        break;
	}
        return;
    }

    if ( !str_cmp( arg1, "o" ) || !str_cmp( arg1, "on" ) )
    {
        /* 'look on' */
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Look on what?\n\r", ch );
            return;
        }

        if ( (obj = get_obj_here( ch, arg2 )) == NULL )
        {
            send_to_char( "You do not see that here.\n\r", ch );
            return;
        }
        
        if ( obj->item_type != ITEM_FURNITURE || obj->contains  == NULL )
        act( "There is nothing on $p.", ch, obj, NULL, TO_CHAR );
        else
        {
        if ( obj->contains->next_content != NULL )
        sprintf( buf, "On %s are ", format_obj_to_char( obj, ch, TRUE ) );
        else
        sprintf( buf, "On %s is ", format_obj_to_char( obj, ch, TRUE ) );

        send_to_char( show_list_to_char2( obj->contains, ch, buf ), ch );
        }
        
        if ( has_occupant( obj ) )
        show_occupants_to_char( obj, ch );
        return;
    }

    if ( !str_cmp( arg1, "a" ) || !str_cmp( arg1, "at" ) )
    {
	strcpy( arg1, arg2 );
    arg2[0] = '\0';
    }

    if ( (victim = get_char_room( ch, arg1 )) != NULL )
    {
	show_char_to_char_1( victim, ch );
	return;
    }

    if ( char_look_list( ch, ch->carrying, arg1 ) )
    return;

    if ( char_look_list( ch, ch->in_room->contents, arg1 ) )
    return;

    {
        char *pdesc;
        
        pdesc = get_extra_descr( arg1, ch->in_room->extra_descr );        
        if ( pdesc != NULL )
        {
            page_to_char( pdesc, ch );
            return;
        }
    }

    if ( ( door = get_dir( arg1 ) ) == MAX_DIR )
    {
	send_to_char( "You do not see that here.\n\r", ch );
	return;
    }

    /* 'look direction' */
    if ( ( pexit = ch->in_room->exit[door] ) == NULL )
    {
        sprintf( buf, "There is nothing of note %sward from here.\n\r",
                      dir_name[door] );
        send_to_char( buf, ch );
        return;
    }

    if ( pexit->to_room != NULL && room_is_dark( pexit->to_room ) )
    {
        sprintf( buf, "To the %s is darkness.\n\r", dir_name[door] );
        send_to_char( buf, ch );
        return;
    }

    if ( !MTD(pexit->description) )  send_to_char( pexit->description, ch );
    else
    if ( MTD(pexit->keyword) || !IS_SET( pexit->exit_info, EX_ISDOOR ) )
    {
        sprintf( buf, "There is nothing of note %sward from here.\n\r",
                      dir_name[door] );
        send_to_char( buf, ch );
    }

    if ( !MTD(pexit->keyword)
      && !IS_SET(pexit->exit_info, EX_SECRET)
      && !IS_SET(pexit->exit_info, EX_CONCEALED) )
    {
        if ( IS_SET(pexit->exit_info, EX_CLOSED) )
        act( "The $T is closed.", ch, NULL, pexit->keyword, TO_CHAR );
        else if ( IS_SET(pexit->exit_info, EX_ISDOOR) )
        act( "The $T is open.",   ch, NULL, pexit->keyword, TO_CHAR );
    }

    if ( IS_SET(pexit->exit_info, EX_WINDOW)
      && !IS_SET(pexit->exit_info, EX_CLOSED)
      && pexit->to_room != NULL )
    {
        act( "Through the $t you see:", ch, pexit->keyword, NULL, TO_CHAR );

        if ( !MTD(pexit->to_room->description) )
        {
        send_to_char( "   ", ch ); /* indent */
        send_to_char( pexit->to_room->description, ch );
        }

        show_list_to_char( pexit->to_room->contents, ch, FALSE, FALSE );
        show_char_to_char( pexit->to_room->people,   ch );
    }

    if ( !IS_SET(pexit->exit_info, EX_CLOSED)
      && !IS_SET(pexit->exit_info, EX_CONCEALED) )
    act( "$n glances $t.", ch, dir_name[door], NULL, TO_ROOM );
    scan_direction( ch, door );

    return;
}




/*
 * Thanks to Zrin for auto-exit part.
 * Syntax:  exits
 *          exits auto
 */
void do_exits( CHAR_DATA *ch, char *argument )
{
    extern char * const dir_name[];
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    EXIT_DATA *pexit;
    OBJ_DATA *obj;
    bool found;
    bool fAuto;
    int door;

    buf[0] = '\0';
    fAuto  = !str_cmp( argument, "auto" );

    if ( room_is_dark( ch->in_room ) && !IS_SET(ch->act2, WIZ_HOLYLIGHT) )
      {
          if ( !fAuto ) 
          send_to_char( "It's too dark to see anything!\n\r", ch );
          return;
	}


    if ( !check_blind( ch ) )
	return;

    strcpy( buf, fAuto ? " [" : "" );

    found = FALSE;
    for ( door = 0; door < MAX_DIR; door++ )
    {
	if ( ( pexit = ch->in_room->exit[door] ) != NULL
	&&   pexit->to_room != NULL
        &&   !IS_SET(pexit->exit_info, EX_CONCEALED) )
	{
            if ( fAuto )
            {
                if ( IS_SET(pexit->exit_info, EX_CLOSED)
                  && IS_SET(pexit->exit_info, EX_SECRET) )
                continue;
                
                strcat( buf, dir_letter[door] );
                found = TRUE;
            }
	    else
	    {
            if ( !IS_SET(pexit->exit_info, EX_CLOSED)
              && !MTD(pexit->keyword) )
            {
                sprintf( buf + strlen(buf), "A %s leads %s to %s.\n\r",
                         pexit->keyword, dir_name[door],
                         room_is_dark( pexit->to_room )  ?  "darkness"
                                            : pexit->to_room->name );
                found = TRUE;
            }
            else
            if ( !IS_SET(pexit->exit_info, EX_SECRET) )
            {
                sprintf( buf + strlen(buf), "%s%s%s is %s%s.\n\r",
                  door != DIR_UP && door != DIR_DOWN ? "To the " : "",
                  door != DIR_UP && door != DIR_DOWN ? dir_name[door]
                                               : capitalize(dir_name[door]),
                  door == DIR_UP || door == DIR_DOWN ? "ward from here" : "",
                  IS_SET(pexit->exit_info, EX_CLOSED) ? "a closed " : "",
                  IS_SET(pexit->exit_info, EX_CLOSED) ? pexit->keyword :
                  room_is_dark( pexit->to_room )  ?  "darkness"
                                            : pexit->to_room->name );
                found = TRUE;
            }
	    }
	}
    }
    
    for ( obj = ch->in_room->contents;  obj != NULL;  obj =obj->next_content )
    {
    	if ( obj->item_type == ITEM_FURNITURE
    	  && IS_SET(obj->value[1], FURN_EXIT)
         && !IS_SET(obj->value[1], FURN_NOSHOW)
          && can_see_obj( ch, obj ) )
    	{
		if ( !fAuto )
		sprintf( buf2, "%s", STR(obj, action_descr) );
		else
		sprintf( buf2, " (%s)", STR(obj, short_descr) );
 
    		send_to_char( buf2, ch );
    		found = TRUE;
    	}
    }

    if ( !found )
        strcat( buf, fAuto ? "" : "There are no obvious ways out.\n\r" );

    if ( fAuto )
        strcat( buf, "]" );

    if ( buf[1] != ']' ) send_to_char( buf, ch );
    return;
}


#define STAT(func, str1, str2, str3, str4, str5 ) \
                if (func(ch) <  8) sprintf(buf, str1 );       \
           else if (func(ch) < 12) sprintf(buf, str2 );       \
           else if (func(ch) < 16) sprintf(buf, str3 );       \
           else if (func(ch) < 22) sprintf(buf, str4 );       \
           else                    sprintf(buf, str5 );


/*
 * Syntax:  score
 */
void do_score( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    int i;

    if ( IS_NPC(ch) )
    {
        do_stat( ch, "self" );
        return;
    }

    ansi_color( NTEXT, ch );
    
    buf2[0] = '\0';

    i = PERCENTAGE(GET_AGE(ch),race_table[ch->race].base_age);
    sprintf( buf, "You are a%s %s named %s,\n\r",
                   i < 30 ? " young" :
                   i < 60 ? " middle-aged" :
                   i < 80 ? "n aging" :
                   i < 90 ? "n elderly" : "n ancient",
                   race_table[ch->race].race_name, ch->name );
    strcat( buf2, buf );

    {
        int p = PC(ch,played);
        int ct = (int) (current_time - PC(ch,logon));

        i = (p + ct)/7200;
    }

    if ( i > 0 )
    {
    if ( i > 24 )
    {
        int days;
        int hours;
        char smuf[MAX_STRING_LENGTH];

        days  = i / 24;
        hours = i % 24;

        sprintf( smuf, "%s", numberize( days ) );
        sprintf( buf, " with a total of %s day%s and %s hour%s of play,\n\r",
                      smuf, days == 1 ? "" : "s",
                      numberize( hours ), hours == 1 ? "" : "s" );
    }
    else
    {
        sprintf( buf, " with a total of %s hour%s of play,\n\r",
                      numberize( i ), i == 1 ? "" : "s" );
    }
    strcat( buf2, buf );
    }

    sprintf( buf, " %s halfspans tall,\n\r", numberize( ch->size ) );
    strcat( buf2, buf );
    
    sprintf( buf, " you are %s years old, ", numberize( GET_AGE(ch) ) );
    strcat( buf2, buf );

    if ( PC(ch,birth_month) == time_info.month )
    {

        int daydist = PC(ch,birth_day) - time_info.day;

        if ( daydist == -1 )
        strcat( buf2, "yesterday was your birthday, " );
        else
        if ( daydist == 0 )
        strcat( buf2, "today is your birthday, " );
        else
        if ( daydist == 1 )
        strcat( buf2, "tomorrow is your birthday, " );
        else
        if ( daydist > 1 && daydist < 30 )
        {
            sprintf( buf, "your birthday is in %s days,", numberize(daydist) );
            strcat( buf2, buf );
        }
    }
    strcat( buf2, "\n\r" );
    
    sprintf( buf, " and you are currently %s and %s.\n\r", STRING_HITS(ch), STRING_MOVES(ch) );
    strcat( buf2, buf );

    {
	char *p;

    p = format_indent( str_dup(buf2), " ", 76, TRUE );
    send_to_char( p, ch );
    free_string( p );
    } 

    if ( ch->carry_number != 0 )
    {
        sprintf( buf2, "%s", numberize( ch->carry_number ) );
        sprintf( buf, "You are carrying %s item%s weighing roughly %s stone%s.\n\r",
                      buf2,
                      ch->carry_number == 1 ? "" : "s",
                      numberize( ch->carry_weight/2+1 ),
                      ch->carry_weight == 1 ? "" : "s" );
        send_to_char( buf, ch );
    }

    if ( IS_IMMORTAL(ch) )
    {
    send_to_char( "You are", ch );

    switch ( get_trust( ch ) )
    {
           default: if ( IS_IMMORTAL(ch) )
                           sprintf( buf, " an immortal,"   );
                      else buf[0] = '\0';
                    break;
   case LEVEL_HERO: sprintf( buf, " an avatar," ); break;
case LEVEL_BUILDER: sprintf( buf, " a conceiver," ); break;
  case LEVEL_ANGEL: sprintf( buf, " an angel,"  ); break;
case LEVEL_SUPREME: sprintf( buf, " supreme,"   ); break;
case LEVEL_DEMIGOD: sprintf( buf, " a demigod," ); break;
    case MAX_LEVEL: sprintf( buf, " God,"   ); break;
    }
    
    send_to_char( buf, ch );

    sprintf( buf, " with a building security of %d.\n\r", PC(ch,security) );
    send_to_char( buf, ch );
    }
    
    {
    char *p;
    char fbuf[MAX_STRING_LENGTH];
    
    fbuf[0] = '\0';
    
    sprintf( fbuf, "You possess " );

    STAT(get_curr_str, "a frail ",
                       "a ",
                       "a hardened ",
                       "a muscular ",
                       "a mighty " );
    strcat( fbuf, buf );

    STAT(get_curr_int, "moronic",
                       "simpleton's",
                       ch->sex == SEX_MALE   ? "man's" :
                       ch->sex == SEX_FEMALE ? "woman's" : "eunich's",
                       "scholar",
                       "genius" );
    strcat( fbuf, buf );

    STAT(get_curr_wis, " physique, with a head like a hole,  ",
                       " body, ",
                       " build, with good common sense,  ",
                       " frame, with a wise air about you,  ",
                       " physique, with a perceptive mind,  " );
    strcat( fbuf, buf );

    STAT(get_curr_dex, " and you are lithargic and" ,
                       " and you are ",
                       " and you are nimble and",
                       " and you are quick and",
                       " and you are like lightning and" );
    strcat( fbuf, buf );
     
    STAT(get_curr_con, " quite faint-hearted.  ",
                       " of average health.  ",
                       " healthy.  ",
                       " brazen.  ",
                       " very healthy.  " );
    strcat( fbuf, buf );
    
    p = format_indent( str_dup(fbuf), " ", 76, TRUE );
    send_to_char( p, ch );
    free_string( p );
    }

    if ( ch->pcdata )
    {
    sprintf( buf, "You are %s, %s, %s",
         (PC(ch,condition[COND_DRUNK] ) > 50) ? "drunk" : 
         (PC(ch,condition[COND_DRUNK] ) > 20) ? "tipsy" : 
                                                "sober",
         
         (PC(ch,condition[COND_THIRST]) >   50) ? "quenched"    :
         (PC(ch,condition[COND_THIRST]) >   10) ? "not thirsty" :
         (PC(ch,condition[COND_THIRST]) >= -10) ? "thirsty"     : 
                                                  "dehydrated",
         
         (PC(ch,condition[COND_FULL]  ) >  50) ? "full"            :
         (PC(ch,condition[COND_FULL]  ) >  20) ? "satisfied"       :
         (PC(ch,condition[COND_FULL]  ) >   0) ? "slightly hungry" :
         (PC(ch,condition[COND_FULL]  ) > -30) ? "hungry"          :
         (PC(ch,condition[COND_FULL]  ) > -50) ? "famished"        :
                                                 "starving" );
    send_to_char( buf,  ch );
    }

    switch ( ch->position )
    {
    case POS_DEAD:     send_to_char( ", and have died.\n\r",              ch ); break;
    case POS_MORTAL:   send_to_char( ", and have been mortally wounded.\n\r",  ch ); break;
    case POS_INCAP:    send_to_char( ", and have been incapacitated.\n\r",     ch ); break;
    case POS_STUNNED:  send_to_char( ", and, unfortunately, stunned.\n\r",     ch ); break;
    case POS_SLEEPING:
    case POS_SITTING:
    case POS_RESTING:
    if ( ch->furniture )
    {
        sprintf( buf, ", and %s on %s.\n\r", position_name(ch->position),
                 STR(ch->furniture,short_descr) );
    } 
    else
    sprintf( buf, ", and %s.\n\r", position_name(ch->position) );
    
    send_to_char( buf, ch );
    break;
    case POS_STANDING:
     if ( ch->riding != NULL )
     {
        sprintf( buf, ", and you are riding %s.\n\r", NAME(ch->riding) );
        send_to_char( buf, ch );
     }
     else
     send_to_char( ".\n\r", ch );
    break;
    case POS_FIGHTING:
     if ( ch->riding != NULL )
     {
        sprintf( buf, ", and engaged in combat with %s.\n\r", NAME(ch->fighting) );
        send_to_char( buf, ch );
     }
     else
     send_to_char( ", and fighting.\n\r",          ch );
    break;
    }

     if ( ch->bounty <    70  ) send_to_char( "You are a protected citizen", ch );
else if ( ch->bounty <   500  ) send_to_char( "You are an untrustworthy theif", ch );
else if ( ch->bounty <  10000 ) send_to_char( "You are considered a criminal", ch );
else if ( ch->bounty < 100000 ) send_to_char( "You are a fugitive from justice", ch );
                           else send_to_char( "You are a feared outlaw", ch );

    if ( ch->owed > 0 )
    send_to_char( ", and owed a bounty.\n\r", ch );
    else
    send_to_char( ".\n\r", ch );

	do_fight( ch, "" );

    sprintf( buf, "You are currently speaking %s.\n\r", lang_table[ch->speaking].name );
    send_to_char( buf, ch );

    if ( IS_AFFECTED(ch,AFF_HIDE) && IS_AFFECTED(ch,AFF_SNEAK) )
    send_to_char( "You are attempting camoflage and stealth.\n\r", ch );
    else
    if ( IS_AFFECTED(ch,AFF_HIDE) )
    send_to_char( "You are trying to camoflage yourself.\n\r", ch );
    else
    if ( IS_AFFECTED(ch,AFF_SNEAK) )
    send_to_char( "You are trying to move with stealth.\n\r", ch );


    return;
}



char *	const	day_name	[] =
{
    "Lexo, the Great Hawk",
    "Franto, the Falcon",
    "Halag, the Owl",
    "Ruz, the Black Crow",
    "Kalamak, the Phoenix",
    "Aedo, the Golden Eagle",
    "Franwag, the Grey Gull"                         /*  7 */
};

char *  const   month_name  [] =
{
    "Iak, Season of the Ice Cougar, in winter",
    "Vod, Season of the White Fox, in winter",
    "Lin, Season of the Robin, in spring",
    "Nemi, Season of the Crystalfish, in spring",
    "Grez, the Crop Wind, planting season",
    "Po, Season of the Squirrel, in summer",
    "Rani, the Dry Winds, in summer",
    "Falak, the Dragon's Breath, late summer",
    "Kae, Harvest Moon",
    "Ret, Season of the Changing Oak, in autumn",
    "Jal, the New Frost, in autumn",
    "Yun, the Ice Weaver, in winter"
};

static char * const sky_look[8] =
{
    "cloudless",
    "cloudy",
    "obscured by storm clouds",
    "lit by flashes of lightning",
    "slightly overcast",
    "scattered with a few flakes",
    "filled with flakes",
    "a blizzard of white"
};


/*
 * Syntax:  time
 *          time full
 */
void do_time( CHAR_DATA *ch, char *argument )
{
    extern char str_boot_time[];
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    char descr[MAX_STRING_LENGTH];
    sh_int wind;
    int day;

    if ( !check_blind( ch ) )
    {
        send_to_char( "You have no clue what is going on, you are blind!\n\r",
                      ch );
        return;
    }

    one_argument( argument, arg );

    day     = time_info.day + 1;

    switch ( time_info.hour )
    {
        case  1:
        case  2: sprintf( descr, "late night"       ); break;
        case  3:
        case  4: sprintf( descr, "early morning"    ); break;
        case  5: sprintf( descr, "just before dawn" ); break;
        case  6: sprintf( descr, "dawn"             ); break;
        case  7: 
        case  8: sprintf( descr, "early morning"    ); break;
        case  9:
        case 10:
        case 11: sprintf( descr, "morning"          ); break;
        case 12: sprintf( descr, "midday"           ); break;
        case 13:
        case 15: sprintf( descr, "afternoon"        ); break;
        case 14: sprintf( descr, "mid-afternoon"    ); break;
        case 16:
        case 17: sprintf( descr, "evening"          ); break;
        case 18: sprintf( descr, "twilight"         ); break;
        case 19: sprintf( descr, "dusk"             ); break;
        case 20:
        case 21:
        case 22: sprintf( descr, "night"            ); break;
        case 23: sprintf( descr, "late at night"    ); break;
        case  0: sprintf( descr, "midnight"         ); break;
    }

    sprintf( buf, "It is %s on the day of %s.  The %s of the month of %s, in the year %s. ",
             descr,
             day_name[day % 7],
             day ==  1 ? "first"          :
             day ==  2 ? "second"         :
             day ==  3 ? "third"          :
             day ==  4 ? "fourth"         :
             day ==  5 ? "fifth"          :
             day ==  6 ? "sixth"          :
             day ==  7 ? "seventh"        :
             day ==  8 ? "eighth"         :
             day ==  9 ? "ninth"          :
             day == 10 ? "tenth"          :
             day == 11 ? "eleventh"       :
             day == 12 ? "twelfth"        :
             day == 13 ? "thirteenth"     :
             day == 14 ? "fourteenth"     :
             day == 15 ? "fifteenth"      :
             day == 16 ? "sixteenth"      :
             day == 17 ? "seventeenth"    :
             day == 18 ? "eighteenth"     :
             day == 19 ? "nineteenth"     :
             day == 20 ? "twentieth"      :
             day == 21 ? "twenty-first"   :
             day == 22 ? "twenty-second"  :
             day == 23 ? "twenty-third"   :
             day == 24 ? "twenty-fourth"  :
             day == 25 ? "twenty-fifth"   :
             day == 26 ? "twenty-sixth"   :
             day == 27 ? "twenty-seventh" :
             day == 28 ? "twenty-eighth"  :
             day == 29 ? "twenty-ninth"   :
                         "thirtieth",
             month_name[time_info.month],
             numberize( time_info.year ) );

    if ( !IS_OUTSIDE(ch) )
    {
        strcat( buf, "You cannot tell what the weather is like from here." );
    }
    else
    {
    wind = weather_info.windspeed;
    descr[0] = '\0';
    sprintf( descr, "The sky is %s ",
                  (time_info.month < 2 || time_info.month == 11) ?
                  sky_look[weather_info.sky+4] : sky_look[weather_info.sky] );
    strcat( buf, descr );
    sprintf( descr, "and a %s %sward %s blows.\n\r",
             (weather_info.temperature < 35) ? "cold" :
             (weather_info.temperature < 60) ? "cool" :
             (weather_info.temperature < 90) ? "warm" : "hot",
             dir_name[abs(weather_info.winddir) % 4],
             wind <= 20 ? "breeze"   :
             wind <= 50 ? "wind"     :
             wind <= 80 ? "gust"     :
                          "torrent"    );
    strcat( buf, descr );


    }

    if ( IS_OUTSIDE(ch) && time_info.hour < 4 )
    {
        if ( weather_info.sky != SKY_CLOUDLESS
          && weather_info.moon_phase != MOON_NEW )
        strcat( buf, "The moon is behind a cloud." );
        else
        switch ( weather_info.moon_phase )
        {
        case MOON_NEW:
            strcat( buf, "No moon graces the heavens tonight." ); break;
        case MOON_WAXING_CRESCENT:
            strcat( buf, "The waxing moon is a mere crescent in the night sky." ); break;
        case MOON_WAXING_HALF:
            strcat( buf, "The waxing half-moon can be seen on this night." ); break;
        case MOON_WAXING_THREE_QUARTERS:
            strcat( buf, "Tonight, the moon is near full, a waxing gibbous of celestial harmony." ); break;
        case MOON_FULL:
            strcat( buf, "The moon is full." ); break;
        case MOON_WANING_THREE_QUARTERS:
            strcat( buf, "The moon is in the phase of a waning gibbous." ); break;
        case MOON_WANING_HALF:
            strcat( buf, "A waning half-moon treks across the night sky." ); break;
        case MOON_WANING_CRESCENT:
            strcat( buf, "Only a sliver of moon remains in the heavens." ); break;
          default:
            if ( IS_IMMORTAL(ch) )
            strcat( buf, "Something is drastically wrong with the moon!  E-gads!" );
           break;
        }
    }

    {
        char *p;
        p = format_string( str_dup( buf ) );
        send_to_char( p, ch );
        free_string( p );
    }

    if ( IS_IMMORTAL( ch ) && !str_cmp( arg, "full" ) )
    {
        extern int num_hour;
        extern int pulse_area;
        extern int pulse_mobile;
        extern int pulse_violence;
        extern int autosave_counter;

        sprintf( buf, "%s\n\rBooted at:   %s\rSystem time: %s\r",
         VERSION_STR,  str_boot_time, (char *) ctime( &current_time )  );
        send_to_char( buf, ch );

        sprintf( buf,
 "Temp: %4d  Windspd: %4d  Dir:    %4d  Month: %4d  Hour: %4d  Phase: %4d\n\r"
 "Sky:  %4d  MMHG:    %4d  Change: %4d  Day:   %4d  Year: %4d  Next:  %4d\n\r"
 "Sun:  %4d  NumHour: %4d  Area:   %4d  Mob:   %4d  Fgt:  %4d  Auto:  %4d\n\r",
               weather_info.temperature,   weather_info.windspeed,
               weather_info.winddir %4,    time_info.month,
               time_info.hour,             weather_info.moon_phase,
               weather_info.sky,           weather_info.mmhg,
               weather_info.change,        time_info.day,
               time_info.year,             weather_info.next_phase,
               weather_info.sunlight,      num_hour/60,
               pulse_area,                 pulse_mobile,
               pulse_violence,             autosave_counter );
        send_to_char( buf, ch );
    }

    return;
}



void help_to_char( char *text, CHAR_DATA *ch, bool fPage )
{
   char buf[MAX_STRING_LENGTH];
   const char *str;
   const char *i;
   char *point;

   if( text == NULL || *text == '\0' )
   {
      send_to_char( "\n\r\n\r", ch );
      return;
   }

   point = buf;
   str = text;
   while( *str != '\0' )
   {
      if( *str != '$' )
      {
         *point++ = *str++;
         continue;
      }

      ++str;
      switch( *str )
      {
         default: i = " "; break;
        case '0': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  BLACK;   break;
        case '1': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  BLUE;    break;
        case '2': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  GREEN;   break;
        case '3': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  CYAN;    break;
        case '4': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  RED;     break;
        case '5': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  PURPLE;  break;
        case '6': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  YELLOW;  break;
        case '7': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  GREY;    break;
        case 'B': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  BOLD;    break;
        case 'I': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  INVERSE; break;
        case 'F': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  FLASH;   break;
        case 'N': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  NTEXT;   break;
        case 'n': i = "\n\r"; break;
        case '$': i = "$";    break;
      } 
      ++str;
      while( (*point = *i) != '\0' )
         ++point, ++i;      
   }
   *point = '\0';

   if ( fPage ) page_to_char( buf, ch );
   else         send_to_char( buf, ch );
   return;
}





/*
 * Syntax:  help [keyword]
 */
void do_help( CHAR_DATA *ch, char *argument )
{
    char argall[MAX_INPUT_LENGTH];
    char argone[MAX_INPUT_LENGTH];
    HELP_DATA *pHelp;
    
    if ( ch->desc == NULL ) return;

    if ( argument[0] == '\0' )
	argument = "summary";

    if ( !str_cmp( argument, "index" ) )
    {
        int col = 0;
        bool fFound = FALSE;
        char buf[MAX_STRING_LENGTH];
        char buf2[MAX_STRING_LENGTH];

        buf[0] = '\0';

        sprintf( buf, "Help Index:\n\r" );
        for ( pHelp = help_first; pHelp != NULL; pHelp = pHelp->next )
        {
            col++;

            if ( pHelp->level > get_trust( ch ) )
            continue;

            fFound = TRUE;
            one_argument( pHelp->keyword, buf2 );
            sprintf( buf2, "%-26s", trunc_fit( buf2, 26 ) );
            strcat( buf, buf2 );
            if ( col % 3 == 0 ) strcat( buf, "\n\r" );
        }

        if ( !fFound ) send_to_char( "None.", ch );
        else
        page_to_char( buf, ch );

        return;
    }


    if ( argument[0] == '#' )
    {
        char buf[MAX_STRING_LENGTH];
        bool fFound = FALSE;        
        
        
        argument++;
        if ( *argument == '\0' ) return;

        sprintf( buf, "Related Topics:\n\r" );
        for ( pHelp = help_first; pHelp != NULL; pHelp = pHelp->next )
        {

            if ( pHelp->level > get_trust( ch ) )
            continue;

            if ( strstr( pHelp->text, argument ) )
            {
                if ( !ch->desc || CONNECTED(ch->desc)
                  || ch->desc->connected == CON_DOC_MENU )
                {
                    fFound = TRUE;
                    strcat( buf, pHelp->keyword );
                    strcat( buf, "\n\r" );
                }
            }
        }

        page_to_char( buf, ch );
        if ( !fFound ) page_to_char( "None.", ch );
        return;
    }


    /*
     * Tricky argument handling so 'help a b' doesn't match a.
     */
    argall[0] = '\0';
    while ( argument[0] != '\0' )
    {
	argument = one_argument( argument, argone );
	if ( argall[0] != '\0' )
	    strcat( argall, " " );
	strcat( argall, argone );
    }

    for ( pHelp = help_first; pHelp != NULL; pHelp = pHelp->next )
    {
	if ( pHelp->level > get_trust( ch ) )
	    continue;

        if ( is_prename( argall, pHelp->keyword ) )
        {
            if ( !ch->desc || CONNECTED(ch->desc)
              || ch->desc->connected == CON_DOC_MENU )
            {
                char buf[MAX_STRING_LENGTH];
                
                first_arg( pHelp->keyword, buf, FALSE );
                if ( HAS_ANSI(ch) ) send_to_char( BOLD, ch );
                send_to_char( buf, ch );
                if ( HAS_ANSI(ch) ) send_to_char( NTEXT, ch );
                send_to_char( "\n\r", ch );

                if ( pHelp->text[0] == '.' )
                help_to_char( pHelp->text+1, ch, TRUE );
                else
                help_to_char( pHelp->text  , ch, TRUE );
                return;
            }

            /*
             * Strip leading '.' to allow initial blanks.
             */
            if ( pHelp->text[0] == '.' )
            help_to_char( pHelp->text+1, ch, FALSE );
            else
            help_to_char( pHelp->text  , ch, FALSE );
            return;
        }
    }

    send_to_char( "No help on that word.\n\r", ch );
    return;
}



/*
 * New 'who' command originally by Alander of Rivers of Mud.
 * NEW 'who' command by Locke of The Isles.
 * Syntax:  who
 *          who [number] [number]
 *          who immortal
 */
void do_who( CHAR_DATA *ch, char *argument )
{
    static int max = 0;
    char buf[MAX_STRING_LENGTH];
    DESCRIPTOR_DATA *d;
    extern int num_hour;
    int iLevelLower;
    int iLevelUpper;
    int nNumber;
    int nMatch;
    int gMatch;
    bool fImmortalOnly;

    /*
     * Set default arguments.
     */
    iLevelLower    = 0;
    iLevelUpper    = MAX_LEVEL;
    fImmortalOnly  = FALSE;

    /*
     * Parse arguments.
     */
    nNumber = 0;
    for ( ;; )
    {
	char arg[MAX_STRING_LENGTH];

	argument = one_argument( argument, arg );
	if ( arg[0] == '\0' )
	    break;

	if ( is_number( arg ) )
	{
	    switch ( ++nNumber )
	    {
	    case 1: iLevelLower = atoi( arg ); break;
	    case 2: iLevelUpper = atoi( arg ); break;
	    default:
		send_to_char( "Only two level numbers allowed.\n\r", ch );
		return;
	    }
	}
	else
	{
	    arg[3]    = '\0';
        if ( !str_prefix( arg, "immortal" ) )
	    {
		fImmortalOnly = TRUE;
	    }
        }
    }

    /*
     * Now show matching chars.
     */
    nMatch = 0;
    gMatch = 0;
    buf[0] = '\0';
    for ( d = descriptor_list; d != NULL; d = d->next )
    {
	CHAR_DATA *wch;

	/*
	 * Check for match against restrictions.
	 * Don't use trust as that exposes trusted mortals.
	 */
    if ( !CONNECTED(d) || !can_see( ch, d->character ) )
        continue;

#ifdef NOWHO_BUILDERS
    if ( d->connected != CON_PLAYING && !IS_IMMORTAL(ch) ) continue;
#endif

	wch   = ( d->original != NULL ) ? d->original : d->character;

    if ( IS_NPC(wch) ) continue;

    if ( PC(wch,level) < iLevelLower
        ||   PC(wch,level) > iLevelUpper
        || ( fImmortalOnly  && PC(wch,level) < LEVEL_HERO ) )
	    continue;

        /*
         * Format it up.
         */
         if (IS_HERO(wch) && PC(wch,level) == get_trust( wch ) )
         {
         char doe[MAX_STRING_LENGTH];
         gMatch++;

         if ( d->connected != CON_PLAYING )
              sprintf( doe, " -Editing- " );
         else
         {
         switch ( PC(wch,level) )
         {
                         default: sprintf( doe, " Immortal  " ); break;
                 case LEVEL_HERO: sprintf( doe, " Judge     " ); break;
              case LEVEL_BUILDER: sprintf( doe, " Builder   " ); break;
/*                case LEVEL_DEITY: sprintf( doe, " Designer  " ); break;*/
                case LEVEL_ANGEL: sprintf( doe, " Reviewer  " ); break;
              case LEVEL_SUPREME: sprintf( doe, " Designer  " ); break;
              case LEVEL_DEMIGOD: sprintf( doe, " Producer  " ); break;
                  case MAX_LEVEL: sprintf( doe, " Admin     " ); break;
         }
         }
               sprintf( buf + strlen(buf), "[%11s] ", doe );
               sprintf( doe, PC(wch,constellation), wch->name );
               strcat( buf, doe );
               strcat( buf, "\n\r" );
        }
        else
        {
        nMatch++;
        if (IS_IMMORTAL(ch))
        sprintf( buf + strlen(buf), "[%11s] %s, %s\n\r",
                                    " Mortal    ",  STR(wch,name), NAME(wch) );
        else
        {
/* use for no visible morts in game: */
/*        if ( !CONNECTED(ch->desc) )  */
        sprintf( buf + strlen(buf), "[%11s] %s\n\r", " Mortal    ",  NAME(wch) );
        }
        }
    }

    ansi_color( BOLD, ch );
    send_to_char( buf, ch );
    ansi_color( NTEXT, ch );

    if (nMatch > 0)
    {
        sprintf( buf, "There %s %d visible player%s",
             nMatch > 1 ? "are" : "is",  nMatch,
             nMatch > 1 ? "s" : "" );
        send_to_char( buf, ch );
    }

    if (gMatch > 0 || fImmortalOnly)
    {
        if (nMatch > 0)
        sprintf( buf, " and %d visible god%s", gMatch,
                      gMatch == 1 ? "" : "s" );
        else
        sprintf( buf, "There %s %d visible god%s",
             gMatch > 1 ? "are" : "is",  gMatch,
             gMatch > 1 ? "s" : "" );

        send_to_char( buf, ch );
    }

    max = nMatch + gMatch > max ? nMatch + gMatch : max;
    sprintf( buf, ", with a high of %d.\n\r", max );
    if ( max > 0 ) send_to_char( buf, ch );

    if ( num_hour / (60 * PULSE_PER_SECOND) < 60 )
    {
    sprintf( buf, "Next reboot will occur in %d minute%s.\n\r",
         num_hour / (60 * PULSE_PER_SECOND),
         num_hour / (60 * PULSE_PER_SECOND) != 1 ? "s" : "" );
    }
    else
    {
    sprintf( buf, "Next reboot will occur in %d hour%s.\n\r",
        num_hour / (60 * PULSE_PER_SECOND * 60)+1,
        num_hour / (60 * PULSE_PER_SECOND * 60)+1 != 1 ? "s" : "" );
    }
    send_to_char( buf, ch );
    return;
}



void show_inventory( CHAR_DATA *ch, CHAR_DATA *tch, bool fPeek )
{
    OBJ_DATA *obj;
    bool ShowPockets = FALSE;
    bool ShowNothing = TRUE;
    
    for ( obj = ch->carrying; obj != NULL; obj = obj->next_content )
    {
        if ( fPeek
          && ch != tch
          && !IS_IMMORTAL(tch) 
          && !skill_check( tch, gsn_peek, 50 ) )
        continue;

        if ( !can_see_obj( tch, obj ) )
        continue;
        
        if ( obj->wear_loc == WEAR_NONE )
        ShowPockets = TRUE;
            
        if ( obj->item_type != ITEM_CONTAINER )
        continue;
        
        if ( IS_SET(obj->value[1], CONT_CLOSED) )
        {
            send_to_char( capitalize(STR(obj,short_descr)), ch );
            send_to_char( " is closed.\n\r", ch );
            ShowNothing = FALSE;
            continue;
        }
        
        if ( obj->contains == NULL )
        continue;
        
        ShowNothing = FALSE;
        act( "$p contains:", tch, obj, NULL, TO_CHAR );
        if ( fPeek )
        show_peek_to_char( obj->contains, tch, TRUE, TRUE, LEARNED(tch,gsn_peek) );
        else
        show_list_to_char( obj->contains, tch, TRUE, TRUE );
    }
    
    if ( !ShowPockets )
    {
    if ( ShowNothing )
    act( "$E $t carrying nothing of note.", 
         tch, tch == ch ? "are" : "is", ch, TO_CHAR );
    return;
    }

    act( "Tucked away in the folds of $S clothing is:", 
         tch, NULL, ch, TO_CHAR );

    if ( fPeek )
    show_peek_to_char( ch->carrying, tch, TRUE, TRUE, LEARNED(tch,gsn_peek) );
    else
    show_list_to_char( ch->carrying, tch, TRUE, TRUE );
    return;
}




/*
 * Syntax:  inventory
 */
void do_inventory( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    OBJ_DATA *h;

    show_inventory( ch, ch, FALSE );
    if ( ch->riding )
    {
        send_to_char( "Your steed:\n\r", ch );
        show_inventory( ch->riding, ch, FALSE );
    }

    h = get_eq_char( ch, WEAR_HOLD_1 );
    if ( h == NULL ) h = get_eq_char( ch, WEAR_WIELD_1 );
    if ( h != NULL )
    {
        sprintf( buf, (get_eq_char( ch, WEAR_WIELD_2 ) == NULL) 
                   && (get_eq_char( ch, WEAR_HOLD_2 )  == NULL) ?
                     "You %s %s in your hands.\n\r"             :
                     "You %s %s in your primary hand.\n\r",
                 h->wear_loc ==  WEAR_HOLD_1 ? "hold" : "wield",
                 PERSO(h, ch) );
        send_to_char( buf, ch );
    }

    h = get_eq_char( ch, WEAR_HOLD_2 );
    if ( h == NULL ) h = get_eq_char( ch, WEAR_WIELD_2 );
    if ( h != NULL )
    {
        sprintf( buf, "In your secondary hand, you %s %s.\n\r",
                 h->wear_loc ==  WEAR_HOLD_2 ? "hold" : "wield",
                 PERSO(h, ch) );
        send_to_char( buf, ch );
    }
    return;
}


void show_belt( CHAR_DATA *victim, CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];
    OBJ_DATA *obj;
    int belt;

    buf[0] = '\0';

    for ( belt = WEAR_BELT_1;  belt < WEAR_BELT_5; belt++ )
    {
        if ( (obj = get_eq_char( victim, belt )) == NULL )
        continue;

        strcat( buf, "   " );
        strcat( buf, PERSO(obj, ch) );
        strcat( buf, "\n\r" );
    }

    if ( buf[0] != '\0' )
    {
        act( "From $N's belt hangs:", ch, NULL, victim, TO_CHAR );
        send_to_char( buf, ch );
    }
    return;
}



/*
 * Syntax:  peek [person]
 */
void do_peek( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    
    one_argument( argument, arg );
    
    if ( arg[0] == '\0' || (victim = get_char_room( ch, arg )) == NULL )
    {
        send_to_char( "Peek into whose inventory?\n\r", ch );
        return;
    }

    if ( !skill_check( ch, gsn_peek, 0 ) )
    {
        act( "$n is caught peeking at $N's inventory!", ch, NULL, victim, TO_NOTVICT );
        act( "You catch $n peeking at your inventory!", ch, NULL, victim, TO_VICT );
        send_to_char( "You were caught!\n\r", ch );
    }

    show_inventory( victim, ch, TRUE );
    show_belt( victim, ch );
    return;
}



/*
 * Syntax:  equipment
 */
void do_equipment( CHAR_DATA *ch, char *argument )
{
    show_equipment_table( ch, ch );
    return;
}




/*
 * Syntax:  compare [object] [object]
 */
void do_compare( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *obj1;
    OBJ_DATA *obj2;
    int value1;
    int value2;
    char *msg;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    if ( arg1[0] == '\0' )
    {
	send_to_char( "Compare what to what?\n\r", ch );
	return;
    }

    if ( ( obj1 = get_obj_inv( ch, arg1 ) ) == NULL )
    {
	send_to_char( "You do not have that item.\n\r", ch );
	return;
    }

    if ( arg2[0] == '\0' )
    {
	for ( obj2 = ch->carrying; obj2 != NULL; obj2 = obj2->next_content )
	{
	    if ( obj2->wear_loc != WEAR_NONE
	    &&   can_see_obj( ch, obj2 )
	    &&   obj1->item_type == obj2->item_type
	    && ( obj1->wear_flags & obj2->wear_flags & ~ITEM_TAKE) != 0 )
		break;
	}

	if ( obj2 == NULL )
	{
	    send_to_char( "You aren't wearing anything comparable.\n\r", ch );
	    return;
	}
    }
    else
    {
    if ( ( obj2 = get_obj_inv( ch, arg2 ) ) == NULL )
	{
	    send_to_char( "You do not have that item.\n\r", ch );
	    return;
	}
    }
	    
    msg		= NULL;
    value1	= 0;
    value2	= 0;

    if ( obj1 == obj2 )
    msg = "You compare $p to itself.  It looks about the same.";
    else
    if ( obj1->item_type == obj2->item_type )
    {
       switch ( obj1->item_type )
       {
       default:
           msg = "You can't compare $p and $P.";
           break;

       case ITEM_GEM:
           value1 = obj1->value[1];
           value2 = obj2->value[1];
           if ( obj1->value[0] != obj2->value[0] )
           msg = "You can't compare those gems; they are of a different element.";
           break;

       case ITEM_ARMOR:
           value1 = obj1->value[0] / 2;
           value2 = obj2->value[0] / 2;
           break;

       case ITEM_WEAPON:
           value1 = obj1->value[1] + obj1->value[2] / 2;
           value2 = obj2->value[1] + obj2->value[2] / 2;
           break;
       }
    }

    if ( msg == NULL )
    {
	     if ( value1 == value2 ) msg = "$p and $P look about the same.";
	else if ( value1  > value2 ) msg = "$p looks better than $P.";
	else                         msg = "$p looks worse than $P.";
    }

    act( msg, ch, obj1, obj2, TO_CHAR );

    value1 = obj1->weight - obj2->weight;

         if ( value1 == 0 ) msg = NULL;
    else if ( value1 >  3 ) msg = "$p is heavier than $P.";
    else if ( value1 >  0 ) msg = "$p is slightly heavier than $P.";
    else if ( value1 > -3 ) msg = "$P is slightly heavier than $p.";
    else                    msg = "$P is heavier than $p.";

    if ( msg != NULL )     act( msg, ch, obj1, obj2, TO_CHAR );
    return;
}




/*
 * Syntax:  credits
 */
void do_credits( CHAR_DATA *ch, char *argument )
{
    do_help( ch, "nimud" );
    return;
}




/*
 * Syntax:  consider [person]
 */
void do_consider( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    char *buf = '\0';
    int hp;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Consider killing whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, arg ) ) == NULL )
    {
	send_to_char( "They're not here.\n\r", ch );
	return;
    }

    sprintf( arg, "$E is " );
     if ( victim->bounty <    70 ) strcat( arg, "a protected citizen.\n\r" );
else if ( victim->bounty <   500 ) strcat( arg, "an untrustworthy thief.\n\r" );
else if ( victim->bounty <  1000 ) strcat( arg, "considered a criminal.\n\r" );
else if ( victim->bounty < 10000 ) strcat( arg, "a fugitive from justice.\n\r" );
else                               strcat( arg, "a feared outlaw.\n\r" );
    act( arg, ch, NULL, victim, TO_CHAR );

    hp     = ch->hit - victim->hit;

 if ( hp >=  80 ) buf = "You are much healthier than $E.";
 if ( hp <=  60 ) buf = "You are healthier than $E.";
 if ( hp <=  30 ) buf = "You are a bit healthier than $E.";
 if ( hp <=   5 ) buf = "You are a slight bit healthier than $E.";
 if ( hp <=   0 ) buf = "$E is a slight bit healthier than you.";
 if ( hp <= -10 ) buf = "$E is a bit healthier than you.";
 if ( hp <= -30 ) buf = "$E is healthier than you.";
 if ( hp <= -80 ) buf = "$E is much healthier than you.";

    act( buf, ch, NULL, victim, TO_CHAR );
    return;
}




/*
 * Syntax:  report
 */
void do_report( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_INPUT_LENGTH];

    sprintf( buf, "You report that you are %s and %s.\n\r",
                  STRING_HITS(ch), STRING_MOVES(ch)  );
    send_to_char( buf, ch );

    sprintf( buf, "$n reports that $e is %s and %s.",
                  STRING_HITS(ch), STRING_MOVES(ch) );
    act( buf, ch, NULL, NULL, TO_ROOM );

    return;
}




/*
 * Syntax:  socials
 */
void do_socials( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    int iSocial;
    int col;
 
    col = 0;
    for ( iSocial = 0; social_table[iSocial].name[0] != '\0'; iSocial++ )
    {
	sprintf( buf, "%-12s", social_table[iSocial].name );
	send_to_char( buf, ch );
	if ( ++col % 6 == 0 )
	    send_to_char( "\n\r", ch );
    }
 
    if ( col % 6 != 0 )
	send_to_char( "\n\r", ch );
    return;
}



/*
 * Contributed by Alander.
 * Syntax:  commands
 */
void do_commands( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    int cmd;
    int col;
 
    col = 0;
    for ( cmd = 0; cmd_table[cmd].name[0] != '\0'; cmd++ )
    {
        if ( cmd_table[cmd].level <  LEVEL_HERO
        &&   cmd_table[cmd].level <= get_trust( ch )
        &&   cmd_table[cmd].level >=  0
        &&   cmd_table[cmd].position >= POS_DEAD )
	{
	    sprintf( buf, "%-12s", cmd_table[cmd].name );
	    send_to_char( buf, ch );
	    if ( ++col % 6 == 0 )
		send_to_char( "\n\r", ch );
	}
    }
 
    if ( col % 6 != 0 )
	send_to_char( "\n\r", ch );
    return;
}




void do_wizlist ( CHAR_DATA *ch, char *argument )
{

    do_help ( ch, "wizlist" );
    return;

}




