/****************************************************************************
 ****************************************************************************
 * Locke's   __ -based on merc v2.2-____        NIM Server Software         *
 * ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION    *
 * |  /   \  __|  \__/  |  | |  |     O|        documentation release       *
 * |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999           *
 * |    |  ||  |  |__|  |       |     D|                                    *
 * |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud  *
 *   n a m e l e s s i n c a r n a t e          dedicated to chris cool     *
 ****************************************************************************
 *                                                                          *
 *      This is the server software for The Isles, called NiMUD 4.0.        *
 *    Copyright (c) 1994-1999 by Herb Gilliland.  All rights reserved.      *
 *                                                                          *
 *  Much time and thought has gone into this software and you are           *
 *  benefitting.  We hope that you share your changes too.  What goes       *
 *  around, comes around.                                                   *
 *                                                                          *
 ****************************************************************************
 *   Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *   Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 ****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "script.h"
#include "skills.h"

char *	const	dir_name	[]		=
{
    "north", "east", "south", "west", "up", "down", 
    "northwest", "northeast", "southwest", "southeast"
};

char *  const   dir_rev     []      =
{
    "the south", "the west", "the north", "the east", "below", "above",
    "the southeast", "the southwest", "the northeast", "the northwest"
};

char *  const   dir_letter     []      =
{
    "n", "e", "s", "w", "u", "d", "Nw", "Ne", "Sw", "Se"
};

const   sh_int  rev_dir     []      =
{
    DIR_SOUTH,
    DIR_WEST,
    DIR_NORTH,
    DIR_EAST,
    DIR_DOWN,
    DIR_UP,
    DIR_SE,
    DIR_SW,
    DIR_NE,
    DIR_NW   
};

const	sh_int	movement_loss	[SECT_MAX]	=
{
    1,   /* SECT_INSIDE       */
    1,   /* SECT_CITY         */
    2,   /* SECT_FIELD        */
    4,   /* SECT_FOREST       */
    5,   /* SECT_HILLS        */
    8,   /* SECT_MOUNTAIN     */
    4,   /* SECT_WATER_SWIM   */
    1,   /* SECT_WATER_NOSWIM */
    6,   /* SECT_UNDERWATER   */
   10,   /* SECT_AIR          */
    6,   /* SECT_DESERT       */
   10,   /* SECT_ICELAND      */
    5    /* SECT_CLIMB        */
};


void flee( CHAR_DATA *ch, CHAR_DATA *fighting, int d );



void hide_check( CHAR_DATA *ch, ROOM_INDEX_DATA *in_room )
{
    CHAR_DATA *rch;

    if ( !IS_AFFECTED(ch,AFF_HIDE) )
    return;

    for ( rch = in_room->people;  rch != NULL;  rch = rch->next_in_room )
    {
        if ( rch == ch ) continue;

        if ( skill_check( rch, gsn_hide, 25 ) )
        {
            act( "You notice $N trying to hide $S presence.", rch, NULL, ch, TO_CHAR );
            if ( skill_check( ch, gsn_hide, 25 ) )
            {
            act( "$N notices you trying to hide your presence.", ch, NULL, rch, TO_CHAR );
            }
        }
    }

    return;
}



/*
 * Do flee checks.
void flee( CHAR_DATA *ch, CHAR_DATA *fighting, int d )
{
    CHAR_DATA *fch;
    int penalty = 0, fdex, chdex, chstr, fstr;


    chdex = number_range( 0, get_curr_dex(ch) );
    fdex  = number_range( 0, get_curr_dex(fighting) );

    chstr = number_range( 0, get_curr_str(ch) );
    fstr  = number_range( 0, get_curr_str(fighting) );

    for( fch = ch->in_room->people; fch != NULL; fch = fch->next_in_room )
    {
        if ( fch->fighting != ch ) continue;

        penalty++;
        if ( chdex < fdex - (fch == fighting ? -1 : penalty) )
        {
            act( "You attack $N as $E turns to run!", fch, NULL, ch, TO_CHAR );
            act( "$n attacks you as you turn to run!", fch, NULL, ch, TO_VICT );
            act( "$n attacks $N as $e turns to run!", fch, NULL, ch, TO_NOTVICT );
            fch->fbits = 0;
            oroc( fch, ch );
        }
        else
        if ( chstr < fstr - penalty
          || skill_check( ch, gsn_flee, 0 ) )
        {
            act( "$N block$V $n as $e tries to escape $t!",
                 ch, dir_name[d], fch, TO_ALL );
            return;
        }
    }

    stop_fighting( ch, TRUE );
    ch->position = POS_FIGHTING;
}
 */


void leave_strings( CHAR_DATA *ch, OBJ_DATA *obj, int sect, int door )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *fch;
    CHAR_DATA *fch_next;

    if ( ch->position == POS_FIGHTING )
    sprintf( buf, "You turn tail and flee %s", dir_name[door] );
    else
    if ( obj != NULL )
        sprintf( buf, "You use %s to %s %s",
                      can_see_obj( ch, obj ) ? STR(obj, short_descr) : "something",
                      sect == SECT_MOUNTAIN       ? "climb" :
                      sect == SECT_CLIMB         ? "climb" :
                      sect == SECT_WATER_NOSWIM   ? "sail" :
                      sect == SECT_AIR            ? "fly" :
                      sect == SECT_UNDERWATER     ? "dive" : "move",
                      dir_name[door] );
    else
    if ( ch->rider != NULL )
        sprintf( buf, "You wander %s, rode by %s", dir_name[door],
                         PERS(ch->rider, ch) );
    else
    if ( ch->riding != NULL )
        sprintf( buf, "You ride %s %s", PERS(ch->riding, ch),
                         dir_name[door] );
    else
    if ( IS_AFFECTED(ch, AFF_FLYING) )
        sprintf( buf, "You fly %s", dir_name[door] );
    else
    if ( IS_AFFECTED(ch, AFF_SNEAK) )
        sprintf( buf, "You try to sneak %s", dir_name[door] );
    else
    if ( sect == SECT_WATER_SWIM || sect == SECT_UNDERWATER )
        sprintf( buf, "You swim %s", dir_name[door] );
    else
    if ( sect == SECT_CLIMB )
        sprintf( buf, "You climb %s", dir_name[door] );
    else
    if ( ch->hitched_to == NULL )
        sprintf( buf, "You walk %s",  dir_name[door] );
    else
    if ( ch->position == POS_STANDING )
        sprintf( buf, "You drag %s %s",
                      PERSO(ch->hitched_to, ch),
                      dir_name[door] );

    buf[0] = UPPER(buf[0]);
    send_to_char( buf, ch );

    if ( ch->in_room->exit[door]
      && !MTD(ch->in_room->exit[door]->keyword) )
    {
        send_to_char( " through a", ch );
        send_to_char( IS_VOWEL(ch->in_room->exit[door]->keyword[0]) ? "n " : " ", ch );
        send_to_char( ch->in_room->exit[door]->keyword, ch );
    }
    send_to_char( ch->position == POS_FIGHTING ? "!\n\r" : ".\n\r", ch );

    for ( fch = ch->in_room->people; fch != NULL; fch = fch_next )
    {
        fch_next = fch->next_in_room;

        if ( ch == fch
          || ch->riding == fch
          || ch->rider == fch)
        continue;

        if ( !can_see( fch, ch )
          || !IS_AWAKE(fch) )
        continue;

        if ( ch->rider != NULL )
        break;

        if ( ch->position == POS_FIGHTING )
         sprintf( buf, "%s turns and flees %s", PERS(ch, fch), dir_name[door] );
   else if ( obj != NULL )
        sprintf( buf, "%s uses %s to %s %s",
                      PERS(ch, fch),
                      can_see_obj(fch, obj) ? STR(obj, short_descr) : "something",
                      sect == SECT_MOUNTAIN ? "climb" :
                      sect == SECT_WATER_NOSWIM ? "sail" :
                      sect == SECT_AIR ? "fly" :
                      sect == SECT_UNDERWATER ? "dive" : "move",
                      dir_name[door] );
   else if ( ch->riding != NULL &&
        (can_see(fch, ch) || can_see(fch, ch->riding)) )
        {
        if ( ch->riding->hitched_to != NULL )
        {
              sprintf( buf, "%s rides %s upon %s, pulling %s behind them",
                            PERS(ch, fch), dir_name[door],
                            PERS(ch->riding, fch),
                            PERSO(ch->riding->hitched_to, fch) );
        }
        else
        {
              sprintf( buf, "%s rides %s %s", PERS(ch, fch),
                            PERS(ch->riding, fch), dir_name[door] );
        }
        }
   else if ( IS_AFFECTED(ch, AFF_FLYING) && can_see(fch, ch) )
           sprintf( buf, "%s flies %s", PERS(ch, fch), dir_name[door] );
   else if ( IS_AFFECTED(ch, AFF_SNEAK) )
        {
            if ( IS_SET(fch->act2, WIZ_HOLYLIGHT)
              || skill_check(fch, gsn_sneak, 25) )
           sprintf( buf, "%s tries to sneak %s", PERS(ch, fch), dir_name[door] );
           else buf[0] = '\0';
        }
   else if ( sect == SECT_WATER_SWIM || sect == SECT_UNDERWATER )
         sprintf( buf, "%s swims %s",  PERS(ch, fch), dir_name[door] );
   else if ( sect == SECT_CLIMB )
            sprintf( buf, "%s climbs %s",  PERS(ch, fch), dir_name[door] );
   else if ( ch->position == POS_STANDING )
        {
        if ( ch->hitched_to == NULL || !can_see_obj(fch, ch->hitched_to) )
        sprintf( buf, "%s walks %s",  PERS(ch, fch), dir_name[door] );
   else sprintf( buf, "%s walks %s dragging %s",
                      PERS(ch, fch), dir_name[door],
                      STR(ch->hitched_to,short_descr) );
        }

        buf[0] = UPPER(buf[0]);
        send_to_char( buf, fch );
        if ( buf[0] != '\0' )
        {
            if ( ch->in_room->exit[door]
             && !MTD(ch->in_room->exit[door]->keyword) )
            {
                send_to_char( " through a", fch );
                send_to_char( IS_VOWEL(ch->in_room->exit[door]->keyword[0]) ? "n " : " ", fch );
                send_to_char( ch->in_room->exit[door]->keyword, fch );
            }
            send_to_char( ch->position == POS_FIGHTING ? "!\n\r" : ".\n\r", fch );
        }

        sprintf( buf, "%d", door );
        if (script_update( fch, TYPE_MOB, TRIG_MOVES, ch, NULL, buf, NULL ) == 2)
        return;
    }
}


void arrive_strings( CHAR_DATA *ch, OBJ_DATA *obj, int sect, int door )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *fch;
    CHAR_DATA *fch_next;

    for ( fch = ch->in_room->people; fch != NULL; fch = fch_next )
    {
        fch_next = fch->next_in_room;

        if (ch == fch
         || ch->riding == fch
         || ch->rider == fch)
        continue;

        if ( !can_see( fch, ch )
          || !IS_AWAKE(fch) )
        continue;

        if ( ch->rider != NULL )
        break;

        if ( ch->position == POS_FIGHTING )
        sprintf( buf, "%s flees from %s", PERS(ch, fch), dir_rev[door] );
   else if ( obj != NULL )
        sprintf( buf, "%s uses %s to %s %s",
                 PERS(ch, fch),
                 PERSO(obj, fch),
                 sect == SECT_MOUNTAIN     ? "climb" :
                 sect == SECT_WATER_NOSWIM ? "sail" :
                 sect == SECT_AIR          ? "fly" :
                 sect == SECT_UNDERWATER   ? "dive" : "move",
                 dir_name[door] );
   else if ( ch->riding != NULL )
        sprintf( buf, "%s rides %s in from %s", PERS(ch, fch),
                 PERS(ch->riding, fch), dir_rev[door] );
   else if ( IS_AFFECTED(ch, AFF_FLYING) )
        sprintf( buf, "%s flies in from %s", PERS(ch, fch), dir_rev[door] );
   else if ( IS_AFFECTED(ch, AFF_SNEAK) && skill_check( fch, gsn_sneak, 75 ) )
        {
        if ( IS_SET(fch->act2, WIZ_HOLYLIGHT)
          || skill_check( fch, gsn_sneak, 25 ) )
        sprintf( buf, "%s tries to sneak in from %s", PERS(ch, fch), dir_rev[door] );
        else buf[0] = '\0';
        }
   else if ( sect == SECT_WATER_SWIM || sect == SECT_UNDERWATER )
        sprintf( buf, "%s swims in from %s",  PERS(ch, fch), dir_rev[door] );
   else if ( sect == SECT_CLIMB )
        sprintf( buf, "%s climbs in from %s",  PERS(ch, fch), dir_rev[door] );
   else if ( ch->position == POS_STANDING )
    {
        if ( ch->hitched_to == NULL || !can_see_obj(fch, ch->hitched_to) )
        sprintf( buf, "%s walks in from %s",  PERS(ch, fch), dir_rev[door] );
   else sprintf( buf, "%s walks in from %s dragging %s",
                 PERS(ch, fch), dir_rev[door],
                 STR(ch->hitched_to,short_descr) );
    }

        buf[0] = UPPER(buf[0]);
        send_to_char( buf, fch );
        if ( buf[0] != '\0' )
        {
            if ( ch->in_room->exit[rev_dir[door]]
              && !MTD(ch->in_room->exit[rev_dir[door]]->keyword) )
            {
                send_to_char( " through a", fch );
                send_to_char( IS_VOWEL(ch->in_room->exit[rev_dir[door]]->keyword[0]) ? "n " : " ", fch );
                send_to_char( ch->in_room->exit[rev_dir[door]]->keyword, fch );
            }
            send_to_char( ch->position == POS_FIGHTING ? "!\n\r" : ".\n\r", fch );
        }

        sprintf( buf, "%d", rev_dir[door] );
        script_update( fch, TYPE_MOB, TRIG_ENTER, ch, NULL, buf, NULL );
    }
}



bool lose_movement( CHAR_DATA *ch, ROOM_INDEX_DATA *in_room,
                    ROOM_INDEX_DATA *to_room )
{
    int move;

	move = movement_loss[UMIN(SECT_MAX-1, in_room->sector_type)]
         + movement_loss[UMIN(SECT_MAX-1, to_room->sector_type)]
         ;

    if ( move <= 0 ) move = 1;

    if ( ch->riding )
	{
        if ( ch->riding->hitched_to != NULL )
        move += get_obj_weight( ch->riding->hitched_to ) / 4;

        if ( ch->riding->move < move )
        {
            send_to_char( "Your mount is too exhausted.\n\r", ch );
            return FALSE;
        }
	}

    if ( ch->hitched_to != NULL )
    move += get_obj_weight( ch->hitched_to ) / 4;

    if ( ch->riding )   move -= get_curr_con(ch->riding)/2;

    if ( ch->move < move )
	{
	    send_to_char( "You are too exhausted.\n\r", ch );
        return FALSE;
	}

    ch->move -= move;
    return TRUE;
}



bool check_move( CHAR_DATA *ch, int door, int depth, ROOM_INDEX_DATA *in_room,
                 ROOM_INDEX_DATA *to_room, OBJ_DATA **obj )
{
    bool found, fRiding = ch->riding != NULL;
    int sect;
    EXIT_DATA *pexit;
    OBJ_DATA *fobj = NULL;

    /*
     * Dragging -- rider.
     */
    if ( ch->hitched_to != NULL
      && !IS_SET(ch->hitched_to->wear_flags, ITEM_TAKE) )
    {
        act( "You can't budge $p.", ch, ch->hitched_to, NULL, TO_CHAR );
        act( "$N tries to pull $p $T away and fails.", ch, ch->hitched_to, dir_name[door], TO_ROOM );
        return FALSE;
    }

    if ( ch->hitched_to != NULL
      && get_obj_weight( ch->hitched_to ) > can_carry_w( ch ) * 2 )
    {
        act( "You can't budge $p.", ch, ch->hitched_to, NULL, TO_CHAR );
        act( "$N tries to pull $p $T away and fails.", ch, ch->hitched_to, dir_name[door], TO_ROOM );
        return FALSE;
    }

    /*
     * Holding.
     */
    if ( IS_AFFECTED(ch, AFF_HOLD) && depth == 0 )
    {
        send_to_char( "You can't move.\n\r", ch );
        return FALSE;
    }

    if ( (fRiding && IS_AFFECTED(ch->riding, AFF_HOLD)) && depth == 0  )
    {
        send_to_char( "Your ride can't move.\n\r", ch );
        return FALSE;
    }

    in_room = ch->in_room;
    if ( ( pexit   = in_room->exit[door] ) == NULL
      || ( to_room = pexit->to_room      ) == NULL )
    {
    send_to_char( "You cannot go that way.\n\r", ch );
    return FALSE;
    }

    if ( IS_SET(pexit->exit_info, EX_CLOSED)
      && !IS_AFFECTED(ch, AFF_PASS_DOOR) )
    {
        if ( !IS_SET(pexit->exit_info, EX_SECRET) || IS_IMMORTAL(ch) )
        {
            if ( room_is_dark( in_room ) )
            {
                act( "In the darkness, $n stumbles into a closed $T.",ch,NULL,pexit->keyword,TO_ROOM);
                act( "In the darkness, you bump into a closed $T.",ch,NULL,pexit->keyword,TO_CHAR );
            }
            else
            act( "The $T is closed.", ch, NULL, pexit->keyword, TO_CHAR );
        }
        else send_to_char( "You cannot go that way.\n\r", ch );

        if ( !IS_IMMORTAL(ch) ) 
        return FALSE;
    }

    if ( IS_SET(pexit->exit_info, EX_WINDOW) )
    {
        send_to_char( "You cannot go that way.\n\r", ch );
        return FALSE;
    }

    if ( IS_AFFECTED(ch, AFF_CHARM)
      && ch->master != NULL
      && in_room == ch->master->in_room )
    {
    send_to_char( "And leave your beloved master?\n\r", ch );
    return FALSE;
    }

    if ( fRiding && ch->riding->position < POS_STANDING )
    {
        send_to_char( "Your ride doesn't want to move right now.\n\r", ch );
        return FALSE;
    }

    if ( room_is_private( to_room ) )
    {
    send_to_char( "You can't enter that room right now.\n\r", ch );
    return FALSE;
    }

    sect = to_room->sector_type;

    /*
     * Look for a movement device (not really a vehicle).
     */
    found = FALSE;
    for ( fobj = ch->carrying; fobj != NULL;  fobj = fobj->next_content )
    {
    if ( fobj->item_type == ITEM_VEHICLE )
    {
        int t;

        for ( t = 0; t < 4; t++ )
        {
            if (fobj->value[t] == sect)
            {
                found = TRUE;
                break;
            }
        }
        if ( found ) break;
    }
    }
    
    if ( IS_NPC(ch) && IS_SET(ch->act, ACT_PET) ) found = FALSE;

    if ( sect == SECT_INSIDE
      || sect == SECT_CITY
      || sect == SECT_FIELD
      || sect == SECT_FOREST
      || sect == SECT_HILLS )
    {
    fobj = NULL;
    found = TRUE;
    }
    else
    if ( fobj == NULL )
    {
    if ( sect == SECT_WATER_SWIM && !IS_AFFECTED( ch, AFF_FLYING ) )
    {
        fobj = NULL;
        found = TRUE;
        if ( ch->rider != NULL || ch->riding != NULL )
        {
            send_to_char( "You can't swim while riding.\n\r", ch );
            return FALSE;
        }

        if ( !skill_check( ch, gsn_swimming, 2 )
          && !IS_AFFECTED( ch, AFF_BREATHING ) )
        {
            damage( ch, ch, number_fuzzy( 5 ) );
            send_to_char( "You gurgle as water laps into your face.\n\r", ch );
            act( "$n gurgles as $e takes a lung full of water.\n\r", ch, NULL, NULL, TO_ROOM );
            return FALSE;
        }
    }
    else
    if ( sect == SECT_CLIMB && !IS_AFFECTED( ch, AFF_FLYING ) )
    {
        int multiplier;

        fobj = NULL;
        found = TRUE;
        if ( fRiding )
        {
            send_to_char( "You can't climb while riding.\n\r", ch );
            return FALSE;
        }

        if ( hand_empty( ch ) == WEAR_NONE )
        {
            send_to_char( "You need atleast one free hand to climb.\n\r", ch );
            return FALSE;
        }

        if ( get_eq_char( ch, WEAR_HOLD_1 ) != NULL
          || get_eq_char( ch, WEAR_HOLD_2 ) != NULL )
            multiplier = 50;
       else multiplier = 0;


        if ( !skill_check( ch, gsn_climb, multiplier ) )
        {
            if ( !skill_check( ch, gsn_climb, multiplier ) )
            {
            SET_BIT( ch->affected_by, AFF_FALLING );
            send_to_char( "You lose your grip.\n\r", ch );
            }
            else
            {
            send_to_char( "Your hold slips and you nearly fall!\n\r", ch );
            act( "$n's hold slips!", ch, NULL, NULL, TO_ROOM );
            }
            return FALSE;
        }
    }
    }
            
    if ( !found        /* no vehicle */
    && ((sect == SECT_MOUNTAIN && !IS_AFFECTED(ch, AFF_FLYING) )
     || (sect == SECT_AIR       && !IS_AFFECTED(ch, AFF_FLYING) )
     || (sect == SECT_AIR       && fRiding
                                && !IS_AFFECTED(ch->riding, AFF_FLYING) )
     || (sect == SECT_UNDERWATER   && !IS_AFFECTED(ch, AFF_BREATHING) )
     || (sect == SECT_WATER_NOSWIM && !IS_AFFECTED(ch, AFF_FLYING) ))     )
    {
        char buf[MAX_STRING_LENGTH];
            
        switch( sect )
        {
               default: sprintf( buf, "You need another form of transportation to go there\n\r" ); break;
  case SECT_UNDERWATER: sprintf( buf, "You can't hold your breath for long enough.\n\r" ); break;
    case SECT_MOUNTAIN: sprintf( buf, "Its too steep for you to climb unaided.\n\r" ); break;
case SECT_WATER_NOSWIM: sprintf( buf, "You need a boat to go there.\n\r" ); break;
         case SECT_AIR: sprintf( buf, "You can't fly!\n\r" ); break;
        }
            
        send_to_char( buf, ch );
        return FALSE;
    }
      /* End cant move checks */

    *obj = fobj;
    return TRUE;
}



void move_char( CHAR_DATA *ch, int door )
{
    static int depth = 0;
    ROOM_INDEX_DATA *in_room;
    ROOM_INDEX_DATA *to_room;
    OBJ_DATA *obj;
    char buf[MAX_STRING_LENGTH];
    int sect;
    
    if ( door < 0 || door >= MAX_DIR )
    {
	bug( "Do_move: bad door %d.", door );
	return;
    }

    /*
     * Fleeing
     */
    if ( ch->fighting != NULL )
    {
        flee( ch, ch->fighting, door );
        if ( ch->fighting != NULL )
        return;
    }


    /*
     * Blind staggering -- rider or mount.
     */
    if ( IS_AFFECTED(ch, AFF_BLIND)
      || (ch->riding
       && IS_AFFECTED(ch->riding, AFF_BLIND)
       && skill_check(ch, gsn_riding, 50)) )
    {
        if ( door != DIR_UP && door != DIR_DOWN )
        door = depth != 0 ? door : number_fuzzy( door );

        if ( door == DIR_UP || door == DIR_DOWN )
        door = number_range( 0, DIR_NW );
    }

    in_room = ch->in_room;
    to_room = in_room->exit[door] ? in_room->exit[door]->to_room : NULL;

    if ( !check_move(ch, door, depth, in_room, to_room, &obj) )
    return;

    sect = to_room->sector_type;

    /*
     * Exhaustion.
     */
    if ( !lose_movement(ch, in_room, to_room) )
    return;

    WAIT_STATE( ch, 2 );

    sprintf( buf, "%d", door );
    if (script_update( ch->in_room, TYPE_ROOM, TRIG_MOVES, ch, NULL, buf, NULL ) == 2)
    return;

    leave_strings( ch, obj, sect, door );

    char_from_room( ch );
    char_to_room( ch, to_room );

    arrive_strings( ch, obj, sect, door );
    hide_check( ch, to_room );

    if (script_update( to_room, TYPE_ROOM, TRIG_ENTER, ch, NULL, buf, NULL ) == 2)
    return;

    if ( ch->hitched_to != NULL )
    {
        obj_from_room( ch->hitched_to );
        obj_to_room( ch->hitched_to, to_room );
    }

    /*
     * Guard against rider-mount inconsistencies.
     */
    if ( ch->riding != NULL
      && ch->in_room != ch->riding->in_room
      && depth == 0 )
    {
        depth++;
        move_char( ch->riding, door );
        if ( ch->riding->in_room != ch->in_room )
        {
        ch->riding->rider = NULL;
        ch->riding = NULL;
        send_to_char( "You are forced to leave your mount behind.\n\r", ch );
        }
        depth--;
    }
    else
    if ( ch->rider != NULL
      && ch->in_room != ch->rider->in_room
      && depth == 0 )
    {
        depth++;
        move_char( ch->rider, door );
        if ( ch->rider->in_room != ch->in_room )
        {
        ch->rider->riding = NULL;
        ch->rider = NULL;
        send_to_char( "You are forced to leave your rider behind.\n\r", ch );
        }
        depth--;
    }


    do_look( ch, "auto" );

    if ( !MTD(ch->hunting) )
    do_track( ch, "continue" );

    {
        CHAR_DATA *fch;
        CHAR_DATA *fch_next;

        for ( fch = in_room->people; fch != NULL; fch = fch_next )
        {
            fch_next = fch->next_in_room;

            if ( fch->master == ch && fch->position == POS_STANDING )
            {
            act( "You follow $N $t.", fch, dir_name[door], ch, TO_CHAR );
            move_char( fch, door );
            }
            else
            if ( obj && fch->furniture == obj && fch->in_room != obj->in_room )
            {
            act( "$p moves $t.", fch, obj, dir_name[door], TO_CHAR );
            move_char( fch, door );
            }
        }
    }

/*    if ( IS_SET(ch->in_room->room_flags, ROOM_GENERATED) )*/
/*    gen_room( ch->in_room );  */

    if ( ch->position == POS_FIGHTING ) ch->position = POS_STANDING;
    return;
}





void do_north ( CHAR_DATA *ch, char *argument ) { move_char( ch, DIR_NORTH ); return; }
void do_east  ( CHAR_DATA *ch, char *argument ) { move_char( ch, DIR_EAST );  return; }
void do_south ( CHAR_DATA *ch, char *argument ) { move_char( ch, DIR_SOUTH ); return; }
void do_west  ( CHAR_DATA *ch, char *argument ) { move_char( ch, DIR_WEST );  return; }
void do_up    ( CHAR_DATA *ch, char *argument ) { move_char( ch, DIR_UP );    return; }
void do_down  ( CHAR_DATA *ch, char *argument ) { move_char( ch, DIR_DOWN );  return; }
void do_nw    ( CHAR_DATA *ch, char *argument ) { move_char( ch, DIR_NW );    return; }
void do_ne    ( CHAR_DATA *ch, char *argument ) { move_char( ch, DIR_NE );    return; }
void do_sw    ( CHAR_DATA *ch, char *argument ) { move_char( ch, DIR_SW );    return; }
void do_se    ( CHAR_DATA *ch, char *argument ) { move_char( ch, DIR_SE );    return; }




/*
 * Syntax:  drag [object] [direction]
 */
void do_drag( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_STRING_LENGTH];
    char arg2[MAX_STRING_LENGTH];
    CHAR_DATA *mob;
    OBJ_DATA *obj;
    int door;
    
    argument = one_argument( argument, arg1 );
    one_argument( argument, arg2 );

    if ( (obj = get_obj_list(ch, arg1, ch->in_room->contents)) == NULL )
    {
        send_to_char( "Drag what where?\n\r", ch );
        return;
    }
    
    if ( ( door = get_dir( arg2 ) ) == MAX_DIR )
    {   
        send_to_char( "Drag what where?\n\r", ch );
        return;
    }

    for ( mob = ch->in_room->people; mob != NULL; mob = mob->next_in_room )
    {
        if ( mob->hitched_to == obj )
        {
            act( "$p is already hitched to $N.", ch, obj, mob, TO_CHAR );
            return;
        }
    }
    
    ch->hitched_to = obj;
    move_char( ch, door );
    ch->hitched_to = NULL;

    return;
}



/*
 * Syntax:  hitch [person] [object]
 */
void do_hitch( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_STRING_LENGTH];
    char arg2[MAX_STRING_LENGTH];
    OBJ_DATA *obj;
    CHAR_DATA *mob;
    CHAR_DATA *vict;
    
    argument = one_argument( argument, arg1 );
    one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || (vict = get_char_room(ch, arg1)) == NULL )
    {
        send_to_char( "Hitch whom to what?\n\r", ch );
        return;
    }

    if ( arg2[0] == '\0' || (obj = get_obj_list(ch, arg2, ch->in_room->contents)) == NULL )
    {
        send_to_char( "Hitch whom to what?\n\r", ch );
        return;
    }

    if ( !IS_SET(obj->extra_flags, ITEM_HITCH) )
    {
        send_to_char( "You can't hitch anything to that.\n\r", ch );
        return;
    }

    for ( mob = ch->in_room->people; mob != NULL; mob = mob->next_in_room )
    {
        if ( mob->hitched_to == obj )
        {
            act( "$p is already hitched to $N.", ch, obj, mob, TO_CHAR );
            return;
        }
    }

    if ( vict->hitched_to != NULL )
    do_unhitch( ch, arg2 );

    vict->hitched_to = obj;
    act( "You hitch $N to $p.", ch, obj, vict, TO_CHAR );
    act( "$n hitches $N to $p.", ch, obj, vict, TO_NOTVICT );
    act( "$n hitches you to $p.", ch, obj, vict, TO_VICT );
    return;
}



/*
 * Syntax:  unhitch [person]
 */
void do_unhitch( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_STRING_LENGTH];
    char arg2[MAX_STRING_LENGTH];
    OBJ_DATA *obj;
    CHAR_DATA *vict;
    
    argument = one_argument( argument, arg1 );
    one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || (vict = get_char_room(ch, arg1)) == NULL )
    {
        send_to_char( "Unhitch whom?\n\r", ch );
        return;
    }

    if ( vict->hitched_to == NULL )
    {
        send_to_char( "They aren't hitched to anything.", ch );
        return;
    }

    obj = vict->hitched_to;
    vict->hitched_to = NULL;
    act( "You unhitch $N from $p.", ch, obj, vict, TO_CHAR );
    act( "$n unhitches $N from $p.", ch, obj, vict, TO_NOTVICT );
    act( "$n unhitches you from $p.", ch, obj, vict, TO_VICT );
    return;
}
 


/*
 * Syntax:  enter [object]
 */
void do_enter( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_STRING_LENGTH];
    CHAR_DATA *mob;
    OBJ_DATA *obj;
    ROOM_INDEX_DATA *dest;
    
    one_argument( argument, arg );
    
    if ( ( obj = get_obj_here( ch, arg ) ) == NULL )
    {
        send_to_char( "There is nothing like that to enter.\n\r", ch );
        return;
    }
    
    if ( ( obj->item_type != ITEM_FURNITURE )
      || !IS_SET(obj->value[1], FURN_EXIT) )
    {
        send_to_char( "Now how do you expect to do that.\n\r", ch );
        return;
    }
    
    if ( ( dest = get_room_index( obj->value[3] ) ) == NULL )
    {
        send_to_char( "You can't go that way.\n\r", ch );
        return;
    }

    if ( room_is_private( get_room_index( obj->value[3] ) ) )
    {
        send_to_char( "You can't enter that room right now.\n\r", ch );
        return;
    }
      
    if ( IS_SET(obj->value[1], EX_CLOSED) )
    {
        send_to_char( "It's closed.\n\r", ch );
        return;
    }
    
    act( "$n enters $p.", ch, obj, NULL, TO_ROOM );
    act( "You enter $p.", ch, obj, NULL, TO_CHAR );
    script_update( obj, TYPE_OBJ, TRIG_ENTER, ch, NULL, NULL, NULL );

    char_from_room( ch );
    char_to_room( ch, dest );

    do_look( ch, "auto" );

    if ( IS_SET(ch->in_room->room_flags, ROOM_WAGON) )
    act( "$n arrives.", ch, NULL, NULL, TO_ROOM );
    else
    act( "$n arrives from $p.", ch, obj, NULL, TO_ROOM );


    if ( ch->rider != NULL )
    {
        char_from_room( ch->rider );
        char_to_room( ch->rider, dest );
        do_look( ch->rider, "auto" );
    }

    if ( ch->riding != NULL )
    {
        char_from_room( ch->riding );
        char_to_room( ch->riding, dest );
        do_look( ch->riding, "auto" );
    }

    for ( mob = ch->in_room->people;
          mob != NULL;
          mob = mob->next_in_room )
    {
    if (script_update( mob, TYPE_MOB, TRIG_ENTER, ch, NULL, "99", NULL ))
    break;
    }

    return;
}



void do_leave( CHAR_DATA *ch, char *argument )
{
    ROOM_INDEX_DATA *pRoom;
    OBJ_INDEX_DATA *pObjIndex;
    OBJ_DATA *pObj;

    if ( (pRoom = ch->in_room) == NULL )
    {
        send_to_char( "There is nothing to get out of.\n\r", ch );
        return;
    }

    if ( IS_SET(pRoom->room_flags, ROOM_WAGON)
      && (pObjIndex = get_obj_index( pRoom->wagon )) != NULL )
    {
        for ( pObj = object_list; pObj != NULL; pObj = pObj->next )
        {
            if ( pObj->pIndexData == pObjIndex
              && pObj->in_room != NULL )
             break;
        }

        if ( pObj == NULL )
        {
            bug( "Do_leave: pObj == NULL.", 0 );
            send_to_char( "There is nothing to leave to.\n\r", ch );
            return;
        }

        act( "$n leaves.", ch, NULL, NULL, TO_ROOM );
        char_from_room( ch );
        char_to_room( ch, pObj->in_room );
        act( "$n emerge$v from $p.", ch, pObj, NULL, TO_ALL );
        do_look( ch, "auto" );
        return;
    }

    send_to_char( "There is nothing to leave to.\n\r", ch );
    return;
}



/*
 * Syntax:  stand
 */
void do_stand( CHAR_DATA *ch, char *argument )
{
    if ( ch->riding != NULL )    { do_dismount( ch, "" ); return; }

    switch ( ch->position )
    {
    case POS_SLEEPING:
	if ( IS_AFFECTED(ch, AFF_SLEEP) )
	    { send_to_char( "You can't wake up!\n\r", ch ); return; }

	send_to_char( "You wake and stand up.\n\r", ch );
	act( "$n wakes and stands up.", ch, NULL, NULL, TO_ROOM );
	ch->position = POS_STANDING;
    set_furn( ch, NULL );
	break;

    case POS_SITTING:
    case POS_RESTING:
	send_to_char( "You stand up.\n\r", ch );
	act( "$n stands up.", ch, NULL, NULL, TO_ROOM );
	ch->position = POS_STANDING;
    set_furn( ch, NULL );
	break;

    case POS_STANDING:
	send_to_char( "You are already standing.\n\r", ch );
    set_furn( ch, NULL );        /* just to be sure */
	break;

    case POS_FIGHTING:
    send_to_char( "You are fighting!\n\r", ch );
	break;
    }

    return;
}



/*
 * Syntax:  rest
 */
void do_rest( CHAR_DATA *ch, char *argument )
{

    if ( ch->riding != NULL )
    {
    do_rest( ch->riding, "" );
    do_dismount( ch, "" );
    }

    switch ( ch->position )
    {
    case POS_SLEEPING:
	send_to_char( "You are already sleeping.\n\r", ch );
	break;

    case POS_RESTING:
	send_to_char( "You are already resting.\n\r", ch );
	break;

    case POS_SITTING:
    send_to_char( "You lean back and rest.\n\r", ch );
    act( "$n leans back and rests.", ch, NULL, NULL, TO_ROOM );
	ch->position = POS_RESTING;
	break;

    case POS_STANDING:
    send_to_char( "You sit down and rest.\n\r", ch );
    if ( IS_NPC(ch) && IS_SET(ch->act, ACT_MOUNT) )
    act( "$n curls up on the ground.", ch, NULL, NULL, TO_ROOM );
    else
    act( "$n sits down and rests.", ch, NULL, NULL, TO_ROOM );
	ch->position = POS_RESTING;
	break;

    case POS_FIGHTING:
	send_to_char( "You are already fighting!\n\r", ch );
	break;
    }

    return;
}



/*
 * Syntax:  sit
 *          sit [object]
 */
void do_sit( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj = NULL;

    if ( ch->riding != NULL )
    do_dismount( ch, "" );

    one_argument( argument, arg );
    if ( !MTD( arg ) )
    {
        if ( (obj = get_furn_here(ch, arg)) == NULL )
        {
            send_to_char( "Sit on what?\n\r", ch );
            return;
        }

        if ( ch->furniture != NULL )
        {
            send_to_char( "You are already using a piece of furniture.\n\r", ch );
            return;
        }

        if ( ch->position <= POS_SITTING )
        {
            send_to_char( "Get up first.\n\r", ch );
            return;
        }

        if ( !VAL_SET(obj, 1, FURN_SIT) )
        {
            send_to_char( "You can't sit on that.\n\r", ch );
            return;
        }

        if ( OCCUPADO(obj) )
        {
            send_to_char( "There is someone else already using it.\n\r", ch );
            return;
        }

        set_furn( ch, obj );
    }

    switch ( ch->position )
    {
    case POS_SLEEPING:
    send_to_char( "You wake and sit up.\n\r", ch );
    act( "$n wakes and sits up.", ch, NULL, NULL, TO_ROOM );
    ch->position = POS_SITTING;
	break;

    case POS_RESTING:
    send_to_char( "You sit up.\n\r", ch );
    act( "$n sits up.", ch, NULL, NULL, TO_ROOM );
    ch->position = POS_SITTING;
	break;

    case POS_SITTING:
    send_to_char( "You are already sitting.\n\r", ch );
    break;

    case POS_STANDING:
    if ( !ch->furniture )
    send_to_char( "You sit down.\n\r", ch );
    else
    act( "You sit down on $p.", ch, ch->furniture, NULL, TO_CHAR );

    if ( !ch->furniture )
    act( "$n sits down.", ch, NULL, NULL, TO_ROOM );
    else
    act( "$n sits down on $p.", ch, ch->furniture, NULL, TO_ROOM );
    ch->position = POS_SITTING;
	break;

    case POS_FIGHTING:
    send_to_char( "You are fighting!\n\r", ch );
	break;
    }

    return;
}



/*
 * Syntax:  sleep
 *          sleep [object]
 */
void do_sleep( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    if ( ch->riding != NULL )
    {
        send_to_char( "You must dismount first.\n\r", ch );
        return;
    }

    one_argument( argument, arg );
    if ( !MTD( arg ) )
    {
        if ( (obj = get_obj_here(ch, arg)) == NULL )
        {
            send_to_char( "Sleep on what?\n\r", ch );
            return;
        }

        if ( ch->furniture )
        {
            send_to_char( "You are already on something else.\n\r", ch );
            return;
        }

        if ( VAL_SET(obj, 1, FURN_SLEEP) )
        {
            if ( OCCUPADO(obj) )
            {
                send_to_char( "There is no more room on it.\n\r", ch );
                return;
            }
            else
            {
                act( "$n lies down on $p.", ch, obj, NULL, TO_ROOM );
                act( "You lie down on $p.", ch, obj, NULL, TO_CHAR );
                set_furn( ch, obj );
            }
        }
        else
        {
            send_to_char( "You can't sleep on that.\n\r", ch );
            return;
        }
    }
    else
    {
        obj = ch->furniture;
        if ( obj )
        {
            if ( obj->item_type == ITEM_FURNITURE
              && VAL_SET(obj, 1, FURN_SLEEP) )
            {
                act( "$n lies back on $p.", ch, obj, NULL, TO_ROOM );
                act( "You lie back on $p.", ch, obj, NULL, TO_CHAR );
            }
            else
            {
            send_to_char( "You roll onto the floor.\n\r", ch );
            set_furn( ch, NULL );
            }
        }
    }


    switch ( ch->position )
    {
    case POS_SLEEPING:
	send_to_char( "You are already sleeping.\n\r", ch );
	break;

    case POS_RESTING:
    case POS_SITTING:
    case POS_STANDING:

    if ( !ch->furniture )
    send_to_char( "You lie down and fall asleep.\n\r", ch );
    else
    send_to_char( "You go to sleep.\n\r", ch );

    if ( !ch->furniture )
    act( "$n lies down and falls asleep.", ch, NULL, NULL, TO_ROOM );
    else
    act( "$n goes to sleep.", ch, NULL, NULL, TO_ROOM );

	ch->position = POS_SLEEPING;
	break;

    case POS_FIGHTING:
        send_to_char( "You are fighting!\n\r", ch );
	break;
    }

    return;
}



/*
 * Syntax:  wake
 *          wake [person]
 */
void do_wake( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
	{ do_stand( ch, argument ); return; }

    if ( !IS_AWAKE(ch) )
	{ send_to_char( "You are asleep yourself!\n\r",       ch ); return; }

    if ( ( victim = get_char_room( ch, arg ) ) == NULL )
	{ send_to_char( "They aren't here.\n\r",              ch ); return; }

    if ( IS_AWAKE(victim) )
	{ act( "$N is already awake.", ch, NULL, victim, TO_CHAR ); return; }

    if ( IS_AFFECTED(victim, AFF_SLEEP) )
	{ act( "You can't wake $M!",   ch, NULL, victim, TO_CHAR );  return; }

    act( "You wake $M.", ch, NULL, victim, TO_CHAR );
    act( "$n wakes you.", ch, NULL, victim, TO_VICT );
    victim->position = POS_RESTING;
    return;
}



/*
 * Syntax:  sneak
 */
void do_sneak( CHAR_DATA *ch, char *argument )
{
    if ( IS_AFFECTED(ch, AFF_SNEAK) )
    {
    REMOVE_BIT(ch->affected_by, AFF_SNEAK);
    send_to_char( "You stop trying to move silently.\n\r", ch );
    return;
    }

    if ( ch->riding != NULL )
    {
        send_to_char( "Dismount first.\n\r", ch );
        return;
    }
    send_to_char( "You try to move silently.\n\r", ch );
    SET_BIT(ch->affected_by, AFF_SNEAK);
    return;
}



/*
 * Syntax:  hide
 */
void do_hide( CHAR_DATA *ch, char *argument )
{
    if ( IS_AFFECTED(ch, AFF_HIDE) )
    {
    REMOVE_BIT(ch->affected_by, AFF_HIDE);
    send_to_char( "You stop trying to hide your presence.\n\r", ch );
    act( "$n stops trying to hide $s presence.", ch, NULL, NULL, TO_ROOM );
    return;
    }

    if ( ch->riding != NULL )
    {
        send_to_char( "Dismount first.\n\r", ch );
        return;
    }

    send_to_char( "You attempt to hide your presence.\n\r", ch );
    SET_BIT(ch->affected_by, AFF_HIDE);
    hide_check( ch, ch->in_room );
    return;
}




