/****************************************************************************
 ****************************************************************************
 * Locke's   __ -based on merc v2.2-____        NIM Server Software         *
 * ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION    *
 * |  /   \  __|  \__/  |  | |  |     O|        documentation release       *
 * |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999           *
 * |    |  ||  |  |__|  |       |     D|                                    *
 * |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud  *
 *   n a m e l e s s i n c a r n a t e          dedicated to chris cool     *
 ****************************************************************************
 *                                                                          *
 *      This is the server software for The Isles, called NiMUD 4.0.        *
 *    Copyright (c) 1994-1999 by Herb Gilliland.  All rights reserved.      *
 *                                                                          *
 *  Much time and thought has gone into this software and you are           *
 *  benefitting.  We hope that you share your changes too.  What goes       *
 *  around, comes around.                                                   *
 *                                                                          *
 ****************************************************************************
 *   Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *   Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 ****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "script.h"
#include "skills.h"
#include "defaults.h"

#define IS_FULL         75
#define IS_DRUNK        40


#define INV(loc)       ( (loc == WEAR_NONE || loc == WEAR_HOLD_1 ||     \
                          loc == WEAR_HOLD_2) )


#define NOTPET(wb)        ( (IS_NPC(ch) \
                          && IS_SET(ch->act, ACT_PET)           \
                          && wb == WEAR_BELT_1                  \
                          && wb == WEAR_BELT_2                  \
                          && wb == WEAR_BELT_3                  \
                          && wb == WEAR_BELT_4                  \
                          && wb == WEAR_BELT_5 ) )
#define CAN_WEAR_LOC(ch,wb)   ( TRUE )




bool can_wield( CHAR_DATA *ch, OBJ_DATA *obj )
{
    int weight;
    OBJ_DATA *w1, *w2, *sh;

    if ( obj->item_type == ITEM_WEAPON )
    {
        if ( wield_free( ch, obj ) != WEAR_WIELD_1
          && IS_SET(obj->wear_flags, ITEM_TWO_HANDED) )
        {
	    if ( obj->wear_loc != WEAR_HOLD_1 )
            act( "You need to have $p in your primary hand, and two hands free.", ch, obj, NULL, TO_CHAR );
 	    else
            act( "$p requires two hands to be wielded correctly.",
                 ch, obj, NULL, TO_CHAR );
            return FALSE;
        }


        if ( wield_free( ch, obj ) == WEAR_NONE )
        return FALSE;

    }
    else
    if ( IS_SET(obj->wear_flags,ITEM_WEAR_SHIELD) )
    {
        if ( get_eq_char( ch, WEAR_SHIELD ) != NULL )
        {
            send_to_char( "You are already using a shield.", ch );
            return FALSE;
        }
    }
    else
    {
        act( "$p is not a weapon.", ch, obj, NULL, TO_CHAR );
        return FALSE;
    }


    if ( str_app[get_curr_str(ch)].wield < obj->weight )
    {
        act( "You are not strong enough to wield $p.", ch, obj, NULL, TO_CHAR );
        return FALSE;
    }

    w1 = get_eq_char(ch, WEAR_WIELD_1);
    w2 = get_eq_char(ch, WEAR_WIELD_2);
    sh = get_eq_char(ch, WEAR_SHIELD);

    weight = 0;
    if ( w1 ) weight += w1->weight;
    if ( w2 ) weight += w2->weight;
    if ( sh ) weight += sh->weight;

    if ( str_app[get_curr_str(ch)].wield < weight + obj->weight )
    {
        if ( (w1 || w2) && sh )
        act( "You are not strong enough to use a shield, a weapon and $p.",
             ch, obj, NULL, TO_CHAR );
        else
        if ( (w1 || w2) )
        act( "You are too weak to wield $p and $P at the same time.",
             ch, obj, (w1==NULL)?w2:w1, TO_CHAR );
        else
        act( "You lack the strength to wield $p.", ch, obj, NULL, TO_CHAR );
        return FALSE;
    }

    return TRUE;
}


bool draw_obj( CHAR_DATA *ch, OBJ_DATA *obj )
{
   if ( obj->wear_loc != WEAR_BELT_1
     && obj->wear_loc != WEAR_BELT_2
     && obj->wear_loc != WEAR_BELT_3
     && obj->wear_loc != WEAR_BELT_4
     && obj->wear_loc != WEAR_BELT_5 )
   return FALSE;

   if ( hand_empty( ch ) == WEAR_NONE )
   return FALSE;

   if ( !can_wield(ch, obj) )
   return FALSE;

   equip_char( ch, obj, wield_free( ch, obj ) );

   act( "$n draws $p from $s belt.", ch, obj, NULL, TO_ROOM );
   act( "You draw $p from your belt.", ch, obj, NULL, TO_CHAR );
   return TRUE;
}


bool sheath_obj( CHAR_DATA *ch, OBJ_DATA *obj )
{
   if ( obj == NULL )
   return FALSE;
   
   if ( !CAN_WEAR_LOC(ch,WEAR_BELT_1) )
   return FALSE;

   if ( !IS_SET( obj->wear_flags, ITEM_WEAR_BELT ) )
   return FALSE;

   if ( get_eq_char( ch, WEAR_WAIST ) == NULL )
   {
       send_to_char( "You need a belt to sheathe it in.\n\r", ch );
       return TRUE;
   }

   if ( obj->wear_loc != WEAR_NONE
     && obj->wear_loc != WEAR_HOLD_1
     && obj->wear_loc != WEAR_HOLD_2
     && obj->wear_loc != WEAR_WIELD_1
     && obj->wear_loc != WEAR_WIELD_2 )
   return FALSE;

   if ( belt_empty( ch ) == WEAR_NONE )
   {
       send_to_char( "Remove something from your belt first.\n\r", ch );
       return TRUE;
   }

   if ( obj->wear_loc == WEAR_WIELD_1
     || obj->wear_loc == WEAR_WIELD_2
     || IS_SET(obj->extra_flags, ITEM_USED) ) unequip_char( ch, obj );
   obj->wear_loc = belt_empty( ch );
   act( "$n sheathes $p at $s belt.", ch, obj, NULL, TO_ROOM );
   act( "You sheathe $p at your belt.", ch, obj, NULL, TO_CHAR );
   return TRUE;

}

/*
 * Remove an object.
 */
bool remove_obj( CHAR_DATA *ch, int iWear, bool fReplace )
{
    OBJ_DATA *obj;
    
    if ( ( obj = get_eq_char( ch, iWear ) ) == NULL )
	return TRUE;

    if ( !fReplace )
	return FALSE;

    if ( NOT_WORN( obj ) )
    {
    act( "You can't remove $p, since it is already!", ch, obj, NULL, TO_CHAR );
    return FALSE;
    }

    if ( hand_empty( ch ) == WEAR_NONE )
    {
        send_to_char( "Your hands are full.\n\r", ch );
        return FALSE;
    }

    if ( IS_SET(obj->extra_flags, ITEM_NOREMOVE) && !IS_IMMORTAL(ch) )
    {
	act( "You can't remove $p.", ch, obj, NULL, TO_CHAR );
	return FALSE;
    }

    if ( obj->wear_loc == WEAR_WAIST && iWear != WEAR_WAIST )
    {
        OBJ_DATA *obj2;
        bool fFound = FALSE;
        int curwear;

        for ( curwear = WEAR_BELT_1; curwear <= WEAR_BELT_5; curwear++ )
        {
           obj2 = get_eq_char( ch, curwear );
           if (obj2 != NULL)
           {
                 fFound = TRUE;
                 obj_from_char( obj2 );
                 obj_to_room( obj2, ch->in_room );
           }
        }

        if (fFound)
        {
        act( "As $n removes $p, everything on it clatters to the floor!", ch,
                               obj, NULL, TO_ROOM );
        act( "The items hung from your $t clatter to the floor.", ch,
                       smash_article( STR(obj,short_descr) ), NULL, TO_CHAR );
        }
    }

    if ( unequip_char( ch, obj ) )
    {
        act( "$n stops using $p.", ch, obj, NULL, TO_ROOM );
        act( "You stop using $p.", ch, obj, NULL, TO_CHAR );
    }
    else
    {
        send_to_char( "Your hands are full.\n\r", ch );
        return FALSE;
    }

    return TRUE;
}


int get_wear_location( int loc )
{
    if ( IS_SET( loc, ITEM_WEAR_FINGER ) )
    return WEAR_FINGER_L;

    if ( IS_SET( loc, ITEM_WEAR_NECK ) )
    return WEAR_NECK_1;

    if ( IS_SET( loc, ITEM_WEAR_BODY ) )
    return WEAR_BODY;

    if ( IS_SET( loc, ITEM_WEAR_HEAD ) )
    return WEAR_HEAD;

    if ( IS_SET( loc, ITEM_WEAR_LEGS ) )
    return WEAR_LEGS;

    if ( IS_SET( loc, ITEM_WEAR_FEET ) )
    return WEAR_FEET;

    if ( IS_SET( loc, ITEM_WEAR_HANDS ) )
    return WEAR_HANDS;

    if ( IS_SET( loc, ITEM_WEAR_ARMS ) )
    return WEAR_ARMS;

    if ( IS_SET( loc, ITEM_WEAR_SHIELD ) )
    return WEAR_SHIELD;

    if ( IS_SET( loc, ITEM_WEAR_ABOUT ) )
    return WEAR_ABOUT;

    if ( IS_SET( loc, ITEM_WEAR_WAIST ) )
    return WEAR_WAIST;

    if ( IS_SET( loc, ITEM_WEAR_WRIST ) )
    return WEAR_WRIST_L;

    if ( IS_SET( loc, ITEM_WEAR_SHOULDER  ) )
    return WEAR_SHOULDER_L;

    if ( IS_SET( loc, ITEM_WEAR_ANKLE ) )
    return WEAR_ANKLE_L;

    if ( IS_SET( loc, ITEM_WEAR_EAR ) )
    return WEAR_EAR_L;

    if ( IS_SET( loc, ITEM_WEAR_HELM ) )
    return WEAR_HELM;

    if ( IS_SET( loc, ITEM_WEAR_SHIRT ) )
    return WEAR_SHIRT;

    if ( IS_SET( loc, ITEM_WEAR_STOCKING ) )
    return WEAR_STOCKING;

    if ( IS_SET( loc, ITEM_WEAR_FACE ) )
    return WEAR_FACE;

    if ( IS_SET( loc, ITEM_WEAR_BACK ) )
    return WEAR_BACK;

    if ( IS_SET( loc, ITEM_WEAR_LOIN ) )
    return WEAR_LOIN;

    if ( IS_SET( loc, ITEM_WEAR_FOREHEAD ) )
    return WEAR_FOREHEAD;

    if ( IS_SET( loc, ITEM_WEAR_NOSE ) )
    return WEAR_NOSE;

    if ( IS_SET( loc, ITEM_WEAR_PANTS ) )
    return WEAR_PANTS;

    if ( IS_SET( loc, ITEM_WEAR_PIN ) )
    return WEAR_PIN;
    
    if ( IS_SET( loc, ITEM_WEAR_ASBELT ) )
    return WEAR_ASBELT_1;

    return WEAR_NONE;
}

/*
 * Wear one object.
 * Optional replacement of existing objects.
 * Big repetitive code, ick.
 */
void wear_obj( CHAR_DATA *ch, OBJ_DATA *obj, bool fReplace, int loc )
{
    OBJ_DATA *obj2;

    if ( NOTPET(loc) ) return;

    if ( CAN_WEAR( obj, ITEM_WEAR_FINGER ) )
    if ( loc == 0 || loc == ITEM_WEAR_FINGER )
    {

	if ( get_eq_char( ch, WEAR_FINGER_L ) != NULL
	&&   get_eq_char( ch, WEAR_FINGER_R ) != NULL
	&&   !remove_obj( ch, WEAR_FINGER_L, fReplace )
	&&   !remove_obj( ch, WEAR_FINGER_R, fReplace ) )
	    return;

	if ( get_eq_char( ch, WEAR_FINGER_L ) == NULL )
	{
        act( "$n slips $p onto $s left finger.",    ch, obj, NULL, TO_ROOM );
        act( "You slip $p onto your left finger.",  ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_FINGER_L );
	    return;
	}

	if ( get_eq_char( ch, WEAR_FINGER_R ) == NULL )
	{
        act( "$n slips $p onto $s right finger.",   ch, obj, NULL, TO_ROOM );
        act( "You slip $p onto your right finger.", ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_FINGER_R );
	    return;
	}

	bug( "Wear_obj: no free finger.", 0 );
	send_to_char( "You already wear two rings.\n\r", ch );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_ANKLE ) )
    if ( loc == 0 || loc == ITEM_WEAR_ANKLE )
    {

    if ( get_eq_char( ch, WEAR_ANKLE_L ) != NULL
    &&   get_eq_char( ch, WEAR_ANKLE_R ) != NULL
    &&   !remove_obj( ch, WEAR_ANKLE_L, fReplace )
    &&   !remove_obj( ch, WEAR_ANKLE_R, fReplace ) )
	    return;

    if ( get_eq_char( ch, WEAR_ANKLE_L ) == NULL )
	{
        act( "$n fastens $p around $s left ankle.",    ch, obj, NULL, TO_ROOM );
        act( "You fasten $p around your left ankle.",  ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_ANKLE_L );
	    return;
	}

    if ( get_eq_char( ch, WEAR_ANKLE_R ) == NULL )
	{
        act( "$n fastens $p around $s right ankle.",   ch, obj, NULL, TO_ROOM );
        act( "You fasten $p around your right ankle.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_ANKLE_R );
	    return;
	}

    bug( "Wear_obj: no free ankle.", 0 );
    send_to_char( "You already wear two items on your ankles.\n\r", ch );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_EAR ) )
    if ( loc == 0 || loc == ITEM_WEAR_EAR )
    {

    if ( get_eq_char( ch, WEAR_EAR_L ) != NULL
    &&   get_eq_char( ch, WEAR_EAR_R ) != NULL
    &&   !remove_obj( ch, WEAR_EAR_L, fReplace )
    &&   !remove_obj( ch, WEAR_EAR_R, fReplace ) )
	    return;

    if ( get_eq_char( ch, WEAR_EAR_L ) == NULL )
	{
        act( "$n wears $p on $s left ear.",    ch, obj, NULL, TO_ROOM );
        act( "You wear $p on your left ear.",  ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_EAR_L );
	    return;
	}

    if ( get_eq_char( ch, WEAR_EAR_R ) == NULL )
	{
        act( "$n wears $p on $s right ear.",   ch, obj, NULL, TO_ROOM );
        act( "You wear $p on $s right ear.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_EAR_R );
	    return;
	}

    bug( "Wear_obj: no free ear.", 0 );
    send_to_char( "You already wear two earrings.\n\r", ch );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_NECK ) )
    if ( loc == 0 || loc == ITEM_WEAR_NECK )
    {

	if ( get_eq_char( ch, WEAR_NECK_1 ) != NULL
	&&   get_eq_char( ch, WEAR_NECK_2 ) != NULL
	&&   !remove_obj( ch, WEAR_NECK_1, fReplace )
	&&   !remove_obj( ch, WEAR_NECK_2, fReplace ) )
	    return;

	if ( get_eq_char( ch, WEAR_NECK_1 ) == NULL )
	{
        act( "$n clasps $p around $s neck.",   ch, obj, NULL, TO_ROOM );
        act( "You clasp $p around your neck.", ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_NECK_1 );
	    return;
	}

	if ( get_eq_char( ch, WEAR_NECK_2 ) == NULL )
	{
        act( "$n clasps $p around $s neck.",   ch, obj, NULL, TO_ROOM );
        act( "You clasp $p around your neck.", ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_NECK_2 );
	    return;
	}

    bug( "Wear_obj: no free neck.", 0 );
	send_to_char( "You already wear two neck items.\n\r", ch );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_NOSE ) )
    if ( loc == 0 || loc == ITEM_WEAR_NOSE )
    {

    if ( !remove_obj( ch, WEAR_NOSE, fReplace ) )
	    return;
    act( "$n pierces $s nose with $p.",   ch, obj, NULL, TO_ROOM );
    act( "You pierce your nose with $p.", ch, obj, NULL, TO_CHAR );
    equip_char( ch, obj, WEAR_NOSE );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_BODY ) )
    if ( loc == 0 || loc == ITEM_WEAR_BODY )
    {

	if ( !remove_obj( ch, WEAR_BODY, fReplace ) )
	    return;
	act( "$n wears $p on $s body.",   ch, obj, NULL, TO_ROOM );
	act( "You wear $p on your body.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_BODY );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_SHIRT ) )
    if ( loc == 0 || loc == ITEM_WEAR_SHIRT )
    {

    if ( !remove_obj( ch, WEAR_SHIRT, fReplace ) )
	    return;
    act( "$n pulls $p over $s body.",   ch, obj, NULL, TO_ROOM );
    act( "You pull $p over your body.", ch, obj, NULL, TO_CHAR );
    equip_char( ch, obj, WEAR_SHIRT );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_HEAD ) )
    if ( loc == 0 || loc == ITEM_WEAR_HEAD )
    {

	if ( !remove_obj( ch, WEAR_HEAD, fReplace ) )
	    return;
    act( "$n dons $p.",   ch, obj, NULL, TO_ROOM );
    act( "You don $p.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_HEAD );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_HELM )
     && ( obj2 = get_eq_char( ch, WEAR_HEAD ) ) != NULL )
    if ( loc == 0 || loc == ITEM_WEAR_HELM )
    {

    if ( !remove_obj( ch, WEAR_HELM, fReplace ) )
	    return;
    act( "$n places $p onto $P.",   ch, obj, obj2, TO_ROOM );
    act( "You place $p onto $P.", ch, obj, obj2, TO_CHAR );
    equip_char( ch, obj, WEAR_HELM );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_FACE ) )
    if ( loc == 0 || loc == ITEM_WEAR_FACE )
    {

    if ( !remove_obj( ch, WEAR_FACE, fReplace ) )
	    return;
    act( "$n covers $s face with $p.",   ch, obj, NULL, TO_ROOM );
    act( "You cover $s face with $p.", ch, obj, NULL, TO_CHAR );
    equip_char( ch, obj, WEAR_FACE );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_LEGS ) )
    if ( loc == 0 || loc == ITEM_WEAR_LEGS )
    {

	if ( !remove_obj( ch, WEAR_LEGS, fReplace ) )
	    return;
    act( "$n straps $p onto $s legs.",   ch, obj, NULL, TO_ROOM );
    act( "You strap $p onto your legs.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_LEGS );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_PANTS ) )
    if ( loc == 0 || loc == ITEM_WEAR_PANTS )
    {

        if ( !remove_obj( ch, WEAR_PANTS, fReplace ) )
            return;
        act( "$n wear $p on $s legs.",   ch, obj, NULL, TO_ROOM );
        act( "You wear $p on your legs.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_PANTS );
        return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_STOCKING ) )
    if ( loc == 0 || loc == ITEM_WEAR_STOCKING )
    {

        if ( !remove_obj( ch, WEAR_STOCKING, fReplace ) )
            return;
        act( "$n pull $p onto $s legs.",   ch, obj, NULL, TO_ROOM );
        act( "You pull $p onto your legs.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_STOCKING );
        return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_FEET ) )
    if ( loc == 0 || loc == ITEM_WEAR_FEET )
    {
         if ( !remove_obj( ch, WEAR_FEET, fReplace ) )
               return;
         act( "$n slips $s feet into $p.",   ch, obj, NULL, TO_ROOM );
         act( "You slip your feet into $p.", ch, obj, NULL, TO_CHAR );
         equip_char( ch, obj, WEAR_FEET );
         return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_HANDS ) )
    if ( loc == 0 || loc == ITEM_WEAR_HANDS )
    {

        if ( !remove_obj( ch, WEAR_HANDS, fReplace ) )
            return;
        act( "$n wears $p on $s hands.",   ch, obj, NULL, TO_ROOM );
        act( "You wear $p on your hands.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_HANDS );
        return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_ARMS ) )
    if ( loc == 0 || loc == ITEM_WEAR_ARMS )
    {

        if ( !remove_obj( ch, WEAR_ARMS, fReplace ) )
             return;
        act( "$n wears $p on $s arms.",   ch, obj, NULL, TO_ROOM );
        act( "You wear $p on your arms.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_ARMS );
        return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_ABOUT ) )
    if ( loc == 0 || loc == ITEM_WEAR_ABOUT )
    {
        if ( !remove_obj( ch, WEAR_ABOUT, fReplace ) )
            return;
        act( "$n wraps $p about $s body.",   ch, obj, NULL, TO_ROOM );
        act( "You wrap $p about your body.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_ABOUT );
        return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_WAIST ) )
    if ( loc == 0 || loc == ITEM_WEAR_WAIST )
    {

        if ( !remove_obj( ch, WEAR_WAIST, fReplace ) )
            return;
        act( "$n fastens $p around $s waist.",   ch, obj, NULL, TO_ROOM );
        act( "You fasten $p around your waist.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_WAIST );
        return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_LOIN ) )
    if ( loc == 0 || loc == ITEM_WEAR_LOIN )
    {

        if ( !remove_obj( ch, WEAR_LOIN, fReplace ) )
            return;
        act( "$n wraps $p about $s waist.",   ch, obj, NULL, TO_ROOM );
        act( "You wrap $p about your waist.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_LOIN );
        return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_WRIST ) )
    if ( loc == 0 || loc == ITEM_WEAR_WRIST )
    {

	if ( get_eq_char( ch, WEAR_WRIST_L ) != NULL
	&&   get_eq_char( ch, WEAR_WRIST_R ) != NULL
	&&   !remove_obj( ch, WEAR_WRIST_L, fReplace )
	&&   !remove_obj( ch, WEAR_WRIST_R, fReplace ) )
	    return;

	if ( get_eq_char( ch, WEAR_WRIST_L ) == NULL )
	{
	    act( "$n clips $p around $s left wrist.",
		ch, obj, NULL, TO_ROOM );
	    act( "You clip $p around your left wrist.",
		ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_WRIST_L );
	    return;
    }

	if ( get_eq_char( ch, WEAR_WRIST_R ) == NULL )
	{
	    act( "$n clips $p around $s right wrist.",
		ch, obj, NULL, TO_ROOM );
	    act( "You clip $p around your right wrist.",
		ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_WRIST_R );
	    return;
	}

	bug( "Wear_obj: no free wrist.", 0 );
	send_to_char( "You already wear two wrist items.\n\r", ch );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_SHOULDER ) )
    if ( loc == 0 || loc == ITEM_WEAR_SHOULDER )
    {

    if ( get_eq_char( ch, WEAR_SHOULDER_L ) != NULL
      && get_eq_char( ch, WEAR_SHOULDER_R ) != NULL
      && !remove_obj( ch, WEAR_SHOULDER_L, fReplace )
      && !remove_obj( ch, WEAR_SHOULDER_R, fReplace ) )
            return;

    if ( get_eq_char( ch, WEAR_SHOULDER_L ) == NULL )
        {
             act( "$n slings $p over $s left shoulder.",
                     ch, obj, NULL, TO_ROOM );
             act( "You sling $p over your left shoulder.",
                     ch, obj, NULL, TO_CHAR );
             equip_char( ch, obj, WEAR_SHOULDER_L );
                 return;
        }

    if ( get_eq_char( ch, WEAR_SHOULDER_R ) == NULL )
        {
             act( "$n slings $p over $s right shoulder.",
                     ch, obj, NULL, TO_ROOM );
             act( "You sling $p over your right shoulder.",
                     ch, obj, NULL, TO_CHAR );
             equip_char( ch, obj, WEAR_SHOULDER_R );
                 return;
        }

    bug( "Wear_obj: no free shoulder.", 0 );
    send_to_char( "You already wear an items on each shoulder.\n\r", ch );
        return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_ASBELT ) )
    if ( loc == 0 || loc == ITEM_WEAR_ASBELT )
    {

    if ( get_eq_char( ch, WEAR_ASBELT_1 ) != NULL
      && get_eq_char( ch, WEAR_ASBELT_2 ) != NULL
      && get_eq_char( ch, WEAR_ASBELT_3 ) != NULL
      && !remove_obj( ch, WEAR_ASBELT_1, fReplace )
      && !remove_obj( ch, WEAR_ASBELT_2, fReplace )
      && !remove_obj( ch, WEAR_ASBELT_3, fReplace ) )
            return;

    if ( get_eq_char( ch, WEAR_ASBELT_1 ) == NULL )
        {
             act( "$n fastens $p around $s waist.",  ch, obj, NULL, TO_ROOM );
             act( "You fasten $p around your waist.", ch, obj, NULL, TO_CHAR );
             equip_char( ch, obj, WEAR_ASBELT_1 );
                 return;
        }

    if ( get_eq_char( ch, WEAR_ASBELT_2 ) == NULL )
        {
             act( "$n fastens $p around $s waist.",  ch, obj, NULL, TO_ROOM );
             act( "You fasten $p around your waist.", ch, obj, NULL, TO_CHAR );
             equip_char( ch, obj, WEAR_ASBELT_2 );
                 return;
        }

    if ( get_eq_char( ch, WEAR_ASBELT_3 ) == NULL )
        {
            act( "$n fastens $p around $s waist.",   ch, obj, NULL, TO_ROOM );
            act( "You fasten $p around your waist.",  ch, obj, NULL, TO_CHAR );
            equip_char( ch, obj, WEAR_ASBELT_3 );
            return;
        }

    bug( "Wear_obj: no free as_belt.", 0 );
    send_to_char( "You already wear enough items there.\n\r", ch );
        return;
    }


    if ( CAN_WEAR( obj, ITEM_WEAR_BACK ) )
    if ( loc == 0 || loc == ITEM_WEAR_BACK )
    {
        if ( !remove_obj( ch, WEAR_BACK, fReplace ) )
            return;
        act( "$n hefts $p onto $s back.",   ch, obj, NULL, TO_ROOM );
        act( "You heft $p onto your back.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_BACK );
        return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_SHIELD ) )
    {
        if ( !remove_obj( ch, WEAR_SHIELD, fReplace )
          || !can_wield( ch, obj ) )
            return;
        act( "$n straps $p to $s arm as a shield.", ch, obj, NULL, TO_ROOM );
        act( "You strap $p to your arm as a shield.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_SHIELD );
        return;
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_SHOULDERS ) )
    {
        if ( !remove_obj( ch, WEAR_SHOULDERS, fReplace )
          || !can_wield( ch, obj) )
            return;
        act( "$n places $p on $s shoulders.", ch, obj, NULL, TO_ROOM );
        act( "You place $p on your shoulders.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_SHOULDERS );
        return;
    }

    if ( CAN_WEAR( obj, ITEM_HOLD )  && hand_empty( ch ) != WEAR_NONE )
    {
        if ( !remove_obj( ch, obj->wear_loc, fReplace ) )
            return;
        act( "$n holds $p in $s hand.", ch, obj, NULL, TO_ROOM );
        act( "You hold $p in your hand.", ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, hand_empty( ch ) );
        return;
    }

    if ( fReplace )
    send_to_char( "You can't wear that there.\n\r", ch );

    return;
}



/*
 * Syntax:  wear [object]
 *          wear [object] [location]
 *          wear all
 */
void do_wear( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int oldwear;

    argument = one_argument( argument, arg1 );
    one_argument( argument, arg2 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Wear what?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg1, "all" ) )
    {
	OBJ_DATA *obj_next;

	for ( obj = ch->carrying; obj != NULL; obj = obj_next )
	{
	    obj_next = obj->next_content;
        if ( (obj->wear_loc == WEAR_NONE || obj->wear_loc == WEAR_HOLD_1 ||
              obj->wear_loc == WEAR_HOLD_2)
           && can_see_obj( ch, obj )
           && !TOO_SMALL(ch, obj)
           && !TOO_BIG(ch, obj) )
        wear_obj( ch, obj, FALSE, 0 );
	}
	return;
    }
    else
    {
    if ( ( obj = get_obj_carry( ch, arg1 ) ) == NULL )
	{
        send_to_char( "You do not have that item in your hand.\n\r", ch );
	    return;
	}

    if ( (obj->size || ch->size) && (TOO_BIG(ch,obj) || TOO_SMALL(ch,obj)) )
    {
        send_to_char( "It doesn't fit you.\n\r", ch );
        return;
    }

    oldwear = obj->wear_loc;
    wear_obj( ch, obj, TRUE, wear_name_bit( arg2 ) );
    if ( obj->size && ch->size && oldwear != obj->wear_loc )
    {
        if ( obj->size < ch->size )
        send_to_char( "It looks a bit snug.\n\r", ch );
        else
        if ( obj->size > ch->size )
        send_to_char( "It looks a bit loose.\n\r", ch );
    }
    }

    return;
}



/*
 * Syntax:  sheath
 *          sheath [object]
 */
void do_sheath( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_STRING_LENGTH];
    OBJ_DATA *obj;

    argument = one_argument( argument, arg1 );

    if ( ( obj = get_obj_carry( ch, arg1 ) ) == NULL )
    {
        if ( get_item_held( ch, ITEM_WEAPON ) != NULL )
             sheath_obj( ch, get_item_held( ch, ITEM_WEAPON ) );
        if ( get_item_held( ch, ITEM_WEAPON ) != NULL )
             sheath_obj( ch, get_item_held( ch, ITEM_WEAPON ) );
        return;
    }

    if (!sheath_obj( ch, obj ))  send_to_char( "You can't do that!\n\r", ch );
    return;
}



/*
 * Syntax:  draw
 *          draw [object]
 */
void do_draw( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_STRING_LENGTH];
    OBJ_DATA *obj;
 
    argument = one_argument( argument, arg1 );
 
    if ( ( obj = get_obj_wear( ch, arg1 ) ) == NULL )
      {    
       if ( ( obj = get_eq_char( ch, WEAR_BELT_1 ) ) != NULL ) 
          draw_obj( ch, obj );
       if ( ( obj = get_eq_char( ch, WEAR_BELT_2 ) ) != NULL ) 
          draw_obj( ch, obj );                 
       if ( ( obj = get_eq_char( ch, WEAR_BELT_3 ) ) != NULL ) 
          draw_obj( ch, obj );
       if ( ( obj = get_eq_char( ch, WEAR_BELT_4 ) ) != NULL ) 
          draw_obj( ch, obj );
       if ( ( obj = get_eq_char( ch, WEAR_BELT_5 ) ) != NULL ) 
          draw_obj( ch, obj );
          
       return;
     }
 
    if (!draw_obj( ch, obj ))  send_to_char( "You are unable to draw an item from your belt.\n\r", ch );
    return;
}
 


/*
 * Syntax:  remove [object]
 */
void do_remove( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Remove what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_wear( ch, arg ) ) == NULL )
    {
        send_to_char( "You are not wearing that item.\n\r", ch );
	return;
    }

    remove_obj( ch, obj->wear_loc, TRUE );
    return;
}



/*
 * Syntax:  wield [object]
 */
void do_wield( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if ( ( obj = get_obj_carry( ch, arg ) ) == NULL )
    {
        send_to_char( "You are not holding that object.\n\r", ch );
        return;
    }

    if ( obj->wear_loc == WEAR_WIELD_1
      || obj->wear_loc == WEAR_WIELD_2 )
    {
	send_to_char( "It is already being wielded.\n\r", ch );
    	return;
    }

    if ( can_wield( ch, obj ) )
    {
	equip_char( ch, obj, wield_free( ch, obj ) );

    	act( "$n wields $p.", ch, obj, NULL, TO_ROOM );
    	act( "You wield $p.", ch, obj, NULL, TO_CHAR );
    }
    else
    {
	act( "You can't wield $p now.", ch, obj, NULL, TO_CHAR );
    }

    return;
}


/*
 * Syntax:  hold [object]
 */
void do_hold( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if ( ( obj = get_obj_carry( ch, arg ) ) == NULL )
    {
        send_to_char( "You are not holding that object.\n\r", ch );
        return;
    }

    if ( obj->wear_loc == WEAR_HOLD_1
      || obj->wear_loc == WEAR_HOLD_2 )
    return;

    if ( obj->wear_loc == WEAR_WIELD_1
      || obj->wear_loc == WEAR_WIELD_2
      || IS_SET(obj->extra_flags, ITEM_USED) )
    {
        unequip_char( ch, obj );
        act( "$n stops wielding $p.", ch, obj, NULL, TO_ROOM );
        act( "You stop wielding $p.", ch, obj, NULL, TO_CHAR );
    }

    obj->wear_loc   = hand_empty( ch );
    act( "$n holds $p.", ch, obj, NULL, TO_ROOM );
    act( "You hold $p.", ch, obj, NULL, TO_CHAR );
    return;
}


void get_obj( CHAR_DATA *ch, OBJ_DATA *obj, OBJ_DATA *container, bool fMoney )
{
    if ( !CAN_WEAR(obj, ITEM_TAKE) )
    {
	send_to_char( "You can't take that.\n\r", ch );
	return;
    }

    if ( hand_empty( ch ) == WEAR_NONE )
    {
        send_to_char( "Your hands are full.\n\r", ch );
        return;
    };

    if ( ch->carry_weight + get_obj_weight( obj ) > can_carry_w( ch )
     && container == NULL )
    {
        act( "$d: you can't carry that much weight.",
             ch, NULL, STR(obj, name), TO_CHAR );
        return;
    }

    if ( container != NULL )
    {
        act( "You get $p from $P.", ch, obj, container, TO_CHAR );
        act( "$n gets $p from $P.", ch, obj, container, TO_ROOM );
        obj_from_obj( obj );
        if ( !fMoney ) obj_to_char( obj, ch );
        else           obj_to_char_money( obj, ch );
        obj->wear_loc = hand_empty( ch );
        script_update( obj, TYPE_OBJ, TRIG_GETS, ch, obj, NULL, NULL );
    }
    else
    {
        act( "You get $p.", ch, obj, container, TO_CHAR );
        act( "$n gets $p.", ch, obj, container, TO_ROOM );
        obj_from_room( obj );
        obj_to_char_money( obj, ch );
        if ( obj->carried_by != NULL )    obj->wear_loc = hand_empty( ch );
        script_update( obj, TYPE_OBJ, TRIG_GETS, ch, NULL, NULL, NULL );
    }

    return;
}



/*
 * Syntax: get [object]
 *         get all
 *         get all [object]
 *         get all.[object]
 *         get all.[object] [object]
 */
void do_get( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    OBJ_DATA *container;
    bool found;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' )
    {
	send_to_char( "Get what?\n\r", ch );
	return;
    }

    if ( arg2[0] == '\0' )
    {
        if ( str_cmp( arg1, "all" ) && str_prefix( "all.", arg1 ) )
        {
            obj = get_obj_list( ch, arg1, ch->in_room->contents );
            if ( obj == NULL )
            {
                act( "I see no $T here.", ch, NULL, arg1, TO_CHAR );
                return;
            }
            get_obj( ch, obj, NULL, TRUE );
        }
        else
        {
            found = FALSE;
            for ( obj = ch->in_room->contents; obj != NULL; obj = obj_next )
            {
                obj_next = obj->next_content;
                if ( ( arg1[3] == '\0' || is_name( &arg1[4], STR(obj, name) ) )
                &&   can_see_obj( ch, obj ) )
                {
                    found = TRUE;
                    get_obj( ch, obj, NULL, TRUE );
                    if ( hand_empty( ch ) == WEAR_NONE ) break;
                }
            }

            if ( !found )
            {
                if ( arg1[3] == '\0' )
                send_to_char( "I see nothing here.\n\r", ch );
                else
                act( "I see no $T here.", ch, NULL, &arg1[4], TO_CHAR );
            }
        }
    }
    else
    {
        if ( !str_cmp( arg2, "all" ) || !str_prefix( "all.", arg2 ) )
        {
            send_to_char( "You can't do that.\n\r", ch );
            return;
        }

        if ( ( container = get_obj_here( ch, arg2 ) ) == NULL )
        {
            act( "I see no $T here.", ch, NULL, arg2, TO_CHAR );
            return;
        }

        switch ( container->item_type )
        {
            default: send_to_char( "That's not a container.\n\r", ch );
                     return;

            case ITEM_FURNITURE:
             if ( !VAL_SET(container, 1, FURN_PUT) )
             {
                send_to_char( "That's not a container.\n\r", ch );
                return;
             }
            case ITEM_CONTAINER:
            case ITEM_CORPSE_NPC:
            case ITEM_CORPSE_PC:
            break;
        }

        if ( IS_SET(container->value[1], CONT_CLOSED) )
        {
            act( "The $t is closed.",
                 ch, smash_article(STR(container, name)), NULL, TO_CHAR );
            return;
        }

        if ( str_cmp( arg1, "all" ) && str_prefix( "all.", arg1 ) )
        {
            /* 'get obj container' */
            obj = get_obj_list( ch, arg1, container->contains );
            if ( obj == NULL )
            {
            act( "I see nothing like that in the $T.", ch, NULL, arg2, TO_CHAR );
            return;
            }
            get_obj( ch, obj, container, container->carried_by != ch );
        }
        else
        {
            /* 'get all container' or 'get all.obj container' */
            found = FALSE;
            for ( obj = container->contains; obj != NULL; obj = obj_next )
            {
            obj_next = obj->next_content;
                if ( ( arg1[3] == '\0' || is_name( &arg1[4], STR(obj, name) ) )
                    &&   can_see_obj( ch, obj ) )
            {
                found = TRUE;
                get_obj( ch, obj, container, container->carried_by != ch );
                        if ( hand_empty( ch ) == WEAR_NONE ) break;
            }
            }

            if ( !found )
            {
            if ( arg1[3] == '\0' )
                act( "I see nothing in the $T.", ch, NULL, arg2, TO_CHAR );
            else
                act( "I see nothing like that in the $T.",
                     ch, NULL, arg2, TO_CHAR );
            }
        }
    }

    return;
}




/*
 * Syntax:  put [object] [object]
 *          put all.[object] [object]
 */
void do_put( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *container;
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
	send_to_char( "Put what in what?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg2, "all" ) || !str_prefix( "all.", arg2 ) )
    {
	send_to_char( "You can't do that.\n\r", ch );
	return;
    }

    if ( ( container = get_obj_here( ch, arg2 ) ) == NULL )
    {
	act( "I see no $T here.", ch, NULL, arg2, TO_CHAR );
	return;
    }

    if ( container->item_type != ITEM_CONTAINER
      && container->item_type != ITEM_FURNITURE )
    {
        send_to_char( "That's not a container.\n\r", ch );
        return;
    }
    
    if ( container->item_type == ITEM_FURNITURE 
      && !IS_SET(container->value[1], FURN_PUT) )
    {
        send_to_char( "You can't put anything on that.\n\r", ch );
        return;
    }

    if ( IS_SET(container->value[1], CONT_CLOSED) )
    {
    act( "The $t is closed.",
         ch, smash_article(STR(container, name)), NULL, TO_CHAR );
	return;
    }

    if ( str_cmp( arg1, "all" ) && str_prefix( "all.", arg1 ) )
    {
	/* 'put obj container' */
    if ( ( obj = get_obj_inv( ch, arg1 ) ) == NULL )
	{
	    send_to_char( "You do not have that item.\n\r", ch );
	    return;
	}

	if ( obj == container )
	{
	    send_to_char( "You can't fold it into itself.\n\r", ch );
	    return;
	}

	if ( !can_drop_obj( ch, obj ) )
	{
	    send_to_char( "You can't let go of it.\n\r", ch );
	    return;
	}

    if ( get_obj_weight( obj ) + (get_obj_weight(container) - container->weight) > container->value[0] )
	{
	    send_to_char( "It won't fit.\n\r", ch );
	    return;
	}

	obj_from_char( obj );
    obj_to_obj( obj, container );
    if ( container->item_type != ITEM_FURNITURE )
    {
    act( "$n puts $p in $P.", ch, obj, container, TO_ROOM );
    act( "You put $p in $P.", ch, obj, container, TO_CHAR );
    }
    else
    {
    act( "$n places $p on $P.", ch, obj, container, TO_ROOM );
    act( "You place $p on $P.", ch, obj, container, TO_CHAR );
    }
    merge_money_obj( container );
    }
    else
    {
    /* 'put all container' or 'put all.obj container' */
	for ( obj = ch->carrying; obj != NULL; obj = obj_next )
	{
	    obj_next = obj->next_content;

        if ( ( arg1[3] == '\0' || is_name( &arg1[4], STR(obj, name) ) )
	    &&   can_see_obj( ch, obj )
            &&   INV(obj->wear_loc)
	    &&   obj != container
	    &&   can_drop_obj( ch, obj )
	    &&   get_obj_weight( obj ) + get_obj_weight( container )
		 <= container->value[0] )
	    {
		obj_from_char( obj );
        obj_to_obj( obj, container );
        if ( container->item_type != ITEM_FURNITURE )
        {
        act( "$n puts $p in $P.", ch, obj, container, TO_ROOM );
        act( "You put $p in $P.", ch, obj, container, TO_CHAR );
        }
        else
        {
        act( "$n places $p on $P.", ch, obj, container, TO_ROOM );
        act( "You place $p on $P.", ch, obj, container, TO_CHAR );
        }
        merge_money_obj( container );
	    }
	}
    }

    return;
}



/*
 * Syntax:  dump [object]
 *          dump [object] [object]
 */
void do_dump( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *container1, *container2 = NULL;
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Dump what (into what)?\n\r", ch );
	return;
    }

    if ( (container1 = get_obj_here( ch, arg1 )) == NULL )
    {
        send_to_char( "You can't find that here.\n\r", ch );
        return;
    }

    if ( arg2[0] != '\0' && (container2 = get_obj_here( ch, arg2 )) == NULL )
    {
        send_to_char( "You can't find that here to dump it into.\n\r", ch );
        return;
    }

    if ( container1->item_type != ITEM_CONTAINER )
    {
        send_to_char( "That's not a container that you can dump out.\n\r", ch );
        return;
    }

    if ( VAL_SET(container1, 1, CONT_CLOSED) )
    {
        send_to_char( "It is closed.\n\r", ch );
        return;
    }

    if ( container2 )
    {
        if ( container2->item_type != ITEM_CONTAINER )
        {
            send_to_char( "That's not a container that you can dump out.\n\r", ch );
            return;
        }

        if ( VAL_SET(container2, 1, CONT_CLOSED) )
        {
            send_to_char( "You can't dump anything into it, it is closed.\n\r", ch );
            return;
        }

        for ( obj = container1->contains;  obj != NULL; obj = obj_next )
        {
        obj_next = obj->next_content;

        if ( get_obj_weight( obj ) + get_obj_weight( container2 ) > container2->value[0] )
        {
        send_to_char( "It won't all fit.\n\r", ch );
        act( "$n dumps a portion of the contents of $p into $P.", ch, container1, container2, TO_ROOM );
	    return;
        }

        obj_from_obj( obj );
        obj_to_obj( obj, container2 );
        }

        act( "$n dumps the contents of $p into $P.", ch, container1, container2, TO_ROOM );
        act( "You dump the contents of $p into $P.", ch, container1, container2, TO_CHAR );
    }
    else
    {
        act( "$n dumps the contents of $p onto the ground.", ch, container1, NULL, TO_ROOM );
        act( "You dump the contents of $p onto the ground.", ch, container1, NULL, TO_CHAR );

        for ( obj = container1->contains;  obj != NULL; obj = obj_next )
        {
            obj_next = obj->next_content;

            obj_from_obj( obj );
            obj_to_room( obj, ch->in_room );
        }
    }

    return;
}




/*
 * Syntax:  drop [object]
 *          drop all
 *          drop all.[object]
 *          drop [number] [money object]
 */
void do_drop( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    int amount = 0;
    bool found;

    argument = one_argument( argument, arg );
    if ( is_number( arg ) )
    {
        amount = atoi( arg );
        argument = one_argument( argument, arg );
    }

    if ( arg[0] == '\0' )
    {
	send_to_char( "Drop what?\n\r", ch );
	return;
    }

    if ( str_cmp( arg, "all" ) && str_prefix( "all.", arg ) )
    {
	/* 'drop obj' */
    if ( ( obj = get_obj_inv( ch, arg ) ) == NULL )
	{
        send_to_char( "You do not have that item.\n\r", ch );
	    return;
	}
    else
    if ( !NOT_WORN(obj) )
    {
        send_to_char( "You will have to remove it first.\n\r", ch );
        return;
    }

	if ( !can_drop_obj( ch, obj ) )
	{
	    send_to_char( "You can't let go of it.\n\r", ch );
	    return;
	}

    if ( obj->item_type == ITEM_MONEY )
    {
        OBJ_DATA *pnewobj;

        if ( amount > obj->value[0] || amount == 0 )
        amount = obj->value[0];

        obj->value[0] -= amount;


        update_money( obj );
        obj_to_room( (pnewobj = create_money( amount, obj->value[1] )), ch->in_room );

        act( "$n drops $p.", ch, pnewobj, NULL, TO_ROOM );
        act( "You drop $p.", ch, pnewobj, NULL, TO_CHAR );
        strip_empty_money( ch );
        merge_money( ch );
        return;
    }

	obj_from_char( obj );
	obj_to_room( obj, ch->in_room );
	act( "$n drops $p.", ch, obj, NULL, TO_ROOM );
	act( "You drop $p.", ch, obj, NULL, TO_CHAR );
    }
    else
    {
	/* 'drop all' or 'drop all.obj' */
	found = FALSE;
	for ( obj = ch->carrying; obj != NULL; obj = obj_next )
	{
	    obj_next = obj->next_content;

        if ( ( arg[3] == '\0' || is_name( &arg[4], STR(obj, name) ) )
	    &&   can_see_obj( ch, obj )
            && INV(obj->wear_loc)
	    &&   can_drop_obj( ch, obj ) )
	    {
		found = TRUE;
		obj_from_char( obj );
		obj_to_room( obj, ch->in_room );
		act( "$n drops $p.", ch, obj, NULL, TO_ROOM );
		act( "You drop $p.", ch, obj, NULL, TO_CHAR );
	    }
	}

	if ( !found )
	{
	    if ( arg[3] == '\0' )
		act( "You are not carrying anything.",
		    ch, NULL, arg, TO_CHAR );
	    else
        act( "You are not carrying $T.",
		    ch, NULL, &arg[4], TO_CHAR );
	}
    }

    return;
}



/*
 * Syntax:  give [object] [person]
 *          give [number] [money object] [person]
 */
void do_give( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA  *obj;
    int amount = 0;

    argument = one_argument( argument, arg1 );

    if ( is_number( arg1 ) )
    {
        amount = atoi( arg1 );
        argument = one_argument( argument, arg1 );
    }

    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
	send_to_char( "Give what to whom?\n\r", ch );
	return;
    }

	if ( ( victim = get_char_room( ch, arg2 ) ) == NULL )
	{
	    send_to_char( "They aren't here.\n\r", ch );
	    return;
	}

    if ( ( obj = get_obj_inv( ch, arg1 ) ) == NULL )
    {
	send_to_char( "You do not have that item.\n\r", ch );
	return;
    }

    if ( !NOT_WORN( obj ) )
    {
        if ( obj->wear_loc == WEAR_WIELD_1
          || obj->wear_loc == WEAR_WIELD_2 )
        {
            if ( IS_SET(obj->extra_flags, ITEM_USED) )
            {
                unequip_char( ch, obj );
                act( "$n stops wielding $p.", ch, obj, NULL, TO_ROOM );
                act( "You stop wielding $p.", ch, obj, NULL, TO_CHAR );
            }
            obj->wear_loc   = hand_empty( ch );
        }
        else
        {
            send_to_char( "You must remove it first.\n\r", ch );
            return;
        }
    }

    if ( ( victim = get_char_room( ch, arg2 ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( !can_drop_obj( ch, obj ) )
    {
	send_to_char( "You can't let go of it.\n\r", ch );
	return;
    }

    if ( hand_empty( victim ) == WEAR_NONE  && !IS_IMMORTAL(victim)
      && obj->item_type != ITEM_MONEY )
    {
	act( "$N has $S hands full.", ch, NULL, victim, TO_CHAR );
	return;
    }

    if ( obj->item_type == ITEM_MONEY )
    {
        int oldval = obj->value[1];

        if ( amount > obj->value[0] || amount == 0 )
        amount = obj->value[0];

        obj->value[0] -= amount;

        update_money( obj );
        obj = create_money( amount, oldval );

        strip_empty_money( ch );
        merge_money( ch );
    }                     

    if ( victim->carry_weight + get_obj_weight( obj ) > can_carry_w( victim ) )
    {
	act( "$N can't carry that much weight.", ch, NULL, victim, TO_CHAR );
	return;
    }

    if ( !can_see_obj( victim, obj ) )
    {
	act( "$N can't see it.", ch, NULL, victim, TO_CHAR );
	return;
    }

    act( "$n gives $p to $N.", ch, obj, victim, TO_NOTVICT );
    act( "$n gives you $p.",   ch, obj, victim, TO_VICT    );
    act( "You give $p to $N.", ch, obj, victim, TO_CHAR    );

    if ( obj->carried_by != NULL ) obj_from_char( obj );
    if ( obj->carried_by != NULL ) obj->wear_loc = hand_empty( victim );
    else                           obj->wear_loc = WEAR_NONE;
    obj_to_char_money( obj, victim );

    return;
}



/*
 * Syntax:  fill [object]
 *          fill [lantern] [object]
 */
void do_fill( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    OBJ_DATA *fountain;
    bool found;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Fill what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_carry( ch, arg ) ) == NULL )
    {
    send_to_char( "You do not have that item in your hands.\n\r", ch );
	return;
    }

    if ( obj->item_type == ITEM_DRINK_CON )
    {
         found = FALSE;
         for ( fountain = ch->in_room->contents; fountain != NULL;
         fountain = fountain->next_content )
         {
         if ( fountain->item_type == ITEM_FOUNTAIN )
         {
             found = TRUE;
             break;
         }
         }

         if ( !found )
         {
         send_to_char( "There is no fountain here!\n\r", ch );
         return;
         }

         if ( obj->value[2] != 0 && obj->value[0] > 0 )
         do_pour( ch, arg );

         if ( obj->value[0] >= obj->value[1] )
         {
         send_to_char( "Your container is full.\n\r", ch );
         return;
         }

         act( "You fill $p with the water from $P.", ch, obj, fountain, TO_CHAR );
         act( "$n fills $p with water from $P.", ch, obj, fountain, TO_ROOM );
         obj->value[2] = 0; /* fountains are water */
         obj->value[0] = obj->value[1];
    }
    else
    if ( obj->item_type == ITEM_LIGHT )
    {
        OBJ_DATA *obj2;

        if ( ( obj2 = get_item_held( ch, ITEM_DRINK_CON ) ) == NULL )
        {
        send_to_char( "You don't have anything in your hand to fill it with.\n\r", ch );
        return;
        }

        if ( !IS_SET(obj->value[3], LIGHT_FILLABLE) )
        {
        send_to_char( "It can't be refueled.\n\r", ch );
        return;
        }

        if ( obj2->value[2] != LIQ_OIL )
        {
        send_to_char( "There's no oil in that container.\n\r", ch );
        return;
        }

        if ( obj->value[0] != 0 )
        {
        send_to_char( "There is already some oil in it.\n\r", ch );
        return;
        }

        if (obj2->value[0] >= obj->value[1] )
        {
            act( "You fill $p with $P.", ch, obj, obj2, TO_CHAR );
            obj->value[0] = obj->value[1];
            obj2->value[1] += -(obj->value[0]);
        }
        else
        {
            act( "You empty $P into $p.", ch, obj, obj2, TO_CHAR );
            obj->value[0] = obj2->value[1];
            obj2->value[0] = 0;
            REMOVE_BIT(obj2->extra_flags, ITEM_INVENTORY);
        }
    }
    else
    {
    send_to_char( "You can't fill that.\n\r", ch );
    return;
    }

    return;
}



/*
 * Syntax:  pour [object]
 *          pour [object] [object]
 */
void do_pour( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *obj1;
    OBJ_DATA *obj2 = NULL;

    argument = one_argument( argument, arg1 );
    one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || ( obj1 = get_obj_here( ch, arg1 ) ) == NULL )
	{
        send_to_char( "Pour from what?\n\r", ch );
	    return;
	}
	
	if ( obj1->item_type != ITEM_DRINK_CON
	  || obj1->value[0] <= 0 )
	{
         send_to_char( "You can't pour anything from that.\n\r", ch );
         return;
    }		

    if ( arg2[0] == '\0')
	{
        obj1->value[0] = 0;
        act( "You pour $t from $P onto the ground.",
             ch, liq_table[URANGE(0,obj1->value[2],LIQ_MAX)].liq_name,
             obj1, TO_CHAR );
        act( "$n pours $t from $P onto the ground.",
             ch, liq_table[URANGE(0,obj1->value[2],LIQ_MAX)].liq_name,
             obj1, TO_ROOM );
        obj1->value[3] = 0;
	    return;
	}
	
	if (( obj2 = get_obj_here( ch, arg2 ) ) == NULL)
	{
		act( "Pour $t into what?", ch, obj1, NULL, TO_CHAR);
		return;
	}

    if ( obj1->item_type != ITEM_DRINK_CON )
    {
        send_to_char( "You can't pour anything from that.\n\r", ch );
        return;
    }

    if ( obj1->value[0] <= 0 )
    {
        send_to_char( "There is nothing to pour from that.\n\r", ch );
        return;
    }


    if ( obj2->item_type != ITEM_DRINK_CON )
    {
        send_to_char( "You can't pour anything into that.\n\r", ch );
        return;
    }

	/*
	 * Avoid mixing.
	 * Careful, a bit of recursion here!
	 */
    if ( obj2->value[2] != obj1->value[2] && obj2->value[0] > 0 )
        do_pour( ch, arg2 );

	/*
	 * Make liquid types identical.
	 */
    obj2->value[2] = obj1->value[2];

    sprintf( buf, "$n pours %s from $p into $P.",
             liq_table[URANGE(0,obj2->value[2],LIQ_MAX)].liq_name );
    act( buf, ch, obj1, obj2, TO_ROOM );
    sprintf( buf, "You pour %s from $p into $P.",
             liq_table[URANGE(0,obj2->value[2],LIQ_MAX)].liq_name );
    act( buf, ch, obj1, obj2, TO_CHAR );

    if ( obj2->value[0] + obj1->value[0] > obj2->value[1] )
    {
        obj1->value[0] -= (obj2->value[0] + obj1->value[0]) - obj2->value[1];
        obj2->value[0] = obj2->value[1];
        act( "You fill it as much as you can, but $p still contains some liquid.", ch, obj1, obj2, TO_CHAR );
    }
    else
    {
        obj2->value[0] += obj1->value[0];
        obj1->value[0] = 0;
    }


    return;
}



/*
 * Syntax:  drink [object]
 */
void do_drink( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int amount;
    int liquid;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	for ( obj = ch->in_room->contents; obj; obj = obj->next_content )
	{
	    if ( obj->item_type == ITEM_FOUNTAIN )
		break;
	}

	if ( obj == NULL )
	{
	    send_to_char( "Drink what?\n\r", ch );
	    return;
	}
    }
    else
    {
	if ( ( obj = get_obj_here( ch, arg ) ) == NULL )
	{
	    send_to_char( "You can't find it.\n\r", ch );
	    return;
	}
    }

    if ( !IS_NPC(ch) && PC(ch,condition[COND_DRUNK]) > IS_DRUNK )
    {
        send_to_char( "You fail to reach your mouth.\n\r", ch );
        act( "$n hiccups loudly.", ch, NULL, NULL, TO_ROOM );
	return;
    }

    switch ( obj->item_type )
    {
        default:
        send_to_char( "You can't drink from that.\n\r", ch );
        break;

        case ITEM_FOUNTAIN:
        if ( PC(ch,condition)[COND_THIRST] >= IS_FULL/2 )
        {
            send_to_char( "You are not thirsty enough.\n\r", ch );
            return;
        }

        if ( !IS_NPC(ch) )
            PC(ch,condition)[COND_THIRST] = IS_FULL/2;
            
        act( "$n drinks from $p.", ch, obj, NULL, TO_ROOM );
        act( "You drink a mighty draught from $p.", ch,
             obj, NULL, TO_CHAR );
        obj_cast_spell( obj->value[1], obj->value[0], ch, ch, NULL );
        obj_cast_spell( obj->value[2], obj->value[0], ch, ch, NULL );
        obj_cast_spell( obj->value[3], obj->value[0], ch, ch, NULL );
        break;

        case ITEM_DRINK_CON:
        if ( obj->value[0] <= 0 )
        {
            send_to_char( "It is already empty.\n\r", ch );
            if ( IS_SET(obj->value[3], DRINK_TAVERN) )
            {
                send_to_char( "You discard it.\n\r", ch );
                extract_obj(obj);
            }
            return;
        }

        if ( ( liquid = obj->value[2]) >= LIQ_MAX || liquid < 0 )
        {
            bug( "Do_drink: bad liquid number %d.", obj->pIndexData->vnum );
            liquid = obj->value[2] = 0;
        }

        if ( liquid == LIQ_OIL )
        {
        act( "$n drinks lamp oil from $p, and spits it out onto the ground in surprise.",
            ch, obj, NULL, TO_ROOM );
        act( "You drink oil from $p and spit it out in disgust.",
            ch, obj, NULL, TO_CHAR );
        amount = 1;
        }
        else
        {
        act( "$n drinks $T from $p.",
            ch, obj, liq_table[liquid].liq_name, TO_ROOM );
        act( "You drink $T from $p.",
            ch, obj, liq_table[liquid].liq_name, TO_CHAR );

        send_to_char( STR(obj,action_descr), ch );

        amount = number_range(3, 10);
        amount = UMIN(amount, obj->value[0]);

        gain_condition( ch, COND_DRUNK,
            amount * liq_table[liquid].liq_affect[COND_DRUNK  ] );
        gain_condition( ch, COND_FULL,
            amount * liq_table[liquid].liq_affect[COND_FULL   ] );
        gain_condition( ch, COND_THIRST,
            amount * liq_table[liquid].liq_affect[COND_THIRST ] );

        if ( !IS_NPC(ch) && PC(ch,condition)[COND_DRUNK]  > IS_DRUNK )
            send_to_char( "You feel drunk.\n\r", ch );
        if ( !IS_NPC(ch) && PC(ch,condition)[COND_FULL]   > IS_FULL )
            send_to_char( "You are full.\n\r", ch );
        if ( !IS_NPC(ch) && PC(ch,condition)[COND_THIRST] > IS_FULL )
            send_to_char( "You are no longer thirsty.\n\r", ch );

        if ( IS_SET(obj->value[3], DRINK_POISON) )
        {
            /* Poisoned! */
            AFFECT_DATA af;

            act( "$n chokes and gags.", ch, NULL, NULL, TO_ROOM );
            send_to_char( "You choke and gag.\n\r", ch );
            af.type      = gsn_poison;
            af.duration  = 3 * amount;
            af.location  = APPLY_NONE;
            af.modifier  = 0;
            af.bitvector = AFF_POISON;
            affect_join( ch, &af );
        }
    }
	
        obj->value[0] -= amount;
        if ( obj->value[0] <= 0 )
        {
            obj->value[0] = 0;
            REMOVE_BIT(obj->extra_flags, ITEM_INVENTORY);
            if ( IS_SET(obj->value[3], DRINK_TAVERN) )
            {
                send_to_char( "You discard it.\n\r", ch );
                extract_obj(obj);
            }
        }
        
        if ( obj->value[1] <= 0 )
        {
            act( "You discard $p.", ch, NULL, NULL, TO_CHAR );
            extract_obj( obj );
        }
    break;
    }

    return;
}






/*
 * Syntax:  eat [object]
 */
void do_eat( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    OBJ_DATA *obj2;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
	send_to_char( "Eat what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_inv( ch, arg ) ) == NULL )
    {
	send_to_char( "You do not have that item.\n\r", ch );
	return;
    }

    if ( !IS_IMMORTAL(ch) )
    {
        if ( obj->item_type != ITEM_FOOD && obj->item_type != ITEM_PILL )
	{
	    send_to_char( "That's not edible.\n\r", ch );
	    return;
	}

    if ( !IS_NPC(ch) && PC(ch,condition)[COND_FULL] > IS_FULL )
	{   
	    send_to_char( "You are too full to eat more.\n\r", ch );
	    return;
	}
    }
    else
    {
        if ( obj->item_type == ITEM_LIGHT && IS_LIT(obj) )
            --ch->in_room->light;
    }

    act( "$n eats $p.",  ch, obj, NULL, TO_ROOM );
    act( "You eat $p.", ch, obj, NULL, TO_CHAR );

    if ( obj->item_type == ITEM_FOOD )
    send_to_char( STR(obj,action_descr), ch );

    switch ( obj->item_type )
    {

    case ITEM_FOOD:
	if ( !IS_NPC(ch) )
	{
	    int condition;

        condition = PC(ch,condition)[COND_FULL];
            gain_condition( ch, COND_FULL, obj->value[0] );
            
        if ( condition == 0 && PC(ch,condition)[COND_FULL] >= IS_FULL/2 )
                send_to_char( "You are satisfied.\n\r", ch );
        else if ( PC(ch,condition)[COND_FULL] > IS_FULL )
                send_to_char( "You are full.\n\r", ch );
        }
  
        if ( obj->value[3] != 0 )
        {
        /* Poisoned! */
	    AFFECT_DATA af;

	    act( "$n chokes and gags.", ch, 0, 0, TO_ROOM );
	    send_to_char( "You choke and gag.\n\r", ch );

	    af.type      = gsn_poison;
	    af.duration  = 2 * obj->value[0];
	    af.location  = APPLY_NONE;
	    af.modifier  = 0;
	    af.bitvector = AFF_POISON;
	    affect_join( ch, &af );
	}

        /*
         * Slap the reference object on 'em.
         */
        if ( get_obj_index( obj->value[2] ) != NULL )
        {
        obj2 = create_object( get_obj_index( obj->value[2] ), 0 );
        obj_to_char( obj2, ch );
        if ( IS_SET(obj->extra_flags, ITEM_USED) )
        SET_BIT(obj2->extra_flags, ITEM_USED);
        obj2->wear_loc = obj->wear_loc;
        }
	break;

    case ITEM_PILL:
	obj_cast_spell( obj->value[1], obj->value[0], ch, ch, NULL );
	obj_cast_spell( obj->value[2], obj->value[0], ch, ch, NULL );
	obj_cast_spell( obj->value[3], obj->value[0], ch, ch, NULL );
	break;
    }

    extract_obj( obj );
    return;
}



/*
 * Syntax:  quaff [potion]
 */
void do_quaff( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        send_to_char( "Quaff what?\n\r", ch );
        return;
    }

    if ( ( obj = get_obj_inv( ch, arg ) ) == NULL )
    {
        send_to_char( "You do not have that potion.\n\r", ch );
        return;
    }

    if ( obj->item_type != ITEM_POTION )
    {
        send_to_char( "You can quaff only potions.\n\r", ch );
        return;
    }

    act( "$n quaffs $p.", ch, obj, NULL, TO_ROOM );
    act( "You quaff $p.", ch, obj, NULL ,TO_CHAR );

    send_to_char( STR(obj,action_descr), ch );

    obj_cast_spell( obj->value[1], obj->value[0], ch, ch, NULL );
    obj_cast_spell( obj->value[2], obj->value[0], ch, ch, NULL );
    obj_cast_spell( obj->value[3], obj->value[0], ch, ch, NULL );

    extract_obj( obj );
    return;
}



/*
 * Syntax:  recite [scroll]
 */
void do_recite( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *scroll;
    OBJ_DATA *obj;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( ( scroll = get_obj_inv( ch, arg1 ) ) == NULL )
    {
        send_to_char( "You do not have that scroll.\n\r", ch );
        return;
    }

    if ( scroll->item_type != ITEM_SCROLL )
    {
        send_to_char( "You can recite only scrolls.\n\r", ch );
        return;
    }

    obj = NULL;
    if ( arg2[0] == '\0' )
    {
        victim = ch;
    }
    else
    {
        if ( ( victim = get_char_room ( ch, arg2 ) ) == NULL
        &&   ( obj    = get_obj_here  ( ch, arg2 ) ) == NULL )
        {
            send_to_char( "You can't find it.\n\r", ch );
            return;
        }
    }

    act( "$n recites $p.", ch, scroll, NULL, TO_ROOM );
    act( "You recite $p.", ch, scroll, NULL, TO_CHAR );

    send_to_char( STR(obj,action_descr), ch );

    obj_cast_spell( scroll->value[1], scroll->value[0], ch, victim, obj );
    obj_cast_spell( scroll->value[2], scroll->value[0], ch, victim, obj );
    obj_cast_spell( scroll->value[3], scroll->value[0], ch, victim, obj );

    extract_obj( scroll );
    return;
}



/*
 * Syntax:  brandish [object]
 */
void do_brandish( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    OBJ_DATA *staff;
    int sn;

    if ( ( staff = get_item_held( ch, ITEM_STAFF ) ) == NULL )
    {
    send_to_char( "You don't have the staff in your hand.\n\r", ch );
        return;
    }


    if ( ( sn = staff->value[3] ) < 0
    ||   sn >= MAX_SKILL
    ||   skill_table[sn].spell_fun == 0 )
    {
        bug( "Do_brandish: bad sn %d.", sn );
        return;
    }

    WAIT_STATE( ch, 2 * PULSE_VIOLENCE );

    if ( staff->value[2] > 0 )
    {
    act( "$n raises $p into the air and mutters mystical words under $s breath.",
         ch, staff, NULL, TO_ROOM );
    act( "You brandish $p.", ch, staff, NULL, TO_CHAR );

    send_to_char( STR(staff,action_descr), ch );

        for ( vch = ch->in_room->people; vch; vch = vch_next )
        {
            vch_next    = vch->next_in_room;

            switch ( skill_table[sn].target )
            {
            default:
                bug( "Do_brandish: bad target for sn %d.", sn );
                return;

            case TAR_IGNORE:
                if ( vch != ch )
                    continue;
                break;

            case TAR_CHAR_OFFENSIVE:
                if ( IS_NPC(ch) ? IS_NPC(vch) : !IS_NPC(vch) )
                    continue;
                break;
                
            case TAR_CHAR_DEFENSIVE:
                if ( IS_NPC(ch) ? !IS_NPC(vch) : IS_NPC(vch) )
                    continue;
                break;

            case TAR_CHAR_SELF:
                if ( vch != ch )
                    continue;
                break;
            }

            obj_cast_spell( staff->value[3], staff->value[0], ch, vch, NULL );
        }
    }

    if ( --staff->value[2] <= 0 )
    {
        act( "$n's $p blazes bright and is gone.", ch, staff, NULL, TO_ROOM );
        act( "Your $p blazes bright and is gone.", ch, staff, NULL, TO_CHAR );
        extract_obj( staff );
    }

    return;
}



/*
 * Syntax:  zap [object] [person]
 */
void do_zap( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *wand;
    OBJ_DATA *obj;

    one_argument( argument, arg );
    if ( arg[0] == '\0' && ch->fighting == NULL )
    {
        send_to_char( "Zap whom or what?\n\r", ch );
        return;
    }

    if ( ( wand = get_item_held( ch, ITEM_WAND ) ) == NULL )
    {
    send_to_char( "You don't have a wand in your hand.\n\r", ch );
        return;
    }

    obj = NULL;
    if ( arg[0] == '\0' )
    {
        if ( ch->fighting != NULL )
        {
            victim = ch->fighting;
        }
        else
        {
            send_to_char( "Zap whom or what?\n\r", ch );
            return;
        }
    }
    else
    {
        if ( ( victim = get_char_room ( ch, arg ) ) == NULL
        &&   ( obj    = get_obj_here  ( ch, arg ) ) == NULL )
        {
            send_to_char( "You can't find it.\n\r", ch );
            return;
        }
    }

    WAIT_STATE( ch, 2 * PULSE_VIOLENCE );

    if ( wand->value[2] > 0 )
    {
        if ( victim != NULL )
        {
            act( "$n zaps $N with $p.", ch, wand, victim, TO_ROOM );
            act( "You zap $N with $p.", ch, wand, victim, TO_CHAR );
        }
        else
        {
            act( "$n zaps $P with $p.", ch, wand, obj, TO_ROOM );
            act( "You zap $P with $p.", ch, wand, obj, TO_CHAR );
        }

    send_to_char( STR(wand,action_descr), ch );

        obj_cast_spell( wand->value[3], wand->value[0], ch, victim, obj );
    }

    if ( --wand->value[2] <= 0 )
    {
        act( "$n's $p explodes into fragments.", ch, wand, NULL, TO_ROOM );
        act( "Your $p explodes into fragments.", ch, wand, NULL, TO_CHAR );
        extract_obj( wand );
    }

    return;
}



/*
 * Syntax:  steal [object] [person]
 */
void do_steal( CHAR_DATA *ch, char *argument )
{
    char buf  [MAX_STRING_LENGTH];
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    int percent;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
        send_to_char( "Steal what from whom?\n\r", ch );
        return;
    }

    if ( hand_empty( ch ) == WEAR_NONE )
    {
        send_to_char( "You'll need to free a hand first.\n\r", ch );
        return;
    }

    if ( ( victim = get_char_room( ch, arg2 ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    if ( victim == ch )
    {
    send_to_char( "Like a dull sword, that's pointless.\n\r", ch );
        return;
    }

    WAIT_STATE( ch, skill_table[gsn_steal].beats );
    percent  = number_percent( ) + ( IS_AWAKE(victim) ? 10 : -50 );

    if ( victim->position == POS_FIGHTING
    || !skill_check( ch, gsn_steal, 10 ) )
    {
        /*
         * Failure.
         */
    ch->bounty += 10;
        send_to_char( "Oops.\n\r", ch );
        act( "$n tried to steal from you.\n\r", ch, NULL, victim, TO_VICT    );
        act( "$n tried to steal from $N.\n\r",  ch, NULL, victim, TO_NOTVICT );
    sprintf( buf, "%s is a bloody thief!", NAME(ch) );
    send_to_char( buf, victim );

        if ( !IS_NPC(ch) )
        {
            if ( IS_NPC(victim) )
            {
        oroc( victim, ch );
            }
            else
            {
                log_string( buf );
            }
        }

        return;
    }

    if ( ( obj = get_obj_inv( victim, arg1 ) ) == NULL )
    {
        send_to_char( "You can't find it.\n\r", ch );
        return;
    }
        
    if ( !can_drop_obj( ch, obj ) || ( !skill_check( ch, gsn_steal, 0 ) ) )
    {
    send_to_char( "You can't get it away.\n\r", ch );
        return;
    }

    if ( ch->carry_weight + get_obj_weight( obj ) > can_carry_w( ch ) )
    {
        send_to_char( "You can't carry that much weight.\n\r", ch );
        return;
    }

    if ( IS_SET(obj->extra_flags, ITEM_INVENTORY) )
    {
        ch->bounty += 30;
        obj = create_object( obj->pIndexData, 0 );
    }
    else
    obj_from_char( obj );

    obj_to_char( obj, ch );
    obj->wear_loc = hand_empty( ch );
    send_to_char( "Stolen.\n\r", ch );
    return;
}



/*
 * Syntax:  light [object]
 */
void do_light( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    OBJ_DATA *obj2;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
        obj = get_item_held( ch, ITEM_LIGHT );
   else obj = get_obj_carry( ch, arg );

    obj2 = get_item_held( ch, ITEM_TOOL );

    /*
     * Lamplighters.
     */
    if ( obj == NULL )
    obj = get_obj_here( ch, arg );

    if ( obj == NULL )
    {
        send_to_char( "You don't have the light in your hands.\n\r", ch );
        return;
    }

    if ( IS_LIT( obj ) )
    {
        send_to_char( "It's lit already!\n\r", ch );
        return;
    }

    if ( obj->value[0] <= 0 )
    {
        send_to_char( "It's out of fuel.\n\r", ch );
        return;
    }

    if ( obj2 == NULL )
    {
        send_to_char( "You don't have anything to light it with!\n\r", ch );
        return;
    }

    if ( use_tool( obj2, TOOL_TINDERBOX ) )
    {
        SET_BIT(obj->value[3], LIGHT_LIT);
        act( "$n lights $p with $P.", ch, obj, obj2, TO_ROOM );
        act( "You light $p with $P.", ch, obj, obj2, TO_CHAR );

        ch->in_room->light++;
        return;
    }
    else
    {
        send_to_char( "You can't light it with that.\n\r", ch );
        return;
    }

    return;
}



/*
 * Syntax:  extinguish [object]
 */
void do_extinguish( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
        obj = get_item_held( ch, ITEM_LIGHT );
   else obj = get_obj_carry( ch, arg );

    if ( obj == NULL )
    {
        send_to_char( "You don't have the light in your hands.\n\r", ch );
        return;
    }

    if ( !IS_LIT( obj ) )
    {
        send_to_char( "It's extinguished already!\n\r", ch );
        return;
    }

    send_to_char( STR(obj,action_descr), ch );

    REMOVE_BIT( obj->value[3], LIGHT_LIT );
    act( "$n extinguishes $p.", ch, obj, NULL, TO_ROOM );
    act( "You extinguish $p.", ch, obj, NULL, TO_CHAR );

    ch->in_room->light--;
    return;
}



void do_swap( CHAR_DATA *ch, char *argument )
{
	char arg1[MAX_INPUT_LENGTH];
	char arg2[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    OBJ_DATA *obj1, *obj2;
    
    argument = one_argument( argument, arg1 );
    one_argument( argument, arg2 );
    
    /*
     * Do the default -- swap between hands.
     */
    if ( arg1[0] == '\0' 
      || arg2[0] == '\0' )
    {
	    obj1 = get_eq_char( ch, WEAR_WIELD_1 );
    	if ( obj1 == NULL )
	    obj1 = get_eq_char( ch, WEAR_HOLD_1 );

	    obj2 = get_eq_char( ch, WEAR_WIELD_2 );
	    if ( obj2 == NULL )
	    obj2 = get_eq_char( ch, WEAR_HOLD_2 );

	    if ( obj1 && obj2 )
	    act( "$n swap$v $p and $P between $s two hands.", 
	         ch, obj1, obj2, TO_ALL );
	    else
	    if ( obj1 && !obj2 )
	    act( "$n swap$v $s $p into $s secondary hand.", 
	         ch, obj1, NULL, TO_ALL );
	    else
	    if ( !obj1 && obj2 )
	    act( "$n swap$v $s $p into $s primary hand.", 
	         ch, obj2, NULL, TO_ALL );
	    else
	    {
	        send_to_char( "You have nothing in your hands.\n\r", ch );
    	    return;
	    }

    	if ( obj1 )
	    {
	        if ( obj1->wear_loc == WEAR_HOLD_1 )   obj1->wear_loc = WEAR_HOLD_2;
	        if ( obj1->wear_loc == WEAR_WIELD_1 )  obj1->wear_loc = WEAR_WIELD_2;
	    }

    	if ( obj2 )
	    {
	        if ( obj2->wear_loc == WEAR_HOLD_2 )   obj2->wear_loc = WEAR_HOLD_1;
	        if ( obj2->wear_loc == WEAR_WIELD_2 )  obj2->wear_loc = WEAR_WIELD_1;
	    }
	}
	else
	{
		OBJ_DATA *con1 = NULL;
		OBJ_DATA *con2 = NULL;
		
		obj1 = get_obj_carry( ch, arg1 );
		obj2 = get_obj_carry( ch, arg2 );
		
		/*
		 * Search containers on PC for first object.
		 */
		if ( obj1 == NULL )
		{
		    for ( con1 = ch->carrying; con1 != NULL && obj1 == NULL;  con1 = con1->next_content )
		    {		           
		    	if ( can_see_obj( ch, con1 ) 
		    	  && ( ( con1->item_type == ITEM_CONTAINER
    		    	  || con1->item_type == ITEM_FURNITURE )
        	          && !IS_SET(con1->value[1], CONT_CLOSED) ) )
		    	obj1 = get_obj_list( ch, arg1, con1->contains );
		    }
		}
		
		if ( obj1 == NULL )
		{
			send_to_char( "Swap what?\n\r", ch);
			return;
		}
				
		/*
		 * Search containers on PC for second object.
		 */
		if ( obj2 == NULL )
		{
		    for ( con2 = ch->carrying; con2 != NULL && obj2 == NULL;  con2 = con2->next_content )
		    {		           
		    	if ( can_see_obj( ch, con2 ) 
		    	  && ( ( con2->item_type == ITEM_CONTAINER
    		    	  || con2->item_type == ITEM_FURNITURE )
        	          && !IS_SET(con2->value[1], CONT_CLOSED) ) )
		    	obj2 = get_obj_list( ch, arg2, con2->contains );
		    }
		}
		
		if ( obj2 == NULL )
		{
			send_to_char( "Swap what?\n\r", ch );
			return;
		}
		
		if ( (con1 == NULL && con2 == NULL) 
		  || (con1 != NULL && con2 != NULL) )
		{
			send_to_char( "Swap what with what?\n\r", ch );
			return;
		}
		
		/*
		 * CHECK FOR WEIGHT RESTRAINTS / can_drop_obj!
		 * NEEDS TO BE ADDED HERE!!!!!
		 */
		if ( con1 )
		{
			con1 = obj1->in_obj;
			obj_from_obj( obj1 );         /* grab first object */
			obj_to_char( obj1, ch );      /* give it to the char */
			obj1->wear_loc = obj2->wear_loc;
			
			obj_from_char( obj2 ); 
			obj_to_obj( obj2, con1 );     /* put it in the original */
		}		
		else
		{
			con2 = obj2->in_obj;
			obj_from_obj( obj2 );         /* grab first object */
			obj_to_char( obj2, ch );      /* give it to the char */
			obj2->wear_loc = obj1->wear_loc;
			
			obj_from_char( obj1 ); 
			obj_to_obj( obj1, con2 );     /* put it in the original */
		}

        sprintf( buf, "$n swap$v $p from %s with $P.",
               can_see_obj(ch, con1) ? STR(con1,short_descr) : "something" );
        act( buf, ch, obj1, obj2, TO_ALL );
	}
	
    return;
}




