/****************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *                                                                          *
 *      This is the server software for The Isles, called NiMUD 4.0.        *
 *    Copyright (c) 1994-1999 by Herb Gilliland.  All rights reserved.      *
 *                                                                          *
 ****************************************************************************
 *   Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *   Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 ****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#endif

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "comm.h"
#include "defaults.h"


/*
 * Malloc debugging.
 * Sun incomprehensibility factor.
 */
#if defined(sun)
#undef MALLOC_DEBUG
#endif

#if defined(MALLOC_DEBUG)
#include <malloc.h>
extern	int	malloc_debug	args( ( int  ) );
extern	int	malloc_verify	args( ( void ) );
#endif


/*
 * Signal handling.
 * Apollo has a problem with __attribute(atomic) in signal.h,
 * So dance around it.
 */
#if defined(apollo)
#define __attribute(x)
#endif

#if defined(unix)
#include <signal.h>
#endif

#if defined(apollo)
#undef __attribute
#endif

/*
 * Socket and TCP/IP stuff.
 */
#if     defined(macintosh) || defined(MSDOS)
const char    go_ahead_str    [] = { '\0' };
#endif

#if     defined(unix) && !defined(ECHO_STR)
#include <fcntl.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/telnet.h>

const char    go_ahead_str    [] = { IAC, GA, '\0' };
#endif

#include "network.h"


#if defined(unix)
    fd_set in_set;
    fd_set out_set;
    fd_set exc_set;
    struct timeval null_time;
#endif


/*
 * Global variables.
 */
DESCRIPTOR_DATA *   descriptor_list;    /* All open descriptors      */

FILE *          fpReserve;              /* Reserved file handle      */

bool            newlock;                /* Game is newbie locked         */
bool            wizlock;                /* Game is wizlocked             */
bool            shut_down;              /* Shutdown mud?                 */
char            str_boot_time[MAX_INPUT_LENGTH];
time_t          current_time;           /* Time of this pulse            */
int             packet[60];             /* Communication packet info     */
int             byte_count;             /* Bytes sent.                   */
int             packet_count;           /* Packets sent.                 */
bool            QUIET_STC = FALSE;      /* If true, send_to_chars abort  */


/*
 * OS-dependent local functions.
 */
#if defined(macintosh) || defined(MSDOS)
DESCRIPTOR_DATA dcon;                           /* Local session */

void    game_loop_mac_msdos   args( ( void ) );
bool    read_from_descriptor  args( ( DESCRIPTOR_DATA *d ) );
bool    write_to_descriptor   args( ( int desc, char *txt, int length ) );
#endif

#if defined(unix)
void    game_loop_unix        args( ( int control ) );
int     init_socket           args( ( int port ) );
void    poll_descriptors      args( ( int control ) );
void    clean_descriptors     args( ( void ) );
void    new_descriptor        args( ( int control ) );
bool    read_from_descriptor  args( ( DESCRIPTOR_DATA *d ) );
bool    write_to_descriptor   args( ( int desc, char *txt, int length ) );
bool    write_to_descr_nice   args( ( DESCRIPTOR_DATA *d ) );
#endif


/*
 * Local defines.
 */
#define DC(desc)   ( desc->connected )
#define MT(str, d) ( str == NULL || str[0] == '\0' ? d : str )
#define SMT(str)   ( str == NULL || str[0] == '\0' )

/*
 * Other local functions (OS-independent).
 */
void    nanny              args( ( DESCRIPTOR_DATA *d, char *argument ) );
void    nanny_check        args( ( DESCRIPTOR_DATA *d ) );
bool    check_parse_name   args( ( char *name ) );
bool    check_playing      args( ( DESCRIPTOR_DATA *d, char *name ) );
bool    check_reconnect    args( ( DESCRIPTOR_DATA *d, char *name,
                                   bool fConn ) );
int     main               args( ( int argc, char **argv ) );
bool    process_output     args( ( DESCRIPTOR_DATA *d, bool fPrompt ) );
void    read_from_buffer   args( ( DESCRIPTOR_DATA *d ) );
void    stop_idling        args( ( CHAR_DATA *ch ) );
void    display_prompt     args( ( CHAR_DATA *ch ) );
bool    apply_ok           args( ( CHAR_DATA *ch ) );
void    print_gen_menu     args( ( CHAR_DATA *ch ) );
void    print_doc_menu     args( ( CHAR_DATA *ch ) );
void    print_login_menu   args( ( CHAR_DATA *ch ) );
void    process_input      args( ( void ) );





int main( int argc, char **argv )
{
    struct timeval now_time;
    int port;

#if defined(macintosh) || defined(MSDOS)
    {
    /*
     * New_descriptor analogue.
     */
    dcon.descriptor	= 0;
    dcon.connected  = CON_SHOW_TITLE;
    dcon.host		= str_dup( "localhost" );
    dcon.outsize	= 2000;
    dcon.outbuf		= alloc_mem( dcon.outsize );
    dcon.next		= descriptor_list;
    dcon.pEdit      = NULL;
    dcon.pString    = NULL;
    dcon.fpromptok  = TRUE;
    descriptor_list	= &dcon;
    }
#endif

#if defined(unix)
    int control;
#endif

    /*
     * Memory debugging if needed.
     */
#if defined(MALLOC_DEBUG)
    malloc_debug( 2 );
#endif

    /*
     * Get boot time time.
     */
    gettimeofday( &now_time, NULL );
    current_time = (time_t) now_time.tv_sec;
    strcpy( str_boot_time, ctime( &current_time ) );

    /*
     * Macintosh console inits.
     */
#if defined(macintosh)
    console_options.nrows = 31;
    cshow( stdout );
    csetmode( C_RAW, stdin );
    cecho2file( "log file", 1, stderr );
#endif

    /*
     * Reserve one channel for our use.
     */
    if ( ( fpReserve = fopen( NULL_FILE, "r" ) ) == NULL )
    {
	perror( NULL_FILE );
	exit( 1 );
    }

    /*
     * Get the port number.
     */
    port = DEF_PORT;
    if ( argc > 1 )
    {
     if ( !is_number( argv[1] ) )
     {
         fprintf( stderr, "Usage: %s [port #]\n", argv[0] );
         exit( 1 );
     }
     else if ( ( port = atoi( argv[1] ) ) <= 1024 )
     {
     fprintf( stderr, "Invalid (%d) Port number must be above 1024.\n", port );
     exit( 1 );
     }
    }

    /*
     * Run the game.
     */
#if defined(macintosh) || defined(MSDOS)
    boot_db( 0 );
    log_string( "Local server connection established" );
    game_loop_mac_msdos( );
#endif

#if defined(unix)
    control = init_socket( port );
    boot_db( control );
    sprintf( log_buf, "Server now operational on port %d.", port );
    log_string( log_buf );
    game_loop_unix( control );
    close( control );
#endif

    /*
     * Shutdown.
     */
    log_string( "Normal termination." );
    exit( 0 );
    return 0;
}



#if defined(unix)
int init_socket( int port )
{
    static struct sockaddr_in sa_zero;
    struct sockaddr_in sa;
    int x = 1;
    int fd;

    if ( ( fd = socket( AF_INET, SOCK_STREAM, 0 ) ) < 0 )
    {
	perror( "Init_socket: socket" );
	exit( 1 );
    }

    if ( setsockopt( fd, SOL_SOCKET, SO_REUSEADDR,
    (char *) &x, sizeof(x) ) < 0 )
    {
	perror( "Init_socket: SO_REUSEADDR" );
	close( fd );
	exit( 1 );
    }

#if defined(SO_DONTLINGER) && !defined(SYSV)
    {
	struct	linger	ld;

	ld.l_onoff  = 1;
	ld.l_linger = 1000;

	if ( setsockopt( fd, SOL_SOCKET, SO_DONTLINGER,
	(char *) &ld, sizeof(ld) ) < 0 )
	{
	    perror( "Init_socket: SO_DONTLINGER" );
	    close( fd );
	    exit( 1 );
	}
    }
#endif

    sa		    = sa_zero;
    sa.sin_family   = AF_INET;
    sa.sin_port	    = htons( port );

    if ( bind( fd, (struct sockaddr *) &sa, sizeof(sa) ) < 0 )
    {
	perror( "Init_socket: bind" );
	close( fd );
	exit( 1 );
    }

    if ( listen( fd, 3 ) < 0 )
    {
	perror( "Init_socket: listen" );
	close( fd );
	exit( 1 );
    }

    return fd;
}
#endif



/*
 * Output.
 */
void descriptor_output( void )
{
    DESCRIPTOR_DATA *d;
    DESCRIPTOR_DATA *d_next;
    
#if defined(unix)
        for ( d = descriptor_list; d != NULL; d = d_next )
        {
            d_next = d->next;

            if ( ( d->fcommand || d->outtop > 0 )
            &&   FD_ISSET(d->descriptor, &out_set) )
            {
                if ( !process_output( d, TRUE ) )
                {
                    if ( d->character != NULL )
                        save_char_obj( d->character );
                    d->outtop   = 0;
                    close_socket( d );
                }
            }
        }
#endif

#if defined(macintosh) || defined(MSDOS)
        for ( d = descriptor_list; d != NULL; d = d_next )
        {
            d_next = d->next;

            if ( ( d->fcommand || d->outtop > 0 ) )
            {
                if ( !process_output( d, TRUE ) )
                {
                    if ( d->character != NULL )
                        save_char_obj( d->character );
                    d->outtop   = 0;
                    close_socket( d );
                }
            }
        }
#endif
}


/*
 * Process input.
 */
void process_input( void )
{
    DESCRIPTOR_DATA *d, *d_next;

    for ( d = descriptor_list; d != NULL; d = d_next )
    {
        d_next      = d->next;
        d->fcommand = FALSE;

#if defined(MSDOS)
        if ( kbhit( ) )
#endif
#if defined(unix)
        if ( FD_ISSET( d->descriptor, &in_set ) )
#endif
        {
            if ( d->character != NULL )
                  d->character->timer = 0;

            if ( !read_from_descriptor( d ) )
            {
#if defined(unix)
                 FD_CLR( d->descriptor, &out_set );
#endif
                 if ( d->character != NULL )
                      save_char_obj( d->character );
                 d->outtop   = 0;
                 close_socket( d );
                 continue;
            }
        }

        if ( d->character != NULL && d->character->wait > 0 )
        {
            if (IS_IMMORTAL(d->character))
                      d->character->wait = 0;
                 else --d->character->wait;
            continue;
        }

        read_from_buffer( d );
        if ( d->incomm[0] != '\0' )
        {
             d->fcommand     = TRUE;
             stop_idling( d->character );

             if ( d->pString != NULL ) string_add( d->character,  d->incomm );
             else
             if ( d->showstr_point )   show_string( d, d->incomm );
             else
             {
             switch ( d->connected )
             {
                 case CON_PLAYING: interpret( d->character, d->incomm ); break;
                 case CON_AEDITOR: aedit( d->character, d->incomm );     break;
                 case CON_REDITOR: redit( d->character, d->incomm );     break;
                 case CON_OEDITOR: oedit( d->character, d->incomm );     break;
                 case CON_MEDITOR: medit( d->character, d->incomm );     break;
                 case CON_SEDITOR: sedit( d->character, d->incomm );     break;
                          default: nanny( d, d->incomm );                break;
             }
             }

             /*
              * Application process stuff.  Kludgy.
              */
             if ( d->character != NULL )
                 nanny_check( d );

        d->incomm[0]    = '\0';
        }
    }
    return;
}




/*
 * Mac/msdos game loop.
 */
#if defined(macintosh) || defined(MSDOS)

void game_loop_mac_msdos( void )
{
    struct timeval last_time;
    struct timeval now_time;

    gettimeofday( &last_time, NULL );
    current_time = (time_t) last_time.tv_sec;

    /* Main loop */
    while ( !shut_down )
    {
	DESCRIPTOR_DATA *d;


    process_input( );

	/*
	 * Autonomous game motion.
	 */
	update_handler( );

    descriptor_output( );

	/*
	 * Synchronize to a clock.
	 * Busy wait (blargh).
	 */
	now_time = last_time;
	for ( ; ; )
	{
	    int delta;

#if defined(MSDOS)
	    if ( kbhit( ) )
#endif
	    {
		if ( dcon.character != NULL )
		    dcon.character->timer = 0;
		if ( !read_from_descriptor( &dcon ) )
		{
            d = &dcon;

		    if ( dcon.character != NULL )
			save_char_obj( d->character );
		    dcon.outtop	= 0;
		    close_socket( &dcon );
		}
#if defined(MSDOS)
		break;
#endif
	    }

	    gettimeofday( &now_time, NULL );
	    delta = ( now_time.tv_sec  - last_time.tv_sec  ) * 1000 * 1000
              + ( now_time.tv_usec - last_time.tv_usec );
	    if ( delta >= 1000000 / PULSE_PER_SECOND )
		break;
	}
	last_time    = now_time;
	current_time = (time_t) last_time.tv_sec;
    }

    return;
}
#endif



/*
 * Unix-loop routines.
 */
#if defined(unix)


/*
 * Get rid of drops.
 */
void clean_descriptors( void )
{
    DESCRIPTOR_DATA *d, *d_next;

	/*
	 * Kick out the freaky folks.
	 */
	for ( d = descriptor_list; d != NULL; d = d_next )
	{
	    d_next = d->next;   
	    if ( FD_ISSET( d->descriptor, &exc_set ) )
	    {
		FD_CLR( d->descriptor, &in_set  );
		FD_CLR( d->descriptor, &out_set );
		if ( d->character )
		    save_char_obj( d->character );
		d->outtop	= 0;
		close_socket( d );
	    }
	}
    return;
}


/*
 * Poll all active descriptors.
 */
void poll_descriptors( int control )
{
    DESCRIPTOR_DATA *d;
    int maxdesc;

	FD_ZERO( &in_set  );
	FD_ZERO( &out_set );
	FD_ZERO( &exc_set );
	FD_SET( control, &in_set );
	maxdesc	= control;
	for ( d = descriptor_list; d; d = d->next )
	{
	    maxdesc = UMAX( maxdesc, d->descriptor );
	    FD_SET( d->descriptor, &in_set  );
	    FD_SET( d->descriptor, &out_set );
	    FD_SET( d->descriptor, &exc_set );
	}

	if ( select( maxdesc+1, &in_set, &out_set, &exc_set, &null_time ) < 0 )
	{
	    perror( "Game_loop: select: poll" );
	    exit( 1 );
	}

	/*
	 * New connection?
     */
    if ( FD_ISSET( control, &in_set ) )
	    new_descriptor( control );
    return;
}


/*
 * Unix game loop.
 */
void game_loop_unix( int control )
{
    struct timeval last_time;

    signal( SIGPIPE, SIG_IGN );
    gettimeofday( &last_time, NULL );
    current_time = (time_t) last_time.tv_sec;

    /* Main loop */
    while ( !shut_down )
    {

#if defined(MALLOC_DEBUG)
	if ( malloc_verify( ) != 1 )
	    abort( );
#endif

        poll_descriptors( control );
        clean_descriptors( );
        process_input( );

	/*
	 * Autonomous game motion.
	 */
	update_handler( );

    descriptor_output( );

	/*
	 * Synchronize to a clock.
	 * Sleep( last_time + 1/PULSE_PER_SECOND - now ).
	 * Careful here of signed versus unsigned arithmetic.
	 */
	{
	    struct timeval now_time;
	    long secDelta;
	    long usecDelta;

	    gettimeofday( &now_time, NULL );
	    usecDelta	= ((int) last_time.tv_usec) - ((int) now_time.tv_usec)
			+ 1000000 / PULSE_PER_SECOND;
	    secDelta	= ((int) last_time.tv_sec ) - ((int) now_time.tv_sec );
	    while ( usecDelta < 0 )
	    {
		usecDelta += 1000000;
		secDelta  -= 1;
	    }

	    while ( usecDelta >= 1000000 )
	    {
		usecDelta -= 1000000;
		secDelta  += 1;
	    }

	    if ( secDelta > 0 || ( secDelta == 0 && usecDelta > 0 ) )
	    {
		struct timeval stall_time;

		stall_time.tv_usec = usecDelta;
		stall_time.tv_sec  = secDelta;
		if ( select( 0, NULL, NULL, NULL, &stall_time ) < 0 )
		{
		    perror( "Game_loop: select: stall" );
		    exit( 1 );
		}
	    }
	}

    gettimeofday( &last_time, NULL );
	current_time = (time_t) last_time.tv_sec;
    }

    return;
}



/*
 * New connections must pass through here.
 */
void new_descriptor( int control )
{
    char buf[MAX_STRING_LENGTH];
    DESCRIPTOR_DATA *dnew;
    BAN_DATA *pban;
    struct sockaddr_in sock;
    struct hostent *from;
    int desc;
    int size;
    extern bool fBootDb;

    size = sizeof(sock);
    getsockname( control, (struct sockaddr *) &sock, &size );
    if ( ( desc = accept( control, (struct sockaddr *) &sock, &size) ) < 0 )
    {
	perror( "New_descriptor: accept" );
	return;
    }

#if !defined(FNDELAY)
#define FNDELAY O_NDELAY
#endif

    if ( fcntl( desc, F_SETFL, FNDELAY ) == -1 )
    {
	perror( "New_descriptor: fcntl: FNDELAY" );
	return;
    }

    /*
     * Cons a new descriptor.
     */
    dnew = new_descriptor_data( );
    dnew->descriptor = desc;

    size = sizeof(sock);
    if ( getpeername( desc, (struct sockaddr *) &sock, &size ) < 0 )
    {
	perror( "New_descriptor: getpeername" );
	dnew->host = str_dup( "(unknown)" );
    }
    else
    {
	/*
	 * Would be nice to use inet_ntoa here but it takes a struct arg,
	 * which ain't very compatible between gcc and system libraries.
	 */
	int addr;

	addr = ntohl( sock.sin_addr.s_addr );
	sprintf( buf, "%d.%d.%d.%d",
	    ( addr >> 24 ) & 0xFF, ( addr >> 16 ) & 0xFF,
	    ( addr >>  8 ) & 0xFF, ( addr       ) & 0xFF
	    );
	sprintf( log_buf, "Sock.sinaddr:  %s", buf );
	log_string( log_buf );

    sprintf( log_buf, "Notify>  New connection: %s", buf );
    NOTIFY( log_buf, LEVEL_IMMORTAL, WIZ_NOTIFY_LOGIN );

	from = gethostbyaddr( (char *) &sock.sin_addr,
	    sizeof(sock.sin_addr), AF_INET );
	dnew->host = str_dup( from ? from->h_name : buf );
    }
	
    /*
     * Swiftest: I added the following to ban sites.  I don't
     * endorse banning of sites, but Copper has few descriptors now
     * and some people from certain sites keep abusing access by
     * using automated 'autodialers' and leaving connections hanging.
     *
     * Furey: added suffix check by request of Nickel of HiddenWorlds.
     */
    for ( pban = ban_list; pban != NULL; pban = pban->next )
    {
    if ( /*!*/str_suffix( pban->name, dnew->host ) )
	{
        write_to_descriptor( desc, "Your site has been banned.\n\r", 0 );
	    close( desc );
        free_descriptor( dnew );
	    return;
	}
    }

    /*
     * Init descriptor data.
     */
    dnew->next			= descriptor_list;
    descriptor_list		= dnew;

    /*
     * Send the greeting.
     */
    if ( !fBootDb )
    {
	extern char * help_greeting;

    write_to_buffer(dnew, VERSION_STR, 0 );
    write_to_buffer(dnew, "\n\r", 0 );

	if ( help_greeting[0] == '.' )
	    write_to_buffer( dnew, help_greeting+1, 0 );
	else
	    write_to_buffer( dnew, help_greeting  , 0 );
    }
    else write_to_buffer( dnew, "Please wait.\n\r", 0 );

    return;
}
#endif



void close_socket( DESCRIPTOR_DATA *dclose )
{
    CHAR_DATA *ch;

    if ( dclose->outtop > 0 )
    process_output( dclose, FALSE );

    /*
     * Nail snoopers.
     */
    if ( dclose->snoop_by != NULL )
    {
        char buf[MAX_STRING_LENGTH];
        sprintf( buf, "*%s*  Lost link.\n\r",
                 dclose->character ? dclose->character->name : "(null)" );
        write_to_buffer( dclose->snoop_by, buf, 0 );
    }

    /*
     * Nail snooped.
     */
    {
	DESCRIPTOR_DATA *d;

	for ( d = descriptor_list; d != NULL; d = d->next )
	{
	    if ( d->snoop_by == dclose )
		d->snoop_by = NULL;
	}
    }


    if ( ( ch = dclose->character ) != NULL )
    {
	sprintf( log_buf, "Closing link to %s.", ch->name );
    log_string( log_buf );
    if ( CONNECTED(dclose) )
	{
	    act( "$n has lost $s link.", ch, NULL, NULL, TO_ROOM );
	    ch->desc = NULL;
	}
	else
    {
	    free_char( dclose->character );
        dclose->character = NULL;
    }
    }

    if ( dclose == descriptor_list ) descriptor_list = descriptor_list->next;
    else
    {
	DESCRIPTOR_DATA *d;

    for ( d = descriptor_list; d != NULL && d->next != dclose; d = d->next )
    ;

    if ( d != NULL )   d->next = dclose->next;
    else               bug( "Close_socket: dclose not found.", 0 );
    }

    dclose->next = NULL;
    close( dclose->descriptor );
    free_descriptor( dclose );

#if defined(MSDOS) || defined(macintosh)
    exit(1);
#endif
    return;
}



/*
 * Read and place in buffer.
 */
bool read_from_descriptor( DESCRIPTOR_DATA *d )
{
    int iStart;

    /*
     * Abort if pending command already.
     */
    if ( d->incomm[0] != '\0' )
	return TRUE;

    /*
     * Check for overflow.
     */
    iStart = strlen(d->inbuf);
    if ( iStart >= sizeof(d->inbuf) - 10 )
    {
	sprintf( log_buf, "%s input overflow!", d->host );
	log_string( log_buf );
	write_to_descriptor( d->descriptor,
        "\n\r*** BUFFER OVERFLOW ***\n\r", 0 );
	return FALSE;
    }

    /*
     * Grab input.
     */
#if defined(macintosh)
    for ( ; ; )
    {
	int c;
	c = getc( stdin );
	if ( c == '\0' || c == EOF )
	    break;
	putc( c, stdout );
	if ( c == '\r' )
	    putc( '\n', stdout );
	d->inbuf[iStart++] = c;
	if ( iStart > sizeof(d->inbuf) - 10 )
	    break;
    }
#endif

#if defined(MSDOS) || defined(unix)
    for ( ; ; )
    {
	int nRead;

	nRead = read( d->descriptor, d->inbuf + iStart,
	    sizeof(d->inbuf) - 10 - iStart );
	if ( nRead > 0 )
	{
	    iStart += nRead;
	    if ( d->inbuf[iStart-1] == '\n' || d->inbuf[iStart-1] == '\r' )
		break;
	}
	else if ( nRead == 0 )
	{
        char buf[MAX_STRING_LENGTH];

        log_string( "EOF encountered on read." );
        sprintf( buf, "Notify> %s has lost link.",
                      (d != NULL && d->character != NULL)
                                  ? d->character->name : "Guest" );
        NOTIFY( buf, LEVEL_IMMORTAL, WIZ_NOTIFY_LOGIN );
        return FALSE;
	}
    else if ( errno == EWOULDBLOCK )  break;
	else
	{
        perror( "Read_from_descriptor" );
	    return FALSE;
	}
    }
#endif

    d->inbuf[iStart] = '\0';
    return TRUE;
}




/*
 * Transfer one line from input buffer to input line.
 */
void read_from_buffer( DESCRIPTOR_DATA *d )
{
    int i, j, k;

    /*
     * Hold horses if pending command already.
     */
    if ( d->incomm[0] != '\0' )
	return;

    /*
     * Look for at least one new line.
     */
    for ( i = 0; d->inbuf[i] != '\n' && d->inbuf[i] != '\r'; i++ )
    {
	if ( d->inbuf[i] == '\0' )
	    return;
    }

    /*
     * Canonical input processing.
     */
    for ( i = 0, k = 0; d->inbuf[i] != '\n' && d->inbuf[i] != '\r'; i++ )
    {
	if ( k >= MAX_INPUT_LENGTH - 2 )
	{
        write_to_descriptor( d->descriptor, "Line too long.  Truncating.\n\r", 0 );

	    /* skip the rest of the line */
	    for ( ; d->inbuf[i] != '\0'; i++ )
	    {
		if ( d->inbuf[i] == '\n' || d->inbuf[i] == '\r' )
		    break;
	    }
	    d->inbuf[i]   = '\n';
	    d->inbuf[i+1] = '\0';
	    break;
	}

	if ( d->inbuf[i] == '\b' && k > 0 )
	    --k;
	else if ( isascii(d->inbuf[i]) && isprint(d->inbuf[i]) )
	    d->incomm[k++] = d->inbuf[i];
    }

    /*
     * Finish off the line.
     */
    if ( k == 0 )
	d->incomm[k++] = ' ';
    d->incomm[k] = '\0';

    /*
     * Deal with bozos with #repeat 1000 ...
     */
    if ( k > 1 || d->incomm[0] == '!' )
    {
    	if ( d->incomm[0] != '!' && strcmp( d->incomm, d->inlast ) )
	{
	    d->repeat = 0;
	}
	else
	{
        if ( ++d->repeat >= 50 )
	    {
		sprintf( log_buf, "%s input spamming!", d->host );
		log_string( log_buf );
		write_to_descriptor( d->descriptor,
            "\n\r*** REPEAT OVERFLOW ***\n\r", 0 );
		strcpy( d->incomm, "quit" );
	    }
	}
    }

    /*
     * Do '!' substitution.
     */
    if ( d->incomm[0] == '!' )
	strcpy( d->incomm, d->inlast );
    else
	strcpy( d->inlast, d->incomm );

    /*
     * Shift the input buffer.
     */
    while ( d->inbuf[i] == '\n' || d->inbuf[i] == '\r' )
	i++;
    for ( j = 0; ( d->inbuf[j] = d->inbuf[i+j] ) != '\0'; j++ )
	;
    return;
}



/*
 * Display prompt (player settable prompt).
 */
void display_prompt( CHAR_DATA *ch )
{
   char buf[MAX_STRING_LENGTH];
   char buf2[MAX_STRING_LENGTH];
   const char *str;
   const char *i;
   char *point;

   if( ch->prompt == NULL || ch->prompt[0] == '\0' )
   {
      send_to_char( "\n\r\n\r", ch );
      return;
   }

   point = buf;
   str = ch->prompt;
   while( *str != '\0' )
   {
      if( *str != '%' )
      {
         *point++ = *str++;
         continue;
      }
      ++str;
      switch( *str )
      {
         default: i = " "; break;
        case '0': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  BLACK;   break;
        case '1': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  BLUE;    break;
        case '2': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  GREEN;   break;
        case '3': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  CYAN;    break;
        case '4': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  RED;     break;
        case '5': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  PURPLE;  break;
        case '6': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  YELLOW;  break;
        case '7': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  GREY;    break;
        case 'B': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  BOLD;    break;
        case 'I': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  INVERSE; break;
        case 'F': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  FLASH;   break;
        case 'N': i = !IS_SET( ch->act2, PLR_ANSI ) ? "" :  NTEXT;   break;
        case 'h': sprintf( buf2, "%s", STRING_HITS(ch) );
                  i = buf2;
                break;
        case 'H': if ( IS_IMMORTAL(ch) )
                  sprintf( buf2, "%d", PERCENTAGE(ch->hit, MAXHIT(ch)) );
                  else sprintf( buf2, " " );
                  i = buf2;
                break;
        case 'm': sprintf( buf2, "%s", STRING_MOVES(ch)  );
                  i = buf2;
                break;
        case 'M': if ( IS_IMMORTAL(ch) )
                  sprintf( buf2, "%d", PERCENTAGE(ch->move, MAXMOVE(ch)) );
                  else sprintf( buf2, " " );
                  i = buf2;
                break;
        case 'g': sprintf( buf2, "%s", name_amount( tally_coins( ch ) ) );
                  i = buf2;
                break;
        case 'r': if( IS_IMMORTAL( ch ) && ch->in_room != NULL )
                  sprintf( buf2, "%d", ch->in_room->vnum );
                  else
                  sprintf( buf2, " " );
                  i = buf2;
                break;
        case 'z': if( IS_IMMORTAL( ch ) && ch->in_room != NULL )
                  sprintf( buf2, "%s", ch->in_room->area->name );
                  else
                  sprintf( buf2, " " );
                  i = buf2;
                break;
        case 'Z': if( IS_IMMORTAL( ch ) && ch->in_room != NULL )
                  sprintf( buf2, "%d", ch->in_room->area->vnum );
                  else
                  sprintf( buf2, " " );
                  i = buf2;
                break;
        case 'v': if ( PC(ch,wizinvis) > 0 )
                  sprintf(buf2, "%d", PC(ch,wizinvis) );
                  else
                  if (IS_AFFECTED(ch, AFF_INVISIBLE))
                  sprintf(buf2, "i");
                  else
                  sprintf(buf2, "V");
                  i = buf2;
                break;
        case 'c': if ( IS_IMMORTAL( ch ) )
                  {
                      switch (ch->desc->connected)
                      {
                           case CON_AEDITOR: sprintf( buf2, "AEdit" );  break;
                           case CON_REDITOR: sprintf( buf2, "REdit" );  break;
                           case CON_OEDITOR: sprintf( buf2, "OEdit" );  break;
                           case CON_MEDITOR: sprintf( buf2, "MEdit" );  break;
                           case CON_SEDITOR: sprintf( buf2, "SEdit" );  break;
                                    default: buf2[0] = '\0';            break;
                      }
                  }
                  else sprintf( buf2, " " );
                  i = buf2;
                break;
        case 'C': if ( IS_IMMORTAL( ch ) )
                  {
                      AREA_DATA *pArea;
                      ROOM_INDEX_DATA *pRoom;
                      OBJ_INDEX_DATA *pObj;
                      MOB_INDEX_DATA *pMob;

                  switch (ch->desc->connected)
                  {
                    case CON_AEDITOR:
                    {
                        pArea = (AREA_DATA *)ch->desc->pEdit;
                        sprintf( buf2, "%d", pArea != NULL ? pArea->vnum : 0 );
                        break;
                    }
                    case CON_REDITOR:
                    {
                        pRoom = ch->in_room;
                        sprintf( buf2, "%d", pRoom != NULL ? pRoom->vnum : 0 );
                        break;
                    }
                    case CON_MEDITOR:
                    {
                        pMob = (MOB_INDEX_DATA *)ch->desc->pEdit;
                        sprintf( buf2, "%d", pMob  != NULL ? pMob->vnum  : 0 );
                        break;
                    }
                    case CON_OEDITOR:
                    {
                        pObj = (OBJ_INDEX_DATA *)ch->desc->pEdit;
                        sprintf( buf2, "%d", pObj  != NULL ? pObj->vnum  : 0 );
                        break;
                    }
                    default:
                        buf2[0] = '\0';
                        break;
                  }
                  }
                  else sprintf( buf2, " " );
                  i = buf2;
                break;
         case 'n' : sprintf( buf2, "\n\r" );  i = buf2; break;
         case '%' : sprintf( buf2, "%%" );    i = buf2; break;
      } 
      ++str;
      while( (*point = *i) != '\0' )
         ++point, ++i;      
   }
   write_to_buffer( ch->desc, buf, point - buf );
   return;
}



/*
 * Low level output function.
 */
bool process_output( DESCRIPTOR_DATA *d, bool fPrompt )
{
    fPrompt = (d->fpromptok ? fPrompt : 0);
    /*
     * Bust a prompt.
     */
    if ( d->pString != NULL )       write_to_buffer( d, "> ", 2 );
    else
    if ( fPrompt  && !shut_down )
    {
    if ( d->showstr_point ) write_to_buffer( d,  "<more> ",    0 );
    else
    if ( CONNECTED(d) )
    {
    CHAR_DATA *ch;

	ch = d->original ? d->original : d->character;
    if ( ch != NULL )
    {
    if ( IS_SET(ch->act2, PLR_BLANK) )
	    write_to_buffer( d, "\n\r", 2 );

    if ( IS_SET(ch->act2, PLR_PROMPT) )
            display_prompt( d->character );

    if ( IS_SET(d->character->act2, PLR_TELNET_GA) )
	    write_to_buffer( d, go_ahead_str, 0 );
    }
    }
    }

    /*
     * Short-circuit if nothing to write.
     */
    if ( d->outtop == 0 )
	return TRUE;

    /*
     * OS-dependent output.
     */
#if !defined(unix)
    if ( !write_to_descriptor( d->descriptor, d->outbuf, d->outtop ) )
    {
	d->outtop = 0;
	return FALSE;
    }
    else
    {
	d->outtop = 0;
	return TRUE;
    } 
#else
    if ( !write_to_descr_nice( d ) )
      {
        d->outtop = 0;
        return FALSE;
      }
    else
      {
        return TRUE;
      }
#endif
}



/*
 * Write to the descriptor's output buffer.
 */
void write_to_buffer( DESCRIPTOR_DATA *d, const char *txt, int length )
{
    extern bool fBootDb;

    /*
     * Find length in case caller didn't.
     */
    if ( length <= 0 )
        length = strlen(txt);
 
    /*
     * Initial \n\r if needed.
     */
    if ( !fBootDb && d->outtop == 0 && !d->fcommand )
    {
        d->outbuf[0]    = '\n';
        d->outbuf[1]    = '\r';
        d->outtop       = 2;
    }
 
    /*
     * Expand the buffer as needed.
     */
    while ( d->outtop + length >= d->outsize )
    {
        char *outbuf;
 
        if ( d->outsize >= 32000 )
        {
            d->outtop = 0;
            write_to_buffer( d, "OVER 32000 BYTES.  TRUNCATED.\n\r", 0 );
            return;
        }
        outbuf      = alloc_mem( 2 * d->outsize );
        strncpy( outbuf, d->outbuf, d->outtop );
        free_mem( d->outbuf, d->outsize );
        d->outbuf   = outbuf;
        d->outsize *= 2;
    }
 
    /*
     * Copy.
     */
    strcpy( d->outbuf + d->outtop, txt );
    d->outtop += length;
    return;
}




/*
 * Lowest level output function.
 * Write a block of text to the file descriptor.
 */
bool write_to_descriptor( int desc, char *txt, int length )
{
    int iStart;
    int nWrite;
    int nBlock;

#if defined(macintosh) || defined(MSDOS)
    if ( desc == 0 )
    desc = 1;
#endif

    if ( length <= 0 )
	length = strlen(txt);

    for ( iStart = 0; iStart < length; iStart += nWrite )
    {
        nBlock = UMIN( length - iStart, 4096 );
        if ( ( nWrite = write( desc, txt + iStart, nBlock ) ) < 0 )
        {
            perror( "Write_to_descriptor" );
            return FALSE;
        }
    } 

    return TRUE;
}

 

/*
 * Spill the blood let it run onto me.
 * Clipped from Kalgen.
 */
void parse_snoop( DESCRIPTOR_DATA *d, const char *txt )
{
    char str[MAX_STRING_LENGTH];
    CHAR_DATA *ch;
    int i, j;
    
    if ( d->character == NULL )
    {
        bug( "parse_snoop: NULL passed", 0 );
        return;
    }
    else if ( d->original )
    {
        ch = d->original;
    }
    else
    {
        ch = d->character;
    }
 
    for ( i = 0,j=0; j < (MAX_STRING_LENGTH-3) ; i++, j++ )
    {
        if ( txt[i] == 0 )
        {
/*
        if ( j > 1 )
	    {
                str[j] = 0;
                write_to_buffer( d->snoop_by, str, 0 );
		}
*/
        return;
        }
 
        if ( txt[i] == '\r' )
        {
            j--;
            continue;
        }
 
        if ( j == 0 )
        {
            for ( j = 0; j < MAX_INPUT_LENGTH; j++ )
              str[j] = 0;
              
            if ( HAS_ANSI(d->snoop_by->character) )
            strcat( str, BOLD );
            
            strcat( str, STR(d->character, name) );
            str[4+3]=0;
            strcat( str, "* " );
            
            if ( HAS_ANSI(d->snoop_by->character) )
            strcat( str, ANSI_NORMAL );
            
            j = strlen( str );
        }
 
        if ( txt[i] == '\n' )
        {
            str[j] = '\n';
            j++;
            str[j] = '\r';
            j++;
            str[j] = 0;
            if ( j >= 10 )
              write_to_buffer( d->snoop_by, str, 0 );
            str[0] = 0;
            j = -1;
        }
        else str[j] = txt[i];
    }

    return;
}
 



/*
 * This procedure, an alterate to using the above, will NOT crash the
 * link by spamming the output buffer on the remote side.  This was
 * submitted for your approval by Kalgen of his mud, Zebesta.
 */
bool write_to_descr_nice( DESCRIPTOR_DATA *d )
{
    int iStart;
    int nWrite;
    int nBlock;
    int length;
 
 
    length = d->outtop;
 
    iStart = 0;
    nBlock = UMIN( length - iStart, 4096 );
 
    if ( ( nWrite = write( d->descriptor, d->outbuf + iStart, nBlock ) ) < 0 )
    {
        byte_count += nBlock;
        perror( "Write_to_descriptor" );
        return FALSE;
    }
 
    if ( (length - nWrite) )
    {
        int i;

        for ( i = 0; (i + nWrite) < length; i++ )
           d->outbuf[i] = d->outbuf[i+nWrite];

        d->outtop -= nWrite;
        d->fpromptok = FALSE;
    }
    else
    {
        if ( d->snoop_by )
        {
          d->outbuf[d->outtop] = 0;
          parse_snoop( d, d->outbuf );
        }
 
        d->fpromptok = TRUE;
        d->outtop = 0;
    }

    packet[current_time % 60] += nWrite;
    packet_count += nWrite;
    return TRUE;
}



/*
 * Reset counter.
 * Do anything else.
 */
void stop_idling( CHAR_DATA *ch )
{
    if ( ch == NULL
    ||   ch->desc == NULL
    ||   ch->desc->connected > CON_PLAYING
    ||   ch->in_room != get_room_index( ROOM_VNUM_LIMBO ) )
	return;

    ch->timer = 0;
    return;
}




/*
 * Write to one char.
 */
void send_to_char( const char *txt, CHAR_DATA *ch )
{
    if ( QUIET_STC != TRUE
      && txt != NULL
      && ch != NULL
      && ch->desc != NULL )
        write_to_buffer( ch->desc, txt, strlen(txt) );
    return;
}



/*
 * Send a page to one char.
 */
void page_to_char( const char *txt, CHAR_DATA *ch )
{
    if ( txt == NULL || ch->desc == NULL )
        return;

    /*
     * No pagers.
     */
    if ( ch->pagelen == 0 )
    {
        send_to_char( txt, ch );
        return;
    }

    /*
     * If there is already some data being "paged" for this descriptor,
     * append the new string.
     */
    if ( !MTD(ch->desc->showstr_head) )
    {
        char fub[strlen(txt)+strlen(ch->desc->showstr_head)+2];
        int i;

        fub[0] = '\0';
        strcat( fub, ch->desc->showstr_head );
        i = strlen(fub) - strlen(ch->desc->showstr_point);
        strcat( fub, txt );

        free_string( ch->desc->showstr_head );
        ch->desc->showstr_head = str_dup( fub );
        ch->desc->showstr_point = ch->desc->showstr_head + i;
        return;
    }

    free_string( ch->desc->showstr_head );
    ch->desc->showstr_head = str_dup( txt );
    ch->desc->showstr_point = ch->desc->showstr_head;
    show_string( ch->desc, "" );
    return;
}



/*
 * Simplified pager.
 */
void show_string(struct descriptor_data *d, char *input)
{
  char buffer[ MAX_STRING_LENGTH * 3 ];
  char buf[ MAX_INPUT_LENGTH ];
  register char *scan, *chk;
  int lines = 0, toggle=1;

  one_argument(input, buf);

  switch( UPPER( buf[0] ) )
  {
  case '\0':
  case 'N': /* show next page of text */
     lines = 0;
    break;

  case 'R': /* refresh current page of text */
     lines = - 1 - (d->character->pagelen);
    break;

  case 'P': /* scroll back a page of text */
    lines = -(2*d->character->pagelen);
    break;

  case 'H': /* Show some help */
    write_to_buffer( d, "Pager help:\n\rN or Enter     next page\n\rR              redraw this page\n\r",
                          0 );
    write_to_buffer( d, "P              previous page\n\rH or ?         help\n\rAny other keys exit.\n\r\n\r<more> ",
                    0 );
/*    lines = - 1 - (d->character->pagelen); */
    break;

  default: /*otherwise, stop the text viewing */
    if ( d->showstr_head )
    {
        free_string( d->showstr_head );
        d->showstr_head = str_dup( "" );
    }
    d->showstr_point = NULL;
    return;

  }

  /* do any backing up necessary */
  if (lines < 0)
  {
    for ( scan = d->showstr_point; scan > d->showstr_head; scan-- )
         if ( ( *scan == '\n' ) || ( *scan == '\r' ) )
         {
             toggle = -toggle;
             if ( toggle < 0 )
                 if ( !( ++lines ) )
                     break;
         }
    d->showstr_point = scan;
  }

  /* show a chunk */
  lines  = 0;
  toggle = 1;
  for ( scan = buffer; ; scan++, d->showstr_point++ )
       if ( ( ( *scan = *d->showstr_point ) == '\n' || *scan == '\r' )
           && ( toggle = -toggle ) < 0 )
           lines++;
       else
           if ( !*scan || ( d->character && !IS_NPC( d->character )
                          && lines >= d->character->pagelen) )
           {

               *scan = '\0';
               write_to_buffer( d, buffer, strlen( buffer ) );

             /* See if this is the end (or near the end) of the string */
               for ( chk = d->showstr_point; isspace( *chk ); chk++ );
               if ( !*chk )
               {
                   if ( d->showstr_head )
                   {
                       free_string( d->showstr_head );
                       d->showstr_head = str_dup( "" );
                   }
                   d->showstr_point = 0;
               }
               return;
           }

  return;
}



/*
 * Kludgy display check for ansi color.
 */
void ansi_color( const char *txt, CHAR_DATA *ch )
{
    if ( txt != NULL && ch->desc != NULL )
    {
     if ( !IS_SET(ch->act2,PLR_ANSI) && !IS_SET(ch->act2,PLR_VT100) ) return;
      else
      if ( IS_SET(ch->act2, PLR_VT100) && !IS_SET( ch->act2, PLR_ANSI ) )
      {
         if ( !str_cmp(txt, GREEN )
           || !str_cmp(txt, RED )
           || !str_cmp(txt, BLUE )
           || !str_cmp(txt, BLACK )
           || !str_cmp(txt, CYAN )
           || !str_cmp(txt, GREY )
           || !str_cmp(txt, YELLOW )
           || !str_cmp(txt, PURPLE ) ) return;
      }
     write_to_buffer( ch->desc, txt, strlen(txt) );
     return;
    }
}


/*
 * The primary output interface for echoing to characters.
 */
void global( char *buf, int level, int toggler, int toggler2 )
{
    DESCRIPTOR_DATA *d;
    
    for ( d = descriptor_list; d != NULL; d = d->next )
    {
      if ( CONNECTED(d)
        && get_trust( d->character ) >= level
        && IS_SET(d->character->act, toggler)
        && IS_SET(d->character->act, toggler2) )
      {
         send_to_char( buf, d->character );
         send_to_char( "\n\r", d->character );
      }
    }
}


/*
 * The primary output interface for echoing to descriptors.
 */
void write_global( char *buf )
{
    DESCRIPTOR_DATA *d;
    
    for ( d = descriptor_list; d != NULL; d = d->next )
       write_to_buffer( d, buf, strlen(buf) );
}


void do_global( CHAR_DATA *ch, char *argument )
{
    if ( argument[0] == '\0' )
    {
	send_to_char( "Global what?\n\r", ch );
	return;
    }

    write_global( argument );
    return;
}    


/*
 * The primary output interface for formatted output.
 */
void act( const char *format, CHAR_DATA *ch, const void *arg1, const void *arg2, int type )
{
    char buf[MAX_STRING_LENGTH];
    char fname[MAX_INPUT_LENGTH];
    CHAR_DATA *to;
    CHAR_DATA *vch = (CHAR_DATA *) arg2;
    OBJ_DATA *obj1 = (OBJ_DATA  *) arg1;
    OBJ_DATA *obj2 = (OBJ_DATA  *) arg2;
    const char *str;
    const char *i;
    char *point;

    /*
     * Discard null and zero-length messages.
     */
    if ( format == NULL || format[0] == '\0' || QUIET_STC )
        return;
        
    if ( ch == NULL )
    {
       bug( "Act: null ch", 0 );
       return;
    }
        
    if ( ch->in_room == NULL && type != TO_CHAR && type != TO_VICT )
    {
       bug( "Act: null ch->in_room", 0 );
       return;
    }

    to = ch->in_room->people;
    if ( type == TO_VICT )
    {
	if ( vch == NULL )
	{
	    bug( "Act: null vch with TO_VICT.", 0 );
	    return;
	}
	to = vch->in_room->people;
    }
    
    for ( ; to != NULL; to = to->next_in_room )
    {
    if ( to->desc == NULL || !IS_AWAKE(to) )                 continue;
    if ( type == TO_CHAR    && to != ch )                    continue;
    if ( type == TO_VICT    && ( to != vch || to == ch ) )   continue;
    if ( type == TO_ROOM    && to == ch )                    continue;
    if ( type == TO_NOTVICT && (to == ch || to == vch) )     continue;

    if ( type != TO_ALL
      && type != TO_CHAR
      && type != TO_VICT
      && type != TO_ROOM
      && type != TO_NOTVICT )
    bug( "Act: incorrect type (%d) assuming TO_ALL", type );

    point  = buf;
	str	= format;
	while ( *str != '\0' )
	{
	    if ( *str != '$' )
	    {
		*point++ = *str++;
		continue;
	    }
	    ++str;

        if ( arg2 == NULL && *str >= 'A' && *str <= 'Z'
                          && *str >= '0' && *str <= '9' )
	    {
		bug( "Act: missing arg2 for code %d.", *str );
		i = " <@@@> ";
	    }
	    else
	    {
		switch ( *str )
		{
        default:  bug( "Act: bad code %d.", *str ); i = " <@@@> ";      break;
        case '1': i = ""; if ( IS_SET( to->act2, PLR_ANSI ) ) i = BLUE; break;
        case '2': i = ""; if ( IS_SET( to->act2, PLR_ANSI ) ) i = GREEN; break;
        case '3': i = ""; if ( IS_SET( to->act2, PLR_ANSI ) ) i = CYAN; break;
        case '4': i = ""; if ( IS_SET( to->act2, PLR_ANSI ) ) i = RED; break;
        case '5': i = ""; if ( IS_SET( to->act2, PLR_ANSI ) ) i = PURPLE; break;
        case '6': i = ""; if ( IS_SET( to->act2, PLR_ANSI ) ) i = YELLOW; break;
        case '7': i = ""; if ( IS_SET( to->act2, PLR_ANSI ) ) i = GREY; break;
        case '0': i = ""; if ( IS_SET( to->act2, PLR_ANSI ) ) i = BLACK; break;
        case 'B': i = ""; if ( IS_SET( to->act2, PLR_ANSI )
                    || IS_SET( to->act2, PLR_VT100 ) ) i = BOLD;     break;
        case 'I': i = ""; if ( IS_SET( to->act2, PLR_ANSI )
                    || IS_SET( to->act2, PLR_VT100 ) ) i = INVERSE;  break;
        case 'F': i = ""; if ( IS_SET( to->act2, PLR_ANSI )
                    || IS_SET( to->act2, PLR_VT100 ) ) i = FLASH;    break;
        case 'R': i = ""; if ( IS_SET( to->act2, PLR_ANSI )
                    || IS_SET( to->act2, PLR_VT100 ) ) i = NTEXT;    break;

        /* Thx alex for 't' idea */
        case 't': i = (arg1 != NULL) ? (char *) arg1 : "(null)"; break;
        case 'T': i = (arg2 != NULL) ? (char *) arg2 : "(null)"; break;
        case 'n': i = (ch == to)  ? "you"  : PERS(ch,  to); break;
        case 'N': i = (vch == to) ? "you"  : PERS(vch, to); break;
        case 'e': i = (ch == to)  ? "you"  : HE_SHE(ch);    break;
        case 'E': i = (vch == to) ? "you"  : HE_SHE(vch);   break;
        case 'm': i = (ch == to)  ? "you"  : HIM_HER(ch);   break;
        case 'M': i = (vch == to) ? "you"  : HIM_HER(vch);  break;
        case 's': i = (ch == to)  ? "your" : HIS_HER(ch);   break;
        case 'S': i = (vch == to) ? "your" : HIS_HER(vch);  break;
        case 'i': i = (ch == to)  ? "are"  : "is";          break;
        case 'v': i = (ch == to)  ? ""     : "s";           break;
        case 'V': i = (vch == to) ? ""     : "s";           break;
        case 'w': i = (ch == to)  ? ""     : "es";          break;
        case 'W': i = (vch == to) ? ""     : "es";          break;
        case 'x': i = (ch == to)  ? "y"    : "ies";         break;
        case 'X': i = (vch == to) ? "y"    : "ies";         break;
        case 'y': i = (ch == to)  ? "r"    : "'s";          break;
        case 'Y': i = (vch == to) ? "r"    : "'s";          break;
        case 'k': i = (ch == to)  ? "are"  : "is";          break;
        case 'K': i = (vch == to) ? "are"  : "is";          break;

		case 'p':
		    i = can_see_obj( to, obj1 )
                ? STR(obj1, short_descr)
			    : "something";
		    break;

		case 'P':
		    i = can_see_obj( to, obj2 )
                ? STR(obj2, short_descr)
			    : "something";
		    break;

		case 'd':
            if ( arg2 == NULL || ((char *) arg2)[0] == '\0' )
            {
                i = "door";
            }
            else
            {
                one_argument( (char *) arg2, fname );
                i = fname;
            }
		    break;
		}
	    }
		
	    ++str;
	    while ( ( *point = *i ) != '\0' )
		++point, ++i;
	}

        *point++ = '\n';
        *point++ = '\r';                /*    *point++ = '\0'; */

        write_to_buffer( to->desc, ansi_uppercase( buf ), point - buf );
    }

    return;
}




/*
 * Macintosh support functions.
 */
#if defined(macintosh)
int gettimeofday( struct timeval *tp, void *tzp )
{
    tp->tv_sec  = time( NULL );
    tp->tv_usec = 0;
}
#endif



