/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
*/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "script.h"
#include "defaults.h"
#include "oc.h"


#if !defined(macintosh)
extern	int	_filbuf		args( (FILE *) );
#endif


/*
 * Globals.
 */
HELP_DATA *     help_first;
HELP_DATA *     help_last;

SHOP_DATA *     shop_first;
SHOP_DATA *     shop_last;


char            bug_buf         [2*MAX_INPUT_LENGTH];
CHAR_DATA *     char_list;
char *          help_greeting;
char            log_buf         [2*MAX_INPUT_LENGTH];
OBJ_DATA *      object_list;
TIME_INFO_DATA  time_info;
WEATHER_DATA    weather_info;


/*
 * GSN declarations.
 */

sh_int  gsn_backstab;
sh_int  gsn_peek;
sh_int  gsn_pick_lock;
sh_int  gsn_steal;
sh_int  gsn_haggling;

sh_int  gsn_track;
sh_int  gsn_swimming;
sh_int  gsn_climb;
sh_int  gsn_riding;
sh_int  gsn_hide;
sh_int  gsn_sneak;

sh_int  gsn_enhanced_damage;
sh_int  gsn_second_attack;
sh_int  gsn_third_attack;
sh_int  gsn_dual_wield;
sh_int  gsn_kick;
sh_int  gsn_hth;

sh_int  gsn_parry;
sh_int  gsn_dodge;
sh_int  gsn_rescue;
sh_int  gsn_flee;
sh_int  gsn_subdue;
sh_int  gsn_disarm;

sh_int  gsn_blindness;
sh_int  gsn_charm_person;
sh_int  gsn_curse;
sh_int  gsn_invis;
sh_int  gsn_mass_invis;
sh_int  gsn_poison;
sh_int  gsn_sleep;

sh_int  gsn_wp_slash;
sh_int  gsn_wp_pierce;
sh_int  gsn_wp_whip;
sh_int  gsn_wp_pound;
sh_int  gsn_wp_ranged;
sh_int  gsn_wp_other;

sh_int  gsn_wp;
sh_int  gsn_language;
sh_int  gsn_legerdemain;
sh_int  gsn_offense;
sh_int  gsn_defense;
sh_int  gsn_survival;
sh_int  gsn_fire;
sh_int  gsn_water;
sh_int  gsn_air;
sh_int  gsn_earth;
sh_int  gsn_spc_gen;
sh_int  gsn_spc_necro;
sh_int  gsn_spc_conj;
sh_int  gsn_spc_malad;
sh_int  gsn_spc_illus;
sh_int  gsn_spc_divin;
sh_int  gsn_spc_enchant;
sh_int  gsn_spc_summons;

sh_int  gsn_zengalli;
sh_int  gsn_haanstaed;
sh_int  gsn_olani;
sh_int  gsn_mudaki;
sh_int  gsn_zalufini;
sh_int  gsn_haesni;
sh_int  gsn_ghaenish;
sh_int  gsn_ict;
sh_int  gsn_imarind;
sh_int  gsn_dakonenne;




/*
 * Locals.
 */
MOB_INDEX_DATA *	mob_index_hash		[MAX_KEY_HASH];
OBJ_INDEX_DATA *	obj_index_hash		[MAX_KEY_HASH];
ROOM_INDEX_DATA *	room_index_hash		[MAX_KEY_HASH];
SCRIPT_DATA *       script_index_hash   [MAX_KEY_HASH];
char *              string_hash         [MAX_KEY_HASH];

AREA_DATA *		area_first;
AREA_DATA *		area_last;

extern char *           string_space;
extern char *           top_string;
extern char             str_empty   [1];

int         LOG_LEVEL = LEVEL_IMMORTAL;

extern int         top_help;

extern int         top_vnum_script;
extern int         top_vnum_mob;
extern int         top_vnum_obj;
extern int         top_vnum_room;
extern int         top_vnum_terrain;

TERRAIN_DATA      *terrain_list = NULL;

/*
 * Semi-locals.
 */
bool			fBootDb;
FILE *			fpArea;
char            strArea[MAX_INPUT_LENGTH];

/* values for db2.c */
struct		social_type	social_table		[MAX_SOCIALS];
int         social_count        = 0;


/*
 * From worldgen.c
 */
/*
void    dspace_init      args( ( void ) );
void    fread_map        args( ( char *filename ) );
*/


/*
 * Local booting procedures.
 */
void    load_area         args( ( FILE *fp ) );
void    load_helps        args( ( FILE *fp ) );
void    load_mobiles      args( ( FILE *fp ) );
void    load_objects      args( ( FILE *fp ) );
void    load_rooms        args( ( FILE *fp ) );
void    load_socials      args( ( FILE *fp ) );
void    load_boards       args( ( void ) );       /* board.c */
void    load_scripts      args( ( FILE *fp ) );
void    load_config       args( ( FILE *fp ) );
void    load_contents     args( ( FILE *fp ) );
void    load_terrain      args( ( FILE *fp ) );



void    dump_section_0         args( ( FILE *fp ) );
void    dump_section_s         args( ( FILE *fp ) );

void    fix_exits         args( ( void ) );

void    set_mob_hp        args( ( CHAR_DATA *mob ) );

#define                 MAX_STRING      2097152
#define			MAX_PERM_BLOCK	131072
#define			MAX_MEM_LIST	11

extern void *          rgFreeList  [MAX_MEM_LIST];
extern const int       rgSizeList  [MAX_MEM_LIST];

extern int         nAllocString;
extern int         sAllocString;
extern int         nAllocPerm;
extern int         sAllocPerm;

/*
 * Big mama top level function.
 */
void boot_db( int control )
{
    
    /*
     * Init some data space stuff.
     */
    {
	if ( ( string_space = calloc( 1, MAX_STRING ) ) == NULL )
	{
	    bug( "Boot_db: can't alloc %d string space.", MAX_STRING );
	    exit( 1 );
	}
	top_string	= string_space;
	fBootDb		= TRUE;
    }


    /*
     * Init random number generator.
     */
	init_mm( );

    /*
     * Assign gsn's for skills which have them.
     */
    {
	int sn;

	for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
	    if ( skill_table[sn].pgsn != NULL )
		*skill_table[sn].pgsn = sn;
	}
    }

    /*
     * Read in all the area files.
     */
    {
        FILE *fpList;
        char *strAreaNames[MAX_AREA];
        char buf1[MAX_STRING_LENGTH];
        char buf2[MAX_STRING_LENGTH];
        int x;

        sprintf( strArea, "%s", AREA_LIST );

        for ( x = 0; x < MAX_AREA; x++ ) strAreaNames[x] = NULL;
        
        if ( ( fpList = fopen( AREA_LIST, "r" ) ) == NULL )
        {
	    perror( AREA_LIST );
	    exit( 1 );
        }

        for ( x = 0; x < MAX_AREA; x++ )
        {
            if ( feof( fpList ) ) break;
            strAreaNames[x] = str_dup( fread_word( fpList ) );
            if ( strAreaNames[x][0] == '$' ) break;
        }

        fclose( fpList );

        sprintf( buf1, "Loading areas: [%5d]\n\r", x );
        write_global( buf1 );

        for ( x = 0; x < MAX_AREA; x++ )
        {

        if ( strAreaNames[x] == NULL ) break;

        sprintf( strArea, "%s", strAreaNames[x] );
            
        if ( strArea[0] == '$' )
                break;

        /*
         * Loading output.
         */
        {
#if defined(unix)
            poll_descriptors( control );
            clean_descriptors( );
#endif
            sprintf( buf2, "Loading file [%s]\n\r", strArea );
#if defined(unix)
            log_string( buf2 );
#endif
            write_global( buf2 );
            descriptor_output( );
        }


	    if ( strArea[0] == '-' )
	    {
            fpArea = stdin;
	    }
	    else
	    {
            if ( ( fpArea = fopen( strArea, "r" ) ) == NULL )
            {
		    perror( strArea );
		    exit( 1 );
            }
        }

        for ( ; ; )
	    {
        char *word;
                 

		if ( fread_letter( fpArea ) != '#' )
		{
		    bug( "Boot_db: # not found.", 0 );
		    exit( 1 );
		}

		word = fread_word( fpArea );

        if ( word[0] == '$'  )
                     break;

             if ( !str_cmp( word, "HELPS"      ) ) load_helps     (fpArea);
        else if ( !str_cmp( word, "SOCIALS"    ) ) load_socials   (fpArea);

        else if ( !str_cmp( word, "CONFIG"     ) ) load_config    (fpArea);
        else if ( !str_cmp( word, "CONTENTS"   ) ) load_contents  (fpArea);
        else if ( !str_cmp( word, "TERRAIN"    ) ) load_terrain   (fpArea);

        else if ( !str_cmp( word, "AREADATA"   ) ) load_area      (fpArea);
        else if ( !str_cmp( word, "MOBDATA"    ) ) load_mobiles   (fpArea);
        else if ( !str_cmp( word, "OBJDATA"    ) ) load_objects   (fpArea);
        else if ( !str_cmp( word, "ROOMDATA"   ) ) load_rooms     (fpArea);
        else if ( !str_cmp( word, "PROCDATA"   ) ) load_scripts   (fpArea);

/* Diku support */      

		else
		{
		    bug( "Boot_db: bad section name.", 0 );
		    exit( 1 );
		}
	    }

	    if ( fpArea != stdin )
		fclose( fpArea );
	    fpArea = NULL;
	}

    }

    /*
     * Fix up exits.
     * Declare db booting over.
     * Set up d-space.
     * Reset all areas once.
     * Load up the notes file.
     */
#if defined(unix)
    poll_descriptors( control );
    clean_descriptors( );
#endif

    write_global( "Performing consistency check.\n\r" );
#if defined(unix)
    log_string( "Performing consistency check." );
#endif
    descriptor_output( );
    fix_exits( );

#if defined(unix)
    poll_descriptors( control );
    clean_descriptors( );
#endif

/*
    write_global( "Initializing d-space.\n\r" );
#if defined(unix)
    log_string( "Initializing d-space." );
#endif
    descriptor_output( );
    dspace_init( );
 */

#if defined(unix)
    poll_descriptors( control );
    clean_descriptors( );
#endif
     
    write_global( "Resetting world.\n\r" );
#if defined(unix)
    log_string( "Resetting world." );
#endif
    descriptor_output( );
    update_handler( );

#if defined(unix)
    poll_descriptors( control );
    clean_descriptors( );
#endif
    

    write_global( "Loading bulletin boards.\n\r" );
#if defined(unix)
    log_string( "Loading bulletin boards." );
#endif
    descriptor_output( );
    load_boards( );

#if defined(unix)
    poll_descriptors( control );
    clean_descriptors( );
#endif

    fBootDb = FALSE;
    /*
     * Send the greeting.
     */
    {
	extern char * help_greeting;
	if ( help_greeting[0] == '.' )
        write_global( help_greeting+1 );
	else
        write_global( help_greeting   );
    }
    return;
}




#if defined(KEY)
#undef KEY
#endif

#if defined(SKEY)
#undef SKEY
#endif

#define KEY( literal, field, value )                \
                if ( !str_cmp( word, literal ) )    \
                {                                   \
                    field  = value;                 \
                    fMatch = TRUE;                  \
                    break;                          \
                }

#define SKEY( string, field )                       \
                if ( !str_cmp( word, string ) )     \
                {                                   \
                    free_string( field );           \
                    field = fread_string( fp );     \
                    fMatch = TRUE;                  \
                    break;                          \
                }


/*
 * Snarf an 'area' header line.
 */
void load_area( FILE *fp )
{
    AREA_DATA *pArea;
    char      *word;
    bool      fMatch;

    pArea               = new_area( );
    pArea->age          = 15;
    pArea->nplayer      = 0;
    free_string( pArea->filename );
    pArea->filename     = str_dup( strArea );

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
           case 'N':
            SKEY( "N", pArea->name );
            break;
           case 'S':
             KEY( "S", pArea->security, fread_number( fp ) );
            if ( !str_cmp( word, "Static" ) )
            {
                SET_BIT( pArea->area_flags, AREA_STATIC );
                fMatch = TRUE;
            }
            break;
           case 'V':
            if ( !str_cmp( word, "V" ) )
            {
                pArea->lvnum = fread_number( fp );
                pArea->uvnum = fread_number( fp );
                fMatch = TRUE;
            }
            break;
           case 'E':
             if ( !str_cmp( word, "End" ) )
             {
                 fMatch = TRUE;
				 if ( area_first == NULL )	 area_first = pArea;
				 if ( area_last  != NULL )	 area_last->next = pArea;
                 area_last   = pArea;
                 pArea->next = NULL;
                 return;
            }
            break;
           case 'B':
            SKEY( "B", pArea->builders );
            break;
           case 'R':
            SKEY( "R",  pArea->repop );
            break;
       }

       if ( !fMatch )
       {
           char buf[80];
           sprintf( buf, "Fread_area: '%s', incorrect keyword: %s",
                         strArea, word );
           bug( buf, 0 );
           fread_to_eol( fp );
       }
    }
}


/*
 * Date and time information.
 */
void load_config( FILE *fp )
{
    char      *word;
    bool      fMatch;

    /*
     * Preset time and weather.
     */
    time_info.hour  = 0;
    time_info.day   = 1;
    time_info.month = 0;
    time_info.year  = 453;

	     if ( time_info.hour <  5 ) weather_info.sunlight = SUN_DARK;
	else if ( time_info.hour <  6 ) weather_info.sunlight = SUN_RISE;
	else if ( time_info.hour < 19 ) weather_info.sunlight = SUN_LIGHT;
	else if ( time_info.hour < 20 ) weather_info.sunlight = SUN_SET;
	else                            weather_info.sunlight = SUN_DARK;

    weather_info.change  = 0;
    weather_info.winddir = 0;
        
    if ( time_info.month <= 4 || time_info.month >= 12 )
         weather_info.temperature = number_fuzzy( 20 );
    else weather_info.temperature = number_fuzzy( 50 );
             
    weather_info.windspeed = number_range( 1, 10 );
    weather_info.mmhg       = 960;
        
	if ( time_info.month >= 7 && time_info.month <=12 )
         weather_info.mmhg += number_range( 1, 50 );
    else weather_info.mmhg += number_range( 1, 80 );

	     if ( weather_info.mmhg <=  980 ) weather_info.sky = SKY_LIGHTNING;
	else if ( weather_info.mmhg <= 1000 ) weather_info.sky = SKY_RAINING;
	else if ( weather_info.mmhg <= 1020 ) weather_info.sky = SKY_CLOUDY;
	else                                  weather_info.sky = SKY_CLOUDLESS;

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
         case 'D':
            if ( !str_cmp( word, "Date" ) )
            {
                time_info.hour  = fread_number( fp );
                time_info.day   = fread_number( fp );
                time_info.month = fread_number( fp );
                time_info.year  = fread_number( fp );
                fMatch = TRUE;
            }
            break;
         case 'W':
            if ( !str_cmp( word, "WizLocked" ) )
            {
                wizlock = TRUE;
                fMatch = TRUE;
            }
            break;
         case 'M':
/*
            if ( !str_cmp( word, "Map" ) )
            {
                mapfile = fread_string( fp );
                fread_map( mapfile );
                fMatch = TRUE;
            }
 */
            if ( !str_cmp( word, "Moon" ) )
            {
                weather_info.moon_phase = fread_number( fp );
                weather_info.next_phase = fread_number( fp );
                fMatch = TRUE;
            }
            break;
         case 'N':
            if ( !str_cmp( word, "NewLocked" ) )
            {
                newlock = TRUE;
                fMatch = TRUE;
            }
            break;
         case 'E':
            if ( !str_cmp( word, "End" ) )
            {
                  if ( time_info.hour <  5 ) weather_info.sunlight = SUN_DARK;
             else if ( time_info.hour <  6 ) weather_info.sunlight = SUN_RISE;
             else if ( time_info.hour < 19 ) weather_info.sunlight = SUN_LIGHT;
             else if ( time_info.hour < 20 ) weather_info.sunlight = SUN_SET;
             else                            weather_info.sunlight = SUN_DARK;

                  if ( time_info.month <= 4 || time_info.month >= 12 )
                  weather_info.temperature = number_fuzzy( 20 );
             else weather_info.temperature = number_fuzzy( 50 );
                  return;
            }
            break;
       }

       if ( !fMatch )
       {
           char buf[80];
           sprintf( buf, "load_config: incorrect keyword %s", word );
           bug( buf, 0 );
           fread_to_eol( fp );
       }
    }
    return;
}


/*
 * Load the terrain data.
 */
void load_terrain( FILE *fp )
{
    TERRAIN_DATA *pTerrain;
    char      *word;
    bool      fMatch;

    pTerrain                    = new_terrain( );
    pTerrain->vnum              = fread_number( fp );

    pTerrain->next              = terrain_list;
    terrain_list                = pTerrain;

    if ( pTerrain->vnum > top_vnum_terrain )
    top_vnum_terrain = pTerrain->vnum;

/*    bug ( "begin new terrain (%d)", pTerrain->vnum );      */

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
          case '*': fread_to_eol( fp ); break;
          case 'E':
            if ( !str_cmp( word, "End" ) )
            {
                 return;
            }
           break;
          case 'N':
           SKEY( "N",      pTerrain->name );
           break;
          case 'C':
               {
                /*
                 * Skip blanks.
                 * Read first char.
                 */
                do
                {
                pTerrain->map_char = getc( fp );
                }
                while ( isspace(pTerrain->map_char) );
                fMatch = TRUE;
               }
           break;
          case 'D':
           SKEY( "Da",       pTerrain->winter );
           SKEY( "Db",       pTerrain->summer );
           SKEY( "Dc",       pTerrain->fall   );
           SKEY( "Dd",       pTerrain->spring );
          case 'S':
            KEY( "S",        pTerrain->sector, fread_number( fp ) );
       }

       if ( !fMatch )
       {
           char buf[80];
           sprintf( buf, "fread_terrain: %d incorrect: %s",
                         pTerrain->vnum, word );
           bug( buf, 0 );
           fread_to_eol( fp );
       }
    };
}


void load_contents( FILE *fp )
{
    char      *word;
    bool      fMatch;
    int vnum = ROOM_VNUM_TEMPLATE;
    ROOM_INDEX_DATA *pRoom = get_room_index( vnum );

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
         case 'R':
            if ( !str_cmp( word, "Room" ) )
            {
                int iNest;

                vnum = fread_number( fp );
                pRoom = get_room_index( vnum );
                if ( pRoom == NULL )
                {
                bug( "Load_contents: Invalid room %d.", vnum );
                pRoom = get_room_index( ROOM_VNUM_TEMPLATE );
                }

                for ( iNest = 0; iNest < MAX_NEST; iNest++ )
                rgObjNest[iNest] = NULL;

                fMatch = TRUE;
            }
            break;
         case 'W':
            if ( !str_cmp( word, "Wagon" ) )
            {
                int wvnum;
                OBJ_INDEX_DATA *pObjIndex;
                OBJ_DATA *pObj;

                wvnum = fread_number( fp );
                pObjIndex = get_obj_index( pRoom->wagon );
                if ( pObjIndex != NULL
                  && get_room_index( wvnum ) != NULL )
                {
                    for ( pObj = object_list; pObj != NULL; pObj = pObj->next )
                    {
                        if ( pObj->pIndexData == pObjIndex
                          && pObj->in_room != NULL )
                             break;
                    }

                    if ( pObj == NULL )
                    {
                        pObj = create_object( pObjIndex, 0 );
                        obj_to_room( pObj, get_room_index( wvnum ) );
                    }
                }

                fMatch = TRUE;
            }
         case '#':
            if ( !str_cmp( word+1, "OBJECT" ) )
            {
                fread_obj( pRoom, TYPE_ROOM, fp );
                fMatch = TRUE;
            }
         case 'S':
            if ( !str_cmp( word, "Stop" ) )
            {
                return;
            }
            break;
       }

       if ( !fMatch )
       {
           char buf[80];
           sprintf( buf, "Load_contents: incorrect keyword %s", word );
           bug( buf, 0 );
           fread_to_eol( fp );
       }
    }
    return;
}


/*
 * Snarf a help section.
 */
void load_helps( FILE *fp )
{
    HELP_DATA *pHelp;

    for ( ; ; )
    {
	pHelp		= alloc_perm( sizeof(*pHelp) );
	pHelp->level	= fread_number( fp );
	pHelp->keyword	= fread_string( fp );
    if ( pHelp->keyword[0] == '$' )
            break;
	pHelp->text	= fread_string( fp );

	if ( !str_cmp( pHelp->keyword, "greeting" ) )
	    help_greeting = pHelp->text;

	if ( help_first == NULL )
	    help_first = pHelp;
	if ( help_last  != NULL )
	    help_last->next = pHelp;

	help_last	= pHelp;
	pHelp->next	= NULL;
	top_help++;
    }

    return;
}



/*
 * Snarf a socials file.
 * This code was freely distributed with the Rivers of Mud source code.
 *                                                 -Locke
 */
void load_socials( FILE *fp)
{
    for ( ; ; ) 
    {
    	struct social_type social;
    	char *temp;
        /* clear social */
        social.char_no_arg    = NULL;
        social.others_no_arg  = NULL;
        social.char_found     = NULL;
        social.others_found   = NULL;
        social.vict_found     = NULL; 
        social.char_not_found = NULL;
        social.char_auto      = NULL;
        social.others_auto    = NULL;

        temp = fread_word(fp);
        if ( *temp == '*' )
        {
        fread_to_eol(fp);
        continue;
        }

    	if (!strcmp(temp,"#0"))
	    return;  /* done */

    	strcpy(social.name,temp);
    	fread_to_eol(fp);

	temp = fread_string_eol(fp);
	if (!strcmp(temp,"$"))
	     social.char_no_arg = NULL;
	else if (!strcmp(temp,"#"))
	{
	     social_table[social_count] = social;
	     social_count++;
	     continue; 
	}
        else
	    social.char_no_arg = temp;

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.others_no_arg = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;
             social_count++;
             continue;
        }
        else
        social.others_no_arg = str_dup( temp );

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.char_found = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;
             social_count++;
             continue;
        }
       	else
        social.char_found = str_dup( temp );

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.others_found = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;
             social_count++;
             continue;
        }
        else
        social.others_found = str_dup( temp );

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.vict_found = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;
             social_count++;
             continue;
        }
        else
        social.vict_found = str_dup( temp );

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.char_not_found = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;
             social_count++;
             continue;
        }
        else
        social.char_not_found = str_dup( temp );

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.char_auto = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;

             social_count++;
             continue;
        }
        else
	    social.char_auto = temp;
         
        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.others_auto = NULL;
        else if (!strcmp(temp,"#"))
        {
             social_table[social_count] = social;
             social_count++;
             continue;
        }
        else
        social.others_auto = str_dup( temp );
	
	social_table[social_count] = social;
    	social_count++;
   }
   return;
}



void fread_shop( FILE *fp, MOB_INDEX_DATA *pMobIndex )
{
    SHOP_DATA *pShop;
    char *word;
    bool fMatch;
    int iTrade;

    pShop           = new_shop( );

    for ( ; ; )
    {
        word   = feof( fp ) ? "EndShop" : fread_word( fp );
        fMatch = FALSE;

        switch( UPPER(word[0]) )
        {
         case 'P':
            if ( !str_cmp( word, "P" ) )
            {
                pShop->profit_buy   = fread_number( fp );
                pShop->profit_sell  = fread_number( fp );
                fMatch = TRUE;
            }
           break;
         case 'T':
            if ( !str_cmp( word, "T" ) )
            {

                for ( iTrade = 0; iTrade < MAX_TRADE; iTrade++ )
                pShop->buy_type[iTrade] = fread_number( fp );
                fMatch = TRUE;
            }
           break;
         case 'H':
            if ( !str_cmp( word, "H" ) )
            {
                pShop->open_hour    = fread_number( fp );
                pShop->close_hour   = fread_number( fp );
                fMatch = TRUE;
            }
           break;
         case 'F':
            KEY( "F",        pShop->shop_flags,     fread_number( fp ) );
           break;
         case 'R':
            KEY( "R",        pShop->repair_rate,    fread_number( fp ) );
           break;
         case 'B':
            KEY( "BI",       pShop->buy_index,      fread_number( fp ) );
          break;
         case 'C':
            KEY( "CI",       pShop->comp_index,     fread_number( fp ) );
          break;
         case 'S':
           SKEY( "Str1",     pShop->no_such_item    );
           SKEY( "Str2",     pShop->do_not_buy      );
           SKEY( "Str3",     pShop->list_header     );
            KEY( "SI",       pShop->sell_index,     fread_number( fp ) );
          break;
         case 'E':
            if ( !str_cmp( word, "EndShop" ) )
            {
                pMobIndex->pShop    = pShop;
                pShop->keeper       = pMobIndex->vnum;

                if ( shop_first == NULL )
                     shop_first = pShop;
                if ( shop_last  != NULL )
                     shop_last->next = pShop;

                shop_last   = pShop;
                pShop->next = NULL;
                return;
            }
            if ( !str_cmp( word, "End" ) )
            {
                bug( "Fread_shop: incomplete shop %d", pMobIndex->vnum );
                free_shop( pShop );
                pMobIndex->pShop = NULL;
                return;
            }
           break;
        }

        if ( !fMatch )
        {
            char buf[80];
            sprintf( buf, "Fread_shop: incorrect word %s (%%d)", word );
            bug( buf, pMobIndex->vnum );
            fread_to_eol( fp );
        }
    }

    return;
}



/*
 * Load a single mobile declaration.
 */
void fread_mobile( FILE *fp, int vnum )
{
    MOB_INDEX_DATA *pMobIndex;
    char      *word;
    bool      fMatch;
    int iHash;

    pMobIndex                   = new_mob_index( );
    pMobIndex->vnum             = vnum;
    pMobIndex->area             = area_last;

/*    bug ( "begin new mobile (%d)", vnum );      */

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
          case '*': fread_to_eol( fp ); break;
          case 'E':
            if ( !str_cmp( word, "End" ) )
            {
                 iHash                                   = vnum % MAX_KEY_HASH;
                 pMobIndex->next                 = mob_index_hash[iHash];
                 mob_index_hash[iHash]   = pMobIndex;
                 return;
            }
           break;
          case 'A':
            KEY( "A",   pMobIndex->act,         fread_number( fp ) );
            KEY( "AB", pMobIndex->affected_by, fread_number( fp ) );
            if ( !str_cmp( word, "AP" ) )
            {
                pMobIndex->perm_str = fread_number( fp );
                pMobIndex->perm_int = fread_number( fp );
                pMobIndex->perm_wis = fread_number( fp );
                pMobIndex->perm_dex = fread_number( fp );
                pMobIndex->perm_con = fread_number( fp );
                fMatch = TRUE;
            }
            if ( !str_cmp( word, "At" ) )
            {
                int num;
                ATTACK_DATA *attack;

                fMatch = TRUE;
                num    = fread_number( fp );
                if ( num >= MAX_ATTACK_DATA )
                {
                    bug( "Invalid attack index (%d)", num );
                }
                else
                {

                if ( pMobIndex->attacks[num] == NULL )
                {
                    pMobIndex->attacks[num]  =
                     alloc_perm( sizeof(*pMobIndex->attacks[num]) );
                }
                else
                {
                    bug( "Overwrote pre-existing attack (%d).", num );
                }

                attack = pMobIndex->attacks[num];
                attack->dam1             = fread_number( fp );
                attack->dam2             = fread_number( fp );
                attack->idx              = fread_number( fp );
                pMobIndex->attacks[num]        = attack;
                }
            }
           break;
          case 'M':
            KEY( "M",     pMobIndex->money,   fread_number( fp ) );
           break;
          case 'N':
           SKEY( "N",      pMobIndex->name );
           break;
          case 'S':
            KEY( "S",       pMobIndex->sex,         fread_number( fp ) );
            KEY( "Sz",       pMobIndex->size,        fread_number( fp ) );
           SKEY( "SD",       pMobIndex->short_descr );
            if ( !str_cmp( word, "Shop" ) )
            {
                fread_shop( fp, pMobIndex );
                fMatch = TRUE;
            }
            if ( !str_cmp( word, "Sk" ) )
            {
            int sn;
            int value;

            value = fread_number( fp );
            sn    = skill_lookup( fread_word( fp ) );

            if ( sn < 0 )
            bug( "Fread_mobile: unknown skill(%d)", sn );
            else
            pMobIndex->learned[sn] = value;

            fMatch = TRUE;
            }
            if ( !str_cmp( word, "Sc" ) )
            {
                TRIGGER_DATA *pTrig;

                pTrig = new_trigger( );
                pTrig->script = get_script_index( fread_number( fp ) );
                pTrig->next = pMobIndex->triggers;
                pMobIndex->triggers = pTrig;
                fMatch = TRUE;
            }
           break;
          case 'L':
           SKEY( "LD",      pMobIndex->long_descr );       break;
          case 'D':
           SKEY( "D",     pMobIndex->description );      break;
       }

       if ( !fMatch )
       {
           char buf[80];
           sprintf( buf, "fread_mobile: %d incorrect: %s",
                         vnum, word );
           bug( buf, 0 );
           fread_to_eol( fp );
       }
    };
}


/*
 * Snarf a mob section.
 */
void load_mobiles( FILE *fp )
{
    if ( area_last == NULL )
    {
    bug( "Load_mobiles: no #AREA seen yet.", 0 );
	exit( 1 );
    }

    for ( ; ; )
    {
    int vnum;
	char letter;

	letter				= fread_letter( fp );
	if ( letter != '#' )
	{
        bug( "Load_mobiles: '#' not found.", 0 );
	    exit( 1 );
	}

	vnum				= fread_number( fp );
    if ( vnum == 0 )
            break;

	fBootDb = FALSE;
	if ( get_mob_index( vnum ) != NULL )
	{
	    bug( "Load_mobiles: vnum %d duplicated.", vnum );
	    exit( 1 );
	}
	fBootDb = TRUE;

    fread_mobile( fp, vnum );
    top_vnum_mob = top_vnum_mob < vnum ? vnum : top_vnum_mob;
    }
    return;
}


/*
 * Fixes the slot numbers on certain objects.
 */
void fix_object( OBJ_INDEX_DATA *pObjIndex )
{
    fBootDb = FALSE;
	switch ( pObjIndex->item_type )
	{
	case ITEM_PILL:
	case ITEM_POTION:
	case ITEM_SCROLL:
    case ITEM_FOUNTAIN:
	    pObjIndex->value[1] = slot_lookup( pObjIndex->value[1] );
	    pObjIndex->value[2] = slot_lookup( pObjIndex->value[2] );
	    pObjIndex->value[3] = slot_lookup( pObjIndex->value[3] );
	    break;

	case ITEM_STAFF:
	case ITEM_WAND:
    case ITEM_AMMO:
	    pObjIndex->value[3] = slot_lookup( pObjIndex->value[3] );
	    break;

	}
    fBootDb = TRUE;
    return;
}


void fread_object( FILE *fp, int vnum )
{
    OBJ_INDEX_DATA *pObjIndex;
    int iHash;
    char      *word;
    bool      fMatch;

    pObjIndex                   = new_obj_index( );
    pObjIndex->vnum             = vnum;
    pObjIndex->area             = area_last;

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
          case '*': fread_to_eol( fp ); break;
          case 'E':
            KEY( "E", pObjIndex->extra_flags, fread_number( fp ) );
            if ( !str_cmp( word, "ED" ) )
            {
                EXTRA_DESCR_DATA *ed;

                ed                      = new_extra_descr( );
                ed->keyword             = fread_string( fp );
                ed->description         = fread_string( fp );
                ed->next                = pObjIndex->extra_descr;
                pObjIndex->extra_descr  = ed;
                fMatch = TRUE;
            }
            if ( !str_cmp( word, "End" ) )
            {
                iHash                   = vnum % MAX_KEY_HASH;
                pObjIndex->next         = obj_index_hash[iHash];
                obj_index_hash[iHash]   = pObjIndex;
                fix_object( pObjIndex );
                return;
            }
           break;
          case 'A':
           SKEY( "A", pObjIndex->action_descr );
            if ( !str_cmp( word, "Af" ) )
            {
                AFFECT_DATA *paf;

                paf                     = new_affect( );
                paf->location           = fread_number( fp );
                paf->modifier           = fread_number( fp );
                paf->type               = fread_number( fp );
                paf->duration           = fread_number( fp );
                paf->bitvector          = fread_number( fp );
                paf->next               = pObjIndex->affected;
                pObjIndex->affected     = paf;
                fMatch = TRUE;
            }
           break;
          case 'D':
           SKEY( "D", pObjIndex->description );
           SKEY( "DR", pObjIndex->real_description );
           break;
          case 'L':
            KEY( "L", pObjIndex->level,              fread_number( fp ) );
           break;
          case 'T':
            KEY( "Ti", pObjIndex->timer,              fread_number( fp ) );
            KEY( "T", pObjIndex->item_type,           fread_number( fp ) );
           break;
          case 'N':
            SKEY( "N", pObjIndex->name  );
           break;
          case 'S':
            KEY( "Sz", pObjIndex->size,                fread_number( fp ) );
           SKEY( "SD", pObjIndex->short_descr );
            if ( !str_cmp( word, "Sc" ) )
            {
                TRIGGER_DATA *pTrig;

                pTrig = new_trigger( );
                pTrig->script = get_script_index( fread_number( fp ) );
                pTrig->next = pObjIndex->triggers;
                pObjIndex->triggers = pTrig;
                fMatch = TRUE;
            }
           break;
          case 'P':
           SKEY( "P", pObjIndex->short_descr_plural );
           SKEY( "PD", pObjIndex->description_plural );
           break;
          case 'W':
            KEY( "W", pObjIndex->wear_flags,         fread_number( fp ) );
            KEY( "Wt", pObjIndex->weight,           fread_number( fp ) );
           break;
          case 'V':
            if ( !str_cmp( word, "V" ) )
            {
               fMatch = TRUE;
               pObjIndex->value[0] = fread_number( fp );
               pObjIndex->value[1] = fread_number( fp );
               pObjIndex->value[2] = fread_number( fp );
               pObjIndex->value[3] = fread_number( fp );
            }
           break;
          case 'C':
            KEY( "C", pObjIndex->cost,               fread_number( fp ) );
           break;

       }
               if ( !fMatch )
               {
                  sprintf( log_buf, "fread_object: vnum %d incorrect:  '%s'",
                                    vnum, word );
                  bug( log_buf, 0 );
                  fread_to_eol( fp );
               }
    };

    return;
}




/*
 * Snarf an obj section.
 */
void load_objects( FILE *fp )
{

    if ( area_last == NULL )
    {
    bug( "Load_objects: no #AREA seen yet.", 0 );
	exit( 1 );
    }

    for ( ; ; )
    {
    int vnum;
	char letter;

	letter				= fread_letter( fp );
	if ( letter != '#' )
	{
	    bug( "Load_objects: # not found.", 0 );
	    exit( 1 );
	}

	vnum				= fread_number( fp );
	if ( vnum == 0 )
	    break;

	fBootDb = FALSE;
	if ( get_obj_index( vnum ) != NULL )
	{
	    bug( "Load_objects: vnum %d duplicated.", vnum );
	    exit( 1 );
	}
	fBootDb = TRUE;

    fread_object( fp, vnum );
    top_vnum_obj = top_vnum_obj < vnum ? vnum : top_vnum_obj;
    }

    return;
}



void fread_room( FILE *fp, int vnum )
{
    ROOM_INDEX_DATA *pRoomIndex;
    int iHash;
    int door;
    char *word;
    bool fMatch;


    pRoomIndex              = new_room_index( );
	pRoomIndex->area		= area_last;
	pRoomIndex->vnum		= vnum;

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
          case '*': fread_to_eol( fp ); break;
          case 'E':
            if ( !str_cmp( word, "End" ) )
            {
                 iHash           = vnum % MAX_KEY_HASH;
                 pRoomIndex->next    = room_index_hash[iHash];
                 room_index_hash[iHash]  = pRoomIndex;
                 return;
            }
            if ( !str_cmp( word, "ED" ) )
            {
                 EXTRA_DESCR_DATA *ed;

                 ed                       = new_extra_descr( );
                 ed->keyword              = fread_string( fp );
                 ed->description          = fread_string( fp );
                 ed->next                 = pRoomIndex->extra_descr;
                 pRoomIndex->extra_descr  = ed;
                 fMatch = TRUE;
            }
           break;
          case 'R':
            if ( !str_cmp( word, "Ref" ) )
            {
                 pRoomIndex->template     = fread_number( fp );
                 fMatch = TRUE;
            }
            if ( !str_cmp( word, "R" ) )
            {
                   RESET_DATA *pReset;

                   pReset      = new_reset_data( );
                   pReset->command = fread_letter( fp );
                   pReset->rs_vnum = fread_number( fp );
                   pReset->loc     = fread_number( fp );
                   pReset->percent = fread_number( fp );
                   pReset->num     = fread_number( fp );
                   fread_to_eol( fp );

                   if ( pRoomIndex->reset_first == NULL )
                        pRoomIndex->reset_first  = pReset;
                   if ( pRoomIndex->reset_last  != NULL )
                        pRoomIndex->reset_last->next = pReset;

                   pRoomIndex->reset_last   = pReset;
                   pReset->next             = NULL;
                   fMatch = TRUE;
            }
           break;
          case 'D':
           SKEY( "D", pRoomIndex->description );
            if ( !str_cmp( word, "Dr" ) )
            {
               EXIT_DATA *pexit;

               door                = fread_number( fp );

               if ( door < 0 || door >= MAX_DIR )
               {
                   bug( "Fread_rooms: vnum %d has bad door number.", vnum );
                   exit( 1 );
               }

               pexit           = new_exit( );

               pexit->rs_flags     = fread_number( fp );
               pexit->key          = fread_number( fp );
               pexit->vnum         = fread_number( fp );

               pexit->description  = fread_string( fp );
               pexit->keyword      = fread_string( fp );

               pRoomIndex->exit[door]  = pexit;
               fMatch = TRUE;
            }

           break;
          case 'M':
            KEY( "M", pRoomIndex->max_people, fread_number( fp ) );
           break;
          case 'N':
           SKEY( "N", pRoomIndex->name );
           break;
          case 'F':
            KEY( "F", pRoomIndex->room_flags,   fread_number( fp ) );
           break;
          case 'W':
            KEY( "W", pRoomIndex->wagon,        fread_number( fp ) );
           break;
          case 'T':
            if ( !str_cmp( word, "T" ) )
            {
                pRoomIndex->terrain    = fread_number( fp );
                fMatch = TRUE;
            }
           break;
          case 'S':
            KEY( "S", pRoomIndex->sector_type, fread_number( fp ) );
            if ( !str_cmp( word, "Sc" ) )
            {
                TRIGGER_DATA *pTrig;

                pTrig = new_trigger( );
                pTrig->script = get_script_index( fread_number( fp ) );
                pTrig->next = pRoomIndex->triggers;
                pRoomIndex->triggers = pTrig;
                fMatch = TRUE;
            }
           break;
       }
               if ( !fMatch )
               {
                  char buf[80];
                  sprintf( buf, "fread_rooms: incorrect titler %s on v%d",
                                word, vnum );
                  bug( buf, 0 );
                  fread_to_eol( fp );
               }
    };

}

/*
 * Snarf a room section.
 */
void load_rooms( FILE *fp )
{

    if ( area_last == NULL )
    {
    bug( "Load_rooms: no #AREA seen yet.", 0 );
        exit( 1 );
    }

    for ( ; ; )
    {
    int vnum;
    char letter;

        letter                          = fread_letter( fp );
        if ( letter != '#' )
        {
            bug( "Load_rooms: # not found.", 0 );
            exit( 1 );
        }

        vnum                            = fread_number( fp );
        if ( vnum == 0 )
            break;

        fBootDb = FALSE;
        if ( get_room_index( vnum ) != NULL )
        {
            bug( "Load_rooms: vnum %d duplicated.", vnum );
            exit( 1 );
        }
        fBootDb = TRUE;

    fread_room( fp, vnum );
    top_vnum_room = top_vnum_room < vnum ? vnum : top_vnum_room;
    }

    return;
}



void fread_script( FILE *fp, int vnum )
{
    SCRIPT_DATA *script;
    char        *word;
    bool        fMatch;
    int         iHash;

    script                =  new_script( );
    script->vnum          =  vnum;
    script->area          =  area_last;

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
          case '*': fread_to_eol( fp ); fMatch = TRUE; break;
          case 'N':
           SKEY( "N", script->name );
           break;
          case 'E':
            if ( !str_cmp( word, "End" ) )
            {
               iHash                    = vnum % MAX_KEY_HASH;
               script->next             = script_index_hash[iHash];
               script_index_hash[iHash] = script;
               return;
            }
           break;
          case 'C':
           SKEY( "C", script->commands );
           break;

          case 'T':
            KEY( "T", script->type, fread_number( fp ) );
           break;
       }
               if ( !fMatch )
               {
                  char buf[80];
                  sprintf( buf, "fread_script: incorrect '%s'", word );
                  bug( buf, 0 );
                  fread_to_eol( fp );
               }
    };
}


/*
 * Snarf a script section.
 */
void load_scripts( FILE *fp )
{
    if ( area_last == NULL )
    {
        bug( "Load_scripts: no #AREA seen yet.", 0 );
        exit( 1 );
    }

    for ( ; ; )
    {
        int vnum;
        char letter;

        letter                          = fread_letter( fp );
        if ( letter != '#' )
        {
            bug( "Load_scripts: # not found.", 0 );
            exit( 1 );
        }

        vnum                            = fread_number( fp );
        if ( vnum == 0 )
            break;

        fBootDb = FALSE;
        if ( get_script_index( vnum ) != NULL )
        {
            bug( "Load_scripts: vnum %d duplicated.", vnum );
            exit( 1 );
        }
        fBootDb = TRUE;

        fread_script( fp, vnum );
        top_vnum_script = top_vnum_script < vnum ? vnum : top_vnum_script;
    }

    return;
}



/*
 * Translate all room exits from virtual to real.
 * Has to be done after all rooms are read in.
 * Check for bad reverse exits.
 */
void fix_exits( void )
{
    extern const sh_int rev_dir [];
    char buf[MAX_STRING_LENGTH];
    ROOM_INDEX_DATA *pRoomIndex;
    ROOM_INDEX_DATA *to_room;
    EXIT_DATA *pexit;
    EXIT_DATA *pexit_rev;
    int iHash;
    int door;

    for ( iHash = 0; iHash < MAX_KEY_HASH; iHash++ )
    {
	for ( pRoomIndex  = room_index_hash[iHash];
	      pRoomIndex != NULL;
	      pRoomIndex  = pRoomIndex->next )
	{
	    bool fexit;

	    fexit = FALSE;
        for ( door = 0; door < MAX_DIR; door++ )
	    {
		if ( ( pexit = pRoomIndex->exit[door] ) != NULL )
		{
		    fexit = TRUE;
		    if ( pexit->vnum <= 0 )
			pexit->to_room = NULL;
		    else
			pexit->to_room = get_room_index( pexit->vnum );
                    pexit->exit_info = pexit->rs_flags;
		}
	    }

	    if ( !fexit )
		SET_BIT( pRoomIndex->room_flags, ROOM_NO_MOB );
	}
    }

    for ( iHash = 0; iHash < MAX_KEY_HASH; iHash++ )
    {
	for ( pRoomIndex  = room_index_hash[iHash];
	      pRoomIndex != NULL;
	      pRoomIndex  = pRoomIndex->next )
	{
        for ( door = 0; door < MAX_DIR; door++ )
	    {
		if ( ( pexit     = pRoomIndex->exit[door]       ) != NULL
		&&   ( to_room   = pexit->to_room               ) != NULL
		&&   ( pexit_rev = to_room->exit[rev_dir[door]] ) != NULL
		&&   pexit_rev->to_room != pRoomIndex )
		{
		    sprintf( buf, "Fix_exits: %d:%d -> %d:%d -> %d.",
			pRoomIndex->vnum, door,
			to_room->vnum,    rev_dir[door],
			(pexit_rev->to_room == NULL)
			    ? 0 : pexit_rev->to_room->vnum );
		    bug( buf, 0 );
		}
	    }
        reset_room( pRoomIndex );
        script_update( pRoomIndex, TYPE_ROOM, TRIG_BORN, NULL, NULL, NULL, NULL );
	}
    }

    return;
}


/*
 * Create an instance of a mobile.
 */
CHAR_DATA *create_mobile( MOB_INDEX_DATA *pMobIndex )
{
    CHAR_DATA *mob;

    if ( pMobIndex == NULL )
    {
	bug( "Create_mobile: NULL pMobIndex.", 0 );
    if ( fBootDb ) exit( 1 );

	pMobIndex = get_mob_index( MOB_VNUM_TEMPLATE );
    }
    
    mob = new_char_data( );
    free_pc_data( mob->pcdata );
    mob->pcdata = NULL;

    mob->pIndexData	= pMobIndex;

    mob->name           = NULL;
    mob->short_descr    = NULL;
    mob->long_descr     = NULL;
    mob->description    = NULL;

    mob->position       = POS_STANDING;
    mob->size           = pMobIndex->size;
    mob->race           = pMobIndex->race;

    mob->perm_str       = pMobIndex->perm_str;
    mob->perm_int       = pMobIndex->perm_int;
    mob->perm_wis       = pMobIndex->perm_wis;
    mob->perm_dex       = pMobIndex->perm_dex;
    mob->perm_con       = pMobIndex->perm_con;
    
    mob->fmode          = pMobIndex->fmode;

    mob->triggers       = NULL;
    mob->current        = NULL;

    if ( pMobIndex->triggers != NULL )
    {
    TRIGGER_DATA *trig, *pTrig;

    for ( pTrig = pMobIndex->triggers;  pTrig != NULL;  pTrig = pTrig->next )
    {
        trig               = new_trigger( );

        trig->script       = pTrig->script;
        trig->location     = NULL;

        trig->next       = mob->triggers;
        mob->triggers    = trig;
    }
    }

    mob->timer          = pMobIndex->timer;
    mob->act            = pMobIndex->act;
    mob->affected_by	= pMobIndex->affected_by;
    mob->sex            = pMobIndex->sex;

    if ( pMobIndex->money > 1 )
    create_amount( number_gelify( pMobIndex->money-1 )+1, mob, NULL, NULL );
    else
    if ( pMobIndex->money > 0 ) create_amount( 1, mob, NULL, NULL );

    mob->prompt     = str_dup( "Mob(%h %m): " );
    mob->armor      = 100;
    mob->hit        = MAXHIT(mob);
    mob->move       = MAXMOVE(mob);

    /*
     *  Randomize color, size, and anything else we want!
     */
    mob_strings( mob );

    /*
     * Insert in list.
     */
    mob->next		= char_list;
    char_list		= mob;
    pMobIndex->count++;

    return mob;
}



/*
 * Create an instance of an object.
 */
OBJ_DATA *create_object( OBJ_INDEX_DATA *pObjIndex, int level )
{
    OBJ_DATA *obj;

    if ( pObjIndex == NULL )
    {
	bug( "Create_object: NULL pObjIndex.", 0 );
    if ( fBootDb ) exit( 1 );

	pObjIndex = get_obj_index( OBJ_VNUM_TEMPLATE );
    }

    if ( pObjIndex->item_type == ITEM_LIST && level != -1 )
    {
        OBJ_INDEX_DATA *pIndex;
        char *scanarg;
        char buf[20];
        int num;
        int d;

        scanarg    = pObjIndex->description;
        num        = number_range( 1, arg_count( pObjIndex->description ) );
        buf[0]     = '\0';

        for ( d = 0; d < num; d++ )
        {
            scanarg = one_argument( scanarg, buf );
        }

        num       = atoi( buf );
        pIndex = get_obj_index( num );
        if ( pIndex != NULL ) pObjIndex = pIndex;
    }
    else level = 0;

    obj = new_obj( );
    obj->pIndexData	= pObjIndex;

    if (pObjIndex->level == 0)
         obj->level      = level;
    else obj->level      = pObjIndex->level;

    obj->wear_loc           = WEAR_NONE;

    obj->name               = NULL;
    obj->short_descr        = NULL;
    obj->description        = NULL;
    obj->action_descr       = NULL;
    obj->short_descr_plural = NULL;
    obj->description_plural = NULL;
    obj->real_description   = NULL;

    if ( pObjIndex->triggers != NULL )
    {
    TRIGGER_DATA *trig, *pTrig;

    for ( pTrig = pObjIndex->triggers;  pTrig != NULL;  pTrig = pTrig->next )
    {
        trig               = new_trigger( );

        trig->script       = pTrig->script;
        trig->location     = NULL;

        trig->next       = obj->triggers;
        obj->triggers    = trig;
    }
    }

    obj->item_type      = pObjIndex->item_type;
    obj->extra_flags	= pObjIndex->extra_flags;
    obj->wear_flags     = pObjIndex->wear_flags;
    obj->value[0]       = pObjIndex->value[0];
    obj->value[1]       = pObjIndex->value[1];
    obj->value[2]       = pObjIndex->value[2];
    obj->value[3]       = pObjIndex->value[3];
    obj->size           = pObjIndex->size;
    obj->weight         = pObjIndex->weight;
    if (pObjIndex->cost == 0)
     obj->cost          = number_fuzzy( 10 )
                        * number_fuzzy( level ) * number_fuzzy( level );
    else obj->cost      = number_range( pObjIndex->cost - pObjIndex->cost/8, 
                                        pObjIndex->cost + pObjIndex->cost/8 );

    /*
     * Mess with object properties.
     */
    switch ( obj->item_type )
    {
    default:
    if ( obj->item_type >= ITEM_MAX )
        bug( "Read_object: vnum %d bad type.", pObjIndex->vnum );
	break;

    case ITEM_SCROLL:
	obj->value[0]	= number_fuzzy( obj->value[0] );
	break;

    case ITEM_WAND:
    case ITEM_STAFF:
	obj->value[0]	= number_fuzzy( obj->value[0] );
	obj->value[1]	= number_fuzzy( obj->value[1] );
	obj->value[2]	= obj->value[1];
	break;

    case ITEM_WEAPON:
    if ( obj->value[1] != 0 && obj->value[2] != 0 )
    {
         obj->value[1]   = number_fuzzy( obj->value[1] );
         obj->value[2]   = number_fuzzy( obj->value[2] );
    }
    else
    {
         obj->value[1]   = number_fuzzy( number_fuzzy( 1 * level / 4 + 2 ) );
         obj->value[2]   = number_fuzzy( number_fuzzy( 3 * level / 4 + 6 ) );
    }
    break;

    case ITEM_ARMOR:
    if ( obj->value[0] != 0 )
    {
         obj->value[0]   = number_fuzzy( obj->value[0] );
    }
    else    obj->value[0]   = number_fuzzy( level / 4 + 2 );

    if ( obj->value[2] != 0 )
    {
         obj->value[2]   = number_fuzzy( obj->value[2] );
         obj->value[1]   = obj->value[2];
    }
	break;

    case ITEM_POTION:
    case ITEM_PILL:
	obj->value[0]	= number_fuzzy( number_fuzzy( obj->value[0] ) );
	break;

    case ITEM_MONEY:
	obj->value[0]	= obj->cost;
	break;
    }

    /*
     *  Randomize color, size, and anything else we want!
     */
    obj_strings( obj );

    obj->next		= object_list;
    object_list		= obj;
    pObjIndex->count++;

    return obj;
}




/*
 * Translates mob virtual number to its mob index struct.
 * Hash table lookup.
 */
MOB_INDEX_DATA *get_mob_index( int vnum )
{
    MOB_INDEX_DATA *pMobIndex;

    if ( !fBootDb && vnum > top_vnum_mob ) return NULL;

    for ( pMobIndex  = mob_index_hash[vnum % MAX_KEY_HASH];
	  pMobIndex != NULL;
	  pMobIndex  = pMobIndex->next )
    {
	if ( pMobIndex->vnum == vnum )
	    return pMobIndex;
    }

    if ( fBootDb )
    {
	bug( "Get_mob_index: bad vnum %d.", vnum );
	exit( 1 );
    }

    return NULL;
}



/*
 * Translates mob virtual number to its obj index struct.
 * Hash table lookup.
 */
OBJ_INDEX_DATA *get_obj_index( int vnum )
{
    OBJ_INDEX_DATA *pObjIndex;

    if ( !fBootDb && vnum > top_vnum_obj ) return NULL;

    for ( pObjIndex  = obj_index_hash[vnum % MAX_KEY_HASH];
	  pObjIndex != NULL;
	  pObjIndex  = pObjIndex->next )
    {
	if ( pObjIndex->vnum == vnum )
	    return pObjIndex;
    }

    if ( fBootDb )
    {
	bug( "Get_obj_index: bad vnum %d.", vnum );
	exit( 1 );
    }

    return NULL;
}



/*
 * Translates mob virtual number to its room index struct.
 * Hash table lookup.
 */
ROOM_INDEX_DATA *get_room_index( int vnum )
{
    ROOM_INDEX_DATA *pRoomIndex;

    if ( !fBootDb && vnum > top_vnum_room ) return NULL;

    for ( pRoomIndex  = room_index_hash[vnum % MAX_KEY_HASH];
          pRoomIndex != NULL;
          pRoomIndex  = pRoomIndex->next )
    {
        if ( pRoomIndex->vnum == vnum )
            return pRoomIndex;
    }

    if ( fBootDb )
    {
        bug( "Get_room_index: bad vnum %d.", vnum );
        exit( 1 );
    }

    return NULL;
}

/*
 * Translates virtual number to its script index struct.
 * Hash table lookup.
 */
SCRIPT_DATA *get_script_index( int vnum )
{
    SCRIPT_DATA *script;

    if ( !fBootDb && vnum > top_vnum_script ) return NULL;

    for ( script  = script_index_hash[vnum % MAX_KEY_HASH];
          script != NULL;
          script  = script->next )
    {
        if ( script->vnum == vnum )
            return script;
    }

    if ( fBootDb )
    {
        bug( "Get_script_index: bad vnum %d.", vnum );
        exit( 1 );
    }

    return NULL;
}






/*
 * Randomized strings.
 */
#define MAX_COLOR_LIST        20
#define MAX_FINE_COLOR_LIST   42
#define MAX_CLOTH_LIST         7
#define MAX_FUR_LIST          11
#define MAX_GEM_LIST          111

char *   const  color_list [MAX_COLOR_LIST] =
{
    "red",               "blue",
    "black",             "turquoise",
    "aquamarine",        "yellow",
    "indigo",            "purple",
    "magenta",           "lavender",
    "green",             "white",
    "ochre",             "orange",
    "violet",            "maroon",
    "mauve",             "brown",
    "tan",               "grey"         /* 20 */
};

char *   const  fine_color_list [MAX_FINE_COLOR_LIST] =
{
    "red",              "ruby-red",       "blue",             "sky-blue",
    "black",            "jet-black",      "turquoise",        "cyan",
    "aquamarine",       "blue-green",     "yellow",           "canary yellow",
    "indigo",           "dark blue",      "purple",           "chrome-purple",
    "magenta",          "steel-grey",     "lavender",         "blood-red",
    "green",            "olive drab",     "white",            "ghost-white",
    "ochre",            "burnt-ochre",    "orange",           "leaf-green",
    "violet",           "orange-sienna",  "maroon",           "milky-white",
    "mauve",            "faded brown",    "brown",            "sienna-brown",
    "tan",              "ivy-green",      "grey",             "slate-grey",
    "cobalt-blue",      "forest-green",
};

char *   const  cloth_list [MAX_CLOTH_LIST] =
{
    "satin",
    "linen",
    "silk",
    "cloth",
    "wool",
    "cotton",
    "patchcloth"            /* 7 */
};

int      const  cloth_list_inc [MAX_CLOTH_LIST] =
{
    150,
    120,
    200,
    100,
    110,
    100,
    50
};

char *   const  fur_list [MAX_FUR_LIST] =
{
    "bear",
    "mink",
    "squirrel",
    "fox",
    "grey fox",
    "beaver",
    "ermine",
    "weasel",
    "ferret",
    "raccoon",
    "rabbit",                 /* 11 */
};


const   struct  gem_list_type  gem_list[MAX_GEM_LIST]   =
{ /*    Name                        Mana              Cost  Plural                 */
  { "blue diamond",                 1000, MA|MW,      5000, NULL    },
  { "black diamond",                 600, MA|ME,      3000, NULL    },
  { "red corundum",                  600, MF,         3000, NULL    },
  { "ruby",                          600, MF,         3000, "rubies" },
  { "auburn diamond",                400, MA|MF|ME,   2000, NULL    },
  { "clear diamond",                 300, MA,         1500, NULL    },
  { "crimson topaz",                 300, MF,         1500, "crimson topaz" },
  { "blue sapphire",                 280, MW,         1400, NULL    },
  { "clear sapphire",                280, MA,         1400, NULL    },
  { "yellow sapphire",               280, MF,         1400, NULL    },
  { "green sapphire",                280, ME,         1400, NULL    },
  { "grass-green emerald",           280, ME,         1400, NULL    },
  { "flawed clear diamond",          250, MA,         1250, NULL    },
  { "flawed pink topaz",             250, MF|MA,      1250, "pink topaz" },
  { "gold-flecked lapis lazuli",     220, ME,         1100, NULL    },
  { "fire opal",                     200, MF,         1000, NULL    },
  { "blue lapis lazuli",             200, ME|MW,      1000, NULL    },
  { "black ceylonite",               200, ME,         1000, NULL    },
  { "golden beryl",                  200, MF|MA,      1000, NULL    },
  { "pink beryl",                    200, MF,         1000, NULL    },
  { "colorless topaz",               200, MA,         1000, "colorless topaz" },
  { "yellow topaz",                  200, MF,         1000, "yellow topaz" },
  { "blue topaz",                    200, MW,         1000, "blue topaz" },
  { "blood spinel",                  180, MF|ME,       900, NULL    },
  { "star ruby",                     150, MF,          750, "star rubies" },
  { "pale aquamarine",               150, MW|MA,       750, NULL    },
  { "red spinel",                    150, MF,          750, NULL    },
  { "indigo spinel",                 150, MW,          750, NULL    },
  { "violet spinel",                 150, MW,          750, NULL    },
  { "black opal",                    150, MF,          750, NULL    },
  { "bright green demantoid garnet", 140, ME,          700, NULL    },
  { "fire sphene",                   140, MF,          700, NULL    },
  { "earthen andradite",             130, ME,          650, NULL    },
  { "gray-blue spinel",              120, ME|MW,       600, NULL    },
  { "sea-green spinel",              120, MW,          600, NULL    },
  { "purple-red almandine garnet",   120, MF|MA|MW,    600, NULL    },
  { "cymophane cats-eye",            120, MF|ME,       600, NULL    },
  { "brown jadeite",                 120, ME,          600, NULL    },
  { "green sphene",                  120, ME,          600, NULL    },
  { "orange jadeite",                120, MF,          600, NULL    },
  { "jade",                          120, ME,          600, NULL    },
  { "mauve jadeite",                 110, MF|MW,       550, NULL    },
  { "yellow sphene",                 110, MF,          550, NULL    },
  { "deep red pyrope",               110, MF,          550, NULL    },
  { "pale gray jadeite",             110, ME,          550, NULL    },
  { "fine deep blue turquoise",      100, MW,          500, NULL    },
  { "brown sphene",                  100, ME,          500, NULL    },
  { "white opal",                    100, MA,          500, NULL    },
  { "greenish-blue turquoise",       100, ME|MW,       500, NULL    },
  { "pale blue turquoise",           100, MW|MA,       500, NULL    },
  { "green turquoise",               100, ME,          500, NULL    },
  { "light green jadeite",           100, ME|MA,       500, NULL    },
  { "apple green jadeite",           100, ME,          500, NULL    },
  { "emerald green jadeite",         100, ME,          500, NULL    },
  { "carbonado crystal",             100, ME|MF,       500, "crystals of carbonado" },
  { "star sapphire",                 100, MF,          500, NULL    },
  { "green grossularite garnet",     100, ME,          500, NULL    },
  { "yellow-red hessonite garnet",   100, MF,          500, NULL    },
  { "orange-red spessartite garnet", 100, MF,          500, NULL    },
  { "pale green chrysoberyl",        100, ME,          500, NULL    },
  { "pale yellow chrysoberyl",       100, MF,          500, NULL    },
  { "green alexandrite",             100, ME,          500, NULL    },
  { "green-marked moss agate",       100, ME,          500, NULL    },
  { "black-marked moss agate",       100, MF|ME,       500, NULL    },
  { "red and white banded sardonyx",  90, MF|MA,       450, NULL    },
  { "brown tourmaline",               90, ME,          450, NULL    },
  { "black and white banded onyx",    80, MF|ME|MA,    400, NULL    },
  { "black iron tourmaline",          80, MF,          400, NULL    },
  { "green tourmaline",               80, ME,          400, NULL    },
  { "lithium tourmaline",             80, MW,          400, NULL    },
  { "lilac kunzite spodumene",        80, MW|MF,       400, NULL    },
  { "green hiddenite",                80, ME,          400, NULL    },
  { "mocha stone",                    80, ME,          400, NULL    },
  { "red tourmaline",                 70, MF,          350, NULL    },
  { "green zircon",                   70, ME,          350, NULL    },
  { "banded agate",                   70, MF|MW|ME|MA, 350, NULL    },
  { "peridot",                        60, ME|MA,       300, NULL    },
  { "olivine",                        60, ME|MA,       300, NULL    },
  { "blue zircon",                    60, MW,          300, NULL    },
  { "rust zircon",                    60, ME,          300, NULL    },
  { "clear zircon",                   60, MA,          300, NULL    },
  { "citrine",                        60, MF,          300, NULL    },
  { "amethyst",                       50, MF|MW,       500, NULL    },
  { "fine green chrysoprase",         50, ME,          250, NULL    },
  { "orthoclase feldspar",            50, ME|MW|MA|MF, 250, NULL    },
  { "milky-blue moonstone",           50, MW|MA,       250, NULL    },
  { "plagioclase feldspar",           50, ME|MW|MA|MF, 250, NULL    },
  { "reddish spangled sunstone",      50, MF,          250, NULL    },
  { "gray shimmering labradorite",    50, ME,          250, NULL    },
  { "cairngorm",                      40, ME|MW|MA|MF, 200, NULL    },
  { "rose quartz",                    40, MF,          200, NULL    },
  { "quartz cats-eye",                40, MF|ME,       200, NULL    },
  { "tigers-eye",                     40, ME|MW,       200, NULL    },
  { "green spangled aventurine",      40, MW|ME,       200, NULL    },
  { "reddish spangled aventurine",    40, MW|MF,       200, NULL    },
  { "white chalcedony",               40, MA,          200, NULL    },
  { "dark-green opaque plasma stone", 40, MW|ME,       200, NULL    },
  { "rock quartz",                    30, MW,          150, NULL    },
  { "brown jasper",                   30, ME,          150, NULL    },
  { "yellow jasper",                  30, MF|MA,       150, NULL    },
  { "red jasper",                     30, MF,          150, NULL    },
  { "green jasper",                   30, ME,          150, NULL    },
  { "orange-red carnelian",           30, MF,          150, NULL    },
  { "common opal",                    20, MW,          100, NULL    },
  { "green fluorspar",                20, ME,          100, NULL    },
  { "yellow fluorspar",               20, MF,          100, NULL    },
  { "pink fluorspar",                 20, MF,          100, NULL    },
  { "purple fluorspar",               20, MF|MW,       100, NULL    },
  { "colorless fluorspar",            20, MA,          100, NULL    },
  { "brown fluorspar",                20, ME,          100, NULL    },
  { "banded blue-john",               10, MA|MW,        50, NULL    },
};

void obj_strings( OBJ_DATA *obj )
{
   char buf[MAX_STRING_LENGTH];
   char old[MAX_STRING_LENGTH];
   char *str;
   char *i;
   char *point;
   int pass;

   char c_str[WORK_STRING_LENGTH];
   char C_str[WORK_STRING_LENGTH];
   char l_str[WORK_STRING_LENGTH];
   char f_str[WORK_STRING_LENGTH];
   char g_str[WORK_STRING_LENGTH];
   int g_int, l_int;
   bool fPlural = FALSE;

   g_int = number_range( 0, MAX_GEM_LIST-1 );
   l_int = number_range( 0, MAX_CLOTH_LIST-1 );

   sprintf( c_str, "%s", color_list[number_range( 0, MAX_COLOR_LIST-1 )] );
   sprintf( C_str, "%s", fine_color_list[number_range( 0, MAX_FINE_COLOR_LIST-1 )] );
   sprintf( l_str, "%s", cloth_list[l_int] );
   sprintf( f_str, "%s", fur_list[number_range( 0, MAX_FUR_LIST-1 )] );
   sprintf( g_str, "%s", gem_list[g_int].name );

   for ( pass = 0; pass < 6; pass++ )
   {
      switch( pass )
      {
         default: str = STR( obj, short_descr );
                  bug( "obj_strings: bad pass %d", pass );   break;
          case 0: str = STR( obj, name );                    break;
          case 1: str = STR( obj, short_descr );             break;
          case 2: str = STR( obj, description );             break;
          case 3: str = STR( obj, short_descr_plural );      break;
          case 4: str = STR( obj, real_description  );       break;
          case 5: str = STR( obj, description_plural );      break;
      }

      sprintf( old, "%s", str );
      point = buf;

      if ( !strstr( old, "$" ) ) continue;

      while( *str != '\0' )
      {
         if( *str != '$' )
         {
            *point++ = *str++;
            continue;
         }
         ++str;
         switch( *str )
         {
            default : i = " "; break;
            case 'C': i = C_str; break;
            case 'c': i = c_str; break;
            case 'l': i = l_str; 
                      obj->cost = (obj->cost * cloth_list_inc[l_int])/100;
                      break;
            case 'f': i = f_str; break;
            case 'G': i = g_str; break;
            case 'g':
             {
                 i = g_str;
                 obj->value[0]  =  gem_list[g_int].mana_flags;
                 obj->value[1]  =  gem_list[g_int].mana_value;
                 obj->value[2]  =  gem_list[g_int].mana_value;
                 obj->cost      =  gem_list[g_int].cost;

                 if ( gem_list[g_int].plural != NULL )
                 {
                     free_string( obj->short_descr_plural );
                     obj->short_descr_plural = str_dup( gem_list[g_int].plural );
                     fPlural = TRUE;
                 }
             }
            break;
         }
         ++str;
         while( (*point = *i) != '\0' )
            ++point, ++i;
      }

      *point = '\0';

      if ( str_cmp( old, buf ) )
      {
      switch( pass )
      {
         default: break;
          case 0: if ( str_cmp( STR(obj,name), buf ) )
                  {
                      free_string( obj->name );
                      obj->name                = str_dup( buf );
                  }
                  break;
          case 1: if ( str_cmp( STR(obj,short_descr), buf ) )
                  {
                      free_string( obj->short_descr );
                      obj->short_descr         = str_dup( buf );
                  }
                  break;
          case 2: if ( str_cmp( STR(obj,description), buf ) )
                  {
                      free_string( obj->description );
                      obj->description         = str_dup( buf );
                  }
                  break;
          case 3: if (!fPlural && str_cmp( STR(obj,short_descr_plural), buf ) )
                  {
                      free_string( obj->short_descr_plural );
                      obj->short_descr_plural  = str_dup( buf );
                  }
                  break;
          case 4: if ( !str_cmp( STR(obj,real_description), buf ) )
                  {
                      free_string( obj->real_description );
                      obj->real_description    = str_dup( buf );
                  }
                  break;
          case 5: if ( !str_cmp( STR(obj,description_plural), buf ) )
                  {
                      free_string( obj->description_plural );
                      obj->description_plural  = str_dup( buf );
                  }
                  break;
      }
      }

   }
   
   point = one_argument( STR( obj, short_descr ), buf );
   if ( !str_cmp( buf, "a" ) && IS_VOWEL(*point) )
   {
       sprintf( buf, "an %s", point );
       free_string( obj->short_descr );
       obj->short_descr = str_dup( buf );
   }

   point = one_argument( STR( obj, short_descr_plural ), buf );
   if ( !str_cmp( buf, "a" ) && IS_VOWEL(*point) )
   {
       sprintf( buf, "an %s", point );
       free_string( obj->short_descr_plural );
       obj->short_descr_plural = str_dup( buf );
   }
   
   point = one_argument( STR( obj, description ), buf );
   if ( !str_cmp( buf, "a" ) && IS_VOWEL(*point) )
   {
       sprintf( buf, "An %s", point );
       free_string( obj->description );
       obj->description = str_dup( buf );
   }

   point = one_argument( STR( obj, real_description ), buf );
   if ( !str_cmp( buf, "a" ) && IS_VOWEL(*point) )
   {
       sprintf( buf, "An %s", point );
       free_string( obj->real_description );
       obj->description = str_dup( buf );
   }

   point = one_argument( STR( obj, description_plural ), buf );
   if ( !str_cmp( buf, "a" ) && IS_VOWEL(*point) )
   {
       sprintf( buf, "An %s", point );
       free_string( obj->description_plural );
       obj->description = str_dup( buf );
   }
   
   return;
}


void mob_strings( CHAR_DATA *mob )
{
   char buf[MAX_STRING_LENGTH];
   char old[MAX_STRING_LENGTH];
   char *str;
   char *i;
   char *point;
   int pass;

   char c_str[WORK_STRING_LENGTH];
   char C_str[WORK_STRING_LENGTH];
   char l_str[WORK_STRING_LENGTH];
   char f_str[WORK_STRING_LENGTH];
   char g_str[WORK_STRING_LENGTH];

   sprintf(c_str, "%s", color_list[number_range(0,MAX_COLOR_LIST-1)]);
   sprintf(C_str, "%s", fine_color_list[number_range(0,MAX_FINE_COLOR_LIST-1)]);
   sprintf(l_str, "%s", cloth_list[number_range(0,MAX_CLOTH_LIST-1)]);
   sprintf(f_str, "%s", fur_list[number_range(0,MAX_FUR_LIST-1)]);
   sprintf(g_str, "%s", gem_list[number_range(0,MAX_GEM_LIST-1)].name);

   for ( pass = 0; pass < 4; pass++ )
   {
      switch( pass )
      {
         default: str = STR( mob, short_descr );
                  bug( "Mob_strings: bad pass %d", pass );   break;
          case 0: str = STR( mob, name );                    break;
          case 1: str = STR( mob, short_descr );             break;
          case 2: str = STR( mob, long_descr );              break;
          case 3: str = STR( mob, description );             break;
      }

      sprintf( old, "%s", str );
      point = buf;

      if ( !strstr( old, "$" ) ) continue;

      while( *str != '\0' )
      {
         if( *str != '$' )
         {
            *point++ = *str++;
            continue;
         }
         ++str;
         switch( *str )
         {
            default : i = " "; break;
            case 'C': i = C_str; break;
            case 'c': i = c_str; break;
            case 'l': i = l_str; break;
            case 'f': i = f_str; break;
            case 'G': i = g_str; break;
            break;
         }
         ++str;
         while( (*point = *i) != '\0' )
            ++point, ++i;
      }

      *point = '\0';

      if ( str_cmp( old, buf ) )
      {
      switch( pass )
      {
         default: break;
          case 0: if ( str_cmp( STR(mob,name), buf ) )
                  {
                      free_string( mob->name );
                      mob->name                = str_dup( buf );
                  }
                  break;
          case 1: if ( str_cmp( STR(mob,short_descr), buf ) )
                  {
                      free_string( mob->short_descr );
                      mob->short_descr         = str_dup( buf );
                  }
                  break;
          case 2: if ( str_cmp( STR(mob,long_descr), buf ) )
                  {
                      free_string( mob->long_descr );
                      mob->long_descr          = str_dup( buf );
                  }
                  break;
          case 3: if ( str_cmp( STR(mob,description), buf ) )
                  {
                      free_string( mob->description );
                      mob->description         = str_dup( buf ); break;
                  }
      }
      }

   }
   
   point = one_argument( STR( mob, short_descr ), buf );
   if ( !str_cmp( buf, "a" ) && IS_VOWEL(*point) )
   {
       sprintf( buf, "an %s", point );
       free_string( mob->short_descr );
       mob->short_descr = str_dup( buf );
   }

   point = one_argument( STR( mob, long_descr ), buf );
   if ( !str_cmp( buf, "a" ) && IS_VOWEL(*point) )
   {
       sprintf( buf, "An %s", point );
       free_string( mob->long_descr );
       mob->long_descr = str_dup( buf );
   }

   return;
}





/*
 * Reports a bug.
 */
void bug( const char *str, int param )
{
    char buf[MAX_STRING_LENGTH];
    FILE *fp;

    if ( fpArea != NULL )
    {
	int iLine;
	int iChar;

	if ( fpArea == stdin )
	{
	    iLine = 0;
	}
	else
	{
	    iChar = ftell( fpArea );
	    fseek( fpArea, 0, 0 );
	    for ( iLine = 0; ftell( fpArea ) < iChar; iLine++ )
	    {
		while ( getc( fpArea ) != '\n' )
		    ;
	    }
	    fseek( fpArea, iChar, 0 );
	}

	sprintf( buf, "[*****] FILE: %s LINE: %d", strArea, iLine );
	log_string( buf );

	if ( ( fp = fopen( "shutdown.txt", "a" ) ) != NULL )
	{
	    fprintf( fp, "[*****] %s\n", buf );
	    fclose( fp );
	}
    }

    strcpy( buf, "[*****] BUG: " );
    sprintf( buf + strlen(buf), str, param );
    if ( !fBootDb )
    {
    sprintf( log_buf, "Notify> %s", buf );
    NOTIFY( log_buf, LEVEL_IMMORTAL, WIZ_NOTIFY_BUG );
    }
    log_string( buf );

    if ( fBootDb ) fclose( fpReserve );
    if ( ( fp = fopen( BUG_FILE, "a" ) ) != NULL )
    {
	fprintf( fp, "%s\n", buf );
	fclose( fp );
    }
    if ( fBootDb ) fpReserve = fopen( NULL_FILE, "r" );

    return;
}



/*
 * Writes a string to the log.
 */
void log_string( const char *str )
{
    char *strtime;
    char buf[MAX_STRING_LENGTH];

    strtime                    = ctime( &current_time );
    strtime[strlen(strtime)-1] = '\0';
    fprintf( stderr, "%s :: %s\n", strtime, str );

    sprintf( buf, "Notify> LOG: %s", str );
    NOTIFY( buf, LOG_LEVEL, WIZ_NOTIFY_LOG );
    return;
}




/*
 * Dump (ignore) a section that ends in #0
 */
void dump_section_0( FILE *fp )
{
    for ( ; ; )
    {
	char letter;
    int num;

    if ( ( letter = fread_letter( fp ) ) == '#' )
     if ( ( num = fread_number( fp ) ) == 0 )
        break;

    fread_to_eol( fp );
    continue;
    }

    return;
}

/*
 * Dump (ignore) a section that ends in 'S'
 */
void dump_section_s( FILE *fp )
{
    for ( ; ; )
    {
	char letter;

	if ( ( letter = fread_letter( fp ) ) == 'S' )
	    break;

    fread_to_eol( fp );
    continue;
    }

    return;
}


/*
 * This function is here to aid in debugging.
 * If the last expression in a function is another function call,
 *   gcc likes to generate a JMP instead of a CALL.
 * This is called "tail chaining."
 * It hoses the debugger call stack for that call.
 * So I make this the last call in certain critical functions,
 *   where I really need the call stack to be right for debugging!
 *
 * If you don't understand this, then LEAVE IT ALONE.
 * Don't remove any calls to tail_chain anywhere.
 *
 * -- Furey
 */
void tail_chain( void )
{
    return;
}




