/****************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *                                                                          *
 *      This is the server software for The Isles, called NiMUD 4.0.        *
 *    Copyright (c) 1994-1999 by Herb Gilliland.  All rights reserved.      *
 *                                                                          *
 *  Much time and thought has gone into this software and you are           *
 *  benefitting.  We hope that you share your changes too.  What goes       *
 *  around, comes around.                                                   *
 *                                                                          *
 ****************************************************************************
 *   Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *   Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 ****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <time.h>

#include "mud.h"
#include "skills.h"
#include "spells.h"


/*               DUMs (3)
Name             Address                 Numeric Address  Port  Status Notes
----------------------------------------------------------------------------
CanDUM II        cheetah.vlsi.uwaterloo.ca                2001  up 
                 cheetah.vlsi-cheetahnet.uwaterloo.ca 
                                         129.97.180.1 
                                         129.97.94.45 
DUM II           elektra.ling.umu.se     130.239.24.66    2001  up 
FranDUM          mousson.enst.fr         137.194.160.48   2001  up 
----------------------------------------------------------------------------
*/



char *   const  percent_hit [] =
{
    "slaughtered",
    "massacred",
    "bloodied",
    "beaten",
    "hurt",
    "slighted",
    "bruised",
    "scratched",
    "grazed",
    "fine",
    "fine"
};

char *   const  percent_tired [] =
{
    "exhausted",
    "beat",
    "tired",
    "weary",
    "haggard",
    "fatigued",
    "worked",
    "winded",
    "rested",
    "fresh",
    "fresh"
};


/*
 * Coin information
 */
const struct coin_type coin_table[MAX_COIN] =
{
   {  10,    10000,   1, "bezain",     "bp"  },
   {  10,     1000,   1, "platinum",   "pp"  },
   {  10,      100,   1, "gold",       "gp"  },
   {  10,       10,   1, "silver",     "sp"  },
   {  10,        1,   1, "copper",     "cp"  }
};



/*
 * Bust a race.
 */
const struct   race_type  race_table [MAX_RACE] =
{
  { "human",
    {  0,  0,  0,  0,  0 },                                 /* S I W D C */
    6,                                                      /* Room      */
    50,                                                     /* Max Skill */
    0,                                                      /* Bits      */
    SIZE_AVERAGE,                                           /* Size      */
    125,                                                    /* Base age  */
    17                                                      /* Starting age */
  },                                                        
  { "thilonenne",
    { -1,  1,  0,  1, -1 },
    6,
    50,
    0,
    SIZE_PETITE,
    200,
    17
  },
  { "trioskenne",
    { -2,  1,  1,  1, -1 },
    6,
    60,
    0,
    SIZE_PETITE,
    200,
    20
  },
  { "dakonenne",
    {  1,  1,  1, -1, -2 },
    6,
    55,
    AFF_INFRARED,
    SIZE_PETITE,
    175,
    25,
  },
  { "dwarf",
    {  2, -2, -1, -1,  2 },
    6,
    40,
    AFF_INFRARED,
    SIZE_SMALL,
    125,
    16
  },
  { "giant",
    {  5,  0, -3, -5,  3 },
    6,
    25,
    0,
    SIZE_HUGE,
    100,
    17
  },
  { "drev",
    {  2,  0,  1, -1, -2 },
    6,
    30,
    0,
    SIZE_SMALL,
    100,
    15
  },
  { "heveti",
    {  1, -1,  0, -1,  1 },
    6,
    45,
    0,
    SIZE_LARGE,
    300,
    25
  }
};




const struct   lang_type  lang_table [MAX_LANGUAGE] =
{
    { "zengalli",    &gsn_zengalli     },     /* Common             */
    { "haanstaed",   &gsn_haanstaed    },     /* Dwarven            */
    { "olani",       &gsn_olani        },     /* Thilonenne (south) */
    { "mudaki",      &gsn_mudaki       },     /* Thilonenne (west)  */
    { "zalufini",    &gsn_zalufini     },     /* Trioskenne         */
    { "haesni",      &gsn_haesni       },     /* Drev               */
    { "ghaenish",    &gsn_ghaenish     },     /* Heveti             */
    { "argot",       &gsn_ict          },     /* Rogue's Language   */
    { "imarind",     &gsn_imarind      },     /* Ancient Language   */
    { "dakonenne",   &gsn_dakonenne    },     /* Dakonenne          */
};





/*
 * Color table.
 */
const   struct  color_data color_table [] =
{
   { "\x1b[30m",     "$R$0",   "black"        },
   { "\x1b[34m",     "$R$1",   "blue"         },
   { "\x1b[32m",     "$R$2",   "green"        },
   { "\x1b[36m",     "$R$3",   "cyan"         },
   { "\x1b[31m",     "$R$4",   "red"          },
   { "\x1b[35m",     "$R$5",   "purple"       },
   { "\x1b[33m",     "$R$6",   "brown"        },
   { "\x1b[37m",     "$R$7",   "grey"         },
   { "\x1b[30;1m",   "$B$0",   "dark_grey"    },
   { "\x1b[34;1m",   "$B$1",   "sky-blue"     },
   { "\x1b[32;1m",   "$B$2",   "grass-green"  },
   { "\x1b[36;1m",   "$B$3",   "light-cyan"   },
   { "\x1b[31;1m",   "$B$4",   "bright-red"   },
   { "\x1b[35;1m",   "$B$5",   "magenta"      },
   { "\x1b[33;1m",   "$B$6",   "yellow"       },
   { "\x1b[37;1m",   "$B$7",   "white"        },
   { "\x1b[1m",      "$B",     "bold"         },
   { "\x1b[5m",      "$F",     "flashing"     },
   { "\x1b[7m",      "$I",     "inverse"      },
   { "\x1b[0m",      "$R",     "normal"       },
   { " ",            " ",      " "            }
};


/*
 *  Attack damage type and string.
 */
const   struct  attack_type attack_table [] =         /* CHANGE MAX_ATTACK */
{
    { "hit",      TYPE_HIT,     &gsn_wp_other,   NULL              },  /*  0 */
    { "slice",    TYPE_SLASH,   &gsn_wp_slash,   NULL              },  /*  1 */
    { "stab",     TYPE_PIERCE,  &gsn_wp_pierce,  NULL              },
    { "slash",    TYPE_SLASH,   &gsn_wp_slash,   NULL              },
    { "whip",     TYPE_WHIP,    &gsn_wp_whip,    NULL              },
    { "cleave",   TYPE_SLASH,   &gsn_wp_slash,   NULL              },  /*  5 */
    { "vorpal",   TYPE_SLASH,   &gsn_wp_slash,   hit_vorpal        },
    { "pound",    TYPE_POUND,   &gsn_wp_pound,   NULL              },
    { "pierce",   TYPE_PIERCE,  &gsn_wp_pierce,  NULL              },
    { "lash",     TYPE_WHIP,    &gsn_wp_whip,    NULL              },
    { "claw",     TYPE_SLASH,   &gsn_wp_slash,   NULL              },  /* 10 */
    { "blast",    TYPE_EXPLODE, &gsn_wp_other,   NULL              },
    { "crush",    TYPE_POUND,   &gsn_wp_pound,   NULL              },
    { "gore",     TYPE_PIERCE,  &gsn_wp_pierce,  NULL              },
    { "bite",     TYPE_PIERCE,  &gsn_wp_pierce,  NULL              },
    { "suction",  TYPE_SUCTION, &gsn_wp_other,   hit_suck_disarm   },  /* 15 */
};



/*
 * Attribute bonus tables.
 */
const   struct  str_app_type    str_app     [26]        =
{
 /*  +Hit +Dam Crr Wei */
    { -5, -4,   0,  0 },  /* 0  */
    { -5, -4,   3,  1 },  /* 1  */
    { -3, -2,   3,  2 },
    { -3, -1,  10,  3 },  /* 3  */
    { -2, -1,  25,  4 },
    { -2, -1,  55,  5 },  /* 5  */
    { -1,  0,  80,  6 },
    { -1,  0,  90,  7 },
    {  0,  0, 100,  8 },
    {  0,  0, 100,  9 },
    {  0,  0, 115, 10 }, /* 10  */
    {  0,  0, 115, 11 },
    {  0,  0, 140, 12 },
    {  0,  0, 140, 13 }, /* 13  */
    {  0,  1, 170, 14 },
    {  1,  1, 170, 15 }, /* 15  */
    {  1,  2, 195, 16 },
    {  2,  3, 220, 22 },
    {  2,  4, 250, 25 }, /* 18  */
    {  3,  5, 400, 30 },
    {  3,  6, 500, 35 }, /* 20  */
    {  4,  7, 600, 40 },
    {  5,  7, 700, 45 },
    {  6,  8, 800, 50 },
    {  8, 10, 900, 55 },
    { 10, 12, 999, 60 }  /* 25   */
};



const   struct  int_app_type    int_app     [26]        =
{  /* SLv  DB */
    {  0,  72 },     /*  0 */
    {  0,  60 },     /*  1 */
    {  0,  48 },
    {  0,  36 },     /*  3 */
    {  0,  36 },
    {  1,  24 },     /*  5 */
    {  1,  24 },
    {  2,  12 },
    {  3,  12 },
    {  4,   6 },
    {  5,   0 },     /* 10 */
    {  6,   0 },
    {  7,   0 },
    {  8,   0 },     /* 13 */
    {  9,   0 },
    { 10,   0 },     /* 15 */
    { 11,  -6 },
    { 12,  -6 },
    { 15, -12 },     /* 18 */
    { 17, -12 },
    { 20, -12 },     /* 20 */
    { 23, -12 },
    { 26, -12 },
    { 30, -24 },
    { 35, -48 },
    { 40, -72 }      /* 25 */
};



const   struct  wis_app_type    wis_app     [26]        =
{  /* SLv  DB */
    {  0,  48 },     /*  0 */
    {  0,  36 },     /*  1 */
    {  0,  24 },
    {  0,  12 },     /*  3 */
    {  0,  12 },
    {  1,   6 },     /*  5 */
    {  1,   6 },
    {  2,   6 },
    {  3,   6 },
    {  4,   3 },
    {  5,   0 },     /* 10 */
    {  6,   0 },
    {  7,   0 },
    {  8,   0 },     /* 13 */
    {  9,   0 },
    { 10,   0 },     /* 15 */
    { 11,  -3 },
    { 12,  -3 },
    { 15,  -6 },     /* 18 */
    { 17,  -6 },
    { 20,  -6 },     /* 20 */
    { 23,  -6 },
    { 26,  -6 },
    { 30, -12 },
    { 35, -24 },
    { 40, -36 }      /* 25 */
};



const   struct  dex_app_type    dex_app     [26]        =
{
    {   60 },   /* 0 */
    {   50 },   /* 1 */
    {   50 },
    {   40 },
    {   30 },
    {   20 },   /* 5 */
    {   10 },
    {    0 },
    {    0 },
    {    0 },
    {    0 },   /* 10 */
    {    0 },
    {    0 },
    {    0 },
    {    0 },
    { - 10 },   /* 15 */
    { - 15 },
    { - 20 },
    { - 30 },
    { - 40 },
    { - 50 },   /* 20 */
    { - 60 },
    { - 75 },
    { - 90 },
    { -105 },
    { -120 }    /* 25 */
};



const   struct  con_app_type    con_app     [26]        =
{
    { -80, 20, 20 },   /*  0 */
    { -70, 25, 25 },   /*  1 */
    { -60, 30, 30 },
    { -50, 35, 35 },   /*  3 */
    { -40, 40, 40 },
    { -35, 45, 45 },   /*  5 */
    { -30, 50, 50 },
    { -25, 55, 55 },
    { -20, 60, 60 },
    { -15, 65, 65 },
    { -10, 70, 70 },   /* 10 */
    {  -5, 75, 75 },
    {   0, 80, 80 },
    {   5, 85, 85 },
    {  10, 88, 88 },
    {  15, 90, 90 },   /* 15 */
    {  20, 95, 95 },
    {  25, 97, 97 },
    {  30, 99, 99 },   /* 18 */
    {  35, 99, 99 },
    {  40, 99, 99 },   /* 20 */
    {  50, 99, 99 },
    {  60, 99, 99 },
    {  70, 99, 99 },
    {  80, 99, 99 },
    {  90, 99, 99 }    /* 25 */
};



/*
 * Liquid properties.
 * Used in world.obj.
 */
const	struct	liq_type	liq_table	[LIQ_MAX]	=
{                                                 /* D  F  T */
    { "water",          "clear",                  {  0, 1, 10 } },  /*  0 */
    { "beer",           "amber",                  {  1, 1,  5 } },  /*  1 */
    { "wine",           "rose",                   {  1, 0,  5 } },  /*  2 */
    { "ale",            "brown",                  {  1, 1,  5 } },  /*  3 */
    { "brandy",         "dark",                   {  2, 0,  5 } },  /*  4 */

    { "dark ale",       "black",                  {  2, 0,  4 } },  /*  5 */
    { "port",           "deep red",               {  3, 0,  0 } },  /*  6 */
    { "blueberry wine", "azure",                  {  2, 0,  3 } },  /*  7 */
    { "salt water",     "clear",                  {  0, 1, -2 } },  /*  8 */
    { "bitters",        "dark grey",              { 20, 0,  5 } },  /*  9 */

    { "milk",           "white",                  {  0, 3,  6 } },  /* 10 */

    { "tea",            "tan",                    {  0, 0,  6 } },  /* 11 */

    { "blood",          "red",                    {  0, 2, -1 } },  /* 12 */
    { "blessed water",  "crystal clear",          {-10,10, 10 } },  /* 13 */

    { "lemonade",       "translucent yellow",     {  0, 0,  8 } },  /* 14 */
    { "broth",          "oily, tan",              {  0, 6,  2 } },  /* 15 */

    { "mead",           "thick, dark",            {  3, 2,  1 } },  /* 16 */
    { "lamp oil",       "waxy, yellow",           {  0, 0,  0 } },  /* 17 */

    { "ginseng tea",    "pale tan",               {  0, 0,  6 } },  /* 18 */
    { "orange tea",     "dark orange",            {  0, 0,  6 } },  /* 19 */
    { "cinnamon tea",   "speckled tan",           {  0, 0,  6 } },  /* 20 */
    { "spiced tea",     "reddish tan",            {  0, 0,  6 } },  /* 21 */
    { "salt tea",       "bubbling tan",           {  4, 0,  6 } },  /* 22 */
    { "kio sap tea",    "greenish tan",           {  4, 0,  6 } },  /* 23 */

    { "apple cider",    "aromatic brown",         {  2, 0,  8 } },  /* 24 */
    { "cherry cider",   "rich red",               {  1, 0,  8 } },  /* 25 */
    { "hard cider",     "bitter, brown",          {  5, 0,  8 } },  /* 26 */

    { "mullinspice cider", "speckled brown",      {  0, 0,  2 } },  /* 27 */
    { "mullinspice tea",   "speckled yellow-tan", {  0, 0,  6 } },  /* 28 */
    { "mullinspice brandy", "dark, speckled",     {  2, 0,  6 } },  /* 29 */

    { "peach wine",     "clear, orange",          {  2, 0,  3 } },  /* 30 */
    { "dandilion wine", "clear, yellow",          {  1, 0,  4 } },  /* 31 */
    { "apricot wine",   "clear, orange-red",      {  3, 0,  5 } },  /* 32 */

    { "mud",            "thick, gritty, brown",   {  0, 1,-10 } },  /* 33 */
};


/*
 * Spell components.
 */
const struct   comp_type   comp_table  [] =
{
    /* Metals */
    {  "brass cylinder",   "a",                           C_SOLID,      50 },
    {  "bronze disk",      "a",                           C_SOLID,      50 },
    {  "copper square",    "a",                           C_SOLID,       2 },
    {  "copper wire",      "a",                           C_WIRE,       10 },
    {  "gold bell",        "a",                           C_SOLID,     500 },
    {  "gold caltrops",    "a pair of",                   C_SOLID,     300 },
    {  "gold chunk",       "a",                           C_SOLID,     500 },
    {  "gold dust",        "a small bit of",              C_POWDER,     20 },
    {  "gold needles",     "a set of",                    C_SOLID,    1500 },
    {  "gold powder",      "a pinch of",                  C_POWDER,    100 },
    {  "gold tissue",      "a",                           C_MEMBRANE, 1000 },
    {  "gold wire",        "a length of",                 C_WIRE,      300 },
    {  "iron chunk",       "an",                          C_SOLID,       5 },
    {  "iron filings",     "an amount of",                C_POWDER,      2 },
    {  "iron powder",      "a dash of",                   C_POWDER,     20 },
    {  "iron rod",         "an",                          C_ROD,        30 },
    {  "lead ball",        "a",                           C_SOLID,       6 },
    {  "lead chunk",       "a",                           C_SOLID,       8 },
    {  "mercury",          "an ounce of",                 C_LIQUID,     10 },
    {  "chipped mica",     "a few bits of",               C_POWDER,     10 },
    {  "ground mica",      "a dusting of",                C_POWDER,      8 },
    {  "platinum chunk",   "a",                           C_SOLID,    1500 },
    {  "platinum coin",    "a defaced",                   C_SOLID,     500 },
    {  "platinum die",     "a six-sided",                 C_SOLID,    3500 },
    {  "platinum mirror",  "a shiny",                     C_SOLID,    4000 },
    {  "platinum tissue",  "a",                           C_MEMBRANE, 1000 },
    {  "platinum wire",    "a length of",                 C_WIRE,      800 },
    {  "silver pin",       "a",                           C_ROD,        50 },
    {  "silver powder",    "a bit of",                    C_POWDER,     10 },
    {  "silver wire",      "a length of",                 C_WIRE,       40 },
    {  "tin square",       "a",                           C_SOLID,       5 },
    {  "zinc square",      "a",                           C_SOLID,      10 },

    /* Liquids */
    {  "acid",             "a vial of",                   C_LIQUID,    100 },
    {  "alcohol",          "a bottle of pure",            C_LIQUID,     10 },
    {  "attar of roses",   "a capful of",                 C_LIQUID,  20000 },
    {  "hickory oil",      "a spoonful of",               C_LIQUID,    100 },
    {  "ink",              "a squirt of",                 C_LIQUID,     50 },
    {  "molasses",         "a thick glob of",             C_GELATIN,    10 },
    {  "flammable oil",    "a flask of",                  C_LIQUID,     60 },
    {  "nonflammable oil", "a flask of",                  C_LIQUID,     60 },
    {  "spiced oil",       "a dash of",                   C_LIQUID,    100 },
    {  "sweet oil",        "a tasting of",                C_LIQUID,    100 },
    {  "rainwater",        "a half-cask of",              C_LIQUID,      3 },
    {  "vinegar",          "a bottle of",                 C_LIQUID,     50 },
    {  "distilled water",  "a hand keg of",               C_LIQUID,     10 },

    /* Minerals */
    {  "agate",            "an uncut",                    C_GEM,       100 },
    {  "alkaline salt",    "a pinch of",                  C_POWDER,     10 },
    {  "alum",             "a bit of",                    C_POWDER,      5 },
    {  "amber block",      "an",                          C_SOLID,      80 },
    {  "amber powder",     "a dash of",                   C_POWDER,    100 },
    {  "amber rod",        "an",                          C_ROD,      1000 },
    {  "bitumen",          "a handful of dry",            C_POWDER,    100 },
    {  "blue vitriol",     "a capful of",                 C_LIQUID,     20 },
    {  "borax paste",      "a dab of",                    C_LIQUID,     10 },
    {  "borax stone",      "a",                           C_SOLID,      10 },
    {  "bromine salt",     "a pinch of",                  C_POWDER,    100 },
    {  "amorphous carbon", "a glob of",                   C_GELATIN,   100 },
    {  "graphite",         "a soft piece of",             C_POWDER,    300 },
    {  "chalk",            "some bits of",                C_POWDER,      1 },
    {  "charcoal",         "the soot from",               C_POWDER,    100 },
    {  "fired clay sphere","a",                           C_SOLID,       1 },
    {  "raw clay",         "a slice of",                  C_SOLID,      10 },
    {  "coal chunk",       "a",                           C_SOLID,     100 },
    {  "coal dust",        "a handful of",                C_POWDER,     80 },
    {  "crystal bead",     "a",                           C_SOLID,     700 },
    {  "crystal rod",      "a",                           C_ROD,      1500 },
    {  "crystal square",   "a",                           C_SOLID,     300 },
    {  "crystal sphere",   "a",                           C_SOLID,    2000 },
    {  "diamond",          "an uncut",                    C_GEM,     15000 },
    {  "emerald",          "an uncut",                    C_GEM,     14000 },
    {  "feldspar chunk",   "a",                           C_SOLID,     100 },
    {  "flint",            "a chip of",                   C_SOLID,      10 },
    {  "glass bead",       "a",                           C_SOLID,       2 },
    {  "glass cone",       "a",                           C_SOLID,     500 },
    {  "glass rod",        "a",                           C_ROD,       500 },
    {  "glass sheet",      "a",                           C_SOLID,     200 },
    {  "glass sphere",     "a",                           C_SOLID,     500 },
    {  "granite block",    "a",                           C_SOLID,     200 },
    {  "granite dust",     "a stone's worth of",          C_POWDER,    100 },
    {  "gypsum",           "a",                           C_SOLID,      10 },
    {  "iron pyrite",      "a",                           C_SOLID,     100 },
    {  "lime powder",      "a bit of",                    C_POWDER,     20 },
    {  "litharge",         "a",                           C_SOLID,      30 },
    {  "black marble chunk",     "a",                     C_SOLID,      50 },
    {  "purbeck marble chunk",   "a",                     C_SOLID,      80 },
    {  "mineral sphere",   "a",                           C_SOLID,    1000 },
    {  "mineral prism",    "a",                           C_SOLID,     700 },
    {  "powdered mortar",  "a handful of",                C_SOLID,      50 },
    {  "obsidian chunk",   "a",                           C_SOLID,      30 },
    {  "obsidian cylinder",  "a",                         C_SOLID,      50 },
    {  "obsidian sphere",  "a",                           C_SOLID,      50 },
    {  "phosphorous",      "some",                        C_SOLID,    1000 },
    {  "pitch",            "some",                        C_POWDER,      5 },
    {  "clear quartz",     "a ",                          C_SOLID,      10 },
    {  "realgar",          "a chunk of",                  C_SOLID,      10 },
    {  "rough quartz",     "a",                           C_SOLID,       5 },
    {  "quartz powder",    "carefully refined",           C_POWDER,      3 },
    {  "ruby",             "an uncut",                    C_GEM,     15000 },
    {  "salt block",       "a",                           C_SOLID,      10 },
    {  "granular salt",    "some",                        C_POWDER,     50 },
    {  "sapphire",         "an uncut",                    C_GEM,     14000 },
    {  "fine sand",        "a handful of",                C_POWDER,     10 },
    {  "soot",             "a pouch of woodstoked",       C_POWDER,      2 },
    {  "stalactite shard", "a",                           C_SOLID,       4 },
    {  "tiny stalactite",  "a",                           C_SOLID,      10 },
    {  "sulfur",           "a",                           C_SOLID,     100 },
    {  "talc",             "a",                           C_SOLID,      70 },
    {  "polished turquoise", "a",                         C_SOLID,     500 },
    {  "raw turquoise",    "a",                           C_SOLID,      10 },
    {  "volcanic ash",     "a small pouchful of",         C_POWDER,      5 },

    /* Animal products */
    {  "bat fur",          "a bit of",                    C_SOLID,    3000 },
    {  "bat guano",        "a",                           C_SOLID,     200 },
    {  "beeswax",          "a tin of",                    C_GELATIN,    10 },
    {  "bee wing",         "a",                           C_SOLID,       3 },
    {  "bladder",          "a",                           C_SOLID,       5 },
    {  "powdered bone",    "a pouch of",                  C_POWDER,     10 },
    {  "bone chunks",      "a",                           C_SOLID,     150 },
    {  "blood",            "a jar of bovine",             C_LIQUID,     10 },
    {  "butterfly cocoon", "a",                           C_SOLID,      50 },
    {  "moth cocoon",      "a",                           C_SOLID,       3 },
    {  "wasp cocoon",      "a",                           C_SOLID,       4 },
    {  "coral chunk",      "a",                           C_SOLID,      10 },
    {  "eelskin",          "a large piece of",            C_MEMBRANE,   20 },
    {  "crushed eggshell", "a",                           C_POWDER,      3 },
    {  "eggshell shard",   "a",                           C_SOLID,       3 },
    {  "whole empty eggshell",  "a",                      C_SOLID,       3 },
    {  "fat",              "a glob of",                   C_LIQUID,     40 },
    {  "chicken tail feather",  "a",                      C_SOLID,       5 },
    {  "eagle feather",    "a",                           C_SOLID,    1000 },
    {  "hawk feather",     "a",                           C_SOLID,     500 },
    {  "owl feather",      "a",                           C_SOLID,    1000 },
    {  "raven feather",    "a",                           C_SOLID,     500 },
    {  "white feather",    "a",                           C_SOLID,      10 },
    {  "wing feather",     "a",                           C_SOLID,      50 },
    {  "vulture tail",     "a",                           C_SOLID,     100 },
    {  "dead firefly",     "a",                           C_SOLID,      10 },
    {  "fleece",           "some",                        C_MEMBRANE,    5 },
    {  "fish scale",       "a",                           C_SOLID,      20 },
    {  "frog leg",         "a",                           C_SOLID,       4 },
    {  "glowworm tail",    "a",                           C_SOLID,      10 },
    {  "dead glowworm",    "a",                           C_SOLID,      10 },
    {  "ape hair",         "a",                           C_SOLID,     300 },
    {  "bear hair",        "a",                           C_SOLID,     100 },
    {  "camel hair",       "a",                           C_SOLID,     500 },
    {  "draft horse hair", "a",                           C_SOLID,     300 },
    {  "child hair",       "a",                           C_SOLID,       5 },
    {  "ox hair",          "a",                           C_SOLID,      10 },
    {  "war horse hair",   "a",                           C_SOLID,     100 },
    {  "honeycomb",        "a",                           C_SOLID,     100 },
    {  "centipede leg",    "a",                           C_SOLID,       5 },
    {  "grasshopper hind leg",  "a",                      C_SOLID,      10 },
    {  "millipede leg",    "a",                           C_SOLID,       5 },
    {  "spider leg",       "a",                           C_SOLID,       2 },
    {  "leather strip",    "a",                           C_WIRE,        7 },
    {  "leather thong",    "a",                           C_SOLID,       5 },
    {  "lime",             "a whole",                     C_SOLID,      10 },
    {  "lye",              "some",                        C_POWDER,     10 },
    {  "milk fat",         "the curds of",                C_POWDER,     10 },
    {  "mouse whiskers",   "a",                           C_SOLID,       3 },
    {  "musk",             "a vial of",                   C_LIQUID,     40 },
    {  "powdered ox hoof", "a",                           C_POWDER,     50 },
    {  "pork rind",        "a",                           C_SOLID,       3 },
    {  "python bile",      "a drop of",                   C_LIQUID,    300 },
    {  "rat tail",         "a",                           C_SOLID,       7 },
    {  "rat whisker",      "a",                           C_SOLID,       5 },
    {  "seashell shard",   "a",                           C_SOLID,       5 },
    {  "seashell",         "a",                           C_SOLID,      20 },
    {  "skunk hair",       "a",                           C_SOLID,       5 },
    {  "snake skin",       "a",                           C_MEMBRANE,    4 },
    {  "silkworm egg",     "a",                           C_SOLID,     500 },
    {  "snake scale",      "a",                           C_SOLID,      20 },
    {  "sponge",           "a",                           C_SOLID,      10 },
    {  "tallow",           "a block of",                  C_SOLID,      30 },
    {  "tortoise shell",   "a",                           C_SOLID,      70 },
    {  "vellum",           "a large sheet of",            C_MEMBRANE,  500 },
    {  "white wax",        "some hot",                    C_LIQUID,     20 },
    {  "wool strand",      "a",                           C_WIRE,       50 },

    /* Plant Products */
    {  "acorn",            "a",                           C_SOLID,       3 },
    {  "dried amaryllis blossom",  "a",                   C_SOLID,      10 },
    {  "amaryllis bulb",   "a",                           C_SOLID,       5 },
    {  "amaryllis hypoxis bulb", "a",                     C_SOLID,      30 },
    {  "dried amaryllis stalk",  "a",                     C_SOLID,      30 },
    {  "apple blossom petal",    "a",                     C_SOLID,       3 },
    {  "arsenic",          "some",                        C_POWDER,      1 },
    {  "asafoetida",       "a packet of",                 C_POWDER,     50 },
    {  "aster seed",       "an",                          C_SOLID,       5 },
    {  "apple bark",       "some",                        C_SOLID,       6 },
    {  "ash bark",         "some",                        C_SOLID,       7 },
    {  "beech bark",       "some",                        C_SOLID,       6 },
    {  "cherry bark",      "some",                        C_SOLID,       7 },
    {  "elm bark",         "some",                        C_SOLID,       4 },
    {  "maple bark",       "some",                        C_SOLID,       3 },
    {  "oak bark",         "some",                        C_SOLID,       4 },
    {  "pine bark",        "some",                        C_SOLID,       3 },
    {  "spruce bark",      "some",                        C_SOLID,       5 },
    {  "sumac bark",       "some",                        C_SOLID,       3 },
    {  "walnut bark",      "some",                        C_SOLID,       8 },
    {  "burr",             "a",                           C_SOLID,       2 },
    {  "camphor resin",    "a packet of",                 C_POWDER,     10 },
    {  "dried carrot",     "a",                           C_SOLID,       2 },
    {  "cassia bark",      "some",                        C_SOLID,      60 },
    {  "cassia bud",       "a",                           C_SOLID,      20 },
    {  "castor beans",     "some",                        C_SOLID,       8 },
    {  "citric acid",      "a vial of",                   C_LIQUID,      8 },
    {  "cork",             "a",                           C_SOLID,      10 },
    {  "powdered corn extract",  "a tin of",              C_POWDER,     20 },
    {  "cotton mesh",      "a",                           C_MEMBRANE,   40 },
    {  "white felt",       "some",                        C_MEMBRANE,   10 },
    {  "fern frond",       "a",                           C_SOLID,       2 }, 
    {  "flower",           "a",                           C_SOLID,      10 },
    {  "foxfire fungus",   "a",                           C_SOLID,      20 },
    {  "galbanum",         "a packet of",                 C_POWDER,     50 },
    {  "garlic bud",       "a",                           C_SOLID,       5 },
    {  "garlic clove",     "a",                           C_SOLID,       3 },
    {  "ginger",           "a hand of",                   C_SOLID,      10 },
    {  "ginseng",          "some",                        C_POWDER,     30 },
    {  "holly berries",    "some",                        C_SOLID,      10 },
    {  "holly sprig",      "a",                           C_SOLID,       3 },
    {  "stick of incense", "a",                           C_SOLID,      50 },
    {  "ash leaf",         "an",                          C_SOLID,       3 },
    {  "oak leaf",         "a",                           C_SOLID,       2 },
    {  "poison ivy leaf",  "a",                           C_SOLID,       2 },
    {  "poison oak leaf",  "a",                           C_SOLID,       3 },
    {  "poison sumac leaf",  "a",                         C_SOLID,       3 },
    {  "raspberry leaf",   "a",                           C_SOLID,       7 },
    {  "rose leaf",        "a",                           C_SOLID,       3 },
    {  "rhubarb leaf",     "a",                           C_SOLID,       3 },
    {  "shamrock leaf",    "a",                           C_SOLID,       2 },
    {  "skunk cabbage leaf",  "a",                        C_SOLID,       4 },
    {  "stinging nettle leaf",  "a",                      C_SOLID,       3 },
    {  "sumac leaf",       "a",                           C_SOLID,       3 },
    {  "yew leaf",         "a",                           C_SOLID,       4 },
    {  "ground leek",      "a",                           C_POWDER,      7 },
    {  "legume seeds",     "a bunch of",                  C_POWDER,      2 },
    {  "gold-wefted linen cloth",   "a",                  C_MEMBRANE, 1000 },
    {  "lotus flower",     "a",                           C_SOLID,       4 },
    {  "lotus root",       "a",                           C_SOLID,      30 },
    {  "dry crushed marigold",  "a",                      C_POWDER,      7 },
    {  "moonseed",         "a",                           C_SOLID,     100 },
    {  "green moss",       "a dusk of",                   C_SOLID,       2 },
    {  "phosphorescent moss",  "a dusk of",               C_SOLID,       5 },
    {  "mushroom spores",  "a pouch of",                  C_POWDER,    100 },
    {  "mushroom",         "a",                           C_SOLID,       5 },
    {  "nut shell",        "a",                           C_SOLID,       2 },
    {  "pine bark",        "some",                        C_SOLID,       3 },
    {  "pine cone",        "a",                           C_SOLID,       3 },
    {  "pine needles",     "a few",                       C_POWDER,      4 },
    {  "pine sprig",       "a",                           C_SOLID,       2 },
    {  "pine tar",         "a glob of",                   C_GELATIN,    10 },
    {  "peach pit",        "a",                           C_SOLID,       1 },
    {  "reed stalk",       "a",                           C_SOLID,       5 },
    {  "resin",            "a packet of",                 C_POWDER,      4 },
    {  "rose petal",       "a",                           C_SOLID,       5 },
    {  "rose thorn",       "a",                           C_SOLID,       5 },
    {  "rhubarb root",     "a",                           C_SOLID,       8 },
    {  "dry seaweed",      "a",                           C_SOLID,      20 },
    {  "shallot bulb",     "a",                           C_SOLID,       5 },
    {  "soda ash",         "some",                        C_POWDER,     30 },
    {  "stargrass",        "a dusk of",                   C_SOLID,       5 },
    {  "tacamahac",        "a vial of",                   C_POWDER,     10 },
    {  "thistledown",      "a tuff of",                   C_SOLID,       1 },
    {  "thorns",           "a few",                       C_POWDER,      2 },
    {  "tree sap",         "a blob of",                   C_GELATIN,   100 },
    {  "vermilion",        "a",                           C_SOLID,      10 },
    {  "willow bark",      "some",                        C_SOLID,       3 },
    {  "wolfsbane",        "a sprig of",                  C_SOLID,      30 },
    {  "wynchwood",        "a piece of",                  C_SOLID,      10 },
    {  "yam",              "a",                           C_SOLID,       8 },
    {  "zedoary",          "some",                        C_POWDER,     30 },
    
    /* Aromatics and Spices */
    {  "aloeswood chips",  "some",                        C_POWDER,    100 },
    {  "ambergris",        "some",                        C_POWDER,    100 },
    {  "benzoin",          "some",                        C_POWDER,    100 },
    {  "betony",           "some",                        C_POWDER,    300 },
    {  "calmus",           "some",                        C_POWDER,    100 },
    {  "civet",            "some",                        C_POWDER,   1000 },
    {  "emeli",            "some",                        C_POWDER,    200 },
    {  "frankincense",     "some",                        C_POWDER,   1000 },
    {  "myrrh",            "some",                        C_LIQUID,   1000 },
    {  "onycha",           "some",                        C_LIQUID,    300 },
    {  "dried orchid",     "some",                        C_POWDER,    300 },
    {  "patchouli",        "some",                        C_POWDER,     10 },
    {  "putchuk",          "some",                        C_POWDER,    100 },
    {  "rosewater",        "a petal-vial of",             C_LIQUID,    100 },
    {  "red sandalwood oil",   "a vial of",               C_LIQUID,    500 },
    {  "white sandalwood oil", "a vial of",               C_LIQUID,    300 },
    {  "storax",           "a vial of",                   C_LIQUID,    100 },

    {  "",                 "",                            -1,           -1 }
};

/*
 * The skill and spell table.
 * Slot numbers must never be changed as they appear in #OBJECTS sections.
 * In the damage messages:  %s = singular message      $t = plural
 */
#define null                NULL
#define LFUN(n)             n
#define SFUN(n)             n

#define GROUP(a,b)          a, b

#define STATS(a,b,c,d,e)    a, b, c, d, e

#define SLOT(n)             n
#define WAIT(n)             n
#define MANA(n)             n

#define PRAC(a,b)           a, b

#define TIME(n)             n*5
#define COST(n)             n
#define NO_COMPONENTS       0

const   struct  skill_type  skill_table [MAX_SKILL] =
{
    {
    "reserved",                             MAX_LEVEL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    NULL,                                   MANA_NONE,
    NO_COMPONENTS,
    "!Reserved!",
    GROUP(GRO_NONE, 0),                     STATS(26, 26, 26, 26, 26),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  0,  0),
    TIME(  0),                              COST(  0),
    },
    
/*
 * Spells.
 */

/*
 * Skills.
 */

                            /* Language */
    {
    "zengalli",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_zengalli,                          MANA_NONE,
    NO_COMPONENTS,
    "!Language: Zengalli!",
    GROUP(GRO_LANGUAGE, 0),                 STATS( 0, 9, 0, 0, 0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 100),
    TIME(  6),                              COST(100),
    },

    {
    "haanstaed",                            LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_haanstaed,                         MANA_NONE,
    NO_COMPONENTS,
    "!Language: Haanstaed!",
    GROUP(GRO_LANGUAGE, 0),                 STATS( 0, 9, 0, 0, 0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 100),
    TIME(  6),                              COST(100),
    },

    {
    "olani",                                LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_olani,                             MANA_NONE,
    NO_COMPONENTS,
    "!Language: Olani!",
    GROUP(GRO_LANGUAGE, 0),                 STATS( 0, 9, 0, 0, 0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 100),
    TIME(  6),                              COST(500),
    },

    {
    "mudaki",                               LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_mudaki,                            MANA_NONE,
    NO_COMPONENTS,
    "!Language: Mudaki!",
    GROUP(GRO_LANGUAGE, 0),                 STATS( 0, 9, 0, 0, 0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 100),
    TIME(  6),                              COST(800),
    },

    {
    "zalufini",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_zalufini,                          MANA_NONE,
    NO_COMPONENTS,
    "!Language: Zalufini!",
    GROUP(GRO_LANGUAGE, 0),                 STATS( 0, 9, 0, 0, 0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 100),
    TIME(  6),                              COST(1000),
    },

    {
    "haesni",                               LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_haesni,                            MANA_NONE,
    NO_COMPONENTS,
    "!Language: Haesni!",
    GROUP(GRO_LANGUAGE, 0),                 STATS( 0, 9, 0, 0, 0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 100),
    TIME(  6),                              COST(1000),
    },

    {
    "ghaenish",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_ghaenish,                          MANA_NONE,
    NO_COMPONENTS,
    "!Language: Ghaenish!",
    GROUP(GRO_LANGUAGE, 0),                 STATS( 0, 9, 0, 0, 0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 100),
    TIME(  8),                              COST(5000),
    },

    {
    "argot",                                LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_ict,                               MANA_NONE,
    NO_COMPONENTS,
    "!Language: Ict!",
    GROUP(GRO_LANGUAGE, 0),                 STATS( 0, 9, 0, 0, 0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 80),
    TIME(  6),                              COST(2000),
    },

    {
    "imarind",                              LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_imarind,                           MANA_NONE,
    NO_COMPONENTS,
    "!Language: Imarind!",
    GROUP(GRO_LANGUAGE, 0),                 STATS( 0, 9, 0, 0, 0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 100),
    TIME( 24),                              COST(10000),
    },



                            /* Offense */
    {
    "dual wield",                           LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_dual_wield,                        MANA_NONE,
    NO_COMPONENTS,
    "!Offense: Dual Wield!",
    GROUP(GRO_OFFENSE, 50),                 STATS( 9,  0,  0,  13,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(500),
    },

    {
    "second attack",                        LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_second_attack,                     MANA_NONE,
    NO_COMPONENTS,
    "!Offense: Second Attack!",
    GROUP(GRO_OFFENSE, 10),                 STATS( 9,  0,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(200),
    },

    {
    "third attack",                         LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_third_attack,                      MANA_NONE,
    NO_COMPONENTS,                          "!Offense: Third Attack!",
    GROUP(GRO_OFFENSE, 30),                 STATS( 9,  0,  0,  11,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(350),
    },

    {
    "hand to hand",                         LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_hth,                               MANA_NONE,
    NO_COMPONENTS,
    "!Offense: Hand-To-Hand!",
    GROUP(GRO_OFFENSE, 30),                 STATS( 9,  0,  0,  11,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(2000),
    },

    {
    "enhanced damage",                      LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_enhanced_damage,                   MANA_NONE,
    NO_COMPONENTS,
    "!Offense: Enhanced Damage!",
    GROUP(GRO_OFFENSE, 1),                  STATS( 11,  0,  0,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(500),
    },

                            /* Defense */
    {
    "fleeing",                              LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_flee,                              MANA_NONE,
    NO_COMPONENTS,
    "!Defense: Flee!",
    GROUP(GRO_DEFENSE, 1),                  STATS( 0,  0,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 50),
    TIME( 24),                              COST(50),
    },

    {
    "rescuing",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_rescue,                            MANA_NONE,
    NO_COMPONENTS,
    "!Defense: Rescue!",
    GROUP(GRO_DEFENSE, 30),                 STATS( 9,  0,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 75),
    TIME( 24),                              COST(100),
    },

    {
    "parry",                                LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_parry,                             MANA_NONE,
    NO_COMPONENTS,
    "!Defense: Parry!",
    GROUP(GRO_DEFENSE, 15),                 STATS( 11,  0,  0,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 35),
    TIME( 24),                              COST(600),
    },

    {
    "dodge",                                LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_dodge,                             MANA_NONE,
    NO_COMPONENTS,
    "!Defense: Dodge!",
    GROUP(GRO_DEFENSE, 15),                 STATS( 0,  0,  0, 11,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 35),
    TIME( 24),                              COST(600),
    },

    {
    "disarm",                               LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_disarm,                            MANA_NONE,
    NO_COMPONENTS,
    "!Defense: Disarm!",
    GROUP(GRO_DEFENSE, 50),                 STATS(11,  0,  0, 11,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 50),
    TIME( 24),                              COST(400),
    },

    {
    "subduction",                           LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_subdue,                            MANA_NONE,
    NO_COMPONENTS,
    "!Defense: Subduction!",
    GROUP(GRO_DEFENSE, 70),                 STATS(13,  0,  0, 13,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 50),
    TIME( 24),                              COST(800),
    },
                          /* Wilderness Survival */

    {
    "tracking",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_track,                             MANA_NONE,
    NO_COMPONENTS,
    "!Wilderness Survival: Tracking!",
    GROUP(GRO_SURVIVAL, 50),                STATS( 0,  0,  9,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(2000),
    },

    {
    "swimming",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_swimming,                          MANA_NONE,
    NO_COMPONENTS,
    "!Wilderness Survival: Swimming!",
    GROUP(GRO_SURVIVAL, 10),                STATS( 9,  0,  0,  9, 11),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(1000),
    },

    {
    "climbing",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_climb,                             MANA_NONE,
    NO_COMPONENTS,
    "!Wilderness Survival: Climbing!",
    GROUP(GRO_SURVIVAL, 30),                STATS(11,  0,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(1000),
    },

    {
    "riding",                               LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_riding,                            MANA_NONE,
    NO_COMPONENTS,
    "!Wilderness Survival: Riding!",
    GROUP(GRO_SURVIVAL, 1),                 STATS( 0,  0,  0,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(5000),
    },

    {
    "camoflage",                            LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_hide,                              MANA_NONE,
    NO_COMPONENTS,
    "!Wilderness Survival: Camoflage!",
    GROUP(GRO_SURVIVAL, 75),                STATS( 0,  0,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(1000),
    },

    {
    "stealth",                              LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_sneak,                             MANA_NONE,
    NO_COMPONENTS,
    "!Wilderness Survival: Stealth!",
    GROUP(GRO_SURVIVAL, 50),                STATS( 0,  0,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(1000),
    },

                           /* Legerdemain */

    {
    "backstab",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_sneak,                             MANA_NONE,
    NO_COMPONENTS,
    "!Legerdemain: Backstab!",
    GROUP(GRO_LEGERDEMAIN, 75),             STATS( 9,  0,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 50),
    TIME( 24),                              COST(2000),
    },

    {
    "peek",                                 LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_sneak,                             MANA_NONE,
    NO_COMPONENTS,
    "!Legerdemain: Peek!",
    GROUP(GRO_LEGERDEMAIN, 1),              STATS( 0,  0,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 75),
    TIME( 24),                              COST(200),
    },

    {
    "lock picking",                         LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_pick_lock,                         MANA_NONE,
    NO_COMPONENTS,
    "!Legerdemain: Lock Picking!",
    GROUP(GRO_LEGERDEMAIN, 50),             STATS( 0,  9,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(5000),
    },

    {
    "stealing",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_steal,                             MANA_NONE,
    NO_COMPONENTS,
    "!Legerdemain: Stealing!",
    GROUP(GRO_LEGERDEMAIN, 80),             STATS( 0,  0,  0, 11,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 85),
    TIME( 24),                              COST(8000),
    },

    {
    "haggling",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_haggling,                          MANA_NONE,
    NO_COMPONENTS,
    "!Legerdemain: Haggling!",
    GROUP(GRO_LEGERDEMAIN, 1),              STATS( 0,  9,  9,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 80),
    TIME( 24),                              COST(1000),
    },

/*
 * Proficiencies.
 */
    {
    "edged",                                LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_wp_slash,                          MANA_NONE,
    NO_COMPONENTS,
    "!Weapon Proficiency: Edged!",
    GROUP(GRO_WP, 1),                       STATS( 9,  0,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(200),
    },

    {
    "piercing",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_wp_pierce,                         MANA_NONE,
    NO_COMPONENTS,
    "!Weapon Proficiency: Piercing!",
    GROUP(GRO_WP, 1),                       STATS( 9,  0,  0,  6,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(200),
    },

    {
    "whips",                                LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_wp_whip,                           MANA_NONE,
    NO_COMPONENTS,
    "!Weapon Proficiency: Whips!",
    GROUP(GRO_WP, 1),                       STATS( 9,  0,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(300),
    },

    {
    "bludgeons",                            LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_wp_pound,                          MANA_NONE,
    NO_COMPONENTS,
    "!Weapon Proficiency: Bludgeons!",
    GROUP(GRO_WP, 1),                       STATS( 9,  0,  0,  6,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(100),
    },

    {
    "ranged",                               LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_wp_ranged,                         MANA_NONE,
    NO_COMPONENTS,
    "!Weapon Proficiency: Ranged!",
    GROUP(GRO_WP, 1),                       STATS( 9,  0,  0,  13,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(1000),
    },

    {
    "other",                                LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_wp_other,                          MANA_NONE,
    NO_COMPONENTS,
    "!Weapon Proficiency: Other!",
    GROUP(GRO_WP, 1),                       STATS( 9,  0,  0,  9,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  2, 75),
    TIME( 24),                              COST(800),
    },


/*
 * Groups.
 */
    {
    "language",                             LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_language,                          MANA_NONE,
    NO_COMPONENTS,
    "!Group: Language!",
    GROUP(GRO_NONE, 0),                     STATS( 0, 0, 0,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC( 1, 1),
    TIME( 96),                              COST(10000),
    },

    {
    "legerdemain",                          LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_legerdemain,                       MANA_NONE,
    NO_COMPONENTS,
    "!Group: Legerdemain!",
    GROUP(GRO_NONE, 0),                     STATS( 0,  9,  0, 11,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC( 5, 100),
    TIME( 24),                              COST(5000),
    },

    {
    "offense",                              LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_offense,                           MANA_NONE,
    NO_COMPONENTS,
    "!Group: Offense!",
    GROUP(GRO_NONE, 0),                     STATS(10,  0,  0,  6,  8),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC( 5, 100),
    TIME( 24),                              COST(1000),
    },

    {
    "defense",                              LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_defense,                           MANA_NONE,
    NO_COMPONENTS,
    "!Group: Defense!",
    GROUP(GRO_NONE, 0),                     STATS( 6,  0,  0,  9,  6),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 100),
    TIME( 24),                              COST(1000),
    },

    {
    "wilderness survival",                  LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_survival,                          MANA_NONE,
    NO_COMPONENTS,
    "!Group: Wilderness Survival!",
    GROUP(GRO_NONE, 0),                     STATS( 9,  0,  0,  9,  6),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC( 10, 100),
    TIME(  8),                              COST(5000),
    },

    {
    "weapon proficiencies",                 LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_wp,                                MANA_NONE,
    NO_COMPONENTS,
    "!Group: Weapon Proficiencies!",
    GROUP(GRO_NONE, 0),                     STATS( 6,  0,  0,  6,  6),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  1, 1),
    TIME(  0),                              COST(20000),
    },

/*
 * Elemental casting.
 */

    {
    "firecasting",                          LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_fire,                              MANA_NONE,
    NO_COMPONENTS,
    "!Group: Basic Firecasting!",
    GROUP(GRO_NONE, 0),                     STATS( 0, 10, 10,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  4, 100),
    TIME( 24),                              COST(8000),
    },

    {
    "watercasting",                         LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_water,                             MANA_NONE,
    NO_COMPONENTS,
    "!Group: Basic Watercasting!",
    GROUP(GRO_NONE, 0),                     STATS( 0, 10, 10,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  4, 100),
    TIME( 24),                              COST(8000),
    },

    {
    "earthcasting",                         LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_earth,                             MANA_NONE,
    NO_COMPONENTS,
    "!Group: Expert Earthcasting!",
    GROUP(GRO_NONE, 0),                     STATS( 0, 12, 12,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  4, 100),
    TIME( 24),                              COST(8000),
    },

    {
    "aircasting",                           LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_air,                               MANA_NONE,
    NO_COMPONENTS,
    "!Group: Basic Aircasting!",
    GROUP(GRO_NONE, 0),                     STATS( 0, 10, 10,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  4, 100),
    TIME( 24),                              COST(8000),
    },

/*
 * True Magick.
 */

    {
    "spellcasting",                         LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_spc_gen,                           MANA_NONE,
    NO_COMPONENTS,
    "!Group: General Spellcasting!",
    GROUP(GRO_NONE, 0),                     STATS( 0, 10, 10,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 100),
    TIME( 24),                              COST(30000),
    },

    {
    "necromantics",                         LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_spc_necro,                         MANA_NONE,
    NO_COMPONENTS,
    "!Group: Necromantics!",
    GROUP(GRO_SPC_GENERAL, 100),             STATS( 0, 15, 15,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 100),
    TIME( 24),                              COST(20000),
    },

    {
    "conjurations",                         LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_spc_conj,                          MANA_NONE,
    NO_COMPONENTS,
    "!Group: Conjurations!",
    GROUP(GRO_SPC_GENERAL, 20),             STATS( 0, 13, 13,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 100),
    TIME( 24),                              COST(8000),
    },
    
    {
    "maladictions",                         LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_spc_malad,                         MANA_NONE,
    NO_COMPONENTS,
    "!Group: Maladictions!",
    GROUP(GRO_SPC_GENERAL, 1),              STATS( 0, 10, 10,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 100),
    TIME( 24),                              COST(4000),
    },

    {
    "illusions",                            LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_spc_illus,                         MANA_NONE,
    NO_COMPONENTS,
    "!Group: Illusions!",
    GROUP(GRO_SPC_GENERAL, 10),             STATS( 0, 11, 11,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 100),
    TIME( 24),                              COST(6000),
    },
    
    {
    "divinations",                          LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_spc_divin,                         MANA_NONE,
    NO_COMPONENTS,
    "!Group: Divinations!",
    GROUP(GRO_SPC_GENERAL, 60),             STATS( 0, 12, 12,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 100),
    TIME( 24),                              COST(8000),
    },

    {
    "enchantments",                         LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_spc_enchant,                       MANA_NONE,
    NO_COMPONENTS,
    "!Group: Enchantments!",
    GROUP(GRO_SPC_GENERAL, 50),             STATS( 0, 12, 12,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 100),
    TIME( 24),                              COST(8000),
    },

    {
    "summonings",                           LEVEL_MORTAL,
    LFUN(null),                             SFUN(spell_null),
    TAR_IGNORE,                             POS_STANDING,
    &gsn_spc_summons,                       MANA_NONE,
    NO_COMPONENTS,
    "!Group: Summonings!",
    GROUP(GRO_SPC_GENERAL, 90),             STATS( 0, 12, 12,  0,  0),
    SLOT(  0),                              WAIT(  0),
    MANA(  0),                              PRAC(  5, 100),
    TIME( 24),                              COST(8000),
    },

};



const   struct  group_type  group_table [] =
{
   { "language",                      GRO_LANGUAGE,       &gsn_language    },
   { "legerdemain",                   GRO_LEGERDEMAIN,    &gsn_legerdemain },
   { "offense",                       GRO_OFFENSE,        &gsn_offense     },
   { "defense",                       GRO_DEFENSE,        &gsn_defense     },
   { "wilderness survival",           GRO_SURVIVAL,       &gsn_survival    },
   { "weapon proficiencies",          GRO_WP,             &gsn_wp          },
   { "firecasting",                   GRO_FIRE_BASIC,     &gsn_fire        },
   { "watercasting",                  GRO_WATER_BASIC,    &gsn_water       },
   { "aircasting",                    GRO_AIR_BASIC,      &gsn_air         },
   { "earthcasting",                  GRO_EARTH_BASIC,    &gsn_earth       },
   { "spellcasting",                  GRO_SPC_GENERAL,    &gsn_spc_gen     },
   { "necromantics",                  GRO_NECROMANTICS,   &gsn_spc_necro   },
   { "conjurations",                  GRO_CONJURATIONS,   &gsn_spc_conj    },
   { "maladictions",                  GRO_MALADICTIONS,   &gsn_spc_malad   },
   { "illusions",                     GRO_ILLUSIONS,      &gsn_spc_illus   },
   { "divinations",                   GRO_DIVINATIONS,    &gsn_spc_divin   },
   { "enchantments",                  GRO_ENCHANTMENTS,   &gsn_spc_enchant },
   { "summonings",                    GRO_SUMMONINGS,     &gsn_spc_summons },
   { "",                              GRO_NONE,           NULL             }
};


#undef null


