/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "script.h"
#include "skills.h"



char * get_direction( char *arg )
{
    switch ( LOWER(arg[0]) )
      {
      case 'n': 
      {
            if ( LOWER(arg[1]) == 'w' ) return "northwest";
            if ( LOWER(arg[1]) == 'e' ) return "northeast";
            if ( LOWER(arg[5]) == 'w' ) return "northwest";
            if ( LOWER(arg[5]) == 'e' ) return "northeast";
            return "north";
	  }
      case 's':
      {
            if ( LOWER(arg[1]) == 'w' ) return "southwest";
            if ( LOWER(arg[1]) == 'e' ) return "southeast";
            if ( LOWER(arg[5]) == 'w' ) return "southwest";
            if ( LOWER(arg[5]) == 'e' ) return "southeast";
            return "south";
	  }
      case 'e': return "east";
      case 'w': return "west";
      case 'u': return "up";
      case 'd': return "down";
      }
 
    return "anywhere";
}


int find_door( CHAR_DATA *ch, char *arg )
{
    EXIT_DATA *pexit;
    int door;

    if ( ( door = get_dir( arg ) ) == MAX_DIR )
    {
       for ( door = 0; door < MAX_DIR; door++ )
       {
           if ( ( pexit = ch->in_room->exit[door] ) != NULL
             && IS_SET(pexit->exit_info, EX_ISDOOR)
             && !MTD(pexit->keyword)
             && is_name( arg, pexit->keyword ) )
           return door;
       }

       act( "I see no $T here.", ch, NULL, arg, TO_CHAR );
       return MAX_DIR;
    }
    
    pexit = ch->in_room->exit[door];

    if ( pexit != NULL 
      && IS_SET( pexit->exit_info, EX_SECRET )
      && IS_SET( pexit->exit_info, EX_CLOSED ) )
    {
        act( "I see no door $T here.", ch, NULL, get_direction(arg), TO_CHAR );
        return MAX_DIR;
    }

    if ( pexit != NULL 
      && IS_SET( pexit->exit_info, EX_CONCEALED ) )
    {
        act( "I see no door $T here.", ch, NULL, get_direction(arg), TO_CHAR );
        return MAX_DIR;
    }

    if ( pexit == NULL )
    {
       act( "I see no door $T here.", ch, NULL, get_direction(arg), TO_CHAR );
       return MAX_DIR;
    }

    if ( !IS_SET(pexit->exit_info, EX_ISDOOR) )
    {
       send_to_char( "You cannot do that.\n\r", ch );
       return MAX_DIR;
    }

    return door;
}



/*
 * Syntax:  open [door]
 *          open [direction]
 *          open [object]
 */
void do_open( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Open what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_here( ch, arg ) ) != NULL )
    {
       if ( obj->item_type != ITEM_CONTAINER
         && obj->item_type != ITEM_FURNITURE
         && !IS_SET(obj->value[1], FURN_EXIT) )
       {
           send_to_char( "You cannot open that.\n\r", ch );
           return;
       }

       if ( !IS_SET(obj->value[1], CONT_CLOSED) )
       {
           send_to_char( "It is not closed.\n\r", ch );
           return;
       }

       if ( !IS_SET(obj->value[1], CONT_CLOSEABLE) )
       {
           send_to_char( "You cannot do that.\n\r", ch );
           return;
       }

       if ( IS_SET(obj->value[1], CONT_LOCKED) )
       {
           act( "$p is locked.", ch, obj, NULL, TO_CHAR );
           return;
       }

       REMOVE_BIT(obj->value[1], CONT_CLOSED);
       act( "You open $p.", ch, obj, NULL, TO_CHAR );
       act( "$n opens $p.", ch, obj, NULL, TO_ROOM );
       return;
    }

    if ( ( door = find_door( ch, arg ) ) != MAX_DIR )
    {
        ROOM_INDEX_DATA *to_room;
        EXIT_DATA *pexit;
        EXIT_DATA *pexit_rev;

        pexit = ch->in_room->exit[door];

        if ( !IS_SET(pexit->exit_info, EX_CLOSED) )
        {
            send_to_char( "It is already open.\n\r",  ch );
            return;
        }

        if ( IS_SET(pexit->exit_info, EX_LOCKED) )
        {
            send_to_char( "It is locked.\n\r", ch );
            return;
        }

        if ( IS_SET(pexit->exit_info, EX_JAMMED) )
        {
            send_to_char( "It is jammed shut.\n\r", ch );
            return;
        }

        REMOVE_BIT(pexit->exit_info, EX_CLOSED);
        act( "$n open$v the $t.", ch, pexit->keyword, NULL, TO_ALL );

        if ( ( to_room   = pexit->to_room               ) != NULL
          && ( pexit_rev = to_room->exit[rev_dir[door]] ) != NULL
          && pexit_rev->to_room == ch->in_room )
        {
            CHAR_DATA *rch;

            REMOVE_BIT( pexit_rev->exit_info, EX_CLOSED );
            for ( rch = to_room->people; rch != NULL; rch = rch->next_in_room )
            act( "The $T opens.", rch, NULL, pexit_rev->keyword, TO_CHAR );
        }
    }

    return;
}



/*
 * Syntax:  close [door]
 *          close [direction]
 *          close [object]
 */
void do_close( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Close what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_here( ch, arg ) ) != NULL )
    {
       if ( obj->item_type != ITEM_CONTAINER
         && obj->item_type != ITEM_FURNITURE
         && !IS_SET(obj->value[1], FURN_EXIT) )
       {
           send_to_char( "You cannot close that.\n\r", ch );
           return;
       }

       if ( IS_SET(obj->value[1], CONT_CLOSED) )
       {
           send_to_char( "It is already closed.\n\r", ch );
           return;
       }

       if ( !IS_SET(obj->value[1], CONT_CLOSEABLE) )
       {
           send_to_char( "You cannot do that.\n\r", ch );
           return;
       }

       SET_BIT(obj->value[1], CONT_CLOSED);
       act( "You close $p.", ch, obj, NULL, TO_CHAR );
       act( "$n closes $p.", ch, obj, NULL, TO_ROOM );
       return;
    }

    if ( ( door = find_door( ch, arg ) ) != MAX_DIR )
    {
	ROOM_INDEX_DATA *to_room;
	EXIT_DATA *pexit;
	EXIT_DATA *pexit_rev;

	pexit	= ch->in_room->exit[door];

	if ( IS_SET(pexit->exit_info, EX_CLOSED) )
    {
        send_to_char( "It is already closed.\n\r", ch );
        return;
    }

    if ( IS_SET(pexit->exit_info, EX_JAMMED) )
    {
        send_to_char( "It is jammed open.\n\r", ch );
        return;
    }

	SET_BIT(pexit->exit_info, EX_CLOSED);
    act( "$n close$v the $t.", ch, pexit->keyword, NULL, TO_ALL );

	if ( ( to_room   = pexit->to_room               ) != NULL
	&&   ( pexit_rev = to_room->exit[rev_dir[door]] ) != 0
	&&   pexit_rev->to_room == ch->in_room )
	{
	    CHAR_DATA *rch;

	    SET_BIT( pexit_rev->exit_info, EX_CLOSED );
	    for ( rch = to_room->people; rch != NULL; rch = rch->next_in_room )
        act( "The $T closes.", rch, NULL, pexit_rev->keyword, TO_CHAR );
	}
    }

    return;
}



OBJ_DATA *has_key( CHAR_DATA *ch, int key )
{
   OBJ_DATA *obj;

   for ( obj = ch->carrying; obj != NULL; obj = obj->next_content )
   if ( obj->pIndexData->vnum == key ) return obj;

   return NULL;
}



/*
 * Syntax:  lock [door]
 *          lock [direction]
 *          lock [object]
 */
void do_lock( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;
    OBJ_DATA *key;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
       send_to_char( "Lock what?\n\r", ch );
       return;
    }

    if ( ( obj = get_obj_here( ch, arg ) ) != NULL )
    {
       if ( obj->item_type != ITEM_CONTAINER
         && obj->item_type != ITEM_FURNITURE
         && !IS_SET(obj->value[1], FURN_EXIT) )
       {
           send_to_char( "You cannot do that.\n\r", ch );
           return;
       }

       if ( !IS_SET(obj->value[1], CONT_CLOSED) )
       {
           send_to_char( "It is not closed.\n\r", ch );
           return;
       }

       if ( obj->value[2] <= 0 )
       {
           send_to_char( "It cannot be locked.\n\r", ch );
           return;
       }

       if ( (key = has_key( ch, obj->value[2] )) == NULL )
       {
           send_to_char( "You lack the key.\n\r", ch );
           return;
       }

       if ( IS_SET(obj->value[1], CONT_LOCKED) )
       {
           send_to_char( "It is already locked.\n\r", ch );
           return;
       }

       SET_BIT(obj->value[1], CONT_LOCKED);
       if ( key != NULL )
       act( "You lock $p with $P.", ch, obj, key, TO_CHAR );
       else
       act( "You lock $p.", ch, obj, NULL, TO_CHAR );
       act( "$n locks $p.", ch, obj, NULL, TO_ROOM );
       return;
    }

    if ( ( door = find_door( ch, arg ) ) >= 0 )
    {
       ROOM_INDEX_DATA *to_room;
       EXIT_DATA *pexit;
       EXIT_DATA *pexit_rev;

       pexit   = ch->in_room->exit[door];
       if ( !IS_SET(pexit->exit_info, EX_CLOSED) )
       {
           send_to_char( "It is not closed.\n\r", ch );
           return;
       }

       if ( pexit->key <= 0 )
       {
           send_to_char( "It cannot be locked.\n\r", ch );
           return;
       }

       if ( (key = has_key( ch, pexit->key)) == NULL )
       {
           send_to_char( "You lack the key.\n\r", ch );
           return;
       }

       if ( IS_SET(pexit->exit_info, EX_LOCKED) )
       {
           send_to_char( "It is already locked.\n\r", ch );
           return;
       }

       SET_BIT(pexit->exit_info, EX_LOCKED);
       if ( key != NULL )
       act( "You lock it with $P.", ch, obj, key, TO_CHAR );
       else
       act( "You lock it.", ch, obj, NULL, TO_CHAR );
       act( "$n locks the $T.", ch, NULL, pexit->keyword, TO_ROOM );

       if ( ( to_room   = pexit->to_room               ) != NULL
       &&   ( pexit_rev = to_room->exit[rev_dir[door]] ) != 0
       &&   pexit_rev->to_room == ch->in_room )
       {
           CHAR_DATA *rch;

           SET_BIT( pexit_rev->exit_info, EX_LOCKED );
           for ( rch = to_room->people; rch != NULL; rch = rch->next_in_room )
           act( "The $T clicks.", rch, NULL, pexit_rev->keyword, TO_CHAR );
       }
    }

    return;
}



/*
 * Syntax:  unlock [door]
 *          unlock [direction]
 *          unlock [object]
 */
void do_unlock( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;
    OBJ_DATA *key;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Unlock what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_here( ch, arg ) ) != NULL )
    {
       if ( obj->item_type != ITEM_CONTAINER
         && obj->item_type != ITEM_FURNITURE
         && !IS_SET(obj->value[1], FURN_EXIT) )
       {
           send_to_char( "You cannot do that.\n\r", ch );
           return;
       }

       if ( !IS_SET(obj->value[1], CONT_CLOSED) )
       {
           send_to_char( "It is not closed.\n\r", ch );
           return;
       }

       if ( obj->value[2] <= 0 )
       {
           send_to_char( "It cannot be unlocked.\n\r", ch );
           return;
       }

       if ( (key = has_key( ch, obj->value[2] )) == NULL )
       {
           send_to_char( "You lack the key.\n\r", ch );
           return;
       }

       if ( !IS_SET(obj->value[1], CONT_LOCKED) )
       {
           send_to_char( "It is already unlocked.\n\r", ch );
           return;
       }

       REMOVE_BIT(obj->value[1], CONT_LOCKED);
       if ( key != NULL )
       act( "You unlock $p with $P.", ch, obj, key, TO_CHAR );
       else
       act( "You unlock $p.", ch, obj, NULL, TO_CHAR );
       act( "You unlock $p.", ch, obj, NULL, TO_CHAR );
       return;
    }

    if ( ( door = find_door( ch, arg ) ) >= 0 )
    {
       /* 'unlock door' */
       ROOM_INDEX_DATA *to_room;
       EXIT_DATA *pexit;
       EXIT_DATA *pexit_rev;

       pexit = ch->in_room->exit[door];
       if (pexit == NULL)
       {
             send_to_char( "You can't go that way.\n\r", ch );
             return;
       }

       if ( !IS_SET(pexit->exit_info, EX_CLOSED) )
       {
           send_to_char( "It is not closed.\n\r", ch );
           return;
       }

       if ( pexit->key <= 0 )
       {
           send_to_char( "It cannot be unlocked.\n\r", ch );
           return;
       }

       if ( (key = has_key( ch, pexit->key)) == NULL )
       {
           send_to_char( "You lack the key.\n\r", ch );
           return;
       }

       if ( !IS_SET(pexit->exit_info, EX_LOCKED) )
       {
           send_to_char( "It is already unlocked.\n\r", ch );
           return;
       }

       REMOVE_BIT(pexit->exit_info, EX_LOCKED);
       if ( key != NULL )
       act( "You unlock the $t with $P.", ch, pexit->keyword, key, TO_CHAR );
       else
       act( "You unlock $p.", ch, obj, NULL, TO_CHAR );
       act( "$n unlocks the $T.", ch, NULL, pexit->keyword, TO_ROOM );

       if ( IS_SET(pexit->exit_info, EX_EAT_KEY) )
       {
       act( "The lock of the $t eats $P.", ch, pexit->keyword, key, TO_CHAR );
       obj_from_char( obj );
       extract_obj( obj );
       }

       /* unlock the other side */
       if ( ( to_room   = pexit->to_room               ) != NULL
       &&   ( pexit_rev = to_room->exit[rev_dir[door]] ) != NULL
       &&   pexit_rev->to_room == ch->in_room )
       {
           CHAR_DATA *rch;

           REMOVE_BIT( pexit_rev->exit_info, EX_LOCKED );
           for ( rch = to_room->people; rch != NULL; rch = rch->next_in_room )
           act( "The $T clicks.", rch, NULL, pexit_rev->keyword, TO_CHAR );
       }
    }

    return;
}




/*
 * Syntax:  pick [direction]
 *          pick [door]
 *          pick [object]
 */
void do_pick( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *gch;
    OBJ_DATA *obj;
    int door;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Pick what?\n\r", ch );
	return;
    }

    WAIT_STATE( ch, skill_table[gsn_pick_lock].beats );

    for ( gch = ch->in_room->people; gch; gch = gch->next_in_room )
    {
    if ( IS_NPC(gch) && IS_AWAKE(gch) && get_curr_int(gch) > 9 )
	{
        act( "$N notices you are trying to pick a lock.", ch, NULL, gch, TO_CHAR );
        ch->bounty += 10;
	}
    }

    if ( !skill_check( ch, gsn_pick_lock, 0 ) )
    {
	send_to_char( "You failed.\n\r", ch);
	return;
    }

    if ( ( obj = get_obj_here( ch, arg ) ) != NULL )
    {
       if ( obj->item_type != ITEM_CONTAINER )
       {
           send_to_char( "That's not a container.\n\r", ch );
           return;
       }

       if ( !IS_SET(obj->value[1], CONT_CLOSED) )
       {
           send_to_char( "It is not closed.\n\r", ch );
           return;
       }

       if ( obj->value[2] <= 0 )
       {
           send_to_char( "It cannot be unlocked.\n\r", ch );
           return;
       }

       if ( !IS_SET(obj->value[1], CONT_LOCKED) )
       {
           send_to_char( "It is already unlocked.\n\r", ch );
           return;
       }

       if ( IS_SET(obj->value[1], CONT_PICKPROOF) )
       {
           send_to_char( "You cannot decipher the lock.\n\r", ch );
           return;
       }

       REMOVE_BIT(obj->value[1], CONT_LOCKED);
       act( "You pick the lock of $p.", ch, obj, NULL, TO_CHAR );
       act( "$n picks the lock of $p.", ch, obj, NULL, TO_ROOM );
       return;
    }

    if ( ( door = find_door( ch, arg ) ) >= 0 )
    {
       ROOM_INDEX_DATA *to_room;
       EXIT_DATA *pexit;
       EXIT_DATA *pexit_rev;

       pexit = ch->in_room->exit[door];

       if ( !IS_SET(pexit->exit_info, EX_CLOSED) )
       {
           send_to_char( "It is not closed.\n\r", ch );
           return;
       }

       if ( pexit->key < 0 )
       {
           send_to_char( "It cannot be picked.\n\r", ch );
           return;
       }

       if ( !IS_SET(pexit->exit_info, EX_LOCKED) )
       {
           send_to_char( "It's already unlocked.\n\r", ch );
           return;
       }

       if ( IS_SET(pexit->exit_info, EX_PICKPROOF) )
       {
           send_to_char( "You failed.\n\r", ch );
           return;
       }

       REMOVE_BIT(pexit->exit_info, EX_LOCKED);
       act( "You pick the lock of the $T.", ch, NULL, pexit->keyword, TO_CHAR );
       act( "$n picks the lock of the $T.", ch, NULL, pexit->keyword, TO_ROOM );

       if ( ( to_room   = pexit->to_room               ) != NULL
       &&   ( pexit_rev = to_room->exit[rev_dir[door]] ) != NULL
       &&   pexit_rev->to_room == ch->in_room )
       {
           CHAR_DATA *rch;

           REMOVE_BIT( pexit_rev->exit_info, EX_LOCKED );
           for ( rch = to_room->people; rch != NULL; rch = rch->next_in_room )
           act( "The $T clicks.", rch, NULL, pexit_rev->keyword, TO_CHAR );
       }
    }

    return;
}



