/*****************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *   ___  ___  ___  ___  ___                                                 *
 *  |   ||   ||   ||  |\/|  | 2-x    NiMUD is a software currently under     *
 *   |  \ | |  | |  | |\/| |         development.  It is based primarily on  *
 *   | |\\| |  | |  | |  | |         the discontinued package, Merc 2.2.     *
 *   | | \  |  | |  | |  | |         NiMUD is being written and developed    *
 *  |___||___||___||__|  |__|        By Locke and Surreality as a new,       *
 *   NAMELESS INCARNATE *MUD*        frequently updated package similar to   *
 *       S O F T W A R E             the original Merc 2.x.                  *
 *                                                                           *
 *  Just look for the Iron Maiden skull wherever NiMUD products are found.   *
 *                                                                           *
 *  Much time and thought has gone into this software and you are            *
 *  benefitting.  We hope that you share your changes too.  What goes        *
 *  around, comes around.                                                    *
 *****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "script.h"

#define PARM(var, vtype)         ( !var || (var->type != vtype) )

int gotoloops;
char func_buff[MAX_STRING_LENGTH];

void parse_assign			  args( ( TRIGGER_DATA *trig, char *line,
									  void * caller, int type ) );
char *translate_variables	  args( ( void * caller, int type, char *exp ) );
VARIABLE_DATA * get_variable  args( ( VARIABLE_DATA **vlist, char *name ) );
VARIABLE_DATA * find_variable args( ( void * caller, int type, char *name ) );
VARIABLE_DATA ** varlist	  args( ( void * caller, int type ) );
void assign_var               args( ( void * caller, int type,
                                      VARIABLE_DATA *var, char *name ) );
int trigger                   args( ( void * caller, int type, TRIGGER_DATA *trig ) );



/*
 * Return a trigger of supplied name on supplied caller.
 */
TRIGGER_DATA *get_trigger( void * caller, int type, char *trigname )
{
	TRIGGER_DATA *trig;

	switch( type )
	{
        case TYPE_MOB:   trig = ((CHAR_DATA *)caller)->triggers;        break;
        case TYPE_OBJ:   trig = ((OBJ_DATA *)caller)->triggers;         break;
        case TYPE_ROOM:  trig = ((ROOM_INDEX_DATA *)caller)->triggers;  break;
         default: bug( "Get_trigger: invalid type %d.", type ); return NULL;
	}

	for ( ; trig != NULL;  trig = trig->next )
	{
        if ( !str_cmp( trig->script->name, trigname ) )
		return trig;
	}

	return trig;
}



/*
 * Return a target caller information based on vnum and type,
 * such that for rooms you would have R340 and objects O514 etc.
 */
void * get_target( void * caller, int type, int * target_type, char *exp )
{
    int vnum;

	switch (  *exp	)
	{
		case 'r':
        case 'R': *target_type = TYPE_ROOM;
				  if ( type == TYPE_ROOM ) return caller;
                  if ( type == TYPE_MOB  ) return ((CHAR_DATA *)caller)->in_room;
                  if ( type == TYPE_OBJ  ) return ((OBJ_DATA *)caller)->in_room;
				  break;
		case 'o':
        case 'O': *target_type = TYPE_OBJ;  break;
		case 'm':
        case 'M': *target_type = TYPE_MOB;  break;
		 default: return NULL;
	}

	exp++;

	vnum = atoi(exp);

	if ( type == TYPE_OBJ )
	{
		OBJ_DATA *cobj = (OBJ_DATA *) caller;

        if ( *target_type == TYPE_OBJ )
		{
			OBJ_DATA *obj;

			for ( obj = cobj->in_obj;
				  obj != NULL && obj->pIndexData->vnum != vnum;
				  obj = obj->next_content );

			if ( obj != NULL ) return obj;

			for ( obj = cobj->in_room->contents;
				  obj != NULL && obj->pIndexData->vnum != vnum;
				  obj = obj->next_content );

			if ( obj != NULL ) return obj;

			for ( obj = cobj->contains;
				  obj != NULL && obj->pIndexData->vnum != vnum;
				  obj = obj->next_content );

			if ( obj != NULL ) return obj;

			for ( obj = object_list;
				  obj != NULL && obj->pIndexData->vnum != vnum;
				  obj = obj->next );

			return obj;
		}

        if ( *target_type == TYPE_MOB )
		{
			CHAR_DATA *mob;

			for ( mob = cobj->carried_by->in_room->people;
				  mob != NULL && IS_NPC(mob) && mob->pIndexData->vnum != vnum;
				  mob = mob->next_in_room );

            if ( mob != NULL ) return mob;

			for ( mob = char_list;
				  mob != NULL && IS_NPC(mob) && mob->pIndexData->vnum != vnum;
				  mob = mob->next );

			return mob;
		}
	}

	if ( type == TYPE_MOB )
	{
        CHAR_DATA *cmob = (CHAR_DATA *) caller;

        if ( *target_type == TYPE_OBJ )
		{
			OBJ_DATA *obj;

			for ( obj = cmob->carrying;
				  obj != NULL && obj->pIndexData->vnum != vnum;
				  obj = obj->next_content );

			if ( obj != NULL ) return obj;

			for ( obj = cmob->in_room->contents;
				  obj != NULL && obj->pIndexData->vnum != vnum;
				  obj = obj->next_content );

			if ( obj != NULL ) return obj;

			for ( obj = object_list;
				  obj != NULL && obj->pIndexData->vnum != vnum;
				  obj = obj->next );

			return obj;
		}

        if ( *target_type == TYPE_MOB )
		{
			CHAR_DATA *mob;

			for ( mob = cmob->in_room->people;
				  mob != NULL && IS_NPC(mob) && mob->pIndexData->vnum != vnum;
				  mob = mob->next_in_room );

            if ( mob != NULL ) return mob;

			for ( mob = char_list;
				  mob != NULL && IS_NPC(mob) && mob->pIndexData->vnum != vnum;
				  mob = mob->next );

			return mob;
		}
	}

	return NULL;
}




/*
 * For the in-line parser.
 */
void mini_parse_script( void * caller, int type, char *exp )
{
    char buf[MAX_STRING_LENGTH];
    char *commands;

    while ( *exp != '\0' )
    {
        /*
         * Advance a line.
         */
        exp = one_line( exp, buf );
        commands = skip_spaces( buf );

        if ( *commands == '*' || *commands == '\0' )
        continue;

        if ( *commands == '%' )
        parse_assign( curtrig(caller,type), commands, caller, type );
        else
        {
            VARIABLE_DATA *value;

            value = eval_function( caller, type, commands );
            free_variable( value );
        }
    }

    return;
}






/*
 * Goto a specified label.
 */
VARIABLE_DATA *func_goto( void * caller, int type, VARIABLE_DATA *label )
{
    TRIGGER_DATA *trig = curtrig(caller,type);
    char buf[MAX_STRING_LENGTH];
    char *exp;
    char *line;
    char *slabel;

    if (PARM(label,TYPE_STRING)) return NULL;

    slabel = translate_variables( caller, type, (char *)label->value );

    line = trig->script->commands;
    while ( !MTD(line) )
    {
        /*
         * Advance a line.
         */
        line = one_line( line, buf );
        exp = skip_spaces( buf );

        if ( LOWER(*exp) == 'l' )
        {
            int param_paren = 0;
            char name[MAX_STRING_LENGTH];
            char *point;

            /*
             * Grab the function name.
             * func(param, .... )
             * ^
             */
            point = name;
            while ( *exp != '('
                 && *exp != ' '
                 && *exp != '\0' ) *point++ = *exp++;
            *point = '\0';
            exp = skip_spaces( exp );
            if ( *exp != '\0' ) exp++;

            if ( str_cmp( name, "label" ) )
            continue;

            point = name;
            while( *exp != '\0' )
            {
                /*
                 * Ok, get the hell out of here, we're done.
                 * func(param, .... )
                 *           ^
                 */
                if ( param_paren == 0 )
                    if ( *exp == ','
                      || *exp == ')'
                      || *exp == '\0' )
                    {
                        if ( *exp == ',' || *exp == ')' ) exp++;
                        break;
                    }


                if ( *exp == '(' ) param_paren++;
                else
                if ( *exp == ')' ) param_paren--;

                if ( *exp == ' ' ) exp++;
                else *point++ = *exp++;
            }
            *point = '\0';

            point = translate_variables(caller, type, name);
            if ( !str_cmp( point, slabel ) )
            {
                trig->location = line;
                free_string(point);
                break;
            }
            free_string(point);
        }
    }

    free_string(slabel);

    if ( ++gotoloops > MAX_LOOPS )
    {
        NOTIFY( "Notify>  Exceeded maximum gotos per script (Halted).\n\r", LEVEL_IMMORTAL, WIZ_NOTIFY_SCRIPT );
        trig->location = NULL;
    }
    return NULL;
}




/*
 * Do a conditional.
 */
VARIABLE_DATA *func_if( void * caller, int type,
                        VARIABLE_DATA *exp,
                        VARIABLE_DATA *iftrue,
                        VARIABLE_DATA *iffalse )
{
    int val;
    char *_exp;
    char *_iftrue;
    char *_iffalse;

    if( PARM(exp,TYPE_STRING) )
    {
        _exp = !exp ? str_dup( "" ) : (exp->value ? str_dup( "1" )
                                                  : str_dup( "0" ));
    }
    else
    _exp = translate_variables( caller, type, strip_curlies((char *)exp->value) );

    if( PARM(iftrue, TYPE_STRING) ) _iftrue = str_dup( "" );
    else
    _iftrue  = translate_variables( caller, type, (char *)iftrue->value );

    if( PARM(iffalse, TYPE_STRING) ) _iffalse = str_dup( "" );
    else
    _iffalse = translate_variables( caller, type, (char *)iffalse->value );

    val = atoi(_exp);

    free_string( _exp );
    free_string( _iftrue );
    free_string( _iffalse );
    return NULL;
}




/*
 * Don't do anything, but supply a place for goto to go to.
 */
VARIABLE_DATA *func_label( void * caller, int type )
{
    return NULL;
}



/*
 * Set the value returned by the function.
 */
VARIABLE_DATA *func_return( void * caller, int type, VARIABLE_DATA *value )
{
    TRIGGER_DATA *trig = curtrig( caller, type );
    int x;
    char *_value;

    if( PARM(value,TYPE_STRING) )
    {
        _value = !value ? str_dup( "" ) : (value->value ? str_dup( "1" )
                                                        : str_dup( "0" ));
    }
    else
    _value = translate_variables( caller, type, strip_curlies((char *)value->value) );

    x = atoi(_value);
    trig->returned = x;

    free_string( _value );
    return NULL;
}



/*
 * Halt and set the return value.
 */
VARIABLE_DATA *func_halt( void * caller, int type, VARIABLE_DATA *value )
{
    TRIGGER_DATA *trig = curtrig( caller, type );
    VARIABLE_DATA *pVar, *pVar_next;
    int x;
    char *_value;

    if( PARM(value,TYPE_STRING) )
    {
        _value = !value ? str_dup( "" ) : (value->value ? str_dup( "1" )
                                                        : str_dup( "0" ));
    }
    else
    _value = translate_variables( caller, type, strip_curlies((char *)value->value) );

    x = atoi(_value);
    trig->returned = x;

    for ( pVar = trig->locals;  pVar != NULL; pVar = pVar_next )
    {
        pVar_next = pVar->next;
        free_variable( pVar );
    }

    trig->locals = NULL;
    trig->location = NULL;

    free_string( _value );
    return NULL;
}



/*
 * Halt without prettiness (for debugging purposes).
 */
VARIABLE_DATA *func_permhalt( void * caller, int type )
{
    TRIGGER_DATA *trig = curtrig(caller,type);

    trig->location = NULL;
    SET_BIT(trig->bits, SCRIPT_HALT);
    return NULL;
}



/*
 * Set the wait state.
 */
VARIABLE_DATA *func_wait( void * caller, int type, VARIABLE_DATA *value )
{
    TRIGGER_DATA *trig = curtrig(caller,type);
    char *_value;
    int x;

    if( PARM(value,TYPE_STRING) )
    {
        _value = !value ? str_dup( "" ) : (value->value ? str_dup( "1" )
                                                        : str_dup( "0" ));
    }
    else
    _value = translate_variables( caller, type, strip_curlies((char *)value->value) );

    x = atoi(_value);
    trig->wait = x;

    free_string( _value );
    return NULL;
}




/*
 * Set the autowait state.
 */
VARIABLE_DATA *func_autowait( void * caller, int type, VARIABLE_DATA *value )
{
    TRIGGER_DATA *trig = curtrig(caller,type);
    char *_value;
    int x;

    if( PARM(value,TYPE_STRING) )
    {
        _value = !value ? str_dup( "" ) : (value->value ? str_dup( "1" )
                                                        : str_dup( "0" ));
    }
    else
    _value = translate_variables( caller, type, strip_curlies((char *)value->value) );

    x = atoi(_value);
    trig->autowait = x;

    free_string( _value );
    return NULL;
}



/*
 * Call another trigger.
 */
VARIABLE_DATA *func_call( void * caller, int type, VARIABLE_DATA *trigname,
                          VARIABLE_DATA *target )
{
    VARIABLE_DATA *newvar;
	char buf[MAX_STRING_LENGTH];
	TRIGGER_DATA *trig;
	void * target_caller;
	int target_type;
    char *_trigname;

    if( PARM(trigname,TYPE_STRING) )
    {
        _trigname = !trigname ? str_dup( "" ) : (trigname->value
                                                        ? str_dup( "1" )
                                                        : str_dup( "0" ));
    }
    else
    _trigname = translate_variables( caller, type, strip_curlies((char *)trigname->value) );

	target_caller = caller;
	target_type   = type;

    if ( PARM(target,TYPE_STRING) )
	{
        target_caller = get_target( caller, type, &target_type, (char *) target->value );
        if ( target_caller == NULL ) return NULL;
	}

    trig = get_trigger( target_caller, target_type, _trigname );

    free_string( _trigname );

    if ( trig == NULL || trig == curtrig(caller,type) ) return NULL;

    sprintf( buf, "%d", trigger( caller, type, trig ) );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}




/*
 * Return a pointer to one-self.
 */
VARIABLE_DATA *func_self( void * caller, int type )
{
    VARIABLE_DATA *self;

    self = new_variable( );
    self->value = caller;
    self->type = type;
    return self;
}



/*
 * Compare two numerics.
 */
VARIABLE_DATA *func_cmp( void * caller, int type, VARIABLE_DATA *astr,
                         VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    sprintf( buf, "%d", (int) !str_cmp( _astr, _bstr ) );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Use a boolean NOT.
 */
VARIABLE_DATA *func_not( void * caller, int type, VARIABLE_DATA *value )
{
    static char buf[MAX_STRING_LENGTH];
    int x;
    VARIABLE_DATA *newvar;
    char *_value;

    if( PARM(value,TYPE_STRING) )
    {
        _value = !value ? str_dup( "" ) : (value->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _value = translate_variables( caller, type, strip_curlies((char *)value->value) );

    x = atoi(_value);

    sprintf( buf, "%d", !x );

    free_string( _value );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Perform a boolean OR.
 */
VARIABLE_DATA *func_or( void * caller, int type, VARIABLE_DATA *astr,
                                                 VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    x = atoi(_astr);
    y = atoi(_bstr);

    sprintf( buf, "%d", x || y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Perform a boolean AND.
 */
VARIABLE_DATA *func_and( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    x = atoi(_astr);
    y = atoi(_bstr);

    sprintf( buf, "%d", x && y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}




/*
 * Perform a boolean < check.
 */
VARIABLE_DATA *func_less( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );


    x = atoi(_astr);
    y = atoi(_bstr);

    sprintf( buf, "%d", x < y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Perform a boolean > check.
 */
VARIABLE_DATA *func_greater( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    x = atoi(_astr);
    y = atoi(_bstr);

    sprintf( buf, "%d", x > y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Str_prefix.
 */
VARIABLE_DATA *func_pre( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );


    sprintf( buf, "%d", !str_prefix( _astr, _bstr ) );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Str_infix.
 */
VARIABLE_DATA *func_in( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    char buf[MAX_STRING_LENGTH];
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    sprintf( buf, "%d", !str_infix( _astr, _bstr ) );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Strstr.
 */
VARIABLE_DATA *func_strstr( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    char buf[MAX_STRING_LENGTH];
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    sprintf( buf, "%d", (int) strstr( _astr, _bstr ) );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Pointer compare.
 */
VARIABLE_DATA *func_pcmp( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    VARIABLE_DATA *v1, *v2, *newvar;
    char buf[MAX_STRING_LENGTH];

    if( PARM(astr,TYPE_STRING) )
    v1 = astr;
    else
    v1 = find_variable( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    v2 = bstr;
    else
    v2 = find_variable( caller, type, strip_curlies((char *)bstr->value) );


    buf[0] = '\0';
    if ( v1 == v2 )               buf[0] = '1';
    if ( v1->type != v2->type )   buf[0] = '0';
    if ( v1->value == v2->value ) buf[0] = '1';
    buf[1] = '\0';

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Add two numerics.
 */
VARIABLE_DATA *func_add( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    x = atoi(_astr);
    y = atoi(_bstr);

    sprintf( buf, "%d", x + y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Subtract two numerics.
 */
VARIABLE_DATA *func_sub( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );


    x = atoi(_astr);
    y = atoi(_bstr);

    sprintf( buf, "%d", x - y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Multiply two numerics.
 */
VARIABLE_DATA *func_mult( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );


    x = atoi(_astr);
    y = atoi(_bstr);

    sprintf( buf, "%d", x * y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Divide two numerics.
 */
VARIABLE_DATA *func_div( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    x = atoi(_astr);
    y = atoi(_bstr);

    sprintf( buf, "%d", x / y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Modula two numerics.
 */
VARIABLE_DATA *func_mod( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    x = atoi(_astr);
    y = atoi(_bstr);

    sprintf( buf, "%d", x % y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Return a random numeric in the range A-B.
 */
VARIABLE_DATA *func_random( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    x = atoi(_astr);
    y = atoi(_bstr);

    sprintf( buf, "%d", number_range( x, y ) );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Perform a binary AND.
 */
VARIABLE_DATA *func_band( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );


    x = atoi(_astr);
    y = atoi(_bstr);

	sprintf( buf, "%d", x & y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Perform a binary OR.
 */
VARIABLE_DATA *func_bor( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    x = atoi(_astr);
    y = atoi(_bstr);

	sprintf( buf, "%d", x | y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Perform a binary XOR.
 */
VARIABLE_DATA *func_bxor( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    int x, y;
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    x = atoi(_astr);
    y = atoi(_bstr);

	sprintf( buf, "%d", x ^ y );

    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Concatenate two strings.
 */
VARIABLE_DATA *func_cat( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    static char buf[MAX_STRING_LENGTH];
    VARIABLE_DATA *newvar;
    char *_astr, *_bstr;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    sprintf( buf, "%s%s", strip_curlies(_astr), strip_curlies(_bstr) );
    free_string( _astr );
    free_string( _bstr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * One_arg with a number.
 */
VARIABLE_DATA *func_word( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *value )
{
    static char buf[MAX_STRING_LENGTH];
    char *_astr, *_value, *spoint;
    VARIABLE_DATA *newvar;
    int x;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    if( PARM(value,TYPE_STRING) )
    {
        _value = !value ? str_dup( "" ) : (value->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _value = translate_variables( caller, type, strip_curlies((char *)value->value) );

    spoint = _astr;
    x = atoi(_value);

    while( x > 0 )
    {
        spoint = one_argument(spoint, buf);
        x--;
    }

    free_string( _astr );
    free_string( _value );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}



/*
 * Act()
 */
VARIABLE_DATA * func_out( void * caller, int type, VARIABLE_DATA *out,
                          VARIABLE_DATA *ch, VARIABLE_DATA *arg1,
                          VARIABLE_DATA *arg2, VARIABLE_DATA *act_type )
{
    VARIABLE_DATA *var1, *var2, *var3;
    char *_out, *_act_type;

    if( PARM(out,TYPE_STRING) )
    {
        _out = !out ? str_dup( "" ) : (out->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _out = translate_variables( caller, type, strip_curlies((char *)out->value) );

    if( PARM(act_type,TYPE_STRING) )
    {
        _act_type = !act_type ? str_dup( "" ) : (act_type->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _act_type = translate_variables( caller, type, strip_curlies((char *)act_type->value) );

    if( PARM(ch,TYPE_STRING) )
    var1 = ch;
    else
    var1 = find_variable( caller, type, strip_curlies((char *)ch->value) );

    if( PARM(arg1,TYPE_STRING) )
    var2 = arg1;
    else
    var2 = find_variable( caller, type, strip_curlies((char *)arg1->value) );

    if( PARM(arg2,TYPE_STRING) )
    var3= arg2;
    else
    var3 = find_variable( caller, type, strip_curlies((char *)arg2->value) );

    act( _out, (CHAR_DATA *)var1->value, var2->value, var3->value, atoi(_act_type) );

    free_string( _act_type );
    free_string( _out );

    return NULL;
}


/*
 * Numberize()
 */
VARIABLE_DATA * func_numw( void * caller, int type, VARIABLE_DATA *astr )
{
    VARIABLE_DATA *newvar;
    char *_astr;
    int v;

    if( PARM(astr,TYPE_STRING) )
    {
        _astr = !astr ? str_dup( "" ) : (astr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _astr = translate_variables( caller, type, strip_curlies((char *)astr->value) );

    v = atoi(_astr);
    free_string( _astr );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( numberize(v) );
    return newvar;
}



/*
 * String_replace().
 */
VARIABLE_DATA * func_strp( void * caller, int type, VARIABLE_DATA *value,
                           VARIABLE_DATA *old, VARIABLE_DATA *new )
{
    char buf[MAX_STRING_LENGTH];
    char *_value, *_old, *_new;
    VARIABLE_DATA *newvar;

    if( PARM(value,TYPE_STRING) )
    {
        _value = !value ? str_dup( "" ) : (value->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _value = translate_variables( caller, type, strip_curlies((char *)value->value) );

    if( PARM(old,TYPE_STRING) )
    {
        _old = !old ? str_dup( "" ) : (old->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _old = translate_variables( caller, type, strip_curlies((char *)old->value) );

    if( PARM(new,TYPE_STRING) )
    {
        _new = !new ? str_dup( "" ) : (new->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _new = translate_variables( caller, type, strip_curlies((char *)new->value) );

    if ( *_value == '\0' || *_old == '\0' )
    {
        free_string( _value );
        free_string( _old );
        free_string( _new );
        return NULL;
    }

    while ( strstr( _value, _old ) )
    {
        _value = string_replace( _value, _old, _new );

        if ( *_value == '\0' || *_old == '\0' )
        {
            sprintf( buf, "%s", _value );
            free_string( _value );
            free_string( _old );
            free_string( _new );
            return NULL;
        }
    }

    sprintf( buf, "%s", _value );
    free_string( _value );
    free_string( _old );
    free_string( _new );

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}






/*
 * Self-Interpret.
 */
VARIABLE_DATA * func_do( void * caller, int type,
                         VARIABLE_DATA *exp0,
                         VARIABLE_DATA *exp1,
                         VARIABLE_DATA *exp2,
                         VARIABLE_DATA *exp3,
                         VARIABLE_DATA *exp4,
                         VARIABLE_DATA *exp5 )
{
    char *_exp0, *_exp1, *_exp2, *_exp3, *_exp4, *_exp5;

    if ( type != TYPE_MOB )
        return NULL;

    if( PARM(exp0,TYPE_STRING) )
    {
        _exp0 = !exp0 ? str_dup( "" ) : (exp0->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _exp0 = translate_variables( caller, type, strip_curlies((char *)exp0->value) );

    if( PARM(exp1,TYPE_STRING) )
    {
        _exp1 = !exp1 ? str_dup( "" ) : (exp1->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _exp1 = translate_variables( caller, type, strip_curlies((char *)exp1->value) );

    if( PARM(exp2,TYPE_STRING) )
    {
        _exp2 = !exp2 ? str_dup( "" ) : (exp2->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _exp2 = translate_variables( caller, type, strip_curlies((char *)exp2->value) );

    if( PARM(exp3,TYPE_STRING) )
    {
        _exp3 = !exp3 ? str_dup( "" ) : (exp3->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _exp3 = translate_variables( caller, type, strip_curlies((char *)exp3->value) );

    if( PARM(exp4,TYPE_STRING) )
    {
        _exp4 = !exp4 ? str_dup( "" ) : (exp4->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _exp4 = translate_variables( caller, type, strip_curlies((char *)exp4->value) );

    if( PARM(exp5,TYPE_STRING) )
    {
        _exp5 = !exp5 ? str_dup( "" ) : (exp5->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _exp5 = translate_variables( caller, type, strip_curlies((char *)exp5->value) );

    interpret( (CHAR_DATA *)caller, _exp0 );
    free_string(_exp0);

    interpret( (CHAR_DATA *)caller, _exp1 );
    free_string(_exp1);

    interpret( (CHAR_DATA *)caller, _exp2 );
    free_string(_exp2);

    interpret( (CHAR_DATA *)caller, _exp3 );
    free_string(_exp3);

    interpret( (CHAR_DATA *)caller, _exp4 );
    free_string(_exp4);

    interpret( (CHAR_DATA *)caller, _exp5 );
    free_string(_exp5);

    return NULL;
}



/*
 * Interpret.
 */
VARIABLE_DATA * func_interpret( void * caller, int type,
                         VARIABLE_DATA *who,
                         VARIABLE_DATA *exp1,
                         VARIABLE_DATA *exp2,
                         VARIABLE_DATA *exp3,
                         VARIABLE_DATA *exp4 )
{
    char *_exp1, *_exp2, *_exp3, *_exp4;
    CHAR_DATA *mob;

    if ( !who || who->type != TYPE_MOB )
        return NULL;

    mob = (CHAR_DATA *)who->value;

    if( PARM(exp1,TYPE_STRING) )
    {
        _exp1 = !exp1 ? str_dup( "" ) : (exp1->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _exp1 = translate_variables( caller, type, strip_curlies((char *)exp1->value) );

    if( PARM(exp2,TYPE_STRING) )
    {
        _exp2 = !exp2 ? str_dup( "" ) : (exp2->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _exp2 = translate_variables( caller, type, strip_curlies((char *)exp2->value) );

    if( PARM(exp3,TYPE_STRING) )
    {
        _exp3 = !exp3 ? str_dup( "" ) : (exp3->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _exp3 = translate_variables( caller, type, strip_curlies((char *)exp3->value) );

    if( PARM(exp4,TYPE_STRING) )
    {
        _exp4 = !exp4 ? str_dup( "" ) : (exp4->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _exp4 = translate_variables( caller, type, strip_curlies((char *)exp4->value) );

    interpret( mob, _exp1 );
    free_string(_exp1);

    interpret( mob, _exp2 );
    free_string(_exp2);

    interpret( mob, _exp3 );
    free_string(_exp3);

    interpret( mob, _exp4 );
    free_string(_exp4);

    return NULL;
}



VARIABLE_DATA *func_ms( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *mob;
    char *p = "";
    VARIABLE_DATA *newvar;
    char *_bstr;

    if( PARM(astr,TYPE_MOB) )
    return NULL;

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );


    mob = (CHAR_DATA *)astr->value;

    if ( !str_cmp( _bstr, "short"       ) ) p = mob->short_descr;
    if ( !str_cmp( _bstr, "long"        ) ) p = mob->long_descr;
    if ( !str_cmp( _bstr, "name"        ) ) p = mob->name;
    if ( !str_cmp( _bstr, "description" ) ) p = mob->description;
    if ( !str_cmp( _bstr, "plural"      ) ) p = pluralize( mob->short_descr );
    if ( !str_cmp( _bstr, "vnum"        ) )
    {
        sprintf( buf, "%d", IS_NPC(mob) ? mob->pIndexData->vnum : 0 );
        p = buf;
    }
    if ( !str_cmp( _bstr, "speaking"    ) )
    {
        sprintf( buf, "%d", mob->speaking );
        p = buf;
    }
    if ( !str_cmp( _bstr, "room"    ) )
    {
        sprintf( buf, "%d", mob->in_room->vnum );
        p = buf;
    }

    free_string( _bstr );

    newvar = new_variable( );
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( p );
    return newvar;
}


VARIABLE_DATA *func_os( void * caller, int type, VARIABLE_DATA *astr, VARIABLE_DATA *bstr )
{
    char buf[MAX_STRING_LENGTH];
    OBJ_DATA *obj;
    char *p = "";
    VARIABLE_DATA *newvar;
    char *_bstr;

    if( PARM(astr,TYPE_OBJ) )
    return NULL;

    if( PARM(bstr,TYPE_STRING) )
    {
        _bstr = !bstr ? str_dup( "" ) : (bstr->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _bstr = translate_variables( caller, type, strip_curlies((char *)bstr->value) );

    obj = (OBJ_DATA *)astr->value;

    if ( !str_cmp( _bstr, "short"       ) ) p = obj->short_descr;
    if ( !str_cmp( _bstr, "long"        ) ) p = obj->description;
    if ( !str_cmp( _bstr, "name"        ) ) p = obj->name;
    if ( !str_cmp( _bstr, "description" ) ) p = obj->real_description;
    if ( !str_cmp( _bstr, "plural"      ) ) p = pluralize( obj->short_descr );
    if ( !str_cmp( _bstr, "vnum"        ) )
    {
        sprintf( buf, "%d", obj->pIndexData->vnum );
        p = buf;
    }
    if ( !str_cmp( _bstr, "room"    ) )
    {
        sprintf( buf, "%d", obj->in_room->vnum );
        p = buf;
    }

    free_string( _bstr );

    newvar = new_variable( );
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( p );
    return newvar;
}



VARIABLE_DATA *func_sameroom( void * caller, int type, VARIABLE_DATA *var )
{
    char buf[MAX_STRING_LENGTH];
    int val;
    VARIABLE_DATA *newvar;

    if ( var == NULL ) val = 0;
    else
    switch ( type )
    {
        case TYPE_OBJ:
          if ( var->type == TYPE_OBJ )
           val = ((OBJ_DATA *)var->value)->in_room == ((OBJ_DATA *)caller)->in_room;
          if ( var->type == TYPE_MOB )
           val = ((CHAR_DATA *)var->value)->in_room == ((OBJ_DATA *)caller)->in_room;
          if ( var->type == TYPE_ROOM )
           val = (ROOM_INDEX_DATA *)var->value == ((OBJ_DATA *)caller)->in_room;
           val = 0;
         break;
        case TYPE_MOB:
          if ( var->type == TYPE_OBJ )
           val = ((OBJ_DATA *)var->value)->in_room == ((CHAR_DATA *)caller)->in_room;
          if ( var->type == TYPE_MOB )
           val = ((CHAR_DATA *)var->value)->in_room == ((CHAR_DATA *)caller)->in_room;
          if ( var->type == TYPE_ROOM )
           val = (ROOM_INDEX_DATA *)var->value == ((CHAR_DATA *)caller)->in_room;
           val = 0;
         break;
        case TYPE_ROOM:
          if ( var->type == TYPE_OBJ )
           val = ((OBJ_DATA *)var->value)->in_room == (ROOM_INDEX_DATA *)caller;
          if ( var->type == TYPE_MOB )
           val = ((CHAR_DATA *)var->value)->in_room == (ROOM_INDEX_DATA *)caller;
          if ( var->type == TYPE_ROOM )
           val = (ROOM_INDEX_DATA *)var->value == (ROOM_INDEX_DATA *)caller;
           val = 0;
         break;
        default: val = 0;
    }

    sprintf( buf, "%d", val );
    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}


VARIABLE_DATA *func_eval( void * caller, int type, VARIABLE_DATA *value )
{
    VARIABLE_DATA *newvar;
    char buf[MAX_STRING_LENGTH];
    char *_value;

    if( PARM(value,TYPE_STRING) )
    {
        _value = !value ? str_dup( "" ) : (value->value
                                         ? str_dup( "1" )
                                         : str_dup( "0" ));
    }
    else
    _value = translate_variables( caller, type, strip_curlies((char *)value->value) );

    sprintf( buf, "%s", _value );
    free_string(_value);

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}


/*
 * Returns the name of a random player in the room.
 * format: rndplr( )
 */
VARIABLE_DATA *func_rndplr( void * caller, int type )
{
    VARIABLE_DATA *newvar;
    ROOM_INDEX_DATA *pRoom;
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *och, *rch = NULL;
    CHAR_DATA *ch;

    switch ( type )
    {
        case TYPE_OBJ: pRoom = ((OBJ_DATA *)caller)->in_room;
                       och = NULL;
         break;
        case TYPE_MOB: pRoom = ((CHAR_DATA *)caller)->in_room;
                       och = (CHAR_DATA *)caller;
         break;
        case TYPE_ROOM: pRoom = (ROOM_INDEX_DATA *)caller;
                       och = NULL;
         break;
        default: pRoom = NULL;  och = NULL;
    }

    if (pRoom == NULL)
    {
        sprintf( buf, "me" );
    }
    else
    {
        int count;

        count = 0;
        for ( ch = pRoom->people; ch != NULL; ch = ch->next_in_room )
        {
            if ( IS_NPC(ch) )
            continue;

            if ( och != NULL )
            {
                if ( !can_see( och, ch ) )
                continue;
            }

            count++;
        }

        if ( count > 1 )
        count -= number_range(0,count-1);

        for( ch = pRoom->people; count > 0 && ch != NULL; ch = ch->next_in_room )
        {
            if ( IS_NPC(ch) )
            continue;

            /*
             * Check for invisible players or blinded mobiles.
             * (applies to TYPE_MOB callers only)
             */
            if ( och != NULL )
            {
                if ( !can_see( och, ch ) )
                continue;
            }


            if ( --count == 0 )
            {
                rch = ch;
            }
        }


        if ( rch == NULL )
        {
            sprintf( buf, "me" );
        }
        else
        {
            sprintf( buf, "%s", STR(rch, name) );
        }
    }

    newvar = new_variable();
    newvar->type = TYPE_STRING;
    newvar->value = str_dup( buf );
    return newvar;
}
