/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"

/*
 * List occupants.
 */
void show_occupants_to_char( OBJ_DATA *obj, CHAR_DATA *ch )
{
    CHAR_DATA *och;

    for ( och = ch->in_room->people; och != NULL; och = och->next_in_room )
    {
    if ( och->furniture == obj && can_see( ch, och ) )
    act( "$N $K $t on it.", ch, position_name( och->position ), och, TO_CHAR );
    }
    return;
}


/*
 * Count occupants.
 */
int count_occupants( OBJ_DATA *obj )
{
    CHAR_DATA *och;
    int count = 0;

    if ( obj->in_room == NULL )
    return -1;

    for ( och = char_list; och != NULL; och = och->next )
        if ( och->furniture == obj ) count++;

    return count;
}



bool has_occupant( OBJ_DATA *obj )
{
    CHAR_DATA *och;

    for ( och = char_list; och != NULL; och = och->next )
    {
        if ( och->furniture == obj )
          return TRUE;
    }
    return FALSE;
}



bool occupant( OBJ_DATA *obj )
{
    CHAR_DATA *och;

    for ( och = char_list; och != NULL; och = och->next )
    {
        if ( och->furniture == obj  )
          return TRUE;
    }
    return FALSE;
}


CHAR_DATA *hitched( OBJ_DATA *obj )
{
    CHAR_DATA *och;

    for ( och = char_list; och != NULL; och = och->next )
    {
        if ( och->hitched_to == obj )
          return och;
    }
    return NULL;
}




OBJ_DATA *get_furn_here( CHAR_DATA *ch, char *argument )
{
    OBJ_DATA *obj;
    OBJ_DATA *saved = NULL;

    for ( obj = ch->in_room->contents;  obj != NULL;  obj = obj->next_content )
    {
        if ( is_name(argument,STR(obj,name))
          && obj->item_type == ITEM_FURNITURE
          && ( saved == NULL || !OCCUPADO(obj) ) )
            saved = obj;
    }       
    return saved;
}




void set_furn( CHAR_DATA *ch, OBJ_DATA *obj )
{
    ch->furniture = NULL;

    if ( obj == NULL ) return;

    if ( OCCUPADO(obj) )
    {
        bug( "set_furn: Occupado.", 0 );
        return;
    }

    ch->furniture = obj;
    return;
}


