/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "defaults.h"
#include "script.h"


/*
 * From mem.c
 */
extern VARIABLE_DATA * mud_var_list;


/*
 * Retrieve a character's trusted level for permission checking.
 */
int get_trust( CHAR_DATA *ch )
{
    if ( ch == NULL ) return -1;

    /*
     * Switch characters are trusted at their original level.
     */
    if ( ch->desc != NULL && ch->desc->original != NULL )
	ch = ch->desc->original;

    if ( IS_NPC(ch) )
	return LEVEL_HERO - 1;

    if ( ch->pcdata )
    return PC(ch,level);

    return -1;
}






/*
 * Retrieve character's current strength.
 */
int get_curr_str( CHAR_DATA *ch )
{
    int max;

	max = 25;

    return URANGE( 3, ch->perm_str + ch->mod_str, max );
}




/*
 * Retrieve character's current intelligence.
 */
int get_curr_int( CHAR_DATA *ch )
{
    int max;

	max = 25;

    return URANGE( 3, ch->perm_int + ch->mod_int, max );
}



/*
 * Retrieve character's current wisdom.
 */
int get_curr_wis( CHAR_DATA *ch )
{
    int max;

	max = 25;

    return URANGE( 3, ch->perm_wis + ch->mod_wis, max );
}


/*
 * Retrieve character's current dexterity.
 */
int get_curr_dex( CHAR_DATA *ch )
{
    int max;

	max = 25;

    return URANGE( 3, ch->perm_dex + ch->mod_dex, max );
}



/*
 * Retrieve character's current constitution.
 */
int get_curr_con( CHAR_DATA *ch )
{
    int max;

	max = 25;

    return URANGE( 3, ch->perm_con + ch->mod_con, max );
}




/*
 * Retrieve a character's carry capacity.
 */
int can_carry_w( CHAR_DATA *ch )
{
    if ( IS_IMMORTAL(ch) || (IS_NPC(ch) && ch->pIndexData->pShop) )
	return 1000000;

    return str_app[get_curr_str(ch)].carry;
}


/*
 * Apply or remove an affect to a character.
 */
void affect_modify( CHAR_DATA *ch, AFFECT_DATA *paf, bool fAdd )
{
    OBJ_DATA *obj, *obj_next;
    int mod;
    static int depth;

    mod = paf->modifier;

    if ( fAdd )
    {
	SET_BIT( ch->affected_by, paf->bitvector );
    }
    else
    {
        OBJ_DATA *obj;

        REMOVE_BIT( ch->affected_by, paf->bitvector );
        SET_BIT(ch->affected_by, race_table[ch->race].affect_bits);

        /*
         * Make check if your wearing two affects of the same bitvector.
         */
        for ( obj = ch->carrying;   obj != NULL;  obj = obj->next_content )
        {
            AFFECT_DATA *af;

            if ( NOT_WORN(obj) )
             continue;

            for ( af = obj->affected; af != NULL;  af = af->next )
            {
                if (IS_SET( af->bitvector, paf->bitvector ) )
                SET_BIT(ch->affected_by, af->bitvector);
            }
        }

        mod = 0 - mod;
    }

    if ( IS_NPC(ch) )
	return;

    switch ( paf->location )
    {
    default:
        {
            int sn;

            if ( (sn = slot_lookup(paf->location)) <= 0 )
            {
                bug( "Affect_modify: unknown location %d.", paf->location );
                paf->location = APPLY_NONE;
                return;
            }

            PC(ch,learned[sn]) += mod;
        }
    break;
    case APPLY_NONE:                                   break;
    case APPLY_STR:           ch->mod_str      += mod; break;
    case APPLY_DEX:           ch->mod_dex      += mod; break;
    case APPLY_INT:           ch->mod_int      += mod; break;
    case APPLY_WIS:           ch->mod_wis      += mod; break;
    case APPLY_CON:           ch->mod_con      += mod; break;
    case APPLY_SEX:           ch->sex          += mod; break;
    case APPLY_AGE:           PC(ch,age)       += mod; break;
    case APPLY_SIZE:          ch->size         += mod; break;
    case APPLY_AC:            ch->armor        += mod; break;
    case APPLY_HITROLL:       ch->hitroll      += mod; break;
    case APPLY_DAMROLL:       ch->damroll      += mod; break;
    case APPLY_SAVING_THROW:  ch->saving_throw += mod; break;
    }

    if ( depth == 0 )    /* obj_from/to_char recurses */
    {
    depth++;
    for ( obj = ch->carrying;
          obj != NULL && can_carry_w( ch ) < ch->carry_weight;
          obj = obj_next )
    {
    obj_next = obj->next_content;
    
    act( "You drop $p.", ch, obj, NULL, TO_CHAR );
    act( "$n drops $p.", ch, obj, NULL, TO_ROOM );
    unequip_char( ch, obj );
    obj_from_char( obj );
    obj_to_room( obj, ch->in_room );
    }
    depth--;
    }
    return;
}



/*
 * Give an affect to a char.
 */
void affect_to_char( CHAR_DATA *ch, AFFECT_DATA *paf )
{
    AFFECT_DATA *paf_new;


    paf_new = new_affect( );

    *paf_new		= *paf;
    paf_new->next	= ch->affected;
    ch->affected	= paf_new;

    affect_modify( ch, paf_new, TRUE );
    return;
}



/*
 * Remove an affect from a char.
 */
void affect_remove( CHAR_DATA *ch, AFFECT_DATA *paf )
{
    if ( ch->affected == NULL )
    {
	bug( "Affect_remove: no affect.", 0 );
	return;
    }

    affect_modify( ch, paf, FALSE );

    if ( paf == ch->affected )
    {
	ch->affected	= paf->next;
    }
    else
    {
	AFFECT_DATA *prev;

	for ( prev = ch->affected; prev != NULL; prev = prev->next )
	{
	    if ( prev->next == paf )
	    {
		prev->next = paf->next;
		break;
	    }
	}

	if ( prev == NULL )
	{
	    bug( "Affect_remove: cannot find paf.", 0 );
	    return;
	}
    }

    free_affect( paf );
    return;
}



/*
 * Strip all affects of a given sn.
 */
void affect_strip( CHAR_DATA *ch, int sn )
{
    AFFECT_DATA *paf;
    AFFECT_DATA *paf_next;

    for ( paf = ch->affected; paf != NULL; paf = paf_next )
    {
	paf_next = paf->next;
	if ( paf->type == sn )
	    affect_remove( ch, paf );
    }

    return;
}



/*
 * Return true if a char is affected by a spell.
 */
bool is_affected( CHAR_DATA *ch, int sn )
{
    AFFECT_DATA *paf;

    for ( paf = ch->affected; paf != NULL; paf = paf->next )
    {
	if ( paf->type == sn )
	    return TRUE;
    }

    return FALSE;
}



/*
 * Add or enhance an affect.
 */
void affect_join( CHAR_DATA *ch, AFFECT_DATA *paf )
{
    AFFECT_DATA *paf_old;
    bool found;

    found = FALSE;
    for ( paf_old = ch->affected; paf_old != NULL; paf_old = paf_old->next )
    {
	if ( paf_old->type == paf->type )
	{
	    paf->duration += paf_old->duration;
	    paf->modifier += paf_old->modifier;
	    affect_remove( ch, paf_old );
	    break;
	}
    }

    affect_to_char( ch, paf );
    return;
}


/*
 * Move a char out of a room.
 */
void char_from_room( CHAR_DATA *ch )
{
    OBJ_DATA *obj;

    set_furn( ch, NULL );

    if ( ch->in_room == NULL )
    {
	bug( "Char_from_room: NULL.", 0 );
	return;
    }

    if ( !IS_NPC(ch) )
	--ch->in_room->area->nplayer;

    for ( obj = ch->carrying; obj != NULL;  obj = obj->next_content )
    {

    if ( obj->item_type == ITEM_LIGHT
      && IS_LIT(obj)
      && ch->in_room->light > 0 )    --ch->in_room->light;
    }

    if ( ch == ch->in_room->people )
    {
	ch->in_room->people = ch->next_in_room;
    }
    else
    {
	CHAR_DATA *prev;

	for ( prev = ch->in_room->people; prev; prev = prev->next_in_room )
	{
	    if ( prev->next_in_room == ch )
	    {
		prev->next_in_room = ch->next_in_room;
		break;
	    }
	}

	if ( prev == NULL )
	    bug( "Char_from_room: ch not found.", 0 );
    }

    ch->in_room      = NULL;
    ch->next_in_room = NULL;
    return;
}



/*
 * Move a char into a room.
 */
void char_to_room( CHAR_DATA *ch, ROOM_INDEX_DATA *pRoomIndex )
{
    OBJ_DATA *obj;

    if ( pRoomIndex == NULL )
    {
	bug( "Char_to_room: NULL.", 0 );
	return;
    }

    ch->in_room         = pRoomIndex;
    ch->next_in_room	= pRoomIndex->people;
    pRoomIndex->people	= ch;

    if ( !IS_NPC(ch) )
	++ch->in_room->area->nplayer;

    for ( obj = ch->carrying; obj != NULL;  obj = obj->next_content )
    {   
    if ( obj->item_type == ITEM_LIGHT && IS_LIT(obj) )   ++ch->in_room->light;
    }

    return;
}




/*
 * Move (intelligently) an object to a char.
 */
void obj_to_char_money( OBJ_DATA *obj, CHAR_DATA *ch )
{
    OBJ_DATA *fobj;

    if ( obj->item_type == ITEM_MONEY  )
    {
    for ( fobj = ch->carrying;  fobj != NULL; fobj = fobj->next_content )
    {
        if ( fobj->item_type == ITEM_CONTAINER )
        {
            OBJ_DATA *iobj;

            for ( iobj = fobj->contains; iobj != NULL; iobj = iobj->next_content )
            {
                if ( iobj->item_type == ITEM_MONEY )
                {
                    break;
                }
            }
            if ( iobj == NULL )
            continue;

            obj_to_obj( obj, fobj );
            merge_money_obj( fobj );
            return;
        }
    }

    if ( fobj == NULL )
    {
    for ( fobj = ch->carrying;  fobj != NULL; fobj = fobj->next_content )
    {
        if ( fobj->item_type == ITEM_CONTAINER )
        {
            obj_to_obj( obj, fobj );
            merge_money_obj( fobj );
            return;
        }
    }
    }
    }

    if ( obj->item_type == ITEM_LIGHT
    &&   IS_LIT(obj)
    &&   ch->in_room != NULL )
    ++ch->in_room->light;

    obj->next_content = ch->carrying;
    ch->carrying      = obj;
    obj->carried_by     = ch;
    obj->in_room        = NULL;
    obj->in_obj         = NULL;
    ch->carry_number   += get_obj_number( obj );
    ch->carry_weight   += get_obj_weight( obj );

}


/*
 * Give an obj to a char.
 */
void obj_to_char( OBJ_DATA *obj, CHAR_DATA *ch )
{
    if ( obj->item_type == ITEM_LIGHT
    &&   IS_LIT(obj)
    &&   ch->in_room != NULL )
    ++ch->in_room->light;

    obj->next_content = ch->carrying;
    ch->carrying      = obj;
    obj->carried_by     = ch;
    obj->in_room        = NULL;
    obj->in_obj         = NULL;
    ch->carry_number   += get_obj_number( obj );
    ch->carry_weight   += get_obj_weight( obj );
    REMOVE_BIT(obj->extra_flags, ITEM_USED);
    return;
}



/*
 * Take an obj from its character.
 */
void obj_from_char( OBJ_DATA *obj )
{
    CHAR_DATA *ch;

    if ( ( ch = obj->carried_by ) == NULL )
    {
	bug( "Obj_from_char: null ch.", 0 );
	return;
    }

    if ( (obj->wear_loc != WEAR_NONE
       && obj->wear_loc != WEAR_HOLD_1
       && obj->wear_loc != WEAR_HOLD_2
       && obj->wear_loc != WEAR_BELT_1
       && obj->wear_loc != WEAR_BELT_2
       && obj->wear_loc != WEAR_BELT_3
       && obj->wear_loc != WEAR_BELT_4
       && obj->wear_loc != WEAR_BELT_5)
      || IS_SET(obj->extra_flags,ITEM_USED) )        unequip_char( ch, obj );

    if ( ch->carrying == obj )
    {
	ch->carrying = obj->next_content;
    }
    else
    {
	OBJ_DATA *prev;

	for ( prev = ch->carrying; prev != NULL; prev = prev->next_content )
	{
	    if ( prev->next_content == obj )
	    {
		prev->next_content = obj->next_content;
		break;
	    }
	}

	if ( prev == NULL )
	    bug( "Obj_from_char: obj not in list.", 0 );
    }

    if ( obj->item_type == ITEM_LIGHT
    &&   IS_LIT(obj)
    &&   ch->in_room != NULL
    &&   ch->in_room->light > 0 )
    --ch->in_room->light;


    obj->carried_by	 = NULL;
    obj->next_content	 = NULL;
    ch->carry_number	-= get_obj_number( obj );
    ch->carry_weight	-= get_obj_weight( obj );
    return;
}




/*
 * Find the ac value of an obj, including position effect.
 */
int apply_ac( OBJ_DATA *obj, int iWear )
{
    if ( obj->item_type != ITEM_ARMOR )
	return 0;

    return obj->value[0];
}



/*
 * Get an object from a char using type referencing.
 */
OBJ_DATA *get_item_held( CHAR_DATA *ch, int itype )
{
    OBJ_DATA *obj;

    if ( ( obj = get_eq_char( ch, WEAR_HOLD_1 ) ) != NULL
        && obj->item_type == itype )
        return obj;

    if ( ( obj = get_eq_char( ch, WEAR_WIELD_1 ) ) != NULL
        && obj->item_type == itype )
        return obj;

    if ( ( obj = get_eq_char( ch, WEAR_HOLD_2 ) ) != NULL
        && obj->item_type == itype )
        return obj;

    if ( ( obj = get_eq_char( ch, WEAR_WIELD_2 ) ) != NULL
        && obj->item_type == itype )
        return obj;

    return NULL;
}


/*
 * Find a piece of eq on a character.
 */
OBJ_DATA *get_eq_char( CHAR_DATA *ch, int iWear )
{
    OBJ_DATA *obj;

    for ( obj = ch->carrying; obj != NULL; obj = obj->next_content )
    {
	if ( obj->wear_loc == iWear )
	    return obj;
    }

    return NULL;
}




/*
 *  Return if an object can be put in their hands (hands empty?)
 */
int hand_empty( CHAR_DATA *ch )
{
    OBJ_DATA *h1, *h2;

    h1 = get_eq_char( ch, WEAR_HOLD_1 );
    if ( h1 == NULL ) h1 = get_eq_char( ch, WEAR_WIELD_1 );
    h2 = get_eq_char( ch, WEAR_HOLD_2 );
    if ( h2 == NULL ) h2 = get_eq_char( ch, WEAR_WIELD_2 );

    if ( (h1 != NULL && IS_SET( h1->wear_flags, ITEM_TWO_HANDED ))
      || (h2 != NULL && IS_SET( h2->wear_flags, ITEM_TWO_HANDED )) )
            return WEAR_NONE;

    if ( h1 == NULL ) return WEAR_HOLD_1;
    if ( h2 == NULL ) return WEAR_HOLD_2;

    return WEAR_NONE;
}



/*
 * Return the denominator to the empty wield slot on a character.
 */
int wield_free( CHAR_DATA *ch, OBJ_DATA *obj )
{
    OBJ_DATA *h1, *h2;

    h1 = get_eq_char( ch, WEAR_HOLD_1 );
    if ( h1 == NULL ) h1 = get_eq_char( ch, WEAR_WIELD_1 );
    h2 = get_eq_char( ch, WEAR_HOLD_2 );
    if ( h2 == NULL ) h2 = get_eq_char( ch, WEAR_WIELD_2 );

    if ( (h1 != NULL 
        && IS_SET( h1->wear_flags, ITEM_TWO_HANDED ) 
        && h1->wear_loc == WEAR_WIELD_1)
      || (h2 != NULL 
        && IS_SET( h2->wear_flags, ITEM_TWO_HANDED ) 
        && h2->wear_loc == WEAR_WIELD_2) )
    return WEAR_NONE;

    if ( h1 == NULL || h1 == obj ) return WEAR_WIELD_1;
    if ( h2 == NULL || h2 == obj ) return WEAR_WIELD_2;

    return WEAR_NONE;
}


/*
 *  Return if an object can be put in their belt (hands empty?)
 */
int belt_empty( CHAR_DATA *ch )
{
    if ( get_eq_char( ch, WEAR_WAIST )  == NULL )        return WEAR_NONE;

    if ( get_eq_char( ch, WEAR_BELT_1 ) == NULL )        return WEAR_BELT_1;
    if ( get_eq_char( ch, WEAR_BELT_2 ) == NULL )        return WEAR_BELT_2;
    if ( get_eq_char( ch, WEAR_BELT_3 ) == NULL )        return WEAR_BELT_3;
    if ( get_eq_char( ch, WEAR_BELT_4 ) == NULL )        return WEAR_BELT_4;
    if ( get_eq_char( ch, WEAR_BELT_5 ) == NULL )        return WEAR_BELT_5;

    return WEAR_NONE;
}


/*
 * Unequip a char with an obj.
 */
bool unequip_char( CHAR_DATA *ch, OBJ_DATA *obj )
{
    AFFECT_DATA *paf;

    if ( (obj->wear_loc == WEAR_NONE) )
    {
        obj->wear_loc = hand_empty( ch );
        bug( "Unequip_char: From none to hand_empty(%d).", obj->wear_loc );
        return TRUE;
    }

    if ( (obj->wear_loc == WEAR_NONE
      || obj->wear_loc == WEAR_HOLD_1
      || obj->wear_loc == WEAR_HOLD_2
      || obj->wear_loc == WEAR_BELT_1
      || obj->wear_loc == WEAR_BELT_2
      || obj->wear_loc == WEAR_BELT_3
      || obj->wear_loc == WEAR_BELT_4
      || obj->wear_loc == WEAR_BELT_5)
      && !IS_SET(obj->extra_flags, ITEM_USED) )
    {
    bug( "Unequip_char: already unequipped.", 0 );
    return TRUE;
    }

    for ( paf = obj->pIndexData->affected; paf != NULL; paf = paf->next )
    affect_modify( ch, paf, FALSE );
    for ( paf = obj->affected; paf != NULL; paf = paf->next )
    affect_modify( ch, paf, FALSE );

    ch->armor       += obj->value[0];
    obj->wear_loc    = hand_empty( ch );
    REMOVE_BIT(obj->extra_flags, ITEM_USED);

    return TRUE;
}

/*
 * Equip a char with an obj.
 */
void equip_char( CHAR_DATA *ch, OBJ_DATA *obj, int iWear )
{
    AFFECT_DATA *paf;

    if ( (obj->wear_loc != WEAR_NONE
       && obj->wear_loc != WEAR_HOLD_1
       && obj->wear_loc != WEAR_HOLD_2
       && obj->wear_loc != WEAR_BELT_1
       && obj->wear_loc != WEAR_BELT_2
       && obj->wear_loc != WEAR_BELT_3
       && obj->wear_loc != WEAR_BELT_4
       && obj->wear_loc != WEAR_BELT_5)
      || IS_SET(obj->extra_flags, ITEM_USED)
      || get_eq_char( ch, iWear ) != NULL )
    {
        bug( "Equip_char: already equipped (%d).", iWear );
        return;
    }

    if ( iWear == WEAR_NONE
      || iWear == WEAR_HOLD_1
      || iWear == WEAR_HOLD_2
      || iWear == WEAR_BELT_1
      || iWear == WEAR_BELT_2
      || iWear == WEAR_BELT_3
      || iWear == WEAR_BELT_4
      || iWear == WEAR_BELT_5)
    {
       bug( "Equip_char: equipped how? (%d)", iWear );
       return;
    }

    for ( paf = obj->pIndexData->affected; paf != NULL; paf = paf->next )
	affect_modify( ch, paf, TRUE );
    for ( paf = obj->affected; paf != NULL; paf = paf->next )
	affect_modify( ch, paf, TRUE );

    ch->armor           -= obj->value[0];
    obj->wear_loc	 = iWear;
    SET_BIT(obj->extra_flags, ITEM_USED);

    return;
}


/*
 * Count occurrences of an obj in a list.
 */
int count_obj_list( OBJ_INDEX_DATA *pObjIndex, OBJ_DATA *list )
{
    OBJ_DATA *obj;
    int nMatch;

    nMatch = 0;
    for ( obj = list; obj != NULL; obj = obj->next_content )
    {
	if ( obj->pIndexData == pObjIndex )
	    nMatch++;
    }

    return nMatch;
}



/*
 * Move an obj out of a room.
 */
void obj_from_room( OBJ_DATA *obj )
{
    ROOM_INDEX_DATA *in_room;

    if ( ( in_room = obj->in_room ) == NULL )
    {
	bug( "obj_from_room: NULL.", 0 );
	return;
    }

    if ( obj == in_room->contents )
    {
	in_room->contents = obj->next_content;
    }
    else
    {
	OBJ_DATA *prev;

	for ( prev = in_room->contents; prev; prev = prev->next_content )
	{
	    if ( prev->next_content == obj )
	    {
		prev->next_content = obj->next_content;
		break;
	    }
	}

	if ( prev == NULL )
	{
	    bug( "Obj_from_room: obj not found.", 0 );
	    return;
	}
    }

    if ( obj->item_type == ITEM_LIGHT && IS_LIT(obj) )  --obj->in_room->light;

    obj->in_room      = NULL;
    obj->next_content = NULL;
    return;
}



/*
 * Move an obj into a room.
 */
void obj_to_room( OBJ_DATA *obj, ROOM_INDEX_DATA *pRoomIndex )
{
    if ( obj->item_type == ITEM_LIGHT && IS_LIT(obj) )  ++pRoomIndex->light;

    obj->next_content		= pRoomIndex->contents;
    pRoomIndex->contents	= obj;
    obj->in_room		= pRoomIndex;
    obj->carried_by		= NULL;
    obj->in_obj			= NULL;
    obj->wear_loc       = WEAR_NONE;

    return;
}



/*
 * Move an object into an object.
 */
void obj_to_obj( OBJ_DATA *obj, OBJ_DATA *obj_to )
{
    obj->next_content   = obj_to->contains;
    obj_to->contains    = obj;
    obj->in_obj			= obj_to;
    obj->in_room		= NULL;
    obj->carried_by		= NULL;
    obj->wear_loc       = WEAR_NONE;

    for ( ; obj_to != NULL; obj_to = obj_to->in_obj )
    {
	if ( obj_to->carried_by != NULL )
	{
	    obj_to->carried_by->carry_number += get_obj_number( obj );
	    obj_to->carried_by->carry_weight += get_obj_weight( obj );
	}
    }

    return;
}



/*
 * Move an object out of an object.
 */
void obj_from_obj( OBJ_DATA *obj )
{
    OBJ_DATA *obj_from;

    if ( ( obj_from = obj->in_obj ) == NULL )
    {
	bug( "Obj_from_obj: null obj_from.", 0 );
	return;
    }

    if ( obj == obj_from->contains )
    {
	obj_from->contains = obj->next_content;
    }
    else
    {
	OBJ_DATA *prev;

	for ( prev = obj_from->contains; prev; prev = prev->next_content )
	{
	    if ( prev->next_content == obj )
	    {
		prev->next_content = obj->next_content;
		break;
	    }
	}

	if ( prev == NULL )
	{
	    bug( "Obj_from_obj: obj not found.", 0 );
	    return;
	}
    }

    obj->next_content = NULL;
    obj->in_obj       = NULL;

    for ( ; obj_from != NULL; obj_from = obj_from->in_obj )
    {
	if ( obj_from->carried_by != NULL )
	{
	    obj_from->carried_by->carry_number -= get_obj_number( obj );
	    obj_from->carried_by->carry_weight -= get_obj_weight( obj );
	}
    }

    return;
}



/*
 * Extract an obj from the world.
 */
void extract_obj( OBJ_DATA *obj )
{
    OBJ_DATA *obj_content;
    OBJ_DATA *obj_next;
    extern OBJ_DATA *obj_free;
    VARIABLE_DATA *pVar;
    VARIABLE_DATA *pVar_next;

    {
        CHAR_DATA *mob;

        for ( mob = char_list;  mob != NULL; mob = mob->next )
        {
            if ( mob->furniture == obj )
            mob->furniture = NULL;

            if ( mob->hitched_to == obj )
            mob->hitched_to = NULL;
        }
    }

    for ( pVar = mud_var_list;  pVar != NULL;  pVar = pVar_next )
    {
        pVar_next = pVar->next;
        if ( pVar->type == TYPE_OBJ && (OBJ_DATA *)pVar->value == obj )
        {
            pVar->type  = TYPE_STRING;
            pVar->value = str_dup( "" );
        }
    }


    if ( obj->in_room != NULL )    obj_from_room( obj );
    if ( obj->carried_by != NULL ) obj_from_char( obj );
    if ( obj->in_obj != NULL )     obj_from_obj( obj );

    for ( obj_content = obj->contains; obj_content; obj_content = obj_next )
    {
	obj_next = obj_content->next_content;
	extract_obj( obj->contains );
    }

    if ( object_list == obj )
    {
	object_list = obj->next;
    }
    else
    {
	OBJ_DATA *prev;

	for ( prev = object_list; prev != NULL; prev = prev->next )
	{
	    if ( prev->next == obj )
	    {
		prev->next = obj->next;
		break;
	    }
	}

	if ( prev == NULL )
	{
	    bug( "Extract_obj: obj %d not found.", obj->pIndexData->vnum );
	    return;
	}
    }

    {
	AFFECT_DATA *paf;
	AFFECT_DATA *paf_next;

	for ( paf = obj->affected; paf != NULL; paf = paf_next )
	{
	    paf_next    = paf->next;

        free_affect( paf );
	}
    }

    {
	EXTRA_DESCR_DATA *ed;
	EXTRA_DESCR_DATA *ed_next;

	for ( ed = obj->extra_descr; ed != NULL; ed = ed_next )
	{
	    ed_next		= ed->next;

        free_extra_descr( ed );
	}
    }

    free_string( obj->name        );
    free_string( obj->description );
    free_string( obj->description_plural );
    free_string( obj->short_descr );
    free_string( obj->short_descr_plural );
    free_string( obj->action_descr );
    free_string( obj->real_description );
    --obj->pIndexData->count;
    obj->next	= obj_free;
    obj_free	= obj;
    return;
}



/*
 * Extract a char from the world.
 */
void extract_char( CHAR_DATA *ch, bool fPull )
{
    CHAR_DATA *wch;
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    VARIABLE_DATA *pVar;
    VARIABLE_DATA *pVar_next;

    if ( ch->in_room == NULL )
    {
	bug( "Extract_char: NULL.", 0 );
	return;
    }

    if ( fPull )
    {
        CHAR_DATA *pet;
        CHAR_DATA *pet_next;

        for ( pet = char_list; pet != NULL; pet = pet_next )
        {
            pet_next = pet->next;
            if ( ch != pet
              && ( pet->master == ch )
              && IS_SET(pet->act, ACT_PET) )
            extract_char( pet, TRUE );
        }
    }

    for ( pVar = mud_var_list;  pVar != NULL;  pVar = pVar_next )
    {
        pVar_next = pVar->next_mud_var;
        if ( pVar->type == TYPE_MOB && (CHAR_DATA *)pVar->value == ch )
        {
            pVar->type  = TYPE_STRING;
            pVar->value = str_dup( "" );
        }
    }

    if ( ch->haggling != NULL )
    {
        if ( ch->haggling->carried_by == NULL )
        extract_obj( ch->haggling );
        ch->haggling = NULL;
    }

    if ( fPull )
	die_follower( ch );

    stop_fighting( ch, TRUE );

    for ( obj = ch->carrying; obj != NULL; obj = obj_next )
    {
	obj_next = obj->next_content;
	extract_obj( obj );
    }
    
    char_from_room( ch );
    
    if ( ch->riding != NULL )
    {
       ch->riding->rider = NULL;
       ch->riding             = NULL;
    }
    
    if ( ch->rider != NULL )
    {
       ch->rider->riding = NULL;
       ch->rider         = NULL;
    }
    
    if ( !IS_NPC(ch) )
        PC(ch,condition)[COND_THIRST] = 100;

    
    if ( !fPull )
    {
    char_to_room( ch, get_room_index( ROOM_VNUM_DEATH ) );
    do_look( ch, "auto" );
	return;
    }

    if ( IS_NPC(ch) )
	--ch->pIndexData->count;

    if ( ch->desc != NULL && ch->desc->original != NULL )
	do_return( ch, "" );

    if ( ch->desc != NULL ) ch->desc->snoop_by = NULL;


    if ( ch == char_list )
    {
       char_list = ch->next;
    }
    else
    {
	CHAR_DATA *prev;

	for ( prev = char_list; prev != NULL; prev = prev->next )
	{
	    if ( prev->next == ch )
	    {
		prev->next = ch->next;
		break;
	    }
	}

	if ( prev == NULL )
	{
	    bug( "Extract_char: char not found.", 0 );
	    return;
	}
    }

    for ( wch = mount_list;  wch != NULL;  wch = wch->next )
    {
        if ( wch->master != ch )
        continue;

        if ( wch == mount_list )
        {
            mount_list = mount_list->next;
        }
        else
        {
            CHAR_DATA *prev;

            for ( prev = mount_list; prev != NULL; prev = prev->next )
            {
                if ( prev->next == wch )
                {
                    prev->next = wch->next;
                    break;
                }
            }

            if ( prev == NULL && wch->next != NULL )
            {
                bug( "Extract_char: mount not found.", 0 );
                return;
            }
        }

        wch->in_room = NULL;
        free_char( wch );
    }

    if ( ch->desc )
	ch->desc->character = NULL;
    free_char( ch );
    return;
}



/*
 * Find a char in the room.
 */
CHAR_DATA *get_char_room( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *rch;
    int number;
    int count;

    number = number_argument( argument, arg );
    count  = 0;

    if ( !str_cmp( arg, "self" ) || !str_cmp( arg, "me" ) )
	return ch;

    if ( !str_cmp( arg, "mount" ) )
    return ch->riding;

    for ( rch = ch->in_room->people; rch != NULL; rch = rch->next_in_room )
    {
        if ( ch == rch && count <= 1 )
        continue;
        
        if ( !can_see( ch, rch ) )
        continue;

        if ( !is_name( arg, STR(rch, name) ) )
        {
            if ( !IS_NPC(rch) && is_name( arg, rch->keywords ) )
            ;
            else continue;
        }

        if ( ++count == number )
            return rch;
    }
    
    if ( !is_name( arg, STR(ch, name) ) )
    {
        if ( !IS_NPC(ch) && is_name( arg, ch->keywords ) )
        return ch;
    }   

    return NULL;
}




/*
 * Find a char in the world.
 */
CHAR_DATA *get_char_world( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *wch;
    int number;
    int count;

    if ( ( wch = get_char_room( ch, argument ) ) != NULL )
	return wch;

    number = number_argument( argument, arg );
    count  = 0;
    for ( wch = char_list; wch != NULL ; wch = wch->next )
    {
        if ( !can_see( ch, wch ) )
        continue;

        if ( !is_name( arg, STR(wch, name) ) )
        {
            if ( !IS_NPC(wch) && is_name( arg, wch->keywords ) )
            ;
            else continue;
        }

        if ( ++count == number )
            return wch;
    }

    return NULL;
}



/*
 * Find some object with a given index data.
 * Used by area-reset 'P' command.
 */
OBJ_DATA *get_obj_type( OBJ_INDEX_DATA *pObjIndex )
{
    OBJ_DATA *obj;

    for ( obj = object_list; obj != NULL; obj = obj->next )
    {
	if ( obj->pIndexData == pObjIndex )
	    return obj;
    }

    return NULL;
}



      
/*
 * Return # of objects which an object counts as.
 * Thanks to Tony Chamberlain for the correct recursive code here.
 */
int get_obj_number( OBJ_DATA *obj )
{
    int number;

    if ( obj->item_type == ITEM_CONTAINER )
	number = 0;
    else
	number = 1;

    for ( obj = obj->contains; obj != NULL; obj = obj->next_content )
	number += get_obj_number( obj );

    return number;
}



/*
 * Return weight of an object, including weight of contents.
 * Danger: Recursion ahead.
 */
int get_obj_weight( OBJ_DATA *obj )
{
    int weight;

    weight = obj->weight;
    if ( obj->item_type == ITEM_DRINK_CON )
    weight += obj->value[0]/10;

    for ( obj = obj->contains; obj != NULL; obj = obj->next_content )
	weight += get_obj_weight( obj );

    return weight;
}



/*
 * True if room is dark.
 */
int room_is_dark( ROOM_INDEX_DATA *pRoomIndex )
{
    if ( pRoomIndex == NULL ) return FALSE;

    /*
     * Someone gotta light?
     */
    if ( pRoomIndex->light > 0 )
    return FALSE;

    /*
     * Is it supposed to be dark here?
     */
    if ( IS_SET(pRoomIndex->room_flags, ROOM_DARK) )
    return TRUE;

    /*
     * Are we inside?
     */
    if ( pRoomIndex->sector_type == SECT_INSIDE )
    return FALSE;

    /*
     * If it is daylight.
     */
    if ( weather_info.sunlight == SUN_RISE
      || weather_info.sunlight == SUN_LIGHT )
    return FALSE;

    /*
     * If the moon is out and you're in the city or a field.
     */
    if ( weather_info.sunlight == MOON_RISE
      && weather_info.sky == SKY_CLOUDLESS
      && (pRoomIndex->sector_type == SECT_FIELD
       || pRoomIndex->sector_type == SECT_CITY) )
    return FALSE;

    /* 
     * If the sky is cloudy and you're in the forest..
     */
    if ( weather_info.sky != SKY_CLOUDLESS
      && pRoomIndex->sector_type == SECT_FOREST )
    return TRUE;
 

    return FALSE;
}



/*
 * True if room is private.
 */
bool room_is_private( ROOM_INDEX_DATA *pRoomIndex )
{
    CHAR_DATA *rch;
    int count;

    if ( pRoomIndex->max_people == 0 )
    return FALSE;

    count = 0;
    for ( rch = pRoomIndex->people; rch != NULL; rch = rch->next_in_room )
	count++;

    if ( count >= pRoomIndex->max_people )
	return TRUE;

    return FALSE;
}



/*
 * True if char can see victim.
 */
bool can_see( CHAR_DATA *ch, CHAR_DATA *victim )
{
    if ( ch == victim )
	return TRUE;
    
    if ( !IS_NPC(ch) && IS_SET(ch->act2, WIZ_HOLYLIGHT) )
	return TRUE;

    if ( IS_AFFECTED(ch, AFF_BLIND) )
	return FALSE;

    if ( room_is_dark( ch->in_room ) && !IS_AFFECTED(ch, AFF_INFRARED) )
	return FALSE;

/*
    if ( IS_NPC(ch) && HAS_SCRIPT(ch) && !IS_SET(ch->act, ACT_AGGRESSIVE ) )
    return TRUE;
 */

    if ( IS_AFFECTED(victim, AFF_INVISIBLE)
    &&   !IS_AFFECTED(ch, AFF_DETECT_INVIS) )
	return FALSE;

    if ( IS_AFFECTED(victim, AFF_HIDE)
    &&   !IS_AFFECTED(ch, AFF_DETECT_HIDDEN)
    &&   victim->fighting == NULL
    &&   ( IS_NPC(ch) ? !IS_NPC(victim) : IS_NPC(victim) ) )
	return FALSE;

    if (  get_trust( ch ) < GET_PC(victim,wizinvis,0)
       && get_trust( ch ) < get_trust( victim ) )
    return FALSE;

    return TRUE;
}



/*
 * True if char can see obj.
 */
bool can_see_obj( CHAR_DATA *ch, OBJ_DATA *obj )
{
    if ( !IS_NPC(ch) && IS_SET(ch->act2, WIZ_HOLYLIGHT) )
	return TRUE;

    if ( IS_AFFECTED( ch, AFF_BLIND ) )
    return FALSE;

    if ( IS_SET( obj->extra_flags, ITEM_BURNING ) )
    return TRUE;

    if ( obj->item_type == ITEM_LIGHT && IS_LIT( obj ) )
	return TRUE;

    if ( room_is_dark( ch->in_room ) && !IS_AFFECTED(ch, AFF_INFRARED) )
	return FALSE;

    if ( IS_SET(obj->extra_flags, ITEM_INVIS)
    &&   !IS_AFFECTED(ch, AFF_DETECT_INVIS) )
	return FALSE;

    return TRUE;
}



/*
 * True if char can drop obj.
 */
bool can_drop_obj( CHAR_DATA *ch, OBJ_DATA *obj )
{
    if ( !IS_SET(obj->extra_flags, ITEM_NODROP) )
	return TRUE;

    if ( IS_IMMORTAL(ch) )
	return TRUE;

    if ( NOT_WORN( obj ) )
    return TRUE;

    return FALSE;
}


/*
 * Get an extra description from a list.
 */
char *get_extra_descr( const char *name, EXTRA_DESCR_DATA *ed )
{
    for ( ; ed != NULL; ed = ed->next )
    {
	if ( is_name( name, ed->keyword ) )
        return ed->description;
    }
    return NULL;
}



/*
 * Use up some of a tool.
 */
bool use_tool( OBJ_DATA *obj, int bit )
{
    if ( obj == NULL
      || obj->item_type != ITEM_TOOL
      || !VAL_SET(obj, 0, bit) )
    return FALSE;

    if ( obj->value[1] <= 0 )
    return FALSE;

    obj->value[1]--;
    return TRUE;
}



/*
 * Find a percentage, with error checking.
 */
int PERCENTAGE( int amount, int max )
{
    if (max > 0) return (amount*100)/max;

    return amount*100;
}



/*
 * Check for a skill.
 */
bool skill_check( CHAR_DATA *ch, int sn, int modifier )
{
    int level;

    /* Reset last used time */
    if ( !IS_NPC(ch) )
	PC(ch, last_used)[sn] = 0;

    if ( modifier == 0 ) modifier = 100;
    
    level = LEARNED(ch,sn) > 0 ?
            INTERPOLATE(0, modifier, LEARNED(ch,sn)) : 0;

    if( URANGE(0, level, 100) > number_percent( ) )
    {
	/* Improvement by use chance 0% ... 4% */
    if ( ((4 - int_app[get_curr_int(ch)].learn)/4)+1 >=number_range(1,100))
        advance_skill( ch, sn, number_range(1,skill_table[sn].max_prac),0);
	return TRUE;
    }
    else
    {
	/* Learn from mistakes 0% ... 3% */
    if ( ((2 - int_app[get_curr_int(ch)].learn)/4)+1 >= number_range(1,100) )
        advance_skill( ch, sn, number_range(1,skill_table[sn].max_prac),0);
	return FALSE;
    }
}


/*
 * Check the wield weight of a mobile, for quick equations.
 */
int wield_weight( CHAR_DATA *ch )
{
    int weight;
    OBJ_DATA *w1, *w2, *sh;

    w1 = get_eq_char(ch, WEAR_WIELD_1);
    w2 = get_eq_char(ch, WEAR_WIELD_2);
    sh = get_eq_char(ch, WEAR_SHIELD);

    weight = 0;
    if ( w1 ) weight += w1->weight;
    if ( w2 ) weight += w2->weight;
    if ( sh ) weight += sh->weight;

    return weight;
}

