/***************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "script.h"



bool	check_social	args( ( CHAR_DATA *ch, char *command,
			    char *argument ) );



/*
 * Command logging types.
 */
#define LOG_NORMAL	0
#define LOG_ALWAYS	1
#define LOG_NEVER	2



/*
 * Log-all switch.
 */
bool				fLogAll		= FALSE;



/*
 * Command table.
 */
const	struct	cmd_type	cmd_table	[] =
{
    /*
     * Common movement commands.
     */
    { "north",      do_north,         POS_FIGHTING,          0,  LOG_NORMAL },
    { "east",       do_east,          POS_FIGHTING,          0,  LOG_NORMAL },
    { "south",      do_south,         POS_FIGHTING,          0,  LOG_NORMAL },
    { "west",       do_west,          POS_FIGHTING,          0,  LOG_NORMAL },
    { "up",         do_up,            POS_FIGHTING,          0,  LOG_NORMAL },
    { "down",       do_down,          POS_FIGHTING,          0,  LOG_NORMAL },
    { "northwest",  do_nw,            POS_FIGHTING,          0,  LOG_NORMAL },
    { "northeast",  do_ne,            POS_FIGHTING,          0,  LOG_NORMAL },
    { "southwest",  do_sw,            POS_FIGHTING,          0,  LOG_NORMAL },
    { "southeast",  do_se,            POS_FIGHTING,          0,  LOG_NORMAL },
    { "nw",         do_nw,            POS_FIGHTING,          0,  LOG_NORMAL },
    { "ne",         do_ne,            POS_FIGHTING,          0,  LOG_NORMAL },
    { "sw",         do_sw,            POS_FIGHTING,          0,  LOG_NORMAL },
    { "se",         do_se,            POS_FIGHTING,          0,  LOG_NORMAL },
    { "go",         do_enter,         POS_FIGHTING,          0,  LOG_NORMAL },

    /*
     * Common other commands.
     * Placed here so one and two letter abbreviations work.
     */
    { "buy",        do_buy,           POS_RESTING,           0,  LOG_NORMAL  },
    { "exits",      do_exits,         POS_RESTING,           0,  LOG_NORMAL  },
    { "get",        do_get,           POS_RESTING,           0,  LOG_NORMAL  },
    { "inventory",  do_inventory,     POS_DEAD,              0,  LOG_NORMAL  },
    { "engage",     do_kill,          POS_FIGHTING,          0,  LOG_NORMAL  },
    { "look",       do_look,          POS_RESTING,           0,  LOG_NORMAL  },
    { "examine",    do_look,          POS_RESTING,           0,  LOG_NORMAL  },
    { "order",      do_order,         POS_RESTING,           0,  LOG_NORMAL  },
    { "rest",       do_rest,          POS_RESTING,           0,  LOG_NORMAL  },
    { "sit",        do_sit,           POS_SLEEPING,          0,  LOG_NORMAL  },
    { "stand",      do_stand,         POS_SLEEPING,          0,  LOG_NORMAL  },
    { "sheathe",    do_sheath,        POS_RESTING,           0,  LOG_NORMAL  },
    { "shoot",      do_shoot,         POS_STANDING,          0,  LOG_NORMAL  },
    { "wield",      do_wield,         POS_RESTING,           0,  LOG_NORMAL  },

    /*
     *  Racial commands.
     */

    /*
     * Informational commands.
     */
    { "bug",            do_bug,          POS_DEAD,        0,  LOG_NORMAL     },
    { "commands",       do_commands,     POS_DEAD,        0,  LOG_NORMAL     },
    { "compare",        do_compare,      POS_RESTING,     0,  LOG_NORMAL     },
    { "credits",        do_credits,      POS_DEAD,        0,  LOG_NORMAL     },
    { "equipment",      do_equipment,    POS_DEAD,        0,  LOG_NORMAL     },
    { "help",           do_help,         POS_DEAD,        0,  LOG_NORMAL     },
    { "idea",           do_idea,         POS_DEAD,        0,  LOG_NORMAL     },
    { "report",         do_report,       POS_DEAD,        0,  LOG_NORMAL     },
    { "score",          do_score,        POS_DEAD,        0,  LOG_NORMAL     },
    { "socials",        do_socials,      POS_DEAD,        0,  LOG_NORMAL     },
    { "skills",         do_skills,       POS_DEAD,        0,  LOG_NORMAL     },
    { "time",           do_time,         POS_DEAD,        0,  LOG_NORMAL     },
    { "typo",           do_typo,         POS_DEAD,        0,  LOG_NORMAL     },
    { "who",            do_who,          POS_DEAD,        0,  LOG_NORMAL     },
    { "wizlist",        do_wizlist,      POS_DEAD,        0,  LOG_NORMAL     },
                    
    /*
     * Configuration commands.
     */
    { "set",            do_config,       POS_DEAD,        0,  LOG_NORMAL     },

    { "compact",        do_compact,      POS_DEAD,        0,  LOG_NORMAL     },
    { "brief",          do_brief,        POS_DEAD,        0,  LOG_NORMAL     },
    { "blank",          do_blank,        POS_DEAD,        0,  LOG_NORMAL     },
    { "ansi",           do_ansi,         POS_DEAD,        0,  LOG_NORMAL     },
    { "color",          do_ansi,         POS_DEAD,        0,  LOG_NORMAL     },
    { "pager",          do_pager,        POS_DEAD,        0,  LOG_NORMAL     },
    { "prompt",         do_prompt,       POS_DEAD,        0,  LOG_NORMAL     },

    { "clear",          do_clear,        POS_DEAD,        0,  LOG_NORMAL     },

    { "password",       do_password,     POS_DEAD,        0,  LOG_NEVER      },

    /*
     * Communication commands.
     */
    { "emote",        do_emote,       POS_RESTING,           0,  LOG_NORMAL  },
    { ":",            do_emote,       POS_RESTING,           0,  LOG_NORMAL  },
    { "note",         do_note,        POS_RESTING,           0,  LOG_NORMAL  },
    { "say",          do_say,         POS_RESTING,           0,  LOG_NORMAL  },
    { "talk",         do_talk,        POS_RESTING,           0,  LOG_NORMAL  },
    { "ooc",          do_ooc,         POS_RESTING,           0,  LOG_NORMAL  },
    { "'",            do_say,         POS_RESTING,           0,  LOG_NORMAL  },
    { "\"",           do_say,         POS_RESTING,           0,  LOG_NORMAL  },
    { "shout",        do_shout,       POS_RESTING,           0,  LOG_NORMAL  },
    { "speak",        do_speak,       POS_DEAD,              0,  LOG_NORMAL  },
    { "contact",      do_contact,     POS_RESTING,           0,  LOG_NORMAL  },
    { "wish",         do_wish,        POS_RESTING,           0,  LOG_NORMAL  },
    { "smote",        do_smote,       POS_RESTING,           0,  LOG_NORMAL  },


    /*
     * Object manipulation commands.
     */
    { "brandish",     do_brandish,    POS_RESTING,           0,  LOG_NORMAL  },
    { "close",        do_close,       POS_RESTING,           0,  LOG_NORMAL  },
    { "dump",         do_dump,        POS_RESTING,           0,  LOG_NORMAL  },
    { "drag",         do_drag,        POS_RESTING,           0,  LOG_NORMAL  },
    { "draw",         do_draw,        POS_RESTING,           0,  LOG_NORMAL  },
    { "drink",        do_drink,       POS_RESTING,           0,  LOG_NORMAL  },
    { "drop",         do_drop,        POS_RESTING,           0,  LOG_NORMAL  },
    { "eat",          do_eat,         POS_RESTING,           0,  LOG_NORMAL  },
    { "extinguish",   do_extinguish,  POS_RESTING,           0,  LOG_NORMAL  },
    { "fill",         do_fill,        POS_RESTING,           0,  LOG_NORMAL  },
    { "give",         do_give,        POS_RESTING,           0,  LOG_NORMAL  },
    { "hold",         do_hold,        POS_RESTING,           0,  LOG_NORMAL  },
    { "light",        do_light,       POS_RESTING,           0,  LOG_NORMAL  },
    { "list",         do_list,        POS_RESTING,           0,  LOG_NORMAL  },
    { "lock",         do_lock,        POS_RESTING,           0,  LOG_NORMAL  },
    { "open",         do_open,        POS_RESTING,           0,  LOG_NORMAL  },
    { "pick",         do_pick,        POS_RESTING,           0,  LOG_NORMAL  },
    { "pour",         do_pour,        POS_RESTING,           0,  LOG_NORMAL  },
    { "put",          do_put,         POS_RESTING,           0,  LOG_NORMAL  },
    { "quaff",        do_quaff,       POS_RESTING,           0,  LOG_NORMAL  },
    { "recite",       do_recite,      POS_RESTING,           0,  LOG_NORMAL  },
    { "remove",       do_remove,      POS_RESTING,           0,  LOG_NORMAL  },
    { "reload",       do_reload,      POS_RESTING,           0,  LOG_NORMAL  },
    { "sell",         do_sell,        POS_RESTING,           0,  LOG_NORMAL  },
    { "swap",         do_swap,        POS_RESTING,           0,  LOG_NORMAL  },
    { "take",         do_get,         POS_RESTING,           0,  LOG_NORMAL  },
    { "unlock",       do_unlock,      POS_RESTING,           0,  LOG_NORMAL  },
    { "wear",         do_wear,        POS_RESTING,           0,  LOG_NORMAL  },
    { "zap",          do_zap,         POS_RESTING,           0,  LOG_NORMAL  },

    /*
     * Combat commands.
     */
    { "backstab",     do_backstab,    POS_STANDING,          0,  LOG_NORMAL  },
    { "bs",           do_backstab,    POS_STANDING,          0,  LOG_NORMAL  },
/*    { "disarm",       do_disarm,      POS_FIGHTING,          0,  LOG_NORMAL  },*/
    { "flee",         do_flee,        POS_FIGHTING,          0,  LOG_NORMAL  },
/*    { "kick",         do_kick,        POS_FIGHTING,          0,  LOG_NORMAL  },*/
    { "rescue",       do_rescue,      POS_FIGHTING,          0,  LOG_NORMAL  },
    { "retreat",      do_retreat,     POS_FIGHTING,          0,  LOG_NORMAL  },
    { "fight",        do_fight,       POS_FIGHTING,          0,  LOG_NORMAL  },

    /*
     * Miscellaneous commands.
     */
    { "dismount",       do_dismount,  POS_RESTING,           0,  LOG_NORMAL  },
    { "follow",         do_follow,    POS_RESTING,           0,  LOG_NORMAL  },
    { "peek",           do_peek,      POS_DEAD,              0,  LOG_NORMAL  },

    { "hide",           do_hide,      POS_RESTING,           0,  LOG_NORMAL  },
    { "hitch",          do_hitch,     POS_STANDING,          0,  LOG_NORMAL  },
    { "ride",           do_mount,     POS_STANDING,          0,  LOG_NORMAL  },
    { "mount",          do_mount,     POS_STANDING,          0,  LOG_NORMAL  },

    { "learn",          do_learn,     POS_SLEEPING,          0,  LOG_NORMAL  },
    { "practice",       do_practice,  POS_SLEEPING,          0,  LOG_NORMAL  },
    { "qui",            do_qui,             -1,             -1,  LOG_NORMAL  },
    { "quit",           do_quit,      POS_DEAD,              0,  LOG_NORMAL  },
    { "save",           do_save,      POS_DEAD,              0,  LOG_NORMAL  },
    { "sleep",          do_sleep,     POS_SLEEPING,          0,  LOG_NORMAL  },
    { "sneak",          do_sneak,     POS_STANDING,          0,  LOG_NORMAL  },
    { "steal",          do_steal,     POS_STANDING,          0,  LOG_NORMAL  },
    { "track",          do_track,     POS_STANDING,          0,  LOG_NORMAL  },
    { "train",          do_practice,  POS_RESTING,           0,  LOG_NORMAL  },
    { "unhitch",        do_unhitch,   POS_STANDING,          0,  LOG_NORMAL  },
    { "wake",           do_wake,      POS_SLEEPING,          0,  LOG_NORMAL  },
    { "enter",      do_enter,         POS_FIGHTING,          0,  LOG_NORMAL  },
    { "leave",      do_leave,         POS_FIGHTING,          0,  LOG_NORMAL  },



    /*
     * Immortal commands.  Sorted by level for wizhelp.
     */
    { "advance",        do_advance,   POS_DEAD,     MAX_LEVEL,   LOG_ALWAYS  },
    { "shell",          do_shell,     POS_DEAD,     MAX_LEVEL,   LOG_ALWAYS  },

    { "aedit",          do_aedit,     POS_DEAD,  LEVEL_DEMIGOD,  LOG_NORMAL  },
    { "shutdow",        do_shutdow,         -1,  LEVEL_DEMIGOD,  LOG_NORMAL  },
    { "shutdown",       do_shutdown,  POS_DEAD,  LEVEL_DEMIGOD,  LOG_ALWAYS  },
    { "allow",          do_allow,     POS_DEAD,  LEVEL_DEMIGOD,  LOG_ALWAYS  },
    { "ban",            do_ban,       POS_DEAD,  LEVEL_DEMIGOD,  LOG_ALWAYS  },
    { "deny",           do_deny,      POS_DEAD,  LEVEL_DEMIGOD,  LOG_ALWAYS  },
    { "oset",           do_oset,      POS_DEAD,  LEVEL_DEMIGOD,  LOG_ALWAYS  },
    { "mset",           do_mset,      POS_DEAD,  LEVEL_DEMIGOD,  LOG_ALWAYS  },
    { "sset",           do_sset,      POS_DEAD,  LEVEL_DEMIGOD,  LOG_ALWAYS  },
    { "log",            do_log,       POS_DEAD,  LEVEL_DEMIGOD,  LOG_ALWAYS  },
    { "global",         do_global,    POS_DEAD,  LEVEL_DEMIGOD,  LOG_NORMAL  },

    { "discon",         do_disconnect,POS_DEAD,  LEVEL_SUPREME,  LOG_ALWAYS  },
    { "freeze",         do_freeze,    POS_DEAD,  LEVEL_SUPREME,  LOG_ALWAYS  },
    { "reboo",          do_reboo,           -1,  LEVEL_SUPREME,  LOG_NORMAL  },
    { "reboot",         do_reboot,    POS_DEAD,  LEVEL_SUPREME,  LOG_ALWAYS  },
    { "wizlock",        do_wizlock,   POS_DEAD,  LEVEL_SUPREME,  LOG_ALWAYS  },
    { "force",          do_force,     POS_DEAD,  LEVEL_SUPREME,  LOG_ALWAYS  },
    { "noemote",        do_noemote,   POS_DEAD,  LEVEL_SUPREME,  LOG_NORMAL  },
    { "sla",            do_sla,             -1,  LEVEL_SUPREME,  LOG_NORMAL  },
    { "slay",           do_slay,      POS_DEAD,  LEVEL_SUPREME,  LOG_ALWAYS  },
    { "sockets",        do_sockets,   POS_DEAD,  LEVEL_SUPREME,  LOG_NORMAL  },
    { "at",             do_at,        POS_DEAD,  LEVEL_SUPREME,  LOG_NORMAL  },
    { "echo",           do_echo,      POS_DEAD,  LEVEL_SUPREME,  LOG_NORMAL  },
    { "return",         do_return,    POS_DEAD,  LEVEL_SUPREME,  LOG_NORMAL  },
    { "snoop",          do_snoop,     POS_DEAD,  LEVEL_SUPREME,  LOG_NORMAL  },
    { "switch",         do_switch,    POS_DEAD,  LEVEL_SUPREME,  LOG_ALWAYS  },
    { "comlist",        do_comlist,   POS_DEAD,  LEVEL_SUPREME,  LOG_NORMAL  },

    { "terrain",        do_terrain,   POS_DEAD,    LEVEL_ANGEL,  LOG_NORMAL  },
    { "sedit",          do_sedit,     POS_DEAD,    LEVEL_ANGEL,  LOG_NORMAL  },
    { "bounty",         do_bounty,    POS_DEAD,    LEVEL_ANGEL,  LOG_ALWAYS  },
    { "peace",          do_peace,     POS_DEAD,    LEVEL_ANGEL,  LOG_NORMAL  },
    { "recho",          do_recho,     POS_DEAD,    LEVEL_ANGEL,  LOG_NORMAL  },
    { "system",         do_system,    POS_DEAD,    LEVEL_ANGEL,  LOG_ALWAYS  },
    { "cload",          do_charload,  POS_DEAD,    LEVEL_ANGEL,  LOG_NORMAL  },

    { "resets",         do_resets,    POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "redit",          do_redit,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "oedit",          do_oedit,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "medit",          do_medit,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "mobile",         do_mindex,    POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "object",         do_oindex,    POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "room",           do_rstat,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "mload",          do_mload,     POS_DEAD,  LEVEL_BUILDER,  LOG_ALWAYS  },
    { "oload",          do_oload,     POS_DEAD,  LEVEL_BUILDER,  LOG_ALWAYS  },
    { "stat",           do_stat,      POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "astat",          do_astat,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "asave",          do_asave,     POS_DEAD,  LEVEL_BUILDER,  LOG_ALWAYS  },
    { "rfind",          do_rfind,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "ofind",          do_ofind,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "mfind",          do_mfind,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "pfind",          do_pfind,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "purge",          do_purge,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "slookup",        do_slookup,   POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "areas",          do_areas,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "script",         do_script,    POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "tables",         do_table,     POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },
    { "memory",         do_memory,    POS_DEAD,  LEVEL_BUILDER,  LOG_NORMAL  },

    { "users",          do_users,     POS_DEAD, LEVEL_IMMORTAL,  LOG_NORMAL  },
    { "restore",        do_restore,   POS_DEAD, LEVEL_IMMORTAL,  LOG_ALWAYS  },
    { "transfer",       do_transfer,  POS_DEAD, LEVEL_IMMORTAL,  LOG_ALWAYS  },
    { "wizify",         do_wizify,    POS_DEAD, LEVEL_IMMORTAL,  LOG_ALWAYS  },
    { "bamfin",         do_bamfin,    POS_DEAD, LEVEL_IMMORTAL,  LOG_NORMAL  },
    { "bamfout",        do_bamfout,   POS_DEAD, LEVEL_IMMORTAL,  LOG_NORMAL  },
    { "goto",           do_goto,      POS_DEAD, LEVEL_IMMORTAL,  LOG_NORMAL  },
    { "holylight",      do_holylight, POS_DEAD, LEVEL_IMMORTAL,  LOG_NORMAL  },
    { "invis",          do_invis,     POS_DEAD, LEVEL_IMMORTAL,  LOG_NORMAL  },
    { "notify",         do_notify,    POS_DEAD, LEVEL_IMMORTAL,  LOG_NORMAL  },

    { "immtalk",        do_immtalk,   POS_DEAD,    LEVEL_HERO,   LOG_NORMAL  },
    { "]",              do_immtalk,   POS_DEAD,    LEVEL_HERO,   LOG_NORMAL  },
    { "wizhelp",        do_wizhelp,   POS_DEAD,    LEVEL_HERO,   LOG_NORMAL  },
    
    { "where",          do_where,     POS_RESTING, LEVEL_HERO,   LOG_NORMAL  },


    /*
     * End of list.  (this is the sentinel)
     */
    { "",               NULL,         POS_DEAD,              0,  LOG_NORMAL }
};




sh_int comlist [512];

/*
 * Syntax:  comlist
 */
void do_comlist( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char final[4 * MAX_STRING_LENGTH];
    int cmd;

    final[0] = '\0';

    for ( cmd = 0; cmd_table[cmd].name[0] != '\0'; cmd++ )
    {
        sprintf( buf, "%10s %2d%s", cmd_table[cmd].name,
                                    comlist[cmd],
                                    ((cmd+1) % 5 == 0) ? "\n\r" : " " );
        strcat( final, buf );
    }

    page_to_char( final, ch );
    return;
}

    

/*
 * The main entry point for executing commands.
 * Can be recursively called from 'at', 'order', 'force'.
 * Is not called with scripts anymore.
 */
void interpret( CHAR_DATA *ch, char *argument )
{
    char command[MAX_INPUT_LENGTH];
    char logline[MAX_INPUT_LENGTH];
    int cmd;
    int trust;
    bool found = FALSE;

    /*
     * Strip leading spaces.
     */
    while ( *argument == ' ' )
	argument++;
    if ( argument[0] == '\0' )
	return;

    /*
     * Implement freeze command.
     */
    if ( !IS_NPC(ch) && IS_SET(ch->act, PLR_FREEZE) )
    {
    send_to_char( "You are encased in a solid block of ice.\n\r", ch );
	return;
    }

    /*
     * Add to traced script if tracing.
     */
    if ( !IS_NPC(ch) && ch->pcdata->trace != NULL )
    {
        char cmmnd[MAX_INPUT_LENGTH+10];
        char buf[MAX_STRING_LENGTH];
        SCRIPT_DATA *trace;

        trace = ch->pcdata->trace;

        if ( ch->pcdata->trace_wait <= 0 )
        sprintf( cmmnd, "do({%s});\n\r", argument );
        else
        sprintf( cmmnd, "do({%s}); wait(%d);\n\r", argument,
                                                   ch->pcdata->trace_wait );

        sprintf( buf, "%s", trace->commands );

        if ( strlen( buf ) + strlen( cmmnd ) >= ( MAX_STRING_LENGTH - 4 ) )
        {
            send_to_char( "Script too long, truncating.\n\r", ch );
            strncat( buf, cmmnd, MAX_STRING_LENGTH );
            free_string( trace->commands );
            trace->commands = str_dup( buf );
            do_sedit( ch, "trace" );
        }
        else
        {
            strcat( buf, cmmnd );
            free_string( trace->commands );
            trace->commands = str_dup( buf );
            send_to_char( "TRACE --->  ", ch );
            send_to_char( cmmnd, ch );
        }
    }

    /*
     * Grab the command word.
     * Special parsing so ' can be a command,
     *   also no spaces needed after punctuation.
     */
    strcpy( logline, argument );
    if ( !isalpha(argument[0]) && !isdigit(argument[0]) )
    {
	command[0] = argument[0];
	command[1] = '\0';
	argument++;
	while ( isspace(*argument) )
	    argument++;
    }
    else
    {
	argument = one_argument( argument, command );
    }



    /*
     * Look for a command on a mobile.
     * To avoid endless loops frozen in one spot, goto cannot be used
     * as the start of a command trigger.
     */
    if ( !IS_NPC(ch) )  /* Mobs can't trigger mobs this way, sorry. */
    {
        if ( ch->in_room != NULL
          && str_cmp( command, "goto" )
          && !found )
        {
            CHAR_DATA *mob;

            for ( mob = ch->in_room->people;
                  mob != NULL;
                  mob = mob->next_in_room )
            {
                if ( ch == mob ) continue;
                if ( !can_see( ch, mob ) ) continue;

                if ( script_update( mob, TYPE_MOB, TRIG_COMMAND,
                                    ch, NULL, command, argument ) )
                return;
            }
        }
    }

    /*
     * Find a command on an object in your inventory.
     */
    if ( ch->carrying != NULL
      && str_cmp( command, "goto" )
      && !found )
    {
        OBJ_DATA *obj;

        for ( obj = ch->carrying;
              obj != NULL;
              obj = obj->next_content )
        {
            if ( !can_see_obj( ch, obj ) ) continue;

            if ( script_update( obj, TYPE_OBJ, TRIG_COMMAND,
                                ch, NULL, command, argument ) )
            return;
        }
    }

    /*
     * Find a command on an object in the room or an exit object match.
     */
    if ( ch->in_room != NULL
      && str_cmp( command, "goto" )
      && !found )
    {
        OBJ_DATA *obj;
        char *command_dup;

        for ( obj = ch->in_room->contents;
              obj != NULL;
              obj = obj->next_content )
        {
            if ( !can_see_obj( ch, obj ) ) continue;

            if ( script_update( obj, TYPE_OBJ, TRIG_COMMAND,
                                ch, NULL, command, argument ) )
            return;
        }
                
        command_dup = str_dup( command );
        
      for ( obj = ch->in_room->contents; obj != NULL; obj = obj->next_content )
        {
   	    if ( can_see_obj( ch, obj ) && is_name( command_dup, STR(obj, name) ) )
	    {
            if ( obj != NULL 
              && obj->item_type == ITEM_FURNITURE 
              && IS_SET(obj->value[1], FURN_EXIT) )
	    {
	     	do_enter( ch, command_dup );
	       	free_string( command_dup );
	       	return;
            }
            }
        }

        free_string( command_dup );
    }
    
    /*
     * Find a command on a room.
     */
    if ( !found
      && ch->in_room != NULL
      && script_update( ch->in_room, TYPE_ROOM, TRIG_COMMAND,
                        ch, NULL, command, argument ) )
    return;

    /*
     * Look for command in command table.
     */
    trust = get_trust( ch );
    for ( cmd = 0; cmd_table[cmd].name[0] != '\0'; cmd++ )
    {
	if ( command[0] == cmd_table[cmd].name[0]
    &&   !str_prefix( command, cmd_table[cmd].name ) )
	{
        if (IS_NPC(ch) && (ch->desc == NULL)
                       && cmd_table[cmd].level <= FORCE_LEVEL )
        found = TRUE;
        else
        if (cmd_table[cmd].level <= trust)      found = TRUE;

	    break;
    }
    }

    /*
     * Log and snoop.
     */
    if ( cmd_table[cmd].log != LOG_NEVER )
    {
   
    if ( ( !IS_NPC(ch) && IS_SET(ch->act, PLR_LOG) )
    ||   fLogAll
    ||   ( cmd_table[cmd].log == LOG_ALWAYS && !IS_NPC(ch) ) )
    {
        LOG_LEVEL = get_trust(ch);
        sprintf( log_buf, "Log %s: %s", STR(ch,name), logline );
        log_string( log_buf );
        LOG_LEVEL = LEVEL_IMMORTAL;
    }


    if ( ch->desc != NULL && ch->desc->snoop_by != NULL )
    {
        char buf[MAX_STRING_LENGTH];
        sprintf( buf, "%s", STR(ch,name) );
        write_to_buffer( ch->desc->snoop_by, buf,     2 );
        sprintf( buf, "%% " );
        write_to_buffer( ch->desc->snoop_by, buf,     2 );
        write_to_buffer( ch->desc->snoop_by, logline, 0 );
        write_to_buffer( ch->desc->snoop_by, "\n\r",  2 );
    }
    
    }
    
    if ( !found )
    {
	/*
	 * Look for command in socials table.
	 */
	if ( !check_social( ch, command, argument ) )
	    send_to_char( "Huh?\n\r", ch );
        return;
    }
    /*
     * Character not in position for command?
     */
    if ( ch->position < cmd_table[cmd].position )
    {
	switch( ch->position )
	{
	case POS_DEAD:
            send_to_char( "You're dead, you can't move.\n\r", ch );
	    break;

	case POS_MORTAL:
	case POS_INCAP:
	    send_to_char( "You are hurt far too bad for that.\n\r", ch );
	    break;

	case POS_STUNNED:
	    send_to_char( "You are too stunned to do that.\n\r", ch );
	    break;

	case POS_SLEEPING:
            send_to_char( "You are asleep, off in dreamland.\n\r", ch );
	    break;

    case POS_SITTING:
	case POS_RESTING:
            send_to_char( "You'll have to stand up first.\n\r", ch);
	    break;

	case POS_FIGHTING:
            send_to_char( "You are in the middle of combat!\n\r", ch);
	    break;

	}
	return;
    }


    /*
     * Dispatch the command and fix FORCE_LEVEL for the next loser--er user.
     */
    (*cmd_table[cmd].do_fun) ( ch, argument );
    comlist[cmd]++;
    ch->timer = 0;
    FORCE_LEVEL = LEVEL_HERO-1;
    tail_chain( );
    return;
}



bool check_social( CHAR_DATA *ch, char *command, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int cmd;
    bool found;

    found  = FALSE;
    for ( cmd = 0; social_table[cmd].name[0] != '\0'; cmd++ )
    {
	if ( command[0] == social_table[cmd].name[0]
	&&   !str_prefix( command, social_table[cmd].name ) )
	{
	    found = TRUE;
	    break;
	}
    }

    if ( !found )
	return FALSE;

    if ( !IS_NPC(ch) && IS_SET(ch->act2, PLR_NO_EMOTE) )
    {
	send_to_char( "You are anti-social!\n\r", ch );
	return TRUE;
    }

    switch ( ch->position )
    {
    case POS_DEAD:
        send_to_char( "You're dead, you can't move.\n\r", ch );
	return TRUE;

    case POS_INCAP:
    case POS_MORTAL:
	send_to_char( "You are hurt far too bad for that.\n\r", ch );
	return TRUE;

    case POS_STUNNED:
	send_to_char( "You are too stunned to do that.\n\r", ch );
    return TRUE;

    case POS_SLEEPING:
	/*
	 * I just know this is the path to a 12" 'if' statement.  :(
	 * But two players asked for it already!  -- Furey
	 */
	if ( !str_cmp( social_table[cmd].name, "snore" ) )
	    break;
        send_to_char( "You are asleep, off in dreamland.\n\r", ch );
	return TRUE;

    }

    one_argument( argument, arg );
    victim = NULL;
    if ( arg[0] == '\0' )
    {
	act( social_table[cmd].others_no_arg, ch, NULL, victim, TO_ROOM    );
	act( social_table[cmd].char_no_arg,   ch, NULL, victim, TO_CHAR    );
    }
    else if ( ( victim = get_char_room( ch, arg ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r", ch );
    }
    else if ( victim == ch )
    {
	act( social_table[cmd].others_auto,   ch, NULL, victim, TO_ROOM    );
	act( social_table[cmd].char_auto,     ch, NULL, victim, TO_CHAR    );
    }
    else
    {
	act( social_table[cmd].others_found,  ch, NULL, victim, TO_NOTVICT );
	act( social_table[cmd].char_found,    ch, NULL, victim, TO_CHAR    );
	act( social_table[cmd].vict_found,    ch, NULL, victim, TO_VICT    );

    /*
	if ( !IS_NPC(ch) && IS_NPC(victim)
	&&   !IS_AFFECTED(victim, AFF_CHARM)
    &&   IS_AWAKE(victim)
    &&   victim->desc == NULL )
	{
	    switch ( number_bits( 4 ) )
	    {
	    case 0:
        oroc( victim, ch );
        do_peace( ch, "" );
        break;

	    case 1: case 2: case 3: case 4:
	    case 5: case 6: case 7: case 8:
        act( social_table[cmd].others_found, victim, NULL, ch, TO_NOTVICT );
        act( social_table[cmd].char_found,   victim, NULL, ch, TO_CHAR    );
        act( social_table[cmd].vict_found,   victim, NULL, ch, TO_VICT    );
		break;

	    case 9: case 10: case 11: case 12:
		act( "$n slaps $N.",  victim, NULL, ch, TO_NOTVICT );
		act( "You slap $N.",  victim, NULL, ch, TO_CHAR    );
		act( "$n slaps you.", victim, NULL, ch, TO_VICT    );
		break;
	    }
	}
    */

    }

    return TRUE;
}




/*
 * Evaluates multiple line command parses and does them all in one pulse.
 * Kinda kludgy, but useful.
void multi_interpret ( CHAR_DATA *mob, char *com_list )
{
    char buf[MAX_STRING_LENGTH];

    while ( com_list[0] != '\0' )
    {
        com_list = next_command( com_list, buf );
        interpret( mob, buf );
    }
    return;
}
 */



