/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */


#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "skills.h"


/*
 * Thanks again, Morg.
 * Modifications by Locke...
 */
char * garble_text( char *text, int prcnt_comp )
{
   static char buf[MAX_STRING_LENGTH];
   int nChars = 0;
   int rand1, rand2;
   
   static char char_table[] =
   {
      'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
      'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'
   };

   if( text == NULL || text[0] == '\0' )
   {
      bug( "Garble_text: text NULL.", 0 );
      return text;
   }

   if( strlen( text ) > MAX_STRING_LENGTH )
   {
      bug( "Garble_text: Argument to long.", 0 );
      return text;
   } 

   if( prcnt_comp <= 0   )  prcnt_comp = 1;
   if( prcnt_comp >= 90 )  return text;

   for( rand1 = 0; rand1 < strlen( text ); rand1++ )
      if( isalpha( text[rand1] ) )
         nChars++;

   nChars -= nChars * prcnt_comp / 100;

   if( nChars <= 0 )
      return text;

   buf[0] = '\0';
   strcpy( buf, text );
   for( ; nChars > 0; nChars-- )
   {
      rand1 = number_range( 0, strlen( buf ) - 1 );
      if( !isalpha( buf[rand1] ) )
      {
         nChars++;
         continue;
      }
      rand2 = number_range( 0, 24 );
      buf[rand1] = buf[rand1] >= 'A' && buf[rand1] <= 'Z' ?
       UPPER( char_table[rand2] ) : char_table[rand2];
   }   

   return buf;
}



/*
 * Fun fun fun.
 */
int check_speech( CHAR_DATA *ch, CHAR_DATA *speaker, int gsn )
{
   int percent;

   if( !IS_NPC(ch) && IS_SET(ch->act2, WIZ_TRANSLATE) )
      return 100;

   if( !IS_NPC(speaker) && IS_SET(speaker->act2, WIZ_TRANSLATE) )
     return 100;

   percent = LEARNED(ch,gsn);
   if ( percent >= skill_table[gsn].max_learn )
     return 100;

   if ( percent < 90 )
   percent += number_range( 0, 15 ) - 8;  /* Language incentive*/

   
   if( ch != speaker && LEARNED(ch,gsn) < percent )
     skill_check( ch, gsn, percent );
    

   return percent;
}


