/***************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "spells.h"
#include "skills.h"


/*
 * Compute a saving throw.
 * Negative apply's make saving throw better.
 */
bool saves_spell( int level, CHAR_DATA *victim )
{
    int save;

    save = 40 + ( victim->saving_throw ) * 5;
    save = URANGE( 5, save, 95 );
    return number_percent( ) < save;
}


int find_char_mana( CHAR_DATA *ch, int bit )
{
    OBJ_DATA *obj;
    OBJ_DATA *cont;
    int mana = 0;

    for ( obj = ch->carrying; obj != NULL; obj = obj->next_content )
    {
        if ( obj->item_type == ITEM_GEM && VAL_SET(obj, 0, bit) )
        {
            mana += obj->value[1];
        }
        else
        if ( obj->item_type == ITEM_CONTAINER && !IS_SET(obj->value[1], CONT_CLOSED) )
        {
            for ( cont = obj->contains; cont != NULL; cont = cont->next_content )
            {
            if ( cont->item_type == ITEM_GEM && VAL_SET(cont, 0, bit) )
            {
                 mana += cont->value[1];
            }
            }
        }
    }

    return mana;
}

void take_mana_char( CHAR_DATA *ch, int mana, int bit )
{
    OBJ_DATA *obj, *obj_next;
    OBJ_DATA *cont, *cont_next;

    for ( obj = ch->carrying; obj != NULL; obj = obj_next )
    {
        obj_next = obj->next_content;
        if ( obj->item_type == ITEM_GEM && VAL_SET(obj, 0, bit) )
        {
            if ( obj->value[1] >= mana )
            {
                obj->value[1] -= mana;
                if ( obj->value[1] == 0 )
                {
                act( "$p is drained of all its power, and shatters into thousands of shards!",
                     ch, obj, NULL, TO_CHAR );
                obj_from_char( obj );
                extract_obj( obj );
                }
                return;
            }
            else
            {
                mana -= obj->value[1];
                act( "$p is drained of all its power, and shatters into thousands of shards!",
                     ch, obj, NULL, TO_CHAR );
                obj_from_char( obj );
                extract_obj( obj );
            }
        }
        else
        if ( obj->item_type == ITEM_CONTAINER && !IS_SET(obj->value[1], CONT_CLOSED) )
        {
            for ( cont = obj->contains; cont != NULL; cont = cont_next )
            {
            cont_next = cont->next_content;
            if ( cont->item_type == ITEM_GEM && VAL_SET(cont, 0, bit) )
            {
               if ( cont->value[1] >= mana )
               {
                   cont->value[1] -= mana;
                   if ( cont->value[1] == 0 )
                   {
                   act( "$p is drained of all its power, and shatters into thousands of shards!",
                        ch, cont, NULL, TO_CHAR );
                   obj_from_char( cont );
                   extract_obj( cont );
                   }
                   return;
               }
               else
               {
                   mana -= cont->value[1];
                   act( "$p is drained of all its power, and shatters into thousands of shards!",
                        ch, cont, NULL, TO_CHAR );
                   obj_from_char( cont );
                   extract_obj( cont );
               }
            }
            }
        }
    }

    return;
}



/*
 * The kludgy global is for spells who want more stuff from command line.
 */
char *target_name;


void do_cast( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    void *vo;
    int mana;
    int char_mana;
    int sn;

    /*
     * Switched NPC's can cast spells, but others can, too, if they are alone.
     */
    if ( IS_NPC(ch) && (ch->master != NULL) )
	return;

    target_name = one_argument( argument, arg1 );
    one_argument( target_name, arg2 );

    if ( arg1[0] == '\0' )
    {
	send_to_char( "Cast which what where?\n\r", ch );
	return;
    }

    if ( (sn = skill_lookup( arg1 )) < 0
      || GET_PC(ch,level,MAX_LEVEL) < skill_table[sn].skill_level
      || LEARNED(ch,sn) <= 0 )
    {
	send_to_char( "You can't do that.\n\r", ch );
	return;
    }
  
    if ( ch->position < skill_table[sn].minimum_position )
    {
    send_to_char( "You can't concentrate enough.\n\r", ch );
	return;
    }

    mana = IS_NPC(ch) ? 0 : UMAX(
    skill_table[sn].mana,
    100 / ( 2 ) );

    /*
     * Locate targets.
     */
    victim	= NULL;
    obj		= NULL;
    vo		= NULL;
      
    switch ( skill_table[sn].target )
    {
    default:
	bug( "Do_cast: bad target for sn %d.", sn );
	return;

    case TAR_IGNORE:
	break;

    case TAR_CHAR_OFFENSIVE:
	if ( arg2[0] == '\0' )
	{
	    if ( ( victim = ch->fighting ) == NULL )
	    {
		send_to_char( "Cast the spell on whom?\n\r", ch );
		return;
	    }
	}
	else
	{
	    if ( ( victim = get_char_room( ch, arg2 ) ) == NULL )
	    {
		send_to_char( "They aren't here.\n\r", ch );
		return;
	    }
	}

	vo = (void *) victim;
	break;

    case TAR_CHAR_DEFENSIVE:
	if ( arg2[0] == '\0' )
	{
	    victim = ch;
	}
	else
	{
	    if ( ( victim = get_char_room( ch, arg2 ) ) == NULL )
	    {
		send_to_char( "They aren't here.\n\r", ch );
		return;
	    }
	}

	vo = (void *) victim;
	break;

    case TAR_CHAR_SELF:
    if ( arg2[0] != '\0' && !is_name( arg2, STR(ch, name) ) )
	{
	    send_to_char( "You cannot cast this spell on another.\n\r", ch );
	    return;
	}

	vo = (void *) ch;
	break;

    case TAR_OBJ_INV:
	if ( arg2[0] == '\0' )
	{
	    send_to_char( "What should the spell be cast upon?\n\r", ch );
	    return;
	}

    if ( ( obj = get_obj_carry( ch, arg2 ) ) == NULL )
	{
        send_to_char( "You are not carrying that in your hand.\n\r", ch );
	    return;
	}

	vo = (void *) obj;
	break;
    }
	    

    char_mana = find_char_mana( ch, skill_table[sn].mana_type );

    if ( !IS_NPC(ch) && mana > char_mana && !IS_IMMORTAL(ch) )
    {
        switch ( skill_table[sn].mana_type )
        {
            default: send_to_char( "You don't have enough mana.\n\r", ch ); break;
     case MANA_FIRE: send_to_char( "You don't have enough Fire gems.\n\r", ch ); break;
      case MANA_AIR: send_to_char( "You don't have enough Air gems.\n\r", ch ); break;
    case MANA_WATER: send_to_char( "You don't have enough Water gems.\n\r", ch ); break;
    case MANA_EARTH: send_to_char( "You don't have enough Earth gems.\n\r", ch ); break;
        }
        return;
    }
      
    WAIT_STATE( ch, skill_table[sn].beats );

    if ( !IS_IMMORTAL(ch) || char_mana >= mana )
    {
    if ( !IS_NPC(ch) && number_percent( ) > LEARNED(ch,sn) )
    {
	send_to_char( "You lost your concentration.\n\r", ch );
    take_mana_char( ch, mana/2, skill_table[sn].mana_type );
    }
    else
    {
    (*skill_table[sn].spell_fun) ( sn, INTERPOLATE(1, 40, LEARNED(ch,sn)), ch, vo );
    take_mana_char( ch, mana, skill_table[sn].mana_type );
    }
    }

    if ( skill_table[sn].target == TAR_CHAR_OFFENSIVE
    &&   victim != ch
    &&   victim->master != ch )
    {
	CHAR_DATA *vch;
	CHAR_DATA *vch_next;

	for ( vch = ch->in_room->people; vch; vch = vch_next )
	{
	    vch_next = vch->next_in_room;
	    if ( victim == vch && victim->fighting == NULL )
	    {
        oroc( victim, ch );
		break;
	    }
	}
    }

    return;
}



/*
 * Cast spells at targets using a magical object.
 */
void obj_cast_spell( int sn, int level, CHAR_DATA *ch, CHAR_DATA *victim, OBJ_DATA *obj )
{
    void *vo;

    if ( sn <= 0 )
	return;

    if ( sn >= MAX_SKILL || skill_table[sn].spell_fun == 0 )
    {
	bug( "Obj_cast_spell: bad sn %d.", sn );
	return;
    }

    switch ( skill_table[sn].target )
    {
    default:
	bug( "Obj_cast_spell: bad target for sn %d.", sn );
	return;

    case TAR_IGNORE:
	vo = NULL;
	break;

    case TAR_CHAR_OFFENSIVE:
	if ( victim == NULL )
	    victim = ch->fighting;
    if ( victim == NULL )
	{
        send_to_char( "The spell fizzles.\n\r", ch );
	    return;
	}
	vo = (void *) victim;
	break;

    case TAR_CHAR_DEFENSIVE:
	if ( victim == NULL )
	    victim = ch;
	vo = (void *) victim;
	break;

    case TAR_CHAR_SELF:
	vo = (void *) ch;
	break;

    case TAR_OBJ_INV:
	if ( obj == NULL )
	{
        send_to_char( "The spell fizzles.\n\r", ch );
	    return;
	}
	vo = (void *) obj;
	break;
    }

    target_name = "";
    (*skill_table[sn].spell_fun) ( sn, level, ch, vo );

    if ( skill_table[sn].target == TAR_CHAR_OFFENSIVE
    &&   victim != ch
    &&   victim->master != ch )
    {
	CHAR_DATA *vch;
	CHAR_DATA *vch_next;

	for ( vch = ch->in_room->people; vch; vch = vch_next )
	{
	    vch_next = vch->next_in_room;
	    if ( victim == vch && victim->fighting == NULL )
	    {
        oroc( victim, ch );
		break;
	    }
	}
    }

    return;
}


