#
# Grok Makefile
# Updated 11 August 1997
#
# Usage:
#   make            -- make 'merc' executable
#   make clean      -- remove object files
#   make spotless   -- remove object files and 'mud'executable
#

# If you use -lmcheck, you should also define USE_MCHECK too.

CC      =gcc
PROF    =-O -g3#      -pg -DUSE_MCHECK
L_FLAGS =$(PROF) -lcrypt#     -lmcheck -static -DMALLOC_DEBUG
E_FLAGS =#            -Lefence/ -lefence -DMALLOC_DEBUG
O_FLAGS =$(PROF)
C_FLAGS =-Wall -Wstrict-prototypes -Wpointer-arith -Wno-char-subscripts \
         -Winline $(O_FLAGS)

.SUFFIXES:
.SUFFIXES: .c .o

O_FILES = act_cfg.o act_comm.o act_info.o act_move.o act_obj.o bit.o      \
          board.o comm.o db.o def.o door.o fight.o function.o furn.o      \
          handler.o interp.o language.o magic.o mem.o money.o mount.o     \
          nanny.o oc.o parse.o save.o script.o shop.o skills.o spells.o   \
          string.o track.o update.o wiz.o wiz_info.o wiz_set.o xrand.o

default: all
all: mud

ac.o: ac.c mud.h

mud: $(O_FILES)
	rm -f mud
	$(CC) $(L_FLAGS) -o mud $(O_FILES) $(E_FLAGS)

.c.o:
	$(CC) -c $(C_FLAGS) $<

tags:
	ctags -W -p. *.[cmh] &> tags.log

clean:
	rm -f *~ *.o make.log tags tags.log

realclean spotless: clean
	rm -f mud core

