/****************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *   ___  ___  ___  __    __                                                *
 *  |   ||   ||   ||  |\/|  | 2-x    NiMUD is a software currently under    *
 *   |  \ | |  | |  | |\/| |         development.  It is based primarily on *
 *   | |\\| |  | |  | |  | |         the discontinued package, Merc 2.2.    *
 *   | | \  |  | |  | |  | |         NiMUD is being written and developed   *
 *  |___||___||___||__|  |__|        By Locke and Surreality as a new,      *
 *   NAMELESS INCARNATE *MUD*        frequently updated package similar to  *
 *        S O F T W A R E            the original Merc 2.x.                 *
 *                                                                          *
 *  Just look for the Iron Maiden skull wherever NiMUD products are found.  *
 *                                                                          *
 *  Much time and thought has gone into this software and you are           *
 *  benefitting.  We hope that you share your changes too.  What goes       *
 *  around, comes around.                                                   *
 ****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "comm.h"
#include "skills.h"
#include "script.h"


/* Memory recycling */

AFFECT_DATA             *   affect_free;
ATTACK_DATA             *   attack_free;
DESCRIPTOR_DATA         *   descriptor_free;
RESET_DATA              *   reset_free;
TRIGGER_DATA            *   trigger_free;
SCRIPT_DATA             *   script_free;
VARIABLE_DATA           *   variable_free;
AREA_DATA               *   area_free;
EXTRA_DESCR_DATA        *   extra_descr_free;
EXIT_DATA               *   exit_free;
ROOM_INDEX_DATA         *   room_index_free;
OBJ_INDEX_DATA          *   obj_index_free;
SHOP_DATA               *   shop_free;
MOB_INDEX_DATA          *   mob_index_free;
RESET_DATA              *   reset_free;
ATTACK_DATA             *   attack_free;
CHAR_DATA               *   char_free;
PC_DATA                 *   pc_free;
OBJ_DATA                *   obj_free;
NOTE_DATA               *   note_free;

AFFECT_DATA              affect_zero;
ATTACK_DATA              attack_zero;
DESCRIPTOR_DATA          descriptor_zero;
RESET_DATA               reset_zero;
TRIGGER_DATA             trigger_zero;
SCRIPT_DATA              script_zero;
VARIABLE_DATA            variable_zero;
AREA_DATA                area_zero;
EXTRA_DESCR_DATA         extra_descr_zero;
EXIT_DATA                exit_zero;
ROOM_INDEX_DATA          room_index_zero;
OBJ_INDEX_DATA           obj_index_zero;
SHOP_DATA                shop_zero;
MOB_INDEX_DATA           mob_index_zero;
RESET_DATA               reset_zero;
ATTACK_DATA              attack_zero;
CHAR_DATA                ch_zero;
PC_DATA                  pc_zero;
OBJ_DATA                 obj_zero;
TERRAIN_DATA             terrain_zero;

/*
 * Memory management.
 * Increase MAX_STRING if you have too.
 * Tune the others only if you understand what you're doing.
 */
#define         MAX_STRING      2097152
#define			MAX_PERM_BLOCK	131072
#define			MAX_MEM_LIST	11

void *			rgFreeList	[MAX_MEM_LIST];
const int		rgSizeList	[MAX_MEM_LIST]	=
{
    16, 32, 64, 128, 256, 1024, 2048, 4096, 8192, 16384, 32768-64
};

int         nAllocString;
int         sAllocString;
int         nAllocPerm;
int         sAllocPerm;

int         num_pulse;

char *      string_space;
char *      top_string;
char        str_empty       [1];

int         top_affect         = 0;
int         top_area           = 0;
int         top_ed             = 0;
int         top_exit           = 0;
int         top_help           = 0;
int         top_mob_index      = 0;
int         top_obj_index      = 0;
int         top_reset          = 0;
int         top_room           = 0;
int         top_shop           = 0;
int         top_variable       = 0;
int         top_trigger        = 0;
int         top_script         = 0;
int         top_char_data      = 0;
int         top_pcdata         = 0;
int         top_attack         = 0;
int         top_obj            = 0;
int         top_descriptor     = 0;
int         top_note           = 0;

int         top_vnum_script    = 0;
int         top_vnum_mob       = 0;
int         top_vnum_obj       = 0;
int         top_vnum_room      = 0;
int         top_vnum_terrain   = 0;


extern bool            fBootDb;
extern FILE *          fpArea;
extern char            strArea[MAX_INPUT_LENGTH];
extern int             social_count;

VARIABLE_DATA           * mud_var_list;


#define         AREA_NONE       0
#define         AREA_CHANGED    1
#define         AREA_ADDED      2

#define         SEX_NONE        4
#define         ROOM_NONE       0
#define         EX_NONE         0
#define         ITEM_NONE       0
#define         EXTRA_NONE      0
#define         ITEM_WEAR_NONE  0
#define         ACT_NONE        0
#define         AFFECT_NONE     0





DESCRIPTOR_DATA *new_descriptor_data( void )
{
    DESCRIPTOR_DATA *dnew;

    if ( descriptor_free == NULL )
    {
        dnew = alloc_mem( sizeof(*dnew) );
        top_descriptor++;
    }
    else
    {
        dnew            = descriptor_free;
        descriptor_free = descriptor_free->next;
    }

    *dnew               = descriptor_zero;
    dnew->host          = str_dup( "" );
    dnew->descriptor    = -1;
    dnew->connected     = CON_SHOW_TITLE;
    dnew->showstr_head  = NULL;
    dnew->showstr_point = NULL;
    dnew->outsize       = 2000;
    dnew->pEdit         = NULL;
    dnew->pString       = NULL;
    dnew->fpromptok     = TRUE;
    dnew->outbuf        = alloc_mem( dnew->outsize );

    return dnew;
}



void free_descriptor( DESCRIPTOR_DATA *d )
{
    free_string( d->host );
    free_mem( d->outbuf, d->outsize );      /* RT socket leak fix */
    d->next    = descriptor_free;
    descriptor_free = d;
    return;
}




CHAR_DATA *new_char_data( void )
{
    CHAR_DATA *ch;

    if ( char_free == NULL )
    {
        ch          =   alloc_perm( sizeof(*ch) );
        top_char_data++;
    }
    else
    {
        ch             =   char_free;
        char_free      =   char_free->next;
    }

    *ch                 = ch_zero;
    ch->name            = &str_empty[0];
    ch->fmode           = 3;
    ch->short_descr     = &str_empty[0];
    ch->long_descr      = &str_empty[0];
    ch->description     = &str_empty[0];
    ch->prompt          = &str_empty[0];
    ch->hunting         = &str_empty[0];
    ch->keywords        = &str_empty[0];
    ch->armor           = 100;
    ch->position        = POS_STANDING;
    ch->master          = NULL;
    ch->fighting        = NULL;
    ch->riding          = NULL;
    ch->rider      = NULL;
    ch->furniture       = NULL;
    ch->pIndexData      = NULL;
    ch->affected        = NULL;
    ch->pnote           = NULL;
    ch->triggers        = NULL;
    ch->timer           = -1;
    ch->wait            = 0;
    ch->affected_by     = 0;
    ch->position        = POS_RESTING;
    ch->hitroll         = 0;
    ch->act             = PLR_BLANK | PLR_COMBINE | PLR_PROMPT;
    ch->act2            = 0;
    ch->bounty          = 0;
    ch->owed            = 0;
    ch->damroll         = 0;
    ch->perm_str        = 13;
    ch->perm_int        = 13;
    ch->perm_wis        = 13;
    ch->perm_dex        = 13;
    ch->perm_con        = 13;
    ch->mod_str         = 0;
    ch->mod_int         = 0;
    ch->mod_wis         = 0;
    ch->mod_dex         = 0;
    ch->mod_con         = 0;
    ch->hit             = MAXHIT(ch);
    ch->move            = MAXMOVE(ch);
    ch->pagelen         = 20;
    ch->size            = SIZE_AVERAGE;

    ch->pcdata          = new_pc_data( );
                              
    return ch;
}


void free_char( CHAR_DATA *ch )
{
    OBJ_DATA *obj, *obj_next;
    AFFECT_DATA *paf, *paf_next;
    TRIGGER_DATA *trigger, *trigger_next;
    VARIABLE_DATA *va, *va_next;
    CHAR_DATA *pet;

    if ( ch == NULL ) return;    

    for ( pet = char_list; pet != NULL; pet = pet->next )
    {
        if ( ( pet->master == ch  ) && IS_SET(pet->act, ACT_PET) )
        break;
    }
    if ( pet != NULL ) extract_char( pet, TRUE );

    for ( obj = ch->carrying; obj != NULL; obj = obj_next )
    {
        obj_next = obj->next_content;
        extract_obj( obj );
    }

    for ( trigger = ch->triggers; trigger != NULL; trigger = trigger_next )
    {
    trigger_next     = trigger->next;
    free_trigger( trigger );
    }

    for ( va = ch->globals;  va != NULL; va = va_next )
    {
        va_next = va->next;
        free_variable( va );
    }

    for ( paf = ch->affected; paf != NULL; paf = paf_next )
    {
        paf_next = paf->next;
        affect_remove( ch, paf );
    }

    free_string( ch->name           );
    free_string( ch->short_descr    );
    free_string( ch->long_descr     );
    free_string( ch->description    );
    free_string( ch->prompt         );
    free_string( ch->hunting        );
    free_string( ch->keywords       );

    free_pc_data( ch->pcdata );
    ch->pcdata = NULL;

    ch->next         = char_free;
    char_free        = ch;
    return;
}



PC_DATA *new_pc_data( void )
{
    PC_DATA *pc;

    if ( pc_free == NULL )
    {
        pc           =   alloc_perm( sizeof(*pc) );
        top_pcdata++;
    }
    else
    {
        pc           =   pc_free;
        pc_free      =   pc_free->next;
    }

    *pc                         = pc_zero;
    pc->security                = 9;
    pc->wizinvis                = 0;

    {
        int x;

        for ( x = 0; x < MAX_COLORS; x++ )
        pc->colors[x]           = 16;
    }

    pc->learned[gsn_wp]         =  1;
    pc->learned[gsn_language]   =  1;
    pc->learned[gsn_zengalli]   = 50;

    pc->condition[COND_THIRST]  = 50;
    pc->condition[COND_FULL]    = 50;
    pc->bamfin                  = &str_empty[0];
    pc->bamfout                 = &str_empty[0];
    pc->constellation           = &str_empty[0];
    pc->email                   = &str_empty[0];
    pc->pwd                     = &str_empty[0];
    pc->denial                  = &str_empty[0];
    pc->logon                   = current_time;
    pc->next                    = NULL;
    return pc;
}


void free_pc_data( PC_DATA *pc )
{
    if ( pc == NULL ) return;

    pc->next = pc_free;
    pc_free  = pc;

    free_string( pc->pwd            );
    free_string( pc->bamfin         );
    free_string( pc->bamfout        );
    free_string( pc->constellation  );
    free_string( pc->email          );
    free_string( pc->denial         );
    return;
};



OBJ_DATA *new_obj( void )
{
    OBJ_DATA *pObj;

    if ( obj_free == NULL )
    {
        pObj          =   alloc_perm( sizeof(*pObj) );
        top_obj++;
    }
    else
    {
        pObj          =   obj_free;
        obj_free      =   obj_free->next;
    }

    *pObj                     = obj_zero;
    pObj->next                = NULL;
    pObj->next_content        = NULL;
    pObj->contains            = NULL;
    pObj->in_obj              = NULL;
    pObj->carried_by          = NULL;
    pObj->extra_descr         = NULL;
    pObj->affected            = NULL;
    pObj->pIndexData          = NULL;
    pObj->in_room             = NULL;
    pObj->triggers            = NULL;           /* for scripts */
    pObj->current             = NULL;
    pObj->name                = NULL;
    pObj->short_descr         = NULL;
    pObj->short_descr_plural  = NULL;
    pObj->description         = NULL;
    pObj->description_plural  = NULL;
    pObj->action_descr        = NULL;
    pObj->real_description    = NULL;
    pObj->item_type           = ITEM_TRASH;
    pObj->extra_flags         = ITEM_TAKE;
    pObj->wear_flags          = 0;
    pObj->wear_loc            = WEAR_NONE;
    pObj->weight              = 1;
    pObj->cost                = 0;
    pObj->level               = 0;
    pObj->timer               = -1;
    pObj->size                = 0;
    pObj->material            = 0;
    pObj->value[0]            = 0;
    pObj->value[1]            = 0;
    pObj->value[2]            = 0;
    pObj->value[3]            = 0;

    return pObj;
};




void free_obj( OBJ_DATA *pObj )
{
    EXTRA_DESCR_DATA *ed, *ed_next;
    AFFECT_DATA *af, *af_next;
    TRIGGER_DATA *tr, *tr_next;
    VARIABLE_DATA *va, *va_next;


    pObj->next = obj_free;
    obj_free   = pObj;

    free_string( pObj->name );
    free_string( pObj->short_descr );
    free_string( pObj->short_descr_plural );
    free_string( pObj->description );
    free_string( pObj->description_plural );
    free_string( pObj->action_descr );
    free_string( pObj->real_description );

    for ( ed = pObj->extra_descr;  ed != NULL; ed = ed_next )
    {
        ed_next = ed->next;
        free_extra_descr( ed );
    }

    for ( af = pObj->affected;  af != NULL; af = af_next )
    {
        af_next = af->next;
        free_affect( af );
    }

    for ( tr = pObj->triggers;  tr != NULL; tr = tr_next )
    {
        tr_next = tr->next;
        free_trigger( tr );
    }

    for ( va = pObj->globals;  va != NULL; va = va_next )
    {
        va_next = va->next;
        free_variable( va );
    }

    return;
};



RESET_DATA *new_reset_data( void )
{
    RESET_DATA *pReset;

    if ( reset_free == NULL )
    {
        pReset          =   alloc_perm( sizeof(*pReset) );
        top_reset++;
    }
    else
    {
        pReset          =   reset_free;
        reset_free      =   reset_free->next;
    }

    *pReset             =   reset_zero;
    pReset->next        =   NULL;
    pReset->command     = 'X';
    pReset->loc         =  -1;
    pReset->percent     =   0;
    pReset->rs_vnum     =   0;
    pReset->vnum        =   0;
    pReset->num         =   1;

    return pReset;
}



void free_reset_data( RESET_DATA *pReset )
{
    pReset->next            = reset_free;
    reset_free              = pReset;
    return;
}


TERRAIN_DATA *new_terrain( void )
{
    TERRAIN_DATA *pTerrain;

    pTerrain        =   alloc_perm( sizeof(*pTerrain) );
    top_vnum_terrain++;

    *pTerrain           =   terrain_zero;
    pTerrain->next        =   NULL;
    pTerrain->name        = str_dup( "unset" );
    pTerrain->winter      = str_dup( "It is winter.\n\r" );
    pTerrain->spring      = str_dup( "It is spring.\n\r" );
    pTerrain->summer      = str_dup( "It is summer.\n\r" );
    pTerrain->fall        = str_dup( "It is fall.\n\r" );
    pTerrain->map_char    = ' ';
    pTerrain->vnum         =  top_vnum_terrain;

    return pTerrain;
}





AREA_DATA *new_area( void )
{
    AREA_DATA *pArea;
    char buf[MAX_INPUT_LENGTH];

    if ( area_free == NULL )
    {
        pArea   =   alloc_perm( sizeof(*pArea) );
        top_area++;
    }
    else
    {
        pArea       =   area_free;
        area_free   =   area_free->next;
    }


    *pArea                  =   area_zero;
    pArea->next             =   NULL;
    pArea->name             =   str_dup( "New Area" );
    pArea->repop            =   &str_empty[0];
    pArea->area_flags       =   AREA_ADDED;
    pArea->security         =   1;
    pArea->builders         =   str_dup( "None" );
    pArea->lvnum            =   0;
    pArea->uvnum            =   0;
    pArea->age              =   0;
    pArea->nplayer          =   0;
    pArea->vnum             =   top_area-1;
    sprintf( buf, "area-%s%d.are", pArea->vnum-1 < 10 ? "00" :
                                   pArea->vnum-1 < 100 ? "0" : "",
                                   pArea->vnum-1 );
    pArea->filename         =   str_dup( buf );

    return pArea;
}



void free_area( AREA_DATA *pArea )
{
    free_string( pArea->name );
    free_string( pArea->filename );
    free_string( pArea->repop );
    free_string( pArea->builders );

    pArea->next         =   area_free->next;
    area_free           =   pArea;
    return;
}



EXTRA_DESCR_DATA *new_extra_descr( void )
{
    EXTRA_DESCR_DATA *pExtra;

    if ( extra_descr_free == NULL )
    {
        pExtra              =   alloc_perm( sizeof(*pExtra) );
        top_ed++;
    }
    else
    {
        pExtra              =   extra_descr_free;
        extra_descr_free    =   extra_descr_free->next;
    }

    *pExtra                 =   extra_descr_zero;
    pExtra->keyword         =   NULL;
    pExtra->description     =   NULL;
    pExtra->next            =   NULL;

    return pExtra;
}



void free_extra_descr( EXTRA_DESCR_DATA *pExtra )
{
    free_string( pExtra->keyword );
    free_string( pExtra->description );

    pExtra->next        =   extra_descr_free;
    extra_descr_free    =   pExtra;
    return;
}



EXIT_DATA *new_exit( void )
{
    EXIT_DATA *pExit;

    if ( exit_free == NULL )
    {
        pExit           =   alloc_perm( sizeof(*pExit) );
        top_exit++;
    }
    else
    {
        pExit           =   exit_free;
        exit_free       =   exit_free->next;
    }

    *pExit              =   exit_zero;
    pExit->to_room      =   NULL;
    pExit->next         =   NULL;
    pExit->vnum         =   0;
    pExit->exit_info    =   0;
    pExit->key          =   0;
    pExit->keyword      =   NULL;
    pExit->description  =   str_dup("");
    pExit->rs_flags     =   0;

    return pExit;
}



void free_exit( EXIT_DATA *pExit )
{
    free_string( pExit->keyword );
    free_string( pExit->description );

    pExit->next         =   exit_free;
    exit_free           =   pExit;
    return;
}


ATTACK_DATA *new_attack ( void )
{
    ATTACK_DATA *attack;

    if ( attack_free == NULL )
    {
        attack          = alloc_perm( sizeof(*attack) );
        top_attack++;
    }
    else
    {
        attack          =   attack_free;
        attack_free     =   attack_free->next;
    }

    *attack      = attack_zero;
    attack->idx  = 0;
    attack->dam1 = 0;
    attack->dam2 = 0;

    return attack;
}


void free_attack ( ATTACK_DATA *attack )
{
    attack->next     = attack_free;
    attack_free      = attack;
    return;
}
 

ROOM_INDEX_DATA *new_room_index( void )
{
    ROOM_INDEX_DATA *pRoom;
    int door;

    if ( room_index_free == NULL )
    {
        pRoom           =   alloc_perm( sizeof(*pRoom) );
        top_room++;
    }
    else
    {
        pRoom           =   room_index_free;
        room_index_free =   room_index_free->next;
    }

    *pRoom                  =   room_index_zero;
    pRoom->next             =   NULL;
    pRoom->reset_first      =   NULL;
    pRoom->reset_last       =   NULL;
    pRoom->people           =   NULL;
    pRoom->contents         =   NULL;
    pRoom->extra_descr      =   NULL;
    pRoom->area             =   NULL;

    for ( door=0; door < MAX_DIR; door++ )
        pRoom->exit[door]   =   NULL;

    pRoom->name             =   &str_empty[0];
    pRoom->description      =   &str_empty[0];
    pRoom->vnum             =   0;
    pRoom->room_flags       =   0;
    pRoom->light            =   0;
    pRoom->sector_type      =   0;
    pRoom->terrain          =   0;

    return pRoom;
}



void free_room_index( ROOM_INDEX_DATA *pRoom )
{
    int door;
    EXTRA_DESCR_DATA *pExtra, *pExtra_next;
    RESET_DATA *pReset, *pReset_next;
    VARIABLE_DATA *va, *va_next;
    TRIGGER_DATA *trigger, *trigger_next;

    free_string( pRoom->name );
    free_string( pRoom->description );

    for ( door = 0; door < MAX_DIR; door++ )
    {
        if ( pRoom->exit[door] != NULL )
            free_exit( pRoom->exit[door] );
    }

    for ( pExtra = pRoom->extra_descr; pExtra != NULL; pExtra = pExtra_next )
    {
        pExtra_next = pExtra->next;
        free_extra_descr( pExtra );
    }

    for ( pReset = pRoom->reset_first; pReset != NULL; pReset = pReset_next )
    {
        pReset_next = pReset->next;
        free_reset_data( pReset );
    }

    for ( trigger = pRoom->triggers; trigger != NULL; trigger = trigger_next )
    {
    trigger_next     = trigger->next;
    free_trigger( trigger );
    }

    for ( va = pRoom->globals;  va != NULL; va = va_next )
    {
        va_next = va->next;
        free_variable( va );
    }

    for ( door = 0;  door < MAX_KEY_HASH;  door++ )
    {
        ROOM_INDEX_DATA *room;

        for ( room = room_index_hash[door];  room != NULL;  room = room->next )
        {
            if ( room->next == pRoom )
            room->next = room->next->next;
        }
    }

    pRoom->next     =   room_index_free;
    room_index_free =   pRoom;
    return;
}



AFFECT_DATA *new_affect( void )
{
    AFFECT_DATA *pAf;

    if ( affect_free == NULL )
    {
        pAf             =   alloc_perm( sizeof(*pAf) );
        top_affect++;
    }
    else
    {
        pAf             =   affect_free;
        affect_free     =   affect_free->next;
    }

    *pAf            =   affect_zero;
    pAf->next       =   NULL;
    pAf->location   =   0;
    pAf->modifier   =   0;
    pAf->type       =   0;
    pAf->duration   =   0;
    pAf->bitvector  =   0;

    return pAf;
}



void free_affect( AFFECT_DATA* pAf )
{
    pAf->next           = affect_free;
    affect_free         = pAf;
    return;
}



OBJ_INDEX_DATA *new_obj_index( void )
{
    OBJ_INDEX_DATA *pObj;
    int value;

    if ( obj_index_free == NULL )
    {
        pObj           =   alloc_perm( sizeof(*pObj) );
        top_obj_index++;
    }
    else
    {
        pObj            =   obj_index_free;
        obj_index_free  =   obj_index_free->next;
    }

    *pObj               =   obj_index_zero;
    pObj->next          =   NULL;
    pObj->extra_descr   =   NULL;
    pObj->affected      =   NULL;
    pObj->area          =   NULL;
    pObj->name          =   str_dup( "unset" );
    pObj->short_descr   =   str_dup( "unset" );
    pObj->description   =   str_dup( "unset\n\r" );
    pObj->action_descr       = &str_empty[0];
    pObj->short_descr_plural = &str_empty[0];
    pObj->description_plural = &str_empty[0];
    pObj->real_description   = &str_empty[0];
    pObj->vnum          =   0;
    pObj->size          =   SIZE_ANY;
    pObj->item_type     =   ITEM_TRASH;
    pObj->timer         =   0;
    pObj->extra_flags   =   0;
    pObj->wear_flags    =   0;
    pObj->count         =   0;
    pObj->weight        =   0;
    pObj->level         =   0;
    pObj->cost          =   0;
    for ( value=0; value<10; value++ )
        pObj->value[value]  =   0;

    return pObj;
}



void free_obj_index( OBJ_INDEX_DATA *pObj )
{
    EXTRA_DESCR_DATA *pExtra;
    AFFECT_DATA *pAf;

    free_string( pObj->name );
    free_string( pObj->short_descr );
    free_string( pObj->short_descr_plural );
    free_string( pObj->description );
    free_string( pObj->description_plural );
    free_string( pObj->action_descr );

    for ( pAf = pObj->affected; pAf != NULL; pAf = pAf->next )
    {
        free_affect( pAf );
    }

    for ( pExtra = pObj->extra_descr; pExtra != NULL; pExtra = pExtra->next )
    {
        free_extra_descr( pExtra );
    }
    
    pObj->next              = obj_index_free;
    obj_index_free          = pObj;
    return;
}



SHOP_DATA *new_shop( void )
{
    SHOP_DATA *pShop;
    int buy;

    if ( shop_free == NULL )
    {
        pShop           =   alloc_perm( sizeof(*pShop) );
        top_shop++;
    }
    else
    {
        pShop           =   shop_free;
        shop_free       =   shop_free->next;
    }

    *pShop                = shop_zero;
    pShop->next           = NULL;
    pShop->keeper         = 0;
    pShop->profit_buy     = 100;
    pShop->profit_sell    = 100;
    pShop->open_hour      = 0;
    pShop->close_hour     = 23;

    pShop->comp_index     = 0;
    pShop->buy_index      = 0;
    pShop->sell_index     = 0;
    pShop->no_such_item   = str_dup( "I don't have that to sell you." );
    pShop->do_not_buy     = str_dup( "I am not interested in that item." );
    pShop->list_header    = str_dup( "" );

    for ( buy=0; buy<MAX_TRADE; buy++ )
        pShop->buy_type[buy]    =   ITEM_NONE;

    return pShop;
}



void free_shop( SHOP_DATA *pShop )
{
    free_string( pShop->no_such_item );
    free_string( pShop->do_not_buy );

    pShop->next = shop_free;
    shop_free   = pShop;
    return;
}



MOB_INDEX_DATA *new_mob_index( void )
{
    MOB_INDEX_DATA *pMob;
    int iAttack;

    if ( mob_index_free == NULL )
    {
        pMob           =   alloc_perm( sizeof(*pMob) );
        top_mob_index++;
    }
    else
    {
        pMob            =   mob_index_free;
        mob_index_free  =   mob_index_free->next;
    }

    *pMob               =   mob_index_zero;
    pMob->next          =   NULL;
    pMob->pShop         =   NULL;
    pMob->area          =   NULL;
    pMob->name          =   str_dup( "unset" );
    pMob->short_descr   =   str_dup( "unset" );
    pMob->long_descr    =   str_dup( "unset\n\r" );
    pMob->description   =   &str_empty[0];
    pMob->vnum          =   0;
    pMob->count         =   0;
    pMob->sex           =   0;
    pMob->act           =   0;
    pMob->timer         =   0;
    pMob->affected_by   =   0;
    pMob->money         =   0;
    pMob->size          =   SIZE_AVERAGE;
    for ( iAttack = 0;  iAttack < MAX_ATTACK_DATA;  iAttack++ )
    pMob->attacks[iAttack] = NULL;

    for ( iAttack = 0;  iAttack < MAX_SKILL;  iAttack++ )
    pMob->learned[iAttack] = 0;
    
    pMob->learned[gsn_zengalli] = 100;
    pMob->learned[gsn_dodge]    = 25;
    pMob->learned[gsn_parry]    = 25;

    return pMob;
}



void free_mob_index( MOB_INDEX_DATA *pMob )
{
    free_string( pMob->name );
    free_string( pMob->short_descr );
    free_string( pMob->long_descr );
    free_string( pMob->description );

    free_shop( pMob->pShop );

    pMob->next              = mob_index_free;
    mob_index_free          = pMob;
    return;
}




VARIABLE_DATA *new_variable( void )
{
    VARIABLE_DATA *var;

    if ( variable_free == NULL )
    {
        var      = alloc_perm( sizeof(*var) );
        top_variable++;
    }
    else
    {
        var           = variable_free;
        variable_free = variable_free->next;
    }

    *var              = variable_zero;
    var->type         = TYPE_STRING;
    var->value        = str_dup( "" );
    var->next         = NULL;
    var->next_mud_var = mud_var_list;
    mud_var_list      = var;
    return var;
}


TRIGGER_DATA *new_trigger( void )
{
    TRIGGER_DATA *trigger;


    if ( trigger_free == NULL )
    {
        trigger      = alloc_perm( sizeof(*trigger) );
        top_trigger++;
    }
    else
    {
        trigger      = trigger_free;
        trigger_free = trigger_free->next;
    }

    *trigger         = trigger_zero;
    trigger->next    = NULL;
    return trigger;
}


/*
 * Frees a variable for scripts.
 * This is used most often.
 */
void free_variable( VARIABLE_DATA *var )
{
    VARIABLE_DATA *pVar;
    
    if ( var == NULL ) return;

    free_string( var->name );

    var->next        = variable_free;
    variable_free    = var;    

    
    if ( var == mud_var_list )
    {
        mud_var_list      = var->next_mud_var;
        var->next_mud_var = NULL;
    }
    else
    {
        for ( pVar = mud_var_list;  
              pVar != NULL && pVar->next_mud_var != var;
              pVar = pVar->next_mud_var );
              
        if ( pVar == NULL || pVar->next_mud_var == NULL )
        { 
            bug( "Free_variable: var not found in list.", 0 );
            var->next_mud_var = NULL;
        }
        else
        {              
            pVar->next_mud_var = var->next_mud_var;
            var->next_mud_var  = NULL;
        }
    }
     
    return;
}


/*
 * Frees a trigger, used when a mob dies.
 */
void free_trigger( TRIGGER_DATA *trig )
{
    VARIABLE_DATA *va;
    VARIABLE_DATA *va_next;

    if ( trig == NULL ) return;

    trig->next       = trigger_free;
    trigger_free     = trig;
    
    for ( va = trig->locals;  va != NULL; va = va_next )
    {
        va_next = va->next;
        free_variable( va );
    }

    return;
}

/*
 * Hardly ever used ( will be when you can use OLC to delete indexes )
 */
void free_script( SCRIPT_DATA *scr )
{
    if ( scr == NULL ) return;

    free_string( scr->name     );
    free_string( scr->commands );

    scr->next       = script_free;
    script_free     = scr;
    return;
}

SCRIPT_DATA *new_script( void )
{
    SCRIPT_DATA *script;

    if ( script_free == NULL )
    {
        script    = alloc_perm( sizeof(*script) );
        top_script++;
    }
    else
    {
        script        = script_free;
        script_free   = script_free->next;
    }
    
    *script     = script_zero;
    script->commands = str_dup( "" );
    script->name     = str_dup( "new script" );
    return script;
}
    


/* END MEMORY RECYCLING STUFF */

/*
 * Read a letter from a file.
 */
char fread_letter( FILE *fp )
{
    char c;

    do
    {
    c = getc( fp );
    }
    while ( isspace(c) );

    return c;
}



/*
 * Read a number from a file.
 */
int fread_number( FILE *fp )
{
    int number;
    bool sign;
    char c;

    do
    {
    c = getc( fp );
    }
    while ( isspace(c) );

    number = 0;

    sign   = FALSE;
    if ( c == '+' )
    {
	c = getc( fp );
    }
    else if ( c == '-' )
    {
	sign = TRUE;
	c = getc( fp );
    }

    if ( !isdigit(c) )
    {
	bug( "Fread_number: bad format.", 0 );
	exit( 1 );
    }

    while ( isdigit(c) )
    {
	number = number * 10 + c - '0';
	c      = getc( fp );
    }

    if ( sign )
	number = 0 - number;

    if ( c == '|' )
	number += fread_number( fp );
    else if ( c != ' ' )
	ungetc( c, fp );

    return number;
}



/*
 * Read and allocate space for a string from a file.
 * These strings are read-only and shared.
 * Strings are hashed:
 *   each string prepended with hash pointer to prev string,
 *   hash code is simply the string length.
 * This function takes 40% to 50% of boot-up time.
 */
char *fread_string( FILE *fp )
{
    char *plast;
    char c;

    plast = top_string + sizeof(char *);
    if ( plast > &string_space[MAX_STRING - MAX_STRING_LENGTH] )
    {
	bug( "Fread_string: MAX_STRING %d exceeded.", MAX_STRING );
	exit( 1 );
    }

    /*
     * Skip blanks.
     * Read first char.
     */
    do
    {
	c = getc( fp );
    }
    while ( isspace(c) );

    if ( ( *plast++ = c ) == '~' )
        return &str_empty[0];

    for ( ;; )
    {
	/*
	 * Back off the char type lookup,
	 *   it was too dirty for portability.
	 *   -- Furey
	 */
	switch ( *plast = getc( fp ) )
	{
	default:
	    plast++;
	    break;

	case EOF:
	    bug( "Fread_string: EOF", 0 );
	    exit( 1 );
	    break;

	case '\n':
	    plast++;
	    *plast++ = '\r';
	    break;

	case '\r':
	    break;

	case '~':
	    plast++;
	    {
		union
		{
		    char *	pc;
		    char	rgc[sizeof(char *)];
		} u1;
		int ic;
		int iHash;
		char *pHash;
		char *pHashPrev;
		char *pString;

		plast[-1] = '\0';
		iHash     = UMIN( MAX_KEY_HASH - 1, plast - 1 - top_string );
		for ( pHash = string_hash[iHash]; pHash; pHash = pHashPrev )
		{
		    for ( ic = 0; ic < sizeof(char *); ic++ )
			u1.rgc[ic] = pHash[ic];
		    pHashPrev = u1.pc;
		    pHash    += sizeof(char *);

		    if ( top_string[sizeof(char *)] == pHash[0]
		    &&   !strcmp( top_string+sizeof(char *)+1, pHash+1 ) )
			return pHash;
		}

		if ( fBootDb )
		{
		    pString		= top_string;
		    top_string		= plast;
		    u1.pc		= string_hash[iHash];
		    for ( ic = 0; ic < sizeof(char *); ic++ )
			pString[ic] = u1.rgc[ic];
		    string_hash[iHash]	= pString;

		    nAllocString += 1;
		    sAllocString += top_string - pString;
		    return pString + sizeof(char *);
		}
		else
		{
		    return str_dup( top_string + sizeof(char *) );
		}
	    }
	}
    }
}


char *fread_string_eol( FILE *fp )
{
    static bool char_special[256-EOF];
    char *plast;
    char c;
 
    if ( char_special[EOF-EOF] != TRUE )
    {
        char_special[EOF -  EOF] = TRUE;
        char_special['\n' - EOF] = TRUE;
        char_special['\r' - EOF] = TRUE;
    }
 
    plast = top_string + sizeof(char *);
    if ( plast > &string_space[MAX_STRING - MAX_STRING_LENGTH] )
    {
        bug( "Fread_string: MAX_STRING %d exceeded.", MAX_STRING );
        exit( 1 );
    }
 
    /*
     * Skip blanks.
     * Read first char.
     */
    do
    {
        c = getc( fp );
    }
    while ( isspace(c) );
 
    if ( ( *plast++ = c ) == '\n')
        return &str_empty[0];
 
    for ( ;; )
    {
        if ( !char_special[ ( *plast++ = getc( fp ) ) - EOF ] )
            continue;
 
        switch ( plast[-1] )
        {
        default:
            break;
 
        case EOF:
            bug( "Fread_string_eol  EOF", 0 );
            exit( 1 );
            break;
 
        case '\n':  case '\r':
            {
                union
                {
                    char *      pc;
                    char        rgc[sizeof(char *)];
                } u1;
                int ic;
                int iHash;
                char *pHash;
                char *pHashPrev;
                char *pString;
 
                plast[-1] = '\0';
                iHash     = UMIN( MAX_KEY_HASH - 1, plast - 1 - top_string );
                for ( pHash = string_hash[iHash]; pHash; pHash = pHashPrev )
                {
                    for ( ic = 0; ic < sizeof(char *); ic++ )
                        u1.rgc[ic] = pHash[ic];
                    pHashPrev = u1.pc;
                    pHash    += sizeof(char *);
 
                    if ( top_string[sizeof(char *)] == pHash[0]
                    &&   !strcmp( top_string+sizeof(char *)+1, pHash+1 ) )
                        return pHash;
                }
 
                if ( fBootDb )
                {
                    pString             = top_string;
                    top_string          = plast;
                    u1.pc               = string_hash[iHash];
                    for ( ic = 0; ic < sizeof(char *); ic++ )
                        pString[ic] = u1.rgc[ic];
                    string_hash[iHash]  = pString;
 
                    nAllocString += 1;
                    sAllocString += top_string - pString;
                    return pString + sizeof(char *);
                }
                else
                {
                    return str_dup( top_string + sizeof(char *) );
                }
            }
        }
    }
}

/*
 * Read to end of line (for comments).
 */
void fread_to_eol( FILE *fp )
{
    char c;

	c = getc( fp );
    while ( c != '\n' && c != '\r' ) c = getc( fp );

    do
    {
	c = getc( fp );
    }
    while ( c == '\n' || c == '\r' );

    ungetc( c, fp );
    return;
}



/*
 * Read one word (into static buffer).
 */
char *fread_word( FILE *fp )
{
    static char word[MAX_INPUT_LENGTH];
    char *pword;
    char cEnd;

    do
    {
	cEnd = getc( fp );
    }
    while ( isspace( cEnd ) );

    if ( cEnd == '\'' || cEnd == '"' )
    {
	pword   = word;
    }
    else
    {
	word[0] = cEnd;
	pword   = word+1;
	cEnd    = ' ';
    }

    for ( ; pword < word + MAX_INPUT_LENGTH; pword++ )
    {
	*pword = getc( fp );
	if ( cEnd == ' ' ? isspace(*pword) : *pword == cEnd )
	{
	    if ( cEnd == ' ' )
		ungetc( *pword, fp );
	    *pword = '\0';
	    return word;
	}
    }

    bug( "Fread_word: word too long.", 0 );
    exit( 1 );
    return NULL;
}



/*
 * Allocate some ordinary memory, with the expectation of freeing it someday.
 */
void *alloc_mem( int sMem )
{
    void *pMem;
    int iList;

    for ( iList = 0; iList < MAX_MEM_LIST; iList++ )
    {
	if ( sMem <= rgSizeList[iList] )
	    break;
    }

    if ( iList == MAX_MEM_LIST )
    {
	bug( "Alloc_mem: size %d too large.", sMem );
	exit( 1 );
    }

    if ( rgFreeList[iList] == NULL )
    {
	pMem		  = alloc_perm( rgSizeList[iList] );
    }
    else
    {
	pMem              = rgFreeList[iList];
	rgFreeList[iList] = * ((void **) rgFreeList[iList]);
    }

    return pMem;
}



/*
 * Free some memory.
 * Recycle it back onto the free list for blocks of that size.
 */
void free_mem( void *pMem, int sMem )
{
    int iList;

    for ( iList = 0; iList < MAX_MEM_LIST; iList++ )
    {
	if ( sMem <= rgSizeList[iList] )
	    break;
    }

    if ( iList == MAX_MEM_LIST )
    {
	bug( "Free_mem: size %d too large.", sMem );
	exit( 1 );
    }

    * ((void **) pMem) = rgFreeList[iList];
    rgFreeList[iList]  = pMem;

    return;
}



/*
 * Allocate some permanent memory.
 * Permanent memory is never freed, pointers into it may be copied safely.
 */
void *alloc_perm( int sMem )
{
    static char *pMemPerm;
    static int iMemPerm;
    void *pMem;

    while ( sMem % sizeof(long) != 0 )
	sMem++;
    if ( sMem > MAX_PERM_BLOCK )
    {
	bug( "Alloc_perm: %d too large.", sMem );
	exit( 1 );
    }

    if ( pMemPerm == NULL || iMemPerm + sMem > MAX_PERM_BLOCK )
    {
	iMemPerm = 0;
	if ( ( pMemPerm = calloc( 1, MAX_PERM_BLOCK ) ) == NULL )
	{
	    perror( "Alloc_perm" );
	    exit( 1 );
	}
    }

    pMem        = pMemPerm + iMemPerm;
    iMemPerm   += sMem;
    nAllocPerm += 1;
    sAllocPerm += sMem;
    return pMem;
}



/*
 * Duplicate a string into dynamic memory.
 * Fread_strings are read-only and shared.
 */
char *str_dup( const char *str )
{
    char *str_new;

    if ( str[0] == '\0' )
        return &str_empty[0];

    if ( str >= string_space && str < top_string )
	return (char *) str;

    str_new = alloc_mem( strlen(str) + 1 );
    strcpy( str_new, str );
    return str_new;
}



/*
 * Free a string.
 * Null is legal here to simplify callers.
 * Read-only shared strings are not touched.
 */
void free_string( char *pstr )
{
    if ( pstr == NULL
    ||   pstr == &str_empty[0]
    || ( pstr >= string_space && pstr < top_string ) )
	return;

    free_mem( pstr, strlen(pstr) + 1 );
    return;
}




/*
 * This is the only thing that actually *NEEDS* to be here as in a DO_FUN
 * -- Locke
 * Syntax:  memory
 */
void do_memory( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    OBJ_DATA *obj;
    CHAR_DATA *mob;
    int count_mob = 0, count_obj = 0, count_plr = 0;
    int total = 0;

    for ( obj = object_list;  obj != NULL; obj = obj->next )
        count_obj++;

    for ( mob = char_list; mob != NULL; mob = mob->next )
    {
        if ( IS_NPC(mob) ) count_mob++;
                      else count_plr++;
    }

    total += sizeof( AFFECT_DATA      ) * top_affect;
    total += sizeof( AREA_DATA        ) * top_area;
    total += sizeof( EXTRA_DESCR_DATA ) * top_ed;
    total += sizeof( EXIT_DATA        ) * top_exit;
    total += sizeof( HELP_DATA        ) * top_help;
    total += sizeof( RESET_DATA       ) * top_reset;
    total += sizeof( SHOP_DATA        ) * top_shop;
    total += sizeof( MOB_INDEX_DATA   ) * top_mob_index;
    total += sizeof( OBJ_INDEX_DATA   ) * top_obj_index;
    total += sizeof( ROOM_INDEX_DATA  ) * top_room;
    total += sizeof( SCRIPT_DATA      ) * top_script;
    total += sizeof( VARIABLE_DATA    ) * top_variable;
    total += sizeof( TRIGGER_DATA     ) * top_trigger;
    total += sizeof( CHAR_DATA        ) * top_char_data;
    total += sizeof( OBJ_DATA         ) * top_obj;
    total += sizeof( PC_DATA          ) * top_pcdata;
    total += sizeof( ATTACK_DATA      ) * top_attack;
    total += sizeof( DESCRIPTOR_DATA  ) * top_descriptor;
    total += sizeof( NOTE_DATA        ) * top_note;
    total += sizeof( TERRAIN_DATA     ) * top_vnum_terrain;

    sprintf( buf, "Type    %5s  %7s  [%5s] Vnums\n\r", "Num", "Bytes", "Each" );  send_to_char( buf, ch );
    sprintf( buf, "Affects %5d  %7d  [%5d]\n\r",    top_affect,    sizeof( AFFECT_DATA      ) * top_affect,     sizeof( AFFECT_DATA      ) ); send_to_char( buf, ch );
    sprintf( buf, "Attacks %5d  %7d  [%5d]\n\r",    top_attack,    sizeof( ATTACK_DATA      ) * top_attack,     sizeof( ATTACK_DATA      ) ); send_to_char( buf, ch );
    sprintf( buf, "Descs   %5d  %7d  [%5d]\n\r",    top_descriptor,sizeof( DESCRIPTOR_DATA  ) * top_descriptor, sizeof( DESCRIPTOR_DATA  ) ); send_to_char( buf, ch );
    sprintf( buf, "ExDes   %5d  %7d  [%5d]\n\r",    top_ed,        sizeof( EXTRA_DESCR_DATA ) * top_ed,         sizeof( EXTRA_DESCR_DATA ) ); send_to_char( buf, ch );
    sprintf( buf, "Exits   %5d  %7d  [%5d]\n\r",    top_exit,      sizeof( EXIT_DATA        ) * top_exit,       sizeof( EXIT_DATA        ) ); send_to_char( buf, ch );
    sprintf( buf, "Helps   %5d  %7d  [%5d]\n\r",    top_help,      sizeof( HELP_DATA        ) * top_help,       sizeof( HELP_DATA        ) ); send_to_char( buf, ch );
    sprintf( buf, "Notes   %5d  %7d  [%5d]\n\r",    top_note,      sizeof( NOTE_DATA        ) * top_note,       sizeof( NOTE_DATA        ) ); send_to_char( buf, ch );
    sprintf( buf, "Areas   %5d  %7d  [%5d]\n\r",    top_area,      sizeof( AREA_DATA        ) * top_area,       sizeof( AREA_DATA        ) ); send_to_char( buf, ch );
    sprintf( buf, "MobIndx %5d  %7d  [%5d] %d\n\r", top_mob_index, sizeof( MOB_INDEX_DATA   ) * top_mob_index,  sizeof( MOB_INDEX_DATA   ), top_vnum_mob    ); send_to_char( buf, ch );
    sprintf( buf, "ObjIndx %5d  %7d  [%5d] %d\n\r", top_obj_index, sizeof( OBJ_INDEX_DATA   ) * top_obj_index,  sizeof( OBJ_INDEX_DATA   ), top_vnum_obj    ); send_to_char( buf, ch );
    sprintf( buf, "Rooms   %5d  %7d  [%5d] %d\n\r", top_room,      sizeof( ROOM_INDEX_DATA  ) * top_room,       sizeof( ROOM_INDEX_DATA  ), top_vnum_room   ); send_to_char( buf, ch );
    sprintf( buf, "Scripts %5d  %7d  [%5d] %d\n\r", top_script,    sizeof( SCRIPT_DATA      ) * top_script,     sizeof( SCRIPT_DATA      ), top_vnum_script ); send_to_char( buf, ch );
    sprintf( buf, "Resets  %5d  %7d  [%5d]\n\r",    top_reset,     sizeof( RESET_DATA       ) * top_reset,      sizeof( RESET_DATA       ) ); send_to_char( buf, ch );
    sprintf( buf, "Terrain %5d  %7d  [%5d]\n\r",    top_vnum_terrain, sizeof(TERRAIN_DATA   ) * top_vnum_terrain, sizeof(TERRAIN_DATA    ) ); send_to_char( buf, ch );
    sprintf( buf, "Shops   %5d  %7d  [%5d]\n\r",    top_shop,      sizeof( SHOP_DATA        ) * top_shop,       sizeof( SHOP_DATA        ) ); send_to_char( buf, ch );
    sprintf( buf, "Trigs   %5d  %7d  [%5d]\n\r",    top_trigger,   sizeof( TRIGGER_DATA     ) * top_trigger,    sizeof( TRIGGER_DATA     ) ); send_to_char( buf, ch );
    sprintf( buf, "Vars    %5d  %7d  [%5d]\n\r",    top_variable,  sizeof( VARIABLE_DATA    ) * top_variable,   sizeof( VARIABLE_DATA    ) ); send_to_char( buf, ch );
    sprintf( buf, "CharD   %5d  %7d  [%5d]\n\r",    top_char_data, sizeof( CHAR_DATA        ) * top_char_data,  sizeof( CHAR_DATA        ) ); send_to_char( buf, ch );
    sprintf( buf, "ObjD    %5d  %7d  [%5d]\n\r",    top_obj,       sizeof( OBJ_DATA         ) * top_obj,        sizeof( OBJ_DATA         ) ); send_to_char( buf, ch );
    sprintf( buf, "PcD     %5d  %7d  [%5d]\n\r",    top_pcdata,    sizeof( PC_DATA          ) * top_pcdata,     sizeof( PC_DATA          ) ); send_to_char( buf, ch );
    sprintf( buf, "Socials %5d  %7d  [%5d]\n\r",    social_count,  sizeof( struct social_type ) * social_count, sizeof( struct social_type ) ); send_to_char( buf, ch );
    sprintf( buf, "Mobiles %5d  %7d  [%5d]*\n\r",   count_mob,     count_mob * sizeof( CHAR_DATA ),             sizeof( CHAR_DATA ) );        send_to_char( buf, ch );
    sprintf( buf, "Objects %5d  %7d  [%5d]*\n\r",   count_obj,     count_obj * sizeof( OBJ_DATA  ),             sizeof( OBJ_DATA  ) );        send_to_char( buf, ch );
    sprintf( buf, "Players %5d  %7d  [%5d]*\n\r",   count_plr,     count_plr * (sizeof( CHAR_DATA ) + sizeof( PC_DATA )), sizeof( CHAR_DATA ) + sizeof( PC_DATA ) ); send_to_char( buf, ch );

    sprintf( buf, "Total type allocation is %d bytes.\n\r", total );
    send_to_char( buf, ch );


    sprintf( buf, "Booted with %d strings of %d/%d bytes.\n\r",
             nAllocString, sAllocString, MAX_STRING );
    send_to_char( buf, ch );

    sprintf( buf, "Perms %d blocks of %d bytes.\n\r",
             nAllocPerm, sAllocPerm );
    send_to_char( buf, ch );

    {
    extern int packet[60];
    extern int packet_count;
    extern int byte_count;
    
    int p;
    int tot = 0;
   
    for ( p = 0; p < 60; p++ )
    {
      if ( packet[p] == -1 ) continue;
      tot += packet[p];
    }
      
    sprintf( buf,
     "Average IP packets per minute is %d, total packets sent: %d (%d bytes)\n\r",
     tot / UMAX(p,1), packet_count, byte_count );
    send_to_char( buf, ch );
    }

    return;
}






