/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "defaults.h"



void update_money( OBJ_DATA *obj )
{
    char buf[MAX_STRING_LENGTH];
    char buf1[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    char buf3[MAX_STRING_LENGTH];

    if ( obj->item_type != ITEM_MONEY )
    {
        bug( "update_money: item is not of type money.", 0 );
        return;
    }

    if ( obj->value[0] > 1  )
    {
    obj->pIndexData = get_obj_index( OBJ_VNUM_MONEY_SOME );
    if ( obj->value[0] <= 10 )       strcpy( buf, "few"               ); else
    if ( obj->value[0] <= 100 )      strcpy( buf, "small pile of"     ); else
    if ( obj->value[0] <= 1000 )     strcpy( buf, "pile of"           ); else
    if ( obj->value[0] <= 10000 )    strcpy( buf, "large pile of"     ); else
    if ( obj->value[0] <= 100000 )   strcpy( buf, "heaping mound of"  ); else
    if ( obj->value[0] <= 1000000 )  strcpy( buf, "small hill of"     ); else
    if ( obj->value[0] <= 10000000 ) strcpy( buf, "mountain of"       );
                                else strcpy( buf, "whole shitload of" );

    sprintf( buf1, obj->pIndexData->short_descr, numberize( obj->value[0] ),
                   coin_table[obj->value[1]].long_name );
    sprintf( buf2, obj->pIndexData->description, buf,
                   coin_table[obj->value[1]].long_name );
    sprintf( buf3, obj->pIndexData->name, coin_table[obj->value[1]].long_name );
    free_string( obj->name );        obj->name        = str_dup( buf3 );
    free_string( obj->description ); obj->description = str_dup( buf2 );
    free_string( obj->short_descr ); obj->short_descr = str_dup( buf1 );
    obj->weight         = (obj->value[0] * coin_table[obj->value[1]].weight) / 20;
    obj->cost           = obj->value[0] * coin_table[obj->value[1]].convert;
    }
    else
    if ( obj->value[0] == 1 )
    {
    obj->pIndexData = get_obj_index( OBJ_VNUM_MONEY_ONE );
    sprintf( buf1, obj->pIndexData->short_descr,
                   coin_table[obj->value[1]].long_name );
    sprintf( buf2, obj->pIndexData->description,
                   coin_table[obj->value[1]].long_name );
    sprintf( buf3, obj->pIndexData->name, coin_table[obj->value[1]].long_name);
    free_string( obj->name );           obj->name        = str_dup( buf3 );
    free_string( obj->description );    obj->description = str_dup( buf2 );
    free_string( obj->short_descr );    obj->short_descr = str_dup( buf1 );
    obj->weight         = coin_table[obj->value[1]].weight;
    obj->cost           = coin_table[obj->value[1]].convert;
    }

    return;
}

OBJ_DATA *create_money( int amount, int type )
{
    OBJ_DATA *obj;

    if ( amount <= 0 )
    {
    bug( "Create_money: zero or negative money %d.", amount );
    amount = 1;
    }

    if ( amount == 1 )
    {
    obj = create_object( get_obj_index( OBJ_VNUM_MONEY_ONE ), 0 );
    obj->item_type      = ITEM_MONEY;
    obj->value[0]       = 1;
    obj->value[1]       = type;
    obj->wear_loc       = -1;
    obj->weight         = coin_table[type].weight;
    obj->cost           = coin_table[type].convert;
    update_money( obj );
    }
    else
    {
	obj = create_object( get_obj_index( OBJ_VNUM_MONEY_SOME ), 0 );
    obj->value[0]       = amount;
    obj->value[1]       = type;
    obj->item_type      = ITEM_MONEY;
    obj->wear_loc       = -1;
    obj->weight         = amount * coin_table[type].weight / 16;
    obj->cost           = amount * coin_table[type].convert;
    update_money( obj );
    }

    return obj;
}

/*
 * Conglomerate several money items.
 */
void merge_money( CHAR_DATA *ch )
{
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    int sub_totals[MAX_COIN];
    int type;

    for ( type = 0; type < MAX_COIN; type++ )
    {
        sub_totals[type] = tally_one_coin( ch, type, FALSE );
    }

    for ( obj = ch->carrying;  obj != NULL;  obj = obj_next )
    {
        obj_next = obj->next_content;
        if ( obj->item_type == ITEM_MONEY )
        {
            obj_from_char( obj );
            extract_obj( obj );
        }
    }

    for ( type = 0; type < MAX_COIN; type++ )
    {
        if ( sub_totals[type] > 0 )
        {
            obj_to_char( (obj = create_money( sub_totals[type], type )), ch );
            obj->wear_loc = hand_empty( ch );
        }
    }
    return;
}

void merge_money_obj( OBJ_DATA *obj )
{
    OBJ_DATA *iobj;
    OBJ_DATA *obj_next;
    int sub_totals[MAX_COIN];
    int type;

    for ( type = 0; type < MAX_COIN; type++ )
    {
        sub_totals[type] = tally_one_coin_obj( obj, type );
    }

    for ( iobj = obj->contains;  iobj != NULL;  iobj = obj_next )
    {
        obj_next = iobj->next_content;
        if ( iobj->item_type == ITEM_MONEY )
        {
            obj_from_obj( iobj );
            extract_obj( iobj );
        }
    }

    for ( type = 0; type < MAX_COIN; type++ )
    {
        if ( sub_totals[type] > 0 )
          obj_to_obj( create_money( sub_totals[type], type ), obj );
    }
    return;
}

/*
 * Create a set of 'money' objects.
 */
void create_amount( int amount, CHAR_DATA *pMob, ROOM_INDEX_DATA *pRoom,
                    OBJ_DATA *pObj )
{
    OBJ_DATA *obj;
    int type;

    if ( amount <= 0 )
    {
    bug( "Create_amount: zero or negative money %d.", amount );
    return;
    }

    if ( amount == 1 )
    {
    obj = create_money( 1, MAX_COIN-1 );
    if ( pMob ) obj_to_char_money( obj, pMob );
    if ( pRoom ) obj_to_room( obj, pRoom );
    if ( pObj ) obj_to_obj( obj, pObj );
    }
    else
    if ( amount < 30 && (amount % 10 != 0) )
    {
    obj = create_money( amount, MAX_COIN-1 );
    if ( pMob ) obj_to_char_money( obj, pMob );
    if ( pRoom ) obj_to_room( obj, pRoom );
    if ( pObj ) obj_to_obj( obj, pObj );
    }
    else
    {
        for ( type = 0; type < MAX_COIN; type++ )
        {

        if ( amount/coin_table[type].convert <= 0 )
            continue;

        obj = create_money( amount/coin_table[type].convert, type );
        amount %= coin_table[type].convert;

        if ( pMob ) obj_to_char_money( obj, pMob );
        if ( pRoom ) obj_to_room( obj, pRoom );
        if ( pObj ) obj_to_obj( obj, pObj );
        }
    }

    if ( pMob ) merge_money( pMob );
    if ( pObj ) merge_money_obj( pObj );
    return;
}


/*
 * Tally the number of coins a character has.
 */
int tally_coins( CHAR_DATA *mob )
{
    OBJ_DATA *obj;
    int total = 0;

    for ( obj = mob->carrying;  obj != NULL; obj = obj->next_content )
    {
        if ( obj->item_type == ITEM_MONEY
          && obj->value[1] >= 0
          && obj->value[1] < MAX_COIN )
        total += obj->value[0] * coin_table[obj->value[1]].convert;

        if ( ( obj->value[1] < 0 || obj->value[1] >= MAX_COIN ) 
          && obj->item_type == ITEM_MONEY )
        {
        bug( "Tally_coins: obj (vnum %d) bad coinage",
             obj->pIndexData->vnum );
        obj->value[1] = URANGE( 0, obj->value[1], MAX_COIN-1 );
        }

        if ( obj->item_type == ITEM_CONTAINER )
        {
            OBJ_DATA *iobj;

            for ( iobj = obj->contains; iobj != NULL; iobj = iobj->next_content )
            {
                if ( iobj->item_type == ITEM_MONEY
                  && iobj->value[1] >= 0
                  && iobj->value[1] < MAX_COIN )
                total += iobj->value[0] * coin_table[iobj->value[1]].convert;

                if ( ( iobj->value[1] < 0 || iobj->value[1] >= MAX_COIN )
                  && iobj->item_type == ITEM_MONEY )
                {
                bug( "Tally_coins: iobj (vnum %d) bad coinage",
                     iobj->pIndexData->vnum );
                iobj->value[1] = URANGE( 0, iobj->value[1], MAX_COIN-1 );
                }
            }
        }
    }

    return total;
}

/*
 * Tally the number of A SINGLE TYPE OF coin a character has.
 */
int tally_one_coin( CHAR_DATA *mob, int type, bool fContents )
{
    OBJ_DATA *obj;
    int total = 0;

    for ( obj = mob->carrying;  obj != NULL; obj = obj->next_content )
    {
        if ( obj->item_type == ITEM_MONEY
          && obj->value[1] >= 0
          && obj->value[1] < MAX_COIN
          && obj->value[1] == type )
        total += obj->value[0];

        if ( ( obj->value[1] < 0 || obj->value[1] >= MAX_COIN ) 
           && obj->item_type == ITEM_MONEY )
        {
        bug( "Tally_one_coin: obj (vnum %d) bad coinage",
             obj->pIndexData->vnum );
        obj->value[1] = URANGE( 0, obj->value[1], MAX_COIN-1 );
        }

        if ( obj->item_type == ITEM_CONTAINER
           && fContents )
        {
            OBJ_DATA *iobj;

            for ( iobj = obj->contains; iobj != NULL;
                  iobj = iobj->next_content )
            {
                if ( iobj->item_type == ITEM_MONEY
                  && iobj->value[1] >= 0
                  && iobj->value[1] < MAX_COIN
                  && iobj->value[1] == type )
                total += iobj->value[0];

                if ( ( iobj->value[1] < 0 || iobj->value[1] >= MAX_COIN )
                  && iobj->item_type == ITEM_MONEY )
                {
                bug( "Tally_one_coin: iobj (vnum %d) bad coinage",
                     iobj->pIndexData->vnum );
                iobj->value[1] = URANGE( 0, iobj->value[1], MAX_COIN-1 );
                }
            }
        }
    }

    return total;
}

/*
 * Tally the number of A SINGLE TYPE OF coin an object contains.
 */
int tally_one_coin_obj( OBJ_DATA *obj, int type )
{
    OBJ_DATA *iobj;
    int total = 0;

    for ( iobj = obj->contains;  iobj != NULL; iobj = iobj->next_content )
    {
        if ( iobj->item_type == ITEM_MONEY
          && iobj->value[1] >= 0
          && iobj->value[1] < MAX_COIN
          && iobj->value[1] == type )
        total += iobj->value[0];

        if ( ( iobj->value[1] < 0 || iobj->value[1] >= MAX_COIN )
          && iobj->item_type == ITEM_MONEY )
        {
        bug( "Tally_one_coin_obj: iobj (vnum %d) bad coinage",
             iobj->pIndexData->vnum );
        iobj->value[1] = URANGE( 0, iobj->value[1], MAX_COIN-1 );
        }
    }

    return total;
}


/*
 * Create a cost out of the blue.
 */
char *name_amount( int amount )
{
    static char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    int type;

    if ( amount < 20 && amount != 0 )
    {
    sprintf( buf, "%d copper", amount );
    return buf;
    }

    buf[0] = '\0';

    for ( type = 0; ; type++ )
    {
    if (type >= MAX_COIN || amount == 0 )
        break;

    if ( amount/coin_table[type].convert <= 0 )
        continue;

    sprintf( buf2, "%s%s %s", buf[0] != '\0' ? ", " : "",
                              numberize( (amount/coin_table[type].convert) ),
                              coin_table[type].long_name );
    strcat( buf, buf2 );
    amount %= coin_table[type].convert;
    }
    if ( buf[0] == '\0' ) sprintf( buf, "nothing" );

    return buf;
}

/*
 * Nail unused money items.
 */
void strip_empty_money( CHAR_DATA *ch )
{
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    OBJ_DATA *iobj;
    OBJ_DATA *iobj_next;

    for ( obj = ch->carrying;  obj != NULL;  obj = obj_next )
    {
        obj_next = obj->next_content;
        if ( obj->item_type == ITEM_MONEY  && obj->value[0] <= 0 )
        {
            obj_from_char( obj );
            extract_obj( obj );
        }

        for ( iobj = obj->contains;  iobj != NULL; iobj = iobj_next )
        {
        iobj_next = iobj->next_content;
        if ( iobj->item_type == ITEM_MONEY  && iobj->value[0] <= 0 )
        {
            obj_from_obj( iobj );
            extract_obj( iobj );
        }
        }
    }
    return;
}
     

/*
 * Ok, here's the tricky part... managing two money totals at once,
 * this is the routine that makes the change if you give the dude
 * too much.  This is for shops mainly, but can be used elsewhere.
 */
char *sub_coins( int amount, CHAR_DATA *ch )
{
    OBJ_DATA *obj;
    OBJ_DATA *iobj;
    int money = 0;

    if ( tally_coins( ch ) < amount )
    {
        bug( "Sub_coins: ch doesn't have enough money (%d)", amount );
        return "nothing";
    }

    for ( obj = ch->carrying;  obj != NULL;  obj = obj->next_content )
    {
        if ( money >= amount ) break;
        if ( obj->item_type == ITEM_MONEY )
        {
            while ( obj->value[0] > 0 && money < amount )
            {
                 money += coin_table[obj->value[1]].convert;
                 obj->value[0]--;
            }
            if ( obj->value[0] > 0 ) update_money( obj );
        }

        for ( iobj = obj->contains;  iobj != NULL;  iobj = iobj->next_content )
        {
        if ( money >= amount ) break;
        if ( iobj->item_type == ITEM_MONEY )
        {
            while ( iobj->value[0] > 0 && money < amount )
            {
                 money += coin_table[iobj->value[1]].convert;
                 iobj->value[0]--;
            }
            if ( iobj->value[0] > 0 ) update_money( iobj );
        }
        }
    }

    strip_empty_money( ch );
    if ( money > amount ) create_amount( money - amount, ch, NULL, NULL );
    return name_amount( money - amount );
}


