/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "skills.h"



void dismount_char( CHAR_DATA *ch )
{
    CHAR_DATA *vict;

    vict = ch->riding;
    if  ( vict == NULL )
    {
        vict = ch->rider;
        ch->rider = NULL;
        if ( vict == NULL ) return;
        vict->riding = NULL;
    }
    else
    {
        ch->riding = NULL;
        vict->rider = NULL;
    }

    return;
}

void mount_char( CHAR_DATA *ch, CHAR_DATA *victim )
{
   if ( ch == NULL ) return;
   if ( victim == NULL ) return;
   
   if ( ch->in_room != victim->in_room )
   bug( "Mount_char: Ch and victim not in same room.", 0 );

   if ( ch->rider != NULL )
   dismount_char( ch->rider );

   if ( ch->riding != NULL )
   dismount_char( ch );

   if ( victim->rider != NULL )
   dismount_char( victim->rider );

   if ( victim->riding != NULL )
   dismount_char( victim );

   ch->riding = victim;
   victim->rider = ch;

   set_furn( ch, NULL );
   set_furn( victim, NULL );
   return;
}



/*
 * Syntax:  mount [person]
 */
void do_mount( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, buf );

    if ( buf[0] == '\0' )
    {
        send_to_char( "Mount whom?\n\r", ch );
        return;
    }

    if ( ( victim = get_char_room( ch, buf ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }
    
    if ( ch->riding != NULL )
    {
        act( "You are already riding $N!", ch, NULL, ch->riding, TO_CHAR );
        return;
    }

    if ( ch->rider != NULL )
    {
        act( "$N is riding you!", ch, NULL, ch->rider, TO_CHAR );
        return;
    }

    if ( (IS_NPC(victim) && !IS_SET( victim->act, ACT_MOUNT ))
      && !IS_IMMORTAL(ch) )
    {
        send_to_char( "You cannot ride that.\n\r", ch );
        return;
    }

    if ( victim->riding != NULL )
    {
        act( "$N is already riding $n.", victim, NULL, victim->rider, TO_CHAR );
        return;
    }

    if ( victim->rider != NULL )
    {
        act( "$N is riding $n.", victim, NULL, victim->rider, TO_CHAR );
        return;
    }

    mount_char( ch, victim );

    act( "$n leaps onto $N's back.", ch, NULL, victim, TO_ROOM );
    act( "You leap onto $N's back.",  ch, NULL, victim, TO_CHAR );
    act( "$n leaps onto your back.",  ch, NULL, victim, TO_VICT );

    if ( victim->position == POS_RESTING
      || victim->position == POS_SITTING  )
    {
        act( "You clamber groggily to your feet.", victim, NULL, NULL, TO_CHAR );
        act( "$n clambers groggily to $s feet.", victim, NULL, NULL, TO_ROOM );
        victim->position = POS_STANDING;
    }
    return;
}



/*
 * Syntax:  dismount
 */
void do_dismount( CHAR_DATA *ch, char *argument )
{
    if ( ch->riding == NULL )
    {
        send_to_char( "You're not riding anything.\n\r", ch );
        return;
    }

    act( "$n dismounts from $N.",  ch, NULL, ch->riding, TO_NOTVICT );
    act( "You swing your legs aside and dismount $N.",  ch, NULL, ch->riding, TO_CHAR );
    act( "$n dismounts from you.", ch, NULL, ch->riding, TO_VICT );

    dismount_char( ch );
    return;
}


