/***************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/



/*
 * Accommodate old non-Ansi compilers.
 */
#if defined(TRADITIONAL)
#define const
#define args( list )            ( )
#define DECLARE_DO_FUN( fun )        void fun( )
#define DECLARE_SPEC_FUN( fun )        bool fun( )
#define DECLARE_SPELL_FUN( fun )        void fun( )
#define DECLARE_LEARN_FUN( fun )        bool fun( )
#define DECLARE_HIT_FUN( fun )          void fun( )
#else
#define args( list )            list
#define DECLARE_DO_FUN( fun )           DO_FUN    fun
#define DECLARE_SPEC_FUN( fun )        SPEC_FUN  fun
#define DECLARE_SPELL_FUN( fun )        SPELL_FUN fun
#define DECLARE_LEARN_FUN( fun )        LEARN_FUN fun
#define DECLARE_HIT_FUN( fun )          HIT_FUN   fun
#endif



/*
 * Short scalar types.
 * Diavolo reports AIX compiler has bugs with short types.
 */
#if    !defined(FALSE)
#define FALSE     0
#endif

#if    !defined(TRUE)
#define TRUE     1
#endif

#if    defined(_AIX)
#if    !defined(const)
#define const
#endif
typedef int                sh_int;
typedef int                bool;
#define unix
#else
typedef short    int            sh_int;
typedef unsigned char            bool;
#endif



/*
 * Structure types.
 */
typedef struct  affect_data        AFFECT_DATA;
typedef struct  area_data          AREA_DATA;
typedef struct  ban_data           BAN_DATA;
typedef struct  char_data          CHAR_DATA;
typedef struct  descriptor_data    DESCRIPTOR_DATA;
typedef struct  exit_data          EXIT_DATA;
typedef struct  extra_descr_data   EXTRA_DESCR_DATA;
typedef struct  help_data          HELP_DATA;
typedef struct  kill_data          KILL_DATA;
typedef struct  mob_index_data     MOB_INDEX_DATA;
typedef struct  number_data        NUMBER_DATA;
typedef struct  attack_data        ATTACK_DATA;
typedef struct  note_data          NOTE_DATA;
typedef struct  obj_data           OBJ_DATA;
typedef struct  obj_index_data     OBJ_INDEX_DATA;
typedef struct  pc_data            PC_DATA;
typedef struct  room_index_data    ROOM_INDEX_DATA;
typedef struct  reset_data         RESET_DATA;
typedef struct  shop_data          SHOP_DATA;
typedef struct  time_info_data     TIME_INFO_DATA;
typedef struct  weather_data       WEATHER_DATA;
typedef struct  script_data        SCRIPT_DATA;
typedef struct  trigger_data       TRIGGER_DATA;
typedef struct  variable_data      VARIABLE_DATA;
typedef struct  terrain_data       TERRAIN_DATA;



/*
 * Function types.
 */
typedef    void DO_FUN    args( ( CHAR_DATA *ch, char *argument ) );
typedef bool SPEC_FUN    args( ( CHAR_DATA *ch ) );
typedef void SPELL_FUN    args( ( int sn, int level, CHAR_DATA *ch, void *vo ) );
typedef bool LEARN_FUN  args( ( CHAR_DATA *ch, int sn, bool fTell ) );
typedef bool HIT_FUN    args( ( CHAR_DATA *ch, CHAR_DATA *victim, int hit, int dam ) );



/*
 * String and memory management parameters.
 */
#define    MAX_KEY_HASH         1024
#define MAX_STRING_LENGTH     4096
#define MAX_INPUT_LENGTH      512
#define WORK_STRING_LENGTH        512

 /*  1/21/95 */
 /*  3/26/95 */
 /*  7/17/95 */
 /*  9/13/95 */
 /* 10/29/95 */
 /* 03/02/96 */
 /* 03/27/96 */
 /* 04/12/96 */
 /* 10/27/96 */
 /* 10/17/98 */

#define VERSION_STR       "NIM Server Update 13-OCT-99"


/*
 * Game parameters.
 * Increase the max'es if you add more of something.
 * Adjust the pulse numbers to suit yourself.
 */
#define MAX_AREA                  200
#define MAX_ATTACK_DATA             5
#define MAX_COIN                    5
#define MAX_COLORS                 10
#define MAX_USED_COLORS             3
#define MAX_LEVEL                  10
#define MAX_RACE                    8
#define MAX_SKILL                 120
#define MAX_SOCIALS               256
#define MAX_TRADE                   8
#define MAX_ATTACK                 15
#define MAX_LANGUAGE               10
#define MAX_DEBUG                   5

#define LEVEL_GOD                  MAX_LEVEL                        /* 10 */
#define LEVEL_DEMIGOD              9
#define LEVEL_SUPREME              8
#define LEVEL_ANGEL                7

#define LEVEL_BUILDER              5
#define LEVEL_IMMORTAL             4
#define LEVEL_HERO                 3
#define LEVEL_MORTAL               2
#define LEVEL_APPLIED              1
#define LEVEL_NEW                  0

#define LEVEL_SCRIPT               (LEVEL_BUILDER)

/*
 * Time synchronization.
 */
#define PULSE_PER_SECOND             4                      /* 1/4 second */
#define PULSE_VIOLENCE            (  3 * PULSE_PER_SECOND)  /* 3 seconds  */
#define PULSE_MOBILE              (  4 * PULSE_PER_SECOND)  /* 4 seconds  */
#define PULSE_TICK                (300 * PULSE_PER_SECOND)  /* 5 minutes  */
#define PULSE_AREA                ( 60 * PULSE_PER_SECOND)  /* 1 minute   */

/*
 * TO types for act.
 */
#define TO_ROOM             0
#define TO_NOTVICT          1
#define TO_VICT             2
#define TO_CHAR             3
#define TO_ALL              4


/*
 * Fill bits for argument_interpret.
 */
#define FA_IN       0x00000001
#define SA_IN       0x00000002
#define FA_ON       0x00000004
#define SA_ON       0x00000008
#define FA_HERE     0x00000010
#define SA_HERE     0x00000020
#define FA_MY       0x00000040
#define SA_MY       0x00000080

/*
 * Site ban structure.
 */
struct    ban_data
{
    BAN_DATA *    next;
    char *    name;
};



/*
 * Time and weather stuff.
 * Note that weather changes according to the month (winter).
 */
#define SUN_DARK            0
#define SUN_RISE            1
#define SUN_LIGHT            2
#define SUN_SET                3
#define MOON_RISE                   4
#define MOON_SET                    5

#define SKY_CLOUDLESS            0
#define SKY_CLOUDY                  1
#define SKY_RAINING            2
#define SKY_LIGHTNING            3

#define MOON_NEW                    0
#define MOON_WAXING_CRESCENT        1
#define MOON_WAXING_HALF            2
#define MOON_WAXING_THREE_QUARTERS  3
#define MOON_FULL                   4
#define MOON_WANING_THREE_QUARTERS  5
#define MOON_WANING_HALF            6
#define MOON_WANING_CRESCENT        7
#define MOON_MAX                    8

struct    time_info_data
{
    sh_int      hour;
    sh_int      day;
    sh_int      month;
    sh_int      year;
};

struct    weather_data
{
    int        mmhg;
    int        change;
    sh_int      sky;
    sh_int      sunlight;
    sh_int      windspeed;
    sh_int      winddir;            
    sh_int      temperature;
    sh_int      moon_phase;
    sh_int      next_phase;
};



/*
 * For world generator.
 */
struct    terrain_data
{
    TERRAIN_DATA  *next;
    int        vnum;
    int        sector;
    char       map_char;
    char *     fall;
    char *     spring;
    char *     summer;
    char *     winter;
    char *     name;
};




/*
 * Descriptor (channel) structure.
 */
struct    descriptor_data
{
    DESCRIPTOR_DATA *    next;
    DESCRIPTOR_DATA *    snoop_by;
    CHAR_DATA *         character;
    CHAR_DATA *        original;
    char *        host;
    sh_int        descriptor;
    sh_int        connected;
    bool        fcommand;
    bool                fpromptok;
    char                inbuf       [4 * MAX_INPUT_LENGTH];
    char                incomm      [MAX_INPUT_LENGTH];
    char                inlast      [MAX_INPUT_LENGTH];
    int            repeat;
    char *              showstr_head;
    char *              showstr_point;
    char *        outbuf;
    int            outsize;
    int            outtop;
    void *              pEdit;
    char **             pString;
};



/*
 * Attribute bonus structures.
 */
struct    str_app_type
{
    sh_int    tohit;
    sh_int    todam;
    sh_int    carry;
    sh_int    wield;
};

struct    int_app_type
{
    sh_int      spell_level;
    sh_int    learn;
};

struct    wis_app_type
{
    sh_int      spell_level;
    sh_int    practice;
};

struct    dex_app_type
{
    sh_int    defensive;
};

struct    con_app_type
{
    sh_int    hitp;
    sh_int      resistance;
    sh_int    shock;
};


struct lang_type
{
    char *      name;
    sh_int *    pgsn;
};


struct goods_type
{
    char *      name;
    char *      unit;
    sh_int      code;
    sh_int      cost;
    sh_int      weight;
    sh_int      life;
};


struct gem_list_type
{
    char * name;
    int mana_value;
    int mana_flags;
    int cost;
    char * plural;
};


/*
 * Help table types.
 */
struct    help_data
{
    HELP_DATA *    next;
    sh_int    level;
    char *    keyword;
    char *    text;
};



/*
 * Shop types.
 */
#define SHOP_TRADER         0x00000001
#define SHOP_PEDDLER        0x00000002
#define SHOP_REPAIR         0x00000004
#define SHOP_COMPONENTS     0x00000008
#define SHOP_TAVERN         0x00000010

struct    shop_data
{
    SHOP_DATA * next;                   /* Next Shop in List            */
    sh_int    keeper;            /* Vnum of shop keeper mob    */
    sh_int      buy_type [MAX_TRADE];   /* Item types shop will buy     */
    sh_int    profit_buy;        /* Cost multiplier for buying    */
    sh_int    profit_sell;        /* Cost multiplier for selling    */
    sh_int    open_hour;        /* First opening hour        */
    sh_int    close_hour;        /* First closing hour        */
    sh_int      shop_flags;             /* Bits                         */
    sh_int      repair_rate;            /* Cost per unit of armor       */
    int         buy_index;              /* Index of trade items bought  */
    int         sell_index;             /* Index of trade items sold    */
    int         comp_index;             /* Index of components sold     */
    char *      no_such_item;           /* Keeper hasn't got that item  */
    char *      do_not_buy;             /* Keeper won't buy such things */
    char *      list_header;            /* Displayed on peddler list    */
};



struct  race_type
{
   char *   race_name;
   sh_int   bonus          [5];
   int      start_room;
   int      max_skills;
   int      affect_bits;
   int      size;
   int      base_age;
   int      start_age;
};


/*
 * One coin.
 */
struct coin_type
{
   int      multiplier;
   int      convert;
   int      weight;
   char *   long_name;
   char *   short_name;
};




/*
 * Un colour type.
 */
struct color_data
{
   char         code[10];
   char         act_code[5];
   char         name[15];
};


/*
 * Board information.
 */
struct board_data
{
    char *name;
    char *filename;
    int writelevel;
    int readlevel;
};


#define NOTE_ANONYMOUS          1

/*
 * Data structure for notes.
 */
struct    note_data
{
    NOTE_DATA *    next;
    char *    sender;
    char *    date;
    char *      to_list;
    char *    subject;
    char *    text;
    time_t      date_stamp;
    sh_int      note_flags;
};



/*
 * An affect.
 */
struct    affect_data
{
    AFFECT_DATA *    next;
    sh_int        location;
    sh_int        modifier;
    sh_int              type;
    sh_int              duration;
    int            bitvector;
};



/*
 * Types of attacks.
 * Must be non-overlapping with spell/skill types,
 * but may be arbitrary beyond that.
 */
#define TYPE_HIT                     1000
#define TYPE_SLASH                   1001
#define TYPE_PIERCE                  1002
#define TYPE_WHIP                    1003
#define TYPE_EXPLODE                 1004
#define TYPE_POUND                   1005
#define TYPE_SUCTION                 1006
#define TYPE_SHOT                    1007

/*
 * For extra attacks on mobiles.
 */
struct attack_data
{
     ATTACK_DATA * next;
     int           idx;       /* See attack_table for this value */
     sh_int        dam1;
     sh_int        dam2;
};

                     /* AMI DOLENZ I LOVE YOU! */

/*
 * For attack table.
 */
struct attack_type
{
     char     * name;
     int        hit_type;
     sh_int   * wpgsn;                 /* which slot? */
     HIT_FUN  * hit_fun;
};


/*
 * Ansi colors and VT100 codes.
 * On most machines that use ANSI, namely the IBM PCs, the decimal value for
 * the escape character is 27 (1B hex).     Change this value when needed.
 */

#define ESC        '\x1b'

#define BLACK      "\x1b[30m"    /* These are foreground color codes */
#define RED        "\x1b[31m"
#define GREEN      "\x1b[32m"
#define YELLOW     "\x1b[33m"
#define BLUE       "\x1b[34m"
#define PURPLE     "\x1b[35m"
#define CYAN       "\x1b[36m"
#define GREY       "\x1b[37m"

#define B_BLACK    "\x1b[40m"    /* These are background color codes */
#define B_RED      "\x1b[41m"
#define B_GREEN    "\x1b[42m"
#define B_YELLOW   "\x1b[43m"
#define B_BLUE     "\x1b[44m"
#define B_PURPLE   "\x1b[45m"
#define B_CYAN     "\x1b[46m"
#define B_GREY     "\x1b[47m"

/* Below are VT100 and ANSI codes (above are ANSI exclusively)       */

#define EEEE       "\x1b#8"                 /* Turns screen to EEEEs */
#define CLRSCR     "\x1b[2J"                /* Clear screen          */
#define CLREOL     "\x1b[K"                 /* Clear to end of line  */

#define UPARR      "\x1b[A"                 /* Up one line           */
#define DOWNARR    "\x1b[B"                 /* Down one line         */
#define RIGHTARR   "\x1b[C"                 /* Right one column      */
#define LEFTARR    "\x1b[D"                 /* Left one column       */
#define HOMEPOS    "\x1b[H"                 /* Home (upper left)     */

#define BOLD       "\x1b[1m"                /* High intensity        */
#define FLASH      "\x1b[5m"                /* Flashing text         */
#define INVERSE    "\x1b[7m"                /* XORed back and fore   */
#define NTEXT      "\x1b[0m"                /* Normal text  (grey)   */
#define ANSI_NORMAL "\x1b[0m"               /* ""                    */

/*
 * Other codes of note for future ANSI development:
 * The <esc>[y;xH code works nicely for positioning the cursor.
 */


/************************************************************************
 *                      Mobile information.                             *
 ************************************************************************/

/*
 * Act bits.  (Behavior)
 */
#define ACT_IS_NPC           0x00000001         /* Auto set for mobs    */
#define ACT_SENTINEL         0x00000002         /* Stays in one room    */
      /* Used to be SCAVENGER */
#define ACT_HALT             0x00000008         /* die script die!      */

#define ACT_AGGRESSIVE       0x00000020         /* Attacks PC's         */
#define ACT_STAY_AREA        0x00000040         /* Won't leave area     */
#define ACT_WIMPY            0x00000080         /* Flees when hurt      */
#define ACT_PET              0x00000100         /* Auto set for pets    */
#define ACT_TRAIN            0x00000200         /* Can train PC's       */
#define ACT_PRACTICE         0x00000400         /* Can practice PC's    */
      /* Used to be TRACKSCR */
      /* Used to be SCRAMBLE */
#define ACT_MOUNT            0x00002000         /* can be mounted       */
#define ACT_NOSCAN           0x00004000         /* not seen on scan     */


/*
 * Affect bits.
 */
#define AFF_BLIND            0x00000001
#define AFF_INVISIBLE        0x00000002
#define AFF_DETECT_EVIL      0x00000004
#define AFF_DETECT_INVIS     0x00000008
#define AFF_DETECT_MAGIC     0x00000010
#define AFF_DETECT_HIDDEN    0x00000020
#define AFF_HOLD             0x00000040
#define AFF_SANCTUARY        0x00000080
#define AFF_FAERIE_FIRE      0x00000100
#define AFF_INFRARED         0x00000200
#define AFF_CURSE            0x00000400
#define AFF_FLAMING          0x00000800        /* Unused       */
#define AFF_POISON           0x00001000
#define AFF_PROTECT          0x00002000
#define AFF_PARALYSIS        0x00004000        /* Unused       */
#define AFF_SNEAK            0x00008000
#define AFF_HIDE             0x00010000
#define AFF_SLEEP            0x00020000
#define AFF_CHARM            0x00040000
#define AFF_FLYING           0x00080000
#define AFF_PASS_DOOR        0x00100000
#define AFF_FREEACTION       0x00200000
#define AFF_BREATHING        0x00400000

#define AFF_FALLING          0x00800000        /* Don't ask.. :P */


/*
 * Sex.
 */
#define SEX_NEUTRAL                0
#define SEX_MALE                   1
#define SEX_FEMALE                 2

/*
 * Item types.
 */
#define ITEM_TRASH                 0
#define ITEM_LIGHT                 1
#define ITEM_SCROLL                2
#define ITEM_WAND                  3
#define ITEM_STAFF                 4
#define ITEM_WEAPON                5
#define ITEM_RANGED_WEAPON         6
#define ITEM_AMMO                  7
#define ITEM_TREASURE              8
#define ITEM_ARMOR                 9
#define ITEM_POTION                10
#define ITEM_BOOK                  11
#define ITEM_FURNITURE             12
#define ITEM_CLOTHING              13
#define ITEM_PAPER                 14
#define ITEM_CONTAINER             15
#define ITEM_THROWN                16
#define ITEM_DRINK_CON             17
#define ITEM_KEY                   18
#define ITEM_FOOD                  19
#define ITEM_MONEY                 20
#define ITEM_GEM                   21
#define ITEM_VEHICLE               22
#define ITEM_CORPSE_NPC            23
#define ITEM_CORPSE_PC             24
#define ITEM_FOUNTAIN              25
#define ITEM_PILL                  26
#define ITEM_TOOL                  27
#define ITEM_LIST                  28
#define ITEM_BOARD                 29
#define ITEM_COMPONENT             30
#define ITEM_GOODS                 31
#define ITEM_JEWELRY               32
#define ITEM_INDEX                 33

#define ITEM_MAX                   34

/*
 * Object values.

 Item Type          Value[0]        Value[1]        Value[2]       Value[3]
------------------------------------------------------------------------------
 ITEM_TRASH         -               -               -              -
 ITEM_LIGHT         Current Light   Max Light(-1)   -              Light flags
 ITEM_SCROLL        Spell Level     Spell SN        Spell SN       Spell SN
 ITEM_WAND          Spell Level     Min Charge      Max Charge     Spell SN
 ITEM_STAFF         Spell Level     Min Charge      Max Charge     Spell SN
 ITEM_WEAPON        Poison (b)      Min Damage      Max Damage     Weap Type
 ITEM_RANGED_WEAPON Ammo Type       Min Damage      Max Damage     Ranged Type
 ITEM_AMMO          Ammo Type       Bonus to Dam    Spell Level    Spell SN
 ITEM_TREASURE      -               -               -              -
 ITEM_ARMOR         Armor Bonus     Current Damage  Max Damage     -
 ITEM_POTION        Spell Level     Spell SN        Spell SN       Spell SN
 ITEM_BOOK          -               -               -              -
 ITEM_FURNITURE     Capacity        Furniture Flags Key (vnum)     Room (vnum)
 ITEM_CLOTHING      -               -               -              -
 ITEM_PAPER         -               -               -              -
 ITEM_CONTAINER     Maximum Weight  Container Flags Key (vnum)     -
 ITEM_THROWN        Spell Level     Spell SN        Spell SN       Spell SN
 ITEM_DRINK_CON     Current Volume  Capacity        Liquid Type    Drink Flags
 ITEM_KEY           -               -               -              -
 ITEM_FOOD          Ticks of Food   -               Reference Vnum Poison (b)
 ITEM_MONEY         Amount          Type            Set            -
 ITEM_GEM           Mana Flags      Current Mana    Max Mana       -
 ITEM_VEHICLE       Sector Pass     Sector Pass     Sector Pass    Sector Pass
 ITEM_CORPSE_NPC    Mobile's Race   -               -              -
 ITEM_CORPSE_PC     -               -               -              -
 ITEM_FOUNTAIN      Spell Level     Spell SN        Spell SN       Spell SN
 ITEM_PILL          Spell Level     Spell SN        Spell SN       Spell SN
 ITEM_TOOL          Tool Flags      Number of uses  Max uses       -
 ITEM_LIST          Number of vnums -               -              -
 ITEM_BOARD         Board Index     -               -              -
 ITEM_COMPONENT     Component Type  -               -              -
 ITEM_GOODS         Goods Type      -               -              -
 ITEM_JEWELRY       -               -               -              -

 */

/* Object Value Notes:
 *
 * On drink containers, liquid -1 = oil
 * On Pois values, if pois=0 it means no poison, otherwise it is the potency
 * of poison (effects duration)
 */

/*
 * Values for ranged weapons (value[3])
 */

#define RNG_BOW               0
#define RNG_CROSSBOW          1
#define RNG_CATAPULT          2

/*
 * Values for containers (value[1]).
 * Used in #OBJECTS.
 */
#define CONT_CLOSEABLE        1
#define CONT_PICKPROOF        2
#define CONT_CLOSED           4
#define CONT_LOCKED           8
#define CONT_SECRET          16

/*
 * Values for drink containers (value[3]).
 * Used in #OBJECTS.
 */
#define DRINK_POISON          1
#define DRINK_TAVERN          2

/*
 * Values for furniture (value[1]).
 * Used in #OBJECTS
 */
#define FURN_CLOSEABLE       CONT_CLOSEABLE
#define FURN_PICKPROOF       CONT_PICKPROOF
#define FURN_CLOSED          CONT_CLOSED
#define FURN_LOCKED          CONT_LOCKED

#define FURN_NOMOUNT         0x00001000
#define FURN_SIT             0x00002000
#define FURN_SLEEP           0x00004000
#define FURN_EXIT            0x00008000
#define FURN_PUT             0x00010000
#define FURN_MOVE            0x00020000
#define FURN_NOSHOW          0x00040000


/*
 * Values for lights (value[3]).
 * Used in #OBJECTS
 */
#define LIGHT_LIT             1
#define LIGHT_FILLABLE        2

/*
 * Values for tools (value[0]).
 * Used in #OBJECTS
 */
#define TOOL_TINDERBOX                1
#define TOOL_LOCKPICK                 2
#define TOOL_BOUNTY                   4



/*
 * Armor sizes.
 */
#define SIZE_ANY             0
#define SIZE_MINUTE          2 * 4
#define SIZE_SMALL           4 * 4
#define SIZE_PETITE          5 * 4
#define SIZE_AVERAGE         6 * 4
#define SIZE_MEDIUM          7 * 4
#define SIZE_LARGE           8 * 4
#define SIZE_HUGE           10 * 4
#define SIZE_TITANIC        14 * 4
#define SIZE_GARGANTUAN     16 * 4

/*
 * Awkward sizes (For mobs..)
 */
#define SIZE_HORSE         -2



/*
 * Apply types (for affects).             Can't use these as slot numbers.
 * Used in #OBJECTS.
 */
#define APPLY_NONE                10000
#define APPLY_STR                 10001
#define APPLY_DEX                 10002
#define APPLY_INT                 10003
#define APPLY_WIS                 10004
#define APPLY_CON                 10005
#define APPLY_SEX                 10006

#define APPLY_AGE                 10007
#define APPLY_SIZE                10008

#define APPLY_AC                  10009
#define APPLY_HITROLL             10010
#define APPLY_DAMROLL             10011
#define APPLY_SAVING_THROW        10012
  


/*
 * Room flags.
 * Used in #ROOMS.
 */
#define ROOM_DARK            0x00000001
#define ROOM_NO_MOB          0x00000002
#define ROOM_INDOORS         0x00000004
#define ROOM_IMMORTAL        0x00000008
#define ROOM_MARK            0x00000010
#define ROOM_SAVE            0x00000040
                               /***/
#define ROOM_WAGON           0x00000080
                               /***/
#define ROOM_SAFE            0x00000400
#define ROOM_PET_SHOP        0x00001000
#define ROOM_TEMPLATE        0x00002000


/*
 * Directions.
 * Used in #ROOMS.
 */
#define DIR_NORTH                     0
#define DIR_EAST                      1
#define DIR_SOUTH                     2
#define DIR_WEST                      3
#define DIR_UP                        4
#define DIR_DOWN                      5
#define DIR_NW                        6
#define DIR_NE                        7
#define DIR_SW                        8
#define DIR_SE                        9
#define MAX_DIR                      10




/*
 * Exit flags.
 * Used in #ROOMS.
 */
#define EX_ISDOOR            0x00000001
#define EX_CLOSED            0x00000004
#define EX_LOCKED            0x00000002
#define EX_PICKPROOF         0x00000008
#define EX_EAT_KEY           0x00000010
#define EX_BASHPROOF         0x00000020
#define EX_JAMMED            0x00000040
#define EX_SECRET            0x00000080          /* can see only when open  */
#define EX_TRANSPARENT       0x00000100          /* see through when closed */
#define EX_WINDOW            0x00000200          /* shoot through, not move */
#define EX_CONCEALED         0x00000400          /* can't see at all        */



/*
 * Sector types.
 * Used in #ROOMS.
 */
#define SECT_INSIDE                   0          /* cant see weather        */
#define SECT_CITY                     1          /* outdoor mv as inside    */
#define SECT_FIELD                    2          /* illuminated by moon     */
#define SECT_FOREST                   3          /* not illuminated         */
#define SECT_HILLS                    4          /* slower moving           */
#define SECT_MOUNTAIN                 5          /* requires grapple        */
#define SECT_WATER_SWIM               6          /* dropped objs float away */
#define SECT_WATER_NOSWIM             7          /* 4 pulse time on objs    */
#define SECT_UNDERWATER               8          /* needs breathing help    */
#define SECT_AIR                      9          /* requires FLY or vehicle */
#define SECT_DESERT                  10          /* high movement loss      */
#define SECT_ICELAND                 11          /* colder ( or something ) */
#define SECT_CLIMB                   12          /* things fall, no grapple */
#define SECT_MAX                     13




/*
 * Extra flags.
 * Used in #OBJECTS.
 */
#define ITEM_GLOW            0x00000001
#define ITEM_HUM             0x00000002
#define ITEM_DARK            0x00000004
#define ITEM_LOCK            0x00000008
#define ITEM_EVIL            0x00000010
#define ITEM_INVIS           0x00000020
#define ITEM_MAGIC           0x00000040
#define ITEM_NODROP          0x00000080
#define ITEM_BLESS           0x00000100
#define ITEM_NOREMOVE        0x00000200
#define ITEM_INVENTORY       0x00000400
#define ITEM_NOSAVE          0x00000800
#define ITEM_BURNING         0x00001000
#define ITEM_HITCH           0x00002000
#define ITEM_WAGON           0x00004000
#define ITEM_USED            0x00008000



/*
 * Wear flags.
 * Used in #OBJECTS.
 */
#define ITEM_TAKE            0x00000001
#define ITEM_HOLD            0x00000001
#define ITEM_WEAR_FINGER     0x00000002
#define ITEM_WEAR_NECK       0x00000004
#define ITEM_WEAR_BODY       0x00000008
#define ITEM_WEAR_HEAD       0x00000010
#define ITEM_WEAR_LEGS       0x00000020
#define ITEM_WEAR_FEET       0x00000040
#define ITEM_WEAR_HANDS      0x00000080
#define ITEM_WEAR_ARMS       0x00000100
#define ITEM_WEAR_SHIELD     0x00000200
#define ITEM_WEAR_ABOUT      0x00000400
#define ITEM_WEAR_WAIST      0x00000800
#define ITEM_WEAR_WRIST      0x00001000
#define ITEM_WEAR_BELT       0x00002000

#define ITEM_WIELD           0x00004000

#define ITEM_WEAR_SHOULDER   0x00008000
#define ITEM_WEAR_ANKLE      0x00010000
#define ITEM_WEAR_EAR        0x00020000
#define ITEM_WEAR_HELM       0x00040000
#define ITEM_WEAR_SHIRT      0x00080000
#define ITEM_WEAR_STOCKING   0x00100000
#define ITEM_WEAR_FACE       0x00200000
#define ITEM_WEAR_BACK       0x00400000
#define ITEM_WEAR_LOIN       0x00800000
#define ITEM_WEAR_FOREHEAD   0x01000000
#define ITEM_WEAR_NOSE       0x02000000
#define ITEM_WEAR_PANTS      0x04000000

#define ITEM_WEAR_PIN        0x08000000
#define ITEM_WEAR_ASBELT     0x10000000
#define ITEM_WEAR_SHOULDERS  0x20000000

#define ITEM_TWO_HANDED      0x80000000         /* force two handed */



/*
 * Equipment wear locations.
 * Used in #RESETS.
 */
#define WEAR_NONE                    -1
#define WEAR_EAR_L                    0
#define WEAR_EAR_R                    1
#define WEAR_HEAD                     2
#define WEAR_HELM                     3
#define WEAR_FOREHEAD                 4
#define WEAR_FACE                     5
#define WEAR_NOSE                     6
#define WEAR_NECK_1                   7
#define WEAR_NECK_2                   8
#define WEAR_SHIRT                    9
#define WEAR_BODY                    10
#define WEAR_BACK                    11
#define WEAR_LEGS                    12
#define WEAR_PANTS                   13
#define WEAR_STOCKING                14
#define WEAR_FEET                    15
#define WEAR_ANKLE_L                 16
#define WEAR_ANKLE_R                 17
#define WEAR_ARMS                    18
#define WEAR_WRIST_L                 19
#define WEAR_WRIST_R                 20
#define WEAR_HANDS                   21
#define WEAR_FINGER_L                22
#define WEAR_FINGER_R                23
#define WEAR_SHIELD                  24
#define WEAR_ABOUT                   25
#define WEAR_FLOATING                26
#define WEAR_WAIST                   27
#define WEAR_LOIN                    28
#define WEAR_PIN                     29
#define WEAR_BELT_1                  30
#define WEAR_BELT_2                  31
#define WEAR_BELT_3                  32
#define WEAR_BELT_4                  33
#define WEAR_BELT_5                  34
#define WEAR_HOLD_1                  35
#define WEAR_HOLD_2                  36
#define WEAR_SHOULDER_L              37
#define WEAR_SHOULDER_R              38
#define WEAR_WIELD_1                 39
#define WEAR_WIELD_2                 40
#define WEAR_ASBELT_1                41
#define WEAR_ASBELT_2                42
#define WEAR_ASBELT_3                43
#define WEAR_SHOULDERS               44
#define MAX_WEAR                     45





/***************************************************************************
 * *********************************************************************** *
 *  **************** VALUES OF INTEREST TO AREA BUILDERS ****************  *
 *   *************** (End of this section ... stop here) ***************   *
 *    *****************************************************************    *
 ***************************************************************************/

/*
 * Conditions.
 */
#define COND_DRUNK               0
#define COND_FULL                1
#define COND_THIRST              2



/*
 * Positions.
 */
#define POS_DEAD                      0
#define POS_MORTAL                    1
#define POS_INCAP                     2
#define POS_STUNNED                   3
#define POS_SLEEPING                  4
#define POS_RESTING                   5
#define POS_SITTING                   6
#define POS_FIGHTING                  7
#define POS_STANDING                  8


/*
 * Color codings for
 * channels+says
 */
#define COLOR_COMM                    0
#define COLOR_IMMTALK                 1
#define COLOR_ROOM_TITLE              2
#define COLOR_UNUSED3                 3                /* Unused */
#define COLOR_UNUSED4                 4                /* Unused */
#define COLOR_UNUSED5                 5                /* Unused */
#define COLOR_UNUSED6                 6                /* Unused */
#define COLOR_UNUSED7                 7                /* Unused */
#define COLOR_UNUSED8                 8                /* Unused */
#define COLOR_UNUSED9                 9                /* Unused */




/*
 * ACT bits for players.
 */
#define PLR_IS_NPC           0x00000001         /* Don't EVER set.      */

#define PLR_LOG              0x00000010
#define PLR_DENY             0x00000020
#define PLR_FREEZE           0x00000040

#define PLR_SILENCE          0x00000080
#define PLR_NO_EMOTE         0x00000100
#define PLR_NO_TELL          0x00000200
#define PLR_NO_WISH          0x00000400

#define WIZ_NOTIFY           0x00080000
#define WIZ_NOTIFY_1         0x00100000
#define WIZ_NOTIFY_2         0x00200000
#define WIZ_NOTIFY_LOGIN     0x00400000
#define WIZ_NOTIFY_DEATH     0x00800000
#define WIZ_NOTIFY_BUG       0x01000000
#define WIZ_NOTIFY_LOG       0x02000000
#define WIZ_NOTIFY_SCRIPT    0x04000000

/*
 *  Act2 Bits
 * Channel / Config bits.
 */
#define CHANNEL_IMMTALK      0x00000001
#define CHANNEL_WISHES       0x00000002

#define PLR_WIZBIT           0x00000100

#define PLR_AUTOEXIT         0x00000200

#define PLR_BLANK            0x00001000
#define PLR_BRIEF            0x00002000
#define PLR_COMBINE          0x00004000
#define PLR_PROMPT           0x00008000
#define PLR_TELNET_GA        0x00010000

#define PLR_VT100            0x00200000
#define PLR_ANSI             0x00400000

#define WIZ_HOLYLIGHT        0x00800000
#define WIZ_EQUIPMENT        0x01000000
#define WIZ_TRANSLATE        0x02000000




struct script_data
{
   SCRIPT_DATA *        next;
   sh_int               type;
   char *               commands;
   char *               name;
   int                  vnum;
   AREA_DATA *          area;
};

struct trigger_data
{
   TRIGGER_DATA *       next;
   SCRIPT_DATA *        script;            /* From Index                 */
   VARIABLE_DATA *      locals;            /* Local variables            */
   char *               location;          /* Pointer to current parse   */
   int                  bits;              /* Halt etc bits              */
   int                  wait;              /* Individual wait states     */
   int                  autowait;
   int                  returned;          /* Returns value              */
};

struct variable_data
{
   VARIABLE_DATA *      next;
   VARIABLE_DATA *      next_mud_var;
   char *               name;
   sh_int               type;
   void *               value;
};



/*
 * Prototype for a mob.
 * This is the in-memory version of #MOBILES.   MOBIND <- quick search key
 */
struct    mob_index_data
{
    MOB_INDEX_DATA *    next;
    char *              name;
    char *              short_descr;
    char *              long_descr;
    char *              description;
    SHOP_DATA *         pShop;
    AREA_DATA *         area;
    TRIGGER_DATA *      triggers;
    VARIABLE_DATA *     globals;            /* scripts                     */
    int                 vnum;
    sh_int              count;
    sh_int              race;
    sh_int              sex;
    int                 act;
    sh_int              timer;
    int                 affected_by;
    int                 money;
    sh_int              size;
    int                 cost;
    sh_int              perm_str;
    sh_int              perm_int;
    sh_int              perm_wis;
    sh_int              perm_dex;
    sh_int              perm_con;
    ATTACK_DATA *       attacks         [MAX_ATTACK_DATA];
    sh_int              learned         [MAX_SKILL];
    sh_int              fmode;
};


/*
 * Memory saver - data only PC's have.    PDATA
 */
struct pc_data
{
    PC_DATA *           next;
    time_t              logon;
    time_t              save_time;
    time_t              last_note;
    sh_int              condition       [3];
    sh_int              deaf;                          /* channel bits       */
    sh_int              security;                      /* builder security   */
    sh_int              level;                         /* command security   */
    char *              email;
    char *              bamfin;
    char *              bamfout;
    char *              constellation;
    char *              pwd;
    char *              denial;
    int                 wizinvis;
    int                 age;
    int                 played;
    sh_int              skill_time      [MAX_SKILL];   /* time to next       */
    int                 teacher         [MAX_SKILL];   /* teacher mob vnum   */
    sh_int              learned         [MAX_SKILL];   /* percent learned    */
    sh_int              last_used       [MAX_SKILL];   /* last used          */
    sh_int              colors          [MAX_COLORS];
    sh_int              birth_day;
    sh_int              birth_month;
    sh_int              birth_year;
    int                 warmth_rating;
    TRIGGER_DATA       *d_caller        [MAX_DEBUG];   /* debugger */
    TRIGGER_DATA       *d_type          [MAX_DEBUG];   /* debugger */
    SCRIPT_DATA        *trace;                         /* script trace gen   */
    int                 trace_wait;
};

/*
 * One character (PC or NPC).   CHDATA  <-quick search key
 */
struct char_data
{
    CHAR_DATA *         next;               /* For char_list or mount_list */
    CHAR_DATA *         next_in_room;       /* For room->people            */
    CHAR_DATA *         master;             /* For following               */
    CHAR_DATA *         fighting;           /* For combat                  */
    CHAR_DATA *         riding;             /* For mount                   */
    CHAR_DATA *         rider;              /* For being mounted           */
    PC_DATA *           pcdata;             /* Additional PC only info     */
    OBJ_DATA *          hitched_to;         /* For hitching/dragging       */
    OBJ_DATA *          furniture;          /* For sitting/sleeping/wagons */
    char *              hunting;            /* For track                   */
    TRIGGER_DATA *      triggers;           /* scripts                     */
    TRIGGER_DATA *      current;            /* scripts                     */
    VARIABLE_DATA *     globals;
    MOB_INDEX_DATA *    pIndexData;         /* For NPCs                    */
    DESCRIPTOR_DATA *   desc;               /* Channel Descriptor Data     */
    AFFECT_DATA *       affected;           /* Special affects.            */
    NOTE_DATA *         pnote;              /* For bulletin boards.        */
    OBJ_DATA *          carrying;           /* For inventory/equipment     */
    ROOM_INDEX_DATA *   in_room;            /* To be in a location.        */
    char *              name;               /* name (matchable keywords)   */
    char *              keywords;           /* matchable keywords ()       */
    char *              short_descr;        /* short description           */
    char *              long_descr;         /* long description            */
    char *              description;
    char *              prompt;
    sh_int              sex;
    sh_int              race;
    sh_int              timer;
    sh_int              wait;
    sh_int              hit;
    sh_int              move;
    int                 bounty;                /* Price on your head */
    int                 owed;                  /* Rewards owed       */
    int                 act;
    int                 act2;
    int                 fbits;                 /* Fighting bits      */
    sh_int              fmode;                 /* fmode              */
    int                 affected_by;
    sh_int              position;
    sh_int              carry_weight;
    sh_int              carry_number;
    sh_int              saving_throw;
    sh_int              hitroll;
    sh_int              damroll;
    sh_int              armor;
    sh_int              size;
    sh_int              pagelen;
    sh_int              perm_str;
    sh_int              perm_int;
    sh_int              perm_wis;
    sh_int              perm_dex;
    sh_int              perm_con;
    sh_int              mod_str;
    sh_int              mod_int;
    sh_int              mod_wis;
    sh_int              mod_dex;
    sh_int              mod_con;

    CHAR_DATA *         keeper;
    OBJ_DATA *          haggling;
    int                 haggled_cost;
    sh_int              haggle_bits;
    int                 original_cost;
    sh_int              speaking;
};



/*
 * Liquids.
 */
#define LIQ_WATER        0
#define LIQ_OIL         17
#define LIQ_MAX         34

struct    liq_type
{
    char *    liq_name;
    char *    liq_color;
    sh_int      liq_affect[3];     /* 0=drunk  1=food  2=thirst */
};



/*
 * Extra description data for a room or object.
 */
struct    extra_descr_data
{
    EXTRA_DESCR_DATA *next;    /* Next in list                     */
    char *keyword;              /* Keyword in look/examine          */
    char *description;          /* What to see                      */
};


/*
 * Prototype for an object.         OBJIND
 */
struct    obj_index_data
{
    OBJ_INDEX_DATA *    next;
    EXTRA_DESCR_DATA *  extra_descr;
    AFFECT_DATA *       affected;
    AREA_DATA *         area;
    TRIGGER_DATA *      triggers;
    char *              name;
    char *              short_descr;
    char *              short_descr_plural;
    char *              description;
    char *              description_plural;
    char *              action_descr;
    char *              real_description;
    int                 vnum;
    sh_int              item_type;
    sh_int              timer;
    int                 extra_flags;
    int                 wear_flags;
    sh_int              count;
    sh_int              weight;
    sh_int              level;
    int                 cost;
    int                 size;
    sh_int              material;
    sh_int              material_value;
    int                 value   [4];
};





/*
 * One object.                            OBDAT
 */
struct    obj_data
{
    OBJ_DATA *          next;
    OBJ_DATA *          next_content;
    OBJ_DATA *          contains;
    OBJ_DATA *          in_obj;
    CHAR_DATA *         carried_by;
    EXTRA_DESCR_DATA *  extra_descr;
    AFFECT_DATA *       affected;
    OBJ_INDEX_DATA *    pIndexData;
    ROOM_INDEX_DATA *   in_room;
    TRIGGER_DATA *      triggers;           /* for scripts */
    TRIGGER_DATA *      current;
    VARIABLE_DATA *     globals;            /* for scripts */
    char *              name;
    char *              short_descr;
    char *              short_descr_plural;
    char *              description;
    char *              description_plural;
    char *              action_descr;
    char *              real_description;
    sh_int              item_type;
    int                 extra_flags;
    int                 wear_flags;
    sh_int              wear_loc;
    sh_int              weight;
    int                 cost;
    sh_int              level;
    sh_int              timer;
    sh_int              size;
    sh_int              material;
    sh_int              material_value;
    int                 value   [4];
};                                                   


/*
 * Exit data.
 */
struct    exit_data
{
    ROOM_INDEX_DATA *    to_room;
    EXIT_DATA *         next;
    int                 vnum;
    sh_int              exit_info;
    int                 key;
    char *              keyword;
    char *              description;
    sh_int              rs_flags;
};



/*
 * Reset commands:
 *   '*': comment
 *   'M': read a mobile 
 *   'O': read an object  (figures out where to put it)
 */

/*
 * Area-reset definition.
 */
struct    reset_data
{
    RESET_DATA *    next;
    char                command; /* M=Mob O=Obj                              */
    sh_int              rs_vnum; /* vnum of mob/obj to load                  */
    int                 loc;     /* If mob = max mobs else wear_loc or below */
    sh_int              percent; /* chance it will load                      */
    sh_int              vnum;
    sh_int              num;     /* num = num to load                        */
};


#define RESET_LOC_INOBJ    -3      /* object loads as if a content of obj    */
#define RESET_LOC_ONOBJ    -4      /* object loads as if sitting on obj      */
#define RESET_LOC_INROOM   -5      /* just let it load in the room           */


/*
 * Area definition.
 */
struct    area_data
{
    AREA_DATA *         next;
    char *              name;
    char *              repop;
    sh_int              area_flags;
    sh_int              security;
    char *              builders;
    int                 lvnum;
    int                 uvnum;
    sh_int              age;
    sh_int              nplayer;
    char *              filename;
    int                 vnum;
};



/*
 * Room type.                                       ROOMIND
 */
struct    room_index_data
{
    ROOM_INDEX_DATA *    next;
    RESET_DATA *         reset_first;
    RESET_DATA *         reset_last;
    ROOM_INDEX_DATA *    leave_to;
    CHAR_DATA *          people;
    OBJ_DATA *           contents;
    EXTRA_DESCR_DATA *   extra_descr;
    AREA_DATA *          area;
    EXIT_DATA *          exit    [MAX_DIR];
    TRIGGER_DATA *       triggers;           /* for scripts */
    TRIGGER_DATA *       current;
    VARIABLE_DATA *      globals;            /* for scripts */
    char *               name;
    char *               description;
    int                  vnum;
    int                  template;
    int                  room_flags;
    sh_int               max_people;
    sh_int               light;
    sh_int               sector_type;
    int                  terrain;
    int                  wagon;
};


/*
 * Mana types.
 * These are bits for GEMs, these are also used to check if a spell needs
 * that certain mana type.  Used in def.c under skill defines.
 */
#define MANA_ANY           -1
#define MANA_NONE           0
#define MANA_EARTH          1
#define MANA_AIR            2
#define MANA_FIRE           4
#define MANA_WATER          8

#define M_ANY              -1
#define MN                  0
#define ME                  1
#define MA                  2
#define MF                  4
#define MW                  8


/*
 *  Target types.
 */
#define TAR_IGNORE            0
#define TAR_CHAR_OFFENSIVE        1
#define TAR_CHAR_DEFENSIVE        2
#define TAR_CHAR_SELF               3
#define TAR_OBJ_INV                 4


struct  group_type
{
    char *      name;                   /* Name of group                */
    sh_int      group_code;             /* Some neato-code (group slot) */
    sh_int *    pgsn;                   /* Pointer to percent skill gsn */
};



struct  comp_type
{
    char *      name;
    char *      usage;
    sh_int      type;
    sh_int      cost;
};


/*
 * Skills include spells as a particular case.
 */
struct    skill_type
{
    char *      name;                   /* Name of skill        */
    sh_int      skill_level;            /* Security level required      */
    LEARN_FUN * learn_fun;              /* Learn pointer (when needed)  */
    SPELL_FUN * spell_fun;              /* Spell pointer (for spells)    */
    sh_int      target;                 /* Legal targets        */
    sh_int      minimum_position;       /* Position for caster / user   */
    sh_int *    pgsn;                   /* Pointer to associated gsn    */
    sh_int      mana_type;              /* See MANA_x defines           */
    char *      formula;                /* See SPELL_x defines          */
    char *      msg_off;                /* Wear off message/to Victim   */
    sh_int      group_code;             /* Some neato-code (group slot) */
    sh_int      required_percent;       /* % required in group          */

    sh_int      req_str;                /* Required stats               */
    sh_int      req_int;
    sh_int      req_wis;
    sh_int      req_dex;
    sh_int      req_con;

    sh_int      slot;                   /* Slot for #OBJECT loading     */
    sh_int      beats;                  /* Waiting time after use       */
    sh_int      mana;                   /* Minimum mana used/required   */
    sh_int      max_prac;               /* Max % gained in a practice   */
    sh_int      max_learn;              /* Max % gained overall         */
    sh_int      learn_rate;             /* Game-hours between learns    */
    sh_int      cost;                   /* cost (in copper) to learn    */
};


/*
 * Structure for a command in the command lookup table.
 */
struct    cmd_type
{
    char * const    name;
    DO_FUN *            do_fun;
    sh_int        position;
    sh_int        level;
    sh_int        log;
};



/*
 * Structure for a social in the socials table.  (Read from areas)
 */
struct    social_type
{
    char      name[20];
    char *    char_no_arg;
    char *    others_no_arg;
    char *    char_found;
    char *    others_found;
    char *    vict_found;
    char *    char_not_found;
    char *    char_auto;
    char *    others_auto;
};




/*
 * Utility macros.
 */
#define interpolate(l, v0, v32) ( v0 + l * (v32-v0) / 32 )
#define INTERPOLATE(min, max, percent)   ( min + (max - min / percent == 0 ? 1 : percent ) )
#define UMIN(a, b)        ((a) < (b) ? (a) : (b))
#define UMAX(a, b)        ((a) > (b) ? (a) : (b))
#define URANGE(a, b, c)        ((b) < (a) ? (a) : ((b) > (c) ? (c) : (b)))
#define LOWER(c)        ((c) >= 'A' && (c) <= 'Z' ? (c)+'a'-'A' : (c))
#define UPPER(c)        ((c) >= 'a' && (c) <= 'z' ? (c)+'A'-'a' : (c))
#define IS_VOWEL(c)             (c == 'A' || c == 'a' ||                     \
                                 c == 'E' || c == 'e' ||                     \
                                 c == 'I' || c == 'i' ||                     \
                                 c == 'O' || c == 'o' ||                     \
                                 c == 'U' || c == 'u'      )

#define IS_SET(flag, bit)    ((flag) & (bit))
#define SET_BIT(var, bit)    ((var) |= (bit))
#define REMOVE_BIT(var, bit)    ((var) &= ~(bit))
#define TOGGLE_BIT(var, bit)    ((var) ^= (bit))
#define STR(dat, field)         (( (dat)->field != NULL                      \
                                             ? (dat)->field                  \
                                             : (dat)->pIndexData->field ))
#define NST(pointer)            (pointer == NULL ? "" : pointer)
#define MTD(str)                ((str == NULL || str[0] == '\0' ))
#define MTP(str)                ((str == NULL || *str   == '\0' ))
#define STRASN(dat1, dat2)      (free_string( dat1 );   dat1 = str_dup( dat2 ))

#define LINEATE(x,y,x_size)     ( (x+y*x_size) )
#define FINDDESC(x,y,tnum)      ( (x*y%tnum) )

/*
 * Articles.
 */
#define HE_SHE(ch)           (((ch)->sex == SEX_MALE  ) ? "he"   :  \
                           (  ((ch)->sex == SEX_FEMALE) ? "she"  : "it" ) )
#define HIS_HER(ch)          (((ch)->sex == SEX_MALE  ) ? "his"  :  \
                           (  ((ch)->sex == SEX_FEMALE) ? "her"  : "its" ) )
#define HIM_HER(ch)          (((ch)->sex == SEX_MALE  ) ? "him"  :  \
                           (  ((ch)->sex == SEX_FEMALE) ? "her"  : "it" ) )

/*
 * Character macros.
 */
#define IS_NPC(ch)        (IS_SET((ch)->act,ACT_IS_NPC))
#define IS_IMMORTAL(ch)         (get_trust(ch) >= LEVEL_IMMORTAL)
#define IS_HERO(ch)        (get_trust(ch) >= LEVEL_HERO)
#define IS_AFFECTED(ch, sn)    (IS_SET((ch)->affected_by, (sn)))

#define HAS_ANSI(ch)            (!IS_NPC(ch) && IS_SET(ch->act2, PLR_ANSI))

#define IS_AWAKE(ch)        (ch->position > POS_SLEEPING)
#define PC(ch,field)            ((ch)->pcdata->field)
#define GET_PC(ch,field,nopc)   ((ch->pcdata != NULL ? ch->pcdata->field     \
                                                     : (nopc)) )
#define GET_AC(ch)              ((ch)->armor                                 \
                                    + ( IS_AWAKE(ch)                         \
                                    ? dex_app[get_curr_dex(ch)].defensive    \
                    : 0 ))
#define GET_HITROLL(ch)        ((ch)->hitroll+str_app[get_curr_str(ch)].tohit)
#define GET_DAMROLL(ch)        ((ch)->damroll+str_app[get_curr_str(ch)].todam)
#define MAXHIT(ch)              (con_app[get_curr_con(ch)].hitp + 100)
#define MAXMOVE(ch)             (con_app[get_curr_con(ch)].hitp + 100)
#define GET_AGE(ch)             (IS_NPC(ch) ? 17 :                           \
                                       (time_info.year - PC(ch,birth_year)))

#define IS_OUTSIDE(ch)          (!IS_SET(                                    \
                                    (ch)->in_room->room_flags,               \
                    ROOM_INDOORS))

#define WAIT_STATE(ch, npulse)  ((ch)->wait = UMAX((ch)->wait, (npulse)))

#define MANA_COST(ch, sn)       (IS_NPC(ch) ? 0                              \
                                 : number_fuzzy(skill_table[sn].min_mana) )

#define STRING_HITS(ch)         (percent_hit[ URANGE(0,                      \
                                     PERCENTAGE((ch)->hit, MAXHIT(ch))       \
                                                   ,101)/10 ]  )             \

#define STRING_MOVES(ch)        (percent_tired[ URANGE(0,                    \
                                     PERCENTAGE((ch)->move, MAXMOVE(ch))     \
                                                   ,101)/10 ]  )

#define HAS_SCRIPT(ch)          ( IS_NPC(ch) && ch->triggers != NULL )
#define BTW(align)       ( (align) >= race_table[ch->race].minalign &&       \
                           (align) <= race_table[ch->race].maxalign )
#define SAME_ALIGN(ch, victim)  ( (IS_GOOD( ch ) && IS_GOOD( victim ))       \
                               || (IS_EVIL( ch ) && IS_EVIL( victim ))       \
                               || (IS_NEUTRAL(ch) && IS_NEUTRAL( victim )) )
#define TRACK_DEPTH(ch)         ( IS_NPC(ch) ? 50 : 10 )
#define LEARNED(ch,sn)          ( (IS_NPC(ch) ? ch->pIndexData->learned[sn]  \
                                              : PC(ch,learned[sn])) )

/*
 * Object macros.
 */

/*
 * TOO_BIG -> Its too big for you to wear.
 * TOO_SMALL -> Its too small for you to wear.
 */
#define TOO_SMALL(ch,obj)    ( (obj->size) && (ch->size - obj->size) >  4 \
                                ? TRUE : FALSE )
#define TOO_BIG(ch,obj)      ( (obj->size) && (ch->size - obj->size) < -4 \
                                ? TRUE : FALSE )
#define CAN_WEAR(obj, part)     (IS_SET((obj)->wear_flags,  part))
#define IS_OBJ_STAT(obj, stat)  (IS_SET((obj)->extra_flags, stat))
#define NOT_WORN( obj )         ((obj)->wear_loc == WEAR_NONE   ||     \
                                 (obj)->wear_loc == WEAR_HOLD_1 ||     \
                                 (obj)->wear_loc == WEAR_HOLD_2 ||     \
                                 (obj)->wear_loc == WEAR_BELT_1 ||     \
                                 (obj)->wear_loc == WEAR_BELT_2 ||     \
                                 (obj)->wear_loc == WEAR_BELT_3 ||     \
                                 (obj)->wear_loc == WEAR_BELT_4 ||     \
                                 (obj)->wear_loc == WEAR_BELT_5    )
#define IS_WORN( obj )          ( !NOT_WORN( obj ) )
#define IS_LIT( obj )           ( (obj)->value[0] > 0 &&               \
                                 IS_SET((obj)->value[3], LIGHT_LIT) )
#define VAL_SET(obj, num, bit)  (IS_SET((obj)->value[num], bit))
#define OCCUPADO(obj)           ( obj->value[0]/100 <= 0               \
                                || count_occupants(obj) >= obj->value[0]/100 )

/*
 * Description macros.
 */
#define NAME( ch )              ( STR(ch, short_descr) )

#define PERS(ch, looker)     ( can_see( looker, (ch) ) ? NAME(ch) : "someone" )
#define PERSO(obj, looker)   ( can_see_obj(looker, obj) ? STR(obj,short_descr) : "something" )

/*
 * Other macros.
 */
#define NOTIFY(buf, lvl, tog)       ( global( buf, lvl, tog, WIZ_NOTIFY ) )




/*
DECLARE_SPEC_FUN(       spec_breath_any         );
DECLARE_SPEC_FUN(    spec_breath_acid    );
DECLARE_SPEC_FUN(    spec_breath_fire    );
DECLARE_SPEC_FUN(    spec_breath_frost    );
DECLARE_SPEC_FUN(    spec_breath_gas        );
DECLARE_SPEC_FUN(    spec_breath_lightning    );
DECLARE_SPEC_FUN(    spec_cast_adept        );
DECLARE_SPEC_FUN(    spec_cast_cleric    );
DECLARE_SPEC_FUN(    spec_cast_judge        );
DECLARE_SPEC_FUN(    spec_cast_mage        );
DECLARE_SPEC_FUN(    spec_cast_undead    );
DECLARE_SPEC_FUN(    spec_executioner    );
DECLARE_SPEC_FUN(    spec_fido        );
DECLARE_SPEC_FUN(    spec_guard        );
DECLARE_SPEC_FUN(    spec_janitor        );
DECLARE_SPEC_FUN(    spec_mayor        );
DECLARE_SPEC_FUN(    spec_poison        );
DECLARE_SPEC_FUN(    spec_thief        );
 */



/*
 * OS-dependent declarations.
 * These are all very standard library functions,
 *   but some systems have incomplete or non-ansi header files.
 */
#if    defined(_AIX)
char *    crypt        args( ( const char *key, const char *salt ) );
#endif

#if    defined(apollo)
int    atoi        args( ( const char *string ) );
void *    calloc        args( ( unsigned nelem, size_t size ) );
char *    crypt        args( ( const char *key, const char *salt ) );
#endif

#if    defined(hpux)
char *    crypt        args( ( const char *key, const char *salt ) );
#endif

#if    defined(interactive)
#endif

#if    defined(linux)
char *    crypt        args( ( const char *key, const char *salt ) );
#endif

#if    defined(macintosh)
#define NOCRYPT
#if    defined(unix)
#undef    unix
#endif
#endif

#if    defined(MIPS_OS)
char *    crypt        args( ( const char *key, const char *salt ) );
#endif

#if    defined(MSDOS)
#define NOCRYPT
#if    defined(unix)
#undef    unix
#endif
#endif

#if    defined(NeXT)
char *    crypt        args( ( const char *key, const char *salt ) );
#endif

#if    defined(sequent)
char *    crypt        args( ( const char *key, const char *salt ) );
int    fclose        args( ( FILE *stream ) );
int    fprintf        args( ( FILE *stream, const char *format, ... ) );
int    fread        args( ( void *ptr, int size, int n, FILE *stream ) );
int    fseek        args( ( FILE *stream, long offset, int ptrname ) );
void    perror        args( ( const char *s ) );
int    ungetc        args( ( int c, FILE *stream ) );
#endif

#if    defined(sun)
char *    crypt        args( ( const char *key, const char *salt ) );
int    fclose        args( ( FILE *stream ) );
int    fprintf        args( ( FILE *stream, const char *format, ... ) );
#if     defined(SYSV)
size_t     fread        args( ( void *ptr, size_t size, size_t n,
                FILE *stream ) );
#else
/*int     fread           args( ( void *ptr, int size, int n, FILE *stream ) );*/
#endif
int    fseek        args( ( FILE *stream, long offset, int ptrname ) );
void    perror        args( ( const char *s ) );
int    ungetc        args( ( int c, FILE *stream ) );
#endif

#if    defined(ultrix)
char *    crypt        args( ( const char *key, const char *salt ) );
#endif



/*
 * The crypt(3) function is not available on some operating systems.
 * In particular, the U.S. Government prohibits its export from the
 *   United States to foreign countries.
 * Turn on NOCRYPT to keep passwords in plain text.
 */
#if    defined(NOCRYPT)
#define crypt(s1, s2)    (s1)
#endif



/*
 * Data files used by the server.
 *
 * AREA_LIST contains a list of areas to boot.
 * All files are read in completely at bootup.
 * Most output files (bug, idea, typo, shutdown) are append-only.
 *
 * The NULL_FILE is held open so that we have a stream handle in reserve,
 *   so players can go ahead and telnet to all the other descriptors.
 * Then we close it whenever we need to open a file (e.g. a save file).
 */
#if defined(macintosh)
#define PLAYER_DIR    ""        /* Player files            */
#define BOARD_DIR       ""              /* Board files                  */
#define NULL_FILE    "proto.are"    /* To reserve one stream    */
#endif

#if defined(MSDOS)
#define PLAYER_DIR    ""        /* Player files                 */
#define BOARD_DIR       ""              /* Board files                  */
#define NULL_FILE    "nul"        /* To reserve one stream    */
#endif

#if defined(unix)
#define PLAYER_DIR    "../player/"    /* Player files            */
#define BOARD_DIR       "./board/"      /* Board files                  */
#define NULL_FILE       "/dev/null"     /* To reserve one stream        */
#endif

#if defined(linux)
#define PLAYER_DIR    "../player/"    /* Player files            */
#define BOARD_DIR       "./board/"      /* Board files                  */
#define NULL_FILE    "/dev/null"    /* To reserve one stream    */
#endif

#define MUD_FILE        "mud.nfo"       /* Mud time config.             */
#define ROOMS_FILE      "rooms.nfo"     /* Room contents save file.     */
#define AREA_LIST       "area.lst"      /* List of areas                */

#define BUG_FILE    "bugs.txt"      /* For 'bug' and bug( )        */
#define IDEA_FILE    "ideas.txt"    /* For 'idea'            */
#define TYPO_FILE    "typos.txt"     /* For 'typo'            */
#define SHUTDOWN_FILE    "shutdown.txt"    /* For 'shutdown'        */


/*
 * Main global declarations.
 */
 
#define CD    CHAR_DATA
#define MID    MOB_INDEX_DATA
#define OD    OBJ_DATA
#define OID    OBJ_INDEX_DATA
#define RID    ROOM_INDEX_DATA
#define SF    SPEC_FUN
#define AD      AREA_DATA
#define VD      VARIABLE_DATA
#define RD      RESET_DATA
#define TD      TRIGGER_DATA
#define SD      SHOP_DATA
#define EDD     EXTRA_DESCR_DATA
#define AFD     AFFECT_DATA
#define ED      EXIT_DATA
#define ATD     ATTACK_DATA
#define PCD     PC_DATA
#define SCD     SCRIPT_DATA
#define DD      DESCRIPTOR_DATA

/*****************************************************************************
 * Variable and functional contents for file act_cfg.c.                      *
 * Contains mostly user-specific options for connection and gameplay.        *
 *****************************************************************************/

DECLARE_DO_FUN( do_clear     );
DECLARE_DO_FUN( do_blank     );
DECLARE_DO_FUN( do_brief     );
DECLARE_DO_FUN( do_compact   );
DECLARE_DO_FUN( do_holylight );
DECLARE_DO_FUN( do_pager     );
DECLARE_DO_FUN( do_prompt    );
DECLARE_DO_FUN( do_password  );
DECLARE_DO_FUN( do_ansi      );
DECLARE_DO_FUN( do_config    );
DECLARE_DO_FUN( do_notify    );

/*****************************************************************************
 * Variable and functional contents for file act_comm.c                      *
 * Contains mostly in-game communication routines, not network parameters.   *
 *****************************************************************************/
 
DECLARE_DO_FUN( do_immtalk   );
DECLARE_DO_FUN( do_contact   );
DECLARE_DO_FUN( do_wish      );
void shout         args( ( CD *ch, CD *pRoom, char *message, int dir ) );
DECLARE_DO_FUN( do_shout     );
void say_to        args( ( CHAR_DATA *ch, CHAR_DATA *victim, char *argument ));
DECLARE_DO_FUN( do_say       );
DECLARE_DO_FUN( do_talk      );
DECLARE_DO_FUN( do_smote     );
DECLARE_DO_FUN( do_speak     );
DECLARE_DO_FUN( do_ooc       );
DECLARE_DO_FUN( do_emote     );
DECLARE_DO_FUN( do_bug       );
DECLARE_DO_FUN( do_idea      );
DECLARE_DO_FUN( do_typo      );
DECLARE_DO_FUN( do_qui       );
DECLARE_DO_FUN( do_quit      );
DECLARE_DO_FUN( do_save      );
DECLARE_DO_FUN( do_follow    );
void add_follower  args( ( CHAR_DATA *ch, CHAR_DATA *master ) );
void stop_follower args( ( CHAR_DATA *ch ) );
void die_follower  args( ( CHAR_DATA *ch ) );
DECLARE_DO_FUN( do_order     );

/*****************************************************************************
 * Variable and functional contents for file act_info.c                      *
 * Contains mostly informational routines for the player.                    *
 *****************************************************************************/

extern char *  const   where_name  [];
 
void scan_direction       args( ( CHAR_DATA *ch, int dir ) );
char *format_obj_to_char  args( ( OD *obj, CD *ch, bool fShort ) );
void show_list_to_char    args( ( OD *list, CD *ch, bool fShort,
                                  bool fShowNothing ) );
char *show_list_to_char2  args( ( OD *list, CD *ch, char *prefix ) );
void show_peek_to_char    args( ( OD *list, CD *ch, bool fShort,
                                  bool fShowNothing, int percent ) );
 /* Omitted: show_char_to_char_0 */                                  
void show_equipment       args( ( CHAR_DATA *ch, CHAR_DATA *tch ) );
void show_equipment_table args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
void show_size            args( ( CHAR_DATA *ch, CHAR_DATA *tch ) );
 /* Omitted: show_char_to_char_1 */
void show_char_to_char    args( ( CHAR_DATA *list, CHAR_DATA *ch ) );
bool check_blind          args( ( CHAR_DATA *ch ) );
 /* Omitted: char_look_list      */
DECLARE_DO_FUN( do_look      );
DECLARE_DO_FUN( do_examine   );
DECLARE_DO_FUN( do_exits     );
DECLARE_DO_FUN( do_score     );
DECLARE_DO_FUN( do_time      );
DECLARE_DO_FUN( do_help      );
DECLARE_DO_FUN( do_who       );
void show_inventory       args( ( CD *ch, CD *tch, bool fPeek ) );
DECLARE_DO_FUN( do_inventory );
void show_belt            args( ( CHAR_DATA *victim, CHAR_DATA *ch ) );
DECLARE_DO_FUN( do_peek      );
DECLARE_DO_FUN( do_equipment );
DECLARE_DO_FUN( do_compare   );
DECLARE_DO_FUN( do_credits   );
DECLARE_DO_FUN( do_consider  );
DECLARE_DO_FUN( do_report    );
DECLARE_DO_FUN( do_socials   );
DECLARE_DO_FUN( do_commands  );
DECLARE_DO_FUN( do_wizlist   );

/*****************************************************************************
 * Variable and functional contents for file act_move.c                      *
 * Contains movement and positional procedures, and some skill routines.     *
 *****************************************************************************/
 
extern char *  const   dir_name        [];
extern char *  const   dir_rev         [];
extern char *  const   dir_letter      [];
extern const   sh_int  rev_dir         [];
extern const   sh_int  movement_loss   [SECT_MAX];

void hide_check      args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *in_room ) );
/* void flee            args( ( CHAR_DATA *ch, CHAR_DATA *fighting, int d ) ); */
void leave_strings   args( ( CD *ch, OD *obj, int sect, int door ) );
void arrive_strings  args( ( CD *ch, OD *obj, int sect, int door ) );
bool lose_movement   args( ( CD *ch, RID *in_room, RID *to_room ) );
bool check_move      args( ( CD *ch, int door, int depth, RID *in_room,
                             RID *to_room, OD **obj ) );
void move_char       args( ( CHAR_DATA *ch, int door ) );
DECLARE_DO_FUN( do_north     );
DECLARE_DO_FUN( do_east      );
DECLARE_DO_FUN( do_south     );
DECLARE_DO_FUN( do_west      );
DECLARE_DO_FUN( do_up        );
DECLARE_DO_FUN( do_down      );
DECLARE_DO_FUN( do_nw        );
DECLARE_DO_FUN( do_ne        );
DECLARE_DO_FUN( do_sw        );
DECLARE_DO_FUN( do_se        );
DECLARE_DO_FUN( do_drag      );
DECLARE_DO_FUN( do_hitch     );
DECLARE_DO_FUN( do_unhitch   );
DECLARE_DO_FUN( do_enter     );
DECLARE_DO_FUN( do_leave     );
DECLARE_DO_FUN( do_stand     );
DECLARE_DO_FUN( do_rest      );
DECLARE_DO_FUN( do_sit       );
DECLARE_DO_FUN( do_sleep     );
DECLARE_DO_FUN( do_wake      );
DECLARE_DO_FUN( do_sneak     );
DECLARE_DO_FUN( do_hide      );

/*****************************************************************************
 * Variable and functional contents for file act_obj.c                       *
 * Contains object manipulation functions and commands.                      *
 *****************************************************************************/

bool can_wield           args( ( CHAR_DATA *ch, OBJ_DATA *obj ));
bool draw_obj            args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
bool sheath_obj          args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
bool remove_obj          args( ( CHAR_DATA *ch, int iWear, bool fReplace ) );
int  get_wear_location   args( ( int loc ) );
void wear_obj args( ( CHAR_DATA *ch, OBJ_DATA *obj, bool fReplace, int loc ) );
DECLARE_DO_FUN( do_wear     );
DECLARE_DO_FUN( do_sheath   );
DECLARE_DO_FUN( do_draw     );
DECLARE_DO_FUN( do_remove   );
DECLARE_DO_FUN( do_wield    );
DECLARE_DO_FUN( do_hold     );
void get_obj  args( ( CHAR_DATA *ch, OBJ_DATA *obj, OBJ_DATA *container, bool fMoney ) );
DECLARE_DO_FUN( do_get      );
DECLARE_DO_FUN( do_put      );
DECLARE_DO_FUN( do_dump     );
DECLARE_DO_FUN( do_drop     );
DECLARE_DO_FUN( do_give     );
DECLARE_DO_FUN( do_fill     );
DECLARE_DO_FUN( do_pour     );
DECLARE_DO_FUN( do_drink    );
DECLARE_DO_FUN( do_eat      );
DECLARE_DO_FUN( do_quaff    );
DECLARE_DO_FUN( do_recite   );
DECLARE_DO_FUN( do_brandish );
DECLARE_DO_FUN( do_zap      );
DECLARE_DO_FUN( do_steal    );
DECLARE_DO_FUN( do_light    );
DECLARE_DO_FUN( do_extinguish );
DECLARE_DO_FUN( do_swap     );

/*****************************************************************************
 * Variable and functional contents for file bit.c                           *
 * Contains string-to-numeral and numeral-to-string conversions.             *
 *****************************************************************************/
 
char * item_type_name    args( ( int item_type   ) );
int    item_name_type    args( ( char *name      ) );
char * affect_loc_name   args( ( int location    ) );
int    affect_name_loc   args( ( char *name      ) );
char * affect_bit_name   args( ( int vector      ) );
int    affect_name_bit   args( ( char *buf       ) );
char * extra_bit_name    args( ( int extra_flags ) );
int    extra_name_bit    args( ( char *buf       ) );
char * room_bit_name     args( ( int room_flags  ) );
int    room_name_bit     args( ( char *buf       ) );
char * act_bit_name      args( ( int act         ) );
char * plr_bit_name      args( ( int act         ) );
int    act_name_bit      args( ( char *buf       ) );
char * wear_bit_name     args( ( int wear        ) );
int    wear_name_bit     args( ( char *buf       ) );
char * wear_loc_name     args( ( int wearloc     ) );
int    wear_name_loc     args( ( char *buf       ) );
char * sector_name       args( ( int sect        ) );
int    sector_number     args( ( char *argument  ) );
char * position_name     args( ( int pos         ) );
int    size_number       args( ( char *argument  ) );
char * size_name         args( ( int size        ) );
int    get_dir           args( ( char *arg       ) );
int    exit_name_bit     args( ( char *arg       ) );
char * exit_bit_name     args( ( int flag        ) );
int    get_mob_sex_number args(( char *arg       ) );
int    get_proc_type     args( ( char *arg       ) );
char * show_proc_type    args( ( int proc_type   ) );
char * shop_bit_name     args( ( int flag        ) );
int    shop_name_bit     args( ( char *name      ) );
char * name_good_code    args( ( int good_code   ) );
char * name_stat_range   args( ( int stat        ) );


/*****************************************************************************
 * Variable and functional contents for file board.c                         *
 * Contains the current bulletin board and mail systems for internal mud use.*
 *****************************************************************************/
 
/* Omitted board listings. */

void fread_board   args( ( int b ) );
void load_boards   args( ( void ) );
void note_remove   args( ( CHAR_DATA *ch, NOTE_DATA *pnote, int b ) );
void save_board    args( ( int b ) );
bool is_note_to    args( ( CHAR_DATA *ch, int board, NOTE_DATA *pnote ) );
void note_attach   args( ( CHAR_DATA *ch ) );
DECLARE_DO_FUN( do_note    );

/*****************************************************************************
 * Functional and variable contents for file comm.c                          *
 * Contains all hard-comm routines with each descriptor.                     *
 *****************************************************************************/
 
extern DESCRIPTOR_DATA * descriptor_list;
extern FILE *          fpReserve;
extern bool            newlock;
extern bool            wizlock;
extern bool            shut_down;
extern char            str_boot_time[MAX_INPUT_LENGTH];
extern time_t          current_time;
extern int             packet[60];
extern bool            QUIET_STC;

 /* Omitted: init_socket          */
void descriptor_output   args( ( void ) );
void process_input       args( ( void ) );
 /* Omitted: game_loop_mac_msdos  */
#if defined(unix)
void clean_descriptors   args( ( void ) );
void poll_descriptors    args( ( int control ) );
 /* Omitted: game_loop_unix       */
void new_descriptor      args( ( int control ) );
#endif
void close_socket        args( ( DESCRIPTOR_DATA *dclose ) );
 /* Omitted: read_from_descriptor */
 /* Omitted: read_from_buffer     */
void display_prompt      args( ( CHAR_DATA *ch ) );
bool process_output      args( ( DESCRIPTOR_DATA *d, bool fPrompt ) );
void write_to_buffer     args( ( DESCRIPTOR_DATA *d, const char *txt, 
                                 int length ) );
bool write_to_descriptor args( ( int desc, char *txt, int length ) );
void parse_snoop         args( ( DESCRIPTOR_DATA *d, const char *txt ) );
bool write_to_descr_nice args( ( DESCRIPTOR_DATA *d ) );
void stop_idling         args( ( CHAR_DATA *ch ) );
void send_to_char        args( ( const char *txt, CHAR_DATA *ch ) );
void page_to_char        args( ( const char *txt, CHAR_DATA *ch ) );
void show_string         args( ( DESCRIPTOR_DATA *d, char *input) );
void ansi_color          args( ( const char *txt, CHAR_DATA *ch ) );
void global              args( ( char *buf, int level, int toggler,
                                 int toggler2 ) );
void write_global        args( ( char *buf ) );
void act                 args( ( const char *format, CD *ch,
                                 const void *arg1, const void *arg2, 
                                 int type ) );
#if defined(macintosh)
int gettimeofday( struct timeval *tp, void *tzp )
#endif
DECLARE_DO_FUN( do_global );

/*****************************************************************************
 * Variable and functional contents for file db.c                            *
 * Contains all database, mud-wide configuration, and manipulation routines. *
 *****************************************************************************/

extern HELP_DATA *        help_first;
extern HELP_DATA *        help_last;
extern SHOP_DATA *        shop_first;
extern SHOP_DATA *        shop_last;
extern char               bug_buf           [2*MAX_INPUT_LENGTH];
extern CHAR_DATA *        char_list;
extern TERRAIN_DATA *     terrain_list;
extern char *             help_greeting;
extern char               log_buf           [2*MAX_INPUT_LENGTH];
extern OBJ_DATA *         object_list;
extern TIME_INFO_DATA     time_info;
extern WEATHER_DATA       weather_info;
extern MOB_INDEX_DATA *   mob_index_hash    [MAX_KEY_HASH];
extern OBJ_INDEX_DATA *   obj_index_hash    [MAX_KEY_HASH];
extern ROOM_INDEX_DATA *  room_index_hash   [MAX_KEY_HASH];
extern SCRIPT_DATA *      script_index_hash [MAX_KEY_HASH];
extern char *             string_hash       [MAX_KEY_HASH];
extern AREA_DATA *        area_first;
extern AREA_DATA *        area_last;
extern int                LOG_LEVEL;
extern bool               fBootDb;
extern FILE *             fpArea;
extern char               strArea           [MAX_INPUT_LENGTH];
extern struct social_type social_table      [MAX_SOCIALS];
extern int                social_count;

void    boot_db          args( ( int control ) );
 /* Omitted: fread/load_area            */
 /* Omitted: fread/load_helps           */
 /* Omitted: fread/load_mobiles         */
 /* Omitted: fread/load_objects         */
 /* Omitted: fread/load_rooms           */
 /* Omitted: fread/load_socials         */
 /* Omitted: fread/load_scripts         */
 /* Omitted: fread/load_config          */
 /* Omitted: fread/load_content         */
 /* Omitted: dump_section_0             */
 /* Omitted: dump_section_s             */
 /* Omitted: set_mob_hp                 */
void    fix_exits        args( ( void ) );
CD *    create_mobile    args( ( MOB_INDEX_DATA *pMobIndex ) );
OD *    create_object    args( ( OBJ_INDEX_DATA *pObjIndex, int level ) );
MID *   get_mob_index    args( ( int vnum ) );
OID *   get_obj_index    args( ( int vnum ) );
RID *   get_room_index   args( ( int vnum ) );
SCD *   get_script_index args( ( int vnum ) );
void    obj_strings      args( ( OBJ_DATA *obj ) );
void    mob_strings      args( ( CHAR_DATA *mob ) );
void    bug              args( ( const char *str, int param ) );
void    log_string       args( ( const char *str ) );
/* Omitted: dump_section_0             */
/* Omitted: dump_section_s             */
void    tail_chain       args( ( void ) );

/*****************************************************************************
 * Variable and functional declarations for file def.c                       *
 * Contains most tables and mainly constant declarations.                    *
 *****************************************************************************/

extern char *   const                         percent_hit      [];
extern char *   const                         percent_tired    [];
extern          const   struct coin_type      coin_table       [MAX_COIN];
extern          const   struct race_type      race_table       [MAX_RACE];
extern          const   struct lang_type      lang_table       [MAX_LANGUAGE];
extern          const   struct color_data     color_table      [];
extern          const   struct attack_type    attack_table     [];
extern          const   struct str_app_type   str_app          [26];
extern          const   struct int_app_type   int_app          [26];
extern          const   struct wis_app_type   wis_app          [26];
extern          const   struct dex_app_type   dex_app          [26];
extern          const   struct con_app_type   con_app          [26];
extern          const   struct liq_type       liq_table        [LIQ_MAX];
extern          const   struct comp_type      comp_table       [];
extern          const   struct skill_type     skill_table      [MAX_SKILL];
extern          const   struct group_type     group_table      [];

/*****************************************************************************
 * Variable and functional declarations for file door.c                      *
 * Contains most tables and mainly constant declarations.                    *
 *****************************************************************************/

char *  get_direction   args( ( char *arg ) );
int     find_door       args( ( CHAR_DATA *ch, char *arg ) );
DECLARE_DO_FUN( do_open     );
DECLARE_DO_FUN( do_close    );
OD *    has_key         args( ( CHAR_DATA *ch, int key ) );
DECLARE_DO_FUN( do_lock     );
DECLARE_DO_FUN( do_unlock   );
DECLARE_DO_FUN( do_pick     );

/*****************************************************************************
 * Variable and function declarations for file fight.c                       *
 * This file constitutes the entire combat system.                           *
 *****************************************************************************/

void    death_cry       args( ( CHAR_DATA *ch ) );
bool    is_safe         args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
void    make_corpse     args( ( CHAR_DATA *ch ) );
void    oroc            args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
void    raw_kill        args( ( CHAR_DATA *victim ) );
void    set_fighting    args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
/* void    disarm          args( ( CHAR_DATA *ch, CHAR_DATA *victim ) ); */

void    hand_attack     args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
void    mobile_attack   args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
void    weapon_attack   args( ( CHAR_DATA *ch, OBJ_DATA *obj, CHAR_DATA *victim ) );
void    beat_armor      args( ( CHAR_DATA *victim, int idx ) );
void    damage          args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dam ) );
void    update_pos      args( ( CHAR_DATA *victim ) );
void    stop_fighting   args( ( CHAR_DATA *ch, bool fBoth ) );
void    violence_update args( ( void ) );
DECLARE_DO_FUN( do_kill     );
DECLARE_DO_FUN( do_backstab );
DECLARE_DO_FUN( do_flee     );
DECLARE_DO_FUN( do_rescue   );
DECLARE_DO_FUN( do_retreat  );
DECLARE_DO_FUN( do_fight    );
DECLARE_DO_FUN( do_sla      );
DECLARE_DO_FUN( do_slay     );
DECLARE_DO_FUN( do_shoot    );
DECLARE_DO_FUN( do_reload   );
DECLARE_HIT_FUN(   hit_vorpal        );
DECLARE_HIT_FUN(   hit_suck_disarm   );

/*****************************************************************************
 * Variable and functional declarations for file furn.c                      *
 * Contains all furniture routines.                                          *
 *****************************************************************************/
 
void  show_occupants_to_char args( ( OBJ_DATA *obj, CHAR_DATA *ch ) );
int     count_occupants      args( ( OBJ_DATA *obj ) );
bool    has_occupant         args( ( OBJ_DATA *obj ) );
bool    occupant             args( ( OBJ_DATA *obj ) );
CD *    hitched              args( ( OBJ_DATA *obj ) );
OD *    get_furn_here        args( ( CHAR_DATA *ch, char *argument ) );
void    set_furn             args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );

/*****************************************************************************
 * Variable and functional declarations for file handler.c                   *
 * Contains all char/object/room manipulation procedures                     *
 *****************************************************************************/

int    get_trust    args( ( CHAR_DATA *ch ) );
int    get_curr_str    args( ( CHAR_DATA *ch ) );
int    get_curr_int    args( ( CHAR_DATA *ch ) );
int    get_curr_wis    args( ( CHAR_DATA *ch ) );
int    get_curr_dex    args( ( CHAR_DATA *ch ) );
int    get_curr_con    args( ( CHAR_DATA *ch ) );
int    can_carry_w    args( ( CHAR_DATA *ch ) );
void    affect_remove   args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
void    affect_strip    args( ( CHAR_DATA *ch, int sn ) );
void    affect_to_char  args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
bool    is_affected    args( ( CHAR_DATA *ch, int sn ) );
void    affect_join    args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
void    char_from_room    args( ( CHAR_DATA *ch ) );
void    char_to_room    args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *pRoomIndex ) );
void  obj_to_char_money args( ( OBJ_DATA *obj, CHAR_DATA *ch ) );
void    obj_to_char     args( ( OBJ_DATA *obj, CHAR_DATA *ch ) );
void    obj_from_char    args( ( OBJ_DATA *obj ) );
int     apply_ac        args( ( OBJ_DATA *obj, int iWear ) );
OD *    get_item_held   args( ( CHAR_DATA *obj, int iWear ) );
OD *    get_eq_char    args( ( CHAR_DATA *ch, int iWear ) );
int     hand_empty      args( ( CHAR_DATA *ch ) );
int     wield_free      args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
int     belt_empty      args( ( CHAR_DATA *ch ) );
bool    unequip_char    args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
void    equip_char      args( ( CHAR_DATA *ch, OBJ_DATA *obj, int iWear ) );
int    count_obj_list    args( ( OBJ_INDEX_DATA *obj, OBJ_DATA *list ) );
void    obj_from_room    args( ( OBJ_DATA *obj ) );
void    obj_to_room    args( ( OBJ_DATA *obj, ROOM_INDEX_DATA *pRoomIndex ) );
void    obj_to_obj    args( ( OBJ_DATA *obj, OBJ_DATA *obj_to ) );
void    obj_from_obj    args( ( OBJ_DATA *obj ) );
void    extract_obj    args( ( OBJ_DATA *obj ) );
void    extract_char    args( ( CHAR_DATA *ch, bool fPull ) );
CD *    get_char_room    args( ( CHAR_DATA *ch, char *argument ) );
CD *    get_char_world    args( ( CHAR_DATA *ch, char *argument ) );
OD *    get_obj_type    args( ( OBJ_INDEX_DATA *pObjIndexData ) );
int     get_obj_number  args( ( OBJ_DATA *obj ) );
int     get_obj_weight  args( ( OBJ_DATA *obj ) );
int     room_is_dark    args( ( ROOM_INDEX_DATA *pRoomIndex ) );
bool    room_is_private args( ( ROOM_INDEX_DATA *pRoomIndex ) );
bool    can_see         args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
bool    can_see_obj     args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
bool    can_drop_obj    args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
char *  get_extra_descr args( ( const char *name, EXTRA_DESCR_DATA *ed ) );
bool    use_tool        args( ( OBJ_DATA *obj, int bit ) );
int     PERCENTAGE      args( ( int amount, int max ) );
bool    skill_check     args( ( CHAR_DATA *ch, int sn, int modifier ) );
int     wield_weight    args( ( CHAR_DATA *ch ) );

/*****************************************************************************
 * Variable and functional declarations for file interp.c                    *
 * Handles all input interpretation for the mail command set.                *
 *****************************************************************************/

extern  const   struct  cmd_type        cmd_table       [];

DECLARE_DO_FUN( do_comlist  );
void    interpret       args( ( CHAR_DATA *ch, char *argument ) );
 /* Omitted: check_social       */

/*****************************************************************************
 * Variable and functional declarations for file language.c                  *
 * Does the cool stuff for language garbling and stuff like that.            *
 *****************************************************************************/

char *  garble_text     args( ( char *text, int prcnt_comp ) );
int     check_speech    args( ( CHAR_DATA *ch, CHAR_DATA *speaker,
                               int gsn ) );


/*****************************************************************************
 * Variable and functional declarations for file mem.c                       *
 * Handles all memory creation and disposing, and the free lists.            *
 *****************************************************************************/

/* Omitted free lists and zero structures, they need not be global. */

extern int    num_pulse;       /* Remaining pulses until reboot. */

extern char * string_space;
extern char * top_string;
extern char   str_empty[1];

extern int top_affect;
extern int top_area;
extern int top_ed;
extern int top_exit;
extern int top_help;
extern int top_mob_index;
extern int top_obj_index;
extern int top_reset;
extern int top_room;
extern int top_shop;
extern int top_variable;
extern int top_trigger;
extern int top_script;
extern int top_char_data;
extern int top_pcdata;
extern int top_attack;
extern int top_obj;
extern int top_descriptor;
extern int top_note;

extern int top_vnum_script;
extern int top_vnum_mob;
extern int top_vnum_obj;
extern int top_vnum_room;
extern int top_vnum_terrain;

DD *    new_descriptor_data   args( ( void ) );
void    free_descriptor       args( ( DESCRIPTOR_DATA *d ) );
CD *    new_char_data         args( ( void ) );
void    free_char             args( ( CHAR_DATA *ch ) );
PCD *   new_pc_data           args( ( void ) );
void    free_pc_data          args( ( PC_DATA *ch ) );
OD *    new_obj               args( ( void ) );
void    free_obj              args( ( OBJ_DATA *pObj ) );
RD *    new_reset_data        args( ( void ) );
void    free_reset_data       args( ( RESET_DATA *pReset ) );
TERRAIN_DATA *  new_terrain           args( ( void ) );
AD *    new_area              args( ( void ) );
void    free_area             args( ( AREA_DATA *pArea ) );
EDD *   new_extra_descr       args( ( void ) );
void    free_extra_descr      args( ( EXTRA_DESCR_DATA *pExtra ) );
ED *    new_exit              args( ( void ) );
void    free_exit             args( ( EXIT_DATA *pExit ) );
ATD *   new_attack            args( ( void ) );
void    free_attack           args( ( ATTACK_DATA *attack ) );
RID *   new_room_index        args( ( void ) );
void    free_room_index       args( ( ROOM_INDEX_DATA *pRoom ) );
AFD *   new_affect            args( ( void ) );
void    free_affect           args( ( AFFECT_DATA* pAf ) );
OID *   new_obj_index         args( ( void ) );
void    free_obj_index        args( ( OBJ_INDEX_DATA *pObj ) );
SD *    new_shop              args( ( void ) );
void    free_shop             args( ( SHOP_DATA *pShop ) );
MID *   new_mob_index         args( ( void ) );
void    free_mob_index        args( ( MOB_INDEX_DATA *pMob ) );
VD *    new_variable          args( ( void ) );
TD *    new_trigger           args( ( void ) );
void    free_variable         args( ( VARIABLE_DATA *var ) );
void    free_trigger          args( ( TRIGGER_DATA *trig ) );
SCD *   new_script            args( ( void ) );
void    free_script           args( ( SCRIPT_DATA *scr ) );
char    fread_letter          args( ( FILE *fp ) );
int     fread_number          args( ( FILE *fp ) );
char *  fread_string          args( ( FILE *fp ) );
char *  fread_string_eol      args( ( FILE *fp ) );
void    fread_to_eol          args( ( FILE *fp ) );
char *  fread_word            args( ( FILE *fp ) );
void *  alloc_mem             args( ( int sMem ) );
void    free_mem              args( ( void *pMem, int sMem ) );
void *  alloc_perm            args( ( int sMem ) );
char *  str_dup               args( ( const char *str ) );
void    free_string           args( ( char *pstr ) );
DECLARE_DO_FUN( do_memory );

/*****************************************************************************
 * Variable and functional declarations for file money.c                     *
 * Contains all money/object routines.                                       *
 *****************************************************************************/
 
void    update_money    args( ( OBJ_DATA *obj ) );
OD *    create_money    args( ( int amount, int type ) );
void    merge_money     args( ( CHAR_DATA *ch ) );
void    merge_money_obj args( ( OBJ_DATA *obj ) );
void    create_amount   args( ( int amount, CHAR_DATA *pMob,
                                ROOM_INDEX_DATA *pRoom, OBJ_DATA *pObj ) );
int     tally_coins     args( ( CHAR_DATA *mob ) );
int     tally_one_coin  args( ( CHAR_DATA *mob, int type, bool fContents ) );
int     tally_one_coin_obj  args( ( OBJ_DATA *obj, int type ) );
char *  name_amount     args( ( int amount ) );
void    strip_empty_money args( ( CHAR_DATA *ch ) );
char *  sub_coins       args( ( int amount, CHAR_DATA *ch ) );

/*****************************************************************************
 * Variable and functional declarations for file mount.c                     *
 * Contains all mount/dismount routines.                                     *
 *****************************************************************************/

void dismount_char      args( ( CHAR_DATA *ch ) );
void mount_char         args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
DECLARE_DO_FUN( do_mount     );
DECLARE_DO_FUN( do_dismount  );

/*****************************************************************************
 * Variable and functional declarations for file nanny.c                     *
 * Handles all new-connection and new-character code.                        *
 *****************************************************************************/

 /* Omitted: setup_race           */
 /* Omitted: new_char             */
void    nanny              args( ( DESCRIPTOR_DATA *d, char *argument ) );
 /* Omitted: nanny_check          */
 /* Omitted: check_parse_name     */
 /* Omitted: check_playing        */
 /* Omitted: check_reconnect      */
 /* Omitted: stop_idling          */
bool    apply_ok           args( ( CHAR_DATA *ch ) );
 /* Omitted: print_gen_menu       */
 /* Omitted: print_doc_menu       */
void    print_login_menu   args( ( CHAR_DATA *ch ) );


/*****************************************************************************
 * Variable and functional declarations for file magic.c                     *
 * This file is not really functioning at this time.                         *
 *****************************************************************************/
int    skill_lookup    args( ( const char *name ) );
int    slot_lookup    args( ( int slot ) );
bool    saves_spell    args( ( int level, CHAR_DATA *victim ) );
void    obj_cast_spell    args( ( int sn, int level, CHAR_DATA *ch,
                    CHAR_DATA *victim, OBJ_DATA *obj ) );

/*****************************************************************************
 * Variable and functional declarations for file oc.c                        *
 * The online creation source code is contained herein.                      *
 *****************************************************************************/

AD *    get_area_data          args( ( int vnum ) );
AD *    get_vnum_area          args( ( int vnum ) );
char *  area_bit_name          args( ( int area_flags ) );
int     get_area_flags_number  args( ( char *argument ) );
void    aedit                  args( ( CHAR_DATA *ch, char *argument ) );
bool    redit_exit             args( ( CD *ch, RID *pRoom, int door,
                                       char *arg1, char *arg2 ) );
void    redit                  args( ( CHAR_DATA *ch, char *argument ) );
void    oedit                  args( ( CHAR_DATA *ch, char *argument ) );
void    medit                  args( ( CHAR_DATA *ch, char *argument ) );
void    sedit                  args( ( CHAR_DATA *ch, char *argument ) );
DECLARE_DO_FUN( do_aedit  );
DECLARE_DO_FUN( do_redit  );
DECLARE_DO_FUN( do_oedit  );
DECLARE_DO_FUN( do_medit  );
DECLARE_DO_FUN( do_sedit  );
DECLARE_DO_FUN( do_mindex );
DECLARE_DO_FUN( do_sindex );
void value_breakdown           args( ( int type, int v1, int v2, int v3, int v4,
                                       CHAR_DATA *ch ) );
DECLARE_DO_FUN( do_oindex );
 /* Omitted: display_resets       */
 /* Omitted: add_reset            */
DECLARE_DO_FUN( do_resets );
DECLARE_DO_FUN( do_astat  );
 /* Omitted: save_area_list       */
 /* Omitted: save_mobiles         */
 /* Omitted: save_objects         */
 /* Omitted: save_rooms           */
 /* Omitted: save_area            */
DECLARE_DO_FUN( do_asave  );

/*****************************************************************************
 * Variable and functional declarations for file parse.c                     *
 * Contains all parsing routines for input.                                  *
 *****************************************************************************/

OD *    get_obj_list    args( ( CHAR_DATA *ch, char *argument,
                                OBJ_DATA *list ) );
OD *    get_obj_carry   args( ( CHAR_DATA *ch, char *argument ) );
OD *    get_obj_wear    args( ( CHAR_DATA *ch, char *argument ) );
OD *    get_obj_inv     args( ( CHAR_DATA *ch, char *argument ) );
OD *    get_obj_here    args( ( CHAR_DATA *ch, char *argument ) );
OD *    get_obj_world   args( ( CHAR_DATA *ch, char *argument ) );

/*****************************************************************************
 * Variable and functional declarations for file save.c                      *
 * Includes saving and loading of characters, and savable rooms.             *
 *****************************************************************************/

#define MAX_NEST        1000

extern CHAR_DATA *mount_list;
extern OBJ_DATA *      rgObjNest       [MAX_NEST];

 /* Omitted: fread/fwrite char */
 /* Omitted: fread/fwrite mob  */
void    fwrite_obj      args( ( OBJ_DATA *obj, FILE *fp, int iNest ) );
void    fread_obj       args( ( void *caller, int caller_type, FILE *fp ) );
void    save_char_obj    args( ( CHAR_DATA *ch ) );
bool    load_char_obj    args( ( DESCRIPTOR_DATA *d, char *name ) );

/*****************************************************************************
 * Variable and functional declarations for shop.c                           *
 * The shop system and trading code.                                         *
 *****************************************************************************/

extern const     struct   goods_type    goods_table    [];

OD *    create_good        args( ( int good ) );
OD *    create_comp        args( ( int comp ) );
void    shop_list_to_char  args( ( CHAR_DATA *keeper, CHAR_DATA *ch ) );
OD *    get_shop_list_obj  args( ( CHAR_DATA *keeper, CHAR_DATA *ch, int number ) );
CD *    find_keeper        args( ( CHAR_DATA *ch, char *arg ) );
int     get_cost           args( ( CHAR_DATA *keeper, OBJ_DATA *obj, bool fBuy ) );
DECLARE_DO_FUN( do_list     );
DECLARE_DO_FUN( do_buy      );
DECLARE_DO_FUN( do_trade    );
DECLARE_DO_FUN( do_sell     );
DECLARE_DO_FUN( do_barter   );
DECLARE_DO_FUN( do_offer    );


/*****************************************************************************
 * Variable and functional declarations for script.c                         *
 * The script language and parser.                                           *
 *****************************************************************************/

DECLARE_DO_FUN( do_script   );
 /* Omitted internal parsing routines.   */
int script_update    args( ( void * caller, int type, int ttype,
                             CHAR_DATA *actor, OBJ_DATA *catalyst, char *astr,
                             char *bstr  ) );
void parse_script    args( ( TRIGGER_DATA *trig, void * caller, int type ) );
void trigger_list    args( ( OBJ_DATA *list, int ttype, CHAR_DATA  *actor,
                             OBJ_DATA *catalyst, char *astr, char *bstr ) );
VD *eval_function  args( ( void * caller, int type, char *exp ) );

/*****************************************************************************
 * Variable and functional declarations for skills.c                         *
 * Skill routines.                                                           *
 *****************************************************************************/
bool    is_group_index     args( ( int sn ) );
int     group_lookup       args( ( char *name ) );
int     skill_lookup       args( ( const char *name ) );
int     slot_lookup        args( ( int slot ) );
int     group_slot_lookup  args( ( int slot ) );
char *  skill_level        args( ( int sn, int percent ) );
bool    advance_skill      args( ( CHAR_DATA *ch, int sn, int advance, int time_mod ) );
bool    has_prereq         args( ( CHAR_DATA *ch, int sn, bool fTell ) );
void    display_skills     args( ( CHAR_DATA *ch, int group ) );
DECLARE_DO_FUN( do_skills    );
DECLARE_DO_FUN( do_learn     );
DECLARE_DO_FUN( do_practice  );

/*****************************************************************************
 * Variable and functional declarations for string.c                         *
 * Handles most string routines.                                             *
 *****************************************************************************/

void    smash_tilde     args( ( char *str ) );
bool    str_cmp         args( ( const char *astr, const char *bstr ) );
bool    str_prefix      args( ( const char *astr, const char *bstr ) );
bool    str_infix       args( ( const char *astr, const char *bstr ) );
bool    str_suffix      args( ( const char *astr, const char *bstr ) );
char *  capitalize      args( ( const char *str ) );
void    append_file     args( ( CHAR_DATA *ch, char *file, char *str ) );
char *  fix_string      args( ( const char *str ) );
char *  is_are          args( ( char *buf ) );
char *  smash_arg       args( ( char *text, char *name ) );
char *  smash_article   args( ( char *text ) );
char *  pluralize       args( ( char *argument ) );
char *  format_string   args( ( char *oldstring /*, bool fSpace */ ) );
char *  format_indent   args( ( char *oldstring, char *prefix, int width,
                                bool fEnd ) );
char *  replace_string  args( ( char *orig, char *old, char *new ) );
char *  string_replace  args( ( char * orig, char * old, char * new ) );
int     arg_count       args( ( char * argument ) );
char *  string_unpad    args( ( char * argument ) );
char *  string_proper   args( ( char * argument ) );
void    string_edit     args( ( CHAR_DATA *ch, char **pString ) );
void    string_append   args( ( CHAR_DATA *ch, char **pString ) );
void    string_add      args( ( CHAR_DATA *ch, char *argument ) );
bool    is_number       args( ( char *arg ) );
int     number_argument args( ( char *argument, char *arg ) );
char *  one_argument    args( ( char *argument, char *arg_first ) );
char *  one_argcase     args( ( char *argument, char *arg_first ) );
char *  strupr          args( ( char * s ) );
char *  strlwr          args( ( char * s ) );
char *  ansi_uppercase  args( ( char *txt) );
bool    is_name         args( ( const char *str, char *namelist ) );
bool    is_prename      args( ( const char *str, char *namelist ) );
/* Omitted a few const declarations for numberize. */
char *  numberize       args( ( int n ) );
char *  first_arg       args( ( char *argument, char *arg_first, bool fCase ));
char *  skip_spaces     args( ( char *argument ) );
char *  grab_line       args( ( char *argument, char *arg_first ) );
char *  one_line        args( ( char *argument, char *arg_first ) );
bool    has_arg         args( ( char *argument, char *item ) );
char *  trunc_fit       args( ( char *argument, int length ) );
char *  gotoxy          args( ( int x, int y ) );
char *  skip_curlies    args( ( char *arg ) );
char *  strip_curlies   args( ( char *arg ) );

/*****************************************************************************
 * Variable and functional declarations for special.c                        *
 * The old "special functions" that provide basic functions to the world.    *
 * This file may not exist.                                                  *
 *****************************************************************************/
SF *    spec_lookup     args( ( const char *name ) );
char *  sfun_lookup     args( ( SPEC_FUN *sfunc ) );

/*****************************************************************************
 * Variable and functional declarations for track.c                          *
 * Handles the internal queue-based tracking routines submitted by jdinkel.  *
 *****************************************************************************/

 /* Omitted: list/bfs queue functions     */
int find_first_step     args( ( ROOM_INDEX_DATA *src, ROOM_INDEX_DATA *target,
                                int depth ) );
DECLARE_DO_FUN( do_track    );

/*****************************************************************************
 * Variable and functional declarations for update.c                         *
 * Includes update handler and turn-to-turn information.                     *
 *****************************************************************************/
 
void    advance_level    args( ( CHAR_DATA *ch ) );
int     hit_gain        args( ( CHAR_DATA *ch ) );
int     move_gain       args( ( CHAR_DATA *ch ) );
void    gain_condition    args( ( CHAR_DATA *ch, int iCond, int value ) );
void    mobile_update    args( ( void ) );
void    weather_update    args( ( void ) );
void    char_update     args( ( bool fEach ) );
void    obj_update      args( ( bool fEach ) );
void    aggr_update     args( ( void ) );
bool    reset_room      args( ( ROOM_INDEX_DATA *pRoom ) );
void    room_update     args( ( void ) );
void script_update_proc args( ( void ) );
void    update_handler  args( ( void ) );

/*****************************************************************************
 * Variable and functional declarations for file wiz.c                       *
 * Contains generic immortal privledged commands and functions.              *
 *****************************************************************************/
extern BAN_DATA *ban_list;

RID   * find_location   args( ( CHAR_DATA *ch, char *arg ) );
DECLARE_DO_FUN( do_advance     );
DECLARE_DO_FUN( do_restore     );
DECLARE_DO_FUN( do_freeze      );
DECLARE_DO_FUN( do_log           );
DECLARE_DO_FUN( do_noemote     );
DECLARE_DO_FUN( do_peace       );
DECLARE_DO_FUN( do_ban           );
DECLARE_DO_FUN( do_allow       );
DECLARE_DO_FUN( do_wizlock     );
DECLARE_DO_FUN( do_force       );
DECLARE_DO_FUN( do_invis       );
DECLARE_DO_FUN( do_holylight   );
DECLARE_DO_FUN( do_bounty      );
DECLARE_DO_FUN( do_wizify      );
DECLARE_DO_FUN( do_bamfin      );
DECLARE_DO_FUN( do_bamfout     );
DECLARE_DO_FUN( do_deny        );
DECLARE_DO_FUN( do_disconnect  );
DECLARE_DO_FUN( do_system      );
DECLARE_DO_FUN( do_echo        );
DECLARE_DO_FUN( do_recho       );
DECLARE_DO_FUN( do_transfer    );
DECLARE_DO_FUN( do_at           );
DECLARE_DO_FUN( do_goto        );
DECLARE_DO_FUN( do_reboo       );
DECLARE_DO_FUN( do_reboot      );
DECLARE_DO_FUN( do_shutdow     );
DECLARE_DO_FUN( do_shutdown    );
DECLARE_DO_FUN( do_snoop       );
DECLARE_DO_FUN( do_switch      );
DECLARE_DO_FUN( do_return      );
DECLARE_DO_FUN( do_charload    );
DECLARE_DO_FUN( do_shell       );
DECLARE_DO_FUN( do_purge       );

/*****************************************************************************
 * Variable and functional declarations for file wiz_info.c                  *
 * Contains all object/mobile/room commands for higher level immortals.      *
 *****************************************************************************/

extern int      FORCE_LEVEL;

DECLARE_DO_FUN( do_wizhelp     );
DECLARE_DO_FUN( do_rstat       );
DECLARE_DO_FUN( do_index       );
bool   ostat    args( ( CHAR_DATA *ch, char *argument ) );
bool   mstat    args( ( CHAR_DATA *ch, char *argument ) );
DECLARE_DO_FUN( do_stat        );
DECLARE_DO_FUN( do_mfind       );
DECLARE_DO_FUN( do_ofind       );
DECLARE_DO_FUN( do_rfind       );
DECLARE_DO_FUN( do_pfind       );
bool   mwhere    args( ( CHAR_DATA *ch, char *argument ) );
bool   owhere    args( ( CHAR_DATA *ch, char *argument ) );
void   pwhere    args( ( CHAR_DATA *ch ) );
DECLARE_DO_FUN( do_where       );
DECLARE_DO_FUN( do_users       );
DECLARE_DO_FUN( do_sockets     );
DECLARE_DO_FUN( do_slookup     );
DECLARE_DO_FUN( do_areas       );
DECLARE_DO_FUN( do_table       );

/*****************************************************************************
 * Variable and functional declarations for file wiz_set.c                   *
 * Contains immortal commands that allow "illegal" customization of objects. *
 *****************************************************************************/

DECLARE_DO_FUN( do_mload       );
DECLARE_DO_FUN( do_oload       );
DECLARE_DO_FUN( do_load        );
DECLARE_DO_FUN( do_sset        );
DECLARE_DO_FUN( do_mset        );
DECLARE_DO_FUN( do_oset        );
DECLARE_DO_FUN( do_pset        );

/*****************************************************************************
 * Variable and functional declarations for file worldgen.c                  *
 * Experimental World Creation Functions                                     *
 *****************************************************************************/

void    show_terrain    args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *pRoom ) );
DECLARE_DO_FUN( do_terrain   );
void    generate        args( ( CHAR_DATA *ch, int lvnum, int hvnum, bool fOverwrite ) );

/*****************************************************************************
 * Variable and functional declarations for file xrand.c                     *
 * Contains all random number generation routines.                           *
 *****************************************************************************/

int     number_fuzzy    args( ( int number ) );
int     number_gelify   args( ( int number ) );
int     number_range    args( ( int from, int to ) );
int     number_percent  args( ( void ) );
int     number_door     args( ( void ) );
int     number_bits     args( ( int width ) );
void    init_mm         args( ( void ) );
int     number_mm       args( ( void ) );
int     dice            args( ( int number, int size ) );



#undef    CD
#undef    MID
#undef    OD
#undef    OID
#undef    RID
#undef    SF
#undef  AD
#undef  VD
#undef  RD
#undef  TD
#undef  SD
#undef  EDD
#undef  AFD
#undef  ED
#undef  ATD
#undef  PCD
#undef  SCD
#undef  DD

