/****************************************************************************
 *   ___  ___  ___  __    __                                                *
 *  |   ||   ||   ||  |\/|  | 2-x    NiMUD is a software currently under    *
 *   |  \ | |  | |  | |\/| |         development.  It is based primarily on *
 *   | |\\| |  | |  | |  | |         the discontinued package, Merc 2.2.    *
 *   | | \  |  | |  | |  | |         NiMUD is being written and developed   *
 *  |___||___||___||__|  |__|        By Locke and Surreality as a new,      *
 *   NAMELESS INCARNATE *MUD*        frequently updated package similar to  *
 *        S O F T W A R E            the original Merc 2.x.                 *
 *                                                                          *
 *  Just look for the Iron Maiden skull wherever NiMUD products are found.  *
 *                                                                          *
 *  Much time and thought has gone into this software and you are           *
 *  benefitting.  We hope that you share your changes too.  What goes       *
 *  around, comes around.                                                   *
 ****************************************************************************
 * This code is included at the top of the code declarations in comm.c.     *
 ****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#endif

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "defaults.h"
#include "comm.h"
#include "skills.h"

/*
 * Signal handling.
 * Apollo has a problem with __attribute(atomic) in signal.h,
 * So dance around it.
 */
#if defined(apollo)
#define __attribute(x)
#endif

#if defined(unix)
#include <signal.h>
#endif

#if defined(apollo)
#undef __attribute
#endif


/*
 * Socket and TCP/IP stuff.
 */
#if     defined(macintosh) || defined(MSDOS)
const char    echo_off_str    [] = { '\0' };
const char    echo_on_str     [] = { '\0' };
#endif

#if     defined(unix) && !defined(ECHO_STR)
#include <fcntl.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/telnet.h>

const char    echo_off_str    [] = { IAC, WILL, TELOPT_ECHO, '\0' };
const char    echo_on_str     [] = { IAC, WONT, TELOPT_ECHO, '\0' };
#endif

#include "network.h"

/*
 * Local defines.
 */
#define DC(desc)   ( desc->connected )
#define MT(str, d) ( str == NULL || str[0] == '\0' ? d : str )
#define SMT(str)   ( str == NULL || str[0] == '\0' )

/*
 * Other local functions (OS-independent).
 */
void    nanny              args( ( DESCRIPTOR_DATA *d, char *argument ) );
void    nanny_check        args( ( DESCRIPTOR_DATA *d ) );
bool    check_parse_name   args( ( char *name ) );
bool    check_playing      args( ( DESCRIPTOR_DATA *d, char *name ) );
bool    check_reconnect    args( ( DESCRIPTOR_DATA *d, char *name,
                                   bool fConn ) );
void    stop_idling        args( ( CHAR_DATA *ch ) );
bool    apply_ok           args( ( CHAR_DATA *ch ) );
void    print_gen_menu     args( ( CHAR_DATA *ch ) );
void    print_doc_menu     args( ( CHAR_DATA *ch ) );
void    print_login_menu   args( ( CHAR_DATA *ch ) );
void    print_stat_menu    args( ( CHAR_DATA *ch ) );

/*
 * Guest Character support.
 */
int       guestnumber = 0;
CHAR_DATA *generate_guest  args( ( void ) );




/*
 * Setup new player racial information.
 */
void setup_race( CHAR_DATA *ch )
{
    ch->affected_by      = race_table[ch->race].affect_bits;
    ch->position         = POS_STANDING;

    ch->act              = 0;
    ch->act2             = PLR_BLANK | PLR_COMBINE | PLR_PROMPT;
    ch->pagelen          = 20;

    free_string( ch->prompt );
    ch->prompt           = str_dup( "< %h %m > " );

    ch->in_room          = get_room_index( ROOM_VNUM_APPLICATIONS );

    ch->hit              = MAXHIT(ch);
    ch->move             = MAXMOVE(ch);

    /*
     * Race information.
     */
    ch->perm_str      = number_fuzzy(11) + race_table[ch->race].bonus[0];
    ch->perm_int      = number_fuzzy(11) + race_table[ch->race].bonus[1];
    ch->perm_wis      = number_fuzzy(11) + race_table[ch->race].bonus[2];
    ch->perm_dex      = number_fuzzy(11) + race_table[ch->race].bonus[3];
    ch->perm_con      = number_fuzzy(11) + race_table[ch->race].bonus[4];
    ch->size          = race_table[ch->race].size;
    ch->owed          = 2;

    PC(ch,learned)[gsn_zengalli]   = 50;

    switch ( ch->race )
    {
        default: bug( "Setup_race: Invalid race %d.", ch->race );
        case 0:  PC(ch,learned)[gsn_zengalli]  = 100; break;
        case 1:  PC(ch,learned)[gsn_olani]     = 100;
                 PC(ch,learned)[gsn_mudaki]    =  25; break;
        case 2:  PC(ch,learned)[gsn_zalufini]  = 100; break;
        case 3:  PC(ch,learned)[gsn_dakonenne] = 100; break;
        case 4:  PC(ch,learned)[gsn_haanstaed] = 100;
        case 5:  PC(ch,learned)[gsn_zengalli]  = 100; break;
        case 6:  PC(ch,learned)[gsn_haesni]    = 100; break;
        case 7:  PC(ch,learned)[gsn_ghaenish]  = 100; break;
    }

    PC(ch,birth_day)   = time_info.day;
    PC(ch,birth_month) = time_info.month;
    PC(ch,birth_year)  = time_info.year - race_table[ch->race].start_age;
    return;
}

/*
 * Assign default new-character information, objects, etc.
 * Due to nature of objects, do not call twice.
 */
void new_char( CHAR_DATA *ch )
{
    OBJ_DATA *obj;

    if ( ch == NULL )
    return;
    
    /*
     * Newbie equipment.
     */
    if ( ch->carrying == NULL )
    {
    obj = create_object( get_obj_index( OBJ_VNUM_DEFAULT_LIGHT ), 1 );
    obj_to_char( obj, ch );
    obj->wear_loc = WEAR_HOLD_2;
    obj = create_object( get_obj_index( OBJ_VNUM_DEFAULT_WEAPON ), 1 );
    obj_to_char( obj, ch );
    obj->wear_loc = WEAR_HOLD_1;
    obj = create_object( get_obj_index( OBJ_VNUM_DEFAULT_VEST ), 1 );
    obj_to_char( obj, ch );
    obj->size = ch->size;
    equip_char( ch, obj, WEAR_BODY );
    obj = create_object( get_obj_index( OBJ_VNUM_DEFAULT_BELT ), 1 );
    obj_to_char( obj, ch );
    obj->size = ch->size;
    equip_char( ch, obj, WEAR_WAIST );
    obj = create_object( get_obj_index( OBJ_VNUM_DEFAULT_PACK ), 1 );
    obj_to_char( obj, ch );
    obj->size = ch->size;
    equip_char( ch, obj, WEAR_SHOULDER_L );
    obj_to_obj( create_object( get_obj_index( OBJ_VNUM_DEFAULT_TINDERBOX ), 1),
                obj );
    obj_to_obj( create_object( get_obj_index( OBJ_VNUM_DEFAULT_LETTER ), 1),
                obj );
    obj_to_obj( create_object( get_obj_index( OBJ_VNUM_DEFAULT_FOOD ), 1),
                obj );
    obj_to_obj( create_object( get_obj_index( OBJ_VNUM_DEFAULT_DRINK ), 1),
                obj );
    create_amount( number_range( 5, 10 ) * 10, ch, NULL, NULL );
    }

    if ( ch->pcdata == NULL ) ch->pcdata = new_pc_data( );
    PC(ch,level)         = LEVEL_APPLIED;

    return;
}



void print_doc_menu( CHAR_DATA *ch )
{
    write_to_buffer( ch->desc, echo_on_str, 0 );

    do_help( ch, "NANNY_DOC_MENU_HEADER" );

    return;
}

void doc_menu( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    char arg[MAX_STRING_LENGTH];

    write_to_buffer( ch->desc, echo_on_str, 0 );

    one_argument( argument, arg );

    d = ch->desc;

    if ( (d = ch->desc) == NULL ) return;

    if ( arg[0] == '?' )
    {
        print_doc_menu( ch );
        return;
    }
    else
    if ( arg[0] == '\0' )
    {
        send_to_char( "To exit, type 'X', to see a list of topics, type '?'.\n\r", ch );
        return;
    }
    else
    if ( LOWER(arg[0]) == 'x' )
    {
        DC(d) = CON_LOGIN_MENU;   /* Must be in this order, else the */
        print_login_menu( ch );          /* header is displayed.            */
        return;
    }
    else
    {
    do_help( ch, argument );
    }

    return;
}

void print_login_menu( CHAR_DATA *ch )
{
    write_to_buffer( ch->desc, echo_on_str, 0 );

    do_help( ch, "NANNY_LOGIN_MENU_HEADER" );

    send_to_char( capitalize(ch->name), ch );
    send_to_char( ", ", ch );
    send_to_char( "choose thy fate: ",  ch );

    return;
}


void login_menu( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    char arg[MAX_STRING_LENGTH];

    d = ch->desc;
    one_argument( argument, arg );

    switch ( UPPER(arg[0]) )
    {
        case 'W': /* See who is online */
        {
            if ( !str_cmp( ch->name, "guest" ) && PC(ch,level) != 2 )
            {
                send_to_char( "Please connect as your character, first.\n\r", ch );
                print_login_menu( ch );
                DC(d) = CON_LOGIN_MENU;
                return;
            }
            
            do_who( ch, "" );
            print_login_menu( ch );
            DC(d) = CON_LOGIN_MENU;
            break;
        }
        case 'E': /* Enter the game */
        {
            char buf[MAX_STRING_LENGTH];

            if ( !str_cmp( ch->name, "guest" ) )
            {
                send_to_char( "Please connect as your character, first.\n\r", ch );
                print_login_menu( ch );
                DC(d) = CON_LOGIN_MENU;
                return;
            }

            if ( PC(ch,level) > LEVEL_APPLIED )
            {
                if ( IS_HERO(ch) )  do_help( ch, "imotd" );
                do_help( ch, "motd" );
                DC(d) = CON_READ_MOTD;       /* Bypass informality */
            }
            else
            {
            if ( PC(ch,denial) == NULL || PC(ch,denial)[0] == '\0' )
            {
                send_to_char( "\n\rYour character has not yet been approved.\n\r", ch );
                do_help ( ch, "NANNY_AWAITING_APPLY" );
                DC(d) = CON_READ_MOTD;
            }
            else
            {
                sprintf( buf, "\n\rReason for rejection:\n\r\n\r%s\n\r\n\r", PC(ch,denial) );
                send_to_char( buf, ch );
                do_help( ch, "NANNY_RESUBMIT" );
                DC(d) = CON_GEN_MENU;
            }
            }
            return;
        }
       break;
        case 'N': /* New character */
        {
            free_char( ch );
            d->character = new_char_data( );
            ch = d->character;
            ch->desc = d;
            ch->name = str_dup( "Guest" );

            send_to_char( "Enter a password you plan to use: ", ch );
            DC(d) = CON_GET_NEW_PASSWORD;
        }
       break;
        case 'C': /* Connect to Character */
        {
            send_to_char( "By what name are you known? ", ch );
            DC(d) = CON_GET_NAME_NOLOGIN;
        }
       break;
        case 'R': /* Read documentation */
        {
            print_doc_menu( ch );
            DC(d) = CON_DOC_MENU;
        }
       break;
        case 'D': /* Resubmit char */
        {
            if ( !str_cmp( STR(ch,name), "guest" ) )
            {
                send_to_char( "Please log in as your character first.\n\r", ch );
                print_login_menu( ch );
                DC(d) = CON_LOGIN_MENU;
                return;
            }

            do_help( ch, "NANNY_RESUBMIT_WARNING" );
            send_to_char( "Are you sure you wish to delete this character and resubmit? ", ch );
            DC(d) = CON_CONFIRM_RESUBMIT;
        }
       break;
        case 'X': /* Quit */
        {
            do_help( ch, "MENU_FAREWELL" );
            close_socket( d );
            return;
        }
       break;
        default:
        {
            send_to_char( "That choice is invalid.\n\r\n\r", ch );
            print_login_menu( ch );
            ch->desc->connected = CON_LOGIN_MENU;
            return;
        }
       break;
    }

    return;
}


void print_gen_menu( CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];

    write_to_buffer( ch->desc, echo_on_str, 0 );

    do_help( ch, "NANNY_GEN_MENU_HEADER" );
    sprintf( buf, "[1] You are a member of the %s race.\n\r",
                  race_table[ch->race].race_name );
    send_to_char( buf, ch );
    sprintf( buf, "[2] You are %s.\n\r",
                  ch->sex == SEX_MALE   ? "a man" :
                  ch->sex == SEX_FEMALE ? "a woman" : "neuter" );
    send_to_char( buf, ch );
    sprintf( buf, "[3] Your name is %s,\n\r",
                  !str_cmp( ch->name, "guest" )
                    ? "not yet supplied"
                    : capitalize( ch->name ) );
    send_to_char( buf, ch );
    sprintf( buf, "[4] but to others you are known only as \"%s\".\n\r",
                  MT(ch->short_descr, "(not given)") );
    send_to_char( buf, ch );
    sprintf( buf, "[5] Extended keyset: %s\n\r",
                  MT(ch->keywords, "(not given)") );
    send_to_char( buf, ch );
    sprintf( buf, "[6] At a glance to the room, others see:\n\r%s",
                  MT(ch->long_descr, "(not given)\n\r") );
    send_to_char( buf, ch );
    sprintf( buf, "[7] You are described as:\n\r%s",
                  MT(ch->description, "(not given)\n\r") );
    send_to_char( buf, ch );
    sprintf( buf, "[8] Your email address is: %s\n\r",
                  MT(PC(ch,email), "(no email supplied)") );
    send_to_char( buf, ch );

    if ( apply_ok( ch ) )
	send_to_char( "[9] Continue to the next stage of character generation.\n\r", ch );
    else
	send_to_char( "    Your character is not ready to continue to the next stage of generation.\n\r", ch );

    send_to_char( "[Q] Abort submission and return to the login menu.\n\r", ch );

    sprintf( buf, "%s, make your selection by typing the number of the trait you wish\n\rto modify: ", ch->name );
    send_to_char( buf, ch );

    return;
}



void gen_menu( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    char arg[MAX_STRING_LENGTH];
    int choice;

    d = ch->desc;
    one_argument( argument, arg );
    choice = atoi( arg );
    if ( choice == 0 )
    {
        choice = LOWER(arg[0]) == 'q' ? -1 : -3;
    }
    DC(d) = CON_GEN_MENU + choice;

    switch ( DC(d) )
    {
        case CON_GEN_MENU-2:
        {
            do_score( ch, "" );
            sprintf( arg, "%s, make your selection by typing the number of the trait you wish\n\rto modify: ", ch->name );
            send_to_char( arg, ch );
            DC(d) = CON_GEN_MENU;
        }    
        break;
        case CON_GEN_MENU-1:
        {
            free_char( ch );
            d->character = new_char_data( );
            d->character->name = str_dup( "Guest" );
            d->character->desc = d;
            DC(d) = CON_LOGIN_MENU;
            print_login_menu( d->character );
            return;
        }
        break;
        case CON_GEN_NAME:
        {
            do_help( ch, "NANNY_NAME" );
            send_to_char( "Name: ", ch );
        }
       break;
        case CON_GEN_SHORT:
        {
            do_help( ch, "NANNY_SHORT" );
            send_to_char( "Enter your short description: ", ch );
        }
       break;
        case CON_GEN_KEYWORDS:
        {
            do_help( ch, "NANNY_KEYWORDS" );
            send_to_char( "Enter your extended keyset: ", ch );
        }
       break;
        case CON_GEN_LONG:
        {
            do_help( ch, "NANNY_LONG" );
            send_to_char( "Enter your long description:\n\r> ", ch );
        }
       break;
        case CON_GEN_DESCRIPTION:
        {
            do_help( ch, "NANNY_DESCRIPTION" );
            string_edit( ch, &ch->description );
        }
       break;
        case CON_GEN_RACES:
        {
            do_help( ch, "NANNY_RACES" );
            send_to_char( "Enter the name of your desired race: ", ch );
        }
       break;
        case CON_GEN_SEX:
        {
            do_help( ch, "NANNY_SEX" );
            send_to_char( "Which sex (male/female/neuter)? ", ch );
        }
       break;
        case CON_GEN_EMAIL:
        {
            do_help( ch, "NANNY_EMAIL" );
            send_to_char( "Enter your email address: ", ch );
        }
       break;
        case CON_GEN_SUBMIT:
        {
            if ( !apply_ok( ch ) )
            {
                do_help( ch, "APPLICATION REQUIREMENTS" );
                print_gen_menu( ch );
                return;
            }
                                  
            print_stat_menu( ch );
            DC(d) = CON_STAT_MENU;
        }
       break;
        default:
        {
            send_to_char( "Invalid option.\n\r\n\r", ch );
            print_gen_menu( ch );
            ch->desc->connected = CON_GEN_MENU;
            return;
        }
       break;
    }

    return;
}


void gen_menu_choice( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    char arg[MAX_STRING_LENGTH];
    int choice;

    d = ch->desc;
    one_argument( argument, arg );
    choice = DC(d);
    DC(d) = CON_GEN_MENU;

    switch ( choice )
    {
        case CON_GEN_NAME:
        {
            DESCRIPTOR_DATA *d;
            bool fOld;
            char buf[MAX_STRING_LENGTH];

            d = ch->desc;
            fOld = load_char_obj( d, fix_string( arg ) );
            free_char( d->character );
            ch->desc = d;
            d->character = ch;

            if ( !check_parse_name( fix_string( arg ) ) || fOld )
            {
                send_to_char( "Invalid name, try again.\n\rName: ", ch );
                DC(d) = choice;
                return;
            }
            
            buf[0] = '\0';
#if defined(MSDOS)
            sprintf( buf, "del %s%s", PLAYER_DIR, capitalize( ch->name ) );
#else
#if defined(unix)
            sprintf( buf, "rm -f %s%s &", PLAYER_DIR, capitalize( ch->name ) );
#endif
#endif
            if ( str_cmp( ch->name, "guest" ) ) system( buf );
            
            free_string( ch->name );
            ch->name = str_dup( capitalize( fix_string( arg ) ) );
            print_gen_menu( ch );
        }
       break;
        case CON_GEN_SHORT:
        {
            free_string( ch->short_descr );
            ch->short_descr = str_dup( fix_string( argument ) );
            print_gen_menu( ch );
        }
       break;
        case CON_GEN_KEYWORDS:
        {
            free_string( ch->keywords );
            ch->keywords = str_dup( fix_string( argument ) );
            print_gen_menu( ch );
        }
       break;
        case CON_GEN_LONG:
        {
            char buf[MAX_STRING_LENGTH];

            sprintf( buf, "%s\n\r", argument );
            free_string( ch->long_descr );
            ch->long_descr = str_dup( buf );
            print_gen_menu( ch );
        }
       break;
        case CON_GEN_DESCRIPTION:
        {
            if ( d->pString != NULL )
            {
                DC(d) = CON_GEN_DESCRIPTION;
                return;
            }
        }
       break;
        case CON_GEN_RACES:
        {
            int iRace, lines;

            for ( iRace = 0; iRace < MAX_RACE; iRace++ )
            {
                if ( !str_cmp( arg, race_table[iRace].race_name ) )
                 break;
            }

            if ( iRace == MAX_RACE )
            {
                send_to_char( "Invalid selection.\n\rEnter race name: ", ch );
                DC(d) = choice;
                return;
            }

            lines = ch->pagelen;
            ch->pagelen = 400;
            do_help( ch, race_table[iRace].race_name );
            ch->pagelen = lines;
            ch->size = iRace;
            send_to_char( "Do you still want to be this race? ", ch );
            DC(d) = CON_GEN_RACES_2;
        }
       break;
        case CON_GEN_SEX:
        {
            switch ( UPPER(arg[0]) )
            {
                case 'F':
                   ch->sex = SEX_FEMALE;
                   print_gen_menu( ch );
                  break;
                case 'M':
                   ch->sex = SEX_MALE;
                   print_gen_menu( ch );
                  break;
                case 'N':
                   ch->sex = SEX_NEUTRAL;
                   print_gen_menu( ch );
                  break;
                 default:
                   send_to_char( "Invalid selection.\n\rWhich sex (m/f/n)? ", ch );
                   DC(d) = CON_GEN_SEX;
                  break;
            }
        }
       break;
        case CON_GEN_EMAIL:
        {
            free_string( PC(ch,email) );
            PC(ch,email) = str_dup( fix_string( argument ) );
            print_gen_menu( ch );
        }
       break;
        case CON_GEN_RACES_2:
        {
            switch ( UPPER(arg[0]) )
            {
                case 'Y':
                   ch->race  = ch->size;
                   setup_race( ch );
                   print_gen_menu( ch );
                  break;
                case 'N':
                   do_help( ch, "NANNY_RACES" );
                   DC(d) = CON_GEN_RACES;
                  break;
            }
        }
       break;
        default:
        {
            send_to_char( "\n\rInvalid option.\n\r", ch );
            print_gen_menu( ch );
            ch->desc->connected = CON_GEN_MENU;
            return;
        }
       break;
    }

    return;
}


void print_stat_menu( CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];

    do_help( ch, "NANNY_STAT_MENU_HEADER" );
    sprintf( buf, "[S]trength:     %s\n\r", name_stat_range(get_curr_str(ch)) );
    send_to_char( buf, ch );
    sprintf( buf, "[I]ntelligence: %s\n\r", name_stat_range(get_curr_int(ch)) );
    send_to_char( buf, ch );
    sprintf( buf, "[W]isdom:       %s\n\r", name_stat_range(get_curr_wis(ch)) );
    send_to_char( buf, ch );
    sprintf( buf, "[D]exterity:    %s\n\r", name_stat_range(get_curr_dex(ch)) );
    send_to_char( buf, ch );
    sprintf( buf, "[C]onstitution: %s\n\r", name_stat_range(get_curr_con(ch)) );
    send_to_char( buf, ch );
    sprintf( buf, "[A]ge:          %d years\n\r", GET_AGE(ch) );
    send_to_char( buf, ch );
    sprintf( buf, "[H]eight:       %d halfspans\n\r", ch->size );
    send_to_char( buf, ch );
    send_to_char( "[R]eturn to the Generation Menu.\n\r", ch );
    send_to_char( "[U]se these settings.\n\r\n\r", ch );

    sprintf( buf, "You have %d points to distribute.\n\r", ch->owed );
    send_to_char( buf, ch );

    sprintf( buf, "%s, type the letter of the attribute you wish to modify: ",
             capitalize(ch->name) );
    send_to_char( buf, ch );

    return;
}



void stat_menu( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    char buf[MAX_STRING_LENGTH];

    d= ch->desc;
    if ( d==NULL )
    {
        bug( "Stat_menu: NULL descriptor.", 0 );
        return;
    }

    switch( LOWER(argument[0]) )
    {
    case 's':
        do_help( ch, "NANNY_STRENGTH" );
        write_to_buffer( d, "Do you wish to increase (+) or decrease (-) this stat? ", 0 );
        DC(d) = CON_STAT_STR;
      break;
    case 'i':
        do_help( ch, "NANNY_INTELLIGENCE" );
        write_to_buffer( d, "Do you wish to increase (+) or decrease (-) this stat? ", 0 );
        DC(d) = CON_STAT_INT;
      break;
    case 'w':
        do_help( ch, "NANNY_WISDOM" );
        write_to_buffer( d, "Do you wish to increase (+) or decrease (-) this stat? ", 0 );
        DC(d) = CON_STAT_WIS;
      break;
    case 'd':
        do_help( ch, "NANNY_DEXTERITY" );
        write_to_buffer( d, "Do you wish to increase (+) or decrease (-) this stat? ", 0 );
        DC(d) = CON_STAT_DEX;
      break;
    case 'c':
        do_help( ch, "NANNY_CONSTITUTION" );
        write_to_buffer( d, "Do you wish to increase (+) or decrease (-) this stat? ", 0 );
        DC(d) = CON_STAT_CON;
      break;
    case 'a':
        do_help( ch, "NANNY_AGE" );
        sprintf( buf, "A normal %s lives to be %d years old.\n\r",
                 race_table[ch->race].race_name, race_table[ch->race].base_age );
        send_to_char( buf, ch );
        sprintf( buf, "Your character is currently %d years old.\n\r",
                 GET_AGE(ch) );
        send_to_char( buf, ch );

        write_to_buffer( d, "What age would you like your character to be? ", 0 );
        DC(d) = CON_STAT_AGE;
      break;
    case 'h':
        do_help( ch, "NANNY_HEIGHT" );
        sprintf( buf, "Members of your race are from %d to %d halfspans tall.\n\r",
                 race_table[ch->race].size-4,
                 race_table[ch->race].size+4 );
        send_to_char( buf, ch );

        sprintf( buf, "You are currently %d halfspans in size.\n\r",
                 ch->size );
        send_to_char( buf, ch );

        write_to_buffer( d, "How many halfspans in height should your character be? ", 0 );
        DC(d) = CON_STAT_SIZE;
      break;
    case 'r':
        {
            print_gen_menu( ch );
            DC(d) = CON_GEN_MENU;
            return;
        }
    case 'u':
        if ( ch->owed != 0 )
        {
            send_to_char( "You still have stat points to distribute.\n\r", ch );
            print_stat_menu( ch );
            break;
        }

        free_string( PC(ch, denial) );
        PC(ch, denial) = NULL;

        do_help( ch, "APPLICATION_NOTE_RHETORIC" );
        note_attach( ch );
        ch->pnote->subject = str_dup( "---New Player Application---" );
        ch->pnote->to_list = str_dup( "all" );
        string_edit( ch, &ch->pnote->text );
        DC(d) = CON_WRITE_APPLICATION;
       break;
      default: print_stat_menu( ch ); break;
    }

    return;
}


void stat_menu_choice( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;

    d = ch->desc;

    if ( d == NULL )
    {
        bug( "Stat_menu_choice:  NULL descriptor.", 0 );
        return;
    }


    switch( DC(d) )
    {   
   case CON_STAT_STR:
   case CON_STAT_INT:
   case CON_STAT_WIS:
   case CON_STAT_DEX:
   case CON_STAT_CON:
      {
          switch ( argument[0] )
          {
             case '+':
                {
                    if ( ch->owed == 0 )
                    {
                        send_to_char( "You don't have a stat point to distribute.\n\r", ch );
                        write_to_buffer( d, "Do you wish to increase (+) or decrease (-) this stat? ", 0 );
                        return;
                    }

                    if ( (DC(d) == CON_STAT_STR && ch->perm_str >= 18)
                      || (DC(d) == CON_STAT_INT && ch->perm_int >= 18)
                      || (DC(d) == CON_STAT_WIS && ch->perm_wis >= 18)
                      || (DC(d) == CON_STAT_DEX && ch->perm_dex >= 18)
                      || (DC(d) == CON_STAT_CON && ch->perm_con >= 18) )
                    {
                        send_to_char( "You can't add any more to that stat.\n\r", ch );
                        DC(d) = CON_STAT_MENU;
                        return;
                    }

                    ch->owed--;
                    if ( DC(d) == CON_STAT_STR ) ch->perm_str++;
                    if ( DC(d) == CON_STAT_INT ) ch->perm_int++;
                    if ( DC(d) == CON_STAT_WIS ) ch->perm_wis++;
                    if ( DC(d) == CON_STAT_DEX ) ch->perm_dex++;
                    if ( DC(d) == CON_STAT_CON ) ch->perm_con++;
                    print_stat_menu( ch );
                    DC(d) = CON_STAT_MENU;
                }
               break;
             case '-':
                {
                    if ( (DC(d) == CON_STAT_STR && ch->perm_str <= 3)
                      || (DC(d) == CON_STAT_INT && ch->perm_int <= 3)
                      || (DC(d) == CON_STAT_WIS && ch->perm_wis <= 3)
                      || (DC(d) == CON_STAT_DEX && ch->perm_dex <= 3)
                      || (DC(d) == CON_STAT_CON && ch->perm_con <= 3) )
                    {
                        send_to_char( "You can't subtract any more from that stat.\n\r", ch );
                        DC(d) = CON_STAT_MENU;
                        return;
                    }

                    ch->owed++;
                    if ( DC(d) == CON_STAT_STR ) ch->perm_str--;
                    if ( DC(d) == CON_STAT_INT ) ch->perm_int--;
                    if ( DC(d) == CON_STAT_WIS ) ch->perm_wis--;
                    if ( DC(d) == CON_STAT_DEX ) ch->perm_dex--;
                    if ( DC(d) == CON_STAT_CON ) ch->perm_con--;
                    print_stat_menu( ch );
                    DC(d) = CON_STAT_MENU;
                }
               break;
              default:  print_stat_menu( ch ); DC(d) = CON_STAT_MENU;  break;
          }
      }
     break;
   case CON_STAT_AGE:
      {
          int value = atoi(argument);

          PC(ch,birth_year) = time_info.year - URANGE(15,value,race_table[ch->race].base_age-10);
          if ( PC(ch,birth_year) != time_info.year - value )
              send_to_char( "Invalid age.\n\r", ch );

          print_stat_menu( ch );
          DC(d) = CON_STAT_MENU;
      }
     break;
   case CON_STAT_SIZE:
      {
          int value = atoi(argument);

          ch->size = URANGE(race_table[ch->race].size-4,value,race_table[ch->race].size+4);
          if ( ch->size !=  value )
              send_to_char( "Invalid height.\n\r", ch );

          print_stat_menu( ch );
          DC(d) = CON_STAT_MENU;
      }
     break;
        default: print_stat_menu( ch ); DC(d)=CON_STAT_MENU; break;
    }

    return;
}



void char_gen( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    char arg[MAX_STRING_LENGTH];
    char *pwdnew;
    char *p;

    if ( ch == NULL )
	{
		bug( "Char_gen: NULL character at function call.", 0 );
		return;
	}

    d = ch->desc;
    one_argument( argument, arg );

    switch( DC(d) )
    {
    case CON_CONFIRM_NEW_NAME:
        switch ( *argument )
        {
        case 'y': case 'Y':
            write_to_buffer( d, "Enter a password for your character: ", 0 );
            DC(d) = CON_GET_NEW_PASSWORD;
            break;

        case 'n': case 'N':
            print_login_menu( d->character );
            free_char( d->character );
            d->character = NULL;
            DC(d) = CON_LOGIN_MENU;
            break;

        default:
            write_to_buffer( d, "Please type Yes or No.\n\rConfirm? ", 0 );
            break;
        }
       break;

    case CON_GET_NEW_PASSWORD:
#if defined(unix)
        write_to_buffer( d, "\n\r", 2 );
#endif

        if ( strlen(argument) < 5 )
        {
            write_to_buffer( d,
            "Password must be at least five characters long.\n\rPassword: ", 0 );
            return;
        }

        pwdnew = crypt( argument, ch->name );
        for ( p = pwdnew; *p != '\0'; p++ )
        {
            if ( *p == '~' )
            {
            write_to_buffer( d,
                   "New password not acceptable, please try again.\n\rPassword: ", 0 );
            return;
            }
        }

        free_string( PC(ch,pwd) );
        PC(ch,pwd) = str_dup( pwdnew );
        write_to_buffer( d, "Please retype password for verification: ", 0 );
        DC(d) = CON_CONFIRM_NEW_PASSWORD;
       break;

    case CON_CONFIRM_NEW_PASSWORD:
#if defined(unix)
        write_to_buffer( d, "\n\r", 2 );
#endif

        if ( strcmp( crypt( argument, PC(ch,pwd) ), PC(ch,pwd) ) )
        {
            write_to_buffer( d, "Passwords don't match.\n\rRetype password: ",
            0 );
            DC(d) = CON_GET_NEW_PASSWORD;
            return;
        }

        do_help( ch, "NANNY_INTRO" );
		write_to_buffer( d, "Press return to continue: ", 0 );
        DC(d) = CON_SHOW_INTRO;
	   break;

	case CON_SHOW_INTRO:
        do_help( ch, "NANNY_NAME" );
        write_to_buffer( d, "Type a name for your character: ", 0 );
        DC(d) = CON_CHAR_GEN_NAME;
       break;

    case CON_CHAR_GEN_NAME:
        {
            bool fOld;
            char buf[MAX_STRING_LENGTH];

            d = ch->desc;
            fOld = load_char_obj( d, fix_string( arg ) );
            free_char( d->character );
            ch->desc = d;
            d->character = ch;

            if ( !check_parse_name( fix_string( arg ) ) || fOld )
            {
                send_to_char( "Invalid name, try again.\n\rName: ", ch );
                DC(d) = CON_CHAR_GEN_NAME;
                return;
            }
            
            buf[0] = '\0';
#if defined(MSDOS)
            sprintf( buf, "del %s%s", PLAYER_DIR, capitalize( ch->name ) );
#else
#if defined(unix)
            sprintf( buf, "rm -f %s%s &", PLAYER_DIR, capitalize( ch->name ) );
#endif
#endif
            if ( str_cmp( ch->name, "guest" ) ) system( buf );

            free_string( ch->name );
            ch->name = str_dup( capitalize( fix_string( arg ) ) );
        }

        do_help( ch, "NANNY_EMAIL" );
        write_to_buffer( d, "Enter your email address: ", 0 );
        DC(d) = CON_CHAR_GEN_EMAIL;
       break;

    case CON_CHAR_GEN_EMAIL:
        free_string( PC(ch,email) );
        PC(ch,email) = str_dup( fix_string( argument ) );

        do_help( ch, "NANNY_RACES" );
        send_to_char( "Enter the name of your desired race: ", ch );
        DC(d) = CON_CHAR_GEN_RACE;
       break;

    case CON_CHAR_GEN_RACE:
        {
            int iRace, lines;

            for ( iRace = 0; iRace < MAX_RACE; iRace++ )
            {
                if ( !str_cmp( arg, race_table[iRace].race_name ) )
                 break;
            }

            if ( iRace == MAX_RACE )
            {
                send_to_char( "Invalid selection.\n\rEnter race name: ", ch );
                return;
            }

            lines = ch->pagelen;
            ch->pagelen = 400;
            do_help( ch, race_table[iRace].race_name );
            ch->pagelen = lines;
            ch->size = iRace;
            send_to_char( "Do you still want to be this race? ", ch );
            DC(d) = CON_CHAR_GEN_RACE2;
        }
       break;

    case CON_CHAR_GEN_RACE2:
        {
            switch ( UPPER(arg[0]) )
            {
              case 'Y':
                   ch->race  = ch->size;
                   setup_race( ch );

                   do_help( ch, "NANNY_SEX" );
                   write_to_buffer( d, "Which sex (m/f/n)? ", 0 );
                   DC(d) = CON_CHAR_GEN_SEX;
                  break;
              case 'N':
                   do_help( ch, "NANNY_RACES" );
                   send_to_char( "Enter the name of your desired race: ", ch );
                   DC(d) = CON_CHAR_GEN_RACE;
                  break;
               default: write_to_buffer( d, "Type Yes or No.\n\r", 0 ); break;
            }
        }
       break;

   case CON_CHAR_GEN_SEX:
        {
            switch ( UPPER(arg[0]) )
            {
                case 'F':
                   ch->sex = SEX_FEMALE;
                   do_help( ch, "NANNY_SHORT" );
                   write_to_buffer( d, "Enter your short description: ", 0 );
                   DC(d) = CON_CHAR_GEN_SHORT;
                  break;
                case 'M':
                   ch->sex = SEX_MALE;
                   do_help( ch , "NANNY_SHORT" );
                   write_to_buffer( d, "Enter your short description: ", 0 );
                   DC(d) = CON_CHAR_GEN_SHORT;
                  break;
                case 'N':
                   ch->sex = SEX_NEUTRAL;
                   do_help( ch, "NANNY_SHORT" );
                   write_to_buffer( d, "Enter your short description: ", 0 );
                   DC(d) = CON_CHAR_GEN_SHORT;
                  break;
                 default:
                   send_to_char( "Invalid selection.\n\rWhich sex (m/f/n)? ", ch );
                  break;
            }
        }
       break;

   case CON_CHAR_GEN_SHORT:
        {
            free_string( ch->short_descr );
            ch->short_descr = str_dup( fix_string( argument ) );

            do_help( ch, "NANNY_LONG" );
			write_to_buffer( d, "Enter your long description:\n\r> ", 0 );
			DC(d) = CON_CHAR_GEN_LONG;
        }
       break;

   case CON_CHAR_GEN_LONG:
        {
            char buf[MAX_STRING_LENGTH];

            sprintf( buf, "%s\n\r", argument );
            free_string( ch->long_descr );
            ch->long_descr = str_dup( buf );

			do_help( ch, "NANNY_KEYWORDS" );
			write_to_buffer( d, "Enter your extended keywords: ", 0 );
			DC(d) = CON_CHAR_GEN_KEYWORDS;
        }
	   break;

   case CON_CHAR_GEN_KEYWORDS:
        {
            free_string( ch->keywords );
            ch->keywords = str_dup( fix_string( argument ) );

			do_help( ch, "NANNY_DESCRIPTION" );
            string_edit( ch, &ch->description );
			DC(d) = CON_GEN_DESCRIPTION;
        }
       break;

   case CON_GEN_RACES:
   case CON_GEN_SEX:
   case CON_GEN_NAME:
   case CON_GEN_SHORT:
   case CON_GEN_KEYWORDS:
   case CON_GEN_LONG:
   case CON_GEN_DESCRIPTION:
   case CON_GEN_EMAIL:
   case CON_GEN_SUBMIT:
   case CON_GEN_RACES_2:
	 gen_menu_choice( ch, argument );
	   break;

   case CON_GEN_MENU:
     gen_menu( ch, argument );
	   break;

   case CON_STAT_STR:
   case CON_STAT_INT:
   case CON_STAT_WIS:
   case CON_STAT_DEX:
   case CON_STAT_CON:
   case CON_STAT_AGE:
   case CON_STAT_SIZE:
     stat_menu_choice( ch, argument );
       break;

   case CON_STAT_MENU:
     stat_menu( ch, argument );
       break;

	}

	return;
}




/*
 * Guest character support.
 *
 * Create a brand new character, with the name "guest"
 * note: guest characters are ignored in fwrite_char() in save.c
 */
CHAR_DATA *generate_guest( void )
{
    CHAR_DATA *nch;
    char buf[MAX_STRING_LENGTH];

    if (guestnumber < 0) guestnumber = 0;
    guestnumber++;

    nch = new_char_data( );
    nch->name        = str_dup( "Guest"          );

    sprintf( buf, "Guest #%d", guestnumber );
    nch->short_descr = str_dup( buf );

    nch->long_descr  = str_dup( "(OOC) A guest character is observing.\n\r" );
    nch->description = str_dup( "OUT OF CHARACTER GUEST\n\r" );

    sprintf( buf, "guest %d", guestnumber );
    nch->keywords    = str_dup( buf              );

    /*
     * Setup_race creates the pcdata for us.
     */
    setup_race( nch );
    nch->pcdata->level = LEVEL_MORTAL;

    do_prompt(nch, "Guest> " );
    nch->act = ACT_NOSCAN | ACT_WIMPY;
    nch->in_room = get_room_index( ROOM_VNUM_GUEST );

    sprintf( buf, "GUEST CHARACTER CREATED: #%d", guestnumber );
    log_string( buf );

    return nch;
}




/*
 * Deal with sockets that haven't logged in yet.
 */
void nanny( DESCRIPTOR_DATA *d, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    CHAR_DATA *ch;
    bool fOld;
    extern bool wizlock;

    while ( *argument == ' ' )
	argument++;

    /*
     * This may not be neccessary.
     */
    if ( d->character != NULL )
        nanny_check( d );

    /*
     * Make sure descriptors are paired with characters.
     */
    if ( d->character == NULL )
    {
    ch = new_char_data( );

    d->character			= ch;
    ch->desc				= d;
    ch->name                = str_dup( "Guest" );
    ch->act                 = PLR_BLANK | PLR_COMBINE | PLR_PROMPT;
    }

    ch = d->character;


    switch ( DC(d) )
    {

    default:
    bug( "Nanny: bad DC(d) %d.", DC(d) );
	close_socket( d );
	return;

    case CON_SHOW_TITLE:
     print_login_menu( ch );
     DC(d) = CON_LOGIN_MENU;
    break;

    case CON_LOGIN_MENU:
     login_menu( ch, argument );
    break;

    case CON_DOC_MENU:
     doc_menu( ch, argument );
    break;


    case CON_GET_NAME:
	if ( argument[0] == '\0' )
	{
        DC(d) = CON_LOGIN_MENU;
	    return;
	}

	argument[0] = UPPER(argument[0]);
	if ( !check_parse_name( argument ) )
	{
        write_to_buffer( d, "Illegal name, try another.\n\rName: ", 0 );
	    return;
    }

    /*
     * Guest character support.
     */
    if ( !str_cmp(argument,"guest") || !str_cmp(argument,"onlooker") )
    {
        d->character        = generate_guest( );
        d->character->desc  = d;

        do_help(d->character, "GUEST");
        write_to_buffer( d, "HIT RETURN TO OBSERVE: ", 0 );
        DC(d) = CON_READ_MOTD;
        return;
    }


/*
        sprintf( log_buf, "%s is being loaded from disk.", argument );
        NOTIFY( log_buf, LEVEL_SUPREME, WIZ_NOTIFY );
        log_string( log_buf );
 */

    free_char( d->character );
    d->character = NULL;

    if ( check_reconnect( d, argument, TRUE ) )
    {
        fOld = TRUE;
    }
    else
    {
        free_char( d->character );
        fOld = load_char_obj( d, argument );
        ch   = d->character;

        if ( IS_SET(ch->act, PLR_DENY) )
        {
            sprintf( log_buf, "Denying access to %s@%s.", argument, d->host );
            log_string( log_buf );

            sprintf( buf2, "Notify>  Denied %s from %s", argument, d->host );
            NOTIFY( buf2, LEVEL_IMMORTAL, WIZ_NOTIFY_LOGIN );

            write_to_buffer( d, "You are denied access.\n\r", 0 );
            close_socket( d );
            return;
        }

        if ( wizlock && (!IS_HERO(ch) || !IS_SET(ch->act, PLR_WIZBIT)) )
	    {
        write_to_buffer( d, "The game is currently closed to mortals.\n\r", 0 );
        DC(d) = CON_LOGIN_MENU;
		close_socket( d );
		return;
	    }
    }

	if ( fOld )
	{
	    /* Old player */
	    write_to_buffer( d, "Password: ", 0 );
	    write_to_buffer( d, echo_off_str, 0 );
        DC(d) = CON_GET_OLD_PASSWORD;
	    return;
	}
	else
	{
	    /* New player */
        sprintf( buf, "That character does not exist." );
	    write_to_buffer( d, buf, 0 );
        DC(d) = CON_LOGIN_MENU;
        print_login_menu( ch );
	    return;
	}
	break;

    case CON_GET_OLD_PASSWORD:
#if defined(unix)
	write_to_buffer( d, "\n\r", 2 );
#endif

    if ( strcmp( crypt( argument, PC(ch,pwd) ), PC(ch,pwd) ) )
	{
        write_to_buffer( d, "Wrong password.\n\rClosing connection.\n\r", 0 );
	    close_socket( d );
	    return;
	}

	write_to_buffer( d, echo_on_str, 0 );

	if ( check_reconnect( d, ch->name, TRUE ) )
	    return;

 
    if ( check_playing( d, ch->name ) )
    {
        check_reconnect( d, ch->name, TRUE );
        return;
    }

    if ( PC(ch,level) > LEVEL_APPLIED )
    {
        sprintf( log_buf, "%s@%s has connected.", ch->name, d->host );
        log_string( log_buf );
        if ( IS_HERO(ch) )  do_help( ch, "imotd" );
        do_help( ch, "motd" );
        DC(d) = CON_READ_MOTD;       /* Bypass informality */
    }
    else
    {
        if ( PC(ch,denial) == NULL || PC(ch,denial)[0] == '\0' )
        {
            send_to_char( "\n\rYour character has not yet been approved.\n\r", ch );
            do_help ( ch, "NANNY_AWAITING_APPLY" );
            DC(d) = CON_READ_MOTD;
        }
        else
        {
        sprintf( buf, "\n\rReason for rejection:\n\r\n\r%s\n\r\n\r", PC(ch,denial) );
        send_to_char( buf, ch );
        do_help( ch, "NANNY_RESUBMIT" );
        DC(d) = CON_GEN_MENU;
        }
    }
	break;


    case CON_GET_NAME_NOLOGIN:
	if ( argument[0] == '\0' )
	{
        DC(d) = CON_LOGIN_MENU;
	    return;
	}

	argument[0] = UPPER(argument[0]);
	if ( !check_parse_name( argument ) )
	{
        write_to_buffer( d, "Illegal name, try another.\n\rName: ", 0 );
	    return;
    }

    /*
     * Guest character support.
     */
    if ( !str_cmp(argument,"guest") || !str_cmp(argument,"onlooker") )
    {
        d->character        = generate_guest( );
        d->character->desc  = d;

        do_help(d->character, "GUEST");
        write_to_buffer( d, "HIT RETURN TO OBSERVE: ", 0 );
        DC(d) = CON_READ_MOTD;
        return;
    }

/*
        sprintf( log_buf, "%s is being loaded from disk.", argument );
        NOTIFY( log_buf, LEVEL_SUPREME, WIZ_NOTIFY );
        log_string( log_buf );
 */

    free_char( d->character );
	fOld = load_char_obj( d, argument );
	ch   = d->character;

	if ( IS_SET(ch->act, PLR_DENY) )
	{
	    sprintf( log_buf, "Denying access to %s@%s.", argument, d->host );
	    log_string( log_buf );

        sprintf( buf2, "Notify>  Denied %s from %s", argument, d->host );
        NOTIFY( buf2, LEVEL_IMMORTAL, WIZ_NOTIFY_LOGIN );

	    write_to_buffer( d, "You are denied access.\n\r", 0 );
	    close_socket( d );
	    return;
	}

	if ( check_reconnect( d, argument, FALSE ) )
	{
	    fOld = TRUE;
	}
	else
	{
        if ( wizlock && (!IS_HERO(ch) || !IS_SET(ch->act, PLR_WIZBIT)) )
	    {
        write_to_buffer( d, "The game is currently wizlocked.\n\r", 0 );
		close_socket( d );
		return;
	    }
	}

	if ( fOld )
	{
	    /* Old player */
	    write_to_buffer( d, "Password: ", 0 );
	    write_to_buffer( d, echo_off_str, 0 );
        DC(d) = CON_GET_OLD_PASSWORD_NOLOGIN;
	    return;
	}
	else
	{
	    /* New player */
        free_string( ch->name );
        ch->name = str_dup( argument );
        sprintf( buf, "That character does not exist.  Create as new? " );
	    write_to_buffer( d, buf, 0 );
        DC(d) = CON_CONFIRM_NEW_NAME;
	    return;
	}
	break;

    case CON_GET_OLD_PASSWORD_NOLOGIN:
#if defined(unix)
	write_to_buffer( d, "\n\r", 2 );
#endif

    if ( strcmp( crypt( argument, PC(ch,pwd) ), PC(ch,pwd) ) )
	{
        write_to_buffer( d, "Wrong password.\n\rClosing connection.\n\r", 0 );
	    close_socket( d );
	    return;
	}

	write_to_buffer( d, echo_on_str, 0 );

	if ( check_reconnect( d, ch->name, TRUE ) )
	    return;

 
    if ( check_playing( d, ch->name ) )
    {
        check_reconnect( d, ch->name, TRUE );
        return;
    }

    if ( PC(ch,level) > LEVEL_APPLIED )
    {
        print_login_menu( ch );
        DC(d) = CON_LOGIN_MENU;       /* Bypass informality */
    }
    else
    {
        if ( PC(ch,denial) == NULL || PC(ch,denial)[0] == '\0' )
        {
            send_to_char( "\n\rYour character has not yet been approved.\n\r", ch );
            do_help ( ch, "NANNY_AWAITING_APPLY" );
            DC(d) = CON_READ_MOTD;
        }
        else
        {
        sprintf( buf, "\n\rReason for rejection:\n\r\n\r%s\n\r\n\r", PC(ch,denial) );
        send_to_char( buf, ch );
        do_help( ch, "NANNY_RESUBMIT" );
        DC(d) = CON_GEN_MENU;
        }
    }
	break;

    case CON_CONFIRM_RESUBMIT:
	switch ( *argument )
	{
	case 'y': case 'Y':
        if ( IS_HERO(ch) )
        {
            send_to_char( "You are a hero, please contact an immortal before resubmitting.\n\r", ch );
            DC(d) = CON_LOGIN_MENU;
            return;
        }
        {
        CHAR_DATA *nch;

        nch = new_char_data( );
        nch->name        = str_dup( ch->name         );
        nch->short_descr = str_dup( ch->short_descr  );
        nch->long_descr  = str_dup( ch->long_descr   );
        nch->description = str_dup( ch->description  );
        nch->keywords    = str_dup( ch->keywords     );
        PC(nch,email)    = str_dup( PC(ch,email)     );
        PC(nch,pwd)      = str_dup( PC(ch,pwd)       );
        d->character     = nch;
        nch->desc        = d;

        ch->desc = NULL;
        free_char( ch );
        ch = nch;
        }

        print_gen_menu( ch );
        DC(d) = CON_GEN_MENU;
	    break;

	case 'n': case 'N':
        print_login_menu( d->character );
        free_char( d->character );
        d->character = NULL;
        DC(d) = CON_LOGIN_MENU;
	    break;

	default:
        write_to_buffer( d, "Please type Yes or No.\n\rConfirm? ", 0 );
	    break;
	}
	break;

    case CON_CONFIRM_NEW_NAME:
    case CON_GET_NEW_PASSWORD:
    case CON_CONFIRM_NEW_PASSWORD:
	case CON_SHOW_INTRO:
    case CON_CHAR_GEN_NAME:
    case CON_CHAR_GEN_EMAIL:
    case CON_CHAR_GEN_RACE:
    case CON_CHAR_GEN_RACE2:
	case CON_CHAR_GEN_SEX:
	case CON_CHAR_GEN_SHORT:
	case CON_CHAR_GEN_LONG:
	case CON_CHAR_GEN_KEYWORDS:
	case CON_GEN_MENU:
	case CON_GEN_RACES:
	case CON_GEN_SEX:
	case CON_GEN_NAME:
	case CON_GEN_SHORT:
	case CON_GEN_KEYWORDS:
	case CON_GEN_LONG:
	case CON_GEN_DESCRIPTION:
	case CON_GEN_EMAIL:
	case CON_GEN_SUBMIT:
	case CON_GEN_RACES_2:
	case CON_STAT_MENU:
	case CON_STAT_STR:
	case CON_STAT_INT:
	case CON_STAT_WIS:
	case CON_STAT_DEX:
	case CON_STAT_CON:
    case CON_STAT_AGE:
    case CON_STAT_SIZE:
      char_gen( d->character, argument ); break;


    case CON_SEND_APPLICATION:

    ch->in_room = get_room_index( ROOM_VNUM_APPLICATIONS );
    do_note( ch, "post" );
    free_string( PC(ch,denial) );
    PC(ch,denial) = NULL;

    new_char( ch );    
    save_char_obj( ch );

    sprintf( buf2, "Notify> New player %s@%s.", ch->name, d->host );
    NOTIFY( buf2, LEVEL_IMMORTAL, WIZ_NOTIFY_LOGIN );
    sprintf( log_buf, "%s@%s new player.", ch->name, d->host );
    log_string( log_buf );

    write_to_buffer( d, "\n\r", 2 );

    do_help( ch, "NANNY_APPLY" );
    DC(d) = CON_READ_MOTD;
	break;

    case CON_READ_MOTD:
    sprintf( buf2, "\n\r\n\rWelcome to %s.\n\r\n\r",  VERSION_STR );
    save_char_obj( ch );

    if ( PC(ch,level) > LEVEL_APPLIED )
    {
        write_to_buffer( d, buf2, 0 );
        sprintf( buf2, "Notify> %s@%s has entered the game.", ch->name, d->host );
        NOTIFY( buf2, LEVEL_IMMORTAL, WIZ_NOTIFY_LOGIN );
    }

    
    if ( PC(ch,level) == LEVEL_NEW )             /* damn newbies */
    {
       PC(ch,level) = LEVEL_APPLIED;
       print_login_menu( ch );
       DC(d) = CON_LOGIN_MENU;
       break;
    }

    if ( PC(ch,level) == LEVEL_APPLIED )
    {
       print_login_menu( ch );
       DC(d) = CON_LOGIN_MENU;
       break;
    }

    /*
     * Add to connected character list.
     */
    ch->next      = char_list;
    char_list     = ch;
    DC(d)  = CON_PLAYING;

    /*
     * Move mounts from waiting list to full game.
     */
    {
        CHAR_DATA *wch;

        for ( wch = mount_list;  wch != NULL;  wch = wch->next )
        {
            CHAR_DATA *prev;

            if ( wch->master != ch )
            continue;


            if ( wch == mount_list )
            {
                mount_list = mount_list->next;
                wch->next = char_list;
                char_list = wch;
                char_to_room( wch, wch->in_room );
                continue;
            }

            for ( prev = mount_list; prev != NULL; prev = prev->next )
            {
                if ( prev->next == wch )
                {
                    prev->next = wch->next;
                    break;
                }
            }

            if ( prev == NULL ) bug( "Nanny: prev mount not found.", 0 );

            wch->next = char_list;
            char_list = wch;
            char_to_room( wch, wch->in_room );
        }
    }

    /*
     * Figure out room, if invalid, choose new room.
     */
    if ( ch->in_room == NULL )
    {
         if ( IS_IMMORTAL(ch) )
         ch->in_room = get_room_index( ROOM_VNUM_LIMBO );
    else ch->in_room = get_room_index( ROOM_VNUM_DEATH );
    }
     
    if ( ch->in_room == NULL )
         ch->in_room = get_room_index( ROOM_VNUM_TEMPLATE );

    sprintf( log_buf, "%s@%s has connected.", ch->name, d->host );
    log_string( log_buf );
        
    char_to_room( ch, ch->in_room );
    save_char_obj( ch );
    act( "$n has entered the game.", ch, NULL, NULL, TO_NOTVICT );
    do_look( ch, "auto" );

	break;
    }

    return;
}




void nanny_check( DESCRIPTOR_DATA *d )
{
    CHAR_DATA *ch = d->character;

    if ( ch == NULL ) return;


    if ( DC(d) == CON_DOC_MENU && d->showstr_point == NULL )
    send_to_char( "> ", d->character );
    else
    if ( DC(d) == CON_WRITE_APPLICATION && d->pString == NULL )
    {
        send_to_char( "Hit return to submit your application,\n\ror drop connection to abort: ", d->character );
        DC(d) = CON_SEND_APPLICATION;
    }
    else
    if ( DC(d) == CON_GEN_DESCRIPTION && d->pString == NULL )
    {
        print_gen_menu( d->character );
        DC(d) = CON_GEN_MENU;
    }

    return;
}



bool  apply_ok( CHAR_DATA *ch )
{
    if ( !str_cmp( ch->name, "guest" ) )
	{
/*        send_to_char( "You need to choose your name.\n\r", ch );*/
		return FALSE;
	}

    if ( SMT(ch->short_descr) )
	{
/*        send_to_char( "You need to set your short description.\n\r", ch );*/
		return FALSE;
	}

    if ( SMT(ch->long_descr) )
	{
/*        send_to_char( "You need to set your long description.\n\r", ch );*/
		return FALSE;
	}

    if ( SMT(ch->description) )
	{
/*        send_to_char( "You need to set your description.\n\r", ch );*/
		return FALSE;
	}

    if ( SMT(PC(ch,email)) )
	{
/*        send_to_char( "You need to set your email.\n\r", ch );*/
		return FALSE;
	}

    if ( SMT(ch->keywords) )
	{
/*        send_to_char( "You need to set your extended keywords.\n\r", ch );*/
		return FALSE;
	}

    return TRUE;
}



/*
 * Parse a name for acceptability.
 */
bool check_parse_name( char *name )
{
    /*
     * Reserved words or anti-lamer tactics.
     */
  if ( is_name( name, "all auto immortal self newbie god hero"
                      " someone you me the avatar here" ) )
  return FALSE;


    /*
     * Here comes the list of obsenities.  Not exactly the eloquent speech
     * I'm used to, but since the world isn't an eloquent place, neither is
     * this conditional.
     * Purpose?  To get rid of lamers who like to swear in their names,
     * usually at the expense of the hard working programmers and admins
     * who provide the service for them.   "Ass" is allowed as a substring
     * due to its popularity in words ("Bass, Mass, Assassin etc..") and its
     * rather low-degree of obsene-ness.
     */

    if ( !str_infix( name, "fuck" )      ||   !str_infix( name, "shit" )
    ||   !str_infix( name, "cunt" )      ||   !str_infix( name, "penis" )
    ||   !str_infix( name, "asshole" )   ||   !str_infix( name, "vagina" )
    ||   !str_cmp  ( name, "ass" )     )
        return FALSE;

    /*
     * Length restrictions.
     */
    if ( strlen(name) <  3 )
	return FALSE;

#if defined(MSDOS)
    if ( strlen(name) >  8 )
	return FALSE;
#endif

#if defined(macintosh) || defined(unix)
#ifdef NAME_LENGTH
    if ( strlen(name) > NAME_LENGTH )
#else
    if ( strlen(name) > 12 )
#endif
    return FALSE;
#endif

    /*
     * Alphanumerics only.
     * Lock out IllIll twits.
     */
    {
	char *pc;
	bool fIll;

	fIll = TRUE;
	for ( pc = name; *pc != '\0'; pc++ )
	{
	    if ( !isalpha(*pc) )
		return FALSE;
	    if ( LOWER(*pc) != 'i' && LOWER(*pc) != 'l' )
		fIll = FALSE;
	}

	if ( fIll )
	    return FALSE;
    }

    /*
     * Prevent players from naming themselves after mobs.
     */
#ifdef NOMOBJR
    {
	extern MOB_INDEX_DATA *mob_index_hash[MAX_KEY_HASH];
	MOB_INDEX_DATA *pMobIndex;
	int iHash;

	for ( iHash = 0; iHash < MAX_KEY_HASH; iHash++ )
	{
	    for ( pMobIndex  = mob_index_hash[iHash];
		  pMobIndex != NULL;
		  pMobIndex  = pMobIndex->next )
	    {
        if ( is_name( name, pMobIndex->name ) )
		    return FALSE;
	    }
	}
    }
#endif

    return TRUE;
}




/*
 * Look for link-dead player to reconnect.
 */
bool check_reconnect( DESCRIPTOR_DATA *d, char *name, bool fConn )
{
    CHAR_DATA *ch;
    char buf[MAX_STRING_LENGTH];

    for ( ch = char_list; ch != NULL; ch = ch->next )
    {
	if ( !IS_NPC(ch)
	&& ( !fConn || ch->desc == NULL )
	&&   !str_cmp( d->character->name, ch->name ) )
	{
        if ( fConn == FALSE )                            /* WTF? */
	    {
        free_string( PC(d->character,pwd) );
        PC(d->character,pwd) = str_dup( PC(ch,pwd) );
	    }
	    else
	    {
		free_char( d->character );
		d->character = ch;
		ch->desc	 = d;
		ch->timer	 = 0;
		send_to_char( "Reconnecting.\n\r", ch );
		act( "$n has reconnected.", ch, NULL, NULL, TO_ROOM );
		sprintf( log_buf, "%s@%s reconnected.", ch->name, d->host );
		log_string( log_buf );
        DC(d) = CON_PLAYING;
	
        sprintf( buf, "Notify>  %s", log_buf );
        NOTIFY( buf, LEVEL_IMMORTAL, WIZ_NOTIFY_LOGIN );

	    }
	    return TRUE;
	}
    }

    return FALSE;
}



/*
 * Check if already playing.
 */
bool check_playing( DESCRIPTOR_DATA *d, char *name )
{
    DESCRIPTOR_DATA *dold;

    for ( dold = descriptor_list; dold; dold = dold->next )
    {
        if ( dold != d
          && dold->character != NULL
          && dold->connected != CON_GET_NAME
          && dold->connected != CON_GET_OLD_PASSWORD
          && !str_cmp( name, dold->original
                           ? dold->original->name : dold->character->name ) )
        {
             write_to_buffer( dold, "Replacing with new player...Bye!\n\r", 0);
             close_socket( dold );
             return TRUE;
        }
    }

    return FALSE;
}

