


#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "comm.h"
#include "oc.h"
#include "mem.h"
#include "script.h"



#define SKILLSN(sn) (sn != -1 ? skill_table[sn].slot : 0)
#define IS_BUILDER(ch, Area)  ( GET_PC(ch,security,9) <= Area->security     \
                             || strstr( Area->builders, ch->name ) != NULL  \
                             || strstr( Area->builders, "All" ) != NULL    )




AREA_DATA *get_area_data( int vnum )
{
    AREA_DATA *pArea;

    for (pArea = area_first; pArea != NULL; pArea = pArea->next )
    {
        if (pArea->vnum == vnum)
            return pArea;
    }

    return NULL;
}



AREA_DATA *get_vnum_area( int vnum )
{
    AREA_DATA *pArea;

    for ( pArea = area_first; pArea != NULL; pArea = pArea->next )
    {
        if ( vnum >= pArea->lvnum
          && vnum <= pArea->uvnum )
            return pArea;
    }

    return NULL;
}



char *area_bit_name( int area_flags )
{
    static char buf[512];

    buf[0] = '\0';
    if ( area_flags & AREA_STATIC       )   strcat( buf, " static" );
    if ( area_flags & AREA_CHANGED      )   strcat( buf, " changed" );
    if ( area_flags & AREA_ADDED        )   strcat( buf, " added" );
    return buf+1;
}



int get_area_flags_number( char *argument )
{
    if ( !str_cmp( argument, "static"  ) )      return AREA_STATIC;
    if ( !str_cmp( argument, "changed" ) )      return AREA_CHANGED;
    if ( !str_cmp( argument, "added" ) )        return AREA_ADDED;
    return AREA_NONE;
}




void aedit( CHAR_DATA *ch, char *argument )
{
    AREA_DATA *pArea;
    char arg[MAX_STRING_LENGTH];
    char arg1[MAX_STRING_LENGTH];
    char arg2[MAX_STRING_LENGTH];
    char buf [MAX_STRING_LENGTH];
    int  value;

    pArea = (AREA_DATA *)ch->desc->pEdit;
    strcpy( arg, argument );
    smash_tilde( argument );
    argument = one_argument( argument, arg1 );
    strcpy( arg2, argument );


    if ( !IS_BUILDER( ch, pArea ) )
    {
        send_to_char( "AEdit:  Insufficient security to modify area.\n\r", ch );
    }


    if ( !str_cmp( arg1, "show" ) )
    {
        sprintf( buf, "%d", pArea->vnum );
        do_astat( ch, buf );
        return;
    }


    if ( !str_cmp( arg1, "done" ) )
    {
        ch->desc->pEdit = NULL;
        ch->desc->connected = CON_PLAYING;
        return;
    }


    if ( !str_cmp( arg1, "?" ) )
    {
        do_help( ch, "aedit" );
        return;
    }

    if ( !str_cmp( arg1, "generate" ) )
    {
        if ( !str_cmp( arg2, "overwrite" ) )
        generate( ch, pArea->lvnum, pArea->uvnum, TRUE );
        else
        generate( ch, pArea->lvnum, pArea->uvnum, FALSE );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        return;
    };


    if ( is_number( arg1 ) )
    {
        sprintf( buf, "%d", atoi(arg1) );
        do_aedit( ch, buf );
        return;
    }

    if ( !IS_BUILDER( ch, pArea ) )
    {
        interpret( ch, arg );
        return;
    }


    if ( ( value = get_area_flags_number( arg1 ) ) != AREA_NONE )
    {
        TOGGLE_BIT(pArea->area_flags, value);

        send_to_char( "Flag toggled.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "create" ) )
    {
        AREA_DATA *pNewArea;

        if ( area_first == NULL )
        {
            area_first = new_area();
            pNewArea   = area_first;
        }
        else
        {
            for ( pNewArea = area_first;
                  pNewArea != NULL;
                  pNewArea = pNewArea->next )
            {
                if ( pNewArea->next == NULL )
                {
                    send_to_char( pNewArea->name, ch );
                    pNewArea->next = new_area();          /* Clip on end */
                    pNewArea       = pNewArea->next;      /* Goto end    */
                    break;
                }
            }
        }

        ch->desc->pEdit    =   (void *)pNewArea;

        SET_BIT( pNewArea->area_flags, AREA_ADDED );
        send_to_char( "Area Created.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "name" ) )
    {
        if ( arg2[0] == '\0' )
        {
               send_to_char( "Syntax:   name [$name]\n\r", ch );
               return;
        }

        free_string( pArea->name );
        pArea->name = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Name set.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "filename" ) || !str_cmp( arg1, "file" ) )
    {
        if ( argument[0] == '\0' )
        {
            send_to_char( "Syntax:  filename [$file]\n\r", ch );
            send_to_char( "or       file     [$file]\n\r", ch );
            return;
        }

        if ( argument[0] == '$' )
        return;

        free_string( pArea->filename );
        pArea->filename = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Filename set.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "age" ) )
    {
        if ( !is_number( arg2 ) || arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  age [#age]\n\r", ch );
            return;
        }

        pArea->age = atoi( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Age set.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "repop" ) )
    {
        if ( arg2[0] == '\0' )
        {
            string_append( ch, &pArea->repop );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

        if ( arg2[0] == '+' )
        {
            string_append( ch, &pArea->repop );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

        send_to_char( "Syntax:  repop    - line edit\n\r", ch );
        send_to_char( "         repop +  - line append\n\r",ch );
        return;
    }


    if ( !str_cmp( arg1, "security" ) )
    {
        if ( !is_number( arg2 ) || arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  security [#level]\n\r", ch );
            return;
        }

        value = atoi( arg2 );

        if ( IS_NPC(ch) || value < GET_PC(ch,security,0) || value > 9 )
        {
            if ( GET_PC(ch,security,9) != 9 )
            {
                sprintf( buf, "Valid security range is %d-9.\n\r", PC(ch,security) );
                send_to_char( buf, ch );
            }
            else
            {
                send_to_char( "Valid security is 9 only.\n\r", ch );
            }
            return;
        }

        pArea->security = value;
        SET_BIT( pArea->area_flags, AREA_CHANGED );

        send_to_char( "Security set.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "builder" ) )
    {
        argument = one_argument( argument, arg2 );

        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  builder [$name]\n\r", ch );
            return;
        }

        arg2[0] = UPPER( arg2[0] );

        if ( strstr( pArea->builders, arg2 ) != NULL )
        {
            pArea->builders = string_replace( pArea->builders, arg2, "\0" );
            pArea->builders = string_unpad( pArea->builders );

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            send_to_char( "Builder removed.\n\r", ch );
            return;
        }
        else
        {
            buf[0] = '\0';
            if (pArea->builders[0] != '\0' )
            {
                strcat( buf, pArea->builders );
                strcat( buf, " " );
            }
            strcat( buf, arg2 );
            free_string( pArea->builders );
            pArea->builders = string_proper( str_dup( buf ) );

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            send_to_char( "Builder added.\n\r", ch );
            return;
        }
    }


    if ( !str_cmp( arg1, "lvnum" ) )
    {
        if ( !is_number( arg2 ) || arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  lvnum [#lower]\n\r", ch );
            return;
        }
        value = atoi( arg2 );

        if ( get_vnum_area( value ) != NULL
          && get_vnum_area( value ) != pArea )
        {
            send_to_char( "AEdit:  Vnum range already assigned.\n\r", ch );
            return;
        }

        pArea->lvnum = value;
        SET_BIT( pArea->area_flags, AREA_CHANGED );

        send_to_char( "Lower vnum set.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "uvnum" ) )
    {
        if ( !is_number( arg2 ) || arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  uvnum [#upper]\n\r", ch );
            return;
        }

        value = atoi( arg2 );

        if ( get_vnum_area( value ) != NULL
          && get_vnum_area( value ) != pArea )
        {
            send_to_char( "AEdit:  Vnum range already assigned.\n\r", ch );
            return;
        }

        pArea->uvnum = value;
        SET_BIT( pArea->area_flags, AREA_CHANGED );

        send_to_char( "Upper vnum set.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "vnum" ) )
    {
       argument = one_argument( argument, arg1 );
       strcpy( arg2, argument );

       if ( !is_number( arg1 ) || arg1[0] == '\0'
         || !is_number( arg2 ) || arg2[0] == '\0' )
       {
            send_to_char( "Syntax:  vnum [#lower] [#upper]\n\r", ch );
            return;
        }

        value = atoi( arg1 );

        if ( get_vnum_area( value ) != NULL
          && get_vnum_area( value ) != pArea )
        {
            send_to_char( "AEdit:  Lower vnum already assigned.\n\r", ch );
            return;
        }

        pArea->lvnum = value;
        send_to_char( "Lower vnum set.\n\r", ch );

        value = atoi( arg2 );

        if ( get_vnum_area( value ) != NULL
          && get_vnum_area( value ) != pArea )
        {
            send_to_char( "AEdit:   Upper vnum already assigned.\n\r", ch );
            return;
        }

        pArea->uvnum = value;
        send_to_char( "Upper vnum set.\n\r", ch );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        return;
    }

    interpret( ch, arg );
    return;
}



bool redit_exit( CHAR_DATA *ch, ROOM_INDEX_DATA *pRoom, int door,
                 char *arg1, char *arg2 )
{
    AREA_DATA *pArea, *oArea = NULL;
    EXIT_DATA *exit;
    EXIT_DATA *oexit = NULL;
    int value;

    exit = pRoom->exit[door];
    pArea = pRoom->area;
    if ( exit != NULL && exit->to_room != NULL )
    {
        oexit = exit->to_room->exit[rev_dir[door]];
        oArea = exit->to_room->area;
    }

    if ( !str_cmp( arg1, "unlink" )
      || !str_cmp( arg1, "delete" )
      || !str_cmp( arg1, "kill" )  )
    {
        if ( pRoom->exit[door] == NULL )
        {
            send_to_char( "REdit:  Cannot delete a non-existant exit.\n\r", ch );
            return TRUE;
        }

        if ( oexit != NULL && IS_BUILDER( ch, oArea ) )
        {
            free_exit( oexit );
            exit->to_room->exit[rev_dir[door]] = NULL;
            SET_BIT( pArea->area_flags, AREA_CHANGED );
        }

        free_exit( exit );
        pRoom->exit[door] = NULL;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Exit unlinked.\n\r", ch );
        return TRUE;
    }

    if ( is_number( arg1 ) )
    {
        ROOM_INDEX_DATA *to_room;

        value = atoi( arg1 );

        if ( (to_room = get_room_index( value )) == NULL )
        {
            if ( (oArea = get_vnum_area( value )) == NULL )
            {
                send_to_char( "REdit:  Vnum does not fall within an area define.\n\r", ch );
                return TRUE;
            }

            if ( !IS_BUILDER( ch, oArea ) )
            {
            send_to_char( "REdit:  Cannot dig a room in an area of which you are not a builder.\n\r", ch );
            return TRUE;
            }
            else
            {
                if ( ( IS_SET(oArea->area_flags, AREA_STATIC)
                    || IS_SET(pArea->area_flags, AREA_STATIC) )
                  && to_room->area != pArea )
                {
                send_to_char( "REdit:  You cannot link static areas to other areas.\n\r", ch );
                return TRUE;
                }
                else
                {
                char buf[MAX_INPUT_LENGTH];

                sprintf( buf, "create %d", value );
                redit( ch, buf );
                to_room = get_room_index( value );
                if ( to_room == NULL )
                {
                    bug( "Redit_exit: NULL after attempted create, vnum %d.", value );
                    return TRUE;
                }
                to_room->sector_type = pRoom->sector_type;
                to_room->room_flags  = pRoom->room_flags;
                }
            }
        }

        if ( !IS_BUILDER( ch, to_room->area ) )
        {
            send_to_char( "REdit:  Return exit not created.\n\r", ch );
            oArea = NULL;
        }
        else oArea = to_room->area;

        if ( to_room->exit[rev_dir[door]] != NULL )
        {
            send_to_char( "REdit:  Return exit already exists.\n\r", ch );
            return TRUE;
        }

        if ( pRoom->exit[door] != NULL )
            redit_exit( ch, pRoom, door, "unlink", "" );

        pRoom->exit[door] = new_exit();

        pRoom->exit[door]->to_room = to_room;
        pRoom->exit[door]->vnum = value;

        if ( oArea != NULL )
        {
        door                            = rev_dir[door];
        to_room->exit[door]             = new_exit();
        to_room->exit[door]->to_room    = pRoom;
        to_room->exit[door]->vnum       = pRoom->vnum;
        SET_BIT( oArea->area_flags, AREA_CHANGED );
        }

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Exit linked.\n\r", ch );
        return TRUE;
    }
        
    if ( !str_cmp( arg1, "to" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  [direction] room [vnum]\n\r", ch );
            return TRUE;
        }

        if ( pRoom->exit[door] == NULL )
        {
            pRoom->exit[door] = new_exit();
        }

        value = atoi( arg2 );

        if ( get_room_index( value ) == NULL )
        {
            send_to_char( "REdit:  Cannot link to non-existant room.\n\r", ch );
            return TRUE;
        }

        pRoom->exit[door]->to_room = get_room_index( value );
        pRoom->exit[door]->vnum = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Exit destination set.\n\r", ch );
        return TRUE;
    }


    if ( !str_cmp( arg1, "key" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  [direction] key [vnum]\n\r", ch );
            return TRUE;
        }

        if ( pRoom->exit[door] == NULL )
        {
            pRoom->exit[door] = new_exit();
        }

        value = atoi( arg2 );

        if ( get_obj_index( value ) == NULL )
        {
            send_to_char( "REdit:  Cannot use a non-existant object as a key.\n\r", ch );
            return TRUE;
        }

        pRoom->exit[door]->key = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Exit key set.\n\r", ch );
        return TRUE;
    }


    if ( !str_cmp( arg1, "name" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  [direction] name [string]\n\r", ch );
            return TRUE;
        }

        if ( pRoom->exit[door] == NULL )
        {
            pRoom->exit[door] = new_exit();
        }

        free_string( pRoom->exit[door]->keyword );
        pRoom->exit[door]->keyword = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Exit name set.\n\r", ch );
        return TRUE;
    }


    if ( !str_cmp( arg1, "desc" ) || !str_cmp( arg1, "description" ) )
    {
        if ( pRoom->exit[door] == NULL )
        {
            pRoom->exit[door]          = new_exit();
            pRoom->exit[door]->vnum    = pRoom->vnum;
            pRoom->exit[door]->to_room = pRoom;
        }

        string_append( ch, &pRoom->exit[door]->description );
        SET_BIT( pArea->area_flags, AREA_CHANGED );
        return TRUE;
    }

    if ( !str_cmp( arg1, "door" ) )
    {
        if ( (exit = pRoom->exit[door]) == NULL )
        {
            send_to_char( "REdit:  Exit does not exist.\n\r", ch );
            return TRUE;
        }

        if ( pRoom->exit[door]->to_room == NULL )
        {
            send_to_char( "REdit:  Exit does not lead anywhere.\n\r", ch );
            return TRUE;
        }

        oArea = pRoom->exit[door]->to_room->area;
        if ( (oexit = pRoom->exit[door]->to_room->exit[rev_dir[door]]) == NULL )
        {
            send_to_char( "REdit:  No return exit.\n\r", ch );
            return TRUE;
        }

        if ( !IS_BUILDER( ch, oArea ) )
        {
            send_to_char( "REdit:  You are not a builder of the return exit.\n\r", ch );
            return TRUE;
        }

        SET_BIT( exit->rs_flags, EX_ISDOOR );
        SET_BIT( exit->exit_info, EX_ISDOOR );
        SET_BIT( oexit->rs_flags, EX_ISDOOR );
        SET_BIT( oexit->exit_info, EX_ISDOOR );
        send_to_char( "Door copied to reverse side.\n\r", ch );

        if ( arg2[0] != '\0' )
        {
            free_string( exit->keyword );
            exit->keyword = str_dup( arg2 );

            free_string( oexit->keyword );
            oexit->keyword = str_dup( arg2 );
        }
        else
        {
            free_string( exit->keyword );
            exit->keyword = str_dup( "door" );

            free_string( oexit->keyword );
            oexit->keyword = str_dup( "door" );
        }
        return TRUE;
    }

    if ( !str_cmp( arg1, "flag" ) )
    {
        int flag = exit_name_bit( arg2 );

        if ( flag == EX_NONE )
        {
            send_to_char( "Syntax:  [direction] flag [exit flag]\n\r", ch );
            return TRUE;
        }

        if ( pRoom->exit[door] == NULL )
        {
            send_to_char( "REdit:  Exit does not exist.\n\r", ch );
            return TRUE;
        }

        TOGGLE_BIT(pRoom->exit[door]->rs_flags,  flag);
        TOGGLE_BIT(pRoom->exit[door]->exit_info, flag);

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Exit flag toggled.\n\r", ch );
        return TRUE;
    }

    if ( (value = exit_name_bit( arg1 )) != EX_NONE )
    {
        if ( (exit = pRoom->exit[door]) == NULL )
        {
            send_to_char( "REdit:  Exit does not exist.\n\r", ch );
            return TRUE;
        }

        if ( pRoom->exit[door]->to_room == NULL )
        send_to_char( "REdit:  Exit does not lead anywhere.\n\r", ch );
        else
        {
            oArea = pRoom->exit[door]->to_room->area;
            if ( (oexit = pRoom->exit[door]->to_room->exit[rev_dir[door]]) == NULL )
            send_to_char( "REdit:  No return exit.\n\r", ch );
        }

        TOGGLE_BIT(exit->rs_flags, value);
        TOGGLE_BIT(exit->exit_info, value);

        if ( oexit != NULL && IS_BUILDER( ch, oArea ) )
        {
            TOGGLE_BIT(oexit->rs_flags, value);
            TOGGLE_BIT(oexit->exit_info, value);
        }

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Exit flag toggled.\n\r", ch );
        return TRUE;
    }

    return FALSE;
}




void redit( CHAR_DATA *ch, char *argument )
{
    AREA_DATA *pArea;
    ROOM_INDEX_DATA *pRoom;
    EXTRA_DESCR_DATA *ed;
    char arg[MAX_STRING_LENGTH];
    char arg1[MAX_STRING_LENGTH];
    char arg2[MAX_STRING_LENGTH];
    char buf[MAX_STRING_LENGTH];
    int  value;
    int  iHash;
    int  door;

    strcpy( arg, argument );
    smash_tilde( argument );
    argument = one_argument( argument, arg1 );
    strcpy( arg2, argument );

    pRoom = ch->in_room;
    pArea = pRoom->area;


    if ( !IS_BUILDER( ch, pArea ) )
    {
        send_to_char( "AEdit:  Insufficient security to modify room.\n\r", ch );
    }


    if ( !str_cmp( arg1, "show" ) )
    {
        sprintf( buf, "%d", pRoom->vnum );
        do_rstat( ch, buf );
        return;
    }


    if ( !str_cmp( arg1, "done" ) )
    {
        ch->desc->pEdit = NULL;
        ch->desc->connected = CON_PLAYING;
        return;
    }


    if ( !str_cmp( arg1, "?" ) )
    {
        do_help( ch, "redit" );
        return;
    }


    if ( is_number( arg1 ) )
    {
        sprintf( buf, "%d", atoi(arg1) );
        do_redit( ch, buf );
        return;
    }

    if ( !IS_BUILDER( ch, pArea ) )
    {
        interpret( ch, arg );
        return;
    }


    if ( room_name_bit( arg1 ) != ROOM_NONE )
    {
        TOGGLE_BIT(pRoom->room_flags, room_name_bit( arg1 ));

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Room flag toggled.\n\r", ch );
        return;
    }


    if ( sector_number( arg1 ) != SECT_MAX )
    {
        pRoom->sector_type  = sector_number( arg1 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Sector type set.\n\r", ch );
        return;
    }


    if ( ( door = get_dir( arg1 ) ) != MAX_DIR && arg2[0] != '\0' )
    {
        argument = one_argument( argument, arg1 );
        strcpy( arg2, argument );

        if ( redit_exit( ch, pRoom, door, arg1, arg2 ) ) return;
    }


    if ( !str_cmp( arg1, "ed" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  ed add [keyword]\n\r", ch );
            send_to_char( "         ed delete [keyword]\n\r", ch );
            send_to_char( "         ed edit [keyword]\n\r", ch );
            send_to_char( "         ed format [keyword]\n\r", ch );
            return;
        }

        argument = one_argument( argument, arg1 );
        strcpy( arg2, argument );

        if ( !str_cmp( arg1, "add" ) )
        {
            if ( arg2[0] == '\0' )
            {
                send_to_char( "Syntax:  ed add [keyword]\n\r", ch );
                return;
            }

            for ( ed = pRoom->extra_descr; ed != NULL; ed = ed->next )
            {
                if ( is_name( arg2, ed->keyword ) )
                    break;
            }

            if ( ed != NULL )
            {
                send_to_char( "REdit:  Extra description keyword exists.\n\r", ch );
                return;
            }

            ed                  =   new_extra_descr();
            ed->keyword         =   str_dup( arg2 );
            ed->description     =   str_dup( "" );
            ed->next            =   pRoom->extra_descr;
            pRoom->extra_descr  =   ed;

            string_append( ch, &ed->description );

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }


        if ( !str_cmp( arg1, "edit" ) )
        {
            if ( arg2[0] == '\0' )
            {
                send_to_char( "Syntax:  ed edit [keyword]\n\r", ch );
                return;
            }

            for ( ed = pRoom->extra_descr; ed != NULL; ed = ed->next )
            {
                if ( is_name( arg2, ed->keyword ) )
                    break;
            }

            if ( ed == NULL )
            {
                send_to_char( "REdit:  Extra description keyword not found.\n\r", ch );
                return;
            }

            string_append( ch, &ed->description );

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }


        if ( !str_cmp( arg1, "delete" ) )
        {
            EXTRA_DESCR_DATA *ped;

            if ( arg2[0] == '\0' )
            {
                send_to_char( "Syntax:  ed delete [keyword]\n\r", ch );
                return;
            }

            ped = NULL;

            for ( ed = pRoom->extra_descr; ed != NULL; ed = ed->next )
            {
                if ( is_name( arg2, ed->keyword ) )
                    break;
                ped = ed;
            }

            if ( ed == NULL )
            {
                send_to_char( "REdit:  Extra description keyword not found.\n\r", ch );
                return;
            }

            if ( ped == NULL )
            {
                pRoom->extra_descr = ed->next;
            }
            else
            {
                ped->next = ed->next;
            }

            free_extra_descr( ed );

            send_to_char( "Extra description deleted.\n\r", ch );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

    }
   
    if ( !str_cmp( arg1, "reference" ) 
     ||  !str_cmp( arg1, "ref" ) )
    {
        ROOM_INDEX_DATA *template;
  
        value = atoi( arg2 );

        if ( value == 0 )
        {
             send_to_char( "REdit:  Cleared template reference.\n\r", ch);
             pRoom->template = 0;
             return;
        }

        template = get_room_index( value );
   
        if ( template == NULL 
          || !IS_SET(template->room_flags, ROOM_TEMPLATE) )
        {
              send_to_char( "REdit:  Invalid vnum for template.\n\r", ch);
              return;
        }
 
        pRoom->template = value;

        send_to_char( "Room template set.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg1, "proc" ) )
    {
        TRIGGER_DATA *pTrig;
        SCRIPT_DATA *proc;

        if ( !str_cmp( arg2, "clear" ) )
        {
            TRIGGER_DATA *pNext;

            for ( pTrig = pRoom->triggers; pTrig != NULL; pTrig = pNext )
            {
                pNext     = pTrig->next;
                free_trigger( pTrig );
            }

            pRoom->triggers = NULL;
            send_to_char( "Procs cleared.\n\r", ch );
            return;
        }

        if ( (proc = get_script_index(atoi(arg2))) == NULL )
        {
            send_to_char( "Syntax:  proc [vnum]\n\r", ch );
            return;
        }

        pTrig            = new_trigger();
        pTrig->script    = proc;

        pTrig->next    = pRoom->triggers;
        pRoom->triggers = pTrig;

        send_to_char( "Proc set.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg1, "create" ) )
    {
        value = atoi( arg2 );

        if ( arg2[0] == '\0'  || value == 0 )
        {
            send_to_char( "Syntax:  create [vnum]\n\r", ch );
            return;
        }

        pArea = get_vnum_area( value );

        if ( pArea == NULL )
        {
            send_to_char( "REdit:  That vnum is not assigned an area.\n\r", ch );
            return;
        }

        if ( !IS_BUILDER( ch, pArea ) )
        {
            send_to_char( "REdit:  Vnum in an area you cannot build in.\n\r", ch );
            return;
        }

        if ( get_room_index( value ) != NULL )
        {
            send_to_char( "REdit:  Room vnum already exists.\n\r", ch );
            return;
        }

        pRoom                   = new_room_index();
        pRoom->area             = pArea;
        pRoom->vnum             = value;

        if ( value > top_vnum_room ) top_vnum_room = value;

        iHash                   = value % MAX_KEY_HASH;
        pRoom->next             = room_index_hash[iHash];
        room_index_hash[iHash]  = pRoom;
        ch->desc->pEdit         = (void *)pRoom;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Room created.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "name" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  name [name]\n\r", ch );
            return;
        }

        free_string( pRoom->name );
        pRoom->name = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Name set.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "strcpy" ) )
    {
        ROOM_INDEX_DATA *fRoom;

        fRoom = get_room_index( atoi( arg2 ) );

        if ( fRoom == NULL )
        {
        send_to_char( "Syntax:  strcpy [vnum]\n\r", ch );
        return;
        }

        if ( !IS_BUILDER(ch, fRoom->area) )
        {
        send_to_char( "REdit:  You are not allowed to copy from other areas.\n\r", ch );
        return;
        }

        free_string( pRoom->description );
        pRoom->description = str_dup( fRoom->description );
        send_to_char( "Description copied.\n\r *** This is frowned upon by area reviewers! ***\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "desc" ) || !str_cmp( arg1, "description" ) )
    {
        string_append( ch, &pRoom->description );
        SET_BIT( pArea->area_flags, AREA_CHANGED );
        return;
    }


    if ( !str_cmp( arg1, "format" ) )
    {
        pRoom->description = format_string( pRoom->description );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "String formatted.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "light" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  light [number]\n\r", ch );
            return;
        }

        value = atoi( arg2 );
        pRoom->light = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Light set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "wagonref" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  wagonref [obj vnum]\n\r", ch );
            return;
        }

        value = atoi( arg2 );
        pRoom->wagon = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Wagon object vnum reference set.\n\r", ch);
        return;
    }


    interpret( ch, arg );
    return;
}



void oedit( CHAR_DATA *ch, char *argument )
{
    AREA_DATA *pArea;
    OBJ_INDEX_DATA *pObj;
    EXTRA_DESCR_DATA *ed;
    AFFECT_DATA *pAf;
    char arg[MAX_STRING_LENGTH];
    char arg1[MAX_STRING_LENGTH];
    char arg2[MAX_STRING_LENGTH];
    char buf[MAX_STRING_LENGTH];
    int  value;
    int  iHash;

    strcpy( arg, argument );
    smash_tilde( argument );
    argument = one_argument( argument, arg1 );
    strcpy( arg2, argument );

    pObj = (OBJ_INDEX_DATA *)ch->desc->pEdit;
    pArea = pObj->area;

    if ( !IS_BUILDER( ch, pArea ) )
    {
        send_to_char( "OEdit:  Insufficient security to modify object.\n\r", ch );
    }

    if ( !str_cmp( arg1, "show" ) )
    {
        sprintf( buf, "%d", pObj->vnum );
        do_oindex( ch, buf );
        return;
    }


    if ( !str_cmp( arg1, "done" ) )
    {
        ch->desc->pEdit = NULL;
        ch->desc->connected = CON_PLAYING;
        return;
    }


    if ( !str_cmp( arg1, "?" ) )
    {
        do_help( ch, "oedit" );
        return;
    }
    

    if ( is_number( arg1 ) )
    {
        sprintf( buf, "%d", atoi(arg1) );
        do_oedit( ch, buf );
        return;
    }

    if ( !IS_BUILDER( ch, pArea ) )
    {
        interpret( ch, arg );
        return;
    }


    if ( !str_cmp( arg1, "addaffect" ) )
    {
        char arg3[MAX_STRING_LENGTH];

        argument = one_argument( argument, arg1 );
        argument = one_argument( argument, arg2 );
        strcpy( arg3, argument );

        if ( arg1[0] == '\0' || arg2[0] == '\0' || !is_number( arg2 )
          || arg3[0] == '\0' || !is_number( arg3 ) )
        {
            send_to_char( "Syntax:  addaffect [location] [#mod] [#duration]\n\r", ch );
            return;
        }

        pAf             =   new_affect();
        pAf->location   =   affect_name_loc( arg1 );
        pAf->modifier   =   atoi( arg2 );
        pAf->type       =   atoi( arg3 );
        pAf->duration   =   0;
        pAf->bitvector  =   0;
        pAf->next       =   pObj->affected;
        pObj->affected  =   pAf;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Affect added.\n\r", ch);
        return;
    }


    if ( !str_cmp( arg1, "delaffect" ) || !str_cmp( arg1, "remaffect" ) )
    {
        pAf             =   pObj->affected;

        if ( pAf == NULL )
        {
            send_to_char( "OEdit:  No affect to remove.\n\r", ch );
            return;
        }

        pObj->affected  =   pObj->affected->next;
        free_affect( pAf );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Affect removed.\n\r", ch);
        return;
    }


    if ( !str_cmp( arg1, "timer" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  timer [number]\n\r", ch );
            return;
        }

        pObj->timer = atoi( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Timer set.\n\r", ch);
        return;
    }


    if ( ( value = item_name_type( arg1 ) ) != ITEM_NONE )
    {
        pObj->item_type = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Type set.\n\r", ch);
        return;
    }


    if ( ( value = extra_name_bit( arg1 ) ) != EXTRA_NONE )
    {
        TOGGLE_BIT(pObj->extra_flags, value);

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Extra flag toggled.\n\r", ch);
        return;
    }


    if ( ( value = wear_name_bit( arg1 ) ) != ITEM_WEAR_NONE )
    {
        TOGGLE_BIT(pObj->wear_flags, value);

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Wear flag toggled.\n\r", ch);
        return;
    }



    if ( !str_cmp( arg1, "name" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  name [string]\n\r", ch );
            return;
        }

        free_string( pObj->name );
        pObj->name = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Name set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "plural" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  plural [string]\n\r", ch );
            return;
        }

        free_string( pObj->short_descr_plural );
        pObj->short_descr_plural = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Plural set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "plurallong" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  plurallong [string]\n\r", ch );
            return;
        }

        strcat( arg2, "\n\r" );
        if ( !strstr( arg2, "%s" ) )
        {
            send_to_char( "String must contain %s in place of numeric.\n\r", ch );
            return;
        }

        free_string( pObj->description_plural );
        pObj->description_plural = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Plural long description set.\n\r", ch);
        return;
    }


    if ( !str_cmp( arg1, "short" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  short [string]\n\r", ch );
            return;
        }

        free_string( pObj->short_descr );
        pObj->short_descr = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Short description set.\n\r", ch);
        return;
    }


    if ( !str_cmp( arg1, "action" ) )
    {
        SET_BIT( pArea->area_flags, AREA_CHANGED );
        string_append( ch, &pObj->action_descr );
        return;
    }


    if ( !str_cmp( arg1, "description" )  ||  !str_cmp( arg1, "desc" ) )
    {
        SET_BIT( pArea->area_flags, AREA_CHANGED );
        string_append( ch, &pObj->real_description );
        return;
    }


    if ( !str_cmp( arg1, "long" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  long [string]\n\r", ch );
            return;
        }
        
        strcat( arg2, "\n\r" );

        free_string( pObj->description );
        pObj->description = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Long description set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "level" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  level [number]\n\r", ch );
            return;
        }

        pObj->level = atoi( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Level set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "value1") || !str_cmp( arg1, "v1" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  value1 [number]\n\r", ch );
            send_to_char( "or       v1 [number]\n\r", ch );
            return;
        }

        value = atoi( arg2 );
        pObj->value[0] = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Value 1 set.\n\r", ch);
        return;
    }


    if ( !str_cmp( arg1, "value2") || !str_cmp( arg1, "v2" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  value2 [number]\n\r", ch );
            send_to_char( "or       v2 [number]\n\r", ch );
            return;
        }

        value = atoi( arg2 );
        pObj->value[1] = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Value 2 set.\n\r", ch);
        return;
    }


    if ( !str_cmp( arg1, "value3") || !str_cmp( arg1, "v3" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  value3 [number]\n\r", ch );
            send_to_char( "or       v3 [number]\n\r", ch );
            return;
        }

        value = atoi( arg2 );
        pObj->value[2] = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Value 3 set.\n\r", ch);
        return;
    }


    if ( !str_cmp( arg1, "value4") || !str_cmp( arg1, "v4" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  value4 [number]\n\r", ch );
            send_to_char( "or       v4 [number]\n\r", ch );
            return;
        }

        value = atoi( arg2 );
        pObj->value[3] = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Value 4 set.\n\r", ch);
        return;
    }

                           

    if ( !str_cmp( arg1, "material" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  material [type]\n\r", ch );
            return;
        }

        value = atoi( arg2 );   /* Change THIS */
/*        pObj->material = value;  */

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Material set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "size" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  size [number]\n\r", ch );
            return;
        }

        value = atoi( arg2 );
        pObj->size = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Size set.\n\r", ch);
        return;
    }



    if ( !str_cmp( arg1, "weight" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  weight [number]\n\r", ch );
            return;
        }

        value = atoi( arg2 );
        pObj->weight = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Weight set.\n\r", ch);
        return;
    }


    if ( !str_cmp( arg1, "cost" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  cost [number]\n\r", ch );
            return;
        }

        value = atoi( arg2 );
        pObj->cost = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Cost set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "proc" ) )
    {
        TRIGGER_DATA *pTrig;
        SCRIPT_DATA *proc;

        if ( !str_cmp( arg2, "kill" ) )
        {
            TRIGGER_DATA *pNext;

            for ( pTrig = pObj->triggers; pTrig != NULL; pTrig = pNext )
            {
                pNext     = pTrig->next;
                free_trigger( pTrig );
            }

            pObj->triggers = NULL;
            send_to_char( "Procs cleared.\n\r", ch );
            return;
        }

        if ( (proc = get_script_index(atoi(arg2))) == NULL )
        {
            send_to_char( "Syntax:  proc [vnum]\n\r", ch );
            return;
        }

        pTrig            = new_trigger();
        pTrig->script    = proc;

        pTrig->next    = pObj->triggers;
        pObj->triggers = pTrig;

        send_to_char( "Proc set.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "create" ) )
    {
        value = atoi( arg2 );
        if ( arg2[0] == '\0' || value == 0 )
        {
            send_to_char( "Syntax:  oedit create [vnum]\n\r", ch );
            return;
        }

        pArea = get_vnum_area( value );

        if ( pArea == NULL )
        {
            send_to_char( "OEdit:  That vnum is not assigned an area.\n\r", ch );
            return;
        }

        if ( !IS_BUILDER( ch, pArea ) )
        {
            send_to_char( "OEdit:  Vnum in an area you cannot build in.\n\r", ch );
            return;
        }

        if ( get_obj_index( value ) != NULL )
        {
            send_to_char( "OEdit:  Object vnum already exists.\n\r", ch );
            return;
        }
        
        pObj                    = new_obj_index();
        pObj->vnum              = value;
        pObj->area              = pArea;
        
        if ( value > top_vnum_obj ) top_vnum_obj = value;

        iHash                   = value % MAX_KEY_HASH;
        pObj->next              = obj_index_hash[iHash];
        obj_index_hash[iHash]   = pObj;
        ch->desc->pEdit = (void *)pObj;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Object Created.\n\r", ch );
        return;
    }



    if ( !str_cmp( arg1, "ed" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  ed add [keyword]\n\r", ch );
            send_to_char( "         ed delete [keyword]\n\r", ch );
            send_to_char( "         ed edit [keyword]\n\r", ch );
            send_to_char( "         ed format [keyword]\n\r", ch );
            return;
        }

        argument = one_argument( argument, arg1 );
        strcpy( arg2, argument );

        if ( !str_cmp( arg1, "add" ) )
        {
            if ( arg2[0] == '\0' )
            {
                send_to_char( "Syntax:  ed add [keyword]\n\r", ch );
                return;
            }

            ed                  =   new_extra_descr();
            ed->keyword         =   str_dup( arg2 );
            ed->next            =   pObj->extra_descr;
            pObj->extra_descr   =   ed;

            string_append( ch, &ed->description );

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }


        if ( !str_cmp( arg1, "edit" ) )
        {
            if ( arg2[0] == '\0' )
            {
                send_to_char( "Syntax:  ed edit [keyword]\n\r", ch );
                return;
            }

            for ( ed = pObj->extra_descr; ed != NULL; ed = ed->next )
            {
                if ( is_name( arg2, ed->keyword ) )
                    break;
            }

            if ( ed == NULL )
            {
                send_to_char( "OEdit:  Extra description keyword not found.\n\r", ch );
                return;
            }

            string_append( ch, &ed->description );

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }


        if ( !str_cmp( arg1, "append" ) )
        {
            if ( arg2[0] == '\0' )
            {
                send_to_char( "Syntax:  ed edit [keyword]\n\r", ch );
                return;
            }

            for ( ed = pObj->extra_descr; ed != NULL; ed = ed->next )
            {
                if ( is_name( arg2, ed->keyword ) )
                    break;
            }

            if ( ed == NULL )
            {
                send_to_char( "OEdit:  Extra description keyword not found.\n\r", ch );
                return;
            }

            string_append( ch, &ed->description );

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }


        if ( !str_cmp( arg1, "delete" ) )
        {
            EXTRA_DESCR_DATA *ped;

            if ( arg2[0] == '\0' )
            {
                send_to_char( "Syntax:  ed delete [keyword]\n\r", ch );
                return;
            }

            ped = NULL;

            for ( ed = pObj->extra_descr; ed != NULL; ed = ed->next )
            {
                if ( is_name( arg2, ed->keyword ) )
                    break;
                ped = ed;
            }

            if ( ed == NULL )
            {
                send_to_char( "OEdit:  Extra description keyword not found.\n\r", ch );
                return;
            }

            if ( ped == NULL )
            {
                pObj->extra_descr = ed->next;
            }
            else
            {
                ped->next = ed->next;
            }

            free_extra_descr( ed );

            send_to_char( "Extra description deleted.\n\r", ch );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }


        if ( !str_cmp( arg1, "format" ) )
        {
            EXTRA_DESCR_DATA *ped;

            if ( arg2[0] == '\0' )
            {
                send_to_char( "Syntax:  ed format [keyword]\n\r", ch );
                return;
            }

            ped = NULL;

            for ( ed = pObj->extra_descr; ed != NULL; ed = ed->next )
            {
                if ( is_name( arg2, ed->keyword ) )
                    break;
                ped = ed;
            }

            if ( ed == NULL )
            {
                send_to_char( "OEdit:  Extra description keyword not found.\n\r", ch );
                return;
            }

            ed->description = format_string( ed->description );

            send_to_char( "Extra description formatted.\n\r", ch );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }
    }


    interpret( ch, arg );
    return;
}




void medit( CHAR_DATA *ch, char *argument )
{
    AREA_DATA *pArea;
    MOB_INDEX_DATA *pMob;
    char arg[MAX_STRING_LENGTH];
    char arg1[MAX_STRING_LENGTH];
    char arg2[MAX_STRING_LENGTH];
    char buf[MAX_STRING_LENGTH];
    int  value;
    int  iHash;

    strcpy( arg, argument );
    smash_tilde( argument );
    argument = one_argument( argument, arg1 );
    strcpy( arg2, argument );
    value = atoi( arg2 );

    pMob = (MOB_INDEX_DATA *)ch->desc->pEdit;
    pArea = pMob->area;
 
    if ( !IS_BUILDER( ch, pArea ) )
    {
         send_to_char( "MEdit:  Insufficient security to modify mobile.\n\r", ch );
    }

    if ( !str_cmp( arg1, "show" ) )
    {
        sprintf( buf, "%d %s", pMob->vnum, arg2 );
        do_mindex( ch, buf );
        return;
    }


    if ( !str_cmp( arg1, "done" ) )
    {
        ch->desc->pEdit = NULL;
        ch->desc->connected = CON_PLAYING;
        return;
    }

    if ( !str_cmp( arg1, "?" ) )
    {
        do_help( ch, "MEDIT" );
        return;
    }

    if ( !str_cmp( arg1, "skills" ) )
    {
        int sn, col = 0;

        for ( sn = 0;  sn < MAX_SKILL; sn++ )
        {
            if ( skill_table[sn].name == NULL )
            break;

            if ( pMob->learned[sn] <= 0 )
            continue;

            col++;
            sprintf( buf, "%20s/%3d ",
                     trunc_fit( skill_table[sn].name, 20 ),
                     pMob->learned[sn] );
            send_to_char( buf, ch );
            if ( col % 3 == 0 )
            {
                send_to_char( "\n\r", ch );
                col = 0;
            }
        }

        if ( col % 3 != 0 )  send_to_char( "\n\r", ch );
        return;
    }


    if ( is_number( arg1 ) )
    {
        sprintf( buf, "%d", atoi(arg1) );
        do_medit( ch, buf );
        return;
    }

    if ( !IS_BUILDER( ch, pArea ) )
    {
        interpret( ch, arg );
        return;
    }


    if ( !str_cmp( arg1, "shop" ) )
    {
        SHOP_DATA *pShop;

        argument = one_argument( argument, arg1 );
        strcpy( arg2, argument );

        if ( arg1[0] == '\0' )
        {
            send_to_char( "Syntax:  shop hours [#opening] [#closing]\n\r", ch );
            send_to_char( "         shop profit [#buying%] [#selling%]\n\r", ch );
            send_to_char( "         shop type [#] [item type]\n\r", ch );
            send_to_char( "         shop buy 'good name'\n\r", ch );
            send_to_char( "         shop sell 'good name'\n\r", ch );
            send_to_char( "         shop comp 'comp name'\n\r", ch );
            send_to_char( "         shop rate [cost]\n\r", ch );
            send_to_char( "         shop [number] [buy%] [sell%]\n\r", ch );
            send_to_char( "         shop [str1..str3] [string]\n\r", ch );
            send_to_char( "         shop [flag]\n\r", ch );
            send_to_char( "         shop delete\n\r", ch );
            return;
        }



        if ( pMob->pShop == NULL )
        {
            if ( !str_cmp( arg1, "delete" ) )
            {
                send_to_char( "REdit: No shop to delete.\n\r", ch );
                return;
            }

            pMob->pShop         = new_shop();
            pMob->pShop->keeper = pMob->vnum;
            shop_last->next     = pMob->pShop;
            send_to_char( "Shop created.\n\r", ch );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
        }

        pShop = pMob->pShop;

        if ( (value = shop_name_bit( arg1 )) != -1 )
        {
            TOGGLE_BIT(pShop->shop_flags, value);
            send_to_char( "Shop flag toggled.\n\r", ch );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

        if ( !str_cmp( arg1, "str1" ) )
        {
            free_string( pShop->no_such_item );
            pShop->no_such_item = str_dup( arg2 );
            send_to_char( "Str1 set.\n\r", ch );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

        if ( !str_cmp( arg1, "str2" ) )
        {
            free_string( pShop->do_not_buy );
            pShop->do_not_buy = str_dup( arg2 );
            send_to_char( "Str2 set.\n\r", ch );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

        if ( !str_cmp( arg1, "str3" ) )
        {
            free_string( pShop->list_header );
            pShop->list_header = str_dup( arg2 );
            send_to_char( "Str3 set.\n\r", ch );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

        if ( !str_cmp( arg1, "buy_index" ) )
        {
            pShop->buy_index = atoi( arg2 );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

        if ( !str_cmp( arg1, "sell_index" ) )
        {
            pShop->sell_index = atoi( arg2 );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

        if ( !str_cmp( arg1, "comp_index" ) )
        {
            pShop->comp_index = atoi( arg2 );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }


        if ( !str_cmp( arg1, "rate" ) )
        {
            if ( !is_number( arg2 ) )
            {
                send_to_char( "Syntax:  shop rate [#]\n\r", ch );
                return;
            }

            pShop->repair_rate = atoi( arg2 );
            send_to_char( "Shop repair rate set.\n\r", ch );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

        if ( !str_cmp( arg1, "hours" ) )
        {
            argument = one_argument( argument, arg1 );
            strcpy( arg2, argument );

            if ( arg1[0] == '\0' || !is_number(arg1)
              || arg2[0] == '\0' || !is_number(arg2) )
            {
                send_to_char( "Syntax:  shop hours [#opening] [#closing]\n\r", ch );
                return;
            }

            pShop->open_hour = atoi( arg1 );
            pShop->close_hour = atoi( arg2 );

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            send_to_char( "Shop hours set.\n\r", ch);
            return;
        }


        if ( !str_cmp( arg1, "profit" ) )
        {
            argument = one_argument( argument, arg1 );
            strcpy( arg2, argument );

            if ( arg1[0] == '\0' || !is_number( arg1 )
              || arg2[0] == '\0' || !is_number( arg2 ) )
            {
                send_to_char( "Syntax:  shop profit [#buying%] [#selling%]\n\r", ch );
                return;
            }

            pShop->profit_buy     = atoi( arg1 );
            pShop->profit_sell    = atoi( arg2 );

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            send_to_char( "Shop profit set.\n\r", ch);
            return;
        }


        if ( !str_cmp( arg1, "type" ) )
        {
            int iTrade;
            argument = one_argument( argument, arg1 );
            strcpy( arg2, argument );

            if ( arg1[0] == '\0' || !is_number( arg1 )
              || arg2[0] == '\0' )
            {
                send_to_char( "Syntax:  shop type [#] [item type]\n\r", ch );
                return;
            }

            if ( atoi(arg1)-1 > MAX_TRADE )
            {
                sprintf( buf, "%d", MAX_TRADE );
                send_to_char( "REdit:  Shop keepers may only sell ", ch );
                send_to_char( buf, ch );
                send_to_char( " items max.\n\r", ch );
                return;
            }

            if ( ( value = item_name_type(arg2) ) == ITEM_NONE )
            {
                send_to_char( "REdit:  That type of item is not known.\n\r", ch );
                return;
            }

            iTrade = atoi(arg1)-1;

            if ( iTrade < 0 || iTrade >= MAX_TRADE )
            {
                send_to_char( "Syntax:  shop type [#] [item type]\n\r", ch );
                return;
            }

            pShop->buy_type[iTrade] = item_name_type( arg2 );

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            send_to_char( "Shop type set.\n\r", ch);
            return;
        }


        if ( !str_cmp( arg1, "delete" ) )
        {
            if ( pShop == NULL )
            {
                send_to_char( "REdit:  Cannot delete a shop that is non-existant.\n\r", ch );
                return;
            }

            free_shop( pMob->pShop );
            pMob->pShop = NULL;

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            send_to_char( "Shop deleted.\n\r", ch);
            return;
        }

        send_to_char( "Type 'shop' alone for help.\n\r", ch );
        return;
    }


    if ( !str_cmp( arg1, "name" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  name [string]\n\r", ch );
            return;
        }

        free_string( pMob->name );
        pMob->name = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Name set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "strength" ) || !str_cmp( arg1, "str" ) )
    {
        pMob->perm_str = URANGE( 0, atoi( arg2 ), 25 );
        send_to_char( "Strength set.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg1, "intelligence" ) || !str_cmp( arg1, "int" ) )
    {
        pMob->perm_int = URANGE( 0, atoi( arg2 ), 25 );
        send_to_char( "Intelligence set.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg1, "wisdom" ) || !str_cmp( arg1, "wis" ) )
    {
        pMob->perm_wis = URANGE( 0, atoi( arg2 ), 25 );
        send_to_char( "Wisdom set.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg1, "dexterity" ) || !str_cmp( arg1, "dex" ) )
    {
        pMob->perm_dex = URANGE( 0, atoi( arg2 ), 25 );
        send_to_char( "Dexterity set.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg1, "constitution" ) || !str_cmp( arg1, "con" ) )
    {
        pMob->perm_con = URANGE( 0, atoi( arg2 ), 25 );
        send_to_char( "Constitution set.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg1, "size" ) )
    {
        pMob->size = atoi( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Size set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "race" ) )
    {
        int rn;

        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  race [name]\n\r", ch );
            return;
        }

        if ( !is_number(arg2) )
        for ( rn = 0;  rn < MAX_RACE;  rn++ )
        {
            if ( !str_prefix( arg2, race_table[rn].race_name ) )
            break;
        }
        else
        rn = atoi(arg1);

        if ( rn >= MAX_RACE || rn < 0 )
        {
            send_to_char( "Invalid race.\n\r", ch );
            return;
        }

        pMob->race = rn;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Race set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "skill" ) )
    {
        int sn;

        argument = one_argument( argument, arg1 );
        strcpy( arg2, argument );

        if ( arg1[0] == '\0' || arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  skill [skill] [percentage]\n\r", ch );
            return;
        }

        sn = skill_lookup( arg1 );
        if ( sn < 0 && str_cmp( arg1, "all" ) )
        {
            send_to_char( "Invalid skill.\n\r", ch );
            return;
        }

        if ( !str_cmp( arg1, "all" ) )
        {
            for ( sn = 0; sn < MAX_SKILL; sn++ )
            {
                if ( skill_table[sn].name == NULL )
                break;
                pMob->learned[sn] = URANGE( 0, atoi( arg2 ), 100 );
            }
        }
        else    pMob->learned[sn] = URANGE( 0, atoi( arg2 ), 100 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Skill set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "short" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  short [string]\n\r", ch );
            return;
        }

        free_string( pMob->short_descr );
        pMob->short_descr = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Short description set.\n\r", ch);
        return;
    }


    if ( !str_cmp( arg1, "long" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  long [string]\n\r", ch );
            return;
        }

        strcat( arg2, "\n\r" );
        free_string( pMob->long_descr );
        pMob->long_descr = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Long description set.\n\r", ch);
        return;
    }


    if ( !str_cmp( arg1, "desc" ) || !str_cmp( arg1, "description" ) )
    {
        if ( arg2[0] == '\0' )
        {
            string_append( ch, &pMob->description );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

        if ( arg2[0] == '+' )
        {
            string_append( ch, &pMob->description );
            SET_BIT( pArea->area_flags, AREA_CHANGED );
            return;
        }

        send_to_char( "Syntax:  desc    - line edit\n\r", ch );
        send_to_char( "         desc +  - line append\n\r",ch );
        return;
    }


    if ( get_mob_sex_number( arg1 ) != SEX_NONE )
    {
        pMob->sex = get_mob_sex_number( arg1 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Sex set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "timer" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  timer [ticks]\n\r", ch );
            return;
        }

        pMob->timer = atoi( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Timer set.\n\r", ch);
        return;
    }


    if ( ( value = act_name_bit( arg1 ) ) != ACT_NONE )
    {
        TOGGLE_BIT(pMob->act, value);
        SET_BIT( pMob->act, ACT_IS_NPC );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Act flag toggled.\n\r", ch);
        return;
    }


    if ( ( value = affect_name_bit( arg1 ) ) != AFFECT_NONE )
    {
        TOGGLE_BIT(pMob->affected_by, value);

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Affect flag toggled.\n\r", ch);
        return;
    }


    if ( !str_cmp( arg1, "attack" ) )
    {
        int i;
        int iType;

        argument = one_argument( argument, arg1 );
        strcpy( arg2, argument );

        if ( !is_number( arg1 )  )
        {
            send_to_char( "Syntax:  attack [num] [weapon type] [min dam] [max dam]\n\r", ch );
            send_to_char( "         attack [num] delete\n\r",                            ch );
            return;
        }

        i = URANGE( 0, atoi( arg1 ), MAX_ATTACK_DATA-1 );

        argument = one_argument( argument, arg1 );
        strcpy( arg2, argument );

        if ( !str_cmp( arg1, "delete" ) )
        {
            if ( pMob->attacks[i] != NULL )
            {
                 free_attack( pMob->attacks[i] );
                 pMob->attacks[i] = NULL;
                 send_to_char( "Attack deleted.\n\r", ch );
                 return;
            }
            else
            {
                send_to_char( "Attack does not exist already.\n\r", ch );
                return;
            }
        }

        for ( iType = 0; iType < MAX_ATTACK; iType++ )
        {
            if ( !str_cmp( arg1, attack_table[iType].name ) )
            break;
        }

        if ( iType >= MAX_ATTACK )
        {
            send_to_char( "Invalid weapon type (see IREF WEAPONS).\n\r", ch );
            return;
        }

        if ( pMob->attacks[i] == NULL )
        {
            send_to_char( "Attack added.\n\r", ch );
            pMob->attacks[i] = new_attack( );
        }
        else
        {
            send_to_char( "Attack modified.\n\r", ch );
        }

        pMob->attacks[i]->next = NULL;

        pMob->attacks[i]->idx     = iType;

        argument = one_argument( argument, arg1 );
        argument = one_argument( argument, arg2 );

        pMob->attacks[i]->dam1     = atoi( arg1 );
        pMob->attacks[i]->dam2     = atoi( arg2 );

        return;
    }

    if ( !str_cmp( arg1, "proc" ) )
    {
        TRIGGER_DATA *pTrig;
        SCRIPT_DATA *proc;

        if ( !str_cmp( arg2, "kill" ) )
        {
            TRIGGER_DATA *pNext;

            for ( pTrig = pMob->triggers; pTrig != NULL;  )
            {
                pNext     = pTrig->next;
                free_trigger( pTrig );
                pTrig = pNext;
            }

            pMob->triggers = NULL;

            send_to_char( "Procs cleared.\n\r", ch );
            return;
        }

        if ( (proc = get_script_index(atoi(arg2))) == NULL )
        {
            send_to_char( "Syntax:  proc [vnum]\n\r", ch );
            return;
        }

        pTrig            = new_trigger();
        pTrig->script    = proc;

        pTrig->next    = pMob->triggers;
        pMob->triggers = pTrig;

        send_to_char( "Proc set.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg1, "money" ) )
    {
        if ( arg2[0] == '\0' || !is_number( arg2 ) )
        {
            send_to_char( "Syntax:  money [amount in copper]\n\r", ch );
            return;
        }

        pMob->money = atoi( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Monetary amount set.\n\r", ch);
        return;
    }
    

    if ( !str_cmp( arg1, "create" ) )
    {
        value = atoi( argument );
        if ( argument[0] == '\0' || value == 0 )
        {
            send_to_char( "Syntax:  medit create [vnum]\n\r", ch );
            return;
        }

        pArea = get_vnum_area( value );

        if ( pArea == NULL )
        {
            send_to_char( "MEdit:  That vnum is not assigned an area.\n\r", ch );
            return;
        }

        if ( !IS_BUILDER( ch, pArea ) )
        {
            send_to_char( "MEdit:  Vnum in an area you cannot build in.\n\r", ch );
            return;
        }

        if ( get_mob_index( value ) != NULL )
        {
            send_to_char( "MEdit:  Mobile vnum already exists.\n\r", ch );
            return;
        }

        pMob                    = new_mob_index();
        pMob->vnum              = value;
        pMob->area              = pArea;
        
        if ( value > top_vnum_mob ) top_vnum_mob = value;        

        pMob->act               = ACT_IS_NPC;
        iHash                   = value % MAX_KEY_HASH;
        pMob->next              = mob_index_hash[iHash];
        mob_index_hash[iHash]   = pMob;
        ch->desc->pEdit = (void *)pMob;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Mobile Created.\n\r", ch );
        return;
    }


    interpret( ch, arg );
    return;
}


void sedit( CHAR_DATA *ch, char *argument )
{
    AREA_DATA *pArea;
    SCRIPT_DATA *proc;
    char arg[MAX_STRING_LENGTH];
    char arg1[MAX_STRING_LENGTH];
    char arg2[MAX_STRING_LENGTH];
    char buf[MAX_STRING_LENGTH];
    int  value;
    int  iHash;

    strcpy( arg, argument );
    smash_tilde( argument );
    argument = one_argument( argument, arg1 );
    strcpy( arg2, argument );
    value = atoi( arg2 );

    proc = (SCRIPT_DATA *)ch->desc->pEdit;
    pArea = proc->area;
 
    if ( !IS_BUILDER( ch, pArea ) )
    {
         send_to_char( "SEdit:  Insufficient security to modify script.\n\r", ch );
    }

    /*
     * Set this script as your trace.
     */
    if ( !str_cmp( arg1, "trace" ) && !IS_NPC(ch) )
    {
        if ( ch->pcdata->trace != NULL )
        {
            send_to_char( "Trace deactivated.\n\r", ch );
            ch->pcdata->trace = NULL;
            ch->pcdata->trace_wait = 0;
        }
        else
        {
            send_to_char( "Trace activated.\n\r", ch );
            ch->pcdata->trace = proc;
            ch->pcdata->trace_wait = value;
        }

        return;
    }

    if ( !str_cmp( arg1, "show" ) )
    {
        sprintf( buf, "%d %s", proc->vnum, arg2 );
        do_sindex( ch, buf );
        return;
    }


    if ( !str_cmp( arg1, "done" ) )
    {
        ch->desc->pEdit = NULL;
        ch->desc->connected = CON_PLAYING;
        return;
    }

    if ( !str_cmp( arg1, "?" ) )
    {
        do_help( ch, "SEDIT" );
        return;
    }

    if ( !IS_BUILDER( ch, pArea ) )
    {
        interpret( ch, arg );
        return;
    }

    if ( !str_cmp( arg1, "name" ) )
    {
        if ( arg2[0] == '\0' )
        {
            send_to_char( "Syntax:  name [string]\n\r", ch );
            return;
        }

        free_string( proc->name );
        proc->name = str_dup( arg2 );

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Name set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "proc" ) || !str_cmp( arg1, "cmd" ) )
    {
        string_append( ch, &proc->commands );
        SET_BIT( pArea->area_flags, AREA_CHANGED );
        return;
    }

    if ( (value = get_proc_type( arg1 )) != -1  )
    {
        proc->type  = value;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Type set.\n\r", ch);
        return;
    }

    if ( !str_cmp( arg1, "create" ) )
    {
        value = atoi( argument );
        if ( argument[0] == '\0' || value == 0 )
        {
            send_to_char( "Syntax:  sedit create [vnum]\n\r", ch );
            return;
        }

        pArea = get_vnum_area( value );

        if ( pArea == NULL )
        {
            send_to_char( "SEdit:  That vnum is not assigned an area.\n\r", ch );
            return;
        }

        if ( !IS_BUILDER( ch, pArea ) )
        {
            send_to_char( "SEdit:  Vnum in an area you cannot build in.\n\r", ch );
            return;
        }

        if ( get_script_index( value ) != NULL )
        {
            send_to_char( "SEdit:  Script vnum already exists.\n\r", ch );
            return;
        }

        proc                    = new_script();
        proc->vnum              = value;
        proc->area              = pArea;
        
        if ( value > top_vnum_script ) top_vnum_script = value;

        iHash                      = value % MAX_KEY_HASH;
        proc->next                 = script_index_hash[iHash];
        script_index_hash[iHash]   = proc;
        ch->desc->pEdit = (void *)proc;

        SET_BIT( pArea->area_flags, AREA_CHANGED );
        send_to_char( "Script Created.\n\r", ch );
        return;
    }


    interpret( ch, arg );
    return;
}



/*
 * Syntax: aedit [num]
 *         aedit create [vnum]
 */
void do_aedit( CHAR_DATA *ch, char *argument )
{
    AREA_DATA *pArea;
    int value;

    if ( IS_NPC(ch) ) return;

    pArea = ch->in_room->area;

    if ( is_number( argument ) )
    {
        value = atoi( argument );
        if ( ( pArea = get_area_data( value ) ) == NULL )
        {
            send_to_char( "That area vnum does not exist.\n\r", ch );
            return;
        }
    }
    else
    {
        if ( !str_cmp( argument, "create" ) )
        {
            pArea               =   new_area();
            area_last->next     =   pArea;
            area_last           =   pArea;
            SET_BIT( pArea->area_flags, AREA_ADDED );
        }
    }

    ch->desc->pEdit = (void *)pArea;
    ch->desc->connected = CON_AEDITOR;
    return;
}



/*
 * Syntax:  redit
 *          redit [vnum]
 *          redit reset
 *          redit create [vnum]
 */
void do_redit( CHAR_DATA *ch, char *argument )
{
    ROOM_INDEX_DATA *pRoom;
    AREA_DATA *pArea;
    int value;
    int iHash;
    char arg1[MAX_STRING_LENGTH];

    if ( IS_NPC(ch) ) return;
    argument = one_argument( argument, arg1 );

    pRoom = ch->in_room;

    if ( is_number( arg1 ) )
    {
        value = atoi( arg1 );
        if ( ( pRoom = get_room_index( value ) ) == NULL )
        {
            send_to_char( "REdit:  That vnum does not exist.\n\r", ch );
            return;
        }
    }
    else
    {
        if ( !str_cmp( arg1, "reset" ) )
        {
            reset_room( pRoom );
            send_to_char( "Room reset.\n\r", ch );
            return;
        }
        else
        if ( !str_cmp( arg1, "create" ) )
        {
            value = atoi( argument );
            if ( argument[0] == '\0' || value == 0 )
            {
                send_to_char( "Syntax:  redit create [vnum]\n\r", ch );
                return;
            }

            pArea = get_vnum_area( value );

            if ( pArea == NULL )
            {
                send_to_char( "REdit:  That vnum is not assigned an area.\n\r", ch );
                return;
            }

            if ( !IS_BUILDER( ch, pArea ) )
            {
                send_to_char( "REdit:  Vnum in an area you cannot build in.\n\r", ch );
                return;
            }

            if ( get_room_index( value ) != NULL )
            {
                send_to_char( "REdit:  Room vnum already exists.\n\r", ch );
                return;
            }

            pRoom                   = new_room_index();
            pRoom->area             = pArea;
            pRoom->vnum             = value;
            
            if ( value > top_vnum_room ) top_vnum_room = value;
        
            iHash                   = value % MAX_KEY_HASH;
            pRoom->next             = room_index_hash[iHash];
            room_index_hash[iHash]  = pRoom;

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            char_from_room( ch );
            char_to_room( ch, pRoom );
        }
    }

    ch->desc->connected = CON_REDITOR;
    return;
}




/*
 * Syntax:  oedit [vnum]
 *          oedit create [vnum]
 */
void do_oedit( CHAR_DATA *ch, char *argument )
{
    OBJ_INDEX_DATA *pObj;
    AREA_DATA *pArea;
    int value;
    int iHash;
    char arg1[MAX_STRING_LENGTH];

    if ( IS_NPC(ch) ) return;
    argument = one_argument( argument, arg1 );

    if ( is_number( arg1 ) )
    {
        value = atoi( arg1 );
        if ( ( pObj = get_obj_index( value ) ) == NULL )
        {
            send_to_char( "OEdit:  That vnum does not exist.\n\r", ch );
            return;
        }

        ch->desc->pEdit = (void *)pObj;
        ch->desc->connected = CON_OEDITOR;
        return;
    }
    else
    {
        if ( !str_cmp( arg1, "create" ) )
        {
            value = atoi( argument );
            if ( argument[0] == '\0' || value == 0 )
            {
                send_to_char( "Syntax:  oedit create [vnum]\n\r", ch );
                return;
            }

            pArea = get_vnum_area( value );

            if ( pArea == NULL )
            {
                send_to_char( "OEdit:  That vnum is not assigned an area.\n\r", ch );
                return;
            }

            if ( !IS_BUILDER( ch, pArea ) )
            {
                send_to_char( "OEdit:  Vnum in an area you cannot build in.\n\r", ch );
                return;
            }

            if ( get_obj_index( value ) != NULL )
            {
                send_to_char( "OEdit:  Object vnum already exists.\n\r", ch );
                return;
            }

            pObj                    = new_obj_index();
            pObj->vnum              = value;
            pObj->area             = pArea;
            
            if ( value > top_vnum_obj ) top_vnum_obj = value;
        
            iHash                   = value % MAX_KEY_HASH;
            pObj->next              = obj_index_hash[iHash];
            obj_index_hash[iHash]   = pObj;
            ch->desc->pEdit = (void *)pObj;

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            ch->desc->connected = CON_OEDITOR;
            return;
        }
    }

    send_to_char( "OEdit:  There is no default object to edit.\n\r", ch );
    return;
}




/*
 * Syntax:  medit [vnum]
 *          medit create [vnum]
 */
void do_medit( CHAR_DATA *ch, char *argument )
{
    MOB_INDEX_DATA *pMob;
    AREA_DATA *pArea;
    int value;
    int iHash;
    char arg1[MAX_STRING_LENGTH];

    if ( IS_NPC(ch) ) return;
    argument = one_argument( argument, arg1 );

    if ( is_number( arg1 ) )
    {
        value = atoi( arg1 );
        if ( ( pMob = get_mob_index( value ) ) == NULL )
        {
            send_to_char( "MEdit:  That vnum does not exist.\n\r", ch );
            return;
        }

        ch->desc->pEdit = (void *)pMob;
        ch->desc->connected = CON_MEDITOR;
        return;
    }
    else
    {
        if ( !str_cmp( arg1, "create" ) )
        {
            value = atoi( argument );
            if ( argument[0] == '\0' || value == 0 )
            {
                send_to_char( "Syntax:  medit create [vnum]\n\r", ch );
                return;
            }

            pArea = get_vnum_area( value );

            if ( pArea == NULL )
            {
                send_to_char( "OEdit:  That vnum is not assigned an area.\n\r", ch );
                return;
            }

            if ( !IS_BUILDER( ch, pArea ) )
            {
                send_to_char( "OEdit:  Vnum in an area you cannot build in.\n\r", ch );
                return;
            }

            if ( get_mob_index( value ) != NULL )
            {
                send_to_char( "OEdit:  Mobile vnum already exists.\n\r", ch );
                return;
            }

            pMob                    = new_mob_index();
            pMob->vnum              = value;
            pMob->area              = pArea;
            pMob->act               = ACT_IS_NPC;
            
            if ( value > top_vnum_mob ) top_vnum_mob = value;

            iHash                   = value % MAX_KEY_HASH;
            pMob->next              = mob_index_hash[iHash];
            mob_index_hash[iHash]   = pMob;
            ch->desc->pEdit = (void *)pMob;

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            ch->desc->connected = CON_MEDITOR;
            return;
        }
    }

    send_to_char( "MEdit:  There is no default mobile to edit.\n\r", ch );
    return;
}



/*
 * Syntax:  sedit [vnum]
 *          sedit create [vnum]
 */
void do_sedit( CHAR_DATA *ch, char *argument )
{
    SCRIPT_DATA *proc;
    AREA_DATA *pArea;
    int value;
    int iHash;
    char arg1[MAX_STRING_LENGTH];

    if ( IS_NPC(ch) ) return;
    argument = one_argument( argument, arg1 );

    if ( is_number( arg1 ) )
    {
        value = atoi( arg1 );
        if ( ( proc = get_script_index( value ) ) == NULL )
        {
            send_to_char( "SEdit:  That vnum does not exist.\n\r", ch );
            return;
        }

        ch->desc->pEdit = (void *)proc;
        ch->desc->connected = CON_SEDITOR;
        return;
    }
    else
    {
        if ( !str_cmp( arg1, "create" ) )
        {
            value = atoi( argument );
            if ( argument[0] == '\0' || value == 0 )
            {
                send_to_char( "Syntax:  sedit create [vnum]\n\r", ch );
                return;
            }

            pArea = get_vnum_area( value );

            if ( pArea == NULL )
            {
                send_to_char( "SEdit:  That vnum is not assigned an area.\n\r", ch );
                return;
            }

            if ( !IS_BUILDER( ch, pArea ) )
            {
                send_to_char( "SEdit:  Vnum in an area you cannot build in.\n\r", ch );
                return;
            }

            if ( get_script_index( value ) != NULL )
            {
                send_to_char( "SEdit:  Script vnum already exists.\n\r", ch );
                return;
            }

            proc                    = new_script();
            proc->vnum              = value;
            proc->area              = pArea;
            
            if ( value > top_vnum_script ) top_vnum_script = value;

            iHash                    = value % MAX_KEY_HASH;
            proc->next               = script_index_hash[iHash];
            script_index_hash[iHash] = proc;
            ch->desc->pEdit          = (void *)proc;

            SET_BIT( pArea->area_flags, AREA_CHANGED );
            ch->desc->connected = CON_SEDITOR;
            return;
        }
    }

    send_to_char( "SEdit:  There is no default script to edit.\n\r", ch );
    return;
}



/*
 * Syntax:  mindex [vnum]
 */
void do_mindex( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    MOB_INDEX_DATA *victim;
    TRIGGER_DATA *pTrig;
    int iAtt;

    argument = one_argument( argument, arg );
    argument = one_argument( argument, arg2 );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Mindex whom?\n\r", ch );
        return;
    }

    if ( ( victim = get_mob_index( atoi( arg ) ) ) == NULL )
    {
    send_to_char( "Invalid mob index VNUM.\n\r", ch );
        return;
    }

    sprintf( buf, "Name:   [%s]\n\r", victim->name );
    send_to_char( buf, ch );

    sprintf( buf, "Area:   [%5d] %s\n\r",
    victim->area == NULL ? -1        : victim->area->vnum,
    victim->area == NULL ? "No Area" : victim->area->name );
    send_to_char( buf, ch );

    if ( !str_cmp( arg2, "skills" )  )
    {
        for ( iAtt = 0; iAtt < MAX_SKILL; iAtt++ )
        {
            if ( skill_table[iAtt].name == NULL )
            break;
            if ( victim->learned[iAtt] > 0 )
            {
                sprintf( buf, "Skill: %s at %d%%\n\r", skill_table[iAtt].name,
                              victim->learned[iAtt] );
                send_to_char( buf, ch );
            }
        }
        return;
    }

    sprintf( buf, "Short:  [%s]\n\rLong:\n\r%s",
    victim->short_descr,
    victim->long_descr );
    send_to_char( buf, ch );

    sprintf( buf, "Act:    [%s]\n\r", act_bit_name( victim->act ) );
    send_to_char( buf, ch );

    sprintf( buf, "Affect: [%s]\n\r",
                  affect_bit_name( victim->affected_by ) );
    send_to_char( buf, ch );

    sprintf( buf, "Vnm: [%5d] Sz: [%3d]  Race: [%s]  Sex: [%s]\n\r",
        victim->vnum,
        victim->size,
        race_table[victim->race].race_name,
        victim->sex == SEX_MALE    ? "male"   :
        victim->sex == SEX_FEMALE  ? "female" : "neutral" );
    send_to_char( buf, ch );

    sprintf( buf, "Money:  [%5d]  ", victim->money );
    send_to_char( buf, ch );

    sprintf( buf, "Str: [%2d]  Int: [%2d]  Wis: [%2d]  Dex: [%2d]  Con: [%2d]\n\r",
        victim->perm_str,
        victim->perm_int,
        victim->perm_wis,
        victim->perm_dex,
        victim->perm_con );
    send_to_char( buf, ch );

    sprintf( buf, "Description:\n\r%s", victim->description );
    send_to_char( buf, ch );

    for ( iAtt = 0; iAtt < MAX_ATTACK_DATA; iAtt++ )
    {
        if ( victim->attacks[iAtt] != NULL )
        {
            sprintf( buf, "[%d] %ss for [%d] to [%d] damage.\n\r", iAtt,
                          attack_table[victim->attacks[iAtt]->idx].name,
                          victim->attacks[iAtt]->dam1,
                          victim->attacks[iAtt]->dam2 );
            buf[0] = UPPER(buf[0]);
            send_to_char( buf, ch );
        }
    }


    for ( pTrig = victim->triggers; pTrig != NULL; pTrig = pTrig->next )
    {
        sprintf( buf, "[%5d] %s\n\r", pTrig->script->vnum, pTrig->script->name );
        send_to_char( buf, ch );
    }


    if ( victim->pShop != NULL )
    {
        SHOP_DATA *pShop;
        int iTrade;

        pShop = victim->pShop;

        sprintf( buf, "Shop data (for %d):\n\r    Will buy at %d%%, and sell at %d%%.  Opened %d-%d.\n\r",
                      pShop->keeper, pShop->profit_buy, pShop->profit_sell,
                      pShop->open_hour, pShop->close_hour );
        send_to_char( buf, ch );

        sprintf( buf, "    Flags: [%s]\n\r", shop_bit_name(pShop->shop_flags) );
        send_to_char( buf, ch );

        if ( IS_SET(pShop->shop_flags, SHOP_REPAIR) )
        {
        sprintf( buf, "    Repair Rate: [%5d]\n\r", pShop->repair_rate );
        send_to_char( buf, ch );
        }

        sprintf( buf, "Buy Index: %d   Sell Index:  %d   Component Index:  %d",
                 pShop->buy_index, pShop->sell_index, pShop->comp_index );
        send_to_char( buf, ch );

        if ( IS_SET(pShop->shop_flags, SHOP_PEDDLER)
          || IS_SET(pShop->shop_flags, SHOP_TRADER) )
        {
            if ( IS_SET(pShop->shop_flags, SHOP_PEDDLER) )
            sprintf( buf, " [##] Type %-24s", " " );
            else
            sprintf( buf, "%-35s", " " );
            send_to_char( buf, ch );

            if ( IS_SET(pShop->shop_flags, SHOP_TRADER) )
            {
            sprintf( buf, "  [##] %15s %6s %6s",
                          "Trading Item", "Bought", "Sold" );
            send_to_char( buf, ch );
            }

            send_to_char( "\n\r", ch );

            for ( iTrade = 0;
                  iTrade < UMAX(MAX_TRADE,
                     IS_SET(pShop->shop_flags,SHOP_TRADER) ? 10 : MAX_TRADE);
                  iTrade++ )
            {
                char buf2[MAX_STRING_LENGTH];
                bool fNothing = TRUE;

                if ( iTrade < MAX_TRADE
                  && IS_SET(pShop->shop_flags, SHOP_PEDDLER)
                  && pShop->buy_type[iTrade] != ITEM_NONE )
                {
                    sprintf( buf, " [%2d] Peddles %ss",  iTrade+1,
                             item_type_name( pShop->buy_type[iTrade] ) );
                    fNothing = FALSE;
                }
                else
                buf[0] = '\0';
                
                sprintf( buf2, "%-35s", buf );
                if ( !fNothing 
                  || (iTrade < 10 
                   && IS_SET(pShop->shop_flags, SHOP_TRADER)) )
                send_to_char( buf2, ch );

                if ( iTrade < 10
                  && IS_SET(pShop->shop_flags, SHOP_TRADER) )
                {
                    sprintf( buf, "  [%2d] %15s",
                                  iTrade+1,
                                  name_good_code(iTrade) );
                    send_to_char( buf, ch );
                    fNothing = FALSE;
                }

                if ( !fNothing ) send_to_char( "\n\r", ch );
            }
        }


        sprintf( buf, "Str1 [no_such_item]:\n\r%s says, \"%s\"\n\r",
                      capitalize(victim->short_descr), pShop->no_such_item );
        send_to_char( buf, ch );

        if ( IS_SET(pShop->shop_flags, SHOP_PEDDLER)
          || IS_SET(pShop->shop_flags, SHOP_TRADER) )
        {
            sprintf( buf, "Str2 [do_not_buy]:\n\r%s says, \"%s\"\n\r",
                           capitalize(victim->short_descr), pShop->do_not_buy );
            send_to_char( buf, ch );
        }

        if ( IS_SET(pShop->shop_flags, SHOP_PEDDLER) )
        {
            sprintf( buf, "Str3 [list_header]:\n\r%s\n\r",
                     pShop->list_header );
            send_to_char( buf, ch );
        }
    }

    return;
}




/*
 * Syntax:  sindex [vnum]
 */
void do_sindex( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    SCRIPT_DATA *proc;

    argument = one_argument( argument, arg );
    argument = one_argument( argument, arg2 );

    if ( arg[0] == '\0' )
    {
        send_to_char( "Sindex what?\n\r", ch );
        return;
    }

    if ( ( proc = get_script_index( atoi( arg ) ) ) == NULL )
    {
        send_to_char( "Invalid script index VNUM.\n\r", ch );
        return;
    }

    sprintf( buf, "Vnum:   [%5d]  Name:   [%s]\n\r", proc->vnum, proc->name );
    send_to_char( buf, ch );

    sprintf( buf, "Area:   [%5d] %s\n\r",
             proc->area == NULL ? -1        : proc->area->vnum,
             proc->area == NULL ? "No Area" : proc->area->name );
    send_to_char( buf, ch );

    sprintf( buf, "Type: %s\n\r", show_proc_type( proc->type ) );
    send_to_char( buf, ch );

    sprintf( buf, "Proc:\n\r%s", proc->commands );
    send_to_char( buf, ch );

    return;
}




void value_breakdown( int type, int v1, int v2, int v3, int v4, CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];

    switch ( type )
    {
          default: send_to_char( "Values currently unused.\n\r", ch ); break;
  case ITEM_LIGHT:
        {
            if ( v2 >= 0 )
            {
                sprintf( buf, "%d of %d hours of light.\n\r", v1, v2 );
                send_to_char( buf, ch );
            }
            else
            send_to_char( "Provides light infinitely.\n\r", ch );

            sprintf( buf, "Light bits: [%s%s]\n\r",
                          IS_SET(v4, LIGHT_LIT) ? "lit " : "",
                          IS_SET(v4, LIGHT_FILLABLE) ? "fillable" : "" );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_SCROLL:
  case ITEM_POTION:
  case ITEM_FOUNTAIN:
  case ITEM_PILL:
  case ITEM_THROWN:
        {
            sprintf( buf, "Casts %s, %s and %s at level %d.\n\r",
                     v2 > 0 ? skill_table[v2].name : "nothing",
                     v3 > 0 ? skill_table[v3].name : "nothing",
                     v4 > 0 ? skill_table[v4].name : "nothing",
                     v1 );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_WAND:
  case ITEM_STAFF:
        {
            sprintf( buf, "Has %d/%d charges of spell %s at level %d.\n\r",
                     v2, v3,
                     v4 > 0 ? skill_table[v4].name : "nothing",
                     v1 );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_WEAPON:
        {
            sprintf( buf, "Damages from %d-%d (average %d) of type %s%s.\n\r",
                     UMIN(v2,v3),
                     UMAX(v2,v3),
                     (UMIN(v2,v3)+UMAX(v2,v3))/2,
                     v4 >= 0 && v4 < MAX_ATTACK ? attack_table[v4].name : "INVALID",
                     v1 ? " and causes poison" : "" );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_RANGED_WEAPON:
  case ITEM_AMMO:
        {
            send_to_char( "Unimplemented yet.\n\r", ch );
        }
        break;
  case ITEM_ARMOR:
        {
            sprintf( buf, "Can be hit %d/%d times, with an armor class bonus of %d.\n\r",
                     v2, v3, v1 );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_FURNITURE:
        {
            sprintf( buf, "Can maintain up to %d halfstones (%d people)",
                     v1, v1/100 );
            send_to_char( buf, ch );

            if ( get_obj_index( v3 ) != NULL )
            {
                sprintf( buf, ", requires key %d", v3 );
                send_to_char( buf, ch );
            }

            if ( get_room_index( v4 ) != NULL )
            {
                sprintf( buf, ", and leads to %d", v4 );
                send_to_char( buf, ch );
            }

            send_to_char( ".\n\r", ch );

            sprintf( buf, "Furn bits: [%s%s%s%s%s%s%s%s%s%s%s]\n\r",
                     IS_SET(v2,FURN_CLOSEABLE) ? "closeable " : "",
                     IS_SET(v2,FURN_PICKPROOF) ? "pickproof " : "",
                     IS_SET(v2,FURN_CLOSED)    ? "closed "    : "",
                     IS_SET(v2,FURN_LOCKED)    ? "locked "    : "",
                     IS_SET(v2,FURN_NOMOUNT)   ? "nomount "   : "",
                     IS_SET(v2,FURN_SIT)       ? "sit "       : "",
                     IS_SET(v2,FURN_SLEEP)     ? "sleep "     : "",
                     IS_SET(v2,FURN_EXIT)      ? "exit "      : "",
                     IS_SET(v2,FURN_PUT)       ? "put "       : "",
                     IS_SET(v2,FURN_MOVE)      ? "move"       : "",
                     IS_SET(v2,FURN_NOSHOW)    ? "noshow"     : "" );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_CONTAINER:
        {
            sprintf( buf, "Holds up to %d halfstones of weight", v1 );
            send_to_char( buf, ch );

            if ( get_obj_index( v3 ) != NULL )
            {
                sprintf( buf, ", and requires key %d", v3 );
                send_to_char( buf, ch );
            }

            send_to_char( ".\n\r", ch );

            sprintf( buf, "Container bits: [%s%s%s%s]\n\r",
                     IS_SET(v2,CONT_CLOSEABLE) ? "closeable " : "",
                     IS_SET(v2,CONT_PICKPROOF) ? "pickproof " : "",
                     IS_SET(v2,CONT_CLOSED)    ? "closed "    : "",
                     IS_SET(v2,CONT_LOCKED)    ? "locked"    : "" );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_DRINK_CON:
        {
            sprintf( buf, "Contains %d/%d (about %d-%d drinks (halfswils)) of %s%s.\n\r",
                     v1, v2, v1/10, v1/3,
                     v3 >= 0 && v3 < LIQ_MAX ? liq_table[v3].liq_name : "INVALID LIQUID",
                     IS_SET(v4,DRINK_POISON) ? " and is laced with poison" : "" );
            send_to_char( buf, ch );
            if ( IS_SET(v4,DRINK_TAVERN) )
            send_to_char( "This drink container disappears when empty.\n\r", ch );
        }
        break;
  case ITEM_FOOD:
        {
            sprintf( buf, "Food lasts for %d minutes (%d game hours).\n\r",
                     v1, v1 / 5 );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_MONEY:
        {
            sprintf( buf, "Worth %d %s coins.\n\r",
                     v1, v2 >= 0 && v2 < MAX_COIN ? coin_table[v2].long_name : "invalid" );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_GEM:
        {
            sprintf( buf, "Provides %d/%d mana for %s%s%s%s elements.",
                     v2, v3,
                     IS_SET(v1,MA) || IS_SET(v1,ME) ? "earth " : "",
                     IS_SET(v1,MA) || IS_SET(v1,MF) ? "fire "  : "",
                     IS_SET(v1,MA) || IS_SET(v1,MW) ? "water " : "",
                     IS_SET(v1,MA) || IS_SET(v1,MA) ? "air"   : "" );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_VEHICLE:
        {
            sprintf( buf, "Provides access to %s, %s, %s and %s.\n\r",
                     sector_name( v1 ),
                     sector_name( v2 ),
                     sector_name( v3 ),
                     sector_name( v4 ) );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_TOOL:
        {
            sprintf( buf, "Has %d of %d uses remaining.\n\r",
                     v2, v3 );
            send_to_char( buf, ch );

            sprintf( buf, "Tool flags: [%s%s%s]\n\r",
                     IS_SET(v1,TOOL_TINDERBOX) ? "tinderbox " : "",
                     IS_SET(v1,TOOL_LOCKPICK)  ? "lockpick "  : "",
                     IS_SET(v1,TOOL_BOUNTY)    ? "bounty"    : "" );
            send_to_char( buf, ch );
        }
        break;
  case ITEM_BOARD:
  case ITEM_COMPONENT:
  case ITEM_GOODS:
        {
            sprintf( buf, "Has %s index of %d.\n\r", item_type_name(type), v1 );
            send_to_char( buf, ch );
        }
        break;
    }

    return;
}





/*
 * Syntax:  oindex [vnum]
 */
void do_oindex( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA *paf;
    OBJ_INDEX_DATA *obj;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Oindex what?\n\r", ch );
        return;
    }

    if ( ( obj = get_obj_index( atoi( arg ) ) ) == NULL )
    {
    send_to_char( "Invalid VNUM reference.\n\r", ch );
        return;
    }

    sprintf( buf, "Name:   [%s]\n\rArea:   [%5d] %s\n\r",
    obj->name,
    obj->area == NULL ? -1        : obj->area->vnum,
    obj->area == NULL ? "No Area" : obj->area->name );
    send_to_char( buf, ch );


    sprintf( buf, "Vnum:   [%5d]     Type:  [%s]\n\r",
    obj->vnum,
    item_type_name( obj->item_type ) );
    send_to_char( buf, ch );

    sprintf( buf, "Short:  [%s]\n\r", obj->short_descr );
    send_to_char( buf, ch );

    sprintf( buf, "Plural: [%s]\n\r", pluralize( obj->short_descr ) );
    send_to_char( buf, ch );

    {
        char buf2[MAX_STRING_LENGTH];
        sprintf( buf, "Long:\n\r%s", obj->description );
        send_to_char( buf, ch );
        
        sprintf( buf2, "%s %s are here.\n\r", numberize( 2 ), pluralize( obj->short_descr ) );
        sprintf( buf, "Plural:\n\r%s",
             obj->description_plural == NULL
          || obj->description_plural[0] == '\0' ? capitalize(buf2)
                                                : obj->description_plural );
        send_to_char( buf, ch );
    }
  
    sprintf( buf, "Action:\n\r%s", obj->action_descr );
    send_to_char( buf, ch );

    sprintf( buf, "Description:\n\r%s", obj->real_description );
    send_to_char( buf, ch );

    sprintf( buf, "Wear flags:  [%s]\n\rExtra flags: [%s]\n\r",
    wear_bit_name( obj->wear_flags ),
    extra_bit_name( obj->extra_flags ) );
    send_to_char( buf, ch );

    sprintf( buf, "Weight: [%5d]  Cost:     [%5d]  Timer: [%5d]  Level: [%5d]\n\r",
             obj->weight, obj->cost, obj->timer, obj->level );
    send_to_char( buf, ch );

    sprintf( buf, "Size:   [%5d]  Material: [%5d]\n\r",
             obj->size, obj->material );
    send_to_char( buf, ch );

    sprintf( buf, "Values: [%5d] [%5d] [%5d] [%5d]\n\r",
    obj->value[0],    obj->value[1],    obj->value[2],    obj->value[3] );
    send_to_char( buf, ch );

    value_breakdown( obj->item_type,
                     obj->value[0],
                     obj->value[1],
                     obj->value[2],
                     obj->value[3],
                     ch );

    if ( obj->extra_descr != NULL )
    {
        EXTRA_DESCR_DATA *ed;

        send_to_char( "ED keywords: [", ch );

        for ( ed = obj->extra_descr; ed != NULL; ed = ed->next )
        {
        char arg[MAX_STRING_LENGTH];
        
        one_argument( ed->keyword, arg );
        send_to_char( arg, ch );
        if ( ed->next != NULL ) send_to_char( " ", ch );
        }
  
        send_to_char( "]\n\r", ch );
    }

    for ( paf = obj->affected; paf != NULL; paf = paf->next )
    {
       sprintf( buf, "Affects %s by %d.\n\r", affect_loc_name( paf->location ),
                                              paf->modifier );
       send_to_char( buf, ch );
    }

    return;
}


void display_resets( CHAR_DATA *ch )
{
    char final[MAX_STRING_LENGTH];
    char buf[MAX_STRING_LENGTH];
    ROOM_INDEX_DATA *pRoom = ch->in_room;
    RESET_DATA *pReset;
    MOB_INDEX_DATA        *pMob = NULL;
    MOB_INDEX_DATA     *LastMob = NULL;
    OBJ_INDEX_DATA         *obj = NULL;
    OBJ_INDEX_DATA     *LastObj = NULL;
    MOB_INDEX_DATA *pMobIndex;
    OBJ_INDEX_DATA *pObjIndex;
    bool last;
    int iReset = 0;
    int olevel = 2;

    if ( pRoom == NULL ) return;

    pMob    = NULL;
    last    = TRUE;
    final[0]  = '\0';
    

    for ( pReset = pRoom->reset_first; pReset != NULL; pReset = pReset->next )
    {

    send_to_char( final, ch );
    final[0] = '\0';
    sprintf( final, "%2d- ", ++iReset );

        switch ( pReset->command )
        {
        default:
        strcat( final, "Invalid Reset Command\n\r" );
            break;

    case 'M':

        if ( ( pMobIndex = get_mob_index( pReset->rs_vnum ) ) == NULL )
            {
            sprintf( buf, "Load Mobile - Bad Vnum %d\n\r", pReset->rs_vnum );
            strcat( final, buf );
            continue;
            }

        pMob = pMobIndex;
        sprintf( buf, "Loads %s (%d) in room (max %d, %d%% chance) %d times\n\r",
                       pMob->short_descr, pReset->rs_vnum,
                       pReset->loc, pReset->percent, pReset->num );
        strcat( final, buf );

        LastObj = NULL;
        LastMob = pMob;
        olevel  = 1;
            break;

        case 'O':
        if ( ( pObjIndex = get_obj_index( pReset->rs_vnum ) ) == NULL )
            {
            sprintf( buf, "Load Object - Bad Vnum %d\n\r", pReset->rs_vnum );
            strcat( final, buf );
            continue;
            }

        obj       = pObjIndex;

        if ( pReset->loc == RESET_LOC_INOBJ && LastObj != NULL )
        {
            sprintf( buf, " Loads %s (%d) inside %s", obj->short_descr,
                          pReset->rs_vnum,
                          LastObj ? LastObj->short_descr : "!NO OBJ!" );
            strcat( final, buf );
        }
   else if ( pReset->loc == RESET_LOC_ONOBJ && LastObj != NULL )
        {
            sprintf( buf, " Loads %s (%d) on top of %s",
                          obj->short_descr, pReset->rs_vnum,
                          LastObj ? LastObj->short_descr : "!NO OBJ!" );
            strcat( final, buf );
        }
   else if ( pReset->loc == RESET_LOC_INROOM )
        {
            sprintf( buf, "Loads %s (%d) in room",
                          obj->short_descr, pReset->rs_vnum );
            strcat( final, buf );
            LastObj = obj;
        }
   else if ( LastMob != NULL )
        {
            sprintf( buf, " Loads %s (%d) on %s of %s",
                          obj->short_descr, pReset->rs_vnum,
                          wear_loc_name( pReset->loc ),
                          LastMob ? LastMob->short_descr : "!NO MOB!" );
            strcat( final, buf );
        }
        else strcat( final, "Incorrect Assignment of Object\n\r" );

        if ( !strstr( final, "Incorrect" ) && !strstr( final, "Drop" ) )
        {
            sprintf( buf, " %d%% chance %d times\n\r", pReset->percent,
                                                        pReset->num );
            strcat( final, buf );
        }

        if ( LastObj == NULL || obj->item_type == ITEM_CONTAINER )
                LastObj = obj;
        break;

        }
    }
    send_to_char( final, ch );
    final[0] = '\0';

    return;
}



void add_reset( ROOM_INDEX_DATA *room, RESET_DATA *pReset, int index )
{
    RESET_DATA *reset;
    int iReset = 0;

    SET_BIT( room->area->area_flags, AREA_CHANGED );

    if ( room->reset_first == NULL )
    {
        room->reset_first = pReset;
        room->reset_last  = pReset;
        pReset->next      = NULL;
        return;
    }

    index--;

    if ( index == 0 )
    {
        pReset->next = room->reset_first;
        room->reset_first = pReset;
        return;
    }

    for ( reset = room->reset_first; reset->next != NULL; reset = reset->next )
    {
        if ( ++iReset == index ) break;
    }

    pReset->next = reset->next;
    reset->next  = pReset;
    if ( pReset->next == NULL ) room->reset_last = pReset;
    return;
}
 


/*
 * Syntax:  resets [num] obj [vnum] [location] [chance] [times]
 *          resets [num] mob [vnum] [location] [chance] [times]
 *          resets [num] delete
 */
void do_resets( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char arg3[MAX_INPUT_LENGTH];
    char arg4[MAX_INPUT_LENGTH];
    char arg5[MAX_INPUT_LENGTH];
    char arg6[MAX_INPUT_LENGTH];
    RESET_DATA *pReset;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    argument = one_argument( argument, arg3 );
    argument = one_argument( argument, arg4 );
    argument = one_argument( argument, arg5 );
    argument = one_argument( argument, arg6 );

    if ( arg1[0] == '\0' )
    {
        if ( ch->in_room->reset_first != NULL )
        {
        send_to_char( "Resets:\n\r", ch );
        display_resets( ch );
        }
        else
        send_to_char( "No resets in this room.\n\r", ch );
    }

    if ( !IS_BUILDER( ch, ch->in_room->area ) )
    {
        send_to_char( "Resets: Invalid security for editing this room.\n\r",
                      ch );
        return;
    }

    if ( is_number( arg1 ) )
    {
        ROOM_INDEX_DATA *pRoom = ch->in_room;

        if ( !str_cmp( arg2, "delete" ) )
        {
        int insert_loc = atoi( arg1 );

        if ( ch->in_room->reset_first == NULL )
        {
            send_to_char( "No resets in this room.\n\r", ch );
            return;
        }

        if ( insert_loc-1 <= 0 )
        {
            pReset = pRoom->reset_first;
            pRoom->reset_first = pRoom->reset_first->next;
            if ( pRoom->reset_first == NULL )
                 pRoom->reset_last = NULL;
        }
        else
        {
            int iReset = 0;
            RESET_DATA *prev = NULL;

            for ( pReset = pRoom->reset_first; pReset != NULL; pReset = pReset->next )
            {
                if ( ++iReset == insert_loc )   break;
                prev = pReset;
            }

            if ( pReset == NULL )
            {
                send_to_char( "Reset not found.\n\r", ch );
                return;
            }

            if ( prev != NULL )  prev->next = prev->next->next;
                            else pRoom->reset_first = pRoom->reset_first->next;

            for ( pRoom->reset_last = pRoom->reset_first;
                  pRoom->reset_last->next != NULL;
                  pRoom->reset_last = pRoom->reset_last->next );
        }

        SET_BIT( pRoom->area->area_flags, AREA_CHANGED );
        free_reset_data( pReset );
        send_to_char( "Reset deleted.\n\r", ch );
        }
        else
        if ( (!str_cmp( arg2, "mob" ) && is_number( arg3 ))
          || (!str_cmp( arg2, "obj" ) && is_number( arg3 )) )
        {
            pReset = new_reset_data();
            if ( !str_cmp( arg2, "mob" ) )
            {
            pReset->command = 'M';
            pReset->rs_vnum = atoi( arg3 );
            pReset->loc     = is_number( arg4 ) ? atoi( arg4 ) : 1;
            pReset->percent = is_number( arg5 ) ? atoi( arg5 ) : 75;
            }
            else
            if ( !str_cmp( arg2, "obj" ) )
            {
            pReset->command = 'O';
            pReset->rs_vnum = atoi( arg3 );
            if ( !str_cmp( arg4, "inside" ) || !str_cmp( arg4, "in" ) )
                                            pReset->loc     = RESET_LOC_INOBJ;
       else if ( !str_cmp( arg4, "on" ) )   pReset->loc     = RESET_LOC_ONOBJ;
       else if ( !str_cmp( arg4, "room" ) ) pReset->loc     = RESET_LOC_INROOM;
       else pReset->loc     = wear_name_loc( arg4 );
            pReset->percent = is_number( arg5 ) ? atoi( arg5 ) : 75;
            }

            pReset->num     = !is_number(arg6) ? 1 : atoi( arg6 );

            add_reset( ch->in_room, pReset, atoi( arg1 ) );
            send_to_char( "Reset added.\n\r", ch );
        }
        else
        {
        send_to_char( "Syntax: RESET <number> OBJ <vnum> <location> [chance] [num to load]\n\r", ch );
        send_to_char( "        RESET <number> MOB <vnum> [<max #> <chance> <num to load>]\n\r", ch );
        send_to_char( "        RESET <number> DELETE\n\r", ch );
        }
    }

    return;
}




/*
 * Syntax:  astat [num]
 */
void do_astat( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char buf  [MAX_STRING_LENGTH];
    AREA_DATA *pArea;

    smash_tilde( argument );
    strcpy( arg1, argument );

    if ( is_number( arg1 ) )
        pArea = get_area_data( atoi( arg1 ) );
    else
        pArea = ch->in_room->area;
        
    if (!pArea)
      pArea = ch->in_room->area;

    sprintf( buf, "Name:     [%5d] %s\n\r",
             pArea->vnum, pArea->name );
    send_to_char( buf, ch );

    sprintf( buf, "File:     [%s]\n\r",
             pArea->filename );
    send_to_char( buf, ch );

    sprintf( buf, "Age:      [%5d]\n\rPlayers:  [%5d]\n\r",
             pArea->age, pArea->nplayer );
    send_to_char( buf, ch );

    sprintf( buf, "Security: [%5d]\n\rBuilders: [%s]\n\r",
             pArea->security, pArea->builders );
    send_to_char( buf, ch );

    sprintf( buf, "Vnums:    [%d-%d]\n\r", pArea->lvnum, pArea->uvnum );
    send_to_char( buf, ch );

    sprintf( buf, "Repop:\n\r%s", pArea->repop );
    send_to_char( buf, ch );

    sprintf( buf, "Flags:    [%s]\n\r", area_bit_name( pArea->area_flags ) );
    send_to_char( buf, ch );

    return;
}
                    

void save_area_list()
{
    FILE *fp;
    AREA_DATA *pArea;

    if ( ( fp = fopen( "area.lst", "w" ) ) == NULL )
    {
    bug( "Save_area_list: fopen", 0 );
    perror( "area.lst" );
    }
    else
    {
        fprintf( fp, "help.hlp\n" );
	fprintf( fp, "command.hlp\n" );
        fprintf( fp, "races.hlp\n" );
        fprintf( fp, "immref.hlp\n" );
        fprintf( fp, "story.hlp\n" );
        fprintf( fp, "motd.hlp\n" );
        fprintf( fp, "socials.hlp\n" );
        fprintf( fp, "nanny.hlp\n" );
        fprintf( fp, "script.hlp\n" );

        for( pArea = area_first; pArea != NULL; pArea = pArea->next )
        {
            fprintf( fp, "%s\n", pArea->filename );
        }

        fprintf( fp, MUD_FILE "\n" );
        fprintf( fp, ROOMS_FILE "\n" );

        fprintf( fp, "$\n" );
        fclose( fp );
    }

    return;
}


void save_config( void )
{
    FILE *fp;
    TERRAIN_DATA *pTerrain;

    if ( ( fp = fopen( MUD_FILE, "w" ) ) == NULL )
    {
    bug( "Save_area_list: fopen", 0 );
    perror( MUD_FILE );
    }
    else
    {
        fprintf( fp, "#CONFIG\n" );
        fprintf( fp, "Date %d %d %d %d\n", time_info.hour, time_info.day,
                     time_info.month, time_info.year );
        fprintf( fp, "Moon %d %d\n",
                     weather_info.moon_phase, weather_info.next_phase );
        if ( wizlock )
        fprintf( fp, "WizLocked\n" );
        if ( newlock )
        fprintf( fp, "NewLocked\n" );

        fprintf( fp, "End\n\n" );

        /*
         * Output terrain information.
         */
        for ( pTerrain = terrain_list;  pTerrain != NULL;  pTerrain = pTerrain->next )
        {
             fprintf( fp, "#TERRAIN %d\n", pTerrain->vnum );
             fprintf( fp, "N %s~\n",  pTerrain->name   );
             fprintf( fp, "Da %s~\n", pTerrain->spring );
             fprintf( fp, "Db %s~\n", pTerrain->winter );
             fprintf( fp, "Dc %s~\n", pTerrain->summer );
             fprintf( fp, "Dd %s~\n", pTerrain->fall   );
             fprintf( fp, "C %c\n",   pTerrain->map_char  );
             fprintf( fp, "S %d\nEnd\n", pTerrain->sector );
        }

        fprintf( fp, "#$\n" );
        fclose( fp );
    }

    return;
}




void save_contents( void )
{
    FILE *fp;

    if ( ( fp = fopen( ROOMS_FILE, "w" ) ) == NULL )
    {
    bug( "Save_area_list: fopen", 0 );
    perror( ROOMS_FILE );
    }
    else
    {
        int iHash;
        ROOM_INDEX_DATA *room;

        fprintf( fp, "#CONTENTS\n" );

        for ( iHash = 0;  iHash < MAX_KEY_HASH;  iHash++ )
        {
        for ( room = room_index_hash[iHash]; room != NULL;  room = room->next )
        {
            if ( !IS_SET(room->room_flags, ROOM_SAVE) )
            continue;

            fprintf( fp, "Room %d\n", room->vnum );

            if ( IS_SET(room->room_flags, ROOM_WAGON) )
            {
                OBJ_INDEX_DATA *pObjIndex;

                pObjIndex = get_obj_index( room->wagon );
                if ( pObjIndex != NULL )
                {
                    OBJ_DATA *pObj;

                    for ( pObj = object_list; pObj != NULL; pObj = pObj->next )
                    {
                        if ( pObj->pIndexData == pObjIndex
                          && pObj->in_room != NULL )
                             break;
                    }

                    if ( pObj != NULL )
                    fprintf( fp, "Wagon %d\n", pObj->in_room->vnum );
                }
            }

            if ( room->contents != NULL )
            fwrite_obj( room->contents, fp, 0 );
        }
        }

        fprintf( fp, "Stop\n\n" );
        fprintf( fp, "#$\n" );
        fclose( fp );
    }


    /*
     * To avoid object duplication.
     */
    {
        CHAR_DATA *ch;
        
        for ( ch = char_list;  ch != NULL;  ch = ch->next )
            do_save( ch, "" );
    }         
   
    return;
}



void save_mobiles( FILE *fp, AREA_DATA *pArea )
{
    int iHash;
    MOB_INDEX_DATA *pMobIndex;
    TRIGGER_DATA *proc;
    ATTACK_DATA *attack;
    int iTrade;
    int iAttack;
    int sn;

    fprintf( fp, "#MOBDATA\n" );
    for( iHash = 0; iHash < MAX_KEY_HASH; iHash++ )
    {
        for( pMobIndex = mob_index_hash[iHash]; pMobIndex != NULL; pMobIndex = pMobIndex->next )
        {
            if ( pMobIndex != NULL && pMobIndex->area == pArea )
            {
                fprintf( fp, "#%d\n",     pMobIndex->vnum );
                fprintf( fp, "N %s~\n",   fix_string( pMobIndex->name ) );
                fprintf( fp, "SD %s~\n",  fix_string( pMobIndex->short_descr ) );
                fprintf( fp, "LD\n %s~\n", fix_string( pMobIndex->long_descr ) );
                fprintf( fp, "D\n %s~\n",  fix_string( pMobIndex->description ) );
                fprintf( fp, "A %d\n",    pMobIndex->act );
                fprintf( fp, "AB %d\n",   pMobIndex->affected_by );
                fprintf( fp, "M %d\n",    pMobIndex->money );
                fprintf( fp, "S %d\n",    pMobIndex->sex );
                fprintf( fp, "Sz %d\n",   pMobIndex->size );

                fprintf( fp, "AP %d %d %d %d %d\n",
                    pMobIndex->perm_str,
                    pMobIndex->perm_int,
                    pMobIndex->perm_wis,
                    pMobIndex->perm_dex,
                    pMobIndex->perm_con );

                if ( pMobIndex->pShop != NULL )
                {
                     fprintf( fp, "Shop\n" );

                     fprintf( fp, " T " );
                     for( iTrade = 0; iTrade < MAX_TRADE; iTrade++ )
                     fprintf( fp, " %d", pMobIndex->pShop->buy_type[iTrade] );
                     fprintf( fp, "\n" );

                     fprintf( fp, " P %d %d\n", pMobIndex->pShop->profit_buy,
                                                pMobIndex->pShop->profit_sell );
                     fprintf( fp, " H %d %d\n", pMobIndex->pShop->open_hour,
                                                pMobIndex->pShop->close_hour  );
                     fprintf( fp, " F %d\n",    pMobIndex->pShop->shop_flags  );
                     fprintf( fp, " R %d\n",    pMobIndex->pShop->repair_rate );
                     fprintf( fp, " BI %d ",  pMobIndex->pShop->buy_index   );
                     fprintf( fp, " CI %d ",  pMobIndex->pShop->comp_index  );
                     fprintf( fp, " SI %d\n", pMobIndex->pShop->sell_index  );
                     fprintf( fp, " Str1\n %s~\n", fix_string( pMobIndex->pShop->no_such_item ) );
                     fprintf( fp, " Str2\n %s~\n", fix_string( pMobIndex->pShop->do_not_buy ) );
                     fprintf( fp, "EndShop\n" );
                }

                for ( proc = pMobIndex->triggers;  proc != NULL;  proc = proc->next )
                    fprintf( fp, "Sc %d\n", proc->script->vnum );

                for ( iAttack = 0;  iAttack < MAX_ATTACK_DATA; iAttack++ )
                {
                    if ( pMobIndex->attacks[iAttack] != NULL )
                    {
                        attack = pMobIndex->attacks[iAttack];
                        fprintf( fp, "At %d %d %d %d\n",
                          iAttack,
                          attack->dam1,
                          attack->dam2,
                          attack->idx );
                    }
                }

                for ( sn = 0; sn < MAX_SKILL; sn++ )
                {
                    if ( skill_table[sn].name == NULL )
                    break;
                    if ( pMobIndex->learned[sn] > 0 )
                    {
							fprintf( fp, "Sk %d '%s'\n",
                                pMobIndex->learned[sn], skill_table[sn].name );
                    }
                }

                fprintf( fp, "End\n\n" );
            }
        }
    }
    fprintf( fp, "#0\n\n\n\n" );
    return;
}



void save_scripts( FILE *fp, AREA_DATA *pArea )
{
    int iHash;
    SCRIPT_DATA *pIndex;

    fprintf( fp, "#PROCDATA\n" );
    for( iHash = 0; iHash < MAX_KEY_HASH; iHash++ )
    {
        for( pIndex = script_index_hash[iHash]; pIndex != NULL; pIndex = pIndex->next )
        {
            if ( pIndex != NULL && pIndex->area == pArea )
            {
                fprintf( fp, "#%d\n",     pIndex->vnum );
                fprintf( fp, "N %s~\n",   fix_string( pIndex->name ) );
                fprintf( fp, "C\n%s~\n",  fix_string( pIndex->commands ) );
                fprintf( fp, "T %d\n",    pIndex->type );
                fprintf( fp, "End\n\n" );
            }
        }
    }
    fprintf( fp, "#0\n\n\n\n" );
    return;
}




void save_objects( FILE *fp, AREA_DATA *pArea )
{
    int iHash;
    OBJ_INDEX_DATA *pObjIndex;
    AFFECT_DATA *pAf;
    EXTRA_DESCR_DATA *pEd;

    fprintf( fp, "#OBJDATA\n" );
    for( iHash = 0; iHash < MAX_KEY_HASH; iHash++ )
    {
        for( pObjIndex = obj_index_hash[iHash]; pObjIndex != NULL; pObjIndex = pObjIndex->next )
        {
            if ( pObjIndex != NULL && pObjIndex->area == pArea )
            {
                fprintf( fp, "#%d\n",     pObjIndex->vnum );
                fprintf( fp, "N %s~\n",   fix_string( pObjIndex->name ) );
                fprintf( fp, "SD %s~\n",  fix_string( pObjIndex->short_descr ) );
                fprintf( fp, "P %s~\n",   fix_string( pObjIndex->short_descr_plural ) );
                fprintf( fp, "D\n%s~\n",  fix_string( pObjIndex->description ) );
                fprintf( fp, "A\n%s~\n",  fix_string( pObjIndex->action_descr ) );
                fprintf( fp, "PD\n%s~\n", fix_string( pObjIndex->description_plural ) );
                fprintf( fp, "DR\n%s~\n", fix_string( pObjIndex->real_description ) );
                fprintf( fp, "L %d\n",    pObjIndex->level );
                fprintf( fp, "T %d\n",    pObjIndex->item_type );
                fprintf( fp, "E %d\n",    pObjIndex->extra_flags );
                fprintf( fp, "W %d\n",    pObjIndex->wear_flags);
                fprintf( fp, "Sz %d\n",   pObjIndex->size );
                fprintf( fp, "Ti %d\n",   pObjIndex->timer );
                fprintf( fp, "Wt %d\n",   pObjIndex->weight );
                fprintf( fp, "C %d\n",    pObjIndex->cost );


                switch ( pObjIndex->item_type )
                {
                default:
                fprintf( fp, "V %d %d %d %d\n",  pObjIndex->value[0],
                                                 pObjIndex->value[1],
                                                 pObjIndex->value[2],
                                                 pObjIndex->value[3] );
                    break;

                case ITEM_PILL:
                case ITEM_POTION:
                case ITEM_SCROLL:
                case ITEM_FOUNTAIN:
                fprintf( fp, "V %d %d %d %d\n",  pObjIndex->value[0],
                                        SKILLSN( pObjIndex->value[1] ),
                                        SKILLSN( pObjIndex->value[2] ),
                                        SKILLSN( pObjIndex->value[3] ) );
                    break;

                case ITEM_STAFF:
                case ITEM_WAND:
                fprintf( fp, "V %d %d %d %d\n",  pObjIndex->value[0],
                                                 pObjIndex->value[1],
                                                 pObjIndex->value[2],
                                        SKILLSN( pObjIndex->value[3] ) );
                    break;
                }

                for( pAf = pObjIndex->affected; pAf != NULL; pAf = pAf->next )
                {
                fprintf( fp, "Af %d %d %d %d %d\n",  pAf->location,
                                                     pAf->modifier,
                                                     pAf->type,
                                                     pAf->duration,
                                                     pAf->bitvector );
                }

                for( pEd = pObjIndex->extra_descr; pEd != NULL; pEd = pEd->next )
                {
				fprintf( fp, "ED %s~\n%s~\n", pEd->keyword,
										 fix_string( pEd->description ) );
                }

                fprintf( fp, "End\n\n" );
            }
        }
    }
    fprintf( fp, "#0\n\n\n\n" );
    return;
}



void save_rooms( FILE *fp, AREA_DATA *pArea )
{
    int iHash;
    ROOM_INDEX_DATA *pRoomIndex;
    EXTRA_DESCR_DATA *pEd;
    RESET_DATA *pReset;
    EXIT_DATA *pExit;
    int door;

    fprintf( fp, "#ROOMDATA\n" );
    for( iHash = 0; iHash < MAX_KEY_HASH; iHash++ )
    {
        for( pRoomIndex = room_index_hash[iHash]; pRoomIndex != NULL; pRoomIndex = pRoomIndex->next )
        {
            if ( pRoomIndex->area == pArea )
            {
                fprintf( fp, "#%d\n",    pRoomIndex->vnum );
                fprintf( fp, "N %s~\n",  fix_string( pRoomIndex->name ) );
                fprintf( fp, "Ref %d\n", pRoomIndex->template );
                fprintf( fp, "D\n%s~\n", fix_string( pRoomIndex->description ) );
                REMOVE_BIT(pRoomIndex->room_flags, ROOM_MARK);
                fprintf( fp, "F %d\n",   pRoomIndex->room_flags  );
                fprintf( fp, "S %d\n",   pRoomIndex->sector_type );
                fprintf( fp, "M %d\n",   pRoomIndex->max_people  );
                fprintf( fp, "W %d\n",   pRoomIndex->wagon       );
                fprintf( fp, "T %d\n",   pRoomIndex->terrain     );

                for ( pEd = pRoomIndex->extra_descr; pEd != NULL;
                      pEd = pEd->next )
                {
					fprintf( fp, "ED %s~\n%s~\n",   pEd->keyword,
                                              fix_string( pEd->description ) );
                }

                for( pReset = pRoomIndex->reset_first; pReset != NULL; pReset = pReset->next )
                {
                    if ( pReset != NULL )
                    {
                      fprintf( fp, "R %c %d %d %d %d\n", pReset->command,
                                                         pReset->rs_vnum,
                                                         pReset->loc,
                                                         pReset->percent,
                                                         pReset->num );
                    }
                }

                for( door = 0; door < MAX_DIR; door++ )
                {
                    if ( (pExit = pRoomIndex->exit[door] ) != NULL
                          && pExit->vnum > 0
                          && get_room_index( pExit->vnum ) != NULL )
                    {
                        fprintf( fp, "Dr %d %d %d %d\n", door,
                                                        pExit->rs_flags,
                                                        pExit->key,
                                                        pExit->vnum );

                        fprintf( fp, "%s~\n", fix_string( pExit->description ) );
                        if ( pExit->keyword != NULL )
                        fprintf( fp, "%s~\n", fix_string( pExit->keyword ) );
                        else fprintf( fp, "~\n" );

                    }
                }
                fprintf( fp, "End\n\n" );
            }
        }
    }
    fprintf( fp, "#0\n\n\n\n" );
    return;
}



void save_area( AREA_DATA *pArea )
{
    FILE *fp;

    REMOVE_BIT( pArea->area_flags, AREA_CHANGED );
    if ( ( fp = fopen( pArea->filename, "w" ) ) == NULL )
    {
    bug( "Open_area: fopen", 0 );
    perror( pArea->filename );
    }

    fprintf( fp, "#AREADATA \n" );
    fprintf( fp, "N %s~\n",        fix_string( pArea->name ) );
    if ( !MTD(pArea->repop) )
    fprintf( fp, "R %s~\n",        fix_string( pArea->repop ) );
    fprintf( fp, "B %s~\n",        fix_string( pArea->builders ) );
    fprintf( fp, "V %d %d\n",      pArea->lvnum, pArea->uvnum );
    fprintf( fp, "S %d\n",         pArea->security );
    if ( IS_SET(pArea->area_flags, AREA_STATIC) )
    fprintf( fp, "Static\n" );
    fprintf( fp, "End\n\n\n\n" );

    save_scripts( fp, pArea );
    save_mobiles( fp, pArea );
    save_objects( fp, pArea );
    save_rooms( fp, pArea );

    fprintf( fp, "#$\n" );

    fclose( fp );
    return;
}



/*
 * Syntax:  asave all
 *          asave world
 *          asave list
 *          asave changed
 *          asave zone
 */
void do_asave( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    AREA_DATA *pArea;
    FILE *fp;
    int value;

    fp = NULL;

    if ( ch == NULL )       /* Do an autosave */
    {
        save_area_list();
        for( pArea = area_first; pArea != NULL; pArea = pArea->next )
        {
            save_area( pArea );
            REMOVE_BIT( pArea->area_flags, AREA_CHANGED );
        }

        save_config();
        save_contents();
        return;
    }

    smash_tilde( argument );
    strcpy( arg1, argument );

    if ( arg1[0] == '\0' )
    {
        send_to_char( "Syntax:\n\r", ch );
        send_to_char( "  asave list     - saves the area.lst file\n\r",    ch );
        send_to_char( "  asave zone     - saves the zone your in\n\r",     ch );
        send_to_char( "  asave changed  - saves all changed zones\n\r",    ch );
        send_to_char( "  asave world    - saves the world! (db dump)\n\r", ch );
        send_to_char( "\n\r", ch );
        return;
    }

    /*
     * Snarf the value (which need not be numeric).
     */
    value = atoi( arg1 );

    if ( ( pArea = get_area_data( value ) ) == NULL && is_number( arg1 ) )
    {
        send_to_char( "That area does not exist.\n\r", ch );
        return;
    }

    if ( is_number( arg1 ) )
    {
        save_area_list();
        save_area( pArea );
        return;
    }

    if ( !str_cmp( "world", arg1 ) || !str_cmp( "all", arg1 ) )
    {
        save_area_list();
        for( pArea = area_first; pArea != NULL; pArea = pArea->next )
        {
            save_area( pArea );
        }

        save_config();
        save_contents();

        send_to_char( "You saved the world.\n\r", ch );
        do_echo( ch, "Database saved." );
        return;
    }

    if ( !str_prefix( arg1, "changed" ) )
    {
        char buf[WORK_STRING_LENGTH];

        save_area_list();

        send_to_char( "Saved zones:\n\r", ch );
        sprintf( buf, "None.\n\r" );

        for( pArea = area_first; pArea != NULL; pArea = pArea->next )
        {
            if ( IS_SET(pArea->area_flags, AREA_CHANGED) )
            {
                if ( !IS_SET(pArea->area_flags, AREA_STATIC) )
                save_area( pArea );
                sprintf( buf, "%24s - '%s'%s\n\r", pArea->name, pArea->filename,
                      IS_SET(pArea->area_flags, AREA_STATIC) ?
                          " - static area, not saved" : "" );
                send_to_char( buf, ch );
            }
        }
        if ( !str_cmp( buf, "None.\n\r" ) )
             send_to_char( buf, ch );
        return;
    }

    if ( !str_prefix( arg1, "list" ) )
    {
      save_area_list();
      return;
    }

    if ( !str_prefix( arg1, "zone" ) )
    {
      save_area_list();
      save_area( ch->in_room->area );
      send_to_char( "Zone saved.\n\r", ch );
      return;
    }

    do_asave( ch, "" );
    return;
}





