
/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */



#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"





/*
 * Find an obj in a list.
 */
OBJ_DATA *get_obj_list( CHAR_DATA *ch, char *argument, OBJ_DATA *list )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int number;
    int count;

    number = number_argument( argument, arg );
    count  = 0;
    for ( obj = list; obj != NULL; obj = obj->next_content )
    {
    if ( can_see_obj( ch, obj ) && is_prename( arg, STR(obj, name) ) )
	{
	    if ( ++count == number )
		return obj;
	}
    }

    return NULL;
}



/*
 * Find an obj in player's hands.
 */
OBJ_DATA *get_obj_carry( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int number;
    int count;

    number = number_argument( argument, arg );
    count  = 0;
    for ( obj = ch->carrying; obj != NULL; obj = obj->next_content )
    {
    if ( (obj->wear_loc == WEAR_NONE
      ||  obj->wear_loc == WEAR_HOLD_1
      ||  obj->wear_loc == WEAR_HOLD_2
      ||  obj->wear_loc == WEAR_WIELD_1
      ||  obj->wear_loc == WEAR_WIELD_2)
    &&   can_see_obj( ch, obj )
    &&   is_name( arg, STR(obj, name) ) )
	{
	    if ( ++count == number )
		return obj;
	}
    }


    return NULL;
}




/*
 * Find an obj in player's equipment.
 */
OBJ_DATA *get_obj_wear( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int number;
    int count;
    int iWear;

    number = number_argument( argument, arg );
    count  = 0;
    for ( iWear = 0; iWear < MAX_WEAR; iWear++ )
    {
        if ( ( obj = get_eq_char( ch, iWear ) ) == NULL )
        continue;

    if ( obj->wear_loc != WEAR_NONE
    &&   obj->wear_loc != WEAR_HOLD_1
    &&   obj->wear_loc != WEAR_HOLD_2
	&&   can_see_obj( ch, obj )
    &&   is_name( arg, STR(obj, name) ) )
	{
	    if ( ++count == number )
		return obj;
	}
    }

    return NULL;
}


/*
 * Find an object in the character's inventory top level.
 */
OBJ_DATA *get_obj_inv( CHAR_DATA *ch, char *argument )
{
    OBJ_DATA *obj;
    char arg[MAX_INPUT_LENGTH];
    int number;
    int count;

    number = number_argument( argument, arg );
    count  = 0;
    for ( obj = ch->carrying; obj != NULL; obj = obj->next_content )
    {
    if ( can_see_obj( ch, obj )  &&   is_name( arg, STR(obj, name) ) )
	{
	    if ( ++count == number )
		return obj;
	}
    }

    return NULL;
}


/*
 * Find an obj in the room or in inventory.
 */
OBJ_DATA *get_obj_here( CHAR_DATA *ch, char *argument )
{
    OBJ_DATA *obj;

    if ( ( obj = get_obj_inv( ch, argument ) ) != NULL )
    return obj;

    obj = get_obj_list( ch, argument, ch->in_room->contents );

    if ( obj != NULL )
    return obj;

    return NULL;
}



/*
 * Find an obj in the world.
 */
OBJ_DATA *get_obj_world( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int number;
    int count;

    if ( ( obj = get_obj_here( ch, argument ) ) != NULL )
	return obj;

    number = number_argument( argument, arg );
    count  = 0;
    for ( obj = object_list; obj != NULL; obj = obj->next )
    {
    if ( can_see_obj( ch, obj ) && is_name( arg, STR(obj, name) ) )
	{
	    if ( ++count == number )
		return obj;
	}
    }

    return NULL;
}




#if defined(NEVER)
/*
 * Diku code - search a block of memory as if it were a string.
 * Slight incompatibility problem here on some machines I suspect.  
 * --Locke
 */
int search_block(char *arg, char **list, bool exact)
{
	register int i,l;

    /*
     * Make into lower case, and get length of string
     */
    for( l = 0; *(arg + l); l++ ) *(arg + l) = LOWER(*(arg + l));

    if (exact)
    {
        for( i = 0; **(list + i) != '\n'; i++ )
            if ( !strcmp(arg, *(list+i)) ) return(i);
    }
    else
    {
        /*
         * Avoid "" to match the first available string
         */

        if (!l) l = 1;

        for( i = 0; **(list+i) != '\n'; i++ )
           if ( !strncmp(arg, *(list + i), l) )
           return(i);
	}

	return(-1);
}
#endif



/*
 * Based on the Quinn argument interpreter for two-word parsing codes
 * from Diku.
 *
 * This code written by Locke.
 *
 * Returns information about the fill words (before and after first_arg).
 */
#define fill_word(argument) 	  ( is_number( argument )					\
                                    && fill_words(argument) )
#define MAX_FILL		10

char *	fill   [MAX_FILL] =
{
  "in",
  "from",
  "with",
  "the",
  "on",
  "at",
  "to",
  "here",
  "my",
  "a"
};

bool fill_words( char *argument )
{
	int x;

	for ( x = 0; x < MAX_FILL; x++ )
	{
		if ( !str_cmp( fill[x], argument ) ) return TRUE;
	}

	return FALSE;
}

#if defined(NEVER)
int argument_interpreter( char *argument, char *first_arg, char *second_arg,
						  int *x, int *y )
{
    int fills = 0;

    first_arg  = '\0';
    second_arg = '\0';
	x = 0;
	y = 0;

    while( *argument != '\0' && fill_word(first_arg) )
    {
        argument = one_argument( argument, first_arg );

        if ( *first_arg != '\0' )
        {
		if ( is_number( first_arg ) )		x = atoi( first_arg );
        if ( !str_cmp( first_arg, "in" )    SET_BIT(fills, FA_IN);
        if ( !str_cmp( first_arg, "on" )    SET_BIT(fills, FA_ON);
        if ( !str_cmp( first_arg, "here" )  SET_BIT(fills, FA_HERE);
        if ( !str_cmp( first_arg, "my" )    SET_BIT(fills, FA_MY);
        }
    }

    while( *argument != '\0' &&  fill_word(second_arg) )
    {
        argument = skip_spaces( argument );
        one_argument( argument, second_arg );

        if ( *second_arg != '\0' )
        {
		if ( is_number( second_arg ) )		y = atoi( first_arg );
        if ( !str_cmp( second_arg, "in" )   SET_BIT(fills, SA_IN);
        if ( !str_cmp( second_arg, "on" )   SET_BIT(fills, SA_ON);
        if ( !str_cmp( second_arg, "here" ) SET_BIT(fills, SA_HERE);
        if ( !str_cmp( second_arg, "my" )   SET_BIT(fills, SA_MY);
        }
    }

    return fills;
}



/*
 *	  "look 'at my sword in the pack here'"
 *	  "look 'sword'"
 *	  "look 'short sword'"
 *	  "look 'at a short sword'"

OBJ_DATA *get_object_nearby( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_STRING_LENGTH];
    char arg2[MAX_STRING_LENGTH];
	int fBits;
	int x, y;

	fBits	  = argument_interpreter( argument, arg1, arg2, &x, &y );

	if ( fBits == 0 )
	{
		if ( arg2[0] == '\0' ) return get_obj_here( ch, arg1 );
		return get_obj_here( ch, argument );
	}



 */






#endif
