
/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */



#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "skills.h"
#include "script.h"
#include "defaults.h"
#include "comm.h"

#if !defined(macintosh)
extern	int	_filbuf		args( (FILE *) );
#endif

CHAR_DATA *mount_list;



/*
 * Array of containers read for proper re-nesting of objects.
 */
OBJ_DATA *  rgObjNest   [MAX_NEST];



void       fwrite_char ( CHAR_DATA *ch, FILE *fp );
void       fwrite_mob  ( CHAR_DATA *ch, FILE *fp );
void       fwrite_obj  ( OBJ_DATA *obj, FILE *fp, int iNest );
void       fread_obj   ( void *caller, int caller_type, FILE *fp );
CHAR_DATA *fread_char  ( CHAR_DATA *ch, FILE *fp );
CHAR_DATA *fread_mob   ( CHAR_DATA *ch, FILE *fp );

/*
 * Save a character and inventory.   MOB infrastructure removed.
 */
void save_char_obj( CHAR_DATA *ch )
{
    CHAR_DATA *pet;
    char strsave[MAX_INPUT_LENGTH];
    FILE *fp;

    if (IS_NPC(ch))
    return;

    if ( PC(ch,level) == 0 )
	return;

    if ( ch->desc != NULL && ch->desc->original != NULL )
	ch = ch->desc->original;

    PC(ch,save_time) = current_time;
    fclose( fpReserve );
    sprintf( strsave, "%s%s", PLAYER_DIR, capitalize( ch->name ) );
    if ( ( fp = fopen( strsave, "w" ) ) == NULL )
    {
	bug( "Save_char_obj: fopen", 0 );
	perror( strsave );
    return;
    }

    fwrite_char( ch, fp );

    if ( ch->carrying != NULL )
    fwrite_obj( ch->carrying, fp, 0 );

    for ( pet = char_list; pet != NULL; pet = pet->next )
    {
        if ( ( pet->master == ch ) && IS_SET(pet->act, ACT_PET) )
        fwrite_mob( pet, fp );
    }

    for ( pet = mount_list; pet != NULL; pet = pet->next )
    {
        if ( ( pet->master == ch ) && IS_SET(pet->act, ACT_PET) )
        fwrite_mob( pet, fp );
    }

    fprintf( fp, "#END\n\n" );
    fclose( fp );
    fpReserve = fopen( NULL_FILE, "r" );
    return;
}


/*
 * Write the char.
 */
void fwrite_char( CHAR_DATA *ch, FILE *fp )
{
    AFFECT_DATA *paf;
    int sn;

    /*
     * Guest character support.
     */
    if ( !str_cmp(ch->name, "guest") ) return;
    
    fprintf( fp, "#PLAYER\n"     );
    fprintf( fp, "N %s~\n",   ch->name        );
    fprintf( fp, "S %s~\n",   ch->short_descr );
    fprintf( fp, "L %s~\n"  , fix_string( ch->long_descr  ) );
    fprintf( fp, "D\n%s~\n",  fix_string( ch->description ) );
    fprintf( fp, "Sx %d\n",   ch->sex                 );
    fprintf( fp, "Sz %d\n",   ch->size        );
    fprintf( fp, "Ra %d\n",   ch->race        );
    fprintf( fp, "Fi %d\n",   ch->fmode       );
    fprintf( fp, "Lv %d\n",   PC(ch,level)    );
    fprintf( fp, "Bou %d\n",  ch->bounty      );
    fprintf( fp, "O %d\n",    ch->owed        );
    fprintf( fp, "Sc %d\n",   PC(ch,security) );
    fprintf( fp, "Wi %d\n",   PC(ch,wizinvis) );
    fprintf( fp, "Pl %d\n",
                 PC(ch,played) + (int) (current_time - PC(ch,logon) ) );
    fprintf( fp, "R %d\n", ch->in_room->vnum );
    fprintf( fp, "BD %d %d %d\n",   PC(ch,birth_day),
                 PC(ch,birth_month), PC(ch,birth_year) );
    fprintf( fp, "H %d %d\n", ch->hit, ch->move );
    fprintf( fp, "A %d A2 %d\n", ch->act, ch->act2 );
    fprintf( fp, "AB %d\n",   ch->affected_by         );
    if ( !MTD(PC(ch,denial)) )
      fprintf( fp, "Denial %s~\n",  fix_string( PC(ch,denial) ) );
    fprintf( fp, "Po %d\n",    /* Bug fix from Alander */
        ch->position == POS_FIGHTING ? POS_STANDING : ch->position );
    fprintf( fp, "ST %d\n",   ch->saving_throw        );
    fprintf( fp, "Hi %d\n",   ch->hitroll             );
    fprintf( fp, "Da %d\n",   ch->damroll             );
    fprintf( fp, "AC %d\n",   ch->armor               );
    fprintf( fp, "De %d\n",   PC(ch,deaf)                );
    if ( IS_NPC(ch) )
    {
    fprintf( fp, "V %d\n",   ch->pIndexData->vnum    );
    }
    else
    {
    fprintf( fp, "P %s~\n",      PC(ch,pwd)         );
    fprintf( fp, "Pr %s~\n",     ch->prompt         );
    fprintf( fp, "Pg %d\n",      ch->pagelen        );
    if ( IS_IMMORTAL(ch) )
    {
    fprintf( fp, "Bi  %s~\n",    PC(ch,bamfin)      );
    fprintf( fp, "Bo %s~\n",     PC(ch,bamfout)     );
    fprintf( fp, "Co %s~\n",     PC(ch,constellation) );
    }
    fprintf( fp, "Em %s~\n",     PC(ch,email)      );
    fprintf( fp, "K %s~\n",      ch->keywords   );
    fprintf( fp, "AP %d %d %d %d %d\n",
        ch->perm_str,
        ch->perm_int,
        ch->perm_wis,
        ch->perm_dex,
        ch->perm_con );

    fprintf( fp, "AM %d %d %d %d %d\n",
        ch->mod_str,
        ch->mod_int,
        ch->mod_wis,
        ch->mod_dex,
        ch->mod_con );

    fprintf( fp, "C %d %d %d\n",
        PC(ch,condition[0]),
        PC(ch,condition[1]),
        PC(ch,condition[2]) );
            
    fprintf( fp, "Cl %d %d %d %d %d %d %d %d %d %d\n",
        PC(ch,colors[0]),
        PC(ch,colors[1]),
        PC(ch,colors[2]),
        PC(ch,colors[3]),
        PC(ch,colors[4]),
        PC(ch,colors[5]),
        PC(ch,colors[6]),
        PC(ch,colors[7]),
        PC(ch,colors[8]),
        PC(ch,colors[9])  );
        
	for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
        if ( skill_table[sn].name != NULL && PC(ch,learned[sn]) > 0 )
	    {
                fprintf( fp, "Sk %d '%s' %d %d\n",
                    PC(ch,learned[sn]), skill_table[sn].name,
                    PC(ch,teacher[sn]), PC(ch,skill_time[sn]) );
	    }
	}
    }

    for ( paf = ch->affected; paf != NULL; paf = paf->next )
    {
	/* Thx Alander */
	if ( paf->type < 0 || paf->type >= MAX_SKILL )
	    continue;

    fprintf( fp, "Af '%s' %d %d %d %d\n",
	    skill_table[paf->type].name,
	    paf->duration,
	    paf->modifier,
	    paf->location,
        paf->bitvector );
    }

    fprintf( fp, "END\n\n" );
    return;
}

/*
 * Write the mob.
 */
void fwrite_mob( CHAR_DATA *ch, FILE *fp )
{
    AFFECT_DATA *paf;
    
    fprintf( fp, "#MOBILE\n"                          );
    fprintf( fp, "V %d\n",    ch->pIndexData->vnum    );
    if ( ch->name != NULL )
    fprintf( fp, "N %s~\n", ch->name                  );
    if ( ch->short_descr != NULL )
    fprintf( fp, "S %s~\n", ch->short_descr           );
    if ( ch->long_descr != NULL )
    fprintf( fp, "L %s~\n",   fix_string( ch->long_descr  ) );
    if ( ch->description != NULL )
    fprintf( fp, "D\n%s~\n",  fix_string( ch->description ) );
    fprintf( fp, "Sx %d\n",   ch->sex                 );
    fprintf( fp, "Sz %d\n",   ch->size                );
    fprintf( fp, "R %d\n",    ch->in_room->vnum       );
    fprintf( fp, "T %d\n",    ch->timer               );

    fprintf( fp, "H %d %d\n", ch->hit, ch->move       );
    fprintf( fp, "A %d A2 %d\n", ch->act, ch->act2    );
    fprintf( fp, "AB %d\n",   ch->affected_by         );
    fprintf( fp, "P %d\n",    /* Bug fix from Alander */
        ch->position == POS_FIGHTING ? POS_STANDING : ch->position );
    fprintf( fp, "ST %d\n",   ch->saving_throw        );
    fprintf( fp, "Hi %d\n",   ch->hitroll             );
    fprintf( fp, "Da %d\n",   ch->damroll             );
    fprintf( fp, "AC %d\n",   ch->armor               );
    fprintf( fp, "AP %d %d %d %d %d\n",
        ch->perm_str,
        ch->perm_int,
        ch->perm_wis,
        ch->perm_dex,
        ch->perm_con );

    fprintf( fp, "AM %d %d %d %d %d\n",
        ch->mod_str,
        ch->mod_int,
        ch->mod_wis,
        ch->mod_dex,
        ch->mod_con );

    for ( paf = ch->affected; paf != NULL; paf = paf->next )
    {
        /* Thx Alander */
        if ( paf->type < 0 || paf->type >= MAX_SKILL )
            continue;

        fprintf( fp, "Af '%s' %d %d %d %d\n",
            skill_table[paf->type].name,
            paf->duration,
            paf->modifier,
            paf->location,
            paf->bitvector );
    }

    fprintf( fp, "END\n\n" );

    if ( ch->carrying != NULL )
    fwrite_obj ( ch->carrying, fp, 0 );

    return;
}


/*
 * Write an object list and each object's contents.
 */
void fwrite_obj( OBJ_DATA *obj, FILE *fp, int iNest )
{
    EXTRA_DESCR_DATA *ed;
    AFFECT_DATA *paf;

    /*
     * Slick recursion to write lists backwards,
     *   so loading them will load in forwards order.
     */
    if ( obj->next_content != NULL )
    fwrite_obj( obj->next_content, fp, iNest );

    /*
     * Castrate storage areas.
     */
    if ( IS_SET( obj->extra_flags, ITEM_NOSAVE ) )
	return;

    fprintf( fp, "\n#OBJECT\n" );
    fprintf( fp, "Nest %d\n",   iNest                );
    fprintf( fp, "V %d\n",   obj->pIndexData->vnum   );
    if ( obj->name )
    fprintf( fp, "N %s~\n",  obj->name               );
    if ( obj->short_descr )     
    fprintf( fp, "S %s~\n",  obj->short_descr        );
    if ( obj->short_descr_plural )
    fprintf( fp, "SP %s~\n", obj->short_descr_plural );
    if ( obj->description )
    fprintf( fp, "D\n%s~\n", obj->description        );
    if ( obj->action_descr )     
    fprintf( fp, "A %s~\n",  obj->action_descr       );
    fprintf( fp, "E %d\n",   obj->extra_flags        );
    fprintf( fp, "W %d\n",   obj->wear_flags         );
    fprintf( fp, "WL %d\n",  obj->wear_loc           );
    fprintf( fp, "I %d\n",   obj->item_type          );
    fprintf( fp, "Wt %d\n",  obj->weight             );
    fprintf( fp, "L %d\n",   obj->level              );
    fprintf( fp, "Sz %d\n",  obj->size               );
    if ( obj->timer != 0 )
    fprintf( fp, "T %d\n",   obj->timer              );
    fprintf( fp, "C %d\n",   obj->cost               );
    fprintf( fp, "Va %d %d %d %d\n",
             obj->value[0],
             obj->value[1],
             obj->value[2],
             obj->value[3] );

    switch ( obj->item_type )
    {
        case ITEM_POTION:
        case ITEM_SCROLL:
        if ( obj->value[1] > 0 )
        {  fprintf( fp, "Sp 1 '%s'\n", skill_table[obj->value[1]].name ); }
        if ( obj->value[2] > 0 )
        {  fprintf( fp, "Sp 2 '%s'\n", skill_table[obj->value[2]].name ); }
        if ( obj->value[3] > 0 )
        {  fprintf( fp, "Sp 3 '%s'\n", skill_table[obj->value[3]].name ); }
        break;

        case ITEM_PILL:
        case ITEM_STAFF:
        case ITEM_WAND:
        if ( obj->value[3] > 0 )
        {  fprintf( fp, "Sp 3 '%s'\n", skill_table[obj->value[3]].name ); }
        break;
    }

    for ( paf = obj->affected; paf != NULL; paf = paf->next )
    {
    fprintf( fp, "Af %d %d %d %d\n",
	    paf->duration,
	    paf->modifier,
	    paf->location,
        paf->bitvector );
    }

    for ( ed = obj->extra_descr; ed != NULL; ed = ed->next )
    { fprintf( fp, "Ex %s~\n%s~\n", ed->keyword, ed->description ); }

    fprintf( fp, "END\n\n" );

    if ( obj->contains != NULL )
    fwrite_obj( obj->contains, fp, iNest + 1 );

    return;
}



/*
 * Load a char and inventory into a new ch structure.
 */
bool load_char_obj( DESCRIPTOR_DATA *d, char *name )
{
    char strsave[MAX_INPUT_LENGTH];
    CHAR_DATA *ch, *mob;
    FILE *fp;
    bool found;

    ch = new_char_data( );

    d->character			= ch;
    ch->desc				= d;
    free_string( ch->name );
    ch->name				= str_dup( name );

    mob = ch;

    found = FALSE;
    fclose( fpReserve );
    sprintf( strsave, "%s%s", PLAYER_DIR, capitalize( name ) );
    if ( ( fp = fopen( strsave, "r" ) ) != NULL )
    {
	int iNest;

	for ( iNest = 0; iNest < MAX_NEST; iNest++ )
	    rgObjNest[iNest] = NULL;

	found = TRUE;
	for ( ; ; )
	{
	    char letter;
	    char *word;

	    letter = fread_letter( fp );
	    if ( letter == '*' )
	    {
		fread_to_eol( fp );
		continue;
	    }

        if ( letter != '#' )
	    {
		bug( "Load_char_obj: # not found.", 0 );
		break;
	    }

        word = fread_word( fp );
             if ( !str_cmp( word, "PLAYER" ) )  mob = fread_char ( ch, fp );
        else if ( !str_cmp( word, "MOBILE" ) )
        {
            mob = fread_mob  ( ch, fp );
            if ( mob != NULL && mob != ch )
            {
                add_follower( mob, ch );
                mob->next  = mount_list;
                mount_list = mob;
            }
            else mob = ch;
        }
        else if ( !str_cmp( word, "OBJECT" ) ) fread_obj  ( mob, TYPE_MOB, fp );
        else if ( !str_cmp( word, "END"    ) ) break;
	    else
	    {
		bug( "Load_char_obj: bad section.", 0 );
		break;
	    }
	}
	fclose( fp );
    }

    fpReserve = fopen( NULL_FILE, "r" );
    return found;
}




/*
 * Read in a char.
 */

#if defined(KEY)
#undef KEY
#endif

#define KEY( literal, field, value )                \
				if ( !str_cmp( word, literal ) )	\
                {                                   \
                    field  = value;                 \
                    fMatch = TRUE;                  \
                    break;                          \
                }

CHAR_DATA *fread_char( CHAR_DATA *ch, FILE *fp )
{
    char *word;
    bool fMatch;


    for ( ; ; )
    {
	word   = feof( fp ) ? "End" : fread_word( fp );
        fMatch = FALSE;

	switch ( UPPER(word[0]) )
	{
	case '*':
	    fMatch = TRUE;
	    fread_to_eol( fp );
	    break;

	case 'A':
        KEY( "A",  ch->act,            fread_number( fp ) );
        KEY( "A2",  ch->act2,           fread_number( fp ) );
        KEY( "AB",  ch->affected_by,    fread_number( fp ) );
        KEY( "AC",  ch->armor,          fread_number( fp ) );

        if ( !str_cmp( word, "Af" ) || !str_cmp( word, "Af" ) )
	    {
		AFFECT_DATA *paf;
        int sn;

        paf = new_affect( );
        sn = skill_lookup( fread_word( fp ) );
        if ( sn < 0 )
        bug( "Fread_char: unknown skill.", 0 );
        else
        paf->type = sn;
		paf->duration	= fread_number( fp );
		paf->modifier	= fread_number( fp );
		paf->location	= fread_number( fp );
		paf->bitvector	= fread_number( fp );
		paf->next	= ch->affected;
		ch->affected	= paf;
		fMatch = TRUE;
		break;
	    }

        if ( !str_cmp( word, "AM"  ) )
	    {
            ch->mod_str  = fread_number( fp );
            ch->mod_int  = fread_number( fp );
            ch->mod_wis  = fread_number( fp );
            ch->mod_dex  = fread_number( fp );
            ch->mod_con  = fread_number( fp );
            fMatch = TRUE;
            break;
	    }

        if ( !str_cmp( word, "AP" ) )
	    {
            ch->perm_str = fread_number( fp );
            ch->perm_int = fread_number( fp );
            ch->perm_wis = fread_number( fp );
            ch->perm_dex = fread_number( fp );
            ch->perm_con = fread_number( fp );
            fMatch = TRUE;
            break;
	    }
	    break;

	case 'B':
        if ( !str_cmp( word, "BD" ) )
        {
            PC(ch,birth_day)   = fread_number( fp );
            PC(ch,birth_month) = fread_number( fp );
            PC(ch,birth_year)  = fread_number( fp );
            fMatch = TRUE;
        }
        KEY( "Bi",  PC(ch,bamfin),     fread_string( fp ) );
        KEY( "Bo", PC(ch,bamfout),    fread_string( fp ) );
        KEY( "Bou",  ch->bounty,        fread_number( fp ) );
	    break;

	case 'C':
        if ( !str_cmp( word, "C" ) )
	    {
                PC(ch,condition[0]) = fread_number( fp );
                PC(ch,condition[1]) = fread_number( fp );
                PC(ch,condition[2]) = fread_number( fp );
        fMatch = TRUE;
		break;
	    }

        if ( !str_cmp( word, "Co" ) )
	    {
        free_string( PC(ch,constellation) );
        PC(ch,constellation) = fread_string( fp );
		fMatch = TRUE;
		break;
	    }

        if ( !str_cmp( word, "Cl" ) )
        {
        PC(ch,colors)[0] = fread_number( fp );
        PC(ch,colors)[1] = fread_number( fp );
        PC(ch,colors)[2] = fread_number( fp );
        PC(ch,colors)[3] = fread_number( fp );
        PC(ch,colors)[4] = fread_number( fp );
        PC(ch,colors)[5] = fread_number( fp );
        PC(ch,colors)[6] = fread_number( fp );
        PC(ch,colors)[7] = fread_number( fp );
        PC(ch,colors)[8] = fread_number( fp );
        PC(ch,colors)[9] = fread_number( fp );
        fMatch = TRUE;
        break;
        }
	    break;

	case 'D':
        KEY( "Da",     ch->damroll,          fread_number( fp ) );
        KEY( "De",    PC(ch,deaf),           fread_number( fp ) );
        KEY( "D",    ch->description,        fread_string( fp ) );
        KEY( "Denial",  PC(ch,denial),          fread_string( fp ) );
	    break;

	case 'E':
        KEY( "Em",   PC(ch,email),      fread_string( fp ) );
        if ( !str_cmp( word, "END" ) )
        return ch;
	    break;

    case 'F':
         KEY( "Fi", ch->fmode,            fread_number( fp ) );
        break;

    case 'O':
        KEY( "O",  ch->owed,        fread_number( fp ) );
        break;

	case 'H':
        KEY( "Hi",   ch->hitroll,              fread_number( fp ) );
                                              
        if ( !str_cmp( word, "H" ) )
	    {
		ch->hit		= fread_number( fp );
		ch->move	= fread_number( fp );
		fMatch = TRUE;
		break;
	    }
	    break;

    case 'K':
        KEY( "K",   ch->keywords,      fread_string( fp ) );
       break;

	case 'L':
        KEY( "Lv",       PC(ch,level),              fread_number( fp ) );
        KEY( "L",       ch->long_descr,            fread_string( fp ) );
	    break;

	case 'N':
        if ( !str_cmp( word, "N" ) )
	    {
		/*
		 * Name already set externally.
		 */
		fread_to_eol( fp );
		fMatch = TRUE;
		break;
	    }
	    break;

        case 'P':
        KEY( "Pr",      ch->prompt,          fread_string( fp ) );
        KEY( "P",       PC(ch,pwd),          fread_string( fp ) );
        KEY( "Pl",      PC(ch,played),       fread_number( fp ) );
        KEY( "Pg",      ch->pagelen,         fread_number( fp ) );
        KEY( "Po",      ch->position,        fread_number( fp ) );
	    break;

	case 'R':
        KEY( "Ra",        ch->race,               fread_number( fp ) );

        if ( !str_cmp( word, "R" ) )
	    {
		ch->in_room = get_room_index( fread_number( fp ) );
		if ( ch->in_room == NULL )
             ch->in_room = get_room_index( ROOM_VNUM_TEMPLATE );
		fMatch = TRUE;
		break;
	    }

	    break;

	case 'S':
        KEY( "ST", ch->saving_throw,      fread_number( fp ) );
        KEY( "Sx", ch->sex,               fread_number( fp ) );
        KEY( "Sz", ch->size,              fread_number( fp ) );
        KEY( "S",  ch->short_descr,       fread_string( fp ) );
        KEY( "Sc", PC(ch,security),       fread_number( fp ) );

        if ( !str_cmp( word, "Sk" ) )
	    {
		int sn;
		int value;
                int teacher;

                value   = fread_number( fp );
                sn      = skill_lookup( fread_word( fp ) );
                teacher = fread_number( fp );
                PC(ch,skill_time[sn])  = fread_number( fp );
                if ( sn < 0 )
                bug( "Fread_char: unknown skill(%d)", sn );
                else
                {
                    PC(ch,learned[sn]) = value;
                    PC(ch,teacher[sn]) = teacher;
                }
		fMatch = TRUE;
	    }

	    break;

	case 'V':
        if ( !str_cmp( word, "V" ) )
	    {
		ch->pIndexData = get_mob_index( fread_number( fp ) );
		fMatch = TRUE;
		break;
	    }
	    break;

	case 'W':
	KEY( "Wi",    PC(ch,wizinvis),            fread_number( fp ) );
	    break;
	}

	if ( !fMatch )
	{
        sprintf( log_buf, "Fread_char: no match (%s).", word );
        bug( log_buf, 0 );
        if ( !feof( fp ) ) fread_to_eol( fp );
	}
    }
}



CHAR_DATA *fread_mob ( CHAR_DATA *ch, FILE *fp )
{
    char *word;
    bool fMatch;
    bool fVnum = FALSE;

    ch = new_char_data( );
    free_pc_data( ch->pcdata );
    ch->pcdata = NULL;

    ch->pIndexData     = NULL;

    ch->name           = NULL;
    ch->short_descr    = NULL;
    ch->long_descr     = NULL;
    ch->description    = NULL;
    ch->position       = POS_STANDING;

    ch->triggers       = NULL;
    ch->current        = NULL;

    ch->prompt     = str_dup( "Mob(%h %m): " );
    ch->armor      = 100;
    ch->hit        = MAXHIT(ch);
    ch->move       = MAXMOVE(ch);

    for ( ; ; )
    {
	word   = feof( fp ) ? "End" : fread_word( fp );
        fMatch = FALSE;

	switch ( UPPER(word[0]) )
	{
	case '*':
	    fMatch = TRUE;
	    fread_to_eol( fp );
	    break;

	case 'A':
        KEY( "A",   ch->act,            fread_number( fp ) );
        KEY( "A2",  ch->act2,           fread_number( fp ) );
        KEY( "AB",  ch->affected_by,    fread_number( fp ) );
        KEY( "AC",  ch->armor,          fread_number( fp ) );

        if ( !str_cmp( word, "Af" ) || !str_cmp( word, "Af" ) )
	    {
		AFFECT_DATA *paf;
        int sn;

        paf = new_affect( );
        sn = skill_lookup( fread_word( fp ) );
        if ( sn < 0 )
        bug( "Fread_mob: unknown skill.", 0 );
        else
        paf->type = sn;
		paf->duration	= fread_number( fp );
		paf->modifier	= fread_number( fp );
		paf->location	= fread_number( fp );
		paf->bitvector	= fread_number( fp );
		paf->next	= ch->affected;
		ch->affected	= paf;
		fMatch = TRUE;
		break;
	    }

        if ( !str_cmp( word, "AM"  ) )
	    {
                ch->mod_str  = fread_number( fp );
                ch->mod_int  = fread_number( fp );
                ch->mod_wis  = fread_number( fp );
                ch->mod_dex  = fread_number( fp );
                ch->mod_con  = fread_number( fp );
		fMatch = TRUE;
		break;
	    }

        if ( !str_cmp( word, "AP" ) )
	    {
                ch->perm_str = fread_number( fp );
                ch->perm_int = fread_number( fp );
                ch->perm_wis = fread_number( fp );
                ch->perm_dex = fread_number( fp );
                ch->perm_con = fread_number( fp );
		fMatch = TRUE;
		break;
	    }
	    break;

	case 'D':
        KEY( "Da",     ch->damroll,          fread_number( fp ) );
        KEY( "D",    ch->description,        fread_string( fp ) );
	    break;

	case 'E':
        if ( !str_cmp( word, "END" ) )
        {
            if ( !fVnum )
            {
                bug( "Fread_mob: Incomplete mobile.", 0 );
                free_char( ch );
                return NULL;
            }

            return ch;
        }
	    break;

	case 'H':
        KEY( "Hi",   ch->hitroll,              fread_number( fp ) );
                                              
        if ( !str_cmp( word, "H" ) )
	    {
		ch->hit		= fread_number( fp );
		ch->move	= fread_number( fp );
		fMatch = TRUE;
		break;
	    }
	    break;

    case 'K':
        KEY( "K",       ch->keywords,      fread_string( fp ) );
        break;

	case 'L':
        KEY( "L",       ch->long_descr,            fread_string( fp ) );
	    break;

	case 'N':
        KEY( "N",       ch->name,            fread_string( fp ) );
	    break;

    case 'P':
        KEY( "P",       ch->position,        fread_number( fp ) );
	    break;

	case 'R':
        KEY( "Ra",        ch->race,               fread_number( fp ) );

        if ( !str_cmp( word, "R" ) )
	    {
		ch->in_room = get_room_index( fread_number( fp ) );
		if ( ch->in_room == NULL )
        ch->in_room = get_room_index( ROOM_VNUM_TEMPLATE );

		fMatch = TRUE;
		break;
	    }

	    break;

    case 'T':
        KEY( "T",  ch->timer,             fread_number( fp ) );
        break;

	case 'S':
        KEY( "ST", ch->saving_throw,      fread_number( fp ) );
        KEY( "Sx", ch->sex,               fread_number( fp ) );
        KEY( "Sz", ch->size,              fread_number( fp ) );
        KEY( "S",  ch->short_descr,       fread_string( fp ) );

	    break;
	case 'W':
	    break;

	case 'V':
        if ( !str_cmp( word, "V" ) )
	    {
            ch->pIndexData = get_mob_index( fread_number( fp ) );
            if ( ch->pIndexData == NULL )
            ch->pIndexData = get_mob_index( MOB_VNUM_TEMPLATE );

            if ( ch->pIndexData->triggers != NULL )
            {
                TRIGGER_DATA *trig, *pTrig;

                for ( pTrig = ch->pIndexData->triggers;
                      pTrig != NULL;  pTrig = pTrig->next )
                {
                    trig               = new_trigger( );

                    trig->script       = pTrig->script;
                    trig->location     = NULL;

                    trig->next       = ch->triggers;
                    ch->triggers    = trig;
                }
            }

            fMatch = TRUE;
            fVnum  = TRUE;
            break;
	    }
	    break;

	}

	if ( !fMatch )
	{
        sprintf( log_buf, "Fread_mob: no match (%s).", word );
        bug( log_buf, 0 );
        if ( !feof( fp ) ) fread_to_eol( fp );
	}
    }
}


void fread_obj( void *caller, int caller_type, FILE *fp )
{
    OBJ_DATA *obj;
    char *word;
    int iNest;
    bool fMatch;
    bool fNest;
    bool fVnum;
    extern OBJ_DATA *obj_free;     /* From mem.c */
    
    obj     = new_obj( );
    fNest   = FALSE;
    fVnum   = FALSE;
    iNest   = 0;

    for ( ; ; )
    {
	word   = feof( fp ) ? "End" : fread_word( fp );
        fMatch = FALSE;

	switch ( UPPER(word[0]) )
	{
	case '*':
	    fMatch = TRUE;
	    fread_to_eol( fp );
	    break;

	case 'A':
        KEY( "A",        obj->action_descr,   fread_string( fp ) );
        if ( !str_cmp( word, "Af" ) )
	    {
        AFFECT_DATA *paf = new_affect( );

		paf->duration	= fread_number( fp );
		paf->modifier	= fread_number( fp );
		paf->location	= fread_number( fp );
		paf->bitvector	= fread_number( fp );
        paf->next       = obj->affected;
		obj->affected	= paf;
        fMatch          = TRUE;
		break;
	    }
	    break;

	case 'C':
        KEY( "C",    obj->cost,      fread_number( fp ) );
        break;

	case 'D':
        KEY( "D", obj->description,       fread_string( fp ) );
	    break;

	case 'E':
        KEY( "E",  obj->extra_flags,       fread_number( fp ) );

        if ( !str_cmp( word, "Ex" ) )
	    {
        EXTRA_DESCR_DATA *ed = new_extra_descr( );
        ed->keyword          = fread_string( fp );
        ed->description      = fread_string( fp );
        ed->next             = obj->extra_descr;
        obj->extra_descr     = ed;
		fMatch = TRUE;
	    }

        if ( !str_cmp( word, "END" ) )
	    {
		if ( !fNest || !fVnum )
		{
		    bug( "Fread_obj: incomplete object.", 0 );
		    free_string( obj->name        );
		    free_string( obj->description );
            free_string( obj->action_descr );
		    free_string( obj->short_descr );
		    obj->next = obj_free;
		    obj_free  = obj;
		    return;
		}
		else
		{
            obj->next   = object_list;
		    object_list	= obj;
		    obj->pIndexData->count++;
		    if ( iNest == 0 || rgObjNest[iNest] == NULL )
            {
                if ( caller == NULL )
                extract_obj( obj );
                else
                {
                   if ( caller_type == TYPE_MOB )
                   {
                       int flags = obj->extra_flags;
                       obj_to_char( obj, (CHAR_DATA *)caller );
                       if ( IS_SET(flags,ITEM_USED) )
                       SET_BIT(obj->extra_flags,ITEM_USED);
                   }
                   else
                   obj_to_room( obj, (ROOM_INDEX_DATA *)caller );
                }
            }
		    else
			obj_to_obj( obj, rgObjNest[iNest-1] );
		    return;
		}
	    }
	    break;

	case 'I':
        KEY( "I",    obj->item_type,         fread_number( fp ) );
	    break;

	case 'L':
        KEY( "L",       obj->level,             fread_number( fp ) );
	    break;

	case 'N':
        KEY( "N",        obj->name,              fread_string( fp ) );

	    if ( !str_cmp( word, "Nest" ) )
	    {
		iNest = fread_number( fp );
		if ( iNest < 0 || iNest >= MAX_NEST )
		{
		    bug( "Fread_obj: bad nest %d.", iNest );
		}
		else
		{
		    rgObjNest[iNest] = obj;
		    fNest = TRUE;
		}
		fMatch = TRUE;
	    }
	    break;

	case 'S':
        KEY( "S",  obj->short_descr,         fread_string( fp ) );
        KEY( "SP", obj->short_descr_plural,  fread_string( fp ) );
        KEY( "Sz", obj->size,                fread_number( fp ) );

        if ( !str_cmp( word, "Sp" ) )
	    {
		int iValue;
		int sn;

		iValue = fread_number( fp );
		sn     = skill_lookup( fread_word( fp ) );
		if ( iValue < 0 || iValue > 3 )
		{
		    bug( "Fread_obj: bad iValue %d.", iValue );
		}
		else if ( sn < 0 )
		{
		    bug( "Fread_obj: unknown skill.", 0 );
		}
		else
		{
		    obj->value[iValue] = sn;
		}
		fMatch = TRUE;
		break;
	    }

	    break;

	case 'T':
        KEY( "T",       obj->timer,             fread_number( fp ) );
	    break;

	case 'V':
        if ( !str_cmp( word, "Va" ) )
	    {
		obj->value[0]	= fread_number( fp );
		obj->value[1]	= fread_number( fp );
		obj->value[2]	= fread_number( fp );
        obj->value[3]   = fread_number( fp );
		fMatch		= TRUE;
		break;
	    }

        if ( !str_cmp( word, "V" ) )
	    {
        int vnum;
                
        vnum = fread_number( fp );
        if ( ( obj->pIndexData = get_obj_index( vnum ) ) == NULL )
               obj->pIndexData = get_obj_index( OBJ_VNUM_TEMPLATE );
        fVnum = TRUE;
		fMatch = TRUE;
		break;
	    }
	    break;

	case 'W':
        KEY( "W",      obj->wear_flags,        fread_number( fp ) );
        KEY( "WL",     obj->wear_loc,          fread_number( fp ) );
        KEY( "Wt",      obj->weight,            fread_number( fp ) );
	    break;

	}

	if ( !fMatch )
	{
        sprintf( log_buf, "Fread_obj: %s no match.", word );
        bug( log_buf, 0 );
	    fread_to_eol( fp );
	}
    }
}

