/****************************************************************************
 *
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *   ___  ___  ___  __    __                                                *
 *  |   ||   ||   ||  |\/|  | 2-x    NiMUD is a software currently under    *
 *   |  \ | |  | |  | |\/| |         development.  It is based primarily on *
 *   | |\\| |  | |  | |  | |         the discontinued package, Merc 2.2.    *
 *   | | \  |  | |  | |  | |         NiMUD is being written and developed   *
 *  |___||___||___||__|  |__|        By Locke and Surreality as a new,      *
 *   NAMELESS INCARNATE *MUD*        frequently updated package similar to  *
 *        S O F T W A R E            the original Merc 2.x.                 *
 *                                                                          *
 *  Just look for the Iron Maiden skull wherever NiMUD products are found.  *
 *                                                                          *
 *  Much time and thought has gone into this software and you are           *
 *  benefitting.  We hope that you share your changes too.  What goes       *
 *  around, comes around.                                                   *
 ****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "script.h"
#include "function.h"

/*
 * Locals.
 */
char * eval_expression        args( ( void * caller, int type, char *exp ) );



/*
 * Returns the currently parsing trigger of the caller.
 */
TRIGGER_DATA *curtrig( void * caller, int type )
{
    OBJ_DATA *obj;
    CHAR_DATA *ch;
    ROOM_INDEX_DATA *room;

    switch ( type )
    {
       case TYPE_OBJ:  obj  = (OBJ_DATA *)caller;        return obj->current;
       case TYPE_MOB:  ch   = (CHAR_DATA *)caller;       return ch->current;
       case TYPE_ROOM: room = (ROOM_INDEX_DATA *)caller; return room->current;
        default:
         bug( "Curtrig: Invalid requested caller-type.", 0 );
         return NULL;
    }
}



/*
 * Return a pointer to the globals of a said caller.
 */
VARIABLE_DATA **varlist( void * caller, int type )
{
    OBJ_DATA *obj;
    CHAR_DATA *ch;
    ROOM_INDEX_DATA *room;

    switch ( type )
    {
       case TYPE_OBJ: obj  = (OBJ_DATA *)caller;        return &obj->globals;
       case TYPE_MOB: ch   = (CHAR_DATA *)caller;       return &ch->globals;
      case TYPE_ROOM: room = (ROOM_INDEX_DATA *)caller; return &room->globals;
             default: bug( "Varlist: Invalid requested caller-type.", 0 );
                      return NULL;
    }
}



/*
 * Searches a variable list for a variable with supplied name.
 */
VARIABLE_DATA *get_variable( VARIABLE_DATA **vlist, char *name )
{
    VARIABLE_DATA *v;

    for ( v = *vlist;  v != NULL;  v = v->next )
    {
        if ( !str_cmp( v->name, name ) )
        break;
    }

    return v;
}



/*
 * Searches a caller list for a variable with supplied name.
 */
VARIABLE_DATA *find_variable( void * caller, int type, char *name )
{
    VARIABLE_DATA *v;
    TRIGGER_DATA *trig = curtrig(caller,type);

    if ( trig )
    {
        for ( v = trig->locals;  v != NULL;  v = v->next )
        {
            if ( !str_cmp( v->name, name ) )
            break;
        }

        if ( v ) return v;
    }


    for ( v = *varlist(caller,type);  v != NULL;  v = v->next )
    {
        if ( !str_cmp( v->name, name ) )
        break;
    }

    return v;
}



/*
 * Grabs a variable from the beginning of an argument, *argument must be
 * pointing to first %.
 */
char *grab_variable( char *argument, char *vname )
{
    argument = skip_spaces( argument );
    if ( *argument != '%' )
    {
        *vname = '\0';
        return argument;
    }

    *vname++ = *argument++;
    while ( *argument != '%' && *argument != '\0' ) *vname++ = *argument++;

    *vname++ = '%';
    *vname++ = '\0';

    return skip_spaces( ++argument );
}



/*
 * Translates all variables on said caller's expression if string,
 * except those contained within literal statements.
 */
char *translate_variables( void * caller, int type, char *exp )
{
    VARIABLE_DATA *var;
    char buf[MAX_STRING_LENGTH];
    char *point;
    char *vpoint;
    char vname[MAX_STRING_LENGTH];


    point = buf;
    while ( *exp != '\0' )
    {
        if ( *exp == '%' )
        {
            vname[0] = '\0';
            vpoint = vname;

            /*
             * %variable%
             * ^
             */
            while ( *exp != '\0' )
            {
                *vpoint++ = *exp++;

                if ( *exp == '%' )
                    break;
            }

            *vpoint++ = *exp++;
            *vpoint = '\0';

            var = find_variable( caller, type, vname );

            if ( var != NULL
             && var->type == TYPE_STRING )
            {
                vpoint = var->value;
                while ( !MTD(vpoint) ) *point++ = *vpoint++;
            }
            else
            {
                vpoint = vname;
                while ( *vpoint != '\0' ) *point++ = *vpoint++;
            }
        }
        else
        {
            /*
             * Jump past literals.
             */
            if ( *exp == '{' )
            {
                int curlies = 0;

                *point++ = *exp++;
                while( *exp != '\0' )
                {

                    /*
                     * Ok, get the hell out of here, we're done.
                     * { .... }
                     *        ^
                     */
                    if ( curlies == 0 )
                       if ( *exp == '}'
                         || *exp == '\0' )
                         break;

                    if ( *exp == '{' ) curlies++;
                    else
                    if ( *exp == '}' ) curlies--;

                    *point++ = *exp++;
                }

                if ( curlies != 0 )
                NOTIFY("Notify>  Translate_variables: Unmatched {}s in literal.", LEVEL_IMMORTAL, WIZ_NOTIFY_SCRIPT);

                if ( *exp == '}' ) *point++ = *exp++;
            }
            else
            *point++ = *exp++;
        }
    }

    *point = '\0';

    return str_dup( buf );
}




/*
 * Receives: func(param, .... )
 * Breaks up parameters, and recurses into each.
 *
 * To add a new function, simply add it to the long if-statements.
 */
VARIABLE_DATA *eval_function( void * caller, int type, char *exp )
{
    VARIABLE_DATA *value;
    char func_name[MAX_STRING_LENGTH];
    char buf[MAX_STRING_LENGTH];
    char params [MAX_PARAMS][MAX_STRING_LENGTH];
    VARIABLE_DATA *ppoint[MAX_PARAMS];
    char *point;
    char *original;
    int x;

    if ( *exp == '\0' ) return NULL;
    if ( *exp == '{'  )
    {
        value = new_variable( );
        value->value = str_dup( exp );
        value->type  = TYPE_STRING;
        return value;
    }
    original = exp;

    /*
     * Prepare the pointers for the parameters.
     */
    for ( x = 0; x < MAX_PARAMS; x++ )
    {
        params[x][0] = '\0';
        ppoint[x] = NULL;
    }

    /*
     * Grab the function name.
     * func(param, .... )
     * ^
     */
    exp = skip_spaces( exp );
    point = func_name;
    while ( *exp != '('
         && *exp != ' '
         && *exp != '\0' ) *point++ = *exp++;
    *point = '\0';
    exp = skip_spaces( exp );

    /*
     * Grab and evaluate, recursively, each parameter.
     * func(param, .... )
     *     ^
     */
    if ( *exp != '\0' ) exp++;
    for ( x = 0;  (*exp != '\0') && (x < MAX_PARAMS);  x++ )
    {
        int param_paren = 0;

        /*
         * Grab the parameters.
         * func(param, .... )
         *      ^---^  ^--^
         *        1  to  x
         */

        point = params[x];
        while( *exp != '\0' )
        {
            /*
             * Jump past literals.
             */
            if ( *exp == '{' )
            {
                int curlies = 0;

                *point++ = *exp++;
                while( *exp != '\0' )
                {

                    /*
                     * Ok, get the hell out of here, we're done.
                     * { .... }
                     *        ^
                     */
                    if ( curlies == 0 )
                       if ( *exp == '}'
                         || *exp == '\0' )
                         break;

                    if ( *exp == '{' ) curlies++;
                    else
                    if ( *exp == '}' ) curlies--;

                    *point++ = *exp++;
                }

                if ( curlies != 0 )
                NOTIFY("Notify>  Eval_function: Unmatched {}s in literal.", LEVEL_IMMORTAL, WIZ_NOTIFY_SCRIPT);

                if ( *exp == '}' ) *point++ = *exp++;
            }

            /*
             * Ok, get the hell out of here, we're done.
             * func(param, .... )
             *           ^  or  ^
             */
            if ( param_paren == 0 )
                if ( *exp == ','
                  || *exp == ')'
                  || *exp == '\0' )
                {
                    if ( *exp == ',' || *exp == ')' ) exp++;
                    break;
                }


            if ( *exp == '(' ) param_paren++;
            else
            if ( *exp == ')' ) param_paren--;

            if ( *exp == ' ' ) exp++;
            else *point++ = *exp++;
        }

        *point = '\0';

        /*
         * Evaluate each one.
         */

        ppoint[x] = eval_function( caller, type, params[x] );

   /*     bug( "params[%d]:", x );
          bug( params[x],0 );
          bug( ppoint[x],0 );         */
    }


    buf[0] = '\0';

    /*
     * Remember, ppoint[] now contains the evaluated values.
     */
    FUNC("goto",     func_goto    (caller, type, ppoint[0]) );
    else
    FUNC("if",       func_if      (caller, type, ppoint[0], ppoint[1], ppoint[2]) );
    else
    FUNC("label",    func_label   (caller, type) );
    else
    FUNC("return",   func_return  (caller, type, ppoint[0]) );
    else
    FUNC("halt",     func_halt    (caller, type, ppoint[0]) );
    else
    FUNC("permhalt", func_permhalt(caller, type ) );
    else
    FUNC("wait",     func_wait    (caller, type, ppoint[0]) );
    else
    FUNC("autowait", func_autowait(caller, type, ppoint[0]) );
    else
    FUNC("call",     func_call    (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("self",     func_self    (caller, type, ppoint[0]) );
    else
    FUNC("cmp",      func_cmp     (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("not",      func_not     (caller, type, ppoint[0]) );
    else
    FUNC("or",       func_or      (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("and",      func_and     (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("less",     func_less    (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("greater",  func_greater (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("pre",      func_pre     (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("in",       func_in      (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("strstr",   func_strstr  (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("add",      func_add     (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("sub",      func_sub     (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("mult",     func_mult    (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("div",      func_div     (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("mod",      func_mod     (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("random",   func_random  (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("band",     func_band    (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("bor",      func_bor     (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("bxor",     func_bxor    (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("cat",      func_cat     (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("word",     func_word    (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("out",      func_out     (caller, type, ppoint[0], ppoint[1], ppoint[2], ppoint[3], ppoint[4]) );
    else
    FUNC("numw",     func_numw    (caller, type, ppoint[0]) );
    else
    FUNC("strp",     func_strp    (caller, type, ppoint[0], ppoint[1], ppoint[2]) );
    else
    FUNC("do",       func_do      (caller, type, ppoint[0], ppoint[1], ppoint[2], ppoint[3], ppoint[4], ppoint[5] ) );
    else
    FUNC("ms",       func_ms      (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("os",       func_os      (caller, type, ppoint[0], ppoint[1]) );
    else
    FUNC("sameroom", func_sameroom(caller, type, ppoint[0]) );
    else
    FUNC("e",        func_eval    (caller, type, ppoint[0]) );
    else
    FUNC("rndplr",   func_rndplr  (caller, type) );
    else
    {
        value = new_variable();
        value->type = TYPE_STRING;
        value->value = str_dup( original );
    }

    /*
     * Flush the parameters.
     */
    for ( x = 0; x < MAX_PARAMS; x++ ) free_variable( ppoint[x] );
    return value;
}



/*
 * Assigns a variable, creating a new one if required.
 * Note string routines imbedded in procedure.
 */
void assign_var( void * caller, int type, VARIABLE_DATA *var, char *name )
{
    VARIABLE_DATA *v;
    TRIGGER_DATA *trig = curtrig(caller,type);

    v = find_variable( caller, type, name );

    if ( v == NULL && trig == NULL )
    return;

    if ( v )
    {
        if ( v->type == TYPE_STRING )
        {
            free_string( (char *)v->value );
            v->value = NULL;
        }
    }
    else
    {
        v = new_variable( );
        v->next = trig->locals;
        trig->locals = v;
        v->name = str_dup( name );
    }

    v->type = var->type;
    v->value = var->type == TYPE_STRING ? str_dup( var->value ) : var->value;

    return;
}



/*
 * Handles assignment statements
 */
void parse_assign( TRIGGER_DATA *trig, char *line, void * caller, int type )
{
    char vname[MAX_STRING_LENGTH];
    VARIABLE_DATA *value;

    line = grab_variable( line, vname );
    value = eval_function( caller, type, line );
    assign_var( caller, type, value, vname );
    free_variable(value);
    return;
}




/*
 * The script parser
 */
void parse_script( TRIGGER_DATA *trig, void * caller, int type )
{
    CHAR_DATA *ch;
    OBJ_DATA *obj;
    ROOM_INDEX_DATA *room;
    char buf[MAX_STRING_LENGTH];
    char *commands;

    if ( trig == NULL )
    {
        bug( "Parse_script: NULL trig.", 0 );
        return;
    }

    switch ( type )
    {
       case TYPE_OBJ:
         obj  = (OBJ_DATA *)caller;
         obj->current  = trig;
        break;
       case TYPE_MOB:
         ch   = (CHAR_DATA *)caller;
         ch->current   = trig;
        break;
       case TYPE_ROOM:
         room = (ROOM_INDEX_DATA *)caller;
         room->current = trig;
        break;
       default:
         bug( "Parse_script: Invalid requested caller-type.", 0 );
        break;
    }

    if ( trig->wait != 0 ) trig->wait--;
    gotoloops = 0;

    while ( !IS_SET(trig->bits, SCRIPT_HALT)
         && !MTD(trig->location)
         && trig->wait == 0 )
    {
        /*
         * Advance a line.
         */
        trig->location = one_line( trig->location, buf );
        commands = skip_spaces( buf );

        if ( *commands == '\0' ) continue;

        if ( *commands == '%' )
        parse_assign( trig, commands, caller, type );
        else
        {
            VARIABLE_DATA *value;

            value = eval_function( caller, type, commands );
            free_variable( value );
        }

        if ( trig->autowait) trig->wait = trig->autowait;
    }

    if ( MTD(trig->location) )
    {
        VARIABLE_DATA *pVar, *pVar_next;

        for ( pVar = trig->locals;  pVar != NULL; pVar = pVar_next )
        {
            pVar_next = pVar->next;
            free_variable( pVar );
        }

        trig->locals = NULL;
        trig->location = NULL;
    }
    return;
}



/*
 * Triggers a trigger on said caller by beginning the parse.
 */
int trigger( void * caller, int type, TRIGGER_DATA *trig )
{
    int returned;

    trig->location = trig->script->commands;
    parse_script( trig, caller, type );
    returned = trig->returned;                 /* Save returned value.    */
    trig->returned = 0;                        /* Default returned value. */
    return returned;
}



/*
 * Quick and dirty multi-purpose script caller, used in most hard-code calls.
 */
int script_update( void * caller, int type, int ttype, CHAR_DATA *actor,
                    OBJ_DATA *catalyst, char *astr, char *bstr  )
{
    TRIGGER_DATA *trig;
    ROOM_INDEX_DATA *room =NULL;
    CHAR_DATA *ch =NULL;
    OBJ_DATA *obj =NULL;
    int returned = 0;
    
    switch ( type )
    {
       case TYPE_OBJ:  obj = (OBJ_DATA *)caller; trig = obj->triggers; break;

       case TYPE_MOB:  ch  = (CHAR_DATA *)caller; trig = ch->triggers; break;

       case TYPE_ROOM: room = (ROOM_INDEX_DATA *)caller; trig = room->triggers;
                       break;

       default: trig = NULL;
                bug( "Trigger: Invalid requested caller-type.", 0 );   break;
    }
    
    for ( ; trig != NULL; trig = trig->next )
    {
        if ( trig->script->type != ttype
          || trig->location != NULL )
        continue;

        {
            TRIGGER_DATA *oldtrig = curtrig(caller,type);
            VARIABLE_DATA *var;

            switch ( type )
            {
               case TYPE_OBJ:  obj->current  = trig; break;
               case TYPE_MOB:  ch->current   = trig; break;
               case TYPE_ROOM: room->current = trig; break;
               default: break;
            }

            var = new_variable( );

            if ( actor )
            {
                var->type  = TYPE_MOB;
                var->value = (CHAR_DATA *)actor;
                assign_var( caller, type, var, "%actor%" );
            }

            if ( catalyst )
            {
                var->type = TYPE_OBJ;
                var->value = (OBJ_DATA *)catalyst;
                assign_var( caller, type, var, "%catalyst%" );
            }

            if ( astr )
            {
                var->type = TYPE_STRING;
                var->value = str_dup( astr );
                assign_var( caller, type, var, "%astr%" );
            }

            if ( bstr )
            {
                var->type = TYPE_STRING;
                var->value = str_dup( bstr );
                assign_var( caller, type, var, "%bstr%" );
            }

            switch ( type )
            {
               case TYPE_OBJ:  obj->current  = oldtrig; break;
               case TYPE_MOB:  ch->current   = oldtrig; break;
               case TYPE_ROOM: room->current = oldtrig; break;
               default: break;
            }

            free_variable( var );
        }
          
        if ( (returned = trigger(caller, type, trig)) ) break;
    }
    
    return returned;
}



/*
 * Triggers a list of objects, like above, quick and dirty.
 */
void trigger_list( OBJ_DATA *list, int ttype, CHAR_DATA  *actor,
                  OBJ_DATA *catalyst, char *astr, char *bstr )
{
    OBJ_DATA *obj, *obj_next;

    for ( obj = list;  obj != NULL;  obj = obj_next )
    {
        obj_next = obj->next_content;

        script_update( obj, TYPE_OBJ, ttype, actor, catalyst, astr, bstr );
    }

    return;
}





/*
 * This little command helps a user debug the scripts online.  It can give
 * information about a single trigger, or general info on the mob's current
 * state of execution.
 */
void do_script( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_STRING_LENGTH];
    char arg2[MAX_STRING_LENGTH];
    void * caller;
    int type;

    return;
}
