/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */

/*
 * Trigger types for repetitive loops, command etc.
 */
#define TRIG_COMMAND        0  /* All       = When a Command is Typed        */
#define TRIG_EACH_PULSE     1  /* Mobs/Objs = Triggered Each Pulse           */
#define TRIG_COMBAT         2  /* All       = Each Round                     */
#define TRIG_TICK_PULSE     3  /* Mobs/Objs = Tick       Room = When Reset   */
#define TRIG_BORN           4  /* Mobs/Objs = Creation   Room = On Startup   */
#define TRIG_GETS           5  /* Objs      = When Taken                     */
#define TRIG_SAY            6  /* All       = Any communications (NFI)       */

#define TRIG_KILLS          8  /* Mobs/Objs = Kills                          */
#define TRIG_DIES           9  /* Mobs      = Dies  Objs/Room = Dies Nearby  */
#define TRIG_ENTER         10  /* All       = Someone Enters                 */
#define TRIG_MOVES         11  /* Mobs/Room = Someone Leaves                 */

#define TRIG_LOOKS	   12  /* All	    = Called when looked at.	     */

/*
 * Internally used bits for triggers.
 */
#define SCRIPT_HALT         0x00000001   /* current=NULL & disallow trig     */

#define MAX_LOOPS           1000   /* Max number of total goto()s per script */


#define TYPE_OBJ            0
#define TYPE_ROOM           1
#define TYPE_MOB            2
#define TYPE_STRING         3
#define TYPE_ALIAS          4

#define MAX_PARAMS          6

#define FUNC(str, function_call)                \
 if ( !str_cmp(func_name, str) ) value = function_call

/* script.c */
TRIGGER_DATA * curtrig args( ( void * caller, int type ) );
VARIABLE_DATA **  varlist   args( ( void * caller, int type ) );

void trigger_list       args( ( OBJ_DATA *list, int ttype, CHAR_DATA  *actor,
                               OBJ_DATA *catalyst, char *astr, char *bstr ) );
int script_update      args( ( void * caller, int type, int ttype,
                               CHAR_DATA *actor, OBJ_DATA *catalyst,
                               char *astr, char *bstr  ) );
void parse_script      args( ( TRIGGER_DATA *trig, void * caller, int type ) );
