/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "skills.h"
#include "shop.h"
#include "defaults.h"


/*
 * Goods list.
 */

const     struct   goods_type    goods_table    [] =
{  /* Name                      Unit           Code      Cost  Wght  Life */
    /* Raw Grain */
    { "barley",                 "dustone",     T_CORN,   100,    2,   -1  },
    { "buckwheat",              "dustone",     T_CORN,    50,    2,   -1  },
    { "chick peas",             "dustone",     T_CORN,   300,    2,   -1  },
    { "lentils",                "dustone",     T_CORN,   200,    2,   -1  },
    { "millet",                 "dustone",     T_CORN,    30,    2,   -1  },
    { "oats",                   "dustone",     T_CORN,    70,    2,   -1  },
    { "rice",                   "dustone",     T_CORN,   500,    2,   -1  },
    { "rye",                    "dustone",     T_CORN,    70,    2,   -1  },
    { "wheat berries",          "dustone",     T_CORN,   200,    2,   -1  },

    /* Flour */
    { "floured barley",         "sack",        T_FLOUR,  200,    5,   -1  },
    { "buckwheat flour",        "sack",        T_FLOUR,  100,    5,   -1  },
    { "floured rye",            "sack",        T_FLOUR,  150,    5,   -1  },
    { "wheat flour",            "sack",        T_FLOUR,  300,    5,   -1  },

    /* Fabrics */
    { "canvas",                 "bolt",        T_FABRIC,  30,    4,   -1  },
    { "cotton",                 "bolt",        T_FABRIC,  80,    4,   -1  },
    { "wool flannel",           "bolt",        T_FABRIC,  24,    4,   -1  },
    { "homespun",               "bolt",        T_FABRIC,  15,    4,   -1  },
    { "lace",                   "tenspan",     T_FABRIC, 500,    1,   -1  },
    { "linen",                  "bolt",        T_FABRIC,  80,    4,   -1  },
    { "raw wool",               "stone",       T_FABRIC,   2,    1,   -1  },
    { "sailcloth",              "tenspan",     T_FABRIC,  10,    1,   -1  },
    { "silk",                   "tenspan",     T_FABRIC, 700,    1,   -1  },
    { "mattress ticking",       "tenspan",     T_FABRIC, 100,    1,   -1  },
    { "pillow ticking",         "tenspan",     T_FABRIC,  80,    1,   -1  },
    { "velvet",                 "tenspan",     T_FABRIC, 300,    1,   -1  },
    { "wool",                   "bolt",        T_FABRIC, 100,    4,   -1  },

    /* Furs */
    { "bear",                   "fur",         T_HIDE,   500,   12,   -1  },
    { "deer",                   "hide",        T_HIDE,   400,   10,   -1  },
    { "red fox",                "hide",        T_HIDE,  1400,    2,   -1  },
    { "white fox",              "hide",        T_HIDE,  1700,    2,   -1  },
    { "horse",                  "hide",        T_HIDE,   300,   13,   -1  },
    { "jaguar",                 "hide",        T_HIDE,  2500,    6,   -1  },
    { "leather",                "hide",        T_HIDE,   200,    6,   -1  },
    { "leopard",                "hide",        T_HIDE,  2200,    6,   -1  },
    { "lion",                   "hide",        T_HIDE,  2400,    7,   -1  },
    { "mink",                   "fur",         T_HIDE,  1200,    3,   -1  },
    { "panther",                "hide",        T_HIDE,  1500,    6,   -1  },
    { "raccoon",                "fur",         T_HIDE,   200,    2,   -1  },
    { "shark",                  "skin",        T_HIDE,  1500,    7,   -1  },
    { "sheep",                  "hide",        T_HIDE,   600,    4,   -1  },
    { "tiger",                  "hide",        T_HIDE,  2500,    7,   -1  },
    { "wolf",                   "hide",        T_HIDE,   800,    4,   -1  },

    /* Dyes */
    { "copper blue",            "vial",        T_DYE,    330,    1,   -1  },
    { "ultramarine blue",       "vial",        T_DYE,    100,    1,   -1  },
    { "mollusk green",          "vial",        T_DYE,     90,    1,   -1  },
    { "indigo",                 "vial",        T_DYE,    300,    1,   -1  },
    { "ocher",                  "vial",        T_DYE,    120,    1,   -1  },
    { "purple",                 "vial",        T_DYE,    330,    1,   -1  },
    { "cochineal red",          "vial",        T_DYE,     40,    1,   -1  },
    { "iron red",               "vial",        T_DYE,     50,    1,   -1  },
    { "mollusk red",            "vial",        T_DYE,     50,    1,   -1  },
    { "safflower dye",          "vial",        T_DYE,     40,    1,   -1  },
    { "sulfer yellow",          "vial",        T_DYE,     30,    1,   -1  },
    { "vermilion dye",          "vial",        T_DYE,     44,    1,   -1  },

    /* Refined metals */
    { "refined brass",          "bar",         T_METAL,   10,    2,   -1  },
    { "refined bronze",         "bar",         T_METAL,    7,    2,   -1  },
    { "refined copper",         "bar",         T_METAL,    6,    2,   -1  },
    { "refined gold",           "bar",         T_METAL, 1100,    2,   -1  },
    { "refined iron",           "bar",         T_METAL,    5,    2,   -1  },
    { "refined lead",           "bar",         T_METAL,    7,    2,   -1  },
    { "refined platinum",       "half bar",    T_METAL, 2000,    1,   -1  },
    { "refined silver",         "bar",         T_METAL,  300,    2,   -1  },
    { "refined tin",            "bar",         T_METAL,   20,    2,   -1  },

    /* Raw metals */
    { "brass ore",              "nugget",      T_ORE,      2,    1,   -1  },
    { "bronze ore",             "nugget",      T_ORE,      3,    1,   -1  },
    { "copper ore",             "nugget",      T_ORE,      2,    1,   -1  },
    { "gold ore",               "nugget",      T_ORE,    350,    1,   -1  },
    { "iron ore",               "nugget",      T_ORE,      1,    1,   -1  },
    { "lead ore",               "nugget",      T_ORE,      3,    1,   -1  },
    { "platinum ore",           "nugget",      T_ORE,    700,    1,   -1  },
    { "silver ore",             "nugget",      T_ORE,    100,    1,   -1  },
    { "tin ore",                "nugget",      T_ORE,      7,    1,   -1  },

    /* Seasonings */
    {  "angelica",              "jar",         T_SPICE,    3,    1,   -1  },
    {  "anise",                 "jar",         T_SPICE,    8,    1,   -1  },
    {  "basil",                 "jar",         T_SPICE,    2,    1,   -1  },
    {  "bergamot",              "jar",         T_SPICE,    5,    1,   -1  },
    {  "borage",                "jar",         T_SPICE,    5,    1,   -1  },
    {  "calendula",             "jar",         T_SPICE,    4,    1,   -1  },
    {  "caraway",               "jar",         T_SPICE,    2,    1,   -1  },
    {  "chervil",               "jar",         T_SPICE,    4,    1,   -1  },
    {  "chives",                "jar",         T_SPICE,    2,    1,   -1  },
    {  "clary",                 "jar",         T_SPICE,    6,    1,   -1  },
    {  "coriander",             "jar",         T_SPICE,    6,    1,   -1  },
    {  "costmary",              "jar",         T_SPICE,    5,    1,   -1  },
    {  "cumin",                 "jar",         T_SPICE,    7,    1,   -1  },
    {  "dillweed",              "jar",         T_SPICE,    3,    1,   -1  },
    {  "sweet herbs",           "fagot",       T_SPICE,   10,    1,   -1  },
    {  "fennel seed",           "jar",         T_SPICE,    2,    1,   -1  },
    {  "fenugreek",             "jar",         T_SPICE,    3,    1,   -1  },
    {  "garlic",                "jar",         T_SPICE,    2,    1,   -1  },
    {  "horehound",             "jar",         T_SPICE,    5,    1,   -1  },
    {  "horseradish",           "jar",         T_SPICE,    6,    1,   -1  },
    {  "hyssop",                "jar",         T_SPICE,    9,    1,   -1  },
    {  "juniper",               "jar",         T_SPICE,    9,    1,   -1  },
    {  "laurel",                "jar",         T_SPICE,    8,    1,   -1  },
    {  "lemon balm",            "jar",         T_SPICE,    4,    1,   -1  },
    {  "liquorice root",        "jar",         T_SPICE,    3,    1,   -1  },
    {  "lovage",                "jar",         T_SPICE,    6,    1,   -1  },
    {  "marigold",              "jar",         T_SPICE,   12,    1,   -1  },
    {  "marjoram",              "jar",         T_SPICE,    6,    1,   -1  },
    {  "mint",                  "jar",         T_SPICE,    7,    1,   -1  },
    {  "mustard seed",          "jar",         T_SPICE,    3,    1,   -1  },
    {  "oregano",               "jar",         T_SPICE,    4,    1,   -1  },
    {  "parsley",               "jar",         T_SPICE,    4,    1,   -1  },
    {  "poppy seed",            "jar",         T_SPICE,    2,    1,   -1  },
    {  "rose hips",             "jar",         T_SPICE,   15,    1,   -1  },
    {  "rosemary",              "jar",         T_SPICE,    5,    1,   -1  },
    {  "sage",                  "jar",         T_SPICE,    6,    1,   -1  },
    {  "salt",                  "jar",         T_SPICE,    1,    1,   -1  },
    {  "winter savory",         "jar",         T_SPICE,    7,    1,   -1  },
    {  "summer savory",         "jar",         T_SPICE,    7,    1,   -1  },
    {  "sweet cicely",          "jar",         T_SPICE,    8,    1,   -1  },
    {  "tarragon",              "jar",         T_SPICE,    7,    1,   -1  },
    {  "thyme",                 "jar",         T_SPICE,    8,    1,   -1  },
    {  "woodruff",              "jar",         T_SPICE,   10,    1,   -1  },

    /* Spices */
    {  "canella",               "sachet",      T_SPICE,    6,    1,   -1  },
    {  "cardamon",              "sachet",      T_SPICE,    6,    1,   -1  },
    {  "cinnamon",              "fagot",       T_SPICE,    5,    1,   -1  },
    {  "cloves",                "sachet",      T_SPICE,    7,    1,   -1  },
    {  "cubeb",                 "sachet",      T_SPICE,    6,    1,   -1  },
    {  "galingale",             "sachet",      T_SPICE,    8,    1,   -1  },
    {  "ginger",                "sachet",      T_SPICE,    3,    1,   -1  },
    {  "mace",                  "sachet",      T_SPICE,    2,    1,   -1  },
    {  "nutmeg",                "sachet",      T_SPICE,    5,    1,   -1  },
    {  "black pepper",          "sachet",      T_SPICE,    7,    1,   -1  },
    {  "red pepper",            "sachet",      T_SPICE,    8,    1,   -1  },
    {  "white pepper",          "sachet",      T_SPICE,    9,    1,   -1  },
    {  "saffron",               "sachet",      T_SPICE,    4,    1,   -1  },
    {  "turmeric",              "sachet",      T_SPICE,    6,    1,   -1  },

    /* Sweeteners */
    {  "rose petal honey",      "jar",         T_SUGAR,   20,    1,   -1  },
    {  "parsley honey",         "jar",         T_SUGAR,   12,    1,   -1  },
    {  "lavander honey",        "jar",         T_SUGAR,   15,    1,   -1  },
    {  "marzipan",              "jar",         T_SUGAR,   30,    1,   -1  },
    {  "molasses",              "jar",         T_SUGAR,   20,    1,   -1  },
    {  "sorghum",               "jar",         T_SUGAR,   10,    1,   -1  },
    {  "brown sugar",           "sack",        T_SUGAR,   10,    3,   -1  },
    {  "lavender sugar",        "sack",        T_SUGAR,   15,    2,   -1  },
    {  "loaf sugar",            "sack",        T_SUGAR,   12,    3,   -1  },
    {  "lemon sugar",           "sack",        T_SUGAR,   15,    2,   -1  },
    {  "mace sugar",            "sack",        T_SUGAR,   14,    2,   -1  },
    {  "orange sugar",          "sack",        T_SUGAR,   18,    2,   -1  },
    {  "powdered sugar",        "sack",        T_SUGAR,   20,    1,   -1  },
    {  "raw sugar",             "sack",        T_SUGAR,    8,    5,   -1  },
    {  "rose sugar",            "sack",        T_SUGAR,   25,    2,   -1  },
    {  "violet sugar",          "sack",        T_SUGAR,   22,    3,   -1  },

    /* Oils */
    {  "almond oil",            "flask",       T_OIL,     30,    1,   -1  },
    {  "hazelnut oil",          "flask",       T_OIL,     30,    1,   -1  },
    {  "herbal oil",            "flask",       T_OIL,     50,    1,   -1  },
    {  "olive oil",             "flask",       T_OIL,     10,    1,   -1  },
    {  "rapeseed oil",          "flask",       T_OIL,     20,    1,   -1  },
    {  "safflower oil",         "flask",       T_OIL,     30,    1,   -1  },
    {  "sesame oil",            "flask",       T_OIL,     50,    1,   -1  },
    {  "sunflower oil",         "flask",       T_OIL,     40,    1,   -1  },
    {  "walnut oil",            "flask",       T_OIL,     50,    1,   -1  },

    { "",                       "",               -1,      0,    0,   -1  },
};

                                                            
OBJ_DATA *create_good( int good )
{
   OBJ_DATA *obj;
   char buf[MAX_STRING_LENGTH];
    
   obj = create_object( get_obj_index(OBJ_VNUM_GOODS), 0 );
     
   sprintf( buf, "%s %s", goods_table[good].name,
                          goods_table[good].unit );
   free_string( obj->name );
   obj->name = str_dup( buf );
   
   sprintf( buf, "a %s of %s", goods_table[good].unit, 
                               goods_table[good].name );
   free_string( obj->short_descr );
   obj->short_descr = str_dup( buf );
   
   sprintf( buf, "%ss of %s", goods_table[good].unit,
                             goods_table[good].name );
   free_string( obj->short_descr_plural );
   obj->short_descr_plural = str_dup( buf );

   sprintf( buf, "%s was placed here.\n\r", STR(obj,short_descr) );
   free_string( obj->description );
   obj->description = str_dup( buf );

   obj->item_type = ITEM_GOODS;
   obj->weight    = goods_table[good].weight;
   obj->cost      = goods_table[good].cost;
   obj->timer     = goods_table[good].life;
   obj->value[0]  = good;

   return obj;
}



OBJ_DATA *create_comp( int comp )
{
   OBJ_DATA *obj;
   char buf[MAX_STRING_LENGTH];
    
   obj = create_object( get_obj_index(OBJ_VNUM_COMP), 0 );
     
   sprintf( buf, "%s %s component",
                 smash_article( smash_arg( comp_table[comp].usage, "of" ) ),
                 comp_table[comp].name );
   free_string( obj->name );
   obj->name = string_unpad( str_dup(buf) );
   
   sprintf( buf, "%s %s", comp_table[comp].usage,
                          comp_table[comp].name );
   free_string( obj->short_descr );
   obj->short_descr = str_dup( buf );
   
   sprintf( buf, "%s components",   comp_table[comp].name );
   free_string( obj->short_descr_plural );
   obj->short_descr_plural = str_dup( buf );

   sprintf( buf, "%s was left here.\n\r", STR(obj,short_descr) );
   free_string( obj->description );
   obj->description = str_dup( buf );
   
   obj->item_type = ITEM_COMPONENT;
   obj->weight    = 1;
   obj->cost      = comp_table[comp].cost;
   obj->timer     = -1;
   obj->value[0]  = comp;
   obj->value[1]  = comp_table[comp].type;

   return obj;
}


/*
struct  shop_data
*/


/*
 * Show the shop list to a character.
 * Can coalesce duplicated items.
 */
void shop_list_to_char( CHAR_DATA *keeper, CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];
    char final[MAX_STRING_LENGTH*2];
    char **prgpstrShow;
    int *prgnShow;
    char *pstrShow;
    OBJ_DATA **lastobj;
    OBJ_DATA *obj;
    int nShow, iShow, vShow;
    int count;
    bool fCombine;
    OBJ_DATA *list = keeper->carrying;

    if ( ch->desc == NULL )
	return;
    
    /*
     * Alloc space for output lines.
     */
    count = 0;
    for ( obj = list; obj != NULL; obj = obj->next_content )
	count++;
    prgpstrShow	= alloc_mem( count * sizeof(char *) );
    prgnShow    = alloc_mem( count * sizeof(int)    );
    lastobj     = alloc_mem( count * sizeof(OBJ_DATA *) );
    nShow = 0;

    /*
     * Format the list of objects.
     */
    for ( obj = list; obj != NULL; obj = obj->next_content )
    {
        if ( obj->wear_loc == WEAR_NONE
          && can_see_obj( ch, obj ) )
        {
            pstrShow = format_obj_to_char( obj, ch, TRUE );
            fCombine = FALSE;

            /*
             * Look for duplicates, case sensitive.
             * Matches tend to be near end so run loop backwards.
             */
            for ( iShow = nShow - 1; iShow >= 0; iShow-- )
            {
                if ( ( !strcmp( prgpstrShow[iShow], pstrShow )
                     || lastobj[iShow] == obj )
                   && obj->item_type != ITEM_MONEY )
                {
                ++prgnShow[iShow];
                lastobj[iShow] = obj;
                fCombine = TRUE;
                break;
                }
            }

            /*
             * Couldn't combine, or didn't want to.
             */
            if ( !fCombine )
            {
            prgpstrShow [nShow] = str_dup( pstrShow );
            prgnShow    [nShow] = 1;
            lastobj     [nShow] = obj;
            nShow++;
            }
        }
    }

    /*
     * Output the formatted list.
     */
    vShow = 1;
    final[0] = '\0';
    for ( iShow = 0; iShow < nShow; iShow++ )
    {
        if ( lastobj[iShow] == NULL )
        {
            bug( "Shop_list_to_char: lastobj == NULL.", 0 );
            continue;
        }

        if ( lastobj[iShow]->item_type == ITEM_MONEY )
        continue;

        if ( prgnShow[iShow] > 1
          && !IS_SET(keeper->pIndexData->pShop->shop_flags, SHOP_TAVERN) )
            sprintf( buf, "#%-2d %s for %s each.\n\r",
                 vShow,
                 capitalize(
                    pluralize( (lastobj[iShow]->item_type == ITEM_DRINK_CON
                             && lastobj[iShow]->value[0] > 0)
                          ? format_obj_to_char(lastobj[iShow],ch,TRUE)
                          : STR(lastobj[iShow],short_descr)
                             )
                           ),
                 name_amount( get_cost( keeper, lastobj[iShow], TRUE ) )
                  );
/*
            sprintf( buf, "*%-2d  %s %s for %s each.\n\r",
                          iShow+1,
                          capitalize(numberize(prgnShow[iShow])),
                          pluralize( ( lastobj[iShow]->item_type == ITEM_DRINK_CON
                                    && lastobj[iShow]->value[0] > 0 )
                                       ? format_obj_to_char(lastobj[iShow],ch,TRUE)
                                       : STR(lastobj[iShow],short_descr)),
                          name_amount( get_cost( keeper, lastobj[iShow], TRUE ) ) );
 */
        else
        sprintf( buf, "#%-2d %s for %s.\n\r",
                 vShow,
                 capitalize( format_obj_to_char(lastobj[iShow], ch, TRUE) ),
                 name_amount( get_cost( keeper, lastobj[iShow], TRUE ) ) );

        strcat( final, buf );
        free_string( prgpstrShow[iShow] );
        prgpstrShow[iShow] = NULL;
        lastobj[iShow] = NULL;
        vShow += prgnShow[iShow];
    }

    if ( nShow == 0 )
    strcat( final, "Nothing.\n\r" );

    page_to_char( final, ch );

    /*
     * Clean up.
     */
    free_mem( prgpstrShow, count * sizeof(char *)      );
    free_mem( prgnShow,    count * sizeof(int)         );
    free_mem( lastobj,     count * sizeof(OBJ_DATA *)  );

    return;
}


#if defined(never)
/*
 * Show the shop list to a character.
 * Can coalesce duplicated items.
 */
OBJ_DATA *get_shop_list_obj( CHAR_DATA *keeper, CHAR_DATA *ch, int number )
{
    OBJ_DATA **lastobj;
    OBJ_DATA *obj;
    int nShow;
    int iShow;
    int count;
    bool fCombine;
    OBJ_DATA *list = keeper->carrying;

    if ( ch->desc == NULL )
    return NULL;
    
    /*
     * Alloc space for output lines.
     */
    count = 0;
    for ( obj = list; obj != NULL; obj = obj->next_content )
	count++;
    lastobj     = alloc_mem( count * sizeof(OBJ_DATA *) );
    nShow	= 0;

    /*
     * Format the list of objects.
     */
    for ( obj = list; obj != NULL; obj = obj->next_content )
    {
        if ( obj->wear_loc == WEAR_NONE && can_see_obj( ch, obj ) )
        {
            fCombine = FALSE;

            /*
             * Look for duplicates, case sensitive.
             * Matches tend to be near end so run loop backwards.
             */
            for ( iShow = nShow - 1; iShow >= 0; iShow-- )
            {
                if ( lastobj[iShow] == obj && obj->item_type != ITEM_MONEY )
                {
                lastobj[iShow] = obj;
                fCombine = TRUE;
                break;
                }
            }

            /*
             * Couldn't combine, or didn't want to.
             */
            if ( !fCombine )
            {
            lastobj     [nShow] = obj;
            nShow++;
            }
        }
    }

    /*
     * Output the formatted list.
     */
    obj = NULL;
    for ( iShow = 0; iShow < nShow; iShow++ )
    {
        if ( lastobj[iShow] == NULL )
        {
            bug( "Shop_list_to_char: lastobj == NULL.", 0 );
            continue;
        }

        if ( lastobj[iShow]->item_type == ITEM_MONEY )
        continue;

        if ( iShow == number-1 )
        obj = lastobj[iShow];

        lastobj[iShow] = NULL;
    }

    /*
     * Clean up.
     */
    free_mem( lastobj,     count * sizeof(OBJ_DATA *)  );

    return obj;
}
#endif


OBJ_DATA *get_shop_list_obj( CHAR_DATA *keeper, CHAR_DATA *ch, int number )
{
    OBJ_DATA *obj;
    int count;
    OBJ_DATA *list = keeper->carrying;

    if ( ch->desc == NULL )
    return NULL;
    
    count = 0;
    for ( obj = list; obj != NULL; obj = obj->next_content )
    {
        count++;

        if ( count == number
          && obj->wear_loc == WEAR_NONE
          && can_see_obj( ch, obj ) )
            break;
    }

    return obj;
}



CHAR_DATA *find_keeper( CHAR_DATA *ch, char *arg )
{
    CHAR_DATA *keeper = NULL;
    SHOP_DATA *pShop = NULL;

    if ( *arg != 0 )
    {
        if ( (keeper = get_char_room( ch, arg )) != NULL
          && (pShop = keeper->pIndexData->pShop) == NULL )
        {
            send_to_char( "They aren't here.\n\r", ch );
            return NULL;
        }
    }

    if ( pShop == NULL )
    {
    for ( keeper = ch->in_room->people; keeper; keeper = keeper->next_in_room )
    {
	if ( IS_NPC(keeper) && (pShop = keeper->pIndexData->pShop) != NULL )
	    break;
    }
    }

    if ( pShop == NULL )
    {
    send_to_char( "There is no one to serve you.\n\r", ch );
	return NULL;
    }

    /*
     * Shop hours.
     */
    if ( time_info.hour == 12 )
    {
        do_say( keeper, "I'm on my lunch break, leave me be!" );
        return NULL;
    }

    if ( time_info.hour < pShop->open_hour )
    {
	do_say( keeper, "Sorry, come back later." );
	return NULL;
    }
    
    if ( time_info.hour > pShop->close_hour )
    {
	do_say( keeper, "Sorry, come back tomorrow." );
	return NULL;
    }

    /*
     * Invisible or hidden people.
     */
    if ( !can_see( keeper, ch ) )
    {
    do_say( keeper, "What?  Who said that?" );
	return NULL;
    }

    /*
     * Undesirables.
     */
    if ( ch->bounty > 10000 )
    {
        do_say( keeper, "I do not service criminals." );
        return NULL;
    }

    return keeper;
}



/*
 * Careful of the recursion.
 */
int get_cost( CHAR_DATA *keeper, OBJ_DATA *obj, bool fBuy )
{
    SHOP_DATA *pShop;
    int cost;

    if ( obj == NULL || ( pShop = keeper->pIndexData->pShop ) == NULL )
	return 0;

    if ( fBuy )
    {
        OBJ_DATA *pObj;
        
        cost = obj->cost;

/*        if ( obj->item_type == ITEM_GOODS )
        {
            if ( has_arg( pShop->buy_list, goods_table[obj->value[0]].name ) )
                cost /= 2;
            if ( has_arg( pShop->sell_list, goods_table[obj->value[0]].name ) )
                cost += (obj->cost*15)/100;
        }*/

        for ( pObj = obj->contains; pObj != NULL; pObj = pObj->next_content )
          cost += get_cost( keeper, pObj, fBuy );
          
        cost = (cost * pShop->profit_buy) / 100;
    }
    else
    {
        OBJ_DATA *obj2;
        int itype;

        cost = 0;
        for ( itype = 0; itype < MAX_TRADE; itype++ )
        {
            if ( obj->item_type == pShop->buy_type[itype] )
            {
            cost = (obj->cost * pShop->profit_sell) / 100;
            break;
            }
        }

        for ( obj2 = keeper->carrying; obj2; obj2 = obj2->next_content )
        {
            if ( obj->pIndexData == obj2->pIndexData )
            cost -= (cost * 15)/100;
        }

/*        if ( obj->item_type == ITEM_GOODS )
        {
            if ( has_arg( pShop->buy_list, goods_table[obj->value[0]].name ) )
                cost += (obj->cost*15)/100;
            if ( has_arg( pShop->sell_list, goods_table[obj->value[0]].name ) )
                cost /= 2;
        } */
    }

    /*
     * Usage adjustments.
     */
    if ( obj->item_type == ITEM_STAFF || obj->item_type == ITEM_WAND )
	cost = cost * obj->value[2] / obj->value[1];

    return cost;
}



/*
 * Syntax:  list
 *          list [person]
 */
void do_list( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    CHAR_DATA *keeper;
    SHOP_DATA *pShop;

    argument = one_argument( argument, arg );

    if ( (keeper = find_keeper( ch, arg )) == NULL )
    return;

    if ( (pShop = keeper->pIndexData->pShop) == NULL )
    {
        bug( "Find_keeper: returned a NULL pShop.", 0 );
        return;
    }

    if ( IS_SET(pShop->shop_flags, SHOP_TRADER) )
    {
        int t;

        buf[0] = '\0';
/*        for ( t = 0;  goods_table[t].code >= 0;  t++ )
        {
            if ( has_arg(pShop->buy_list, goods_table[t].name) )
            {
                int cost;

                cost = (goods_table[t].cost * pShop->trade_sell[goods_table[t].code])/100;
                sprintf( buf2, " %s for %s per %s.\n\r",
                               capitalize(goods_table[t].name),
                               name_amount( cost ),
                               goods_table[t].unit );
                strcat( buf, buf2 );
            }
        }
*/
        if ( buf[0] != '\0' )
        {
            sprintf( buf2, "%s is looking to trade for:\n\r", capitalize(NAME(keeper)) );
            ansi_color( BOLD, ch );
            page_to_char( buf2, ch );
            ansi_color( NTEXT, ch );
            page_to_char( buf, ch );
        }

/*        buf[0] = '\0';
        for ( t = 0;  goods_table[t].code >= 0;  t++ )
        {
            if ( has_arg(pShop->sell_list, goods_table[t].name) )
            {
                int cost;

                cost = (goods_table[t].cost * pShop->trade_sell[goods_table[t].code])/100;
                sprintf( buf2, " %s for %s per %s.\n\r",
                               capitalize(goods_table[t].name),
                               name_amount( cost ),
                               goods_table[t].unit );
                strcat( buf, buf2 );
            }
        }*/

        if ( buf[0] != '\0' )
        {
            sprintf( buf2, "%s is trading:\n\r", capitalize(NAME(keeper)) );
            ansi_color( BOLD, ch );
            page_to_char( buf2, ch );
            ansi_color( NTEXT, ch );
            page_to_char( buf, ch );
        }
    }

    if ( IS_SET(pShop->shop_flags, SHOP_PEDDLER) )
    {
        sprintf( buf, "%s is selling:\n\r", capitalize(NAME(keeper)) );
        ansi_color( BOLD, ch );
        page_to_char( buf, ch );
        ansi_color( NTEXT, ch );
        shop_list_to_char( keeper, ch );
    }

    if ( IS_SET(pShop->shop_flags, SHOP_COMPONENTS) )
    {
        int t;

        buf[0] = '\0';
        for ( t = 0;  comp_table[t].cost >= 0;  t++ )
        {
/*            if ( has_arg(pShop->comp_list, comp_table[t].name) )
            {
                sprintf( buf2, " %s for %s per unit.\n\r",
                               capitalize(comp_table[t].name),
                               name_amount( comp_table[t].cost ) );
                strcat( buf, buf2 );
            }*/
        }

        if ( buf[0] != '\0' )
        {
        sprintf( buf2, "%s has these components in stock:\n\r", capitalize(NAME(keeper)) );
        ansi_color( BOLD, ch );
        page_to_char( buf2, ch );
        ansi_color( NTEXT, ch );
        page_to_char( buf, ch );
        }
    }

    return;
}





bool transact( CHAR_DATA *keeper, OBJ_DATA *obj, CHAR_DATA *ch, int price )
{
    char buf[MAX_STRING_LENGTH];
    char *p;

    if ( obj == NULL )
    {
        bug( "Transact: NULL obj.", 0 );
        return FALSE;
    }

    if ( tally_coins( ch ) < price )
    {
        send_to_char( "You don't have enough money.\n\r", ch );
        return FALSE;
    }

    if ( hand_empty( ch ) == WEAR_NONE )
    {
        send_to_char( "You need a free hand to complete the transaction.\n\r", ch );
        return FALSE;
    }

    if ( obj->carried_by != NULL )
    obj_from_char( obj );

    REMOVE_BIT(obj->extra_flags, ITEM_INVENTORY);
    obj_to_char( obj, ch );
    obj->wear_loc = hand_empty( ch );

    p = sub_coins(price, ch );

    if ( !str_cmp( p, "nothing" ) )
    sprintf( buf, "You buy %s.\n\r", STR(obj,short_descr) );
    else
    sprintf( buf, "You buy %s and receive %s in change.\n\r", STR(obj,short_descr), p );

    send_to_char( buf, ch );
    act( "$n buys $p from $N.", ch, obj, keeper, TO_ROOM );
    return TRUE;
}



void buy_ai( CHAR_DATA *ch, CHAR_DATA *keeper, int offer )
{
/*    char buf[MAX_STRING_LENGTH];
    SHOP_DATA *pShop = keeper->pShop;
    OBJ_DATA *obj;
    int i;

    if ( (obj = ch->haggling) == NULL )
    {
        send_to_char( "You are not trading for anything.\n\r", ch );
        return;
    }

    if ( pShop == NULL )
    {
        bug( "Buy_ai: No shop on keeper.", 0 );
        return;
    }

    if ( ch->keeper != keeper )
    {
        send_to_char( "You are trading with someone else.\n\r", ch );
        return;
    }

    if ( ch->in_room != keeper->in_room )
    {
        send_to_char( "You are not in the same room with the trader.\n\r", ch );
        return;
    }

    if ( offer < 0 )
    {
        ch->original_cost = ch->haggled_cost;
        sprintf( buf, "I can offer you %s for %s copper.",
                 STR(obj,short_descr), numberize(ch->haggling_cost) );
        say_to( keeper, ch, buf );
        return;
    }

    i = (ch->original_cost + pShop->max_flux)/100;
    if ( offer > i/2 )
    {
        if ( number_bits( 2 ) == 0 )
        SET_BIT( ch->haggle_bits, HAGGLE_ANGRY );

        if ( IS_SET(ch->haggle_bits, HAGGLE_ANGRY )
        sprintf( buf, "Your offer is outrageous

  */
}

/*
 * Syntax:  buy [number] [keeper]
 *          buy [component] [keeper]
 *          buy [object] [keeper]
 */
void do_buy( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    OBJ_DATA *obj;
    CHAR_DATA *keeper;
    int t, number;


    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( (keeper = find_keeper( ch, arg2 )) == NULL )
    return;

    if ( is_number(arg1) )
    {
        obj = get_shop_list_obj( keeper, ch, atoi(arg1) );

        if ( obj == NULL )
        {
            sprintf( buf, keeper->pIndexData->pShop->no_such_item, NAME(ch) );
            say_to( keeper, ch, buf );
        }
        else
        transact( keeper, obj, ch, get_cost( keeper, obj, TRUE ) );
        return;
    }

    for ( t = 0;  comp_table[t].type != -1; t++ )
    {
        if ( !str_cmp( comp_table[t].name, arg1 ) )
        break;
    }

    if ( comp_table[t].type != -1 )
    {
        obj = create_comp(t);

        transact( keeper, obj, ch, get_cost( keeper, obj, TRUE ) );
        return;
    }

    number = number_argument( arg1, arg2 );
    t  = 0;
    for ( obj = keeper->carrying; obj != NULL; obj = obj->next_content )
    {
        if ( can_see_obj( ch, obj )
          && is_name( arg1, STR(obj, name) )
          && obj->wear_loc == WEAR_NONE
          && ++t == number )
            break;
    }

    if ( obj == NULL )
    {
        sprintf( buf, keeper->pIndexData->pShop->no_such_item, NAME(ch) );
        say_to( keeper, ch, buf );
    }
    else
    transact( keeper, obj, ch, get_cost( keeper, obj, TRUE ) );

    return;
}




/*
 * Syntax:  trade [item] [keeper]
 */
void do_trade( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *keeper;
    SHOP_DATA *pShop;
    int t;

    return;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( (keeper = find_keeper( ch, arg2 )) == NULL )
    return;

    pShop = keeper->pIndexData->pShop;

    for ( t = 0;  goods_table[t].code != -1; t++ )
    {
        if ( !str_cmp( goods_table[t].name, arg1 ) )
        break;
    }

/*    if ( goods_table[t].code == -1
      && pShop->trade_sell[goods_table[t].code] != 0 )
    {
        sprintf( buf, keeper->pIndexData->pShop->no_such_item, NAME(ch) );
        say_to( keeper, ch, buf );
    }*/

    if ( ch->haggling != NULL )
    {
        if ( ch->haggling->carried_by == NULL )
        extract_obj( ch->haggling );

        ch->haggling = NULL;
        send_to_char( "You stop haggling for the current item.\n\r", ch );
    }

    ch->keeper = keeper;
    ch->haggling = create_good(t);

/*    ch->haggled_cost = (get_cost(keeper, ch->haggling, TRUE)
                       * pShop->trade_sell[goods_table[t].code])/100; */

    ch->haggle_bits  =  HAGGLE_BUY;

    buy_ai( ch, keeper, -1 );
    return;
}




void do_sell( CHAR_DATA *ch, char *argument )
{
    return;
}




/*
 * Syntax:  barter [number] [keeper]
 */
void do_barter( CHAR_DATA *ch, char *argument )
{
    return;
}




/*
 * Syntax:  offer [price]
 *          offer end
 *          offer abort
 *          offer agree [quantity]
 *          offer accept [quantity]
 */
void do_offer( CHAR_DATA *ch, char *argument )
{
    return;
}



void do_appraise( CHAR_DATA *ch, char *argument )
{
    return;
}



