/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "skills.h"
#include "spells.h"

#define IS_ADEPT(ch,sn)    ( PC(ch,learned)[sn] >= skill_table[sn].max_learn )


bool is_group_index( int sn )
{
    int gro;

    for ( gro = 0;  group_table[gro].pgsn != NULL;  gro++ )
    {

        if ( *group_table[gro].pgsn == sn  )
        return TRUE;
    }

    return FALSE;
}


int group_lookup( char *name )
{
    int gsn;

    if ( MTD(name) ) return -1;

    for (gsn = 0;  group_table[gsn].pgsn != NULL;  gsn++ )
    {
        if (!str_prefix( name, group_table[gsn].name ))
            return gsn;
    }

    return -1;
}


int skill_lookup( const char *name )
{
    int sn;

    if ( name == NULL ) return -1;

    for ( sn = 0; sn < MAX_SKILL; sn++ )
    {
	if ( skill_table[sn].name == NULL )
	    break;
	if ( LOWER(name[0]) == LOWER(skill_table[sn].name[0])
	&&   !str_prefix( name, skill_table[sn].name ) )
	    return sn;
    }

    return -1;
}


int slot_lookup( int slot )
{
    extern bool fBootDb;
    int sn;

    if ( slot <= 0 )
	return -1;

    for ( sn = 0; sn < MAX_SKILL; sn++ )
    {
	if ( slot == skill_table[sn].slot )
	    return sn;
    }

    if ( fBootDb )
    {
	bug( "Slot_lookup: bad slot %d.", slot );
	abort( );
    }

    return -1;
}


int group_slot_lookup( int slot )
{
    extern bool fBootDb;
    int sn;

    if ( slot <= 0 )
	return -1;

    for ( sn = 0; group_table[sn].pgsn != NULL; sn++ )
    {
    if ( slot == group_table[sn].group_code )
        return *group_table[sn].pgsn;
    }

    if ( fBootDb )
    {
    bug( "Group_slot_lookup: bad slot %d.", slot );
	abort( );
    }

    return -1;
}


char *skill_level( int sn, int percent )
{
    percent = PERCENTAGE(percent, skill_table[sn].max_learn);

    if ( percent <= 0 )   return "unknown";
	if ( percent == 1 )   return "untrained";
    if ( percent < 10 )   return "dabbling";
    if ( percent < 20 )   return "studying";
    if ( percent < 30 )   return "novice";
    if ( percent < 40 )   return "mediocre";
    if ( percent < 50 )   return "adequate";
    if ( percent < 60 )   return "advancing";
    if ( percent < 70 )   return "skilled";
    if ( percent < 80 )   return "trained";
    if ( percent < 100 )  return "mastering";
    if ( percent >= 100 ) return "an adept";
    return "unknown";
};

/*
 * Newt: General purpose func to advance a skill. 
 * Returns: TRUE if (ch)'s skill (sn) was advanced
 *          FALSE if not
 */
bool advance_skill( CHAR_DATA *ch, int sn, int advance, int time_mod )
{
    if ( !IS_NPC(ch)			/* PCs only		*/
      && PC(ch, skill_time)[sn] <= 0	/* Can practice		*/
      && !IS_ADEPT(ch, sn) 		/* Not yet an adept	*/
      && advance > 0 )			/* Actually improved    */  
    {
        if ( PC(ch,learned)[sn] <= 0 && skill_table[sn].mana > 0 )
        return FALSE;  /* can't discover spells this way */


    	PC(ch, learned)[sn] += advance;
    	PC(ch,skill_time)[sn] = ((int_app[get_curr_int(ch)].learn +
                            wis_app[get_curr_wis(ch)].practice)/2) +
                            skill_table[sn].learn_rate +
			    time_mod;

	if ( PC(ch,learned)[sn] == 1 )
        act( "You discover $t.", ch, skill_table[sn].name, NULL, TO_CHAR);
	else
	if ( PC(ch,learned)[sn] > 1 )
        act( "You improve in $t.", ch, skill_table[sn].name,NULL,TO_CHAR);

	/* Update group listing - check for slot lookup problems */
	if ( PC(ch,learned)[group_slot_lookup(skill_table[sn].group_code)] <= 0 )
        PC(ch,learned)[group_slot_lookup(skill_table[sn].group_code)] = 1;

    	return TRUE;
    }
    return FALSE;
}

bool has_prereq( CHAR_DATA *ch, int sn, bool fTell )
{
    bool ok = TRUE;
    int gsn;

    if ( sn >= MAX_SKILL || skill_table[sn].name == NULL || IS_NPC(ch) )
    return FALSE;

    if ( (gsn = group_slot_lookup( skill_table[sn].group_code ) ) != -1 )
    {
        if ( PC(ch,learned)[gsn] < skill_table[sn].required_percent )
        {
            if(fTell)
            {
                char buf[MAX_STRING_LENGTH];

                sprintf( buf,
                      "You have not yet achieved enough knowledge of %s.\n\r",
                      skill_table[gsn].name );
                send_to_char( buf, ch );
            }
            ok = FALSE;
        }
    }

    if ( get_curr_str( ch ) < skill_table[sn].req_str )
    {
        if (fTell)
        send_to_char( "You are too feeble to train this skill.\n\r", ch );
        ok = FALSE;
    }

    if ( get_curr_int( ch ) < skill_table[sn].req_int )
    {
        if (fTell)
        send_to_char( "You fail to decipher the secrets of this skill.\n\r", ch );
        ok = FALSE;
    }

    if ( get_curr_wis( ch ) < skill_table[sn].req_wis )
    {
        if (fTell)
        send_to_char( "You lack the basic, logical understandings to study this skill.\n\r", ch );
        ok = FALSE;
    }

    if ( get_curr_dex( ch ) < skill_table[sn].req_dex )
    {
        if (fTell)
        send_to_char( "You are not quite agile enough to train this skill.\n\r", ch );
        ok = FALSE;
    }

    if ( get_curr_con( ch ) < skill_table[sn].req_con )
    {
        if (fTell)
        send_to_char( "The rigorous training and practice of this skill would overcome your frailty.\n\r", ch );
        ok = FALSE;
    }

    if ( skill_table[sn].learn_fun != NULL )
    {
        if ( !(*skill_table[sn].learn_fun)( ch, sn, fTell ) )
        ok = FALSE;
    }

    return (ok);
}




char *disp_group( CHAR_DATA *ch, int gsn, int sn )
{
    static char buf[MAX_STRING_LENGTH];
    char fub[MAX_STRING_LENGTH];

    if ( skill_table[*group_table[gsn].pgsn].group_code != GRO_NONE
      || group_table[gsn].group_code == GRO_WP
      || IS_ADEPT(ch,*group_table[gsn].pgsn) )
    sprintf( buf, "%s", group_table[gsn].name );
    else
    sprintf( buf, "%s - %s", group_table[gsn].name,
                  skill_level(sn,PC(ch,learned)[sn]) );

    sprintf( fub, "%s[ %s%s%s ]%s",
             trunc_fit( "---------------------------------------",
               30-(strlen(buf)/2) ),
             HAS_ANSI(ch) ? BOLD : "",
             string_proper( buf ),
             HAS_ANSI(ch) ? ANSI_NORMAL : "",
             trunc_fit( "---------------------------------------",
               30-(strlen(buf)/2) ));

    sprintf( buf, "%s\n\r", trunc_fit( fub, HAS_ANSI(ch) ? 60+8 : 60 ) );
    return buf;
}


char *disp_skill( CHAR_DATA *ch, int sn )
{
    static char buf[MAX_STRING_LENGTH];

    sprintf( buf, "%s - %s",
             trunc_fit(skill_table[sn].name, 18),
             skill_level(sn,PC(ch,learned)[sn]) );

    return buf;
}


void display_skills( CHAR_DATA *ch, int group )
{
    char final[4*MAX_STRING_LENGTH];
    int gsn;
    int col;

    if ( group >= 0 )
    {
        gsn = group;
        if (PC(ch,learned)[*group_table[gsn].pgsn] > 0)
        {
            int sn = *group_table[gsn].pgsn;
            int col = 0;

            page_to_char( disp_group(ch, gsn, sn), ch );

            for ( sn = 0;  sn < MAX_SKILL;  sn++ )
            {
                if ( skill_table[sn].name == NULL )
                break;

                if ( PC(ch,learned)[sn] > 0
                  && skill_table[sn].group_code==group_table[gsn].group_code )
                {
                    page_to_char( disp_skill(ch,sn), ch );

                    col++;
                    if ( col % 2 == 0 )
                    {
                        page_to_char( "\n\r", ch );
                        col = 0;
                    }
                    if ( col % 2 != 0 )  page_to_char( "\n\r", ch );
                }
            }

page_to_char("=================================================================\n\r",ch );
        }
        else
        send_to_char( "You do not know of that skill group.\n\r", ch );
        return;
    }

    final[0] = '\0';

    for (gsn = 0;  group_table[gsn].pgsn != NULL;  gsn++ )
    {
        if (PC(ch,learned)[*group_table[gsn].pgsn] > 0)
        {
            int sn;

            col = 0;
            sn = *group_table[gsn].pgsn;
            strcat( final, disp_group(ch, gsn, sn) );

            for ( sn = 0;  sn < MAX_SKILL;  sn++ )
            {
                if ( skill_table[sn].name == NULL )
                break;

                if ( PC(ch,learned)[sn] > 0
                  && skill_table[sn].group_code== group_table[gsn].group_code )
                {
                    char buf[MAX_STRING_LENGTH];

                    col++;
                    if ( col % 2 == 0 )
                    {
                        sprintf( buf, "%-27s", disp_skill(ch,sn) );
                        strcat( final, "  |  " );
                        strcat( final, buf );
                        strcat( final, "\n\r" );
                        col = 0;
                    }
                    else
                    {
                        sprintf( buf, "%28s", disp_skill(ch,sn) );
/*                        strcat( final, "      " );*/
                        strcat( final, buf );
                    }
                }
            }
            if ( col % 2 != 0 )  strcat( final, "\n\r" );
        }
    }
    page_to_char( final, ch );

    return;
}



/*
 * Syntax:  skills
 *          skills [skill]
 *          skills [group]
 */
void do_skills( CHAR_DATA *ch, char * argument )
{
    char arg[MAX_STRING_LENGTH];
    int gsn;
    bool fShow = FALSE;

    if (IS_NPC(ch))
    {
        MOB_INDEX_DATA *pMob = ch->pIndexData;
        int sn, col = 0;

        for ( sn = 0;  sn < MAX_SKILL; sn++ )
        {
            if ( skill_table[sn].name == NULL )
            break;

            if ( pMob->learned[sn] <= 0 )
            continue;

            col++;
            sprintf( arg, "%20s/%3d ",
                     trunc_fit( skill_table[sn].name, 20 ),
                     pMob->learned[sn] );
            send_to_char( arg, ch );
            if ( col % 3 == 0 )
            {
                send_to_char( "\n\r", ch );
                col = 0;
            }
        }

        if ( col % 3 != 0 )  send_to_char( "\n\r", ch );
        return;
    }

    if ( (gsn = group_lookup( argument )) > -1 )
    {
        display_skills( ch, gsn );
        fShow = TRUE;
    }

    if ( (gsn = skill_lookup( argument )) > -1 )
    {
        char buf[MAX_STRING_LENGTH];
        MOB_INDEX_DATA *pMobIndex = get_mob_index(PC(ch,teacher)[gsn]);

        if ( PC(ch,learned)[gsn] <= 0 )
        {
            send_to_char( "You know nothing of that skill.\n\r", ch );
            return;
        }

        if ( PC(ch,learned)[gsn] >= skill_table[gsn].max_learn )
        {
            sprintf( buf, "You are an adept of %s.\n\r",
                     skill_table[gsn].name );
            send_to_char( buf, ch );
            return;
        }

        sprintf( buf, "You are %s in %s.\n\r",
                       skill_level(gsn,PC(ch,learned)[gsn]),
                       skill_table[gsn].name );
        send_to_char( buf, ch );

        sprintf( buf, "You are apprenticed to %s.\n\r",
                      pMobIndex != NULL ? pMobIndex->short_descr : "no one" );
        send_to_char( buf, ch );

        if ( pMobIndex == NULL ) return;

        if ( PC(ch,skill_time)[gsn] > 0 )
        {
        sprintf( buf, "You still have %s hours left until your next session.\n\r",
                 PC(ch,skill_time)[gsn] > 10 ? "many" :
                 PC(ch,skill_time)[gsn] > 5  ? "several" :
                 PC(ch,skill_time)[gsn] > 2  ? "a few" : "a couple of" );
        send_to_char( buf, ch );
        }
        else
        send_to_char( "You can now attend your next session.\n\r", ch );

        return;
    }

    if ( !fShow )
    {
        display_skills( ch, -1 );
        page_to_char( "============================================================\n\r",ch );
    }

    {
        int total = 0, x;

        for ( x = 0;  x < MAX_SKILL;  x++ )
        {
            if ( PC(ch,learned)[x] > 0 )
                total++;
        }

        if ( total >= race_table[ch->race].max_skills )
        page_to_char( "You have achieved the maximum number of skills for your race.\n\r", ch );
/*        removed as per Zodiac's request
        else
        {
            sprintf( arg, "You are allowed to learn %s more skills in your lifetime.\n\r",
                     numberize( race_table[ch->race].max_skills - total ) );
            page_to_char( arg, ch );
        }
*/
    }
    return;
}




/*
 * Syntax:  learn
 *          learn [skill/group]
 */
void do_learn( CHAR_DATA *ch,  char *argument )
{
    MOB_INDEX_DATA *pMobIndex = NULL;
    CHAR_DATA *rch;
    char buf[MAX_STRING_LENGTH];
    int sn, amount;

    /*-- Newt: Added support for changing teacher, cost penalty is * 5 --*/

#define TUTOR_CHANGE_PENALTY	(5)

    if ( MTD(argument) )
    {
        char buf2[MAX_STRING_LENGTH];

        for ( rch = ch->in_room->people;
              rch != NULL;
              rch = rch->next_in_room )
        {
            if ( IS_NPC(rch)
              && IS_SET(rch->act, ACT_PRACTICE) )
            {
                pMobIndex = rch->pIndexData;
                break;
            }
        }

        if ( pMobIndex == NULL )
        {
        send_to_char( "There is no one here to teach you.\n\r", ch );
        return;
        }

        buf[0] = '\0';
        for ( sn = 0;  sn < MAX_SKILL;  sn++ )
        {
            if ( pMobIndex->learned[sn] > 0
	       	&& has_prereq( ch, sn, FALSE ) 
		/* Newt: If this mob is already tutoring this guy, don't list */
		&& PC(ch, teacher)[sn] != pMobIndex->vnum ) 
            {
    		amount = skill_table[sn].cost 
		       * ( PC(ch, learned)[sn] <= 0 ? 1 : TUTOR_CHANGE_PENALTY );
                strcat( buf, capitalize( skill_table[sn].name ) );
				strcat( buf, " for " );
				strcat( buf, name_amount( amount ) );
                strcat( buf, ".\n\r" );
            }
        }

	if ( buf[0] == '\0' )
	{
        sprintf( buf, "%s cannot offer you any new apprenticeships.\n\r",
                 pMobIndex->short_descr );
        send_to_char( buf, ch );
		return;
	}

        sprintf( buf2, "%s is offering the following apprenticeships:\n\r",
                 pMobIndex->short_descr );
        send_to_char( buf2, ch );
        send_to_char( buf, ch );
        return;
    }


    if ( ( sn = skill_lookup( argument ) ) == -1 )
    {
        send_to_char( "There is no such skill.\n\r", ch );
        return;
    }

    for ( rch = ch->in_room->people;  rch != NULL; rch = rch->next_in_room )
    {
        if ( IS_NPC(rch)
          && IS_SET(rch->act, ACT_PRACTICE)
          && rch->pIndexData->learned[sn] > 0 )
        {
            pMobIndex = rch->pIndexData;
            break;
        }
    }

    if ( pMobIndex == NULL )
    {
    	send_to_char( "There is no one here to teach you that skill.\n\r", ch );
    	return;
    }

    amount = skill_table[sn].cost * ( PC(ch, learned)[sn] <= 0 ? 1 : TUTOR_CHANGE_PENALTY );

    if ( tally_coins( ch ) < amount )
    {
	send_to_char( "You don't have enough money to learn that skill.\n\r", ch );
	return;
    }

    {
        int total = 0, x;

        for ( x = 0;  x < MAX_SKILL;  x++ )
        {
            if ( PC(ch,learned)[x] > 0 )
                total++;
        }

        if ( total >= race_table[ch->race].max_skills )
        {
            send_to_char( "You have achieved the maximum number of skills for your race.\n\r", ch );
            return;
        }
    }

    if ( has_prereq( ch, sn, TRUE ) )
    {
        sprintf( buf, "You receive %s in change.\n\r",
                 sub_coins( amount, ch ) );
        send_to_char( buf, ch );

	/* If a new skill... */
	if ( PC(ch,learned)[sn] <= 0 )
	{ 
	    PC(ch,learned)[sn] = 1;
	    PC(ch,skill_time)[sn] = 2;
	}

	/* If changing tutor... */
	if ( PC(ch,teacher)[sn] != 0 )
	{
	    MOB_INDEX_DATA *old_teacher = NULL;
            old_teacher = get_mob_index(PC(ch,teacher)[sn]);
            sprintf( buf, "You leave apprenticeship of %s.\n\r",
                 old_teacher != NULL ? old_teacher->short_descr : "your old master" );
	}

	PC(ch,teacher)[sn] = pMobIndex->vnum;

        sprintf( buf, "You are now apprenticed to %s in %s.\n\r",
                 pMobIndex->short_descr, skill_table[sn].name );
        send_to_char( buf, ch );
        return;
    }

    send_to_char( PC(ch,learned[sn]) > 0 ?
               "You are already apprenticed to that skill.\n\r" :
               "You cannot learn that skill.\n\r", ch );
    return;
}

/*
 * Newt: Progressive cost for practicing depending on skill level.
 */
int practice_cost( int amount, int level )
{
    int cost;
    cost =   level < 10 ? amount / 2     /* Basics are cheap */
	   : level < 30 ? amount 
	   : level < 40 ? amount * 6 / 5 /* But the better you */
	   : level < 50 ? amount * 5 / 4 /* want to become...  */
	   : level < 60 ? amount * 4 / 3
	   : level < 70 ? amount * 3 / 2 /* The more it'll     */
	   :              amount * 2;    /* cost you!          */
    return ( cost );
}


/*
 * Syntax:  practice [skill/group]
 */
void do_practice( CHAR_DATA *ch,  char *argument )
{
    MOB_INDEX_DATA *pMobIndex = NULL;
    CHAR_DATA *rch;
    char buf[MAX_STRING_LENGTH];
    int sn, amount;

    if ( MTD(argument) )
    {
        buf[0] = '\0';
        for ( sn = 0;  sn < MAX_SKILL;  sn++ )
        {
            if ( PC(ch,learned)[sn] > 0
              && PC(ch,learned)[sn] < skill_table[sn].max_learn )
            {
		amount = practice_cost(skill_table[sn].cost, PC(ch,learned)[sn]);
                strcat( buf, capitalize( skill_table[sn].name ) );
		strcat( buf, " for " );
		strcat( buf, name_amount( amount ) );
                if ( PC(ch,skill_time)[sn] > 0 )
                strcat( buf, ", still awaiting your next lesson" );
                strcat( buf, ".\n\r" );
            }
        }

	if ( buf[0] == '\0' )
	{
            send_to_char( "You are not currently training any skill.\n\r", ch );
		return;
	}

        send_to_char( "You are training in the following skills:\n\r", ch );
        send_to_char( buf, ch );
        return;
    }


    if ( ( sn = skill_lookup( argument ) ) == -1 )
    {
        send_to_char( "There is no such skill.\n\r", ch );
        return;
    }

    for ( rch = ch->in_room->people;  rch != NULL; rch = rch->next_in_room )
    {
        if ( IS_NPC(rch)
          && PC(ch,teacher)[sn] == rch->pIndexData->vnum )
        {
            pMobIndex = rch->pIndexData;
            break;
        }
    }

    if ( pMobIndex == NULL )
    {
    	send_to_char( "Your teacher is not here.\n\r", ch );
    	return;
    }

    amount = practice_cost(skill_table[sn].cost, PC(ch,learned)[sn]);

    if ( tally_coins( ch ) < amount )
    {
        send_to_char( "You don't have enough money for your next lesson.\n\r", ch );
		return;
    }

    if ( PC(ch,skill_time)[sn] > 0 )
    {
        send_to_char( "It is not time for your next lesson.\n\r", ch );
        return;
    }

    if ( IS_ADEPT(ch,sn) )
    {
        PC(ch,learned)[sn] = skill_table[sn].max_learn;
        send_to_char( "You are already an adept of this skill.\n\r", ch );
        return;
    }

    if ( PC(ch,learned)[sn] > 0 )
    {
        int increase;

        increase = number_range( 1, skill_table[sn].max_prac );

        sprintf( buf, "You receive %s in change.\n\r",
                 sub_coins( amount, ch ) );
        send_to_char( buf, ch );

	advance_skill( ch, sn, increase, 0 );
        sprintf( buf, "You practice through another lesson of %s with %s.\n\r",
                      skill_table[sn].name, pMobIndex->short_descr );
        send_to_char( buf, ch );
    }
    else
    	send_to_char( "You know nothing of a skill like that.\n\r", ch );

    return;
}

/*
 * Syntax: train [pc name] [skill]
 */

void do_train( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *who;
    int sn;

    char arg[ MAX_INPUT_LENGTH ];

#define PC_TEACH_LIMIT (60) /* Minimum percentage in skill to teach */

    if ( MTD( argument ) )
    {
	send_to_char( "Train who in which skill?\n\r", ch );
	return;
    }
    /* Huge amount of sanity checks... */
    argument = one_argument( argument, arg );
    if ( ( who = get_char_room( ch, arg ) ) == NULL )
    {
	send_to_char( "You can see no such creature here.\n\r", ch );
	return;
    }
    if ( ( who == ch ) )
    {
        send_to_char( "Teaching yourself?\n\r", ch );
        return;
    }
    /* Valid skill? */
    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
	send_to_char( "Train which skill?\n\r", ch );
	return;
    }
    if ( ( sn = skill_lookup( arg ) ) < 0 )
    {
	send_to_char( "There is no such skill.\n\r", ch );
	return;
    }
    /* Can teach? Insert here PLR_TEACHER bit... */
    if ( PC(ch, learned)[sn] < PC_TEACH_LIMIT )
    {
	sprintf( arg, "You are not skilled enough in %s!\n\r",
		skill_table[sn].name );
	send_to_char( arg, ch );
	return;
    }
    /* Above 1/3 limit & and trainee ready to advance? */
    if ( PC(ch, learned)[sn]/3 > PC(who, learned)[sn]
      && advance_skill( who, sn, 1, 0 ) )
    {
    	sprintf( arg, "You train $N in %s.", skill_table[sn].name );
    	act( arg, ch, NULL, who, TO_CHAR );
    	sprintf( arg, "$n trains you in %s.", skill_table[sn].name );
    	act( arg, ch, NULL, who, TO_VICT );
    }
    else
       	act( "$N cannot be trained by you.", ch, NULL, who, TO_CHAR );
    return;
}

