/*
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 */


#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "mud.h"




/*
 * Removes the tildes from a string.
 * Used for player-entered strings that go into disk files.
 */
void smash_tilde( char *str )
{
    for ( ; *str != '\0'; str++ )
    {
	if ( *str == '~' )
	    *str = '-';
    }

    return;
}



/*
 * Compare strings, case insensitive.
 * Return TRUE if different
 *   (compatibility with historical functions).
 */
bool str_cmp( const char *astr, const char *bstr )
{
    if ( astr == NULL )
    {
    bug( "Str_cmp: null astr.", 0 );
	return TRUE;
    }

    if ( bstr == NULL )
    {
    bug( "Str_cmp: null bstr.", 0 );
	return TRUE;
    }

    for ( ; *astr || *bstr; astr++, bstr++ )
    {
	if ( LOWER(*astr) != LOWER(*bstr) )
	    return TRUE;
    }

    return FALSE;
}


/*
 * Compare strings, case insensitive, for prefix matching.
 * Return TRUE if astr not a prefix of bstr
 *   (compatibility with historical functions).
 */
bool str_prefix( const char *astr, const char *bstr )
{
    if ( astr == NULL )
    {
    bug( "Str_prefix: null astr.", 0 );
	return TRUE;
    }

    if ( bstr == NULL )
    {
    bug( "Str_prefix: null bstr.", 0 );
	return TRUE;
    }

    for ( ; *astr; astr++, bstr++ )
    {
	if ( LOWER(*astr) != LOWER(*bstr) )
	    return TRUE;
    }

    return FALSE;
}



/*
 * Compare strings, case insensitive, for match anywhere.
 * Returns TRUE is astr not part of bstr.
 *   (compatibility with historical functions).
 */
bool str_infix( const char *astr, const char *bstr )
{
    int sstr1;
    int sstr2;
    int ichar;
    char c0;

    if ( astr == NULL )
    {
        char buf[MAX_STRING_LENGTH];

        sprintf( buf, "Str_infix: null astr (compared against '%s').", bstr );
        bug( buf, 0 );
        return TRUE;
    }

    if ( bstr == NULL )
    {
        char buf[MAX_STRING_LENGTH];

        sprintf( buf, "Str_infix: null bstr (compared against '%s').", astr );
        bug( buf, 0 );
        return TRUE;
    }

    if ( ( c0 = LOWER(astr[0]) ) == '\0' )
	return FALSE;

    sstr1 = strlen(astr);
    sstr2 = strlen(bstr);

    for ( ichar = 0; ichar <= sstr2 - sstr1; ichar++ )
    {
	if ( c0 == LOWER(bstr[ichar]) && !str_prefix( astr, bstr + ichar ) )
	    return FALSE;
    }

    return TRUE;
}



/*
 * Compare strings, case insensitive, for suffix matching.
 * Return TRUE if astr not a suffix of bstr
 *   (compatibility with historical functions).
 */
bool str_suffix( const char *astr, const char *bstr )
{
    int sstr1;
    int sstr2;

    if ( !astr || !bstr ) return TRUE;

    sstr1 = strlen(astr);
    sstr2 = strlen(bstr);
    if ( sstr1 <= sstr2 && !str_cmp( astr, bstr + sstr2 - sstr1 ) )
	return FALSE;
    else
	return TRUE;
}






/*
 * Returns an initial-capped string.
 */
char *capitalize( const char *str )
{
    static char strcap[MAX_STRING_LENGTH];
    int i;

    for ( i = 0; str[i] != '\0'; i++ )
    strcap[i] = str[i];
    strcap[i] = '\0';
    strcap[0] = UPPER(strcap[0]);
    return strcap;
}



/*
 * Append a string to a file.
 */
void append_file( CHAR_DATA *ch, char *file, char *str )
{
    FILE *fp;

    if ( IS_NPC(ch) || str[0] == '\0' )
	return;

    fclose( fpReserve );
    if ( ( fp = fopen( file, "a" ) ) == NULL )
    {
	perror( file );
	send_to_char( "Could not open the file!\n\r", ch );
    }
    else
    {
	fprintf( fp, "[%5d] %s: %s\n",
	    ch->in_room ? ch->in_room->vnum : 0, ch->name, str );
	fclose( fp );
    }

    fpReserve = fopen( NULL_FILE, "r" );
    return;
}



/*
 * Smash all \r's and tildes for file writes.
 */
char *fix_string( const char *str )
{
    static char strfix[MAX_STRING_LENGTH];
    int i;
    int o;

    if ( str == NULL )
        return '\0';

    for ( o = i = 0; str[i+o] != '\0'; i++ )
    {
        if (str[i+o] == '\r' || str[i+o] == '~')
            o++;
        strfix[i] = str[i+o];
    }
    strfix[i] = '\0';
    return strfix;
}



/*
 * Sees if last char is 's' and returns 'is' or 'are' pending.
 */
char * is_are( char *text )
{
    while ( *text != '\0' )
    {
        text++;
    }

    text--;

    if ( LOWER(*text) == 's' && LOWER(*text-1) != 's' )  
        return "are";
   else return "is";
}


/*
 * Smashes all occurances of a string from a larger string.
 * Arguments must be seperated by a space.
 */
char *smash_arg( char *text, char *name )
{
    char *arg;
    char buf[MAX_STRING_LENGTH];
    static char buf2[MAX_STRING_LENGTH];

    buf2[0] = '\0';

    arg = one_argument( text, buf );

    while ( buf[0] != '\0' )
    {
        if ( str_cmp( buf, name ) )
        {
             strcat( buf2, buf );
             strcat( buf2, " " );
        }

        arg = one_argument( arg, buf );
    }

    return buf2;
}




/*
 * Grab 'a' 'an's and 'the's and smash the living hell out of them.
 * Good for use with manipulation of object names.  Only destroys first
 * occurance.
 */
char *smash_article( char *text )
{
    char *arg;
    char buf[MAX_STRING_LENGTH];
    static char buf2[MAX_STRING_LENGTH];

    one_argument( text, buf );

    if ( !str_cmp( buf, "the" ) ||
         !str_cmp( buf, "an"  ) ||
         !str_cmp( buf, "a"   ) )
    {
        arg = one_argument( text, buf );
        sprintf( buf2, "%s", arg );
    }
    else strcpy( buf2, text );

    return buf2;
}




char *pluralize( char *argument )
{
    static char buf[MAX_STRING_LENGTH];
    char *v;

    sprintf( buf, "%s", smash_article(argument) );
    v = strstr( buf, " of " );

    if ( v == NULL )
    {
        if ( LOWER(buf[strlen(buf)-1]) == 'y' )
        {
            buf[strlen(buf)-1] = 'i';
            strcat( buf, "es" );
        }
        else
        if ( LOWER(buf[strlen(buf)-1]) == 'f' 
          && !(LOWER(buf[strlen(buf)-2]) == 'i'
            && LOWER(buf[strlen(buf)-3]) == 'o') )
        {
            buf[strlen(buf)-1] = 'v';
            strcat( buf, "es" );
        }
        else
        if ( LOWER(buf[strlen(buf)-1]) == 'h' )
        strcat( buf, "es" );
        else            
        if ( LOWER(buf[strlen(buf)-1]) == 's' )
        {
            if ( LOWER(buf[strlen(buf)-2]) == 'u'
              && !IS_VOWEL(LOWER(buf[strlen(buf)-3])) )
            {
                buf[strlen(buf)-2] = 'i';
                buf[strlen(buf)-1] = '\0';
            }
            else
            strcat( buf, "es" );
        }
        else
        strcat( buf, "s" );
    }
    else
    {
        char xbuf[MAX_STRING_LENGTH];

        sprintf( xbuf, "%s", v );
        buf[strlen(buf)-strlen(v)] = '\0';

        if ( LOWER(buf[strlen(buf)-1]) == 'y' )
        {
            buf[strlen(buf)-1] = 'i';
            strcat( buf, "es" );
        }
        else
        if ( LOWER(buf[strlen(buf)-1]) == 'f' 
          && !(LOWER(buf[strlen(buf)-2]) == 'i'
            && LOWER(buf[strlen(buf)-3]) == 'o') )
        {
            buf[strlen(buf)-1] = 'v';
            strcat( buf, "es" );
        }
        else
        if ( LOWER(buf[strlen(buf)-1]) == 'h' )
        strcat( buf, "es" );
        else            
        if ( LOWER(buf[strlen(buf)-1]) == 's' )
        {
            if ( LOWER(buf[strlen(buf)-2]) == 'u'
              && !IS_VOWEL(LOWER(buf[strlen(buf)-3])) )
            {
                buf[strlen(buf)-2] = 'i';
                buf[strlen(buf)-1] = '\0';
            }
            else
            strcat( buf, "es" );
        }
        else
        strcat( buf, "s" );

        strcat( buf, xbuf );
    }

    return buf;
}




/*
 * Thanks to Kalgen for the new procedure (no more bug!)
 * Original wordwrap() written by Surreality.
 */
char *format_string( char *oldstring /*, bool fSpace */)
{
  char xbuf[MAX_STRING_LENGTH];
  char xbuf2[MAX_STRING_LENGTH];
  char *rdesc;
  int i=0;
  bool cap=TRUE;
  
  xbuf[0]=xbuf2[0]=0;
  
  i=0;
  
  for (rdesc = oldstring; *rdesc; rdesc++)
  {
    if (*rdesc=='\n')
    {
      if (xbuf[i-1] != ' ')
      {
        xbuf[i]=' ';
        i++;
      }
    }
    else if (*rdesc=='\r') ;
    else if (*rdesc==' ')
    {
      if (xbuf[i-1] != ' ')
      {
        xbuf[i]=' ';
        i++;
      }
    }
    else if (*rdesc==')')
    {
      if (xbuf[i-1]==' ' && xbuf[i-2]==' ' && 
          (xbuf[i-3]=='.' || xbuf[i-3]=='?' || xbuf[i-3]=='!'))
      {
        xbuf[i-2]=*rdesc;
        xbuf[i-1]=' ';
        xbuf[i]=' ';
        i++;
      }
      else
      {
        xbuf[i]=*rdesc;
        i++;
      }
    }
    else if (*rdesc=='.' || *rdesc=='?' || *rdesc=='!') {
      if (xbuf[i-1]==' ' && xbuf[i-2]==' ' && 
          (xbuf[i-3]=='.' || xbuf[i-3]=='?' || xbuf[i-3]=='!')) {
        xbuf[i-2]=*rdesc;
        if (*(rdesc+1) != '\"')
        {
          xbuf[i-1]=' ';
          xbuf[i]=' ';
          i++;
        }
        else
        {
          xbuf[i-1]='\"';
          xbuf[i]=' ';
          xbuf[i+1]=' ';
          i+=2;
          rdesc++;
        }
      }
      else
      {
        xbuf[i]=*rdesc;
        if (*(rdesc+1) != '\"')
        {
          xbuf[i+1]=' ';
          xbuf[i+2]=' ';
          i += 3;
        }
        else
        {
          xbuf[i+1]='\"';
          xbuf[i+2]=' ';
          xbuf[i+3]=' ';
          i += 4;
          rdesc++;
        }
      }
      cap = TRUE;
    }
    else
    {
      xbuf[i]=*rdesc;
      if ( cap )
        {
          cap = FALSE;
          xbuf[i] = UPPER( xbuf[i] );
        }
      i++;
    }
  }
  xbuf[i]=0;
  strcpy(xbuf2,xbuf);
  
  rdesc=xbuf2;
  
  xbuf[0]=0;
  
  for ( ; ; )
  {
    for (i=0; i<77; i++)
    {
      if (!*(rdesc+i)) break;
    }
    if (i<77)
    {
      break;
    }
    for (i=(xbuf[0]?76:73) ; i ; i--)
    {
      if (*(rdesc+i)==' ') break;
    }
    if (i)
    {
      *(rdesc+i)=0;
      strcat(xbuf,rdesc);
      strcat(xbuf,"\n\r");
      rdesc += i+1;
      while (*rdesc == ' ') rdesc++;
    }
    else
    {
      bug ("No spaces", 0);
      *(rdesc+75)=0;
      strcat(xbuf,rdesc);
      strcat(xbuf,"-\n\r");
      rdesc += 76;
    }
  }
  while (*(rdesc+i) && (*(rdesc+i)==' '||
                        *(rdesc+i)=='\n'||
                        *(rdesc+i)=='\r'))
    i--;
  *(rdesc+i+1)=0;
  strcat(xbuf,rdesc);
  if (xbuf[strlen(xbuf)-2] != '\n')
    strcat(xbuf,"\n\r");

  free_string(oldstring);
  return(str_dup(xbuf));
}



/*
 * Adaptation of Kalgen's word-wrap procedure for neater effects.
 */
char *format_indent( char *oldstring, char *prefix, int width, bool fEnd )
{
    char xbuf[MAX_STRING_LENGTH];
    char xbuf2[MAX_STRING_LENGTH];
    char *rdesc;
    int i=0;
    bool cap=TRUE;

    xbuf[0]=xbuf2[0]=0;

    i = 0;

    for ( rdesc = oldstring; *rdesc; rdesc++ )
    {
        if ( *rdesc == '\n' )
        {
            if ( xbuf[i-1] != ' ' )
            {
                xbuf[i] = ' ';
                i++;
            }
        }
        else
        if ( *rdesc == '\r' ) ;
        else
        if ( *rdesc == ' ' )
        {
            if ( xbuf[i-1] != ' ' )
            {
                xbuf[i]=' ';
                i++;
            }
        }
        else
        if ( *rdesc == ')' )
        {
            if ( xbuf[i-1] == ' '
              && xbuf[i-2] == ' '
              && ( xbuf[i-3] == '.'
                || xbuf[i-3] == '?'
                || xbuf[i-3] == '!' ) )
            {
                xbuf[i-2]=*rdesc;
                xbuf[i-1]=' ';
                xbuf[i]=' ';
                i++;
            }
            else
            {
                xbuf[i]=*rdesc;
                i++;
            }
        }
        else
        if ( *rdesc == '.'
          || *rdesc == '?'
          || *rdesc == '!' )
        {
            cap = TRUE;
            if ( xbuf[i-1] == ' '
              && xbuf[i-2] == ' '
              && ( xbuf[i-3] == '.'
                || xbuf[i-3] == '?'
                || xbuf[i-3] == '!' ) )
            {
                xbuf[i-2]=*rdesc;
                if ( *(rdesc+1) != '\"' )
                {
                    xbuf[i-1]=' ';
                    xbuf[i]=' ';
                    i++;
                }
                else
                {
                    xbuf[i-1]='\"';
                    xbuf[i]=' ';
                    xbuf[i+1]=' ';
                    i+=2;
                    rdesc++;
                }
            }
            else
            {
                xbuf[i]=*rdesc;
                if (*(rdesc+1) != '\"')
                {
                    if ( *(rdesc+1) == ' ' )
                    {
                        xbuf[i+1]=' ';
                        xbuf[i+2]=' ';
                        i += 3;
                    }
                    else
                    {
                        cap = FALSE;
                        xbuf[i] = *rdesc;
                        i++;
                    }
                }
                else
                {
                  xbuf[i+1]='\"';
                  xbuf[i+2]=' ';
                  xbuf[i+3]=' ';
                  i += 4;
                  rdesc++;
                }
            }
        }
        else
        {
            xbuf[i]=*rdesc;
            if ( cap )
            {
                cap = FALSE;
                xbuf[i] = UPPER( xbuf[i] );
            }
            i++;
        }
    }

    xbuf[i]=0;
    strcpy(xbuf2,xbuf);

    rdesc=xbuf2;

    xbuf[0]=0;

    for ( ; ; )
    {
        for ( i = 0; i < width+1; i++ )
        {
            if ( !*(rdesc+i) )
            break;
        }

        if ( i < width+1 )
            break;

        for ( i = xbuf[0] ? width : width-3; i; i-- )
        {
            if ( *(rdesc+i) == ' ' )
            break;
        }

        if ( i )
        {
            *(rdesc+i)=0;
            strcat(xbuf,rdesc);
            strcat(xbuf,"\n\r");
            strcat(xbuf,prefix);
            rdesc += i+1;
            while (*rdesc == ' ') rdesc++;
        }
        else
        {
            bug ("No spaces", 0);
            *(rdesc+width-1)=0;
            strcat(xbuf,rdesc);
            strcat(xbuf,"-\n\r");
            rdesc += width;
        }
    }

    while (*(rdesc+i) && (*(rdesc+i)==' '||
                          *(rdesc+i)=='\n'||
                          *(rdesc+i)=='\r'))
      i--;
    *(rdesc+i+1)=0;
    strcat(xbuf,rdesc);
    if ( fEnd && xbuf[strlen(xbuf)-2] != '\n')
      strcat(xbuf,"\n\r");

    if ( xbuf[strlen(xbuf)-1] == ' ' )
         xbuf[strlen(xbuf)-1] = '\0';
    if ( xbuf[strlen(xbuf)-1] == ' ' )
         xbuf[strlen(xbuf)-1] = '\0';

    free_string(oldstring);
    return(str_dup(xbuf));
}



/*
 * Replace a substring with a new substring, return the new version.
 * (make sure to str_dup() when needed)
 */
char *replace_string( char *orig, char *old, char *new )
{
    static char xbuf[MAX_STRING_LENGTH];
    int i;

    xbuf[0]      = '\0';
      
    strcpy(xbuf, orig);
    if ( strstr(orig,old) != NULL )
    {
         i        = strlen( orig ) - strlen( strstr(orig, old) );
         xbuf[i]  = '\0';
         strcat( xbuf, new);
         strcat( xbuf, &orig[i+strlen( old )] );
    }

    return ( xbuf );
}


/*
 * Does the same thing as above but returns a str_dup()'d version.
 */
char * string_replace( char * orig, char * old, char * new )
{
    char xbuf[MAX_STRING_LENGTH];
    int i;

    xbuf[0] = '\0';
    strcpy( xbuf, orig );
    if ( strstr( orig, old ) != NULL )
    {
        i = strlen( orig ) - strlen( strstr( orig, old ) );
        xbuf[i] = '\0';
        strcat( xbuf, new );
        strcat( xbuf, &orig[i+strlen( old )] );
        free_string( orig );
    }

    return str_dup( xbuf );
}

/*
 * Counts the number of "words" (strings of non-spaces separated by spaces)
 * in a string.     Not the best way (should use one_arg).
 */
int arg_count( char *argument )
{
    int total;
    char *s;

    total = 0;
    s = argument;

    while ( *s != '\0' )
    {
        if ( *s != ' ' )
        {
            total++;
            while ( *s != ' ' && *s != '\0' )
                s++;
        }
        else
        {
            s++;
        }
    }

    return total;
}



/*
 * Returns a string with one space between each argument.
 */
char * string_unpad( char * argument )
{
    char buf[MAX_STRING_LENGTH];
    char *s;

    s = argument;

    while ( *s == ' ' )
        s++;

    strcpy( buf, s );
    s = buf;

    if ( *s != '\0' )
    {
        while ( *s != '\0' )
            s++;
        s--;

        while( *s == ' ' )
            s--;
        s++;
        *s = '\0';
    }

    free_string( argument );
    return str_dup( buf );
}



/*
 * First char is capitol, the rest is lowercase or something to that effect.
 */
char * string_proper( char * argument )
{
    char *s;

    s = argument;

    while ( *s != '\0' )
    {
        if ( *s != ' ' )
        {
            *s = UPPER(*s);
            while ( *s != ' ' && *s != '\0' )
                s++;
        }
        else
        {
            s++;
        }
    }

    return argument;
}




void string_edit( CHAR_DATA *ch, char **pString )
{
    send_to_char( " Entering line editing mode, terminate with a ~ or @ on a blank line.\n\r", ch );
    send_to_char( "-====================================================================-\n\r", ch );

    if ( *pString == NULL )
    {
        *pString = str_dup( "" );
    }
    else
    {
        free_string( *pString );
        *pString = str_dup( "" );
    }

    ch->desc->pString = pString;
    return;
}



void string_append( CHAR_DATA *ch, char **pString )
{
    send_to_char( "-=========================- Entering APPEND Mode -=======================-\n\r", ch );
    send_to_char( " Type .h on a new line for help, terminate with a ~ or @ on a blank line.\n\r", ch );
    send_to_char( "-========================================================================-\n\r", ch );

    ch->desc->pString = pString;
    return;
}
                                        

void string_add( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];

    if ( *argument == '.' )
    {
        char arg1 [MAX_INPUT_LENGTH];
        char arg2 [MAX_INPUT_LENGTH];
        char arg3 [MAX_INPUT_LENGTH];

        argument = one_argument( argument, arg1 );
        argument = first_arg( argument, arg2, FALSE );
        argument = first_arg( argument, arg3, FALSE );

        if ( !str_cmp( arg1, ".c" ) )
        {
            send_to_char( "String cleared.\n\r", ch );
            free_string( *ch->desc->pString );
            *ch->desc->pString = str_dup( "" );
            return;
        }

        if ( !str_cmp( arg1, ".p" ) )
        {
#if defined(unix)
        FILE *out;
        char *pf;

        out=fopen(".roomdesc","w");
        if ( *argument )
        fprintf(out,"%s\n", argument );
        else
        fprintf(out,"%s\n", *ch->desc->pString );
        fflush(out);
        fclose(out);

        out = popen( "ispell -a -S < .roomdesc", "r" );
        send_to_char( "The following words are misspelled:\n\r", ch );
        
        while (fgets(buf, MAX_STRING_LENGTH-1, out) != NULL)
        {
            if ( buf[0] != '&' ) continue;
            pf = format_string( str_dup( buf ) );
            send_to_char( pf, ch );
            free_string( pf );
        }
            
        pclose( out );
#else
        send_to_char( "Unix systems only.\n\r", ch );
#endif
        return;
        }

        if ( !str_cmp( arg1, ".s" ) )
        {
            send_to_char( "String so far:\n\r", ch );
            send_to_char( *ch->desc->pString, ch );
            return;
        }

        if ( !str_cmp( arg1, ".r" ) )
        {
            if ( arg2[0] == '\0' )
            {
                send_to_char( "usage:  .r \"old string\" \"new string\"\n\r", ch );
                return;
            }

            *ch->desc->pString = string_replace( *ch->desc->pString, arg2, arg3 );
            sprintf( buf, "'%s' replaced with '%s'.\n\r", arg2, arg3 );
            send_to_char( buf, ch );
            return;
        }

        if ( !str_cmp( arg1, ".f" ) )
        {
            *ch->desc->pString = format_string( *ch->desc->pString );
            send_to_char( "String formatted.\n\r", ch );
            return;
        }

        if ( !str_cmp( arg1, ".q" ) )
        {
            ch->desc->pString = NULL;
            return;
        }
        
        if ( !str_cmp( arg1, ".h" ) )
        {
            send_to_char( "Editor help (commands available from the beginning of a new line only):  \n\r", ch );
            send_to_char( ".r 'old string' 'new string'   - replace a substring with a new string  \n\r", ch );
            send_to_char( ".m                             - spell check string (w/ unix spell)     \n\r", ch );
            send_to_char( ".h                             - get sedit help (this)                  \n\r", ch );
            send_to_char( ".s                             - show string so far                     \n\r", ch );
            send_to_char( ".f                             - format (word wrap) string              \n\r", ch );
            send_to_char( ".c                             - clear string so far                    \n\r", ch );
            send_to_char( ".p                             - check spelling of the entire string    \n\r", ch );
            send_to_char( ".p 'word'                      - check spelling of a word               \n\r", ch );
            send_to_char( ".q              (also: @ or ~) - exit string editor (end string)        \n\r", ch );
            return;
        }

        send_to_char( "SEdit:  Invalid dot command.\n\r", ch );
        return;
    }

    if ( *argument == '~' || *argument == '@' )
    {
        ch->desc->pString = NULL;
        return;
    }

    sprintf( buf, "%s", *ch->desc->pString );

    if ( strlen( buf ) + strlen( argument ) >= ( MAX_STRING_LENGTH - 4 ) )
    {
        send_to_char( "String too long, truncating.\n\r", ch );
        strncat( buf, argument, MAX_STRING_LENGTH );
        free_string( *ch->desc->pString );
        *ch->desc->pString = str_dup( buf );
        ch->desc->pString = NULL;
        return;
    }

    strcat( buf, argument );
    strcat( buf, "\n\r" );
    free_string( *ch->desc->pString );
    *ch->desc->pString = str_dup( buf );
    return;
}



/*
 * Return true if an argument is completely numeric.
 */
bool is_number( char *arg )
{
    if ( *arg == '\0' )
        return FALSE;
        
    if ( *arg == '-' )
      {
       arg++;
       if ( !isdigit(*arg) ) return FALSE;
       arg++;
	 }           /* legalize your minus */
 
    for ( ; *arg != '\0'; arg++ )
      {
        if ( !isdigit(*arg) )
            return FALSE;
      }
 
    return TRUE;
}

/*
 * Given a string like 14.foo, return 14 and 'foo'
 */
int number_argument( char *argument, char *arg )
{
    char *pdot;
    int number;
    
    for ( pdot = argument; *pdot != '\0'; pdot++ )
    {
	if ( *pdot == '.' )
	{
	    *pdot = '\0';
	    number = atoi( argument );
	    *pdot = '.';
	    strcpy( arg, pdot+1 );
	    return number;
	}
    }

    strcpy( arg, argument );
    return 1;
}



/*
 * Pick off one argument from a string and return the rest.
 * Understands quotes.
 */
char *one_argument( char *argument, char *arg_first )
{
    char cEnd;

    if ( argument == NULL ) return "";

    while ( isspace(*argument) )
	argument++;

    cEnd = ' ';
    if ( *argument == '\'' || *argument == '"' )
	cEnd = *argument++;

    while ( *argument != '\0' )
    {
	if ( *argument == cEnd )
	{
	    argument++;
	    break;
	}
	*arg_first = LOWER(*argument);
	arg_first++;
	argument++;
    }
    *arg_first = '\0';

    while ( isspace(*argument) )
	argument++;

    return argument;
}


/*
 * Pick off one argument from a string and return the rest.
 * Understands quotes.    No case manipulations.
 */
char *one_argcase( char *argument, char *arg_first )
{
    char cEnd;

    while ( isspace(*argument) )
	argument++;

    cEnd = ' ';
    if ( *argument == '\'' || *argument == '"' )
	cEnd = *argument++;

    while ( *argument != '\0' && *argument != '\n' )
    {
	if ( *argument == cEnd )
	{
	    argument++;
	    break;
	}
	arg_first++;
	argument++;
    }
    *arg_first = '\0';

    while ( isspace(*argument) )
	argument++;

    return argument;
}


char * strupr( char * s )
{
   char * u;

   for( u = s; *u != '\0'; u++ )
   {
       *u = UPPER(*u);
   }

   return s;
}

char * strlwr( char * s )
{
   char * u;

   for( u = s; *u != '\0'; u++ )
   {
       *u = LOWER(*u);
   }

   return s;
}


/*
 * Take a string like <[3m<[1mhi and make it <[3m<[1mHi
 * Thanx to Arcane@max.tiac.net from TIACMUD
 * Changes made by Locke.
 */
char *ansi_uppercase(char *txt)
{
  char *str;

  str = txt;

  while ( *str )
  {
  if ( *str == ESC )  str++;
     else break;
  if ( *str == '[' )  str++;
     else break;
  while( isdigit(*str) ) str++;
  if ( *str == 'm' )  str++;
     else break;
  }

  *str = UPPER(*str);

  return txt;
}


/*
 * See if a string is one of the names of an object.
 */
bool is_name( const char *str, char *namelist )
{
    char name[MAX_INPUT_LENGTH];

    if ( str == NULL || namelist == NULL ) return FALSE;

    for ( ; ; )
    {
	namelist = one_argument( namelist, name );
	if ( name[0] == '\0' )
	    return FALSE;
    if ( !str_cmp( str, name ) )            /* str_cmp for full matching */
	    return TRUE;
    }
}


/*
 * See if a string is one of the keywords in a string.
 * Checks as prefixes.
 */
bool is_prename( const char *str, char *namelist )
{
    char name[MAX_INPUT_LENGTH];

    if ( str == NULL || namelist == NULL ) return FALSE;

    for ( ; ; )
    {
	namelist = one_argument( namelist, name );
	if ( name[0] == '\0' )
	    return FALSE;
    if ( !str_prefix( str, name ) )
	    return TRUE;
    }
}


/*
 * Take a number like 43 and make it forty-three.
 */
char *   const  ones_numerals [10] =
{
    "zero",
    "one",
    "two",
    "three",
    "four",
    "five",
    "six",
    "seven",
    "eight",
    "nine"
};

char *   const  tens_numerals [10] =
{
    "-",
    "-",
    "twenty",
    "thirty",
    "forty",
    "fifty",
    "sixty",
    "seventy",
    "eighty",
    "ninety"
};

char *   const  meta_numerals [4] =
{
    "hundred",
    "thousand",
    "million",
    "billion"
};

char *   const  special_numbers [10] =
{
    "ten",
    "eleven",
    "twelve",
    "thirteen",
    "fourteen",
    "fifteen",
    "sixteen",
    "seventeen",
    "eighteen",
    "nineteen"
};



char *numberize( int n )
{
    static char buf[MAX_STRING_LENGTH];
    sh_int    digits[3];
    int t = abs(n);

    buf[0] = '\0';

    /*
     * Special cases (10-19)
     */
    if ( n >= 10 && n <= 19 )
    {
        sprintf( buf, "%s", special_numbers[n-10] );
        return buf;
    }

    if ( n < 10 && n >= 0 )
    {
        sprintf( buf, "%s", ones_numerals[n] );
        return buf;
    }

    /*
     * Cha.
     */
    if ( n >= 10000 || n < 0 )
    {
        sprintf( buf, "%d", n );
        return buf;
    }


    digits[3] = t / 1000;
    t -= 1000*digits[3];
    digits[2] = t / 100;
    t -= 100*digits[2];
    digits[1] = t / 10;
    t -= 10*digits[1];
    digits[0] = t;

    if ( digits[3] > 0 )
    {
        sprintf( buf, "%s%s", buf, ones_numerals[digits[3]] );
        sprintf( buf, "%s thousand ", buf );
    }

    if ( digits[2] > 0 )
    {
        sprintf( buf, "%s%s", buf, ones_numerals[digits[2]] );
        sprintf( buf, "%s hundred ", buf );
    }

    if ( digits[1] > 0 )
    {
        sprintf( buf, "%s%s", buf, tens_numerals[digits[1]] );
        if ( digits[0] > 0 ) sprintf( buf, "%s-", buf );
    }

    if ( digits[0] > 0 )
    {
        sprintf( buf, "%s%s", buf, ones_numerals[digits[0]] );
    }

    if ( buf[(t = strlen(buf)-1)] == ' ' )  buf[t] = '\0';
    if ( buf[(t = strlen(buf)-1)] == ' ' )  buf[t] = '\0';
    return buf;
}





/*
 * Pick off one argument from a string and return the rest.
 * Understands quotes, parenthesis (barring ()'s) and percentages.
 */
char *first_arg( char *argument, char *arg_first, bool fCase )
{
    char cEnd;

    while ( *argument == ' ' )
	argument++;

    cEnd = ' ';
    if ( *argument == '\'' || *argument == '"'
      || *argument == '%'  || *argument == '(' )
    {
        if ( *argument == '(' )
        {
            cEnd = ')';
            argument++;
        }
        else cEnd = *argument++;
    }

    while ( *argument != '\0' )
    {
	if ( *argument == cEnd )
	{
	    argument++;
	    break;
	}
    if ( fCase ) *arg_first = LOWER(*argument);
            else *arg_first = *argument;
	arg_first++;
	argument++;
    }
    *arg_first = '\0';

    while ( *argument == ' ' )
	argument++;

    return argument;
}



/*
 * Skips forward to the next non-space.
 */
char *skip_spaces( char *argument )
{
    while ( *argument == ' ' )  argument++;

    return argument;
}



/*
 * Takes the top line off a multi-line string, returns a pointer to the next.
 */
char *grab_line( char *argument, char *arg_first )
{
    while ( *argument != '\n' && *argument != '\0' )
    *arg_first++ = *argument++;

    if ( *argument == '\n' ) argument++;
    if ( *argument == '\r' ) argument++;

    *arg_first++ = '\0';

    return argument;
}



/*
 * Takes the top line off a multi-line string, returns a pointer to the next.
 */
char *one_line( char *argument, char *arg_first )
{
    while ( *argument != '\0' )
    {
        if ( *argument == ';'  )
        {
            argument++;
            break;
        }

        /*
         * Skip comments.
         */
        if ( *argument == '*' )
        while ( *argument != '\n' && *argument != '\0' ) argument++;

        /*
         * Jump past literals.
         */
        if ( *argument == '{' )
        {
            int curlies = 0;

            *arg_first++ = *argument++;
            while( *argument != '\0' )
            {

                /*
                 * Ok, get the hell out of here, we're done.
                 * { .... }
                 *        ^
                 */
                if ( curlies == 0 )
                   if ( *argument == '}'
                     || *argument == '\0' )
                     break;

                if ( *argument == '{' ) curlies++;
                else
                if ( *argument == '}' ) curlies--;

                *arg_first++ = *argument++;
            }

            if ( curlies != 0 )
            NOTIFY("Notify>  One_line: Unmatched {}s in literal.", LEVEL_IMMORTAL, WIZ_NOTIFY_SCRIPT);

            if ( *argument == '}' ) *arg_first++ = *argument++;
        }
        else
        if ( *argument == '\n' || *argument == '\r' ) argument++;
        else
        *arg_first++ = *argument++;
    }

    *arg_first = '\0';
    return argument;
}



bool has_arg( char *argument, char *item )
{
    char arg[MAX_STRING_LENGTH];

    while ( *argument != '\0' )
    {
        argument = first_arg( argument, arg, TRUE );
        if ( !str_cmp( arg, item ) )
        return TRUE;
    }

    return FALSE;
}



char *trunc_fit( char *argument, int length )
{
    static char buf[MAX_STRING_LENGTH];
    int x;

    if ( argument == NULL )
    return argument;

    for ( x = 0;  (x < length) && (*argument != '\0');  x++ )
    {
        buf[x] = *argument;
        argument++;
    };
    buf[x] = '\0';

    return buf;
};



char *gotoxy( int x, int y )
{
    static char buf[30];

    sprintf( buf, "\x1b[%d;%dH", y, x );
    return buf;
};



char *skip_curlies( char *arg )
{
    char *p = arg;
    int curlies = 0;

    while( *arg != '\0' && *arg != '{' ) arg++;

    if ( *arg == '\0' ) return p;

    while( *arg != '\0' )
    {
        /*
         * Ok, get the hell out of here, we're done.
         * { .... }
         *        ^
         */
        if ( curlies == 0 )
        {
           if ( *arg == '}'
             || *arg == '\0' )
             break;
        }

        if ( *arg == '{' ) curlies++;
        else
        if ( *arg == '}' ) curlies--;

        arg++;
    }

    return arg;
}



char *strip_curlies( char *arg )
{
    static char buf[MAX_STRING_LENGTH];
    char *p;
    int curlies = 0;

    sprintf( buf, "%s", arg );
    arg = skip_spaces( arg );
    if ( *arg++ != '{' ) return buf;

    p = buf;
    while( *arg != '\0' )
    {
        /*
         * Ok, get the hell out of here, we're done.
         * { .... }
         *        ^
         */
        if ( curlies == 0 )
        {
           if ( *arg == '}'
             || *arg == '\0' )
             break;
        }

        if ( *arg == '{' ) curlies++;
        else
        if ( *arg == '}' ) curlies--;

        *p++ = *arg++;
    }

    *p = '\0';
    return buf;
}

