/***************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "script.h"
#include "skills.h"
#include "comm.h"
#include "board.h"


int     num_hour              = PULSE_PER_SECOND * 60 * 60 * 24;
int     pulse_area;
int     pulse_mobile;
int     pulse_violence;
int     pulse_point;
int     autosave_counter;

/*
 * Local functions.
 */
void    aggr_update     args( ( void ) );


void    save_config     args( ( void ) );


/*
 * From board.c
 */

void save_board( int b );

extern struct note_data     *note_list[MAX_BOARD];



     


/*
 * Regeneration stuff.
 */
int hit_gain( CHAR_DATA *ch )
{
    int gain;

    if ( IS_NPC(ch) )
    {
    gain = get_curr_con(ch) * 3 / 2;
    }
    else
    {
    gain = UMIN( 5, get_curr_con(ch) );

	switch ( ch->position )
	{
	case POS_SLEEPING: gain += get_curr_con(ch);		break;
	case POS_RESTING:  gain += get_curr_con(ch) / 2;	break;
	}

    if ( PC(ch,condition[COND_FULL])   <= 0 )
	    gain /= 2;

    if ( PC(ch,condition[COND_THIRST]) <= 0 )
	    gain /= 2;

    }

    if ( IS_AFFECTED(ch, AFF_POISON) )
	gain /= 4;

    return UMIN(gain, MAXHIT(ch) - ch->hit);
}





int move_gain( CHAR_DATA *ch )
{
    int gain;

    if ( IS_NPC(ch) )
    {
    gain = get_curr_con(ch);
    }
    else
    {
    gain = UMAX( 15, 2 * get_curr_con(ch) );

	switch ( ch->position )
	{
	case POS_SLEEPING: gain += get_curr_dex(ch);		break;
	case POS_RESTING:  gain += get_curr_dex(ch) / 2;	break;
	}

    if ( PC(ch,condition[COND_FULL])   <= 0 )
	    gain /= 2;

    if ( PC(ch,condition[COND_THIRST]) <= 0 )
	    gain /= 2;
    }

    if ( IS_AFFECTED(ch, AFF_POISON) )
	gain /= 4;

    return UMIN(gain, MAXMOVE(ch) - ch->move);
}



void gain_condition( CHAR_DATA *ch, int iCond, int value )
{
    int condition;

    if ( IS_NPC(ch) || IS_HERO(ch) )
        return;

    /*
     * Nasty desert.
     * Nasty.
     */
    if ( iCond == COND_THIRST 
      && value < 0
      && ch->in_room 
      && ch->in_room->sector_type == SECT_DESERT )   value *= 2;

    condition               = PC(ch,condition[iCond]);
    PC(ch,condition[iCond]) = URANGE( -100, condition + value, 100 );

    if ( iCond == COND_DRUNK && PC(ch,condition[iCond]) < 0 )
        PC(ch,condition[iCond]) = 0;

    condition = PC(ch,condition[iCond]);

/*
    if ( PC(ch,condition[iCond]) < 10 )
    {
      switch ( iCond )
      {
      case COND_FULL:   send_to_char( "You are hungry.\n\r",  ch );   break;
      case COND_THIRST: send_to_char( "You are thirsty.\n\r", ch );   break;
      }
    }
*/

    if ( iCond == COND_DRUNK
      && condition == 5 )
        send_to_char( "You sober up.\n\r", ch );

    if ( PC(ch,condition[iCond]) < 0 )
    {
      switch ( iCond )
      {
      case COND_FULL:
          if ( condition < -80 )
          send_to_char( "You are dying of starvation; you require sustinence.\n\r", ch );
     else if ( condition < -60 )
          send_to_char( "You begin to feel the effects of lack of food; you are weak and dizzy.\n\r", ch );
     else if ( condition < -40 )
          send_to_char( "You feel faint from lack of food, you are starving.\n\r",  ch );
     else if ( condition < -20 )
          send_to_char( "Your stomach is growling, you should really eat something.\n\r", ch );

          if ( PC(ch,condition[iCond]) <= -100
            && ch->position > POS_SLEEPING )
          {
              send_to_char(  "You collapse due to lack of food...", ch );
              act( "$n collapses!", ch, NULL, NULL, TO_ROOM );
              ch->position = POS_STUNNED;
          }
          break;

      case COND_THIRST:
          if ( condition < -80 )
          send_to_char( "You are dying of dehydration; you need fluid.\n\r", ch );
     else if ( condition < -60 )
          send_to_char( "Having gone without liquid, you are now feeling weak and dehydrated.\n\r", ch );
     else if ( condition < -40 )
          send_to_char( "You feel faint and sickly, you are dehydrating.\n\r",  ch );
     else if ( condition < -20 )
          send_to_char( "You are really thirsty and your lips are quite parched.\n\r", ch );

          if ( PC(ch,condition[iCond]) <= -100 )
          {
              send_to_char(  "You have died of dehydration!", ch );
              act( "$n dies of dehydration!", ch, NULL, NULL, TO_ROOM );
              raw_kill(ch);
          }
          break;
      }
    }

    return;
}


/*
 * Mob autonomous action.
 * This function takes 25% to 35% of ALL Merc cpu time.
 * -- Furey
 */
void mobile_update( void )
{
    CHAR_DATA *ch;
    CHAR_DATA *ch_next;
    EXIT_DATA *pexit;
    int door;

    /* Examine all mobs. */
    for ( ch = char_list; ch != NULL; ch = ch_next )
    {
	ch_next = ch->next;

    if ( ch->in_room == NULL )
        continue;

    /* Add drowning here... */

    if ( !IS_NPC(ch) )
        continue;

    if ( ch->timer > 0 )
    {
        if ( --ch->timer == 0 )
        {
        act( "$n has left.", ch, NULL, NULL, TO_ROOM );
        act( "Your time has run out.", ch, NULL, NULL, TO_CHAR );
        raw_kill( ch );
        continue;
        }
    }

    if ( IS_AFFECTED(ch, AFF_CHARM) )
	    continue;

	/* Examine call for special procedure */
	/* That's all for sleeping / busy monster */
	if ( ch->position != POS_STANDING )
	    continue;

	/* Wander */
	if ( !IS_SET(ch->act, ACT_SENTINEL)
    && ( door = number_bits( MAX_DIR ) ) < MAX_DIR
	&& ( pexit = ch->in_room->exit[door] ) != NULL
	&&   pexit->to_room != NULL
	&&   !IS_SET(pexit->exit_info, EX_CLOSED)
	&&   !IS_SET(pexit->to_room->room_flags, ROOM_NO_MOB)
	&& ( !IS_SET(ch->act, ACT_STAY_AREA)
	||   pexit->to_room->area == ch->in_room->area ) )
	{
	    move_char( ch, door );
	    if ( ch->position < POS_STANDING )
	        continue;
	}

	/* Flee */
    if ( ch->hit < MAXHIT(ch) / 2
    && ( door = number_bits( MAX_DIR ) ) < MAX_DIR
	&& ( pexit = ch->in_room->exit[door] ) != NULL
	&&   pexit->to_room != NULL
	&&   !IS_SET(pexit->exit_info, EX_CLOSED)
	&&   !IS_SET(pexit->to_room->room_flags, ROOM_NO_MOB) )
	{
	    CHAR_DATA *rch;
	    bool found;

	    found = FALSE;
	    for ( rch  = pexit->to_room->people;
		  rch != NULL;
		  rch  = rch->next_in_room )
	    {
		if ( !IS_NPC(rch) )
		{
		    found = TRUE;
		    break;
		}
	    }
	    if ( !found )
        move_char( ch, door );
	}

    }

    return;
}



/*
 * Update the time table.
 */
void time_update( void )
{
    char buf[MAX_STRING_LENGTH];
    int rstr = number_range( 1, 3 );

    switch ( ++time_info.hour )
    {
    case  4:
        if ( weather_info.sunlight != MOON_RISE )
        break;

        weather_info.sunlight = MOON_SET;
        weather_info.temperature -= number_fuzzy( 5 );

        if ( rstr == 1 )
        strcat( buf, "The moon sets.\n\r" );
        else
        if ( rstr == 2 )
        strcat( buf, "The moon disappears beneath the horizon.\n\r" );
        else
        strcat( buf, "The sky grows dark as the moon sets.\n\r" );
       break;

    case  5:
        weather_info.sunlight = SUN_LIGHT;

        if ( rstr == 1 )
        strcat( buf, "Dawn blushes the sky with hues of orange and magenta.\n\r" );
        else
        if ( rstr == 2 )
        strcat( buf, "The day has begun.\n\r" );
        else
        strcat( buf, "It is dawn.\n\r" );

        if ( time_info.month == 0
          || time_info.month == 1
          || time_info.month == 11 )
        weather_info.temperature = number_fuzzy( 20 );   /* Winter */
        else
        if ( time_info.month == 2
          || time_info.month == 3
          || time_info.month == 4 )
        weather_info.temperature = number_fuzzy( 50 );   /* Spring */
        else
        if ( time_info.month == 5
          || time_info.month == 6
          || time_info.month == 7 )
        weather_info.temperature = number_fuzzy( 80 );   /* Summer */
        else
        weather_info.temperature = number_fuzzy( 45 );   /* Autumn */
       break;

    case  6:
        weather_info.sunlight = SUN_RISE;
        weather_info.temperature += number_fuzzy( 15 );

        if ( rstr == 1 )
        strcat( buf, "The first shafts of sunlight streak along their western path.\n\r" );
        else
        if ( rstr == 2 )
        strcat( buf, "The sun rises in the east.\n\r" );
        else
        strcat( buf, "The sun illuminates the lands.\n\r" );
       break;

    case  12:
        weather_info.temperature += number_fuzzy( 20 );

        if ( rstr == 1 )
        strcat( buf, "It is noon.\n\r" );
        else
        if ( rstr == 2 )
        strcat( buf, "The sun reaches its apex in the sky.\n\r" );
        else
        strcat( buf, "Sunlight beats down upon you from directly above.\n\r" );
       break;

    case 19:
        weather_info.sunlight = SUN_SET;
        weather_info.temperature -= number_fuzzy( 20 );

        if ( rstr == 1 )
        strcat( buf, "The sun slowly disappears in the west.\n\r" );
        else
        if ( rstr == 2 )
        strcat( buf, "The sun dips below the western horizon.\n\r" );
        else
        strcat( buf, "The sun sets with a glorious twilight.\n\r" );
       break;

    case 20:
        weather_info.sunlight = SUN_DARK;
        weather_info.temperature -= number_fuzzy( 10 );

        if ( rstr == 1 )
        strcat( buf, "The night has begun.\n\r" );
        else
        if ( rstr == 2 )
        strcat( buf, "The last bit of twilight fades away to blackness.\n\r" );
        else
        strcat( buf, "The darkness of night engulfs the realm.\n\r" );
       break;

    case 24:
        if ( weather_info.moon_phase != MOON_NEW )
        weather_info.sunlight = MOON_RISE;
        weather_info.temperature -= number_fuzzy( 10 );
        time_info.hour = 0;
        time_info.day++;              /* New Day */
        save_config( );


        if ( ++weather_info.next_phase % 3 == 0 )
        {
            weather_info.moon_phase++;
            if ( weather_info.moon_phase >= MOON_MAX )
            {
                weather_info.moon_phase = MOON_NEW;
                weather_info.next_phase = 0;
            }
        }

        if ( weather_info.moon_phase == MOON_NEW )
        strcat( buf, "A black disc, devoid of stars, is the only moon on this night.\n\r" );
   else if ( weather_info.moon_phase == MOON_WAXING_CRESCENT )
        strcat( buf, "The short sliver of moon offers its jagged edge to the night sky.\n\r" );
   else if ( weather_info.moon_phase == MOON_WAXING_HALF )
        strcat( buf, "The waxing half moon rises for its night journey across the heavens.\n\r" );
   else if ( weather_info.moon_phase == MOON_WAXING_THREE_QUARTERS )
        strcat( buf, "The waxing three quarter moon rises.\n\r" );
   else if ( weather_info.moon_phase == MOON_FULL )
        strcat( buf, "The full moon rises, casting a silver glow over the night.\n\r" );
   else if ( weather_info.moon_phase == MOON_WANING_THREE_QUARTERS )
        strcat( buf, "The grey-silver waning three-quarter moon begins its nocturnal trek.\n\r" );
   else if ( weather_info.moon_phase == MOON_WANING_HALF )
        strcat( buf, "Amidst an oceanic starry night sky, the waning half moon floats,\n\rits silvery ship adrift on celestial currents.\n\r" );
   else if ( weather_info.moon_phase == MOON_WANING_CRESCENT )
        strcat( buf, "A curved waning crescent moon graces the night with a few rays of moonlight.\n\r" );
       break;
    }

    if ( time_info.day   >= 30 )     /* New Month */
    {
        time_info.day = 0;
        time_info.month++;
    }

    if ( time_info.month >= 12 )     /* New Year  */
    {
        time_info.month = 0;
        time_info.year++;
    }
}



/*
 * Update the weather.
 * (mmhg=Millimeters of Mercury)
 */
void weather_update( void )
{
    char buf[MAX_STRING_LENGTH];
    DESCRIPTOR_DATA *d;
    int diff;

    buf[0] = '\0';

    /*
     * Weather change.
     */
    if ( number_bits( 4 ) == 0 )
    {
        int olddir = weather_info.winddir;

        weather_info.winddir += number_range( 0, 2 )-1;
        if ( weather_info.winddir % 3 != olddir )
        strcat( buf, "The wind changes direction.\n\r" );
    }

    if ( time_info.month >= 9 && time_info.month <= 16 )
	diff = weather_info.mmhg >  985 ? -2 : 2;
    else
	diff = weather_info.mmhg > 1015 ? -2 : 2;

    weather_info.change   += diff * dice(1, 4) + dice(2, 6) - dice(2, 6);
    weather_info.change    = UMAX(weather_info.change, -12);
    weather_info.change    = UMIN(weather_info.change,  12);

    weather_info.mmhg += weather_info.change;
    weather_info.mmhg  = UMAX(weather_info.mmhg,  960);
    weather_info.mmhg  = UMIN(weather_info.mmhg, 1040);

    switch ( weather_info.sky )
    {
    default: 
        bug( "Weather_update: bad sky %d.", weather_info.sky );
        weather_info.sky = SKY_CLOUDLESS;
       break;

    case SKY_CLOUDLESS:
        if ( weather_info.mmhg <  990
        || ( weather_info.mmhg < 1010 && number_bits( 2 ) == 0 ) )
        {
            if ( time_info.month < 2 || time_info.month == 11 )
            {
                strcat( buf, "A few flakes of snow are falling.\n\r" );
                weather_info.temperature -= 15;
            }
            else
            {
                if ( weather_info.sunlight == MOON_RISE )
                strcat( buf, "The moon passes behind a cloud.\n\r" );
                else
                strcat( buf, "The sky is getting cloudy.\n\r" );
                weather_info.temperature -= 5;
            }

            weather_info.sky = SKY_CLOUDY;
            weather_info.windspeed += 10;
        }
       break;

    case SKY_CLOUDY:
        if ( weather_info.mmhg <  970
        || ( weather_info.mmhg <  990 && number_bits( 2 ) == 0 ) )
        {
            if ( time_info.month < 2 || time_info.month == 11 )
            {
                strcat( buf, "It starts to snow.\n\r" );
                weather_info.temperature -= 15;
            }
            else
            {
                strcat( buf, "It starts to rain.\n\r" );
                weather_info.temperature -= 5;
            }

            weather_info.sky = SKY_RAINING;
            weather_info.windspeed += 10;
        }

        if ( weather_info.mmhg > 1030 && number_bits( 2 ) == 0 )
        {
            if ( time_info.month < 2 || time_info.month == 11 )
            {
                strcat( buf, "The snow lets up.\n\r" );
                weather_info.temperature += 15;
            }
            else
            {
                if ( weather_info.sunlight == MOON_RISE )
                strcat( buf, "The clouds disappear and the moon again shines into the night.\n\r" );
                else
                strcat( buf, "The clouds disappear.\n\r" );
                weather_info.temperature += 5;
            }

            weather_info.sky = SKY_CLOUDLESS;
            weather_info.windspeed -= 10;
        }
       break;

    case SKY_RAINING:
        if ( weather_info.mmhg <  970 && number_bits( 2 ) == 0 )
        {
            if ( time_info.month < 2 || time_info.month == 11 )
            {
                strcat( buf, "You are caught in a blizzard.\n\r" );
                weather_info.temperature -= 30;
            }
            else
            strcat( buf, "Lightning flashes in the sky.\n\r" );

            weather_info.sky = SKY_LIGHTNING;
            weather_info.windspeed += 10;
        }

        if ( weather_info.mmhg > 1030
        || ( weather_info.mmhg > 1010 && number_bits( 2 ) == 0 ) )
        {
            if ( time_info.month < 2 || time_info.month == 11 )
            {
                strcat( buf, "The snow is letting up.\n\r" );
                weather_info.temperature += 30;
            }
            else
            strcat( buf, "The rain stopped.\n\r" );

            weather_info.sky = SKY_CLOUDY;
            weather_info.windspeed -= 10;
        }
       break;

    case SKY_LIGHTNING:
        if ( weather_info.mmhg > 1010
        || ( weather_info.mmhg >  990 && number_bits( 2 ) == 0 ) )
        {
            if ( time_info.month < 2 || time_info.month == 11 )
            {
                strcat( buf, "The blizzard subsides.\n\r" );
                weather_info.temperature += 10;
            }
            else
            strcat( buf, "The lightning has stopped.\n\r" );

            weather_info.sky = SKY_RAINING;
            weather_info.windspeed -= 10;
            break;
        }
       break;
    }

    if ( buf[0] != '\0' )
    {
        for ( d = descriptor_list; d != NULL; d = d->next )
        {
            if ( d->connected == CON_PLAYING
              && IS_OUTSIDE(d->character)
              && IS_AWAKE(d->character) )
            send_to_char( buf, d->character );
        }
    }

    return;
}



/*
 * Update all chars, including mobs.
 * This function is performance sensitive.
 */
void char_update( bool fEach )
{
    CHAR_DATA *ch;
    CHAR_DATA *ch_next;
    CHAR_DATA *ch_save;
    CHAR_DATA *ch_quit;
    time_t save_time;

    save_time	= current_time;
    ch_save	= NULL;
    ch_quit	= NULL;
    for ( ch = char_list; ch != NULL; ch = ch_next )
    {
	AFFECT_DATA *paf;
	AFFECT_DATA *paf_next;

	ch_next = ch->next;

	script_update( ch, TYPE_MOB, fEach ? TRIG_EACH_PULSE : TRIG_TICK_PULSE,
				   NULL, NULL, NULL, NULL );

    if ( !fEach )
    {
        if ( !IS_NPC(ch) )
        {
            int iSkill;

            for ( iSkill = 0; iSkill < MAX_SKILL; iSkill++ )
            {
                if ( PC(ch,skill_time[iSkill]) > 0 )
                     PC(ch,skill_time[iSkill])--;

                /*
                 * Forget skills when unused too long...
                 *          -- Newt
                 */

                if ( PC(ch, learned)[iSkill] > 0
                /* --------------------------------------------------------
                &&   skill_table[iSkill].forget_time > 0
                                                 ^^^^^^^^^^^
                    Add "forget_time" field to skill_table!

                &&   PC(ch,last_used)[iSkill] > skill_table[iSkill].forget_time
                   --------------------------------------------------------- */
                &&   number_bits(5) == 0
                && !IS_IMMORTAL(ch) )
                {
                     PC(ch, learned)[iSkill]--;
                     PC(ch, last_used)[iSkill] = 0;
                }
                else
                    PC(ch, last_used)[iSkill]++;

            }
            continue;
        }

        if ( ch->position >= POS_STUNNED )
        if ( ch->hit  < MAXHIT(ch) )
		ch->hit  += hit_gain(ch);
    }

    if ( !IS_IMMORTAL(ch) )
    {
        if ( !IS_AWAKE(ch) )
        {
            gain_condition( ch, COND_DRUNK, -number_fuzzy(8) );

            if ( number_range(0,1) )
            {
            gain_condition( ch, COND_FULL,  -1 );
            gain_condition( ch, COND_FULL,  -1 );
            }
        }
        else
        {
            gain_condition( ch, COND_DRUNK,  -number_fuzzy(4) );
            gain_condition( ch, COND_FULL,   -number_range(0,1) );
            gain_condition( ch, COND_THIRST, -number_range(0,1) );
        }
    }

	/*
	 * Find dude with oldest save time.
	 */
	if ( !IS_NPC(ch)
    && ( ch->desc == NULL || !CONNECTED(ch->desc) )
    &&   PC(ch,level) >= 2
    &&   PC(ch,save_time) < save_time )
	{
	    ch_save	= ch;
        save_time   = PC(ch,save_time);
	}

	if ( ch->position >= POS_STUNNED )
	{
        if ( ch->move < MAXMOVE(ch) )
		ch->move += move_gain(ch);
	}

	if ( ch->position == POS_STUNNED )
	    update_pos( ch );

    if ( !IS_NPC(ch) ) ch->timer++;
    if ( !IS_IMMORTAL(ch) )
	{
        if ( ch->timer > 15 )
		ch_quit = ch;
	}

	for ( paf = ch->affected; paf != NULL; paf = paf_next )
	{
	    paf_next	= paf->next;
	    if ( paf->duration > 0 )
		paf->duration--;
	    else if ( paf->duration < 0 )
		;
	    else
	    {
		if ( paf_next == NULL
		||   paf_next->type != paf->type
		||   paf_next->duration > 0 )
		{
		    if ( paf->type > 0 && skill_table[paf->type].msg_off )
		    {
			send_to_char( skill_table[paf->type].msg_off, ch );
			send_to_char( "\n\r", ch );
		    }
		}
	  
		affect_remove( ch, paf );
	    }
	}

	/*
	 * Careful with the damages here,
	 *   MUST NOT refer to ch after damage taken,
	 *   as it may be lethal damage (on NPC).
	 */
	if ( IS_AFFECTED(ch, AFF_POISON) )
	{
	    act( "$n shivers and suffers.", ch, NULL, NULL, TO_ROOM );
	    send_to_char( "You shiver and suffer.\n\r", ch );
        damage( ch, ch, 2 );
	}
	else if ( ch->position == POS_INCAP )
	{
        damage( ch, ch, 1 );
	}
	else if ( ch->position == POS_MORTAL )
	{
        damage( ch, ch, 2 );
	}
    }

    /*
     * Autosave and autoquit.
     * Check that these chars still exist.
     */
    if ( ch_save != NULL || ch_quit != NULL )
    {
	for ( ch = char_list; ch != NULL; ch = ch_next )
	{
	    ch_next = ch->next;
        if ( ch == ch_save )        save_char_obj( ch );
        if ( ch == ch_quit )        do_quit( ch, "" );
	}
    }

    return;
}



/*
 * Update all objs.
 * Called once a tick.	This function is performance sensitive.
 */
void obj_update_pulse( void )
{   
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    ROOM_INDEX_DATA *pRoom;

    for ( obj = object_list; obj != NULL; obj = obj_next )
    {
        CHAR_DATA *rch;
        bool Vehicle = FALSE;

        obj_next = obj->next;

        script_update( obj, TYPE_OBJ, TRIG_EACH_PULSE, NULL, NULL, NULL, NULL );

/* consistency check */
        if ( obj->carried_by == NULL ) obj->wear_loc = WEAR_NONE;
        
        if ( obj->item_type == ITEM_VEHICLE && obj->in_room != NULL )
        {
            int i;

            for ( i = 0; i < 4; i++ )
            {
                if ( obj->in_room->sector_type == obj->value[i] )
                {
                    Vehicle = TRUE;
                    break;
                }
            }
        }


		if ( (pRoom = obj->in_room) != NULL
		  && (pRoom->sector_type == SECT_WATER_NOSWIM
		   || pRoom->sector_type == SECT_WATER_SWIM
		   || pRoom->sector_type == SECT_AIR
		   || (pRoom->sector_type == SECT_UNDERWATER
			&& pRoom->exit[DIR_DOWN] != NULL
			&& pRoom->exit[DIR_DOWN]->to_room != NULL)
		   || pRoom->sector_type == SECT_CLIMB)
		  && !Vehicle )
		{
			EXIT_DATA *pExit;
			char buf[MAX_STRING_LENGTH];

			sprintf( buf, "$p %s",
						  pRoom->sector_type == SECT_WATER_NOSWIM ||
						  pRoom->sector_type == SECT_WATER_SWIM ?
							  "splashes into the water and disappears." :
						  pRoom->sector_type == SECT_AIR ||
						  pRoom->sector_type == SECT_CLIMB ?
							  "plummets down to the earth below." :
							  "floats down into the murky waters below." );

            if ( (rch = pRoom->people) != NULL )
			{
			act( buf, rch, obj, NULL, TO_ROOM );
			act( buf, rch, obj, NULL, TO_CHAR );
			}

			if ( (pExit = pRoom->exit[DIR_DOWN]) != NULL
			 &&   pExit->to_room != pRoom
			 &&   pExit->to_room != NULL )
			{
				obj_from_room( obj );
				pRoom = pExit->to_room;
				sprintf( buf, "$p %s",
						  pRoom->sector_type == SECT_WATER_NOSWIM ||
						  pRoom->sector_type == SECT_WATER_SWIM ?
							  "washes in from above." :
						  pRoom->sector_type == SECT_CLIMB ?
							  "plummets down from above." :
							  "floats down from above." );
				obj_to_room( obj, pExit->to_room );
				rch = pExit->to_room->people;
				if ( rch != NULL )
				{
				act( buf, rch, obj, NULL, TO_ROOM );
				act( buf, rch, obj, NULL, TO_CHAR );
				}
			}
			else
			{
				extract_obj( obj );
				continue;
			}

		}
    }

    return;
}



void obj_update_tick( void )
{   
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    ROOM_INDEX_DATA *pRoom;

    for ( obj = object_list; obj != NULL; obj = obj_next )
    {
		CHAR_DATA *rch;
        CHAR_DATA *ch;
		char *msg;

        obj_next = obj->next;

        script_update( obj, TYPE_OBJ, TRIG_TICK_PULSE, NULL, NULL, NULL, NULL );

/* consistency check */
        if ( obj->carried_by == NULL ) obj->wear_loc = WEAR_NONE;

        ch = obj->carried_by;
        pRoom = ch != NULL ? ch->in_room : obj->in_room;
    
        if ( obj->item_type == ITEM_LIGHT && IS_LIT(obj) )
        {
        if ( --obj->value[0] == 0 && pRoom != NULL )
		{
            --pRoom->light;
            if ( ch != NULL )
            {
			act( "$p goes out.", ch, obj, NULL, TO_ROOM );
            act( "$p that you are carrying goes out.", ch, obj, NULL, TO_CHAR );
            }
            else if ( obj->in_room != NULL
            &&      ( rch = obj->in_room->people ) != NULL )
            {
            act( "$p goes out.", rch, obj, NULL, TO_ROOM );
            }
            REMOVE_BIT(obj->value[3], LIGHT_LIT);
            if (!IS_SET(obj->value[3], LIGHT_FILLABLE))    extract_obj( obj );
		}
        else
        if ( ch != NULL )
        {
            if (obj->value[0] > 0)
            {
                switch ( PERCENTAGE( obj->value[0], obj->value[1] )/10 )
                {
                    case 0:
                    act( "$p carried by $n flickers and sputters.", ch, obj, NULL, TO_ROOM );
                    act( "$p flickers and sputters.", ch, obj, NULL, TO_CHAR );
                    break;
                    case 1:
                    act( "$p carried by $n flickers.", ch, obj, NULL, TO_ROOM );
                    act( "$p flickers.", ch, obj, NULL, TO_CHAR );
                    break;
                    case 2:
                    act( "$p carried by $n flickers slightly.", ch, obj, NULL, TO_ROOM );
                    act( "$p flickers slightly.", ch, obj, NULL, TO_CHAR );
                    break;
                }
            }
        }
		}

        if ( obj->timer <= 0 
          || --obj->timer > 0 
          || IS_SET(obj->extra_flags, ITEM_INVENTORY) )
        continue;

		switch ( obj->item_type )
		{
		default:			  msg = "$p vanishes.";                      break;
		case ITEM_POTION:	  msg = "$p fades away.";                    break;
		case ITEM_WAND: 	  msg = "$p fizzles, pops and implodes.";    break;
		case ITEM_STAFF:	  msg = "$p folds up into oblivion.";        break;
		case ITEM_SCROLL:	  msg = "$p becomes unreadible.";            break;
		case ITEM_ARMOR:	  msg = "$p falls apart.";                   break;
		case ITEM_GEM:	  msg = "$p shatters into thousands of shards!"; break;
		case ITEM_PILL: 	  msg = "$p crumbles into dust.";            break;
		case ITEM_FOUNTAIN:   msg = "$p dries up.";                      break;
		case ITEM_CORPSE_NPC: msg = "$p rots away to nothing.";          break;
		case ITEM_CORPSE_PC:  msg = "$p decays into dust.";              break;
		case ITEM_FOOD: 	  msg = "$p goes bad.";                      break;
		case ITEM_DRINK_CON:  msg = "$p disappears in a puff of smoke."; break;
		}

		if ( obj->carried_by != NULL )
        act( msg, obj->carried_by, obj, NULL, TO_CHAR );
		else
		if ( obj->in_room != NULL
		  && ( rch = obj->in_room->people ) != NULL )
		{
            act( msg, rch, obj, NULL, TO_ROOM );
            act( msg, rch, obj, NULL, TO_CHAR );
		}

		extract_obj( obj );
    }

    return;
}



/*
 * Aggress.
 * Called once per pulse;
 *
 * for each mortal PC
 *     for each mob in room
 *         aggress on some random PC
 * also take care of scramblers
 *
 * This function takes 25% to 35% of ALL Merc cpu time.
 * Unfortunately, checking on each PC move is too tricky,
 *   because we don't the mob to just attack the first PC
 *   who leads the party into the room.
 *
 * -- Furey
 */
void aggr_update( void )
{
    CHAR_DATA *wch;
    CHAR_DATA *wch_next;
    CHAR_DATA *ch;
    CHAR_DATA *ch_next;
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    CHAR_DATA *victim;

    for ( wch = char_list; wch != NULL; wch = wch_next )
    {
	wch_next = wch->next;

    script_update( wch, TYPE_MOB, TRIG_EACH_PULSE, NULL, NULL, NULL, NULL );

    if ( IS_NPC(wch)
    ||   IS_IMMORTAL(wch)
    ||   wch->in_room == NULL )
        continue;

	for ( ch = wch->in_room->people; ch != NULL; ch = ch_next )
	{
	    int count;

	    ch_next	= ch->next_in_room;

	    if ( !IS_NPC(ch)
            ||  ( !IS_SET(ch->act, ACT_AGGRESSIVE) )
	    ||   ch->fighting != NULL
	    ||   IS_AFFECTED(ch, AFF_CHARM)
	    ||   !IS_AWAKE(ch)
	    ||   ( IS_SET(ch->act, ACT_WIMPY) && IS_AWAKE(wch) )
	    ||   !can_see( ch, wch ) )
		continue;

	    /*
	     * Ok we have a 'wch' player character and a 'ch' npc aggressor.
	     * Now make the aggressor fight a RANDOM pc victim in the room,
	     *   giving each 'vch' an equal chance of selection.
	     */
	    count	= 0;
	    victim	= NULL;
	    for ( vch = wch->in_room->people; vch != NULL; vch = vch_next )
	    {
		vch_next = vch->next_in_room;

		if ( !IS_NPC(vch)
        &&   !IS_IMMORTAL(vch)
		&&   ( !IS_SET(ch->act, ACT_WIMPY) || !IS_AWAKE(vch) )
		&&   can_see( ch, vch ) )
		{
		    if ( number_range( 0, count ) == 0 )
			victim = vch;
		    count++;
		}
	    }

	    if ( victim == NULL )
	    {
		bug( "Aggr_update: null victim.", count );
		continue;
	    }

        oroc( ch, victim );
	}
    }

    return;
}





/*
 * Reset one room.
 */
bool reset_room( ROOM_INDEX_DATA *pRoom )
{
    RESET_DATA *pReset;                /* Current Reset                   */
    CHAR_DATA *pMob;                   /* Current Working Mobile          */
    OBJ_DATA *pObj;                    /* Current Working Object          */
    CHAR_DATA    *LastMob;             /* Last Mob Created                */
    OBJ_DATA     *LastObj;             /* Last Object Created             */
    int iExit;                         /* For exit resets                 */
    bool fOldBootDb = fBootDb;

    fBootDb = FALSE;                   /* Skirt get_xxx_index() exit()s   */

    if ( pRoom == NULL ) return FALSE;
    if ( get_room_index( pRoom->vnum ) == NULL )
    {
          bug( "Reset_room: invalid room %d", pRoom->vnum);
          if ( fOldBootDb ) exit( 1 );
          return FALSE;
    }

    pMob    = NULL;
    LastMob = NULL;
    LastObj = NULL;
    
    for ( iExit = 0;  iExit < MAX_DIR;  iExit++ )
    {
       EXIT_DATA *pExit;
       EXIT_DATA *tExit;
       
       pExit = pRoom->exit[iExit];
       if ( pExit == NULL ) continue;
       tExit = pExit->to_room != NULL ? pExit->to_room->exit[rev_dir[iExit]]
                                      : NULL;

       if ( pRoom->people != NULL
         && !IS_SET(pExit->exit_info, EX_CONCEALED) )
       {
         if ( IS_SET(pExit->exit_info, EX_WINDOW) )
         {
         if ( !IS_SET(pExit->exit_info, EX_CLOSED)
            && IS_SET(pExit->rs_flags, EX_CLOSED) )
         {
         act( "The $t shuts.", pRoom->people, pExit->keyword, NULL, TO_CHAR );
         act( "The $t shuts.", pRoom->people, pExit->keyword, NULL, TO_ROOM );
         }
         }
         else
         {
         if ( !IS_SET(pExit->exit_info, EX_CLOSED)
            && IS_SET(pExit->rs_flags, EX_CLOSED) )
         {
         act( "The $t closes.", pRoom->people, pExit->keyword, NULL, TO_CHAR );
         act( "The $t closes.", pRoom->people, pExit->keyword, NULL, TO_ROOM );
         }
         }

         if ( !IS_SET(pExit->exit_info, EX_LOCKED)
            && IS_SET(pExit->rs_flags, EX_LOCKED) )
         {
         act( "The $t clicks.", pRoom->people, pExit->keyword, NULL, TO_CHAR );
         act( "The $t clicks.", pRoom->people, pExit->keyword, NULL, TO_ROOM );
         }
       }

       pExit->exit_info = pExit->rs_flags;      /* set the reset flags   */
       if ( tExit != NULL )
        tExit->exit_info = tExit->rs_flags;     /* nail the other side */
    }

    for ( pReset = pRoom->reset_first; pReset != NULL; pReset = pReset->next )
    {
	MOB_INDEX_DATA *pMobIndex;
    OBJ_INDEX_DATA *pObjIndex;
    int count;

    for ( count = 0; count < pReset->num; count++ )
    {
    if ( number_percent( ) > pReset->percent )
        continue;

	switch ( pReset->command )
	{
        default: bug( "Reset_room: bad command %c.", pReset->command );
	    break;

    case 'M':

        if ( ( pMobIndex = get_mob_index( pReset->rs_vnum ) ) == NULL )
        {
            bug( "Reset_room: 'M': bad vnum %d.", pReset->rs_vnum );
            if ( fOldBootDb ) exit( 1 );
            break;
        }

        if ( pMobIndex->count >= pReset->loc )
            break;

        pMob = create_mobile( pMobIndex );

        char_to_room( pMob, pRoom );
        script_update( pMob, TYPE_MOB, TRIG_BORN, NULL, NULL, NULL, NULL );

        LastObj = NULL;
        LastMob = pMob;
     break;

	case 'O':
        if ( ( pObjIndex = get_obj_index( pReset->rs_vnum ) ) == NULL )
        {
            bug( "Reset_room: 'O': bad vnum %d.", pReset->rs_vnum );
            if ( fOldBootDb ) exit( 1 );
            continue;
        }

        pObj = create_object( pObjIndex, 0 );

        if ( pReset->loc == RESET_LOC_INOBJ && LastObj != NULL )
        {
            obj_to_obj( pObj, LastObj );
            script_update( pObj, TYPE_OBJ, TRIG_BORN, NULL, NULL, NULL, NULL );
        }
   else if ( pReset->loc == RESET_LOC_ONOBJ && LastObj != NULL )
        {
            obj_to_obj( pObj, LastObj );
            script_update( pObj, TYPE_OBJ, TRIG_BORN, NULL, NULL, NULL, NULL );
        }
   else if ( pReset->loc == RESET_LOC_INROOM )
        {
        if ( count_obj_list( pObjIndex, pRoom->contents ) < pReset->num )
        {
            LastObj = pObj;
            obj_to_room( pObj, pRoom );
            script_update( pObj, TYPE_OBJ, TRIG_BORN, NULL, NULL, NULL, NULL );
        }
        else count = pReset->num;
        }
   else if ( LastMob != NULL )
        {
            obj_to_char( pObj, LastMob );
            pObj->wear_loc = URANGE( WEAR_NONE, pReset->loc, MAX_WEAR );

            /* For Shopkeepers */
            if ( LastMob->pIndexData->pShop != NULL
              && pObj->wear_loc == WEAR_NONE )
            {
                SET_BIT(pObj->extra_flags, ITEM_INVENTORY);
              /*  pObj->cost = pObj->pIndexData->cost; */
            }
            else
            script_update( pObj, TYPE_OBJ, TRIG_BORN, NULL, NULL, NULL, NULL );
        }
        
        if ( pObj->carried_by == NULL
          && pObj->in_room    == NULL
          && pObj->in_obj     == NULL )
        {
            extract_obj( pObj );
            pObj = NULL;
            continue;             
        }

        if ( pObj->item_type == ITEM_CONTAINER )
                LastObj = pObj;
        break;
    }
    }


    }

    fBootDb = fOldBootDb;
    script_update( pRoom, TYPE_ROOM, TRIG_TICK_PULSE, NULL, NULL, NULL, NULL );
    return TRUE;
}


/*
 * Repopulate rooms periodically (update 1/1024 of the rooms).
 */
void room_update( void )
{
    static int iHash;
    ROOM_INDEX_DATA *pRoom;

    if (iHash < 0) iHash = -1;
    if (++iHash >= MAX_KEY_HASH )
        iHash = 0;

    for (pRoom = room_index_hash[iHash]; pRoom != NULL; pRoom = pRoom->next )
    {
        CHAR_DATA *pch;

        if ( reset_room( pRoom )
          && pRoom->area->repop != NULL
          && pRoom->area->repop[0] != '\0' )
        {
        for ( pch = pRoom->people; pch != NULL; pch = pch->next_in_room )
            send_to_char( pRoom->area->repop, pch );
        }
    }

    return;
}


/*
 * Update all script parses.
 */
void script_update_proc( void )
{
    ROOM_INDEX_DATA *room;
    OBJ_DATA *obj;
    CHAR_DATA *ch, *ch_next;
    int iHash;

    for ( iHash = 0;  iHash < MAX_KEY_HASH;  iHash++ )
    {
    for ( room = room_index_hash[iHash]; room != NULL;  room = room->next )
    {
        TRIGGER_DATA *trig;
        for ( trig = room->triggers;  trig != NULL;  trig = trig->next )
            parse_script( trig, room, TYPE_ROOM );
    }
    }

    for ( obj = object_list;  obj != NULL;  obj = obj->next )
    {
        TRIGGER_DATA *trig;
        for ( trig = obj->triggers;  trig != NULL;  trig = trig->next )
            parse_script( trig, obj, TYPE_OBJ );
    }

    for ( ch = char_list;  ch != NULL;  ch = ch_next )
    {
        TRIGGER_DATA *trig;

        ch_next = ch->next;

        for ( trig = ch->triggers;  trig != NULL;  trig = trig->next )
            parse_script( trig, ch, TYPE_MOB );
    }
    return;
}



/*
 * Auto 10-hour reboots.
 */
void auto_reboot( void )
{
	if ( num_hour == (PULSE_PER_SECOND * 60) * 30 )
	{
	write_global( "The Isles will autoreboot in 30 minutes.\n\r" );
	do_echo( char_list, "You don't need to quit, your character is saved just beforehand." );
	}
	else
	if ( num_hour == (PULSE_PER_SECOND * 60) * 15 )
	{
	write_global( "The Isles will autoreboot in 15 minutes.\n\r" );
	do_echo( char_list, "You don't need to quit, your character is saved just beforehand." );
	}
	else
	if ( num_hour == (PULSE_PER_SECOND * 60) * 10 )
	{
	write_global( "The Isles will autoreboot in 10 minutes.\n\r" );
	do_echo( char_list, "You don't need to quit, your character is saved just beforehand." );
	}
	else
	if ( num_hour == (PULSE_PER_SECOND * 60) * 5 )
	{
	write_global( "The Isles will autoreboot in 5 minutes.\n\r" );
    do_echo( char_list, "You don't need to quit, your character is saved just beforehand." );
	}
	else
	if ( num_hour == (PULSE_PER_SECOND * 60) )
	{
	write_global( "The Isles will autoreboot in 1 minute.\n\r" );
	do_echo( char_list, "You don't need to quit, your character is saved just beforehand." );
	}
	else
	if ( num_hour <= 0 )
	{
		CHAR_DATA *mob;
        NOTE_DATA *pnote;
        int bnum, count = 0;
         
		write_global( "The Isles is auto-rebooting and will be back up shortly.\n\r" );

		for ( mob = char_list; mob != NULL; mob = mob->next )
                if ( !IS_NPC(mob) ) do_save( mob, "" );

        /*
         * Digest boards with large numbers of notes.
         */
        for ( bnum = 0;  bnum < MAX_BOARD;  bnum++ )
        {
            for ( pnote = note_list[bnum]; pnote != NULL; pnote = pnote->next )
            count++;

            if ( count >= 50 )
            {
                char buf[MAX_STRING_LENGTH];
                char buf1[MAX_STRING_LENGTH];
                char buf3[MAX_STRING_LENGTH];
                char *strtime;

            for ( pnote = note_list[bnum]; pnote != NULL; pnote = pnote->next )
              {
                if ( is_name( "all", pnote->to_list ) && str_cmp( pnote->subject, "[Digest]" ) )
                {
                    buf3[0] = '\0';

            strcat( buf3, "================================================\n\r" );
            sprintf( buf, "From: %s\n\r",    fix_string( pnote->sender ) );            strcat( buf3, buf );
            sprintf( buf, "To:   %s\n\r",    fix_string( pnote->to_list ) );            strcat( buf3, buf );
            sprintf( buf, "Sent: %s\n\r",    pnote->date );            strcat( buf3, buf );
            sprintf( buf, "Subject: %s\n\r", fix_string( pnote->subject ) );            strcat( buf3, buf );
            sprintf( buf, "Text:\n\r%s\n\r",   fix_string( pnote->text ) );            strcat( buf3, buf );
            strcat( buf3, "------------------------------------------------\n\r" );

                   if ( strlen( buf3 ) + strlen( buf1 ) >= MAX_STRING_LENGTH )
                   break;

                   strcat( buf1, buf3 );
                   save_board( bnum );
                }
              }

            for ( pnote = note_list[bnum]; pnote != NULL; )
              {
                NOTE_DATA *pnote_next;
                pnote_next = pnote->next;

                if ( is_name( "all", pnote->to_list ) && str_cmp( pnote->subject, "[Digest]" ) )
                {
                   note_remove( char_list, pnote, bnum );
                }
                pnote = pnote_next;
              }

            if (buf1[0] != '\0')
            {
            note_attach( char_list );
            free_string( char_list->pnote->to_list );
            SET_BIT(char_list->pnote->note_flags, NOTE_ANONYMOUS);
            char_list->pnote->to_list = str_dup( "all" );
            char_list->pnote->subject = str_dup( "[Digest]" );
            char_list->pnote->text = str_dup( buf1 );
            char_list->pnote->next                 = NULL;
            strtime                         = ctime( &current_time );
            strtime[strlen(strtime)-1]      = '\0';
            char_list->pnote->date                 = str_dup( strtime );
            char_list->pnote->date_stamp           = current_time;

            char_list->pnote->next   = note_list[bnum];
            note_list[bnum]   = char_list->pnote;

            char_list->pnote       = NULL;
            save_board( bnum );
            }
            }
        }

		do_asave( NULL, "" );
		do_reboot( char_list, "" );
	}
    return;
}


/*
 * Handle all kinds of updates.
 * Called once per pulse from game loop.
 * Random times to defeat tick-timing clients and players.
 */
void update_handler( void )
{
    num_hour--;
    num_pulse++;

    /*
     * Once per minute.
     */
    if ( --pulse_area     <= 0 )
    {
		pulse_area	= number_range( PULSE_AREA / 2, 3 * PULSE_AREA / 2 );
        char_update     ( TRUE );
        if ( number_range( 0, 1 ) != 0 ) weather_update  ( );
        obj_update_tick ( );
    }

    /*
     * Once per hour.
     */
    if ( --autosave_counter <= 0 )
    {
		extern int packet[60];
		int p;

		num_pulse = 0;
        for ( p = 0; p < 60; p++ )  packet[p] = -1;
		num_hour++;

		write_global( "Please wait while the database is being saved..." );
		descriptor_output( );
		autosave_counter = (PULSE_PER_SECOND * 60) * 60;
		do_asave( NULL, "" );
		write_global( "Database saved.\n\r" );
    }

    /*
     * Once every 4 seconds.
     */
    if ( --pulse_mobile   <= 0 )
    {
		pulse_mobile	= PULSE_MOBILE;
		mobile_update	 ( );
		room_update 	 ( );
		obj_update_pulse ( );
    }

    /*
     * Once every 3 seconds.
     */
    if ( --pulse_violence <= 0 )
    {
		pulse_violence	= PULSE_VIOLENCE;
		violence_update  ( );
    }


    /*
     * Once every five minutes.
     */
    if ( --pulse_point    <= 0 )
    {
        time_update     ( );
        pulse_point     = PULSE_TICK;
		char_update 	( FALSE );
    }

    if ( num_hour < (PULSE_PER_SECOND * 60) * 60 )
	auto_reboot( );
     
    aggr_update( );
    script_update_proc( );
    tail_chain( );
    return;
}





