/***************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "comm.h"
#include "defaults.h"


/*
 * Local functions.
 */

ROOM_INDEX_DATA *	find_location	args( ( CHAR_DATA *ch, char *arg ) );



/*
 * Syntax:  advance [person] [level]
 *          advance [person] [level] [constellation]
 */
void do_advance( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *victim;
    int level;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' || !is_number( arg2 ) )
    {
        send_to_char( "Syntax: advance <char> <level> [constellation].\n\r", ch );
        return;
    }

    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
        send_to_char( "That player is not here.\n\r", ch);
        return;
    }

    if ( IS_NPC(victim) )
    {
        send_to_char( "Not on NPC's.\n\r", ch );
        return;
    }

    if ( ( level = atoi( arg2 ) ) < 1 || level > MAX_LEVEL )
    {
        sprintf( buf, "Level must be 1 to %d.\n\r", MAX_LEVEL );
        send_to_char( buf, ch );
        return;
    }

    if ( PC(ch,level) != MAX_LEVEL )
    send_to_char( "Limited to your trust level, changing constellation only.\n\r", ch );
    else
    {
        PC(victim,level)    = level;

        if ( MTD(PC(victim,constellation)) )
        PC(victim,constellation) = str_dup( "%s" );

        switch ( PC(victim,level) )
        {
            case 1:
             sprintf( buf, "$n $k now an unvalidated player on this mud.\n\r" ); break;
            case 2:
             sprintf( buf, "$n$y character has been validated.\n\r" ); break;
            case LEVEL_HERO:
             sprintf( buf, "$n $k now an Avatar.\n\r" ); break;
            case MAX_LEVEL:
             sprintf( buf, "$n $k now the highest level available on this mud.\n\r" ); break;
            default:
             if (IS_IMMORTAL(victim)) sprintf( buf, "$n $k now immortal.\n\r" );
                                 else sprintf( buf, "$n $k raised a level.\n\r" );
            break;
        }

        act( buf, victim, NULL, ch, TO_VICT );
        act( buf, victim, NULL, ch, TO_CHAR );

        if ( !IS_SET(ch->act2, CHANNEL_IMMTALK) && IS_IMMORTAL(ch) )
        do_immtalk( ch, "" );
    }


    if ( !IS_IMMORTAL(victim) )
    {
        free_string( PC(victim, constellation) );
        PC(victim,constellation) = NULL;
    }
    else
    if ( *argument != '\0' )
    {
        free_string( PC(victim, constellation) );
        PC(victim,constellation) = str_dup( argument );
    }

    return;
}




/*
 * Syntax:  restore [person]
 */
void do_restore( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
        send_to_char( "Restore whom?\n\r", ch );
        return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    victim->hit  = MAXHIT(victim);
    victim->move = MAXMOVE(victim);
    update_pos( victim );
    act( "You touch $S head and restore $M.", ch, NULL, victim, TO_CHAR );
    act( "$n touches your head and you feel energized.", ch, NULL, victim, TO_VICT );
    return;
}




/*
 * Syntax:  freeze [person]
 */
void do_freeze( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Freeze whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    if ( get_trust( victim ) >= get_trust( ch ) )
    {
    send_to_char( "You failed.\n\r", ch );
	return;
    }

    if ( IS_SET(victim->act, PLR_FREEZE) )
    {
	REMOVE_BIT(victim->act, PLR_FREEZE);
    send_to_char( "You can play again.\n\r", victim );
    send_to_char( "FREEZE removed.\n\r", ch );
    }
    else
    {
	SET_BIT(victim->act, PLR_FREEZE);
    send_to_char( "The gods have revoked your freedoms, you are frozen!\n\r", victim );
    send_to_char( "FREEZE set.\n\r", ch );
    }

    save_char_obj( victim );

    return;
}




/*
 * Syntax:  log [person]
 *          log all
 */
void do_log( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    extern bool fLogAll;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Log whom?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg, "all" ) )
    {
	if ( fLogAll )
	{
	    fLogAll = FALSE;
        send_to_char( "Log ALL off.\n\r", ch );
	}
	else
	{
	    fLogAll = TRUE;
        send_to_char( "Log ALL on.\n\r", ch );
	}
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    /*
     * No level check, gods can log anyone.
     */
    if ( IS_SET(victim->act, PLR_LOG) )
    {
	REMOVE_BIT(victim->act, PLR_LOG);
    send_to_char( "LOG removed.\n\r", ch );
    }
    else
    {
	SET_BIT(victim->act, PLR_LOG);
    send_to_char( "LOG set.\n\r", ch );
    }

    return;
}




/*
 * Syntax:  noemote [person]
 */
void do_noemote( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Noemote whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    if ( get_trust( victim ) >= get_trust( ch ) )
    {
    send_to_char( "You failed.\n\r", ch );
	return;
    }

    if ( IS_SET(victim->act2, PLR_NO_EMOTE) )
    {
    REMOVE_BIT(victim->act2, PLR_NO_EMOTE);
    send_to_char( "You can emote again.\n\r", victim );
    send_to_char( "NO_EMOTE removed.\n\r", ch );
    }
    else
    {
    SET_BIT(victim->act2, PLR_NO_EMOTE);
    send_to_char( "You are no longer allowed to emote!\n\r", victim );
    send_to_char( "NO_EMOTE set.\n\r", ch );
    }

    return;
}




/*
 * Syntax:  peace
 */
void do_peace( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *rch;

    for ( rch = ch->in_room->people; rch != NULL; rch = rch->next_in_room )
    {
        if ( rch->fighting != NULL )
        {
            if ( !str_cmp( argument, "silent" ) )
            send_to_char( "You stop fighting.\n\r", ch );
            else
            {
                act( "$n waves a white flag.", rch, 0, 0, TO_ROOM );
                send_to_char( "You wave a white flag.\n\r", rch );
            }

            rch->fighting = NULL;
            rch->position = POS_STANDING;
            update_pos( rch );
        }
    }

    return;
}



BAN_DATA *		ban_free;
BAN_DATA *		ban_list;


/*
 * Syntax:  ban [site]
 */
void do_ban( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    BAN_DATA *pban;

    if ( IS_NPC(ch) )
	return;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    strcpy( buf, "Banned sites:\n\r" );
	for ( pban = ban_list; pban != NULL; pban = pban->next )
	{
	    strcat( buf, pban->name );
        strcat( buf, "\n\r" );
	}
	send_to_char( buf, ch );
	return;
    }

    for ( pban = ban_list; pban != NULL; pban = pban->next )
    {
	if ( !str_cmp( arg, pban->name ) )
	{
        send_to_char( "That site is already banned!\n\r", ch );
	    return;
	}
    }

    if ( ban_free == NULL )
    {
	pban		= alloc_perm( sizeof(*pban) );
    }
    else
    {
	pban		= ban_free;
	ban_free	= ban_free->next;
    }

    pban->name	= str_dup( arg );
    pban->next	= ban_list;
    ban_list	= pban;
    send_to_char( "Ok.\n\r", ch );
    return;
}




/*
 * Syntax:  allow [site]
 */
void do_allow( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    BAN_DATA *prev;
    BAN_DATA *curr;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Remove which site from the ban list?\n\r", ch );
	return;
    }

    prev = NULL;
    for ( curr = ban_list; curr != NULL; prev = curr, curr = curr->next )
    {
	if ( !str_cmp( arg, curr->name ) )
	{
	    if ( prev == NULL )
		ban_list   = ban_list->next;
	    else
		prev->next = curr->next;

	    free_string( curr->name );
	    curr->next	= ban_free;
	    ban_free	= curr;
        send_to_char( "Ok.\n\r", ch );
	    return;
	}
    }

    send_to_char( "Site is not banned.\n\r", ch );
    return;
}




/*
 * Syntax:  wizlock
 */
void do_wizlock( CHAR_DATA *ch, char *argument )
{
    extern bool wizlock;
    wizlock = !wizlock;

    if ( wizlock )
    send_to_char( "Game wizlocked.\n\r", ch );
    else
    send_to_char( "Game un-wizlocked.\n\r", ch );

    return;
}


/*
 * Thanks to Grodyn for pointing out bugs in this function.
 * Syntax:  force [person] [action]
 *          force all [action]
 */
void do_force( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' || argument[0] == '\0' )
    {
    send_to_char( "Force whom to do what?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg, "all" ) )
    {
	CHAR_DATA *vch;
	CHAR_DATA *vch_next;

	for ( vch = char_list; vch != NULL; vch = vch_next )
	{
	    vch_next = vch->next;

	    if ( !IS_NPC(vch) && get_trust( vch ) < get_trust( ch ) )
	    {
        act( "$n forces everyone to '$t'.", ch, argument, vch, TO_VICT );
        if (!IS_NPC(ch))
          FORCE_LEVEL = get_trust( ch );
          else
          FORCE_LEVEL = MAX_LEVEL;
		interpret( vch, argument );
	    }
	}
    }
    else
    {
	CHAR_DATA *victim;

	if ( ( victim = get_char_world( ch, arg ) ) == NULL )
	{
        send_to_char( "They aren't here.\n\r", ch );
	    return;
	}

	if ( victim == ch )
	{
        send_to_char( "Aye aye, right away!\n\r", ch );
	    return;
	}

	if ( get_trust( victim ) >= get_trust( ch ) )
	{
        send_to_char( "Do it yourself!\n\r", ch );
	    return;
	}

    act( "$n forces you to '$t'.", ch, argument, victim, TO_VICT );
    if (!IS_NPC(ch))
      FORCE_LEVEL = get_trust( ch );
      else
      FORCE_LEVEL = MAX_LEVEL;

	interpret( victim, argument );
    }

    send_to_char( "Ok.\n\r", ch );
    return;
}



/*
 * New routines by Locke.
 * Syntax:  invis [level]
 */
void do_invis( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    int oldinvis;

    one_argument( argument, arg );

    if ( IS_NPC(ch) )
	return;

    oldinvis = PC(ch,wizinvis);
    if ( arg[0] == '\0' )
    {
         PC(ch,wizinvis) = PC(ch,wizinvis) == 0 ? PC(ch,level) : 0;
    }
    else PC(ch,wizinvis) = atoi( arg );


    PC(ch,wizinvis) = PC(ch,wizinvis) <= PC(ch,level)
                      ? PC(ch,wizinvis) : PC(ch,level);

    if ( PC(ch,wizinvis) <= LEVEL_IMMORTAL && PC(ch,wizinvis) != 0 )
         PC(ch,wizinvis) = 0;

    if ( PC(ch,wizinvis) == oldinvis ||
      ( PC(ch,wizinvis) >= LEVEL_IMMORTAL && oldinvis >= LEVEL_IMMORTAL ) )
        return;

    if ( PC(ch,wizinvis) < oldinvis && PC(ch,wizinvis) == 0 )
    {
    act( "$n slowly fades into existence.", ch, NULL, NULL, TO_ROOM );
    send_to_char( "You slowly fade back into existence.\n\r", ch );
    }
    else
    if ( PC(ch,wizinvis) >= LEVEL_IMMORTAL && PC(ch,wizinvis) > oldinvis )
    {
    act( "$n slowly fades into thin air.", ch, NULL, NULL, TO_ROOM );
    send_to_char( "You slowly vanish into thin air.\n\r", ch );
    }

    return;
}




/*
 * Syntax:  bounty [person] [bounty]
 */
void do_bounty( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' || !is_number( arg2 ) )
    {
    send_to_char( "Syntax: bounty <character> <bounty>.\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    victim->bounty =  atoi( arg2 );

    send_to_char( "Bounty set.\n\r", ch );
    return;
}



/*
 * Wizify and Wizbit sent in by M. B. King
 * Syntax:  wizify [person]
 */
void do_wizify( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
  
    argument = one_argument( argument, arg1  );
    if ( arg1[0] == '\0' )
    {
	send_to_char( "Syntax: wizify <name>\n\r" , ch );
	return;
    }
    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r" , ch );
	return;
    }
    if ( IS_NPC( victim ) )
    {
	send_to_char( "Not on mobs.\n\r", ch );
	return;
    }

    TOGGLE_BIT( victim->act2, PLR_WIZBIT );
    if ( IS_SET(victim->act2, PLR_WIZBIT ) )
    {
	act( "$N wizified.\n\r", ch, NULL, victim, TO_CHAR );
	act( "$n has wizified you!\n\r", ch, NULL, victim, TO_VICT );
    }
    else
    {
	act( "$N dewizzed.\n\r", ch, NULL, victim, TO_CHAR );
	act( "$n has dewizzed you!\n\r", ch, NULL, victim, TO_VICT ); 
    }

    do_save( victim, "");
    return;
}



/*
 * Syntax:  bamfin [emote]
 */
void do_bamfin( CHAR_DATA *ch, char *argument )
{
    if ( !IS_NPC(ch) )
    {
	smash_tilde( argument );
    free_string( PC(ch,bamfin) );
    PC(ch,bamfin) = str_dup( argument );
    send_to_char( "Ok.\n\r", ch );
    }
    return;
}



/*
 * Syntax:  bamfout [emote]
 */
void do_bamfout( CHAR_DATA *ch, char *argument )
{
    if ( !IS_NPC(ch) )
    {
	smash_tilde( argument );
    free_string( PC(ch,bamfout) );
    PC(ch,bamfout) = str_dup( argument );
    send_to_char( "Ok.\n\r", ch );
    }
    return;
}



/*
 * Syntax:  deny [person]
 */
void do_deny( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
    send_to_char( "Deny whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    if ( get_trust( victim ) >= get_trust( ch ) )
    {
    send_to_char( "You failed.\n\r", ch );
	return;
    }

    SET_BIT(victim->act, PLR_DENY);
    send_to_char( "You are denied access!\n\r", victim );
    send_to_char( "OK.\n\r", ch );
    do_quit( victim, "" );

    return;
}




/*
 * Syntax:  disconnect [person]
 */
void do_disconnect( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    DESCRIPTOR_DATA *d;
    CHAR_DATA *victim;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
    send_to_char( "Disconnect whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim->desc == NULL )
    {
    act( "$N doesn't have a descriptor.", ch, NULL, victim, TO_CHAR );
	return;
    }

    for ( d = descriptor_list; d != NULL; d = d->next )
    {
	if ( d == victim->desc )
	{
	    close_socket( d );
        send_to_char( "Ok.\n\r", ch );
	    return;
	}
    }

    bug( "Do_disconnect: desc not found.", 0 );
    send_to_char( "Descriptor not found!\n\r", ch );
    return;
}


/*
 * Syntax:  system [message]
 */
void do_system( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    
    if ( argument[0] == '\0' )
    {
    send_to_char( "Echo what?\n\r", ch );
	return;
    }

    for ( d = descriptor_list; d; d = d->next )
    {
        if ( d->connected <= CON_PLAYING )
	{
        send_to_char( "SYSTEM:\07 ", d->character );
	    send_to_char( argument, d->character );
        send_to_char( "\n\r",   d->character );
	}
    }

    return;
}


/*
 * Syntax:  echo [message]
 */
void do_echo( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    
    if ( argument[0] == '\0' )
    {
    send_to_char( "Echo what?\n\r", ch );
	return;
    }

    for ( d = descriptor_list; d; d = d->next )
    {
	if ( d->connected == CON_PLAYING )
	{
	    send_to_char( argument, d->character );
        send_to_char( "\n\r",   d->character );
	}
    }

    return;
}




/*
 * Syntax:  recho [message]
 */
void do_recho( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    
    if ( argument[0] == '\0' )
    {
    send_to_char( "Recho what?\n\r", ch );
	return;
    }

    for ( d = descriptor_list; d; d = d->next )
    {
	if ( d->connected == CON_PLAYING
	&&   d->character->in_room == ch->in_room )
	{
	    send_to_char( argument, d->character );
        send_to_char( "\n\r",   d->character );
	}
    }

    return;
}



ROOM_INDEX_DATA *find_location( CHAR_DATA *ch, char *arg )
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    ROOM_INDEX_DATA *pRoom;
    int iVnum;

    if ( is_number(arg) )
	return get_room_index( atoi( arg ) );

    if ( ( victim = get_char_world( ch, arg ) ) != NULL )
	return victim->in_room;

    if ( ( obj = get_obj_world( ch, arg ) ) != NULL )
        return obj->in_room;

    for ( iVnum = 0;  iVnum <= top_vnum_room;  iVnum++ )
    {
    if ( (pRoom = get_room_index( iVnum )) == NULL )  continue;
    if ( strstr( pRoom->name, arg ) ) return pRoom;
    }
    
    return NULL;
}



/*
 * Syntax:  transfer [person] [place]
 */
void do_transfer( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *location;
    DESCRIPTOR_DATA *d;
    CHAR_DATA *victim;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Transfer whom (and where)?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg1, "all" ) )
    {
	for ( d = descriptor_list; d != NULL; d = d->next )
	{
	    if ( d->connected == CON_PLAYING
	    &&   d->character != ch
	    &&   d->character->in_room != NULL
	    &&   can_see( ch, d->character ) )
	    {
		char buf[MAX_STRING_LENGTH];
                sprintf( buf, "%s %s", STR(d->character,name), arg2 );
                                       do_transfer( ch, buf );
	    }
	}
	return;
    }

    /*
     * Thanks to Grodyn for the optional location parameter.
     */
    if ( arg2[0] == '\0' )
    {
	location = ch->in_room;
    }
    else
    {
	if ( ( location = find_location( ch, arg2 ) ) == NULL )
	{
        send_to_char( "No such location.\n\r", ch );
	    return;
	}

	if ( room_is_private( location ) )
	{
        send_to_char( "That room is private right now.\n\r", ch );
	    return;
	}
    }

    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim->in_room == NULL )
    {
    send_to_char( "They are in limbo.  [extracting]\n\r", ch );
     }

    if ( victim->fighting != NULL )
	stop_fighting( victim, TRUE );
    if ( victim->in_room != NULL )
    {
    act( "$n disappears in a mushroom cloud.", victim, NULL, NULL, TO_ROOM );
    char_from_room( victim );
    }
    char_to_room( victim, location );

    act( "$n arrives from a puff of smoke.", victim, NULL, NULL, TO_ROOM );
    if ( ch != victim )
    act( "$n has transferred you.", ch, NULL, victim, TO_VICT );
    do_look( victim, "auto" );
    if ( ch->in_room != victim->in_room )
    send_to_char( "Transferred.\n\r", ch );
}



/*
 * Syntax:  at [location/person/thing] [action]
 */
void do_at( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *location;
    ROOM_INDEX_DATA *original;
    CHAR_DATA *wch;
    
    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' || argument[0] == '\0' )
    {
    send_to_char( "At where what?\n\r", ch );
        return;
    }

    if ( ( location = find_location( ch, arg ) ) == NULL )
    {
    send_to_char( "No such location.\n\r", ch );
        return;
    }

#if defined(IMMORTAL_PRIVACY)
    if ( room_is_private( location ) )
    {
    send_to_char( "That room is private right now.\n\r", ch );
    return;
    }
#endif

    original = ch->in_room;
    char_from_room( ch );
    char_to_room( ch, location );
    interpret( ch, argument );

    /*
     * See if 'ch' still exists before continuing!
     * Handles 'at XXXX quit' case.
     */
    for ( wch = char_list; wch != NULL; wch = wch->next )
    {
        if ( wch == ch )
        {
            char_from_room( ch );
            char_to_room( ch, original );
            break;
        }
    }

    return;
}


/*
 * Syntax:  as [person] [action]
 */
void do_as( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *wch;
    DESCRIPTOR_DATA *olddesc;
    
    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' || argument[0] == '\0' )
    {
    send_to_char( "As who what?\n\r", ch );
        return;
    }
    
    if ( (wch = get_char_world( ch, arg )) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }


    if ( IS_NPC(wch) || IS_IMMORTAL(wch) )
    {
        send_to_char( "Only mortal PCs.\n\r", ch );
        return;
    }
    
    olddesc = wch->desc;
    wch->desc = ch->desc;
    ch->desc->character = wch;
    
    if ( strstr( argument, "quit" )
      || !str_prefix( argument, "quit" ) )
    {
        send_to_char( "No thanks.\n\r", ch );
        return;
    }
    
    interpret( wch, argument );
    
    ch->desc = olddesc;
    olddesc->character = ch;

    return;
}



/*
 * Syntax:  goto [person/place/thing]
 */
void do_goto( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *location;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
    send_to_char( "Goto where?\n\r", ch );
	return;
    }

    if ( ( location = find_location( ch, arg ) ) == NULL )
    {
    send_to_char( "No such location.\n\r", ch );
	return;
    }

#if defined(IMMORTAL_PRIVACY)
    if ( room_is_private( location ) )
    {
    send_to_char( "That room is private right now.\n\r", ch );
	return;
    }
#endif

    if ( ch->fighting != NULL )
	stop_fighting( ch, TRUE );

    if ( PC(ch,wizinvis) < LEVEL_IMMORTAL )
    {
    do_emote( ch, (GET_PC(ch,bamfout[0],'\0') != '\0')
        ? PC(ch,bamfout) : "leaves in a swirling mist" );
    }

    char_from_room( ch );
    char_to_room( ch, location );

    if ( PC(ch,wizinvis) < LEVEL_IMMORTAL  )
    {
    do_emote( ch, (GET_PC(ch,bamfin[0],'\0') != '\0')
        ? PC(ch,bamfin) : "appears in a swirling mist" );
    }

    do_look( ch, "auto" );
    return;
}


void do_reboo( CHAR_DATA *ch, char *argument )
{
    send_to_char( "If you want to REBOOT, spell it out.\n\r", ch );
    return;
}



/*
 * Syntax:  reboot
 */
void do_reboot( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    extern bool shut_down;
    extern int num_hour;

    one_argument( argument, buf );
    if ( buf[0] == '\0' || atoi(buf) == 0 )
    {
        sprintf( buf, "Reboot by %s.\n\r ", STR(ch,name) );
        write_global( buf );
        shut_down = TRUE;
        return;
    }

    num_hour = ((PULSE_PER_SECOND * 60) * atoi(buf)) + 1;
    return;
}



void do_shutdow( CHAR_DATA *ch, char *argument )
{
    send_to_char( "If you want to SHUTDOWN, spell it out.\n\r", ch );
    return;
}



/*
 * Syntax:  shutdown
 */
void do_shutdown( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    extern bool shut_down;

    sprintf( buf, "Shutdown by %s. ", STR(ch,name) );
    append_file( ch, SHUTDOWN_FILE, buf );
    strcat( buf, "\n\r" );
    write_global( buf );
    
    shut_down = TRUE;
    return;
}




/*
 * Syntax:  snoop [person]
 */
void do_snoop( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    DESCRIPTOR_DATA *d;
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( IS_NPC(ch) )
    {
        send_to_char( "Bad mobile!  Don't ever do that again!\n\r", ch );
        return;
    }

    if ( arg[0] == '\0' ) sprintf( arg, "self" );

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim->desc == NULL )
    {
        send_to_char( "No descriptor to snoop.\n\r", ch );
	return;
    }

    if ( victim == ch )
    {
    send_to_char( "Cancelling all snoops.\n\r", ch );
	for ( d = descriptor_list; d != NULL; d = d->next )
	{
            if ( d->snoop_by == ch->desc )
                d->snoop_by = NULL;
	}
	return;
    }
    
    if ( victim->desc->snoop_by == ch->desc )
    {
        victim->desc->snoop_by = NULL;
        send_to_char( "Cancelled.\n\r", ch );
        return;
    }

    if ( victim->desc->snoop_by != NULL )
    {
        send_to_char( "Busy already.\n\r", ch );
	return;
    }

    if ( get_trust( victim ) >= get_trust( ch ) )
    {
        victim->desc->snoop_by = NULL;
        act( "$B$n is snooping you.$R", ch, NULL, victim, TO_VICT );
    }

    if ( ch->desc != NULL )
    {
	for ( d = ch->desc->snoop_by; d != NULL; d = d->snoop_by )
	{
	    if ( d->character == victim || d->original == victim )
	    {
                send_to_char( "No snoop loops.\n\r", ch );
		return;
	    }
	}
    }

    victim->desc->snoop_by = ch->desc;
    send_to_char( "Snooped.\n\r", ch );
    return;
}




/*
 * Syntax:  switch [person]
 */
void do_switch( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );
    
    if ( arg[0] == '\0' )
    {
        send_to_char( "Switch into whom?\n\r", ch );
	return;
    }

    if ( ch->desc == NULL )
	return;
    
    if ( ch->desc->original != NULL )
    {
        send_to_char( "You are already switched.\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim == ch )
    {
        send_to_char( "Ok.\n\r", ch );
	return;
    }

    if ( victim->desc != NULL || !IS_NPC(victim) )
    {
        send_to_char( "Character in use.\n\r", ch );
	return;
    }

    ch->desc->character = victim;
    ch->desc->original  = ch;
    victim->desc        = ch->desc;
    ch->desc            = NULL;
    send_to_char( "Ok.\n\r", victim );
    return;
}



/*
 * Syntax:  return
 */
void do_return( CHAR_DATA *ch, char *argument )
{
    if ( ch->desc == NULL )
	return;

    if ( ch->desc->original == NULL )
    {
        send_to_char( "You aren't switched.\n\r", ch );
	return;
    }

    send_to_char( "You return to your original body.\n\r", ch );
    ch->desc->character       = ch->desc->original;
    ch->desc->original        = NULL;
    ch->desc->character->desc = ch->desc; 
    ch->desc                  = NULL;
    return;
}




/*
 * Syntax:  charload [name]
 *          charload [name] deny
 *          charload [name] allow
 *          charload [name] approve
 *          charload [name] reject
 *          charload [name] show
 *
 * Why does this not load the associated mobs?
 */
void do_charload( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    DESCRIPTOR_DATA *d;
    CHAR_DATA *nch;
    bool fOld;
    
    argument = one_argument( argument, arg );
    argument = one_argument( argument, arg2 );

    if ( arg[0] == '\0' )
    {
        send_to_char( "cload <character> <action>\n\r", ch );
        send_to_char( "deny allow approve reject show unload save\n\r", ch );
        send_to_char( "Characters not logged in are loaded into the room they were last in.\n\r", ch );
        return;
    }

    if ( ( nch = get_char_world( ch, arg ) ) == NULL )
    {
        d = ch->desc;
        d->character = NULL;
        fOld = load_char_obj( d, capitalize( arg ) );
        nch = d->character;
        nch->desc = NULL;       /* juggling desc */
        d->character = ch;
        ch->desc = d;
    
        if ( !fOld )
        {
            free_char( nch );
            send_to_char( "That character does not exist.\n\r", ch );
            return;
        }

        if ( nch->in_room == NULL )
        char_to_room( nch, get_room_index( ROOM_VNUM_APPLICATIONS ) );
        else
        char_to_room( nch, nch->in_room );
        
        nch->next = char_list;
        char_list = nch;
        send_to_char( "Character loaded.\n\r", ch );
    }
    else
    {
        if ( IS_NPC(nch) )
        return;
    }

    if ( !str_cmp( arg2, "unload" ) )
    {
        send_to_char( "Saved and unloaded.\n\r", ch );
        do_quit( nch, "" );
        return;
    }

    if ( !str_cmp( arg2, "save" ) )
    {
        send_to_char( "Saved.\n\r", ch );
        do_save( nch, "" );
        return;
    }

    if ( !str_cmp( arg2, "approve" ) )
    {
        PC(nch,level) = LEVEL_MORTAL;
        REMOVE_BIT( nch->act, PLR_DENY );
        char_from_room( nch );
        char_to_room( nch, get_room_index( race_table[ch->race].start_room ) );
        send_to_char( "Approved.\n\r", ch );

        free_string( PC(nch,denial) );
        PC(nch,denial) = str_dup( "" );
        return;
    }

    if ( !str_cmp( arg2, "reject" ) )
    {
        PC(nch,level) = LEVEL_APPLIED;
        char_from_room( nch );
        char_to_room( nch, get_room_index( ROOM_VNUM_APPLICATIONS ) );
        string_append( ch, &PC(nch,denial)  );
        PC(nch,denial) = str_dup( argument );
        send_to_char( "Rejecting.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg2, "deny" ) )
    {
        SET_BIT( nch->act, PLR_DENY );
        send_to_char( "Denied.\n\r", ch );
        save_char_obj( nch );
        do_quit( nch, "" );
        return;
    }

    if ( !str_cmp( arg2, "allow" ) )
    {
        REMOVE_BIT( nch->act, PLR_DENY );
        send_to_char( "Allowed.\n\r", ch );
        return;
    }

    return;
}
    



/*
 * Syntax:  shell [command]
 */
void do_shell( CHAR_DATA *ch, char *argument )
{
#if defined(unix)
    char buf[MAX_INPUT_LENGTH];
    
    if ( !str_cmp( argument, "last" ) )
    {
        FILE *out;
        char *pf;

        out = fopen( "ispell -a -S < .roomdesc", "r" );
        
        while (fgets(buf, MAX_STRING_LENGTH-1, out) != NULL)
        {
            if ( buf[0] != '&' ) continue;
            pf = format_string( str_dup( buf ) );
            send_to_char( pf, ch );
            free_string( pf );
        }
            
        pclose( out );
        return;
    }

    sprintf( buf, "%s > .shellout &", argument );
    system( buf );

#else
    system( argument );
#endif
    
    send_to_char( "Shell command executed.\n\r", ch );
    return;
}



/*
 * Syntax:  purge
 *          purge [object]
 *          purge [person]
 */
void do_purge( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj = NULL;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	/* 'purge' */
	CHAR_DATA *vnext;
	OBJ_DATA  *obj_next;

	for ( victim = ch->in_room->people; victim != NULL; victim = vnext )
	{
	    vnext = victim->next_in_room;
        if ( IS_NPC(victim) && victim->desc == NULL )
		extract_char( victim, TRUE );
	}

	for ( obj = ch->in_room->contents; obj != NULL; obj = obj_next )
	{
	    obj_next = obj->next_content;
	    extract_obj( obj );
	}

    act( "$n cleanses the room with righteous fire!", ch, NULL, NULL, TO_ROOM);
    send_to_char( "You cleanse the room with righteous fire!\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, arg ) ) == NULL
      && ( obj    = get_obj_here( ch, arg ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    if ( victim )
    {
    if ( !IS_NPC(victim) || victim->desc != NULL )
    {
    send_to_char( "Not on PC's or switched PC's.\n\r", ch );
	return;
    }

    act( "You purge $N.", ch, NULL, victim, TO_CHAR );
    act( "$n purges $N.", ch, NULL, victim, TO_NOTVICT );
    extract_char( victim, TRUE );
    }

    if ( obj )
    {
    act( "You purge $P.", ch, NULL, obj, TO_CHAR );
    act( "$n purges $P.", ch, NULL, obj, TO_ROOM );
    extract_obj( obj );
    }

    return;
}

