/***************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "comm.h"
#include "board.h"
#include "skills.h"
#include "mem.h"
#include "script.h"

/*
 * Local variables.
 */

int         FORCE_LEVEL;


/*
 *  Syntax:  wizhelp
 */
void do_wizhelp( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    int cmd;
    int col;
 
    col = 0;
    for ( cmd = 0; cmd_table[cmd].name[0] != '\0'; cmd++ )
    {
        if ( cmd_table[cmd].level >= LEVEL_HERO
        &&   cmd_table[cmd].level <= get_trust( ch )
        &&   cmd_table[cmd].position >= POS_DEAD )
	{
        sprintf( buf, "%10s [%2d]", cmd_table[cmd].name, cmd_table[cmd].level );
	    send_to_char( buf, ch );
        if ( ++col % 5 == 0 )
        send_to_char( "\n\r", ch );
	}
    }
 
    if ( col % 4 != 0 )
    send_to_char( "\n\r", ch );
    return;
}



/*
 *  Syntax:  rstat
 *           rstat [name/vnum]
 */
void do_rstat( CHAR_DATA *ch, char *argument )
{
    extern char * const dir_name[];
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    TRIGGER_DATA *pTrig;
    VARIABLE_DATA *pVar;
    ROOM_INDEX_DATA *location;
    OBJ_DATA *obj;
    CHAR_DATA *rch;
    int door;

    one_argument( argument, arg );
    location = ( arg[0] == '\0' ) ? ch->in_room : find_location( ch, arg );
    if ( location == NULL )
    {
    send_to_char( "No such location.\n\r", ch );
	return;
    }

    sprintf( buf, "Name:  [%s]\n\rArea:  [%5d] %s\n\r",
             location->name,
             location->area->vnum,
             location->area->name );
    send_to_char( buf, ch );

    sprintf( buf, "Sector: [%s]\n\rVnum:  [%5d]  Reference:  [%5d]  Wagon: [%5d]\n\rLight: [%5d]  Max People: [%5d]\n\r",
             sector_name( location->sector_type ),
             location->vnum,
             location->template,
             location->wagon,
             location->light,
             location->max_people );
    send_to_char( buf, ch );

    sprintf( buf, "Flags: [%s]\n\rDescription:\n\r%s",
             room_bit_name( location->room_flags ),
             location->description );
    send_to_char( buf, ch );

    if ( location->extra_descr != NULL )
    {
	EXTRA_DESCR_DATA *ed;

    send_to_char( "ED keywords: ", ch );
	for ( ed = location->extra_descr; ed; ed = ed->next )
    {
            send_to_char( "'", ch );
            send_to_char( ed->keyword, ch );
            send_to_char( "'", ch );
	}
    send_to_char( "\n\r", ch );
    }

    send_to_char( "Chars: [", ch );
    for ( rch = location->people; rch; rch = rch->next_in_room )
    {
        send_to_char( " ", ch );
        one_argument( STR(rch, name), buf );
        send_to_char( buf, ch );
    }

    send_to_char( "]\n\rObjs:  [", ch );
    for ( obj = location->contents; obj; obj = obj->next_content )
    {
    send_to_char( " ", ch );
    one_argument( STR(obj, name), buf );
	send_to_char( buf, ch );
    }
    send_to_char( "]\n\r", ch );

    for ( door = 0; door < MAX_DIR; door++ )
    {
	EXIT_DATA *pexit;

	if ( ( pexit = location->exit[door] ) != NULL )
	{
        sprintf( buf, "%5s to [%5d], key [%5d], fl %3d/%3d [%s] '%s'\n\r",
                 capitalize( dir_name[door] ),
                 pexit->to_room != NULL ? pexit->to_room->vnum : 0,
                 pexit->key,
                 pexit->exit_info, pexit->rs_flags,
                 exit_bit_name( pexit->rs_flags ),
                 !MTD(pexit->keyword) ? pexit->keyword : "" );
	    send_to_char( buf, ch );
        if ( pexit->description != NULL && pexit->description[0] != '\0' )
            send_to_char( pexit->description, ch );
    }
    }

    for ( pTrig = location->triggers; pTrig != NULL; pTrig = pTrig->next )
    {
        sprintf( buf, "[%5d] %s (%d,%d)\n\r", pTrig->script->vnum, pTrig->script->name, pTrig->wait, pTrig->autowait );
        send_to_char( buf, ch );

        for ( pVar = pTrig->locals;  pVar != NULL;  pVar = pVar->next )
        {
            sprintf( buf, "  [%2d] %s ", pVar->type, pVar->name );
            send_to_char( buf, ch );

            switch ( pVar->type )
            {
                case TYPE_STRING: sprintf( buf, " = \"%s\"\n\r", (char *)pVar->value ); break;
                case TYPE_MOB:    sprintf( buf, " = %s\n\r", STR(((CHAR_DATA *)pVar->value),name) ); break;
                case TYPE_OBJ:    sprintf( buf, " = %d\n\r", ((OBJ_DATA  *)pVar->value)->pIndexData->vnum ); break;
                case TYPE_ROOM:   sprintf( buf, " = %d\n\r", ((ROOM_INDEX_DATA *)pVar->value)->vnum ); break;
                default:          sprintf( buf, " = <unknown>\n\r" ); break;
            }
            send_to_char( buf, ch );
        }
    }

    for ( pVar = location->globals;  pVar != NULL;  pVar = pVar->next )
    {
        sprintf( buf, "[%2d] %s ", pVar->type, pVar->name );
        send_to_char( buf, ch );

        switch ( pVar->type )
        {
            case TYPE_STRING: sprintf( buf, " = \"%s\"\n\r", (char *)pVar->value ); break;
            case TYPE_MOB:    sprintf( buf, " = %s\n\r", STR(((CHAR_DATA *)pVar->value),name) ); break;
            case TYPE_OBJ:    sprintf( buf, " = %d\n\r", ((OBJ_DATA  *)pVar->value)->pIndexData->vnum ); break;
            case TYPE_ROOM:   sprintf( buf, " = %d\n\r", ((ROOM_INDEX_DATA *)pVar->value)->vnum ); break;
            default:          sprintf( buf, " = <unknown>\n\r" ); break;
        }
        send_to_char( buf, ch );
    }

    if ( location->reset_first == NULL )
    {
        send_to_char( "Room has no resets.\n\r", ch );
        return;
    }


    return;
}


/*
 * Syntax:  index mobile [vnum]
 *          index object [vnum]
 *          index room   [vnum]
 *          index [vnum]
 */
void do_index( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_STRING_LENGTH];

    argument = one_argument( argument, arg );
    
     if ( !str_prefix(arg, "mobile") ) do_mindex( ch, argument );
else if ( !str_prefix(arg, "object") ) do_oindex( ch, argument );
else if ( !str_prefix(arg, "room"  ) ) do_rstat( ch, argument );
else do_rstat( ch, arg );

     return;
}
    
  


bool ostat( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA *paf;
    OBJ_DATA *obj;
    TRIGGER_DATA *pTrig;
    VARIABLE_DATA *pVar;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Syntax:  stat <target> [description]\n\r", ch );
    return TRUE;
    }

    if ( ( obj = get_obj_world( ch, arg ) ) == NULL )
    {
    return FALSE;
    }

    sprintf( buf, "Name:   [%s]          Area: [%3d] %s\n\r",
    STR(obj, name),
    obj->pIndexData->area->vnum,
    obj->pIndexData->area->name );
    send_to_char( buf, ch );


    sprintf( buf, "Vnum:   [%5d]   Size:  [%5d]  Type: [%s]\n\r",
             obj->pIndexData->vnum,  obj->size,
             item_type_name( obj->item_type ) );
    send_to_char( buf, ch );

    sprintf( buf, "Short:  [%s]\n\rPlural: [%s]\n\r",
             STR(obj, short_descr), pluralize( STR(obj, short_descr) ) );
    send_to_char( buf, ch );

    sprintf( buf, "Long:\n\r%s", STR(obj,description) );
    send_to_char( buf, ch );

    if ( MTD(STR(obj,description_plural)) )
    sprintf( buf, "Plural:\n\r%s %s are here.\n\r",
             capitalize( numberize( number_range( 0, 100 ) ) ),
             pluralize( STR(obj, short_descr) ) );
    else
    {
        send_to_char( "Plural:\n\r", ch );
        sprintf( buf, STR(obj,description_plural),
                      numberize( number_range( 0, 100 ) ) );
        buf[0] = UPPER(buf[0]);
    }
    send_to_char( buf, ch );

    sprintf( buf, "Action:\n\r%s", STR(obj, action_descr) );
    send_to_char( buf, ch );

    if ( *argument != '\0' && !str_prefix( argument, "description" ) )
    {
        sprintf( buf, "Description:\n\r%s", STR(obj,real_description) );
        send_to_char( buf, ch );
    }

    sprintf( buf, "Wear bits:  [%s]\n\rExtra bits: [%s]\n\r",
    wear_bit_name( obj->wear_flags ),
    extra_bit_name( obj->extra_flags ) );
    send_to_char( buf, ch );

    sprintf( buf, "Number: [%d/%d]  Weight: [%d/%d]  Occupants: [%5d]\n\r",
             1,           get_obj_number( obj ),
             obj->weight, get_obj_weight( obj ),
             count_occupants( obj ) );
    send_to_char( buf, ch );

    sprintf( buf, "Cost:   [%5d]   Timer: [%5d]  Level: [%5d]\n\r",
             obj->cost, obj->timer, obj->level );
    send_to_char( buf, ch );

    sprintf( buf, "Room:   [%5d]  Object: [%s]   Carried: [%s]\n\rHitched: [%s]   Wear_loc: [%s]\n\r",
             obj->in_room    == NULL    ?        0 : obj->in_room->vnum,
             obj->in_obj     == NULL    ? "(none)" : STR(obj->in_obj, short_descr),
             obj->carried_by == NULL    ? "(no one)" : NAME(obj->carried_by),
             hitched(obj)    == NULL    ? "(no one)" : NAME(hitched(obj)),
             wear_loc_name( obj->wear_loc ) );
    send_to_char( buf, ch );

    show_occupants_to_char( obj, ch );
    
    sprintf( buf, "Values: [%5d] [%5d] [%5d] [%5d]\n\r",
    obj->value[0],
    obj->value[1],
    obj->value[2],
    obj->value[3] );
    send_to_char( buf, ch );

    value_breakdown( obj->item_type,
                     obj->value[0],
                     obj->value[1],
                     obj->value[2],
                     obj->value[3],
                     ch );

    if ( obj->extra_descr != NULL || obj->pIndexData->extra_descr != NULL )
    {
	EXTRA_DESCR_DATA *ed;

    send_to_char( "ED keywords: [", ch );

	for ( ed = obj->extra_descr; ed != NULL; ed = ed->next )
	{
	    send_to_char( ed->keyword, ch );
	    if ( ed->next != NULL )
        send_to_char( " ", ch );
	}

	for ( ed = obj->pIndexData->extra_descr; ed != NULL; ed = ed->next )
	{
	    send_to_char( ed->keyword, ch );
	    if ( ed->next != NULL )
        send_to_char( " ", ch );
	}

    send_to_char( "]\n\r", ch );
    }

    for ( paf = obj->affected; paf != NULL; paf = paf->next )
    {
       sprintf( buf, "Affects %s by %d.\n\r", affect_loc_name( paf->location ),
                                              paf->modifier );
       send_to_char( buf, ch );
    }

    for ( paf = obj->pIndexData->affected; paf != NULL; paf = paf->next )
    {
       sprintf( buf, "Affects %s by %d.\n\r", affect_loc_name( paf->location ),
                                              paf->modifier );
       send_to_char( buf, ch );
    }

    for ( pTrig = obj->triggers; pTrig != NULL; pTrig = pTrig->next )
    {
        sprintf( buf, "[%5d] %s (%d,%d)\n\r", pTrig->script->vnum, pTrig->script->name, pTrig->wait, pTrig->autowait );
        send_to_char( buf, ch );

        for ( pVar = pTrig->locals;  pVar != NULL;  pVar = pVar->next )
        {
            sprintf( buf, "  [%2d] %s ", pVar->type, pVar->name );
            send_to_char( buf, ch );

            switch ( pVar->type )
            {
                case TYPE_STRING: sprintf( buf, " = \"%s\"\n\r", (char *)pVar->value ); break;
                case TYPE_MOB:    sprintf( buf, " = %s\n\r", STR(((CHAR_DATA *)pVar->value),name) ); break;
                case TYPE_OBJ:    sprintf( buf, " = %d\n\r", ((OBJ_DATA  *)pVar->value)->pIndexData->vnum ); break;
                case TYPE_ROOM:   sprintf( buf, " = %d\n\r", ((ROOM_INDEX_DATA *)pVar->value)->vnum ); break;
                default:          sprintf( buf, " = <unknown>\n\r" ); break;
            }
            send_to_char( buf, ch );
        }
    }

    for ( pVar = obj->globals;  pVar != NULL;  pVar = pVar->next )
    {
        sprintf( buf, "[%2d] %s ", pVar->type, pVar->name );
        send_to_char( buf, ch );

        switch ( pVar->type )
        {
            case TYPE_STRING: sprintf( buf, " = \"%s\"\n\r", (char *)pVar->value ); break;
            case TYPE_MOB:    sprintf( buf, " = %s\n\r", STR(((CHAR_DATA *)pVar->value),name) ); break;
            case TYPE_OBJ:    sprintf( buf, " = %d\n\r", ((OBJ_DATA  *)pVar->value)->pIndexData->vnum ); break;
            case TYPE_ROOM:   sprintf( buf, " = %d\n\r", ((ROOM_INDEX_DATA *)pVar->value)->vnum ); break;
            default:          sprintf( buf, " = <unknown>\n\r" ); break;
        }
        send_to_char( buf, ch );
    }

    return TRUE;
}


bool mstat( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA *paf;
    CHAR_DATA *victim;
    TRIGGER_DATA *pTrig;
    VARIABLE_DATA *pVar;
    int days, hours;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Syntax: stat <target> [description]\n\r", ch );
    return TRUE;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    return FALSE;
    }

    sprintf( buf, "Name:  [%s]\n\r",   STR(victim, name) );
    send_to_char( buf, ch );

    if ( victim->pIndexData != NULL && victim->pIndexData->area != NULL )
    {
    sprintf( buf, "Area:  [%3d] %s\n\r",
             victim->pIndexData->area->vnum,
             victim->pIndexData->area->name );
    send_to_char( buf, ch );
    }

    if ( victim->pIndexData != NULL )
    {
    sprintf( buf, "Vnum:  [%5d]  ", victim->pIndexData->vnum );
    send_to_char( buf, ch );
    }

    sprintf( buf, "Hp:  [%3d/%3d]    Move: [%3d/%3d]\n\rDrunk: [%5d/100]  Thirst: [%4d/100]  Full: [%d/100]\n\r",
    victim->hit,         MAXHIT(victim),
    victim->move,        MAXMOVE(victim),
    GET_PC(victim,condition[COND_DRUNK],0),
    GET_PC(victim,condition[COND_THIRST],0),
    GET_PC(victim,condition[COND_FULL],0) );
    send_to_char( buf, ch );

    sprintf( buf, "Size:  [%5d]   Race:  [%5d]   Sex:  [%s]    Room:  %s [%d]\n\r",
             victim->size,
             victim->race,
             victim->sex == SEX_MALE    ? "male"   :
             victim->sex == SEX_FEMALE  ? "female" : "neutral",
             victim->in_room == NULL    ? "None"   :
                 trunc_fit( victim->in_room->name, 15 ),
             victim->in_room == NULL    ?        0 : victim->in_room->vnum );
    send_to_char( buf, ch );


    sprintf( buf, "Str:   [%5d]   Int:   [%5d]   Wis:  [%5d]   Dex:    [%5d] Con: [%5d]\n\r",
                  get_curr_str( victim ),
                  get_curr_int( victim ),
                  get_curr_wis( victim ),
                  get_curr_dex( victim ),
                  get_curr_con( victim ) );
    send_to_char( buf, ch );
	
    sprintf( buf, "Lv:    [%5d]   AC:    [%5d]  Coins: [%5d]   Fight:  [%d, %d]\n\r",
             GET_PC(victim,level,-1),
             GET_AC(victim),      tally_coins ( victim ),
             victim->fmode, victim->fbits );
    send_to_char( buf, ch );

    sprintf( buf, "Wait:  [%5d]   Invis: [%5d] Bounty: [%5d]   Owed:   [%5d]\n\r",
             victim->wait,        GET_PC(victim,wizinvis,0),
             victim->bounty,      victim->owed );
    send_to_char( buf, ch );


    days  = ((int) GET_PC(victim,played,0)) / 24;
    hours = ((int) GET_PC(victim,played,0)) % 24;
    sprintf( buf, "Age:   [%5d]   Timer: [%5d]  Trace: [%5d]   Played: [%d, %d]\n\r",
                  GET_AGE(victim), victim->timer,
                  IS_NPC(ch) ? -1 :
                    (ch->pcdata->trace != NULL ? ch->pcdata->trace->vnum : -1),
                  days, hours );
    send_to_char( buf, ch );

    sprintf( buf, "Act:     [%s]\n\r",
             IS_NPC(victim) ? act_bit_name( victim->act )
                            : plr_bit_name( victim->act ) );
    send_to_char( buf, ch );

    sprintf( buf, "Affects: [%s]\n\r", affect_bit_name(victim->affected_by));
    send_to_char( buf, ch );

    sprintf( buf, "Wielding: [%d/%d]  Hitroll/Damroll: [%d/%d]  [%s",
             wield_weight(ch),
             str_app[get_curr_str(ch)].wield,
             GET_HITROLL(victim), GET_DAMROLL(victim),
             position_name( victim->position ) );
    send_to_char( buf, ch );
	
    if ( victim->furniture )
    {
        sprintf( buf, " on %s", STR(victim->furniture, short_descr) );
        send_to_char( buf, ch );
    }

    if ( victim->position == POS_FIGHTING )
    {
        sprintf( buf, " with %s",
                      victim->fighting ? NAME(victim->fighting) : "nobody" );
        send_to_char( buf, ch );
    }

    send_to_char( "]\n\r", ch );

    sprintf( buf, "Carrying %d items of weight %d.\n\r",
	victim->carry_number, victim->carry_weight );
    send_to_char( buf, ch );

    buf[0] = '\0';

    if ( victim->master || !MTD(victim->hunting) )
    {
    sprintf( buf, "Master: %s  Hunting: %s",
             victim->master      ? NAME(victim->master)   : "Nobody",
             MTD(victim->hunting) ? "Nobody" : victim->hunting );
    send_to_char( buf, ch );
    }

    if ( victim->riding
      || victim->rider )
    {
    sprintf( buf, "Riding: [%s]  Mounted by:  [%s]",
             victim->riding      ? NAME(victim->riding)     : "Nobody",
             victim->rider       ? NAME(victim->rider)      : "Nobody" );
    send_to_char( buf, ch );
    }

    if ( buf[0] != '\0' ) send_to_char( "\n\r", ch );

    sprintf( buf, "Short: [%s]\n\rLong:\n\r%s",
             STR(victim, short_descr),  STR(victim, long_descr) );
    send_to_char( buf, ch );
    
    if ( STR(victim, long_descr)[strlen(STR(victim, long_descr))-2] != '\n' )
    send_to_char( "\n\r", ch );

    if ( *argument != '\0' && !str_prefix( argument, "description" ) )
    {
        sprintf( buf, "Description:\n\r%s", STR(victim,description) );
        send_to_char( buf, ch );
    }

    if ( !MTD(victim->keywords) )
    {
        sprintf( buf, "Extended Keywords: [%s]\n\r", victim->keywords );
        send_to_char( buf, ch );
    }

    if ( victim->pcdata )
    {
    if ( !MTD(PC(victim,email)) )
    {
        sprintf( buf, "Email: %s\n\r", PC(victim,email) );
        send_to_char( buf, ch );
    }

    if ( !MTD(PC(victim,denial)) )
    {
        sprintf( buf, "Rejection notice:\n\r%s", PC(victim,denial) );
        send_to_char( buf, ch );
    }
    }

    for ( pTrig = victim->triggers; pTrig != NULL; pTrig = pTrig->next )
    {
        sprintf( buf, "[%5d] %s (%d,%d)\n\r", pTrig->script->vnum, pTrig->script->name, pTrig->wait, pTrig->autowait );
        send_to_char( buf, ch );

        for ( pVar = pTrig->locals;  pVar != NULL;  pVar = pVar->next )
        {
            sprintf( buf, "  [%2d] %s ", pVar->type, pVar->name );
            send_to_char( buf, ch );

            switch ( pVar->type )
            {
                case TYPE_STRING: sprintf( buf, " = \"%s\"\n\r", (char *)pVar->value ); break;
                case TYPE_MOB:    sprintf( buf, " = %s\n\r", STR(((CHAR_DATA *)pVar->value),name) ); break;
                case TYPE_OBJ:    sprintf( buf, " = %d\n\r", ((OBJ_DATA  *)pVar->value)->pIndexData->vnum ); break;
                case TYPE_ROOM:   sprintf( buf, " = %d\n\r", ((ROOM_INDEX_DATA *)pVar->value)->vnum ); break;
                default:          sprintf( buf, " = <unknown>\n\r" ); break;
            }
            send_to_char( buf, ch );
        }
    }

    for ( pVar = victim->globals;  pVar != NULL;  pVar = pVar->next )
    {
        sprintf( buf, "[%2d] %s ", pVar->type, pVar->name );
        send_to_char( buf, ch );

        switch ( pVar->type )
        {
            case TYPE_STRING: sprintf( buf, " = \"%s\"\n\r", (char *)pVar->value ); break;
            case TYPE_MOB:    sprintf( buf, " = %s\n\r", STR(((CHAR_DATA *)pVar->value),name) ); break;
            case TYPE_OBJ:    sprintf( buf, " = %d\n\r", ((OBJ_DATA  *)pVar->value)->pIndexData->vnum ); break;
            case TYPE_ROOM:   sprintf( buf, " = %d\n\r", ((ROOM_INDEX_DATA *)pVar->value)->vnum ); break;
            default:          sprintf( buf, " = <unknown>\n\r" ); break;
        }
        send_to_char( buf, ch );
    }

    for ( paf = victim->affected; paf != NULL; paf = paf->next )
    {
	sprintf( buf,
        "[Spell %s on %s by %d for %d with %s]\n\r",
	    skill_table[(int) paf->type].name,
	    affect_loc_name( paf->location ),
	    paf->modifier,
	    paf->duration,
        affect_bit_name( paf->bitvector )        );
	send_to_char( buf, ch );
    }

    return TRUE;

}




bool pstat( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    SCRIPT_DATA *pScript;
    int vnum;
    int search;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Syntax: stat <proc vnum>\n\r", ch );
    return TRUE;
    }

    search = atoi( arg );

    pScript = NULL;
    for ( vnum = 0; vnum <= top_vnum_script; vnum++ )
    {
        if ( vnum == search )
        {
            pScript = get_script_index( vnum );
            break;
        }
    }

    if ( pScript == NULL )
    return FALSE;


    sprintf( buf, "Vnum:  [%5d]  Name:  [%s]\n\r", pScript->vnum,
             pScript->name  );
    page_to_char( buf, ch );

    sprintf( buf, "Type:  [%5d]         [%s]\n\r", pScript->type,
             show_proc_type( pScript->type ) );
    page_to_char( buf, ch );

    sprintf( buf, "Proc:\n\r%s", pScript->commands );
    page_to_char( buf, ch );

    return TRUE;            
}


/*
 * Syntax:  stat [person/thing/num]
 */
void do_stat( CHAR_DATA *ch, char *argument )
{
    if ( *argument == '\0' )
    {
        send_to_char( "Usage:   stat [person|thing|vnum]\n\r", ch );
        return;
    }

    if ( !mstat( ch, argument )
      && !ostat( ch, argument )
      && !pstat( ch, argument ) )
        send_to_char( "Nothing like that to stat.\n\r", ch );

     return;
}



    /*
     * Yeah, so iterating over all vnum's takes 10,000 loops.
     * Get_mob_index is fast, and I don't feel like threading another link.
     * Do you?
     * -- Furey
     */

/*
 * Enhancements by Locke
 * Syntax:  mfind all
 *          mfind [name]
 *          mfind [name] [lower [upper]]
 *          mfind area [lower [upper]]
 *          mfind [lower] [upper]
 */
void do_mfind( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char arg3[MAX_INPUT_LENGTH];
    MOB_INDEX_DATA *pMobIndex;
    bool fRange = FALSE;
    bool fArea = FALSE;
    bool fName = FALSE;
    int range1 = 0;
    int range2 = 0;
    AREA_DATA *pArea = ch->in_room->area;
    char name[MAX_INPUT_LENGTH];
    int vnum;
    bool found = FALSE;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    argument = one_argument( argument, arg3 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Syntax: mfind all\n\r",               ch );
    send_to_char( "        mfind [name, area] [num1 num2]\n\r", ch );
	return;
    }

    if ( is_number( arg1 ) && is_number( arg2 ) )
    {
        fRange = TRUE;
        range1 = atoi( arg1 );
        range2 = atoi( arg2 );
        if ( !str_cmp(arg3, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg3, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg3 );
            }
        }
    }
    else
    {
        if ( is_number( arg2 ) && is_number( arg3 ) )
        {
            fRange = TRUE;
            range1 = atoi( arg2 );
            range2 = atoi( arg3 );
        }
        if ( !str_cmp(arg1, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg1, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg1 );
            }
        }
    }


    if ( range1 > range2 && fRange )
    {
        vnum = range1;
        range1 = range2;
        range2 = vnum;
    }

    if ( range2 > top_vnum_mob || !fRange ) range2 = top_vnum_mob;

    for ( vnum = range1; vnum <= range2; vnum++ )
    {
        if ( ( pMobIndex = get_mob_index( vnum ) ) != NULL
          && ( is_prename( name, pMobIndex->name )
            || is_prename( name, pMobIndex->short_descr ) || !fName )
          && ( pMobIndex->area == pArea || !fArea ) )
        {
            found = TRUE;
            sprintf( buf, "[%5d] %-42s  %s\n\r", vnum, pMobIndex->short_descr,
                                             !fArea ? trunc_fit(pMobIndex->name,20) : "" );
            send_to_char( buf, ch );
        }
    }


    if ( !found )
    send_to_char( "Nothing like that in hell, earth, or heaven.\n\r", ch );

    return;
}


/*
 * Enhancements by Locke
 * Syntax:  ofind all
 *          ofind [name]
 *          ofind [name] [lower [upper]]
 *          ofind area [lower [upper]]
 *          ofind [lower] [upper]
 */
void do_ofind( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char arg3[MAX_INPUT_LENGTH];
    OBJ_INDEX_DATA *pObjIndex;
    bool fRange = FALSE;
    bool fArea = FALSE;
    bool fName = FALSE;
    int range1 = 0;
    int range2 = 0;
    AREA_DATA *pArea = ch->in_room->area;
    char name[MAX_INPUT_LENGTH];
    int vnum;
    bool found = FALSE;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    argument = one_argument( argument, arg3 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Syntax: ofind all\n\r",               ch );
    send_to_char( "        ofind [name, area] [num1 num2]\n\r", ch );
	return;
    }

    if ( is_number( arg1 ) && is_number( arg2 ) )
    {
        fRange = TRUE;
        range1 = atoi( arg1 );
        range2 = atoi( arg2 );
        if ( !str_cmp(arg3, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg3, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg3 );
            }
        }
    }
    else
    {
        if ( is_number( arg2 ) && is_number( arg3 ) )
        {
            fRange = TRUE;
            range1 = atoi( arg2 );
            range2 = atoi( arg3 );
        }
        if ( !str_cmp(arg1, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg1, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg1 );
            }
        }
    }


    if ( range1 > range2 && fRange )
    {
        vnum = range1;
        range1 = range2;
        range2 = vnum;
    }

    if ( range2 > top_vnum_obj || !fRange ) range2 = top_vnum_obj;

    for ( vnum = range1; vnum <= range2; vnum++ )
    {
        if ( ( pObjIndex = get_obj_index( vnum ) ) != NULL
          && ( is_prename( name, pObjIndex->name )
            || is_prename( name, pObjIndex->short_descr ) || !fName )
          && ( pObjIndex->area == pArea || !fArea ) )
        {
            found = TRUE;
            sprintf( buf, "[%5d %10s] %-42s  %s\n\r", vnum,
                                             item_type_name( pObjIndex->item_type ),
                                             pObjIndex->short_descr,
                                             !fArea ? trunc_fit(pObjIndex->area->name,20) : "" );
            send_to_char( buf, ch );
        }
    }


    if ( !found )
    send_to_char( "Nothing like that in hell, earth, or heaven.\n\r", ch );

    return;
}


/*
 * Syntax:  rfind all
 *          rfind [name]
 *          rfind [name] [lower [upper]]
 *          rfind area [lower [upper]]
 *          rfind [lower] [upper]
 */
void do_rfind( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char arg3[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *pRoomIndex;
    bool fRange = FALSE;
    bool fArea = FALSE;
    bool fName = FALSE;
    int range1 = 0;
    int range2 = 0;
    AREA_DATA *pArea = ch->in_room->area;
    char name[MAX_INPUT_LENGTH];
    int vnum;
    bool found = FALSE;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    argument = one_argument( argument, arg3 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Syntax: rfind all\n\r",               ch );
    send_to_char( "        rfind [name, area] [num1 num2]\n\r", ch );
	return;
    }

    if ( is_number( arg1 ) && is_number( arg2 ) )
    {
        fRange = TRUE;
        range1 = atoi( arg1 );
        range2 = atoi( arg2 );

        if ( !str_cmp(arg3, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg3, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg3 );
            }
        }
    }
    else
    {
        if ( is_number( arg2 ) && is_number( arg3 ) )
        {
            fRange = TRUE;
            range1 = atoi( arg2 );
            range2 = atoi( arg3 );
        }

        if ( !str_cmp(arg1, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg1, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg1 );
            }
        }
    }


    if ( range1 > range2 && fRange )
    {
        vnum = range1;
        range1 = range2;
        range2 = vnum;
    }

    if ( range2 > top_vnum_room || !fRange ) range2 = top_vnum_room;

    for ( vnum = range1; vnum <= range2; vnum++ )
    {
        if ( ( pRoomIndex = get_room_index( vnum ) ) != NULL
          && ( is_prename( name, pRoomIndex->name ) || !fName )
          && ( pRoomIndex->area == pArea         || !fArea ) )
        {
            found = TRUE;
            sprintf( buf, "[%5d] %-42s  %s\n\r", vnum,
                                       trunc_fit( pRoomIndex->name, 42 ),
                                       !fArea ? pRoomIndex->area->name : "" );
            send_to_char( buf, ch );
        }
    }


    if ( !found )
    send_to_char( "Nothing like that in hell, earth, or heaven.\n\r", ch );

    return;
}


/*
 * Syntax:  pfind all
 *          pfind [name]
 *          pfind [name] [lower [upper]]
 *          pfind area [lower [upper]]
 *          pfind [lower] [upper]
 */
void do_pfind( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char arg3[MAX_INPUT_LENGTH];
    SCRIPT_DATA *pProc;
    bool fRange = FALSE;
    bool fArea = FALSE;
    bool fName = FALSE;
    int range1 = 0;
    int range2 = 0;
    AREA_DATA *pArea = ch->in_room->area;
    char name[MAX_INPUT_LENGTH];
    int vnum;
    bool found = FALSE;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    argument = one_argument( argument, arg3 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Syntax: pfind all\n\r",               ch );
    send_to_char( "        pfind [name, area] [num1 num2]\n\r", ch );
	return;
    }

    if ( is_number( arg1 ) && is_number( arg2 ) )
    {
        fRange = TRUE;
        range1 = atoi( arg1 );
        range2 = atoi( arg2 );

        if ( !str_cmp(arg3, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg3, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg3 );
            }
        }
    }
    else
    {
        if ( is_number( arg2 ) && is_number( arg3 ) )
        {
            fRange = TRUE;
            range1 = atoi( arg2 );
            range2 = atoi( arg3 );
        }

        if ( !str_cmp(arg1, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg1, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg1 );
            }
        }
    }


    if ( range1 > range2 && fRange )
    {
        vnum = range1;
        range1 = range2;
        range2 = vnum;
    }

    if ( range2 > top_vnum_script || !fRange ) range2 = top_vnum_script;

    for ( vnum = range1; vnum <= range2; vnum++ )
    {
        if ( ( pProc = get_script_index( vnum ) ) != NULL
          && ( is_prename( name, pProc->name ) || !fName )
          && ( pProc->area == pArea         || !fArea ) )
        {
            found = TRUE;
            sprintf( buf, "[%5d %2d] %-32s  %s\n\r", vnum, pProc->type,
                                             pProc->name,
                                             !fArea ? pProc->area->name : "" );
            send_to_char( buf, ch );
        }
    }


    if ( !found )
    send_to_char( "Nothing like that in hell, earth, or heaven.\n\r", ch );

    return;
}



 
bool mwhere( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    bool found, fAll = FALSE;

    one_argument( argument, arg );
    if ( arg[0] == '\0' ) return FALSE;

    if ( !str_cmp( arg, "all" ) ) fAll = TRUE;

    found = FALSE;
    for ( victim = char_list; victim != NULL; victim = victim->next )
    {
    if ( can_see( ch, victim )
	&&   victim->in_room != NULL
    && ( is_name(arg, NAME(victim)) || fAll ) )
	{
	    found = TRUE;
        sprintf( buf, "[%5d] %-28s at [%5d] %s\n\r",
                 IS_NPC(victim) ? victim->pIndexData->vnum : 0,
                 IS_NPC(victim) ? STR(victim, short_descr) : STR(victim,name),
                 victim->in_room->vnum,
                 victim->in_room->name );
        send_to_char( buf, ch );
	}
    }

    return found;
}


/* Idea from Talen of Vego's do_where command */

bool owhere( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    bool found = FALSE;
    OBJ_DATA *obj;
    OBJ_DATA *in_obj;
    int obj_counter = 1;

    one_argument( argument, arg );

    if( arg[0] == '\0' )
    return FALSE;

	for ( obj = object_list; obj != NULL; obj = obj->next )
	{
        if ( !can_see_obj( ch, obj ) || !is_name( arg, STR(obj, name) ) )
	        continue;

	    found = TRUE;

	    for ( in_obj = obj; in_obj->in_obj != NULL;
		 in_obj = in_obj->in_obj )
	        ;

	    if ( in_obj->carried_by != NULL )
	    {
		sprintf( buf, "[%2d] %s carried by %s.\n\r", obj_counter,
            STR(obj, short_descr), PERS( in_obj->carried_by, ch ) );
	    }
	    else
	    {
        sprintf( buf, "[%2d] %s in %s [%d].\n\r", obj_counter,
            STR(obj, short_descr), ( in_obj->in_room == NULL ) ?
            "somewhere" : in_obj->in_room->name, (in_obj->in_room == NULL) ?
            0 : in_obj->in_room->vnum );
	    }
	    
	    obj_counter++;
	    buf[0] = UPPER( buf[0] );
	    send_to_char( buf, ch );
	}

    return found;
}

void pwhere( CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *victim;
    bool found;

	send_to_char( "Players near you:\n\r", ch );
	found = FALSE;
    for ( victim = char_list;  victim != NULL;  victim = victim->next )
	{
       if ( !IS_NPC(victim)
         && victim->in_room != NULL
         && can_see( ch, victim ) )
       {
        found = TRUE;
        sprintf( buf, "%-18s %28s  [%5d]  %s\n\r", STR(victim,name),
                                               victim->in_room->name,
                                               victim->in_room->vnum,
                                               trunc_fit(victim->in_room->area->name,20) );
        send_to_char( buf, ch );
       }
	}

    if ( !found ) send_to_char( "No players can be found.\n\r", ch );

    return;
}



/*
 * Syntax:  where [person/thing]
 */
void do_where( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_STRING_LENGTH];
    bool found1, found2;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        pwhere( ch );
        return;
    }

    found1 = mwhere( ch, arg );
    found2 = owhere( ch, arg );

    if ( !found1 && !found2 )
    {
        send_to_char( "Nothing like that anywhere.\n\r", ch );
        return;
    }
    return;
}



char *connect_string( int c )
{
    switch ( c )
    {
            case CON_AEDITOR: return "EDITING: Areas";
            case CON_REDITOR: return "EDITING: Rooms";
            case CON_MEDITOR: return "EDITING: Mobiles";
            case CON_OEDITOR: return "EDITING: Objects";
            case CON_SEDITOR: return "EDITING: Scripts";
            case CON_PLAYING: return "Playing the game.";
         case CON_SHOW_TITLE: return "At the title screen.";
          case CON_READ_MOTD: return "Reading the login message.";
         case CON_LOGIN_MENU: return "At the menu.";
           case CON_DOC_MENU: return "Reading the online docs.";
           case CON_GEN_MENU: return "At the Char-Gen menu.";
          case CON_GEN_RACES: return "GEN: Rechoosing a race.";
            case CON_GEN_SEX: return "GEN: Rechoosing a sex.";
           case CON_GEN_NAME: return "GEN: Reentering a name.";
          case CON_GEN_SHORT: return "GEN: Reentering a short.";
       case CON_GEN_KEYWORDS: return "GEN: Reentering keywords.";
           case CON_GEN_LONG: return "GEN: Retyping a long.";
    case CON_GEN_DESCRIPTION: return "GEN: Reentering a main.";
          case CON_GEN_EMAIL: return "GEN: Retyping an email.";
         case CON_GEN_SUBMIT: return "GEN: Submitting an app.";
        case CON_GEN_RACES_2: return "GEN: Reconfirming a race.";
          case CON_STAT_MENU: return "At the Stat Mod menu.";
           case CON_STAT_STR: return "STAT: Modifying str.";
           case CON_STAT_INT: return "STAT: Modifying int.";
           case CON_STAT_WIS: return "STAT: Modifying wis.";
           case CON_STAT_DEX: return "STAT: Modifying dex.";
           case CON_STAT_CON: return "STAT: Modifying con.";
           case CON_STAT_AGE: return "STAT: Selecting new age.";
          case CON_STAT_SIZE: return "STAT: Selecting a height.";
   case CON_CONFIRM_NEW_NAME: return "Confirming a new name.";
   case CON_GET_NEW_PASSWORD: return "Choosing a new password.";
                        case
    CON_CONFIRM_NEW_PASSWORD: return "Confirming a new password.";
         case CON_SHOW_INTRO: return "Reading the gen intro.";
      case CON_CHAR_GEN_NAME: return "Entering a name.";
     case CON_CHAR_GEN_EMAIL: return "Entering an email.";
      case CON_CHAR_GEN_RACE: return "Choosing a race.";
     case CON_CHAR_GEN_RACE2: return "Confirming new race.";
       case CON_CHAR_GEN_SEX: return "Choosing sex.";
     case CON_CHAR_GEN_SHORT: return "Entering short.";
      case CON_CHAR_GEN_LONG: return "Entering long.";
  case CON_CHAR_GEN_KEYWORDS: return "Entering keywords.";
           case CON_GET_NAME: return "Typing a name.";
   case CON_GET_OLD_PASSWORD: return "Entering a password.";
   case CON_GET_NAME_NOLOGIN: return "Typing a name.     [NOLOG]";
                        case
CON_GET_OLD_PASSWORD_NOLOGIN: return "Entering password. [NOLOG]";
  case CON_WRITE_APPLICATION: return "Writing an application.";
   case CON_SEND_APPLICATION: return "Sending the application.";
   case CON_CONFIRM_RESUBMIT: return "** Confirming resubmit! **";
                     default: return "?? Closing Connection ??";
    }
}



/*
 *  Syntax:  users
 */
void do_users( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    DESCRIPTOR_DATA *d;
    int count;

    count	= 0;
    buf[0]	= '\0';
    for ( d = descriptor_list; d != NULL; d = d->next )
    {
    if ( d->character != NULL && can_see( ch, d->character ) )
	{
        count++;
        sprintf( buf2, "[%2d %2d %2d] %s@%s",
		d->descriptor,
		d->connected,
        d->character ? d->character->timer : 0,
        d->original  ? STR(d->original,name)  :
        d->character ? STR(d->character,name) : "(none)",
		d->host
		);

        sprintf( buf + strlen(buf), "%-53s%-25s\n\r",
                 buf2, connect_string( d->connected ) );
	}
    }

    sprintf( buf2, "%d user%s\n\r", count, count == 1 ? "" : "s" );
    send_to_char( buf2, ch );
    send_to_char( buf, ch );
    return;
}


/*
 *  Syntax:  sockets
 */
void do_sockets( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    CHAR_DATA *tch;
    DESCRIPTOR_DATA *d;
    int count;

    count	= 0;
    buf[0]	= '\0';
    for ( tch = char_list; tch != NULL; tch = tch->next )
    {
    if ( !IS_NPC(tch) && can_see( ch, tch ) )
	{
        count++;
        if ( (d = tch->desc) != NULL )
        {
        sprintf( buf + strlen(buf), "[%2d %2d %2d] %s@%s\n\r",
		d->descriptor,
		d->connected,
        d->character ? d->character->timer : 0,
        d->original  ? STR(d->original,name)  :
        d->character ? STR(d->character,name) : "(none)",
        d->host  );
        }
        else
        {
        sprintf( buf + strlen(buf), "[      %2d] %16s %5d\n\r",
        tch->timer,
        STR(tch,name),
        tch->in_room != NULL ? tch->in_room->vnum : 0 );
        }
	}
    }

    sprintf( buf2, "%d user%s\n\r", count, count == 1 ? "" : "s" );
    send_to_char( buf2, ch );
    send_to_char( buf, ch );
    return;
}



/*
 * Syntax:  slookup all
 *          slookup ['skill name']
 */
void do_slookup( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    int sn;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
    send_to_char( "Slookup what?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg, "all" ) )
    {
	for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
	    if ( skill_table[sn].name == NULL )
		break;
        sprintf( buf, "Sn: %4d Slot: %4d Skill/spell: '%s'\n\r",
		sn, skill_table[sn].slot, skill_table[sn].name );
	    send_to_char( buf, ch );
	}
    }
    else
    {
	if ( ( sn = skill_lookup( arg ) ) < 0 )
	{
        send_to_char( "No such skill or spell.\n\r", ch );
	    return;
	}

    sprintf( buf, "Sn: %4d Slot: %4d Skill/spell: '%s'  Group: %d\n\r",
        sn, skill_table[sn].slot, skill_table[sn].name, skill_table[sn].group_code );
	send_to_char( buf, ch );
    }

    return;
}


void count_rooms( AREA_DATA *pArea, int *rooms, int *unfinished )
{
     ROOM_INDEX_DATA *pRoomIndex;
     int iHash;

     for ( iHash = 0; iHash < MAX_KEY_HASH; iHash++ )
	for ( pRoomIndex = room_index_hash[iHash]; pRoomIndex; pRoomIndex = pRoomIndex->next )
	    if ( pRoomIndex->area == pArea )
	    {
		if ( pRoomIndex->description[0] == '\0' 
                  && pRoomIndex->template == 0 )
		    (*unfinished)++;
		(*rooms)++;
	    }
}

/*
 * Syntax:  areas
 */
void do_areas( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    AREA_DATA *pArea;
    int total_rooms = 0, total_unfinished = 0, s_rooms = 0, s_unfinished = 0;

    sprintf( buf, "[%2s] %-15s S %-6s-%6s %-12s %-3s/%-3s %-18.18s\n\r",
    "#N", "Area Name", "lvnum", "uvnum", "Filename", "Rm", "NoD", "Builders" );
    send_to_char( buf, ch );

    for ( pArea = area_first; pArea != NULL; pArea = pArea->next )
    {
	
    count_rooms( pArea, &s_rooms, &s_unfinished );
    sprintf( buf, "[%2d] %-15s %1d %6d-%-6d %-12s %3d/%-3d %-15s\n\r",
        pArea->vnum,
        trunc_fit(pArea->name,15),
        pArea->security,
        pArea->lvnum,
        pArea->uvnum,
        pArea->filename,
	s_rooms, s_unfinished,
        pArea->builders );
	send_to_char( buf, ch );
   	total_rooms 		+= s_rooms;
	total_unfinished 	+= s_unfinished;
	s_rooms = s_unfinished = 0;
    }
    sprintf( buf, "\n\rTotal: %d rooms, %d unfinished (%d%%)\n\r",
	total_rooms, total_unfinished,
        total_unfinished * 100 / UMAX(1,total_rooms) );
    send_to_char( buf, ch );

    return;
}



extern const struct board_data board_table [MAX_BOARD];

/*
 * Syntax:  table
 *          table [type]
 */
void do_table( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    int x;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
        send_to_char( "Tables to view:\n\r", ch );
        send_to_char( "race coin color board attack liquid goods components\n\r", ch );
        send_to_char( "str int wis dex con groups skills bits\n\r", ch );
        return;
    }

    if ( !str_prefix( arg, "race" ) )
    {
        send_to_char( "[Num] Name         - Siz Age Bth Room  Sks Sr In Ws Dx Co Affects\n\r", ch );
        for ( x = 0; x < MAX_RACE; x++ )
        {
            sprintf( buf, "[%3d] %12s - %3d %3d %3d %5d %3d %2d %2d %2d %2d %2d %s\n\r",
                          x,
                          race_table[x].race_name,
                          race_table[x].size,
                          race_table[x].base_age,
                          race_table[x].start_age,
                          race_table[x].start_room,
                          race_table[x].max_skills,
                          race_table[x].bonus[0],
                          race_table[x].bonus[1],
                          race_table[x].bonus[2],
                          race_table[x].bonus[3],
                          race_table[x].bonus[4],
                          affect_bit_name( race_table[x].affect_bits ) );
            send_to_char( buf, ch );
        }
        return;
    }

    if ( !str_prefix( arg, "coin" ) )
    {
        send_to_char( "[Num] Mult Convert  Wgt Short Long\n\r", ch );
        for ( x = 0; x < MAX_COIN; x++ )
        {
            sprintf( buf, "[%3d] %4d %7d %4d %5s %s\n\r",
                     x,
                     coin_table[x].multiplier,
                     coin_table[x].convert,
                     coin_table[x].weight,
                     coin_table[x].short_name,
                     coin_table[x].long_name   );
            send_to_char( buf, ch );
        }
        return;
    }

    if ( !str_prefix( arg, "color" ) )
    {
        if ( !IS_SET(ch->act2, PLR_ANSI) )
        {
            send_to_char( "You don't have ansi support activated.\n\r", ch );
            return;
        }

            send_to_char( "[Num] Code   Code Name\n\r", ch );
        for ( x = 0; x < 20; x++ )
        {
            sprintf( buf, "[%3d] %sSAMPLE%s %4s %s\n\r",
                          x,
                          color_table[x].code,
                          NTEXT,
                          color_table[x].act_code,
                          color_table[x].name );
            send_to_char( buf, ch );
        }
        return;
    }

    if ( !str_prefix( arg, "board" ) )
    {
        send_to_char( "[Num] Read  Write Filename      Name\n\r", ch );
        for ( x = 0; x < MAX_BOARD; x++ )
        {
            sprintf( buf, "[%3d] %5d %5d %-13s %s\n\r",
                          x,
                          board_table[x].readlevel,
                          board_table[x].writelevel,
                          board_table[x].filename,
                          board_table[x].name );
            send_to_char( buf, ch );
        }
        return;
    }

    if ( !str_prefix( arg, "attack" ) )
    {
        send_to_char( "[Num] Slot WpSN Hit_fun Name\n\r", ch );
        for ( x = 0; x < MAX_ATTACK; x++ )
        {
            sprintf( buf, "[%3d] %4d %4d %6s  %s\n\r",
                          x,
                          *attack_table[x].wpgsn,
                          attack_table[x].hit_type,
                          attack_table[x].hit_fun ? "Yes" : "No",
                          attack_table[x].name );
            send_to_char( buf, ch );
        }
        return;
    }

    if ( !str_prefix( arg, "liquid" ) )
    {
        send_to_char( "[Num] Drunk Full Thirst Name            Color\n\r", ch );
        for ( x = 0; x < LIQ_MAX; x++ )
        {
            sprintf( buf, "[%3d] %5d %4d %6d %-15s %s\n\r",
                     x,
                     liq_table[x].liq_affect[0],
                     liq_table[x].liq_affect[1],
                     liq_table[x].liq_affect[2],
                     liq_table[x].liq_name,
                     liq_table[x].liq_color );
            send_to_char( buf, ch );
        }
        return;
    }

    if ( !str_prefix( arg, "str" ) )
    {
        send_to_char( "[Str] Hit Dam Carry Wield\n\r", ch );
        for ( x = 0; x < 26; x++ )
        {
            sprintf( buf, "[%3d] %3d %3d %5d %5d\n\r",
                          x,
                          str_app[x].tohit,
                          str_app[x].todam,
                          str_app[x].carry,
                          str_app[x].wield );
            send_to_char( buf, ch );
        }
        return;
    }
               
    if ( !str_prefix( arg, "int" ) )
    {
        send_to_char( "[Int] Learn\n\r", ch );
        for ( x = 0; x < 26; x++ )
        {
            sprintf( buf, "[%3d] %5d\n\r",
                          x,
                          int_app[x].learn );
            send_to_char( buf, ch );
        }
        return;
    }

    if ( !str_prefix( arg, "wis" ) )
    {
        send_to_char( "[Wis] Practice\n\r", ch );
        for ( x = 0; x < 26; x++ )
        {
            sprintf( buf, "[%3d] %8d\n\r",
                          x,
                          wis_app[x].practice );
            send_to_char( buf, ch );
        }
        return;
    }

    if ( !str_prefix( arg, "dex" ) )
    {
        send_to_char( "[Dex] Defensive\n\r", ch );
        for ( x = 0; x < 26; x++ )
        {
            sprintf( buf, "[%3d] %9d\n\r",
                          x,
                          dex_app[x].defensive );
            send_to_char( buf, ch );
        }
        return;
    }

    if ( !str_prefix( arg, "con" ) )
    {
        send_to_char( "[Con] HpDiff Hits Shock Res\n\r", ch );
        for ( x = 0; x < 26; x++ )
        {
            sprintf( buf, "[%3d] %6d %4d %5d %3d\n\r",
                          x,
                          con_app[x].hitp,
                          con_app[x].hitp + 100,
                          con_app[x].shock,
                          con_app[x].resistance );
            send_to_char( buf, ch );
        }
        return;
    }

    if ( !str_prefix( arg, "groups" ) )
    {
        send_to_char( "[Gro] Code GSN Name\n\r", ch );
        for ( x = 0; group_table[x].pgsn != NULL; x++ )
        {
            sprintf( buf, "[%3d] %4d %3d %s\n\r",
                          x,
                          group_table[x].group_code,
                          group_table[x].pgsn ? *group_table[x].pgsn : -1,
                          group_table[x].name );
            send_to_char( buf, ch );
        }
        return;
    }

    if ( !str_prefix( arg, "skills" ) )
    {
        char final[4*MAX_STRING_LENGTH];

        sprintf( final, "Skill Name        GSN Code Req%% St In Ws Dx Cn Slot Mana Pra%% Lrn%% LRate Cost\n\r" );
        for ( x = 0; x < MAX_SKILL; x++ )
        {
            if ( skill_table[x].name == NULL )
            break;

            sprintf( buf, "%17s %3d %4d %3d%% %2d %2d %2d %2d %2d %4d %4d %3d%% %3d%% %5d %4d\n\r",
                          trunc_fit( skill_table[x].name, 16 ),
                          ( skill_table[x].pgsn) ? *skill_table[x].pgsn : x,
                          skill_table[x].group_code,
                          skill_table[x].required_percent,
                          skill_table[x].req_str,
                          skill_table[x].req_int,
                          skill_table[x].req_wis,
                          skill_table[x].req_dex,
                          skill_table[x].req_con,
                          skill_table[x].slot,
                          skill_table[x].mana,
                          skill_table[x].max_prac,
                          skill_table[x].max_learn,
                          skill_table[x].learn_rate,
                          skill_table[x].cost           );
            strcat( final, buf );
        }

        page_to_char( final, ch );
        return;
    }

    if ( !str_prefix( arg, "bits" ) )
    {
        send_to_char( "AFFECT_BIT_NAME:\n\r", ch );
        send_to_char( affect_bit_name( -1 ), ch );
        send_to_char( "\n\r", ch );
        send_to_char( "EXTRA_BIT_NAME:\n\r", ch );
        send_to_char( extra_bit_name( -1 ), ch );
        send_to_char( "\n\r", ch );
        send_to_char( "ROOM_BIT_NAME:\n\r", ch );
        send_to_char( room_bit_name( -1 ), ch );
        send_to_char( "\n\r", ch );
        send_to_char( "ACT_BIT_NAME:\n\r", ch );
        send_to_char( act_bit_name( -1 ), ch );
        send_to_char( "\n\r", ch );
        send_to_char( "PLR_BIT_NAME:\n\r", ch );
        send_to_char( plr_bit_name( -1 ), ch );
        send_to_char( "\n\r", ch );
        send_to_char( "WEAR_BIT_NAME:\n\r", ch );
        send_to_char( wear_bit_name( -1 ), ch );
        send_to_char( "\n\r", ch );
        send_to_char( "EXIT_BIT_NAME:\n\r", ch );
        send_to_char( exit_bit_name( -1 ), ch );
        send_to_char( "\n\r", ch );
        send_to_char( "SHOP_BIT_NAME:\n\r", ch );
        send_to_char( shop_bit_name( -1 ), ch );
        send_to_char( "\n\r", ch );
        return;
    }


    if ( !str_prefix( arg, "components" ) )
    {
        char final[MAX_STRING_LENGTH*8];

        sprintf( final, "[Num] %-23s %-21s [Tp]  Cost\n\r",
                 "Component Name", "Sell Unit (usage)" );

        for ( x = 0;  comp_table[x].type != -1; x++ )
        {
            sprintf( buf, "[%3d] %-23s %-21s [%2d] %5d\n\r",
                     x,
                     comp_table[x].name,
                     comp_table[x].usage,
                     comp_table[x].type,
                     comp_table[x].cost );
            strcat( final, buf );
        }

        page_to_char( final, ch );
        return;
    }

    if ( !str_prefix( arg, "goods" ) )
    {
        char final[MAX_STRING_LENGTH*2];

        sprintf( final, "[Num] %-20s %-8s Wt [%-6s] [Lf]  Cost\n\r",
                 "Name", "Unit", "Type" );

        for ( x = 0;  goods_table[x].code >= 0; x++ )
        {
            sprintf( buf, "[%3d] %-20s %-8s %2d [%-6s] [%2d] %5d\n\r",
                     x,
                     goods_table[x].name,
                     goods_table[x].unit,
                     goods_table[x].weight,
                     name_good_code( goods_table[x].code ),
                     goods_table[x].life,
                     goods_table[x].cost );
            strcat( final, buf );
        }

        page_to_char( final, ch );
        return;
    }

    do_table( ch, "" );
    return;
}



