/***************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"
#include "comm.h"


/*
 * Syntax:  mload [vnum]
 */
void do_mload( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    MOB_INDEX_DATA *pMobIndex;
    CHAR_DATA *victim;
    
    one_argument( argument, arg );

    if ( arg[0] == '\0' || !is_number(arg) )
    {
    send_to_char( "Syntax: mload <vnum>.\n\r", ch );
	return;
    }

    if ( ( pMobIndex = get_mob_index( atoi( arg ) ) ) == NULL )
    {
    send_to_char( "No mob has that vnum.\n\r", ch );
	return;
    }

    victim = create_mobile( pMobIndex );
    char_to_room( victim, ch->in_room );
    act( "$n has created $N!", ch, NULL, victim, TO_ROOM );
    act( "You create $N!", ch, NULL, victim, TO_CHAR );
    return;
}



/*
 * Syntax:  oload [vnum]
 *          oload [vnum] [level]
 */
void do_oload( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_INDEX_DATA *pObjIndex;
    OBJ_DATA *obj;
    int level;
 
    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
 
    if ( arg1[0] == '\0' || !is_number( arg1 ) )
    {
        send_to_char( "Syntax: oload <vnum> <level>.\n\r", ch );
        return;
    }
 
    if ( arg2[0] == '\0' )
    {
	level = get_trust( ch );
    }
    else
    {
	/*
	 * New feature from Alander.
	 */
        if ( !is_number( arg2 ) )
        {
        send_to_char( "Syntax: oload <vnum> <level>.\n\r", ch );
	    return;
        }
        level = atoi( arg2 );

	if ( level < 0 || level > get_trust( ch ) )
        {
        send_to_char( "Limited to your trust level.\n\r", ch );
	    return;
        }
    }

    if ( ( pObjIndex = get_obj_index( atoi( arg1 ) ) ) == NULL )
    {
    send_to_char( "No object has that vnum.\n\r", ch );
	return;
    }

    obj = create_object( pObjIndex, level );
    if ( CAN_WEAR(obj, ITEM_TAKE) )
    {
	obj_to_char( obj, ch );
    obj->wear_loc     = hand_empty( ch );
    }
    else
    {
	obj_to_room( obj, ch->in_room );
    }
    act( "$n has created $p!", ch, obj, NULL, TO_ROOM );
    act( "You create $p!", ch, obj, NULL, TO_CHAR );
    return;
}



/*
 * Syntax:  load mobile [vnum]
 *          load object [vnum]
 *          load object [vnum] [level]
 */
void do_load( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_STRING_LENGTH];

    argument = one_argument( argument, arg );
    
     if ( !str_prefix( arg, "mobile" ) ) do_mload( ch, argument );
else if ( !str_prefix( arg, "object" ) ) do_oload( ch, argument );
else send_to_char( "Syntax: Load <mob|obj> <vnum>\n\r", ch );

     return;
}





/*
 * Syntax:  sset [person] ['skill'] [value/max]
 *          sset [person] all
 */
void do_sset( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int value;
    int sn;
    bool fAll;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    argument = one_argument( argument, arg3 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' || arg3[0] == '\0' )
    {
        send_to_char( "Syntax: sset <victim> '<skill>' <value|max>\n\r",  ch );
        send_to_char( "or:     sset <victim> all       <value|max>\n\r",  ch );
        send_to_char( "Skill being any skill or spell.\n\r",              ch );
        return;
    }

    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    if ( IS_NPC(victim) )
    {
        send_to_char( "Not on NPC's.\n\r", ch );
        return;
    }

    fAll = !str_cmp( arg2, "all" );
    sn   = 0;
    if ( !fAll && ( sn = skill_lookup( arg2 ) ) < 0 )
    {
        send_to_char( "No such skill or spell.\n\r", ch );
        return;
    }

    /*
     * Snarf the value.
     */
    if ( !is_number( arg3 ) )
    {
        if ( !str_cmp( arg3, "max" ) )
        {
            if ( fAll )
            {
                for ( sn = 0; sn < MAX_SKILL; sn++ )
                {
                    if ( skill_table[sn].name != NULL )
                    PC(victim,learned[sn]) = skill_table[sn].max_learn;
                }
            }
            else PC(victim,learned[sn]) = skill_table[sn].max_learn;

            send_to_char( "Skills set to max_learn value.\n\r", ch );
            return;
        }

        send_to_char( "Value must be numeric.\n\r", ch );
        return;
    }

    value = atoi( arg3 );
    if ( value <= -1 || value > 100 )
    {
        send_to_char( "Value range is 0 (unlearned) to 100.\n\r", ch );
        return;
    }

    if ( fAll )
    {
        for ( sn = 0; sn < MAX_SKILL; sn++ )
        {
            if ( skill_table[sn].name != NULL )
            PC(victim,learned[sn]) = value;
        }
    }
    else PC(victim,learned[sn]) = value;

    return;
}



/*
 * Syntax:  mset [person] [field] [value]
 */
void do_mset( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int value;

    smash_tilde( argument );
    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    strcpy( arg3, argument );

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
    send_to_char( "Syntax: mset <victim> <field>  <value>\n\r", ch );
    send_to_char( "or:     mset <victim> <string> <value>\n\r", ch );
    send_to_char( "\n\r", ch );
    send_to_char( "Field being one of:\n\r",                ch );
    send_to_char( "  sex    class   race\n\r",              ch );
    send_to_char( "  hp     move    timer\n\r",             ch );
    send_to_char( "  master  practice\n\r",                 ch );
    send_to_char( "  act    affect\n\r",                    ch );
    send_to_char( "--For Players:\n\r",                     ch );
    send_to_char( "  str int wis dex con security\n\r",     ch );
    send_to_char( "  race size\n\r",                        ch );
    send_to_char( "  thirst drunk full\n\r",                ch );
    send_to_char( "\n\r", ch );
    send_to_char( "String being one of:\n\r",               ch );
    send_to_char( "  name short long description\n\r",      ch );
    send_to_char( "--For Players:\n\r",                     ch );
    send_to_char( "  keywords constellation\n\r",           ch );
    return;
    }

    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    /*
     * Snarf the value (which need not be numeric).
     */
    value = is_number( arg3 ) ? atoi( arg3 ) : -1;

    /*
     * Set something.
     */
    if ( !str_cmp( arg2, "sex" ) && arg3[0] != '\0' )
    {
        if ( value < 0 || value > 2 )
        {
            send_to_char( "Sex range is 0 to 2.\n\r", ch );
            return;
        }
        victim->sex = value;
        return;
    }

    if ( !str_cmp( arg2, "size" ) && arg3[0] != '\0' )
    {
    victim->size = value;
    return;
    }


    if ( !str_cmp( arg2, "timer" ) && arg3[0] != '\0' )
    {
        if ( value < 0 || value > 30000 )
        {
            send_to_char( "Timer range is 0 to 30,000.\n\r", ch );
            return;
        }
        victim->timer = value;
        return;
    }

    if ( !str_cmp( arg2, "master" ) && arg3[0] != '\0' )
    {
        if ( !str_cmp( arg3, "none" ) )
        {
        victim->master = NULL;
        return;
        }

        if ( ( get_char_world( ch, arg3 ) ) == NULL )
        {
        send_to_char( "They aren't here.\n\r", ch );
        return;
        }

        victim->master = get_char_world( ch, arg3 );
        return;
    }


    if ( !str_cmp( arg2, "act" ) && arg3[0] != '\0' )
    {
        victim->act = value;
        if ( !IS_SET( victim->act, ACT_IS_NPC ) )
             SET_BIT( victim->act, ACT_IS_NPC );
        return;
    }

    if ( !str_cmp( arg2, "affect" ) && arg3[0] != '\0' )
    {
        victim->affected_by = value;
        return;
    }

    if ( !str_cmp( arg2, "name" ) && arg3[0] != '\0' )
    {
        free_string( victim->name );
        victim->name = str_dup( arg3 );
        return;
    }

    if ( !str_cmp( arg2, "short" ) && arg3[0] != '\0' )
    {
	free_string( victim->short_descr );
	victim->short_descr = str_dup( arg3 );
	return;
    }

    if ( !str_cmp( arg2, "long" ) )
    {
        char buf[MAX_STRING_LENGTH];

        sprintf( buf, "%s\n\r", arg3 );
        free_string( victim->long_descr );
        victim->long_descr = str_dup( buf );
        return;
    }

    if ( !str_cmp( arg2, "description" ) )
    {
        send_to_char( "Entering line editing mode.\n\r", ch );
        send_to_char( "Terminate with a ~ on a blank line.\n\r", ch );
        ch->desc->pString = &victim->description;
        return;
    }

    if ( IS_NPC(victim) )
    {
        do_mset( ch, "" );
        return;
    }

    /*
     * Players only.
     */
    if ( get_trust( victim ) > get_trust( ch ) )
    {
    send_to_char( "They are trusted at a higher level than you.\n\r", ch );
    return;
    }

    if ( !str_cmp( arg2, "str" )
      && arg3[0] != '\0' )
    {
        if ( value < 3 || value > 25 )
        {
        send_to_char( "Strength range is 3 to 25.\n\r", ch );
	    return;
        }

        victim->perm_str = value;
        return;
    }

    if ( !str_cmp( arg2, "int" ) && arg3[0] != '\0' )
    {
        if ( value < 3 || value > 25 )
	{
        send_to_char( "Intelligence range is 3 to 25.\n\r", ch );
	    return;
	}

    victim->perm_int = value;
	return;
    }

    if ( !str_cmp( arg2, "wis" ) && arg3[0] != '\0' )
    {
        if ( value < 3 || value > 25 )
	{
        send_to_char( "Wisdom range is 3 to 25.\n\r", ch );
	    return;
	}

    victim->perm_wis = value;
	return;
    }

    if ( !str_cmp( arg2, "dex" ) && arg3[0] != '\0' )
    {
        if ( value < 3 || value > 25 )
	{
        send_to_char( "Dexterity range is 3 to 25.\n\r", ch );
	    return;
	}

    victim->perm_dex = value;
	return;
    }

    if ( !str_cmp( arg2, "con" ) && arg3[0] != '\0' )
    {
        if ( value < 3 || value > 25 )
	{
        send_to_char( "Constitution range is 3 to 25.\n\r", ch );
	    return;
	}

    victim->perm_con = value;
	return;
    }

    if ( !str_cmp( arg2, "race" ) && arg3[0] != '\0' )
    {
    if ( value < 0 || value >= MAX_RACE )
    {
        char buf[MAX_STRING_LENGTH];

        sprintf( buf, "Race range is 0 to %d.\n", MAX_RACE-1 );
        send_to_char( buf, ch );
        return;
    }
    victim->race = value;
    return;
    }


    if ( !str_cmp( arg2, "security" ) && arg3[0] != '\0' )
    {
        if ( value < 1 || value > 9 )
	{
        send_to_char( "Security level is between 1 and 9.\n\r", ch );
	    return;
	}

        if ( PC(victim,security) >= PC(ch,security) )
        {
        send_to_char( "They have a higher security level than you!\n\r", ch );
        return;
        }
    
        PC(victim,security) = UMAX(PC(ch,security), value);
	return;
    }

    if ( !str_cmp( arg2, "thirst" ) && arg3[0] != '\0' )
    {
    if ( value < -100 || value > 100 )
	{
        send_to_char( "Thirst range is -100 to 100.\n\r", ch );
	    return;
	}

    if ( victim->pcdata ) PC(victim,condition[COND_THIRST]) = value;
	return;
    }

    if ( !str_cmp( arg2, "drunk" ) && arg3[0] != '\0' )
    {
    if ( value < 0 || value > 100 )
	{
        send_to_char( "Drunk range is 0 to 100.\n\r", ch );
	    return;
	}

    if ( victim->pcdata ) PC(victim,condition[COND_DRUNK]) = value;
	return;
    }

    if ( !str_cmp( arg2, "full" ) && arg3[0] != '\0')
    {
    if ( value < -100 || value > 100 )
	{
        send_to_char( "Full range is -100 to 100.\n\r", ch );
	    return;
	}

    if ( victim->pcdata ) PC(victim,condition[COND_FULL]) = value;
	return;
    }

    if ( !str_cmp( arg2, "keywords" ) && arg3[0] != '\0' )
    {
        free_string( victim->keywords );
        victim->keywords = str_dup( arg3 );
	return;
    }

    if ( !str_cmp( arg2, "constellation" ) )
    {
        free_string( PC(victim,constellation) );
        PC(victim,constellation) = str_dup( arg3 );
        return;
    }

    /*
     * Generate usage message.
     */
    do_mset( ch, "" );
    return;
}



/*
 * Syntax:  oset [object] [field] [value]
 */
void do_oset( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int value;

    smash_tilde( argument );
    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    strcpy( arg3, argument );

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
    send_to_char( "Syntax: oset <object> <field>  <value>\n\r", ch );
    send_to_char( "or:     oset <object> <string> <value>\n\r", ch );
    send_to_char( "\n\r",                                 ch );
    send_to_char( "Field being one of:\n\r",              ch );
    send_to_char( "  value1, 2, 3, 4               \n\r", ch );
    send_to_char( "  extra   wear    level   weight\n\r", ch );
    send_to_char( "  cost    type    timer   size\n\r",   ch );
    send_to_char( "\n\r",                                 ch );
    send_to_char( "String being one of:\n\r",             ch );
    send_to_char( "  name    short   long\n\r",           ch );
	return;
    }

    if ( ( obj = get_obj_world( ch, arg1 ) ) == NULL )
    {
    send_to_char( "Nothing like that in hell, earth, or heaven.\n\r", ch );
	return;
    }

    /*
     * Snarf the value (which need not be numeric).
     */
    value = atoi( arg3 );

    /*
     * Set something.
     */
    if ( (!str_cmp( arg2, "value1" ) || !str_cmp( arg2, "v1" )) && arg3[0] != '\0' )
    {
    obj->value[0] = value;
    return;
    }

    if ( (!str_cmp( arg2, "value2" ) || !str_cmp( arg2, "v2" )) && arg3[0] != '\0' )
    {
	obj->value[1] = value;
	return;
    }

    if ( (!str_cmp( arg2, "value3" ) || !str_cmp( arg2, "v3" )) && arg3[0] != '\0' )
    {
	obj->value[2] = value;
	return;
    }

    if ( (!str_cmp( arg2, "value4" ) || !str_cmp( arg2, "v4" )) && arg3[0] != '\0' )
    {
	obj->value[3] = value;
	return;
    }


    if ( !str_cmp( arg2, "extra" ) && arg3[0] != '\0' )
    {
    obj->extra_flags ^= extra_name_bit( arg3 );
	return;
    }

    if ( !str_cmp( arg2, "wear" ) && arg3[0] != '\0' )
    {
    obj->wear_flags ^= wear_name_bit( arg3 );
	return;
    }

    if ( !str_cmp( arg2, "level" ) && arg3[0] != '\0' )
    {
	obj->level = value;
	return;
    }

    if ( !str_cmp( arg2, "size" ) && arg3[0] != '\0' )
    {
    obj->size = value;
	return;
    }
	
    if ( !str_cmp( arg2, "weight" ) && arg3[0] != '\0' )
    {
	obj->weight = value;
	return;
    }

    if ( !str_cmp( arg2, "cost" ) && arg3[0] != '\0' )
    {
	obj->cost = value;
	return;
    }

    if ( !str_cmp( arg2, "timer" ) && arg3[0] != '\0' )
    {
	obj->timer = value;
	return;
    }

    if ( !str_cmp( arg2, "type" ) && arg3[0] != '\0' )
    {
    obj->item_type = item_name_type ( arg3 );
    return;
    }

    if ( !str_cmp( arg2, "name" ) && arg3[0] != '\0' )
    {
	free_string( obj->name );
	obj->name = str_dup( arg3 );
	return;
    }

    if ( !str_cmp( arg2, "short" ) && arg3[0] != '\0' )
    {
	free_string( obj->short_descr );
	obj->short_descr = str_dup( arg3 );
	return;
    }

    if ( !str_cmp( arg2, "long" ) )
    {           
        send_to_char( "Entering line editing mode.\n\r", ch );
        send_to_char( "Terminate with a ~ on a blank line.\n\r", ch );
        ch->desc->pString = &obj->description;
        return;
    }


    /*
     * Generate usage message.
     */
    do_oset( ch, "" );
    return;
}



