/****************************************************************************
******************************************************************************
* Locke's   __ -based on merc v2.2-____        NIM Server Software           *
* ___ ___  (__)__    __ __   __ ___| G| v4.0   Version 4.0 GOLD EDITION      *
* |  /   \  __|  \__/  |  | |  |     O|        documentation release         *
* |       ||  |        |  \_|  | ()  L|        Hallow's Eve 1999             *
* |    |  ||  |  |__|  |       |     D|                                      *
* |____|__|___|__|  |__|\___/__|______|        http://www.nimud.org/nimud    *
*   n a m e l e s s i n c a r n a t e          dedicated to chris cool       *
******************************************************************************
 *   ___  ___  ___  __    __                                                *
 *  |   ||   ||   ||  |\/|  | 2-x    NiMUD is a software currently under    *
 *   |  \ | |  | |  | |\/| |         development.  It is based primarily on *
 *   | |\\| |  | |  | |  | |         the discontinued package, Merc 2.2.    *
 *   | | \  |  | |  | |  | |         NiMUD is being written and developed   *
 *  |___||___||___||__|  |__|        By Locke and Surreality as a new,      *
 *   NAMELESS INCARNATE *MUD*        frequently updated package similar to  *
 *        S O F T W A R E            the original Merc 2.x.                 *
 *                                                                          *
 *  Just look for the Iron Maiden skull wherever NiMUD products are found.  *
 *                                                                          *
 *  Much time and thought has gone into this software and you are           *
 *  benefitting.  We hope that you share your changes too.  What goes       *
 *  around, comes around.                                                   *
 ****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mud.h"


/*
 * The following code is for the creation of a generated world file.
 * Each array is used internally by the processor in order to create
 * a larger world.  Populate this world as you wish.
 *
 * Terrain data is referenced here, but is not actually copied to the
 * room.  This allows a dynamic terrain space, referenced as needed.
 * Set constraints based on maximum map size.
 *
 * Terrain types are stored in the mud.nfo area file.
 */

/*
 * Size constraints.
 */
#define MAX_X       400
#define MAX_Y       400


/*
 * Command line terrain editing.
 * Syntax: terrain <vnum> <command> <value>
 */
void do_terrain( CHAR_DATA *ch, char *argument )
{
    TERRAIN_DATA *pTerrain;
    char arg[MAX_INPUT_LENGTH];
    int vnum, value;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        send_to_char( "Terrain syntax:\n\r", ch );
        send_to_char( "   terrain new\n\r", ch );
        send_to_char( "   terrain list\n\r", ch );
        send_to_char( "   terrain <vnum> <command|field|sectortype> <value>\n\r\n\r", ch );
        send_to_char( "Commands:  show\n\r", ch );
        send_to_char( "Fields:    winter summer fall spring name map\n\r", ch );
        return;
    };

    if ( !str_cmp( arg, "list" ) )
    {
        for ( pTerrain = terrain_list;  pTerrain != NULL;  pTerrain = pTerrain->next )
        {
            sprintf( arg, "[%3d] %c %s\n\r", pTerrain->vnum, pTerrain->map_char, pTerrain->name );
            send_to_char( arg, ch );
        }

        return;
    }

    if ( !str_cmp( arg, "new" ) )
    {
        pTerrain = new_terrain( );
        pTerrain->next = terrain_list;
        terrain_list = pTerrain;
        send_to_char( "Terrain created.\n\r", ch );
        return;
    }

    vnum = atoi(arg);
    argument = one_argument( argument, arg );
    value = atoi(arg);

    for ( pTerrain = terrain_list;  pTerrain != NULL;  pTerrain = pTerrain->next )
    {
        if ( vnum == pTerrain->vnum )
        break;
    };

    if ( pTerrain == NULL )
    {
        send_to_char( "Terrain not found.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg, "name" ) )
    {
        free_string( pTerrain->name );
        pTerrain->name = str_dup( argument );
        send_to_char( "Terrain name set.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg, "spring" ) )
    {
        string_append( ch, &pTerrain->spring );
        return;
    }

    if ( !str_cmp( arg, "summer" ) )
    {
        string_append( ch, &pTerrain->summer );
        return;
    }

    if ( !str_cmp( arg, "fall" ) )
    {
        string_append( ch, &pTerrain->fall   );
        return;
    }

    if ( !str_cmp( arg, "winter" ) )
    {
        string_append( ch, &pTerrain->winter );
        return;
    }

    if ( !str_cmp( arg, "map" ) )
    {
        pTerrain->map_char = *argument;
        send_to_char( "Map character set.\n\r", ch );
        return;
    }

    if ( sector_number( arg ) != SECT_MAX )
    {
         pTerrain->sector  = sector_number( arg );
         send_to_char( "Sector type set.\n\r", ch );
         return;
    }

    /* Otherwise, show... */

    sprintf( arg, "Name:  [%s]\n\r", pTerrain->name );
    send_to_char( arg, ch );

    sprintf( arg, "Vnum:  [%3d]   Sector:  [%s]    Map char: [%c]\n\r",
             pTerrain->vnum,
             sector_name( pTerrain->sector ),
             pTerrain->map_char );
    send_to_char( arg, ch );

    sprintf( arg, "Spring:\n\r%sSummer:\n\r%sFall:\n\r%sWinter:\n\r%s",
             pTerrain->spring,
             pTerrain->summer,
             pTerrain->fall,
             pTerrain->winter );
    send_to_char( arg, ch );

    return;
};




void show_terrain( CHAR_DATA *ch, ROOM_INDEX_DATA *pRoom )
{
    char *description;
    TERRAIN_DATA *pTerrain;

    if ( pRoom->terrain == 0 )
    return;

    for ( pTerrain = terrain_list;  pTerrain != NULL;  pTerrain = pTerrain->next )
    {
        if ( pRoom->terrain == pTerrain->vnum )
        break;
    };


    if ( pTerrain == NULL )
    return;

    description = NULL;

    switch ( time_info.month )
    {
        case 0:  /* winter */
        case 1:
        case 11:
             description = pTerrain->winter;
         break;

        case 2:  /* spring */
        case 3:
        case 4:
             description = pTerrain->spring;
         break;

        case 5:  /* summer */
        case 6:
        case 7:
             description = pTerrain->summer;
          break;

        case 8:  /* fall   */
        case 9:
        case 10:
             description = pTerrain->fall;
         break;
    };

    if ( description == NULL ) return;

    send_to_char( description, ch );
    return;
}


const     int    tdir[MAX_DIR][2] =
{ /*   x  y    */
    {  0, -1  },  /* DIR_NORTH */
    {  1,  0  },  /* DIR_EAST  */
    {  0,  1  },  /* DIR_SOUTH */
    { -1,  0  },  /* DIR_WEST  */
    {  0,  0  },  /* DIR_UP not supported */
    {  0,  0  },  /* DIR_DOWN not supported */
    { -1, -1  },  /* DIR_NW    */
    {  1, -1  },  /* DIR_NE    */
    { -1,  1  },  /* DIR_SW    */
    {  1,  1  }   /* DIR_SE    */
};


void generate( CHAR_DATA *ch, int lvnum, int hvnum, bool fOverwrite )
{
    ROOM_INDEX_DATA *pRoom;
    TERRAIN_DATA    *pTerrain;
    char buf[MAX_STRING_LENGTH];
    char *map;
    int iRoom[MAX_X][MAX_Y];
    int x, y, door;
    int maxX = 0, maxY = 0;
    int vnum;

    /*
     * Make all vnums -1
     */
    for ( y = 0;  y < MAX_Y;  y++ )
    {
        for ( x = 0;  x < MAX_X;  x++ )
        {
            iRoom[x][y] = -1;
        }
    }

    /*
     * Find map room.
     */
    pRoom = get_room_index( lvnum );

    if ( pRoom == NULL )
    {
        send_to_char( "No map room.\n\r", ch );
        return;
    }

    send_to_char( "[Generating Landscape]\n\r", ch );

    y = 0;
    x = 0;
    vnum = lvnum+1;
    for ( map = pRoom->description; *map && vnum <= hvnum;  map++ )
    {
        /*
         * New line.
         */
        if ( *map == '\n' )
        {
            y++;
            send_to_char( "\n\r", ch );
            map++;

            if ( *map == '\r' ) map++;

            if ( x > maxX && x < MAX_X )
            maxX = x;
            x = 0;

            /*
             * Map is too long.  (Map is too high)
             */
            if ( y >= MAX_Y )
            {
                maxY = MAX_Y;
                send_to_char( "\n\r << clipped\n\r", ch );
                break;
            }
        }

        /*
         * End of string.
         */
        if ( *map == '\0' )
        {
            maxY = y;
            break;
        }

        /*
         * Too long of a line.  (Map is too wide)
         */
        if ( x >= MAX_X )
        {
            send_to_char( "\n\r << wrapped\n\r", ch );
            x = 0;
            y++;
            if ( y >= MAX_Y )
            {
                maxY = MAX_Y;
                send_to_char( "\n\r << clipped\n\r", ch );
                break;
            }
        }

        /*
         * Find the appropriate terrain data.
         */
        for ( pTerrain = terrain_list;  pTerrain != NULL;  pTerrain = pTerrain->next )
        {
            if ( pTerrain->map_char == *map )
            break;
        }

        if ( pTerrain != NULL )
        {
            sprintf( buf, "%c", *map );
            send_to_char( buf, ch );
        }
        else
        {
            send_to_char( "?", ch );
            x++;  /* continue moving */
            continue;
        }

        iRoom[x][y] = vnum;

        pRoom = get_room_index( iRoom[x][y] );

        /*
         * Generate a new room.
         */
        if ( pRoom == NULL )
        {
            int iHash;

            pRoom                   = new_room_index();
            pRoom->area             = get_vnum_area( vnum );
            pRoom->vnum             = vnum;

            if ( vnum > top_vnum_room ) top_vnum_room = vnum;

            iHash                   = vnum % MAX_KEY_HASH;
            pRoom->next             = room_index_hash[iHash];
            room_index_hash[iHash]  = pRoom;
            pRoom->name             = str_dup( pTerrain->name );
        }

        /*
         * Set terrain information.
         * Overwrite if desired.
         */
        if ( fOverwrite || pRoom->name == NULL )
        {
            free_string( pRoom->name );
            pRoom->name             = str_dup( pTerrain->name );
        }

            pRoom->terrain = pTerrain->vnum;
            sprintf( buf, "Generate: iRoom[%d,%d] = %d", x, y, iRoom[x][y] );
            bug( buf, 0 );

        vnum++;
        x++;                   /* <- Yo, MudMCs, this is important */
    }

    for ( y = 0;  y < maxY;  y++ )
    {
        for ( x = 0;  x < maxX;  x++ )
        {
            sprintf( buf, "Gen-postmap: iRoom[%d,%d] = %d", x, y, iRoom[x][y] );
            bug( buf, 0 );
        }
    }

    /*
     * Connect rooms.
     */
    sprintf( buf, "(end)\n\r[Map Size %d, %d]\n\r[Connecting Rooms]\n\r", maxX, maxY );
    send_to_char( buf, ch );

    for ( y = 0; y < maxY; y++ )
    {
        for ( x = 0; x < maxX; x++ )
        {
            if (iRoom[x][y] == -1)
                continue;

            sprintf( buf, "Generate: iRoom[%d,%d] = %d", x, y, iRoom[x][y] );
            bug( buf, 0 );

            for ( door = 0;  door < MAX_DIR;  door++ )
            {
                int to_vnum;

                if ( door == DIR_UP
                  || door == DIR_DOWN )
                continue;

                /*
                 * Range Check
                 */
                if ( x + tdir[door][0] < 0
                  || x + tdir[door][0] >= MAX_X
                  || y + tdir[door][1] < 0
                  || y + tdir[door][1] >= MAX_Y )
                continue;

                to_vnum = iRoom[(x + tdir[door][0])][(y + tdir[door][1])];

                if ( to_vnum == -1 )
                continue;

                pRoom = get_room_index( iRoom[x][y] );

                if ( pRoom->exit[door] != NULL )
                {
                    if ( !fOverwrite )
                    continue;

                    free_exit( pRoom->exit[door] );
                    pRoom->exit[door] = NULL;
                }


               pRoom->exit[door] = new_exit();

               pRoom->exit[door]->to_room = get_room_index( to_vnum );
               pRoom->exit[door]->vnum = to_vnum;
            }
            send_to_char( "+", ch );
        }
        send_to_char( "\n\r", ch );
    }

    send_to_char( "[Generation complete]\n\r", ch );
    return;
};
