/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"



/*
 * Local functions.
 */
void    talk_channel    args( ( CHAR_DATA *ch, char *argument,
                            int channel, const char *verb ) );
void    stop_idling     args( ( CHAR_DATA *ch ) );

int chan( int channel )
{
   int c;
   switch( channel )
   {
     case CHANNEL_IMMTALK  : c = COLOR_IMMTALK;  break;
     case CHANNEL_GOSSIP   : c = COLOR_GOSSIP;   break;
     case CHANNEL_AUCTION  : c = COLOR_AUCTION;  break;
     default               : bug ( "Chan: invalid code %d", channel );
                             c = 0; break;
   }
   return c;
}


/*
 * Generic channel function.
 */
void talk_channel( CHAR_DATA *ch, char *argument, int channel, const char *verb )
{
    char buf[MAX_STRING_LENGTH];
    DESCRIPTOR_DATA *d;
    int position;
    int old_con;
    char *verb2;

    if ( argument[0] == '\0' )
    {
        sprintf( buf, "%s what?\n\r", verb );
        buf[0] = UPPER(buf[0]);
        return;
    }

    if ( !IS_NPC(ch) && IS_SET(ch->act2, PLR_SILENCE) )
    {
        sprintf( buf, "You can't %s.\n\r", verb );
        send_to_char( buf, ch );
        return;
    }

    REMOVE_BIT(ch->deaf, channel);

    if ( channel == CHANNEL_IMMTALK )
    {
        sprintf( buf, "%s$n: $t$R",
                      color_table[ch->colors[chan(channel)]].act_code );
            position        = ch->position;
            ch->position    = POS_STANDING;
            act( buf, ch, argument, NULL, TO_CHAR );
            ch->position    = position;
        sprintf( buf, "$n: $t$R" );
    }
    else
    {
    switch ( argument[strlen(argument)-1] )
    {
        default: verb2 = ""; break;
       case '!': verb2 = " exclaiming"; break;
       case '?': verb2 = " asking"; break;
    }
    sprintf( buf, "%sYou %s%s '$t'$R",
             color_table[ch->colors[chan(channel)]].act_code,
             verb, verb2 );
    position = ch->position;
    ch->position = POS_STANDING;
    act( buf, ch, argument, NULL, TO_CHAR );
    ch->position = position;
    
    sprintf( buf, "$n %ss%s '$t'$R",     verb, verb2 );
    }

    for ( d = descriptor_list; d != NULL; d = d->next )
    {
        CHAR_DATA *och;
        CHAR_DATA *vch;

        och = d->original ? d->original : d->character;
        vch = d->character;

        if (( d->connected == CON_PLAYING
         ||   d->connected == CON_AEDITOR
         ||   d->connected == CON_OEDITOR
         ||   d->connected == CON_MEDITOR
         ||   d->connected == CON_REDITOR)
        &&   vch != ch
        &&  !IS_SET(och->deaf, channel) )
        {
        char buf2 [MAX_STRING_LENGTH];

            if ( channel == CHANNEL_IMMTALK && !IS_HERO(och) )
                continue;
            if ( channel == CHANNEL_AUCTION
            &&   vch->in_room->area != ch->in_room->area )
                continue;

            position            = vch->position;
            old_con             = d->connected;
            d->connected        = CON_PLAYING;
             vch->position   = POS_STANDING;

        sprintf( buf2, "%s%s$R",
                 color_table[vch->colors[chan(channel)]].act_code,
                 buf );
        act( buf2, ch, argument, vch, TO_VICT );
            vch->position       = position;
            d->connected        = old_con;
        }
    }

    return;
}



void do_auction( CHAR_DATA *ch, char *argument )
{
    talk_channel( ch, argument, CHANNEL_AUCTION, "auction" );
    return;
}

void do_gossip( CHAR_DATA *ch, char *argument )
{
    talk_channel( ch, argument, CHANNEL_GOSSIP, "gossip" );
    return;
}

void do_immtalk( CHAR_DATA *ch, char *argument )
{
    talk_channel( ch, argument, CHANNEL_IMMTALK, "immtalk" );
    return;
}



void do_shout( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    int door;
    CHAR_DATA *rch;
    ROOM_INDEX_DATA *pRoom, *tRoom;

    if ( *argument == '\0' )
    {
        send_to_char( "Shout what?\n\r", ch );
        return;
    }

    sprintf( buf, "%sYou shout '$t'$R",
             color_table[ch->colors[COLOR_SHOUT]].act_code );
    act( buf, ch, argument, NULL, TO_CHAR );

    for ( rch = ch->in_room->people; rch != NULL; rch = rch->next_in_room )
    {
        sprintf( buf, "%s$n shouts '$t'$R",
                      color_table[rch->colors[COLOR_SHOUT]].act_code );
        act( buf, ch, argument, rch, TO_VICT );
    }

    pRoom = ch->in_room;
    for ( door = 0; door < MAX_DIR; door++ )
    {
        if ( pRoom->exit[door] == NULL ) continue;
        if ( (tRoom = pRoom->exit[door]->to_room) == NULL ) continue;

        for ( rch = tRoom->people; rch != NULL; rch = rch->next_in_room )
        {
            sprintf( buf, "%sSomeone shouts from %s '$t'$R",
                     color_table[rch->colors[COLOR_SHOUT]].act_code,
                     dir_rev[door] );
            act( buf, rch, argument, NULL, TO_CHAR );
        }
    }

    WAIT_STATE( ch, 12 );
    return;
}

                                  

void do_say( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    CHAR_DATA *mob;
    char *verb;

    if ( argument[0] == '\0' )
    {
        send_to_char( "Say what?\n\r", ch );
        return;
    }

    switch ( argument[strlen(argument)-1] )
    {
        default: verb = "say";     break;
       case '!': verb = "exclaim"; break;
       case '?': verb = "ask";     break;
    }

    sprintf( buf, "%sYou %s '$t'$R",
                  color_table[ch->colors[COLOR_SAY]].act_code, verb );

    if (ch->desc != NULL)   act( buf, ch, argument, NULL, TO_CHAR  );

    for ( mob = ch->in_room->people;  mob != NULL;  mob = mob->next_in_room )
    {
        TRIGGER_DATA *trig;
        sprintf( buf, "%s%s %ss '$t'$R",
                      color_table[mob->colors[COLOR_SAY]].act_code,
                      capitalize(PERS(ch, mob)), verb );
                      
        if ( mob != ch && mob->desc != NULL )
        {
            act( buf, mob, argument, NULL, TO_CHAR );
        }

        if ( IS_NPC(ch) && IS_NPC(mob)
          && mob->pIndexData->vnum == ch->pIndexData->vnum ) 
            continue;

        for ( trig = mob->triggers; trig != NULL; trig = trig->next )
        {
            if ( trig->trigger_type == TRIG_SAY
              && strstr( argument, trig->keywords ) != NULL
              && trig->current == NULL )
            {
            trig->current = trig->script;
            trig->bits    = SCRIPT_ADVANCE;
            act_trigger( mob, trig->name, argument, IS_NPC(ch) ? STR(ch, name) : ch->name, NULL );
            }
        }
    }

    return;
}

        
        

void do_tell( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *victim;
    TRIGGER_DATA *trig;
    int position;


    if ( !IS_NPC(ch) && IS_SET(ch->act2, PLR_SILENCE) )
    {
        send_to_char( "Your message didn't get through.\n\r", ch );
        return;
    }


    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' || argument[0] == '\0' )
    {
        send_to_char( "Tell whom what?\n\r", ch );
        return;
    }

    /*
     * Can tell to PC's anywhere, but NPC's only in same room.
     * -- Furey
     */
    if ( ( victim = get_char_world( ch, arg ) ) == NULL
    || ( IS_NPC(victim) && victim->in_room != ch->in_room ) )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    if ( !IS_IMMORTAL(ch) && !IS_AWAKE(victim) )
    {
    act( "$E can't hear you.", ch, 0, victim, TO_CHAR );
        return;
    }

    sprintf( buf, "%sYou tell $N '$t'$R",
               color_table[ch->colors[COLOR_TELL]].act_code );
    act( buf, ch, argument, victim, TO_CHAR );

    sprintf( buf, "%s$N tells you '$t'$R",
               color_table[victim->colors[COLOR_TELL]].act_code );

    position        = victim->position;
    victim->position    = POS_STANDING;
    act( buf, victim, argument, ch, TO_CHAR );
    victim->position    = position;
    victim->reply       = ch;

    for ( trig = victim->triggers; trig != NULL; trig = trig->next )
    {
        if ( victim->pIndexData == ch->pIndexData ) break;
        
        if ( trig->trigger_type == TRIG_TELL
          && strstr( argument, trig->keywords ) != NULL
          && trig->current == NULL )
        {
            trig->current = trig->script;
            trig->bits    = SCRIPT_ADVANCE;
            act_trigger( victim, trig->name, argument, ch->name, NULL );
        }
    }
    return;
}



void do_reply( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *victim;
    TRIGGER_DATA *trig;
    char buf[MAX_STRING_LENGTH];
    int position;

    if ( !IS_NPC(ch) && IS_SET(ch->act2, PLR_SILENCE) )
    {
        send_to_char( "Your message didn't get through.\n\r", ch );
        return;
    }

    if ( ( victim = ch->reply ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    if ( !IS_IMMORTAL(ch) && !IS_AWAKE(victim) )
    {
        act( "$E can't hear you.", ch, 0, victim, TO_CHAR );
        return;
    }

    sprintf( buf, "%sYou tell $N '$t'$R",
               color_table[ch->colors[COLOR_TELL]].act_code );
    act( buf, ch, argument, victim, TO_CHAR );
    position            = victim->position;
    victim->position    = POS_STANDING;

    sprintf( buf, "%s$n tells you '$t'$R",
               color_table[victim->colors[COLOR_TELL]].act_code );
    act( buf, ch, argument, victim, TO_VICT );
    victim->position    = position;
    victim->reply       = ch;

    for ( trig = victim->triggers; trig != NULL; trig = trig->next )
    {
        if ( trig->trigger_type == TRIG_TELL
          && strstr( argument, trig->keywords ) != NULL
          && trig->current == NULL )
        {
            trig->current = trig->script;
            trig->bits    = SCRIPT_ADVANCE;
            act_trigger( victim, trig->name, argument, ch->name, NULL );
        }
    }
    return;
}



void do_emote( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char *plast;

    if ( !IS_NPC(ch) && IS_SET(ch->act2, PLR_NO_EMOTE) )
    {
        send_to_char( "You can't show your emotions.\n\r", ch );
        return;
    }

    if ( argument[0] == '\0' )
    {
        send_to_char( "Emote what?\n\r", ch );
        return;
    }

    for ( plast = argument; *plast != '\0'; plast++ );

    strcpy( buf, argument );
    if ( isalpha(plast[-1]) )
        strcat( buf, "." );

    act( "$n $T", ch, NULL, buf, TO_ROOM );
    if (ch->desc != NULL) act( "$n $T", ch, NULL, buf, TO_CHAR );
    return;
}



void do_bug( CHAR_DATA *ch, char *argument )
{
    append_file( ch, BUG_FILE, argument );
    send_to_char( "Ok.  Thanks.\n\r", ch );
    return;
}



void do_idea( CHAR_DATA *ch, char *argument )
{
    append_file( ch, IDEA_FILE, argument );
    send_to_char( "Ok.  Thanks.\n\r", ch );
    return;
}



void do_typo( CHAR_DATA *ch, char *argument )
{
    append_file( ch, TYPO_FILE, argument );
    send_to_char( "Ok.  Thanks.\n\r", ch );
    return;
}



void do_rent( CHAR_DATA *ch, char *argument )
{
    send_to_char( "There is no rent here.  Just save and quit.\n\r", ch );
    return;
}



void do_qui( CHAR_DATA *ch, char *argument )
{
    send_to_char( "If you want to QUIT, you have to spell it out.\n\r", ch );
    return;
}



void do_quit( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    char buf[MAX_STRING_LENGTH];

    if ( IS_NPC(ch) && ch->desc != NULL )
    {
        do_return( ch, "" );
        return;
    }

    if ( ch->position == POS_FIGHTING )
    {
        send_to_char( "No way! You are fighting.\n\r", ch );
        return;
    }

    if ( ch->position  < POS_STUNNED  )
    {
        send_to_char( "You're not DEAD yet.\n\r", ch );
        return;
    }

    do_help( ch, "FAREWELL" );

    stop_idling( ch );

    sprintf( log_buf, "%s has left the game.", NAME(ch) );
    log_string( log_buf );

    sprintf( buf, "Notify>  %s has left the game.", NAME(ch) );
    NOTIFY( buf, LEVEL_IMMORTAL, WIZ_NOTIFY_LOGIN );

    act( "$n has left the game.", ch, NULL, NULL, TO_NOTVICT );

    /*
     * After extract_char the ch is no longer valid!
     */
    save_char_obj( ch );
    d = ch->desc;
    extract_char( ch, TRUE );
    if ( d != NULL )
            close_socket( d );

    return;
}



void do_save( CHAR_DATA *ch, char *argument )
{
    if ( IS_NPC(ch) )
        return;

    if ( ch->level < 2 )
    {
        send_to_char( "You must be at least second level to save.\n\r", ch );
        return;
    }

    save_char_obj( ch );
    send_to_char( "Ok.\n\r", ch );
    return;
}



void do_follow( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        send_to_char( "Follow whom?\n\r", ch );
        return;
    }

    if ( ( victim = get_char_room( ch, arg ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    if ( IS_AFFECTED(ch, AFF_CHARM) && ch->master != NULL )
    {
        act( "But you'd rather follow $N!", ch, NULL, ch->master, TO_CHAR );
        return;
    }

    if ( victim == ch )
    {
        if ( ch->master == NULL )
        {
            send_to_char( "You already follow yourself.\n\r", ch );
            return;
        }
        stop_follower( ch );
        return;
    }
    
    if ( ch->master != NULL )
        stop_follower( ch );

    add_follower( ch, victim );
    return;
}



void add_follower( CHAR_DATA *ch, CHAR_DATA *master )
{
    if ( ch->master != NULL )
    {
        bug( "Add_follower: non-null master.", 0 );
        return;
    }

    ch->master        = master;
    ch->leader        = NULL;

    if ( can_see( master, ch ) )
        act( "$n now follows you.", ch, NULL, master, TO_VICT );

    act( "You now follow $N.",  ch, NULL, master, TO_CHAR );

    return;
}



void stop_follower( CHAR_DATA *ch )
{
    if ( ch->master == NULL )
    {
        bug( "Stop_follower: null master.", 0 );
        return;
    }

    if ( IS_AFFECTED(ch, AFF_CHARM) )
    {
        REMOVE_BIT( ch->affected_by, AFF_CHARM );
        affect_strip( ch, gsn_charm_person );
    }

    if ( can_see( ch->master, ch ) )
        act( "$n stops following you.",     ch, NULL, ch->master, TO_VICT    );
    act( "You stop following $N.",      ch, NULL, ch->master, TO_CHAR    );

    ch->master = NULL;
    ch->leader = NULL;
    return;
}



void die_follower( CHAR_DATA *ch )
{
    CHAR_DATA *fch;

    if ( ch->master != NULL )
        stop_follower( ch );

    ch->leader = NULL;

    for ( fch = char_list; fch != NULL; fch = fch->next )
    {
        if ( fch->master == ch )
            stop_follower( fch );
        if ( fch->leader == ch )
            fch->leader = fch;
    }

    return;
}



void do_order( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    CHAR_DATA *och;
    CHAR_DATA *och_next;
    bool found;
    bool fAll;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' || argument[0] == '\0' )
    {
        send_to_char( "Order whom to do what?\n\r", ch );
        return;
    }

    if ( IS_AFFECTED( ch, AFF_CHARM ) )
    {
        send_to_char( "You feel like taking, not giving, orders.\n\r", ch );
        return;
    }

    if ( !str_cmp( arg, "all" ) )
    {
        fAll   = TRUE;
        victim = NULL;
    }
    else
    {
        fAll   = FALSE;
        if ( ( victim = get_char_room( ch, arg ) ) == NULL )
        {
            send_to_char( "They aren't here.\n\r", ch );
            return;
        }

        if ( victim == ch )
        {
            send_to_char( "Aye aye, right away!\n\r", ch );
            return;
        }

        if ( !IS_AFFECTED(victim, AFF_CHARM) || victim->master != ch )
        {
            send_to_char( "Do it yourself!\n\r", ch );
            return;
        }
    }

    found = FALSE;
    for ( och = ch->in_room->people; och != NULL; och = och_next )
    {
        och_next = och->next_in_room;

        if ( IS_AFFECTED(och, AFF_CHARM)
        &&   och->master == ch
        && ( fAll || och == victim ) )
        {
            found = TRUE;
            act( "$n orders you to '$t'.", ch, argument, och, TO_VICT );
            interpret( och, argument );
        }
    }

    if ( found )
    send_to_char( "Ok.\n\r", ch );
    else
        send_to_char( "You have no followers here.\n\r", ch );
    return;
}



void do_group( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        CHAR_DATA *gch;
        CHAR_DATA *leader;

        leader = (ch->leader != NULL) ? ch->leader : ch;
        sprintf( buf, "%s's group:\n\r", PERS(leader, ch) );
        send_to_char( buf, ch );

        for ( gch = char_list; gch != NULL; gch = gch->next )
        {
            if ( is_same_group( gch, ch ) )
            {
            sprintf( buf,
                     "[%2d] %-16s  %-10s  %-10s  %10dx   %s\n\r",
                     gch->level,
                     capitalize( PERS(gch, ch) ),
                     STRING_HITS(gch), STRING_MOVES(gch), gch->exp,
                     IS_SET(gch->act2, PLR_ASSIST) ? "assisting" : ""    );
            send_to_char( buf, ch );
            }
        }
        return;
    }

    if ( ( victim = get_char_room( ch, arg ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    if ( ch->master != NULL || ( ch->leader != NULL && ch->leader != ch ) )
    {
        send_to_char( "But you are following someone else!\n\r", ch );
        return;
    }

    if ( victim->master != ch && ch != victim )
    {
        act( "$N isn't following you.", ch, NULL, victim, TO_CHAR );
        return;
    }

    if ( is_same_group( victim, ch ) && ch != victim )
    {
        victim->leader = NULL;
        act( "$n removes $N from $s group.",   ch, NULL, victim, TO_NOTVICT );
        act( "$n removes you from $s group.",  ch, NULL, victim, TO_VICT    );
        act( "You remove $N from your group.", ch, NULL, victim, TO_CHAR    );
        return;
    }

    victim->leader = ch;
    act( "$N joins $n's group.", ch, NULL, victim, TO_NOTVICT );
    act( "You join $n's group.", ch, NULL, victim, TO_VICT    );
    act( "$N joins your group.", ch, NULL, victim, TO_CHAR    );
    return;
}



/*
 * 'Split' originally by Gnort, God of Chaos.
 */
void do_split( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *gch;
    int members;
    int amount;
    int share;
    int extra;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        send_to_char( "Split how much?\n\r", ch );
        return;
    }
    
    amount = atoi( arg );

    if ( amount < 0 )
    {
        send_to_char( "Your group wouldn't like that.\n\r", ch );
        return;
    }

    if ( amount == 0 )
    {
        send_to_char( "You hand out zero coins, but no one notices.\n\r", ch );
        return;
    }

    if ( tally_coins( ch ) < amount )
    {
        send_to_char( "You don't have that much gold.\n\r", ch );
        return;
    }
  
    members = 0;
    for ( gch = ch->in_room->people; gch != NULL; gch = gch->next_in_room )
    {
        if ( is_same_group( gch, ch ) )
            members++;
    }

    if ( members < 2 )
    {
        send_to_char( "Just keep it all.\n\r", ch );
        return;
    }
            
    share = amount / members;
    extra = amount % members;

    if ( share == 0 )
    {
        send_to_char( "Don't even bother, cheapskate.\n\r", ch );
        return;
    }

    sub_coins( amount, ch );
    create_amount( share + extra, ch, NULL, NULL );

    sprintf( buf,
    "You split %s coins.\n\rYour share is %s coins.\n\r",
    name_amount( amount ), name_amount( share + extra ) );
    send_to_char( buf, ch );

    sprintf( buf, "%s splits %s coins.\n\rYour share is %s coins.",
            NAME(ch), name_amount( amount ), name_amount( share ) );

    for ( gch = ch->in_room->people; gch != NULL; gch = gch->next_in_room )
    {
        if ( gch != ch && is_same_group( gch, ch ) )
        {
            send_to_char( buf, gch );
        create_amount( share, gch, NULL, NULL );
        }
    }

    return;
}



void do_gtell( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *gch;

    if ( argument[0] == '\0' )
    {
        send_to_char( "Tell your group what?\n\r", ch );
        return;
    }

    if ( IS_SET( ch->act2, PLR_NO_TELL ) )
    {
        send_to_char( "Your message didn't get through!\n\r", ch );
        return;
    }

    /*
     * Note use of send_to_char, so gtell works on sleepers.
     */
    for ( gch = char_list; gch != NULL; gch = gch->next )
    {
        int position;

    sprintf( buf, "%s%s tells the group '%s'$R",
                  color_table[gch->colors[COLOR_TELL]].act_code,
                  NAME(ch), argument );
    position = gch->position;
    gch->position = POS_STANDING;
        if ( is_same_group( gch, ch ) )
       act( buf, gch, NULL, NULL, TO_CHAR );
       gch->position = position;
    }

    return;
}



/*
 * It is very important that this be an equivalence relation:
 * (1) A ~ A
 * (2) if A ~ B then B ~ A
 * (3) if A ~ B  and B ~ C, then A ~ C
 */
bool is_same_group( CHAR_DATA *ach, CHAR_DATA *bch )
{
    if ( ach->leader != NULL ) ach = ach->leader;
    if ( bch->leader != NULL ) bch = bch->leader;
    return ach == bch;
}





