/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"



char *	const	where_name	[] =
{
    "<worn on finger>",
    "<worn on finger>",
    "<worn around neck>",
    "<worn around neck>",
    "<worn on body>",
    "<worn on head>",
    "<worn on legs>",
    "<worn on feet>",
    "<worn on hands>",
    "<worn on arms>",
    "<worn as shield>",
    "<worn about body>",
    "<worn about waist>",
    "<worn around wrist>",
    "<worn around wrist>",
    "<floating nearby>",
    "<thrust through belt>",
    "<thrust through belt>",
    "<thrust through belt>",
    "<thrust through belt>",
    "<thrust through belt>",
    "<primary hand>",
    "<secondary hand>",
    "<slung over shoulder>",
    "<slung over shoulder>",
};


#define MAX_ITERATION       4      /* for old ver */


char *  const   dist_name  [MAX_ITERATION] =
{
    "nearby",
    "not too far off",
    "fairly far",
    "a long ways off"
};


/*
 * Local functions.
 */
char *  format_obj_to_char  args( ( OBJ_DATA *obj, CHAR_DATA *ch,
                                    bool fShort ) );
void	show_list_to_char	args( ( OBJ_DATA *list, CHAR_DATA *ch,
                                    bool fShort, bool fShowNothing ) );
void	show_char_to_char_0	args( ( CHAR_DATA *victim, CHAR_DATA *ch ) );
void	show_char_to_char_1	args( ( CHAR_DATA *victim, CHAR_DATA *ch ) );
void	show_char_to_char	args( ( CHAR_DATA *list, CHAR_DATA *ch ) );
void    show_equipment      args( ( CHAR_DATA *ch, CHAR_DATA *tch ) );
bool    check_blind         args( ( CHAR_DATA *ch ) );


/*
 * Old version (nice looking, but is hard to modify.)
 */

void scan_direction( CHAR_DATA *ch, int dir )
{
    EXIT_DATA *pexit;
    ROOM_INDEX_DATA *troom;
    CHAR_DATA *mob;
    char *done;
    char final[MAX_STRING_LENGTH];
    char buf[MAX_STRING_LENGTH];
    bool fMultiple;
    int n = 0;


    if ( dir < 0 || dir >= MAX_DIR ) return;
    final[0] = '\0';

    pexit          = ch->in_room->exit[dir];
    if ( pexit == NULL )
        return;

    if ( (IS_SET(pexit->exit_info, EX_CLOSED)
       || room_is_dark(pexit->to_room))
       && !IS_IMMORTAL(ch) )
       return;

     n = 0;
     while ( pexit != NULL && n < MAX_ITERATION )
     {
     fMultiple  = FALSE;
     troom      = pexit->to_room;
     if ( troom->people != NULL 
       && can_see( ch, troom->people ) 
       && troom != ch->in_room )
     {
        if ( (IS_SET(pexit->exit_info, EX_CLOSED) || room_is_dark(troom))
          && !IS_IMMORTAL(ch) )
        {
            n = MAX_ITERATION;          /* End loop */
            sprintf( buf, " %s %s %s from here.", fMultiple ? "are" : "is",
                                          dist_name[URANGE(0, n, 7 )],
                                          dir_name[URANGE(0, dir, MAX_DIR-1)] );
            strcat( final, buf );
            continue;
        }

        for ( mob = troom->people; mob != NULL; mob = mob->next_in_room )
        {
            if  ( !can_see( ch, mob ) )
              continue;

            if ( mob->next_in_room == NULL && mob != troom->people )
            {
                fMultiple = TRUE;
                sprintf( buf, " and %s", NAME(mob) );
            }
       else if ( mob->next_in_room != NULL
              && mob->next_in_room->next_in_room != NULL )
                 sprintf( buf, "%s, ", NAME(mob) );
            else sprintf( buf, "%s", NAME(mob) );
            strcat( final, buf );
       }
       sprintf( buf, " %s %s %s from here.", fMultiple ? "are" : "is",
                                          dist_name[URANGE(0, n, MAX_ITERATION-1)],
                                          dir_name[URANGE(0, dir, MAX_DIR-1)] );
       strcat( final, buf );
       final[0] = UPPER(final[0]);
       done = format_string( str_dup( final ) );
       send_to_char( done, ch );
       free_string( done );
       final[0] = '\0';
     }
     pexit = troom->exit[dir];
     n++;
     }
     
     return;
}


char *format_obj_to_char( OBJ_DATA *obj, CHAR_DATA *ch, bool fShort )
{
    static char buf[MAX_STRING_LENGTH];

    buf[0] = '\0';
    if ( IS_OBJ_STAT(obj, ITEM_INVIS)     )   strcat( buf, "(Invis) "     );
    if ( IS_AFFECTED(ch, AFF_DETECT_EVIL)
         && IS_OBJ_STAT(obj, ITEM_EVIL)   )   strcat( buf, "(Red Aura) "  );
    if ( IS_AFFECTED(ch, AFF_DETECT_MAGIC)
         && IS_OBJ_STAT(obj, ITEM_MAGIC)  )   strcat( buf, "(Yellow Glow) "   );
    if ( IS_OBJ_STAT(obj, ITEM_GLOW)      )   strcat( buf, "(Glowing) "   );
    if ( IS_OBJ_STAT(obj, ITEM_HUM)       )   strcat( buf, "(Humming) "   );

    if ( fShort )
    {
        strcat( buf, STR(obj, short_descr) );
    }
    else
    {
        strcat( buf, STR(obj, description) );
    }

    return buf;
}



/*
 * Show a list to a character.
 * Can coalesce duplicated items.
 */
void show_list_to_char( OBJ_DATA *list, CHAR_DATA *ch, bool fShort, bool fShowNothing )
{
    char buf[MAX_STRING_LENGTH];
    char **prgpstrShow;
    int *prgnShow;
    char *pstrShow;
    OBJ_DATA *obj;
    int nShow;
    int iShow;
    int count;
    bool fCombine;

    if ( ch->desc == NULL )
	return;
    
    /*
     * Alloc space for output lines.
     */
    count = 0;
    for ( obj = list; obj != NULL; obj = obj->next_content )
	count++;
    prgpstrShow	= alloc_mem( count * sizeof(char *) );
    prgnShow    = alloc_mem( count * sizeof(int)    );
    nShow	= 0;

    /*
     * Format the list of objects.
     */
    for ( obj = list; obj != NULL; obj = obj->next_content )
    { 
    if ( obj->wear_loc == WEAR_NONE && can_see_obj( ch, obj ) )
	{
	    pstrShow = format_obj_to_char( obj, ch, fShort );
	    fCombine = FALSE;

        if ( IS_NPC(ch) || IS_SET(ch->act2, PLR_COMBINE) )
        {
		/*
		 * Look for duplicates, case sensitive.
		 * Matches tend to be near end so run loop backwords.
		 */
		for ( iShow = nShow - 1; iShow >= 0; iShow-- )
		{
		    if ( !strcmp( prgpstrShow[iShow], pstrShow ) )
		    {
			prgnShow[iShow]++;
			fCombine = TRUE;
			break;
		    }
		}
	    }

	    /*
	     * Couldn't combine, or didn't want to.
	     */
	    if ( !fCombine )
	    {
		prgpstrShow [nShow] = str_dup( pstrShow );
		prgnShow    [nShow] = 1;
		nShow++;
	    }
	}
    }

    /*
     * Output the formatted list.
     */
    for ( iShow = 0; iShow < nShow; iShow++ )
    {
    if ( IS_NPC(ch) || IS_SET(ch->act2, PLR_COMBINE) )
	{
	    if ( prgnShow[iShow] != 1 )
	    {
        sprintf( buf, "(%2d) ", prgnShow[iShow] );
		send_to_char( buf, ch );
	    }
	}
	send_to_char( prgpstrShow[iShow], ch );
    if (fShort)
      send_to_char( "\n\r", ch );
	free_string( prgpstrShow[iShow] );
    }

    if ( fShowNothing && nShow == 0 )
    {
    if ( IS_NPC(ch) || IS_SET(ch->act2, PLR_COMBINE) )
        send_to_char( "     ", ch );
    send_to_char( "Nothing.\n\r", ch );
    }

    /*
     * Clean up.
     */
    free_mem( prgpstrShow, count * sizeof(char *) );
    free_mem( prgnShow,    count * sizeof(int)    );

    return;
}


/*
 *  Shows a mob/player to character (look in room)
 */
void show_char_to_char_0( CHAR_DATA *victim, CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];

    buf[0] = '\0';
    if ( victim == NULL || ch == NULL ) return;

    if ( victim->mounted_by != NULL
      && victim->mounted_by->in_room == ch->in_room )
        return;

/*    send_to_char( "MOB/PLR ", ch );       */

    if ( IS_AFFECTED(victim, AFF_INVISIBLE)   ) strcat( buf, "(Invis) "      );
    if ( IS_AFFECTED(victim, AFF_HIDE)        ) strcat( buf, "(Hidden) "     );
    if ( IS_AFFECTED(victim, AFF_CHARM)       ) strcat( buf, "(Charmed) "    );
    if ( IS_AFFECTED(victim, AFF_PASS_DOOR)   ) strcat( buf, "(Translucent) ");
    if ( IS_AFFECTED(victim, AFF_FAERIE_FIRE) ) strcat( buf, "(Pink Aura) "  );
    if ( IS_EVIL(victim)
    &&   IS_AFFECTED(ch, AFF_DETECT_EVIL)     ) strcat( buf, "(Red Aura) "   );
    if ( IS_AFFECTED(victim, AFF_SANCTUARY)   ) strcat( buf, "(White Aura) " );
    if ( !IS_NPC(victim) && victim->desc == NULL ) strcat( buf, "(LINKLESS) ");

    if ( victim->position == POS_STANDING
      && STR(victim, long_descr)[0] != '\0' )
    {
    strcat( buf, STR(victim, long_descr) );
	send_to_char( buf, ch );
	return;
    }

    strcat( buf, PERS( victim, ch ) );
    if ( !IS_NPC(victim) && !IS_SET(ch->act2, PLR_BRIEF) )
	strcat( buf, victim->pcdata->title );

    if ( victim->riding != NULL && victim->riding->in_room == victim->in_room )
    {
        char buf2[MAX_STRING_LENGTH];
        sprintf( buf2, " is here, riding %s.\n\r", PERS(victim->riding, ch) );
        strcat( buf, buf2 );
    }
    else
    {
    switch ( victim->position )
    {
    case POS_DEAD:     strcat( buf, " is DEAD!!\n\r" );              break;
    case POS_MORTAL:   strcat( buf, " is mortally wounded.\n\r" );   break;
    case POS_INCAP:    strcat( buf, " is incapacitated.\n\r" );      break;
    case POS_STUNNED:  strcat( buf, " is lying here stunned.\n\r" ); break;
    case POS_SLEEPING: strcat( buf, " is sleeping here.\n\r" );      break;
    case POS_RESTING:
    strcat( buf, " is resting here.\n\r" );       break;
    case POS_STANDING:
      strcat( buf, " is here.\n\r" );
     break;
    case POS_FIGHTING:
      strcat( buf, " is here, fighting " );
      if ( victim->fighting == NULL )
          strcat( buf, "thin air??\n\r" );
      else if ( victim->fighting == ch )
          strcat( buf, "YOU!\n\r" );
      else if ( victim->in_room == victim->fighting->in_room )
      {
          strcat( buf, PERS( victim->fighting, ch ) );
          strcat( buf, ".\n\r" );
      }
      else
          strcat( buf, "someone who left??\n\r" );
     break;
    }
    }
                                       /*    strcat( buf, "\n\r" ); */
    buf[0] = UPPER(buf[0]);
    send_to_char( buf, ch );
    return;
}


/*
 * Shows the generated object description to a character.
 * (Once again I must say, Thanks to Kalgen for this AWESOME idea)
 * Thanks to Morgenes for the bug fixes/improvements.
 *                                    - Locke
 */
void show_equipment( CHAR_DATA *ch, CHAR_DATA *tch )
{
   OBJ_DATA *obj;
   OBJ_DATA *obj2;
   char buf[MAX_STRING_LENGTH];
   char descr[MAX_STRING_LENGTH];
   char *finalstr;
   bool fBool;
   int oType;

   buf[0] = '\0';
   descr[0] = '\0';

   fBool = FALSE;

   if( ( ( obj = get_eq_char( ch, WEAR_FINGER_L ) ) != NULL
    && can_see_obj( tch, obj ) )
    && ( ( obj2 = get_eq_char( ch, WEAR_FINGER_R ) ) != NULL
    && can_see_obj( tch, obj2 ) )
    && !strcmp( STR(obj,short_descr), STR(obj2,short_descr) ) )
   {
      sprintf( buf, "%s is wearing two %ss on %s fingers",
       HE_SHE( ch ),
       smash_article( STR(obj,short_descr) ),
       HIS_HER( ch ) );
      strcat( descr, buf );
   }
   else
   {
      if( ( obj = get_eq_char( ch, WEAR_FINGER_L ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "On %s left hand, %s is wearing %s",
          HIS_HER( ch ), HE_SHE( ch ), STR(obj,short_descr) );
         strcat( descr, buf );
         fBool = TRUE;
      }
     
      if( ( obj = get_eq_char( ch, WEAR_FINGER_R ) ) != NULL
       && can_see_obj( tch, obj ) )
      { 
         if( fBool )
            sprintf( buf, " and %s %s on %s right",
             STR(obj,short_descr), is_are( STR(obj,short_descr) ), HIS_HER( ch ) );
         else
            sprintf( buf, "On %s right hand %s %s",
             HIS_HER( ch ), is_are( STR(obj,short_descr) ), STR(obj,short_descr) );
         strcat( descr, buf );
      }
   }

   if( ( obj = get_eq_char( ch, WEAR_HANDS ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      if( descr[0] != '\0' )
         sprintf( buf, ", with %s covering %s hands.",
          STR(obj,short_descr), HIS_HER(ch) );
      else
         sprintf( buf, "%s %s worn on %s hands.",
          STR(obj,short_descr), is_are( STR(obj,short_descr) ), HIS_HER( ch ) );
      strcat( descr, buf );
   }
   else if( descr[0] != '\0' )
      strcat( descr, ".  " );

   fBool = FALSE;

   if( ( obj = get_eq_char( ch, WEAR_HEAD ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s is wearing %s on %s head.  ",
       HE_SHE( ch ), STR(obj,short_descr), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( ( obj = get_eq_char( ch, WEAR_NECK_1 ) ) != NULL
    && can_see_obj( tch, obj ) )
    && ( ( obj2 = get_eq_char( ch, WEAR_NECK_2 ) ) != NULL
    && can_see_obj( tch, obj2 ) )
    && !strcmp( STR(obj,short_descr), STR(obj2,short_descr) ) )
   {
      sprintf( buf, "Two %ss are clasped around %s neck.  ",
       smash_article( STR(obj,short_descr) ), HIS_HER( ch ) );
      strcat( descr, buf );
   }
   else
   {
      if( ( obj = get_eq_char( ch, WEAR_NECK_1 ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( get_eq_char( ch, WEAR_NECK_2 ) == NULL )
            sprintf( buf, "%s is worn on %s neck.  ",
             STR(obj,short_descr), HIS_HER( ch ) );
         else
            sprintf( buf, "%s and ", STR(obj,short_descr) );
         strcat( descr, buf );
         fBool = TRUE;
      }
   
      if( ( obj = get_eq_char( ch, WEAR_NECK_2 ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( fBool )
            sprintf( buf, "%s are worn on %s neck.  ",
             STR(obj,short_descr), HIS_HER( ch ) );
         else
            sprintf( buf, "%s %s worn on %s neck.  ",
             STR(obj,short_descr), is_are( STR(obj,short_descr) ), HIS_HER( ch ) );
         strcat( descr, buf );
      }
   }

   fBool = FALSE;
   
   if( ( obj = get_eq_char( ch, WEAR_ABOUT ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s %s draped over %s ",
       STR(obj,short_descr), is_are( STR(obj,short_descr) ), HIS_HER( ch ) );
      strcat( descr, buf );
      if( ( obj = get_eq_char( ch, WEAR_BODY ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "%s.  ",
          smash_article( STR(obj,short_descr) ) );
      }
      else
         sprintf( buf, "naked chest.  " );
      strcat( descr, buf );
   }
   else if( ( obj = get_eq_char( ch, WEAR_BODY ) ) != NULL 
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s %s being worn on %s body.",
       STR(obj,short_descr), is_are( STR(obj,short_descr) ), HIS_HER( ch ) );
      strcat( descr, buf );
   }
  
   if( ( obj = get_eq_char( ch, WEAR_ARMS ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s %s protecting %s arms.  ",
       STR(obj,short_descr), is_are( STR(obj,short_descr) ), HIS_HER( ch ) );
      strcat( descr, buf );
   }
 
   if( ( obj = get_eq_char( ch, WEAR_LEGS ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s is wearing %s on %s legs.  ",
       HE_SHE( ch ), STR(obj,short_descr), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( ( obj = get_eq_char( ch, WEAR_WRIST_L ) ) != NULL
    && can_see_obj( tch, obj ) )
    && ( ( obj2 = get_eq_char( ch, WEAR_WRIST_R ) ) != NULL
    && can_see_obj( tch, obj2 ) )
    && !strcmp( STR(obj,short_descr), STR(obj2,short_descr) ) )
   {
      sprintf( buf, "Two %ss are on each wrist.  ",
       smash_article( STR(obj,short_descr) ) );
      strcat( descr, buf );
   }
   else
   {
      if( ( obj = get_eq_char( ch, WEAR_WRIST_L ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "Encircling %s left wrist, %s %s",
          HIS_HER( ch ), is_are( STR(obj,short_descr) ), STR(obj,short_descr) );
         strcat( descr, buf );
         fBool = TRUE;
      }
    
      if( ( obj = get_eq_char( ch, WEAR_WRIST_R ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( fBool )
            sprintf( buf, " and %s on %s right.  ",
             STR(obj,short_descr), HIS_HER( ch ) );
         else
            sprintf( buf,
             "Encircling %s right wrist %s %s.  ",
             HIS_HER( ch ), is_are( STR(obj,short_descr) ), STR(obj,short_descr) );
         strcat( descr, buf );
      }
      else if( fBool )
         strcat( descr, ".  " );
   }

   fBool = FALSE;

   if( ( ( obj = get_eq_char( ch, WEAR_SHOULDER_L ) ) != NULL
    && can_see_obj( tch, obj ) )
    && ( ( obj2 = get_eq_char( ch, WEAR_SHOULDER_R ) ) != NULL
    && can_see_obj( tch, obj2 ) )
    && !strcmp( STR(obj,short_descr), STR(obj2,short_descr) ) )
   {
      sprintf( buf, "%s has two %ss slung over %s shoulders.",
       HE_SHE( ch ), smash_article( STR(obj,short_descr) ), HIS_HER( ch ) );
      strcat( descr, buf );
   } 
   else
   {
      if( ( obj = get_eq_char( ch, WEAR_SHOULDER_L ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         sprintf( buf, "%s %s slung over %s left shoulder",
          STR(obj,short_descr), is_are( STR(obj,short_descr) ), HIS_HER( ch ) );
         strcat( descr, buf );
         fBool = TRUE;
      }
      if( ( obj = get_eq_char( ch, WEAR_SHOULDER_R ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( fBool )
            sprintf( buf, " and %s %s slung over %s right",
             STR(obj,short_descr), is_are( STR(obj,short_descr) ), HIS_HER( ch ) );
         else
            sprintf( buf, "Over %s right shoulder %s %s",
            HIS_HER( ch ), is_are( STR(obj,short_descr) ), STR(obj,short_descr) );
         strcat( descr, buf );
      }
      if( fBool || get_eq_char( ch, WEAR_SHOULDER_R ) )
         strcat( descr, ".  " );
   }

   fBool = FALSE;

   if( ( ( obj = get_eq_char( ch, WEAR_HOLD_1 ) ) != NULL
    && can_see_obj( tch, obj ) )
    && ( ( obj2 = get_eq_char( ch, WEAR_HOLD_2 ) ) != NULL
    && can_see_obj( tch, obj2 ) )
    && !strcmp( STR(obj,short_descr), STR(obj2,short_descr) ) )
   {
      if( obj->item_type == ITEM_WEAPON )
         sprintf( buf, "Two %ss are wielded in %s hands.",
          smash_article( STR(obj,short_descr) ), HIS_HER( ch ) );
      else
         sprintf( buf, "Two %ss are at the ready in %s hands.",
          smash_article( STR(obj,short_descr) ), HIS_HER( ch ) );
      strcat( descr, buf );
   }
   else
   {
      oType = ITEM_TRASH;
      if( ( obj = get_eq_char( ch, WEAR_HOLD_1 ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( obj->item_type == ITEM_WEAPON )
         {
            sprintf( buf, "%s %s being wielded",
             STR(obj,short_descr), is_are( STR(obj,short_descr) ) );
            oType = ITEM_WEAPON;
         }
         else
            sprintf( buf, "%s %s at the ready",
             STR(obj,short_descr), is_are( STR(obj,short_descr) ) );
         strcat( descr, buf );
         fBool = TRUE;
      }
      if( ( obj = get_eq_char( ch, WEAR_HOLD_2 ) ) != NULL
       && can_see_obj( tch, obj ) )
      {
         if( fBool )
         {
            if( oType == ITEM_WEAPON 
             && obj->item_type == ITEM_WEAPON )
               sprintf( buf, ", as well as %s.  ",
                STR(obj,short_descr) );
            else if( obj->item_type == ITEM_WEAPON )
               sprintf( buf, ", and %s %s wielded.  ",
                STR(obj,short_descr), is_are( STR(obj,short_descr) ) );
            else
               sprintf( buf, ", and %s %s at the ready.  ",
                STR(obj,short_descr), is_are( STR(obj,short_descr) ) );
         }
         else
         {
            if( obj->item_type != ITEM_WEAPON )
               sprintf( buf, "%s %s at the ready.  ",
                STR(obj,short_descr), is_are( STR(obj,short_descr) ) );
            else
               sprintf( buf, "%s %s being wielded.",
                STR(obj,short_descr), is_are( STR(obj,short_descr) ) );
         } 
         strcat( descr, buf );
      }
      else if( fBool )
         strcat( descr, ".  " );
   }

   fBool = FALSE;

   if( ( obj = get_eq_char( ch, WEAR_FLOATING ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s is floating near %s head.  ",
       STR(obj,short_descr), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( obj = get_eq_char( ch, WEAR_WAIST ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s fits snugly around %s waist.  ",
       STR(obj,short_descr), HIS_HER( ch ) );
      strcat( descr, buf );
   }

   if( ( obj = get_eq_char( ch, WEAR_SHIELD ) ) != NULL
    && can_see_obj( tch, obj ) )
   {
      sprintf( buf, "%s serves to protect %s as a shield.  ",
        STR(obj,short_descr), HIM_HER( ch ) );
      strcat( descr, buf );
   }
   
   if( descr[0] != '\0' )
   {
      send_to_char( "\n\r", tch );
      finalstr = format_string( str_dup( descr ) );
      send_to_char( finalstr, tch );
      free_string( finalstr );
   }

   return;
}



/*
 * Shows the actually character (look at someone)
 */
void show_char_to_char_1( CHAR_DATA *victim, CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    OBJ_DATA *obj;
    int iWear;
    bool found;

    if ( can_see( victim, ch ) )
    {
	act( "$n looks at you.", ch, NULL, victim, TO_VICT    );
	if ( ch != victim )
         act( "$n looks at $N.",  ch, NULL, victim, TO_NOTVICT );
else         act( "$n looks $mself over.", ch, NULL, NULL, TO_NOTVICT );
    }

    if ( STR(victim, description)[0] != '\0' )
    {
    send_to_char( STR(victim, description), ch );
    }
    else
    {
	act( "You see nothing special about $M.", ch, NULL, victim, TO_CHAR );
    }

    show_equipment( victim, ch );

    send_to_char( "\n\r",   ch );

    strcpy( buf, PERS(victim, ch) );
    sprintf( buf, "     %s looks %s.\n\r", capitalize(PERS( victim, ch )),
                                  STRING_HITS(victim) );
    send_to_char( buf, ch );

    send_to_char( "     ", ch );
    switch ( victim->position )
    {
        case POS_DEAD:
          act( "$N is dead.", ch, NULL, victim, TO_CHAR );
         break;
        case POS_MORTAL:
          act( "$N has wounds that may bring death.", ch, NULL, victim, TO_CHAR );
         break;
        case POS_INCAP:
          act( "$N has been rendered incapacitated.", ch, NULL, victim, TO_CHAR );
         break;
        case POS_STUNNED:
          act( "$N is stunned.", ch, NULL, victim, TO_CHAR );
         break;
        case POS_SLEEPING:
          act( "$N is fast asleep.", ch, NULL, victim, TO_CHAR );
         break;
        case POS_FIGHTING:
          if ( victim->fighting != NULL )
          {
          sprintf( buf, "%s is fighting with %s.\n\r",
                        PERS( victim, ch ),  PERS( victim->fighting, ch ) );
          send_to_char( buf, ch );
          }
         break;
          default:  break;
    }

    send_to_char( "\n\r", ch );

    if ( !IS_NPC(victim) )
    {                 
    sprintf( buf2, "%s",  race_table[victim->race].race_name );

    for ( iWear = 0; iWear < strlen(buf2); iWear++ )
     buf2[iWear] = LOWER(buf2[iWear]);

    if ( victim->riding != NULL )
    {
    sprintf( buf, "Mounted on %s, ", NAME(victim->riding) );
    send_to_char( buf, ch );
    }
else if ( victim->mounted_by != NULL )
    {
    sprintf( buf, "Ridden by %s, ", NAME(victim->mounted_by) );
    send_to_char( buf, ch );
    }

    sprintf( buf, "%s is a %s approximately %s sapling%s tall.\n\r",
                  capitalize(HE_SHE(victim)), buf2,
                  victim->size == ARMOR_MINUTE  ? "one half" :
                  victim->size == ARMOR_SMALL   ? "one" :
                  victim->size == ARMOR_PETITE  ? "one and one half" :
                  victim->size == ARMOR_AVERAGE ? "two" :
                  victim->size == ARMOR_MEDIUM  ? "two and one half" :
                  victim->size == ARMOR_LARGE   ? "three" :
                  victim->size == ARMOR_HUGE    ? "four" :
                  victim->size == ARMOR_TITANIC ? "five" :
                  victim->size == ARMOR_GARGANTUAN ? "six" : "unknown",
                  victim->size == ARMOR_SMALL   ? "" : "s" );
    send_to_char( buf, ch );
    }
    else
    {
    if ( victim->riding != NULL )
    {
    sprintf( buf, "Mounted on %s.\n\r", NAME(victim->riding) );
    send_to_char( buf, ch );
    }
else if ( victim->mounted_by != NULL )
    {
    sprintf( buf, "Ridden by %s.\n\r", NAME(victim->mounted_by) );
    send_to_char( buf, ch );
    }
    }

    if ( ch == victim || IS_IMMORTAL(ch) )
    {
    found = FALSE;
    act( "$N is using:", ch, NULL, victim, TO_CHAR );
    for ( iWear = 0; iWear < MAX_WEAR; iWear++ )
    {
    if ( ( obj = get_eq_char( victim, iWear ) ) == NULL )
        continue;

    sprintf( buf, "%-24s %s\n\r", where_name[iWear],
    can_see_obj( ch, obj ) ? format_obj_to_char( obj, ch, TRUE ) : "something" );
    send_to_char( buf, ch );
	found = TRUE;
    }

    if ( !found )  send_to_char( "     Nothing.\n\r", ch );
    }

    if ( victim != ch
    && ((!IS_NPC(ch) && number_percent( ) < ch->pcdata->learned[gsn_peek])
      || IS_IMMORTAL(ch)
      || ch->riding == victim
      || ch->mounted_by == victim ) )
    {
    send_to_char( "\n\rYou peek at the inventory:\n\r", ch );
    show_list_to_char( victim->carrying, ch, TRUE, TRUE );
    }

     return;
}


 /*
  *  Show whose in the room (all mobs/players)
  */
void show_char_to_char( CHAR_DATA *list, CHAR_DATA *ch )
{
    CHAR_DATA *rch;
    bool fDark = FALSE;

    for ( rch = list; rch != NULL; rch = rch->next_in_room )
    {
	if ( rch == ch )
	    continue;

	if ( !IS_NPC(rch)
        &&   rch->wizinvis >= ch->level
	&&   get_trust( ch ) < get_trust( rch ) )
	    continue;

	if ( can_see( ch, rch ) )
	{
	    show_char_to_char_0( rch, ch );
	}
    else
    if ( room_is_dark( ch->in_room ) && !fDark && IS_AFFECTED(rch, AFF_INFRARED ) )
	{
            fDark = TRUE;
	    send_to_char( "Pairs of red eyes stare at you from the darkness.\n\r", ch );
	}
    }

    return;
} 



bool check_blind( CHAR_DATA *ch )
{
    if ( !IS_NPC(ch) && IS_SET(ch->act, PLR_HOLYLIGHT) )
	return TRUE;

    if ( IS_AFFECTED(ch, AFF_BLIND) )
    {
	send_to_char( "You can't see a thing!\n\r", ch );
	return FALSE;
    }

    return TRUE;
}



void do_look( CHAR_DATA *ch, char *argument )
{
    char buf  [MAX_STRING_LENGTH];
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    EXIT_DATA *pexit;
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    char *pdesc;
    int door;

/*    if ( ch->desc == NULL )
    return;   */

    if ( ch->position < POS_SLEEPING )
    {
	send_to_char( "You can't see anything but stars!\n\r", ch );
	return;
    }

    if ( ch->position == POS_SLEEPING )
    {
	send_to_char( "You can't see anything, you're sleeping!\n\r", ch );
	return;
    }

    if ( !check_blind( ch ) )
	return;

    if ( !IS_NPC(ch)
    &&   !IS_SET(ch->act, PLR_HOLYLIGHT)
    &&   room_is_dark( ch->in_room ) )
    {
        send_to_char( "   It is pitch black ... \n\r", ch );
	show_char_to_char( ch->in_room->people, ch );
	return;
    }

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || !str_cmp( arg1, "auto" ) )
    {
	/* 'look' or 'look auto' */
    ansi_color( GREY, ch );
    ansi_color( BOLD, ch );

    send_to_char( ch->in_room->name, ch );
    send_to_char( "\n\r", ch );

    ansi_color( NTEXT, ch );
    ansi_color( GREY, ch );

	if ( arg1[0] == '\0'
    || ( !IS_NPC(ch) && !IS_SET(ch->act2, PLR_BRIEF) ) )
    {
        send_to_char( "   ", ch ); /* indent */
	    send_to_char( ch->in_room->description, ch );
    }

    ansi_color( BLUE, ch );

    if ( !IS_NPC(ch) && IS_SET(ch->act2, PLR_AUTOEXIT) )
        do_exits( ch, "auto" );

    ansi_color( NTEXT, ch );

/*    ansi_color( BOLD, ch ); */

	show_list_to_char( ch->in_room->contents, ch, FALSE, FALSE );
	show_char_to_char( ch->in_room->people,   ch );

    ansi_color( NTEXT, ch );

	return;
    }

    if ( !str_cmp( arg1, "i" ) || !str_cmp( arg1, "in" ) )
    {
	/* 'look in' */
	if ( arg2[0] == '\0' )
	{
	    send_to_char( "Look in what?\n\r", ch );
	    return;
	}

	if ( ( obj = get_obj_here( ch, arg2 ) ) == NULL )
	{
	    send_to_char( "You do not see that here.\n\r", ch );
	    return;
	}

	switch ( obj->item_type )
	{
	default:
	    send_to_char( "That is not a container.\n\r", ch );
	    break;

    case ITEM_LIGHT:
    if ( obj->value[1] != 0 )
    {
    int percent = PERCENTAGE( obj->value[0], obj->value[1] );

    if ( obj->value[0] <= 0 )
    {
         send_to_char( "It is empty.\n\r", ch );
         break;
    }
    else
    {
         sprintf( buf, "It's %s of lamp oil.\n\r",
         percent < 10 ? "almost empty"        :
         percent < 40 ? "less than half full" :
         percent < 60 ? "half full"           :
         percent < 90 ? "more than half"      : "full" );
         send_to_char( buf, ch );
    }

    }
    else send_to_char( "It contains nothing.\n\r", ch );
    break;
	case ITEM_DRINK_CON:
        if ( obj->value[0] <= 0 )
	    {
		send_to_char( "It is empty.\n\r", ch );
		break;
	    }
        else
        {
        int percent = PERCENTAGE( obj->value[0], obj->value[1] );

        if ( obj->value[2] == -1 )
           sprintf( buf, "It's %s of lamp oil.\n\r",
                    percent < 10 ? "almost empty"         :
                    percent < 40 ? "less than half full"  :
                    percent < 60 ? "half full"            :
                    percent < 70 ? "more than half full"  : 
                                   "full" );
      else sprintf( buf, "It's %s of a %s liquid.\n\r",
                    percent < 10 ? "almost empty"         :
                    percent < 40 ? "less than half full"  :
                    percent < 60 ? "half full"            :
                    percent < 70 ? "more than half full"  : 
                                   "full" ,
                    liq_table[obj->value[2]].liq_color );
        send_to_char( buf, ch );
        }
	    break;

	case ITEM_CONTAINER:
    case ITEM_CORPSE_NPC:
    case ITEM_CORPSE_PC:
	    if ( IS_SET(obj->value[1], CONT_CLOSED) )
	    {
		send_to_char( "It is closed.\n\r", ch );
		break;
	    }

	    act( "$p contains:", ch, obj, NULL, TO_CHAR );
	    show_list_to_char( obj->contains, ch, TRUE, TRUE );
	    break;
	}
	return;
    }

    if ( ( victim = get_char_room( ch, arg1 ) ) != NULL )
    {
	show_char_to_char_1( victim, ch );
	return;
    }

    for ( obj = ch->carrying; obj != NULL; obj = obj->next_content )
    {
	if ( can_see_obj( ch, obj ) )
	{
	    pdesc = get_extra_descr( arg1, obj->extra_descr );
	    if ( pdesc != NULL )
	    {
        page_to_char( pdesc, ch );
		return;
	    }

	    pdesc = get_extra_descr( arg1, obj->pIndexData->extra_descr );
	    if ( pdesc != NULL )
	    {
        page_to_char( pdesc, ch );
		return;
	    }
	}

    if ( is_name( arg1, STR(obj, name) ) )
	{
        send_to_char( STR(obj, description), ch );
	    return;
	}
    }

    for ( obj = ch->in_room->contents; obj != NULL; obj = obj->next_content )
    {
	if ( can_see_obj( ch, obj ) )
	{
	    pdesc = get_extra_descr( arg1, obj->extra_descr );
	    if ( pdesc != NULL )
	    {
        page_to_char( pdesc, ch );
		return;
	    }

	    pdesc = get_extra_descr( arg1, obj->pIndexData->extra_descr );
	    if ( pdesc != NULL )
	    {
        page_to_char( pdesc, ch );
		return;
	    }
	}

    if ( is_name( arg1, STR(obj, name) ) )
	{
        page_to_char( STR(obj, description), ch );
	    return;
	}
    }

    pdesc = get_extra_descr( arg1, ch->in_room->extra_descr );
    if ( pdesc != NULL )
    {
    page_to_char( pdesc, ch );
	return;
    }

    if ( ( door = get_dir( arg1 ) ) == MAX_DIR )
    {
	send_to_char( "You do not see that here.\n\r", ch );
	return;
    }

    /* 'look direction' */
    if ( ( pexit = ch->in_room->exit[door] ) == NULL )
    {
	send_to_char( "Nothing special there.\n\r", ch );
	return;
    }

    act( "$n glances $t.", ch, dir_name[door], NULL, TO_ROOM );

    if ( pexit->description != NULL && pexit->description[0] != '\0' )
	send_to_char( pexit->description, ch );
    else
	send_to_char( "Nothing special there.\n\r", ch );

    if ( pexit->keyword    != NULL
    &&   pexit->keyword[0] != '\0'
    &&   pexit->keyword[0] != ' ' )
    {
	if ( IS_SET(pexit->exit_info, EX_CLOSED) )
	{
        act( "The $T is closed.", ch, NULL, pexit->keyword, TO_CHAR );
	}
	else if ( IS_SET(pexit->exit_info, EX_ISDOOR) )
	{
        act( "The $T is open.",   ch, NULL, pexit->keyword, TO_CHAR );
	}
    }

    scan_direction( ch, door );

    return;
}



void do_examine( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Examine what?\n\r", ch );
	return;
    }

    do_look( ch, arg );

    if ( ( obj = get_obj_here( ch, arg ) ) != NULL )
    {
	switch ( obj->item_type )
	{
	default:
	    break;
    case ITEM_LIGHT:
         if( obj->value[1] )
         {
            int percent = PERCENTAGE( obj->value[0], obj->value[1] );

            sprintf( buf, "\n\r%s %s %s\n\r",
                          capitalize( STR(obj, short_descr) ),
                          is_are( STR(obj, short_descr) ),
             !IS_LIT(obj)  ? "extinguished." :
             percent <  10 ? "flickering and sputtering." :
             percent <  20 ? "flickering." :
             percent <  30 ? "flickering slightly." :
             percent <  40 ? "providing ample light." :
                             "glowing brightly." );
            send_to_char( buf, ch );
         }
        break;
    case ITEM_ARMOR:
                if( obj->value[1] )
                {
                   int percent;

                   percent = PERCENTAGE( obj->value[1], obj->value[2] );
                   sprintf( buf, "\n\r%s %s\n\r",
                                 capitalize( STR(obj, short_descr) ),
                    percent <  10 ? "is in pieces." :
                    percent <  20 ? "is nearly destroyed." :
                    percent <  30 ? "is heavily damaged." :
                    percent <  40 ? "is in poor shape." :
                    percent <  50 ? "looks worn." :
                    percent <  60 ? "is starting to look rather worn." :
                    percent <  70 ? "looks well used." :
                    percent <  80 ? "is slightly damaged." :
                    percent <  90 ? "is in fair shape." :
                    percent < 100 ? "is in good shape." :
                                    "looks excellent." );
                   send_to_char( buf, ch );
                }
                if ( TOO_BIG(ch, obj) )
                send_to_char( "It looks too big for you to wear.\n\r", ch );
           else if ( TOO_SMALL(ch, obj) )
                send_to_char( "It looks too small for you to wear.\n\r", ch );
           else send_to_char( "You could probably wear it.\n\r", ch );
     break;
    case ITEM_GEM:
                if( obj->value[1] )
                {
                   int percent;
                   percent = PERCENTAGE( obj->value[1], obj->value[2] );

                   sprintf( buf, "\n\r%s %s\n\r",
                                 capitalize( STR(obj, short_descr) ),
                    percent <  10 ? "is dimly flickering." :
                    percent <  20 ? "is slowly pulsating." :
                    percent <  30 ? "is quickly pulstating." :
                    percent <  40 ? "is glowing." :
                    percent <  50 ? "glows brightly." :
                    percent <  60 ? "radiates with energy." :
                                    "is radiant with blinding intensity." );
                   send_to_char( buf, ch );
                }
     break;
	case ITEM_DRINK_CON:
	case ITEM_CONTAINER:
	case ITEM_CORPSE_NPC:
	case ITEM_CORPSE_PC:
	    send_to_char( "When you look inside, you see:\n\r", ch );
	    sprintf( buf, "in %s", arg );
	    do_look( ch, buf );
	}
    }

    return;
}

void do_blank ( CHAR_DATA *ch, char *argument )
{
    ( IS_SET ( ch->act2, PLR_BLANK )
     ? do_config( ch, "-blank" )
     : do_config( ch, "+blank" ) );

}

void do_brief ( CHAR_DATA *ch, char *argument )
{

    ( IS_SET ( ch->act2, PLR_BRIEF )
     ? do_config( ch, "-brief" )
     : do_config( ch, "+brief" ) );

}

void do_combine ( CHAR_DATA *ch, char *argument )
{

    ( IS_SET ( ch->act2, PLR_COMBINE )
     ? do_config( ch, "-combine" )
     : do_config( ch, "+combine" ) );

}
 
void do_pagelen ( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    int lines;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
	lines = 20;
    else
	lines = atoi( arg );

    if ( lines < 1 )
    {
	send_to_char(
		"Negative or Zero values for a page pause is not legal.\n\r",
		     ch );
	return;
    }

    if ( lines > 500 )
    {
	send_to_char(
        "Can't set page length greater than 500.\n\r",
		     ch );
	return;
    }

    ch->pcdata->pagelen = lines;
    sprintf( buf, "Page pause set to %d lines.\n\r", lines );
    send_to_char( buf, ch );
    return;
}

/*
 * Allows a player to set their prompt (NPC or PC)
 * coded by Morgenes for Aldara Mud
 */
void do_prompt( CHAR_DATA *ch, char *argument )
{
   char buf[MAX_STRING_LENGTH];
   char buf2[MAX_STRING_LENGTH];

   if( argument[0] == '\0' )
   {
      if (!IS_SET(ch->act2, PLR_PROMPT))
      {
         send_to_char( "Prompt ON.\n\r", ch );
         SET_BIT(ch->act2, PLR_PROMPT);
      }
      else
      {
         REMOVE_BIT( ch->act2, PLR_PROMPT );
         send_to_char( "Prompt OFF.\n\r", ch );
      }
      return;
   }

   if( !strcmp( argument, "all" ) )
      strcpy( buf, "< %h %m > " );
   else
   {
      if ( strlen(argument) > 100 )
         argument[100] = '\0';
      strcpy( buf, argument );
      smash_tilde( buf );
   }

   free_string( ch->prompt );
   ch->prompt = str_dup( buf );
   sprintf( buf2, "Prompt set to '%s'.\n\r", ch->prompt );
   send_to_char( buf2, ch );

   if (!IS_SET(ch->act2, PLR_PROMPT))
         SET_BIT(ch->act2, PLR_PROMPT);

   return;
} 

/*
 * Thanks to Zrin for auto-exit part.
 */
void do_exits( CHAR_DATA *ch, char *argument )
{
    extern char * const dir_name[];
    char buf[MAX_STRING_LENGTH];
    EXIT_DATA *pexit;
    bool found;
    bool fAuto;
    int door;

    buf[0] = '\0';
    fAuto  = !str_cmp( argument, "auto" );

    if ( room_is_dark( ch->in_room ) ) 
      {
          if ( !fAuto ) 
          send_to_char( "It's too dark to see anything!\n\r", ch );
          return;
	}


    if ( !check_blind( ch ) )
	return;

    strcpy( buf, fAuto ? "[Exits:" : "Obvious exits:\n\r" );

    found = FALSE;
    for ( door = 0; door < MAX_DIR; door++ )
    {
	if ( ( pexit = ch->in_room->exit[door] ) != NULL
	&&   pexit->to_room != NULL
	&&   !IS_SET(pexit->exit_info, EX_CLOSED) )
	{
	    found = TRUE;
	    if ( fAuto )
	    {
		strcat( buf, " " );
		strcat( buf, dir_name[door] );
	    }
	    else
	    {
		sprintf( buf + strlen(buf), "%-5s - %s\n\r",
		    capitalize( dir_name[door] ),
		    room_is_dark( pexit->to_room )
			?  "Too dark to tell"
			: pexit->to_room->name
		    );
	    }
	}
    }

    if ( !found )
	strcat( buf, fAuto ? " none" : "None.\n\r" );

    if ( fAuto )
	strcat( buf, "]\n\r" );

    send_to_char( buf, ch );
    return;
}


#define STAT(func, str1, str2, str3, str4, str5)              \
                if (func(ch) <  7) sprintf(buf, str1 );       \
           else if (func(ch) < 14) sprintf(buf, str2 );       \
           else if (func(ch) < 18) sprintf(buf, str3 );       \
           else if (func(ch) < 21) sprintf(buf, str4 );       \
           else                    sprintf(buf, str5 );


void do_score( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    AFFECT_DATA *paf;
    int i;

    if ( IS_NPC(ch) )
    {
        int old;
        old         = FORCE_LEVEL;
        FORCE_LEVEL = MAX_LEVEL;
        do_mstat( ch, "self" );
        FORCE_LEVEL = old;
        return;
    }

    ansi_color( NTEXT, ch );

    sprintf( buf,
    "You are %s%s, %d years old (%d hours).\n\r",
    NAME(ch),
    ch->pcdata->title,
	get_age(ch),
    (get_age(ch) - 17) * 4 );
    send_to_char( buf, ch );

    sprintf( buf2, "%s",  race_table[ch->race].race_name );
    for ( i = 0; i < strlen(buf2); i++ )
     buf2[i] = LOWER(buf2[i]);

    sprintf( buf, "You are a %s of approximately %s sapling%s tall.\n\r",
                  buf2,
                  ch->size == ARMOR_MINUTE  ? "one half" :
                  ch->size == ARMOR_SMALL   ? "one" :
                  ch->size == ARMOR_PETITE  ? "one and one half" :
                  ch->size == ARMOR_AVERAGE ? "two" :
                  ch->size == ARMOR_MEDIUM  ? "two and one half" :
                  ch->size == ARMOR_LARGE   ? "three" :
                  ch->size == ARMOR_HUGE    ? "four" :
                  ch->size == ARMOR_TITANIC ? "five" :
                  ch->size == ARMOR_GARGANTUAN ? "six" : "unknown",
                  ch->size == ARMOR_SMALL   ? "" : "s" );
    send_to_char( buf, ch );

    if ( get_trust( ch ) != ch->level )
    {
    sprintf( buf, "You are trusted at level %d.\n\r", get_trust( ch ) );
	send_to_char( buf, ch );
    }

    sprintf( buf,
    "You are %s and %s, with %d practices, and %d learns.\n\r",
    STRING_HITS(ch),  STRING_MOVES(ch),
    ch->practice, ch->learn );
    send_to_char( buf, ch );

    sprintf( buf,
    "You are carrying %d items with a total of %d stones of weight.\n\r",
    ch->carry_number, ch->carry_weight );
    send_to_char( buf, ch );

    if (!IS_HERO(ch))
    sprintf( buf,"You have scored %d exp, and you need %d for level %d.\n\r",
             ch->exp, FIND_EXP(ch->level, ch->race) - ch->exp, ch->level+1 );
    else
    {
        switch ( ch->level )
        {
           default: sprintf( buf, "You're immortal."   ); break;
   case LEVEL_HERO: sprintf( buf, "You are an Avatar." ); break;
case LEVEL_BUILDER: sprintf( buf, "You are a Builder." ); break;
  case LEVEL_ANGEL: sprintf( buf, "You are an angel."  ); break;
case LEVEL_SUPREME: sprintf( buf, "You are supreme."   ); break;
case LEVEL_DEMIGOD: sprintf( buf, "You are a demigod." ); break;
    case MAX_LEVEL: sprintf( buf, "You're GOD, man."   ); break;
        }
    }
    
    send_to_char( buf, ch );

    if (IS_IMMORTAL(ch))
    {
        sprintf( buf, "  Building security: %d\n\r", ch->security );
        send_to_char( buf, ch );
    }
    
    if ( ch->level >= LEVEL_HERO )
    {
      sprintf( buf,
      "Str: %d  Int: %d  Wis: %d  Dex: %d  Con: %d.\n\r",
      get_curr_str(ch),
      get_curr_int(ch),
      get_curr_wis(ch),
      get_curr_dex(ch),
      get_curr_con(ch) );
      send_to_char( buf, ch );
   }

   send_to_char( "You are", ch );

   STAT(get_curr_str, " a feeble ",
                      " a fairly weak ",
                      " a hardened ",
                      " a muscular ",
                      " a mighty " );
   send_to_char( buf, ch );

   STAT(get_curr_int, "idiot",
                      "simpleton",
                      "person",
                      "thinker",
                      "genius" );
   send_to_char( buf, ch );

   STAT(get_curr_wis, " with a head like a hole.\n\r",
                      ".\n\r",
                      " with good common sense.\n\r",
                      " with a wise air about you.\n\r",
                      " with a perceptive mind.\n\r" );
   send_to_char( buf, ch );

   STAT(get_curr_dex, "You're lethargic and",
                      "You have average dexterity and",
                      "You are nimble and",
                      "You are quick and",
                      "You are like lightning and" );
   send_to_char( buf, ch );

   STAT(get_curr_con, " quite faint-hearted.\n\r",
                      " are of average health.\n\r",
                      " you are brazen.\n\r",
                      " you are healthy.\n\r",
                      " tough as a whip.\n\r" );
   send_to_char( buf, ch );

   sprintf( buf, "You are %s, %s and %s.\n\r",
        (ch->pcdata->condition[COND_DRUNK]  > 10) ? "drunk"    : "sober",
        (ch->pcdata->condition[COND_THIRST] > 10) ? "quenched" :
        (ch->pcdata->condition[COND_THIRST] >= 0) ? "thirsty"  : "dehydrated" ,
        (ch->pcdata->condition[COND_FULL] > 10) ? "full" :
        (ch->pcdata->condition[COND_FULL] >= 0) ? "hungry"  : "starving" );
   send_to_char( buf,  ch );

    switch ( ch->position )
    {
    case POS_DEAD:     send_to_char( "You are DEAD!!\n\r",             ch ); break;
    case POS_MORTAL:   send_to_char( "You are mortally wounded.\n\r",  ch ); break;
    case POS_INCAP:    send_to_char( "You are incapacitated.\n\r",     ch ); break;
    case POS_STUNNED:  send_to_char( "You are stunned.\n\r",           ch ); break;
    case POS_SLEEPING: send_to_char( "You are sleeping.\n\r",          ch ); break;
    case POS_RESTING:  send_to_char( "You are resting.\n\r",           ch ); break;
    case POS_STANDING: send_to_char( "You are standing.\n\r",          ch ); break;
    case POS_FIGHTING: send_to_char( "You are fighting.\n\r",          ch ); break;
            default: send_to_char( "You're fucked. (tell a god!)\n\r", ch ); break;
    }


    send_to_char( "Your attire is ", ch );
         if ( GET_AC(ch) >=  100 ) send_to_char( "your birthday suit! ", ch );
    else if ( GET_AC(ch) >=   80 ) send_to_char( "pathetic. ",     ch );
    else if ( GET_AC(ch) >=   60 ) send_to_char( "barely protective. ",  ch );
    else if ( GET_AC(ch) >=   40 ) send_to_char( "slightly protective. ", ch );
    else if ( GET_AC(ch) >=   20 ) send_to_char( "somewhat protective. ", ch );
    else if ( GET_AC(ch) >=    0 ) send_to_char( "protective. ",          ch );
    else if ( GET_AC(ch) >= - 20 ) send_to_char( "well protective. ",     ch );
    else if ( GET_AC(ch) >= - 40 ) send_to_char( "durable. ", ch );
    else if ( GET_AC(ch) >= - 60 ) send_to_char( "heavily durable. ",  ch );
    else if ( GET_AC(ch) >= - 80 ) send_to_char( "strongly durable. ", ch );
    else if ( GET_AC(ch) >= -100 ) send_to_char( "divinely durable. ", ch );
    else                           send_to_char( "invincible! ",       ch );

    if ( ch->level >= LEVEL_HERO )
    {
    sprintf( buf, "  (AC: %d)\n\r", GET_AC(ch) );
    send_to_char( buf, ch );
    }
    else
    send_to_char( "\n\r", ch );

    if ( ch->level >= LEVEL_HERO )
    {
    sprintf( buf, "Hitroll: %3d   Damroll: %3d\n\r",
	    GET_HITROLL(ch), GET_DAMROLL(ch) );
	send_to_char( buf, ch );
    }
    
    send_to_char( "Your attitudes are ", ch );
         if ( ch->alignment >  900 ) send_to_char( "angelic.", ch );
    else if ( ch->alignment >  700 ) send_to_char( "saintly.", ch );
    else if ( ch->alignment >  350 ) send_to_char( "good.",    ch );
    else if ( ch->alignment >  100 ) send_to_char( "kind.",    ch );
    else if ( ch->alignment > -100 ) send_to_char( "neutral.", ch );
    else if ( ch->alignment > -350 ) send_to_char( "unkind.",   ch );
    else if ( ch->alignment > -700 ) send_to_char( "evil.",    ch );
    else if ( ch->alignment > -900 ) send_to_char( "demented.", ch );
    else                             send_to_char( "satanistic.", ch );

    if ( ch->level >= LEVEL_HERO )
    {
    sprintf( buf, "  (Alignment: %d)\n\r", ch->alignment );
    send_to_char( buf, ch );
    }
    else
    send_to_char( "\n\r", ch );

    
    if ( ch->affected != NULL )
    {
    char final[MAX_STRING_LENGTH];

    final[0] = '\0';

	for ( paf = ch->affected; paf != NULL; paf = paf->next )
	{
        if ( ch->pcdata->learned[paf->type] < 50 ) continue;

        sprintf( buf, "%s", skill_table[paf->type].name );
        strcat( final, buf );

        if ( ch->level >= LEVEL_HERO )
	    {
        if (ch->level > LEVEL_HERO)
           sprintf( buf,
            " (modifies %s by %d for %d)\n\r",
		    affect_loc_name( paf->location ),
		    paf->modifier,
		    paf->duration );
          else
           sprintf( buf,
            ", which will wear off in %d hours.\n\r",
            paf->duration );
        strcat( final, buf );
	    }
        else strcat( final, "\n\r" );
	}

    if ( final[0] != '\0' )
    {
        send_to_char( "You are affected by:\n\r", ch );
        send_to_char( final, ch );
    }
    }
    return;
}



char *	const	day_name	[] =
{
    "the Great Hawk",
    "the Cougar",
    "the Fox",
    "the Titans",
    "the Many Tides",
    "the Sleeping Lamb",
    "the Sanctuary"
};

char *	const	month_name	[] =
{
    "the Darkening Madness",
    "Winter",
    "Midwinter",
    "the White Fox",
    "the Season of New Beginnings",
    "Spring",
    "the Season of Chaos",
    "the Season of Discord",
    "Grummet",
    "Midsummer",
    "the Equinox",
    "the Chilled Winds",
    "Indian Summer",
    "Darkenback",
    "Autumn",
    "the Changing Oak",
    "the Season of the Frost",
    "the Ancient Darkness",
    "the Freezing Spires"         /* 17 */
};

static char * const sky_look[8] =
{
    "cloudless",
	"cloudy",
	"rainy",
    "lit by flashes of lightning",
    "slightly overcast",
    "scattered with a few flakes",
    "filled with flakes",
    "a blizzard of white"
};

void do_time( CHAR_DATA *ch, char *argument )
{
    extern char str_boot_time[];
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    char descr[MAX_STRING_LENGTH];
    char *suf;
    sh_int wind;
    int day;

    one_argument( argument, arg );

    day     = time_info.day + 1;

         if ( day > 4 && day <  20 ) suf = "th";
    else if ( day % 10 ==  1       ) suf = "st";
    else if ( day % 10 ==  2       ) suf = "nd";
    else if ( day % 10 ==  3       ) suf = "rd";
    else                             suf = "th";

    sprintf( descr, "%d o'clock",
            (time_info.hour % 12 == 0) ? 12 : time_info.hour % 12 );

    sprintf( buf,
    "It is %s%s, Day of %s, the %d%s of %s, the year 453.\n\r",
        time_info.hour == 12 ? "noon" :
        time_info.hour == 0  ? "midnight" : descr,
        time_info.hour > 12 ? " in the morning" :
        time_info.hour < 12 &&
        time_info.hour > 0 ? " in the afternoon" : "",
        day_name[day % 7],
        day, suf,
        month_name[time_info.month]  );

    suf = format_string( /* str_dup( */ buf /*)*/ );
    send_to_char( suf, ch );
    free_string( suf );
        
    if ( !IS_OUTSIDE(ch) )
    {
	send_to_char( "You can't see the weather indoors.\n\r", ch );
    }
    else
    {
    wind = weather_info.windspeed;
    descr[0] = '\0';
    sprintf( buf, "The sky is %s ",
                  (time_info.month <= 4 || time_info.month >= 15) ?
                  sky_look[weather_info.sky+4] : sky_look[weather_info.sky] );
    strcat( descr, buf );
    sprintf( buf, "and a %s %sward %s blows.\n\r",
             (weather_info.temperature < 35) ? "cold" :
             (weather_info.temperature < 60) ? "cool" :
             (weather_info.temperature < 90) ? "warm" : "hot",
             dir_name[abs(weather_info.winddir) % 3],
             wind < 10 ? "breeze"   :
             wind < 20 ? "wind"     :
             wind < 30 ? "gust"     :
                         "torrent"    );
    strcat( descr, buf );

    if ( IS_IMMORTAL( ch ) && !str_cmp( arg, "full" ) )
    {
        sprintf( buf,
 "Temperature: %d\n\rWindspeed: %d\n\rDirection: %d\n\rSky: %d\n\rMMHG: %d\n\rChange: %d\n\r",
                      weather_info.temperature,
                      weather_info.windspeed,
                      weather_info.winddir,
                      weather_info.sky,
                      weather_info.mmhg,
                      weather_info.change );
        strcat( descr, buf );
    }

    send_to_char( descr, ch );
    }

    sprintf( buf, "The Isles started up at %s\r The system time is now %s\r\n\r",
        str_boot_time,
        (char *) ctime( &current_time )     );
    send_to_char( buf, ch );
    return;
}


void do_help( CHAR_DATA *ch, char *argument )
{
    char argall[MAX_INPUT_LENGTH];
    char argone[MAX_INPUT_LENGTH];
    HELP_DATA *pHelp;
    bool fLevel = FALSE;

    if ( argument[0] == '\0' )
	argument = "summary";

    /*
     * Tricky argument handling so 'help a b' doesn't match a.
     */
    argall[0] = '\0';
    while ( argument[0] != '\0' )
    {
	argument = one_argument( argument, argone );
	if ( argall[0] != '\0' )
	    strcat( argall, " " );
	strcat( argall, argone );
    }

    for ( pHelp = help_first; pHelp != NULL; pHelp = pHelp->next )
    {
	if ( pHelp->level > get_trust( ch ) )
        {
        fLevel = TRUE;
	    continue;
        }

	if ( is_name( argall, pHelp->keyword ) )
	{
	    if ( pHelp->level >= 0 && str_cmp( argall, "imotd" ) )
	    {
		send_to_char( pHelp->keyword, ch );
		send_to_char( "\n\r", ch );
	    }

	    /*
	     * Strip leading '.' to allow initial blanks.
	     */
	    if ( pHelp->text[0] == '.' )
        page_to_char( pHelp->text+1, ch );
	    else
        page_to_char( pHelp->text  , ch );
	    return;
	}
    }

    if ( !fLevel ) send_to_char( "No help on that word.\n\r", ch );
              else send_to_char( "You can't access that topic yet.\n\r", ch );
    return;
}



/*
 * New 'who' command originally by Alander of Rivers of Mud.
 * NEW 'who' command by Locke of The Isles.
 */
void do_who( CHAR_DATA *ch, char *argument )
{
    static int max = 0;
    char buf[MAX_STRING_LENGTH];
    DESCRIPTOR_DATA *d;
    int iLevelLower;
    int iLevelUpper;
    int nNumber;
    int nMatch;
    int gMatch;
    bool fImmortalOnly;

    /*
     * Set default arguments.
     */
    iLevelLower    = 0;
    iLevelUpper    = MAX_LEVEL;
    fImmortalOnly  = FALSE;

    /*
     * Parse arguments.
     */
    nNumber = 0;
    for ( ;; )
    {
	char arg[MAX_STRING_LENGTH];

	argument = one_argument( argument, arg );
	if ( arg[0] == '\0' )
	    break;

	if ( is_number( arg ) )
	{
	    switch ( ++nNumber )
	    {
	    case 1: iLevelLower = atoi( arg ); break;
	    case 2: iLevelUpper = atoi( arg ); break;
	    default:
		send_to_char( "Only two level numbers allowed.\n\r", ch );
		return;
	    }
	}
	else
	{
	    arg[3]    = '\0';
        if ( !str_prefix( arg, "immortal" ) )
	    {
		fImmortalOnly = TRUE;
	    }
        }
    }

    /*
     * Now show matching chars.
     */
    nMatch = 0;
    gMatch = 0;
    buf[0] = '\0';
    for ( d = descriptor_list; d != NULL; d = d->next )
    {
	CHAR_DATA *wch;

	/*
	 * Check for match against restrictions.
	 * Don't use trust as that exposes trusted mortals.
	 */
    if ( (d->connected != CON_PLAYING
       && d->connected != CON_AEDITOR
       && d->connected != CON_REDITOR
       && d->connected != CON_OEDITOR
       && d->connected != CON_MEDITOR)     || !can_see( ch, d->character ) )
        continue;

#ifdef NOWHO_BUILDERS
    if ( d->connected != CON_PLAYING && !IS_IMMORTAL(ch) ) continue;
#endif

	wch   = ( d->original != NULL ) ? d->original : d->character;
	if ( wch->level < iLevelLower
	||   wch->level > iLevelUpper
        || ( fImmortalOnly  && wch->level < LEVEL_HERO ) )
	    continue;

	/*
         * Format it up.
         */
         if (IS_HERO(wch) && wch->level == get_trust( wch ) )
         {
         char doe[MAX_STRING_LENGTH];
         gMatch++;

         if ( d->connected != CON_PLAYING )
              sprintf( doe, " Building  " );
         else
         {
         switch ( wch->level )
         {
                         default: sprintf( doe, " Immortal  " ); break;
                case LEVEL_HERO:  sprintf( doe, "  Avatar   " ); break;
                case LEVEL_ANGEL: sprintf( doe, "   Angel   " ); break;
              case LEVEL_SUPREME: sprintf( doe, "  Supreme  " ); break;
              case LEVEL_DEMIGOD: sprintf( doe, "  Demi-God " ); break;
                  case MAX_LEVEL: sprintf( doe, "*-  God  -*" ); break;
         }
         }
               sprintf( buf + strlen(buf), "[%11s] %s%s\n\r",
                  doe,  NAME(wch),   wch->pcdata->title );
        }
        else
        {
        nMatch++;
        sprintf( buf + strlen(buf), "[%6d     ] %s%s\n\r",
            wch->level,
            NAME(wch),
            wch->pcdata->title );
        }
    }
    ansi_color( BOLD, ch );
    send_to_char( buf, ch );
    ansi_color( NTEXT, ch );

    if (nMatch > 0)
    {
        sprintf( buf, "There %s %d visible player%s",
             nMatch > 1 ? "are" : "is",  nMatch,
             nMatch > 1 ? "s" : "" );
        send_to_char( buf, ch );
    }

    if (gMatch > 0)
    {
        if (nMatch > 0)
        sprintf( buf, " and %d visible god%s", gMatch,
                      gMatch == 1 ? "" : "s" );
        else
        sprintf( buf, "There %s %d visible god%s",
             gMatch > 1 ? "are" : "is",  gMatch,
             gMatch > 1 ? "s" : "" );

        send_to_char( buf, ch );
    }

    max = nMatch + gMatch > max ? nMatch + gMatch : max;
    sprintf( buf, ", with a high of %d.\n\r", max );
    send_to_char( buf, ch );
    return;
}



void do_inventory( CHAR_DATA *ch, char *argument )
{
    send_to_char( "Tucked away in the folds of your clothing is:\n\r", ch );
    show_list_to_char( ch->carrying, ch, TRUE, TRUE );
    return;
}



void do_equipment( CHAR_DATA *ch, char *argument )
{
    OBJ_DATA *obj;
    char buf[MAX_STRING_LENGTH];
    int iWear;
    bool found;

    send_to_char( "You are using:\n\r", ch );
    found = FALSE;
    for ( iWear = 0; iWear < MAX_WEAR; iWear++ )
    {
	if ( ( obj = get_eq_char( ch, iWear ) ) == NULL )
	    continue;

    sprintf( buf, "%-24s %s\n\r", where_name[iWear],
       can_see_obj( ch, obj ) ? format_obj_to_char( obj, ch, TRUE )
                              : "something" );
    send_to_char( buf, ch );
	found = TRUE;
    }

    if ( !found )
    send_to_char( "     Nothing.\n\r", ch );

    return;
}



void do_compare( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *obj1;
    OBJ_DATA *obj2;
    int value1;
    int value2;
    char *msg;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    if ( arg1[0] == '\0' )
    {
	send_to_char( "Compare what to what?\n\r", ch );
	return;
    }

    if ( ( obj1 = get_obj_inv( ch, arg1 ) ) == NULL )
    {
	send_to_char( "You do not have that item.\n\r", ch );
	return;
    }

    if ( arg2[0] == '\0' )
    {
	for ( obj2 = ch->carrying; obj2 != NULL; obj2 = obj2->next_content )
	{
	    if ( obj2->wear_loc != WEAR_NONE
	    &&   can_see_obj( ch, obj2 )
	    &&   obj1->item_type == obj2->item_type
	    && ( obj1->wear_flags & obj2->wear_flags & ~ITEM_TAKE) != 0 )
		break;
	}

	if ( obj2 == NULL )
	{
	    send_to_char( "You aren't wearing anything comparable.\n\r", ch );
	    return;
	}
    }
    else
    {
    if ( ( obj2 = get_obj_inv( ch, arg2 ) ) == NULL )
	{
	    send_to_char( "You do not have that item.\n\r", ch );
	    return;
	}
    }
	    
    msg		= NULL;
    value1	= 0;
    value2	= 0;

    if ( obj1 == obj2 )
    {
	msg = "You compare $p to itself.  It looks about the same.";
    }
    else if ( obj1->item_type != obj2->item_type )
    {
	msg = "You can't compare $p and $P.";
    }
    else
    {
	switch ( obj1->item_type )
	{
	default:
	    msg = "You can't compare $p and $P.";
	    break;

	case ITEM_ARMOR:
	    value1 = obj1->value[0];
	    value2 = obj2->value[0];
	    break;

	case ITEM_WEAPON:
        value1 = obj1->value[1] + obj1->value[2] / 2;
        value2 = obj2->value[1] + obj2->value[2] / 2;
	    break;
	}
    }

    if ( msg == NULL )
    {
	     if ( value1 == value2 ) msg = "$p and $P look about the same.";
	else if ( value1  > value2 ) msg = "$p looks better than $P.";
	else                         msg = "$p looks worse than $P.";
    }

    act( msg, ch, obj1, obj2, TO_CHAR );
    return;
}



void do_credits( CHAR_DATA *ch, char *argument )
{
    do_help( ch, "nimud" );
    return;
}



void do_where( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    DESCRIPTOR_DATA *d;
    bool found;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Players near you:\n\r", ch );
	found = FALSE;
	for ( d = descriptor_list; d; d = d->next )
	{
       if ( ( victim = d->character ) != NULL
       &&   !IS_NPC(victim)
       &&   victim->in_room != NULL
       &&   can_see( ch, victim ) )
       {
       if ( IS_HERO(ch) )
       {
          found = TRUE;
         sprintf( buf, "%-28s %s [%d]\n\r", NAME(victim), victim->in_room->name, victim->in_room->vnum );
         send_to_char( buf, ch );
       }
       else
       if ( d->connected == CON_PLAYING )
       {
          found = TRUE;
         if  ( victim->in_room->area == ch->in_room->area )
          sprintf( buf, "%-28s %s\n\r", NAME(victim), victim->in_room->name );
         else buf[0] = '\0';
          send_to_char( buf, ch );
       }
       }
	}
	if ( !found )
        send_to_char( "No one can be found.\n\r", ch );
    }
    else
    {
	found = FALSE;
	for ( victim = char_list; victim != NULL; victim = victim->next )
	{
	    if ( victim->in_room != NULL
	    &&   victim->in_room->area == ch->in_room->area
	    &&   !IS_AFFECTED(victim, AFF_HIDE)
	    &&   !IS_AFFECTED(victim, AFF_SNEAK)
	    &&   can_see( ch, victim )
        &&   is_name( arg, STR(victim, name) ) )
	    {
		found = TRUE;
		sprintf( buf, "%-28s %s\n\r",
		    PERS(victim, ch), victim->in_room->name );
		send_to_char( buf, ch );
		break;
	    }
	}
	if ( !found )
	    act( "You didn't find any $T.", ch, NULL, arg, TO_CHAR );
    }

    return;
}


void do_consider( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    char *msg = '\0';
    char *buf = '\0';
    int diff;
    int hpdiff;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Consider killing whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, arg ) ) == NULL )
    {
	send_to_char( "They're not here.\n\r", ch );
	return;
    }

    if ( IS_IMMORTAL( victim ) )
    {
	send_to_char( "The gods do not accept this type of sacrafice.\n\r",
		     ch );
	return;
    }

    diff = victim->level - ch->level;

         if ( diff <= -10 ) msg = "$N is no threat.";
    else if ( diff <=  -4 ) msg = "$N is no match for you.";
    else if ( diff <=  -2 ) msg = "$N may be able to hold its own.";
    else if ( diff <=   1 ) msg = "The perfect match!";
    else if ( diff <=   3 ) msg = "$N could pose a threat.";
    else if ( diff <=   5 ) msg = "$N would have little trouble defending $mself.";
    else if ( diff <=   7 ) msg = "$N is much more powerful than you.";
    else if ( diff <=   9 ) msg = "$N would be a deadly opponent.";
    else                    msg = "$N could kill you without batting an eye.";

    act( msg, ch, NULL, victim, TO_CHAR );

    /* additions by king@tinuviel.cs.wcu.edu */
    hpdiff = ( ch->hit - victim->hit );

    if ( ( ( diff >= 0) && ( hpdiff <= 0 ) )
	|| ( ( diff <= 0 ) && ( hpdiff >= 0 ) ) )
    {
        send_to_char( "Also,", ch );
    }
    else
    {
        send_to_char( "However,", ch );
    }

 if ( hpdiff >= 101 ) buf = " you are currently much healthier than $E.";
 if ( hpdiff <= 100 ) buf = " you are currently healthier than $E.";
 if ( hpdiff <= 50 )  buf = " you are currently slightly healthier than $E.";
 if ( hpdiff <= 25 )  buf = " you are a teensy bit healthier than $E.";
 if ( hpdiff <= 0 )   buf = " $E is a teensy bit healthier than you.";
 if ( hpdiff <= -25 ) buf = " $E is slightly healthier than you.";
 if ( hpdiff <= -50 ) buf = " $E is healthier than you.";
 if ( hpdiff <= -100 )buf = " $E is much healthier than you.";

    act( buf, ch, NULL, victim, TO_CHAR );
    return;
}



void set_title( CHAR_DATA *ch, char *title )
{
    char buf[MAX_STRING_LENGTH];

    if ( IS_NPC(ch) )
    {
	bug( "Set_title: NPC.", 0 );
	return;
    }

    if ( isalpha(title[0]) || isdigit(title[0]) )
    {
	buf[0] = ' ';
	strcpy( buf+1, title );
    }
    else
    {
	strcpy( buf, title );
    }

    free_string( ch->pcdata->title );
    ch->pcdata->title = str_dup( buf );
    return;
}



void do_title( CHAR_DATA *ch, char *argument )
{
    if ( IS_NPC(ch) )
	return;

    if ( argument[0] == '\0' )
    {
	send_to_char( "Change your title to what?\n\r", ch );
	return;
    }

    if ( strlen(argument) > 50 )
	argument[50] = '\0';

    smash_tilde( argument );
    set_title( ch, argument );
    send_to_char( "Ok.\n\r", ch );
}



void do_description( CHAR_DATA *ch, char *argument )
{
    string_append( ch, &ch->description );
    return;
}



void do_report( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_INPUT_LENGTH];

    sprintf( buf,
    "You report that you are %s and %s.\n\r",
    STRING_HITS(ch), STRING_MOVES(ch)  );
    send_to_char( buf, ch );

    sprintf( buf, "$n reports that $e is %s and %s.",
    STRING_HITS(ch), STRING_MOVES(ch) );
    act( buf, ch, NULL, NULL, TO_ROOM );

    return;
}

char *how_good(int percent)
{
  static char buf[256];
  
  if (percent == 0)           strcpy(buf, "(horrid)");
  else if (percent <= 10)     strcpy(buf, "(awful)");
  else if (percent <= 20)     strcpy(buf, "(bad)");
  else if (percent <= 40)     strcpy(buf, "(poor)");
  else if (percent <= 55)     strcpy(buf, "(average)");
  else if (percent <= 70)     strcpy(buf, "(fair)");
  else if (percent <= 80)     strcpy(buf, "(good)");
  else if (percent <= 85)     strcpy(buf, "(great)");
  else                        strcpy(buf, "(superb)");
  
  return (buf);
}

void do_learn( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    int sn;
    int skl;

    if ( IS_NPC(ch) )
	return;

    skl    = 0;
	for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
	    if ( skill_table[sn].name == NULL )
		break;

        if ( ch->pcdata->learned[sn] != 0 )  skl++;
    }

    if ( argument[0] == '\0' )
    {
	int col;

    col    = 0;
	for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
	    if ( skill_table[sn].name == NULL )
		break;
        if ( ch->level < skill_table[sn].skill_level[ch->class]
          || ch->pcdata->learned[sn] != 0 )
		continue;

        sprintf( buf, "%24s ", skill_table[sn].name );
	    send_to_char( buf, ch );
        if ( ++col % 3 == 0 )
		send_to_char( "\n\r", ch );

    }

	if ( col % 3 != 0 )
	    send_to_char( "\n\r", ch );

    sprintf( buf, "You have %d learning sessions left.\n\rYou may learn %d more skills/spells in your lifetime.\n\r",
        ch->learn, race_table[ch->race].max_skills - skl );
	send_to_char( buf, ch );
    }
    else
    {
	CHAR_DATA *mob;
	int adept;

	if ( !IS_AWAKE(ch) )
	{
	    send_to_char( "In your dreams, or what?\n\r", ch );
	    return;
	}

	for ( mob = ch->in_room->people; mob != NULL; mob = mob->next_in_room )
	{
	    if ( IS_NPC(mob) && IS_SET(mob->act, ACT_PRACTICE) )
		break;
	}

	if ( mob == NULL )
	{
	    send_to_char( "You can't do that here.\n\r", ch );
	    return;
	}

    if ( skl >= race_table[ch->race].max_skills )
	{
        send_to_char( "You have already learned the maximum skills for your race.\n\r", ch );
	    return;
	}

    if ( ch->learn <= 0 )
	{
        send_to_char( "You have no learning sessions left.\n\r", ch );
	    return;
	}

    if ( ( sn = skill_lookup( argument ) ) < 0
	|| ( !IS_NPC(ch)
    &&   ch->level < skill_table[sn].skill_level[ch->class] ) )
	{
        send_to_char( "You can't learn that.\n\r", ch );
	    return;
	}

	adept = IS_NPC(ch) ? 100 : class_table[ch->class].skill_adept;

    if ( ch->pcdata->learned[sn] != 0 )
	{
        sprintf( buf, "You already know %s.\n\r", skill_table[sn].name );
	    send_to_char( buf, ch );
	}
	else
	{
        ch->learn--;
        ch->pcdata->learned[sn] = 1;
        act( "You learn $T.",
		    ch, NULL, skill_table[sn].name, TO_CHAR );
        act( "$n learns $T.",
		    ch, NULL, skill_table[sn].name, TO_ROOM );
	}
    }
    return;
}



void do_practice( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char final[MAX_STRING_LENGTH];
    int sn;

    if ( IS_NPC(ch) )
	return;

    if ( argument[0] == '\0' )
    {
        int col;
        
        final[0] = '\0';

	col    = 0;
	for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
	    if ( skill_table[sn].name == NULL )
		break;
        if ( (ch->level < skill_table[sn].skill_level[ch->class])
          || (ch->pcdata->learned[sn] == 0) )
		continue;

        if (ch->level >= LEVEL_HERO )
          sprintf( buf, "%23s%c %3d%%  ", skill_table[sn].name,
                           skill_table[sn].spell_fun != spell_null ? '*' : ' ',
                                        ch->pcdata->learned[sn] );
        else
          sprintf( buf, " %28s%10s", skill_table[sn].name,
                                     how_good(ch->pcdata->learned[sn]) );
        strcat( final, buf );
        if ( ++col % 2 == 0 )
        strcat( final, "\n\r" );

	}

    if ( col % 2 != 0 )
        strcat( final, "\n\r" );

	sprintf( buf, "You have %d practice sessions left.\n\r",
	    ch->practice );
    send_to_char( final, ch );
	send_to_char( buf, ch );
    }
    else
    {
	CHAR_DATA *mob;
	int adept;

	if ( !IS_AWAKE(ch) )
	{
	    send_to_char( "In your dreams, or what?\n\r", ch );
	    return;
	}

	for ( mob = ch->in_room->people; mob != NULL; mob = mob->next_in_room )
	{
	    if ( IS_NPC(mob) && IS_SET(mob->act, ACT_PRACTICE) )
		break;
	}

	if ( mob == NULL )
	{
	    send_to_char( "You can't do that here.\n\r", ch );
	    return;
	}

	if ( ch->practice <= 0 )
	{
	    send_to_char( "You have no practice sessions left.\n\r", ch );
	    return;
	}

	if ( ( sn = skill_lookup( argument ) ) < 0
	|| ( !IS_NPC(ch)
    &&   (ch->level < skill_table[sn].skill_level[ch->class] ||
          ch->pcdata->learned[sn] <= 0) ) )
	{
	    send_to_char( "You can't practice that.\n\r", ch );
	    return;
	}

	adept = IS_NPC(ch) ? 100 : class_table[ch->class].skill_adept;

	if ( ch->pcdata->learned[sn] >= adept )
	{
	    sprintf( buf, "You are already an adept of %s.\n\r",
		skill_table[sn].name );
	    send_to_char( buf, ch );
	}
	else
	{
	    ch->practice--;
        ch->pcdata->learned[sn] += UMIN(int_app[get_curr_int(ch)].learn,
                                        skill_table[sn].max_prac);
	    if ( ch->pcdata->learned[sn] < adept )
	    {
		act( "You practice $T.",
		    ch, NULL, skill_table[sn].name, TO_CHAR );
		act( "$n practices $T.",
		    ch, NULL, skill_table[sn].name, TO_ROOM );
	    }
	    else
	    {
		ch->pcdata->learned[sn] = adept;
		act( "You are now an adept of $T.",
		    ch, NULL, skill_table[sn].name, TO_CHAR );
		act( "$n is now an adept of $T.",
		    ch, NULL, skill_table[sn].name, TO_ROOM );
	    }
	}
    }
    return;
}





void do_password( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char *pArg;
    char *pwdnew;
    char *p;
    char cEnd;

    if ( IS_NPC(ch) )
	return;

    /*
     * Can't use one_argument here because it smashes case.
     * So we just steal all its code.  Bleagh.
     */
    pArg = arg1;
    while ( isspace(*argument) )
	argument++;

    cEnd = ' ';
    if ( *argument == '\'' || *argument == '"' )
	cEnd = *argument++;

    while ( *argument != '\0' )
    {
	if ( *argument == cEnd )
	{
	    argument++;
	    break;
	}
	*pArg++ = *argument++;
    }
    *pArg = '\0';

    pArg = arg2;
    while ( isspace(*argument) )
	argument++;

    cEnd = ' ';
    if ( *argument == '\'' || *argument == '"' )
	cEnd = *argument++;

    while ( *argument != '\0' )
    {
	if ( *argument == cEnd )
	{
	    argument++;
	    break;
	}
	*pArg++ = *argument++;
    }
    *pArg = '\0';

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
	send_to_char( "Syntax: password <old> <new>.\n\r", ch );
	return;
    }

    if ( strcmp( crypt( arg1, ch->pcdata->pwd ), ch->pcdata->pwd ) )
    {
	WAIT_STATE( ch, 40 );
	send_to_char( "Wrong password.  Wait 10 seconds.\n\r", ch );
	return;
    }

    if ( strlen(arg2) < 5 )
    {
	send_to_char(
	    "New password must be at least five characters long.\n\r", ch );
	return;
    }

    /*
     * No tilde allowed because of player file format.
     */
    pwdnew = crypt( arg2, NAME(ch) );
    for ( p = pwdnew; *p != '\0'; p++ )
    {
	if ( *p == '~' )
	{
	    send_to_char(
		"New password not acceptable, try again.\n\r", ch );
	    return;
	}
    }

    free_string( ch->pcdata->pwd );
    ch->pcdata->pwd = str_dup( pwdnew );
    save_char_obj( ch );
    send_to_char( "Ok.\n\r", ch );
    return;
}



void do_socials( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    int iSocial;
    int col;
 
    col = 0;
    for ( iSocial = 0; social_table[iSocial].name[0] != '\0'; iSocial++ )
    {
	sprintf( buf, "%-12s", social_table[iSocial].name );
	send_to_char( buf, ch );
	if ( ++col % 6 == 0 )
	    send_to_char( "\n\r", ch );
    }
 
    if ( col % 6 != 0 )
	send_to_char( "\n\r", ch );
    return;
}



/*
 * Contributed by Alander.
 */
void do_commands( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    int cmd;
    int col;
 
    col = 0;
    for ( cmd = 0; cmd_table[cmd].name[0] != '\0'; cmd++ )
    {
        if ( cmd_table[cmd].level <  LEVEL_HERO
        &&   cmd_table[cmd].level <= get_trust( ch )
        &&   cmd_table[cmd].level >=  0 )
	{
	    sprintf( buf, "%-12s", cmd_table[cmd].name );
	    send_to_char( buf, ch );
	    if ( ++col % 6 == 0 )
		send_to_char( "\n\r", ch );
	}
    }
 
    if ( col % 6 != 0 )
	send_to_char( "\n\r", ch );
    return;
}



void do_channels( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	if ( !IS_NPC(ch) && IS_SET(ch->act, PLR_SILENCE) )
	{
	    send_to_char( "You are silenced.\n\r", ch );
	    return;
	}

	send_to_char( "Channels:", ch );

	send_to_char( !IS_SET(ch->deaf, CHANNEL_AUCTION)
	    ? " +AUCTION"
	    : " -auction",
	    ch );

    send_to_char( !IS_SET(ch->deaf, CHANNEL_GOSSIP)
        ? " +GOSSIP"
        : " -gossip",
	    ch );

	if ( IS_HERO(ch) )
	{
	    send_to_char( !IS_SET(ch->deaf, CHANNEL_IMMTALK)
		? " +IMMTALK"
		: " -immtalk",
		ch );
	}
    }
    else
    {
	bool fClear;
	int bit;

	     if ( arg[0] == '+' ) fClear = TRUE;
	else if ( arg[0] == '-' ) fClear = FALSE;
	else
	{
	    send_to_char( "Channels -channel or +channel?\n\r", ch );
	    return;
	}

         if ( !str_prefix( arg+1, "auction"  ) ) bit = CHANNEL_AUCTION;
    else if ( !str_prefix( arg+1, "gossip"   ) ) bit = CHANNEL_GOSSIP;
    else if ( !str_prefix( arg+1, "immtalk"  ) ) bit = CHANNEL_IMMTALK;
	else
	{
	    send_to_char( "Set or clear which channel?\n\r", ch );
	    return;
	}

	if ( fClear )
	    REMOVE_BIT (ch->deaf, bit);
	else
	    SET_BIT    (ch->deaf, bit);

	send_to_char( "Ok.\n\r", ch );
    }

    return;
}


void do_auto( CHAR_DATA *ch, char *argument )
{  do_config( ch, "" );   return;  }

void do_autoloot( CHAR_DATA *ch, char *argument )
{ do_config( ch, "autoloot" );  return; }

void do_autosac( CHAR_DATA *ch, char *argument )
{ do_config( ch, "autosac" );  return; }

void do_autoexit( CHAR_DATA *ch, char *argument )
{ do_config( ch, "autoexit" ); return; }

void do_autogold( CHAR_DATA *ch, char *argument )
{ do_config( ch, "autogold" );   return; }

void do_autosplit( CHAR_DATA *ch, char *argument )
{ do_config( ch, "autosplit" );  return; }

void do_assist( CHAR_DATA *ch, char *argument )
{ do_config( ch, "assist" );    return; }


char * const color_name [] =
{
  "AUCTION",
  "GOSSIP",
  "SHOUT",
  "IMMTALK",
  "SAY",
  "TELL"
};
  

void do_ansi( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char arg1[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    int c;
    int c2;

    if ( IS_NPC(ch) )
	return;

    argument = one_argument( argument, arg );
    strcpy( arg1, argument );

    if ( !str_cmp( arg, "toggle" ) ) { do_config( ch, "ansi" ); return; }

    if ( arg[0] == '\0' )
    {
      if ( IS_SET( ch->act2, PLR_ANSI ) )
      for ( c = 0; c < COLOR_UNUSED6; c++ )
      {
        sprintf( buf, "%s%10ss will appear in %s%s%s\n\r",
                      color_table[19].code,
                      color_name[c],
                      color_table[ch->colors[c]].code,
                      color_table[ch->colors[c]].name,
                      color_table[19].code );
        send_to_char( buf, ch );
      };
      send_to_char( "To toggle ANSI, type 'config ansi'.  Type HELP ANSI for more help.\n\r", ch );
      return;
    };

    for ( c = 0; c < MAX_COLORS; c++ )
    {
       if ( !str_cmp( arg, color_name[c] ) )
       break;
    };

    if ( !is_number( arg1 ) )
    {
       for ( c2 = 0; c2 < 20; c2++ )
       {
          if ( !str_cmp( arg1, color_table[c2].name ) )
          break;
       }
    }
    else c2 = atoi( arg1 );

    sprintf( buf, "Invalid color index.\n\r" );

    if ((c < MAX_COLORS) && (c >= 0) && (c2 < 20) && (c2 >= 0))
    {
        ch->colors[c] = c2;
        sprintf( buf, "Set %s color to %s%s%s.\n\r", color_name[c],
                                                   color_table[c2].code,
                                                   color_table[c2].name,
                                                   NTEXT );
    };

    send_to_char( buf, ch );
    return;
}

/*
 * Contributed by Grodyn.
 */
void do_config( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];

    if ( IS_NPC(ch) )
	return;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        send_to_char( "[ Keyword  ] Option\n\r", ch );

if ( IS_IMMORTAL(ch) )
{
    send_to_char(  IS_SET(ch->act2, PLR_AUTOEXIT)
        ? "[*AUTOEXIT ] You automatically see exits.\n\r"
        : "[ autoexit ] You don't automatically see exits.\n\r"
        , ch );

    send_to_char(  IS_SET(ch->act2, PLR_AUTOLOOT)
        ? "[*AUTOLOOT ] You automatically loot corpses.\n\r"
        : "[ autoloot ] You don't automatically loot corpses.\n\r"
        , ch );

    send_to_char(  IS_SET(ch->act2, PLR_AUTOSAC)
        ? "[*AUTOSAC  ] You automatically sacrifice corpses.\n\r"
        : "[ autosac  ] You don't automatically sacrifice corpses.\n\r"
        , ch );

    send_to_char(  IS_SET(ch->act2, PLR_AUTOGOLD)
        ? "[*AUTOGOLD ] You automatically loot gold from corpses.\n\r"
        : "[ autogold ] You don't automatically loot gold from corpses.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_AUTOSPLIT)
        ? "[*AUTOSPLIT] You automatically split gold looted from corpses.\n\r"
        : "[ autosplit] You don't automatically split gold looted from corpses.\n\r"
	    , ch );
}

    send_to_char(  IS_SET(ch->act2, PLR_ASSIST)
        ? "[*ASSIST   ] You automatically assist your group in combat.\n\r"
        : "[ assist   ] You don't automatically assist your group in combat.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_BLANK)
        ? "[*BLANK    ] You have a blank line before your prompt.\n\r"
        : "[ blank    ] You have no blank line before your prompt.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_BRIEF)
        ? "[*BRIEF    ] You see brief descriptions.\n\r"
        : "[ brief    ] You see long descriptions.\n\r"
	    , ch );
         
    send_to_char(  IS_SET(ch->act2, PLR_COMBINE)
        ? "[*COMBINE  ] You see object lists in combined format.\n\r"
        : "[ combine  ] You see object lists in single format.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_PROMPT)
        ? "[*PROMPT   ] You have a prompt.\n\r"
        : "[ prompt   ] You don't have a prompt.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_ANSI)
        ? "[*ANSI     ] You receive ansi color codes.\n\r"
        : "[ ansi     ] You don't receive ansi color codes.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_TELNET_GA)
        ? "[*TELNETGA ] You receive a telnet GA sequence.\n\r"
        : "[ telnetga ] You don't receive a telnet GA sequence.\n\r"
	    , ch );

    send_to_char(  IS_SET(ch->act2, PLR_SILENCE)
        ? "[*SILENCE  ] You are silenced.\n\r"
	    : ""
	    , ch );

    send_to_char( !IS_SET(ch->act2, PLR_NO_EMOTE)
	    ? ""
        : "[ emote    ] You can't emote.\n\r"
	    , ch );

    send_to_char( !IS_SET(ch->act2, PLR_NO_TELL)
	    ? ""
        : "[ tell     ] You can't use 'tell'.\n\r"
	    , ch );

    send_to_char( IS_SET(ch->act, PLR_HOLYLIGHT ) && IS_IMMORTAL(ch)
        ? "[*HOLYLITE ] You are using holylight.\n\r"
        : ""
	    , ch );

    }
    else
    {
    char arg2[MAX_STRING_LENGTH];
	bool fSet;
	int bit;

    fSet = arg[0] == '+';
    if ( arg[0] == '-' || arg[0] == '+' )
    {
                sprintf( arg2, "%c", arg[0] );
                sprintf( arg, "%s", arg+1 );
    }

         if ( !str_cmp( arg, "autoexit" ) && IS_IMMORTAL(ch) )
                                              bit = PLR_AUTOEXIT;
    else if ( !str_cmp( arg, "autoloot" ) && IS_IMMORTAL(ch) )
                                              bit = PLR_AUTOLOOT;
    else if ( !str_cmp( arg, "autosac"  ) && IS_IMMORTAL(ch) )
                                              bit = PLR_AUTOSAC;
    else if ( !str_cmp( arg, "autogold" ) && IS_IMMORTAL(ch) )
                                              bit = PLR_AUTOGOLD;
    else if ( !str_cmp( arg, "assist"   ) ) bit = PLR_ASSIST;
    else if ( !str_cmp( arg, "autosplit") ) bit = PLR_AUTOSPLIT;
    else if ( !str_cmp( arg, "blank"    ) ) bit = PLR_BLANK;
    else if ( !str_cmp( arg, "brief"    ) ) bit = PLR_BRIEF;
    else if ( !str_cmp( arg, "combine"  ) ) bit = PLR_COMBINE;
    else if ( !str_cmp( arg, "prompt"   ) ) bit = PLR_PROMPT;
    else if ( !str_cmp( arg, "ansi"     ) ) bit = PLR_ANSI;
    else if ( !str_cmp( arg, "telnetga" ) ) bit = PLR_TELNET_GA;
	else
	{
	    send_to_char( "Config which option?\n\r", ch );
	    return;
	}

        if ( fSet )
        {
            sprintf( buf, "Enabled.\n\r" );
            SET_BIT    (ch->act2, bit);
        }
        else
        if ( !fSet && arg2[0] == '-' )
        {
            sprintf( buf, "Disabled.\n\r" );
            REMOVE_BIT (ch->act2, bit);
        }
        else
        {
            if (IS_SET(ch->act2, bit))
            {
            sprintf( buf, "Disabled.\n\r" );
            REMOVE_BIT (ch->act2, bit);
            }
            else
            {
            sprintf( buf, "Enabled.\n\r" );
            SET_BIT    (ch->act2, bit);
            }
        }

    send_to_char( buf, ch );
    }

    return;
}


void do_wizlist ( CHAR_DATA *ch, char *argument )
{

    do_help ( ch, "wizlist" );
    return;

}



void do_levels( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char final[MAX_STRING_LENGTH];
    int x;

    sprintf( final, "    Lvl Exp\n\r" );

    for ( x = 0; x <= LEVEL_HERO; x++ )
    {
    if ( ch->level == x )
    {
    sprintf( buf, "Level %2d %14d <-- This is your current level.\n\r", x,
             FIND_EXP(x, ch->race) );
    }
    else
    {
    sprintf( buf, "Level %2d %14d\n\r", x, FIND_EXP(x, ch->race) );
    }
    strcat( final, buf );
    }

    page_to_char( final, ch );

    return;
}



char *   const  wp_name [] =
{
    "miscellaneous",
    "edged",
    "thrusting",
    "whip",
    "fragmentation",
    "bludgeon",
    "exotic",
    "ranged"
};


#define WP(sn)   ( (IS_NPC(ch) ? ch->level : ch->pcdata->profs[sn]) )

void do_skills( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char final[MAX_STRING_LENGTH];
    int col;
    int sn;

    final[0] = '\0';
    col = 0;
    send_to_char( "Skills:\n\r", ch );
    for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
	    if ( skill_table[sn].name == NULL )
		break;
        if ( (ch->level < skill_table[sn].skill_level[ch->class])
          || (ch->pcdata->learned[sn] == 0)
          || (skill_table[sn].spell_fun != spell_null) )
		continue;

        sprintf( buf, " %28s%10s", skill_table[sn].name,
                                   how_good(ch->pcdata->learned[sn]) );
        strcat( final, buf );
        if ( ++col % 2 == 0 )
        strcat( final, "\n\r" );
    }
    page_to_char( final, ch );

    send_to_char( "\n\rWeapon proficiencies:\n\r", ch );
    for ( sn = 0; sn < WP_MAX; sn++ )
    {
    sprintf( buf, "Your %s performance is %s.\n\r", wp_name[sn],
             WP(sn) <= 1 ? "nominal"  :
             WP(sn) < 10 ? "beginner" :
             WP(sn) < 20 ? "intermediate" :
             WP(sn) < 30 ? "advanced" :
             WP(sn) < 40 ? "expert"   :
                           "mastered"            );
    send_to_char( buf, ch );
    }

    return;
}

#undef WP

void do_spells( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char final[MAX_STRING_LENGTH];
    int col;
    int sn;

    final[0] = '\0';
    col = 0;
    send_to_char( "Spells:\n\r", ch );
    for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
        if ( skill_table[sn].name == NULL )
		break;

        if ( (ch->level < skill_table[sn].skill_level[ch->class])
          || (ch->pcdata->learned[sn] == 0)
          || (skill_table[sn].spell_fun == spell_null) )
		continue;

        sprintf( buf, " %38s%10s %s\n\r", skill_table[sn].name,
                      how_good(ch->pcdata->learned[sn]),
                      skill_table[sn].mana_type == MANA_AIR   ? "(air)   " :
                      skill_table[sn].mana_type == MANA_FIRE  ? "(fire)  " :
                      skill_table[sn].mana_type == MANA_WATER ? "(water) " :
                      skill_table[sn].mana_type == MANA_EARTH ? "(earth) " :
                      skill_table[sn].mana_type == MANA_ANY   ? "(any)   " :
                                                                "(other) " );
        strcat( final, buf );
    }
    page_to_char( final, ch );

    return;
}

