/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "merc.h"



char *	const	dir_name	[]		=
{
    "north", "east", "south", "west", "up", "down", 
    "northwest", "northeast", "southwest", "southeast"
};

char *  const   dir_rev     []      =
{
    "the south", "the west", "the north", "the east", "below", "above",
    "southeast", "southwest", "northeast", "northwest"
};

const	sh_int	rev_dir		[]		=
{
    DIR_SOUTH,
    DIR_WEST,
    DIR_NORTH,
    DIR_EAST,
    DIR_DOWN,
    DIR_UP,
    DIR_SE,
    DIR_SW,
    DIR_NE,
    DIR_NW   
};

const	sh_int	movement_loss	[SECT_MAX]	=
{
    1, 2, 2, 3, 4, 6, 4, 1, 6, 10, 6
};



/*
 * Local functions.
 */
int     find_door   args( ( CHAR_DATA *ch, char *arg ) );
OBJ_DATA *has_key		args( ( CHAR_DATA *ch, int key ) );

char * get_direction( char *arg )
{
    switch ( LOWER(arg[0]) )
      {
      case 'n': 
      {
            if ( LOWER(arg[1]) == 'w' ) return "northwest";
            if ( LOWER(arg[1]) == 'e' ) return "northeast";
            if ( LOWER(arg[5]) == 'w' ) return "northwest";
            if ( LOWER(arg[5]) == 'e' ) return "northeast";
            return "north";
	  }
      case 's':
      {
            if ( LOWER(arg[1]) == 'w' ) return "southwest";
            if ( LOWER(arg[1]) == 'e' ) return "southeast";
            if ( LOWER(arg[5]) == 'w' ) return "southwest";
            if ( LOWER(arg[5]) == 'e' ) return "southeast";
            return "south";
	  }
      case 'e': return "east";
      case 'w': return "west";
      case 'u': return "up";
      case 'd': return "down";
      }
 
    return "anywhere";
}




void move_char( CHAR_DATA *ch, int door )
{
    static int depth = 0;
    CHAR_DATA *fch;
    CHAR_DATA *fch_next;
    ROOM_INDEX_DATA *in_room;
    ROOM_INDEX_DATA *to_room;
    OBJ_DATA *obj;
    char buf[MAX_STRING_LENGTH];
    EXIT_DATA *pexit;
    int sect;
    int move;
    bool found;
    
    if ( door < 0 || door >= MAX_DIR )
    {
	bug( "Do_move: bad door %d.", door );
	return;
    }

    in_room = ch->in_room;
    if ( ( pexit   = in_room->exit[door] ) == NULL
    ||   ( to_room = pexit->to_room      ) == NULL )
    {
	send_to_char( "Alas, you cannot go that way.\n\r", ch );
	return;
    }

    if ( IS_SET(pexit->exit_info, EX_CLOSED)
    &&   !IS_AFFECTED(ch, AFF_PASS_DOOR) )
    {
        if ( !IS_SET(pexit->exit_info, EX_SECRET) || IS_IMMORTAL(ch) )
           act( "The $T is closed.", ch, NULL, pexit->keyword, TO_CHAR );
      else send_to_char( "Alas, you cannot go that way.\n\r", ch );
        if ( !IS_IMMORTAL(ch) ) return;
    }

    if ( IS_AFFECTED(ch, AFF_CHARM)
    &&   ch->master != NULL
    &&   in_room == ch->master->in_room )
    {
	send_to_char( "What?  And leave your beloved master?\n\r", ch );
	return;
    }

    if ( ch->riding != NULL && ch->riding->position < POS_STANDING )
    {
        send_to_char( "Your ride doesn't want to move right now.\n\r", ch );
        return;
    }

    if ( room_is_private( to_room ) )
    {
	send_to_char( "That room is private right now.\n\r", ch );
	return;
    }

    sect = to_room->sector_type;

        /*
         * Look for a vehicle.
         */
            found = FALSE;
            for ( obj = ch->carrying; obj != NULL; obj = obj->next_content )
            {
            if ( obj->item_type == ITEM_VEHICLE )
            {
                int t;

                for ( t = 0; t <= 9; t++ )
                {
                    if (obj->value[t] == sect)
                    {
                        found = TRUE;
                        break;
                    }
                }
                if (found) break;
            }
            }

            if ( IS_NPC(ch) && IS_SET(ch->act, ACT_PET) ) found = FALSE;
            
   if ( !found        /* no vehicle */
   && ((sect == SECT_MOUNTAIN  && !IS_AFFECTED(ch, AFF_FLYING) )
    || (sect == SECT_AIR       && !IS_AFFECTED(ch, AFF_FLYING) )
    || (sect == SECT_AIR       && ch->riding != NULL
                               && !IS_AFFECTED(ch->riding, AFF_FLYING) )
    || (sect == SECT_WATER_NOSWIM && !IS_AFFECTED(ch, AFF_FLYING) ))        )
   {
        char buf[MAX_STRING_LENGTH];
            
        switch( sect )
        {
               default: sprintf( buf, "You need another form of transportation to go there\n\r" ); break;
  case SECT_UNDERWATER: sprintf( buf, "You can't hold your breath for long enough.\n\r" ); break;
    case SECT_MOUNTAIN: sprintf( buf, "Its too steep for you to climb unaided.\n\r" ); break;
case SECT_WATER_NOSWIM: sprintf( buf, "You need a boat to go there.\n\r" ); break;
         case SECT_AIR: sprintf( buf, "You can't fly!\n\r" ); break;
        }
            
        send_to_char( buf, ch );
        return;
    }
      /* End cant move checks */
    else obj = NULL;

	move = movement_loss[UMIN(SECT_MAX-1, in_room->sector_type)]
	     + movement_loss[UMIN(SECT_MAX-1, to_room->sector_type)]
         ;

    if ( ch->riding != NULL ) move /= (ch->riding->level / 10)+1;
    if ( ch->move < move )
	{
	    send_to_char( "You are too exhausted.\n\r", ch );
	    return;
	}

	WAIT_STATE( ch, 1 );
        if ( !IS_NPC(ch) ) ch->move -= move;

        if ( obj != NULL )
        sprintf( buf, "You use %s to %s %s.",
                      STR(obj, short_descr),
                      sect == SECT_MOUNTAIN ? "climb" :
                      sect == SECT_WATER_NOSWIM ? "sail" :
                      sect == SECT_AIR ? "fly" :
                      sect == SECT_UNDERWATER ? "dive" : "move",
                      dir_name[door] );
   else if ( ch->mounted_by != NULL )
           sprintf( buf, "You wander %s, rode by %s.", dir_name[door],
                         PERS(ch->mounted_by, ch) );
   else if ( ch->riding != NULL )
           sprintf( buf, "You ride %s %s.", PERS(ch->riding, ch),
                         dir_name[door] );
   else if ( IS_AFFECTED(ch, AFF_FLYING) )
           sprintf( buf, "You fly %s.", dir_name[door] );
   else if ( IS_AFFECTED(ch, AFF_SNEAK) )
           sprintf( buf, "You sneak %s.", dir_name[door] );
   else    if ( sect == SECT_WATER_SWIM )
           sprintf( buf, "You swim %s.", dir_name[door] );
   else    sprintf( buf, "You walk %s.", dir_name[door] );

   buf[0] = UPPER(buf[0]);
   send_to_char( buf, ch );
   send_to_char( "\n\r", ch );

    for ( fch = in_room->people; fch != NULL; fch = fch_next )
    {
        fch_next = fch->next_in_room;

        if (ch == fch || ch->riding == fch || ch->mounted_by == fch) continue;

        if ( !can_see( fch, ch ) || !IS_AWAKE(fch) ) continue;

        if ( ch->mounted_by != NULL )        break;
   if ( obj != NULL )
        sprintf( buf, "%s uses %s to %s %s.",
                      PERS(ch, fch),
                      STR(obj, short_descr),
                      sect == SECT_MOUNTAIN ? "climb" :
                      sect == SECT_WATER_NOSWIM ? "sail" :
                      sect == SECT_AIR ? "fly" :
                      sect == SECT_UNDERWATER ? "dive" : "move",
                      dir_name[door] );
   else if ( ch->riding != NULL &&
     (can_see(fch, ch) || can_see(fch, ch->riding)) )
           sprintf( buf, "%s rides %s %s.", PERS(ch, fch), PERS(ch->riding, fch),
                         dir_name[door] );
   else if ( IS_AFFECTED(ch, AFF_FLYING) && can_see(fch, ch) )
           sprintf( buf, "%s flies %s.", PERS(ch, fch), dir_name[door] );
   else if ( IS_AFFECTED(ch, AFF_SNEAK) )
        {
            if ( IS_SET(fch->act, PLR_HOLYLIGHT) )
           sprintf( buf, "%s sneaks %s.", PERS(ch, fch), dir_name[door] );
           else buf[0] = '\0';
        }
   else if ( IS_NPC(ch) && IS_SET(ch->act, ACT_SCRAMBLE) )
            sprintf( buf, "%s rushes %s.", PERS(ch, fch), dir_name[door] );
   else  if ( sect == SECT_WATER_SWIM )
         sprintf( buf, "%s swims %s.",  PERS(ch, fch), dir_name[door] );
   else  sprintf( buf, "%s walks %s.",  PERS(ch, fch), dir_name[door] );

        buf[0] = UPPER(buf[0]);
        send_to_char( buf, fch );
        if ( buf[0] != '\0' ) send_to_char( "\n\r", fch );
    }

    char_from_room( ch );
    char_to_room( ch, to_room );

    if ( ch->riding != NULL
      && ch->in_room != ch->riding->in_room
      && depth == 0 )
    {
        depth++;
        move_char( ch->riding, door );
    if ( ch->riding->in_room != ch->in_room ) 
    {
    ch->riding->mounted_by = NULL;
    ch->riding = NULL; 
    send_to_char( "You are forced to leave your mount behind.\n\r", ch );
    }
        depth--;
    }
    else
    if ( ch->mounted_by != NULL
      && ch->in_room != ch->mounted_by->in_room
      && depth == 0 )
    {
        depth++;
        move_char( ch->mounted_by, door );
    if ( ch->mounted_by->in_room != ch->in_room ) 
    {
    ch->mounted_by->riding = NULL;
    ch->mounted_by = NULL;
    send_to_char( "You are forced to leave your rider behind.\n\r", ch );
    }
        depth--;
    }

    for ( fch = to_room->people; fch != NULL; fch = fch_next )
    {
        TRIGGER_DATA *pTrig;

        fch_next = fch->next_in_room;

        if (ch == fch || ch->riding == fch || ch->mounted_by == fch) continue;

        if ( !can_see( fch, ch ) || !IS_AWAKE(fch) ) continue;

        if ( ch->mounted_by != NULL )        break;

        if ( obj != NULL )
        sprintf( buf, "%s uses %s to %s %s.",
                      PERS(ch, fch),
                      STR(obj, short_descr),
                      sect == SECT_MOUNTAIN ? "climb" :
                      sect == SECT_WATER_NOSWIM ? "sail" :
                      sect == SECT_AIR ? "fly" :
                      sect == SECT_UNDERWATER ? "dive" : "move",
                      dir_name[door] );
   else if ( ch->riding != NULL )
           sprintf( buf, "%s rides %s in from %s.", PERS(ch, fch),
                         PERS(ch->riding, fch), dir_rev[door] );
   else if ( IS_AFFECTED(ch, AFF_FLYING) )
           sprintf( buf, "%s flies in from %s.", PERS(ch, fch), dir_rev[door] );
   else if ( IS_AFFECTED(ch, AFF_SNEAK) )
        {
            if ( IS_SET(fch->act, PLR_HOLYLIGHT) )
           sprintf( buf, "%s sneaks in from %s.", PERS(ch, fch), dir_rev[door] );
           else buf[0] = '\0';
        }
   else if ( IS_NPC(ch) && IS_SET(ch->act, ACT_SCRAMBLE) )
            sprintf( buf, "%s rushes in from %s.", PERS(ch, fch), dir_rev[door] );
   else  if ( sect == SECT_WATER_SWIM )
         sprintf( buf, "%s swims in from %s.",  PERS(ch, fch), dir_rev[door] );
   else     sprintf( buf, "%s walks in from %s.",  PERS(ch, fch), dir_rev[door] );

        buf[0] = UPPER(buf[0]);
        send_to_char( buf, fch );
        if ( buf[0] != '\0' ) send_to_char( "\n\r", fch );

        if ( HAS_SCRIPT(fch) )
        for ( pTrig = fch->triggers; pTrig != NULL; pTrig = pTrig->next )
        {
            if ( pTrig->trigger_type == TRIG_ENTER
              && pTrig->current == NULL
              && !IS_SET(fch->act, ACT_HALT) )
            {
                pTrig->current = pTrig->script;
                act_trigger( fch, pTrig->name, NULL, NAME(ch), NULL );
            }
        }
    }

    do_look( ch, "auto" );

    if ( HAS_SCRIPT(ch) )
    {
        TRIGGER_DATA *pTrig;
        for ( pTrig = ch->triggers; pTrig != NULL; pTrig = pTrig->next )
        {
            if ( pTrig->trigger_type == TRIG_MOVES
              && pTrig->current == NULL
              && !IS_SET(ch->act, ACT_HALT) )
            {
                pTrig->current = pTrig->script;
                act_trigger( ch, pTrig->name, NULL, NULL, NULL );
            }
        }
    }

    if( ch->hunting[0] != '\0' )
       do_track( ch, "continue" );

    for ( fch = in_room->people; fch != NULL; fch = fch_next )
    {
	fch_next = fch->next_in_room;
	if ( fch->master == ch && fch->position == POS_STANDING )
	{
        act( "You follow $N $t.", fch, dir_name[door], ch, TO_CHAR );
        move_char( fch, door );
	}
    }

    return;
}



void do_north( CHAR_DATA *ch, char *argument )
{ move_char( ch, DIR_NORTH );  return; }

void do_east( CHAR_DATA *ch, char *argument )
{ move_char( ch, DIR_EAST );   return; }

void do_south( CHAR_DATA *ch, char *argument )
{ move_char( ch, DIR_SOUTH );  return; }

void do_west( CHAR_DATA *ch, char *argument )
{ move_char( ch, DIR_WEST );   return; }

void do_up( CHAR_DATA *ch, char *argument )
{ move_char( ch, DIR_UP );     return; }

void do_down( CHAR_DATA *ch, char *argument )
{ move_char( ch, DIR_DOWN );   return; }

void do_nw( CHAR_DATA *ch, char *argument )
{ move_char( ch, DIR_NW );     return; }
 
void do_ne( CHAR_DATA *ch, char *argument )
{ move_char( ch, DIR_NE );     return; }
 
void do_sw( CHAR_DATA *ch, char *argument )
{ move_char( ch, DIR_SW );     return; }
        
void do_se( CHAR_DATA *ch, char *argument )
{ move_char( ch, DIR_SE );     return; }




 
void do_enter( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_STRING_LENGTH];
    OBJ_DATA *obj;
    ROOM_INDEX_DATA *dest;
    
    one_argument( argument, arg );
    
    if ( ( obj = get_obj_here( ch, arg ) ) == NULL )
      {
        send_to_char( "There is nothing like that to enter.\n\r", ch );
        return;
      }
    
    if ( ( obj->item_type != ITEM_FURNITURE )
      || !IS_SET(obj->value[0], FURN_EXIT) )
      {
        send_to_char( "Now how do you expect to do that.\n\r", ch );
        return;
      }
    
    if ( ( dest = get_room_index( obj->value[1] ) ) == NULL )
      {
        send_to_char( "You can't go that way.\n\r", ch );
        return;
      }
    
    act( "$n enters $p.", ch, obj, NULL, TO_ROOM );
    act( "You enter $p.", ch, obj, NULL, TO_CHAR );
    char_from_room( ch );
    char_to_room( ch, dest );
    do_look( ch, "auto" );
    act( "$n enters from $p.", ch, obj, NULL, TO_ROOM );

    if ( ch->mounted_by != NULL )
    {
        char_from_room( ch->mounted_by );
        char_to_room( ch->mounted_by, dest );
        do_look( ch->mounted_by, "auto" );
    }

    if ( ch->riding != NULL )
    {
        char_from_room( ch->riding );
        char_to_room( ch->riding, dest );
        do_look( ch->riding, "auto" );
    }
    return;
}



int find_door( CHAR_DATA *ch, char *arg )
{
    EXIT_DATA *pexit;
    int door;

    if ( ( door = get_dir( arg ) ) == MAX_DIR )
    {
    for ( door = 0; door < MAX_DIR; door++ )
	{
	    if ( ( pexit = ch->in_room->exit[door] ) != NULL
	    &&   IS_SET(pexit->exit_info, EX_ISDOOR)
	    &&   pexit->keyword != NULL
	    &&   is_name( arg, pexit->keyword ) )
		return door;
	}
	act( "I see no $T here.", ch, NULL, arg, TO_CHAR );
	return -1;
    }

    if ( ( pexit = ch->in_room->exit[door] ) == NULL )
    {
    act( "I see no door $T here.", ch, NULL, get_direction(arg), TO_CHAR );
	return -1;
    }

    if ( !IS_SET(pexit->exit_info, EX_ISDOOR) )
    {
	send_to_char( "You can't do that.\n\r", ch );
	return -1;
    }

    return door;
}



void do_open( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Open what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_here( ch, arg ) ) != NULL )
    {
	/* 'open object' */
    if ( obj->item_type != ITEM_CONTAINER
    &&   obj->item_type != ITEM_FURNITURE
    && !IS_SET(obj->value[0], FURN_EXIT) )
    { send_to_char( "That's not a container.\n\r", ch );        return;   }
	if ( !IS_SET(obj->value[1], CONT_CLOSED) )
    { send_to_char( "It's already open.\n\r",      ch );        return;   }
	if ( !IS_SET(obj->value[1], CONT_CLOSEABLE) )
    { send_to_char( "You can't do that.\n\r",      ch );        return;   }
	if ( IS_SET(obj->value[1], CONT_LOCKED) )
    { send_to_char( "It's locked.\n\r",            ch );        return;   }

	REMOVE_BIT(obj->value[1], CONT_CLOSED);
	send_to_char( "Ok.\n\r", ch );
	act( "$n opens $p.", ch, obj, NULL, TO_ROOM );
	return;
    }

    if ( ( door = find_door( ch, arg ) ) >= 0 )
    {
	/* 'open door' */
	ROOM_INDEX_DATA *to_room;
	EXIT_DATA *pexit;
	EXIT_DATA *pexit_rev;

	pexit = ch->in_room->exit[door];
	if ( !IS_SET(pexit->exit_info, EX_CLOSED) )
	    { send_to_char( "It's already open.\n\r",      ch ); return; }
	if (  IS_SET(pexit->exit_info, EX_LOCKED) )
	    { send_to_char( "It's locked.\n\r",            ch ); return; }

	REMOVE_BIT(pexit->exit_info, EX_CLOSED);
        act( "$n opens the $T.", ch, NULL, pexit->keyword, TO_ROOM );
	send_to_char( "Ok.\n\r", ch );

	/* open the other side */
	if ( ( to_room   = pexit->to_room               ) != NULL
	&&   ( pexit_rev = to_room->exit[rev_dir[door]] ) != NULL
	&&   pexit_rev->to_room == ch->in_room )
	{
	    CHAR_DATA *rch;

	    REMOVE_BIT( pexit_rev->exit_info, EX_CLOSED );
	    for ( rch = to_room->people; rch != NULL; rch = rch->next_in_room )
                act( "The $T opens.", rch, NULL, pexit_rev->keyword, TO_CHAR );
	}
    }

    return;
}



void do_close( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Close what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_here( ch, arg ) ) != NULL )
    {
	/* 'close object' */
    if ( obj->item_type != ITEM_CONTAINER
    &&   obj->item_type != ITEM_FURNITURE
    && !IS_SET(obj->value[0], FURN_EXIT) )
	    { send_to_char( "That's not a container.\n\r", ch ); return; }
	if ( IS_SET(obj->value[1], CONT_CLOSED) )
	    { send_to_char( "It's already closed.\n\r",    ch ); return; }
	if ( !IS_SET(obj->value[1], CONT_CLOSEABLE) )
	    { send_to_char( "You can't do that.\n\r",      ch ); return; }

	SET_BIT(obj->value[1], CONT_CLOSED);
	send_to_char( "Ok.\n\r", ch );
	act( "$n closes $p.", ch, obj, NULL, TO_ROOM );
	return;
    }

    if ( ( door = find_door( ch, arg ) ) >= 0 )
    {
	/* 'close door' */
	ROOM_INDEX_DATA *to_room;
	EXIT_DATA *pexit;
	EXIT_DATA *pexit_rev;

	pexit	= ch->in_room->exit[door];
	if ( IS_SET(pexit->exit_info, EX_CLOSED) )
	    { send_to_char( "It's already closed.\n\r",    ch ); return; }

	SET_BIT(pexit->exit_info, EX_CLOSED);
        act( "$n closes the $T.", ch, NULL, pexit->keyword, TO_ROOM );
	send_to_char( "Ok.\n\r", ch );

	/* close the other side */
	if ( ( to_room   = pexit->to_room               ) != NULL
	&&   ( pexit_rev = to_room->exit[rev_dir[door]] ) != 0
	&&   pexit_rev->to_room == ch->in_room )
	{
	    CHAR_DATA *rch;

	    SET_BIT( pexit_rev->exit_info, EX_CLOSED );
	    for ( rch = to_room->people; rch != NULL; rch = rch->next_in_room )
                act( "The $T closes.", rch, NULL, pexit_rev->keyword, TO_CHAR );
	}
    }

    return;
}



OBJ_DATA *has_key( CHAR_DATA *ch, int key )
{
   OBJ_DATA *obj;

   for ( obj = ch->carrying; obj != NULL; obj = obj->next_content )
        if ( obj->pIndexData->vnum == key ) return obj;

   return NULL;
}



void do_lock( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Lock what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_here( ch, arg ) ) != NULL )
    {
	/* 'lock object' */
    if ( obj->item_type != ITEM_CONTAINER
    &&   obj->item_type != ITEM_FURNITURE
    && !IS_SET(obj->value[0], FURN_EXIT) )
	    { send_to_char( "That's not a container.\n\r", ch ); return; }
	if ( !IS_SET(obj->value[1], CONT_CLOSED) )
	    { send_to_char( "It's not closed.\n\r",        ch ); return; }
	if ( obj->value[2] < 0 )
	    { send_to_char( "It can't be locked.\n\r",     ch ); return; }
	if ( has_key( ch, obj->value[2] ) == NULL )
	    { send_to_char( "You lack the key.\n\r",       ch ); return; }
	if ( IS_SET(obj->value[1], CONT_LOCKED) )
	    { send_to_char( "It's already locked.\n\r",    ch ); return; }

	SET_BIT(obj->value[1], CONT_LOCKED);
	send_to_char( "*Click*\n\r", ch );
	act( "$n locks $p.", ch, obj, NULL, TO_ROOM );
	return;
    }

    if ( ( door = find_door( ch, arg ) ) >= 0 )
    {
	/* 'lock door' */
	ROOM_INDEX_DATA *to_room;
	EXIT_DATA *pexit;
	EXIT_DATA *pexit_rev;

	pexit	= ch->in_room->exit[door];
	if ( !IS_SET(pexit->exit_info, EX_CLOSED) )
	    { send_to_char( "It's not closed.\n\r",        ch ); return; }
	if ( pexit->key < 0 )
	    { send_to_char( "It can't be locked.\n\r",     ch ); return; }
	if ( has_key( ch, pexit->key) == NULL )
	    { send_to_char( "You lack the key.\n\r",       ch ); return; }
	if ( IS_SET(pexit->exit_info, EX_LOCKED) )
	    { send_to_char( "It's already locked.\n\r",    ch ); return; }

	SET_BIT(pexit->exit_info, EX_LOCKED);
	send_to_char( "*Click*\n\r", ch );
        act( "$n locks the $T.", ch, NULL, pexit->keyword, TO_ROOM );

	/* lock the other side */
	if ( ( to_room   = pexit->to_room               ) != NULL
	&&   ( pexit_rev = to_room->exit[rev_dir[door]] ) != 0
	&&   pexit_rev->to_room == ch->in_room )
	{
	    SET_BIT( pexit_rev->exit_info, EX_LOCKED );
	}
    }

    return;
}



void do_unlock( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int door;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Unlock what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_here( ch, arg ) ) != NULL )
    {
	/* 'unlock object' */
    if ( obj->item_type != ITEM_CONTAINER
    &&   obj->item_type != ITEM_FURNITURE
    && !IS_SET(obj->value[0], FURN_EXIT) )
	    { send_to_char( "That's not a container.\n\r", ch ); return; }
	if ( !IS_SET(obj->value[1], CONT_CLOSED) )
	    { send_to_char( "It's not closed.\n\r",        ch ); return; }
	if ( obj->value[2] < 0 )
	    { send_to_char( "It can't be unlocked.\n\r",   ch ); return; }
	if ( has_key( ch, obj->value[2] ) == NULL )
	    { send_to_char( "You lack the key.\n\r",       ch ); return; }
	if ( !IS_SET(obj->value[1], CONT_LOCKED) )
	    { send_to_char( "It's already unlocked.\n\r",  ch ); return; }

	REMOVE_BIT(obj->value[1], CONT_LOCKED);
        act( "$n unlocks $p.", ch, obj, NULL, TO_ROOM );
        act( "You unlock $p.", ch, obj, NULL, TO_CHAR );
	return;
    }

    if ( ( door = find_door( ch, arg ) ) >= 0 )
    {
	/* 'unlock door' */
	ROOM_INDEX_DATA *to_room;
	EXIT_DATA *pexit;
	EXIT_DATA *pexit_rev;

	pexit = ch->in_room->exit[door];
	if ( !IS_SET(pexit->exit_info, EX_CLOSED) )
	    { send_to_char( "It's not closed.\n\r",        ch ); return; }
	if ( pexit->key < 0 )
	    { send_to_char( "It can't be unlocked.\n\r",   ch ); return; }
	if ( ( obj = has_key( ch, pexit->key) ) == NULL )
	    { send_to_char( "You lack the key.\n\r",       ch ); return; }
	if ( !IS_SET(pexit->exit_info, EX_LOCKED) )
	    { send_to_char( "It's already unlocked.\n\r",  ch ); return; }

    if ( IS_SET(pexit->exit_info, EX_EAT_KEY) )
    {
        act( "The lock eats $p.", ch, obj, NULL, TO_NOTVICT );
        obj_from_char( obj );
        extract_obj( obj );
    }

	REMOVE_BIT(pexit->exit_info, EX_LOCKED);
    act( "You unlock the $T with $p.", ch, obj, pexit->keyword, TO_CHAR );
    act( "$n unlocks the $T.", ch, NULL, pexit->keyword, TO_ROOM );

	/* unlock the other side */
	if ( ( to_room   = pexit->to_room               ) != NULL
	&&   ( pexit_rev = to_room->exit[rev_dir[door]] ) != NULL
	&&   pexit_rev->to_room == ch->in_room )
	{
	    REMOVE_BIT( pexit_rev->exit_info, EX_LOCKED );
	}
    }

    return;
}



void do_pick( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *gch;
    OBJ_DATA *obj;
    int door;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Pick what?\n\r", ch );
	return;
    }

    WAIT_STATE( ch, skill_table[gsn_pick_lock].beats );

    /* look for guards */
    for ( gch = ch->in_room->people; gch; gch = gch->next_in_room )
    {
	if ( IS_NPC(gch) && IS_AWAKE(gch) && ch->level + 5 < gch->level )
	{
	    act( "$N is standing too close to the lock.",
		ch, NULL, gch, TO_CHAR );
	    return;
	}
    }

    if ( !skill_check( ch, gsn_pick_lock, 0 ) )
    {
	send_to_char( "You failed.\n\r", ch);
	return;
    }

    if ( ( obj = get_obj_here( ch, arg ) ) != NULL )
    {
	/* 'pick object' */
	if ( obj->item_type != ITEM_CONTAINER )
	    { send_to_char( "That's not a container.\n\r", ch ); return; }
	if ( !IS_SET(obj->value[1], CONT_CLOSED) )
	    { send_to_char( "It's not closed.\n\r",        ch ); return; }
	if ( obj->value[2] < 0 )
	    { send_to_char( "It can't be unlocked.\n\r",   ch ); return; }
	if ( !IS_SET(obj->value[1], CONT_LOCKED) )
	    { send_to_char( "It's already unlocked.\n\r",  ch ); return; }
	if ( IS_SET(obj->value[1], CONT_PICKPROOF) )
	    { send_to_char( "You failed.\n\r",             ch ); return; }

        REMOVE_BIT(obj->value[1], CONT_LOCKED);
        act( "You pick $p.", ch, obj, NULL, TO_CHAR );        
        act( "$n picks $p.", ch, obj, NULL, TO_ROOM );
	return;
    }

    if ( ( door = find_door( ch, arg ) ) >= 0 )
    {
	/* 'pick door' */
	ROOM_INDEX_DATA *to_room;
	EXIT_DATA *pexit;
	EXIT_DATA *pexit_rev;

	pexit = ch->in_room->exit[door];
	if ( !IS_SET(pexit->exit_info, EX_CLOSED) )
	    { send_to_char( "It's not closed.\n\r",        ch ); return; }
	if ( pexit->key < 0 )
	    { send_to_char( "It can't be picked.\n\r",     ch ); return; }
	if ( !IS_SET(pexit->exit_info, EX_LOCKED) )
	    { send_to_char( "It's already unlocked.\n\r",  ch ); return; }
	if ( IS_SET(pexit->exit_info, EX_PICKPROOF) )
	    { send_to_char( "You failed.\n\r",             ch ); return; }

        REMOVE_BIT(pexit->exit_info, EX_LOCKED);
        act( "You pick the $T.", ch, NULL, pexit->keyword, TO_CHAR );
        act( "$n picks the $T.", ch, NULL, pexit->keyword, TO_ROOM );

	/* pick the other side */
	if ( ( to_room   = pexit->to_room               ) != NULL
	&&   ( pexit_rev = to_room->exit[rev_dir[door]] ) != NULL
	&&   pexit_rev->to_room == ch->in_room )
	{
	    REMOVE_BIT( pexit_rev->exit_info, EX_LOCKED );
	}
    }

    return;
}




void do_stand( CHAR_DATA *ch, char *argument )
{
    switch ( ch->position )
    {
    case POS_SLEEPING:
	if ( IS_AFFECTED(ch, AFF_SLEEP) )
	    { send_to_char( "You can't wake up!\n\r", ch ); return; }

	send_to_char( "You wake and stand up.\n\r", ch );
	act( "$n wakes and stands up.", ch, NULL, NULL, TO_ROOM );
	ch->position = POS_STANDING;
	break;

    case POS_RESTING:
	send_to_char( "You stand up.\n\r", ch );
	act( "$n stands up.", ch, NULL, NULL, TO_ROOM );
	ch->position = POS_STANDING;
	break;

    case POS_STANDING:
	send_to_char( "You are already standing.\n\r", ch );
	break;

    case POS_FIGHTING:
	send_to_char( "You are already fighting!\n\r", ch );
	break;
    }

    return;
}



void do_rest( CHAR_DATA *ch, char *argument )
{
    switch ( ch->position )
    {
    case POS_SLEEPING:
	send_to_char( "You are already sleeping.\n\r", ch );
	break;

    case POS_RESTING:
	send_to_char( "You are already resting.\n\r", ch );
	break;

    case POS_STANDING:
	send_to_char( "You rest.\n\r", ch );
	act( "$n rests.", ch, NULL, NULL, TO_ROOM );
	ch->position = POS_RESTING;
	break;

    case POS_FIGHTING:
	send_to_char( "You are already fighting!\n\r", ch );
	break;
    }

    return;
}



void do_sleep( CHAR_DATA *ch, char *argument )
{
    switch ( ch->position )
    {
    case POS_SLEEPING:
	send_to_char( "You are already sleeping.\n\r", ch );
	break;

    case POS_RESTING:
    case POS_STANDING: 
	send_to_char( "You sleep.\n\r", ch );
	act( "$n sleeps.", ch, NULL, NULL, TO_ROOM );
	ch->position = POS_SLEEPING;
	break;

    case POS_FIGHTING:
        send_to_char( "You are fighting!\n\r", ch );
	break;
    }

    return;
}



void do_wake( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
	{ do_stand( ch, argument ); return; }

    if ( !IS_AWAKE(ch) )
	{ send_to_char( "You are asleep yourself!\n\r",       ch ); return; }

    if ( ( victim = get_char_room( ch, arg ) ) == NULL )
	{ send_to_char( "They aren't here.\n\r",              ch ); return; }

    if ( IS_AWAKE(victim) )
	{ act( "$N is already awake.", ch, NULL, victim, TO_CHAR ); return; }

    if ( IS_AFFECTED(victim, AFF_SLEEP) )
	{ act( "You can't wake $M!",   ch, NULL, victim, TO_CHAR );  return; }

    act( "You wake $M.", ch, NULL, victim, TO_CHAR );
    act( "$n wakes you.", ch, NULL, victim, TO_VICT );
    victim->position = POS_STANDING;
    return;
}



void do_sneak( CHAR_DATA *ch, char *argument )
{
    AFFECT_DATA af;

    send_to_char( "You attempt to move silently.\n\r", ch );
    affect_strip( ch, gsn_sneak );

    if ( IS_NPC(ch) || number_percent( ) < ch->pcdata->learned[gsn_sneak] )
    {
	af.type      = gsn_sneak;
	af.duration  = ch->level;
	af.location  = APPLY_NONE;
	af.modifier  = 0;
	af.bitvector = AFF_SNEAK;
	affect_to_char( ch, &af );
    }

    return;
}



void do_hide( CHAR_DATA *ch, char *argument )
{
    send_to_char( "You attempt to hide.\n\r", ch );

    if ( IS_AFFECTED(ch, AFF_HIDE) )
	REMOVE_BIT(ch->affected_by, AFF_HIDE);

    if ( IS_NPC(ch) || number_percent( ) < ch->pcdata->learned[gsn_hide] )
	SET_BIT(ch->affected_by, AFF_HIDE);

    return;
}



/*
 * Contributed by Alander.
 */
void do_visible( CHAR_DATA *ch, char *argument )
{
    affect_strip ( ch, gsn_invis			);
    affect_strip ( ch, gsn_mass_invis			);
    affect_strip ( ch, gsn_sneak			);
    REMOVE_BIT   ( ch->affected_by, AFF_HIDE		);
    REMOVE_BIT   ( ch->affected_by, AFF_INVISIBLE	);
    REMOVE_BIT   ( ch->affected_by, AFF_SNEAK		);
    send_to_char( "Ok.\n\r", ch );
    return;
}



void do_recall( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *victim;
    ROOM_INDEX_DATA *loc;
  
    act( "$n prays for transportation!", ch, NULL, NULL, TO_ROOM );

    if ( ( loc = get_room_index( ch->in_room->area->recall_loc ) ) == NULL )
    {
	send_to_char( "You are completely lost.\n\r", ch );
	return;
    }

    if ( ch->in_room == loc )
    {
    send_to_char( "Your already there!\n\r", ch );
	return;
    }

    if ( IS_SET(ch->in_room->room_flags, ROOM_NO_RECALL)
    ||   IS_AFFECTED(ch, AFF_CURSE) )
    {
	send_to_char( "God has forsaken you.\n\r", ch );
	return;
    }

    if ( ( victim = ch->fighting ) != NULL )
    {
	int lose;

	if ( number_bits( 1 ) == 0 )
	{
	    WAIT_STATE( ch, 4 );
	    lose = (ch->desc != NULL) ? 50 : 100;
	    gain_exp( ch, 0 - lose );
	    sprintf( buf, "You failed!  You lose %d exps.\n\r", lose );
	    send_to_char( buf, ch );
	    return;
	}

	lose = (ch->desc != NULL) ? 100 : 200;
	gain_exp( ch, 0 - lose );
	sprintf( buf, "You recall from combat!  You lose %d exps.\n\r", lose );
	send_to_char( buf, ch );
	stop_fighting( ch, TRUE );
    }

    ch->move /= 2;
    act( "$n disappears.", ch, NULL, NULL, TO_ROOM );
    char_from_room( ch );
    char_to_room( ch, loc );
    if ( ch->mounted_by != NULL )
    {
        do_recall( ch->mounted_by, "" );
    }

    if ( ch->riding != NULL )
    {
        do_recall( ch->riding, "" );
    }
    act( "$n appears in the room.", ch, NULL, NULL, TO_ROOM );
    do_look( ch, "auto" );

    return;
}



void do_train( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *mob;
    sh_int *pAbility;
    char *pOutput;
    int cost;

    if ( IS_NPC(ch) )
	return;

    /*
     * Check for trainer.
     */
    for ( mob = ch->in_room->people; mob; mob = mob->next_in_room )
    {
	if ( IS_NPC(mob) && IS_SET(mob->act, ACT_TRAIN) )
	    break;
    }

    if ( mob == NULL )
    {
	send_to_char( "You can't do that here.\n\r", ch );
	return;
    }

    if ( argument[0] == '\0' )
    {
	sprintf( buf, "You have %d practice sessions.\n\r", ch->practice );
	send_to_char( buf, ch );
	argument = "foo";
    }

    cost = 5;

    if ( !str_cmp( argument, "str" ) )
    {
	pAbility    = &ch->pcdata->perm_str;
	pOutput     = "strength";
    }

    else if ( !str_cmp( argument, "int" ) )
    {
	pAbility    = &ch->pcdata->perm_int;
	pOutput     = "intelligence";
    }

    else if ( !str_cmp( argument, "wis" ) )
    {
	pAbility    = &ch->pcdata->perm_wis;
	pOutput     = "wisdom";
    }

    else if ( !str_cmp( argument, "dex" ) )
    {
	pAbility    = &ch->pcdata->perm_dex;
	pOutput     = "dexterity";
    }

    else if ( !str_cmp( argument, "con" ) )
    {
	pAbility    = &ch->pcdata->perm_con;
	pOutput     = "constitution";
    }
    else if ( !str_cmp( argument, "hp" ) )
    {
       cost    = 5;
       if ( cost > ch->practice )
       {
         send_to_char( "You don't have enough practices.\n\r", ch );
         return;
       }
       ch->max_hit += number_range(1,get_curr_con(ch));
       ch->practice    -= cost;
       pOutput     = "hit points";
       act( "Your $T increase!", ch, NULL, pOutput, TO_CHAR );
       act( "$n's $T increase!", ch, NULL, pOutput, TO_ROOM );
       return;
    }

    else if ( !str_cmp( argument, "move" ) )
    {
       cost    = 3;
       if ( cost > ch->practice )
       {
         send_to_char( "You don't have enough practices.\n\r", ch );
         return;
       }
       ch->max_move += number_range(1,get_curr_dex(ch));
       ch->practice    -= cost;
       pOutput     = "movement";
       act( "Your $T increases!", ch, NULL, pOutput, TO_CHAR );
       act( "$n's $T increases!", ch, NULL, pOutput, TO_ROOM );
       return;
    }

    else
    {
	strcpy( buf, "You can train:" );
	if ( ch->pcdata->perm_str < 18 ) strcat( buf, " str" );
	if ( ch->pcdata->perm_int < 18 ) strcat( buf, " int" );
	if ( ch->pcdata->perm_wis < 18 ) strcat( buf, " wis" );
	if ( ch->pcdata->perm_dex < 18 ) strcat( buf, " dex" );
	if ( ch->pcdata->perm_con < 18 ) strcat( buf, " con" );

        strcat( buf, " hp move\n\r" );
        send_to_char( buf, ch );

	return;
    }

    if ( *pAbility >= 18 )
    {
	act( "Your $T is already at maximum.", ch, NULL, pOutput, TO_CHAR );
	return;
    }

    if ( cost > ch->practice )
    {
	send_to_char( "You don't have enough practices.\n\r", ch );
	return;
    }

    ch->practice	-= cost;
    *pAbility		+= 1;
    act( "Your $T increases!", ch, NULL, pOutput, TO_CHAR );
    act( "$n's $T increases!", ch, NULL, pOutput, TO_ROOM );
    return;
}









