/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"


/*
 * from hand
 */

void update_money( OBJ_DATA *obj );

/*
 * Local functions.
 */
void	get_obj		args( ( CHAR_DATA *ch, OBJ_DATA *obj,
                            OBJ_DATA *container ) );
bool	remove_obj	args( ( CHAR_DATA *ch, int iWear, bool fReplace ) );
void    wear_obj    args( ( CHAR_DATA *ch, OBJ_DATA *obj,
                            bool fReplace, int loc ) );
CHAR_DATA *    find_keeper args( ( CHAR_DATA *ch ) );
int	get_cost	args( ( CHAR_DATA *keeper, OBJ_DATA *obj, bool fBuy ) );
void            args( obj_resort( OBJ_DATA *obj ) );



#define INV(loc)       ( (loc == WEAR_NONE || loc == WEAR_HOLD_1 ||     \
                          loc == WEAR_HOLD_2) )


void obj_resort( OBJ_DATA *obj )
{
    return;
}



void get_obj( CHAR_DATA *ch, OBJ_DATA *obj, OBJ_DATA *container )
{
    if ( !CAN_WEAR(obj, ITEM_TAKE) )
    {
	send_to_char( "You can't take that.\n\r", ch );
	return;
    }

    if ( hand_empty( ch ) == WEAR_NONE )
    {
        send_to_char( "Your hands are full.\n\r", ch );
        return;
    };

    if ( ch->carry_weight + get_obj_weight( obj ) > can_carry_w( ch )
     && container == NULL )
    {
	act( "$d: you can't carry that much weight.",
        ch, NULL, STR(obj, name), TO_CHAR );
	return;
    }

    if ( container != NULL )
    {
	act( "You get $p from $P.", ch, obj, container, TO_CHAR );
	act( "$n gets $p from $P.", ch, obj, container, TO_ROOM );
	obj_from_obj( obj );
    }
    else
    {
	act( "You get $p.", ch, obj, container, TO_CHAR );
	act( "$n gets $p.", ch, obj, container, TO_ROOM );
	obj_from_room( obj );
    }

    obj_to_char( obj, ch );
    obj->wear_loc = hand_empty( ch );
    if ( obj->item_type == ITEM_MONEY )
    {
        obj->wear_loc = WEAR_NONE;
        merge_money( ch );
    }

    return;
}



void do_get( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    OBJ_DATA *container;
    bool found;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    /* Get type. */
    if ( arg1[0] == '\0' )
    {
	send_to_char( "Get what?\n\r", ch );
	return;
    }

    if ( arg2[0] == '\0' )
    {
	if ( str_cmp( arg1, "all" ) && str_prefix( "all.", arg1 ) )
	{
	    /* 'get obj' */
	    obj = get_obj_list( ch, arg1, ch->in_room->contents );
	    if ( obj == NULL )
	    {
		act( "I see no $T here.", ch, NULL, arg1, TO_CHAR );
		return;
	    }

	    get_obj( ch, obj, NULL );
	}
	else
	{
	    /* 'get all' or 'get all.obj' */
	    found = FALSE;
	    for ( obj = ch->in_room->contents; obj != NULL; obj = obj_next )
	    {
		obj_next = obj->next_content;
        if ( ( arg1[3] == '\0' || is_name( &arg1[4], STR(obj, name) ) )
		&&   can_see_obj( ch, obj ) )
		{
		    found = TRUE;
                    get_obj( ch, obj, NULL );
                    if ( hand_empty( ch ) == WEAR_NONE ) break;
		}
	    }

	    if ( !found ) 
	    {
		if ( arg1[3] == '\0' )
		    send_to_char( "I see nothing here.\n\r", ch );
		else
		    act( "I see no $T here.", ch, NULL, &arg1[4], TO_CHAR );
	    }
	}
    }
    else
    {
	/* 'get ... container' */
	if ( !str_cmp( arg2, "all" ) || !str_prefix( "all.", arg2 ) )
	{
	    send_to_char( "You can't do that.\n\r", ch );
	    return;
	}

	if ( ( container = get_obj_here( ch, arg2 ) ) == NULL )
	{
	    act( "I see no $T here.", ch, NULL, arg2, TO_CHAR );
	    return;
	}

	switch ( container->item_type )
	{
	default:
	    send_to_char( "That's not a container.\n\r", ch );
	    return;

	case ITEM_CONTAINER:
	case ITEM_CORPSE_NPC:
	    break;

	case ITEM_CORPSE_PC:
	    {
		char name[MAX_INPUT_LENGTH];
		CHAR_DATA *gch;
		char *pd;

		if ( IS_NPC(ch) )
		{
		    send_to_char( "You can't do that.\n\r", ch );
		    return;
		}

        pd = STR(container, short_descr);
		pd = one_argument( pd, name );
		pd = one_argument( pd, name );
		pd = one_argument( pd, name );

        if ( str_cmp( name, NAME(ch) ) && !IS_IMMORTAL(ch) )
		{
		    bool fGroup;

		    fGroup = FALSE;
		    for ( gch = char_list; gch != NULL; gch = gch->next )
		    {
			if ( !IS_NPC(gch)
			&&   is_same_group( ch, gch )
            &&   !str_cmp( name, NAME(gch) ) )
			{
			    fGroup = TRUE;
			    break;
			}
		    }

		    if ( !fGroup )
		    {
			send_to_char( "You can't do that.\n\r", ch );
			return;
		    }
        }
        }
	}

	if ( IS_SET(container->value[1], CONT_CLOSED) )
	{
        act( "The $d is closed.", ch, NULL, STR(container, name), TO_CHAR );
	    return;
	}

	if ( str_cmp( arg1, "all" ) && str_prefix( "all.", arg1 ) )
	{
	    /* 'get obj container' */
	    obj = get_obj_list( ch, arg1, container->contains );
	    if ( obj == NULL )
	    {
        act( "I see nothing like that in the $T.", ch, NULL, arg2, TO_CHAR );
		return;
	    }
	    get_obj( ch, obj, container );
	}
	else
	{
	    /* 'get all container' or 'get all.obj container' */
	    found = FALSE;
	    for ( obj = container->contains; obj != NULL; obj = obj_next )
	    {
		obj_next = obj->next_content;
        if ( ( arg1[3] == '\0' || is_name( &arg1[4], STR(obj, name) ) )
		&&   can_see_obj( ch, obj ) )
		{
		    found = TRUE;
		    get_obj( ch, obj, container );
                    if ( hand_empty( ch ) == WEAR_NONE ) break;
		}
	    }

	    if ( !found )
	    {
		if ( arg1[3] == '\0' )
            act( "I see nothing in the $T.", ch, NULL, arg2, TO_CHAR );
		else
            act( "I see nothing like that in the $T.",
                 ch, NULL, arg2, TO_CHAR );
	    }
	}
    }

    return;
}



void do_put( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *container;
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
	send_to_char( "Put what in what?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg2, "all" ) || !str_prefix( "all.", arg2 ) )
    {
	send_to_char( "You can't do that.\n\r", ch );
	return;
    }

    if ( ( container = get_obj_here( ch, arg2 ) ) == NULL )
    {
	act( "I see no $T here.", ch, NULL, arg2, TO_CHAR );
	return;
    }

    if ( container->item_type != ITEM_CONTAINER )
    {
	send_to_char( "That's not a container.\n\r", ch );
	return;
    }

    if ( IS_SET(container->value[1], CONT_CLOSED) )
    {
    act( "The $d is closed.", ch, NULL, STR(container, name), TO_CHAR );
	return;
    }

    if ( str_cmp( arg1, "all" ) && str_prefix( "all.", arg1 ) )
    {
	/* 'put obj container' */
    if ( ( obj = get_obj_inv( ch, arg1 ) ) == NULL )
	{
	    send_to_char( "You do not have that item.\n\r", ch );
	    return;
	}

	if ( obj == container )
	{
	    send_to_char( "You can't fold it into itself.\n\r", ch );
	    return;
	}

	if ( !can_drop_obj( ch, obj ) )
	{
	    send_to_char( "You can't let go of it.\n\r", ch );
	    return;
	}

	if ( get_obj_weight( obj ) + get_obj_weight( container )
	     > container->value[0] )
	{
	    send_to_char( "It won't fit.\n\r", ch );
	    return;
	}

	obj_from_char( obj );
	obj_to_obj( obj, container );
	act( "$n puts $p in $P.", ch, obj, container, TO_ROOM );
	act( "You put $p in $P.", ch, obj, container, TO_CHAR );
    }
    else
    {
	/* 'put all container' or 'put all.obj container' */
	for ( obj = ch->carrying; obj != NULL; obj = obj_next )
	{
	    obj_next = obj->next_content;

        if ( ( arg1[3] == '\0' || is_name( &arg1[4], STR(obj, name) ) )
	    &&   can_see_obj( ch, obj )
            &&   INV(obj->wear_loc)
	    &&   obj != container
	    &&   can_drop_obj( ch, obj )
	    &&   get_obj_weight( obj ) + get_obj_weight( container )
		 <= container->value[0] )
	    {
		obj_from_char( obj );
		obj_to_obj( obj, container );
		act( "$n puts $p in $P.", ch, obj, container, TO_ROOM );
		act( "You put $p in $P.", ch, obj, container, TO_CHAR );
	    }
	}
    }

    return;
}



void do_drop( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    bool found;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Drop what?\n\r", ch );
	return;
    }

    if ( str_cmp( arg, "all" ) && str_prefix( "all.", arg ) )
    {
	/* 'drop obj' */
    if ( ( obj = get_obj_inv( ch, arg ) ) == NULL )
	{
        send_to_char( "You do not have that item.\n\r", ch );
	    return;
	}
    else
    if ( !NOT_WORN(obj) )
    {
        send_to_char( "You will have to remove it first.\n\r", ch );
        return;
    }

	if ( !can_drop_obj( ch, obj ) )
	{
	    send_to_char( "You can't let go of it.\n\r", ch );
	    return;
	}

    if ( obj->item_type == ITEM_MONEY )
    {
        char arg2[MAX_STRING_LENGTH];
        int amount;

        argument = one_argument( argument, arg2 );
        amount = atoi( arg2 );

        if ( amount > obj->value[0] || amount == 0 ) amount = obj->value[0];

        send_to_char( "You drop some money.\n\r", ch );
        act( "$n drops some money.", ch, NULL, NULL, TO_ROOM );

        obj->value[0] -= amount;
        update_money( obj );
        create_amount( amount * coin_table[obj->value[1]].convert, NULL, 
                       ch->in_room, NULL  );
        strip_empty_money( ch );
        merge_money( ch );
        return;
    }

	obj_from_char( obj );
	obj_to_room( obj, ch->in_room );
	act( "$n drops $p.", ch, obj, NULL, TO_ROOM );
	act( "You drop $p.", ch, obj, NULL, TO_CHAR );
    }
    else
    {
	/* 'drop all' or 'drop all.obj' */
	found = FALSE;
	for ( obj = ch->carrying; obj != NULL; obj = obj_next )
	{
	    obj_next = obj->next_content;

        if ( ( arg[3] == '\0' || is_name( &arg[4], STR(obj, name) ) )
	    &&   can_see_obj( ch, obj )
            && INV(obj->wear_loc)
	    &&   can_drop_obj( ch, obj ) )
	    {
		found = TRUE;
		obj_from_char( obj );
		obj_to_room( obj, ch->in_room );
		act( "$n drops $p.", ch, obj, NULL, TO_ROOM );
		act( "You drop $p.", ch, obj, NULL, TO_CHAR );
	    }
	}

	if ( !found )
	{
	    if ( arg[3] == '\0' )
		act( "You are not carrying anything.",
		    ch, NULL, arg, TO_CHAR );
	    else
        act( "You are not carrying $T.",
		    ch, NULL, &arg[4], TO_CHAR );
	}
    }

    return;
}



void do_give( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA  *obj;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
	send_to_char( "Give what to whom?\n\r", ch );
	return;
    }

	if ( ( victim = get_char_room( ch, arg2 ) ) == NULL )
	{
	    send_to_char( "They aren't here.\n\r", ch );
	    return;
	}

    if ( ( obj = get_obj_inv( ch, arg1 ) ) == NULL )
    {
	send_to_char( "You do not have that item.\n\r", ch );
	return;
    }

    if ( !NOT_WORN( obj ) )
    {
	send_to_char( "You must remove it first.\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, arg2 ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( !can_drop_obj( ch, obj ) )
    {
	send_to_char( "You can't let go of it.\n\r", ch );
	return;
    }

    if ( hand_empty( victim ) == WEAR_NONE  && !IS_IMMORTAL(victim)
      && obj->item_type != ITEM_MONEY )
    {
	act( "$N has $S hands full.", ch, NULL, victim, TO_CHAR );
	return;
    }

    if ( victim->carry_weight + get_obj_weight( obj ) > can_carry_w( victim ) )
    {
	act( "$N can't carry that much weight.", ch, NULL, victim, TO_CHAR );
	return;
    }

    if ( !can_see_obj( victim, obj ) )
    {
	act( "$N can't see it.", ch, NULL, victim, TO_CHAR );
	return;
    }

    obj_from_char( obj );
    obj_to_char( obj, victim );
    obj->wear_loc = obj->item_type == ITEM_MONEY ? WEAR_NONE : hand_empty( victim );

    act( "$n gives $p to $N.", ch, obj, victim, TO_NOTVICT );
    act( "$n gives you $p.",   ch, obj, victim, TO_VICT    );
    act( "You give $p to $N.", ch, obj, victim, TO_CHAR    );
    return;
}




void do_fill( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    OBJ_DATA *fountain;
    bool found;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Fill what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_held( ch, arg ) ) == NULL )
    {
    send_to_char( "You do not have that item in your hands.\n\r", ch );
	return;
    }


    if ( obj->item_type == ITEM_DRINK_CON )
    {
         found = FALSE;
         for ( fountain = ch->in_room->contents; fountain != NULL;
         fountain = fountain->next_content )
         {
         if ( fountain->item_type == ITEM_FOUNTAIN )
         {
             found = TRUE;
             break;
         }
         }

         if ( !found )
         {
         send_to_char( "There is no fountain here!\n\r", ch );
         return;
         }

         if ( obj->value[0] != 0 )
         {
         send_to_char( "There is already another liquid in it.\n\r", ch );
         return;
         }

         if ( obj->value[0] >= obj->value[1] )
         {
         send_to_char( "Your container is full.\n\r", ch );
         return;
         }

         act( "You fill $p.", ch, obj, NULL, TO_CHAR );
         obj->value[2] = 0; /* fountains are water */
         obj->value[0] = obj->value[1];
    }
    else
    if ( obj->item_type == ITEM_LIGHT )
    {
        OBJ_DATA *obj2;

        if ( ( obj2 = get_item_held( ch, ITEM_DRINK_CON ) ) == NULL )
        {
        send_to_char( "You don't have anything in your hand to fill it with.\n\r", ch );
        return;
        }

        if ( !IS_SET(obj->value[3], LIGHT_FILLABLE) )
        {
        send_to_char( "It can't be refueled.\n\r", ch );
        return;
        }

        if ( obj2->value[2] != -1 )
        {
        send_to_char( "There's no oil in that container.\n\r", ch );
        return;
        }

        if ( obj->value[0] != 0 )
        {
        send_to_char( "There is already some oil in it.\n\r", ch );
        return;
        }

        if ( IS_SET(obj->value[3], LIGHT_LIT) )
        {
        send_to_char( "I don't think it's a good idea while it is lit.\n\r", ch );
        return;
        }

        if (obj2->value[1] >= obj->value[1] )
        {
            act( "You fill $p with $P.", ch, obj, obj2, TO_CHAR );
            obj->value[0] = obj->value[1];
            obj2->value[0] += -(obj->value[1]);
        }
        else
        {
            act( "You empty $P into $p.", ch, obj, obj2, TO_CHAR );
            obj->value[0] = obj->value[1];
            obj2->value[0] = 0;
        }
    }
    else
    {
    send_to_char( "You can't fill that.\n\r", ch );
    return;
    }

    return;
}



void do_drink( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int amount;
    int liquid;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	for ( obj = ch->in_room->contents; obj; obj = obj->next_content )
	{
	    if ( obj->item_type == ITEM_FOUNTAIN )
		break;
	}

	if ( obj == NULL )
	{
	    send_to_char( "Drink what?\n\r", ch );
	    return;
	}
    }
    else
    {
	if ( ( obj = get_obj_here( ch, arg ) ) == NULL )
	{
	    send_to_char( "You can't find it.\n\r", ch );
	    return;
	}
    }

    if ( !IS_NPC(ch) && ch->pcdata->condition[COND_DRUNK] > 10 )
    {
	send_to_char( "You fail to reach your mouth.  *Hic*\n\r", ch );
	return;
    }

    switch ( obj->item_type )
    {
    default:
	send_to_char( "You can't drink from that.\n\r", ch );
	break;

    case ITEM_FOUNTAIN:
	if ( !IS_NPC(ch) )
	    ch->pcdata->condition[COND_THIRST] = 48;
    act( "$n drinks from $p.", ch, obj, NULL, TO_ROOM );
    act( "You drink from $p until you are no longer thirsty.", ch, 
         obj, NULL, TO_CHAR );
    obj_cast_spell( obj->value[1], obj->value[0], ch, ch, NULL );
    obj_cast_spell( obj->value[2], obj->value[0], ch, ch, NULL );
    obj_cast_spell( obj->value[3], obj->value[0], ch, ch, NULL );
	break;

    case ITEM_DRINK_CON:
	if ( obj->value[1] <= 0 )
	{
	    send_to_char( "It is already empty.\n\r", ch );
	    return;
	}

	if ( ( liquid = obj->value[2] ) >= LIQ_MAX )
	{
	    bug( "Do_drink: bad liquid number %d.", liquid );
	    liquid = obj->value[2] = 0;
	}

    if ( liquid == -1 )
    {
    act( "$n drinks lamp oil from $p, and spits it out on the ground in surprise.",
        ch, obj, NULL, TO_ROOM );
    act( "You drink oil from $p.  Bleech!  You spit it out.",
        ch, obj, NULL, TO_CHAR );
    amount = 0;
    }
    else
    {
	act( "$n drinks $T from $p.",
	    ch, obj, liq_table[liquid].liq_name, TO_ROOM );
	act( "You drink $T from $p.",
	    ch, obj, liq_table[liquid].liq_name, TO_CHAR );

	amount = number_range(3, 10);
	amount = UMIN(amount, obj->value[1]);
	
	gain_condition( ch, COND_DRUNK,
	    amount * liq_table[liquid].liq_affect[COND_DRUNK  ] );
	gain_condition( ch, COND_FULL,
	    amount * liq_table[liquid].liq_affect[COND_FULL   ] );
	gain_condition( ch, COND_THIRST,
	    amount * liq_table[liquid].liq_affect[COND_THIRST ] );

	if ( !IS_NPC(ch) && ch->pcdata->condition[COND_DRUNK]  > 10 )
	    send_to_char( "You feel drunk.\n\r", ch );
	if ( !IS_NPC(ch) && ch->pcdata->condition[COND_FULL]   > 40 )
	    send_to_char( "You are full.\n\r", ch );
	if ( !IS_NPC(ch) && ch->pcdata->condition[COND_THIRST] > 40 )
        send_to_char( "You are no longer thirsty.\n\r", ch );
	
	if ( obj->value[3] != 0 )
	{
	    /* The shit was poisoned ! */
	    AFFECT_DATA af;

	    act( "$n chokes and gags.", ch, NULL, NULL, TO_ROOM );
	    send_to_char( "You choke and gag.\n\r", ch );
	    af.type      = gsn_poison;
	    af.duration  = 3 * amount;
	    af.location  = APPLY_NONE;
	    af.modifier  = 0;
	    af.bitvector = AFF_POISON;
	    affect_join( ch, &af );
	}
    }
	
    obj->value[0] -= amount;
    if ( obj->value[0] <= 0 ) obj->value[1] = 0;
	break;
    }

    return;
}



void do_eat( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
	send_to_char( "Eat what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_inv( ch, arg ) ) == NULL )
    {
	send_to_char( "You do not have that item.\n\r", ch );
	return;
    }

    if ( !IS_IMMORTAL(ch) )
    {
	if ( obj->item_type != ITEM_FOOD && obj->item_type != ITEM_PILL )
	{
	    send_to_char( "That's not edible.\n\r", ch );
	    return;
	}

	if ( !IS_NPC(ch) && ch->pcdata->condition[COND_FULL] > 40 )
	{   
	    send_to_char( "You are too full to eat more.\n\r", ch );
	    return;
	}
    }
    else
    {
        if ( obj->item_type == ITEM_LIGHT && IS_LIT(obj) )
            --ch->in_room->light;
    }

    act( "$n eats $p.",  ch, obj, NULL, TO_ROOM );
    act( "You eat $p.", ch, obj, NULL, TO_CHAR );

    switch ( obj->item_type )
    {

    case ITEM_FOOD:
	if ( !IS_NPC(ch) )
	{
	    int condition;

	    condition = ch->pcdata->condition[COND_FULL];
	    gain_condition( ch, COND_FULL, obj->value[0] );
	    if ( condition == 0 && ch->pcdata->condition[COND_FULL] >= 10 )
		send_to_char( "You are no longer hungry.\n\r", ch );
	    else if ( ch->pcdata->condition[COND_FULL] > 40 )
		send_to_char( "You are full.\n\r", ch );
    }

	if ( obj->value[3] != 0 )
    {
	    /* The shit was poisoned! */
	    AFFECT_DATA af;

	    act( "$n chokes and gags.", ch, 0, 0, TO_ROOM );
	    send_to_char( "You choke and gag.\n\r", ch );

	    af.type      = gsn_poison;
	    af.duration  = 2 * obj->value[0];
	    af.location  = APPLY_NONE;
	    af.modifier  = 0;
	    af.bitvector = AFF_POISON;
	    affect_join( ch, &af );
	}
	break;

    case ITEM_PILL:
	obj_cast_spell( obj->value[1], obj->value[0], ch, ch, NULL );
	obj_cast_spell( obj->value[2], obj->value[0], ch, ch, NULL );
	obj_cast_spell( obj->value[3], obj->value[0], ch, ch, NULL );
	break;
    }

    extract_obj( obj );
    return;
}


bool draw_obj( CHAR_DATA *ch, OBJ_DATA *obj )
{
   if ( obj->wear_loc != WEAR_BELT_1
     && obj->wear_loc != WEAR_BELT_2
     && obj->wear_loc != WEAR_BELT_3
     && obj->wear_loc != WEAR_BELT_4
     && obj->wear_loc != WEAR_BELT_5 )
   return FALSE;

   if ( hand_empty( ch ) == WEAR_NONE )
   return FALSE;

   obj->wear_loc = hand_empty( ch );
   act( "$n draws $p from $s belt.", ch, obj, NULL, TO_ROOM );
   act( "You draw $p from your belt.", ch, obj, NULL, TO_CHAR );
   return TRUE;

}



bool sheath_obj( CHAR_DATA *ch, OBJ_DATA *obj )
{
   if ( obj == NULL )
   return FALSE;

   if ( !IS_SET( obj->wear_flags, ITEM_WEAR_BELT ) )
   return FALSE;

   if ( get_eq_char( ch, WEAR_WAIST ) == NULL )
   {
       send_to_char( "You need a belt to sheath it in.\n\r", ch );
       return TRUE;
   }

   if ( obj->wear_loc != WEAR_NONE
     && obj->wear_loc != WEAR_HOLD_1
     && obj->wear_loc != WEAR_HOLD_2 )
   return FALSE;

   if ( belt_empty( ch ) == WEAR_NONE )
   {
       send_to_char( "Remove something from your belt first.\n\r", ch );
       return TRUE;
   }

   obj->wear_loc = belt_empty( ch );
   act( "$n sheaths $p in $s belt.", ch, obj, NULL, TO_ROOM );
   act( "You sheath $p in your belt.", ch, obj, NULL, TO_CHAR );
   return TRUE;

}

/*
 * Remove an object.
 */
bool remove_obj( CHAR_DATA *ch, int iWear, bool fReplace )
{
    OBJ_DATA *obj;

    if ( ( obj = get_eq_char( ch, iWear ) ) == NULL )
	return TRUE;

    if ( !fReplace )
	return FALSE;

    if ( NOT_WORN( obj ) )
    {
    act( "You can't remove $p, since it is already!", ch, obj, NULL, TO_CHAR );
    return FALSE;
    }

    if ( hand_empty( ch ) == WEAR_NONE )
    {
        send_to_char( "You're hands are full.\n\r", ch );
        return FALSE;
    }

    if ( IS_SET(obj->extra_flags, ITEM_NOREMOVE) && !IS_IMMORTAL(ch) )
    {
	act( "You can't remove $p.", ch, obj, NULL, TO_CHAR );
	return FALSE;
    }

    if ( obj->wear_loc == WEAR_WAIST )
    {
        OBJ_DATA *obj2;
        bool fFound = FALSE;
        int curwear;

        for ( curwear = WEAR_BELT_1; curwear <= WEAR_BELT_5; curwear++ )
        {
           obj2 = get_eq_char( ch, curwear );
           if (obj2 != NULL)
           {
                 fFound = TRUE;
                 obj_from_char( obj2 );
                 obj_to_room( obj2, ch->in_room );
           }
        }

        if (fFound)
        {
        act( "Everything on $n's belt clatters to the floor.", ch,
                               NULL, NULL, TO_ROOM );
        send_to_char( "Everything on your belt clatters to the floor!\n\r", ch );
        }
    }

    if ( unequip_char( ch, obj ) )
    {
        act( "$n stops using $p.", ch, obj, NULL, TO_ROOM );
        act( "You stop using $p.", ch, obj, NULL, TO_CHAR );
    }
    else
    {
        send_to_char( "Your hands are full.\n\r", ch );
        return FALSE;
    }

    return TRUE;
}


#define NOTPET(wb)        ( (IS_NPC(ch)                         \
                          && IS_SET(ch->act, ACT_PET)           \
                          && wb != ITEM_WEAR_SHOULDER           \
                          && wb != ITEM_WEAR_WAIST              \
                          && wb != ITEM_WEAR_ABOUT) )

/*
 * Wear one object.
 * Optional replacement of existing objects.
 * Big repetitive code, ick.
 */
void wear_obj( CHAR_DATA *ch, OBJ_DATA *obj, bool fReplace, int loc )
{
    if ( NOTPET(loc) ) return;

    if ( CAN_WEAR( obj, ITEM_WEAR_FINGER ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_FINGER )
    {

	if ( get_eq_char( ch, WEAR_FINGER_L ) != NULL
	&&   get_eq_char( ch, WEAR_FINGER_R ) != NULL
	&&   !remove_obj( ch, WEAR_FINGER_L, fReplace )
	&&   !remove_obj( ch, WEAR_FINGER_R, fReplace ) )
	    return;

	if ( get_eq_char( ch, WEAR_FINGER_L ) == NULL )
	{
        act( "$n slips $p onto $s left finger.",    ch, obj, NULL, TO_ROOM );
        act( "You slip $p onto your left finger.",  ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_FINGER_L );
	    return;
	}

	if ( get_eq_char( ch, WEAR_FINGER_R ) == NULL )
	{
        act( "$n slips $p onto $s right finger.",   ch, obj, NULL, TO_ROOM );
        act( "You slip $p onto your right finger.", ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_FINGER_R );
	    return;
	}

	bug( "Wear_obj: no free finger.", 0 );
	send_to_char( "You already wear two rings.\n\r", ch );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_NECK ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_NECK )
    {

	if ( get_eq_char( ch, WEAR_NECK_1 ) != NULL
	&&   get_eq_char( ch, WEAR_NECK_2 ) != NULL
	&&   !remove_obj( ch, WEAR_NECK_1, fReplace )
	&&   !remove_obj( ch, WEAR_NECK_2, fReplace ) )
	    return;

	if ( get_eq_char( ch, WEAR_NECK_1 ) == NULL )
	{
        act( "$n clasps $p around $s neck.",   ch, obj, NULL, TO_ROOM );
        act( "You clasp $p around your neck.", ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_NECK_1 );
	    return;
	}

	if ( get_eq_char( ch, WEAR_NECK_2 ) == NULL )
	{
        act( "$n clasps $p around $s neck.",   ch, obj, NULL, TO_ROOM );
        act( "You clasp $p around your neck.", ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_NECK_2 );
	    return;
	}

    bug( "Wear_obj: no free neck.", 0 );
	send_to_char( "You already wear two neck items.\n\r", ch );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_BODY ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_BODY )
    {

	if ( !remove_obj( ch, WEAR_BODY, fReplace ) )
	    return;
	act( "$n wears $p on $s body.",   ch, obj, NULL, TO_ROOM );
	act( "You wear $p on your body.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_BODY );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_HEAD ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_HEAD )
    {

	if ( !remove_obj( ch, WEAR_HEAD, fReplace ) )
	    return;
    act( "$n dons $p on $s head.",   ch, obj, NULL, TO_ROOM );
    act( "You don $p on your head.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_HEAD );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_LEGS ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_LEGS )
    {

	if ( !remove_obj( ch, WEAR_LEGS, fReplace ) )
	    return;
	act( "$n wears $p on $s legs.",   ch, obj, NULL, TO_ROOM );
	act( "You wear $p on your legs.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_LEGS );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_FEET ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_FEET )
    {

	if ( !remove_obj( ch, WEAR_FEET, fReplace ) )
	    return;
    act( "$n slips $s feet into $p.",   ch, obj, NULL, TO_ROOM );
    act( "You slip your feet into $p.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_FEET );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_HANDS ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_HANDS )
    {

	if ( !remove_obj( ch, WEAR_HANDS, fReplace ) )
	    return;
	act( "$n wears $p on $s hands.",   ch, obj, NULL, TO_ROOM );
	act( "You wear $p on your hands.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_HANDS );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_ARMS ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_ARMS )
    {

	if ( !remove_obj( ch, WEAR_ARMS, fReplace ) )
	    return;
	act( "$n wears $p on $s arms.",   ch, obj, NULL, TO_ROOM );
	act( "You wear $p on your arms.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_ARMS );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_ABOUT ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_ABOUT )
    {
	if ( !remove_obj( ch, WEAR_ABOUT, fReplace ) )
	    return;
	act( "$n wraps $p about $s body.",   ch, obj, NULL, TO_ROOM );
	act( "You wrap $p about your body.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_ABOUT );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_WAIST ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_WAIST )
    {

	if ( !remove_obj( ch, WEAR_WAIST, fReplace ) )
	    return;
    act( "$n fastens $p around $s waist.",   ch, obj, NULL, TO_ROOM );
    act( "You fasten $p around your waist.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_WAIST );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_WRIST ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_WRIST )
    {

	if ( get_eq_char( ch, WEAR_WRIST_L ) != NULL
	&&   get_eq_char( ch, WEAR_WRIST_R ) != NULL
	&&   !remove_obj( ch, WEAR_WRIST_L, fReplace )
	&&   !remove_obj( ch, WEAR_WRIST_R, fReplace ) )
	    return;

	if ( get_eq_char( ch, WEAR_WRIST_L ) == NULL )
	{
	    act( "$n clips $p around $s left wrist.",
		ch, obj, NULL, TO_ROOM );
	    act( "You clip $p around your left wrist.",
		ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_WRIST_L );
	    return;
    }

	if ( get_eq_char( ch, WEAR_WRIST_R ) == NULL )
	{
	    act( "$n clips $p around $s right wrist.",
		ch, obj, NULL, TO_ROOM );
	    act( "You clip $p around your right wrist.",
		ch, obj, NULL, TO_CHAR );
	    equip_char( ch, obj, WEAR_WRIST_R );
	    return;
	}

	bug( "Wear_obj: no free wrist.", 0 );
	send_to_char( "You already wear two wrist items.\n\r", ch );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_SHOULDER ) )
    {
    if ( loc == 0 || loc == ITEM_WEAR_SHOULDER )
    {

    if ( get_eq_char( ch, WEAR_SHOULDER_L ) != NULL
    &&   get_eq_char( ch, WEAR_SHOULDER_R ) != NULL
    &&   !remove_obj( ch, WEAR_SHOULDER_L, fReplace )
    &&   !remove_obj( ch, WEAR_SHOULDER_R, fReplace ) )
	    return;

    if ( get_eq_char( ch, WEAR_SHOULDER_L ) == NULL )
	{
        act( "$n slings $p over $s left shoulder.",
		ch, obj, NULL, TO_ROOM );
        act( "You sling $p over your left shoulder.",
		ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_SHOULDER_L );
	    return;
    }

    if ( get_eq_char( ch, WEAR_SHOULDER_R ) == NULL )
	{
        act( "$n slings $p over $s right shoulder.",
		ch, obj, NULL, TO_ROOM );
        act( "You sling $p over your right shoulder.",
		ch, obj, NULL, TO_CHAR );
        equip_char( ch, obj, WEAR_SHOULDER_R );
	    return;
	}

    bug( "Wear_obj: no free shoulder.", 0 );
    send_to_char( "You already wear two items on your shoulders.\n\r", ch );
	return;
    }
    }

    if ( CAN_WEAR( obj, ITEM_WEAR_SHIELD ) )
    {
	if ( !remove_obj( ch, WEAR_SHIELD, fReplace ) )
	    return;
    act( "$n straps $p to $s arm as a shield.", ch, obj, NULL, TO_ROOM );
    act( "You strap $p to your arm as a shield.", ch, obj, NULL, TO_CHAR );
	equip_char( ch, obj, WEAR_SHIELD );
	return;
    }

    if ( CAN_WEAR( obj, ITEM_HOLD ) && hand_empty( ch ) != WEAR_NONE )
    {
    if ( !remove_obj( ch, obj->wear_loc, fReplace ) )
        return;
    act( "$n holds $p in $s hand.", ch, obj, NULL, TO_ROOM );
    act( "You hold $p in your hand.", ch, obj, NULL, TO_CHAR );
    equip_char( ch, obj, hand_empty( ch ) );
	return;
    }

    if ( fReplace )
    send_to_char( "You can't wear, wield, or hold that there.\n\r", ch );

    return;
}



void do_wear( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    argument = one_argument( argument, arg1 );
    one_argument( argument, arg2 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Wear what?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg1, "all" ) )
    {
	OBJ_DATA *obj_next;

	for ( obj = ch->carrying; obj != NULL; obj = obj_next )
	{
	    obj_next = obj->next_content;
        if ( (obj->wear_loc == WEAR_NONE || obj->wear_loc == WEAR_HOLD_1 ||
              obj->wear_loc == WEAR_HOLD_2)
           && can_see_obj( ch, obj )
           && !TOO_SMALL(ch, obj)
           && !TOO_BIG(ch, obj) )
        wear_obj( ch, obj, FALSE, 0 );
	}
	return;
    }
    else
    {
    if ( ( obj = get_obj_held( ch, arg1 ) ) == NULL )
	{
        send_to_char( "You do not have that item in your hand.\n\r", ch );
	    return;
	}

    if ( TOO_BIG(ch,obj) || TOO_SMALL(ch,obj) )
    {
        send_to_char( "It doesn't fit you.\n\r", ch );
        return;
    }

    if ( obj->value[3] && ch->size )
    {
        if ( obj->value[3] < ch->size )
        send_to_char( "It looks a bit snug.\n\r", ch );
        if ( obj->value[3] > ch->size )
        send_to_char( "It looks a bit loose.\n\r", ch );
    }
    wear_obj( ch, obj, TRUE, wear_name_bit( arg2 ) );
    }

    return;
}


void do_sheath( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_STRING_LENGTH];
    OBJ_DATA *obj;

    argument = one_argument( argument, arg1 );

    if ( ( obj = get_obj_held( ch, arg1 ) ) == NULL )
    {
        if ( get_item_held( ch, ITEM_WEAPON ) != NULL )
             sheath_obj( ch, get_item_held( ch, ITEM_WEAPON ) );
        if ( get_item_held( ch, ITEM_WEAPON ) != NULL )
             sheath_obj( ch, get_item_held( ch, ITEM_WEAPON ) );
        return;
    }

    if (!sheath_obj( ch, obj ))  send_to_char( "You can't do that!\n\r", ch );
    return;
}


void do_draw( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_STRING_LENGTH];
    OBJ_DATA *obj;
 
    argument = one_argument( argument, arg1 );
 
    if ( ( obj = get_obj_wear( ch, arg1 ) ) == NULL )
      {    
       if ( ( obj = get_eq_char( ch, WEAR_BELT_1 ) ) != NULL ) 
          draw_obj( ch, obj );
       if ( ( obj = get_eq_char( ch, WEAR_BELT_2 ) ) != NULL ) 
          draw_obj( ch, obj );                 
       if ( ( obj = get_eq_char( ch, WEAR_BELT_3 ) ) != NULL ) 
          draw_obj( ch, obj );
       if ( ( obj = get_eq_char( ch, WEAR_BELT_4 ) ) != NULL ) 
          draw_obj( ch, obj );
       if ( ( obj = get_eq_char( ch, WEAR_BELT_5 ) ) != NULL ) 
          draw_obj( ch, obj );
          
       return;
     }
 
    if (!draw_obj( ch, obj ))  send_to_char( "You can't do that!\n\r", ch );
    return;
  }
 
 
void do_remove( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Remove what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_wear( ch, arg ) ) == NULL )
    {
	send_to_char( "You do not have that item.\n\r", ch );
	return;
    }

    remove_obj( ch, obj->wear_loc, TRUE );
    return;
}


void do_sacrifice( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if ( arg[0] == '\0' || !str_cmp( arg, NAME(ch) ) )
    {
    act( "$n offers $mself to Locke, who graciously declines.",
	    ch, NULL, NULL, TO_ROOM );
	send_to_char(
        "Locke appreciates your offer and may accept it later.\n\r", ch );
	return;
    }

    obj = get_obj_list( ch, arg, ch->in_room->contents );
    if ( obj == NULL )
    {
	send_to_char( "You can't find it.\n\r", ch );
	return;
    }

    if ( !CAN_WEAR(obj, ITEM_TAKE) )
    {
	act( "$p is not an acceptable sacrifice.", ch, obj, 0, TO_CHAR );
	return;
    }

    send_to_char( "A mystical copper coin materializes in your coinpurse!\n\r", ch );
    create_amount( 1, ch, NULL, NULL );

    act( "$n sacrifices $p to Locke.", ch, obj, NULL, TO_ROOM );
    extract_obj( obj );
    return;
}



void do_quaff( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Quaff what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_inv( ch, arg ) ) == NULL )
    {
	send_to_char( "You do not have that potion.\n\r", ch );
	return;
    }

    if ( obj->item_type != ITEM_POTION )
    {
	send_to_char( "You can quaff only potions.\n\r", ch );
	return;
    }

    act( "$n quaffs $p.", ch, obj, NULL, TO_ROOM );
    act( "You quaff $p.", ch, obj, NULL ,TO_CHAR );

    obj_cast_spell( obj->value[1], obj->value[0], ch, ch, NULL );
    obj_cast_spell( obj->value[2], obj->value[0], ch, ch, NULL );
    obj_cast_spell( obj->value[3], obj->value[0], ch, ch, NULL );

    extract_obj( obj );
    return;
}



void do_recite( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *scroll;
    OBJ_DATA *obj;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( ( scroll = get_obj_inv( ch, arg1 ) ) == NULL )
    {
	send_to_char( "You do not have that scroll.\n\r", ch );
	return;
    }

    if ( scroll->item_type != ITEM_SCROLL )
    {
	send_to_char( "You can recite only scrolls.\n\r", ch );
	return;
    }

    obj = NULL;
    if ( arg2[0] == '\0' )
    {
	victim = ch;
    }
    else
    {
	if ( ( victim = get_char_room ( ch, arg2 ) ) == NULL
	&&   ( obj    = get_obj_here  ( ch, arg2 ) ) == NULL )
	{
	    send_to_char( "You can't find it.\n\r", ch );
	    return;
	}
    }

    act( "$n recites $p.", ch, scroll, NULL, TO_ROOM );
    act( "You recite $p.", ch, scroll, NULL, TO_CHAR );

    obj_cast_spell( scroll->value[1], scroll->value[0], ch, victim, obj );
    obj_cast_spell( scroll->value[2], scroll->value[0], ch, victim, obj );
    obj_cast_spell( scroll->value[3], scroll->value[0], ch, victim, obj );

    extract_obj( scroll );
    return;
}



void do_brandish( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *vch;
    CHAR_DATA *vch_next;
    OBJ_DATA *staff;
    int sn;

    if ( ( staff = get_item_held( ch, ITEM_STAFF ) ) == NULL )
    {
    send_to_char( "You don't have the staff in your hand.\n\r", ch );
	return;
    }


    if ( ( sn = staff->value[3] ) < 0
    ||   sn >= MAX_SKILL
    ||   skill_table[sn].spell_fun == 0 )
    {
	bug( "Do_brandish: bad sn %d.", sn );
	return;
    }

    WAIT_STATE( ch, 2 * PULSE_VIOLENCE );

    if ( staff->value[2] > 0 )
    {
    act( "$n raises $p into the air and mutters mystical words under $s breath.",
         ch, staff, NULL, TO_ROOM );
    act( "You brandish $p.", ch, staff, NULL, TO_CHAR );
	for ( vch = ch->in_room->people; vch; vch = vch_next )
	{
	    vch_next	= vch->next_in_room;

	    switch ( skill_table[sn].target )
	    {
	    default:
		bug( "Do_brandish: bad target for sn %d.", sn );
		return;

	    case TAR_IGNORE:
		if ( vch != ch )
		    continue;
		break;

	    case TAR_CHAR_OFFENSIVE:
		if ( IS_NPC(ch) ? IS_NPC(vch) : !IS_NPC(vch) )
		    continue;
		break;
		
	    case TAR_CHAR_DEFENSIVE:
		if ( IS_NPC(ch) ? !IS_NPC(vch) : IS_NPC(vch) )
		    continue;
		break;

	    case TAR_CHAR_SELF:
		if ( vch != ch )
		    continue;
		break;
	    }

	    obj_cast_spell( staff->value[3], staff->value[0], ch, vch, NULL );
	}
    }

    if ( --staff->value[2] <= 0 )
    {
	act( "$n's $p blazes bright and is gone.", ch, staff, NULL, TO_ROOM );
	act( "Your $p blazes bright and is gone.", ch, staff, NULL, TO_CHAR );
	extract_obj( staff );
    }

    return;
}



void do_zap( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *wand;
    OBJ_DATA *obj;

    one_argument( argument, arg );
    if ( arg[0] == '\0' && ch->fighting == NULL )
    {
	send_to_char( "Zap whom or what?\n\r", ch );
	return;
    }

    if ( ( wand = get_item_held( ch, ITEM_WAND ) ) == NULL )
    {
    send_to_char( "You don't have a wand in your hand.\n\r", ch );
	return;
    }

    obj = NULL;
    if ( arg[0] == '\0' )
    {
	if ( ch->fighting != NULL )
	{
	    victim = ch->fighting;
	}
	else
	{
	    send_to_char( "Zap whom or what?\n\r", ch );
	    return;
	}
    }
    else
    {
	if ( ( victim = get_char_room ( ch, arg ) ) == NULL
	&&   ( obj    = get_obj_here  ( ch, arg ) ) == NULL )
	{
	    send_to_char( "You can't find it.\n\r", ch );
	    return;
	}
    }

    WAIT_STATE( ch, 2 * PULSE_VIOLENCE );

    if ( wand->value[2] > 0 )
    {
	if ( victim != NULL )
	{
	    act( "$n zaps $N with $p.", ch, wand, victim, TO_ROOM );
	    act( "You zap $N with $p.", ch, wand, victim, TO_CHAR );
	}
	else
	{
	    act( "$n zaps $P with $p.", ch, wand, obj, TO_ROOM );
	    act( "You zap $P with $p.", ch, wand, obj, TO_CHAR );
	}

	obj_cast_spell( wand->value[3], wand->value[0], ch, victim, obj );
    }

    if ( --wand->value[2] <= 0 )
    {
	act( "$n's $p explodes into fragments.", ch, wand, NULL, TO_ROOM );
	act( "Your $p explodes into fragments.", ch, wand, NULL, TO_CHAR );
	extract_obj( wand );
    }

    return;
}



void do_steal( CHAR_DATA *ch, char *argument )
{
    char buf  [MAX_STRING_LENGTH];
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    int percent;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
	send_to_char( "Steal what from whom?\n\r", ch );
	return;
    }

    if ( hand_empty( ch ) == WEAR_NONE )
    {
        send_to_char( "You'll need to free a hand first.\n\r", ch );
        return;
    }

    if ( ( victim = get_char_room( ch, arg2 ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim == ch )
    {
    send_to_char( "Like a dull sword, that's pointless.\n\r", ch );
	return;
    }

    WAIT_STATE( ch, skill_table[gsn_steal].beats );
    percent  = number_percent( ) + ( IS_AWAKE(victim) ? 10 : -50 );

    if ( victim->position == POS_FIGHTING
    || ( !IS_NPC(ch) && percent > ch->pcdata->learned[gsn_steal] ) )
    {
	/*
	 * Failure.
	 */
            ch->bounty += 10;
	send_to_char( "Oops.\n\r", ch );
	act( "$n tried to steal from you.\n\r", ch, NULL, victim, TO_VICT    );
	act( "$n tried to steal from $N.\n\r",  ch, NULL, victim, TO_NOTVICT );
        sprintf( buf, "%s is a bloody thief!", NAME(ch) );
        send_to_char( buf, victim );
	if ( !IS_NPC(ch) )
	{
	    if ( IS_NPC(victim) )
	    {
		multi_hit( victim, ch, TYPE_UNDEFINED );
	    }
	    else
	    {
		log_string( buf );
	    }
	}

	return;
    }

    if ( ( obj = get_obj_inv( victim, arg1 ) ) == NULL )
    {
	send_to_char( "You can't find it.\n\r", ch );
	return;
    }
	
    if ( !can_drop_obj( ch, obj )
    ||   IS_SET(obj->extra_flags, ITEM_INVENTORY)
    ||   obj->level > ch->level )
    {
	send_to_char( "You can't pry it away.\n\r", ch );
	return;
    }

    if ( ch->carry_weight + get_obj_weight( obj ) > can_carry_w( ch ) )
    {
	send_to_char( "You can't carry that much weight.\n\r", ch );
	return;
    }

    obj_from_char( obj );
    obj_to_char( obj, ch );
    obj->wear_loc = hand_empty( ch );
    send_to_char( "Stolen.\n\r", ch );
    return;
}


void do_light( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    OBJ_DATA *obj2;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
        obj = get_item_held( ch, ITEM_LIGHT );
   else obj = get_obj_held( ch, arg );

    obj2 = get_item_held( ch, ITEM_TOOL );

    if ( obj == NULL )
    {
        send_to_char( "You don't have the light in your hands.\n\r", ch );
        return;
    }

    if ( IS_LIT( obj ) )
    {
        send_to_char( "It's lit already!\n\r", ch );
        return;
    }

    if ( obj->value[0] <= 0 )
    {
        send_to_char( "It's out of fuel.\n\r", ch );
        return;
    }

    if ( obj2 == NULL )
    {
        send_to_char( "You don't have anything to light it with!\n\r", ch );
        return;
    }

    if ( use_tool( obj2, TOOL_TINDERBOX ) )
    {
        SET_BIT(obj->value[3], LIGHT_LIT);
        act( "$n lights $p with $P.", ch, obj, obj2, TO_ROOM );
        act( "You light $p with $P.", ch, obj, obj2, TO_CHAR );

        ch->in_room->light++;
        return;
    }
    else
    {
        send_to_char( "You can't light it with that.\n\r", ch );
        return;
    }

    return;
}


void do_extinguish( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
        obj = get_item_held( ch, ITEM_LIGHT );
   else obj = get_obj_held( ch, arg );

    if ( obj == NULL )
    {
        send_to_char( "You don't have the light in your hands.\n\r", ch );
        return;
    }

    if ( !IS_LIT( obj ) )
    {
        send_to_char( "It's extinguished already!\n\r", ch );
        return;
    }


    REMOVE_BIT( obj->value[3], LIGHT_LIT );
    act( "$n extinguishes $p.", ch, obj, NULL, TO_ROOM );
    act( "You extinguish $p.", ch, obj, NULL, TO_CHAR );

    ch->in_room->light--;
    return;
}

/*
 * Shopping commands.
 */
CHAR_DATA *find_keeper( CHAR_DATA *ch )
{
    CHAR_DATA *keeper;
    SHOP_DATA *pShop;

    pShop = NULL;
    for ( keeper = ch->in_room->people; keeper; keeper = keeper->next_in_room )
    {
	if ( IS_NPC(keeper) && (pShop = keeper->pIndexData->pShop) != NULL )
	    break;
    }

    if ( pShop == NULL )
    {
	send_to_char( "You can't do that here.\n\r", ch );
	return NULL;
    }

    /*
     * Undesirables. (none any more)
     */

    /*
     * Shop hours.
     */
    if ( time_info.hour == 12 )
    {
        do_say( keeper, "I'm on my lunch break, leave me be!" );
        return NULL;
    }

    if ( time_info.hour < pShop->open_hour )
    {
	do_say( keeper, "Sorry, come back later." );
	return NULL;
    }
    
    if ( time_info.hour > pShop->close_hour )
    {
	do_say( keeper, "Sorry, come back tomorrow." );
	return NULL;
    }

    /*
     * Invisible or hidden people.
     */
    if ( !can_see( keeper, ch ) )
    {
    do_say( keeper, "What?  Who said that?" );
	return NULL;
    }

    return keeper;
}



int get_cost( CHAR_DATA *keeper, OBJ_DATA *obj, bool fBuy )
{
    SHOP_DATA *pShop;
    int cost;

    if ( obj == NULL || ( pShop = keeper->pIndexData->pShop ) == NULL )
	return 0;

    if ( fBuy )
    {
        OBJ_DATA *pObj;
        
        cost = obj->cost;
        for ( pObj = obj->contains; pObj != NULL; pObj = pObj->next_content )
          cost += pObj->cost;
          
        cost *= pShop->profit_buy / 100;
    }
    else
    {
	OBJ_DATA *obj2;
	int itype;

	cost = 0;
	for ( itype = 0; itype < MAX_TRADE; itype++ )
	{
	    if ( obj->item_type == pShop->buy_type[itype] )
	    {
		cost = obj->cost * pShop->profit_sell / 100;
		break;
	    }
	}

	for ( obj2 = keeper->carrying; obj2; obj2 = obj2->next_content )
	{
	    if ( obj->pIndexData == obj2->pIndexData )
	    {
		cost = 0;
		break;
	    }
	}
    }

    if ( obj->item_type == ITEM_STAFF || obj->item_type == ITEM_WAND )
	cost = cost * obj->value[2] / obj->value[1];

    return cost;
}


#define PET_COST(pet)              ( (30 * pet->level * pet->level) )


void do_buy( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char tells[MAX_INPUT_LENGTH];

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Buy what?\n\r", ch );
	return;
    }

    if ( IS_SET(ch->in_room->room_flags, ROOM_PET_SHOP) )
    {
	char buf[MAX_STRING_LENGTH];
	CHAR_DATA *pet;
        CHAR_DATA *wch;
        ROOM_INDEX_DATA *pRoomIndexNext;
	ROOM_INDEX_DATA *in_room;

	if ( IS_NPC(ch) )
	    return;

	pRoomIndexNext = get_room_index( ch->in_room->vnum + 1 );
	if ( pRoomIndexNext == NULL )
	{
	    bug( "Do_buy: bad pet shop at vnum %d.", ch->in_room->vnum );
	    send_to_char( "Sorry, you can't buy that here.\n\r", ch );
	    return;
	}

	in_room     = ch->in_room;
	ch->in_room = pRoomIndexNext;
	pet         = get_char_room( ch, arg );
	ch->in_room = in_room;

    if ( pet == NULL || !IS_SET(pet->act, ACT_PET) )
	{
	    send_to_char( "Sorry, you can't buy that here.\n\r", ch );
	    return;
	}

 
    for ( wch = char_list; wch != NULL; wch = wch->next )
      {
        if ( IS_NPC( wch )
          && (wch->master == ch || wch->leader == ch)
          && IS_SET( wch->act, ACT_PET ) )
	  {
           send_to_char( "You already have a follower!\n\r", ch );
           return;
	 }
      }

    if ( tally_coins( ch ) < PET_COST(pet) )
	{
	    send_to_char( "You can't afford it.\n\r", ch );
	    return;
	}

    if ( ch->level < pet->level )
	{
       send_to_char( "Unfortunately, you're not ready for this follower.\n\r", ch );
       return;
	}

    sprintf( buf, "You receive %s in change.\n\r",
                  sub_coins( PET_COST(pet), ch ) );
    send_to_char( buf, ch );

	pet			= create_mobile( pet->pIndexData );
	SET_BIT(ch->act, PLR_BOUGHT_PET);
	SET_BIT(pet->act, ACT_PET);
	SET_BIT(pet->affected_by, AFF_CHARM);

	argument = one_argument( argument, arg );
	if ( arg[0] != '\0' )
	{
        sprintf( buf, "%s %s", NAME(pet), arg );
	    free_string( pet->name );
	    pet->name = str_dup( buf );
	}

	sprintf( buf, "%sA neck tag says 'I belong to %s'.\n\r",
        STR(pet, description), NAME(ch) );
	free_string( pet->description );
	pet->description = str_dup( buf );
        pet->exp = 0;

	char_to_room( pet, ch->in_room );
	add_follower( pet, ch );
    send_to_char( "Enjoy your follower.\n\r", ch );
    act( "$n bought $N as a follower.", ch, NULL, pet, TO_ROOM );
	return;
    }
    else
    {
	CHAR_DATA *keeper;
	OBJ_DATA *obj;
	int cost;
    int looking;

    if ( ( keeper = find_keeper( ch ) ) == NULL )
        return;

    if ( is_number( arg ) )
    {
        looking = atoi( arg );
        cost = 1;
        for ( obj = keeper->carrying; obj != NULL && cost != looking;
              obj = obj->next_content )
        {
             if ( (obj->wear_loc == WEAR_NONE
               ||  obj->wear_loc == WEAR_HOLD_1
               ||  obj->wear_loc == WEAR_HOLD_2)
               && can_see_obj( ch, obj )
               && obj->item_type != ITEM_MONEY
               && ( get_cost( keeper, obj, TRUE ) ) > 0 ) cost++;
        }
    }
    else obj = get_obj_inv( keeper, arg );

	cost = get_cost( keeper, obj, TRUE );

	if ( cost <= 0 || !can_see_obj( ch, obj ) )
	{
        sprintf( tells, "%s I don't sell that -- try 'list'.", NAME(ch) );
        do_tell( keeper, tells );
	    return;
	}

    if ( hand_empty( ch ) == WEAR_NONE )
    {
        send_to_char( "You need to have a free hand for your purchase.\n\r", ch );
        return;
    }

    if ( tally_coins( ch ) < cost )
	{
        sprintf( tells, "%s You don't have enough money to buy %s.", NAME(ch),
                        STR(obj, short_descr) );
        do_tell( keeper, tells );
	    return;
	}

	if ( ch->carry_weight + get_obj_weight( obj ) > can_carry_w( ch ) )
	{
	    send_to_char( "You can't carry that much weight.\n\r", ch );
	    return;
	}

    act( "$n buys $p from $N.", ch, obj, keeper, TO_ROOM );
    act( "You buy $p from $N.", ch, obj, keeper, TO_CHAR );
    sprintf( tells, "%s Here is %s in change.", NAME(ch),
                                                sub_coins( cost, ch ) );
    if ( !strstr( tells, "nothing" ) )
        do_tell( keeper, tells );

    create_amount( cost, keeper, NULL, NULL );

	if ( IS_SET( obj->extra_flags, ITEM_INVENTORY ) )
	  { 
            OBJ_DATA *co = obj->contains;
	    obj = create_object( obj->pIndexData, obj->level );
            for ( ; co != NULL; co  = co->next_content )
	      obj_to_obj( create_object( co->pIndexData, co->level ), obj );
          }
	else
	    obj_from_char( obj );

    obj_to_char( obj, ch );
    obj->wear_loc = hand_empty( ch );
	return;
    }
}



void do_list( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];

    if ( IS_SET(ch->in_room->room_flags, ROOM_PET_SHOP) )
    {
	ROOM_INDEX_DATA *pRoomIndexNext;
	CHAR_DATA *pet;
	bool found;

	pRoomIndexNext = get_room_index( ch->in_room->vnum + 1 );
	if ( pRoomIndexNext == NULL )
	{
	    bug( "Do_list: bad pet shop at vnum %d.", ch->in_room->vnum );
	    send_to_char( "You can't do that here.\n\r", ch );
	    return;
	}

	found = FALSE;
	for ( pet = pRoomIndexNext->people; pet; pet = pet->next_in_room )
	{
	    if ( IS_SET(pet->act, ACT_PET) )
	    {
		if ( !found )
		{
		    found = TRUE;
            send_to_char( "Available followers:\n\r", ch );
		}
		sprintf( buf, "[%2d] %28s - %s\n\r",
		    pet->level,
            name_amount( PET_COST(pet) ),
                    STR(pet, short_descr) );
		send_to_char( buf, ch );
	    }
	}
	if ( !found )
        send_to_char( "You notice a sign that reads:\n\rNothing for sale right now.\n\r", ch );
	return;
    }
    else
    {
	char arg[MAX_INPUT_LENGTH];
	CHAR_DATA *keeper;
	OBJ_DATA *obj;
	int cost;
        int num;
        bool found;

	one_argument( argument, arg );

	if ( ( keeper = find_keeper( ch ) ) == NULL )
	    return;

	found = FALSE;
        num = 1;
	for ( obj = keeper->carrying; obj; obj = obj->next_content )
	{
        if ( (obj->wear_loc == WEAR_NONE
           || obj->wear_loc == WEAR_HOLD_1
           || obj->wear_loc == WEAR_HOLD_2 )
	    &&   can_see_obj( ch, obj )
        && obj->item_type != ITEM_MONEY
	    && ( cost = get_cost( keeper, obj, TRUE ) ) > 0
        && ( arg[0] == '\0' || is_name( arg, STR(obj, name) ) ) )
	    {
		if ( !found )
		{
		    found = TRUE;
		}

        sprintf( buf, "[%3d] %s for %s.\n\r", num,
                                         capitalize( STR(obj, short_descr) ),
                                         name_amount( cost ) );
		send_to_char( buf, ch );
        num++;
	    }
	}

	if ( !found )
	{
	    if ( arg[0] == '\0' )
        send_to_char( "You can't buy anything here right now.\n\r", ch );
	    else
		send_to_char( "You can't buy that here.\n\r", ch );
	}
	return;
    }
}



void do_sell( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    char tells[MAX_INPUT_LENGTH];
    CHAR_DATA *keeper;
    OBJ_DATA *obj;
    int cost;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Sell what?\n\r", ch );
	return;
    }

    if ( ( keeper = find_keeper( ch ) ) == NULL )
	return;

    if ( ( obj = get_obj_carry( ch, arg ) ) == NULL )
    {
        sprintf( tells, "%s You aren't holding that item!", NAME(ch) );
        do_tell( keeper, tells );
        return;
    }

    if ( !can_drop_obj( ch, obj ) )
    {
        send_to_char( "You can't let go of it.\n\r", ch );
        return;
    }

    if ( ( cost = get_cost( keeper, obj, FALSE ) ) <= 0 )
    {
        act( "$n looks at $p and shrugs.", keeper, obj, ch, TO_VICT );
        return;
    }

    act( "$n sells $p to $N.", ch, obj, keeper, TO_ROOM );
    sprintf( buf, "You sell $p for %s to $N.", name_amount( cost ) );
    act( buf, ch, obj, keeper, TO_CHAR );
    create_amount( cost, ch, NULL, NULL );

    if ( obj->item_type == ITEM_TRASH )
    {
    act( "$n eats $p, munching hungrily.", keeper, obj, NULL, TO_NOTVICT );
	extract_obj( obj );
    }
    else
    {
	obj_from_char( obj );
	obj_to_char( obj, keeper );
    }

    return;
}



void do_value( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char tells[MAX_INPUT_LENGTH];
    CHAR_DATA *keeper;
    OBJ_DATA *obj;
    int cost;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Value what?\n\r", ch );
	return;
    }

    if ( ( keeper = find_keeper( ch ) ) == NULL )
	return;

    if ( ( obj = get_obj_carry( ch, arg ) ) == NULL )
    {
        sprintf( tells, "%s You aren't holding that item!", NAME(ch) );
        do_tell( keeper, tells );
        return;
    }

    if ( !can_drop_obj( ch, obj ) )
    {
        send_to_char( "You can't let go of it.\n\r", ch );
        return;
    }

    if ( ( cost = get_cost( keeper, obj, FALSE ) ) <= 0 )
    {
        act( "$n looks at $p and shrugs.", keeper, obj, ch, TO_VICT );
	return;
    }

    sprintf( tells, "%s I guess I'd give you %s for %s.", NAME(ch),
                  name_amount( cost ), STR(obj, short_descr) );
    do_tell( keeper, tells );
    return;
}

