/****************************************************************************
 *   ___  ___  ___  __    __                                                *
 *  |   ||   ||   ||  |\/|  | 2-x    NiMUD is a software currently under    *
 *   |  \ | |  | |  | |\/| |         development.  It is based primarily on *
 *   | |\\| |  | |  | |  | |         the discontinued package, Merc 2.2.    *
 *   | | \  |  | |  | |  | |         NiMUD is being written and developed   *
 *  |___||___||___||__|  |__|        By Locke and Surreality as a new,      *
 *   NAMELESS INCARNATE *MUD*        frequently updated package similar to  *
 *        S O F T W A R E            the original Merc 2.x.                 *
 *                                                                          *
 *  Just look for the Iron Maiden skull wherever NiMUD products are found.  *
 *                                                                          *
 *  Much time and thought has gone into this software and you are           *
 *  benefitting.  We hope that you share your changes too.  What goes       *
 *  around, comes around.                                                   *
 ****************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"

#define OLD 1
#define NEW 2


void do_breath( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    int level = ch->level;
    CHAR_DATA *vo = ch->fighting;
    
    argument = one_argument( argument, arg );
    
    if ( ch->race != RACE_DRAGONKIN || IS_NPC( ch ) )
      {
        send_to_char( "Only for Dragonkin!\n\r", ch );
        return;
      }
    
    if ( ch->fighting == NULL )
      {
        send_to_char( "You're not fighting anyone.\n\r", ch );
        return;
      }
    
     if ( !str_cmp( arg, "fire" ) )
      spell_fire_breath( skill_lookup( "fire breath" ), level, ch, vo );
else if ( !str_cmp( arg, "acid" ) && ch->level >= 10 )
      spell_acid_breath( skill_lookup( "acid breath" ), level, ch, vo );
else if ( !str_cmp( arg, "frost" ) && ch->level >= 15 )
      spell_frost_breath( skill_lookup( "frost breath" ), level, ch, vo );
else if ( !str_cmp( arg, "gas" ) && ch->level >= 20 )
      spell_gas_breath( skill_lookup( "gas breath" ), level, ch, vo );           
else if ( !str_cmp( arg, "lightning" ) && ch->level >= 25 )
      spell_lightning_breath( skill_lookup( "lightning breath" ), level, ch, vo );
else
  {
           send_to_char( "You can't use that breath weapon, yet.\n\r", ch );
           return;
	 }

      WAIT_STATE( ch,  24 );      
      return;
  }


void do_infravision( CHAR_DATA *ch, char *argument )
{
    /*
     * Check for race (pardon the endless switch statement!)
     */

    switch ( ch->race )
    {
             default: send_to_char( "You lack that ability.\n\r", ch ); return;
       case RACE_ELF:
   case RACE_HALFELF:
   case RACE_WILDELF:
 case RACE_SHADOWELF:
      case RACE_DROW: break;
    }

    if ( IS_SET( ch->affected_by, AFF_INFRARED ) )
    {
        send_to_char( "You're already seeing in the dark!\n\r", ch );
        return;
    }

    affect_strip( ch, skill_lookup( "infravision" ) );
    spell_infravision( skill_lookup( "infravision" ), ch->level, ch, ch );

    return;
}

void do_meld( CHAR_DATA *ch, char *argument )
{
    /*
     * Check for race (pardon the endless switch statement!)
     */

    switch ( ch->race )
    {
             default: send_to_char( "You lack that ability.\n\r", ch ); return;
     case RACE_SKULK: break;
    }

    if ( IS_SET( ch->affected_by, AFF_INVISIBLE ) )
    {
        send_to_char( "You're already invisible!\n\r", ch );
        return;
    }

    affect_strip( ch, skill_lookup( "invisibility" ) );
    spell_invis( skill_lookup( "invisibility" ), ch->level, ch, ch );

    return;
}


void do_fly( CHAR_DATA *ch, char *argument )
{
    /*
     * Check for race (pardon the endless switch statement!)
     */
 
    switch ( ch->race )
      {
      default: send_to_char( "You lack that ability.\n\r", ch ); return;
      case RACE_DRAGONKIN: break;
      }
 
    if ( IS_SET( ch->affected_by, AFF_FLYING ) )
      {
        send_to_char( "You're already flying!\n\r", ch );
        return;
      }
 
    affect_strip( ch, skill_lookup( "fly" ) );
    spell_fly( skill_lookup( "fly" ), ch->level, ch, ch );
 
    return;
  }


void do_mount( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, buf );

    if ( buf[0] == '\0' )
    {
        send_to_char( "Mount whom?\n\r", ch );
        return;
    }

    if ( ( victim = get_char_room( ch, buf ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
        return;
    }
    
    if ( ch->riding != NULL )
    {
        send_to_char( "Your already riding someone else!\n\r", ch );
        return;
    }

    if ( ch->mounted_by != NULL )
    {
        send_to_char( "Your being ridden by someone else!\n\r", ch );
        return;
    }

    if ( victim->leader != ch && victim->master != ch )
    {
        send_to_char( "They aren't following you!\n\r", ch );
        return;
    }

    if ( !IS_NPC( ch ) &&
         !IS_SET( victim->act, ACT_MOUNTABLE ) && !IS_IMMORTAL(ch) )
    {
        send_to_char( "You can't ride that.\n\r", ch );
        return;
    }

    if ( victim->riding != NULL )
    {
        send_to_char( "They are riding someone else!\n\r", ch );
        return;
    }

    if ( victim->mounted_by != NULL )
    {
        send_to_char( "They are being ridden by someone else!\n\r", ch );
        return;
    }

    ch->riding          = victim;
    victim->mounted_by  = ch;

    act( "$n mounts $N, and starts riding $M.", ch, NULL, victim, TO_ROOM );
    act( "You mount $N, and start riding $M.",  ch, NULL, victim, TO_CHAR );
    act( "$n mounts you.",  ch, NULL, victim, TO_VICT );
    return;
}

void do_dismount( CHAR_DATA *ch, char *argument )
{
    if ( ch->riding == NULL )
    {
        send_to_char( "You're not riding anything.\n\r", ch );
        return;
    }

    act( "$n dismounts from $N.",  ch, NULL, ch->riding, TO_NOTVICT );
    act( "You dismount from $N.",  ch, NULL, ch->riding, TO_CHAR );
    act( "$n dismounts from you.", ch, NULL, ch->riding, TO_VICT );

    ch->riding->mounted_by = NULL;
    ch->riding             = NULL;
    return;
}


void do_buck( CHAR_DATA *ch, char *argument )
{
    if ( ch->mounted_by == NULL )
    {
        send_to_char( "There is no one riding you.\n\r", ch );
        return;
    }

    act( "$n bucks $N!",             ch, NULL, ch->mounted_by, TO_NOTVICT );
    act( "You buck $M!",             ch, NULL, ch->mounted_by, TO_CHAR );
    act( "$n bucks you from $m!",    ch, NULL, ch->mounted_by, TO_VICT );

    ch->mounted_by->riding   = NULL;
    ch->mounted_by->position = POS_RESTING;
    ch->mounted_by           = NULL;
    return;
}

/***************************************************************************
 *   File: graph.c                                       Part of CircleMUD *
 *  Usage: various graph algorithms                                        *
 *                                                                         *
 *  All rights reserved.  See license.doc for complete information.        *
 *                                                                         *
 *  Copyright (C) 1993 by the Trustees of the Johns Hopkins University     *
 *  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
 ***************************************************************************/


/* #define TRACK_THROUGH_DOORS */

/*
 * You can define or not define TRACK_THOUGH_DOORS, above, depending on
 *  whether or not you want track to find paths which lead through closed
 *  or hidden doors.
 */

/*
 * BFS return values.
 */
#define BFS_ERROR           -1 
#define BFS_ALREADY_THERE   -2  
#define BFS_NO_PATH         -3


struct bfs_queue_struct 
{
   ROOM_INDEX_DATA *room;
   sh_int   dir;
   sh_int   depth;
   struct bfs_queue_struct *next;
};

struct room_list_struct 
{
   ROOM_INDEX_DATA *room;
   struct room_list_struct *next;
};

static struct bfs_queue_struct *queue_head = NULL, *queue_tail = NULL;

static struct room_list_struct *list_head = NULL, *list_tail = NULL;

/* Utility macros */
#define MARK( room )          ( SET_BIT( ( room )->room_flags, BFS_MARK))
#define UNMARK( room )        ( REMOVE_BIT( ( room )->room_flags, BFS_MARK))
#define IS_MARKED( room )     ( IS_SET( ( room )->room_flags, BFS_MARK))
#define TOROOM( room, y )     ( ( room )->exit[ ( y ) ]->to_room )
#define IS_CLOSED( room, y )  ( IS_SET( ( room )->exit[( y )]->exit_info, \
                                EX_CLOSED))

#ifdef TRACK_THROUGH_DOORS
#define VALID_EDGE( room, y )                                              \
                              ( ( room )->exit[( y )] &&                   \
			      ( TOROOM(( room ), ( y ) ) != NOWHERE ) &&   \
			      ( !IS_MARKED( TOROOM( ( room ), ( y ) ) ) ) )
#else
#define VALID_EDGE( room , y )                                             \
                              ( ( room )->exit[ ( y ) ] &&                 \
			      ( TOROOM( ( room ), ( y ) ) != NULL ) &&     \
                              ( !IS_CLOSED( (room), ( y ) ) ) &&           \
                              ( !IS_MARKED( TOROOM( ( room ), ( y ) ) ) ) )
#endif

void list_enqueue( ROOM_INDEX_DATA *room )
{
   static struct room_list_struct *curr;

   curr = alloc_mem( sizeof( struct room_list_struct ) );
   curr->room = room;
   curr->next = NULL;

   if( list_tail != NULL )
   {
      list_tail->next = curr;
      list_tail = curr;
   }
   else
      list_head = list_tail = curr;

   return;
}

void bfs_enqueue( ROOM_INDEX_DATA *room, sh_int dir, sh_int depth )
{
   struct bfs_queue_struct *curr;

   curr = alloc_mem( sizeof( struct bfs_queue_struct ) );
   curr->room = room;
   curr->dir = dir;
   curr->depth = depth + 1;
   curr->next = NULL;

   if( queue_tail != NULL )
   {
      queue_tail->next = curr;
      queue_tail = curr;
   }
   else
      queue_head = queue_tail = curr;

   list_enqueue( room );

   return;
}

void bfs_dequeue(void)
{
   struct bfs_queue_struct *curr;

   curr = queue_head;

   if( (queue_head = queue_head->next) == NULL )
      queue_tail = NULL;

   free_mem( curr, sizeof( struct bfs_queue_struct ) );
   return;
}

void list_dequeue( void )
{
   struct room_list_struct *curr;

   curr = list_head;

   if( (list_head = list_head->next) == NULL )
      list_tail = NULL;

   UNMARK( curr->room );
   free_mem( curr, sizeof( struct room_list_struct ) );
   return;
}

void bfs_clear_queue(void) 
{
   while( queue_head != NULL )
      bfs_dequeue();
   return;
}

void list_clear_queue( void )
{
   while( list_head != NULL )
      list_dequeue();
}

/* find_first_step: given a source room and a target room, find the first
   step on the shortest path from the source to the target.

   Intended usage: in mobile_activity, give a mob a dir to go if they're
   tracking another mob or a PC.  Or, a 'track' skill for PCs.
*/


int find_first_step( ROOM_INDEX_DATA *src, ROOM_INDEX_DATA *target)
{
   int curr_dir;

   if ( src == NULL || target == NULL ) {
      bug("Illegal value passed to find_first_step (graph.c)", 0 );
      return BFS_ERROR;
   }

   if (src == target)
      return BFS_ALREADY_THERE;

   queue_head = queue_tail = NULL;
   list_head = list_tail = NULL;

   MARK( src );
   list_enqueue( src );

   /* first, enqueue the first steps, saving which direction we're going. */
   for (curr_dir = 0; curr_dir < 6; curr_dir++)
      if ( VALID_EDGE( src, curr_dir ) ) 
      {
         MARK( TOROOM( src, curr_dir ) );
         bfs_enqueue( TOROOM( src, curr_dir ), curr_dir, 0 );
      }

   /* now, do the classic BFS. */
   while( queue_head )
   {
      if( queue_head->depth >= 10 )
      {
         bfs_clear_queue();
         list_clear_queue();
         return BFS_NO_PATH;
      }
      if( queue_head->room == target ) 
      {
	 curr_dir = queue_head->dir;
	 bfs_clear_queue();
         list_clear_queue();
	 return curr_dir;
      }
      else
      {
         for( curr_dir = 0; curr_dir < MAX_DIR; curr_dir++ )
         {
            if (VALID_EDGE( queue_head->room, curr_dir ) ) 
            {
               MARK( TOROOM( queue_head->room, curr_dir ) );
	       bfs_enqueue( TOROOM( queue_head->room, curr_dir  ),
                queue_head->dir, queue_head->depth );
            }
         }
         bfs_dequeue();
      }
   }
   list_clear_queue();
   return BFS_NO_PATH;
}


/************************************************************************
*  Functions and Commands which use the above fns		        *
************************************************************************/

void do_track ( CHAR_DATA *ch, char *argument ) 
{
   char buf[MAX_STRING_LENGTH];
   char arg[MAX_INPUT_LENGTH];
   CHAR_DATA *vict;
   int dir;

   if( !skill_check( ch, gsn_track, 0 ) )
   {
      send_to_char( "You can't seem to find any tracks here.\n\r", ch );
      return;
   }

   one_argument(argument, arg);

   if( arg[0] == '\0' && ch->hunting[0] == '\0' )
   {
      send_to_char("Whom are you trying to track?\n\r", ch);
      return;
   }

   if( arg[0] == '\0' && ch->hunting[0] != '\0' )
   {
      do_track( ch, "continue" );
      return;
   }

   if( strcmp( arg, "continue" ) )
   {
      if( ( vict = get_char_world( ch, arg ) ) == NULL )
      {
         send_to_char("No-one around by that name.\n\r", ch);
         free_string( ch->hunting );
         ch->hunting = str_dup( "" );
         return;
      }

      if( ch == vict && ch->hunting[0] != '\0' )
      {
         send_to_char( "You stop looking for signs of your quarry.\n\r", ch );
         free_string( ch->hunting );
         ch->hunting = str_dup( "" );
         return;
      }

      if( ch != vict && ch->hunting[0] != '\0' )
      {
         send_to_char(
          "Type TRACK and your name to stop tracking your quarry.\n\r", ch );
         return;
      }
   }
   else
   {
      if( ch->hunting[0] == '\0' )
      {
         send_to_char( "You aren't tracking anyone.\n\r", ch );
         free_string( ch->hunting );
         ch->hunting = str_dup( "" );
         return;
      }
      if( ( vict = get_char_world( ch, ch->hunting ) ) == NULL )
      {
         send_to_char("You lose track of your quarry.\n\r", ch);
         free_string( ch->hunting );
         ch->hunting = str_dup( "" );
         return;
      }
   }

   dir = find_first_step( ch->in_room, vict->in_room );

   switch( dir )
   {
      case BFS_ERROR:
         send_to_char("Hmm.. something seems to be wrong.\n\r", ch);
         ch->hunting = NULL;
         break;
      case BFS_ALREADY_THERE:
         if( ch->hunting == NULL )
            send_to_char("You're already in the same room!!\n\r", ch);
         else
            send_to_char("You've found your quarry!!\n\r", ch );
         free_string( ch->hunting );
         ch->hunting = str_dup( "" );
         break;
      case BFS_NO_PATH:
         sprintf(buf, "You can't find a trail to %s from here.\n\r",
          vict->sex == SEX_FEMALE ? "her" : "him" );
         send_to_char(buf, ch);
         free_string( ch->hunting );
         ch->hunting = str_dup( "" );
         break;
      default:
         /* if you want to make this into a skill instead of a command,
            the next few lines make it give you a random direction if you
            fail the random skill roll.
         */

         sprintf(buf, "You sense a trail %s from here!\n\r", dir_name[dir]);
         send_to_char(buf, ch);
         if( ch->hunting[0] == '\0' )
            ch->hunting = str_dup( arg );
         break;
   }
   return;
}


void hunt_victim( CHAR_DATA *ch)
{
   char buf[MAX_STRING_LENGTH];
   int dir;
   CHAR_DATA *vict;

   if( ch == NULL || ch->hunting == NULL )
      return;

   /* make sure the char still exists */
   vict = get_char_world( ch, ch->hunting );

   if( vict == NULL ) 
   {
      sprintf(buf, "mutters, 'Lost the trail!'" );
      do_emote(ch, buf);
      free_string( ch->hunting );
      ch->hunting = str_dup( "" );
      return;
   }

   dir = find_first_step(ch->in_room, vict->in_room);

   if( dir < 0 ) 
   {
      sprintf(buf, "Damn!  Lost the trail!"  );
      do_say( ch, buf );
      free_string( ch->hunting );
      ch->hunting = str_dup( "" );
      return;
   }
   else 
   {
      move_char( ch, dir );
      if( ch->in_room == vict->in_room )
      {
         multi_hit( ch, vict, TYPE_UNDEFINED );
         free_string( ch->hunting );
         ch->hunting = str_dup( "" );
      }
      return;
   }
}



