/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"


/*
 * Local variables.
 */

int         FORCE_LEVEL;


/*
 * Local functions.
 */

ROOM_INDEX_DATA *	find_location	args( ( CHAR_DATA *ch, char *arg ) );



void do_notify( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char buf  [MAX_INPUT_LENGTH];

    smash_tilde( argument );
    argument = one_argument( argument, arg1 );

    if ( arg1[0] == '\0' )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY) )
       {
          send_to_char( "NOTIFY is now OFF.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY);
          return;
       }
       else
       {
          send_to_char( "NOTIFY is now ON.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY);
          return;
       }
    }
    else
    if ( !str_cmp(arg1, "death")
      || !str_cmp(arg1, "deaths") )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY_DEATH) )
       {
          send_to_char( "Death notification is now OFF.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY_DEATH);
          return;
       }
       else
       {
          send_to_char( "Death notification is now ON.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY_DEATH);
          return;
       }
    }
    else
    if ( !str_cmp(arg1, "script")
      || !str_cmp(arg1, "scripts") )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY_SCRIPT) )
       {
          send_to_char( "Script track notification is now OFF.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY_SCRIPT);
          return;
       }
       else
       {
          send_to_char( "Script track notification is now ON.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY_SCRIPT);
          return;
       }
    }
    else
    if ( !str_cmp(arg1, "bug")
      || !str_cmp(arg1, "bugs") )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY_BUG) )
       {
          send_to_char( "Bug notification is now OFF.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY_BUG);
          return;
       }
       else
       {
          send_to_char( "Bug notification is now ON.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY_BUG);
          return;
       }
    }
    else
    if ( !str_cmp(arg1, "log")
      || !str_cmp(arg1, "logs") )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY_LOG) )
       {
          send_to_char( "Log notification is now OFF.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY_LOG);
          return;
       }
       else
       {
          send_to_char( "Log notification is now ON.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY_LOG);
          if ( IS_SET( ch->act, WIZ_NOTIFY_BUG ) ) do_notify( ch, "bug" );
          return;
       }
    }
    else
    if ( !str_cmp(arg1, "login")
      || !str_cmp(arg1, "logins") )
    {
       if ( IS_SET(ch->act, WIZ_NOTIFY_LOGIN) )
       {
          send_to_char( "Login notify is now OFF.\n\r", ch );
          REMOVE_BIT(ch->act, WIZ_NOTIFY_LOGIN);
          return;
       }
       else
       {
          send_to_char( "Login notify is now ON.\n\r", ch );
          SET_BIT(ch->act, WIZ_NOTIFY_LOGIN);
          return;
       }
    }
    else
    if ( !str_cmp(arg1, "?")
      || !str_cmp(arg1, "help")
      || !str_cmp(arg1, "list") )
    {
        send_to_char( "Typing NOTIFY <option> toggles the notification on and off.\n\r", ch);
        send_to_char( "NOTIFY alone toggles notification off.\n\r", ch );
        send_to_char( "NOTIFY LIST, NOTIFY ? and NOTIFY HELP all list this display.\n\r", ch );
        sprintf( buf, "Logins notify     : %s\n\r",
                 IS_SET(ch->act, WIZ_NOTIFY_LOGIN) ? "ON" : "OFF" );
        send_to_char( buf, ch );
        sprintf( buf, "Bugs notify       : %s\n\r",
                 IS_SET(ch->act, WIZ_NOTIFY_BUG) ? "ON" : "OFF" );
        send_to_char( buf, ch );
        sprintf( buf, "Scripts notify    : %s\n\r",
                 IS_SET(ch->act, WIZ_NOTIFY_SCRIPT) ? "ON" : "OFF" );
        send_to_char( buf, ch );
        sprintf( buf, "Logs notify       : %s\n\r",
                 IS_SET(ch->act, WIZ_NOTIFY_LOG) ? "ON" : "OFF" );
        send_to_char( buf, ch );
        sprintf( buf, "Death notify      : %s\n\r",
                 IS_SET(ch->act, WIZ_NOTIFY_DEATH) ? "ON" : "OFF" );
        send_to_char( buf, ch );
        sprintf( buf, "The notify command is currently %s.\n\r",
                 IS_SET(ch->act, WIZ_NOTIFY) ? "active" : "inactive" );
        send_to_char( buf, ch );
        return;
    }
    else
    {
      send_to_char( "Eh?  I dont understand that!\n\r", ch );
      return;
    }
}


void do_wizhelp( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    int cmd;
    int col;
 
    col = 0;
    for ( cmd = 0; cmd_table[cmd].name[0] != '\0'; cmd++ )
    {
        if ( cmd_table[cmd].level >= LEVEL_HERO
        &&   cmd_table[cmd].level <= get_trust( ch ) )
	{
        sprintf( buf, "%12s (%2d)", cmd_table[cmd].name, cmd_table[cmd].level );
	    send_to_char( buf, ch );
        if ( ++col % 4 == 0 )
        send_to_char( "\n\r", ch );
	}
    }
 
    if ( col % 4 != 0 )
    send_to_char( "\n\r", ch );
    return;
}



void do_bamfin( CHAR_DATA *ch, char *argument )
{
    if ( !IS_NPC(ch) )
    {
	smash_tilde( argument );
	free_string( ch->pcdata->bamfin );
	ch->pcdata->bamfin = str_dup( argument );
    send_to_char( "Ok.\n\r", ch );
    }
    return;
}



void do_bamfout( CHAR_DATA *ch, char *argument )
{
    if ( !IS_NPC(ch) )
    {
	smash_tilde( argument );
	free_string( ch->pcdata->bamfout );
	ch->pcdata->bamfout = str_dup( argument );
    send_to_char( "Ok.\n\r", ch );
    }
    return;
}



void do_deny( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
    send_to_char( "Deny whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    if ( get_trust( victim ) >= get_trust( ch ) )
    {
    send_to_char( "You failed.\n\r", ch );
	return;
    }

    SET_BIT(victim->act, PLR_DENY);
    send_to_char( "You are denied access!\n\r", victim );
    send_to_char( "OK.\n\r", ch );
    do_quit( victim, "" );

    return;
}



void do_disconnect( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    DESCRIPTOR_DATA *d;
    CHAR_DATA *victim;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
    send_to_char( "Disconnect whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim->desc == NULL )
    {
    act( "$N doesn't have a descriptor.", ch, NULL, victim, TO_CHAR );
	return;
    }

    for ( d = descriptor_list; d != NULL; d = d->next )
    {
	if ( d == victim->desc )
	{
	    close_socket( d );
        send_to_char( "Ok.\n\r", ch );
	    return;
	}
    }

    bug( "Do_disconnect: desc not found.", 0 );
    send_to_char( "Descriptor not found!\n\r", ch );
    return;
}




void do_echo( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    
    if ( argument[0] == '\0' )
    {
    send_to_char( "Echo what?\n\r", ch );
	return;
    }

    for ( d = descriptor_list; d; d = d->next )
    {
	if ( d->connected == CON_PLAYING )
	{
	    send_to_char( argument, d->character );
        send_to_char( "\n\r",   d->character );
	}
    }

    return;
}



void do_recho( CHAR_DATA *ch, char *argument )
{
    DESCRIPTOR_DATA *d;
    
    if ( argument[0] == '\0' )
    {
    send_to_char( "Recho what?\n\r", ch );
	return;
    }

    for ( d = descriptor_list; d; d = d->next )
    {
	if ( d->connected == CON_PLAYING
	&&   d->character->in_room == ch->in_room )
	{
	    send_to_char( argument, d->character );
        send_to_char( "\n\r",   d->character );
	}
    }

    return;
}



ROOM_INDEX_DATA *find_location( CHAR_DATA *ch, char *arg )
{
    CHAR_DATA *victim;
    OBJ_DATA *obj;

    if ( is_number(arg) )
	return get_room_index( atoi( arg ) );

    if ( ( victim = get_char_world( ch, arg ) ) != NULL )
	return victim->in_room;

    if ( ( obj = get_obj_world( ch, arg ) ) != NULL )
	return obj->in_room;

    return NULL;
}



void do_transfer( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *location;
    DESCRIPTOR_DATA *d;
    CHAR_DATA *victim;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Transfer whom (and where)?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg1, "all" ) )
    {
	for ( d = descriptor_list; d != NULL; d = d->next )
	{
	    if ( d->connected == CON_PLAYING
	    &&   d->character != ch
	    &&   d->character->in_room != NULL
	    &&   can_see( ch, d->character ) )
	    {
		char buf[MAX_STRING_LENGTH];
                sprintf( buf, "%s %s", NAME(d->character), arg2 );
                                       do_transfer( ch, buf );
	    }
	}
	return;
    }

    /*
     * Thanks to Grodyn for the optional location parameter.
     */
    if ( arg2[0] == '\0' )
    {
	location = ch->in_room;
    }
    else
    {
	if ( ( location = find_location( ch, arg2 ) ) == NULL )
	{
        send_to_char( "No such location.\n\r", ch );
	    return;
	}

	if ( room_is_private( location ) )
	{
        send_to_char( "That room is private right now.\n\r", ch );
	    return;
	}
    }

    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim->in_room == NULL )
    {
    send_to_char( "They are in limbo.\n\r", ch );
	return;
    }

    if ( victim->fighting != NULL )
	stop_fighting( victim, TRUE );
    act( "$n disappears in a mushroom cloud.", victim, NULL, NULL, TO_ROOM );
    char_from_room( victim );
    char_to_room( victim, location );

    if ( victim->mounted_by != NULL 
      && victim->in_room != victim->mounted_by->in_room )
        do_transfer( ch, victim->mounted_by->name );
    if ( victim->riding != NULL
      && victim->in_room != victim->riding->in_room ) 
        do_transfer( ch, victim->riding->name );

    act( "$n arrives from a puff of smoke.", victim, NULL, NULL, TO_ROOM );
    if ( ch != victim )
    act( "$n has transferred you.", ch, NULL, victim, TO_VICT );
    do_look( victim, "auto" );
    send_to_char( "Ok.\n\r", ch );
}



void do_at( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *location;
    ROOM_INDEX_DATA *original;
    CHAR_DATA *wch;
    
    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' || argument[0] == '\0' )
    {
    send_to_char( "At where what?\n\r", ch );
	return;
    }

    if ( ( location = find_location( ch, arg ) ) == NULL )
    {
    send_to_char( "No such location.\n\r", ch );
	return;
    }

    if ( room_is_private( location ) )
    {
    send_to_char( "That room is private right now.\n\r", ch );
	return;
    }

    original = ch->in_room;
    char_from_room( ch );
    char_to_room( ch, location );
    interpret( ch, argument );

    /*
     * See if 'ch' still exists before continuing!
     * Handles 'at XXXX quit' case.
     */
    for ( wch = char_list; wch != NULL; wch = wch->next )
    {
	if ( wch == ch )
	{
	    char_from_room( ch );
	    char_to_room( ch, original );
	    break;
	}
    }

    return;
}



void do_goto( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *location;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
    send_to_char( "Goto where?\n\r", ch );
	return;
    }

    if ( ( location = find_location( ch, arg ) ) == NULL )
    {
    send_to_char( "No such location.\n\r", ch );
	return;
    }

    if ( room_is_private( location ) )
    {
    send_to_char( "That room is private right now.\n\r", ch );
	return;
    }

    if ( ch->fighting != NULL )
	stop_fighting( ch, TRUE );

    if ( ch->wizinvis < LEVEL_IMMORTAL )
    {
    do_emote( ch, (ch->pcdata != NULL && ch->pcdata->bamfout[0] != '\0')
        ? ch->pcdata->bamfout : "leaves in a swirling mist" );
    }

    char_from_room( ch );
    char_to_room( ch, location );

    if ( ch->wizinvis < LEVEL_IMMORTAL )
    {
    do_emote( ch, (ch->pcdata != NULL && ch->pcdata->bamfin[0] != '\0')
        ? ch->pcdata->bamfin : "appears in a swirling mist" );
    }

    do_look( ch, "auto" );
    return;
}



void do_rstat( CHAR_DATA *ch, char *argument )
{
    extern char * const dir_name[];
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *location;
    OBJ_DATA *obj;
    CHAR_DATA *rch;
    int door;

    one_argument( argument, arg );
    location = ( arg[0] == '\0' ) ? ch->in_room : find_location( ch, arg );
    if ( location == NULL )
    {
    send_to_char( "No such location.\n\r", ch );
	return;
    }

    if ( ch->in_room != location && room_is_private( location ) )
    {
    send_to_char( "That room is private right now.\n\r", ch );
	return;
    }

    sprintf( buf, "Name: '%s'\n\rArea: [%3d] '%s'\n\r",
	location->name,
    location->area->vnum,
    location->area->name );
    send_to_char( buf, ch );

    sprintf( buf,
    "Vnum: %d\n\rSector: %s\n\rLight: %d\n\r",
	location->vnum,
    sector_name( location->sector_type ),
	location->light );
    send_to_char( buf, ch );

    sprintf( buf,
    "Room flags: %s\n\rDescription:\n\r%s",
    room_bit_name( location->room_flags ),
	location->description );
    send_to_char( buf, ch );

    if ( location->extra_descr != NULL )
    {
	EXTRA_DESCR_DATA *ed;

    send_to_char( "Extra description keywords: ", ch );
	for ( ed = location->extra_descr; ed; ed = ed->next )
        {
            send_to_char( "'", ch );
	    send_to_char( ed->keyword, ch );
            send_to_char( "'", ch );
	}
    send_to_char( "\n\r", ch );
    }

    send_to_char( "Characters:", ch );
    for ( rch = location->people; rch; rch = rch->next_in_room )
    {
    send_to_char( " ", ch );
    one_argument( NAME(rch), buf );
	send_to_char( buf, ch );
    }

    send_to_char( "\n\rObjects:   ", ch );
    for ( obj = location->contents; obj; obj = obj->next_content )
    {
    send_to_char( " ", ch );
    one_argument( STR(obj, name), buf );
	send_to_char( buf, ch );
    }
    send_to_char( "\n\r", ch );

    for ( door = 0; door < MAX_DIR; door++ )
    {
	EXIT_DATA *pexit;

	if ( ( pexit = location->exit[door] ) != NULL )
	{
	    sprintf( buf,
        "Door: %5s  To: %d  Key: %d  Exit flags: %d(%d) '%s'\n\r",

                dir_name[door],
		pexit->to_room != NULL ? pexit->to_room->vnum : 0,
	    	pexit->key,
                pexit->exit_info, pexit->rs_flags,
            (pexit->keyword != NULL) ? pexit->keyword : "" );
	    send_to_char( buf, ch );
        if ( pexit->description != NULL && pexit->description[0] != '\0' )
            send_to_char( pexit->description, ch );
    }
    }

    if ( location->reset_first == NULL )
    {
        send_to_char( "Room has no resets.\n\r", ch );
        return;
    }


    return;
}


void do_index( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_STRING_LENGTH];

    argument = one_argument( argument, arg );
    
     if ( !str_prefix(arg, "mobile") ) do_mindex( ch, argument );
else if ( !str_prefix(arg, "object") ) do_oindex( ch, argument );
else if ( !str_prefix(arg, "room")   ) do_rstat( ch, argument );
else send_to_char( "Syntax: Index <mob|obj|room> <vnum>\n\r", ch );

     return;
}
    
  


void do_ostat( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA *paf;
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Ostat what?\n\r", ch );
	return;
    }

    if ( ( obj = get_obj_world( ch, arg ) ) == NULL )
    {
    send_to_char( "Nothing like that in hell, earth, or heaven.\n\r", ch );
	return;
    }

    sprintf( buf, "Name: '%s'.\n\rArea: [%3d] '%s'.\n\rFile: '%s'.\n\r",
    STR(obj, name),
    obj->pIndexData->area->vnum,
    obj->pIndexData->area->name,
    obj->pIndexData->area->filename );
    send_to_char( buf, ch );


    sprintf( buf, "Vnum: %d.  Type: %s.\n\r",
    obj->pIndexData->vnum,
    item_type_name( obj->item_type ) );
    send_to_char( buf, ch );

    sprintf( buf, "Short description: %s.\n\rLong description: %s",
    STR(obj, short_descr), STR(obj, description) );
    send_to_char( buf, ch );

    sprintf( buf, "Action description: %s.\n\r", obj->action_descr );
    send_to_char( buf, ch );

    sprintf( buf, "Wear bits: %s.\n\r  Extra bits: %s.\n\r",
    wear_bit_name( obj->wear_flags ),
    extra_bit_name( obj->extra_flags ) );
    send_to_char( buf, ch );

    sprintf( buf, "Number: %d/%d.  Weight: %d/%d.\n\r",
	1,           get_obj_number( obj ),
	obj->weight, get_obj_weight( obj ) );
    send_to_char( buf, ch );

    sprintf( buf, "Cost: %d.  Timer: %d.  Level: %d.\n\r",
	obj->cost, obj->timer, obj->level );
    send_to_char( buf, ch );

    sprintf( buf,
    "In room: %d.  In object: %s.  Carried by: %s.  Wear_loc: %s.\n\r",
	obj->in_room    == NULL    ?        0 : obj->in_room->vnum,
    obj->in_obj     == NULL    ? "(none)" : STR(obj->in_obj, short_descr),
    obj->carried_by == NULL    ? "(none)" : NAME(obj->carried_by),
    wear_loc_name( obj->wear_loc ) );
    send_to_char( buf, ch );
    
    sprintf( buf, "Values: %d %d %d %d %d %d %d %d %d %d.\n\r",
    obj->value[0],
    obj->value[1],
    obj->value[2],
    obj->value[3],
    obj->value[4],
    obj->value[5],
    obj->value[6],
    obj->value[7],
    obj->value[8],
    obj->value[9] );
    send_to_char( buf, ch );

    if ( obj->extra_descr != NULL || obj->pIndexData->extra_descr != NULL )
    {
	EXTRA_DESCR_DATA *ed;

    send_to_char( "Extra description keywords: '", ch );

	for ( ed = obj->extra_descr; ed != NULL; ed = ed->next )
	{
	    send_to_char( ed->keyword, ch );
	    if ( ed->next != NULL )
        send_to_char( " ", ch );
	}

	for ( ed = obj->pIndexData->extra_descr; ed != NULL; ed = ed->next )
	{
	    send_to_char( ed->keyword, ch );
	    if ( ed->next != NULL )
        send_to_char( " ", ch );
	}

    send_to_char( "'.\n\r", ch );
    }

    for ( paf = obj->affected; paf != NULL; paf = paf->next )
    {
       sprintf( buf, "Affects %s by %d.\n\r", affect_loc_name( paf->location ),
                                              paf->modifier );
       send_to_char( buf, ch );
    }

    for ( paf = obj->pIndexData->affected; paf != NULL; paf = paf->next )
    {
       sprintf( buf, "Affects %s by %d.\n\r", affect_loc_name( paf->location ),
                                              paf->modifier );
       send_to_char( buf, ch );
    }

    return;
}


void do_mstat( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA *paf;
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Mstat whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( !IS_NPC( victim ) )
    {
    send_to_char( "Not on PC's.\n\r", ch );
    return;
    }

    sprintf( buf, "Name: '%s'.\n\rArea: [%3d] '%s'.\n\r",
    NAME(victim),
    victim->pIndexData->area->vnum,
    victim->pIndexData->area->name );
    send_to_char( buf, ch );

    sprintf( buf, "Vnum: %d.  Sex: %s.  Room: %d.\n\r",
    victim->pIndexData->vnum,
    victim->sex == SEX_MALE    ? "male"   :
    victim->sex == SEX_FEMALE  ? "female" : "neutral",
    victim->in_room == NULL    ?        0 : victim->in_room->vnum );
    send_to_char( buf, ch );

    sprintf( buf, "Hp: %d/%d.   Move: %d/%d.\n\r",
	victim->hit,         victim->max_hit,
    victim->move,        victim->max_move );
    send_to_char( buf, ch );
	
    sprintf( buf,
    "Lv: %d.  Align: %d.  AC: %d.  Gold: %d.  Exp: %d.\n\r",
    victim->level,       victim->alignment,
    GET_AC(victim),      tally_coins ( victim ),         victim->exp );
    send_to_char( buf, ch );

    sprintf( buf, "Hitroll: %d.  Damroll: %d.  Position: %d.\n\r",
	GET_HITROLL(victim), GET_DAMROLL(victim),
    victim->position );
    send_to_char( buf, ch );
	
    if ( victim->position == POS_FIGHTING )
    {
        sprintf( buf, "Fighting: %s.\n\r",
                      victim->fighting ? NAME(victim->fighting) : "(none)" );
        send_to_char( buf, ch );
    }

    sprintf( buf, "Carrying: %d.  Weight: %d.\n\r",
	victim->carry_number, victim->carry_weight );
    send_to_char( buf, ch );

    sprintf( buf, "Age: %d.  Played: %d.  Timer: %d.\n\rAct: %s.\n\r",
    get_age( victim ), (int) victim->played, victim->timer,
             act_bit_name( victim->act ) );
    send_to_char( buf, ch );

    sprintf( buf, "Master: %s  Leader: %s\n\rAffected by: %s.\n\r",
             victim->master      ? NAME(victim->master)   : "(none)",
             victim->leader      ? NAME(victim->leader)   : "(none)",
             affect_bit_name( victim->affected_by ) );
    send_to_char( buf, ch );

    sprintf( buf, "Short description: %s.\n\rLong  description:\n\r %s",
    STR(victim, short_descr),  STR(victim, long_descr) );
    send_to_char( buf, ch );

    if ( victim->spec_fun != NULL )
    {
        sprintf( buf, "Spec fun: %s.\n\r", victim->spec_name );
        send_to_char( buf, ch );
    }

    for ( paf = victim->affected; paf != NULL; paf = paf->next )
    {
	sprintf( buf,
        "Spell: '%s' modifies %s by %d for %d hours with bits %s.\n\r",
	    skill_table[(int) paf->type].name,
	    affect_loc_name( paf->location ),
	    paf->modifier,
	    paf->duration,
        affect_bit_name( paf->bitvector )        );
	send_to_char( buf, ch );
    }

    return;

}


void do_pstat( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA *paf;
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Pstat whom?\n\r", ch );
        return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    if ( IS_NPC( victim ) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
    return;
    }

    sprintf( buf, "Name: %s.\n\r",   NAME(victim) );
    send_to_char( buf, ch );

    sprintf( buf, "Sex: %s.  Room: %d.\n\r",
    victim->sex == SEX_MALE    ? "male"   :
    victim->sex == SEX_FEMALE  ? "female" : "neutral",
        victim->in_room == NULL    ?        0 : victim->in_room->vnum
        );
    send_to_char( buf, ch );

    sprintf( buf, "Str: %d.  Int: %d.  Wis: %d.  Dex: %d.  Con: %d.\n\r",
        get_curr_str(victim),
        get_curr_int(victim),
        get_curr_wis(victim),
        get_curr_dex(victim),
        get_curr_con(victim) );
    send_to_char( buf, ch );

    sprintf( buf, "Hp: %d/%d.   Move: %d/%d.  Practices: %d.\n\r",
        victim->hit,         victim->max_hit,
        victim->move,        victim->max_move,
        victim->practice );
    send_to_char( buf, ch );
        
    sprintf( buf,
    "Lv: %d.  Class: %d.  Align: %d.  AC: %d.  Gold: %d.  Exp: %d.\n\r",
        victim->level,       victim->class,        victim->alignment,
    GET_AC(victim),      tally_coins( victim ),         victim->exp );
    send_to_char( buf, ch );

    sprintf( buf, "Hitroll: %d.  Damroll: %d.  Position: %d.\n\r",
        GET_HITROLL(victim), GET_DAMROLL(victim),
    victim->position  );
    send_to_char( buf, ch );

    if ( victim->position == POS_FIGHTING )
    {
        sprintf( buf, "Fighting: %s.\n\r",
                      victim->fighting ? NAME(victim->fighting) : "(none)" );
        send_to_char( buf, ch );
    }

    sprintf( buf, "Thirst: %d.  Full: %d.  Drunk: %d.  Saving throw: %d.\n\r",
    victim->pcdata->condition[COND_THIRST],
    victim->pcdata->condition[COND_FULL],
    victim->pcdata->condition[COND_DRUNK],
    victim->saving_throw );
        send_to_char( buf, ch );

    sprintf( buf, "Carrying: %d.  Weight: %d.\n\r",
        victim->carry_number, victim->carry_weight );
    send_to_char( buf, ch );

    sprintf( buf, "Age: %d.  Played: %d.  Timer: %d.  Bounty/Owed: %d/%d.\n\rAct: %s.\n\r",
    get_age( victim ), (int) victim->played, victim->timer, victim->bounty,
    victim->owed, plr_bit_name( victim->act ) );
    send_to_char( buf, ch );

    sprintf( buf, "Master: %s.  Leader: %s.  Affected by: %s.\n\r",
    victim->master      ? NAME(victim->master)   : "(none)",
    victim->leader      ? NAME(victim->leader)   : "(none)",
        affect_bit_name( victim->affected_by ) );
    send_to_char( buf, ch );

    sprintf( buf, "Short description: %s.\n\rLong  description: %s",
    STR(victim, short_descr),
    STR(victim, long_descr) );
    send_to_char( buf, ch );

    for ( paf = victim->affected; paf != NULL; paf = paf->next )
    {
        sprintf( buf,
        "Spell: '%s' modifies %s by %d for %d hours with bits %s.\n\r",
            skill_table[(int) paf->type].name,
        affect_loc_name( paf->location ),
            paf->modifier,
            paf->duration,
            affect_bit_name( paf->bitvector )
            );
        send_to_char( buf, ch );
    }

    return;
}




void do_stat( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_STRING_LENGTH];

    argument = one_argument( argument, arg );
    
     if ( !str_prefix( arg, "mobile" ) ) do_mstat( ch, argument );
else if ( !str_prefix( arg, "object" ) ) do_ostat( ch, argument );
else if ( !str_prefix( arg, "player" ) ) do_pstat( ch, argument );
else send_to_char( "Syntax: Stat <mob|obj|player> <name>\n\r", ch );

     return;
}


    /*
     * Yeah, so iterating over all vnum's takes 10,000 loops.
     * Get_mob_index is fast, and I don't feel like threading another link.
     * Do you?
     * -- Furey
     */

/*
 * enhancements by Locke
 */
void do_mfind( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char arg3[MAX_INPUT_LENGTH];
    MOB_INDEX_DATA *pMobIndex;
    bool fRange = FALSE;
    bool fArea = FALSE;
    bool fName = FALSE;
    int range1 = 0;
    int range2 = 0;
    AREA_DATA *pArea = ch->in_room->area;
    char name[MAX_INPUT_LENGTH];
    int vnum;
    bool found = FALSE;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    argument = one_argument( argument, arg3 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Syntax: mfind all\n\r",               ch );
    send_to_char( "        mfind [name, area] [num1 num2]\n\r", ch );
	return;
    }

    if ( is_number( arg1 ) && is_number( arg2 ) )
    {
        fRange = TRUE;
        range1 = atoi( arg1 );
        range2 = atoi( arg2 );
        if ( !str_cmp(arg3, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg3, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg3 );
            }
        }
    }
    else
    {
        if ( is_number( arg2 ) && is_number( arg3 ) )
        {
            fRange = TRUE;
            range1 = atoi( arg2 );
            range2 = atoi( arg3 );
        }
        if ( !str_cmp(arg1, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg1, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg1 );
            }
        }
    }


    if ( range1 > range2 && fRange )
    {
        vnum = range1;
        range1 = range2;
        range2 = vnum;
    }

    if ( range2 > top_vnum_mob || !fRange ) range2 = top_vnum_mob;

    for ( vnum = range1; vnum <= range2; vnum++ )
    {
        if ( ( pMobIndex = get_mob_index( vnum ) ) != NULL
          && ( is_name( name, pMobIndex->name ) || !fName )
          && ( pMobIndex->area == pArea || !fArea ) )
        {
            found = TRUE;
            sprintf( buf, "[%5d %3d] %-32s  %-32s\n\r", vnum, pMobIndex->level,
                                             pMobIndex->short_descr,
                                             !fArea ? pMobIndex->name : "" );
            send_to_char( buf, ch );
        }
    }


    if ( !found )
    send_to_char( "Nothing like that in hell, earth, or heaven.\n\r", ch );

    return;
}


/*
 * enhancements by Locke
 */
void do_ofind( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char arg3[MAX_INPUT_LENGTH];
    OBJ_INDEX_DATA *pObjIndex;
    bool fRange = FALSE;
    bool fArea = FALSE;
    bool fName = FALSE;
    int range1 = 0;
    int range2 = 0;
    AREA_DATA *pArea = ch->in_room->area;
    char name[MAX_INPUT_LENGTH];
    int vnum;
    bool found = FALSE;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    argument = one_argument( argument, arg3 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Syntax: ofind all\n\r",               ch );
    send_to_char( "        ofind [name, area] [num1 num2]\n\r", ch );
	return;
    }

    if ( is_number( arg1 ) && is_number( arg2 ) )
    {
        fRange = TRUE;
        range1 = atoi( arg1 );
        range2 = atoi( arg2 );
        if ( !str_cmp(arg3, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg3, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg3 );
            }
        }
    }
    else
    {
        if ( is_number( arg2 ) && is_number( arg3 ) )
        {
            fRange = TRUE;
            range1 = atoi( arg2 );
            range2 = atoi( arg3 );
        }
        if ( !str_cmp(arg1, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg1, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg1 );
            }
        }
    }


    if ( range1 > range2 && fRange )
    {
        vnum = range1;
        range1 = range2;
        range2 = vnum;
    }

    if ( range2 > top_vnum_obj || !fRange ) range2 = top_vnum_obj;

    for ( vnum = range1; vnum <= range2; vnum++ )
    {
        if ( ( pObjIndex = get_obj_index( vnum ) ) != NULL
          && ( is_name( name, pObjIndex->name ) || !fName )
          && ( pObjIndex->area == pArea || !fArea ) )
        {
            found = TRUE;
            sprintf( buf, "[%5d %3d] %-32s  %-32s\n\r", vnum,
                                             pObjIndex->item_type,
                                             pObjIndex->short_descr,
                                             !fArea ? pObjIndex->name : "" );
            send_to_char( buf, ch );
        }
    }


    if ( !found )
    send_to_char( "Nothing like that in hell, earth, or heaven.\n\r", ch );

    return;
}

void do_rfind( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char arg3[MAX_INPUT_LENGTH];
    ROOM_INDEX_DATA *pRoomIndex;
    bool fRange = FALSE;
    bool fArea = FALSE;
    bool fName = FALSE;
    int range1 = 0;
    int range2 = 0;
    AREA_DATA *pArea = ch->in_room->area;
    char name[MAX_INPUT_LENGTH];
    int vnum;
    bool found = FALSE;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    argument = one_argument( argument, arg3 );

    if ( arg1[0] == '\0' )
    {
    send_to_char( "Syntax: rfind all\n\r",               ch );
    send_to_char( "        rfind [name, area] [num1 num2]\n\r", ch );
	return;
    }

    if ( is_number( arg1 ) && is_number( arg2 ) )
    {
        fRange = TRUE;
        range1 = atoi( arg1 );
        range2 = atoi( arg2 );

        if ( !str_cmp(arg3, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg3, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg3 );
            }
        }
    }
    else
    {
        if ( is_number( arg2 ) && is_number( arg3 ) )
        {
            fRange = TRUE;
            range1 = atoi( arg2 );
            range2 = atoi( arg3 );
        }

        if ( !str_cmp(arg1, "area") )     fArea = TRUE;
        else
        {
            if ( !str_cmp( arg1, "all" ) )
            {
                fRange = FALSE;
                fName  = FALSE;
                fArea  = FALSE;
            }
            else
            {
                fName = TRUE;
                strcpy( name, arg1 );
            }
        }
    }


    if ( range1 > range2 && fRange )
    {
        vnum = range1;
        range1 = range2;
        range2 = vnum;
    }

    if ( range2 > top_vnum_room || !fRange ) range2 = top_vnum_room;

    for ( vnum = range1; vnum <= range2; vnum++ )
    {
        if ( ( pRoomIndex = get_room_index( vnum ) ) != NULL
          && ( is_name( name, pRoomIndex->name ) || !fName )
          && ( pRoomIndex->area == pArea || !fArea ) )
        {
            found = TRUE;
            sprintf( buf, "[%5d %d] %-32s  %-32s\n\r", vnum, pRoomIndex->light,
                                             pRoomIndex->name,
                                             !fArea ? pRoomIndex->name : "" );
            send_to_char( buf, ch );
        }
    }


    if ( !found )
    send_to_char( "Nothing like that in hell, earth, or heaven.\n\r", ch );

    return;
}


void do_find( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_STRING_LENGTH];

    argument = one_argument( argument, arg );
    
     if ( !str_prefix( arg, "mobile" ) ) do_mfind( ch, argument );
else if ( !str_prefix( arg, "object" ) ) do_ofind( ch, argument );
else if ( !str_prefix( arg, "room" ) )   do_rfind( ch, argument );
else send_to_char( "Syntax: Find <mob|obj|room> [name,area] [num1 num2]\n\r", ch );

     return;
}

 
void do_mwhere( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    bool found;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
    send_to_char( "Mwhere whom?\n\r", ch );
	return;
    }

    found = FALSE;
    for ( victim = char_list; victim != NULL; victim = victim->next )
    {
	if ( IS_NPC(victim)
	&&   victim->in_room != NULL
    &&   is_name( arg, NAME(victim) ) )
	{
	    found = TRUE;
        sprintf( buf, "[%5d] %-28s [%5d] %s\n\r",
		victim->pIndexData->vnum,
        STR(victim, short_descr),
		victim->in_room->vnum,
		victim->in_room->name );
	    send_to_char( buf, ch );
	}
    }

    if ( !found )
    act( "You didn't find any $T.", ch, NULL, arg, TO_CHAR );

    return;
}





void do_reboo( CHAR_DATA *ch, char *argument )
{
    send_to_char( "If you want to REBOOT, spell it out.\n\r", ch );
    return;
}



void do_reboot( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    extern bool merc_down;

    sprintf( buf, "Reboot by %s.\n\r ", NAME(ch) );
    {
    DESCRIPTOR_DATA *d;
   
    for ( d = descriptor_list; d != NULL; d = d->next )
    {
    write_to_buffer( d, buf, strlen(buf)-1 );
    }
    }

    merc_down = TRUE;
    return;
}



void do_shutdow( CHAR_DATA *ch, char *argument )
{
    send_to_char( "If you want to SHUTDOWN, spell it out.\n\r", ch );
    return;
}



void do_shutdown( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    extern bool merc_down;

    sprintf( buf, "Shutdown by %s. ", NAME(ch) );
    append_file( ch, SHUTDOWN_FILE, buf );
    strcat( buf, "\n\r" );
    {
    DESCRIPTOR_DATA *d;
   
    for ( d = descriptor_list; d != NULL; d = d->next )
    {
    write_to_buffer( d, buf, strlen(buf)-1 );
    }
    }
    
    merc_down = TRUE;
    return;
}



void do_snoop( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    DESCRIPTOR_DATA *d;
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( IS_NPC(ch) )
    {
        send_to_char( "Bad mobile!  Don't ever do that again!\n\r", ch );
        return;
    }

    if ( arg[0] == '\0' ) sprintf( arg, "self" );

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim->desc == NULL )
    {
        send_to_char( "No descriptor to snoop.\n\r", ch );
	return;
    }

    if ( victim == ch )
    {
    send_to_char( "Cancelling all snoops.\n\r", ch );
	for ( d = descriptor_list; d != NULL; d = d->next )
	{
            if ( d->snoop_by == ch->desc )
                d->snoop_by = NULL;
	}
	return;
    }
    
    if ( victim->desc->snoop_by == ch->desc )
    {
        victim->desc->snoop_by = NULL;
        send_to_char( "Cancelled.\n\r", ch );
        return;
    }

    if ( victim->desc->snoop_by != NULL )
    {
        send_to_char( "Busy already.\n\r", ch );
	return;
    }

    if ( get_trust( victim ) >= get_trust( ch ) )
    {
        victim->desc->snoop_by = NULL;
        act( "$B$n is snooping you.$R", ch, NULL, victim, TO_VICT );
    }

    if ( ch->desc != NULL )
    {
	for ( d = ch->desc->snoop_by; d != NULL; d = d->snoop_by )
	{
	    if ( d->character == victim || d->original == victim )
	    {
                send_to_char( "No snoop loops.\n\r", ch );
		return;
	    }
	}
    }

    victim->desc->snoop_by = ch->desc;
    send_to_char( "Snooped.\n\r", ch );
    return;
}



void do_switch( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );
    
    if ( arg[0] == '\0' )
    {
        send_to_char( "Switch into whom?\n\r", ch );
	return;
    }

    if ( ch->desc == NULL )
	return;
    
    if ( ch->desc->original != NULL )
    {
        send_to_char( "You are already switched.\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
        send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( victim == ch )
    {
        send_to_char( "Ok.\n\r", ch );
	return;
    }

    if ( victim->desc != NULL || !IS_NPC(victim) )
    {
        send_to_char( "Character in use.\n\r", ch );
	return;
    }

    ch->desc->character = victim;
    ch->desc->original  = ch;
    victim->desc        = ch->desc;
    ch->desc            = NULL;
    send_to_char( "Ok.\n\r", victim );
    return;
}



void do_return( CHAR_DATA *ch, char *argument )
{
    if ( ch->desc == NULL )
	return;

    if ( ch->desc->original == NULL )
    {
        send_to_char( "You aren't switched.\n\r", ch );
	return;
    }

    send_to_char( "You return to your original body.\n\r", ch );
    ch->desc->character       = ch->desc->original;
    ch->desc->original        = NULL;
    ch->desc->character->desc = ch->desc; 
    ch->desc                  = NULL;
    return;
}



void do_mload( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    MOB_INDEX_DATA *pMobIndex;
    CHAR_DATA *victim;
    
    one_argument( argument, arg );

    if ( arg[0] == '\0' || !is_number(arg) )
    {
    send_to_char( "Syntax: mload <vnum>.\n\r", ch );
	return;
    }

    if ( ( pMobIndex = get_mob_index( atoi( arg ) ) ) == NULL )
    {
    send_to_char( "No mob has that vnum.\n\r", ch );
	return;
    }

    victim = create_mobile( pMobIndex );
    char_to_room( victim, ch->in_room );
    act( "$n has created $N!", ch, NULL, victim, TO_ROOM );
    act( "You create $N!", ch, NULL, victim, TO_CHAR );
    return;
}



void do_oload( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_INDEX_DATA *pObjIndex;
    OBJ_DATA *obj;
    int level;
 
    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
 
    if ( arg1[0] == '\0' || !is_number( arg1 ) )
    {
        send_to_char( "Syntax: oload <vnum> <level>.\n\r", ch );
        return;
    }
 
    if ( arg2[0] == '\0' )
    {
	level = get_trust( ch );
    }
    else
    {
	/*
	 * New feature from Alander.
	 */
        if ( !is_number( arg2 ) )
        {
        send_to_char( "Syntax: oload <vnum> <level>.\n\r", ch );
	    return;
        }
        level = atoi( arg2 );

	if ( level < 0 || level > get_trust( ch ) )
        {
        send_to_char( "Limited to your trust level.\n\r", ch );
	    return;
        }
    }

    if ( ( pObjIndex = get_obj_index( atoi( arg1 ) ) ) == NULL )
    {
    send_to_char( "No object has that vnum.\n\r", ch );
	return;
    }

    obj = create_object( pObjIndex, level );
    if ( CAN_WEAR(obj, ITEM_TAKE) )
    {
	obj_to_char( obj, ch );
    obj->wear_loc     = hand_empty( ch );
    }
    else
    {
	obj_to_room( obj, ch->in_room );
    }
    act( "$n has created $p!", ch, obj, NULL, TO_ROOM );
    act( "You create $p!", ch, obj, NULL, TO_CHAR );
    return;
}


void do_load( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_STRING_LENGTH];

    argument = one_argument( argument, arg );
    
     if ( !str_prefix( arg, "mobile" ) ) do_mload( ch, argument );
else if ( !str_prefix( arg, "object" ) ) do_oload( ch, argument );
else send_to_char( "Syntax: Load <mob|obj> <vnum>\n\r", ch );

     return;
}


void do_purge( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    OBJ_DATA *obj;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	/* 'purge' */
	CHAR_DATA *vnext;
	OBJ_DATA  *obj_next;

	for ( victim = ch->in_room->people; victim != NULL; victim = vnext )
	{
	    vnext = victim->next_in_room;
        if ( IS_NPC(victim) && victim->desc == NULL )
		extract_char( victim, TRUE );
	}

	for ( obj = ch->in_room->contents; obj != NULL; obj = obj_next )
	{
	    obj_next = obj->next_content;
	    extract_obj( obj );
	}

    act( "$n cleanses the room with righteous fire!", ch, NULL, NULL, TO_ROOM);
    send_to_char( "You cleanse the room with righteous fire!\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
        return;
    }

    if ( !IS_NPC(victim) || victim->desc != NULL )
    {
    send_to_char( "Not on PC's or switched PC's.\n\r", ch );
	return;
    }

    act( "$n purges $N.", ch, NULL, victim, TO_NOTVICT );
    extract_char( victim, TRUE );
    return;
}



void do_advance( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int level;
    int iLevel;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' || !is_number( arg2 ) )
    {
    send_to_char( "Syntax: advance <char> <level>.\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, arg1 ) ) == NULL )
    {
    send_to_char( "That player is not here.\n\r", ch);
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    if ( ( level = atoi( arg2 ) ) < 1 || level > MAX_LEVEL )
    {
        char buf[MAX_STRING_LENGTH];

        sprintf( buf, "Level must be 1 to %d.\n\r", MAX_LEVEL );
        send_to_char( buf, ch );
        return;
    }

    if ( level > get_trust( ch ) )
    {
    send_to_char( "Limited to your trust level.\n\r", ch );
	return;
    }

    /*
     * Lower level:
     *   Reset to level 1.
     *   Then raise again.
     *   Currently, an imp can lower another imp.
     *   -- Swiftest
     */
    if ( level < victim->level )
    {
	int sn;

    send_to_char( "Lowering a player's level!\n\r", ch );
    send_to_char( "**** OOOOHHHHHHHHHH  NNNNOOOO ****\n\r", victim );
	victim->level    = 1;
    victim->exp      = 0;
	victim->max_hit  = 10;
	victim->max_move = 100;
	for ( sn = 0; sn < MAX_SKILL; sn++ )
        victim->pcdata->learned[sn] = 0;
	victim->practice = 0;
	victim->hit      = victim->max_hit;
	victim->move     = victim->max_move;
	advance_level( victim );
    }
    else
    {
    send_to_char( "Raising a player's level!\n\r", ch );
    send_to_char( "**** OOOOHHHHHHHHHH  YYYYEEEESSS ****\n\r", victim );
    }

    for ( iLevel = victim->level ; iLevel < level; iLevel++ )
    {
    send_to_char( "You raise a level! ", victim );
	victim->level += 1;
	advance_level( victim );
    }
    victim->exp   = 0;
    victim->trust = 0;
    return;
}



void do_trust( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int level;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' || !is_number( arg2 ) )
    {
    send_to_char( "Syntax: trust <char> <level>.\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, arg1 ) ) == NULL )
    {
    send_to_char( "That player is not here.\n\r", ch);
	return;
    }

    if (IS_NPC(ch) || IS_NPC(victim))
    {
        send_to_char( "Not on, or by, NPCs.\n\r", ch );
        return;
    }

    if ( ( level = atoi( arg2 ) ) < 0 || level > MAX_LEVEL )
    {
        char buf[MAX_STRING_LENGTH];

        sprintf( buf, "Level must be 0 (reset) or 1 to %d.\n\r", MAX_LEVEL );
        send_to_char( buf, ch );
        return;
    }

    if ( level > get_trust( ch ) )
    {
    send_to_char( "Limited to your trust.\n\r", ch );
	return;
    }

    victim->trust = level;
    return;
}



void do_restore( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
    send_to_char( "Restore whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    victim->hit  = victim->max_hit;
    victim->move = victim->max_move;
    update_pos( victim );
    act( "$n has restored you.", ch, NULL, victim, TO_VICT );
    send_to_char( "Ok.\n\r", ch );
    return;
}



void do_freeze( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Freeze whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    if ( get_trust( victim ) >= get_trust( ch ) )
    {
    send_to_char( "You failed.\n\r", ch );
	return;
    }

    if ( IS_SET(victim->act, PLR_FREEZE) )
    {
	REMOVE_BIT(victim->act, PLR_FREEZE);
    send_to_char( "You can play again.\n\r", victim );
    send_to_char( "FREEZE removed.\n\r", ch );
    }
    else
    {
	SET_BIT(victim->act, PLR_FREEZE);
    send_to_char( "You can't do ANYthing!\n\r", victim );
    send_to_char( "FREEZE set.\n\r", ch );
    }

    save_char_obj( victim );

    return;
}



void do_log( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Log whom?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg, "all" ) )
    {
	if ( fLogAll )
	{
	    fLogAll = FALSE;
        send_to_char( "Log ALL off.\n\r", ch );
	}
	else
	{
	    fLogAll = TRUE;
        send_to_char( "Log ALL on.\n\r", ch );
	}
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    /*
     * No level check, gods can log anyone.
     */
    if ( IS_SET(victim->act, PLR_LOG) )
    {
	REMOVE_BIT(victim->act, PLR_LOG);
    send_to_char( "LOG removed.\n\r", ch );
    }
    else
    {
	SET_BIT(victim->act, PLR_LOG);
    send_to_char( "LOG set.\n\r", ch );
    }

    return;
}



void do_noemote( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Noemote whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    if ( get_trust( victim ) >= get_trust( ch ) )
    {
    send_to_char( "You failed.\n\r", ch );
	return;
    }

    if ( IS_SET(victim->act2, PLR_NO_EMOTE) )
    {
    REMOVE_BIT(victim->act2, PLR_NO_EMOTE);
    send_to_char( "You can emote again.\n\r", victim );
    send_to_char( "NO_EMOTE removed.\n\r", ch );
    }
    else
    {
    SET_BIT(victim->act2, PLR_NO_EMOTE);
    send_to_char( "You can't emote!\n\r", victim );
    send_to_char( "NO_EMOTE set.\n\r", ch );
    }

    return;
}



void do_notell( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Notell whom?", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    if ( get_trust( victim ) >= get_trust( ch ) )
    {
    send_to_char( "You failed.\n\r", ch );
	return;
    }

    if ( IS_SET(victim->act2, PLR_NO_TELL) )
    {
    REMOVE_BIT(victim->act2, PLR_NO_TELL);
    send_to_char( "You can tell again.\n\r", victim );
    send_to_char( "NO_TELL removed.\n\r", ch );
    }
    else
    {
    SET_BIT(victim->act2, PLR_NO_TELL);
    send_to_char( "You can't tell!\n\r", victim );
    send_to_char( "NO_TELL set.\n\r", ch );
    }

    return;
}



void do_silence( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Silence whom?", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    if ( get_trust( victim ) >= get_trust( ch ) )
    {
    send_to_char( "You failed.\n\r", ch );
	return;
    }

    if ( IS_SET(victim->act2, PLR_SILENCE) )
    {
    REMOVE_BIT(victim->act2, PLR_SILENCE);
    send_to_char( "You can use channels again.\n\r", victim );
    send_to_char( "SILENCE removed.\n\r", ch );
    }
    else
    {
    SET_BIT(victim->act2, PLR_SILENCE);
    send_to_char( "You can't use channels!\n\r", victim );
    send_to_char( "SILENCE set.\n\r", ch );
    }

    return;
}



void do_peace( CHAR_DATA *ch, char *argument )
{
    CHAR_DATA *rch;

    for ( rch = ch->in_room->people; rch != NULL; rch = rch->next_in_room )
    {
        if ( rch->fighting != NULL )
        {
            act( "$n waves a white flag.", rch, 0, 0, TO_ROOM );
            send_to_char( "You wave a white flag.\n\r", rch );
            rch->fighting = NULL;
            rch->position = POS_STANDING;
            update_pos( rch );
        }
    }

    return;
}



BAN_DATA *		ban_free;
BAN_DATA *		ban_list;

void do_ban( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    BAN_DATA *pban;

    if ( IS_NPC(ch) )
	return;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    strcpy( buf, "Banned sites:\n\r" );
	for ( pban = ban_list; pban != NULL; pban = pban->next )
	{
	    strcat( buf, pban->name );
        strcat( buf, "\n\r" );
	}
	send_to_char( buf, ch );
	return;
    }

    for ( pban = ban_list; pban != NULL; pban = pban->next )
    {
	if ( !str_cmp( arg, pban->name ) )
	{
        send_to_char( "That site is already banned!\n\r", ch );
	    return;
	}
    }

    if ( ban_free == NULL )
    {
	pban		= alloc_perm( sizeof(*pban) );
    }
    else
    {
	pban		= ban_free;
	ban_free	= ban_free->next;
    }

    pban->name	= str_dup( arg );
    pban->next	= ban_list;
    ban_list	= pban;
    send_to_char( "Ok.\n\r", ch );
    return;
}



void do_allow( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    BAN_DATA *prev;
    BAN_DATA *curr;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
    send_to_char( "Remove which site from the ban list?\n\r", ch );
	return;
    }

    prev = NULL;
    for ( curr = ban_list; curr != NULL; prev = curr, curr = curr->next )
    {
	if ( !str_cmp( arg, curr->name ) )
	{
	    if ( prev == NULL )
		ban_list   = ban_list->next;
	    else
		prev->next = curr->next;

	    free_string( curr->name );
	    curr->next	= ban_free;
	    ban_free	= curr;
        send_to_char( "Ok.\n\r", ch );
	    return;
	}
    }

    send_to_char( "Site is not banned.\n\r", ch );
    return;
}



void do_wizlock( CHAR_DATA *ch, char *argument )
{
    extern bool wizlock;
    wizlock = !wizlock;

    if ( wizlock )
    send_to_char( "Game wizlocked.\n\r", ch );
    else
    send_to_char( "Game un-wizlocked.\n\r", ch );

    return;
}



void do_slookup( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    int sn;

    one_argument( argument, arg );
    if ( arg[0] == '\0' )
    {
    send_to_char( "Slookup what?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg, "all" ) )
    {
	for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
	    if ( skill_table[sn].name == NULL )
		break;
        sprintf( buf, "Sn: %4d Slot: %4d Skill/spell: '%s'\n\r",
		sn, skill_table[sn].slot, skill_table[sn].name );
	    send_to_char( buf, ch );
	}
    }
    else
    {
	if ( ( sn = skill_lookup( arg ) ) < 0 )
	{
        send_to_char( "No such skill or spell.\n\r", ch );
	    return;
	}

    sprintf( buf, "Sn: %4d Slot: %4d Skill/spell: '%s'\n\r",
	    sn, skill_table[sn].slot, skill_table[sn].name );
	send_to_char( buf, ch );
    }

    return;
}



void do_sset( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int value;
    int sn;
    bool fAll;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    argument = one_argument( argument, arg3 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' || arg3[0] == '\0' )
    {
    send_to_char( "Syntax: sset <victim> <skill> <value>\n\r",  ch );
    send_to_char( "or:     sset <victim> all     <value>\n\r",  ch );
    send_to_char( "Skill being any skill or spell.\n\r",        ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    fAll = !str_cmp( arg2, "all" );
    sn   = 0;
    if ( !fAll && ( sn = skill_lookup( arg2 ) ) < 0 )
    {
    send_to_char( "No such skill or spell.\n\r", ch );
	return;
    }

    /*
     * Snarf the value.
     */
    if ( !is_number( arg3 ) )
    {
    send_to_char( "Value must be numeric.\n\r", ch );
	return;
    }

    value = atoi( arg3 );
    if ( value < -1 || value > 100 )
    {
    send_to_char( "Value range is 0 (unlearned) to 100.\n\r", ch );
	return;
    }

    if ( fAll )
    {
	for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
	    if ( skill_table[sn].name != NULL )
		victim->pcdata->learned[sn]	= value;
	}
    }
    else
    {
	victim->pcdata->learned[sn] = value;
    }

    return;
}



void do_mset( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int value;

    smash_tilde( argument );
    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    strcpy( arg3, argument );

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
    send_to_char( "Syntax: mset <victim> <field>  <value>\n\r", ch );
    send_to_char( "or:     mset <victim> <string> <value>\n\r", ch );
    send_to_char( "\n\r",                       ch );
    send_to_char( "Field being one of:\n\r",                ch );
    send_to_char( "  sex    class   level\n\r",      ch );
    send_to_char( "  hp     move    timer\n\r",     ch );
    send_to_char( "  align  master  leader  practice\n\r",  ch );
    send_to_char( "  act    affect\n\r",                    ch );
    send_to_char( "\n\r",                       ch );
    send_to_char( "String being one of:\n\r",           ch );
    send_to_char( "  name short long description spec\n\r",   ch );
    return;
    }

    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( !IS_NPC( victim ) )
    {
    send_to_char( "Not on PC's.\n\r", ch );
    return;
    }

    /*
     * Snarf the value (which need not be numeric).
     */
    value = is_number( arg3 ) ? atoi( arg3 ) : -1;

    /*
     * Set something.
     */
    if ( !str_cmp( arg2, "sex" ) && arg3[0] != '\0' )
    {
        if ( value < 0 || value > 2 )
        {
            send_to_char( "Sex range is 0 to 2.\n\r", ch );
            return;
        }
        victim->sex = value;
        return;
    }

    if ( !str_cmp( arg2, "class" ) && arg3[0] != '\0' )
    {
        if ( value < 0 || value >= MAX_CLASS )
        {
            char buf[MAX_STRING_LENGTH];

            sprintf( buf, "Class range is 0 to %d.\n", MAX_CLASS-1 );
            send_to_char( buf, ch );
            return;
        }
        victim->class = value;
        return;
    }

    if ( !str_cmp( arg2, "level" ) && arg3[0] != '\0' )
    {
        if ( value < 0 || value > 50 )
        {
            send_to_char( "Level range is 0 to 50.\n\r", ch );
            return;
        }
        victim->level = value;
        return;
    }

    if ( !str_cmp( arg2, "hp" ) && arg3[0] != '\0' )
    {
        if ( value < -10 || value > 30000 )
        {
            send_to_char( "Hp range is -10 to 30,000 hit points.\n\r", ch );
            return;
        }
        victim->max_hit = value;
        return;
    }


    if ( !str_cmp( arg2, "move" ) && arg3[0] != '\0' )
    {
        if ( value < 0 || value > 30000 )
        {
            send_to_char( "Move range is 0 to 30,000 move points.\n\r", ch );
            return;
        }
        victim->max_move = value;
        return;
    }

    if ( !str_cmp( arg2, "timer" ) && arg3[0] != '\0' )
    {
        if ( value < 0 || value > 30000 )
        {
            send_to_char( "Timer range is 0 to 30,000.\n\r", ch );
            return;
        }
        victim->timer = value;
        return;
    }

    if ( !str_cmp( arg2, "practice" ) && arg3[0] != '\0' )
    {
        if ( value < 0 || value > 100 )
        {
            send_to_char( "Practice range is 0 to 100 sessions.\n\r", ch );
            return;
        }
        victim->practice = value;
        return;
    }

    if ( !str_cmp( arg2, "align" ) && arg3[0] != '\0' )
    {
        if ( value < -1000 || value > 1000 )
        {
            send_to_char( "Alignment range is -1000 to 1000.\n\r", ch );
            return;
        }
        victim->alignment = value;
        return;
    }

    if ( !str_cmp( arg2, "master" ) && arg3[0] != '\0' )
    {
        if ( !str_cmp( arg3, "none" ) )
        {
        victim->master = NULL;
        return;
        }

        if ( ( get_char_world( ch, arg3 ) ) == NULL )
        {
        send_to_char( "They aren't here.\n\r", ch );
        return;
        }

        victim->master = get_char_world( ch, arg3 );
        return;
    }


    if ( !str_cmp( arg2, "leader" ) && arg3[0] != '\0' )
    {
        if ( !str_cmp( arg3, "none" ) )
        {
        victim->leader = NULL;
        return;
        }

        if ( ( get_char_world( ch, arg3 ) ) == NULL )
        {
        send_to_char( "They aren't here.\n\r", ch );
        return;
        }

        victim->leader = get_char_world( ch, arg3 );
        return;
    }

    if ( !str_cmp( arg2, "act" ) && arg3[0] != '\0' )
    {
        victim->act = value;
        if ( !IS_SET( victim->act, ACT_IS_NPC ) )
             SET_BIT( victim->act, ACT_IS_NPC );
        return;
    }

    if ( !str_cmp( arg2, "affect" ) && arg3[0] != '\0' )
    {
        victim->affected_by = value;
        return;
    }

    if ( !str_cmp( arg2, "name" ) && arg3[0] != '\0' )
    {
        free_string( victim->name );
        victim->name = str_dup( arg3 );
        return;
    }

    if ( !str_cmp( arg2, "short" ) && arg3[0] != '\0' )
    {
	free_string( victim->short_descr );
	victim->short_descr = str_dup( arg3 );
	return;
    }

    if ( !str_cmp( arg2, "long" ) )
    {                   
        send_to_char( "Entering line editing mode.\n\r", ch );
        send_to_char( "Terminate with a ~ on a blank line.\n\r", ch );
        ch->desc->pString = &victim->long_descr;
        return;
    }

    if ( !str_cmp( arg2, "description" ) )
    {
        send_to_char( "Entering line editing mode.\n\r", ch );
        send_to_char( "Terminate with a ~ on a blank line.\n\r", ch );
        ch->desc->pString = &victim->description;
        return;
    }

    if ( !str_cmp( arg2, "spec" ) && arg3[0] != '\0' )
    {
        if ( spec_lookup( arg3 ) == NULL )
        {
            send_to_char( "No such spec fun.\n\r", ch );
            return;
        }

        victim->spec_fun = spec_lookup( arg3 );
        victim->spec_name = str_dup( arg3 );
        return;
    }

    /*
     * Generate usage message.
     */
    do_mset( ch, "" );
    return;
}



void do_oset( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
    int value;

    smash_tilde( argument );
    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    strcpy( arg3, argument );

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
    send_to_char( "Syntax: oset <object> <field>  <value>\n\r", ch );
    send_to_char( "or:     oset <object> <string> <value>\n\r", ch );
    send_to_char( "\n\r",                                 ch );
    send_to_char( "Field being one of:\n\r",              ch );
    send_to_char( "  value0  value1  value2  value3\n\r", ch );
    send_to_char( "  extra   wear    level   weight\n\r", ch );
    send_to_char( "  cost    type    timer\n\r",          ch );
    send_to_char( "\n\r",                                 ch );
    send_to_char( "String being one of:\n\r",             ch );
    send_to_char( "  name    short   long    ed\n\r",     ch );
	return;
    }

    if ( ( obj = get_obj_world( ch, arg1 ) ) == NULL )
    {
    send_to_char( "Nothing like that in hell, earth, or heaven.\n\r", ch );
	return;
    }

    /*
     * Snarf the value (which need not be numeric).
     */
    value = atoi( arg3 );

    /*
     * Set something.
     */
    if ( (!str_cmp( arg2, "value0" ) || !str_cmp( arg2, "v0" )) && arg3[0] != '\0' )
    {
    obj->value[0] = value;
    return;
    }

    if ( (!str_cmp( arg2, "value1" ) || !str_cmp( arg2, "v1" )) && arg3[0] != '\0' )
    {
	obj->value[1] = value;
	return;
    }

    if ( (!str_cmp( arg2, "value2" ) || !str_cmp( arg2, "v2" )) && arg3[0] != '\0' )
    {
	obj->value[2] = value;
	return;
    }

    if ( (!str_cmp( arg2, "value3" ) || !str_cmp( arg2, "v3" )) && arg3[0] != '\0' )
    {
	obj->value[3] = value;
	return;
    }

    if ( !str_cmp( arg2, "extra" ) && arg3[0] != '\0' )
    {
	obj->extra_flags = value;
	return;
    }

    if ( !str_cmp( arg2, "wear" ) && arg3[0] != '\0' )
    {
	obj->wear_flags = value;
	return;
    }

    if ( !str_cmp( arg2, "level" ) && arg3[0] != '\0' )
    {
	obj->level = value;
	return;
    }
	
    if ( !str_cmp( arg2, "weight" ) && arg3[0] != '\0' )
    {
	obj->weight = value;
	return;
    }

    if ( !str_cmp( arg2, "cost" ) && arg3[0] != '\0' )
    {
	obj->cost = value;
	return;
    }

    if ( !str_cmp( arg2, "timer" ) && arg3[0] != '\0' )
    {
	obj->timer = value;
	return;
    }

    if ( !str_cmp( arg2, "type" ) && arg3[0] != '\0' )
    {
    obj->item_type = value;
    return;
    }

    if ( !str_cmp( arg2, "name" ) && arg3[0] != '\0' )
    {
	free_string( obj->name );
	obj->name = str_dup( arg3 );
	return;
    }

    if ( !str_cmp( arg2, "short" ) && arg3[0] != '\0' )
    {
	free_string( obj->short_descr );
	obj->short_descr = str_dup( arg3 );
	return;
    }

    if ( !str_cmp( arg2, "long" ) )
    {           
        send_to_char( "Entering line editing mode.\n\r", ch );
        send_to_char( "Terminate with a ~ on a blank line.\n\r", ch );
        ch->desc->pString = &obj->description;
        return;
    }

    if ( !str_cmp( arg2, "ed" ) )
    {
	EXTRA_DESCR_DATA *ed;

    if ( ch->sedit != NULL )
    {
        send_to_char( "You are already editing a string.\n\r", ch );
        return;
    }

	argument = one_argument( argument, arg3 );
	if ( argument == NULL )
	{
        send_to_char( "Syntax: oset <object> ed <keyword> <string>\n\r",
		ch );
	    return;
	}

	if ( extra_descr_free == NULL )
	{
	    ed			= alloc_perm( sizeof(*ed) );
	}
	else
	{
	    ed			= extra_descr_free;
	    extra_descr_free	= ed;
	}

    send_to_char( "Entering line editing mode.\n\r", ch );
    send_to_char( "Terminate with a ~ on a blank line.\n\r", ch );
	ed->keyword		= str_dup( arg3     );
    ch->desc->pString = &ed->description;
	ed->next		= obj->extra_descr;
	obj->extra_descr	= ed;
	return;
    }

    /*
     * Generate usage message.
     */
    do_oset( ch, "" );
    return;
}



void do_pset( CHAR_DATA *ch, char *argument )
{
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    int value;

    smash_tilde( argument );
    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    strcpy( arg3, argument );

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
    send_to_char( "Syntax: pset <victim> <field>  <value>\n\r",  ch );
    send_to_char( "or:     pset <victim> <string> <value>\n\r",  ch );
    send_to_char( "\n\r",                                        ch );
    send_to_char( "Field being one of:\n\r",                     ch );
    send_to_char( "  str int wis dex con sex security\n\r",      ch );
    send_to_char( "  hp move practice align race\n\r",           ch );
    send_to_char( "  thirst drunk full master leader learn",     ch );
    send_to_char( "\n\r",                                        ch );
    send_to_char( "String being one of:\n\r",                    ch );
    send_to_char( "  short long description title\n\r",          ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC( victim ) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
    return;
    }

    if ( get_trust( victim ) > get_trust( ch ) )
    {
    send_to_char( "They are trusted at a higher level than you.\n\r", ch );
    return;
    }

    /*
     * Snarf the value (which need not be numeric).
     */
    value = is_number( arg3 ) ? atoi( arg3 ) : -1;

    /*
     * Set something.
     */
    if ( !str_cmp( arg2, "str" ) && arg3[0] != '\0' )
    {
        if ( value < 3 || value > 25 )
	{
        send_to_char( "Strength range is 3 to 25.\n\r", ch );
	    return;
	}

	victim->pcdata->perm_str = value;
	return;
    }

    if ( !str_cmp( arg2, "int" ) && arg3[0] != '\0' )
    {
        if ( value < 3 || value > 25 )
	{
        send_to_char( "Intelligence range is 3 to 25.\n\r", ch );
	    return;
	}

	victim->pcdata->perm_int = value;
	return;
    }

    if ( !str_cmp( arg2, "wis" ) && arg3[0] != '\0' )
    {
        if ( value < 3 || value > 25 )
	{
        send_to_char( "Wisdom range is 3 to 25.\n\r", ch );
	    return;
	}

	victim->pcdata->perm_wis = value;
	return;
    }

    if ( !str_cmp( arg2, "dex" ) && arg3[0] != '\0' )
    {
        if ( value < 3 || value > 25 )
	{
        send_to_char( "Dexterity range is 3 to 25.\n\r", ch );
	    return;
	}

	victim->pcdata->perm_dex = value;
	return;
    }

    if ( !str_cmp( arg2, "con" ) && arg3[0] != '\0' )
    {
        if ( value < 3 || value > 25 )
	{
        send_to_char( "Constitution range is 3 to 25.\n\r", ch );
	    return;
	}

	victim->pcdata->perm_con = value;
	return;
    }

    if ( !str_cmp( arg2, "sex" ) && arg3[0] != '\0' )
    {
	if ( value < 0 || value > 2 )
	{
        send_to_char( "Sex range is 0 to 2.\n\r", ch );
	    return;
	}
	victim->sex = value;
	return;
    }

    if ( !str_cmp( arg2, "race" ) && arg3[0] != '\0' )
    {
    if ( value < 0 || value >= MAX_RACE )
	{
	    char buf[MAX_STRING_LENGTH];

        sprintf( buf, "Class range is 0 to %d.\n", MAX_RACE-1 );
	    send_to_char( buf, ch );
	    return;
	}
    victim->race = value;
	return;
    }


    if ( !str_cmp( arg2, "hp" ) && arg3[0] != '\0' )
    {
    if ( value < 1 || value > 30000 )
	{
        send_to_char( "Hp range is 1 to 30,000 hit points.\n\r", ch );
	    return;
	}
	victim->max_hit = value;
	return;
    }


    if ( !str_cmp( arg2, "move" ) && arg3[0] != '\0' )
    {
    if ( value < 1 || value > 30000 )
	{
        send_to_char( "Move range is 1 to 30,000 move points.\n\r", ch );
	    return;
	}
	victim->max_move = value;
	return;
    }

    if ( !str_cmp( arg2, "practice" ) && arg3[0] != '\0' )
    {
	if ( value < 0 || value > 100 )
	{
        send_to_char( "Practice range is 0 to 100 sessions.\n\r", ch );
	    return;
	}
	victim->practice = value;
	return;
    }

    if ( !str_cmp( arg2, "security" ) && arg3[0] != '\0' )
    {
    if ( value < 1 || value > 9 )
	{
        send_to_char( "Security level is between 1 and 9.\n\r", ch );
	    return;
	}

    if ( victim->security >= ch->security )
    {
        send_to_char( "They have a higher security level than you!\n\r", ch );
        return;
    }

    victim->security = UMIN(ch->security, value);
	return;
    }

    if ( !str_cmp( arg2, "learn" ) && arg3[0] != '\0' )
    {
    if ( value < 0 || value > MAX_SKILL )
	{
        send_to_char( "Practice range is 0 to 100 sessions.\n\r", ch );
	    return;
	}
    victim->learn = value;
	return;
    }

    if ( !str_cmp( arg2, "align" ) && arg3[0] != '\0' )
    {
	if ( value < -1000 || value > 1000 )
	{
        send_to_char( "Alignment range is -1000 to 1000.\n\r", ch );
	    return;
	}
	victim->alignment = value;
	return;
    }

    if ( !str_cmp( arg2, "thirst" ) && arg3[0] != '\0' )
    {
	if ( value < 0 || value > 100 )
	{
        send_to_char( "Thirst range is 0 to 100.\n\r", ch );
	    return;
	}

	victim->pcdata->condition[COND_THIRST] = value;
	return;
    }

    if ( !str_cmp( arg2, "drunk" ) && arg3[0] != '\0' )
    {
	if ( value < 0 || value > 100 )
	{
        send_to_char( "Drunk range is 0 to 100.\n\r", ch );
	    return;
	}

	victim->pcdata->condition[COND_DRUNK] = value;
	return;
    }

    if ( !str_cmp( arg2, "full" ) && arg3[0] != '\0' )
    {
	if ( value < 0 || value > 100 )
	{
        send_to_char( "Full range is 0 to 100.\n\r", ch );
	    return;
	}

	victim->pcdata->condition[COND_FULL] = value;
	return;
    }

    if ( !str_cmp( arg2, "master" ) && arg3[0] != '\0' )
    {
    if ( !str_cmp( arg3, "none" ) )
    {
    victim->master = NULL;
    return;
    }

    if ( ( get_char_world( ch, arg3 ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
    return;
    }

    victim->master = get_char_world( ch, arg3 );
    return;
    }


    if ( !str_cmp( arg2, "leader" ) && arg3[0] != '\0' )
    {
    if ( !str_cmp( arg3, "none" ) )
    {
    victim->leader = NULL;
    return;
    }

    if ( ( get_char_world( ch, arg3 ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
    return;
    }

    victim->leader = get_char_world( ch, arg3 );
    return;
    }

    if ( !str_cmp( arg2, "short" ) && arg3[0] != '\0' )
    {
	free_string( victim->short_descr );
	victim->short_descr = str_dup( arg3 );
	return;
    }

    if ( !str_cmp( arg2, "long" ) )
    {           
        send_to_char( "Entering line editing mode.\n\r", ch );
        send_to_char( "Terminate with a ~ on a blank line.\n\r", ch );
        ch->desc->pString = &victim->long_descr;
        return;
    }

    if ( !str_cmp( arg2, "title" ) && arg3[0] != '\0' )
    {
	set_title( victim, arg3 );
	return;
    }

    /*
     * Generate usage message.
     */
    do_pset( ch, "" );
    return;
}


void do_set( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_STRING_LENGTH];

    argument = one_argument( argument, arg );
    
     if ( !str_prefix( arg, "mobile" ) ) do_mset( ch, argument );
else if ( !str_prefix( arg, "object" ) ) do_oset( ch, argument );
else if ( !str_prefix( arg, "player" ) ) do_pset( ch, argument );
else send_to_char( "Syntax: Set <mob|obj|player> <name> <field> <value>\n\r", ch );

     return;
}


void do_nwhere( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_STRING_LENGTH];

    if ( !IS_IMMORTAL( ch ) )
      {
           do_where( ch, argument );
           return;
	 }
    
    argument = one_argument( argument, arg );

     if ( !str_prefix( arg, "mobile" ) ) do_mwhere( ch, argument ); 
else if ( !str_prefix( arg, "object" ) ) do_owhere( ch, argument );
else if ( !str_prefix( arg, "player" ) )  do_where( ch, argument );
else send_to_char( "Syntax: Where <mob|obj|player> <name>\n\r", ch );

     return;
}



void do_users( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    DESCRIPTOR_DATA *d;
    int count;

    count	= 0;
    buf[0]	= '\0';
    for ( d = descriptor_list; d != NULL; d = d->next )
    {
	if ( d->character != NULL && can_see( ch, d->character ) )
	{
	    count++;
        sprintf( buf + strlen(buf), "[%2d %2d %2d] %s@%s\n\r",
		d->descriptor,
		d->connected,
        d->character ? d->character->timer : 0,
        d->original  ? NAME(d->original)  :
        d->character ? NAME(d->character) : "(none)",
		d->host
		);
	}
    }

    sprintf( buf2, "%d user%s\n\r", count, count == 1 ? "" : "s" );
    send_to_char( buf2, ch );
    send_to_char( buf, ch );
    return;
}



/*
 * Thanks to Grodyn for pointing out bugs in this function.
 */
void do_force( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];

    argument = one_argument( argument, arg );

    if ( arg[0] == '\0' || argument[0] == '\0' )
    {
    send_to_char( "Force whom to do what?\n\r", ch );
	return;
    }

    if ( !str_cmp( arg, "all" ) )
    {
	CHAR_DATA *vch;
	CHAR_DATA *vch_next;

	for ( vch = char_list; vch != NULL; vch = vch_next )
	{
	    vch_next = vch->next;

	    if ( !IS_NPC(vch) && get_trust( vch ) < get_trust( ch ) )
	    {
        act( "$n forces everyone to '$t'.", ch, argument, vch, TO_VICT );
        if (!IS_NPC(ch))
          FORCE_LEVEL = get_trust( ch );
          else
          FORCE_LEVEL = MAX_LEVEL;
		interpret( vch, argument );
	    }
	}
    }
    else
    {
	CHAR_DATA *victim;

	if ( ( victim = get_char_world( ch, arg ) ) == NULL )
	{
        send_to_char( "They aren't here.\n\r", ch );
	    return;
	}

	if ( victim == ch )
	{
        send_to_char( "Aye aye, right away!\n\r", ch );
	    return;
	}

	if ( get_trust( victim ) >= get_trust( ch ) )
	{
        send_to_char( "Do it yourself!\n\r", ch );
	    return;
	}

    act( "$n forces you to '$t'.", ch, argument, victim, TO_VICT );
    if (!IS_NPC(ch))
      FORCE_LEVEL = get_trust( ch );
      else
      FORCE_LEVEL = MAX_LEVEL;

	interpret( victim, argument );
    }

    send_to_char( "Ok.\n\r", ch );
    return;
}



/*
 * New routines by Dionysos.
 */
void do_invis( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    int oldinvis;

    one_argument( argument, arg );

    if ( IS_NPC(ch) )
	return;

    oldinvis = ch->wizinvis;
    if ( arg[0] == '\0' )
    {
         ch->wizinvis = ch->wizinvis == 0 ? ch->level : 0;
    }
    else ch->wizinvis = atoi( arg );


    ch->wizinvis = ch->wizinvis <= ch->level ? ch->wizinvis : ch->level;

    if ( ch->wizinvis <= LEVEL_IMMORTAL && ch->wizinvis != 0 )
         ch->wizinvis = 0;

    if ( ch->wizinvis == oldinvis ||
      ( ch->wizinvis >= LEVEL_IMMORTAL && oldinvis >= LEVEL_IMMORTAL ) )
        return;

    if ( ch->wizinvis < oldinvis && ch->wizinvis == 0 )
    {
    act( "$n slowly fades into existence.", ch, NULL, NULL, TO_ROOM );
    send_to_char( "You slowly fade back into existence.\n\r", ch );
    }
    else
    if ( ch->wizinvis >= LEVEL_IMMORTAL && ch->wizinvis > oldinvis )
    {
    act( "$n slowly fades into thin air.", ch, NULL, NULL, TO_ROOM );
    send_to_char( "You slowly vanish into thin air.\n\r", ch );
    }

    return;
}



void do_holylight( CHAR_DATA *ch, char *argument )
{
    if ( IS_NPC(ch) )
	return;

    if ( IS_SET(ch->act, PLR_HOLYLIGHT) )
    {
	REMOVE_BIT(ch->act, PLR_HOLYLIGHT);
    send_to_char( "Holy light mode off.\n\r", ch );
    }
    else
    {
	SET_BIT(ch->act, PLR_HOLYLIGHT);
    send_to_char( "Holy light mode on.\n\r", ch );
    }

    return;
}

void do_bounty( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );

    if ( arg1[0] == '\0' || arg2[0] == '\0' || !is_number( arg2 ) )
    {
    send_to_char( "Syntax: bounty <character> <bounty>.\n\r", ch );
	return;
    }

    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
    send_to_char( "They aren't here.\n\r", ch );
	return;
    }

    if ( IS_NPC(victim) )
    {
    send_to_char( "Not on NPC's.\n\r", ch );
	return;
    }

    victim->bounty =  atoi( arg2 );

    send_to_char( "Bounty set.\n\r", ch );
    return;
}


/* Wizify and Wizbit sent in by M. B. King */

void do_wizify( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
  
    argument = one_argument( argument, arg1  );
    if ( arg1[0] == '\0' )
    {
	send_to_char( "Syntax: wizify <name>\n\r" , ch );
	return;
    }
    if ( ( victim = get_char_world( ch, arg1 ) ) == NULL )
    {
	send_to_char( "They aren't here.\n\r" , ch );
	return;
    }
    if ( IS_NPC( victim ) )
    {
	send_to_char( "Not on mobs.\n\r", ch );
	return;
    }

    TOGGLE_BIT( victim->act, PLR_WIZBIT );
    if ( IS_SET(victim->act, PLR_WIZBIT ) )
    {
	act( "$N wizified.\n\r", ch, NULL, victim, TO_CHAR );
	act( "$n has wizified you!\n\r", ch, NULL, victim, TO_VICT );
    }
    else
    {
	act( "$N dewizzed.\n\r", ch, NULL, victim, TO_CHAR );
	act( "$n has dewizzed you!\n\r", ch, NULL, victim, TO_VICT ); 
    }

    do_save( victim, "");
    return;
}

/* Idea from Talen of Vego's do_where command */

void do_owhere( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    bool found = FALSE;
    OBJ_DATA *obj;
    OBJ_DATA *in_obj;
    int obj_counter = 1;

    one_argument( argument, arg );

    if( arg[0] == '\0' )
    {
	send_to_char( "Syntax:  owhere <object>.\n\r", ch );
	return;
    }
    else
    {
	for ( obj = object_list; obj != NULL; obj = obj->next )
	{
        if ( !can_see_obj( ch, obj ) || !is_name( arg, STR(obj, name) ) )
	        continue;

	    found = TRUE;

	    for ( in_obj = obj; in_obj->in_obj != NULL;
		 in_obj = in_obj->in_obj )
	        ;

	    if ( in_obj->carried_by != NULL )
	    {
		sprintf( buf, "[%2d] %s carried by %s.\n\r", obj_counter,
            STR(obj, short_descr), PERS( in_obj->carried_by, ch ) );
	    }
	    else
	    {
        sprintf( buf, "[%2d] %s in %s [%d].\n\r", obj_counter,
            STR(obj, short_descr), ( in_obj->in_room == NULL ) ?
            "somewhere" : in_obj->in_room->name, (in_obj->in_room == NULL) ?
            0 : in_obj->in_room->vnum );
	    }
	    
	    obj_counter++;
	    buf[0] = UPPER( buf[0] );
	    send_to_char( buf, ch );
	}
    }

    if ( !found )
	send_to_char(
		"Nothing like that in hell, earth, or heaven.\n\r" , ch );

    return;


}

void do_areas( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    AREA_DATA *pArea;

    sprintf( buf, "[%3s] %-24s (%-5s-%5s)   %10s %3s [%s]\n\r",
       "Num", "Area Name", "lvnum", "uvnum", "Filename", "Sec", "Builders" );
    send_to_char( buf, ch );

    for ( pArea = area_first; pArea != NULL; pArea = pArea->next )
    {
    sprintf( buf, "[%3d] %-24s (%-5d-%5d) %13s %2d [%s]\n\r",
        pArea->vnum,
        pArea->name,
        pArea->lvnum,
        pArea->uvnum,
        pArea->filename,
        pArea->security,
        pArea->builders );
	send_to_char( buf, ch );
    }

    return;
}






