/****************************************************************************
 *   ___  ___  ___  __    __                                                *
 *  |   ||   ||   ||  |\/|  | 2-x    NiMUD is a software currently under    *
 *   |  \ | |  | |  | |\/| |         development.  It is based primarily on *
 *   | |\\| |  | |  | |  | |         the discontinued package, Merc 2.2.    *
 *   | | \  |  | |  | |  | |         NiMUD is being written and developed   *
 *  |___||___||___||__|  |__|        By Locke and Surreality as a new,      *
 *   NAMELESS INCARNATE *MUD*        frequently updated package similar to  *
 *        S O F T W A R E            the original Merc 2.x.                 *
 *                                                                          *
 *  Just look for the Iron Maiden skull wherever NiMUD products are found.  *
 *                                                                          *
 *  Much time and thought has gone into this software and you are           *
 *  benefitting.  We hope that you share your changes too.  What goes       *
 *  around, comes around.                                                   *
 ****************************************************************************/
 
#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"
 
/*
 * I could have wrote this as a dynamic entity, but I'm lazy.
 */
 
#define MAX_BOARD       42

/* currently unused */ 
#if defined(unix)
#define BOARD_PATH      "\boards"
#else
#define BOARD_PATH      ""
#endif
 
struct board_data
{
    char *name;
    char *filename;
    int writelevel;
    int readlevel;
  };
 
 
const struct board_data board_table [MAX_BOARD] =
{
  { "Immortal",      "board1.txt",   LEVEL_IMMORTAL, LEVEL_IMMORTAL   },
  { "Announcements", "board2.txt",   LEVEL_IMMORTAL, 0                },
  { "Public",        "board3.txt",   0,              0                },
  { "Hero",          "board4.txt",   LEVEL_HERO,     LEVEL_HERO       },
  { "Building",      "board5.txt",   LEVEL_HERO,     LEVEL_HERO       },
  { "Rules",         "board6.txt",   LEVEL_IMMORTAL, 0                },
  { "Clan Heads",    "board7.txt",   0,              0                },
  { "Judges",        "board8.txt",   LEVEL_ANGEL,    0                },
  { "Complains",     "board9.txt",   0,              0                },
  { "Roleplay",      "board10.txt",  0,              0                },
 
  { "Bulletins",     "bboard1.txt",  0,              0                },
  { "Bulletins",     "bboard2.txt",  0,              0                },
  { "Bulletins",     "bboard3.txt",  0,              0                },
  { "Bulletins",     "bboard4.txt",  0,              0                },
  { "Bulletins",     "bboard5.txt",  0,              0                },
  { "Bulletins",     "bboard6.txt",  0,              0                },
  { "Bulletins",     "bboard7.txt",  0,              0                },
  { "Bulletins",     "bboard8.txt",  0,              0                },
  { "Bulletins",     "bboard9.txt",  0,              0                },
  { "Bulletins",     "bboard10.txt", 0,              0                },
 
  { "Clan Board 1",  "cboard1.txt",  0,              0                },
  { "Clan Board 2",  "cboard2.txt",  0,              0                },
  { "Clan Board 3",  "cboard3.txt",  0,              0                },   
  { "Clan Board 4",  "cboard4.txt",  0,              0                },   
  { "Clan Board 5",  "cboard5.txt",  0,              0                },   
  { "Clan Board 6",  "cboard6.txt",  0,              0                },   
  { "Clan Board 7",  "cboard7.txt",  0,              0                },   
  { "Clan Board 8",  "cboard8.txt",  0,              0                },   
  { "Clan Board 9",  "cboard9.txt",  0,              0                },   
  { "Clan Board 10", "cboard10.txt", 0,              0                },   
  { "Clan Board 11", "cboard11.txt", 0,              0                },   
  { "Clan Board 12", "cboard12.txt", 0,              0                },   
  { "Clan Board 13", "cboard13.txt", 0,              0                },   
  { "Clan Board 14", "cboard14.txt", 0,              0                },   
  { "Clan Board 15", "cboard15.txt", 0,              0                },   
  { "Clan Board 16", "cboard16.txt", 0,              0                },   
  { "Clan Board 17", "cboard17.txt", 0,              0                },   
  { "Clan Board 18", "cboard18.txt", 0,              0                },   
  { "Clan Board 19", "cboard19.txt", 0,              0                },   
  { "Clan Board 20", "cboard20.txt", 0,              0                },

  { "IC Bulletins",  "bboard1.txt",  0,              0                },
  { "Housing",       "bboard2.txt",  0,              LEVEL_HERO       }

};

#define KEY( literal, field, value )                \
                                if ( !str_cmp( word, literal ) )        \
                {                                   \
                    field  = value;                 \
                    fMatch = TRUE;                  \
                    break;                          \
                                }
 
#define SKEY( string, field )                       \
                if ( !str_cmp( word, string ) )     \
                {                                   \
                    free_string( field );           \
                    field = fread_string( fp );     \
                    fMatch = TRUE;                  \
                    break;                          \
                                }

extern char                    strArea[MAX_INPUT_LENGTH]; 
extern FILE *                  fpArea;

/*
 * Careful when creating a verbose bulletin list, as each one will end
 * up with only a few words on it.  Now, the Clan Boards are accessible
 * by only a few people out of the norm, so it makes sense to make as
 * many as you are going to need.  Remember the number and modify the
 * table if you want to change the name of the board according to the
 * clan name.  Just remember that you wont a whole bunch of the other
 * ones, so keep it to a minimum.
 */
 
struct note_data     *note_list[MAX_BOARD];
 
/*
 * this structure is as good as any, might as well use it...
struct  note_data
{
    NOTE_DATA * next;
    char *      sender;
    char *      date;
    char *      to_list;
    char *      subject;
    char *      text;
    time_t      date_stamp;
  };
 */
 
 
bool is_note_to  args( ( CHAR_DATA *ch, int board, NOTE_DATA *pnote ) );

#define CAN_WRITE(ch, boardnum)  ( ch->level >=                         \
                                   board_table[boardnum].writelevel )
 
#define list      note_list[b]
#define filename  board_table[b].filename

void fread_board( int b )
{
    FILE *fp;
    NOTE_DATA *pnote;
    NOTE_DATA *pnotelast;
    char *word;
    bool fMatch;
    int count = 0;
 
    if ( ( fp = fopen( filename, "r" ) ) == NULL )
      {
        list = NULL;
        return;
      }
     
    pnote = alloc_mem( sizeof(*pnote) );    /* create a new note      */
    pnote->sender   = str_dup( "" );        /* defaults */
    pnote->date     = str_dup( "" );
    pnote->to_list  = str_dup( "" );
    pnote->subject  = str_dup( "" );
    pnote->text     = str_dup( "" );
    pnote->next     = NULL;                 /* clip it off            */
    list = pnote;                           /* put it on the fore     */
    pnotelast = NULL;                       /* first != last          */
        
    for ( ; ; )
      {
        fMatch = FALSE;                     /* lame screwups */
        
        word = feof(fp) ? "#END" : fread_word( fp );
 
        switch ( UPPER(word[0]) )
        {
           case 'S':                                   /* fill */
             KEY( "Sender",  pnote->sender,     fread_string( fp ) );
             KEY( "Stamp",   pnote->date_stamp, fread_number( fp ) );
             KEY( "Subject", pnote->subject,    fread_string( fp ) );
            break;
           case 'D':
             KEY( "Date",    pnote->date,       fread_string( fp ) );
            break;
           case 'T':
             KEY( "To",      pnote->to_list,    fread_string( fp ) );
             KEY( "Text",    pnote->text,       fread_string( fp ) );
            break;
           case 'E':  
             if ( !str_cmp( word, "End" ) )
             {                                        /* not first, second */
                 if ( pnotelast != NULL ) 
                 pnotelast->next = pnote;             /* add to list       */
                 pnotelast = pnote;                   /* prepare for next  */
                 pnote = alloc_mem( sizeof(*pnote) ); /* create the next   */
                 pnote->sender   = str_dup( "" );     /* defaults */
                 pnote->date     = str_dup( "" );
                 pnote->to_list  = str_dup( "" );
                 pnote->subject  = str_dup( "" );
                 pnote->text     = str_dup( "" );
                 pnote->next     = NULL;              /* clip it off       */
                 fMatch = TRUE;
                 count++;
             }
            break;
           case '#':
             if ( !str_cmp( word, "#END" ) )      
             {
                 if (list == pnote) list = NULL;     /* no notes = no list */
                 pnote->next = note_free;            /* add to free list   */
                 note_free   = pnote;
                 if (pnotelast != NULL) 
                 pnotelast->next = NULL;             /* clip list          */
                 fclose( fp );
                 return;
             }
            break;
        }
        
        if ( !fMatch )
        {
            strcpy( strArea, filename );
            sprintf( log_buf, "load_notes: bad keyword '%s'", word );
            bug( log_buf, 0 );                                       
            fclose( fp );
            return;
        }
    }
}

#undef list 
#undef filename
 
void load_boards( void )
{
   int b;
   
   for ( b = 0; b < MAX_BOARD; b++ ) fread_board( b );
   return;
}
 

void note_remove( CHAR_DATA *ch, NOTE_DATA *pnote, int b )
{
    char to_new[MAX_INPUT_LENGTH];
    char to_one[MAX_INPUT_LENGTH];
    NOTE_DATA *prev;
    char *to_list;
 
    /*
     * Build a new to_list.
     * Strip out this recipient.
     */
    to_new[0]   = '\0';
    to_list     = pnote->to_list;
    while ( *to_list != '\0' )
      {
        to_list = one_argument( to_list, to_one );
    if ( to_one[0] != '\0' && str_cmp( NAME(ch), to_one ) )
      {
            strcat( to_new, " " );
            strcat( to_new, to_one );
      }
      }
 
    /*
     * Just a simple recipient removal?
     */
    if ( !is_note_to( ch, b, pnote ) )
      {
    if ( str_cmp( NAME(ch), pnote->sender ) && to_new[0] != '\0' )
      {
        free_string( pnote->to_list );
        pnote->to_list = str_dup( to_new + 1 );
        return;
      }
  }
 
    /*
     * Remove note from linked list.
     */
    if ( pnote == note_list[b] )
      {
        note_list[b] = pnote->next;
      }
    else
      {
        for ( prev = note_list[b]; prev != NULL; prev = prev->next )
          {
            if ( prev->next == pnote )
                break;
          }
 
        if ( prev == NULL )
          {
            bug( "Note_remove: pnote not found.", 0 );
            return;
          }
 
        prev->next = pnote->next;
      }
 
    free_string( pnote->text    );
    free_string( pnote->subject );
    free_string( pnote->to_list );
    free_string( pnote->date    );
    free_string( pnote->sender  );
    pnote->next = note_free;
    note_free   = pnote; 
    return;
  }

 
void save_board( int b )
{
    NOTE_DATA *pnote;
    FILE *fp;
    
    fclose( fpReserve );
    if ( ( fp = fopen( board_table[b].filename, "w" ) ) == NULL )
      {
        perror( board_table[b].filename );
        return;
      }
     
    for ( pnote = note_list[b]; pnote != NULL; pnote = pnote->next )
      {
        smash_tilde( pnote->text );
 
        fprintf( fp, "Sender  %s~\n", fix_string( pnote->sender ) );
        fprintf( fp, "Date    %s~\n", pnote->date );
        fprintf( fp, "Stamp   %d\n",  pnote->date_stamp );
        fprintf( fp, "To      %s~\n", fix_string( pnote->to_list ) );
        fprintf( fp, "Subject %s~\n", fix_string( pnote->subject ) );
        fprintf( fp, "Text\n%s~\n",   pnote->text );
        fprintf( fp, "End\n\n" );
      }
    fprintf( fp, "#END\n" );
    fclose( fp );
    fpReserve = fopen( NULL_FILE, "r" );
  }
 
 
 
bool is_note_to( CHAR_DATA *ch, int board, NOTE_DATA *pnote )
{
    if ( !str_cmp( NAME(ch), pnote->sender ) )
        return TRUE;
 
    if ( ch->level < board_table[board].readlevel )
        return FALSE;
 
    if ( is_name( "all", pnote->to_list ) )
        return TRUE;
 
    if ( IS_HERO(ch) && is_name( "immortal", pnote->to_list ) )
        return TRUE;
 
    if ( is_name( NAME(ch), pnote->to_list ) )
        return TRUE;
        
    if ( ch->level >= LEVEL_SUPREME )
        return TRUE;
 
    return FALSE;
  }   
 
 
void note_attach( CHAR_DATA *ch )
{
    NOTE_DATA *pnote;
 
    if ( ch->pnote != NULL )
        return;
 
    if ( note_free == NULL )
      {
        pnote     = alloc_perm( sizeof(*ch->pnote) );
      }
    else
      {
        pnote     = note_free;
        note_free = note_free->next;
      }
 
    pnote->next         = NULL;
    pnote->sender       = str_dup( NAME(ch) );
    pnote->date         = str_dup( "" );
    pnote->to_list      = str_dup( "" );
    pnote->subject      = str_dup( "" );
    pnote->text         = str_dup( "" );
    ch->pnote           = pnote;
    return;
  }
 
 
void do_note( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char buf1[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    NOTE_DATA *pnote;
    int vnum;
    int anum;
    OBJ_DATA *obj;
    int bnum;
    
    if ( IS_NPC(ch) )
        return;
 
    buf1[0] = '\0';
 
    argument = one_argument( argument, arg );
    smash_tilde( argument );
 
    if ( arg[0] == '\0' )
      {                                         
        send_to_char( "Syntax: note list            \n\r", ch );
        send_to_char( "        note read <num>      \n\r", ch );
        send_to_char( "        note remove <num>    \n\r", ch );
        send_to_char( "        note delete <num>    \n\r\n\r", ch );
        send_to_char( "Syntax: note to <person(s)|all|immort>\n\r", ch );
        send_to_char( "        note subject <text>  \n\r", ch );
        send_to_char( "        note write           \n\r", ch );
        send_to_char( "        note post            \n\r", ch );
        send_to_char( "        note show            \n\r", ch );
        send_to_char( "        note clear           \n\r", ch );
        return;
      }
   
    for ( obj = ch->in_room->contents; obj != NULL; obj = obj->next_content )
      {
        if ( obj->item_type == ITEM_BOARD && obj->value[0] >= 0 &&
             obj->value[0] < MAX_BOARD )
           break;
      }
    
    if ( obj == NULL ) 
      {
        send_to_char( "There is no board here.\n\r", ch );
        return;
      }
    bnum = obj->value[0];
               
    if ( !str_cmp( arg, "list" ) )
      {
        vnum = 1;
        sprintf( buf, "The following notes are on the %s board:\n\r", 
                      board_table[bnum].name );
        send_to_char( buf, ch );
        for ( pnote = note_list[bnum]; pnote != NULL; pnote = pnote->next )
          {
            if ( is_note_to( ch, bnum, pnote ) )
              {
        sprintf( buf, "[%-3d %18s] %s to %s: %s\n\r",
            vnum,
            pnote->date, pnote->sender, pnote->to_list, pnote->subject );
                strcat( buf1, buf );
                vnum++;
      }
          }
        if ( buf1[0] == '\0' ) sprintf( buf1, "None.\n\r" );
        send_to_char( buf1, ch );
        act( "$n looks over the notes on $p.", ch, obj, NULL, TO_ROOM );
        return;
      }
 
    if ( !str_cmp( arg, "read" ) )
      {
        bool fAll;
 
        if ( !str_cmp( argument, "all" ) )
          {
            fAll = TRUE;
            anum = 0;
          }
        else if ( argument[0] == '\0' || !str_prefix( argument, "next" ) )
          /* read next unread note */
          {
            vnum = 1;
            for ( pnote = note_list[bnum]; pnote != NULL; pnote = pnote->next )
              {
                if ( is_note_to( ch, bnum, pnote )
            && str_cmp( NAME(ch), pnote->sender )
                    && ch->last_note < pnote->date_stamp )
                  {
                    sprintf( buf, "[%3d] %s: %s\n\r%s\n\rTo: %s\n\r",
                            vnum,
                            pnote->sender,
                            pnote->subject,
                            pnote->date,
                            pnote->to_list );
                    strcat( buf1, buf );
                    strcat( buf1, pnote->text );
                    ch->last_note = UMAX( ch->last_note, pnote->date_stamp );
                    send_to_char( buf1, ch );
act( "$n studies a note on $p for a while.", ch, obj, NULL, TO_ROOM );
                    return;
                  }
                else
                    vnum++;
              }
            send_to_char( "You have no unread notes.\n\r", ch );
            return;
          }
        else if ( is_number( argument ) )
          {
            fAll = FALSE;
            anum = atoi( argument );
          }
        else
          {
            send_to_char( "Note read which number?\n\r", ch );
            return;
          }
 
        vnum = 1;
        for ( pnote = note_list[bnum]; pnote != NULL; pnote = pnote->next )
          {
            if ( is_note_to( ch, bnum, pnote ) && ( vnum++ == anum || fAll ) )
              {
                sprintf( buf, "[%3d] %s: %s\n\r%s\n\rTo: %s\n\r",
                      vnum - 1,
                      pnote->sender,
                      pnote->subject,
                      pnote->date,
                      pnote->to_list      );
                strcat( buf1, buf );
                strcat( buf1, pnote->text );
                send_to_char( buf1, ch );
act( "$n studies a note on $p for a while.", ch, obj, NULL, TO_ROOM );
                ch->last_note = UMAX( ch->last_note, pnote->date_stamp );
                return;
              }
          }
 
        send_to_char( "No such note.\n\r", ch );
        return;
      }
 
    if ( !str_cmp( arg, "write" ) )
      {
    note_attach( ch );
    string_append( ch, &ch->pnote->text );
    return;
  }
 
 
    if ( !str_cmp( arg, "subject" ) )
      {
        note_attach( ch );
        free_string( ch->pnote->subject );
        ch->pnote->subject = str_dup( argument );
        send_to_char( "Ok.\n\r", ch );
        return;
      }
 
    if ( !str_cmp( arg, "to" ) )
      {
        note_attach( ch );
        free_string( ch->pnote->to_list );
        ch->pnote->to_list = str_dup( argument );
        send_to_char( "Ok.\n\r", ch );
        return;
      }
 
    if ( !str_cmp( arg, "clear" ) )
      {
        if ( ch->pnote != NULL )
          {
            free_string( ch->pnote->text );
            free_string( ch->pnote->subject );
            free_string( ch->pnote->to_list );
            free_string( ch->pnote->date );
            free_string( ch->pnote->sender );
            ch->pnote->next     = note_free;
            note_free           = ch->pnote;
            ch->pnote           = NULL;
          }
 
        send_to_char( "Ok.\n\r", ch );
        return;
      }
 
    if ( !str_cmp( arg, "show" ) )
      {
        if ( ch->pnote == NULL )
          {
            send_to_char( "You have no note in progress.\n\r", ch );
            return;
          }
 
        sprintf( buf, "%s: %s\n\rTo: %s\n\r",
            ch->pnote->sender,
            ch->pnote->subject,
            ch->pnote->to_list
            );
        send_to_char( buf, ch );
        send_to_char( ch->pnote->text, ch );
        return;
      }
 
    if ( !str_cmp( arg, "post" ) || !str_prefix( arg, "send" ) )
      {
        char *strtime;

        if ( !CAN_WRITE(ch, bnum) )
          {
           send_to_char( "You aren't able to write any notes here.\n\r", ch );
           return;
          }
 
        if ( ch->pnote == NULL )
          {
            send_to_char( "You have no note in progress.\n\r", ch );
            return;
          }
 
        if ( !str_cmp( ch->pnote->to_list, "" ) )
          {
            send_to_char(
              "You need to provide a recipient (name, all, or immortal).\n\r",
                         ch );
            return;
          }
 
        if ( !str_cmp( ch->pnote->subject, "" ) )
          {
            send_to_char( "You need to provide a subject.\n\r", ch );
            return;
          }
 
        ch->pnote->next                 = NULL;
        strtime                         = ctime( &current_time );
        strtime[strlen(strtime)-1]      = '\0';
        ch->pnote->date                 = str_dup( strtime );
        ch->pnote->date_stamp           = current_time;
 
        if ( note_list[bnum] == NULL )
          {
            note_list[bnum]   = ch->pnote;
          }
        else
          {
            for ( pnote = note_list[bnum]; pnote->next != NULL; pnote = pnote->next )
                ;
            pnote->next = ch->pnote;
          }
        pnote           = ch->pnote;
        ch->pnote       = NULL;
        save_board( bnum );
        send_to_char( "Ok.\n\r", ch );
        act( "$n tacks a note up on $p.", ch, obj, NULL, TO_ROOM );
        return;
      }
 
    if ( !str_cmp( arg, "remove" ) )
      {
        if ( !is_number( argument ) )
          {
            send_to_char( "Note remove which number?\n\r", ch );
            return;
          }
 
        anum = atoi( argument );
        vnum = 1;
        for ( pnote = note_list[bnum]; pnote != NULL; pnote = pnote->next )
          {
        if ( (is_note_to( ch, bnum, pnote ) || IS_IMMORTAL(ch)) && vnum++ == anum )
          {
                note_remove( ch, pnote, bnum ); 
                save_board( bnum );
act( "$n tears a note off $p and crumples it up.", ch, obj, NULL, TO_ROOM );
                send_to_char( "Note removed.\n\r", ch );
                return;
              }
      }
 
        send_to_char( "No such note.\n\r", ch );
        return;
      }
 
    send_to_char( "Huh?  Type 'help note' for usage.\n\r", ch );
    return;
  }


