/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "merc.h"

#if !defined(macintosh)
extern	int	_filbuf		args( (FILE *) );
#endif



/*
 * Globals.
 */
HELP_DATA *		help_first;
HELP_DATA *		help_last;

SHOP_DATA *		shop_first;
SHOP_DATA *		shop_last;

CHAR_DATA *		char_free;
EXTRA_DESCR_DATA *	extra_descr_free;
NOTE_DATA *		note_free;
OBJ_DATA *		obj_free;
PC_DATA *		pcdata_free = NULL;

char			bug_buf		[2*MAX_INPUT_LENGTH];
CHAR_DATA *		char_list;
char *			help_greeting;
char            log_buf     [2*MAX_INPUT_LENGTH];
KILL_DATA		kill_table	[MAX_LEVEL];
OBJ_DATA *		object_list;
TIME_INFO_DATA		time_info;
WEATHER_DATA    weather_info;

sh_int			gsn_backstab;
sh_int			gsn_dodge;
sh_int			gsn_hide;
sh_int			gsn_peek;
sh_int			gsn_pick_lock;
sh_int			gsn_sneak;
sh_int			gsn_steal;

sh_int          gsn_track;

sh_int			gsn_disarm;
sh_int			gsn_enhanced_damage;
sh_int			gsn_kick;
sh_int			gsn_parry;
sh_int			gsn_rescue;
sh_int			gsn_second_attack;
sh_int			gsn_third_attack;
sh_int          gsn_dual_wield;

sh_int			gsn_blindness;
sh_int			gsn_charm_person;
sh_int			gsn_curse;
sh_int			gsn_invis;
sh_int			gsn_mass_invis;
sh_int			gsn_poison;
sh_int			gsn_sleep;

sh_int          lang_gsn[MAX_LANG];



/*
 * Locals.
 */
MOB_INDEX_DATA *	mob_index_hash		[MAX_KEY_HASH];
OBJ_INDEX_DATA *	obj_index_hash		[MAX_KEY_HASH];
ROOM_INDEX_DATA *	room_index_hash		[MAX_KEY_HASH];
char *              string_hash     [MAX_KEY_HASH];

AREA_DATA *		area_first;
AREA_DATA *		area_last;

extern char *          string_space;
extern char *          top_string;
extern char            str_empty   [1];

int         LOG_LEVEL = LEVEL_IMMORTAL;

extern int         top_affect;
extern int         top_area;
extern int         top_ed;
extern int         top_exit;
extern int         top_help;
extern int         top_mob_index;
extern int         top_obj_index;
extern int         top_reset;
extern int         top_room;
extern int         top_shop;

extern int         top_vnum_mob;
extern int         top_vnum_obj;
extern int         top_vnum_room;



/*
 * Semi-locals.
 */
bool			fBootDb;
FILE *			fpArea;
char			strArea[MAX_INPUT_LENGTH];

/* values for db2.c */
struct		social_type	social_table		[MAX_SOCIALS];
int         social_count        = 0;


/*
 * Local booting procedures.
 */
void	init_mm		args( ( void ) );

void    load_area         args( ( FILE *fp ) );
void    load_helps        args( ( FILE *fp ) );
void    load_mobiles      args( ( FILE *fp ) );
void    load_objects      args( ( FILE *fp ) );
void    load_rooms        args( ( FILE *fp ) );
void    load_socials      args( ( FILE *fp ) );
void    load_boards       args( ( void ) );
void    load_scripts      args( ( char *fn, MOB_INDEX_DATA *pMob ) );

void    diku_load_area         args( ( FILE *fp ) );
void    diku_load_shops        args( ( FILE *fp ) );
void    diku_load_specials     args( ( FILE *fp ) );
void    diku_load_mobiles      args( ( FILE *fp ) );
void    diku_load_objects      args( ( FILE *fp ) );
void    diku_load_rooms        args( ( FILE *fp ) );
void    diku_load_resets       args( ( FILE *fp ) );

void    diku_consistency       args( ( AREA_DATA *pArea ) );

void    dump_section_0         args( ( FILE *fp ) );
void    dump_section_s         args( ( FILE *fp ) );

void    fix_exits         args( ( void ) );

void    reset_room        args( ( ROOM_INDEX_DATA *pRoom ) );
                     
void    set_mob_hp        args( ( CHAR_DATA *mob ) );
void    set_mob_xp        args( ( CHAR_DATA *mob ) );

#define         MAX_STRING      2097152
#define			MAX_PERM_BLOCK	131072
#define			MAX_MEM_LIST	11

extern void *          rgFreeList  [MAX_MEM_LIST];
extern const int       rgSizeList  [MAX_MEM_LIST];

extern int         nAllocString;
extern int         sAllocString;
extern int         nAllocPerm;
extern int         sAllocPerm;

/*
 * Set Mob's Xp's based on 1st Edition AD&D (Copyright TSR)  - from aldara -
 */
void set_mob_xp ( CHAR_DATA *mob )
{
   if( mob->level < 1 )
      mob->exp = 5 + mob->max_hit;
   else if( mob->level < 2 )
      mob->exp = 10 + mob->max_hit;
   else if( mob->level < 3 )
      mob->exp = 20 + ( 2 * mob->max_hit );   
   else if( mob->level < 4 )
      mob->exp = 35 + ( 3 * mob->max_hit );   
   else if( mob->level < 5 )
      mob->exp = 60 + ( 4 * mob->max_hit );   
   else if( mob->level < 6 )
      mob->exp = 90 + ( 5 * mob->max_hit );
   else if( mob->level < 7 )
      mob->exp = 150 + ( 6 * mob->max_hit );   
   else if( mob->level < 8 )
      mob->exp = 225 + ( 8 * mob->max_hit );
   else if( mob->level < 9 )
      mob->exp = 375 + ( 10 * mob->max_hit );
   else if( mob->level < 10 )
      mob->exp = 600 + ( 12 * mob->max_hit );
   else if( mob->level < 11 )
      mob->exp = 900 + ( 14 * mob->max_hit );
   else if( mob->level < 13 )
      mob->exp = 1300 + ( 16 * mob->max_hit );
   else if( mob->level < 15 )
      mob->exp = 1800 + ( 18 * mob->max_hit );
   else if( mob->level < 17 )
      mob->exp = 2400 + ( 20 * mob->max_hit );
   else if( mob->level < 19 )
      mob->exp = 3000 + ( 25 * mob->max_hit );
   else if( mob->level < 21 )
      mob->exp = 4000 + ( 30 * mob->max_hit );
   else if( mob->level < 26 )
      mob->exp = 6000 + ( 40 * mob->max_hit );
   else if( mob->level < 31 )
      mob->exp = 8000 + ( 50 * mob->max_hit );
   else if( mob->level < 36 )
      mob->exp = 10000 + ( 60 * mob->max_hit );
   else if( mob->level < 41 )
      mob->exp = 12000 + ( 70 * mob->max_hit );
   else if( mob->level < 46 )
      mob->exp = 15000 + ( 80 * mob->max_hit );
   else if( mob->level < 51 )
      mob->exp = 20000 + ( 90 * mob->max_hit );  
   else
      mob->exp = 25000 + ( 100 * mob->max_hit );

   if( mob->armor < 0 )
      mob->exp += 45 * mob->level;

   if( mob->spec_fun )
      if( mob->spec_fun == spec_breath_any )
         mob->exp += 40 * mob->level;
      else if( mob->spec_fun == spec_breath_acid 
       || mob->spec_fun == spec_breath_fire 
       || mob->spec_fun == spec_breath_frost 
       || mob->spec_fun == spec_breath_gas 
       || mob->spec_fun == spec_breath_lightning )
         mob->exp += 30 * mob->level;
      else if( mob->spec_fun == spec_cast_cleric
       || mob->spec_fun == spec_cast_mage
       || mob->spec_fun == spec_cast_undead )
         mob->exp += 25 * mob->level;
      else if( mob->spec_fun == spec_poison )
         mob->exp += 10 * mob->level;
         
  if (mob->exp <= 0) 
      mob->exp = 1;
}


/*
 * Set Mob's Hp's is a new system for re-empowering the mobiles.
 * Check it out. Created by Morgenes for Aldara Mud.
 * Original concept by Elohiem.
 */
void set_mob_hp( CHAR_DATA *mob )
{
   int no4, no6 = 0, no8 = 0, no10 = 0, no12 = 0, no20 = 0;
   int hps = 0, curr;

   for( no4 = mob->level; no4 > 0; no4-- )
      no6 += dice( 1, 4 );
   for(; no6 > 0; no6-- )
   {
      curr = dice( 1, 6);
      if( curr == 6 )
         no8++;
      hps += curr;  
   }
   if( no8 )
   {
      for(; no8 > 0; no8-- )
      {
         curr = dice( 1, 8 );
         if( curr == 8 ) {  
            no10++;
            hps += 2;
         }
         else if( curr == 7 ) 
            hps++;
      }
      if( no10 )
      {
         for(; no10 > 0; no10-- )
         {
            curr = dice( 1, 10 );
            if( curr == 10 ) {
               no12++;
               hps += 2;
            }
            else if( curr == 9 )
               hps++;
         }
         if( no12 )
         {
            for(; no12 > 0; no12-- )
            {
               curr = dice( 1, 12 );
               if( curr == 12 ) {
                  no20++;
                  hps += 2;
               }
               else if( curr == 11 )
                  hps++;
            }
            for(; no20 > 0; no20-- )
            {
               curr = dice( 1, 20 );
               if( curr > 12 )
                  hps += curr - 12;
            }
         }
      }
   }
   if( hps > mob->max_hit )
      mob->max_hit = hps;
   mob->level = mob->max_hit / 8 + 1;
}

/*
 * Big mama top level function.
 */
void boot_db( void )
{
    /*
     * Init some data space stuff.
     */
    {
	if ( ( string_space = calloc( 1, MAX_STRING ) ) == NULL )
	{
	    bug( "Boot_db: can't alloc %d string space.", MAX_STRING );
	    exit( 1 );
	}
	top_string	= string_space;
	fBootDb		= TRUE;
    }


    /*
     * Init random number generator.
     */
    {
	init_mm( );
    }

    /*
     * Set time and weather.
     */
    {
	long lhour, lday, lmonth;

	lhour		= (current_time - 650336715)
			/ (PULSE_TICK / PULSE_PER_SECOND);
	time_info.hour	= lhour  % 24;
	lday		= lhour  / 24;
	time_info.day	= lday   % 35;
	lmonth		= lday   / 35;
	time_info.month	= lmonth % 17;
	time_info.year	= lmonth / 17;

	     if ( time_info.hour <  5 ) weather_info.sunlight = SUN_DARK;
	else if ( time_info.hour <  6 ) weather_info.sunlight = SUN_RISE;
	else if ( time_info.hour < 19 ) weather_info.sunlight = SUN_LIGHT;
	else if ( time_info.hour < 20 ) weather_info.sunlight = SUN_SET;
	else                            weather_info.sunlight = SUN_DARK;

	weather_info.change	= 0;
    weather_info.winddir = 0;
    if ( time_info.month <= 4 || time_info.month >= 17 )
    weather_info.temperature = number_fuzzy( 20 );
    else
    weather_info.temperature = number_fuzzy( 50 );
    weather_info.windspeed = number_range( 1, 10 );
	weather_info.mmhg	= 960;
	if ( time_info.month >= 7 && time_info.month <=12 )
	    weather_info.mmhg += number_range( 1, 50 );
	else
	    weather_info.mmhg += number_range( 1, 80 );

	     if ( weather_info.mmhg <=  980 ) weather_info.sky = SKY_LIGHTNING;
	else if ( weather_info.mmhg <= 1000 ) weather_info.sky = SKY_RAINING;
	else if ( weather_info.mmhg <= 1020 ) weather_info.sky = SKY_CLOUDY;
	else                                  weather_info.sky = SKY_CLOUDLESS;

    }

    /*
     * Assign gsn's for skills which have them.
     */
    {
	int sn;

	for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
	    if ( skill_table[sn].pgsn != NULL )
		*skill_table[sn].pgsn = sn;
	}
    }

    /*
     * Read in all the area files.
     */
    {
	FILE *fpList;

	if ( ( fpList = fopen( AREA_LIST, "r" ) ) == NULL )
	{
	    perror( AREA_LIST );
	    exit( 1 );
	}


	for ( ; ; )
	{
	    strcpy( strArea, fread_word( fpList ) );
	    if ( strArea[0] == '$' )
		break;

	    if ( strArea[0] == '-' )
	    {
		fpArea = stdin;
	    }
	    else
	    {
		if ( ( fpArea = fopen( strArea, "r" ) ) == NULL )
		{
		    perror( strArea );
		    exit( 1 );
		}
	    }

	    for ( ; ; )
	    {
		char *word;

		if ( fread_letter( fpArea ) != '#' )
		{
		    bug( "Boot_db: # not found.", 0 );
		    exit( 1 );
		}

		word = fread_word( fpArea );

		     if ( word[0] == '$'               )                 break;

        else if ( !str_cmp( word, "HELPS"    ) ) load_helps     (fpArea);
        else if ( !str_cmp( word, "SOCIALS"  ) ) load_socials   (fpArea);

        else if ( !str_cmp( word, "AREADATA" ) ) load_area      (fpArea);
        else if ( !str_cmp( word, "MOBDATA"  ) ) load_mobiles   (fpArea);
        else if ( !str_cmp( word, "OBJDATA"  ) ) load_objects   (fpArea);
        else if ( !str_cmp( word, "ROOMDATA" ) ) load_rooms     (fpArea);

/* Diku support */
        else if ( !str_cmp( word, "AREA"     ) ) diku_load_area    (fpArea);
        else if ( !str_cmp( word, "MOBILES"  ) ) diku_load_mobiles (fpArea);
        else if ( !str_cmp( word, "OBJECTS"  ) ) diku_load_objects (fpArea);
        else if ( !str_cmp( word, "ROOMS"    ) ) diku_load_rooms   (fpArea);
        else if ( !str_cmp( word, "SHOPS"    ) ) diku_load_shops   (fpArea);
        else if ( !str_cmp( word, "SPECIALS" ) ) diku_load_specials(fpArea);
        else if ( !str_cmp( word, "RESETS"   ) ) diku_load_resets  (fpArea);

		else
		{
		    bug( "Boot_db: bad section name.", 0 );
		    exit( 1 );
		}
	    }

	    if ( fpArea != stdin )
		fclose( fpArea );
	    fpArea = NULL;
	}
	fclose( fpList );
    }

    /*
     * Fix up exits.
     * Declare db booting over.
     * Reset all areas once.
     * Load up the notes file.
     */
    fix_exits( );
    fBootDb = FALSE;
    load_boards( );
    return;
}


#if defined(KEY)
#undef KEY
#endif

#define KEY( literal, field, value )                \
				if ( !str_cmp( word, literal ) )	\
                {                                   \
                    field  = value;                 \
                    fMatch = TRUE;                  \
                    break;                          \
				}

#define SKEY( string, field )                       \
                if ( !str_cmp( word, string ) )     \
                {                                   \
                    free_string( field );           \
                    field = fread_string( fp );     \
                    fMatch = TRUE;                  \
                    break;                          \
				}

/*
 * Snarf an 'area' header line.   Check this format.  MUCH better.  Add fields
 * too.
 *
 * #AREAFILE
 * Name   { All } Locke    Newbie School~
 * Repop  A teacher pops in the room and says, 'Repop coming!'~
 * Recall 3001
 * End
 */
void load_area( FILE *fp )
{
    AREA_DATA *pArea;
    char      *word;
    bool      fMatch;

    pArea               = alloc_perm( sizeof(*pArea) );
    pArea->age          = 15;
    pArea->nplayer      = 0;
    pArea->filename     = str_dup( strArea );
    pArea->vnum         = top_area;
    pArea->name         = str_dup( "New Area" );
    pArea->builders     = str_dup( "" );
    pArea->repop        = str_dup( "Tock.\n\r" );
    pArea->security     = 1;
    pArea->lvnum        = 0;
    pArea->uvnum        = 0;
    pArea->area_flags   = 0;
    pArea->recall_loc   = ROOM_VNUM_TEMPLE;

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
           case 'N':
            SKEY( "Name", pArea->name );
            break;
           case 'S':
             KEY( "Security", pArea->security, fread_number( fp ) );
            break;
           case 'V':
            if ( !str_cmp( word, "VNUMs" ) )
            {
                pArea->lvnum = fread_number( fp );
                pArea->uvnum = fread_number( fp );
            }
            break;
           case 'E':
             if ( !str_cmp( word, "End" ) )
             {
                 fMatch = TRUE;
                 if ( area_first == NULL )
                    area_first = pArea;
                 if ( area_last  != NULL )
                    area_last->next = pArea;
                 area_last   = pArea;
                 pArea->next = NULL;
                 top_area++;
                 return;
            }
            break;
           case 'B':
            SKEY( "Builders", pArea->builders );
            break;
           case 'R':
             KEY( "Recall", pArea->recall_loc, fread_number( fp ) );
            SKEY( "Repop",  pArea->repop );
            if ( !str_cmp( word, "Reset" ) )
            {
                fread_to_eol( fp );
                fMatch = TRUE;
            }
            break;
       }
    }

}


/*
 * Snarf a help section.
 */
void load_helps( FILE *fp )
{
    HELP_DATA *pHelp;

    for ( ; ; )
    {
	pHelp		= alloc_perm( sizeof(*pHelp) );
	pHelp->level	= fread_number( fp );
	pHelp->keyword	= fread_string( fp );
	if ( pHelp->keyword[0] == '$' )
	    break;
	pHelp->text	= fread_string( fp );

	if ( !str_cmp( pHelp->keyword, "greeting" ) )
	    help_greeting = pHelp->text;

	if ( help_first == NULL )
	    help_first = pHelp;
	if ( help_last  != NULL )
	    help_last->next = pHelp;

	help_last	= pHelp;
	pHelp->next	= NULL;
	top_help++;
    }

    return;
}


/*
 *  snarf a socials file
 *
 *  This code was freely distributed with the Rivers of Mud source code, and
 *  has been adapted for use here on NiMUD - NiMUD would not be what it is
 *  without all the previous coders who released their source code.
 *
 *  What this does is socials are in a file instead of in interp.c
 *                       share and enjoy
 *                                                 -Locke
 */
void load_socials( FILE *fp)
{
    for ( ; ; ) 
    {
    	struct social_type social;
    	char *temp;
        /* clear social */
	social.char_no_arg = NULL;
	social.others_no_arg = NULL;
	social.char_found = NULL;
	social.others_found = NULL;
	social.vict_found = NULL; 
    social.char_not_found = NULL;
	social.char_auto = NULL;
	social.others_auto = NULL;

    	temp = fread_word(fp);
    	if (!strcmp(temp,"#0"))
	    return;  /* done */

    	strcpy(social.name,temp);
    	fread_to_eol(fp);

	temp = fread_string_eol(fp);
	if (!strcmp(temp,"$"))
	     social.char_no_arg = NULL;
	else if (!strcmp(temp,"#"))
	{
	     social_table[social_count] = social;
	     social_count++;
	     continue; 
	}
        else
	    social.char_no_arg = temp;

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.others_no_arg = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;
             social_count++;
             continue;
        }
        else
        social.others_no_arg = str_dup( temp );

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.char_found = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;
             social_count++;
             continue;
        }
       	else
        social.char_found = str_dup( temp );

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.others_found = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;
             social_count++;
             continue;
        }
        else
        social.others_found = str_dup( temp );

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.vict_found = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;
             social_count++;
             continue;
        }
        else
        social.vict_found = str_dup( temp );

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.char_not_found = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;
             social_count++;
             continue;
        }
        else
        social.char_not_found = str_dup( temp );

        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.char_auto = NULL;
        else if (!strcmp(temp,"#"))
        {
	     social_table[social_count] = social;
             social_count++;
             continue;
        }
        else
	    social.char_auto = temp;
         
        temp = fread_string_eol(fp);
        if (!strcmp(temp,"$"))
             social.others_auto = NULL;
        else if (!strcmp(temp,"#"))
        {
             social_table[social_count] = social;
             social_count++;
             continue;
        }
        else
        social.others_auto = str_dup( temp );
	
	social_table[social_count] = social;
    	social_count++;
   }
   return;
}


void fread_mobile( FILE *fp, int vnum )
{
    MOB_INDEX_DATA *pMobIndex;
    char      *word;
    bool      fMatch;
    int iHash;
    int iAttack;

    pMobIndex                   = new_mob_index( );
    pMobIndex->vnum             = vnum;
    pMobIndex->area             = area_last;

    for ( iAttack = 0;  iAttack < MAX_ATTACK_DATA;  iAttack++ )
    pMobIndex->attacks[iAttack] = NULL;

/*    bug ( "begin new mobile (%d)", vnum );      */

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
          case '*': fread_to_eol( fp ); break;
          case 'E':
            if ( !str_cmp( word, "End" ) )
            {
               iHash           = vnum % MAX_KEY_HASH;
               pMobIndex->next     = mob_index_hash[iHash];
               mob_index_hash[iHash]   = pMobIndex;
               top_mob_index++;
               kill_table[URANGE(0, pMobIndex->level, MAX_LEVEL-1)].number++;
               return;
            }
           break;
          case 'A':
            KEY( "ActBits",   pMobIndex->act,         fread_number( fp ) );
            KEY( "Affect_By", pMobIndex->affected_by, fread_number( fp ) );
            KEY( "Alignment", pMobIndex->alignment,   fread_number( fp ) );
            if ( !str_cmp( word, "Attack" ) )
            {
                int num;
                ATTACK_DATA *attack;

                fMatch = TRUE;
                num    = fread_number( fp );
                if ( num >= MAX_ATTACK_DATA )
                {
                    bug( "Invalid attack index (%d)", num );
                }
                else
                {

                if ( pMobIndex->attacks[num] == NULL )
                {
                    pMobIndex->attacks[num]  =
                     alloc_perm( sizeof(*pMobIndex->attacks[num]) );
                }
                else
                {
                    bug( "Overwrote pre-existing attack (%d).", num );
                }

                attack = pMobIndex->attacks[num];
                attack->dam1             = fread_number( fp );
                attack->dam2             = fread_number( fp );
                attack->idx              = fread_number( fp );
                pMobIndex->attacks[num]        = attack;
                }
            }
           break;
          case 'M':
            KEY( "Money",     pMobIndex->money,   fread_number( fp ) );
           break;
          case 'N':
           SKEY( "Name",      pMobIndex->name );
           break;
          case 'S':
            KEY( "Sex",       pMobIndex->sex,         fread_number( fp ) );
           SKEY( "Short",     pMobIndex->short_descr );
            if ( !str_cmp( word, "Spec" ) )
            {
                  pMobIndex->spec_name = str_dup( fread_word( fp ) );
                  pMobIndex->spec_fun  = spec_lookup( pMobIndex->spec_name );
                  fMatch = TRUE;
            }
            if ( !str_cmp( word, "Shop" ) )
            {
               SHOP_DATA *pShop;
               int iTrade;

               pShop           = alloc_perm( sizeof(*pShop) );

               pShop->keeper = vnum;

               for ( iTrade = 0; iTrade < MAX_TRADE; iTrade++ )
               pShop->buy_type[iTrade] = fread_number( fp );

               pShop->profit_buy   = fread_number( fp );
               pShop->profit_sell  = fread_number( fp );
               pShop->open_hour    = fread_number( fp );
               pShop->close_hour   = fread_number( fp );

               pMobIndex->pShop    = pShop;

               if ( shop_first == NULL )
                    shop_first = pShop;
               if ( shop_last  != NULL )
                    shop_last->next = pShop;

               shop_last   = pShop;
               pShop->next = NULL;
               top_shop++;
               fMatch = TRUE;
            }

            if ( !str_cmp( word, "ScriptFile" ) )
            {
                pMobIndex->script_fn        = str_dup( fread_word( fp ) );
                load_scripts( pMobIndex->script_fn, pMobIndex );
                fMatch = TRUE;
            }
           break;
          case 'V':
            if ( !str_cmp( word, "Var" ) )
            {
                VARIABLE_DATA *var;

                var                  = alloc_mem( sizeof(*var) );
                var->name            = str_dup( fread_word( fp ) );
                var->value           = fread_string( fp );
                var->next            = pMobIndex->variables;
                pMobIndex->variables = var;
                fMatch = TRUE;
            }
          case 'L':
           SKEY( "Long",      pMobIndex->long_descr );
            KEY( "Level",     pMobIndex->level,       fread_number( fp ) );
           break;
          case 'D':
           SKEY( "Descr",     pMobIndex->description );
           break;
       }
               if ( !fMatch )
               {
                  char buf[80];
                  sprintf( buf, "fread_mobile: %d incorrect: %s",
                                 vnum, word );
                  bug( buf, 0 );
                  fread_to_eol( fp );
               }
    };
}


/*
 * Snarf a mob section.
 */
void load_mobiles( FILE *fp )
{
    if ( area_last == NULL )
    {
    bug( "Load_mobiles: no #AREA seen yet.", 0 );
	exit( 1 );
    }

    for ( ; ; )
    {
    int vnum;
	char letter;

	letter				= fread_letter( fp );
	if ( letter != '#' )
	{
        bug( "Load_mobiles: '#' not found.", 0 );
	    exit( 1 );
	}

	vnum				= fread_number( fp );
    if ( vnum == 0 )
    {
/*        bug( "found vnum zero", 0 );       */
        break;
    }
	fBootDb = FALSE;
	if ( get_mob_index( vnum ) != NULL )
	{
	    bug( "Load_mobiles: vnum %d duplicated.", vnum );
	    exit( 1 );
	}
	fBootDb = TRUE;

    fread_mobile( fp, vnum );
    top_vnum_mob = top_vnum_mob < vnum ? vnum : top_vnum_mob;
    }
    return;
}

/*
 * Fixes the slot numbers on certain objects.
 */

void fix_object( OBJ_INDEX_DATA *pObjIndex )
{
	switch ( pObjIndex->item_type )
	{
	case ITEM_PILL:
	case ITEM_POTION:
	case ITEM_SCROLL:
    case ITEM_FOUNTAIN:
	    pObjIndex->value[1] = slot_lookup( pObjIndex->value[1] );
	    pObjIndex->value[2] = slot_lookup( pObjIndex->value[2] );
	    pObjIndex->value[3] = slot_lookup( pObjIndex->value[3] );
	    break;

	case ITEM_STAFF:
	case ITEM_WAND:
	    pObjIndex->value[3] = slot_lookup( pObjIndex->value[3] );
	    break;
	}
    return;
}


void fread_object( FILE *fp, int vnum )
{
    OBJ_INDEX_DATA *pObjIndex;
    int iHash;
    char      *word;
    bool      fMatch;

    pObjIndex                   = new_obj_index( );
    pObjIndex->vnum             = vnum;
    pObjIndex->area             = area_last;

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
          case '*': fread_to_eol( fp ); break;
          case 'E':
            KEY( "Extra", pObjIndex->extra_flags, fread_number( fp ) );
            if ( !str_cmp( word, "ExtraDescr" ) )
            {
                EXTRA_DESCR_DATA *ed;

                ed                      = alloc_perm( sizeof(*ed) );
                ed->keyword             = fread_string( fp );
                ed->description         = fread_string( fp );
                ed->next                = pObjIndex->extra_descr;
                pObjIndex->extra_descr  = ed;
                top_ed++;
                fMatch = TRUE;
            }
            if ( !str_cmp( word, "End" ) )
            {
                iHash                   = vnum % MAX_KEY_HASH;
                pObjIndex->next         = obj_index_hash[iHash];
                obj_index_hash[iHash]   = pObjIndex;
                top_obj_index++;
                fix_object( pObjIndex );
                return;
            }
           break;
          case 'A':
           SKEY( "Action", pObjIndex->action_descr );
            if ( !str_cmp( word, "Affect" ) )
            {
                AFFECT_DATA *paf;

                paf                     = alloc_perm( sizeof(*paf) );
                paf->location           = fread_number( fp );
                paf->modifier           = fread_number( fp );
                paf->type               = fread_number( fp );
                paf->duration           = fread_number( fp );
                paf->bitvector          = fread_number( fp );
                paf->next               = pObjIndex->affected;
                pObjIndex->affected     = paf;
                top_affect++;
                fMatch = TRUE;
            }
           break;
          case 'D':
           SKEY( "Descr", pObjIndex->description );
           break;
          case 'L':
            KEY( "Level", pObjIndex->level,              fread_number( fp ) );
           break;
          case 'T':
            KEY( "Timer", pObjIndex->timer,              fread_number( fp ) );
            KEY( "Type", pObjIndex->item_type,           fread_number( fp ) );
           break;
          case 'N':
            SKEY( "Name", pObjIndex->name  );
           break;
          case 'S':
           SKEY( "Short", pObjIndex->short_descr );
           break;
          case 'W':
            KEY( "Wear", pObjIndex->wear_flags,         fread_number( fp ) );
            KEY( "Weight", pObjIndex->weight,           fread_number( fp ) );
           break;
          case 'V':
            if ( !str_cmp( word, "Values" ) )
            {
               fMatch = TRUE;
               for ( iHash = 0; iHash < 10; iHash++ )
               {
                   pObjIndex->value[iHash] = fread_number( fp );
               };
            }
           break;
          case 'C':
            KEY( "Cost", pObjIndex->cost,               fread_number( fp ) );
           break;

       }
               if ( !fMatch )
               {
                  sprintf( log_buf, "fread_object: vnum %d incorrect:  '%s'",
                                    vnum, word );
                  bug( log_buf, 0 );
                  fread_to_eol( fp );
               }
    };

    return;
}

/*
 * Snarf an obj section.
 */
void load_objects( FILE *fp )
{

    if ( area_last == NULL )
    {
    bug( "Load_objects: no #AREA seen yet.", 0 );
	exit( 1 );
    }

    for ( ; ; )
    {
    int vnum;
	char letter;

	letter				= fread_letter( fp );
	if ( letter != '#' )
	{
	    bug( "Load_objects: # not found.", 0 );
	    exit( 1 );
	}

	vnum				= fread_number( fp );
	if ( vnum == 0 )
	    break;

	fBootDb = FALSE;
	if ( get_obj_index( vnum ) != NULL )
	{
	    bug( "Load_objects: vnum %d duplicated.", vnum );
	    exit( 1 );
	}
	fBootDb = TRUE;

    fread_object( fp, vnum );
    top_vnum_obj = top_vnum_obj < vnum ? vnum : top_vnum_obj;
    }

    return;
}


void fread_room( FILE *fp, int vnum )
{
    ROOM_INDEX_DATA *pRoomIndex;
    int iHash;
    int door;
    char *word;
    bool fMatch;


    pRoomIndex              = new_room_index( );
	pRoomIndex->area		= area_last;
	pRoomIndex->vnum		= vnum;

    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
          case '*': fread_to_eol( fp ); break;
          case 'E':
            if ( !str_cmp( word, "End" ) )
            {
                 iHash           = vnum % MAX_KEY_HASH;
                 pRoomIndex->next    = room_index_hash[iHash];
                 room_index_hash[iHash]  = pRoomIndex;
                 top_room++;
                 return;
            }
            if ( !str_cmp( word, "ExtraDescr" ) )
            {
                 EXTRA_DESCR_DATA *ed;

                 ed                       = alloc_perm( sizeof(*ed) );
                 ed->keyword              = fread_string( fp );
                 ed->description          = fread_string( fp );
                 ed->next                 = pRoomIndex->extra_descr;
                 pRoomIndex->extra_descr  = ed;
                 top_ed++;
                 fMatch = TRUE;
            }
           break;
          case 'R':
            if ( !str_cmp( word, "Reset" ) )
            {
                   RESET_DATA *pReset;

                   pReset      = alloc_perm( sizeof(*pReset) );
                   pReset->command = fread_letter( fp );
                   pReset->rs_vnum = fread_number( fp );
                   pReset->loc     = fread_number( fp );
                   pReset->percent = fread_number( fp );
                   fread_to_eol( fp );

                   if ( pRoomIndex->reset_first == NULL )
                        pRoomIndex->reset_first  = pReset;
                   if ( pRoomIndex->reset_last  != NULL )
                        pRoomIndex->reset_last->next = pReset;

                   pRoomIndex->reset_last   = pReset;
                   pReset->next             = NULL;
                   top_reset++;
                   fMatch = TRUE;
            }
           break;
          case 'D':
           SKEY( "Descr", pRoomIndex->description );
            if ( !str_cmp( word, "Door" ) )
            {
               EXIT_DATA *pexit;

               door                = fread_number( fp );

               if ( door < 0 || door >= MAX_DIR )
               {
                   bug( "Fread_rooms: vnum %d has bad door number.", vnum );
                   exit( 1 );
               }

               pexit           = alloc_perm( sizeof(*pexit) );

               pexit->rs_flags     = fread_number( fp );
               pexit->key          = fread_number( fp );
               pexit->vnum         = fread_number( fp );

               pexit->description  = fread_string( fp );
               pexit->keyword      = fread_string( fp );

               pRoomIndex->exit[door]  = pexit;
               top_exit++;
               fMatch = TRUE;
            }
           break;
          case 'N':
           SKEY( "Name", pRoomIndex->name );
           break;
          case 'F':
            KEY( "Flags", pRoomIndex->room_flags,   fread_number( fp ) );
           break;
          case 'S':
            KEY( "Sector", pRoomIndex->sector_type, fread_number( fp ) );
           break;
       }
               if ( !fMatch )
               {
                  char buf[80];
                  sprintf( buf, "fread_rooms: incorrect titler %s on v%d",
                                word, vnum );
                  bug( buf, 0 );
                  fread_to_eol( fp );
               }
    };

}

/*
 * Snarf a room section.
 */
void load_rooms( FILE *fp )
{

    if ( area_last == NULL )
    {
    bug( "Load_rooms: no #AREA seen yet.", 0 );
	exit( 1 );
    }

    for ( ; ; )
    {
    int vnum;
    char letter;

	letter				= fread_letter( fp );
	if ( letter != '#' )
	{
	    bug( "Load_rooms: # not found.", 0 );
	    exit( 1 );
	}

	vnum				= fread_number( fp );
	if ( vnum == 0 )
	    break;

	fBootDb = FALSE;
	if ( get_room_index( vnum ) != NULL )
	{
	    bug( "Load_rooms: vnum %d duplicated.", vnum );
	    exit( 1 );
	}
	fBootDb = TRUE;

    fread_room( fp, vnum );
    top_vnum_room = top_vnum_room < vnum ? vnum : top_vnum_room;
    }

    return;
}




TRIGGER_DATA *fread_trigger( FILE *fp )
{
    char      *word;
    bool      fMatch;
    TRIGGER_DATA *trigger;

    trigger               =  alloc_perm( sizeof(*trigger) );
    trigger->next         = NULL;
    trigger->waiting      = 0;
    trigger->current      = NULL;
    trigger->script       = NULL;
    trigger->trigger_type = 0;
    trigger->bits         = 0;
    trigger->keywords     = str_dup( "" );
    trigger->name         = str_dup( fread_word( fp ) );


    for ( ; ; )
    {
       word   = feof( fp ) ? "End" : fread_word( fp );
       fMatch = FALSE;

       switch ( UPPER(word[0]) )
       {
          case '*': fread_to_eol( fp ); fMatch = TRUE; break;
          case 'K':
            KEY( "Keywords",     trigger->keywords, fread_string( fp ) );
           break;
          case 'E':
            if ( !str_cmp( word, "End" ) )
            {
               fMatch = TRUE;
               return trigger;
            }
           break;
          case 'S':
           if ( !str_cmp( word, "Sc" ) || !str_cmp( word, "Script" ) )
           {
           SCRIPT_DATA *scr;

           if ( trigger->script != NULL )
           {
              for ( scr = trigger->script; scr->next != NULL; scr = scr->next )
              ;      /* scan to the end */
              scr->next                = alloc_perm( sizeof(*scr) );
              scr = scr->next;
           }
           else
           {
               trigger->script = alloc_perm( sizeof(*scr) );
               scr = trigger->script;
           }

           scr->command             = fread_string( fp );
           scr->next                = NULL;
           fMatch = TRUE;
           }
          break;

          case 'T':
            KEY( "Type",       trigger->trigger_type, fread_number( fp ) );
           break;
       }
               if ( !fMatch )
               {
                  char buf[80];
                  sprintf( buf, "fread_trigger: incorrect '%s'", word );
                  bug( buf, 0 );
                  fread_to_eol( fp );
               }
    };
}


void load_scripts( char *fn, MOB_INDEX_DATA *pMob )
{
    FILE *fp;
    TRIGGER_DATA *trigger;
    char *word;
    bool fMatch = TRUE;

    pMob->triggers = NULL;

    if ( ( fp = fopen( fn, "r" ) ) == NULL )
    {
        char buf[MAX_STRING_LENGTH];
        sprintf( buf, "%s script file not found!", fn );
        bug( buf, 0 );
        return;
    }

    for ( ; fMatch; )
    {
        fMatch = FALSE;
        word   = feof( fp ) ? "#END" : fread_word( fp );

        if ( word[0] == '*' )     /* In-file comments */
        {
             fread_to_eol( fp );
             fMatch = TRUE;
        }
        else
        if ( word[0] == '#' )
        {
            if ( !str_cmp( word, "#END" ) )
            {
                fMatch = TRUE;
                break;
            }
            else
            if ( !str_cmp( word, "#TRIGGER" ) )
            {
                fMatch          = TRUE;
                trigger         = fread_trigger( fp );
                trigger->next   = pMob->triggers;
                pMob->triggers  = trigger;
            }
        }
    }
 
    if ( !fMatch )
    {
        strcpy( strArea, fn );
        fpArea = fp;
        bug( "Load_scripts: bad key word.", 0 );
        exit( 1 );
    }
    return;
}


/*
 * Translate all room exits from virtual to real.
 * Has to be done after all rooms are read in.
 * Check for bad reverse exits.
 */
void fix_exits( void )
{
    extern const sh_int rev_dir [];
    char buf[MAX_STRING_LENGTH];
    ROOM_INDEX_DATA *pRoomIndex;
    ROOM_INDEX_DATA *to_room;
    EXIT_DATA *pexit;
    EXIT_DATA *pexit_rev;
    int iHash;
    int door;

    for ( iHash = 0; iHash < MAX_KEY_HASH; iHash++ )
    {
	for ( pRoomIndex  = room_index_hash[iHash];
	      pRoomIndex != NULL;
	      pRoomIndex  = pRoomIndex->next )
	{
	    bool fexit;

	    fexit = FALSE;
        for ( door = 0; door < MAX_DIR; door++ )
	    {
		if ( ( pexit = pRoomIndex->exit[door] ) != NULL )
		{
		    fexit = TRUE;
		    if ( pexit->vnum <= 0 )
			pexit->to_room = NULL;
		    else
			pexit->to_room = get_room_index( pexit->vnum );
                    pexit->exit_info = pexit->rs_flags;
		}
	    }

	    if ( !fexit )
		SET_BIT( pRoomIndex->room_flags, ROOM_NO_MOB );
	}
    }

    for ( iHash = 0; iHash < MAX_KEY_HASH; iHash++ )
    {
	for ( pRoomIndex  = room_index_hash[iHash];
	      pRoomIndex != NULL;
	      pRoomIndex  = pRoomIndex->next )
	{
        for ( door = 0; door < MAX_DIR; door++ )
	    {
		if ( ( pexit     = pRoomIndex->exit[door]       ) != NULL
		&&   ( to_room   = pexit->to_room               ) != NULL
		&&   ( pexit_rev = to_room->exit[rev_dir[door]] ) != NULL
		&&   pexit_rev->to_room != pRoomIndex )
		{
		    sprintf( buf, "Fix_exits: %d:%d -> %d:%d -> %d.",
			pRoomIndex->vnum, door,
			to_room->vnum,    rev_dir[door],
			(pexit_rev->to_room == NULL)
			    ? 0 : pexit_rev->to_room->vnum );
		    bug( buf, 0 );
		}
	    }
        reset_room( pRoomIndex );
	}
    }

    return;
}





/*
 * Create an instance of a mobile.
 */
CHAR_DATA *create_mobile( MOB_INDEX_DATA *pMobIndex )
{
    CHAR_DATA *mob;
    VARIABLE_DATA *var;

    if ( pMobIndex == NULL )
    {
	bug( "Create_mobile: NULL pMobIndex.", 0 );
	exit( 1 );
    }

    if ( char_free == NULL )
    {
	mob		= alloc_perm( sizeof(*mob) );
    }
    else
    {
	mob		= char_free;
	char_free	= char_free->next;
    }

    clear_char( mob );
    mob->pIndexData	= pMobIndex;

    mob->name           = NULL;
    mob->short_descr    = NULL;
    mob->long_descr     = NULL;
    mob->description    = NULL;

    mob->spec_name      = NULL;
    mob->spec_fun       = pMobIndex->spec_fun;
    mob->position       = POS_STANDING;

    mob->spec_tracer    = 0;

    mob->triggers       = pMobIndex->triggers;
    mob->variables      = NULL;

    for ( var = pMobIndex->variables; var != NULL; var = var->next )
          assign_variable( var->name, var->value, mob );
                     
    mob->level          = pMobIndex->level + (number_range( 0, 2 )-2);
    mob->timer          = pMobIndex->timer;
    mob->act            = pMobIndex->act;
    mob->affected_by	= pMobIndex->affected_by;
    mob->alignment      = pMobIndex->alignment;
    mob->sex            = pMobIndex->sex;
    if ( pMobIndex->money > 1 )
    create_amount( number_range( pMobIndex->money/2,
                                 pMobIndex->money-1 )+1, mob, NULL, NULL );

    mob->prompt     = str_dup( "Mob(%hh %mm): " );

    mob->armor		= interpolate( mob->level, 100, -100 );

    mob->max_hit    = number_fuzzy( (mob->level * 8) + mob->level );
                                
    if( mob->level > 3 )
       set_mob_hp( mob );
       
    mob->hit            = mob->max_hit;
    
    if ( mob->max_hit <= 0 )
    {
         mob->max_hit = 1;
         mob->hit     = 1;
    }
    
    set_mob_xp( mob );
    
    mob->level = pMobIndex->level;


    /*
     * Insert in list.
     */
    mob->next		= char_list;
    char_list		= mob;
    pMobIndex->count++;


    return mob;
}



/*
 * Create an instance of an object.
 */
OBJ_DATA *create_object( OBJ_INDEX_DATA *pObjIndex, int level )
{
    static OBJ_DATA obj_zero;
    OBJ_INDEX_DATA *pIndex;
    OBJ_DATA *obj;

    if ( pObjIndex == NULL )
    {
	bug( "Create_object: NULL pObjIndex.", 0 );
	exit( 1 );
    }

    if ( pObjIndex->item_type == ITEM_LIST && level != -1 )
    {
        char *scanarg;
        char buf[20];
        int num;
        int d;

        scanarg    = str_dup( pObjIndex->description );
        num        = number_range( 1, pObjIndex->value[0] );
        buf[0]     = '\0';

        for ( d = 0; d < num; d++ )
        {
            scanarg = one_argument( scanarg, buf );
        }

        num       = atoi( buf );
        pIndex = get_obj_index( num );
        if ( pIndex != NULL ) pObjIndex = pIndex;
    }
    else level = 0;

    if ( obj_free == NULL )
    {
	obj		= alloc_perm( sizeof(*obj) );
    }
    else
    {
	obj		= obj_free;
	obj_free	= obj_free->next;
    }

    *obj		= obj_zero;
    obj->pIndexData	= pObjIndex;
    obj->in_room	= NULL;

    if (pObjIndex->level == 0)
         obj->level      = level;
    else obj->level      = pObjIndex->level;

    obj->wear_loc       = WEAR_NONE;

    obj->name           = NULL;
    obj->short_descr    = NULL;
    obj->description    = NULL;
    obj->action_descr   = NULL;

    obj->item_type      = pObjIndex->item_type;
    obj->extra_flags	= pObjIndex->extra_flags;
    obj->wear_flags     = pObjIndex->wear_flags;
    obj->value[0]       = pObjIndex->value[0];
    obj->value[1]       = pObjIndex->value[1];
    obj->value[2]       = pObjIndex->value[2];
    obj->value[3]       = pObjIndex->value[3];
    obj->value[4]       = pObjIndex->value[4];
    obj->value[5]       = pObjIndex->value[5];
    obj->value[6]       = pObjIndex->value[6];
    obj->value[7]       = pObjIndex->value[7];
    obj->value[8]       = pObjIndex->value[8];
    obj->value[9]       = pObjIndex->value[9];
    obj->weight         = pObjIndex->weight;
    if (pObjIndex->cost == 0)
     obj->cost          = number_fuzzy( 10 )
                        * number_fuzzy( level ) * number_fuzzy( level );
    else obj->cost      = number_range( pObjIndex->cost/2, pObjIndex->cost );

    /*
     * Mess with object properties.
     */
    switch ( obj->item_type )
    {
    default:
    if ( obj->item_type >= ITEM_MAX )
        bug( "Read_object: vnum %d bad type.", pObjIndex->vnum );
	break;

    case ITEM_SCROLL:
	obj->value[0]	= number_fuzzy( obj->value[0] );
	break;

    case ITEM_WAND:
    case ITEM_STAFF:
	obj->value[0]	= number_fuzzy( obj->value[0] );
	obj->value[1]	= number_fuzzy( obj->value[1] );
	obj->value[2]	= obj->value[1];
	break;

    case ITEM_WEAPON:
    if ( obj->value[1] != 0 && obj->value[2] != 0 )
    {
         obj->value[1]   = number_fuzzy( obj->value[1] );
         obj->value[2]   = number_fuzzy( obj->value[2] );
    }
    else
    {
         obj->value[1]   = number_fuzzy( number_fuzzy( 1 * level / 4 + 2 ) );
         obj->value[2]   = number_fuzzy( number_fuzzy( 3 * level / 4 + 6 ) );
    }
    break;

    case ITEM_ARMOR:
    if ( obj->value[0] != 0 )
    {
         obj->value[0]   = number_fuzzy( obj->value[0] );
    }
    else    obj->value[0]   = number_fuzzy( level / 4 + 2 );
    if ( obj->value[1] != 0 )
    {
         obj->value[3]   = number_fuzzy( obj->value[3] );
         obj->value[2]   = obj->value[3];
    }
	break;

    case ITEM_POTION:
    case ITEM_PILL:
	obj->value[0]	= number_fuzzy( number_fuzzy( obj->value[0] ) );
	break;

    case ITEM_MONEY:
	obj->value[0]	= obj->cost;
	break;
    }

    /*
     *  Randomize color, size, and anything else we want!
     */
    obj_strings( obj );

    obj->next		= object_list;
    object_list		= obj;
    pObjIndex->count++;

    return obj;
}



/*
 * Clear a new character.
 */
void clear_char( CHAR_DATA *ch )
{
    static CHAR_DATA ch_zero;

    *ch                 = ch_zero;
    ch->name            = &str_empty[0];
    ch->short_descr     = &str_empty[0];
    ch->long_descr      = &str_empty[0];
    ch->description     = &str_empty[0];
    ch->prompt          = &str_empty[0];
    ch->hunting         = str_dup( "" );
    ch->logon           = current_time;
    ch->armor           = 100;
    ch->position        = POS_STANDING;
    ch->master          = NULL;
    ch->leader          = NULL;
    ch->fighting        = NULL;
    ch->reply           = NULL;
    ch->hunting         = &str_empty[0];
    ch->riding          = NULL;          /* careful.. */
    ch->mounted_by      = NULL;
    ch->class           = 0;       /* single class monotony */
    ch->spec_fun        = NULL;
    ch->pIndexData      = NULL;
    ch->affected        = NULL;
    ch->pnote           = NULL;
    ch->sedit           = NULL;
    ch->triggers        = NULL;
    ch->variables       = NULL;
    ch->spec_tracer     = 0;
    ch->trust           = 0;
    ch->wizinvis        = 0;
    ch->timer           = -1;
    ch->wait            = 0;
    ch->affected_by     = 0;
    ch->security        = 9;
    ch->position        = POS_RESTING;
    ch->alignment       = 0;
    ch->hitroll         = 0;
    ch->act2            = 0;
    ch->bounty          = 0;
    ch->owed            = 0;
    ch->damroll         = 0;
    ch->practice		= 21;
    ch->hit             = 20;
    ch->max_hit			= 20;
    ch->move			= 100;
    ch->max_move		= 100;
    ch->size            = ARMOR_ANY;
    ch->colors[COLOR_AUCTION]  = 13;
    ch->colors[COLOR_GOSSIP]   = 14;
    ch->colors[COLOR_SHOUT]    = 12;
    ch->colors[COLOR_SAY]      = 15;
    ch->colors[COLOR_TELL]     = 10;
    ch->colors[COLOR_UNUSED6]  = 7;
    ch->colors[COLOR_UNUSED7]  = 7;
    ch->colors[COLOR_UNUSED8]  = 7;
    ch->colors[COLOR_UNUSED9]  = 7;
    return;
}



/*
 * Free a character.
 */
void free_char( CHAR_DATA *ch )
{
    OBJ_DATA *obj;
    OBJ_DATA *obj_next;
    AFFECT_DATA *paf;
    AFFECT_DATA *paf_next;
    TRIGGER_DATA *trigger;
    TRIGGER_DATA *trigger_next;
    VARIABLE_DATA *var;
    VARIABLE_DATA *var_next;

    {
    CHAR_DATA *pet;
    
    for ( pet = char_list; pet != NULL; pet = pet->next )
      {
        if ( ( pet->master == ch || pet->leader == ch ) 
          && IS_SET(pet->act, ACT_PET) )
                       break;
      }
        if ( pet != NULL )
          extract_char( pet, TRUE );
 
  }


    for ( obj = ch->carrying; obj != NULL; obj = obj_next )
    {
	obj_next = obj->next_content;
	extract_obj( obj );
    }

    for ( trigger = ch->triggers; trigger != NULL; trigger = trigger_next )
    {
    trigger_next     = trigger->next;
    trigger->current = NULL;
    trigger->tracer  = 0;
    free_trigger( trigger );
    }

    for ( var = ch->variables; var != NULL; var = var_next )
    {
    var_next = var->next;
    free_variable( var );
    }

    for ( paf = ch->affected; paf != NULL; paf = paf_next )
    {
	paf_next = paf->next;
	affect_remove( ch, paf );
    }

    free_string( ch->name           );
    free_string( ch->short_descr	);
    free_string( ch->long_descr		);
    free_string( ch->description	);
    free_string( ch->prompt         );
    free_string( ch->hunting        );

    if ( ch->pcdata != NULL )
    {
	free_string( ch->pcdata->pwd		);
	free_string( ch->pcdata->bamfin		);
	free_string( ch->pcdata->bamfout	);
    free_string( ch->pcdata->title      );
	ch->pcdata->next = pcdata_free;
	pcdata_free      = ch->pcdata;
    }

    ch->next	     = char_free;
    char_free	     = ch;
    return;
}


/*
 * Translates mob virtual number to its mob index struct.
 * Hash table lookup.
 */
MOB_INDEX_DATA *get_mob_index( int vnum )
{
    MOB_INDEX_DATA *pMobIndex;

    if ( !fBootDb && vnum > top_vnum_mob ) return NULL;

    for ( pMobIndex  = mob_index_hash[vnum % MAX_KEY_HASH];
	  pMobIndex != NULL;
	  pMobIndex  = pMobIndex->next )
    {
	if ( pMobIndex->vnum == vnum )
	    return pMobIndex;
    }

    if ( fBootDb )
    {
	bug( "Get_mob_index: bad vnum %d.", vnum );
	exit( 1 );
    }

    return NULL;
}



/*
 * Translates mob virtual number to its obj index struct.
 * Hash table lookup.
 */
OBJ_INDEX_DATA *get_obj_index( int vnum )
{
    OBJ_INDEX_DATA *pObjIndex;

    if ( !fBootDb && vnum > top_vnum_obj ) return NULL;

    for ( pObjIndex  = obj_index_hash[vnum % MAX_KEY_HASH];
	  pObjIndex != NULL;
	  pObjIndex  = pObjIndex->next )
    {
	if ( pObjIndex->vnum == vnum )
	    return pObjIndex;
    }

    if ( fBootDb )
    {
	bug( "Get_obj_index: bad vnum %d.", vnum );
	exit( 1 );
    }

    return NULL;
}



/*
 * Translates mob virtual number to its room index struct.
 * Hash table lookup.
 */
ROOM_INDEX_DATA *get_room_index( int vnum )
{
    ROOM_INDEX_DATA *pRoomIndex;

    if ( !fBootDb && vnum > top_vnum_room ) return NULL;

    for ( pRoomIndex  = room_index_hash[vnum % MAX_KEY_HASH];
	  pRoomIndex != NULL;
	  pRoomIndex  = pRoomIndex->next )
    {
	if ( pRoomIndex->vnum == vnum )
	    return pRoomIndex;
    }

    if ( fBootDb )
    {
	bug( "Get_room_index: bad vnum %d.", vnum );
	exit( 1 );
    }

    return NULL;
}


void obj_strings( OBJ_DATA *obj )
{
   char buf[MAX_STRING_LENGTH];
   const char *str;
   const char *i;
   char *point;
   int pass;

   char c_str[WORK_STRING_LENGTH];
   char l_str[WORK_STRING_LENGTH];

   sprintf( c_str, "%s", color_list[number_range( 0, MAX_COLOR_LIST-1 )] );
   sprintf( l_str, "%s", cloth_list[number_range( 0, MAX_CLOTH_LIST-1 )] );

   for ( pass = 0; pass < 3; pass++ )
   {
   switch( pass )
   {
      default: str = STR( obj, short_descr );
               bug( "obj_strings: bad pass %d", pass );   break;
       case 0: str = STR( obj, name );               break;
       case 1: str = STR( obj, short_descr ); break;
       case 2: str = STR( obj, description ); break;
   }

   point = buf;

   while( *str != '\0' )
   {
      if( *str != '$' )
      {
         *point++ = *str++;
         continue;
      }
      ++str;
      switch( *str )
      {
         default : i = " "; break;
         case 'c': i = c_str; break;
         case 'l': i = l_str; break;
      } 
      ++str;
      while( (*point = *i) != '\0' )
         ++point, ++i;      
   }

   *point = '\0';

   switch( pass )
   {
      default: break;
       case 0: obj->name        = str_dup( buf ); break;
       case 1: obj->short_descr = str_dup( buf ); break;
       case 2: obj->description = str_dup( buf ); break;
   }
   }
   return;
}




/*
 * Reports a bug.
 */
void bug( const char *str, int param )
{
    char buf[MAX_STRING_LENGTH];
    FILE *fp;

    if ( fpArea != NULL )
    {
	int iLine;
	int iChar;

	if ( fpArea == stdin )
	{
	    iLine = 0;
	}
	else
	{
	    iChar = ftell( fpArea );
	    fseek( fpArea, 0, 0 );
	    for ( iLine = 0; ftell( fpArea ) < iChar; iLine++ )
	    {
		while ( getc( fpArea ) != '\n' )
		    ;
	    }
	    fseek( fpArea, iChar, 0 );
	}

	sprintf( buf, "[*****] FILE: %s LINE: %d", strArea, iLine );
	log_string( buf );

    sprintf( log_buf, "Notify> %s", buf );
    NOTIFY( log_buf, LEVEL_IMMORTAL, WIZ_NOTIFY_BUG );

	if ( ( fp = fopen( "shutdown.txt", "a" ) ) != NULL )
	{
	    fprintf( fp, "[*****] %s\n", buf );
	    fclose( fp );
	}
    }

    strcpy( buf, "[*****] BUG: " );
    sprintf( buf + strlen(buf), str, param );
    log_string( buf );

    if ( ( fp = fopen( BUG_FILE, "a" ) ) != NULL )
    {
	fprintf( fp, "%s\n", buf );
	fclose( fp );
    }

    return;
}



/*
 * Writes a string to the log.
 */
void log_string( const char *str )
{
    char *strtime;
    char buf[MAX_STRING_LENGTH];

    strtime                    = ctime( &current_time );
    strtime[strlen(strtime)-1] = '\0';
    fprintf( stderr, "%s :: %s\n", strtime, str );

    sprintf( buf, "Notify> LOG: %s", str );
    NOTIFY( buf, LOG_LEVEL, WIZ_NOTIFY_LOG );
    LOG_LEVEL = LEVEL_IMMORTAL;

    return;
}



/*
 * Snarf an 'area' header line.
 */
void diku_load_area( FILE *fp )
{
    AREA_DATA *pArea;

    pArea             = new_area( );
    pArea->name       = fread_string( fp );
    pArea->filename   = str_dup( strArea );
    pArea->vnum       = top_area;

    if ( area_first == NULL )    area_first = pArea;
    if ( area_last  != NULL )    area_last->next = pArea;
    area_last	= pArea;
    pArea->next	= NULL;

    top_area++;
    return;
}



/*
 * Snarf a mob section.
 */
void diku_load_mobiles( FILE *fp )
{
    MOB_INDEX_DATA *pMobIndex;

    if ( area_last == NULL )
    {
    bug( "Diku_load_mobiles: no #AREA seen yet.", 0 );
	exit( 1 );
    }
    for ( ; ; )
    {
	sh_int vnum;
	char letter;
	int iHash;

	letter				= fread_letter( fp );
	if ( letter != '#' )
	{
	    bug( "Load_mobiles: # not found.", 0 );
	    exit( 1 );
	}

	vnum				= fread_number( fp );
	if ( vnum == 0 )
	    break;

	fBootDb = FALSE;
	if ( get_mob_index( vnum ) != NULL )
	{
	    bug( "Load_mobiles: vnum %d duplicated.", vnum );
	    exit( 1 );
	}
	fBootDb = TRUE;

    pMobIndex                   = new_mob_index( );
    pMobIndex->area             = area_last;
    pMobIndex->vnum             = vnum;
    pMobIndex->name             = fread_string( fp );
	pMobIndex->short_descr		= fread_string( fp );
	pMobIndex->long_descr		= fread_string( fp );
	pMobIndex->description		= fread_string( fp );

	pMobIndex->long_descr[0]	= UPPER(pMobIndex->long_descr[0]);
	pMobIndex->description[0]	= UPPER(pMobIndex->description[0]);

	pMobIndex->act			= fread_number( fp ) | ACT_IS_NPC;
	pMobIndex->affected_by		= fread_number( fp );
	pMobIndex->pShop		= NULL;
    pMobIndex->spec_fun  = NULL;
    pMobIndex->spec_name = NULL;
    pMobIndex->script_fn = NULL;
    pMobIndex->triggers  = NULL;           /* for scripts */
    pMobIndex->timer     = 0;

    for ( iHash = 0; iHash < MAX_ATTACK_DATA; iHash++ )
    pMobIndex->attacks[iHash] = NULL;

	pMobIndex->alignment		= fread_number( fp );
	letter				= fread_letter( fp );
	pMobIndex->level		= number_fuzzy( fread_number( fp ) );

	/*
	 * The unused stuff is for imps who want to use the old-style
	 * stats-in-files method.
	 */
    fread_number( fp );
    fread_number( fp );
    fread_number( fp );
    fread_letter( fp );
    fread_number( fp );
    fread_letter( fp );
    fread_number( fp );
    fread_number( fp );
    fread_letter( fp );
    fread_number( fp );
    fread_letter( fp );
    fread_number( fp );
    pMobIndex->money        = fread_number( fp );
    fread_number( fp );
    fread_number( fp );
    fread_number( fp );

	/*
	 * Back to meaningful values.
	 */
	pMobIndex->sex			= fread_number( fp );

	if ( letter != 'S' )
	{
	    bug( "Load_mobiles: vnum %d non-S.", vnum );
	    exit( 1 );
	}

    iHash                   = vnum % MAX_KEY_HASH;
    pMobIndex->next         = mob_index_hash[iHash];
	mob_index_hash[iHash]	= pMobIndex;
	top_mob_index++;
    top_vnum_mob = top_vnum_mob < vnum ? vnum : top_vnum_mob;
	kill_table[URANGE(0, pMobIndex->level, MAX_LEVEL-1)].number++;
    }

    return;
}



/*
 * Snarf an obj section.
 */
void diku_load_objects( FILE *fp )
{
    OBJ_INDEX_DATA *pObjIndex;

    if ( area_last == NULL )
    {
    bug( "Diku_load_objects: no #AREA seen yet.", 0 );
	exit( 1 );
    }
    for ( ; ; )
    {
       	sh_int vnum;
	char letter;
	int iHash;

	letter				= fread_letter( fp );
	if ( letter != '#' )
	{
        bug( "Diku_load_objects: # not found.", 0 );
	    exit( 1 );
	}

	vnum				= fread_number( fp );
	if ( vnum == 0 )
        break;


	fBootDb = FALSE;
	if ( get_obj_index( vnum ) != NULL )
	{
        bug( "Diku_load_objects: vnum %d duplicated.", vnum );
	    exit( 1 );
	}
	fBootDb = TRUE;

    pObjIndex               = new_obj_index( );
    pObjIndex->area         = area_last;
	pObjIndex->vnum			= vnum;
    pObjIndex->name             = fread_string( fp );
	pObjIndex->short_descr		= fread_string( fp );
	pObjIndex->description		= fread_string( fp );
/*
    pObjIndex->action_descr
 */
         
	   while ( letter != '~' ) letter = fread_letter( fp );

	pObjIndex->short_descr[0]	= LOWER(pObjIndex->short_descr[0]);
	pObjIndex->description[0]	= UPPER(pObjIndex->description[0]);

    sprintf( pObjIndex->description, "%s\n\r", pObjIndex->description );

	pObjIndex->item_type		= fread_number( fp );
	pObjIndex->extra_flags		= fread_number( fp );
	pObjIndex->wear_flags		= fread_number( fp );
	pObjIndex->value[0]		= fread_number( fp );
	pObjIndex->value[1]		= fread_number( fp );
	pObjIndex->value[2]		= fread_number( fp );
	pObjIndex->value[3]		= fread_number( fp );
    pObjIndex->value[4]     = 0;
    pObjIndex->value[5]     = 0;
    pObjIndex->value[6]     = 0;
    pObjIndex->value[7]     = 0;
    pObjIndex->value[8]     = 0;
    pObjIndex->value[9]     = 0;
    pObjIndex->timer        = -1;
	pObjIndex->weight		= fread_number( fp );
	pObjIndex->cost			= fread_number( fp );	/* Unused */
	/* Cost per day */		  fread_number( fp );

	if ( pObjIndex->item_type == ITEM_POTION )
	    SET_BIT(pObjIndex->extra_flags, ITEM_NODROP);

	for ( ; ; )
	{
	    char letter;

	    letter = fread_letter( fp );

	    if ( letter == 'A' )
	    {
		AFFECT_DATA *paf;

        paf                 = alloc_perm( sizeof(*paf) );
        paf->type           = -1;
		paf->duration		= -1;
		paf->location		= fread_number( fp );
		paf->modifier		= fread_number( fp );
		paf->bitvector		= 0;
        paf->next           = pObjIndex->affected;
		pObjIndex->affected	= paf;
		top_affect++;
	    }

	    else if ( letter == 'E' )
	    {
		EXTRA_DESCR_DATA *ed;

		ed			= alloc_perm( sizeof(*ed) );
		ed->keyword		= fread_string( fp );
		ed->description		= fread_string( fp );
		ed->next		= pObjIndex->extra_descr;
		pObjIndex->extra_descr	= ed;
		top_ed++;
	    }

	    else
	    {
		ungetc( letter, fp );
		break;
	    }
	}

	/*
	 * Translate spell "slot numbers" to internal "skill numbers."
	 */
	switch ( pObjIndex->item_type )
	{
    case ITEM_FOUNTAIN:
	case ITEM_PILL:
	case ITEM_POTION:
	case ITEM_SCROLL:
	    pObjIndex->value[1] = slot_lookup( pObjIndex->value[1] );
	    pObjIndex->value[2] = slot_lookup( pObjIndex->value[2] );
	    pObjIndex->value[3] = slot_lookup( pObjIndex->value[3] );
	    break;

	case ITEM_STAFF:
	case ITEM_WAND:
	    pObjIndex->value[3] = slot_lookup( pObjIndex->value[3] );
	    break;
	}

	iHash			= vnum % MAX_KEY_HASH;
	pObjIndex->next		= obj_index_hash[iHash];
	obj_index_hash[iHash]	= pObjIndex;
	top_obj_index++;
    top_vnum_obj = top_vnum_obj < vnum ? vnum : top_vnum_obj;
    }

    return;
}




/*
 * Snarf a room section.
 */
void diku_load_rooms( FILE *fp )
{
    ROOM_INDEX_DATA *pRoomIndex;

    if ( area_last == NULL )
    {
    bug( "Diku_load_rooms: no #AREA seen yet.", 0 );
	exit( 1 );
    }

    for ( ; ; )
    {
	sh_int vnum;
	char letter;
	int door;
	int iHash;

	letter				= fread_letter( fp );
	if ( letter != '#' )
	{
        bug( "Diku_load_rooms: # not found.", 0 );
	    exit( 1 );
	}

	vnum				= fread_number( fp );
	if ( vnum == 0 )
	    break;

	fBootDb = FALSE;
	if ( get_room_index( vnum ) != NULL )
	{
        bug( "Diku_load_rooms: vnum %d duplicated.", vnum );
	    exit( 1 );
	}
	fBootDb = TRUE;

    pRoomIndex                  = new_room_index( );
    pRoomIndex->area            = area_last;
    pRoomIndex->vnum            = vnum;
    pRoomIndex->name            = fread_string( fp );
	pRoomIndex->description		= fread_string( fp );
    /* Area number */             fread_number( fp );
    pRoomIndex->room_flags      = fread_number( fp );
	pRoomIndex->sector_type		= fread_number( fp );
    pRoomIndex->light           = 0;
    for ( door = 0; door < MAX_DIR; door++ )
	    pRoomIndex->exit[door] = NULL;

	for ( ; ; )
	{
	    letter = fread_letter( fp );

	    if ( letter == 'S' )
		break;

	    if ( letter == 'D' )
	    {
		EXIT_DATA *pexit;
		int locks;

		door = fread_number( fp );
        if ( door < 0 || door > MAX_DIR )
		{
            bug( "Diku_load_rooms: vnum %d has bad door number.", vnum );
		    exit( 1 );
		}

		pexit			= alloc_perm( sizeof(*pexit) );
		pexit->description	= fread_string( fp );
		pexit->keyword		= fread_string( fp );
		pexit->exit_info	= 0;
        pexit->rs_flags     = 0;
		locks			= fread_number( fp );
		pexit->key		= fread_number( fp );
		pexit->vnum		= fread_number( fp );

		switch ( locks )
		{
        case 1: pexit->rs_flags  = EX_ISDOOR;                break;
        case 2: pexit->rs_flags  = EX_ISDOOR | EX_PICKPROOF; break;
		}

		pRoomIndex->exit[door]	= pexit;
		top_exit++;
	    }
	    else if ( letter == 'E' )
	    {
		EXTRA_DESCR_DATA *ed;

		ed			= alloc_perm( sizeof(*ed) );
		ed->keyword		= fread_string( fp );
		ed->description		= fread_string( fp );
		ed->next		= pRoomIndex->extra_descr;
		pRoomIndex->extra_descr	= ed;
		top_ed++;
	    }
	    else
	    {
        bug( "Diku_load_rooms: vnum %d has flag not 'DES'.", vnum );
		exit( 1 );
	    }
	}

	iHash			= vnum % MAX_KEY_HASH;
	pRoomIndex->next	= room_index_hash[iHash];
	room_index_hash[iHash]	= pRoomIndex;
	top_room++;
    top_vnum_room = top_vnum_room < vnum ? vnum : top_vnum_room;
    }

    return;
}



/*
 * Snarf a shop section.
 */
void diku_load_shops( FILE *fp )
{
    SHOP_DATA *pShop;

    for ( ; ; )
    {
	MOB_INDEX_DATA *pMobIndex;
	int iTrade;

    pShop               = alloc_perm( sizeof(*pShop) );
	pShop->keeper		= fread_number( fp );
	if ( pShop->keeper == 0 )
	    break;
	for ( iTrade = 0; iTrade < MAX_TRADE; iTrade++ )
	    pShop->buy_type[iTrade]	= fread_number( fp );
	pShop->profit_buy	= fread_number( fp );
	pShop->profit_sell	= fread_number( fp );
	pShop->open_hour	= fread_number( fp );
	pShop->close_hour	= fread_number( fp );
                          fread_to_eol( fp );
    pMobIndex           = get_mob_index( pShop->keeper );
	pMobIndex->pShop	= pShop;

	if ( shop_first == NULL )
	    shop_first = pShop;
	if ( shop_last  != NULL )
	    shop_last->next = pShop;

	shop_last	= pShop;
	pShop->next	= NULL;
	top_shop++;
    }

    return;
}



/*
 * Snarf spec proc declarations.
 */
void diku_load_specials( FILE *fp )
{
    for ( ; ; )
    {
	MOB_INDEX_DATA *pMobIndex;
	char letter;

	switch ( letter = fread_letter( fp ) )
	{
	default:
        bug( "Diku_load_specials: letter '%c' not *MS.", letter );
	    exit( 1 );

	case 'S':
	    return;

	case '*':
	    break;

	case 'M':
        pMobIndex           = get_mob_index ( fread_number ( fp ) );
        pMobIndex->spec_name = fread_word( fp );
        pMobIndex->spec_fun = spec_lookup ( pMobIndex->spec_name );
        if ( pMobIndex->spec_fun == NULL )
	    {
        bug( "Diku_load_specials: 'M': vnum %d.", pMobIndex->vnum );
		exit( 1 );
	    }
	    break;
	}

	fread_to_eol( fp );
    }
}


void dadd_reset( ROOM_INDEX_DATA *pR, RESET_DATA *pReset )
{
    RESET_DATA *pr;

    if ( pR == NULL )
       return;

    pr = pR->reset_last;

    if ( pr == NULL )
    {
        pR->reset_first = pReset;
        pR->reset_last  = pReset;
    }
    else
    {
        pR->reset_last->next = pReset;
        pR->reset_last       = pReset;
        pR->reset_last->next = NULL;
    }

    top_reset++;
    return;
}


void diku_load_resets( FILE *fp )
{
    RESET_DATA *pReset;
    int rvn = 0;

    if ( area_last == NULL )
    {
    bug( "Diku_load_resets: no #AREA seen yet.", 0 );
	exit( 1 );
    }

    for ( ; ; )
    {
	ROOM_INDEX_DATA *pRoomIndex;
	EXIT_DATA *pexit;
	char letter;
    int arg1, arg2, arg3;

	if ( ( letter = fread_letter( fp ) ) == 'S' )
	    break;

	if ( letter == '*' )
	{
	    fread_to_eol( fp );
	    continue;
	}

	/* if_flag */	  fread_number( fp );
            arg1    = fread_number( fp );
            arg2    = fread_number( fp );
            arg3    = (letter == 'G' || letter == 'R')
			    ? 0 : fread_number( fp );
			  fread_to_eol( fp );

    /*
     * Validate parameters.
	 * We're calling the index functions for the side effect.
	 */
	switch ( letter )
	{
	default:
        bug( "Diku_load_resets: bad command '%c'.", letter );
	    exit( 1 );
	    break;

	case 'M':
        if ( (pRoomIndex = get_room_index( arg3 )) != NULL )
        {
            pReset      = alloc_perm( sizeof(*pReset) );
            pReset->rs_vnum = arg1;
            pReset->percent = 100;
            pReset->loc     = arg2;
            pReset->command = 'M';
            dadd_reset( pRoomIndex, pReset );
            rvn = arg3;
        }
	    break;

	case 'O':
        if ( (pRoomIndex = get_room_index( arg3 )) != NULL )
        {
            pReset      = alloc_perm( sizeof(*pReset) );
            pReset->rs_vnum = arg1;
            pReset->percent = 100;
            pReset->loc     = RESET_LOC_INROOM;
            pReset->command = 'O';
            dadd_reset( pRoomIndex, pReset );
            rvn = arg3;
        }
	    break;

	case 'P':
        if ( (pRoomIndex = get_room_index( arg3 )) != NULL )
        {
            pReset      = alloc_perm( sizeof(*pReset) );
            pReset->rs_vnum = arg1;
            pReset->percent = 100;
            pReset->loc     = RESET_LOC_INOBJ;
            pReset->command = 'O';
            dadd_reset( pRoomIndex, pReset );
        }
	    break;

	case 'G':
	case 'E':
        if ( (pRoomIndex = get_room_index( rvn )) != NULL )
        {
            pReset      = alloc_perm( sizeof(*pReset) );
            pReset->rs_vnum = arg1;
            pReset->percent = 100;
            pReset->loc     = letter == 'G' ? 0 : arg3;
            pReset->command = 'O';
            dadd_reset( pRoomIndex, pReset );
        }
	    break;

	case 'D':
        pRoomIndex = get_room_index( arg1 );

        if ( (arg2 < 0)
        ||   (arg2 > MAX_DIR)
        || (pRoomIndex == NULL)
        || ( pexit = pRoomIndex->exit[arg2] ) == NULL
        || !IS_SET( pexit->rs_flags, EX_ISDOOR ) )
        {
        bug( "Diku_Load_resets: 'D': exit %d illegal.", arg2 );
        exit( 1 );
        }

        switch ( arg3 )
        {
         default: bug( "Diku_load_resets: 'D': invalid door reset switch" , 0);
            case 0: break;
            case 1: SET_BIT( pexit->rs_flags, EX_LOCKED );           break;
            case 2: SET_BIT( pexit->rs_flags, EX_PICKPROOF );        break;
              break;
        }

	    break;

	case 'R':
        fread_to_eol( fp );
	    break;
	}

    }

    return;
}



/*
 * Dump (ignore) a section that ends in #0
 */
void dump_section_0( FILE *fp )
{
    for ( ; ; )
    {
	char letter;
    int num;

    if ( ( letter = fread_letter( fp ) ) == '#' )
     if ( ( num = fread_number( fp ) ) == 0 )
        break;

    fread_to_eol( fp );
    top_reset++;
    continue;
    }

    return;
}

/*
 * Dump (ignore) a section that ends in 'S'
 */
void dump_section_s( FILE *fp )
{
    for ( ; ; )
    {
	char letter;

	if ( ( letter = fread_letter( fp ) ) == 'S' )
	    break;

    fread_to_eol( fp );
    top_reset++;
    continue;
    }

    return;
}


/*
 * This function is here to aid in debugging.
 * If the last expression in a function is another function call,
 *   gcc likes to generate a JMP instead of a CALL.
 * This is called "tail chaining."
 * It hoses the debugger call stack for that call.
 * So I make this the last call in certain critical functions,
 *   where I really need the call stack to be right for debugging!
 *
 * If you don't understand this, then LEAVE IT ALONE.
 * Don't remove any calls to tail_chain anywhere.
 *
 * -- Furey
 */
void tail_chain( void )
{
    return;
}



