/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <time.h>
#include "merc.h"

/*               DUMs (3)
Name             Address                 Numeric Address  Port  Status Notes
----------------------------------------------------------------------------
CanDUM II        cheetah.vlsi.uwaterloo.ca                2001  up 
                 cheetah.vlsi-cheetahnet.uwaterloo.ca 
                                         129.97.180.1 
                                         129.97.94.45 
DUM II           elektra.ling.umu.se     130.239.24.66    2001  up 
FranDUM          mousson.enst.fr         137.194.160.48   2001  up 
----------------------------------------------------------------------------
*/



/*
 * Lovely experience table.   Tweak this after gameplay.
 * Use IP() <true interpolation> to find values needed.
 */

 
const  int  exptable[MAX_LEVEL+1] =
{
            0,    /* Level 0 */
            0,
          100,  
          250,
          500,   
         1000,    /* 5  */
 
         2000,
         4000,
         8000,
        10000,
        15000,    /* 10 */
 
        20000,
        40000,
        60000,
       100000,
       200000,    /* 15 */
 
       500000,
       800000,
      1000000,
      1500000,
      2000000,
 
      3000000,
      5000000,
     10000000,
     15000000,
     20000000,    /* 25 */
 
     25000000,
     30000000,
     50000000,
    100000000,
    100000000,    /* Hero */
 
    100000000,
           32,
           33,
           34,
           35,    /* 35 */
 
           36,
           37,
           38,
           39,
           40     /* 40 */
};



char *   const  percent_hit [] =
{
    "massacred",
    "slaughtered",
    "bloodied",
    "beaten",
    "wounded",
    "hurt",
    "bruised",
    "scratched",
    "fine",
    "fine",
    "excellent"
};

char *   const  percent_tired [] =
{
    "exhausted",
    "beat",
    "tired",
    "weary",
    "haggard",
    "fatigued",
    "worked",
    "winded",
    "rested",
    "fresh",
    "fresh"
};


char *   const  color_list [MAX_COLOR_LIST] =
{
    "red",
    "blue",
    "black",
    "turquoise",
    "yellow",
    "faded indigo",
    "purple",
    "magenta",
    "lavender",
    "green",
    "white",
    "faded orange",
    "violet",
    "maroon",
    "mauve",
    "brown",          /* 16 */
    "tan",
    "grey"
};

char *   const  cloth_list [MAX_CLOTH_LIST] =
{
    "satin",
    "linen",
    "silk",
    "cloth",
    "wool",
    "cotton",
    "reed"            /* 7 */
};

/*
 * Coin information
 */
const struct coin_type coin_table[MAX_COIN] =
{
   {  10,   10000,   3, "obsidian",   "op"  },
   {  10,    1000,   2, "platinum",   "pp"  },
   {  10,     100,   1, "gold",       "gp"  },
   {  10,      10,   1, "silver",     "sp"  },
   {  10,       1,   1, "copper",     "cp"  }
};


char *   const  lang_name[MAX_LANG] =
{
    "common",
    "elven",
    "dwarven",
    "gnome",
    "kender",
    "shadaokin",
    "dragon",
    "skulk",
    "beastman"
};

/*
 * bust a race.
 */
const struct   race_type  race_table [MAX_RACE] =
{
  { "Human",
    {  0,  0,  0,  0,  0 },                                 /* S I W D C */
    3001,                                                   /* Room      */
    50,                                                     /* Max Skill */
    0,                                                      /* Exp Mod   */
    0,                                                      /* Bits      */
    ARMOR_AVERAGE,                                          /* Size      */
    { 100,  0,  0,  0,  0,  0,  0,  0,  0  }                /* Languages */
  },
  { "Half-Elf",
    { -1,  1,  0,  1, -1 },
    3700,
    50,
    4,
    0,
    ARMOR_AVERAGE,
    { 100, 50,  0,  0,  0,  0,  0,  0,  0  }
  },
  { "Elf",
    { -1,  2,  1,  1, -2 },
    3700,
    60,
    3,
    0,
    ARMOR_PETITE,
    { 100,100,  0,  0,  0,  0,  0,  0,  0  }
  },
  { "Wild-Elf",
    { -1,  0, -1,  1,  1 },
    3700,
    65,
    2,
    AFF_DETECT_HIDDEN,
    ARMOR_PETITE,
    { 100,100,  0,  0,  0,  0,  0,  0, 20  }
  },
  { "High-Elf",
    {  1,  1,  0,  1, -1 },
    3700,
    55,
    4,
    0,
    ARMOR_PETITE,
    { 100,100,  0,  0,  0,  0,  0,  0,  0  }
  },
  { "Shadowelf",
    { -1,  0,  0,  2, -1 },
    3700,
    50,
    4,
    0,
    ARMOR_SMALL,
    { 100,100,  0,  0,  0,  0,  0, 10,  0  }
  },
  { "Drow",
    {  1,  1,  1, -1, -2 },
    3700,
    70,
    2,
    AFF_INFRARED,
    ARMOR_PETITE,
    { 100,100,  0,  0,  0,  0,  0,  0,  0  }
  },
  { "Dwarf",
    {  3, -3, -2, -1,  3 },
    6501,
    40,
    2,
    AFF_INFRARED,
    ARMOR_SMALL,
    { 100,  0,100,  0,  0,  0,  0,  0,  0  }
  },
  { "Hilldwarf",
    {  2,  0,  0, -2,  2 },
    6501,
    30,
    4,
    0,
    ARMOR_SMALL,
    { 100,  0,100, 20,  0,  0,  0,  0,  0  }
  },
  { "Gnome",
    {  3,  0, -3,  0,  3 },
    3700,
    35,
    4,
    0,
    ARMOR_SMALL,
    { 100,  0,  0,100,  0,  0,  0,  0,  0  }
  },
  { "Tinkergnome",
    {  0,  1,  0,  0,  2 },
    3700,
    30,
    0,
    0,
    ARMOR_SMALL,
    { 100,  0,  0,100,  0,  0,  0,  0,  0  }
  },
  { "Giant",
    {  5,  0, -5,  0,  3 },
    3700,
    25,
    2,
    0,
    ARMOR_HUGE,
    { 100,  0,  0,  0,  0,  0,  0,  0,  0  }
  },
  { "Kender",
    {  2, -1, -1,  0,  3 },
    3700,
    35,
    0,
    0,
    ARMOR_SMALL,
    { 100,  0,  0,100,  0,  0,  0,  0, 20  }
  },
  { "ShadaoSlav",
    {  0,  5,  5, -3, -2 },
    3700,  
    75,    
    1,  
    AFF_INFRARED,
    ARMOR_LARGE,
    { 100,  0,  0,  0,  0,100,  0,  0,  0  }
  },
  { "Dragonkin",   
    {  2,  2,  2, -5,  1 },   
    3700,  
    10,    
    3,  
    AFF_DETECT_INVIS,
    ARMOR_LARGE,
    { 100,  0,  0,  0,  0,  0,100,  0,  0  }
  },
  { "Buckawn",     
    { -4,  0,  1,  2, -2 },   
    3700,  
    50,    
    4,  
    AFF_FREEACTION,
    ARMOR_SMALL,
    { 100, 20, 20,100,  0,  0,  0,  0,  0  }
  },
  { "Skulk",       
    {  0,  1,  0,  2, -3 },   
    3700,  
    35,    
    4,  
    0,
    ARMOR_AVERAGE,
    { 100,  0,  0,  0,  0,  0,  0,100,  0  }
  },
  { "Beastman",    
    {  1,  1, -3,  1,  0 },   
    3700, 
    40,    
    0,
    0,
    ARMOR_AVERAGE,
    { 100,  0,  0,  0,  0,  0,  0,  0,100  }
  }
};


/*
 * Class table.
 */
const   struct  class_type  class_table [MAX_CLASS] =
{
  {
     "",  APPLY_NONE,  0, 90,   /* name, prime req, room, max percent */
     18, 6,  5, 15              /* thac0 1st, thac0 32nd, minhits, maxhits */
  }

};

/*
 * A single set of colors for use with the COLOR command. :)
 */

const   struct  color_data color_table[] =
{
   { "\x1b[30m",     "$R$0",   "black",         0 },
   { "\x1b[34m",     "$R$1",   "blue",          1 },
   { "\x1b[32m",     "$R$2",   "green",         2 },
   { "\x1b[36m",     "$R$3",   "cyan",          3 },
   { "\x1b[31m",     "$R$4",   "red",           4 },
   { "\x1b[35m",     "$R$5",   "purple",        5 },
   { "\x1b[33m",     "$R$6",   "brown",         6 },
   { "\x1b[37m",     "$R$7",   "grey",          7 },
   { "\x1b[30;1m",   "$B$0",   "dark_grey",     8 },
   { "\x1b[34;1m",   "$B$1",   "light_blue",    9 },
   { "\x1b[32;1m",   "$B$2",   "light_green",  10 },
   { "\x1b[36;1m",   "$B$3",   "light_cyan",   11 },
   { "\x1b[31;1m",   "$B$4",   "light_red",    12 },
   { "\x1b[35;1m",   "$B$5",   "magenta",      13 },
   { "\x1b[33;1m",   "$B$6",   "yellow",       14 },
   { "\x1b[37;1m",   "$B$7",   "white",        15 },
   { "\x1b[1m",      "$B",     "bold",         16 },
   { "\x1b[5m",      "$F",     "flashing",     17 },
   { "\x1b[7m",      "$I",     "inverse",      18 },
   { "\x1b[0m",      "$R",     "normal",       19 }
};


/*
 *  Attack damage type and string.
 */
const   struct  attack_type attack_table [] =         /* CHANGE MAX_ATTACK */
{
    {   "hit",          TYPE_HIT,       NULL                   },  /*  0   */
    {   "slice",        TYPE_SLASH,     NULL                   },  /*  1   */
    {   "stab",         TYPE_PIERCE,    NULL                   },
    {   "slash",        TYPE_SLASH,     NULL                   },
    {   "whip",         TYPE_WHIP,      NULL                   },
    {   "claw",         TYPE_SLASH,     NULL                   },  /*  5   */
    {   "blast",        TYPE_EXPLODE,   NULL                   },
    {   "pound",        TYPE_POUND,     NULL                   },
    {   "crush",        TYPE_POUND,     NULL                   },
    {   "gore",         TYPE_PIERCE,    NULL                   },
    {   "bite",         TYPE_PIERCE,    NULL                   },  /*  10  */
    {   "pierce",       TYPE_PIERCE,    NULL                   },
    {   "suction",      TYPE_SUCTION,   hit_suck_disarm        },
    {   "vorpal",       TYPE_SLASH,     hit_vorpal             },
    {   "cleave",       TYPE_SLASH,     NULL                   },
    {   "wail",         TYPE_HIT,       NULL                   }   /*  15  */
};



/*
 * Attribute bonus tables.
 */
const   struct  str_app_type    str_app     [26]        =
{
    { -5, -4,   0,  0 },  /* 0  */
    { -5, -4,   3,  1 },  /* 1  */
    { -3, -2,   3,  2 },
    { -3, -1,  10,  3 },  /* 3  */
    { -2, -1,  25,  4 },
    { -2, -1,  55,  5 },  /* 5  */
    { -1,  0,  80,  6 },
    { -1,  0,  90,  7 },
    {  0,  0, 100,  8 },
    {  0,  0, 100,  9 },
    {  0,  0, 115, 10 }, /* 10  */
    {  0,  0, 115, 11 },
    {  0,  0, 140, 12 },
    {  0,  0, 140, 13 }, /* 13  */
    {  0,  1, 170, 14 },
    {  1,  1, 170, 15 }, /* 15  */
    {  1,  2, 195, 16 },
    {  2,  3, 220, 22 },
    {  2,  4, 250, 25 }, /* 18  */
    {  3,  5, 400, 30 },
    {  3,  6, 500, 35 }, /* 20  */
    {  4,  7, 600, 40 },
    {  5,  7, 700, 45 },
    {  6,  8, 800, 50 },
    {  8, 10, 900, 55 },
    { 10, 12, 999, 60 }  /* 25   */
};



const   struct  int_app_type    int_app     [26]        =
{
    {  3 },	/*  0 */
    {  5 },	/*  1 */
    {  7 },
    {  8 },	/*  3 */
    {  9 },
    { 10 },	/*  5 */
    { 11 },
    { 12 },
    { 13 },
    { 15 },
    { 17 },	/* 10 */
    { 19 },
    { 22 },
    { 25 },
    { 28 },
    { 31 },	/* 15 */
    { 34 },
    { 37 },
    { 40 },	/* 18 */
    { 44 },
    { 49 },	/* 20 */
    { 55 },
    { 60 },
    { 70 },
    { 85 },
    { 99 }	/* 25 */
};



const   struct  wis_app_type    wis_app     [26]        =
{
    { 1 },      /*  0 */
    { 1 },      /*  1 */
    { 1 },
    { 1 },      /*  3 */
    { 1 },
    { 1 },	/*  5 */
    { 1 },
    { 1 },
    { 1 },
    { 2 },
    { 2 },	/* 10 */
    { 2 },
    { 2 },
    { 2 },
    { 2 },
    { 3 },	/* 15 */
    { 3 },
    { 4 },
    { 5 },	/* 18 */
    { 5 },
    { 5 },	/* 20 */
    { 6 },
    { 6 },
    { 6 },
    { 6 },
    { 7 }	/* 25 */
};



const   struct  dex_app_type    dex_app     [26]        =
{
    {   60 },   /* 0 */
    {   50 },   /* 1 */
    {   50 },
    {   40 },
    {   30 },
    {   20 },   /* 5 */
    {   10 },
    {    0 },
    {    0 },
    {    0 },
    {    0 },   /* 10 */
    {    0 },
    {    0 },
    {    0 },
    {    0 },
    { - 10 },   /* 15 */
    { - 15 },
    { - 20 },
    { - 30 },
    { - 40 },
    { - 50 },   /* 20 */
    { - 60 },
    { - 75 },
    { - 90 },
    { -105 },
    { -120 }    /* 25 */
};



const   struct  con_app_type    con_app     [26]        =
{
    { -4, 20 },   /*  0 */
    { -3, 25 },   /*  1 */
    { -2, 30 },
    { -2, 35 },	  /*  3 */
    { -1, 40 },
    { -1, 45 },   /*  5 */
    { -1, 50 },
    {  0, 55 },
    {  0, 60 },
    {  0, 65 },
    {  0, 70 },   /* 10 */
    {  0, 75 },
    {  0, 80 },
    {  0, 85 },
    {  0, 88 },
    {  1, 90 },   /* 15 */
    {  2, 95 },
    {  2, 97 },
    {  3, 99 },   /* 18 */
    {  3, 99 },
    {  4, 99 },   /* 20 */
    {  4, 99 },
    {  5, 99 },
    {  6, 99 },
    {  7, 99 },
    {  8, 99 }    /* 25 */
};



/*
 * Liquid properties.
 * Used in world.obj.
 */
const	struct	liq_type	liq_table	[LIQ_MAX]	=
{
    { "water",			"clear",	{  0, 1, 10 }	},  /*  0 */
    { "beer",           "amber",    {  1, 2,  5 }   },
    { "wine",           "rose",     {  2, 2,  5 }   },
    { "ale",			"brown",	{  2, 2,  5 }	},
    { "brandy",         "dark",     {  5, 2,  5 }   },

    { "whisky",         "golden",   {  6, 1,  4 }   },  /*  5 */
    { "whapple juice",  "golden",   { 10, 0,  0 }   },
    { "vodka",          "clear",    {  3, 3,  3 }   },
    { "salt water",     "clear",    {  0, 1, -2 }   },

    { "milk",           "white",    {  0, 3,  6 }   },  
    { "coffee",         "black",    { -1, 1,  6 }   },  /* 10 */
    { "tea",			"tan",		{  0, 1,  6 }	},

    { "blood",			"red",		{  0, 2, -1 }	},
    { "unblood",        "green",    {  0, 2, -2 }   },

    { "lemonade",       "pink",     {  0, 1,  8 }   },
    { "cola",			"cherry",	{  0, 1,  5 }	}   /* 15 */
};


/*
 * The skill and spell table.
 * Slot numbers must never be changed as they appear in #OBJECTS sections.
 */
#define SLOT(n)	n
#define WAIT(n) n
#define MANA(n) n
#define PRAC(n) n

const   struct  skill_type  skill_table [MAX_SKILL] =
{

/*
 * Magic spells.
 */

    {
    "reserved",     { 99 },
    0, 0,        TAR_IGNORE,     POS_STANDING,
    NULL,           SLOT( 0),    0,  0,  0,  0,
	"",			""
    },

    {
    "acid blast",       { 20 },
    NULL, spell_acid_blast,   TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(70),   MANA(20), MANA_WATER, PRAC(20),
    WAIT(12),     "acid blast",       "!Acid Blast!"
    },

    {
    "armor",        {  5 },
    NULL, spell_armor,     TAR_CHAR_DEFENSIVE, POS_STANDING,
    NULL,           SLOT( 1),    MANA(5), MANA_EARTH, PRAC(20),
    WAIT(12),    "",         "You feel less protected."
    },

    {
    "bless",        { LEVEL_IMMORTAL },
    NULL, spell_bless,        TAR_CHAR_DEFENSIVE, POS_STANDING,
    NULL,           SLOT( 3),    MANA(5), MANA_AIR,   PRAC(20),
    WAIT(12),    "",         "You feel less righteous."
    },

    {
    "blindness",        {  8 },
    NULL, spell_blindness,    TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    &gsn_blindness,     SLOT( 4),    MANA(5), MANA_FIRE, PRAC(20),
    WAIT(12),    "",         "You can see again."
    },

    {
    "burning hands",    {  5 },
    NULL, spell_burning_hands,    TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT( 5),   MANA(15), MANA_FIRE, PRAC(20),
    WAIT(12),    "burning hands",    "!Burning Hands!"
    },

    {
    "call lightning",   { 20 },
    NULL, spell_call_lightning,   TAR_IGNORE,     POS_FIGHTING,
    NULL,           SLOT( 6),   MANA(15), MANA_AIR,  PRAC(20),
    WAIT(12),    "lightning bolt",   "!Call Lightning!"
    },

    {
    "hands of wind",   { 26 },
    NULL, spell_cause_critical,   TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(63),   MANA(20), MANA_AIR,  PRAC(20),
    WAIT(12),    "wind",        "!Hands of Wind!"
    },

    {
    "fists of fire",      { 5 },
    NULL, spell_cause_light,  TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(62),   MANA(15), MANA_FIRE, PRAC(20),
    WAIT(12),    "fiery hits",        "!Fists of Fire!"
    },

    {
    "ice shards",    { 10 },
    NULL, spell_cause_serious,    TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(64),   MANA(17),  MANA_WATER, PRAC(20),
    WAIT(12),    "shards of ice",        "!Ice Shard!"
    },

    {
    "charm person",     { 20 },
    NULL, spell_charm_person, TAR_CHAR_OFFENSIVE, POS_STANDING,
    &gsn_charm_person,  SLOT( 7),    MANA(5), MANA_ANY, PRAC(20),
    WAIT(12),    "",         "You feel more self-confident."
    },

    {
    "channeling",       { 10 },
    NULL, spell_channeling,  TAR_OBJ_INV,  POS_STANDING,
    NULL,            SLOT(301), MANA(25), MANA_ANY, PRAC(20),
    WAIT(12),        "",    "!Channeling!"
    },

    {
    "chill touch",      {  3 },
    NULL, spell_chill_touch,  TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT( 8),   MANA(15), MANA_WATER, PRAC(20),
    WAIT(12),    "chilling touch",   "You feel less cold."
    },

    {
    "fire fingers",     { 16 },
    NULL, spell_colour_spray, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(10),   MANA(15),  MANA_FIRE, PRAC(20),
    WAIT(12),     "fire fingers",     "!Fire Fingers!"
    },

    {
    "light",  {  4 },
    NULL, spell_continual_light,  TAR_IGNORE,     POS_STANDING,
    NULL,           SLOT(57),    MANA(7), MANA_FIRE,  PRAC(20),
    WAIT(12),    "",         "!Continual Light!"
    },

    {
    "control weather",  { 12 },
    NULL, spell_control_weather,  TAR_IGNORE,     POS_STANDING,
    NULL,           SLOT(11),   MANA(25), MANA_AIR, PRAC(20),
    WAIT(12),    "",         "!Control Weather!"
    },

    {
    "create food",      { 12 },
    NULL, spell_create_food,  TAR_IGNORE,     POS_STANDING,
    NULL,           SLOT(12),    MANA(5), MANA_EARTH, PRAC(20),
    WAIT(12),    "",         "!Create Food!"
    },

    {
    "create spring",    { 13 },
    NULL, spell_create_spring,    TAR_IGNORE,     POS_STANDING,
    NULL,           SLOT(80),   MANA(20), MANA_WATER, PRAC(20),
    WAIT(12),    "",         "!Create Spring!"
    },

    {
    "create water",     { 11 },
    NULL, spell_create_water, TAR_OBJ_INV,        POS_STANDING,
    NULL,           SLOT(13),    MANA(5), MANA_WATER, PRAC(20),
    WAIT(12),    "",         "!Create Water!"
    },

    {
    "cure blindness",   { 8 },
    NULL, spell_cure_blindness,   TAR_CHAR_DEFENSIVE, POS_FIGHTING,
    NULL,           SLOT(14),    MANA(5), MANA_WATER, PRAC(20),
    WAIT(12),
	"",			"!Cure Blindness!"
    },

    {
    "heal critical",    { 16 },
    NULL, spell_cure_critical,    TAR_CHAR_DEFENSIVE, POS_FIGHTING,
    NULL,           SLOT(15),   MANA(20), MANA_EARTH, PRAC(20),
    WAIT(12),    "",         "!Cure Critical!"
    },

    {
    "heal light",       { 10 },
    NULL, spell_cure_light,   TAR_CHAR_DEFENSIVE, POS_FIGHTING,
    NULL,           SLOT(16),   MANA(10), MANA_EARTH, PRAC(20),
    WAIT(12),    "",         "!Cure Light!"
    },

    {
    "cure poison",      { 14 },
    NULL, spell_cure_poison,  TAR_CHAR_DEFENSIVE, POS_STANDING,
    NULL,           SLOT(43),    MANA(5), MANA_WATER, PRAC(20),
    WAIT(12),    "",         "!Cure Poison!"
    },

    {
    "heal serious",     { 12 },
    NULL, spell_cure_serious, TAR_CHAR_DEFENSIVE, POS_FIGHTING,
    NULL,           SLOT(61),   MANA(15), MANA_EARTH, PRAC(20),
    WAIT(12),    "",         "!Cure Serious!"
    },

    {
    "curse",        { 12 },
    NULL, spell_curse,        TAR_CHAR_OFFENSIVE, POS_STANDING,
    &gsn_curse,     SLOT(17),   MANA(20), MANA_AIR,   PRAC(20),
    WAIT(12),    "curse",        "The curse wears off."
    },

    {
    "detect evil",      { 6 },
    NULL, spell_detect_evil,  TAR_CHAR_SELF,      POS_STANDING,
    NULL,           SLOT(18),    MANA(5), MANA_FIRE,  PRAC(20),
    WAIT(12),    "",         "The red in your vision disappears."
    },

    {
    "detect hidden",    { 15 },
    NULL, spell_detect_hidden,    TAR_CHAR_SELF,      POS_STANDING,
    NULL,           SLOT(44),    MANA(5), MANA_FIRE,  PRAC(20),
    WAIT(12),    "",         "You feel less aware of your suroundings."
    },

    {
    "detect invisible",     {  5 },
    NULL, spell_detect_invis, TAR_CHAR_SELF,      POS_STANDING,
    NULL,           SLOT(19),    MANA(5), MANA_FIRE,  PRAC(20),
    WAIT(12),    "",         "You no longer see invisible objects."
    },

    {
    "detect magic",     {  2 },
    NULL, spell_detect_magic, TAR_CHAR_SELF,      POS_STANDING,
    NULL,           SLOT(20),    MANA(5), MANA_FIRE,  PRAC(20),
    WAIT(12),    "",         "The detect magic wears off."
    },

    {
    "detect poison",    { 1 },
    NULL, spell_detect_poison,    TAR_OBJ_INV,        POS_STANDING,
    NULL,           SLOT(21),    MANA(5), MANA_FIRE,  PRAC(20),
    WAIT(12),    "",         "!Detect Poison!"
    },

    {
    "dispel evil",      { 1 },
    NULL, spell_dispel_evil,  TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(22),   MANA(15), MANA_WATER, PRAC(20),
    WAIT(12),    "dispel evil",      "!Dispel Evil!"
    },

    {
    "dispel magic",     { 11 },
    NULL, spell_dispel_magic, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(59),   MANA(15), MANA_EARTH, PRAC(20),
    WAIT(12),    "",         "!Dispel Magic!"
    },

    {
    "earthquake",       { 17 },
    NULL, spell_earthquake,   TAR_IGNORE,     POS_FIGHTING,
    NULL,           SLOT(23),   MANA(15), MANA_EARTH, PRAC(20),
    WAIT(12),    "earthquake",       "!Earthquake!"
    },

    {
    "enchant weapon",   { 18 },
    NULL, spell_enchant_weapon,   TAR_OBJ_INV,        POS_STANDING,
    NULL,           SLOT(24),   MANA(100),    MANA_FIRE, PRAC(20),
    WAIT(24),    "",         "!Enchant Weapon!"
    },

    {
    "energy drain",     { 16 },
    NULL, spell_energy_drain, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(25),   MANA(35),  MANA_FIRE, PRAC(20),
    WAIT(12),    "energy drain",     "!Energy Drain!"
    },

    {
    "outline",      {  2 },
    NULL, spell_faerie_fire,  TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(72),    MANA(5), MANA_FIRE,  PRAC(20),
    WAIT(12),    "outline",      "The pink aura around you fades away."
    },

    {
    "rising mist",       { 4 },
    NULL, spell_faerie_fog,   TAR_IGNORE,     POS_STANDING,
    NULL,           SLOT(73),   MANA(12), MANA_AIR, PRAC(20),
    WAIT(12),    "rising mist",       "!Rising Mist!"
    },

    {
    "fireball",     { 15 },
    NULL, spell_fireball,     TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(26),   MANA(15), MANA_FIRE, PRAC(20),
    WAIT(12),    "fireball",     "!Fireball!"
    },

    {
    "flamestrike",      { 23 },
    NULL, spell_flamestrike,  TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(65),   MANA(20), MANA_FIRE, PRAC(20),
    WAIT(12),    "flamestrike",      "!Flamestrike!"
    },

    {
    "fly",          {  8 },
    NULL, spell_fly,      TAR_CHAR_DEFENSIVE, POS_STANDING,
    NULL,           SLOT(56),   MANA(10), MANA_AIR,  PRAC(20),
    WAIT(18),    "",         "You slowly float to the ground."
    },

    {
    "conjure undead",         { 20 },
    NULL, spell_gate,     TAR_CHAR_DEFENSIVE, POS_FIGHTING,
    NULL,           SLOT(83),   MANA(50), MANA_EARTH, PRAC(20),
    WAIT(12),    "",         "!Gate!"
    },

    {
    "earthen strength",   {  10 },
    NULL, spell_giant_strength,   TAR_CHAR_DEFENSIVE, POS_STANDING,
    NULL,           SLOT(39),   MANA(20), MANA_EARTH, PRAC(20),
    WAIT(12),    "",         "You feel the strength pour out of you."
    },

    {
    "magic boulders",         { 14 },
    NULL, spell_harm,     TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(27),   MANA(35), MANA_EARTH, PRAC(20),
    WAIT(12),    "hurling boulders",       "!Hurling Boulders!"
    },

    {
    "healing",         { 20 },
    NULL, spell_heal,     TAR_CHAR_DEFENSIVE, POS_FIGHTING,
    NULL,           SLOT(28),   MANA(50), MANA_EARTH, PRAC(20),
    WAIT(12),    "",         "!Healing!"
    },

    {
    "identify",     { 12 },
    NULL, spell_identify,     TAR_OBJ_INV,        POS_STANDING,
    NULL,           SLOT(53),   MANA(12), MANA_ANY,   PRAC(20),
    WAIT(24),    "",         "!Identify!"
    },

    {
    "infravision",      {  8 },
    NULL, spell_infravision,  TAR_CHAR_DEFENSIVE, POS_STANDING,
    NULL,           SLOT(77),    MANA(5), MANA_FIRE,  PRAC(20),
    WAIT(18),    "",         "You no longer see in the dark."
    },

    {
    "invisibility",        {  10 },
    NULL, spell_invis,        TAR_CHAR_DEFENSIVE, POS_STANDING,
    &gsn_invis,     SLOT(29),    MANA(5), MANA_AIR,   PRAC(20),
    WAIT(12),    "",         "You are no longer invisible."
    },

    {
    "know alignment",   {  3  },
    NULL, spell_know_alignment,   TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(58),    MANA(9), MANA_FIRE,  PRAC(20),
    WAIT(12),    "",         "!Know Alignment!"
    },

    {
    "lightning bolt",   {  9  },
    NULL, spell_lightning_bolt,   TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(30),   MANA(15), MANA_FIRE,  PRAC(20),
    WAIT(12),    "lightning bolt",   "!Lightning Bolt!"
    },

    {
    "locate object",    {  11 },
    NULL, spell_locate_object,    TAR_IGNORE,     POS_STANDING,
    NULL,           SLOT(31),   MANA(20), MANA_ANY,   PRAC(20),
    WAIT(18),    "",         "!Locate Object!"
    },

    {
    "spear of fire",    {  1 },
    NULL, spell_magic_missile,    TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(32),   MANA(15), MANA_FIRE,  PRAC(20),
    WAIT(12),    "fiery spear",    "!Spear of Fire!"
    },

    {
    "mass invisibility",       { 18 },
    NULL, spell_mass_invis,   TAR_IGNORE,     POS_STANDING,
    &gsn_mass_invis,    SLOT(69),   MANA(20), MANA_AIR, PRAC(20),
    WAIT(24),    "",         "!Mass Invis!"
    },

    {
    "pass door",        { 18 },
    NULL, spell_pass_door,    TAR_CHAR_SELF,      POS_STANDING,
    NULL,           SLOT(74),   MANA(20),  MANA_AIR, PRAC(20),
    WAIT(12),
	"",			"You feel solid again."
    },

    {
    "poison",       { 10 },
    NULL, spell_poison,       TAR_CHAR_OFFENSIVE, POS_STANDING,
    &gsn_poison,        SLOT(33),   MANA(10), MANA_WATER, PRAC(20),
    WAIT(12),
	"poison",		"You feel less sick."
    },

    {
    "protection",       { 15 },
    NULL, spell_protection,   TAR_CHAR_SELF,      POS_STANDING,
    NULL,           SLOT(34),    MANA(5), MANA_FIRE, PRAC(20),
    WAIT(12),    "",         "You feel less protected."
    },

    {
    "refresh",      {  7 },
    NULL, spell_refresh,      TAR_CHAR_DEFENSIVE, POS_STANDING,
    NULL,           SLOT(81),   MANA(12), MANA_EARTH, PRAC(20),
    WAIT(18),    "",      "!Refresh!"
    },

    {
    "remove curse",     { 13 },
    NULL, spell_remove_curse, TAR_CHAR_DEFENSIVE, POS_STANDING,
    NULL,           SLOT(35),    MANA(5), MANA_WATER, PRAC(20),
    WAIT(12),    "",         "!Remove Curse!"
    },

    {
    "sanctuary",        { 12 },
    NULL, spell_sanctuary,    TAR_CHAR_DEFENSIVE, POS_STANDING,
    NULL,           SLOT(36),   WAIT(75), MANA_WATER, PRAC(20),
    WAIT(12),    "",         "The white aura around your body fades."
    },

    {
    "shield",       { 13 },
    NULL, spell_shield,       TAR_CHAR_DEFENSIVE, POS_STANDING,
    NULL,           SLOT(67),   WAIT(12), MANA_WATER, PRAC(20),
    WAIT(18),    "",     "The thin transparent skin shimmers and fades away."
    },

    {
    "shocking grasp",   {  7 },
    NULL, spell_shocking_grasp,   TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(37),   WAIT(15), MANA_FIRE,  PRAC(20),
    WAIT(12),    "shocking grasp",   "!Shocking Grasp!"
    },

    {
    "sleep",        { 14 },
    NULL, spell_sleep,        TAR_CHAR_OFFENSIVE, POS_STANDING,
    &gsn_sleep,     SLOT(38),   WAIT(15), MANA_EARTH, PRAC(20),
    WAIT(12),    "",         "You feel less tired."
    },

    {
    "stone skin",       { 17 },
    NULL, spell_stone_skin,   TAR_CHAR_SELF,      POS_STANDING,
    NULL,           SLOT(66),   WAIT(12), MANA_EARTH, PRAC(20),
    WAIT(18),    "",         "Your skin feels soft again."
    },

    {
    "summon",       { 15 },
    NULL, spell_summon,       TAR_IGNORE,     POS_STANDING,
    NULL,           SLOT(40),   MANA(50), MANA_AIR,   PRAC(20),
    WAIT(12),    "",         "!Summon!"
    },

    {
    "teleport",     {  20 },
    NULL, spell_teleport,     TAR_CHAR_SELF,      POS_FIGHTING,
    NULL,           SLOT( 2),   MANA(35), MANA_AIR,   PRAC(20),
    WAIT(12),    "",         "!Teleport!"
    },

    {
    "weaken",       {  7 },
    NULL, spell_weaken,       TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(68),   MANA(20), MANA_WATER, PRAC(20),
    WAIT(12),    "spell",        "You feel the strength pouring into you."
    },

    {
    "word of recall",   { 1 },
    NULL, spell_word_of_recall,   TAR_CHAR_SELF,      POS_RESTING,
    NULL,           SLOT(42),    MANA(5), MANA_AIR,   PRAC(20),
    WAIT(12),    "",         "!Word of Recall!"
    },

/*
 * Dragon breath
 */
    {
    "acid breath",      { 41 },
    NULL, spell_acid_breath,  TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(200),   MANA(30),  MANA_WATER, PRAC(20),
    WAIT(8),    "blast of acid",    "!Acid Breath!"
    },

    {                       
    "fire breath",      { 42 },
    NULL, spell_fire_breath,  TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(201),   MANA(30),  MANA_FIRE,  PRAC(20),
    WAIT(8),    "blast of flame",   "!Fire Breath!"
    },

    {
    "frost breath",     { 43 },
    NULL, spell_frost_breath, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(202),   MANA(30),  MANA_WATER, PRAC(20),
    WAIT(8),    "blast of frost",   "!Frost Breath!"
    },

    {
    "gas breath",       { 44 },
    NULL, spell_gas_breath,   TAR_IGNORE,     POS_FIGHTING,
    NULL,           SLOT(203),   MANA(30),  MANA_AIR, PRAC(20),
    WAIT(8),    "blast of gas",     "!Gas Breath!"
    },

    {
    "lightning breath", { 45 },
    NULL, spell_lightning_breath, TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    NULL,           SLOT(204),   MANA(30),  MANA_ANY,   PRAC(20),
    WAIT(8),    "blast of lightning",   "!Lightning Breath!"
    },

/*
 * Fighter and thief skills.
 */
    {
    "backstab",     { 5 },
    NULL, spell_null,     TAR_IGNORE,     POS_STANDING,
    &gsn_backstab,      SLOT( 0),    0, 0, PRAC(20), 24,
	"backstab",		"!Backstab!"
    },

    {                                              
    "disarm",       { 7 },
    NULL, spell_null,     TAR_IGNORE,     POS_FIGHTING,
    &gsn_disarm,        SLOT( 0),    0, 0, PRAC(20), 24,
	"",			"!Disarm!"
    },

    {
    "dodge",        { 3 },
    NULL, spell_null,     TAR_IGNORE,     POS_FIGHTING,
    &gsn_dodge,     SLOT( 0),    0,  0, PRAC(20), 0,
	"",			"!Dodge!"
    },

    {
    "enhanced damage",  { 9 },
    NULL, spell_null,     TAR_IGNORE,     POS_FIGHTING,
    &gsn_enhanced_damage,   SLOT( 0),    0, 0,PRAC(20),  0,
	"",			"!Enhanced Damage!"
    },

    {
    "hide",         { 12 },
    NULL, spell_null,     TAR_IGNORE,     POS_RESTING,
    &gsn_hide,      SLOT( 0),    0, 0, PRAC(20), 12,
	"",			"!Hide!"
    },

    {
    "kick",         { 1 },
    NULL, spell_null,     TAR_CHAR_OFFENSIVE, POS_FIGHTING,
    &gsn_kick,      SLOT( 0),    0, 0, PRAC(20), 8,
    "kick",         "!Kick!"
    },

    {
    "parry",        { 3 },
    NULL, spell_null,     TAR_IGNORE,     POS_FIGHTING,
    &gsn_parry,     SLOT( 0),    0, 0, PRAC(20), 0,
	"",			"!Parry!"
    },

    {
    "peek",         { 5 },
    NULL, spell_null,     TAR_IGNORE,     POS_STANDING,
    &gsn_peek,      SLOT( 0),    0, 0, PRAC(20), 0,
	"",			"!Peek!"
    },

    {
    "pick lock",        { 8 },
    NULL, spell_null,     TAR_IGNORE,     POS_STANDING,
    &gsn_pick_lock,     SLOT( 0),    0, 0, PRAC(20), 12,
	"",			"!Pick!"
    },

    {
    "rescue",       {  10 },
    NULL, spell_null,     TAR_IGNORE,     POS_FIGHTING,
    &gsn_rescue,        SLOT( 0),    0, 0, PRAC(20), 12,
	"",			"!Rescue!"
    },

    {
    "second attack",    { 8 },
    NULL, spell_null,     TAR_IGNORE,     POS_FIGHTING,
    &gsn_second_attack, SLOT( 0),    0, 0, PRAC(20), 0,
	"",			"!Second Attack!"
    },

    {
    "sneak",        { 5 },
    NULL, spell_null,     TAR_IGNORE,     POS_STANDING,
    &gsn_sneak,     SLOT( 0),    0, 0, PRAC(20), 12,
	"",			NULL
    },

    {
    "steal",        {  3 },
    NULL, spell_null,     TAR_IGNORE,     POS_STANDING,
    &gsn_steal,     SLOT( 0),    0, 0, PRAC(20), 24,
	"",			"!Steal!"
    },

    {
    "third attack",     { 18 },
    NULL, spell_null,     TAR_IGNORE,     POS_FIGHTING,
    &gsn_third_attack,  SLOT( 0),    0, 0,PRAC(20),  0,
	"",			"!Third Attack!"
    },

    {
    "dual wield",       { 15 },
    NULL, spell_null,     TAR_IGNORE,      POS_FIGHTING,
    &gsn_dual_wield,   SLOT( 0),     0, 0,PRAC(20),  0,
    "",         "!Dual Wield!"
    },

    {
    "tracking",         { 15 },
    NULL, spell_null,     TAR_IGNORE,      POS_STANDING,
    &gsn_track,   SLOT( 0),     0, 0, PRAC(20), 0,
    "",         "!Tracking!"
    },

};


const   struct  group_type  group_table [MAX_SKILL_GROUPS] =
{
};








