/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/



/*
 * Accommodate old non-Ansi compilers.
 */
#if defined(TRADITIONAL)
#define const
#define args( list )			( )
#define DECLARE_DO_FUN( fun )		void fun( )
#define DECLARE_SPEC_FUN( fun )		bool fun( )
#define DECLARE_SPELL_FUN( fun )        void fun( )
#define DECLARE_LEARN_FUN( fun )        void fun( )
#define DECLARE_HIT_FUN( fun )          void fun( )
#else
#define args( list )			list
#define DECLARE_DO_FUN( fun )           DO_FUN    fun
#define DECLARE_SPEC_FUN( fun )		SPEC_FUN  fun
#define DECLARE_SPELL_FUN( fun )        SPELL_FUN fun
#define DECLARE_LEARN_FUN( fun )        LEARN_FUN fun
#define DECLARE_HIT_FUN( fun )          HIT_FUN   fun
#endif



/*
 * Short scalar types.
 * Diavolo reports AIX compiler has bugs with short types.
 */
#if	!defined(FALSE)
#define FALSE	 0
#endif

#if	!defined(TRUE)
#define TRUE	 1
#endif

#if	defined(_AIX)
#if	!defined(const)
#define const
#endif
typedef int				sh_int;
typedef int				bool;
#define unix
#else
typedef short    int			sh_int;
typedef unsigned char			bool;
#endif



/*
 * Structure types.
 */
typedef struct	affect_data		AFFECT_DATA;
typedef struct	area_data		AREA_DATA;
typedef struct	ban_data		BAN_DATA;
typedef struct  char_data               CHAR_DATA;
typedef struct  editing_data            EDITING_DATA;
typedef struct	descriptor_data		DESCRIPTOR_DATA;
typedef struct	exit_data		EXIT_DATA;
typedef struct	extra_descr_data	EXTRA_DESCR_DATA;
typedef struct	help_data		HELP_DATA;
typedef struct	kill_data		KILL_DATA;
typedef struct	mob_index_data		MOB_INDEX_DATA;
typedef struct  attack_data             ATTACK_DATA;
typedef struct	note_data		NOTE_DATA;
typedef struct  sedit_data              SEDIT_DATA;
typedef struct	obj_data		OBJ_DATA;
typedef struct  obj_index_data          OBJ_INDEX_DATA;
typedef struct	pc_data			PC_DATA;
typedef struct  room_index_data         ROOM_INDEX_DATA;
typedef struct	reset_data		RESET_DATA;
typedef struct	shop_data		SHOP_DATA;
typedef struct	time_info_data		TIME_INFO_DATA;
typedef struct	weather_data		WEATHER_DATA;
typedef struct  script_data             SCRIPT_DATA;
typedef struct  trigger_data            TRIGGER_DATA;
typedef struct  variable_data           VARIABLE_DATA;



/*
 * Function types.
 */
typedef	void DO_FUN	args( ( CHAR_DATA *ch, char *argument ) );
typedef bool SPEC_FUN	args( ( CHAR_DATA *ch ) );
typedef void SPELL_FUN	args( ( int sn, int level, CHAR_DATA *ch, void *vo ) );
typedef void LEARN_FUN  args( ( CHAR_DATA *ch, CHAR_DATA *p, int sn ) );
typedef bool HIT_FUN    args( ( CHAR_DATA *ch, CHAR_DATA *victim, int hit, int dam ) );



/*
 * String and memory management parameters.
 */
#define	MAX_KEY_HASH		 1024
#define MAX_STRING_LENGTH	 4096
#define MAX_INPUT_LENGTH	  512
#define WORK_STRING_LENGTH        512

#define VERSION_STR       "NiMUD Revision 2-68 (8/18/94)"


/*
 * Game parameters.
 * Increase the max'es if you add more of something.
 * Adjust the pulse numbers to suit yourself.
 */
#define MAX_SKILL                 100
#define MAX_CLASS                   1
#define MAX_LEVEL                  40
#define MAX_SOCIALS               256
#define MAX_RACE                   18
#define MAX_COLORS                 10
#define MAX_SKILL_GROUPS           24
#define MAX_GROUP_SKILLS           11

#define LEVEL_HERO                 (MAX_LEVEL - 10)

#define LEVEL_DEMIGOD              (MAX_LEVEL - 1)
#define LEVEL_SUPREME              (MAX_LEVEL - 2)
#define LEVEL_ANGEL                (MAX_LEVEL - 3)
#define LEVEL_BUILDER              (MAX_LEVEL - 8)
#define LEVEL_IMMORTAL             (MAX_LEVEL - 9)

#define LEVEL_SCRIPT               (MAX_LEVEL-1)

#define PULSE_PER_SECOND             4
#define PULSE_VIOLENCE            (  2 * PULSE_PER_SECOND)  /* 2 seconds */
#define PULSE_MOBILE              (  4 * PULSE_PER_SECOND)  /* 4 seconds */
#define PULSE_TICK                (300 * PULSE_PER_SECOND)  /* 5 minutes */
#define PULSE_AREA                ( 60 * PULSE_PER_SECOND)  /* 1 minute  */



/*
 * Site ban structure.
 */
struct	ban_data
{
    BAN_DATA *	next;
    char *	name;
};



/*
 * Time and weather stuff.
 * Note that weather changes according to the month (winter).
 */
#define SUN_DARK		    0
#define SUN_RISE		    1
#define SUN_LIGHT		    2
#define SUN_SET			    3
#define MOON_RISE                   4
#define MOON_SET                    5

#define SKY_CLOUDLESS		    0
#define SKY_CLOUDY		    1
#define SKY_RAINING		    2
#define SKY_LIGHTNING		    3

struct	time_info_data
{
    sh_int      hour;
    sh_int      day;
    sh_int      month;
    sh_int      year;
};

struct	weather_data
{
    int		mmhg;
    int		change;
    sh_int      sky;
    sh_int      sunlight;
    sh_int      windspeed;
    sh_int      winddir;
    sh_int      temperature;
};



/*
 * Connected state for a channel.
 */
#define CON_PLAYING			 0
#define CON_GET_NAME			 1
#define CON_GET_OLD_PASSWORD		 2
#define CON_CONFIRM_NEW_NAME		 3
#define CON_GET_NEW_PASSWORD		 4
#define CON_CONFIRM_NEW_PASSWORD	 5
#define CON_GET_NEW_SEX                  6
#define CON_GET_NEW_RACE                 7
#define CON_CONFIRM_NEW_RACE             8
#define CON_READ_MOTD                   10

#define CON_AEDITOR                     -1
#define CON_REDITOR                     -2
#define CON_MEDITOR                     -3
#define CON_OEDITOR                     -4

#define CONNECTED(d)        ( d->connected <= CON_PLAYING )



/*
 * Online editing structure.
 */
struct  editing_data
{
    void *              pIndex;
    sh_int              vnum;
    sh_int              type;
    sh_int              command;
    char *              text;
    char **             destination;
};



/*
 * Descriptor (channel) structure.
 */
struct	descriptor_data
{
    DESCRIPTOR_DATA *	next;
    DESCRIPTOR_DATA *	snoop_by;
    CHAR_DATA *         character;
    CHAR_DATA *		original;
    char *		host;
    sh_int		descriptor;
    sh_int		connected;
    bool		fcommand;
    bool                fpromptok;
    char		inbuf		[4 * MAX_INPUT_LENGTH];
    char		incomm		[MAX_INPUT_LENGTH];
    char		inlast		[MAX_INPUT_LENGTH];
    int			repeat;
    char *              showstr_head;
    char *              showstr_point;
    char *		outbuf;
    int			outsize;
    int			outtop;
    EDITING_DATA        editing;
    void *              pEdit;
    char **             pString;
};



/*
 * Attribute bonus structures.
 */
struct	str_app_type
{
    sh_int	tohit;
    sh_int	todam;
    sh_int	carry;
    sh_int	wield;
};

struct	int_app_type
{
    sh_int	learn;
};

struct	wis_app_type
{
    sh_int	practice;
};

struct	dex_app_type
{
    sh_int	defensive;
};

struct	con_app_type
{
    sh_int	hitp;
    sh_int	shock;
};



/*
 * TO types for act.
 */
#define TO_ROOM		    0
#define TO_NOTVICT	    1
#define TO_VICT		    2
#define TO_CHAR		    3



/*
 * Help table types.
 */
struct	help_data
{
    HELP_DATA *	next;
    sh_int	level;
    char *	keyword;
    char *	text;
};



/*
 * Shop types.
 */
#define MAX_TRADE	 5

struct	shop_data
{
    SHOP_DATA * next;                   /* Next Shop in List            */
    sh_int	keeper;			/* Vnum of shop keeper mob	*/
    sh_int	buy_type [MAX_TRADE];	/* Item types shop will buy	*/
    sh_int	profit_buy;		/* Cost multiplier for buying	*/
    sh_int	profit_sell;		/* Cost multiplier for selling	*/
    sh_int	open_hour;		/* First opening hour		*/
    sh_int	close_hour;		/* First closing hour		*/
};

/*
 * Race list (see def.c)
 */
#define RACE_HUMAN               0
#define RACE_HALFELF             1
#define RACE_ELF                 2
#define RACE_WILDELF             3
#define RACE_HIGHELF             4
#define RACE_SHADOWELF           5
#define RACE_DROW                6
#define RACE_DWARF               7
#define RACE_HILLDWARF           8
#define RACE_GNOME               9
#define RACE_TINKERGNOME        10
#define RACE_GIANT              11
#define RACE_KENDER             12
#define RACE_SHADAOSLAV         13
#define RACE_DRAGONKIN          14
#define RACE_BUCKAWN            15
#define RACE_SKULK              16
#define RACE_BEASTMAN           17

#define LANG_COMMON              0
#define LANG_ELVEN               1
#define LANG_DWARVEN             2
#define LANG_GNOME               3
#define LANG_KENDER              4
#define LANG_SHADAOKIN           5
#define LANG_DRAGON              6
#define LANG_SKULK               7
#define LANG_BEASTMAN            8
#define MAX_LANG                 9

struct  race_type
{
   char     race_name     [20];
   sh_int   bonus          [5];
   int      start_room;
   int      max_skills;
   int      exp_mod;
   int      affect_bits;
   int      size;
   int      startlang[MAX_LANG];
};

#define MAX_COIN       5

/*
 * One Coin
 */
struct coin_type
{
   int      multiplier;
   int      convert;
   int      weight;
   char *   long_name;
   char *   short_name;
};

/*
 * Per-class stuff.
 */
struct	class_type
{
    char        who_name        [20];   /* name of class */
    sh_int      attr_prime;             /* prime attrib  */
    int         guild;                  /* start room    */
    sh_int      skill_adept;            /* max skill lvl */
    sh_int      thac0_00;
    sh_int      thac0_32;
    sh_int      hp_min;                 /* gain max/min  */
    sh_int      hp_max;
};



/*
 * Skill and spell group structures.
 */
struct  group_type
{
    char      * group_name;
    sh_int      group_cost[MAX_CLASS];
    char      * skill_list[MAX_GROUP_SKILLS];
};


/*
 * Un colour type.
 */
struct color_data
{
   char         code[10];
   char         act_code[5];
   char         name[15];
   int          number;
};


/*
 * Data structure for notes.
 */
struct	note_data
{
    NOTE_DATA *	next;
    char *	sender;
    char *	date;
    char *	to_list;
    char *	subject;
    char *	text;
    time_t      date_stamp;
};


/*
 * A string edit
 */
struct  sedit_data
{
    SEDIT_DATA *        next;
    char **             destination;
    char *              text;
};



/*
 * An affect.
 */
struct	affect_data
{
    AFFECT_DATA *	next;
    sh_int		location;
    sh_int		modifier;
    sh_int              type;
    sh_int              duration;
    int			bitvector;
};



/*
 * A kill structure (indexed by level).
 */
struct	kill_data
{
    int                 number;
    sh_int		killed;
};

/*
 * Types of attacks.
 * Must be non-overlapping with spell/skill types,
 * but may be arbitrary beyond that.
 */
#define TYPE_ATTACK_DATA             -2
#define TYPE_UNDEFINED               -1
#define TYPE_HIT                     1000
#define TYPE_SLASH                   1001
#define TYPE_PIERCE                  1002
#define TYPE_WHIP                    1003
#define TYPE_EXPLODE                 1004
#define TYPE_POUND                   1005
#define TYPE_SUCTION                 1006
#define TYPE_SHOT                    1007
#define MAX_ATTACK                   16         /* max index + 1 */
#define MAX_ATTACK_TYPES             8

/*
 * Weapon proficiencies.  Increase damage and hit percentiles.
 */
#define WP_HIT                       0
#define WP_SLASH                     1
#define WP_PIERCE                    2
#define WP_WHIP                      3
#define WP_EXPLODE                   4
#define WP_POUND                     5
#define WP_SUCTION                   6
#define WP_SHOT                      7
#define WP_MAX                       8

#define MAX_ATTACK_DATA              5

struct attack_data
{
     ATTACK_DATA * next;
     int           idx;       /* See attack_table for this value */
     sh_int        dam1;
     sh_int        dam2;
};



struct attack_type
{
     char     * name;
     int        hit_type;
     HIT_FUN  * hit_fun;
};


/***************************************************************************
 * *********************************************************************** *
 *  **************** VALUES OF INTEREST TO AREA BUILDERS ****************  *
 *   *************** (Start of section ... start here) *****************   *
 *    *****************************************************************    *
 ***************************************************************************/

/*
 * Ansi colors and VT100 codes
 * Used in #PLAYER
 *
 * On most machines that use ANSI, namely the IBM PCs, the decimal value for
 * the escape character is 27 (1B hex).     Change this value when needed.
 */

#define ESC        '\x1b'

#define BLACK      "\x1b[30m"    /* These are foreground color codes */
#define RED        "\x1b[31m"
#define GREEN      "\x1b[32m"
#define YELLOW     "\x1b[33m"
#define BLUE       "\x1b[34m"
#define PURPLE     "\x1b[35m"
#define CYAN       "\x1b[36m"
#define GREY       "\x1b[37m"

#define B_BLACK    "\x1b[40m"    /* These are background color codes */
#define B_RED      "\x1b[41m"
#define B_GREEN    "\x1b[42m"
#define B_YELLOW   "\x1b[43m"
#define B_BLUE     "\x1b[44m"
#define B_PURPLE   "\x1b[45m"
#define B_CYAN     "\x1b[46m"
#define B_GREY     "\x1b[47m"

/* Below are VT100 and ANSI codes (above are ANSI exclusively)       */

#define EEEE       "\x1b#8"                 /* Turns screen to EEEEs */
#define CLRSCR     "\x1b[2j"                /* Clear screen          */
#define CLREOL     "\x1b[K"                 /* Clear to end of line  */

#define UPARR      "\x1b[A"                 /* Up one line           */
#define DOWNARR    "\x1b[B"                 /* Down one line         */
#define RIGHTARR   "\x1b[C"                 /* Right one column      */
#define LEFTARR    "\x1b[D"                 /* Left one column       */
#define HOMEPOS    "\x1b[H"                 /* Home (upper left)     */

#define BOLD       "\x1b[1m"                /* High intensity        */
#define FLASH      "\x1b[5m"                /* Flashing text         */
#define INVERSE    "\x1b[7m"                /* XORed back and fore   */
#define NTEXT      "\x1b[0m"                /* Normal text  (grey)   */

/*
 * Other codes of note for future ANSI development:
 * The <esc>[y;xH code works nicely for positioning the cursor.
 */

/*
 * Color codings for
 * channels+says
 */
#define COLOR_AUCTION                 0
#define COLOR_GOSSIP                  1
#define COLOR_SHOUT                   2
#define COLOR_IMMTALK                 3
#define COLOR_SAY                     4
#define COLOR_TELL                    5
#define COLOR_UNUSED6                 6
#define COLOR_UNUSED7                 7
#define COLOR_UNUSED8                 8
#define COLOR_UNUSED9                 9


/*
 * ACT bits for mobs.
 * Used in #MOBILES.
 */
#define ACT_IS_NPC           0x00000001         /* Auto set for mobs    */
#define ACT_SENTINEL         0x00000002         /* Stays in one room    */
#define ACT_SCAVENGER        0x00000004         /* Picks up objects     */
#define ACT_HALT             0x00000008         /* die script die!      */
#define ACT_FIGHTSCR         0x00000010         /* scripts ok in combat */
#define ACT_AGGRESSIVE       0x00000020         /* Attacks PC's         */
#define ACT_STAY_AREA        0x00000040         /* Won't leave area     */
#define ACT_WIMPY            0x00000080         /* Flees when hurt      */
#define ACT_PET              0x00000100         /* Auto set for pets    */
#define ACT_TRAIN            0x00000200         /* Can train PC's       */
#define ACT_PRACTICE         0x00000400         /* Can practice PC's    */
#define ACT_TRACKSCR         0x00000800         /* show script show!    */
#define ACT_SCRAMBLE         0x00001000         /* scrambling mobtraps  */
#define ACT_MOUNTABLE        0x00002000         /* can be mounted       */
#define ACT_TRACKING         0x00004000         /* tracks its enemies   */
#define ACT_ANGRY            0x00008000         /* less than aggress    */
#define ACT_IMMORTAL         0x00010000         /* can't be attacked    */


/*
 * Bits for 'affected_by'.
 * Used in #MOBILES.
 */
#define AFF_BLIND            0x00000001
#define AFF_INVISIBLE        0x00000002
#define AFF_DETECT_EVIL      0x00000004
#define AFF_DETECT_INVIS     0x00000008
#define AFF_DETECT_MAGIC     0x00000010
#define AFF_DETECT_HIDDEN    0x00000020
#define AFF_HOLD             0x00000040        /* Unused       */
#define AFF_SANCTUARY        0x00000080
#define AFF_FAERIE_FIRE      0x00000100
#define AFF_INFRARED         0x00000200
#define AFF_CURSE            0x00000400
#define AFF_FLAMING          0x00000800        /* Unused       */
#define AFF_POISON           0x00001000
#define AFF_PROTECT          0x00002000
#define AFF_PARALYSIS        0x00004000        /* Unused       */
#define AFF_SNEAK            0x00008000
#define AFF_HIDE             0x00010000
#define AFF_SLEEP            0x00020000
#define AFF_CHARM            0x00040000
#define AFF_FLYING           0x00080000
#define AFF_PASS_DOOR        0x00100000
#define AFF_FREEACTION       0x00200000



/*
 * Sex.
 * Used in #MOBILES.
 */
#define SEX_NEUTRAL                   0
#define SEX_MALE                      1
#define SEX_FEMALE                    2


/*
 * Well known mob virtual numbers.
 * Defined in #MOBILES.
 */
#define MOB_VNUM_TEMPLATE          1
#define MOB_VNUM_CITYGUARD         2

#define MOB_VNUM_GHOST            10
#define MOB_VNUM_SKELETON         11
#define MOB_VNUM_ZOMBIE           12
#define MOB_VNUM_WIGHT            13
#define MOB_VNUM_WRAITH           14
#define MOB_VNUM_VAMPIRE          15
#define MOB_VNUM_DAEMON           16



/*
 * Well known object virtual numbers.
 * Defined in #OBJECTS.
 */
#define OBJ_VNUM_TEMPLATE              1
#define OBJ_VNUM_MONEY_ONE             2
#define OBJ_VNUM_MONEY_SOME            3

#define OBJ_VNUM_CORPSE_NPC           10
#define OBJ_VNUM_CORPSE_PC            11
#define OBJ_VNUM_SEVERED_HEAD         12
#define OBJ_VNUM_TORN_HEART           13
#define OBJ_VNUM_SLICED_ARM           14
#define OBJ_VNUM_SLICED_LEG           15
#define OBJ_VNUM_FINAL_TURD           16

#define OBJ_VNUM_MUSHROOM             20
#define OBJ_VNUM_LIGHT_BALL           21
#define OBJ_VNUM_SPRING               22

#define OBJ_VNUM_DEFAULT_WEAPON       30
#define OBJ_VNUM_DEFAULT_VEST         31
#define OBJ_VNUM_DEFAULT_PACK         32
#define OBJ_VNUM_DEFAULT_LIGHT        33
#define OBJ_VNUM_DEFAULT_BELT         34
#define OBJ_VNUM_DEFAULT_SHIELD       35
#define OBJ_VNUM_DEFAULT_TINDERBOX    36
#define OBJ_VNUM_DEFAULT_LETTER       37
#define OBJ_VNUM_DEFAULT_FOOD         38
#define OBJ_VNUM_DEFAULT_DRINK        39


/*
 * Well known room virtual numbers.
 * Defined in #ROOMS.
*/
#define ROOM_VNUM_TEMPLATE            1
#define ROOM_VNUM_LIMBO               2
#define ROOM_VNUM_CHAT                3
#define ROOM_VNUM_TEMPLE           3001
#define ROOM_VNUM_ALTAR             100
#define ROOM_VNUM_SCHOOL           3700



/*
 * Item types.
 * Used in #OBJECTS.
 */
#define ITEM_LIGHT                  1 /* v0:curlight v1:maxlight v3:flags  */
#define ITEM_SCROLL                 2 /* v0:splevel v1-3:spells            */
#define ITEM_WAND                   3 /* v0:splevel v1-3:spells            */
#define ITEM_STAFF                  4 /* v0:splevel v1-3:spells            */
#define ITEM_WEAPON                 5 /* v1:mindam v2:maxdam v3:type       */
#define ITEM_RANGED_WEAPON          6 /* v0:ammo v1:min v2:maxdam v3:type  */
#define ITEM_AMMO                   7 /* v0:type v1:add to dam             */
#define ITEM_TREASURE               8 /* values unused                     */
#define ITEM_ARMOR                  9 /* v0:AC v1:0=curdam v2:max v3:size  */
#define ITEM_POTION                10 /* v0:splevel v1-3:spells            */
#define ITEM_BOOK                  11 /* values unsued (soon to be)        */
#define ITEM_FURNITURE             12 /* v0:flags v1:ex flags v2:key v3:rm */
#define ITEM_TRASH                 13 /* values unused                     */
#define ITEM_PAPER                 14 /* values unused                     */
#define ITEM_CONTAINER             15 /* v0:max_weight v1:flags v2:keyvnum */
#define ITEM_THROWN                16 /* v0:splevel v1-3:spells            */
#define ITEM_DRINK_CON             17 /* v0:capacity v1:cur v2:liq v3:Pois */
#define ITEM_KEY                   18 /* values unused                     */
#define ITEM_FOOD                  19 /* v0: hours of food v3:Pois         */
#define ITEM_MONEY                 20 /* v0: amount v1: type               */
#define ITEM_GEM                   21 /* v0: flags v1: mana v2: max mana   */
#define ITEM_VEHICLE               22 /* any value=sector allowed to pass  */
#define ITEM_CORPSE_NPC            23 /* values unused                     */
#define ITEM_CORPSE_PC             24 /* values unused                     */
#define ITEM_FOUNTAIN              25 /* v0:splevel v1-3:spells            */
#define ITEM_PILL                  26 /* v0:splevel v1-3:spells            */
#define ITEM_TOOL                  27 /* v0:flags v1: # left v2:max uses   */
#define ITEM_LIST                  28 /* v0:number of vnums in list        */
#define ITEM_BOARD                 29 /* v0: index of board */

#define ITEM_MAX                   30


/* Object Value Notes:
 *
 * On drink containers, liquid -1 = oil
 * On Pois values, if pois=0 it means no poison, otherwise its the level
 * of poison (effects duration)
 * splevel = spell level    v0/v1/v2/v3 = values
 */

/*
 * Values for ranged weapons (value[3])
 */

#define RNG_BOW               0
#define RNG_CROSSBOW          1
#define RNG_CATAPULT          2

/*
 * Values for containers (value[1]).
 * Used in #OBJECTS.
 */
#define CONT_CLOSEABLE		      1
#define CONT_PICKPROOF		      2
#define CONT_CLOSED                   4
#define CONT_LOCKED		      8

/*
 * Values for furnature (value[0]).
 * Used in #OBJECTS
 */
#define FURN_SIT                      1
#define FURN_SLEEP                    2
#define FURN_EXIT                     4

/*
 * Values for lights (value[3]).
 * Used in #OBJECTS
 */
#define LIGHT_LIT                     1
#define LIGHT_FILLABLE                2

/*
 * Values for tools (value[0]).
 * Used in #OBJECTS
 */
#define TOOL_TINDERBOX                1
#define TOOL_LOCKPICK                 2
#define TOOL_BOUNTY                   4



/*
 * Armor sizes.
 */
#define ARMOR_ANY         0
#define ARMOR_MINUTE      1
#define ARMOR_SMALL       2
#define ARMOR_PETITE      3
#define ARMOR_AVERAGE     4
#define ARMOR_MEDIUM      5
#define ARMOR_LARGE       6
#define ARMOR_HUGE        7
#define ARMOR_TITANIC     8
#define ARMOR_GARGANTUAN  9

/*
 * TOO_BIG -> Its too big for you to wear.
 * TOO_SMALL -> Its too small for you to wear.
 */
#define TOO_SMALL(ch,obj)    ( ((ch)->size - obj->value[3] > 1           \
                             && obj->value[3]) ? TRUE : FALSE )
#define TOO_BIG(ch,obj)      ( ((ch)->size - obj->value[3] < -1          \
                             && obj->value[3]) ? TRUE : FALSE )

/*
 * Extra flags.
 * Used in #OBJECTS.
 */
#define ITEM_GLOW            0x00000001
#define ITEM_HUM             0x00000002
#define ITEM_DARK            0x00000004
#define ITEM_LOCK            0x00000008
#define ITEM_EVIL            0x00000010
#define ITEM_INVIS           0x00000020
#define ITEM_MAGIC           0x00000040
#define ITEM_NODROP          0x00000080
#define ITEM_BLESS           0x00000100
#define ITEM_ANTI_GOOD       0x00000200
#define ITEM_ANTI_EVIL       0x00000400
#define ITEM_ANTI_NEUTRAL    0x00000800
#define ITEM_NOREMOVE        0x00001000
#define ITEM_INVENTORY       0x00002000
#define ITEM_NOSAVE          0x00004000
#define ITEM_BURNING         0x00008000



/*
 * Wear flags.
 * Used in #OBJECTS.
 */
#define ITEM_TAKE            0x00000001
#define ITEM_WEAR_FINGER     0x00000002
#define ITEM_WEAR_NECK       0x00000004
#define ITEM_WEAR_BODY       0x00000008
#define ITEM_WEAR_HEAD       0x00000010
#define ITEM_WEAR_LEGS       0x00000020
#define ITEM_WEAR_FEET       0x00000040
#define ITEM_WEAR_HANDS      0x00000080
#define ITEM_WEAR_ARMS       0x00000100
#define ITEM_WEAR_SHIELD     0x00000200
#define ITEM_WEAR_ABOUT      0x00000400
#define ITEM_WEAR_WAIST      0x00000800
#define ITEM_WEAR_WRIST      0x00001000
#define ITEM_WEAR_BELT       0x00002000
#define ITEM_WIELD           0x00004000
#define ITEM_HOLD            0x00004000
#define ITEM_WEAR_SHOULDER   0x00008000
#define ITEM_TWO_HANDED      0x80000000



/*
 * Apply types (for affects).
 * Used in #OBJECTS.
 */
#define APPLY_NONE		      0
#define APPLY_STR		      1
#define APPLY_DEX		      2
#define APPLY_INT		      3
#define APPLY_WIS		      4
#define APPLY_CON		      5
#define APPLY_SEX		      6
#define APPLY_CLASS		      7
#define APPLY_LEVEL		      8
#define APPLY_AGE		      9
#define APPLY_HEIGHT		     10
#define APPLY_WEIGHT		     11
#define APPLY_MANA		     12
#define APPLY_HIT                    13
#define APPLY_MOVE		     14
#define APPLY_GOLD		     15
#define APPLY_EXP		     16
#define APPLY_AC		     17
#define APPLY_HITROLL		     18
#define APPLY_DAMROLL		     19
#define APPLY_SAVING_THROW           20
#define APPLY_SAVING_THROW_A         21
#define APPLY_SAVING_THROW_B         22
#define APPLY_SAVING_THROW_C         23
#define APPLY_SAVING_THROW_D         24
  


/*
 * Room flags.
 * Used in #ROOMS.
 */
#define ROOM_DARK            0x00000001
#define ROOM_NO_MOB          0x00000002
#define ROOM_INDOORS         0x00000004
#define ROOM_IMMORTAL        0x00000008
#define BFS_MARK             0x00000010
/*                                   2
                                     4
                                     8   */
#define ROOM_BANK            0x00000100
#define ROOM_PRIVATE         0x00000200
#define ROOM_SAFE            0x00000400
#define ROOM_SOLITARY        0x00000800
#define ROOM_PET_SHOP        0x00001000
#define ROOM_NO_RECALL       0x00002000


/*
 * Directions.
 * Used in #ROOMS.
 */
#define DIR_NORTH		      0
#define DIR_EAST                      1
#define DIR_SOUTH		      2
#define DIR_WEST		      3
#define DIR_UP			      4
#define DIR_DOWN		      5
#define DIR_NW                        6
#define DIR_NE                        7
#define DIR_SW                        8
#define DIR_SE                        9
#define MAX_DIR                      10




/*
 * Exit flags.
 * Used in #ROOMS.
 */
#define EX_ISDOOR            0x00000001
#define EX_CLOSED            0x00000004
#define EX_LOCKED            0x00000002
#define EX_PICKPROOF         0x00000008
#define EX_EAT_KEY           0x00000010
#define EX_BASHPROOF         0x00000020
#define EX_JAMMED            0x00000040
#define EX_SECRET            0x00000080



/*
 * Sector types.
 * Used in #ROOMS.
 */
#define SECT_INSIDE                   0          /* cant see weather        */
#define SECT_CITY                     1          /* outdoor mv as inside    */
#define SECT_FIELD                    2          /* illuminated by moon     */
#define SECT_FOREST                   3          /* not illuminated         */
#define SECT_HILLS                    4          /* slower moving           */
#define SECT_MOUNTAIN                 5          /* requires grapple        */
#define SECT_WATER_SWIM               6          /* dropped objs float away */
#define SECT_WATER_NOSWIM             7          /* 4 pulse time on objs    */
#define SECT_UNDERWATER               8          /* needs breathing help    */
#define SECT_AIR                      9          /* requires FLY or vehicle */
#define SECT_DESERT                  10          /* hmm. no recall zone     */
#define SECT_ICELAND                 11          /* colder                  */
#define SECT_MAX                     12



/*
 * Equpiment wear locations.
 * Used in #RESETS.
 */
#define WEAR_DEPOSIT                 -2
#define WEAR_NONE		     -1
#define WEAR_FINGER_L                 0
#define WEAR_FINGER_R                 1
#define WEAR_NECK_1                   2
#define WEAR_NECK_2                   3
#define WEAR_BODY                     4
#define WEAR_HEAD                     5
#define WEAR_LEGS                     6
#define WEAR_FEET                     7
#define WEAR_HANDS                    8
#define WEAR_ARMS                     9
#define WEAR_SHIELD                  10
#define WEAR_ABOUT                   11
#define WEAR_WAIST                   12
#define WEAR_WRIST_L                 13
#define WEAR_WRIST_R                 14
#define WEAR_FLOATING                15
#define WEAR_BELT_1                  16
#define WEAR_BELT_2                  17
#define WEAR_BELT_3                  18
#define WEAR_BELT_4                  19
#define WEAR_BELT_5                  20
#define WEAR_HOLD_1                  21
#define WEAR_HOLD_2                  22
#define WEAR_SHOULDER_L              23
#define WEAR_SHOULDER_R              24
#define MAX_WEAR                     25





/***************************************************************************
 * *********************************************************************** *
 *  **************** VALUES OF INTEREST TO AREA BUILDERS ****************  *
 *   *************** (End of this section ... stop here) ***************   *
 *    *****************************************************************    *
 ***************************************************************************/

/*
 * Conditions.
 */
#define COND_DRUNK		      0
#define COND_FULL		      1
#define COND_THIRST		      2



/*
 * Positions.
 */
#define POS_DEAD		      0
#define POS_MORTAL		      1
#define POS_INCAP		      2
#define POS_STUNNED		      3
#define POS_SLEEPING		      4
#define POS_RESTING		      5
#define POS_FIGHTING		      6
#define POS_STANDING		      7



/*
 * ACT bits for players.
 */
#define PLR_IS_NPC           0x00000001         /* Don't EVER set.      */
#define PLR_BOUGHT_PET       0x00000002

#define PLR_HOLYLIGHT        0x00000004
#define PLR_WIZBIT           0x00000008

#define PLR_LOG              0x00000010
#define PLR_DENY             0x00000020
#define PLR_FREEZE           0x00000040

#define WIZ_NOTIFY           0x00000080
#define WIZ_NOTIFY_1         0x00000100
#define WIZ_NOTIFY_2         0x00000200
#define WIZ_NOTIFY_LOGIN     0x00000400
#define WIZ_NOTIFY_DEATH     0x00000800
#define WIZ_NOTIFY_BUG       0x00001000
#define WIZ_NOTIFY_LOG       0x00002000
#define WIZ_NOTIFY_SCRIPT    0x00004000

#define PLR_MOUNTABLE        0x00008000         /* MUST be same as ACT_ */

/*
 *  Act2 Bits
 * Channel / Config bits.
 */
#define CHANNEL_AUCTION      0x00000001
#define CHANNEL_GOSSIP       0x00000002
#define CHANNEL_IMMTALK      0x00000008

#define PLR_AUTOGOLD         0x00000100
#define PLR_AUTOEXIT         0x00000200
#define PLR_AUTOLOOT         0x00000400
#define PLR_AUTOSAC          0x00000800
#define PLR_BLANK            0x00001000
#define PLR_BRIEF            0x00002000
#define PLR_COMBINE          0x00004000
#define PLR_PROMPT           0x00008000
#define PLR_TELNET_GA        0x00010000
#define PLR_ASSIST           0x00020000
#define PLR_AUTOSPLIT        0x00040000

#define PLR_SILENCE          0x00080000
#define PLR_NO_EMOTE         0x00100000
#define PLR_NO_TELL          0x00200000

#define PLR_ANSI             0x00400000
#define PLR_VT100            0x00800000

/*
 * Trigger types for repetitive loops, command etc.
 */
#define TRIG_COMMAND          0   /* When a player types x command        */
#define TRIG_EACH_PULSE       1   /* Increments every pulse               */
#define TRIG_COMBAT           2   /* Every combat pulse                   */
#define TRIG_TICK_PULSE       3   /* Every tick (one mud-hour)            */
#define TRIG_BORN             4   /* Happens upon creation                */
#define TRIG_GETS             5   /* Happens when a mob gets/is given     */
#define TRIG_SAY              6   /* Happens when a mob sees a string     */
#define TRIG_TELL             7   /* Happens when a mob sees a string     */
#define TRIG_KILLS            8   /* Happens when a mob kills another     */
#define TRIG_DIES             9   /* Happens when the mob is killed       */
#define TRIG_ENTER           10   /* Happens on arrival (for each person) */
#define TRIG_MOVES           11   /* Happens whenever a mobile moves      */

/*
 * Internally used bits for triggers.
 */
#define SCRIPT_ADVANCE       0x00000001 /* Its OK to go to next command set  */
#define SCRIPT_HALT          0x00000002 /* current=NULL & disallow trig      */


struct script_data
{
   SCRIPT_DATA *        next;
   char *               command;
};

struct trigger_data
{
   TRIGGER_DATA *       next;
   SCRIPT_DATA *        script;
   SCRIPT_DATA *        current;
   sh_int               tracer;
   sh_int               waiting;
   sh_int               trigger_type;
   int                  bits;
   char *               keywords;
   char *               name;
};

struct variable_data
{
   VARIABLE_DATA *      next;
   char *               name;
   char *               value;
};


/*
 * Prototype for a mob.
 * This is the in-memory version of #MOBILES.   MOBIND <- quick search key
 */
struct	mob_index_data
{
    MOB_INDEX_DATA *	next;
    SPEC_FUN *          spec_fun;
    char *              spec_name;
    char *              script_fn;
    SHOP_DATA *		pShop;
    AREA_DATA *		area;
    TRIGGER_DATA *      triggers;           /* for scripts */
    VARIABLE_DATA *     variables;
    char *              name;
    char *              short_descr;
    char *		long_descr;
    char *		description;
    int                 vnum;
    sh_int		count;
    sh_int		killed;
    sh_int              sex;
    sh_int		level;
    int                 act;
    sh_int              timer;
    int			affected_by;
    sh_int		alignment;
    int                 money;
    ATTACK_DATA *       attacks [MAX_ATTACK_DATA];
};



/*
 * One character (PC or NPC).    CHDATA  <-quick search key
 */
struct char_data
{
    CHAR_DATA *         next;
    CHAR_DATA *		next_in_room;
    CHAR_DATA *         master;
    CHAR_DATA *		leader;
    CHAR_DATA *         fighting;
    CHAR_DATA *         reply;
    CHAR_DATA *         riding;
    CHAR_DATA *         mounted_by;
    char *              hunting;
    SPEC_FUN *		spec_fun;
    char *              spec_name;
    int                 spec_tracer;
    TRIGGER_DATA *      triggers;           /* for scripts           */
    VARIABLE_DATA *     variables;          /* for scripts           */
    MOB_INDEX_DATA *	pIndexData;
    DESCRIPTOR_DATA *	desc;
    AFFECT_DATA *	affected;
    SEDIT_DATA *        sedit;
    NOTE_DATA *		pnote;
    OBJ_DATA *		carrying;
    ROOM_INDEX_DATA *   in_room;
    ROOM_INDEX_DATA *	was_in_room;
    PC_DATA *		pcdata;
    char *		name;
    char *		short_descr;
    char *		long_descr;
    char *		description;
    char *              prompt;
    sh_int		sex;
    sh_int		class;
    sh_int		race;
    sh_int		level;
    sh_int		trust;
    int                 wizinvis;
    int			played;
    time_t		logon;
    time_t		save_time;
    time_t              last_note;
    sh_int		timer;
    sh_int		wait;
    sh_int		hit;
    sh_int		max_hit;
    sh_int		move;
    sh_int		max_move;
    int                 bounty;
    int                 owed;
    int                 money;
    int			exp;
    int			act;
    int                 act2;
    int			affected_by;
    sh_int		position;
    sh_int		practice;
    sh_int              learn;
    sh_int		carry_weight;
    sh_int		carry_number;
    sh_int		saving_throw;
    sh_int		alignment;
    sh_int		hitroll;
    sh_int		damroll;
    sh_int		armor;
    sh_int		wimpy;
    sh_int		deaf;
    sh_int              colors [MAX_COLORS];
    sh_int              security;
    sh_int              size;
};



/*
 * Data which only PC's have.         PCDAT <- quick search key
 */
struct	pc_data
{
    PC_DATA *		next;
    char *		pwd;
    char *		bamfin;
    char *		bamfout;
    char *		title;
    sh_int              pagelen;
    sh_int		perm_str;
    sh_int		perm_int;
    sh_int		perm_wis;
    sh_int		perm_dex;
    sh_int		perm_con;
    sh_int		mod_str;
    sh_int		mod_int;
    sh_int		mod_wis;
    sh_int		mod_dex;
    sh_int		mod_con;
    sh_int		condition	[3];
    sh_int		learned		[MAX_SKILL];
    sh_int              profs           [WP_MAX];
};



/*
 * Liquids.
 */
#define LIQ_WATER        0
#define LIQ_MAX		16

struct	liq_type
{
    char *	liq_name;
    char *	liq_color;
    sh_int      liq_affect[3];     /* 1= drunk  2=food  3=thirst */
};



/*
 * Extra description data for a room or object.
 */
struct	extra_descr_data
{
    EXTRA_DESCR_DATA *next;	/* Next in list                     */
    char *keyword;              /* Keyword in look/examine          */
    char *description;          /* What to see                      */
};



/*
 * Prototype for an object.         OBJIND
 */
struct	obj_index_data
{
    OBJ_INDEX_DATA *	next;
    EXTRA_DESCR_DATA *	extra_descr;
    AFFECT_DATA *	affected;
    AREA_DATA *		area;
    char *		name;
    char *		short_descr;
    char *              description;
    char *              action_descr;
    int                 vnum;
    sh_int		item_type;
    sh_int              timer;
    sh_int		extra_flags;
    int                 wear_flags;
    sh_int		count;
    sh_int		weight;
    sh_int              level;
    int                 cost;
    int                 value   [10];
};



/*
 * One object.                            OBDAT
 */
struct	obj_data
{
    OBJ_DATA *          next;
    OBJ_DATA *		next_content;
    OBJ_DATA *		contains;
    OBJ_DATA *		in_obj;
    CHAR_DATA *		carried_by;
    EXTRA_DESCR_DATA *	extra_descr;
    AFFECT_DATA *	affected;
    OBJ_INDEX_DATA *	pIndexData;
    ROOM_INDEX_DATA *	in_room;
    char *		name;
    char *		short_descr;
    char *		description;
    char *              action_descr;
    sh_int              item_type;
    sh_int		extra_flags;
    sh_int		wear_flags;
    sh_int              wear_loc;
    sh_int		weight;
    int			cost;
    sh_int		level;
    sh_int		timer;
    int                 value   [10];
};



/*
 * Exit data.
 */
struct	exit_data
{
    ROOM_INDEX_DATA *	to_room;
    EXIT_DATA *         next;
    int                 vnum;
    sh_int		exit_info;
    int                 key;
    char *		keyword;
    char *		description;
    sh_int              rs_flags;
};



/*
 * Reset commands:
 *   '*': comment
 *   'M': read a mobile 
 *   'O': read an object  (figures out where to put it)
 */

/*
 * Area-reset definition.
 */
struct	reset_data
{
    RESET_DATA *	next;
    char                command; /* M=Mob O=Obj                              */
    sh_int              rs_vnum; /* vnum of mob/obj to load                  */
    int                 loc;     /* If mob = max mobs else wear_loc or below */
    sh_int              percent; /* chance it will load                      */
    sh_int              vnum;
};


#define RESET_LOC_INOBJ    -3      /* object loads as if a content of obj    */
#define RESET_LOC_ONOBJ    -4      /* object loads as if sitting on obj      */
#define RESET_LOC_INROOM   -5      /* just let it load in the room           */
#define RESET_LOC_PREVOBJ  -6      /* get out! */


/*
 * Area definition.
 */
struct	area_data
{
    AREA_DATA *		next;
    char *		name;
    char *              repop;
    int                 recall_loc;
    sh_int              area_flags;
    sh_int              security;
    char *              builders;
    int                 lvnum;
    int                 uvnum;
    sh_int		age;
    sh_int		nplayer;
    char *              filename;
    int                 vnum;
};



/*
 * Room type.                                       ROOMIND
 */
struct	room_index_data
{
    ROOM_INDEX_DATA *	next;
    RESET_DATA *        reset_first;
    RESET_DATA *        reset_last;
    CHAR_DATA *		people;
    OBJ_DATA *		contents;
    EXTRA_DESCR_DATA *	extra_descr;
    AREA_DATA *		area;
    EXIT_DATA *         exit    [MAX_DIR];
    char *		name;
    char *		description;
    int                 vnum;
    int                 room_flags;
    sh_int		light;
    sh_int		sector_type;
};





/*
 * Mana types.
 * These are bits for GEMs, these are also used to check if a spell needs
 * that certain mana type.  Used in def.c under skill defines.
 */
#define MANA_ANY           -1
#define MANA_NONE           0
#define MANA_EARTH          1
#define MANA_AIR            2
#define MANA_FIRE           4
#define MANA_WATER          8


/*
 *  Target types.
 */
#define TAR_IGNORE		    0
#define TAR_CHAR_OFFENSIVE	    1
#define TAR_CHAR_DEFENSIVE	    2
#define TAR_CHAR_SELF		    3
#define TAR_OBJ_INV		    4



/*
 * Skills include spells as a particular case.
 */
struct	skill_type
{
    char *	name;			/* Name of skill		*/
    sh_int      skill_level[MAX_CLASS]; /* Level needed                 */
    LEARN_FUN * learn_fun;              /* Learn pointer (when needed)  */
    SPELL_FUN *	spell_fun;		/* Spell pointer (for spells)	*/
    sh_int	target;			/* Legal targets		*/
    sh_int	minimum_position;	/* Position for caster / user	*/
    sh_int *	pgsn;			/* Pointer to associated gsn	*/
    sh_int	slot;			/* Slot for #OBJECT loading	*/
    sh_int      mana;                   /* Minimum mana used            */
    sh_int      mana_type;              /* See MANA_x defines           */
    sh_int      max_prac;               /* Max % gained in a practice   */
    sh_int	beats;			/* Waiting time after use	*/
    char *	noun_damage;		/* Damage message		*/
    char *	msg_off;		/* Wear off message		*/
};



/*
 * These are skill_lookup return values for common skills and spells.
 */
extern	sh_int	gsn_backstab;
extern	sh_int	gsn_dodge;
extern	sh_int	gsn_hide;
extern	sh_int	gsn_peek;
extern	sh_int	gsn_pick_lock;
extern	sh_int	gsn_sneak;
extern	sh_int	gsn_steal;

extern  sh_int  gsn_track;

extern	sh_int	gsn_disarm;
extern	sh_int	gsn_enhanced_damage;
extern	sh_int	gsn_kick;
extern	sh_int	gsn_parry;
extern	sh_int	gsn_rescue;
extern	sh_int	gsn_second_attack;
extern	sh_int	gsn_third_attack;
extern  sh_int  gsn_dual_wield;

extern	sh_int	gsn_blindness;
extern	sh_int	gsn_charm_person;
extern	sh_int	gsn_curse;
extern	sh_int	gsn_invis;
extern	sh_int	gsn_mass_invis;
extern	sh_int	gsn_poison;
extern	sh_int	gsn_sleep;

extern  sh_int  lang_gsn[MAX_LANG];


/*
 * Utility macros.
 */
#define interpolate(l, v0, v32) ( v0 + l * (v32-v0) / 32 )
#define INTERPOLATE(min, max, percent)   ( min + (max - min /      \
                                           percent == 0 ? 1 : percent ) )
#define UMIN(a, b)		((a) < (b) ? (a) : (b))
#define UMAX(a, b)		((a) > (b) ? (a) : (b))
#define URANGE(a, b, c)		((b) < (a) ? (a) : ((b) > (c) ? (c) : (b)))
#define LOWER(c)		((c) >= 'A' && (c) <= 'Z' ? (c)+'a'-'A' : (c))
#define UPPER(c)		((c) >= 'a' && (c) <= 'z' ? (c)+'A'-'a' : (c))
#define IS_SET(flag, bit)	((flag) & (bit))
#define SET_BIT(var, bit)	((var) |= (bit))
#define REMOVE_BIT(var, bit)	((var) &= ~(bit))
#define TOGGLE_BIT(var, bit)    ((var) ^= (bit))
#define STR(dat, field)         (( (dat)->field != NULL                    \
                                             ? (dat)->field                \
                                             : (dat)->pIndexData->field ))
#define NST(pointer)            (pointer == NULL ? "" : pointer)

/*
 * Articles.
 */
#define HE_SHE(ch)           (((ch)->sex == SEX_MALE  ) ? "he"   :  \
                           (  ((ch)->sex == SEX_FEMALE) ? "she"  : "it" ) )
#define HIS_HER(ch)          (((ch)->sex == SEX_MALE  ) ? "his"  :  \
                           (  ((ch)->sex == SEX_FEMALE) ? "her"  : "its" ) )
#define HIM_HER(ch)          (((ch)->sex == SEX_MALE  ) ? "him"  :  \
                           (  ((ch)->sex == SEX_FEMALE) ? "her"  : "it" ) )

/*
 * Character macros.
 */
#define IS_NPC(ch)		(IS_SET((ch)->act, ACT_IS_NPC))
#define IS_IMMORTAL(ch)         (get_trust(ch) >= LEVEL_IMMORTAL)
#define IS_HERO(ch)		(get_trust(ch) >= LEVEL_HERO)
#define IS_AFFECTED(ch, sn)	(IS_SET((ch)->affected_by, (sn)))

#define IS_GOOD(ch)		(ch->alignment >= 350)
#define IS_EVIL(ch)		(ch->alignment <= -350)
#define IS_NEUTRAL(ch)		(!IS_GOOD(ch) && !IS_EVIL(ch))

#define IS_AWAKE(ch)		(ch->position > POS_SLEEPING)
#define GET_AC(ch)		((ch)->armor				    \
				    + ( IS_AWAKE(ch)			    \
				    ? dex_app[get_curr_dex(ch)].defensive   \
				    : 0 ))
#define GET_HITROLL(ch)		((ch)->hitroll+str_app[get_curr_str(ch)].tohit)
#define GET_DAMROLL(ch)		((ch)->damroll+str_app[get_curr_str(ch)].todam)

#define IS_OUTSIDE(ch)		(!IS_SET(				    \
				    (ch)->in_room->room_flags,		    \
				    ROOM_INDOORS))

#define WAIT_STATE(ch, npulse)  ((ch)->wait = UMAX((ch)->wait, (npulse)))

#define MANA_COST(ch, sn)       (IS_NPC(ch) ? 0 : UMAX (                    \
				skill_table[sn].min_mana,                   \
				100 / (2 + ch->level -                      \
				skill_table[sn].skill_level[ch->class] ) ) )

#define STRING_HITS(ch)         (percent_hit[ URANGE(0,                     \
                                     PERCENTAGE((ch)->hit, (ch)->max_hit)   \
                                                   ,101)/10 ]  )            \

#define STRING_MOVES(ch)        (percent_tired[ URANGE(0,                   \
                                     PERCENTAGE((ch)->move, (ch)->max_move) \
                                                   ,101)/10 ]  )
#define HAS_SCRIPT(ch)          ( IS_NPC(ch) && ch->triggers != NULL )
#define FIND_EXP(lv, r)         ( race_table[r].exp_mod != 0 ?              \
                                  exptable[URANGE(0,lv+1,MAX_LEVEL)] +      \
                                  (exptable[URANGE(0,lv+1,MAX_LEVEL)] /     \
                                  race_table[r].exp_mod) :                  \
                                  exptable[URANGE(0,lv+1,MAX_LEVEL)] )


/*
 * Object macros.
 */
#define CAN_WEAR(obj, part)     (IS_SET((obj)->wear_flags,  part))
#define IS_OBJ_STAT(obj, stat)  (IS_SET((obj)->extra_flags, stat))
#define NOT_WORN( obj )         ((obj)->wear_loc == WEAR_NONE   ||     \
                                 (obj)->wear_loc == WEAR_HOLD_1 ||     \
                                 (obj)->wear_loc == WEAR_HOLD_2 ||     \
                                 (obj)->wear_loc == WEAR_BELT_1 ||     \
                                 (obj)->wear_loc == WEAR_BELT_2 ||     \
                                 (obj)->wear_loc == WEAR_BELT_3 ||     \
                                 (obj)->wear_loc == WEAR_BELT_4 ||     \
                                 (obj)->wear_loc == WEAR_BELT_5    )
#define IS_LIT( obj )           ( (obj)->value[0] > 0 &&               \
                                 IS_SET((obj)->value[3], LIGHT_LIT) )
#define VAL_SET(obj, num, bit)  (IS_SET((obj)->value[num], bit))

/*
 * Description macros.
 */
#define NAME( ch )              (( !IS_NPC( ch ) ? (ch)->name              \
                                                 : STR(ch, short_descr) ))

#define PERS(ch, looker)     ( can_see( looker, (ch) ) ? NAME(ch) : "someone" )

/*
 * Other macros.
 */
#define NOTIFY(buf, lvl, tog)       ( global( buf, lvl, tog, WIZ_NOTIFY ) )


/*
 * Structure for a command in the command lookup table.
 */
struct	cmd_type
{
    char * const	name;
    DO_FUN *            do_fun;
    sh_int		position;
    sh_int		level;
    sh_int		log;
};



/*
 * Structure for a social in the socials table.  (Read from areas)
 */
struct	social_type
{
    char      name[20];
    char *    char_no_arg;
    char *    others_no_arg;
    char *    char_found;
    char *    others_found;
    char *    vict_found;
    char *    char_not_found;
    char *    char_auto;
    char *    others_auto;
};



/*
 * Global constants.
 */
extern	const	struct	str_app_type	str_app		[26];
extern	const	struct	int_app_type	int_app		[26];
extern	const	struct	wis_app_type	wis_app		[26];
extern	const	struct	dex_app_type	dex_app		[26];
extern	const	struct	con_app_type	con_app		[26];

extern	const	struct	class_type	class_table	[MAX_CLASS];
extern  const   struct  color_data      color_table     [];
extern  const   struct  race_type       race_table      [MAX_RACE];
extern  const   struct  coin_type       coin_table      [MAX_COIN];
extern  const   struct  attack_type     attack_table    [];
extern	const	struct	cmd_type	cmd_table	[];
extern	const	struct	liq_type	liq_table	[LIQ_MAX];
extern	const	struct	skill_type	skill_table	[MAX_SKILL];

extern  const           int              exptable       [MAX_LEVEL+1];

extern  struct  social_type             social_table    [MAX_SOCIALS];

extern  char *  const                   percent_hit     [];
extern  char *  const                   percent_tired   [];
extern  char *  const                   lang_name       [MAX_LANG];

#define MAX_COLOR_LIST             18
#define MAX_CLOTH_LIST              7

extern  char *  const                   color_list      [MAX_COLOR_LIST];
extern  char *  const                   cloth_list      [MAX_CLOTH_LIST];

extern  char *  const                   dir_name        [];
extern  char *  const                   dir_rev         [];
extern  const            sh_int         rev_dir         [];
extern  const            sh_int         movement_loss   [SECT_MAX];

/*
 * Global variables.
 */
extern		HELP_DATA	  *	help_first;
extern		SHOP_DATA	  *	shop_first;

extern		BAN_DATA	  *	ban_list;
extern		CHAR_DATA	  *	char_list;
extern		DESCRIPTOR_DATA   *	descriptor_list;
extern		OBJ_DATA	  *	object_list;

extern          AFFECT_DATA       *     affect_free;      /* Unused Alloc AF */
extern          ATTACK_DATA       *     attack_free;
extern          RESET_DATA        *     reset_free;
extern          SCRIPT_DATA       *     script_free;
extern		BAN_DATA	  *	ban_free;
extern		CHAR_DATA	  *	char_free;
extern		DESCRIPTOR_DATA	  *	descriptor_free;
extern		EXTRA_DESCR_DATA  *	extra_descr_free;
extern		NOTE_DATA	  *	note_free;
extern		OBJ_DATA	  *	obj_free;
extern		PC_DATA		  *	pcdata_free;
extern          TRIGGER_DATA      *     trigger_free;
extern          SCRIPT_DATA       *     script_free;
extern          VARIABLE_DATA     *     variable_free;

extern		char			bug_buf		[];
extern		time_t			current_time;
extern		bool			fLogAll;
extern		FILE *			fpReserve;
extern		KILL_DATA		kill_table	[];
extern		char			log_buf		[];
extern		TIME_INFO_DATA		time_info;
extern		WEATHER_DATA		weather_info;

extern          MOB_INDEX_DATA *        mob_index_hash  [MAX_KEY_HASH];
extern          OBJ_INDEX_DATA *        obj_index_hash  [MAX_KEY_HASH];
extern          ROOM_INDEX_DATA *       room_index_hash [MAX_KEY_HASH];
extern          char *                  string_hash     [MAX_KEY_HASH];
extern          AREA_DATA *             area_first;
extern          AREA_DATA *             area_last;
extern          int                     top_affect;
extern          int                     top_area;
extern          int                     top_ed;
extern          int                     top_exit;
extern          int                     top_help;
extern          int                     top_mob_index;
extern          int                     top_obj_index;
extern          int                     top_reset;
extern          int                     top_room;
extern          int                     top_shop;

extern          int                     top_vnum_mob;
extern          int                     top_vnum_obj;
extern          int                     top_vnum_room;

extern          char                    str_empty       [1];

extern          int                     FORCE_LEVEL;
extern          int                     LOG_LEVEL;

/*
 * Command functions.
 * Defined in act_*.c (mostly).
 */
DECLARE_DO_FUN( do_ansi         );     /* NC */
DECLARE_DO_FUN(	do_advance	);
DECLARE_DO_FUN(	do_allow	);
DECLARE_DO_FUN(	do_answer	);
DECLARE_DO_FUN(	do_areas	);
DECLARE_DO_FUN(	do_at		);
DECLARE_DO_FUN(	do_auction	);
DECLARE_DO_FUN( do_auto         );
DECLARE_DO_FUN( do_autosac      );
DECLARE_DO_FUN( do_assist       );     /* NC */
DECLARE_DO_FUN( do_autosplit    );     /* NC */
DECLARE_DO_FUN( do_autoloot     );
DECLARE_DO_FUN( do_autoexit     );
DECLARE_DO_FUN( do_autogold     );     /* NC */
DECLARE_DO_FUN(	do_backstab	);
DECLARE_DO_FUN(	do_bamfin	);
DECLARE_DO_FUN(	do_bamfout	);
DECLARE_DO_FUN(	do_ban		);
DECLARE_DO_FUN( do_blank        );
DECLARE_DO_FUN( do_bounty       );     /* NC */
DECLARE_DO_FUN( do_brief        );
DECLARE_DO_FUN(	do_brandish	);
DECLARE_DO_FUN( do_buck         );     /* NC */
DECLARE_DO_FUN(	do_bug		);
DECLARE_DO_FUN(	do_buy		);
DECLARE_DO_FUN(	do_cast		);
DECLARE_DO_FUN(	do_channels	);
DECLARE_DO_FUN( do_gossip       );
DECLARE_DO_FUN(	do_close	);
DECLARE_DO_FUN(	do_commands	);
DECLARE_DO_FUN(	do_compare	);
DECLARE_DO_FUN(	do_config	);
DECLARE_DO_FUN(	do_consider	);
DECLARE_DO_FUN(	do_credits	);
DECLARE_DO_FUN(	do_deny		);
DECLARE_DO_FUN( do_deposit      );     /* NC */
DECLARE_DO_FUN(	do_description	);
DECLARE_DO_FUN(	do_disarm	);
DECLARE_DO_FUN(	do_disconnect	);
DECLARE_DO_FUN( do_dismount     );     /* NC */
DECLARE_DO_FUN(	do_down		);
DECLARE_DO_FUN( do_draw         );     /* NC */
DECLARE_DO_FUN(	do_drink	);
DECLARE_DO_FUN(	do_drop		);
DECLARE_DO_FUN(	do_east		);
DECLARE_DO_FUN(	do_eat		);
DECLARE_DO_FUN(	do_echo		);
DECLARE_DO_FUN(	do_emote	);
DECLARE_DO_FUN( do_enter        );     /* NC */
DECLARE_DO_FUN( do_equipment    );
DECLARE_DO_FUN( do_examine      );
DECLARE_DO_FUN(	do_exits	);
DECLARE_DO_FUN( do_extinguish   );     /* NC */
DECLARE_DO_FUN(	do_fill		);
DECLARE_DO_FUN( do_find         );     /* NC */
DECLARE_DO_FUN(	do_flee		);
DECLARE_DO_FUN(	do_follow	);
DECLARE_DO_FUN(	do_force	);
DECLARE_DO_FUN(	do_freeze	);
DECLARE_DO_FUN(	do_get		);
DECLARE_DO_FUN(	do_give		);
DECLARE_DO_FUN(	do_goto		);
DECLARE_DO_FUN(	do_group	);
DECLARE_DO_FUN(	do_gtell	);
DECLARE_DO_FUN(	do_help		);
DECLARE_DO_FUN(	do_hide		);
DECLARE_DO_FUN(	do_holylight	);
DECLARE_DO_FUN(	do_idea		);
DECLARE_DO_FUN(	do_immtalk	);
DECLARE_DO_FUN( do_index        );     /* NC */
DECLARE_DO_FUN(	do_inventory	);
DECLARE_DO_FUN(	do_invis	);
DECLARE_DO_FUN(	do_kick		);
DECLARE_DO_FUN(	do_kill		);
DECLARE_DO_FUN( do_learn        );     /* NC */
DECLARE_DO_FUN( do_levels       );     /* NC */
DECLARE_DO_FUN(	do_list		);
DECLARE_DO_FUN( do_light        );     /* NC */
DECLARE_DO_FUN( do_load         );     /* NC */
DECLARE_DO_FUN( do_lock         );
DECLARE_DO_FUN(	do_log		);
DECLARE_DO_FUN(	do_look		);
DECLARE_DO_FUN(	do_memory	);
DECLARE_DO_FUN(	do_mfind	);
DECLARE_DO_FUN(	do_mload	);
DECLARE_DO_FUN( do_mount        );     /* NC */
DECLARE_DO_FUN(	do_mset		);
DECLARE_DO_FUN(	do_mstat	);
DECLARE_DO_FUN(	do_mwhere	);
DECLARE_DO_FUN(	do_murde	);
DECLARE_DO_FUN(	do_murder	);
DECLARE_DO_FUN(	do_music	);
DECLARE_DO_FUN( do_nwhere       );     /* NC */
DECLARE_DO_FUN(	do_noemote	);
DECLARE_DO_FUN(	do_north	);
DECLARE_DO_FUN(	do_note		);
DECLARE_DO_FUN(	do_notell	);
DECLARE_DO_FUN( do_notify       );     /* NC */
DECLARE_DO_FUN( do_nw           );     /* NC */
DECLARE_DO_FUN( do_ne           );     /* NC */
DECLARE_DO_FUN( do_sw           );     /* NC */
DECLARE_DO_FUN( do_se           );     /* NC */
DECLARE_DO_FUN(	do_ofind	);
DECLARE_DO_FUN(	do_oload	);
DECLARE_DO_FUN(	do_open		);
DECLARE_DO_FUN(	do_order	);
DECLARE_DO_FUN(	do_oset		);
DECLARE_DO_FUN(	do_ostat	);
DECLARE_DO_FUN( do_owhere       );
DECLARE_DO_FUN( do_pagelen      );
DECLARE_DO_FUN( do_password     );                
DECLARE_DO_FUN( do_prompt       );
DECLARE_DO_FUN(	do_peace	);
DECLARE_DO_FUN(	do_pick		);
DECLARE_DO_FUN(	do_pose		);
DECLARE_DO_FUN(	do_practice	);
DECLARE_DO_FUN( do_pset         );
DECLARE_DO_FUN( do_pstat        );
DECLARE_DO_FUN(	do_purge	);
DECLARE_DO_FUN(	do_put		);
DECLARE_DO_FUN(	do_quaff	);
DECLARE_DO_FUN(	do_question	);
DECLARE_DO_FUN(	do_qui		);
DECLARE_DO_FUN(	do_quit		);
DECLARE_DO_FUN(	do_reboo	);
DECLARE_DO_FUN(	do_reboot	);
DECLARE_DO_FUN(	do_recall	);
DECLARE_DO_FUN(	do_recho	);
DECLARE_DO_FUN(	do_recite	);
DECLARE_DO_FUN( do_reload       );
DECLARE_DO_FUN(	do_remove	);
DECLARE_DO_FUN(	do_rent		);
DECLARE_DO_FUN(	do_reply	);
DECLARE_DO_FUN(	do_report	);
DECLARE_DO_FUN(	do_rescue	);
DECLARE_DO_FUN(	do_rest		);
DECLARE_DO_FUN(	do_restore	);
DECLARE_DO_FUN(	do_return	);
DECLARE_DO_FUN( do_rfind        );     /* NC */
DECLARE_DO_FUN(	do_rstat	);
DECLARE_DO_FUN(	do_sacrifice	);
DECLARE_DO_FUN(	do_save		);
DECLARE_DO_FUN(	do_say		);
DECLARE_DO_FUN(	do_score	);
DECLARE_DO_FUN(	do_sell		);
DECLARE_DO_FUN( do_sheath       );     /* NC */
DECLARE_DO_FUN( do_shoot        );     /* NC */
DECLARE_DO_FUN(	do_shout	);
DECLARE_DO_FUN(	do_shutdow	);
DECLARE_DO_FUN(	do_shutdown	);
DECLARE_DO_FUN(	do_silence	);
DECLARE_DO_FUN(	do_sla		);
DECLARE_DO_FUN(	do_slay		);
DECLARE_DO_FUN(	do_sleep	);
DECLARE_DO_FUN(	do_slookup	);
DECLARE_DO_FUN(	do_sneak	);
DECLARE_DO_FUN(	do_snoop	);
DECLARE_DO_FUN(	do_socials	);
DECLARE_DO_FUN(	do_south	);
DECLARE_DO_FUN( do_speak        );     /* NC */
DECLARE_DO_FUN( do_spells       );     /* NC */
DECLARE_DO_FUN(	do_split	);
DECLARE_DO_FUN( do_skills       );     /* NC */
DECLARE_DO_FUN( do_set          );
DECLARE_DO_FUN(	do_sset		);
DECLARE_DO_FUN(	do_stand	);
DECLARE_DO_FUN( do_stat         );     /* NC */
DECLARE_DO_FUN(	do_steal	);
DECLARE_DO_FUN( do_string       );
DECLARE_DO_FUN(	do_switch	);
DECLARE_DO_FUN(	do_tell		);
DECLARE_DO_FUN(	do_time		);
DECLARE_DO_FUN( do_title        );
DECLARE_DO_FUN( do_track        );     /* NC */
DECLARE_DO_FUN(	do_train	);
DECLARE_DO_FUN(	do_transfer	);
DECLARE_DO_FUN(	do_trust	);
DECLARE_DO_FUN(	do_typo		);
DECLARE_DO_FUN(	do_unlock	);
DECLARE_DO_FUN(	do_up		);
DECLARE_DO_FUN(	do_users	);
DECLARE_DO_FUN(	do_value	);
DECLARE_DO_FUN(	do_visible	);
DECLARE_DO_FUN(	do_wake		);
DECLARE_DO_FUN(	do_wear		);
DECLARE_DO_FUN(	do_weather	);
DECLARE_DO_FUN(	do_west		);
DECLARE_DO_FUN(	do_where	);
DECLARE_DO_FUN(	do_who		);
DECLARE_DO_FUN( do_withdraw     );     /* NC */
DECLARE_DO_FUN(	do_wimpy	);
DECLARE_DO_FUN(	do_wizhelp	);
DECLARE_DO_FUN( do_wizify       );
DECLARE_DO_FUN(	do_wizlock	);
DECLARE_DO_FUN( do_wizlist      );
DECLARE_DO_FUN( do_wizprompt    );
DECLARE_DO_FUN(	do_yell		);
DECLARE_DO_FUN(	do_zap		);

/* Racial abilities commands! */
DECLARE_DO_FUN( do_infravision  );     /* NC */
DECLARE_DO_FUN( do_meld         );     /* NC */
DECLARE_DO_FUN( do_fly          );     /* NC */
DECLARE_DO_FUN( do_breath       );     /* NC */

/* online creation commands */
DECLARE_DO_FUN( do_asave        );     /* NC */
DECLARE_DO_FUN( do_astat        );
DECLARE_DO_FUN( do_mindex       );     /* NC */
DECLARE_DO_FUN( do_oindex       );     /* NC */

DECLARE_DO_FUN( do_aedit        );     /* NC */
DECLARE_DO_FUN( do_redit        );     /* NC */
DECLARE_DO_FUN( do_oedit        );     /* NC */
DECLARE_DO_FUN( do_medit        );     /* NC */

DECLARE_DO_FUN( do_resets       );     /* NC */
DECLARE_DO_FUN( do_script       );     /* NC */


/*
 * Spell functions.
 * Defined in magic.c.
 */
DECLARE_SPELL_FUN(	spell_null		);
DECLARE_SPELL_FUN(	spell_acid_blast	);
DECLARE_SPELL_FUN(	spell_armor		);
DECLARE_SPELL_FUN(	spell_bless		);
DECLARE_SPELL_FUN(	spell_blindness		);
DECLARE_SPELL_FUN(	spell_burning_hands	);
DECLARE_SPELL_FUN(	spell_call_lightning	);
DECLARE_SPELL_FUN(	spell_cause_critical	);
DECLARE_SPELL_FUN(	spell_cause_light	);
DECLARE_SPELL_FUN(	spell_cause_serious	);
DECLARE_SPELL_FUN(	spell_change_sex	);
DECLARE_SPELL_FUN(      spell_channeling        );
DECLARE_SPELL_FUN(	spell_charm_person	);
DECLARE_SPELL_FUN(	spell_chill_touch	);
DECLARE_SPELL_FUN(	spell_colour_spray	);
DECLARE_SPELL_FUN(	spell_continual_light	);
DECLARE_SPELL_FUN(	spell_control_weather	);
DECLARE_SPELL_FUN(	spell_create_food	);
DECLARE_SPELL_FUN(	spell_create_spring	);
DECLARE_SPELL_FUN(	spell_create_water	);
DECLARE_SPELL_FUN(	spell_cure_blindness	);
DECLARE_SPELL_FUN(	spell_cure_critical	);
DECLARE_SPELL_FUN(	spell_cure_light	);
DECLARE_SPELL_FUN(	spell_cure_poison	);
DECLARE_SPELL_FUN(	spell_cure_serious	);
DECLARE_SPELL_FUN(	spell_curse		);
DECLARE_SPELL_FUN(	spell_detect_evil	);
DECLARE_SPELL_FUN(	spell_detect_hidden	);
DECLARE_SPELL_FUN(	spell_detect_invis	);
DECLARE_SPELL_FUN(	spell_detect_magic	);
DECLARE_SPELL_FUN(	spell_detect_poison	);
DECLARE_SPELL_FUN(	spell_dispel_evil	);
DECLARE_SPELL_FUN(	spell_dispel_magic	);
DECLARE_SPELL_FUN(	spell_earthquake	);
DECLARE_SPELL_FUN(	spell_enchant_weapon	);
DECLARE_SPELL_FUN(	spell_energy_drain	);
DECLARE_SPELL_FUN(	spell_faerie_fire	);
DECLARE_SPELL_FUN(	spell_faerie_fog	);
DECLARE_SPELL_FUN(	spell_fireball		);
DECLARE_SPELL_FUN(	spell_flamestrike	);
DECLARE_SPELL_FUN(	spell_fly		);
DECLARE_SPELL_FUN(	spell_gate		);
DECLARE_SPELL_FUN(	spell_general_purpose	);
DECLARE_SPELL_FUN(	spell_giant_strength	);
DECLARE_SPELL_FUN(	spell_harm		);
DECLARE_SPELL_FUN(	spell_heal		);
DECLARE_SPELL_FUN(	spell_high_explosive	);
DECLARE_SPELL_FUN(	spell_identify		);
DECLARE_SPELL_FUN(	spell_infravision	);
DECLARE_SPELL_FUN(	spell_invis		);
DECLARE_SPELL_FUN(	spell_know_alignment	);
DECLARE_SPELL_FUN(	spell_lightning_bolt	);
DECLARE_SPELL_FUN(	spell_locate_object	);
DECLARE_SPELL_FUN(	spell_magic_missile	);
DECLARE_SPELL_FUN(	spell_mass_invis	);
DECLARE_SPELL_FUN(	spell_pass_door		);
DECLARE_SPELL_FUN(	spell_poison		);
DECLARE_SPELL_FUN(	spell_protection	);
DECLARE_SPELL_FUN(	spell_refresh		);
DECLARE_SPELL_FUN(	spell_remove_curse	);
DECLARE_SPELL_FUN(	spell_sanctuary		);
DECLARE_SPELL_FUN(	spell_shocking_grasp	);
DECLARE_SPELL_FUN(	spell_shield		);
DECLARE_SPELL_FUN(	spell_sleep		);
DECLARE_SPELL_FUN(	spell_stone_skin	);
DECLARE_SPELL_FUN(	spell_summon		);
DECLARE_SPELL_FUN(	spell_teleport		);
DECLARE_SPELL_FUN(	spell_ventriloquate	);
DECLARE_SPELL_FUN(	spell_weaken		);
DECLARE_SPELL_FUN(	spell_word_of_recall	);
DECLARE_SPELL_FUN(	spell_acid_breath	);
DECLARE_SPELL_FUN(	spell_fire_breath	);
DECLARE_SPELL_FUN(	spell_frost_breath	);
DECLARE_SPELL_FUN(	spell_gas_breath	);
DECLARE_SPELL_FUN(	spell_lightning_breath	);

DECLARE_SPEC_FUN(       spec_breath_any         );
DECLARE_SPEC_FUN(	spec_breath_acid	);
DECLARE_SPEC_FUN(	spec_breath_fire	);
DECLARE_SPEC_FUN(	spec_breath_frost	);
DECLARE_SPEC_FUN(	spec_breath_gas		);
DECLARE_SPEC_FUN(	spec_breath_lightning	);
DECLARE_SPEC_FUN(	spec_cast_adept		);
DECLARE_SPEC_FUN(	spec_cast_cleric	);
DECLARE_SPEC_FUN(	spec_cast_judge		);
DECLARE_SPEC_FUN(	spec_cast_mage		);
DECLARE_SPEC_FUN(	spec_cast_undead	);
DECLARE_SPEC_FUN(	spec_executioner	);
DECLARE_SPEC_FUN(	spec_fido		);
DECLARE_SPEC_FUN(	spec_guard		);
DECLARE_SPEC_FUN(	spec_janitor		);
DECLARE_SPEC_FUN(	spec_mayor		);
DECLARE_SPEC_FUN(	spec_poison		);
DECLARE_SPEC_FUN(	spec_thief		);

DECLARE_HIT_FUN(        hit_vorpal              );
DECLARE_HIT_FUN(        hit_suck_disarm         );


/*
 * OS-dependent declarations.
 * These are all very standard library functions,
 *   but some systems have incomplete or non-ansi header files.
 */
#if	defined(_AIX)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(apollo)
int	atoi		args( ( const char *string ) );
void *	calloc		args( ( unsigned nelem, size_t size ) );
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(hpux)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(interactive)
#endif

#if	defined(linux)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(macintosh)
#define NOCRYPT
#if	defined(unix)
#undef	unix
#endif
#endif

#if	defined(MIPS_OS)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(MSDOS)
#define NOCRYPT
#if	defined(unix)
#undef	unix
#endif
#endif

#if	defined(NeXT)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif

#if	defined(sequent)
char *	crypt		args( ( const char *key, const char *salt ) );
int	fclose		args( ( FILE *stream ) );
int	fprintf		args( ( FILE *stream, const char *format, ... ) );
int	fread		args( ( void *ptr, int size, int n, FILE *stream ) );
int	fseek		args( ( FILE *stream, long offset, int ptrname ) );
void	perror		args( ( const char *s ) );
int	ungetc		args( ( int c, FILE *stream ) );
#endif

#if	defined(sun)
char *	crypt		args( ( const char *key, const char *salt ) );
int	fclose		args( ( FILE *stream ) );
int	fprintf		args( ( FILE *stream, const char *format, ... ) );
#if 	defined(SYSV)
size_t 	fread		args( ( void *ptr, size_t size, size_t n, 
				FILE *stream ) );
#else
int	fread		args( ( void *ptr, int size, int n, FILE *stream ) );
#endif
int	fseek		args( ( FILE *stream, long offset, int ptrname ) );
void	perror		args( ( const char *s ) );
int	ungetc		args( ( int c, FILE *stream ) );
#endif

#if	defined(ultrix)
char *	crypt		args( ( const char *key, const char *salt ) );
#endif



/*
 * The crypt(3) function is not available on some operating systems.
 * In particular, the U.S. Government prohibits its export from the
 *   United States to foreign countries.
 * Turn on NOCRYPT to keep passwords in plain text.
 */
#if	defined(NOCRYPT)
#define crypt(s1, s2)	(s1)
#endif



/*
 * Data files used by the server.
 *
 * AREA_LIST contains a list of areas to boot.
 * All files are read in completely at bootup.
 * Most output files (bug, idea, typo, shutdown) are append-only.
 *
 * The NULL_FILE is held open so that we have a stream handle in reserve,
 *   so players can go ahead and telnet to all the other descriptors.
 * Then we close it whenever we need to open a file (e.g. a save file).
 */
#if defined(macintosh)
#define PLAYER_DIR	""		/* Player files			*/
#define NULL_FILE	"proto.are"	/* To reserve one stream	*/
#endif

#if defined(MSDOS)
#define PLAYER_DIR	""		/* Player files                 */
#define NULL_FILE	"nul"		/* To reserve one stream	*/
#endif

#if defined(unix)
#define PLAYER_DIR	"../player/"	/* Player files			*/
#define NULL_FILE       "/dev/null"     /* To reserve one stream        */
#endif

#if defined(linux)
#define PLAYER_DIR	"../player/"	/* Player files			*/
#define NULL_FILE	"/dev/null"	/* To reserve one stream	*/
#endif

#define AREA_LIST       "area.lst"      /* List of areas                */

#define BUG_FILE	"bugs.txt"      /* For 'bug' and bug( )		*/
#define IDEA_FILE	"ideas.txt"	/* For 'idea'			*/
#define TYPO_FILE	"typos.txt"     /* For 'typo'			*/
#define SHUTDOWN_FILE	"shutdown.txt"	/* For 'shutdown'		*/


/*
 * Our function prototypes.
 * One big lump ... this is every function in Merc.
 */
#define CD	CHAR_DATA
#define MID	MOB_INDEX_DATA
#define OD	OBJ_DATA
#define OID	OBJ_INDEX_DATA
#define RID	ROOM_INDEX_DATA
#define SF	SPEC_FUN
#define AD      AREA_DATA
#define VD      VARIABLE_DATA
#define RD      RESET_DATA
#define TD      TRIGGER_DATA
#define SD      SHOP_DATA
#define EDD     EXTRA_DESCR_DATA
#define AFD     AFFECT_DATA
#define ED      EXIT_DATA
#define ATD     ATTACK_DATA

/* act_comm.c */
void    add_follower    args( ( CHAR_DATA *ch, CHAR_DATA *master ) );
void	stop_follower	args( ( CHAR_DATA *ch ) );
void	die_follower	args( ( CHAR_DATA *ch ) );
bool	is_same_group	args( ( CHAR_DATA *ach, CHAR_DATA *bch ) );

/* act_info.c */
void	set_title	args( ( CHAR_DATA *ch, char *title ) );

/* act_move.c */
void	move_char	args( ( CHAR_DATA *ch, int door ) );

/* act_obj.c */
void            args( obj_resort( OBJ_DATA *obj ) );

/* act_wiz.c */
ROOM_INDEX_DATA *	find_location	args( ( CHAR_DATA *ch, char *arg ) );

/* act_race.c */
int     find_first_step args( ( ROOM_INDEX_DATA *src, ROOM_INDEX_DATA *target) );
char *  lang            args( ( CHAR_DATA *ch, char *words ) );

/* comm.c */
void	close_socket	args( ( DESCRIPTOR_DATA *dclose ) );
void    write_to_buffer args( ( DESCRIPTOR_DATA *d, const char *txt,
                                int length ) );
void    global          args( ( char *buf, int level, int toggler,
                                int toggler2 ) );
void	send_to_char	args( ( const char *txt, CHAR_DATA *ch ) );
void    page_to_char    args( ( const char *txt, CHAR_DATA *ch ) );
void    ansi_color      args( ( const char *txt, CHAR_DATA *ch ) );
void    show_string     args( ( DESCRIPTOR_DATA *d, char *input ) );
void	act		args( ( const char *format, CHAR_DATA *ch,
                             const void *arg1, const void *arg2, int type ) );

/* db.c */
void	boot_db		args( ( void ) );
void    fix_exits       args( ( void ) );
void	area_update	args( ( void ) );
void    room_update     args( ( void ) );
void    reset_room  args( ( ROOM_INDEX_DATA *pRoom ) );
CD *    create_mobile   args( ( MOB_INDEX_DATA *pMobIndex ) );
OD *	create_object	args( ( OBJ_INDEX_DATA *pObjIndex, int level ) );
void	clear_char	args( ( CHAR_DATA *ch ) );
void	free_char	args( ( CHAR_DATA *ch ) );
char *  get_extra_descr args( ( const char *name, EXTRA_DESCR_DATA *ed ) );
MID *	get_mob_index	args( ( int vnum ) );
OID *	get_obj_index	args( ( int vnum ) );
RID *	get_room_index	args( ( int vnum ) );
void    obj_strings     args( ( OBJ_DATA *obj ) );
void    mob_strings     args( ( CHAR_DATA *mob ) );
int	interpolate	args( ( int level, int value_00, int value_32 ) );
void	bug		args( ( const char *str, int param ) );
void	log_string	args( ( const char *str ) );
void	tail_chain	args( ( void ) );

/* fight.c */
bool    is_safe         args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
void    death_cry       args( ( CHAR_DATA *ch ) );
void	violence_update	args( ( void ) );
void	multi_hit	args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dt ) );
void	damage		args( ( CHAR_DATA *ch, CHAR_DATA *victim, int dam,
			    int dt ) );
void	update_pos	args( ( CHAR_DATA *victim ) );
void	stop_fighting	args( ( CHAR_DATA *ch, bool fBoth ) );
void    raw_kill        args( ( CHAR_DATA *victim ) );

/* handler.c */
int	get_trust	args( ( CHAR_DATA *ch ) );
int	get_age		args( ( CHAR_DATA *ch ) );
int	get_curr_str	args( ( CHAR_DATA *ch ) );
int	get_curr_int	args( ( CHAR_DATA *ch ) );
int	get_curr_wis	args( ( CHAR_DATA *ch ) );
int	get_curr_dex	args( ( CHAR_DATA *ch ) );
int	get_curr_con	args( ( CHAR_DATA *ch ) );
int	can_carry_n	args( ( CHAR_DATA *ch ) );
int	can_carry_w	args( ( CHAR_DATA *ch ) );
bool	is_name		args( ( const char *str, char *namelist ) );
void	affect_to_char	args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
void	affect_remove	args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
void	affect_strip	args( ( CHAR_DATA *ch, int sn ) );
bool	is_affected	args( ( CHAR_DATA *ch, int sn ) );
void	affect_join	args( ( CHAR_DATA *ch, AFFECT_DATA *paf ) );
void	char_from_room	args( ( CHAR_DATA *ch ) );
void	char_to_room	args( ( CHAR_DATA *ch, ROOM_INDEX_DATA *pRoomIndex ) );
void	obj_to_char	args( ( OBJ_DATA *obj, CHAR_DATA *ch ) );
void	obj_from_char	args( ( OBJ_DATA *obj ) );
int	apply_ac	args( ( OBJ_DATA *obj, int iWear ) );
OD *	get_eq_char	args( ( CHAR_DATA *ch, int iWear ) );
void	equip_char	args( ( CHAR_DATA *ch, OBJ_DATA *obj, int iWear ) );
OD *    get_item_held   args( ( CHAR_DATA *ch, int itype ) );
int     hand_empty      args( ( CHAR_DATA *ch ) );
int     belt_empty      args( ( CHAR_DATA *ch ) );
bool    unequip_char    args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
int	count_obj_list	args( ( OBJ_INDEX_DATA *obj, OBJ_DATA *list ) );
void	obj_from_room	args( ( OBJ_DATA *obj ) );
void	obj_to_room	args( ( OBJ_DATA *obj, ROOM_INDEX_DATA *pRoomIndex ) );
void	obj_to_obj	args( ( OBJ_DATA *obj, OBJ_DATA *obj_to ) );
void	obj_from_obj	args( ( OBJ_DATA *obj ) );
void	extract_obj	args( ( OBJ_DATA *obj ) );
void	extract_char	args( ( CHAR_DATA *ch, bool fPull ) );
CD *	get_char_room	args( ( CHAR_DATA *ch, char *argument ) );
CD *	get_char_world	args( ( CHAR_DATA *ch, char *argument ) );
OD *	get_obj_type	args( ( OBJ_INDEX_DATA *pObjIndexData ) );
OD *	get_obj_list	args( ( CHAR_DATA *ch, char *argument,
			    OBJ_DATA *list ) );
OD *    get_obj_carry   args( ( CHAR_DATA *ch, char *argument ) );
OD *	get_obj_wear	args( ( CHAR_DATA *ch, char *argument ) );
OD *    get_obj_inv     args( ( CHAR_DATA *ch, char *argument ) );
OD *    get_obj_held    args( ( CHAR_DATA *ch, char *argument ) );
OD *	get_obj_here	args( ( CHAR_DATA *ch, char *argument ) );
OD *	get_obj_world	args( ( CHAR_DATA *ch, char *argument ) );

OD *    create_money    args( ( int amount, int type ) );
void    merge_money     args( ( CHAR_DATA *ch ) );
void    create_amount   args( ( int amount, CHAR_DATA *pMob,
                                ROOM_INDEX_DATA *pRoom, OBJ_DATA *pObj ) );
int     tally_coins     args( ( CHAR_DATA *mob ) );
int     tally_one_coin  args( ( CHAR_DATA *mob, int type ) );
char *  name_amount     args( ( int amount ) );
void    strip_empty_money args( ( CHAR_DATA *ch ) );
char *  sub_coins       args( ( int amount, CHAR_DATA *ch ) );

int	get_obj_number	args( ( OBJ_DATA *obj ) );
int	get_obj_weight	args( ( OBJ_DATA *obj ) );
int     room_is_dark    args( ( ROOM_INDEX_DATA *pRoomIndex ) );
bool	room_is_private	args( ( ROOM_INDEX_DATA *pRoomIndex ) );
bool	can_see		args( ( CHAR_DATA *ch, CHAR_DATA *victim ) );
bool	can_see_obj	args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );
bool	can_drop_obj	args( ( CHAR_DATA *ch, OBJ_DATA *obj ) );

char *  get_extra_descr args( ( const char *name, EXTRA_DESCR_DATA *ed ) );
bool    use_tool        args( ( OBJ_DATA *obj, int bit ) );
int     PERCENTAGE      args( ( int amount, int max ) );

bool skill_check        args( ( CHAR_DATA *ch, int sn, int modifier ) );

/* interp.c */
void	interpret	args( ( CHAR_DATA *ch, char *argument ) );

/* magic.c */
int	skill_lookup	args( ( const char *name ) );
int	slot_lookup	args( ( int slot ) );
bool	saves_spell	args( ( int level, CHAR_DATA *victim ) );
void	obj_cast_spell	args( ( int sn, int level, CHAR_DATA *ch,
				    CHAR_DATA *victim, OBJ_DATA *obj ) );
/* ocreate.c */
void    aedit           args( ( CHAR_DATA *ch, char *argument ) );
void    redit           args( ( CHAR_DATA *ch, char *argument ) );
void    oedit           args( ( CHAR_DATA *ch, char *argument ) );
void    medit           args( ( CHAR_DATA *ch, char *argument ) );
AD *    get_area_data   args( ( int vnum ) );

/* save.c */
void	save_char_obj	args( ( CHAR_DATA *ch ) );
bool	load_char_obj	args( ( DESCRIPTOR_DATA *d, char *name ) );

/* script.c */
int     get_dir         args( ( char *arg ) );
char *  translate_variables      args( ( char *argument, CHAR_DATA *mob ) );
VD *    get_variable    args( ( char *var_name, CHAR_DATA *mob ) );
void    assign_variable args( ( char *var_name, char *value, CHAR_DATA *mob ));
char *  first_arg       args( ( char *argument, char *arg_first, bool fCase ));
void    act_trigger     args( ( CHAR_DATA *mob, char *command,
                            char *argument, char *from, char *to ) );
void    script_interpret args( ( CHAR_DATA *ch, TRIGGER_DATA *trigger ) );

/* string.c */
void    string_append   args( ( CHAR_DATA *ch, char **pString ) );
void	string_edit	args( ( CHAR_DATA *ch, char **pString ) );
void	string_add	args( ( CHAR_DATA *ch, char *argument ) );
char   *fix_string      args( ( const char *str ) );
void    string_add      args( ( CHAR_DATA *ch, char *argument ) );
bool    is_number       args( ( char *arg ) );
int     number_argument args( ( char *argument, char *arg ) );
char *  one_argument    args( ( char *argument, char *arg_first ) );
char *  one_argcase     args( ( char *argument, char *arg_first ) );
char *  is_are          args( ( char *buf ) );
char *  smash_arg       args( ( char *text, char *name ) );
char *  smash_article   args( ( char *text ) );
char *  wordwrap        args( ( char *text ) );
char *  format_string   args( ( char *oldstring /*, bool fSpace */ ) );
char *  replace_string  args( ( char *orig, char *old, char *new ) );
char *  string_replace  args( ( char * orig, char * old, char * new ) );
bool    str_cmp         args( ( const char *astr, const char *bstr ) );
bool    str_prefix      args( ( const char *astr, const char *bstr ) );
bool    str_infix       args( ( const char *astr, const char *bstr ) );
bool    str_suffix      args( ( const char *astr, const char *bstr ) );
char *  capitalize      args( ( const char *str ) );
void    append_file     args( ( CHAR_DATA *ch, char *file, char *str ) );
void    smash_tilde     args( ( char *str ) );
int     arg_count       args( ( char *argument ) );
char *  string_unpad    args( ( char * argument ) );
char *  string_proper   args( ( char * argument ) );
char *  strupr          args( ( char * s ) );
char *  strlwr          args( ( char * s ) );
char *  ansi_uppercase  args( ( char *txt) );

/* xrand.c */
int     number_fuzzy    args( ( int number ) );
int     number_range    args( ( int from, int to ) );
int     number_percent  args( ( void ) );
int     number_door     args( ( void ) );
int     number_bits     args( ( int width ) );
int     number_mm       args( ( void ) );
int     dice            args( ( int number, int size ) );

/* special.c */
SF *    spec_lookup     args( ( const char *name ) );
char *  sfun_lookup     args( ( SPEC_FUN *sfunc ) );

/* mem.c */
char    fread_letter    args( ( FILE *fp ) );
int     fread_number    args( ( FILE *fp ) );
char *  fread_string    args( ( FILE *fp ) );
char *  fread_string_eol args( ( FILE *fp ) );
void    fread_to_eol    args( ( FILE *fp ) );
char *  fread_word      args( ( FILE *fp ) );
void *  alloc_mem       args( ( int sMem ) );
void *  alloc_perm      args( ( int sMem ) );
void    free_mem        args( ( void *pMem, int sMem ) );
char *  str_dup         args( ( const char *str ) );

RD *    new_reset_data  args( ( void ) );
AD *    new_area        args( ( void ) );
EDD *   new_extra_descr args( ( void ) );
ED *    new_exit  args( ( void ) );
ATD *   new_attack args( ( void ) );
RID *   new_room_index  args( ( void ) );
AFD *   new_affect      args( ( void ) );
OID *   new_obj_index   args( ( void ) );
SD *    new_shop        args( ( void ) );
MID *   new_mob_index   args( ( void ) );
void    free_reset_data args( ( RESET_DATA *pReset ) );
void    free_area       args( ( AREA_DATA *pArea ) );
void    free_extra_descr args( ( EXTRA_DESCR_DATA *pExtra ) );
void    free_exit       args( ( EXIT_DATA *pExit ) );
void    free_attack     args( ( ATTACK_DATA *attack ) );
void    free_room_index args( ( ROOM_INDEX_DATA *pRoom ) );
void    free_affect     args( ( AFFECT_DATA* pAf ) );
void    free_obj_index  args( ( OBJ_INDEX_DATA *pObj ) );
void    free_shop       args( ( SHOP_DATA *pShop ) );
void    free_mob_index  args( ( MOB_INDEX_DATA *pMob ) );
void    free_trigger    args( ( TRIGGER_DATA *trig ) );
void    free_variable   args( ( VARIABLE_DATA *var ) );
void    free_script     args( ( SCRIPT_DATA *scr ) );
void    free_string     args( ( char *pstr ) );

/* bit.c */
char *  item_type_name  args( ( int item_type ) );
char *	affect_loc_name	args( ( int location ) );
char *	affect_bit_name	args( ( int vector ) );
char *	extra_bit_name	args( ( int extra_flags ) );
char *  room_bit_name   args( ( int room_flags ) );
char *  act_bit_name    args( ( int act ) );
char *  plr_bit_name    args( ( int act ) );
char *  wear_bit_name   args( ( int wear ) );
char *  wear_loc_name   args( ( int wearloc ) );
char *  sector_name     args( ( int sect ) );

int     item_name_type  args( ( char *name ) );
int     affect_name_loc args( ( char *name ) );
int     affect_name_bit args( ( char *buf ) );
int     extra_name_bit  args( ( char *buf ) );
int     room_name_bit   args( ( char *buf ) );
int     act_name_bit    args( ( char *buf ) );
int     wear_name_bit   args( ( char *buf ) );
int     wear_name_loc   args( ( char *buf ) );

/* update.c */
void	advance_level	args( ( CHAR_DATA *ch ) );
void	gain_exp	args( ( CHAR_DATA *ch, int gain ) );
void	gain_condition	args( ( CHAR_DATA *ch, int iCond, int value ) );
void    script_update   args( ( CHAR_DATA *ch, int timetype ) );
void	update_handler	args( ( void ) );

#undef	CD
#undef	MID
#undef	OD
#undef	OID
#undef	RID
#undef	SF
#undef  AD
#undef  VD
#undef  RD
#undef  TD
#undef  SD
#undef  EDD
#undef  AFD
#undef  ED
#undef  ATD


