<?php

/**
 * Mail Downloader plugin for Remository 3.53+ 
 * License : http://www.gnu.org/copyleft/gpl.html ver 2
 * @Copyright (C) 2011 Remository Software Limited
 * martin@remository.com
 * http://remository.com
 */

/**
 * Mail Downloader for Remository
 *
 * @package		Remository
 * @subpackage	Content
 * @since 		Remository 3.53+
 */

defined( '_VALID_MOS' ) OR defined ( '_JEXEC' ) OR die( 'Direct Access to this location is not allowed.' );

$cmsapi_addon_topdir = 'mambots/plugins/modules';
$cmsapi_addon_tops = explode('/', $cmsapi_addon_topdir);
$cmsapi_mydir = array_reverse(explode('/', str_replace('\\', '/', __FILE__)));
do $cmsapi_shifted = array_shift($cmsapi_mydir); while (!in_array($cmsapi_shifted, $cmsapi_addon_tops));
$cmsapi_absolute_path = implode('/', array_reverse($cmsapi_mydir));

require_once($cmsapi_absolute_path.'/components/com_remository/remository.interface.php');

// error_reporting(E_ALL);

if (defined('_JOOMLA_15PLUS')) {
	jimport( 'joomla.event.plugin' );
	jimport('joomla.html.parameter');

	class plgRemositoryMaildown extends JPlugin  {
		protected $plugin_type = 'remository';
	
		public function remositoryDoneDownload ($fileinfo, $len, $user, $repository, $database) {
		 	$worker = new remository_plugin_maildown();
		 	return $worker->remositoryDoneDownload ($this->params, $fileinfo, $len, $user, $repository, $database);
		}
	}
}
else {
	global $_MAMBOTS;	
	/** Register search function inside Mambo's API */
	$_MAMBOTS->registerFunction( 'remositoryDoneDownload', 'plgRemositoryMaildown' );
	
	function plgRemositoryMaildown ($published, $fileinfo, $len, $user, $repository, $database) {
	 	$worker = new remository_plugin_maildown();
		// Get parameters from Database
		$query = "SELECT params FROM #__mambots WHERE element = 'quickdown' AND folder = 'content'";
		$database->setQuery($query);
		$paramstring = $database->loadResult();
		$params = new mosParameters($paramstring);
	 	return $worker->remositoryDoneDownload ($params, $fileinfo, $len, $user, $repository, $database, $published);
	}
}

class remository_plugin_maildown {
	
	public function remositoryDoneDownload ($params, $fileinfo, $len, $user, $repository, $database, $published=true) {
		if ($user->id) {
			$text = $params->get('mailtext');
			if ($text) {
				$text = str_replace('{filetitle}', $fileinfo->filetitle, $text);
				$subject = $params->get('mailsubject');
				$repository = remositoryRepository::getInstance();
				$user->sendMailTo ($subject, $text, $repository->Sub_Mail_Alt_Addr, $repository->Sub_Mail_Alt_Name, $fileinfo);
			}
		}
	}
}