/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Thanks to abaddon for proof-reading our comm.c and pointing out bugs.  *
 *  Any remaining bugs are, of course, our work, not his.  :)              *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/
/***************************************************************************
*       ROM 2.4 is copyright 1993-1998 Russ Taylor                         *
*       ROM has been brought to you by the ROM consortium                  *
*           Russ Taylor (rtaylor@hypercube.org)                            *
*           Gabrielle Taylor (gtaylor@hypercube.org)                       *
*           Brian Moore (zump@rom.org)                                     *
*       By using this code, you have agreed to follow the terms of the     *
*       ROM license, in the file Rom24/doc/rom.license                     *
***************************************************************************/
#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "merc.h"
#include "interp.h"
#include "magic.h"
#include "recycle.h"
#include "tables.h"
#include "lookup.h"
#include "olc.h"


/* The new MAXMAP_X and MAXMAP_Y is the actual size of the display map.
   To get the space left and right of each room, you need a space before
   each room, and then you have one dangling at the end. Same for above
   and below, except you hang one dangling at the bottom. So I made new
   defines for the (MAX_Y*2)+1, instead of having that expression all
   over the code. Make expanding the map later easier.

   There's better ways to do this, but it works for now. Basically you use
   the MAXMAP_* defines when you want to traverse the entire map, for when
   you initialize it and so forth. For the actual room coordinates that you
   pass to areamapper, you use the normal MAX_* defines, so you can skip over
   the exit places more accurately. You could of course do all the calculations
   manually in the code, but eh.. it works.

   To expand it in the future, you could make the ROOM_ and EXIT_ flags be a
   bitvector, then set each room to the right roomflag, then for the exits
   you can add whatever combo of flags you'd like based on what kind of exit
   it is. Then you could have different exit symbols for one-way and two-ways
   exits, or if it's a door, and if it's a door, change color if it's open
   or closed or locked, etc.

   --Chilalin
 */


#define MAX_X 80
#define MAX_Y 30
#define MAXMAP_X (MAX_X*2+1)
#define MAXMAP_Y (MAX_Y*2+1)


#define DIR_X 0
#define DIR_Y 1

#define MAX_DIR_CON 4

#define ROOM_NONE  0
#define ROOM_NORM  1
#define ROOM_UP    2
#define ROOM_DOWN  3
#define ROOM_IN    4
#define EXIT_NORTH 5
#define EXIT_SOUTH 6
#define EXIT_EAST  7
#define EXIT_WEST  8

void areamapper args( (ROOM_INDEX_DATA *pRoom, int x, int y, int rType) );
void mapexit	args( (int dir, int x, int y) );

int get_room_type args( (int dir) );
int dirconnect[MAXMAP_X*MAXMAP_Y][4];

int map[MAXMAP_X][MAXMAP_Y];


int setexit[6][2] ={ {0, -1},{ 1, 0},{ 0, 1},{ -1, 0}, {0, 0}, { 0, 0 }};

void do_map(CHAR_DATA *ch, char *argument)
{
    int i, x, y, strtX = 0;
    bool sendRow = FALSE, sColF= FALSE;
    ROOM_INDEX_DATA *pRoom;

    for(y = 0 ; y < MAXMAP_Y ; y++)
        for(x = 0 ; x < MAXMAP_X ; x++ )
            map[x][y] = 0;

    for(i = 0 ; i < MAXMAP_X*MAXMAP_Y ; i++ )
        for(x = 0 ; i < MAX_DIR_CON ; i++ )
            dirconnect[x][i] = 0;

    for(i = ch->in_room->area->min_vnum ; i < ch->in_room->area->max_vnum ; i++)
    {
        if( (pRoom = get_room_index(i)  )== NULL )
            continue;
        REMOVE_BIT(pRoom->room_flags, ROOM_MAPPED );
    }
    if(!ch->in_room)
    {
        send_to_char("Ooo your in twouble.\n\r",ch);
        return;
    }


    areamapper(ch->in_room, MAX_X/2, MAX_Y/2, ROOM_IN);
    for(x = 0; x<MAXMAP_X ; x++ )
    {
        for(i = 0; i < MAXMAP_Y ; i++ )
        {
            if(map[x][i] > 0 )
            {
                strtX = x;
                sColF = TRUE;
                break;
            }
        }
        if(sColF)
        {
            sColF=FALSE;
            break;
        }
    }
    for( y = 0; y < MAXMAP_Y ; y++ ) // Collum
    {
        for(x = 0; x<MAXMAP_X ; x++ )
        {
            if(map[x][y] > 0 )
            {
                sendRow = TRUE;
                break;
            }

        }

        if(sendRow)
        {
            for(x = strtX ; x < MAXMAP_X ; x++ ) // Row
            {
                switch( map[x][y] )
                {
                case ROOM_NONE:
                    send_to_char(" ",ch);
                    break;
                case ROOM_NORM:
                    send_to_char("{W+{x",ch);
                    break;
                case ROOM_UP:
                    send_to_char("{R+{x",ch);
                    break;
                case ROOM_DOWN:
                    send_to_char("{B+{x",ch);
                    break;
                case ROOM_IN:
                    send_to_char("{C*{x",ch);
                    break;
                case EXIT_NORTH:
                case EXIT_SOUTH:
                    send_to_char("{W|{x",ch);
                    break;
                case EXIT_EAST:
                case EXIT_WEST:
                    send_to_char("{W-{x",ch);
                    break;
                default:
                    send_to_char("X",ch);
                }
            }
            send_to_char("\n\r",ch);
        }
        sendRow = FALSE;
    }
}

void areamapper(ROOM_INDEX_DATA *pRoom, int x, int y, int rType)
{
    int dir;
    int newx, newy;
    ROOM_INDEX_DATA *nRoom;
    EXIT_DATA *pExit;

    newx = ((x*2)+1);
    newy = ((y*2)+1);

    if(newx > MAXMAP_X || newy > MAXMAP_Y )
        return;

    if(map[newx][newy] != ROOM_IN )
        map[newx][newy] = rType;

    SET_BIT(pRoom->room_flags, ROOM_MAPPED );

    for(dir = 0; dir < MAX_DIR ; dir ++ )
    {
        if( (pExit = pRoom->exit[dir] ) == NULL)
            continue;
        if( ((nRoom = pExit->u1.to_room ) == NULL) ||
           (nRoom->area != pRoom->area) )
            continue;
        mapexit( dir, newx+setexit[dir][DIR_X], newy+setexit[dir][DIR_Y] );

        if ( IS_SET(nRoom->room_flags, ROOM_MAPPED) )
            continue;


        areamapper(	nRoom, x + setexit[dir][DIR_X], y + setexit[dir][DIR_Y], get_room_type(dir) );
    }
}

int get_room_type(int dir)
{
	if (dir == DIR_UP)
		return ROOM_UP;
	if(dir == DIR_DOWN)
		return ROOM_DOWN;
	return ROOM_NORM;
}

void mapexit( dir, x, y )
{
    switch( dir )
    {
    case DIR_NORTH:
    case DIR_SOUTH:
        map[x][y] = EXIT_NORTH;
        break;
    case DIR_EAST:
    case DIR_WEST:
        map[x][y] = EXIT_EAST;
        break;
    }
}
