/*Original colour code, written by Davion. */
#include "main.hh"

int  symbol_lookup ( const char symbol );
struct colour_type
{	char *name;
	char *symbol;
	char *code;
};

extern const struct colour_type colour_table[];
const struct colour_type colour_table[] =
{
    {  "White", 	"x", 		"\0x1B[0m" 	},
    {  "DRed",      	"r",    	"\0x1B[0;31m"	},
    {  "DGreen",	"g",		"\0x1B[0;32m"	},
    {  "DYellow",   	"y",		"\0x1B[0;33m"	},
    {  "DBlue", 	"b",		"\0x1B[0;34m"      },
    {  "DPurple",   	"m",		"\0x1B[0;35m"	},
    {  "DCyan",		"c",		"\0x1B[0;36m"      },
    {  "Dwhite",	"w",		"\0x1B[0;37m"	},
    {  "DGrey",		"D",		"\0x1B[1;30m"	},
    {  "BRed",		"R",		"\0x1B[1;31m"	},
    {  "BGreen",  	"G",		"\0x1B[1;32m"	},
    {  "BYellow", 	"Y",		"\0x1B[1;33m"	},
    {  "BBlue",   	"B",		"\0x1B[1;34m"	},
    {  "BPink",  	"M",		"\0x1B[1;35m"	},
    {  "BCyan",   	"C",		"\0x1B[1;36m"	},
    {  "BWhite",  	"W",		"\0x1B[1;37m"	},
    {  "Bracer",	"{",		"{"			},
    {  "Beep",		"*",		"\a"		},
    {  "NewLine",	"\\",		"\n\r"		},
    {  NULL,	 	NULL, 		NULL		}
};


void String::Colour()
{   String tmp;
    String rhs(*this);
    int col;
    bool found;

    for(int i = 0; i < len; ++i )
    {	found = false;
		if(rhs[i] == '{' )
		{   	if( ( col = symbol_lookup(rhs[i+1]) ) == -1 )
				col = 0;
			tmp += colour_table[col].code;
			++i;
			found = true;
		}
		if(!found)
			tmp += string[i];
    }
    Empty();
    Set(tmp);
}

int symbol_lookup( const char symbol )
{	int i;
	for ( i = 0; colour_table[i].name != NULL ; i++ )
	{	if( symbol == *colour_table[i].symbol  )
		return i;
	}
	return -1;
}






