/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik Stfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

/***************************************************************************
*	ROM 2.4 is copyright 1993-1998 Russ Taylor			   *
*	ROM has been brought to you by the ROM consortium		   *
*	    Russ Taylor (rtaylor@hypercube.org)				   *
*	    Gabrielle Taylor (gtaylor@hypercube.org)			   *
*	    Brian Moore (zump@rom.org)					   *
*	By using this code, you have agreed to follow the terms of the	   *
*	ROM license, in the file Rom24/doc/rom.license			   *
***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <unistd.h>
#include "include.h"

int mortal_online args ((CHAR_DATA *ch));
int immortal_online args ((CHAR_DATA *ch));
void *get_pcdata args( (CHAR_DATA *ch) );

int MAX_SKILL;

char *	const	where_name	[] =
{
"{C<{wused as light{C>{x            ",
"{C<{wworn as hood{C>{x             ",
"    {c<{Wworn on head{c>{x         ",
"{C<{wworn as cloak{C>{x            ",
"    {c<{Wworn around neck{c>{x     ",
"    {c<{Wworn around neck{c>{x     ",
"    {c<{Wworn on torso{c>{x        ",
"    {c<{Wworn on back{c>{x         ",
"    {c<{Wworn on shoulder{c>{x     ",
"{C<{wworn around arms{C>{x         ",
"    {c<{Wworn on arms{c>{x         ",
"    {c<{Wworn around wrist{c>{x    ",
"    {c<{Wworn around wrist{c>{x    ",
"    {c<{Wworn on hands{c>{x        ",
"    {c<{Wworn on finger{c>{x       ",
"    {c<{Wworn on finger{c>{x       ",
"{C<{wworn around body{C>{x         ",
"    {c<{Wworn about body{c>{x      ",
"    {c<{Wworn about waist{c>{x     ",
"{C<{wworn around legs{C>{x         ",
"    {c<{Wworn on legs{c>{x         ",
"    {c<{Wworn on feet{c>{x         ",
"{C<{wworn as shield{C>{x           ",
"{C<{wwielded{C>{x                  ",
"{C<{wsecondary weapon{C>{x         ",
"{C<{wheld{C>{x                     ",
"{C<{wfloating nearby{C>{x          ",
"{C<{rlodged in a leg{C>{x          ",
"{C<{rlodged in an arm{C>{x         ",
"{C<{rlodged in a rib{C>{x          ",
};


/* for  keeping track of the player count */
int max_on = 0;

sh_int count_connections;

/*
 * Local functions.
 */
char *	format_obj_to_char	args( ( OBJ_DATA *obj, CHAR_DATA *ch,
				    bool fShort ) );
void	show_list_to_char	args( ( OBJ_DATA *list, CHAR_DATA *ch,
				    bool fShort, bool fShowNothing ) );
void	show_char_to_char_0	args( ( CHAR_DATA *victim, CHAR_DATA *ch ) );
void	show_char_to_char_1	args( ( CHAR_DATA *victim, CHAR_DATA *ch ) );
void	show_char_to_char	args( ( CHAR_DATA *list, CHAR_DATA *ch ) );
bool	check_blind		args( ( CHAR_DATA *ch ) );
void    look_sky                args( ( CHAR_DATA *ch ) );
#define MAX_NEST        100
static  OBJ_DATA *      rgObjNest       [MAX_NEST];
void    read_version            args( ( char *version ) );
bool    write_version           args( ( char *argument ) );
int     moon_status             args( (                ) );

extern  void    fread_char      args( ( CHAR_DATA *ch,  FILE *fp ) );


int compare_mdeaths(const void *v1, const void *v2)
{
    return (*(MOB_INDEX_DATA * *)v2)->kills - (*(MOB_INDEX_DATA * *)v1)->killed;
}


char *format_obj_to_char( OBJ_DATA *obj, CHAR_DATA *ch, bool fShort )
{
    static char buf[MAX_STRING_LENGTH];

    buf[0] = '\0';
    if ((fShort && (obj->short_descr == NULL || obj->short_descr[0] == '\0'))
    ||  (obj->description == NULL || obj->description[0] == '\0'))
	return buf;

    if ( IS_OBJ_STAT(obj, ITEM_INVIS)     )   strcat( buf, "(Invis) "     );
    if (  IS_OBJ_STAT(obj, ITEM_EVIL)   )   strcat( buf, "(Red Aura) "  );
    if ( IS_OBJ_STAT(obj,ITEM_BLESS))	      strcat(buf,"(Blue Aura) "	);
    if ( IS_OBJ_STAT(obj, ITEM_MAGIC)  )   strcat( buf, "(Magical) "   );
    if ( IS_OBJ_STAT(obj, ITEM_GLOW)      )   strcat( buf, "(Glowing) "   );
    if ( IS_OBJ_STAT(obj, ITEM_HUM)       )   strcat( buf, "(Humming) "   );
    if (IS_OBJ_STAT(obj, ITEM_AUCTIONED) )    strcat(buf,  "(Auctioned) ");
    if(IS_OBJ_STAT(obj,ITEM_HIDDEN))          strcat(buf,  "(Hidden) ");

    if ( fShort )
    {
	if ( obj->short_descr != NULL )
	    strcat( buf, obj->short_descr );
    }
    else
    {
	if ( obj->description != NULL)
	    strcat( buf, obj->description );
    }

    return buf;
}



/*
 * Show a list to a character.
 * Can coalesce duplicated items.
 */
void show_list_to_char( OBJ_DATA *list, CHAR_DATA *ch, bool fShort, bool fShowNothing )
{
    char buf[MAX_STRING_LENGTH];
    BUFFER *output;
    char **prgpstrShow;
    int *prgnShow;
    char *pstrShow;
    OBJ_DATA *obj;
    int nShow;
    int iShow;
    int count;
    bool fCombine;

    if ( ch->desc == NULL )
	return;

    /*
     * Alloc space for output lines.
     */
    output = new_buf();

    count = 0;
    for ( obj = list; obj != NULL; obj = obj->next_content )
	count++;
    if ( count > 5000 )
    {
       send_to_char( "That is WAY too much junk!  Drop some of it!\n\r", ch );
       return;
    }
    prgpstrShow	= (char **) alloc_mem( count * sizeof(char *) );
    prgnShow    = (int *) alloc_mem( count * sizeof(int)    );
    nShow	= 0;

    /*
     * Format the list of objects.
     */
    for ( obj = list; obj != NULL; obj = obj->next_content )
    {
	if ( obj->wear_loc == WEAR_NONE && obj->belted_vnum <= 0 && can_see_obj( ch, obj ) && obj->strap_loc < 0)
	{
	    if(!obj->carried_by && !IS_NPC(ch) && !OBJ_SAME_SHAFT(ch, obj) )
	       continue;

	    pstrShow = format_obj_to_char( obj, ch, fShort );

	    fCombine = FALSE;

	    if ( IS_NPC(ch) || IS_SET(ch->comm, COMM_COMBINE) )
	    {
		/*
		 * Look for duplicates, case sensitive.
		 * Matches tend to be near end so run loop backwords.
		 */
		for ( iShow = nShow - 1; iShow >= 0; iShow-- )
		{
		    if ( !strcmp( prgpstrShow[iShow], pstrShow ) )
		    {
			prgnShow[iShow]++;
			fCombine = TRUE;
			break;
		    }
		}
	    }

	    /*
	     * Couldn't combine, or didn't want to.
	     */
	    if ( !fCombine )
	    {
		prgpstrShow [nShow] = str_dup( pstrShow );
		prgnShow    [nShow] = 1;
		nShow++;
	    }
	}
    }

    /*
     * Output the formatted list.
     */
    for ( iShow = 0; iShow < nShow; iShow++ )
    {
	if (prgpstrShow[iShow][0] == '\0')
	{
	    free_string(prgpstrShow[iShow]);
	    continue;
	}

	if ( IS_NPC(ch) || IS_SET(ch->comm, COMM_COMBINE) )
	{
	    if ( prgnShow[iShow] != 1 )
	    {
		sprintf( buf, "(%2d) ", prgnShow[iShow] );
		add_buf(output,buf);
	    }
	    else
	    {
		add_buf(output,"     ");
	    }
	}
	add_buf(output,prgpstrShow[iShow]);
	add_buf(output,"\n\r");
	free_string( prgpstrShow[iShow] );
    }

    if ( fShowNothing && nShow == 0 )
    {
	if ( IS_NPC(ch) || IS_SET(ch->comm, COMM_COMBINE) )
	    send_to_char( "     ", ch );
	send_to_char( "Nothing.\n\r", ch );
    }
    page_to_char(buf_string(output),ch);

    /*
     * Clean up.
     */
    free_buf(output);
    free_mem( prgpstrShow, count * sizeof(char *) );
    free_mem( prgnShow,    count * sizeof(int)    );

    return;
}



void show_char_to_char_0( CHAR_DATA *victim, CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH],message[MAX_STRING_LENGTH];
	USE *use;
    buf[0] = '\0';

    if ( RIDDEN(victim) )
    {
	    if ( ch != RIDDEN(victim) )
		strcat( buf, "(Ridden) " );
	    else
	        strcat( buf, "(Your mount) " );
    }
    if ( IS_SET(victim->comm,COMM_AFK	  )   ) strcat( buf, "[AFK] "	     );
    if ( IS_SET(victim->comm2,COMM_AFK    )   ) strcat( buf, "[Auto AFK] "   );
    if ( victim->invis_level >= LEVEL_HERO    ) strcat( buf, "(Wizi) "	     );
    if ( IS_EVIL(victim) ) strcat( buf, "(Red Aura) "   );
    if ( IS_GOOD(victim) ) strcat( buf, "(Golden Aura) ");
    if ( !IS_NPC(victim) && IS_SET(victim->act, PLR_WAR) )
                                                strcat( buf, "(WAR) " );
    if (!IS_NPC(victim) && !victim->desc      ) strcat( buf, "(Linkdead) " );
    if ( !IS_NPC(victim) && IS_SET(victim->act, PLR_KILLER ) )
						strcat( buf, "(KILLER) "     );
    if ( !IS_NPC(victim) && IS_SET(victim->act, PLR_THIEF  ) )
						strcat( buf, "(THIEF) "      );
    if ( victim->position == victim->start_pos && victim->long_descr[0] != '\0' )
    {
	strcat( buf, victim->long_descr );
	send_to_char( buf, ch );
	return;
    }


    strcat( buf, PERS( victim, ch ) );

   switch ( victim->position )
    {
    case POS_DEAD:     strcat( buf, " is DEAD!!" );              break;
    case POS_MORTAL:   strcat( buf, " is mortally wounded." );   break;
    case POS_INCAP:    strcat( buf, " is incapacitated." );      break;
    case POS_STUNNED:  strcat( buf, " is lying here stunned." ); break;
    case POS_SLEEPING:
	if (victim->on != NULL)
	{	use = get_obj_use(victim->on, UTYPE_FURNITURE);
	    if (IS_SET(use->value[2],SLEEP_AT))
  	    {
		sprintf(message," is sleeping at %s.",
		    victim->on->short_descr);
		strcat(buf,message);
	    }
	    else if (IS_SET(use->value[2],SLEEP_ON))
	    {
		sprintf(message," is sleeping on %s.",
		    victim->on->short_descr);
		strcat(buf,message);
	    }
	    else
	    {
		sprintf(message, " is sleeping in %s.",
		    victim->on->short_descr);
		strcat(buf,message);
	    }
	}
	else
	    strcat(buf," is sleeping here.");
	break;
    case POS_RESTING:
        if (victim->on != NULL)
		{	use = get_obj_use(victim->on, UTYPE_FURNITURE);
            if (IS_SET(use->value[2],REST_AT))
            {
                sprintf(message," is resting at %s.",
                    victim->on->short_descr);
                strcat(buf,message);
            }
            else if (IS_SET(use->value[2],REST_ON))
            {
                sprintf(message," is resting on %s.",
                    victim->on->short_descr);
                strcat(buf,message);
            }
            else
            {
                sprintf(message, " is resting in %s.",
                    victim->on->short_descr);
                strcat(buf,message);
            }
	}
        else
	    strcat( buf, " is resting here." );
	break;
    case POS_SITTING:
        if (victim->on != NULL)
        {	use = get_obj_use(victim->on, UTYPE_FURNITURE);
            if (IS_SET(use->value[2],SIT_AT))
            {
                sprintf(message," is sitting at %s.",
                    victim->on->short_descr);
                strcat(buf,message);
            }
            else if (IS_SET(use->value[2],SIT_ON))
            {
                sprintf(message," is sitting on %s.",
                    victim->on->short_descr);
                strcat(buf,message);
            }
            else
            {
                sprintf(message, " is sitting in %s.",
                    victim->on->short_descr);
                strcat(buf,message);
            }
        }
        else
	    strcat(buf, " is sitting here.");
	break;
    case POS_STANDING:
	if (victim->on != NULL)
	{	use = get_obj_use(victim->on, UTYPE_FURNITURE);
	    if (IS_SET(use->value[2],STAND_AT))
	    {
		sprintf(message," is standing at %s.",
		    victim->on->short_descr);
		strcat(buf,message);
	    }
	    else if (IS_SET(use->value[2],STAND_ON))
	    {
		sprintf(message," is standing on %s.",
		   victim->on->short_descr);
		strcat(buf,message);
	    }
	    else
	    {
		sprintf(message," is standing in %s.",
		    victim->on->short_descr);
		strcat(buf,message);
	    }
	}
	else if ( MOUNTED(victim) )
	{
	    strcat( buf, " is here and is riding " );
	    strcat( buf, MOUNTED(victim)->short_descr );
	}
	else
	    strcat( buf, " is here." );
	break;
    case POS_FIGHTING:
	strcat( buf, " is here, fighting " );
	if ( victim->fighting == NULL )
	    strcat( buf, "thin air??" );
	else if ( victim->fighting == ch )
	    strcat( buf, "YOU!" );
	else if ( IN_ROOM(victim) == IN_ROOM(victim->fighting) )
	{
	    strcat( buf, PERS( victim->fighting, ch ) );
	    strcat( buf, "." );
	}
	else
	    strcat( buf, "someone who left??" );
	break;
    }

    strcat( buf, "\n\r" );
    buf[0] = UPPER(buf[0]);
    send_to_char( buf, ch );
    return;
}



void show_char_to_char_1( CHAR_DATA *victim, CHAR_DATA *ch )
{
    char buf[MAX_STRING_LENGTH];
    OBJ_DATA *obj, *temp;
    int iWear;
    int percent;
    bool found;
    bool beltfound = FALSE;

    if ( can_see( victim, ch ) )
    {
	if (ch == victim)
	    act( "$n looks at $mself.",ch,NULL,NULL,TO_ROOM);
	else
	{
	    act( "$n looks at you.", ch, NULL, victim, TO_VICT    );
	    act( "$n looks at $N.",  ch, NULL, victim, TO_NOTVICT );
	}
    }

    if ( victim->description[0] != '\0' )
    {
	send_to_char( victim->description, ch );
    }

    else
    {
       if (!IS_NPC (victim))
       {
          sprintf (buf, "%s the %s %s has",
            PERS(victim,ch), race_table[victim->race].name, victim->sex == 0 ? "it" : victim->sex == 1 ? "male" : "female");
          send_to_char (buf, ch);
          sprintf (buf, " %s eyes and %s hair. %s body is of a %s build, and %s\n\r%s in stature.\n\r",
			eye_table[victim->pcdata->eye].name,
			hair_table[victim->pcdata->hair].name,
			victim->sex == 0 ? "Its" : victim->sex == 1 ? "His" : "Her",
			weight_table[victim->pcdata->weight].name,
			victim->sex == 0 ? "it is" : victim->sex == 1 ? "he's" : "she's",
			height_table[victim->pcdata->height].name );

          send_to_char (buf, ch);
         }

  	 act( "You see nothing special about $M.", ch, NULL, victim, TO_CHAR );
         display_bp(ch, victim);

    }

    if ( MOUNTED(victim) )
    {
	    sprintf( buf, "%s is riding %s.\n\r", victim->name, MOUNTED(victim)->short_descr);
	    send_to_char( buf, ch);
    }
    if ( RIDDEN(victim) )
    {
        sprintf( buf, "%s is being ridden by %s.\n\r", victim->short_descr, RIDDEN(victim)->name );
        send_to_char( buf, ch);
    }

    if ( victim->max_hit > 0 )
	percent = ( 100 * victim->hit ) / victim->max_hit;
    else
	percent = -1;

    strcpy( buf, PERS(victim, ch) );

    if (percent >= 100)
	strcat( buf, " is in excellent condition.\n\r");
    else if (percent >= 90)
	strcat( buf, " has a few scratches.\n\r");
    else if (percent >= 75)
	strcat( buf," has some small wounds and bruises.\n\r");
    else if (percent >=  50)
	strcat( buf, " has quite a few wounds.\n\r");
    else if (percent >= 30)
	strcat( buf, " has some big nasty wounds and scratches.\n\r");
    else if (percent >= 15)
	strcat ( buf, " looks pretty hurt.\n\r");
    else if (percent >= 0 )
	strcat (buf, " is in awful condition.\n\r");
    else
	strcat(buf, " is bleeding to death.\n\r");

    buf[0] = UPPER(buf[0]);
    send_to_char( buf, ch );

    if( (obj = get_eq_char(victim,WEAR_CLOAK) ) != NULL && obj->part == FALSE)
    {
	send_to_char("You can't seem to see their belongings.\n\r",ch);
	sprintf(buf,"{C<{wworn as cloak{C>{x     %s\n\r",obj->short_descr);
	send_to_char(buf,ch);
	return;
    }

    found = FALSE;

    for ( iWear = 0; iWear < MAX_WEAR; iWear++ )
    {
		if ( ( obj = get_eq_char( victim, iWear ) ) == NULL )
		{
			show_strapped(ch,victim,iWear);
			continue;
		}

		if ( can_see_obj( ch, obj ) && !get_obj_use(obj, UTYPE_BELT ) )
		{
			if ( !found )
			{
				send_to_char( "\n\r", ch );
				act( "$N is using:", ch, NULL, victim, TO_CHAR );
				found = TRUE;
			}
			    if( get_eq_char(victim, WEAR_CLOAK ) != NULL  &&
			      (iWear > WEAR_CLOAK && iWear < WEAR_LAYER_ARMS ))
					continue;
			    if( get_eq_char(victim, WEAR_LAYER_ARMS) != NULL &&
			      (iWear > WEAR_LAYER_ARMS && iWear < WEAR_LAYER_BODY) )
					continue;
			    if( get_eq_char(victim, WEAR_LAYER_BODY) != NULL &&
				  (iWear > WEAR_LAYER_BODY && iWear < WEAR_LAYER_LEGS) )
					continue;
			    if( get_eq_char(victim, WEAR_LAYER_LEGS) != NULL &&
				  (iWear > WEAR_LAYER_LEGS && iWear < WEAR_SHIELD) )
					continue;

			    send_to_char( where_name[iWear], ch );
			    send_to_char( "",ch);
			    send_to_char( format_obj_to_char( obj, ch, TRUE ), ch );
			    send_to_char( "\n\r", ch );
		    	    show_strapped(ch,victim,iWear);
		}
    }

    for ( iWear = 0; iWear < MAX_WEAR; iWear++ )
    {
		if ( ( obj = get_eq_char( victim, iWear ) ) != NULL
		&&   can_see_obj( ch, obj ) && get_obj_use(obj, UTYPE_BELT) )
		{
			if ( !found )
			{
				send_to_char( "\n\r", ch );
				act( "$N is using:\n\r", ch, NULL, victim, TO_CHAR );
				found = TRUE;
			}
			printf_to_char( ch, "{C<{wstrapped to %s{C>{x\n\r", obj->short_descr );
			for ( temp = victim->carrying; temp; temp = temp->next_content )
			{
				if (temp->belted_vnum == obj->pIndexData->vnum)
				{
					printf_to_char( ch, "   %s\n\r", temp->short_descr );
					beltfound = TRUE;
				}
			}
			if ( !beltfound )
				send_to_char( "   Nothing.\n\r", ch );
		}
	}

    if ( victim != ch
    &&   !IS_NPC(ch)
    &&   number_percent( ) < get_skill(ch,skill_lookup("peek")))
    {
	send_to_char( "\n\rYou peek at the inventory:\n\r", ch );
	check_improve(ch,skill_lookup("peek"),TRUE,4);
	show_list_to_char( victim->carrying, ch, TRUE, TRUE );
    }

    return;
}



void show_char_to_char( CHAR_DATA *list, CHAR_DATA *ch )
{
    CHAR_DATA *rch;

    for ( rch = list; rch != NULL; rch = rch->next_in_room )
    {
	if ( rch == ch
	    || ( RIDDEN(rch) && IN_ROOM(rch) == RIDDEN(rch)->in_room && RIDDEN(rch) != ch ) )
	    continue;

	if ( get_trust(ch) < rch->invis_level)
	    continue;
	if (!IS_NPC(ch) && !IS_NPC(rch) && (IN_MINE(ch) || IN_MINE(rch) ) && !IS_SAME_SHAFT(ch,rch) )
	    continue;
	if(!IS_NPC(ch) && IS_NPC(rch) && IN_MINE(ch) )
	    continue;
	if ( can_see( ch, rch )  )
	{
	    show_char_to_char_0( rch, ch );
            if( MOUNTED(rch) && (IN_ROOM(rch) == MOUNTED(rch)->in_room) )
            show_char_to_char_0( MOUNTED(rch), ch );
	}
	else if ( room_is_dark( IN_ROOM(ch) ))
	{
	    send_to_char( "You see glowing red eyes watching YOU!\n\r", ch );
	}
    }

    return;
}



bool check_blind( CHAR_DATA *ch )
{

 //   if (!IS_NPC(ch) && IS_SET(ch->act,PLR_HOLYLIGHT) )
	return TRUE;

	return FALSE;
    return TRUE;
}

/* changes your scroll */
void do_scroll(CHAR_DATA *ch, char *argument)
{
    char arg[MAX_INPUT_LENGTH];
    char buf[100];
    int lines;

    one_argument(argument,arg);

    if (arg[0] == '\0')
    {
	if (ch->lines == 0)
	    send_to_char("You do not page long messages.\n\r",ch);
	else
	{
	    sprintf(buf,"You currently display %d lines per page.\n\r",
		    ch->lines + 2);
	    send_to_char(buf,ch);
	}
	return;
    }

    if (!is_number(arg))
    {
	send_to_char("You must provide a number.\n\r",ch);
	return;
    }

    lines = atoi(arg);

    if (lines == 0)
    {
        send_to_char("Paging disabled.\n\r",ch);
        ch->lines = 0;
        return;
    }

    if (lines < 10 || lines > 100)
    {
	send_to_char("You must provide a reasonable number.\n\r",ch);
	return;
    }

    sprintf(buf,"Scroll set to %d lines.\n\r",lines);
    send_to_char(buf,ch);
    ch->lines = lines - 2;
}

/* RT does socials */
void do_socials(CHAR_DATA *ch, char *argument)
{
    char buf[MAX_STRING_LENGTH];
    int iSocial;
    int col;

    col = 0;

    for (iSocial = 0; social_table[iSocial].name[0] != '\0'; iSocial++)
    {
	sprintf(buf,"%-12s",social_table[iSocial].name);
	send_to_char(buf,ch);
	if (++col % 6 == 0)
	    send_to_char("\n\r",ch);
    }

    if ( col % 6 != 0)
	send_to_char("\n\r",ch);
    return;
}



/* RT Commands to replace news, motd, imotd, etc from ROM */

void do_motd(CHAR_DATA *ch, char *argument)
{
    do_function(ch, &do_help, "motd");
}

void do_imotd(CHAR_DATA *ch, char *argument)
{
    do_function(ch, &do_help, "imotd");
}

void do_rules(CHAR_DATA *ch, char *argument)
{
    do_function(ch, &do_help, "rules");
}

void do_story(CHAR_DATA *ch, char *argument)
{
    do_function(ch, &do_help, "story");
}

/* RT this following section holds all the auto commands from ROM, as well as
   replacements for config */

void do_autolist(CHAR_DATA *ch, char *argument)
{
    if (IS_NPC(ch))
      return;

    send_to_char("   action     status\n\r",ch);
    send_to_char("O-----------------------------------O\n\r",ch);

    send_to_char("| autoassist     ",ch);
    if (IS_SET(ch->act,PLR_AUTOASSIST))
        send_to_char("ON                 |\n\r",ch);
    else
        send_to_char("OFF                |\n\r",ch);
    send_to_char("| autodamage     ",ch);
    if (IS_SET(ch->act,PLR_AUTODAMAGE))
        send_to_char("ON                 |\n\r",ch);
    else
        send_to_char("OFF                |\n\r",ch);

    send_to_char("| autoexit       ",ch);
    if (IS_SET(ch->act,PLR_AUTOEXIT))
        send_to_char("ON                 |\n\r",ch);
    else
        send_to_char("OFF                |\n\r",ch);

    send_to_char("| autoweather    ",ch);
    if (IS_SET(ch->act,PLR_AUTOWEATHER))
        send_to_char("ON                 |\n\r",ch);
    else
        send_to_char("OFF                |\n\r",ch);

    send_to_char("| autogold       ",ch);
    if (IS_SET(ch->act,PLR_AUTOGOLD))
        send_to_char("ON                 |\n\r",ch);
    else
        send_to_char("OFF                |\n\r",ch);

    send_to_char("| autoloot       ",ch);
    if (IS_SET(ch->act,PLR_AUTOLOOT))
        send_to_char("ON                 |\n\r",ch);
    else
        send_to_char("OFF                |\n\r",ch);

    send_to_char("| autosac        ",ch);
    if (IS_SET(ch->act,PLR_AUTOSAC))
        send_to_char("ON                 |\n\r",ch);
    else
        send_to_char("OFF                |\n\r",ch);

    send_to_char("| autosplit      ",ch);
    if (IS_SET(ch->act,PLR_AUTOSPLIT))
        send_to_char("ON                 |\n\r",ch);
    else
        send_to_char("OFF                |\n\r",ch);

    send_to_char("| autolevel      ",ch);
    if (IS_SET(ch->comm2, COMM_AUTOLEVEL))
        send_to_char("ON                 |\n\r",ch);
    else
        send_to_char("OFF                |\n\r",ch);

    send_to_char("| pet leveling   ",ch);
    if (IS_SET(ch->comm2, COMM_PETLEVEL))
        send_to_char("ON                 |\n\r",ch);
    else
        send_to_char("OFF                |\n\r",ch);

    send_to_char("| compact mode   ",ch);
    if (IS_SET(ch->comm,COMM_COMPACT))
        send_to_char("ON                 |\n\r",ch);
    else
        send_to_char("OFF                |\n\r",ch);

    send_to_char("| prompt         ",ch);
    if (IS_SET(ch->comm,COMM_PROMPT))
	send_to_char("ON                 |\n\r",ch);
    else
	send_to_char("OFF                |\n\r",ch);

    send_to_char("| combine items  ",ch);
    if (IS_SET(ch->comm,COMM_COMBINE))
	send_to_char("ON                 |\n\r",ch);
    else
	send_to_char("OFF                |\n\r",ch);

    send_to_char("O-----------------------------------O\n\r",ch);

    if (!IS_SET(ch->act,PLR_CANLOOT))
	send_to_char("| Your corpse is safe from thieves. |\n\r",ch);
    else
        send_to_char("| Your corpse may be looted.        |\n\r",ch);

    if (IS_SET(ch->act,PLR_NOSUMMON))
	send_to_char("| You cannot be summoned.           |\n\r",ch);
    else
	send_to_char("| You can be summoned.              |\n\r",ch);

    if (IS_SET(ch->act,PLR_NOFOLLOW))
	send_to_char("| You do not welcome followers.     |\n\r",ch);
    else
	send_to_char("| You accept followers.             |\n\r",ch);

    send_to_char("O-----------------------------------O\n\r",ch);

}

void do_autoassist(CHAR_DATA *ch, char *argument)
{
    if (IS_NPC(ch))
      return;

    if (IS_SET(ch->act,PLR_AUTOASSIST))
    {
      send_to_char("Autoassist removed.\n\r",ch);
      REMOVE_BIT(ch->act,PLR_AUTOASSIST);
    }
    else
    {
      send_to_char("You will now assist when needed.\n\r",ch);
      SET_BIT(ch->act,PLR_AUTOASSIST);
    }
}

void do_autodamage(CHAR_DATA *ch, char *argument)
{
    if (IS_NPC(ch))
     return;

    if (IS_SET(ch->act,PLR_AUTODAMAGE))
    {
        send_to_char("Autodamage is currently OFF.\n\r",ch);
        REMOVE_BIT(ch->act,PLR_AUTODAMAGE);
    }
    else
    {
        send_to_char("Autodamage is currently ON.\n\r",ch);
        SET_BIT(ch->act,PLR_AUTODAMAGE);
    }
}

void do_autoexit(CHAR_DATA *ch, char *argument)
{
    if (IS_NPC(ch))
      return;

    if (IS_SET(ch->act,PLR_AUTOEXIT))
    {
      send_to_char("Exits will no longer be displayed.\n\r",ch);
      REMOVE_BIT(ch->act,PLR_AUTOEXIT);
    }
    else
    {
      send_to_char("Exits will now be displayed.\n\r",ch);
      SET_BIT(ch->act,PLR_AUTOEXIT);
    }
}

void do_autogold(CHAR_DATA *ch, char *argument)
{
    if (IS_NPC(ch))
      return;

    if (IS_SET(ch->act,PLR_AUTOGOLD))
    {
      send_to_char("Autogold removed.\n\r",ch);
      REMOVE_BIT(ch->act,PLR_AUTOGOLD);
    }
    else
    {
      send_to_char("Automatic gold looting set.\n\r",ch);
      SET_BIT(ch->act,PLR_AUTOGOLD);
    }
}

void do_autoloot(CHAR_DATA *ch, char *argument)
{
    if (IS_NPC(ch))
      return;

    if (IS_SET(ch->act,PLR_AUTOLOOT))
    {
      send_to_char("Autolooting removed.\n\r",ch);
      REMOVE_BIT(ch->act,PLR_AUTOLOOT);
    }
    else
    {
      send_to_char("Automatic corpse looting set.\n\r",ch);
      SET_BIT(ch->act,PLR_AUTOLOOT);
    }
}

void do_autosac(CHAR_DATA *ch, char *argument)
{
    if (IS_NPC(ch))
      return;

    if (IS_SET(ch->act,PLR_AUTOSAC))
    {
      send_to_char("Autosacrificing removed.\n\r",ch);
      REMOVE_BIT(ch->act,PLR_AUTOSAC);
    }
    else
    {
      send_to_char("Automatic corpse sacrificing set.\n\r",ch);
      SET_BIT(ch->act,PLR_AUTOSAC);
    }
}

void do_autosplit(CHAR_DATA *ch, char *argument)
{
    if (IS_NPC(ch))
      return;

    if (IS_SET(ch->act,PLR_AUTOSPLIT))
    {
      send_to_char("Autosplitting removed.\n\r",ch);
      REMOVE_BIT(ch->act,PLR_AUTOSPLIT);
    }
    else
    {
      send_to_char("Automatic gold splitting set.\n\r",ch);
      SET_BIT(ch->act,PLR_AUTOSPLIT);
    }
}

void do_brief(CHAR_DATA *ch, char *argument)
{
    if (IS_SET(ch->comm,COMM_BRIEF))
    {
      send_to_char("Full descriptions activated.\n\r",ch);
      REMOVE_BIT(ch->comm,COMM_BRIEF);
    }
    else
    {
      send_to_char("Short descriptions activated.\n\r",ch);
      SET_BIT(ch->comm,COMM_BRIEF);
    }
}

void do_compact(CHAR_DATA *ch, char *argument)
{
    if (IS_SET(ch->comm,COMM_COMPACT))
    {
      send_to_char("Compact mode removed.\n\r",ch);
      REMOVE_BIT(ch->comm,COMM_COMPACT);
    }
    else
    {
      send_to_char("Compact mode set.\n\r",ch);
      SET_BIT(ch->comm,COMM_COMPACT);
    }
}

void do_prompt(CHAR_DATA *ch, char *argument)
{
   char buf[MAX_STRING_LENGTH];

   if ( argument[0] == '\0' )
   {
	if (IS_SET(ch->comm,COMM_PROMPT))
   	{
      	    send_to_char("You will no longer see prompts.\n\r",ch);
      	    REMOVE_BIT(ch->comm,COMM_PROMPT);
    	}
    	else
    	{
      	    send_to_char("You will now see prompts.\n\r",ch);
      	    SET_BIT(ch->comm,COMM_PROMPT);
    	}
       return;
   }

   if( !strcmp( argument, "all" ) )
      strcpy( buf, "<%hhp %mm %vmv> ");
   else
   {
      if ( strlen(argument) > 50 )
         argument[50] = '\0';
      strcpy( buf, argument );
      smash_tilde( buf );
      if (str_suffix("%c",buf))
	strcat(buf," ");

   }

   free_string( ch->prompt );
   ch->prompt = str_dup( buf );
   sprintf(buf,"Prompt set to %s\n\r",ch->prompt );
   send_to_char(buf,ch);
   return;
}

void do_combine(CHAR_DATA *ch, char *argument)
{
    if (IS_SET(ch->comm,COMM_COMBINE))
    {
      send_to_char("Long inventory selected.\n\r",ch);
      REMOVE_BIT(ch->comm,COMM_COMBINE);
    }
    else
    {
      send_to_char("Combined inventory selected.\n\r",ch);
      SET_BIT(ch->comm,COMM_COMBINE);
    }
}

void do_noloot(CHAR_DATA *ch, char *argument)
{
    if (IS_NPC(ch))
      return;

    if (IS_SET(ch->act,PLR_CANLOOT))
    {
      send_to_char("Your corpse is now safe from thieves.\n\r",ch);
      REMOVE_BIT(ch->act,PLR_CANLOOT);
    }
    else
    {
      send_to_char("Your corpse may now be looted.\n\r",ch);
      SET_BIT(ch->act,PLR_CANLOOT);
    }
}

void do_nofollow(CHAR_DATA *ch, char *argument)
{
    if (IS_NPC(ch))
      return;

    if (IS_SET(ch->act,PLR_NOFOLLOW))
    {
      send_to_char("You now accept followers.\n\r",ch);
      REMOVE_BIT(ch->act,PLR_NOFOLLOW);
    }
    else
    {
      send_to_char("You no longer accept followers.\n\r",ch);
      SET_BIT(ch->act,PLR_NOFOLLOW);
      die_follower( ch );
    }
}

void map_ocean(CHAR_DATA *ch);

void look_ocean( CHAR_DATA *ch )
{	map_ocean(ch);
	return;
}
void MapCity(CHAR_DATA *ch);

void do_look( CHAR_DATA *ch, char *argument )
{
    char buf  [MAX_STRING_LENGTH];
    char arg1 [MAX_INPUT_LENGTH];
    char arg2 [MAX_INPUT_LENGTH];
    char arg3 [MAX_INPUT_LENGTH];
    EXIT_DATA *pexit;
    CHAR_DATA *victim;
    OBJ_DATA *obj;
    char *pdesc;
    int door;
    int number,count;
	USE *use;
	bool found = FALSE;

    if ( ch->desc == NULL )
	return;

    if ( ch->position < POS_SLEEPING )
    {
	send_to_char( "You can't see anything but stars!\n\r", ch );
	return;
    }

    if ( ch->position == POS_SLEEPING )
    {
	send_to_char( "You can't see anything, you're sleeping!\n\r", ch );
	return;
    }

    if ( !check_blind( ch ) )
    {	send_to_char("The blindness obscures your vision.\n\r",ch);
	return;
    }

    if ( !IS_NPC(ch)
    &&   !IS_SET(ch->act, PLR_HOLYLIGHT)
    &&   room_is_dark( IN_ROOM(ch) ) )
    
    {
	send_to_char( "It is pitch black ... \n\r", ch );
	show_char_to_char( IN_ROOM(ch)->people, ch );
	return;
    }

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    number = number_argument(arg1,arg3);
    count = 0;

    if ( arg1[0] == '\0' || !str_cmp( arg1, "auto" ) )
    {
	if(!IS_NPC(ch) && IN_MINE(ch) )
	{   do_function(ch, &do_look, "mine" );
	    return;
	}
/*	if(!IS_VIRTUAL(ch->in_ocean))
	{	MapCity(ch);
		return;
	} */
	look_ocean(ch);
	return;

	/* 'look' or 'look auto' */
	sprintf( buf, "{c%s{x", IN_ROOM(ch)->name );
	send_to_char( buf, ch );

        if ( (IS_IMMORTAL(ch) && (IS_NPC(ch) || IS_SET(ch->act,PLR_HOLYLIGHT)))
        ||   IS_BUILDER(ch, IN_ROOM(ch)->area) )
	{
	    sprintf(buf," {C[{cRoom {w%d{C]{x",IN_ROOM(ch)->vnum);
	    send_to_char(buf,ch);
	}

	send_to_char( "\n\r", ch );

        if ( IS_SET(ch->act, PLR_AUTOWEATHER) && IS_OUTDOORS(ch))
        {
            show_weather(ch);
        }

	if ( arg1[0] == '\0'
	|| ( !IS_NPC(ch) && !IS_SET(ch->comm, COMM_BRIEF) ) )
	{
	    sprintf( buf, "  %s", IN_ROOM(ch)->description );
	    send_to_char( buf, ch );
	}

        if ( !IS_NPC(ch) && IS_SET(ch->act, PLR_AUTOEXIT) )
	{
	    send_to_char("\n\r",ch);
            do_function(ch, &do_exits, "auto" );
	}
	show_list_to_char( IN_ROOM(ch)->contents, ch, FALSE, FALSE );
	show_char_to_char( IN_ROOM(ch)->people,   ch );
	return;
    }

    if( !str_cmp(arg1, "mine" ) )
    {
	if(IS_NPC(ch) )
	{   send_to_char("Nah, mobs don't need to look around mines.\n\r",ch);
	    return;
	}
	if(!IN_MINE(ch) )
	{   send_to_char("You can't look around a mine if you arn't in one.\n\r",ch);
	    return;
	}
	look_mine(ch);
	return;
    }

    if ( !str_cmp( arg1, "sky" ) )
    {
      if ( !IS_OUTSIDE(ch) )
      {
        send_to_char( "You can't see the sky indoors.\n\r", ch );
        return;
      }
      else
      {
        look_sky( ch );
        return;
      }
    }


    if ( !str_cmp( arg1, "i" ) || !str_cmp(arg1, "in")  || !str_cmp(arg1,"on"))
    {	/* 'look in' */
		if ( arg2[0] == '\0' )
		{	send_to_char( "Look in what?\n\r", ch );
			return;
		}
		if ( ( obj = get_obj_here( ch, NULL, arg2 ) ) == NULL )
		{	send_to_char( "You do not see that here.\n\r", ch );
			return;
		}
		if( ( use = get_obj_use( obj, UTYPE_POT) ) )
		{	if(!obj->contains )
				printf_to_char(ch, "%s has nothing in it.\n\r", obj->short_descr);
			else
				printf_to_char(ch, "%s has %dmL^ of %s.\n\r", obj->short_descr, use->value[1], material_table[obj->contains->material].name );
			found = TRUE;			
			return;
		}

		if( ( use = get_obj_use(obj, UTYPE_DRINK_CON ) ) != NULL )
		{	if ( use->value[1] <= 0 )
				send_to_char( "It is empty.\n\r", ch );
			else	
				printf_to_char(ch, "It's %sfilled with  a %s liquid.\n\r",
					use->value[1] < use->value[0] / 4
						? "less than half-" :
					use->value[1] < 3 * use->value[0] / 4
						? "about half-"     : "more than half-",
					liq_table[use->value[2]].liq_color );
			found = TRUE;

		}
		if( ( use = get_obj_use(obj, UTYPE_QUIVER) ) != NULL )
		{	if ( use->value[0] <= 0 )
				send_to_char( "The quiver is out of arrows.\n\r", ch );
			else if (use->value[0] == 1 )
				send_to_char( "The quiver has 1 arrow remaining in it.\n\r", ch );
			else if (use->value[0] > 1 )
				printf_to_char( ch, "The quiver has %d arrows in it.\n\r", use->value[0]);
			found = TRUE;		
		}

		if( ( use = get_obj_use(obj, UTYPE_CONTAINER ) ) != NULL
		||  ( use = get_obj_use(obj, UTYPE_CORPSE_NPC) ) != NULL
		||  ( use = get_obj_use(obj, UTYPE_CORPSE_PC ) ) != NULL )
		{   if ( IS_SET(use->value[1], CONT_CLOSED) )
				send_to_char( "It is closed.\n\r", ch );
			else
			{	act( "$p holds:", ch, obj, NULL, TO_CHAR );
				show_list_to_char( obj->contains, ch, TRUE, TRUE );
			}
			found = TRUE;
		}
		if( ( use = get_obj_use(obj, UTYPE_HEARTH ) ) != NULL 
		||	( use = get_obj_use(obj, UTYPE_FURNACE) ) != NULL )
		{	act( "$p holds:", ch, obj, NULL, TO_CHAR );
			show_list_to_char( obj->contains, ch, TRUE, TRUE );
			found = TRUE;
		}
		if(!found)
		{	send_to_char("That isn't a container.\n\r",ch);
			return;
		}
		return;
	}
    if ( ( victim = get_char_room( ch, NULL, arg1 ) ) != NULL )
    {
	show_char_to_char_1( victim, ch );
	return;
    }

    for ( obj = ch->carrying; obj != NULL; obj = obj->next_content )
    {
	if ( can_see_obj( ch, obj ) )
	{  /* player can see object */
	    pdesc = get_extra_descr( arg3, obj->extra_descr );
	    if ( pdesc != NULL )
	    {	if (++count == number)
	    	{
		    send_to_char( pdesc, ch );
                    show_obj_cond( ch, obj );
		    return;
	    	}
	    	else continue;
	    }

 	    pdesc = get_extra_descr( arg3, obj->pIndexData->extra_descr );
 	    if ( pdesc != NULL )
            {
 	    	if (++count == number)
 	    	{
		    send_to_char( pdesc, ch );
                    show_obj_cond( ch, obj );
		    return;
	     	}
		else continue;
            }

	    if ( is_name( arg3, obj->name ) )
	    	if (++count == number)
	    	{
	    	    send_to_char( obj->description, ch );
	    	    send_to_char( "\n\r",ch);
                    show_obj_cond( ch, obj );
		    return;
		  }
	  }
    }

    for ( obj = IN_ROOM(ch)->contents; obj != NULL; obj = obj->next_content )
    {
	if ( can_see_obj( ch, obj ) )
	{
	    pdesc = get_extra_descr( arg3, obj->extra_descr );
	    if ( pdesc != NULL )
	    	if (++count == number)
	    	{
		    send_to_char( pdesc, ch );
                    show_obj_cond( ch, obj );
		    return;
	    	}

	    pdesc = get_extra_descr( arg3, obj->pIndexData->extra_descr );
	    if ( pdesc != NULL )
	    	if (++count == number)
	    	{
		    send_to_char( pdesc, ch );
                    show_obj_cond( ch, obj );
		    return;
	    	}

	    if ( is_name( arg3, obj->name ) )
		if (++count == number)
		{
		    send_to_char( obj->description, ch );
		    send_to_char("\n\r",ch);
                    show_obj_cond( ch, obj );
		    return;
		}
	}
    }

    pdesc = get_extra_descr(arg3,IN_ROOM(ch)->extra_descr);
    if (pdesc != NULL)
    {
	if (++count == number)
	{
	    send_to_char(pdesc,ch);
	    return;
	}
    }

    if (count > 0 && count != number)
    {
    	if (count == 1)
    	    sprintf(buf,"You only see one %s here.\n\r",arg3);
    	else
    	    sprintf(buf,"You only see %d of those here.\n\r",count);

    	send_to_char(buf,ch);
    	return;
    }

         if ( !str_cmp( arg1, "n" ) || !str_cmp( arg1, "north" ) ) door = 0;
    else if ( !str_cmp( arg1, "e" ) || !str_cmp( arg1, "east"  ) ) door = 1;
    else if ( !str_cmp( arg1, "s" ) || !str_cmp( arg1, "south" ) ) door = 2;
    else if ( !str_cmp( arg1, "w" ) || !str_cmp( arg1, "west"  ) ) door = 3;
    else if ( !str_cmp( arg1, "u" ) || !str_cmp( arg1, "up"    ) ) door = 4;
    else if ( !str_cmp( arg1, "d" ) || !str_cmp( arg1, "down"  ) ) door = 5;
    else
    {
	send_to_char( "You do not see that here.\n\r", ch );
	return;
    }
	ExitList *pex = IN_ROOM(ch)->exit;
    /* 'look direction' */
    if ( ( pexit = (*pex)[door] ) == NULL )
    {
	send_to_char( "Nothing special there.\n\r", ch );
	return;
    }

    if ( pexit->description != NULL && pexit->description[0] != '\0' )
	send_to_char( pexit->description, ch );
    else
	send_to_char( "Nothing special there.\n\r", ch );

    if ( pexit->keyword    != NULL
    &&   pexit->keyword[0] != '\0'
    &&   pexit->keyword[0] != ' ' )
    {
	if ( IS_SET(pexit->exit_info, EX_CLOSED) )
	{
	    act( "The $d is closed.", ch, NULL, pexit->keyword, TO_CHAR );
	}
	else if ( IS_SET(pexit->exit_info, EX_ISDOOR) )
	{
	    act( "The $d is open.",   ch, NULL, pexit->keyword, TO_CHAR );
	}
    }

    return;
}

/* RT added back for the hell of it */
void do_read (CHAR_DATA *ch, char *argument )
{
    do_function(ch, &do_look, argument);
}

void do_examine( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    OBJ_DATA *obj;
	USE *use;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Examine what?\n\r", ch );
	return;
    }

   if ( !str_cmp( arg, "box" ) )
        {
            if (IN_ROOM(ch)->vnum != ROOM_VNUM_RENTBOX )
            {
                send_to_char( "Do you see a box here?\n\r", ch );
                return;
            }

            send_to_char( "You have the following in your box:\n\r", ch );
            show_list_to_char( ch->pcdata->box, ch, TRUE, TRUE );
            return;
        }

    do_function(ch, &do_look, arg );

    if ( ( obj = get_obj_here( ch, NULL, arg ) ) != NULL )
    {	if( get_obj_use(obj, UTYPE_JUKEBOX ) )
			do_function(ch, &do_play, "list");
		if( ( use = get_obj_use(obj, UTYPE_MONEY ) )!= NULL )
		{	if (use->value[0] == 0)
			{	if (use->value[1] == 0)
					send_to_char("Odd...there's no coins in the pile.\n\r",ch);
				else if (use->value[1] == 1)
				    send_to_char("Wow. One gold coin.\n\r",ch);
				else
				    printf_to_char(ch,"There are %d gold coins in the pile.\n\r",	use->value[1]);
			}
			else if (use->value[1] == 0)
			{	if (use->value[0] == 1)
					send_to_char("Wow. One silver coin.\n\r",ch);
				else
				    printf_to_char(ch,"There are %d silver coins in the pile.\n\r",	use->value[0]);
			}
			else
				printf_to_char(ch, "There are %d gold and %d silver coins in the pile.\n\r", use->value[1],use->value[0]);
		}

		if( get_obj_use(obj, UTYPE_DRINK_CON )
		||  get_obj_use(obj, UTYPE_CONTAINER )
		||  get_obj_use(obj, UTYPE_CORPSE_NPC )
		||  get_obj_use(obj, UTYPE_CORPSE_PC ) )
		{   sprintf(buf,"in %s",argument);
		    do_function(ch, &do_look, buf );
		}
    }

    return;
}



/*
 * Thanks to Zrin for auto-exit part.
 */
void do_exits( CHAR_DATA *ch, char *argument )
{
    extern char * const dir_name[];
    char buf[MAX_STRING_LENGTH];
    EXIT_DATA *pexit;
    bool found;
    bool fAuto;
    int door;
	ExitList *pex;

    fAuto  = !str_cmp( argument, "auto" );

    if(!IS_NPC(ch) && IN_MINE(ch) )
    {	look_mine(ch);
	return;
    }
    if ( !check_blind( ch ) )
	return;

    if (fAuto)
	sprintf(buf,"{C[{cExits:{w");
    else if (IS_IMMORTAL(ch))
	sprintf(buf,"Obvious exits from room %d:\n\r",IN_ROOM(ch)->vnum);
    else
	sprintf(buf,"Obvious exits:\n\r");
	pex = IN_ROOM(ch)->exit;
    found = FALSE;
    for ( door = 0; door <= 5; door++ )
    {
	if ( ( pexit = (*pex)[door] ) != NULL
	&&   (pexit->u1.to_room != NULL || pexit->to_shaft != NULL ) )
	{	if(IS_SET(pexit->exit_info, EX_HIDDEN) && !IS_IMMORTAL(ch) )
			continue;
	    found = TRUE;
	    if ( fAuto )
	    {	strcat( buf, " " );
            if (IS_SET (pexit->exit_info, EX_CLOSED))
	        {	strcat (buf, "{C({w");
				strcat( buf, dir_name[door] );
				strcat (buf, "{C){w");
			}
   	   else if( IS_SET (pexit->exit_info, EX_HIDDEN))
		    {	strcat(buf, "{C<{x");
				strcat( buf, dir_name[door] );
				strcat (buf, "{C>{x");
			}
			else
			{   if(pexit->to_shaft)
					strcat(buf, "{cMine-{w" );
				strcat (buf, dir_name[door]);
			}
	    }
	    else
	    {	if (!IS_SET (pexit->exit_info, EX_CLOSED))
			{	sprintf( buf + strlen(buf), "%-5s - %s", capitalize( dir_name[door] ), pexit->to_shaft ? "A Mine" : (room_is_dark( pexit->u1.to_room ) ?  "Too dark to tell" : pexit->u1.to_room->name) );
		    }
			if (IS_IMMORTAL(ch))
				sprintf(buf + strlen(buf), " (room %d)\n\r", pexit->to_shaft ? 0 : pexit->u1.to_room->vnum);
			else
			    sprintf(buf + strlen(buf), "\n\r");

		}
    }
	}

    if ( !found )
	strcat( buf, fAuto ? " none" : "None.\n\r" );

    if ( fAuto )
	strcat( buf, "{C]{x\n\r" );

    send_to_char( buf, ch );
    return;
}

void do_pinfo( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];

    if (IS_NPC(ch))
    {
       send_to_char( "Sorry mobs don't have player info!\n\r", ch );
       return;
    }

    printf_to_char( ch, "\r\nO----------------------------------------------------------O\n\r" );

    send_to_char( "|                                                          |\n\r", ch );

    sprintf(buf,
    "| Gold       : %-14ld Silver       : %-13ld |\n\r", ch->gold, ch->silver );
    send_to_char(buf,ch);

    printf_to_char( ch, "| Bank Gold  : %-14ld Bank Silver  : %-13ld |\n\r", ch->pcdata->gold_bank, ch->pcdata->silver_bank );

    printf_to_char( ch, "| Experience : %-14d Exp to level : %-13d |\n\r", ch->exp,
    exp_to_level(ch));

    sprintf(buf, "| Questpoints: %-14d |\n\r", ch->pcdata->questpoints);
    send_to_char(buf, ch);

    printf_to_char( ch, "| Levelflux  : %-14d Iquestpoints : %-13d |\n\r", ch->levelflux, ch->pcdata->qps );

    printf_to_char( ch, "| Questtime  : %-14d Nextquest    : %-13d |\n\r", ch->pcdata->nextquest );

    printf_to_char( ch, "| Pkill Wins : %-14d Pkill Losses : %-13d |\n\r", ch->pcdata->kills_pc, ch->pcdata->deaths_pc );

    printf_to_char( ch, "| Mob Kills  : %-14d Mob Deaths   : %-13d |\n\r", ch->pcdata->kills_mob, ch->pcdata->deaths_mob );

    send_to_char( "|                                                          |\n\r", ch );

    if ( IS_SET( ch->act, PLR_FREQUENT ) )
        send_to_char( "| You are a member of the Frequent Questors guild.         |\n\r", ch );

    send_to_char( "|                                                          |\n\r", ch );

    printf_to_char( ch, "O----------------------------------------------------------O\n\r" );

    return;
}
extern const struct sex_type relgrank_table[];

void do_score( CHAR_DATA *ch, char *argument )
{
	char hunger[MSL], thirst[MSL], align[MSL], pos[MSL];
	char hpstr[MSL], manastr[MSL], mvstr[MSL], acp[MSL];
	char acs[MSL], ace[MSL], acb[MSL];
	int cond;

	if(IS_NPC(ch ) )
		return;
	cond = ch->pcdata->condition[COND_HUNGER];
	sprintf(hpstr,  "%ld/%ld", ch->hit, ch->max_hit );
	sprintf(manastr,"%ld/%ld", ch->mana, ch->max_mana );
	sprintf(mvstr,  "%ld/%ld", ch->move, ch->max_move );
		 if( cond >= 24 ) sprintf(hunger, "Stuffed" );
	else if( cond >= 20 ) sprintf(hunger, "Full" );
	else if( cond >= 14 ) sprintf(hunger, "Well Fed" );
	else if( cond >= 8 ) sprintf(hunger, "Somewhat Hungry" );
	else if( cond >= 5  ) sprintf(hunger, "Hungry" );
	else  sprintf(hunger, "Starving" );

	cond = ch->pcdata->condition[COND_THIRST];

    if( cond >= 24 ) sprintf(thirst, "Quenched" );
	else if( cond >= 20 ) sprintf(thirst, "Not Thirsty" );
	else if( cond >= 14 ) sprintf(thirst, "Barely Thirsty" );
	else if( cond >= 8 ) sprintf(thirst, "Somewhat Thirsty" );
	else if( cond >= 5  ) sprintf(thirst, "Thirsty" );
	else  sprintf(thirst, "Parched" );

	    if ( ch->alignment >  750 ) sprintf(align,  "Angelic" );
   else if ( ch->alignment >  750 ) sprintf(align,  "Saintly" );
   else if ( ch->alignment >  250 ) sprintf(align,  "Good" );
   else if ( ch->alignment >  150 ) sprintf(align,  "Kind" );
   else if ( ch->alignment >   -1 ) sprintf(align,  "Neutral");
   else if ( ch->alignment > -151 ) sprintf(align,  "Mean" );
   else if ( ch->alignment > -251 ) sprintf(align,  "Evil" );
   else if ( ch->alignment > -751 ) sprintf(align,  "Demonic" );
   else                             sprintf(align,  "Satanic" );

	switch ( ch->position )
	{	case POS_DEAD:
			sprintf(pos, "DEAD" );
			break;
		case POS_MORTAL:
			sprintf(pos, "Mortally wounded");
			break;
		case POS_INCAP:
			sprintf(pos, "Incapacitated");
			break;
		case POS_STUNNED:
			sprintf(pos, "Stunned");
			break;
		case POS_SLEEPING:
			sprintf(pos, "Sleeping");
			break;
		case POS_RESTING:
			sprintf(pos, "Resting");
			break;
		case POS_SITTING:
			sprintf(pos, "Sitting");
			break;
        case POS_STANDING:
  			if(MOUNTED(ch))
				sprintf(pos, "Mounted");/*Riding on %s", MOUNTED(ch)->short_descr );*/
  			else
				sprintf(pos, "Standing");
	        break;

		case POS_FIGHTING:
			sprintf(pos, "fighting");
			break;
	}
	sprintf(acs,"%d%%",GET_AC(ch, AC_SLASH) );
	sprintf(acb,"%d%%",GET_AC(ch, AC_BASH) );
	sprintf(acp,"%d%%",GET_AC(ch, AC_PIERCE) );
	sprintf(ace,"%d%%",GET_AC(ch, AC_EXOTIC) );
	printf_to_char( ch, "%26s%s\n\r", ch->name, ch->pcdata->title );
	      send_to_char( "{W---------------------------------------------------------------------------\n\r",ch);
	printf_to_char( ch, "       {CClass: {W%-12s{D| {CSex  : {W%-12s| {CHometown : {W%s\n\r",class_table[ch->clss].name,ch->sex == 0 ? "sexless" : ch->sex == 1 ? "male" : "female", hometown_table[ch->hometown].name );
	printf_to_char( ch, "       {CRace : {W%-12s{D| {CWimpy: {W%-12d| {CClan     : {W%s{D(%s)\n\r",race_table[ch->race].name, ch->wimpy, !is_clan(ch) ? "None" : clan_table[ch->clan].name, !is_clan(ch) ? "None" : clan_table[ch->clan].rank[ch->rank].rankname );
	printf_to_char( ch, "       {CHP   : {W%-12s{D| {CMana : {W%-12s| {CMove     : {W%s\n\r",hpstr, manastr, mvstr);
	      send_to_char( "{D     --------------------------------------------------------------------\n\r",ch);
	      send_to_char( "       {cStats -            {D| {cArmour -           {D| {cBank -\n\r",ch);
	printf_to_char( ch, "           {cStr: {w%-2d{D(%2d)    |    {cPierce : {w%-7s{D|   {cSilver : {w%ld\n\r",get_curr_stat(ch,STAT_STR), ch->perm_stat[STAT_STR],acp, ch->pcdata->silver_bank );
	printf_to_char( ch, "           {cInt: {w%-2d{D(%2d)    |    {cBash   : {w%-7s{D|   {cGold   : {w%ld\n\r",get_curr_stat(ch,STAT_INT), ch->perm_stat[STAT_INT],acb, ch->pcdata->gold_bank );
	printf_to_char( ch, "           {cWis: {w%-2d{D(%2d)    |    {cSlash  : {w%-7s{D| {cHeld -\n\r",get_curr_stat(ch,STAT_WIS), ch->perm_stat[STAT_WIS],acs );
	printf_to_char( ch, "           {cDex: {w%-2d{D(%2d)    |    {cMagic  : {w%-7s{D|   {cSilver : {w%ld\n\r",get_curr_stat(ch,STAT_DEX), ch->perm_stat[STAT_DEX],ace,ch->silver );
	printf_to_char( ch, "           {cCon: {w%-2d{D(%2d)    |                    {D|   {cGold   : {w%ld\n\r",get_curr_stat(ch,STAT_CON), ch->perm_stat[STAT_CON], ch->gold );
	      send_to_char( "{D     --------------------------------------------------------------------\n\r",ch);
	printf_to_char( ch, "       {CHitroll   : {W%-7d{D| | {CItems       : {W%ld/%d\n\r",GET_HITROLL(ch), ch->carry_number, can_carry_n(ch));
	printf_to_char( ch, "       {CDamroll   : {W%-7d{D| | {CWeight      : {W%d/%d\n\r",GET_DAMROLL(ch), get_carry_weight(ch) / 10, can_carry_w(ch) /10 );
	printf_to_char( ch, "       {CHours     : {W%-7d{D| {CAge          : {W%-4d{D| {CHunger      : {W%s\n\r",( ch->played + (int) (current_time - ch->logon) ) / 3600, get_age(ch), hunger );
	printf_to_char( ch, "       {CPractices : {W%-7d{D| {CTrains       : {W%-4d{D| {CThirst      : {W%s\n\r", ch->practice, ch->train, thirst );
	      send_to_char( "{D     --------------------------------------------------------------------\n\r",ch);
	printf_to_char( ch, "       {cMarked    : {w%-7s{D| {cLevel        : {w%-4d{D| {cReligion    : {w%s{D(%s)\n\r", IS_SET(ch->act, PLR_MARK) ? "Yes" : "No", ch->level, ch->pcdata->religion ? ch->pcdata->religion->name : "None", ch->pcdata->religion ? relgrank_table[ch->pcdata->rank].name : "Nothing" );
	if(IS_IMMORTAL(ch) )
	printf_to_char( ch, "       {cIncog     : {w%-7d{D| {cWizinvis     : {w%-4d{D| {cSecurity    : {w%d\n\r", ch->incog_level, ch->invis_level, ch->pcdata->security );
	      send_to_char( "{D     --------------------------------------------------------------------\n\r",ch);
	printf_to_char( ch, "            {CMob Kills    : {W%-10d{D|   {CMob Deaths    : {W%d\n\r",ch->pcdata->kills_mob, ch->pcdata->deaths_mob );
	printf_to_char( ch, "            {CPlayer Kills : {W%-10d{D|   {CPlayer Deaths : {W%d\n\r",ch->pcdata->kills_pc, ch->pcdata->deaths_pc);
	      send_to_char( "{D     --------------------------------------------------------------------\n\r",ch);
	printf_to_char( ch, "            {cPosition     : {w%-10s{D|   {cExperience    : {w%ld{D(%d)\n\r",pos, ch->exp, exp_to_level( ch ) );
	printf_to_char( ch, "            {cQuest Points : {w%-10d{D|   {cFlux Level    : {w%d\n\r",ch->pcdata->questpoints, ch->levelflux );
	      send_to_char( "{W---------------------------------------------------------------------------{x\n\r",ch);

/*---------------------------------------------------------------------------
       Class: mage        | Sex  : female      | Hometown : Midgaard
       Race : human       | Wimpy: 13133       | Clan     : None(None)
       HP   : 1168/1168   | Mana : 3448/3448   | Move     : 1408/1408
     --------------------------------------------------------------------
       Stats -            | Armour -           | Bank-
           Str: 14(14)    |    Pierce : 100    |   Silver : 1000000
           Int: 16(16)    |    Bash   : 100    |   Gold   : 1000000
           Wis: 13(13)    |    Slash  : 100    | Holding-
           Dex: 13(13)    |    Magic  : 100    |   Gold   : 1000000
           Con: 13(13)    |                    |   Silver : 1000000
     --------------------------------------------------------------------
        Hitroll   : 0     | Cast Ability : 100 | Items       : 37/1000
        Damroll   : 0     | Cast Level   : 100 | Weight      : 75/10000000
        Hours     : 1313  | Years        : 18  | Hunger      : Full
        Practices : 132   | Trains       : 132 | Thirst      : Quenched
     --------------------------------------------------------------------
        Marked    : No    | Level        : 110 | Religion    : None(None)
        Incog     : 110   | Wizinvis     : 110 | Security    : 9
     --------------------------------------------------------------------
            Mob Kills    : 924882    |   Mob Deaths    : 2999291
	        Player Kills : 213       |   Player Deaths : 0
     --------------------------------------------------------------------
            Position     : Standing  |   Experience    : 2101001(0)
            Quest Points : 9000000   |   Flux Level    : 2
----------------------------------------------------------------------------

*/	if (IS_SET(ch->comm,COMM_SHOW_AFFECTS))
		do_function(ch, &do_affects, "");
}

void do_affects(CHAR_DATA *ch, char *argument )
{
    AFFECT_DATA *paf;
    char buf[MAX_STRING_LENGTH];

    if ( ch->affected != NULL )
    {	printf_to_char(ch, "|   %-20s |   %-20s |   %-5s | %-5s |\n\r", "Spell", "Modifier", "Value", "Duration" );
		send_to_char("========================================================================\n\r",ch);

		for ( paf = ch->affected; paf != NULL; paf = paf->next )
		{	if ( paf->duration == -1 )
				sprintf( buf, "|   %-20s |   %-20s |   %-6d |    %-5s |\n\r", skill_table[paf->type].name, affect_loc_name( paf->location ),paf->modifier, "Perminent" );
			else
				sprintf( buf, "|   %-20s |   %-20s |   %-5d |    %-5d |\n\r", skill_table[paf->type].name, affect_loc_name( paf->location ), paf->modifier, paf->duration );

		    send_to_char( buf, ch );
		}
    }
    else
	send_to_char("You are not affected by any spells.\n\r",ch);

    return;
}



char *	const	day_name	[] =
{
    "the Moon", "the Bull", "Deception", "Thunder", "Freedom",
    "the Great Gods", "the Sun"
};

char *	const	month_name	[] =
{
    "Winter", "the Winter Wolf", "the Frost Giant", "the Old Forces",
    "the Grand Struggle", "the Spring", "Nature", "Futility", "the Dragon",
    "the Sun", "the Heat", "the Battle", "the Dark Shades", "the Shadows",
    "the Long Shadows", "the Ancient Darkness", "the Great Evil"
};

void do_time( CHAR_DATA *ch, char *argument )
{
    char crs_tme[MSL], str_tme[MSL], sys_tme[MSL], sst[MSL], ssd[MSL], ssm[MSL];
    char *suf;
    int day;
    struct tm *time_str;
    day     = time_info.day + 1;

         if ( day > 4 && day <  20 ) suf = "th";
    else if ( day % 10 ==  1       ) suf = "st";
    else if ( day % 10 ==  2       ) suf = "nd";
    else if ( day % 10 ==  3       ) suf = "rd";
    else                             suf = "th";

    if(last_crash_time > (int) current_time || last_crash_time < first_boot_time )
        sprintf(crs_tme, "Al'haen hasn't crashed since Original Boot" );
    else
    {
        time_str = localtime( (time_t *) &last_crash_time  );
	strftime (crs_tme, 256, "%A, %B %d %Y at %I:%M %p", time_str);
    }
	time_str = localtime( (time_t *) &first_boot_time  );
	strftime (str_tme, 256, "%A, %B %d %Y at %I:%M %p", time_str);
	time_str = localtime( &current_time );
   	strftime (sys_tme, 256, "%A, %B %d %Y, %I:%M %p", time_str);
	sprintf(sst, "%d o'clock %s", (time_info.hour % 12 == 0) ? 12 : time_info.hour %12, time_info.hour >= 12 ? "pm" : "am" );
	sprintf(ssd, "The Day of %s, %d%s",  day_name[day % 7], day, suf );
	sprintf(ssm, "The Month of %s",  month_name[time_info.month] );
	printf_to_char(ch, "Al'haen's Time:            %s\n\r", sst );
	printf_to_char(ch, "Al'haen's Day:             %s\n\r", ssd );
	printf_to_char(ch, "Al'haen's Month:           %s\n\r", ssm );
	printf_to_char(ch, "Al'haen's Last Crash:      %s\n\r", crs_tme );
	printf_to_char(ch, "Al'haen's Original Boot:   %s\n\r", str_tme );
	printf_to_char(ch, "System time:                   %s\n\r", sys_tme );
    return;
}

void do_help( CHAR_DATA *ch, char *argument )
{
    HELP_DATA *pHelp;
    BUFFER *output;
    bool found = FALSE;
    char argall[MAX_INPUT_LENGTH],argone[MAX_INPUT_LENGTH];
    int level;

    output = new_buf();

    if ( argument[0] == '\0' )
	argument = "summary";

    /* this parts handles help a b so that it returns help 'a b' */
    argall[0] = '\0';
    while (argument[0] != '\0' )
    {
	argument = one_argument(argument,argone);
	if (argall[0] != '\0')
	    strcat(argall," ");
	strcat(argall,argone);
    }

    for ( pHelp = help_first; pHelp != NULL; pHelp = pHelp->next )
    {
    	level = (pHelp->level < 0) ? -1 * pHelp->level - 1 : pHelp->level;

	if (level > get_trust( ch ) )
	    continue;

	if ( is_name( argall, pHelp->keyword ) )
	{
	    /* add seperator if found */
	    if (found)
		add_buf(output,
    "\n\r============================================================\n\r\n\r");
	    if ( pHelp->level >= 0 && str_cmp( argall, "imotd" ) )
	    {
		add_buf(output,pHelp->keyword);
		add_buf(output,"\n\r");
	    }

	    /*
	     * Strip leading '.' to allow initial blanks.
	     */
	    if ( pHelp->text[0] == '.' )
		add_buf(output,pHelp->text+1);
	    else
		add_buf(output,pHelp->text);
	    found = TRUE;
	    /* small hack :) */
	    if (ch->desc != NULL && ch->desc->connected != CON_PLAYING
	    &&  		    ch->desc->connected != CON_GEN_GROUPS)
		break;
	}
    }

    if(!found)
    {
       send_to_char("No help on that word.\n\r", ch);
    }
    else
	page_to_char(buf_string(output),ch);
    free_buf(output);
}


/* whois command */
void do_whois (CHAR_DATA *ch, char *argument)
{
    char arg[MAX_INPUT_LENGTH];
    BUFFER *output;
    char buf[MAX_STRING_LENGTH];
    DESCRIPTOR_DATA *d;
    bool found = FALSE;

    one_argument(argument,arg);

    if (arg[0] == '\0')
    {
	send_to_char("You must provide a name.\n\r",ch);
	return;
    }

    output = new_buf();

    for (d = descriptor_list; d != NULL; d = d->next)
    {
	CHAR_DATA *wch;
	char const *clss;

 	if (d->connected != CON_PLAYING || !can_see(ch,d->character))
	    continue;

	wch = ( d->original != NULL ) ? d->original : d->character;

 	if (!can_see(ch,wch))
	    continue;

	if (!str_prefix(arg,wch->name))
	{
	    found = TRUE;

	    /* work out the printing */
	    clss = class_table[wch->clss].who_name;
	    switch(wch->level)
	    {
		case MAX_LEVEL - 0 : clss = "IMP"; 	break;
		case MAX_LEVEL - 1 : clss = "CRE";	break;
		case MAX_LEVEL - 2 : clss = "SUP";	break;
		case MAX_LEVEL - 3 : clss = "DEI";	break;
		case MAX_LEVEL - 4 : clss = "GOD";	break;
		case MAX_LEVEL - 5 : clss = "IMM";	break;
		case MAX_LEVEL - 6 : clss = "DEM";	break;
		case MAX_LEVEL - 7 : clss = "ANG";	break;
		case MAX_LEVEL - 8 : clss = "AVA";	break;
	    }

	    /* a little formatting */
	    sprintf(buf, "\n\r[%3d %6s %s] %s%s%s%s%s%s%s%s%s%s%s%s\n\r",
		wch->level,
		wch->race < MAX_PC_RACE ? pc_race_table[wch->race].who_name
					: "     ",
		clss,
	     wch->incog_level >= LEVEL_HERO ? "(Incog) ": "",
 	     wch->invis_level >= LEVEL_HERO ? "(Wizi) " : "",
             clan_table[wch->clan].who_name,
	     IS_SET(wch->comm, COMM_AFK) ? "[AFK] " : "",
             IS_SET(wch->comm2,COMM_AUTO_AFK) ? "[Auto AFK] " : "",
             IS_SET(wch->act, PLR_WAR) ? "(WAR) " : "",
             IS_SET(wch->act,PLR_KILLER) ? "<KILLER> " : "",
             IS_SET(wch->act,PLR_THIEF) ? "<THIEF{>R " : "",
             IS_SET(wch->act,PLR_TIMEOUT) ? "(TIMEOUT) " : "",
	     !IS_NPC(wch) ? (wch->pcdata->pretitle[0] == '\0' ? "" : wch->pcdata->pretitle ) : "",
             wch->name, IS_NPC(wch) ? "" : wch->pcdata->title);
 	    add_buf(output,buf);

            sprintf(buf,"\n\rO-----------------------------------------------------O\n\r" );
            add_buf( output, buf );
	    sprintf(buf,"|                                                     |\n\r" );
            add_buf( output, buf );
            sprintf(buf,"| Pkill Wins : %-10d Pkill Losses : %-12d |\n\r",
            wch->pcdata->kills_pc, wch->pcdata->deaths_pc );
            add_buf( output, buf );
            sprintf(buf,"| Mob Kills  : %-10d Mob Deaths   : %-12d |\n\r",
            wch->pcdata->kills_mob, wch->pcdata->deaths_mob );
            add_buf( output, buf );
            sprintf(buf,"| Questpoints: %-10d \n\r",
            wch->pcdata->questpoints );
            add_buf( output, buf );
            sprintf(buf,"| Clan       : %-10s Rank         : %-12s |\n\r", player_clan( wch ), player_rank( wch ) );
            add_buf( output, buf );
            sprintf(buf,"|                                                     |\n\r" );
            add_buf( output, buf );
            sprintf(buf,"O-----------------------------------------------------O\n\r" );
            add_buf( output, buf );

	}
    }

    if (!found)
    {
	send_to_char("No one of that name is playing.\n\r",ch);
	return;
    }

    page_to_char(buf_string(output),ch);
    free_buf(output);
}


/*
 * New 'who' command originally by Alander of Rivers of Mud.
 */
void do_who( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char buf2[MAX_STRING_LENGTH];
    char buf3[MSL];
    BUFFER *output;
    DESCRIPTOR_DATA *d;
    FILE *fp = NULL;
    int iClass;
    int iRace;
    int iClan;
    int iLevelLower;
    int iLevelUpper;
    int nNumber;
    int nMatch;
    int count = 0;
    int max = 0;
    int half;
    int sechalf;
    int level;
    bool *rgfClass = new bool[MAX_CLASS];
    bool *rgfRace = new bool[MAX_PC_RACE];
    bool *rgfClan = new bool[MAX_CLAN];
    bool fClassRestrict = FALSE;
    bool fClanRestrict = FALSE;
    bool fClan = FALSE;
    bool fRaceRestrict = FALSE;
    bool fImmortalOnly = FALSE;
    char olc[MSL];


	if(IS_NPC(ch) )
	    return;
	/*
     * Set default arguments.
     */
    iLevelLower    = 0;
    iLevelUpper    = MAX_LEVEL;
    for ( iClass = 0; iClass < MAX_CLASS; iClass++ )
        rgfClass[iClass] = FALSE;
    for ( iRace = 0; iRace < MAX_PC_RACE; iRace++ )
        rgfRace[iRace] = FALSE;
    for (iClan = 0; iClan < MAX_CLAN; iClan++)
	rgfClan[iClan] = FALSE;

    /*
     * Parse arguments.
     */
    nNumber = 0;
    for ( ;; )
    {
        char arg[MAX_STRING_LENGTH];

        argument = one_argument( argument, arg );
        if ( arg[0] == '\0' )
            break;

        if ( is_number( arg ) )
        {
            switch ( ++nNumber )
            {
            case 1: iLevelLower = atoi( arg ); break;
            case 2: iLevelUpper = atoi( arg ); break;
            default:
                send_to_char( "Only two level numbers allowed.\n\r", ch );
                return;
            }
        }
        else
        {

            /*
             * Look for classes to turn on.
             */
            if (!str_prefix(arg,"immortals"))
            {
                fImmortalOnly = TRUE;
            }
            else
            {
                iClass = class_lookup(arg);
                if (iClass == -1)
                {
                    iRace = race_lookup(arg);

                    if (iRace == 0 || iRace >= MAX_PC_RACE)
		    {
			if (!str_prefix(arg,"clan"))
			    fClan = TRUE;
			else
		        {
			    iClan = clan_lookup(arg);
			    if (iClan)
			    {
				fClanRestrict = TRUE;
			   	rgfClan[iClan] = TRUE;
			    }
			    else
			    {
                        	send_to_char(
                            	"That's not a valid race, class, or clan.\n\r",
				   ch);
                            	return;
			    }
                        }
		    }
                    else
                    {
                        fRaceRestrict = TRUE;
                        rgfRace[iRace] = TRUE;
                    }
                }
                else
                {
                    fClassRestrict = TRUE;
                    rgfClass[iClass] = TRUE;
                }
            }
        }
    }

    /*
     * Now show matching chars.
     */
    nMatch = 0;
    buf[0] = '\0';
    output = new_buf();
  for( level = MAX_LEVEL ; level > 0 ; level--)
  {
    if(level == LEVEL_HERO && mortal_online(ch) > 0)
	{	add_buf(output,"{D---------------------------------------------------------------------------{x\n\r");
		add_buf(output,"{cMortals Online:{x\n\r\n\r");
	}
    for ( d = descriptor_list; d != NULL; d = d->next )
    {
        CHAR_DATA *wch;
        char clss[MSL];

        /*
         * Check for match against restrictions.
         * Don't use trust as that exposes trusted mortals.
         */
        if ( d->connected != CON_PLAYING || !can_see( ch, d->character ) )
            continue;

        wch   =  d->character ? d->character : d->original;

	if (!can_see(ch,wch))
	    continue;
	if(wch->level != level)
	    continue;

	if(IS_NPC(wch) ) continue;
        count++;

        if ( wch->level < iLevelLower
        ||   wch->level > iLevelUpper
        || ( fImmortalOnly  && wch->level < LEVEL_IMMORTAL )
        || ( fClassRestrict && !rgfClass[wch->clss] )
        || ( fRaceRestrict && !rgfRace[wch->race])
 	|| ( fClan && !is_clan(wch))
	|| ( fClanRestrict && !rgfClan[wch->clan]))
            continue;

        nMatch++;

        /*
         * Figure out what to print for class.
	 */
	sprintf(clss, "{c%s", class_table[wch->clss].who_name);
	switch ( wch->level )
	{
	default: break;
            {
                case MAX_LEVEL - 0 : sprintf(clss, "{CIMP");     break;
                case MAX_LEVEL - 1 : sprintf(clss, "{CCRE");     break;
                case MAX_LEVEL - 2 : sprintf(clss, "{CSUP");     break;
                case MAX_LEVEL - 3 : sprintf(clss, "{CDEI");     break;
                case MAX_LEVEL - 4 : sprintf(clss, "{CGOD");     break;
                case MAX_LEVEL - 5 : sprintf(clss, "{CIMM");     break;
                case MAX_LEVEL - 6 : sprintf(clss, "{CDEM");     break;
                case MAX_LEVEL - 7 : sprintf(clss, "{CANG");     break;
                case MAX_LEVEL - 8 : sprintf(clss, "{CAVA");     break;
            }
	}

    	switch( wch->desc->editor )
    	{
        	case ED_NONE:			sprintf(olc, "%s", ""); break;
	       	default:
			sprintf(olc, "{B({WOLC{B) {x" );
 			break;
    	}

       if (wch->level >= LEVEL_IMMORTAL && wch->pcdata->immtitle[0] != '\0')
       {
          if (strlen_color(wch->pcdata->immtitle) == 14)
           sprintf(buf3, "{W[{x%s{W]{x", wch->pcdata->immtitle);
          else if (strlen_color(wch->pcdata->immtitle) == 15)
           sprintf(buf3, "{W[{x%s {W]{x", wch->pcdata->immtitle);
          else
          {
            half = ((14 - strlen_color(wch->pcdata->immtitle)) / 2);
            sechalf = (14 - (half + strlen_color(wch->pcdata->immtitle)));
            sprintf(buf3, "{W[{x%*c%s%*c{W]{x", half, ' ', wch->pcdata->immtitle, sechalf,
              ' ');
          }
       }
       else
          sprintf( buf3, "{W[{x{%s%-3d {w%-5s %s{W]{x",
             IS_IMMORTAL(wch) ? "C" : "c", wch->level,
             wch->race < MAX_PC_RACE ?
             pc_race_table[wch->race].who_name : "        ", clss);

	/*
	 * Format it up.
	 */
	sprintf( buf, "%s %s%s%s%s%s%s%s%s%s%s{W%s{w%s\n\r", buf3,
	    olc,
	    wch->incog_level >= LEVEL_HERO ? "(Incog) ": "",
 	     wch->invis_level >= LEVEL_HERO ? "(Wizi) " : "",
             is_clan(wch) ? clan_table[wch->clan].who_name : "",
             is_clan(wch) ? " " : "",
	     IS_SET(wch->comm, COMM_AFK) ? "[AFK] " : "",
             IS_SET(wch->comm2,COMM_AUTO_AFK) ? "[Auto AFK] " : "",
             IS_SET(wch->act, PLR_WAR) ? "(WAR) " : "",
             IS_SET(wch->act,PLR_TIMEOUT) ? "(TIMEOUT) " : "",
	     wch->pcdata->pretitle[0] == '\0' ? "" : wch->pcdata->pretitle,
	    wch->name,
	    IS_NPC(wch) ? "" : wch->pcdata->title );
	add_buf(output,buf);
    }
  }
    max_on = UMAX(count,max_on);

    fp = file_open(MAX_WHO_FILE, "r");
    max = fread_number( fp );
    file_close(fp);

    if ( max_on > max )
    {
	fp = file_open(MAX_WHO_FILE, "w");
        fprintf( fp, "%d\n", max_on );
	file_close(fp);
    }
send_to_char("{D---------------------------------------------------------------------------\n\r",ch);
send_to_char("              {C<>{W   Al'haen : Kingdoms of Crystal   {C<>{x\n\r",ch);

	if(immortal_online(ch) > 0 )
	{	send_to_char("{D---------------------------------------------------------------------------{x\n\r",ch);
		send_to_char("{CVisible Immortals:{x\n\r\n\r",ch);
	}
    add_buf(output,"{D---------------------------------------------------------------------------{x\n\r");
	if ( double_exp )
    {
     sprintf( buf2,"\n\r{cDouble exp is on for {w%d {cticks!", global_exp );
     add_buf(output,buf2);
    }
    sprintf( buf2, "\n\r{cPlayers found: {w%d      {cMost on today    : {w%d\n\r{cMax on ever  : {w%d{c      Total connections: {w%d\n\r", nMatch,
max_on, max, count_connections );
    add_buf(output,buf2);
add_buf(output,"{D---------------------------------------------------------------------------{x\n\r");
	page_to_char( buf_string(output), ch );
    free_buf(output);
	delete [] rgfClass;
    delete [] rgfRace;
    delete [] rgfClan;
	return;
}

void do_count ( CHAR_DATA *ch, char *argument )
{
    int count;
    DESCRIPTOR_DATA *d;
    char buf[MAX_STRING_LENGTH];

    count = 0;

    for ( d = descriptor_list; d != NULL; d = d->next )
        if ( d->connected == CON_PLAYING && can_see( ch, d->character ) )
	    count++;

    max_on = UMAX(count,max_on);

    if (max_on == count)
        sprintf(buf,"There are %d characters on, the most so far today.\n\r",
	    count);
    else
	sprintf(buf,"There are %d characters on, the most on today was %d.\n\r",
	    count,max_on);

    send_to_char(buf,ch);
}

void do_inventory( CHAR_DATA *ch, char *argument )
{
    send_to_char( "You are carrying:\n\r", ch );
    show_list_to_char( ch->carrying, ch, TRUE, TRUE );
    return;
}



void do_equipment( CHAR_DATA *ch, char *argument )
{
    OBJ_DATA *obj, *temp, *sheathed;
    int iWear;
    bool found, beltfound = FALSE;

    send_to_char( "You are using:\n\r", ch );
    found = FALSE;
    for ( iWear = 0; iWear < MAX_WEAR; iWear++ )
    {
		if ( ( obj = get_eq_char( ch, iWear ) ) == NULL )
		{
			show_strapped(ch,ch,iWear);
			continue;
		}
	if ( ( obj = get_eq_char( ch, iWear ) ) == NULL )
	    continue;

	send_to_char( where_name[iWear], ch );
	if ( can_see_obj( ch, obj ) )
	{
	    send_to_char( format_obj_to_char( obj, ch, TRUE ), ch );
	    send_to_char( "\n\r", ch );
	}
	else
	{
	    send_to_char( "something.\n\r", ch );
	}
	found = TRUE;
	show_strapped(ch,ch,iWear);

    }
    for ( iWear = 0; iWear < MAX_WEAR; iWear++ )
    {
		if ( ( obj = get_eq_char( ch, iWear ) ) == NULL || !get_obj_use(obj, UTYPE_BELT ) )
			continue;

		if ( found )
			send_to_char( "\n\r", ch );
		found = TRUE;
		printf_to_char( ch, "{C<{wstrapped to %s{C>{x\n\r", obj->short_descr );
		for ( temp = ch->carrying; temp; temp = temp->next_content )
		{
			if (temp->belted_vnum == obj->pIndexData->vnum)
			{
				printf_to_char( ch, "   %s\n\r", temp->short_descr );
				beltfound = TRUE;
					if(get_obj_use(obj, UTYPE_SHEATH) )
					{
					  for(sheathed =temp->contains; sheathed; sheathed = sheathed->next_content)
						    printf_to_char( ch, "        %s\n\r",sheathed->short_descr);
					}
			}
		}
		if ( !beltfound )
			send_to_char( "   Nothing.\n\r", ch );
    }

    if ( !found )
	send_to_char( "Nothing.\n\r", ch );

    return;
}



void do_compare( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    OBJ_DATA *obj1;
    OBJ_DATA *obj2;
    int value1 = 0;
    int value2 = 0;
    char *msg;
	USE *use1, *use2;
	bool found = FALSE;

    argument = one_argument( argument, arg1 );
    argument = one_argument( argument, arg2 );
    if ( arg1[0] == '\0' )
    {	send_to_char( "Compare what to what?\n\r", ch );
		return;
    }

    if ( ( obj1 = get_obj_carry( ch, arg1, ch ) ) == NULL )
    {	send_to_char( "You do not have that item.\n\r", ch );
		return;
    }

    if (arg2[0] == '\0')
    {	for (obj2 = ch->carrying; obj2 != NULL; obj2 = obj2->next_content)
		{	if (obj2->wear_loc != WEAR_NONE
			&&  can_see_obj(ch,obj2)
			&&  (obj1->wear_flags & obj2->wear_flags & ~ITEM_TAKE) != 0 )
				break;
		}

		if (obj2 == NULL)
		{	send_to_char("You aren't wearing anything comparable.\n\r",ch);
			return;
		}
    }

    else if ( (obj2 = get_obj_carry(ch,arg2,ch) ) == NULL )
    {	send_to_char("You do not have that item.\n\r",ch);
		return;
    }
    msg		= NULL;
    value1	= 0;
    value2	= 0;

    if ( obj1 == obj2 )
    {	msg = "You compare $p to itself.  It looks about the same.";
    }
    else
    {	if( ( use1 = get_obj_use(obj1, UTYPE_ARMOR ) ) != NULL
		&&  ( use2 = get_obj_use(obj2, UTYPE_ARMOR ) ) != NULL )
		{   value1 = use1->value[0] + use1->value[1] + use1->value[2];
			value2 = use2->value[0] + use2->value[1] + use2->value[2];
			found = TRUE;
		}
		if( ( use1 = get_obj_use(obj1, UTYPE_WEAPON ) ) != NULL
		&&  ( use2 = get_obj_use(obj2, UTYPE_WEAPON ) ) != NULL )
		{   if (obj1->pIndexData->new_format)
				value1 = (1 + use1->value[2]) * use1->value[1];
			else
	    		value1 = use1->value[1] + use1->value[2];

			if (obj2->pIndexData->new_format)
				value2 = (1 + use2->value[2]) * use2->value[1];
			else
				value2 = use2->value[1] + use2->value[2];
			found = TRUE;
		}
    }
	if(!found)
		msg = "You can't compare $p and $P.";
    if ( msg == NULL )
    {
	     if ( value1 == value2 ) msg = "$p and $P look about the same.";
	else if ( value1  > value2 ) msg = "$p looks better than $P.";
	else                         msg = "$p looks worse than $P.";
    }

    act( msg, ch, obj1, obj2, TO_CHAR );
    return;
}



void do_credits( CHAR_DATA *ch, char *argument )
{
    do_function(ch, &do_help, "diku" );
    return;
}



void do_where( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    DESCRIPTOR_DATA *d;
    bool found;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Players near you:\n\r", ch );
	found = FALSE;
	for ( d = descriptor_list; d; d = d->next )
	{
	    if ( d->connected == CON_PLAYING
	    && ( victim = d->character ) != NULL
	    &&   !IS_NPC(victim)
	    &&   IN_ROOM(victim) != NULL
	    &&   !IS_SET(IN_ROOM(victim)->room_flags,ROOM_NOWHERE)
 	    &&   (is_room_owner(ch,IN_ROOM(victim))
	    ||    !room_is_private(IN_ROOM(victim)))
	    &&   IN_ROOM(victim)->area == IN_ROOM(ch)->area
	    &&   can_see( ch, victim ) )
	    {
		found = TRUE;
		sprintf( buf, "%-28s %s\n\r",
		    victim->name, IN_ROOM(victim)->name );
		send_to_char( buf, ch );
	    }
	}
	if ( !found )
	    send_to_char( "None\n\r", ch );
    }
    else
    {
	found = FALSE;
	for ( victim = char_list; victim != NULL; victim = victim->next )
	{
	    if ( IN_ROOM(victim) != NULL
	    &&   IN_ROOM(victim)->area == IN_ROOM(ch)->area
	    &&   can_see( ch, victim )
	    &&   is_name( arg, victim->name ) )
	    {
		found = TRUE;
		sprintf( buf, "%-28s %s\n\r",
		    PERS(victim, ch), IN_ROOM(victim)->name );
		send_to_char( buf, ch );
		break;
	    }
	}
	if ( !found )
	    act( "You didn't find any $T.", ch, NULL, arg, TO_CHAR );
    }

    return;
}




void do_consider( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    CHAR_DATA *victim;
    char *msg;
    int diff;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
	send_to_char( "Consider killing whom?\n\r", ch );
	return;
    }

    if ( ( victim = get_char_room( ch, NULL, arg ) ) == NULL )
    {
	send_to_char( "They're not here.\n\r", ch );
	return;
    }

    if (is_safe(ch,victim))
    {
	send_to_char("Don't even think about it.\n\r",ch);
	return;
    }

    diff = victim->level - ch->level;

         if ( diff <= -10 ) msg = "You can kill $N naked and weaponless.";
    else if ( diff <=  -5 ) msg = "$N is no match for you.";
    else if ( diff <=  -2 ) msg = "$N looks like an easy kill.";
    else if ( diff <=   1 ) msg = "The perfect match!";
    else if ( diff <=   4 ) msg = "$N says 'Do you feel lucky, punk?'.";
    else if ( diff <=   9 ) msg = "$N laughs at you mercilessly.";
    else                    msg = "Death will thank you for your gift.";

    act( msg, ch, NULL, victim, TO_CHAR );

    if(ch->alignment > 800) /* Very good characters can tell a lot */
    {
       if (victim->alignment >= 900)
		 msg = "$N represents all that is Holy and Good.";
       else if (victim->alignment >= 700)
		 msg = "$N is an ally, $E's on your side.";
       else if (victim->alignment >= 250)
		 msg = "$N has Good intentions, at least.";
       else if (victim->alignment > -250)
		 msg = "$N is neutral.";
       else if (victim->alignment > -900)
		 msg = "$N is an enemy, $E's rotten.";
       else  msg = "$N is black-hearted! $E is Absolutely Evil!";
   }

   else if(ch->alignment < -800) /* so can very evil characters */
   {
       if (victim->alignment >= 900)
		 msg = "$N absolutely stinks of Righteousness.";
       else if (victim->alignment >= 700)
		 msg = "$N is a goody goody.";
       else if (victim->alignment >= 250)
		 msg = "$N likes to think $E's Good.";
       else if (victim->alignment > -250)
		 msg = "$N is just a neutral coward.";
       else if (victim->alignment > -900)
		 msg = "$N is merely mean and selfish.";
       else  msg = "You and $N are two of a kind, $E is truly Evil.";
   }

/* Very Neutral characters can get a lot of information too. */

   else if( (ch->alignment < 100) && (ch->alignment > -101) )
   {
       if (victim->alignment >= 700)
		 msg = "$N is committed to the side of Good.";
       else if (victim->alignment >= 250)
		 msg = "$N is trying to be Good.";
       else if (victim->alignment >= -250)
		 msg = "$N is neither Good nor Evil.";
       else if (victim->alignment > -700)
		 msg = "$N is trying to be Evil.";
       else  msg = "$N is committed to the side of Evil.";
   }

/* Neither very good nor very evil nor very neutral */
   else
   {
        if (victim->alignment > 900)
		  msg = "$N seems Good.";
        else if (victim->alignment > -900)
		  msg = "You cannot perceive $N's alignment.";
        else  msg = "$N seems Evil.";
    }

    act( msg, ch, NULL, victim, TO_CHAR );

    return;
}



void set_title( CHAR_DATA *ch, char *title )
{
    char buf[MAX_STRING_LENGTH];

    if ( IS_NPC(ch) )
    {
	bug( "Set_title: NPC.", 0 );
	return;
    }

    if ( title[0] != '.' && title[0] != ',' && title[0] != '!' && title[0] != '?' && !isspace(title[0]))
    {
	buf[0] = ' ';
	strcpy( buf+1, title );
    }
    else
    {
	strcpy( buf, title );
    }

    free_string( ch->pcdata->title );
    ch->pcdata->title = str_dup( buf );
    return;
}



void do_title( CHAR_DATA *ch, char *argument )
{
    if ( IS_NPC(ch) )
	return;

    if ( argument[0] == '\0' )
    {
	send_to_char( "Change your title to what?\n\r", ch );
	return;
    }

    if ( strlen(argument) > 45 )
	argument[45] = '\0';

    smash_tilde( argument );
    set_title( ch, argument );
    send_to_char( "Ok.\n\r", ch );
}



void do_description( CHAR_DATA *ch, char *argument )
{
   string_append(ch, &ch->description);
    return;
}



void do_report( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_INPUT_LENGTH];

    sprintf( buf,
	"You say 'I have %ld/%ld hp %ld/%ld mana %ld/%ld mv %d xp.'\n\r",
	ch->hit,  ch->max_hit,
	ch->mana, ch->max_mana,
	ch->move, ch->max_move,
	ch->exp   );

    send_to_char( buf, ch );

    sprintf( buf, "$n says 'I have %ld/%ld hp %ld/%ld mana %ld/%ld mv %d xp.'",
	ch->hit,  ch->max_hit,
	ch->mana, ch->max_mana,
	ch->move, ch->max_move,
	ch->exp   );

    act( buf, ch, NULL, NULL, TO_ROOM );

    return;
}

void do_practice( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH], buf2[MSL], buf3[MSL];
	BUFFER *buffer;
	int sn;

    if ( IS_NPC(ch) )
	return;

    if ( argument[0] == '\0' )
    {
	int col;
	buffer = new_buf();
	col    = 0;

	for ( sn = 0; sn < MAX_SKILL; sn++ )
	{
	    if ( skill_table[sn].name == NULL )
		break;
	    if ( !can_use_skpell(ch, sn)
	      || ch->pcdata->learned[sn] < 1 /* skill is not known */)
		continue;
            sprintf(buf2,"%s:",capitalize(skill_table[sn].name ));

		     if(ch->pcdata->learned[sn] == 1   ) sprintf(buf3, "%3d%%", ch->pcdata->learned[sn]);
		else if(ch->pcdata->learned[sn] <= 75  ) sprintf(buf3, "%3d%%", ch->pcdata->learned[sn]);
		   else                                  sprintf(buf3, "%3d%%", ch->pcdata->learned[sn]);
	    sprintf( buf, "%-25s %s   ",
		buf2,buf3);
		add_buf(buffer, buf);
	    if ( ++col % 3 == 0 )
		add_buf(buffer, "\n\r");
	}

	if ( col % 3 != 0 )
	    add_buf( buffer,"\n\r" );

	sprintf( buf, "You have %d practice sessions left.\n\r",
	    ch->practice );
	add_buf( buffer, buf );
	page_to_char(buf_string(buffer),ch);
	free_buf(buffer);
    }
    else
    {
	CHAR_DATA *mob;
	int adept;

	if ( !IS_AWAKE(ch) )
	{
	    send_to_char( "In your dreams, or what?\n\r", ch );
	    return;
	}

	for ( mob = IN_ROOM(ch)->people; mob != NULL; mob = mob->next_in_room )
	{
	    if ( IS_NPC(mob) && IS_SET(mob->act, ACT_PRACTICE) )
		break;
	}

	if ( mob == NULL )
	{
	    send_to_char( "You can't do that here.\n\r", ch );
	    return;
	}

	if ( ch->practice <= 0 )
	{
	    send_to_char( "You have no practice sessions left.\n\r", ch );
	    return;
	}

	if ( ( sn = skill_lookup( argument ) ) < 0
	|| ( !IS_NPC(ch)
	&&   (!can_use_skpell(ch, sn)
 	||    ch->pcdata->learned[sn] < 1 /* skill is not known */
	||    skill_rating(ch, sn) == 0)))
	{
	    send_to_char( "You can't practice that.\n\r", ch );
	    return;
	}

	adept = IS_NPC(ch) ? 100 : class_table[ch->clss].skill_adept;

	if ( ch->pcdata->learned[sn] >= adept )
	{
	    sprintf( buf, "You are already learned at %s.\n\r",
		skill_table[sn].name );
	    send_to_char( buf, ch );
	}
	else
	{
	    ch->practice--;
	    ch->pcdata->learned[sn] +=
		int_app[get_curr_stat(ch,STAT_INT)].learn /  skill_rating(ch, sn);
	    if ( ch->pcdata->learned[sn] < adept )
	    {
		act( "You practice $T.",
		    ch, NULL, skill_table[sn].name, TO_CHAR );
		act( "$n practices $T.",
		    ch, NULL, skill_table[sn].name, TO_ROOM );
	    }
	    else
	    {
		ch->pcdata->learned[sn] = adept;
		act( "You are now learned at $T.",
		    ch, NULL, skill_table[sn].name, TO_CHAR );
		act( "$n is now learned at $T.",
		    ch, NULL, skill_table[sn].name, TO_ROOM );
	    }
	}
    }
    return;
}



/*
 * 'Wimpy' originally by Dionysos.
 */
void do_wimpy( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    int wimpy;

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
	wimpy = ch->max_hit / 5;
    else
	wimpy = atoi( arg );

    if ( wimpy < 0 )
    {
	send_to_char( "Your courage exceeds your wisdom.\n\r", ch );
	return;
    }

    if ( wimpy > ch->max_hit/2 )
    {
	send_to_char( "Such cowardice ill becomes you.\n\r", ch );
	return;
    }

    ch->wimpy	= wimpy;
    sprintf( buf, "Wimpy set to %d hit points.\n\r", wimpy );
    send_to_char( buf, ch );
    return;
}



void do_password( CHAR_DATA *ch, char *argument )
{
    char arg1[MAX_INPUT_LENGTH];
    char arg2[MAX_INPUT_LENGTH];
    char *pArg;
    char *pwdnew;
    char *p;
    char cEnd;

    if ( IS_NPC(ch) )
	return;

    /*
     * Can't use one_argument here because it smashes case.
     * So we just steal all its code.  Bleagh.
     */
    pArg = arg1;
    while ( isspace(*argument) )
	argument++;

    cEnd = ' ';
    if ( *argument == '\'' || *argument == '"' )
	cEnd = *argument++;

    while ( *argument != '\0' )
    {
	if ( *argument == cEnd )
	{
	    argument++;
	    break;
	}
	*pArg++ = *argument++;
    }
    *pArg = '\0';

    pArg = arg2;
    while ( isspace(*argument) )
	argument++;

    cEnd = ' ';
    if ( *argument == '\'' || *argument == '"' )
	cEnd = *argument++;

    while ( *argument != '\0' )
    {
	if ( *argument == cEnd )
	{
	    argument++;
	    break;
	}
	*pArg++ = *argument++;
    }
    *pArg = '\0';

    if ( arg1[0] == '\0' || arg2[0] == '\0' )
    {
	send_to_char( "Syntax: password <old> <new>.\n\r", ch );
	return;
    }

    if ( strcmp( crypt( arg1, ch->pcdata->pwd ), ch->pcdata->pwd ) )
    {
	WAIT_STATE( ch, 40 );
	send_to_char( "Wrong password.  Wait 10 seconds.\n\r", ch );
	return;
    }

    if ( strlen(arg2) < 5 )
    {
	send_to_char(
	    "New password must be at least five characters long.\n\r", ch );
	return;
    }

    /*
     * No tilde allowed because of player file format.
     */
    pwdnew = crypt( arg2, ch->name );
    for ( p = pwdnew; *p != '\0'; p++ )
    {
	if ( *p == '~' )
	{
	    send_to_char(
		"New password not acceptable, try again.\n\r", ch );
	    return;
	}
    }

    free_string( ch->pcdata->pwd );
    ch->pcdata->pwd = str_dup( pwdnew );
    save_char_obj( ch );
    send_to_char( "Ok.\n\r", ch );
    return;
}

void do_istat(CHAR_DATA *ch, char *argument)
{
    char buf[MAX_STRING_LENGTH];

    if (IS_NPC(ch))
        return;

    sprintf(buf, "Retrieving race information for %s%ss.\n\r",
        IS_IMMORTAL(ch) ? "immortal " : "", race_table[ch->race].name);
    send_to_char(buf, ch);
    sprintf(buf, "Str[%2d/%2d] Max[%2d] %s\n\r",
        ch->perm_stat[STAT_STR],
        get_curr_stat(ch, STAT_STR),
        get_max_train(ch, STAT_STR),
        ch->perm_stat[STAT_STR] == get_max_train(ch, STAT_STR) ? "Maxed" : "");
    send_to_char(buf, ch);
    sprintf(buf, "Int[%2d/%2d] Max[%2d] %s\n\r",
            ch->perm_stat[STAT_INT],
            get_curr_stat(ch, STAT_INT),
            get_max_train(ch, STAT_INT),
        ch->perm_stat[STAT_INT] == get_max_train(ch, STAT_INT) ? "Maxed" : "");
    send_to_char(buf, ch);
    sprintf(buf, "Wis[%2d/%2d] Max[%2d] %s\n\r",
            ch->perm_stat[STAT_WIS],
            get_curr_stat(ch, STAT_WIS),
        get_max_train(ch, STAT_WIS),
        ch->perm_stat[STAT_WIS] == get_max_train(ch, STAT_WIS) ? "Maxed" : "");
    send_to_char(buf, ch);
    sprintf(buf, "Dex[%2d/%2d] Max[%2d] %s\n\r",
            ch->perm_stat[STAT_DEX],
            get_curr_stat(ch, STAT_DEX),
        get_max_train(ch, STAT_DEX),
        ch->perm_stat[STAT_DEX] == get_max_train(ch, STAT_DEX) ? "Maxed" : "");
    send_to_char(buf, ch);
    sprintf(buf, "Con[%2d/%2d] Max[%2d] %s\n\r",
            ch->perm_stat[STAT_CON],
            get_curr_stat(ch, STAT_CON),
        get_max_train(ch, STAT_CON),
        ch->perm_stat[STAT_CON] == get_max_train(ch, STAT_CON) ? "Maxed" : "");
    send_to_char(buf, ch);
    return;
}


void do_become( CHAR_DATA *ch, char *argument)
{
  DESCRIPTOR_DATA *d;
  CHAR_DATA *oldch;
  char * name;
  char * person = strdup(argument);
  char * password = strdup(argument);
  bool fOld;
  extern bool wizlock;
  extern bool newlock;

  password = one_argument(password,person);

  if ( password[0] == '\0' )
  {
      send_to_char( "Syntax: <char> <password>\n\r", ch );
      return;
  }

    if (IS_NPC(ch))
        return;

    d = ch->desc;
    name = strdup(ch->name);
    person[0] = UPPER(person[0]);
    oldch = d->character;
    fOld = load_char_obj( d, person );
    ch = d->character;

    if ( IS_SET(ch->act, PLR_DENY) )
    {
        sprintf( log_buf, "Denying access to %s@%s.", argument, d->host );
        log_string( log_buf );
        write_to_buffer( d, "You are denied access.\n\r", 0 );
  	d->character = oldch;
        return;
    }

    if ( wizlock && !IS_HERO(ch))
    {
	write_to_buffer( d, "The game is wizlocked.\n\r", 0 );
	d->character = oldch;
	return;
    }

    if ( newlock )
    {
        write_to_buffer( d, "The game is newlocked.\n\r", 0 );
        d->character = oldch;
        return;
    }

    if ( fOld )
    {

	if ( !strcmp( password,ch->pcdata->pwd ))
  	{
	    write_to_buffer( d, "Wrong password.\n\r", 0 );
	    d->character = oldch;
	    return;
	}
	extract_char( oldch, TRUE );
	d->character = ch;
	sprintf( log_buf, "%s@%s has connected.", ch->name, d->host );
	log_string( log_buf );
	do_help( ch, "motd" );
	d->connected = CON_READ_MOTD;
	sprintf( log_buf, "%s has become %s", name, person );
	log_string( log_buf );
	free(name);
	return;
    }
    else
    {
        write_to_buffer( d,"Nope. Sorry... Character doesn't Exist.\n\r",0);
	d->character = oldch;
	return;
    }

}

void do_lore( CHAR_DATA *ch, char *argument )
{
    char buf[MAX_STRING_LENGTH];
    char arg[MAX_INPUT_LENGTH];
    AFFECT_DATA *paf;
    OBJ_DATA *obj;
	USE *use;

    if ( IS_NPC(ch)
    &&   can_use_skpell( ch, skill_lookup("lore") ))
    {	send_to_char( "You would like to what?\n\r", ch );
        return;
    }

    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {	send_to_char( "What Would you like to know more about?\n\r", ch );
        return;
    }
    if ( ( obj = get_obj_carry( ch, arg, ch ) ) == NULL )
    {	send_to_char( "You cannot lore that because you do not have that.\n\r", ch );
        return;
	}

	if ( number_percent( ) < get_skill(ch,skill_lookup("lore")))
    {	send_to_char( "You learn more about this object:\n\r", ch );
        check_improve(ch,skill_lookup("lore"),TRUE,4);

	    printf_to_char( ch, "Name(s): %s\n\r", obj->name );
		printf_to_char( ch, "Short description: %s\n\rLong description: %s\n\r", obj->short_descr, obj->description );
		printf_to_char( ch, "Wear bits: %s\n\rExtra bits: %s\n\rExtra2 bits %s\n\r", wear_bit_name(obj->wear_flags), extra_bit_name( obj->extra_flags ), extra2_bit_name( obj->extra2_flags ) );
	    printf_to_char( ch, "Weight: %d (10th pounds)\n\r", obj->weight / 10);
	    printf_to_char( ch, "Level: %d  Cost: %d\n\r", obj->level, obj->cost);
	    show_obj_cond( ch, obj );

		/* now give out vital statistics as per identify */

		if( ( use = get_obj_use(obj, UTYPE_SCROLL ) ) != NULL )
		{	sprintf( buf, "Level %d spells of:", use->value[0] );
			send_to_char( buf, ch );

			if ( use->value[1] >= 0 && use->value[1] < MAX_SKILL )
			{	send_to_char( " '", ch );
				send_to_char( skill_table[use->value[1]].name, ch );
				send_to_char( "'", ch );
			}

			if ( use->value[2] >= 0 && use->value[2] < MAX_SKILL )
			{	send_to_char( " '", ch );
				send_to_char( skill_table[use->value[2]].name, ch );
				send_to_char( "'", ch );
			}

			if ( use->value[3] >= 0 && use->value[3] < MAX_SKILL )
			{	send_to_char( " '", ch );
				send_to_char( skill_table[use->value[3]].name, ch );
				send_to_char( "'", ch );
			}

			if (use->value[4] >= 0 && use->value[4] < MAX_SKILL)
			{	send_to_char(" '",ch);
				send_to_char(skill_table[use->value[4]].name,ch);
				send_to_char("'",ch);
			}

			send_to_char( " when recited.\n\r", ch );
		}
		if( ( use = get_obj_use(obj, UTYPE_POTION )) != NULL )
		{	sprintf( buf, "Level %d spells of:", use->value[0] );
			send_to_char( buf, ch );

			if ( use->value[1] >= 0 && use->value[1] < MAX_SKILL )
			{	send_to_char( " '", ch );
				send_to_char( skill_table[use->value[1]].name, ch );
				send_to_char( "'", ch );
			}

			if ( use->value[2] >= 0 && use->value[2] < MAX_SKILL )
			{	send_to_char( " '", ch );
				send_to_char( skill_table[use->value[2]].name, ch );
				send_to_char( "'", ch );
			}

			if ( use->value[3] >= 0 && use->value[3] < MAX_SKILL )
			{	send_to_char( " '", ch );
				send_to_char( skill_table[use->value[3]].name, ch );
				send_to_char( "'", ch );
			}

			if (use->value[4] >= 0 && use->value[4] < MAX_SKILL)
			{	send_to_char(" '",ch);
				send_to_char(skill_table[use->value[4]].name,ch);
				send_to_char("'",ch);
			}

			send_to_char( " when quaffed.\n\r", ch );
		}
		if( ( use = get_obj_use(obj, UTYPE_PILL )) != NULL )
		{	sprintf( buf, "Level %d spells of:", use->value[0] );
			send_to_char( buf, ch );

			if ( use->value[1] >= 0 && use->value[1] < MAX_SKILL )
			{	send_to_char( " '", ch );
				send_to_char( skill_table[use->value[1]].name, ch );
				send_to_char( "'", ch );
			}

			if ( use->value[2] >= 0 && use->value[2] < MAX_SKILL )
			{	send_to_char( " '", ch );
				send_to_char( skill_table[use->value[2]].name, ch );
				send_to_char( "'", ch );
			}

			if ( use->value[3] >= 0 && use->value[3] < MAX_SKILL )
			{	send_to_char( " '", ch );
				send_to_char( skill_table[use->value[3]].name, ch );
				send_to_char( "'", ch );
			}

			if (use->value[4] >= 0 && use->value[4] < MAX_SKILL)
			{	send_to_char(" '",ch);
				send_to_char(skill_table[use->value[4]].name,ch);
				send_to_char("'",ch);
			}

			send_to_char( " when consumed.\n\r", ch );
		}
		if( ( use = get_obj_use(obj, UTYPE_DRINK_CON )) != NULL )
		{	printf_to_char(ch,"It holds %s-colored %s.\n\r",
					liq_table[use->value[2]].liq_color,
					liq_table[use->value[2]].liq_name);
		}

		if( ( use = get_obj_use( obj, UTYPE_WEAPON )) != NULL )
		{	send_to_char("Weapon type is ",ch);
			switch (use->value[0])
			{	case(WEAPON_EXOTIC):
					send_to_char("exotic\n\r",ch);
					break;
				case(WEAPON_SWORD):
					send_to_char("sword\n\r",ch);
					break;
				case(WEAPON_DAGGER):
					send_to_char("dagger\n\r",ch);
					break;
				case(WEAPON_SPEAR):
					send_to_char("spear/staff\n\r",ch);
					break;
				case(WEAPON_MACE):
					send_to_char("mace/club\n\r",ch);
					break;
				case(WEAPON_AXE):
					send_to_char("axe\n\r",ch);
					break;
				case(WEAPON_FLAIL):
					send_to_char("flail\n\r",ch);
					break;
				case(WEAPON_WHIP):
					send_to_char("whip\n\r",ch);
					break;
				case(WEAPON_POLEARM):
					send_to_char("polearm\n\r",ch);
					break;
				case(WEAPON_BOW):
					send_to_char("bow\n\r",ch);
					break;
				case(WEAPON_STAFF):
					send_to_char("staff\n\r",ch);
					break;
				default:
					send_to_char("unknown\n\r",ch);
					break;
			}
			if (obj->pIndexData->new_format)
				printf_to_char(ch,"Damage is %dd%d (average %d)\n\r",use->value[1],use->value[2],(1 + use->value[2]) * use->value[1] / 2);
			else
				printf_to_char( ch, "Damage is %d to %d (average %d)\n\r", use->value[1], use->value[2], ( use->value[1] + use->value[2] ) / 2 );
			printf_to_char(ch,"Damage noun is %s.\n\r", (use->value[3] > 0 && use->value[3] < MAX_DAMAGE_MESSAGE) ? attack_table[use->value[3]].noun : "undefined");
			
			if (use->value[4])  /* weapon flags */
				printf_to_char(ch,"Weapons flags: %s\n\r", weapon_bit_name(use->value[4]));
		}
        

		if( ( use = get_obj_use(obj, UTYPE_ARMOR )) != NULL )
		{	printf_to_char( ch, "Armor class is %d pierce, %d bash, %d slash, and %d vs.magic\n\r", use->value[0], use->value[1], use->value[2], use->value[3] );

		}

		if( ( use = get_obj_use(obj, UTYPE_CONTAINER )) != NULL )
		{	printf_to_char(ch,"Capacity: %d#  Maximum weight: %d#  flags: %s\n\r",use->value[0], use->value[3], cont_bit_name(use->value[1]));
			if (use->value[4] != 100)
            	printf_to_char(ch,"Weight multiplier: %d%%\n\r", use->value[4]);
		}

		if ( obj->extra_descr != NULL || obj->pIndexData->extra_descr != NULL )
		{	EXTRA_DESCR_DATA *ed;
			send_to_char( "Extra description keywords: '", ch );

			for ( ed = obj->extra_descr; ed != NULL; ed = ed->next )
			{	send_to_char( ed->keyword, ch );
				if ( ed->next != NULL )
					send_to_char( " ", ch );
			}

			for ( ed = obj->pIndexData->extra_descr; ed != NULL; ed = ed->next )
			{	send_to_char( ed->keyword, ch );
				if ( ed->next != NULL )
					send_to_char( " ", ch );
			}

			send_to_char( "'\n\r", ch );
		}

		for ( paf = obj->affected; paf != NULL; paf = paf->next )
		{	printf_to_char( ch, "Affects %s by %d, level %d", affect_loc_name( paf->location ), paf->modifier,paf->level );
			if ( paf->duration > -1)
				printf_to_char(ch,", %d hours.\n\r",paf->duration);
			else
				send_to_char(".\n\r",ch);

			if (paf->bitvector)
			{
				switch(paf->where)
				{
					case TO_AFFECTS:
						sprintf(buf,"Adds %s affect.\n",
							affect_bit_name(paf->bitvector));
						break;
					case TO_WEAPON:
						sprintf(buf,"Adds %s weapon flags.\n",
							weapon_bit_name(paf->bitvector));
						break;
					case TO_OBJECT:
						sprintf(buf,"Adds %s object flag.\n",
							extra_bit_name(paf->bitvector));
						break;
					case TO_IMMUNE:
						sprintf(buf,"Adds immunity to %s.\n",
							res_flags[paf->bitvector].name);
						break;
					case TO_RESIST:
						sprintf(buf,"Adds resistance to %s.\n\r",
							res_flags[paf->bitvector].name);
						break;
					case TO_VULN:
						sprintf(buf,"Adds vulnerability to %s.\n\r",
							res_flags[paf->bitvector].name);
						break;
					case TO_OBJECT2:
					   sprintf(buf,"Adds %s object flag.\n",
							extra2_bit_name(paf->bitvector));
					default:
						sprintf(buf,"Unknown bit %d: %d\n\r",
							paf->where,paf->bitvector);
						break;
				}
				send_to_char(buf,ch);
			}
		}

		if (!obj->enchanted)
		for ( paf = obj->pIndexData->affected; paf != NULL; paf = paf->next )
		{
			sprintf( buf, "Affects %s by %d, level %d.\n\r",
				affect_loc_name( paf->location ), paf->modifier,paf->level );
			send_to_char( buf, ch );
			if (paf->bitvector)
			{
				switch(paf->where)
				{
					case TO_AFFECTS:
						sprintf(buf,"Adds %s affect.\n",
							affect_bit_name(paf->bitvector));
						break;
					case TO_OBJECT:
						sprintf(buf,"Adds %s object flag.\n",
							extra_bit_name(paf->bitvector));
						break;
					case TO_IMMUNE:
						sprintf(buf,"Adds immunity to %s.\n",
							res_flags[paf->bitvector].name);
						break;
					case TO_RESIST:
						sprintf(buf,"Adds resistance to %s.\n\r",
							res_flags[paf->bitvector].name);
						break;
					case TO_VULN:
						sprintf(buf,"Adds vulnerability to %s.\n\r",
							res_flags[paf->bitvector].name);
						break;
					case TO_OBJECT2:
						sprintf(buf,"Adds %s object flag.\n",
							extra2_bit_name(paf->bitvector));
						break;
					default:
						sprintf(buf,"Unknown bit %d: %d\n\r",
							paf->where,paf->bitvector);
						break;
				}
				send_to_char(buf,ch);
			}
		}
	}
    return;
}


void do_hometown( CHAR_DATA *ch, char *argument )
{
   char arg[MSL];
   char buf[MSL];
   int cost = 1000;
   int i;

   argument = one_argument( argument, arg );

   if ( IS_NPC(ch))
   {
       send_to_char( "Mobs don't have hometowns!\n\r", ch );
       return;
   }

   if ( arg[0] == '\0' )
   {
       send_to_char( "Valid hometowns are:\n\r", ch );
       send_to_char( "*******************\n\r", ch );
       for (i=0;hometown_table[i].name != NULL; ++i)
       {
             sprintf(buf,"[%-15s]\n\r\n\r", hometown_table[i].name );
             send_to_char( buf, ch );
       }

       printf_to_char( ch, "[Cost: %-5d gold]\n\r", cost );
       return;
   }

   if (get_hometown(arg) == -1)
   {
       send_to_char( "That's not a valid hometown.\n\r", ch );
       return;
   }

   if ( ch->gold < cost )
   {
       send_to_char( "You don't have enough gold to change your hometown!\n\r", ch );
       return;
   }

   ch->hometown = get_hometown( arg );
   ch->gold -= cost;
   sprintf( buf, "Your hometown is now set to %s. \n\r",hometown_table[ch->hometown].name );
   send_to_char( buf, ch );
   return;
}


void do_autoall(CHAR_DATA *ch, char *argument)
{
   char arg[MIL];

   argument = one_argument( argument, arg );

   if ( arg[0] == '\0' )
   {
       send_to_char( "Syntax: autoall <on>\n\r", ch );
       send_to_char( "Syntax: autoall <off>\n\r", ch );
       return;
   }

   if (IS_NPC(ch))
   return;

   if ( !str_cmp( arg, "on" ) )
   {
       SET_BIT(ch->act,PLR_AUTOASSIST);
       SET_BIT(ch->act,PLR_AUTOEXIT);
       SET_BIT(ch->act,PLR_AUTOGOLD);
       SET_BIT(ch->act,PLR_AUTOLOOT);
       SET_BIT(ch->act,PLR_AUTOSAC);
       SET_BIT(ch->act,PLR_AUTOSPLIT);
       SET_BIT(ch->act,PLR_AUTODAMAGE);
       send_to_char("All autos turned on.\n\r",ch);
   }

   if ( !str_cmp( arg, "off" ) )
   {
       REMOVE_BIT(ch->act,PLR_AUTOASSIST);
       REMOVE_BIT(ch->act,PLR_AUTOEXIT);
       REMOVE_BIT(ch->act,PLR_AUTOGOLD);
       REMOVE_BIT(ch->act,PLR_AUTOLOOT);
       REMOVE_BIT(ch->act,PLR_AUTOSAC);
       REMOVE_BIT(ch->act,PLR_AUTOSPLIT);
       REMOVE_BIT(ch->act,PLR_AUTODAMAGE);
       send_to_char("All autos turned off.\n\r",ch);
   }

   return;
}

void do_petname(CHAR_DATA *ch, char *argument)
{
  char buf[MAX_STRING_LENGTH];
  char command[MAX_INPUT_LENGTH], arg2[MAX_INPUT_LENGTH];
  char name[MSL];

  smash_tilde(argument);

  if ( ch->pet == NULL )
  {
    send_to_char("You dont have a pet!\n\r", ch);
    return;
  }

  if ( IN_ROOM(ch) != ch->pet->in_room )
  {
    send_to_char("Kinda hard for your pet to learn his new name\n\r",ch);
    send_to_char("if he's not even with you! *boggle*\n\r", ch);
    return;
  }

  argument = one_argument(argument, command);

  if ( command[0] == '\0' ||  argument[0] == '\0' )
  {
    send_to_char(
    "\n\rsyntax: petname [name|short|long|desc] <argument>\n\r",ch);
    send_to_char( "\n\r  example: \"petname name fido\n\r", ch);
    send_to_char( "            \"petname short is hungry!\"\n\r",ch);
    send_to_char("\n\rTry using color in the descriptions!\n\r\n\r", ch);
    send_to_char(
    "See \"help petname\" and \"help color\" for more information.\n\r",ch);
    return;
  }

  if ( !str_prefix(command, "name") )
  {
     if ( argument[0] == '{' )
       {
          argument++; argument++;
       }

     argument = one_argument(argument, arg2);

     sprintf(name, "%s%s", PLAYER_DIR, capitalize(arg2));
     if (file_exists(name))
     {
       send_to_char("That name is already taken!\n\r", ch);
       return;
     }

     free_string(ch->pet->name);
     ch->pet->name = capitalize( str_dup(arg2) );
     sprintf(buf, "Your pet has been renamed to: %s\n\r", ch->pet->name);
     send_to_char(buf, ch);

  } /* name */

  else

  if ( !str_prefix(command, "short") )
  {
    if ( argument[0] == '\0' ) return;
    free_string(ch->pet->short_descr);

    /* short description should not have an "\n\r" appended to it. */
    ch->pet->short_descr = str_dup(argument);

    sprintf(buf, "%s's short description set to: \n\r%s\n\r",
            ch->pet->name, ch->pet->short_descr);

    send_to_char(buf, ch);
  } /* short */
  else

  if ( !str_prefix(command, "long") )
  {
    if ( argument[0] == '\0' ) return;
    free_string(ch->pet->long_descr);

    /* long descr needs "\n\r" appended to it. */
    sprintf(buf, "%s\n\r", argument);
    ch->pet->long_descr = str_dup(buf);

    sprintf(buf, "%s's long description set to: \n\r%s\n\r",
            ch->pet->name, ch->pet->long_descr);
    send_to_char(buf, ch);
  }
  else

  if ( !str_prefix(command, "description") )
  {
#if defined (OldDesc)
    do_description(ch, argument);
#else
    if ( argument[0] == '\0' )
    {
        string_append( ch, &ch->pet->description );
        return;
    }
#endif
  }

  else
    do_help(ch, "petname");

  return;

}


void do_finger( CHAR_DATA *ch, char *argument )
{
    char arg[MAX_INPUT_LENGTH];
    char buf[MAX_STRING_LENGTH];
    CHAR_DATA *victim;

    FILE *fp;
    bool fOld;
    int s, d, h, m;
    one_argument( argument, arg );

    if ( arg[0] == '\0' )
    {
        send_to_char( "Finger whom?\n\r", ch );
        return;
    }

    if ( ( victim = get_char_world( ch, arg ) ) != NULL)
    {
        if (!IS_NPC(victim))
        {
    	    do_function(ch, &do_whois, arg);
            act( "\n\r$N is on right now!", ch, NULL, victim, TO_CHAR );

    	    s = current_time - victim->pcdata->last_typed;
            d = s/86400;
    	    s-=d*86400;
    	    h = s/3600;
    	    s -= h*3600;
    	    m = s/60;
	    s -= m*60;
	    printf_to_char(ch, "They haven't typed anything in: %d days %d hours %d minutes %d seconds\n\r", d, h,m,s);

            if (victim->desc == NULL)
	        act( "However, $N is linkdead.", ch, NULL, victim, TO_CHAR );
            return;
        }
    }

    victim = new_char();
    victim->pcdata = new_pcdata();

    fOld = FALSE;
    sprintf( buf, "%s%s", PLAYER_DIR, capitalize( arg ) );
    if (file_exists(buf))
    {
        int iNest;

	fp = file_open(buf, "r");

        for ( iNest = 0; iNest < MAX_NEST; iNest++ )
            rgObjNest[iNest] = NULL;

        fOld = TRUE;
        for ( ; ; )
        {
            char letter;
            char *word;

            letter = fread_letter( fp );
            if ( letter == '*' )
            {
                fread_to_eol( fp );
                continue;
            }

            if ( letter != '#' )
            {
                bug( "Load_char_obj: # not found.", 0 );
                break;
            }

            word = fread_word( fp );
            if      ( !str_cmp( word, "PLAYER" ) ) fread_char( victim, fp );
            else if ( !str_cmp( word, "OBJECT" ) ) break;
            else if ( !str_cmp( word, "O"      ) ) break;
            else if ( !str_cmp( word, "PET"    ) ) break;
            else if ( !str_cmp( word, "END"    ) ) break;
            else
            {
                bug( "Load_char_obj: bad section.", 0 );
                break;
            }
        }
        file_close( fp );
    }
    if ( !fOld )
    {
        send_to_char("No player by that name exists.\n\r",ch);
        free_pcdata(victim->pcdata);
        free_char(victim);
        return;
    }

    if ( (victim->level > LEVEL_HERO) && (victim->level > ch->level) && (ch->level < LEVEL_HERO))
    {
        send_to_char("The gods wouldn't like that.\n\r",ch);
        free_pcdata(victim->pcdata);
        free_char(victim);
        return;
    }

    if ( IS_NPC(victim) || victim->pcdata == NULL )
    {
        send_to_char( "Error loading pcdata.  Stop.\n\r", ch );
        free_pcdata(victim->pcdata);
        free_char(victim);
        return;
    }
    s = current_time - victim->llogoff;
    d = s/86400;
    s-=d*86400;
    h = s/3600;
    s -= h*3600;
    m = s/60;
    s -= m*60;

    if ( ch->level > LEVEL_IMMORTAL )
    {
        sprintf(buf,"Name  : %s\n\r"
                "Level : %-11d Trust  : %d\n\r"
                "Race  : %-5s       Class  : %-15s\n\r"
                "Quest : %-7d     Played : %d hours\n\r"
                "Pkills: %-10d  PDeaths: %d\n\r"
                "Mkills: %-10d  MDeaths: %d\n\r"
                "Clan  : %s\n\r\n\r"
                "Last logged off on %s\n\r",
                victim->name,
                victim->level,
                victim->trust,
                pc_race_table[victim->race].name,
                class_table[victim->clss].name,
                victim->pcdata->questpoints,
                (int) (victim->played / 3600 ),
                victim->pcdata->kills_pc,
                         victim->pcdata->deaths_pc,
                victim->pcdata->kills_mob, victim->pcdata->deaths_mob,
                clan_table[victim->clan].name,
                (char *) ctime(&victim->llogoff));
    }

    else
        sprintf(buf,"Name: %s\n\r"
                "Level: %-11d Clan: %s\n\r"
                "Class: %-11s Race: %s\n\r"
                "Pkills: %-10d PDeaths: %d\n\r"
                "Mkills: %-10d MDeaths: %d\n\r"
                "Last logged off on %s\n\r",
                victim->name,
                victim->level,
                clan_table[victim->clan].name,
                class_table[victim->clss].name,
                pc_race_table[victim->race].name,
                victim->pcdata->kills_pc,
                victim->pcdata->deaths_pc,
                victim->pcdata->kills_mob,
                victim->pcdata->deaths_mob,
                (char *) ctime(&victim->llogoff));


    send_to_char(buf,ch);
    printf_to_char(ch,
        "That was %d days, %d hours, %d minutes and %d seconds ago.\n\r",
        d, h, m, s);

    if ( victim == char_list )
    {
       char_list = victim->next;
    }
    else
    {
        CHAR_DATA *prev;

        for ( prev = char_list; prev != NULL; prev = prev->next )
        {
            if ( prev->next == victim )
            {
                prev->next = victim->next;
                break;
            }
        }

        if ( prev == NULL )
        {
            bug( "Finger: char not found.", 0 );
            return;
        }
    }


        free_pcdata(victim->pcdata);
        free_char(victim);
    return;
}


void do_peek (CHAR_DATA * ch, char *argument)
{
  CHAR_DATA *victim;

  if ((victim = get_char_room (ch, NULL, argument)) == NULL)
  {
      send_to_char ("They aren't here.\n\r", ch);
      return;
  }

  if (number_percent () < get_skill (ch, skill_lookup("peek")))
  {
      act ("You peek at $N's inventory:", ch, NULL, victim, TO_CHAR);
      check_improve (ch, skill_lookup("peek"), TRUE, 4);
      show_list_to_char (victim->carrying, ch, TRUE, TRUE);
      if (get_curr_stat (victim, STAT_INT) > get_curr_stat (ch, STAT_INT))
        act ("$n peeks inside your inventory!", ch, NULL, victim, TO_VICT);
  }
  else
  {
      act ("You failed to peek inside $N's inventory!", ch, NULL, victim, TO_CHAR);
      act ("$n tried to peek inside your inventory!", ch, NULL, victim, TO_VICT);
      act ("$n tried to peek inside $N's inventory!", ch, NULL, victim, TO_NOTVICT);
      check_improve (ch, skill_lookup("peek"), FALSE, 4);
  }

  return;
}

/* cloak wear and remove */
void do_cloak(CHAR_DATA *ch, char *argument)
{
	char arg[MAX_STRING_LENGTH];
	OBJ_DATA *obj;
	one_argument(argument,arg);

	if(IS_NPC(ch))
	{
		send_to_char("You can't do this on Mobs.\n\r",ch);
		return;
	}

	if(arg[0] == '\0')
	{
		send_to_char("Syntax: cloak <part or close>\n\r",ch);
		return;
	}
	if( ( obj = get_eq_char(ch,WEAR_CLOAK) ) == NULL )
	{
	    send_to_char("You arn't wearing a cloak.\n\r",ch);
	    return;
	}

	if(!str_cmp(arg,"close"))
	{
	    if(obj->part == FALSE)
	    {
		send_to_char("Your cloak is already closed.\n\r",ch);
		return;
	    }

	    obj->part = FALSE;
	    send_to_char("You close and tie your cloak.\n\r",ch);
	    act("$n closes and ties $s cloak",ch,NULL,NULL,TO_ROOM);
	    return;
	}

	if(!str_cmp(arg,"part"))
	{
	    if(obj->part == TRUE)
	    {
		send_to_char("Your cloak is already parted.\n\r",ch);
		return;
	    }

	    obj->part = TRUE;
	    send_to_char("You part you cloak, exposing the equipment beneath.\n\r",ch);
	    act("$n unties $s cloak.",ch,NULL,NULL,TO_ROOM);
	    return;
	}

	return;
}

/* hood remove and lift */
void do_hood(CHAR_DATA *ch, char *argument)
{
	char buf[MAX_STRING_LENGTH];
	char arg[MAX_STRING_LENGTH];
	OBJ_DATA *obj;

	buf[0] = '\0';
	one_argument(argument,arg);

	if(IS_NPC(ch))
	{
		send_to_char("Mobs are not allowed to do this.\n\r",ch);
		return;
	}

	if(arg[0] == '\0')
	{
		send_to_char("Syntax: hood <raise> or <remove or lower>\n\r",ch);
		return;
	}

	if( ( obj = get_eq_char(ch, WEAR_HOOD) ) == NULL)
	{
	    send_to_char("You are not wearing a hood which you can raise!\n\r",ch);
	    return;
    	}

	if(!str_cmp(arg,"raise"))
	{
		if(!IS_SET(ch->mask, HOOD_REMOVED) )
		{
		    send_to_char("Your hood is already raised!\n\r",ch);
		    return;
 		}
		send_to_char("You raise the hood of your cloak masking yourself.\n\r",ch);
		act("Someone raises the hood of their cloak.",ch,NULL,NULL,TO_ROOM);
		REMOVE_BIT(ch->mask,HOOD_REMOVED);
		SET_BIT(ch->mask,HOOD_RAISED);
		sprintf(buf, "Someone wearing %s", obj->short_descr);
		free_string(ch->short_descr);
		ch->short_descr = str_dup(buf);
		return;
	}
	else if(!str_cmp(arg,"remove") || !str_cmp(arg,"lower") )
	{
		if(IS_SET(ch->mask, HOOD_REMOVED) )
		{
		    send_to_char("Your hood is already down!\n\r",ch);
		    return;
 		}
		send_to_char("You remove your hood to reveal yourself.\n\r",ch);
		act("Someone removes the hood of their cloak.",ch,NULL,NULL,TO_ROOM);
		REMOVE_BIT(ch->mask,HOOD_RAISED);
		SET_BIT(ch->mask,HOOD_REMOVED);
		free_string(ch->short_descr);
		ch->short_descr = str_dup(ch->name);
		return;
	}
	else
	{
		send_to_char("Syntax: hood <raise> or <remove or lower>\n\r",ch);
		return;
	}

	return;
}

void do_arshow(CHAR_DATA *ch, char *argument)
{
    if (IS_SET(ch->comm2,COMM_SHOW_ARMOR))
    {
      send_to_char("Armor messages will no longer be shown in score.\n\r",ch);
      REMOVE_BIT(ch->comm2,COMM_SHOW_ARMOR);
    }

    else
    {
      send_to_char("Armor messages will now be shown in score.\n\r",ch);
      SET_BIT(ch->comm2,COMM_SHOW_ARMOR);
    }
}

#define NUM_DAYS 35
/* Match this to the number of days per month; this is the moon cycle */
#define NUM_MONTHS 17
/* Match this to the number of months defined in month_name[].  */
#define MAP_WIDTH 72
#define SHOW_WIDTH MAP_WIDTH/2
#define MAP_HEIGHT 9
/* Should be the string length and number of the constants below.*/
const char * star_map[] =
{
"   W.N     ' .     :. M,N     :  y:.,N    `  ,       B,N      .      .  ",
" W. :.N .      G,N  :M.: .N  :` y.N    .      :     B:   .N       :     ",
"    W:N    G.N:       M:.,N:.:   y`N      ,    c.N           .:    `    ",
"   W.`:N       '. G.N  `  : ::.      y.N      c'N      B.N R., ,N       ",
" W:'  `:N .  G. N    `  :    .y.N:.          ,     B.N      :  R:   . .N",
":' '.   .    G:.N      .'   '   :::.  ,  c.N   :c.N    `        R`.N    ",
"      :       `        `        :. ::. :     '  :        ,   , R.`:N    ",
"  ,       G:.N              `y.N :. ::.c`N      c`.N   '        `      .",
"     ..        G.:N :           .:   c.N:.    .              .          "
};

/***************************CONSTELLATIONS*******************************
  Lupus     Gigas      Pyx      Enigma   Centaurus    Terken    Raptus
   The       The       The       The       The         The       The
White Wolf  Giant     Pixie     Sphinx    Centaur      Drow     Raptor
*************************************************************************/
const char * sun_map[] =
{
"\\'|'/",
"- O -",
"/.|.\\"
};
const char * moon_map[] =
{
" @@@ ",
"@@@@@",
" @@@ "
};

void look_sky ( CHAR_DATA * ch )
{
    static char buf[MAX_STRING_LENGTH];
    static char buf2[4];
    int starpos, sunpos, moonpos, moonphase, i, linenum;

   send_to_char("You gaze up towards the heavens and see:\n\r",ch);

   sunpos  = (MAP_WIDTH * (24 - time_info.hour) / 24);
   moonpos = (sunpos + time_info.day * MAP_WIDTH / NUM_DAYS) % MAP_WIDTH;
   if ((moonphase = ((((MAP_WIDTH + moonpos - sunpos ) % MAP_WIDTH ) +
                      (MAP_WIDTH/16)) * 8 ) / MAP_WIDTH)
		         > 4) moonphase -= 8;
   starpos = (sunpos + MAP_WIDTH * time_info.month / NUM_MONTHS) % MAP_WIDTH;
   /* The left end of the star_map will be straight overhead at midnight during
      month 0 */

   for ( linenum = 0; linenum < MAP_HEIGHT; linenum++ )
   {
     if ((time_info.hour >= 6 && time_info.hour <= 18) &&
         (linenum < 3 || linenum >= 6))
       continue;
     sprintf(buf,"|");
     for ( i = MAP_WIDTH/4; i <= 3*MAP_WIDTH/4; i++)
     {
       /* plot moon on top of anything else...unless new moon & no eclipse */
       if ((time_info.hour >= 6 && time_info.hour <= 18)  /* daytime? */
        && (moonpos >= MAP_WIDTH/4 - 2) && (moonpos <= 3*MAP_WIDTH/4 + 2) /* in sky? */
        && ( i >= moonpos - 2 ) && (i <= moonpos + 2) /* is this pixel near moon? */
        && ((sunpos == moonpos && time_info.hour == 12) || moonphase != 0  ) /*no eclipse*/
        && (moon_map[linenum-3][i+2-moonpos] == '@'))
       {
         if ((moonphase < 0 && i - 2 - moonpos >= moonphase) ||
             (moonphase > 0 && i + 2 - moonpos <= moonphase))
           strcat(buf,"@");
         else
           strcat(buf," ");
       }
       else
       if ((linenum >= 3) && (linenum < 6) && /* nighttime */
           (moonpos >= MAP_WIDTH/4 - 2) && (moonpos <= 3*MAP_WIDTH/4 + 2) /* in sky? */
        && ( i >= moonpos - 2 ) && (i <= moonpos + 2) /* is this pixel near moon? */
        && (moon_map[linenum-3][i+2-moonpos] == '@'))
       {
         if ((moonphase < 0 && i - 2 - moonpos >= moonphase) ||
             (moonphase > 0 && i + 2 - moonpos <= moonphase))
           strcat(buf,"@");
         else
           strcat(buf," ");
       }
       else /* plot sun or stars */
       {
         if (time_info.hour>=6 && time_info.hour<=18) /* daytime */
         {
           if ( i >= sunpos - 2 && i <= sunpos + 2 )
           {
             sprintf(buf2,"%c",sun_map[linenum-3][i+2-sunpos]);
             strcat(buf,buf2);
           }
           else
             strcat(buf," ");
         }
         else
         {
           switch (star_map[linenum][(MAP_WIDTH + i - starpos)%MAP_WIDTH])
           {
             default     : strcat(buf," ");    break;
             case '.'    : strcat(buf,".");    break;
             case ','    : strcat(buf,",");    break;
             case ':'    : strcat(buf,":");    break;
             case '`'    : strcat(buf,"`");    break;
             case 'R'    : strcat(buf," ");  break;
             case 'G'    : strcat(buf," ");  break;
             case 'B'    : strcat(buf," ");  break;
             case 'W'    : strcat(buf," ");  break;
             case 'M'    : strcat(buf," ");  break;
             case 'N'    : strcat(buf," ");  break;
             case 'y'    : strcat(buf," ");  break;
             case 'c'    : strcat(buf," ");  break;
           }
         }
       }
     }
     strcat(buf,"|\n\r");
     send_to_char(buf,ch);
   }
     if(!str_cmp(ch->name, "Davion") )
     {
	printf_to_char(ch, "Moonphase %d", moon_status());
     }
}

void do_mobdeaths(CHAR_DATA * ch, char *argument)
{
    extern int top_mob_index;
    BUFFER *buffer;
    char buf[MSL];
    MOB_INDEX_DATA *pMobIndex;
    MOB_INDEX_DATA **mobs;
    long vnum;
    int nMatch,
    count, i;
    bool found;
    mobs = (MOB_INDEX_DATA **) calloc(top_mob_index, sizeof(**mobs ) );
    found = FALSE;
    nMatch = 0;
    count = 0;
    i = 0;
    buffer = new_buf();

    add_buf(buffer, "                    Al'haen Most Popular Mobs                      \n\r");
    add_buf(buffer, "Num  Mob Name                  Level  Area Name            Deaths\n\r");
    add_buf(buffer, "---  ------------------------- -----  -------------------- ------\n\r");

    for (vnum = 0; nMatch < top_mob_index; vnum++)
    {
	if ((pMobIndex = get_mob_index(vnum)) != NULL)
	{
	    nMatch++;

	    if (pMobIndex->killed > 2)
	    {
		mobs[count] = pMobIndex;
		count++;
		found = TRUE;
	    }
	}
    }

    qsort(mobs, count, sizeof(pMobIndex), compare_mdeaths);

    for (i = 0; i < count; i++)
    {
	if (i == 49)
	    break;
        sprintf(buf,"%3d) %-25s %5d  %-20s %6d\n\r", i + 1, mobs[i]->short_descr, mobs[i]->level, mobs[i]->area->name, mobs[i]->killed);
        add_buf( buffer, buf );
    }

    if (!found)
	add_buf(buffer, "\n\rNo Mobs listed yet.\n\r");

    page_to_char(buf_string(buffer), ch);
    free_buf(buffer);
    free( mobs );
    return;
}

int compare_mkills(const void *v1, const void *v2)
{
    return (*(MOB_INDEX_DATA * *)v2)->kills - (*(MOB_INDEX_DATA * *)v1)->kills;
}

void do_mobkills(CHAR_DATA * ch, char *argument)
{
    extern int top_mob_index;
    BUFFER *buffer;
    char buf[MSL];
    MOB_INDEX_DATA *pMobIndex;
    MOB_INDEX_DATA **mobs;
    long vnum;
    int nMatch,
     count,
     i;
    bool found;
	mobs = (MOB_INDEX_DATA **) calloc(top_mob_index, sizeof(MOB_INDEX_DATA *));
    found = FALSE;
    nMatch = 0;
    count = 0;
    i = 0;
    buffer = new_buf();

    add_buf(buffer, "              Al'haen Most Dangerous Monsters                 \n\r");
    add_buf(buffer, "Num  Mob Name                  Level  Area Name            Deaths\n\r");
    add_buf(buffer, "---  ------------------------- -----  -------------------- ------\n\r");

    for (vnum = 0; nMatch < top_mob_index; vnum++)
    {
	if ((pMobIndex = get_mob_index(vnum)) != NULL)
	{
	    nMatch++;

	    if (pMobIndex->kills > 2)
	    {
		mobs[count] = pMobIndex;
		count++;
		found = TRUE;
	    }
	}
    }

    qsort(mobs, count, sizeof(pMobIndex), compare_mkills);

    for (i = 0; i < count; i++)
    {
	if (i == 49)
	    break;
	sprintf(buf, "%3d) %-25s %5d  %-20s %6d\n\r", i + 1, mobs[i]->short_descr, mobs[i]->level, mobs[i]->area->name, mobs[i]->kills);
        add_buf( buffer, buf );
    }

    if (!found)
	add_buf(buffer, "\n\rNo Mobs listed yet.\n\r");

    page_to_char(buf_string(buffer), ch);
    free_buf(buffer);
    free(mobs);
    return;
}

void do_nickname(CHAR_DATA *ch, char *argument )
{
    NICK_DATA *nick;
    char arg[MSL], arg2[MSL], buf[MSL];
    CHAR_DATA *victim;
    bool found = FALSE;

    arg[0] = '\0';
    arg2[0] = arg[0];

    argument = one_argument(argument, arg);
    argument = one_argument(argument, arg2);

    if(arg[0] == '\0' && arg2[0] == '\0' )
    {
    	if(ch->pcdata->nick_first == NULL )
        {
	   send_to_char("You currently have no people nicknamed.\n\r",ch);
	   return;
        }
		else
		{
			send_to_char("You have the following nicknames.\n\r",ch);
			for(nick = ch->pcdata->nick_first; nick; nick = nick->next )
			{
				sprintf(buf, "%s is nicknamed to: %s\n\r",nick->shortd, nick->nickname);
				send_to_char(buf,ch);
			}
			return;
		}
    }

    if(arg[0] == '\0' || arg2[0] == '\0' )
    {
		send_to_char("Syntax:\n\r\tnickname <Character to be named> <String to namethem>\n\r\tnickname erase [all/playername]\n\r",ch);
		return;
    }

    if(!str_cmp(arg, "erase") )
    {
	if(!str_cmp(arg2, "all") )
	{
	    for(nick = ch->pcdata->nick_first; nick; nick = nick->next)
		free_nick(nick);
	    ch->pcdata->nick_first = NULL;
	    send_to_char("Nicknames erased.\n\r",ch);
	    return;
	}
	else {
	for(nick = ch->pcdata->nick_first; nick; nick = nick->next)
	{
	    if(!str_cmp(nick->shortd, arg2) )
	    {
		if( nick == ch->pcdata->nick_first )
		        ch->pcdata->nick_first = nick->next;

	       	free_nick(nick);
		printf_to_char(ch, "%s erased from your nickname list", arg2 );
		break;
	    }
  	}
	return;
	}
    }

    if( ( victim = get_char_room(ch, NULL, arg) ) == NULL )
    {
		send_to_char("They arn't here to nickname!\n\r",ch);
		return;
    }

	if(IS_NPC(victim) )
	{
		send_to_char("Not on mobs.\n\r",ch);
		return;
    }


    for(nick = ch->pcdata->nick_first; nick; nick = nick->next)
    {
		if(!str_cmp(victim->name, nick->realname) )
		{
			found = TRUE;
		    break;
 		}
    }

    if(!found)
    {
		nick = new_nick();
		free_string(nick->realname);
		free_string(nick->nickname);
		free_string(nick->shortd  );
		nick->realname = str_dup(victim->name);
		nick->nickname = str_dup(capitalize(arg2));
		nick->shortd   = str_dup(victim->short_descr);

		nick_to_char(ch, nick);
		printf_to_char(ch, "%s has been nicknamed too: %s\n\r",nick->shortd, nick->nickname);
		return;
    }
    else
    {
		free_string(nick->nickname);
		free_string(nick->shortd  );
		nick->nickname = str_dup(capitalize(arg2));
		nick->shortd   = str_dup(victim->short_descr);
		printf_to_char(ch, "%s's nickname has been changed too %s\n\r",nick->shortd, nick->nickname);
		return;
    }


}

void do_shortdescr(CHAR_DATA *ch, char *argument)
{
    char arg[MSL];

    arg[0] = '\0';

    sprintf(arg, "%s", argument);

    if(argument[0] == '\0' )
    {
	send_to_char("Syntax: shortdesc <shortdescripton>\n\r",ch);
	return;
    }

    if(strlen_color(arg) > 60 )
    {
	send_to_char("Short description over 60 characters. Description rejected.\n\r",ch);
	return;
    }
    if(strstr(argument, ch->name) )
    {
	send_to_char("Your name must not be included in your short description.\n\r",ch);
	return;
    }
    if(strlen_color(arg) < 5)
    {
	send_to_char("Pfft. It has to be longer than that!\n\r",ch);
	return;
    }

    printf_to_char(ch, "Your short desc has been changed too: %s\n\r",arg);
    free_string(ch->short_descr);
    ch->short_descr = str_dup(arg);
    return;
}

void do_introduce( CHAR_DATA *ch, char *argument)
{
    char arg[MSL], buf[MSL];
    CHAR_DATA *victim;
    NICK_DATA *nick;

    arg[0] = '\0';

    argument = one_argument(argument, arg);

    if(arg[0] == '\0')
    {
	send_to_char("Introduce yourself to whom?\n\r",ch);
	return;
    }

    if( (victim = get_char_room(ch, NULL, arg) ) == NULL )
    {
	send_to_char("You kindly introduce yourself to a wall.\n\r",ch);
	return;
    }

    if( has_nick_for_ch(victim, ch) )
    {
	send_to_char("You can't introduce yourself to someone who knows you!\n\r",ch);
	return;
    }

    sprintf(buf, "Hello, my name is %s.", ch->name);
    do_function(ch, &do_say, buf);

    nick = new_nick();
    free_string(nick->realname);
    free_string(nick->nickname);
    free_string(nick->shortd  );
    nick->realname = str_dup(ch->name);
    nick->nickname = str_dup(ch->name);
    nick->shortd   = str_dup(ch->short_descr);
    nick_to_char(victim, nick);
}

void do_immtitle(CHAR_DATA *ch, char *argument)
{
  if (argument[0] == '\0')
  { free_string(ch->pcdata->immtitle);
    ch->pcdata->immtitle = str_dup("");
    send_to_char("Immtitle cleared.\n\r", ch);
    return;
  }

  if (strlen_color(argument) > 12)
  {
    send_to_char("Immtitle must be 12 or under characters long.\n\r", ch); return;
  }

  free_string( ch->pcdata->immtitle );
  ch->pcdata->immtitle = str_dup(argument);
  send_to_char("Immtitle set.\n\r", ch);
}

void do_version (CHAR_DATA * ch, char *argument)
{
  char version[MAX_STRING_LENGTH];
  char buf[MAX_STRING_LENGTH];

  version[0] = '\0';

  if (IS_NPC (ch))
    return;

  if (ch->level < MAX_LEVEL)	/* Stuff trusted characters! */
    {
      read_version (version);
      sprintf (buf, "\n\rAl'haen current version is : %s\n\r", version);
      send_to_char (buf, ch);
      return;
    }

  else
    {
      if (argument[0] == '\0')
	{
	  read_version (version);
	  sprintf (buf, "\n\rAl'haen current version is : %s\n\r", version);
	  send_to_char (buf, ch);
	  return;
	}
      else
	{
	  if (write_version (argument))
	    {
	      sprintf (buf, "Al'haen current version changed to %s\n\r", argument);
	      send_to_char (buf, ch);
	      sprintf (buf, "%s has changed Al'haen current version number to %s",
		       ch->name, argument);
	      log_string (buf);
	    }
	  else
	    send_to_char ("Write version failed - please report", ch);

	  return;
	}
    }

}


bool write_version (char *argument)	/*Returns true if sucsessful, else false */
{
  FILE *versionfp;
  char buf[MAX_STRING_LENGTH];

  versionfp = file_open(VERSION_FILE,"w");
  sprintf (buf, "%s\n", argument);
  fprintf (versionfp, "%s", "#\n");
  fprintf (versionfp, "%s",  buf);
  file_close (versionfp);
  return TRUE;
}

void read_version (char *version)	/*dumps the version No. in version */
{
    FILE *versionfp;

    if (!file_exists(VERSION_FILE))
    {
	bug ("read_version : can't open version file", 0);
	sprintf (version, "V0.0 -- Please report!\n\r");
	return;
    }

    versionfp = file_open(VERSION_FILE, "r") ;

    if (fread_letter (versionfp) != '#')
    {
	bug ("read_version : # not found", 0);
	sprintf (version, "V0.0 -- Please report!\n\r");
    }
    else
	sprintf (version, "%s", fread_string_eol (versionfp));

    file_close(versionfp);
    return;
}

void display_bp(CHAR_DATA *ch, CHAR_DATA *victim)
{
   int	bp;
   char  buf[MSL];

   if ( (IS_NPC(ch)) || (IS_NPC(victim)) )
      return;

   if (victim->bp_points == 0)
       return;

   if (victim->bp_points < 0)
   {
       bp = -1 * victim->bp_points;
       sprintf(buf, "$N has %d black marks above $S shoulder.", bp);
       act( buf, ch, NULL, victim, TO_CHAR );
       return;
   }

   sprintf(buf, "$N has %d glowing rings floating above $S shoulder.\n\r", victim->bp_points);
   act( buf, ch, NULL, victim, TO_CHAR );
   return;
}

void do_autolevel( CHAR_DATA *ch, char *argument )
{
    if (IS_SET(ch->comm2,COMM_AUTOLEVEL))
    {
      send_to_char("You must now find the leveler and level on your own!\n\r",ch);
      REMOVE_BIT(ch->comm2,COMM_AUTOLEVEL);
    }
    else
    {
	  if (!IS_NPC(ch) && ch->pcdata->current_exp > 0)
	  {
              gain_exp(ch, ch->pcdata->current_exp);
	      ch->pcdata->current_exp = 0;
	  }

          send_to_char("You will now be automatically leveled!\n\r",ch);
          SET_BIT(ch->comm2,COMM_AUTOLEVEL);
    }
}

void do_petlevel( CHAR_DATA *ch, char *argument )
{

  if ( ch->pet == NULL )
  {
      send_to_char("You need a pet before you can level one up!\n\r", ch );
      return;
  }

  if (IS_SET( ch->comm2, COMM_PETLEVEL ) )
  {
      send_to_char("Your pets will no longer gain experience and level!\n\r", ch );
      REMOVE_BIT( ch->comm2, COMM_PETLEVEL );
      return;
  }

  else
  {
      send_to_char("Your pets will now gain experience and level with you!\n\r", ch );
      SET_BIT( ch->comm2, COMM_PETLEVEL );
      return;
  }
}

void do_affects2 (CHAR_DATA *ch, char *argument)
{
    AFFECT_DATA *paf, *paf_last = NULL;
    char *buf4;
    char buf3[MSL];
    char buf2[MSL];
    char buf[MSL];
    bool found = FALSE;
    long filter;
    long printme;
    BUFFER *buffer;
    OBJ_DATA *obj;
    int iWear;
    CHAR_DATA *victim;

    if ( IS_IMMORTAL ( ch ) && argument[0] )
    {
        victim = get_char_world ( ch, argument );
        if ( victim == NULL )
        {
            send_to_char ( "They're not in the game.\n\r", ch );
            return;
        }
    }
    else
        victim = ch;

    buffer = new_buf (  );
    if ( victim->affected != NULL )
    {
        if ( victim == ch )
            add_buf ( buffer,
                      "You are affected by the following spells:\n\r" );
        else
        {
            sprintf ( buf, "%s is affected by the following spells:\n\r",
                      PERS(victim, ch) );
            add_buf ( buffer, buf);
        }
        for ( paf = victim->affected; paf != NULL; paf = paf->next )
        {
            if ( paf_last != NULL && paf->type == paf_last->type )
            {
                if ( get_trust ( victim ) >= 20 )
                    add_buf ( buffer, "                          " );
                else
                    continue;
            }
            else
            {
                sprintf ( buf, "Spell: %-19s", skill_table[paf->type].name != NULL
                    ? skill_table[paf->type].name : "unknown" );
                add_buf ( buffer, buf);
            }

            if ( get_trust ( victim ) >= 20 )
            {
                sprintf ( buf, ": modifies %s by %d ",
                          flag_string ( apply_flags, paf->location ),
                          paf->modifier );
                add_buf ( buffer, buf);
                if ( paf->duration == -1 )
                    add_buf ( buffer, "permanently" );
                else
                {
                    sprintf ( buf, "for %d hours", paf->duration );
                    add_buf ( buffer, buf);
                }
            }

            add_buf ( buffer, "\n\r" );
            paf_last = paf;
        }
        found = TRUE;
        add_buf ( buffer, "\n\r" );
    }
    if ( race_table[victim->race].aff != 0 &&
         IS_AFFECTED ( victim, race_table[victim->race].aff ) )
    {
        if ( victim == ch )
            add_buf ( buffer,
                      "You are affected by the following racial abilities:\n\r" );
        else
        {
            sprintf ( buf,
                      "%s is affected by the following racial abilities:\n\r",
                      PERS(victim, ch) );
            add_buf ( buffer, buf);
        }

        strcpy ( buf3,
                 flag_string ( affect_flags, race_table[victim->race].aff ) );
        buf4 = buf3;
        buf4 = one_argument ( buf4, buf2 );
        while ( buf2[0] )
        {
            sprintf ( buf, "Spell: %-19s", buf2 );
            add_buf ( buffer, buf );
            add_buf ( buffer, "\n\r" );
            buf4 = one_argument ( buf4, buf2 );
        }
        found = TRUE;
        add_buf ( buffer, "\n\r" );
    }
    if ( victim->affected_by != 0 &&
         ( victim->affected_by != race_table[victim->race].aff ) )
    {
        bool print = FALSE;

        for ( iWear = 0; iWear < MAX_WEAR; iWear++ )
        {
            if ( ( obj = get_eq_char ( victim, iWear ) ) != NULL )
            {
                for ( paf = obj->affected; paf != NULL; paf = paf->next )
                {
                    if ( !IS_SET ( victim->affected_by, paf->bitvector ) )
                        continue;

                    if ( paf->where != TO_AFFECTS )
                        continue;

                    filter = paf->bitvector;
                    filter &= victim->affected_by;
                    printme = filter;
                    if ( !print )
                    {
                        if ( victim == ch )
                            add_buf ( buffer,
                                      "You are affected by the following equipment spells:\n\r" );
                        else
                        {
                            sprintf ( buf,
                                      "%s is affected by the following equipment spells:\n\r",
                                      PERS(victim, ch) );
                            add_buf ( buffer, buf);
                        }

                        print = TRUE;
                    }

                    strcpy ( buf3, flag_string ( affect_flags, printme ) );
                    buf4 = buf3;
                    buf4 = one_argument ( buf4, buf2 );
                    while ( buf2[0] )
                    {
                        sprintf ( buf, "Spell: %-19s: %s", buf2,
                                  obj->short_descr );
                        add_buf ( buffer, buf);
                        add_buf ( buffer, "\n\r" );
                        buf4 = one_argument ( buf4, buf2 );
                    }
                }
                if ( !obj->enchanted )
                {
                    for ( paf = obj->pIndexData->affected; paf != NULL;
                          paf = paf->next )
                    {
                        if ( !IS_SET ( victim->affected_by, paf->bitvector ) )
                            continue;
                        if ( paf->where != TO_AFFECTS )
                            continue;
                        filter = paf->bitvector;
                        filter &= victim->affected_by;
                        printme = filter;
                        if ( !print )
                        {
                            if ( victim == ch )
                                add_buf ( buffer,
                                          "You are affected by the following equipment spells:\n\r" );
                            else
                            {
                                sprintf ( buf,
                                          "%s is affected by the following equipment spells:\n\r",
                                          PERS(victim, ch) );
                                add_buf ( buffer, buf);
                            }
                            print = TRUE;
                        }

                        strcpy ( buf3,
                                 flag_string ( affect_flags, printme ) );

                        buf4 = buf3;
                        buf4 = one_argument ( buf4, buf2 );
                        while ( buf2[0] )
                        {
                            sprintf ( buf, "Spell: %-19s: %s", buf2,
                                      obj->short_descr );
                            add_buf ( buffer, buf);
                            add_buf ( buffer, "\n\r" );
                            buf4 = one_argument ( buf4, buf2 );
                        }
                    }
                }
            }
        }
        found = TRUE;
        if ( print )
            add_buf ( buffer, "\n\r" );
    }
    if ( !found )
    {
        if ( victim == ch )
            add_buf ( buffer, "You are not affected by any spells.\n\r" );
        else
        {
            sprintf ( buf, "%s is not affected by any spells.\n\r",
                      PERS(victim, ch) );
            add_buf ( buffer, buf);
        }
    }

    page_to_char ( buf_string ( buffer ), ch );
    free_buf ( buffer );
    return;
}
char *dofuname args ((CMD_DATA *cmd ) );
extern const struct size_type log_table[];
void do_helptally(CHAR_DATA *ch, char *argument)
{
    HELP_DATA *pHelp;
    int tally, count = 0, sn;
    char buf[MSL*3], buf2[MSL];
    bool found = FALSE;
    int col;
    char arg[MIL];
	CMD_DATA *cmd;
	char olc_list[16][8];
	BUFFER *pbuf;

	argument = one_argument(argument, arg);
	if(arg[0] == '\0')
	{
		buf[0] = '\0';
		tally = 0;
		col = 0;
		for ( cmd = cmd_first; cmd; cmd = cmd->next)
	        {
			count++;
			for ( pHelp = help_first; pHelp != NULL; pHelp = pHelp->next )
	                {
	                        if ( is_name( cmd->name, pHelp->keyword ) )
	                        {
	                                tally++;
	                                found = TRUE;
	                                break;
	                        }


	                }
	                if(!found)
	                {

						  sprintf( buf2, " [%-11s]", cmd->name);
						  strcat( buf, buf2 );

						  if ( ++col % 5 == 0 )
								strcat(buf,  "\n\r");




	                }
	                found = FALSE;
		 }
						  if (col % 5 != 0 )
						  {
								strcat(buf, "\n\r");
								col = 0;
						  }
						  if ( col % 5 != 0 )
								strcat(buf, "\n\r");

		 printf_to_char(ch, "The following commands lack a helpfile.\n\r%s",buf);
	         printf_to_char(ch, "You have %d helpfiles that have keywords as a command name. You have %d commands.\n\r", tally, count);
	         return;
	}
	else if(!str_prefix(arg, "moreinfo"))
	{	pbuf = new_buf();
		tally = 0;
		
		for ( cmd = cmd_first; cmd; cmd = cmd->next)
		{	count++;
			for ( pHelp = help_first; pHelp != NULL; pHelp = pHelp->next )
			{	if ( is_name( cmd->name, pHelp->keyword ) )
                {	tally++;
					found = TRUE;
					break;
				}
			}
			if(!found)
            {	sprintf( buf2, "{D[{C%-12s{D] {W({c%-3d{W){w %-13s %-3s %-6s {c%s{x\n\r", cmd->name, cmd->level, position_table[cmd->position].name, cmd->show == TRUE ? "Yes" : "No" , log_table[cmd->log].name, dofuname(cmd));
				add_buf(pbuf, buf2 );
			}
			found = FALSE;
		}
		printf_to_char(ch, "The following commands lack a helpfile.\n\r[Command Name] Level Min Position Show Log DoFUN\n\r");
		page_to_char(buf_string(pbuf),ch);
		return;
	}
	else if(!str_prefix(arg, "races")){
		buf[0] = '\0';
		tally = 0;
		col = 0;
		for(sn = 1; sn <= MAX_PC_RACE ; sn++ )
	    {
	    	if(!race_table[sn].pc_race)
	    		continue;
			count++;
			for ( pHelp = help_first; pHelp != NULL; pHelp = pHelp->next )
	        {
	            if ( is_name( race_table[sn].name, pHelp->keyword ))
	            {
	                tally++;
	                found = TRUE;
	                break;
	            }
	        }
			if(!found)
            {
				sprintf( buf2, " [%-17.17s]", race_table[sn].name);
				strcat( buf, buf2 );

				if ( ++col % 4 == 0 )
					strcat(buf,  "\n\r");
            }
	        found = FALSE;
		}
		if (col % 4 != 0 )
		{
			strcat(buf, "\n\r");
			col = 0;
		}
		if ( col % 4 != 0 )
			strcat(buf, "\n\r");

	 	printf_to_char(ch, "The following races lack a helpfile.\n\r%s",buf);
	 	printf_to_char(ch, "You have %d helpfiles that have race names as a keyword.\n\r", tally);
	    return;
	}
	else if(!str_prefix(arg, "classes")){
		buf[0] = '\0';
		tally = 0;
		col = 0;
		for(sn = 0; sn < MAX_CLASS ; sn++ )
	    {
			count++;
			for ( pHelp = help_first; pHelp != NULL; pHelp = pHelp->next )
	        {
	            if ( is_name( class_table[sn].name, pHelp->keyword ))
	            {
	                tally++;
	                found = TRUE;
	                break;
	            }
	        }
			if(!found)
            {
				sprintf( buf2, " [%-17.17s]", class_table[sn].name);
				strcat( buf, buf2 );

				if ( ++col % 4 == 0 )
					strcat(buf,  "\n\r");
            }
	        found = FALSE;
		}
		if (col % 4 != 0 )
		{
			strcat(buf, "\n\r");
			col = 0;
		}
		if ( col % 4 != 0 )
			strcat(buf, "\n\r");

	 	printf_to_char(ch, "The following classes lack a helpfile.\n\r%s",buf);
	 	printf_to_char(ch, "You have %d helpfiles that have class names as a keyword.\n\r", tally);
	    return;
	}
	else if(!str_prefix(arg, "olc")){
		buf[0] = '\0';
		tally = 0;
		col = 0;
		strcpy(olc_list[0], "aedit");  strcpy(olc_list[1], "redit");   strcpy(olc_list[2], "medit");
		strcpy(olc_list[3], "oedit");  strcpy(olc_list[4], "mpedit");  strcpy(olc_list[5], "hedit");
		strcpy(olc_list[6], "opedit"); strcpy(olc_list[7], "rpedit");  strcpy(olc_list[8], "gedit");
		strcpy(olc_list[9], "skedit"); strcpy(olc_list[10], "cmdedit"); strcpy(olc_list[11], "rlgedit");
		strcpy(olc_list[12], "gredit"); strcpy(olc_list[13], "lngedit"); strcpy(olc_list[14], "raedit");
		strcpy(olc_list[15], "cledit");

		for(sn = 0; sn < 16 ; sn++ )
	    {
			count++;
			for ( pHelp = help_first; pHelp != NULL; pHelp = pHelp->next )
	        {
	            if ( is_name( olc_list[sn], pHelp->keyword ))
	            {
	                tally++;
	                found = TRUE;
	                break;
	            }
	        }
			if(!found)
            {
				sprintf( buf2, " [%-17.17s]", olc_list[sn]);
				strcat( buf, buf2 );

				if ( ++col % 4 == 0 )
					strcat(buf,  "\n\r");
            }
	        found = FALSE;
		}
		if (col % 4 != 0 )
		{
			strcat(buf, "\n\r");
			col = 0;
		}
		if ( col % 4 != 0 )
			strcat(buf, "\n\r");

	 	printf_to_char(ch, "The following OLC modes lack a helpfile.\n\r%s",buf);
	 	printf_to_char(ch, "You have %d helpfiles that have OLC modes as a keyword.\n\r", tally);
	    return;
	}
	else if(!str_prefix(arg, "skills") || !str_prefix(arg, "spells")){
		buf[0] = '\0';
		tally = 0;
		col = 0;
		for(sn = 0; sn < MAX_SKILL ; sn++ )
	    {
			count++;

			for ( pHelp = help_first; pHelp != NULL; pHelp = pHelp->next )
	                {
	                        if ( is_name( skill_table[sn].name, pHelp->keyword ))
	                        {
	                            tally++;
	                            found = TRUE;
	                            break;
	                        }


	                }
					if(!found)
	                {
						  sprintf( buf2, " [%-17.17s]", skill_table[sn].name);
						  strcat( buf, buf2 );

						  if ( ++col % 4 == 0 )
								strcat(buf,  "\n\r");
	                }
	                found = FALSE;
		 }
						  if (col % 4 != 0 )
						  {
								strcat(buf, "\n\r");
								col = 0;
						  }
						  if ( col % 4 != 0 )
								strcat(buf, "\n\r");

		if(!str_prefix(arg, "skills")){
		 	printf_to_char(ch, "The following skills lack a helpfile.\n\r%s",buf);
		 	printf_to_char(ch, "You have %d helpfiles that have skill names as a keyword.\n\r", tally);
		}
		else{
			printf_to_char(ch, "The following spells lack a helpfile.\n\r%s",buf);
	     	printf_to_char(ch, "You have %d helpfiles that have spell names as a keyword.\n\r", tally);
		}
	    return;
	}
	else
		send_to_char("Invalid argument. Possible arguments are \"races\", \"classes\" or \"olc\".\n\r", ch);
}


int mortal_online(CHAR_DATA *ch)
{
    DESCRIPTOR_DATA *d;
    int i = 0;

    for ( d = descriptor_list; d != NULL; d = d->next )
    {
	CHAR_DATA *vch;
	vch = d->original ? d->original : d->character;
	if(d->connected != CON_PLAYING)
	    continue;
	if(!IS_IMMORTAL(vch) && can_see(ch, vch) )
	    i++;
    }
    return i;
}

int immortal_online(CHAR_DATA *ch)
{
    DESCRIPTOR_DATA *d;
    int i = 0;
    for ( d = descriptor_list; d != NULL; d = d->next )
    {
	CHAR_DATA *vch;
	vch = d->original ? d->original : d->character;
	if(d->connected != CON_PLAYING)
	    continue;
	if(IS_IMMORTAL(vch) && can_see(ch, vch) )
	    i++;
    }
    return i;
}

void do_email (CHAR_DATA *ch, char *argument)
{
    EMAIL_DATA * pMail;

    printf_to_char(ch, "%-10s %-20s\n\r", "Name", "E-mail" );
    printf_to_char(ch, "======================================\n\r");

    if(argument[0] == '\0' )
    {
	for(pMail = email_first ; pMail ; pMail = pMail->next )
	    printf_to_char(ch, "%-10s %-20s\n\r", pMail->name, pMail->email );
        return;
    }
    if( (pMail = email_lookup(argument) ) == NULL )
    {
	send_to_char("No such person has listed there email by that name.\n\r",ch);
	return;
    }
    printf_to_char(ch, "%-10s %-20s\n\r", pMail->name, pMail->email );

    return;
}

void save_email()
{
    FILE *fp;
    EMAIL_DATA *pMail;

    if ( (fp = file_open("../data/email.dat", "w" ) ) == NULL )
    {
	logf2("Email file gone\n\r");
 	return;
    }
     for( pMail = email_first ; pMail ; pMail = pMail->next )
     {
    	fprintf(fp, "Name %s~\n", pMail->name );
	fprintf(fp, "Email %s~\n", pMail->email );
     }
    fprintf(fp, "$\n");
    file_close(fp);
   return;
}

void load_email()
{
     FILE *fp;
     EMAIL_DATA *pMail = NULL;
     char *word;

     if( file_exists("../data/email.dat" ) )
     {
	fp = file_open("../data/email.dat", "r" );
	for(;;)
 	{
	    word = (char *)(feof( fp ) ? "End" : fread_word( fp ));
	    if(word[0] == '$' )
		return;

	    if(!str_cmp(word, "Name" ) )
	    {
		pMail = new_email();
		pMail->name = fread_string(fp);
	    }
	    if(!str_cmp(word, "Email" ) )
		pMail->email = fread_string(fp);
	}
      }
      return;
}

/* show suppression settings - Gregor Stipicic aka Fade, 2001 */
void do_suppress(CHAR_DATA *ch, char *argument)
{
  char arg[MIL];

  argument = one_argument(argument, arg);

  if(IS_NPC(ch))
     return;

  if(arg[0]=='\0')
  {
     send_to_char("Suppression settings:\n\r",ch);
     printf_to_char(ch,"Weapon flags:   %s  Flag effects: %s  Dodge/etc.: %s\n\r",
     SUP_OO(ch,SUPPRESS_FLAGS), SUP_OO(ch,SUPPRESS_FLAG_EFFECTS), SUP_OO(ch,SUPPRESS_DODGE));

    printf_to_char(ch,"Object effects: %s\n\r", SUP_OO(ch,SUPPRESS_BURN));
    printf_to_char(ch,"Shields are %s compressed into one line.\n\r",
    IS_SET(ch->pcdata->suppress,SUPPRESS_SHIELD)?"":"not ");
    return;
  }

  if(!str_prefix(arg,"weapon"))
  {
     if(IS_SET(ch->pcdata->suppress,SUPPRESS_FLAGS))
     {
        REMOVE_BIT(ch->pcdata->suppress,SUPPRESS_FLAGS);
        send_to_char("Weapon flags are no longer suppressed.\n\r",ch);
     }

     else
     {
        SET_BIT(ch->pcdata->suppress,SUPPRESS_FLAGS);
        send_to_char("Weapon flags are suppressed now.\n\r",ch);
     }

     return;
  }

  if(!str_prefix(arg,"flags"))
  {
     if(IS_SET(ch->pcdata->suppress,SUPPRESS_FLAG_EFFECTS))
     {
        REMOVE_BIT(ch->pcdata->suppress,SUPPRESS_FLAG_EFFECTS);
        send_to_char("Flag effects are no longer suppressed.\n\r",ch);
     }

     else
     {
        SET_BIT(ch->pcdata->suppress,SUPPRESS_FLAG_EFFECTS);
        send_to_char("Flag effects are suppressed now.\n\r",ch);
     }

     return;
  }

  if(!str_prefix(arg,"dodge"))
  {
     if(IS_SET(ch->pcdata->suppress,SUPPRESS_DODGE))
     {
        REMOVE_BIT(ch->pcdata->suppress,SUPPRESS_DODGE);
        send_to_char("Dodges/etc. are no longer suppressed.\n\r",ch);
     }

     else
     {
        SET_BIT(ch->pcdata->suppress,SUPPRESS_DODGE);
        send_to_char("Dodges/etc. are suppressed now.\n\r",ch);
     }

     return;
  }

  if(!str_prefix(arg,"object"))
  {
     if(IS_SET(ch->pcdata->suppress,SUPPRESS_BURN))
     {
        REMOVE_BIT(ch->pcdata->suppress,SUPPRESS_BURN);
        send_to_char("Object effects (burning potions, etc.) are no longer suppressed.\n\r",ch);
     }

     else
     {
        SET_BIT(ch->pcdata->suppress,SUPPRESS_BURN);
        send_to_char("Object effects (burning potions, etc.) are suppressed now.\n\r",ch);
     }

     return;
  }

  if(!str_prefix(arg,"shields"))
  {
     if(IS_SET(ch->pcdata->suppress,SUPPRESS_SHIELD))
     {
        REMOVE_BIT(ch->pcdata->suppress,SUPPRESS_SHIELD);
        SET_BIT(ch->pcdata->suppress,SUPPRESS_SHIELD_COMP);
        send_to_char("Shields are no longer compressed into one line.\n\r",ch);
     }

     else
     {
        SET_BIT(ch->pcdata->suppress,SUPPRESS_SHIELD);
        REMOVE_BIT(ch->pcdata->suppress,SUPPRESS_SHIELD_COMP);
        send_to_char("Shields are compressed into one line now.\n\r",ch);
     }

     return;
  }

  send_to_char("Syntax: suppress weapon/flags/dodge/object/shields\n\r",ch);
  return;

}

void do_away( CHAR_DATA *ch, char *argument )
{

  if ( IS_NPC( ch ) )
  {
      send_to_char( "I'm sorry mobs don't have away messages.\n\r", ch );
      return;
  }

  printf_to_char( ch, "Your current away message is: %s", ch->pcdata->afk );
  return;

}

void do_resist( CHAR_DATA *ch, char *argument )
{	int i;
	char buf[MSL];
	int col = 0;

	for( i = 0; i < MAX_RES ; i++ )
	{	sprintf(buf, "%s[%3d]", res_flags[i].name, ch->resist[i] );
		printf_to_char(ch, "%-15s", buf);
		if( !(++col	% 5) ) send_to_char("\n\r",ch);
	}
	send_to_char("\n\r",ch);
	return;
}
