
/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik Stfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

/***************************************************************************
*	ROM 2.4 is copyright 1993-1998 Russ Taylor			   *
*	ROM has been brought to you by the ROM consortium		   *
*	    Russ Taylor (rtaylor@hypercube.org)				   *
*	    Gabrielle Taylor (gtaylor@hypercube.org)			   *
*	    Brian Moore (zump@rom.org)					   *
*	By using this code, you have agreed to follow the terms of the	   *
*	ROM license, in the file Rom24/doc/rom.license			   *
***************************************************************************/

#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#endif
#include <stdio.h>
#include <time.h>
#include "include.h"


/* weapon selection table */
const	struct	weapon_type	weapon_table	[]	=
{
   { "sword",	&OBJ_VNUM_SCHOOL_SWORD,	WEAPON_SWORD	},
   { "mace",	&OBJ_VNUM_SCHOOL_MACE,	WEAPON_MACE 	},
   { "dagger",	&OBJ_VNUM_SCHOOL_DAGGER,	WEAPON_DAGGER	},
   { "axe",	&OBJ_VNUM_SCHOOL_AXE,	WEAPON_AXE	},
   { "flail",	&OBJ_VNUM_SCHOOL_FLAIL,	WEAPON_FLAIL	},
   { "whip",	&OBJ_VNUM_SCHOOL_WHIP,	WEAPON_WHIP	},
   { "polearm", &OBJ_VNUM_SCHOOL_POLEARM,WEAPON_POLEARM	},
   { "bow",     &OBJ_VNUM_BOW,           WEAPON_BOW      },
	{ "staff",  &OBJ_VNUM_STAFF,		 WEAPON_STAFF	 },
   { NULL,	0,				0	}
};

/* wiznet table and prototype for future flag setting */
const   struct wiznet_type      wiznet_table    []              =
{
   {    "on",           WIZ_ON,         IM },
   {    "prefix",	WIZ_PREFIX,	IM },
   {    "ticks",        WIZ_TICKS,      IM },
   {    "logins",       WIZ_LOGINS,     IM },
   {    "sites",        WIZ_SITES,      L4 },
   {    "links",        WIZ_LINKS,      L7 },
   {	"newbies",	WIZ_NEWBIE,	IM },
   {	"spam",		WIZ_SPAM,	L5 },
   {    "deaths",       WIZ_DEATHS,     IM },
   {    "resets",       WIZ_RESETS,     L4 },
   {    "mobdeaths",    WIZ_MOBDEATHS,  L4 },
   {    "flags",	WIZ_FLAGS,	L5 },
   {	"penalties",	WIZ_PENALTIES,	L5 },
   {	"saccing",	WIZ_SACCING,	L5 },
   {	"levels",	WIZ_LEVELS,	IM },
   {	"load",		WIZ_LOAD,	L2 },
   {	"restore",	WIZ_RESTORE,	L2 },
   {	"snoops",	WIZ_SNOOPS,	L2 },
   {	"switches",	WIZ_SWITCHES,	L2 },
   {	"secure",	WIZ_SECURE,	L1 },
   {    "olc",          WIZ_OLC,        L4 },
	{   "unique",	WIZ_UNIQUE,			L4	},
   {	NULL,		0,		0  }
};

/* attack table  -- not very organized :( */
const 	struct attack_type	attack_table	[MAX_DAMAGE_MESSAGE]	=
{
    { 	"none",		"hit",		-1},  /*  0 */
    {	"slice",	"slice", 	DAM_SLASH	},	
    {   "stab",		"stab",		DAM_PIERCE	},
    {	"slash",	"slash",	DAM_SLASH	},
    {	"whip",		"whip",		DAM_SLASH	},
    {   "claw",		"claw",		DAM_SLASH	},  /*  5 */
    {	"blast",	"blast",	DAM_BASH	},
    {   "pound",	"pound",	DAM_BASH	},
    {	"crush",	"crush",	DAM_BASH	},
    {   "grep",		"grep",		DAM_SLASH	},
    {	"bite",		"bite",		DAM_PIERCE	},  /* 10 */
    {   "pierce",	"pierce",	DAM_PIERCE	},
    {   "suction",	"suction",	DAM_BASH	},
    {	"beating",	"beating",	DAM_BASH	},
    {	"charge",	"charge",	DAM_BASH	},  /* 14 */
    { 	"slap",		"slap",		DAM_BASH	},
    {	"punch",	"punch",	DAM_BASH	},
    {	"cleave",	"cleave",	DAM_SLASH	},
    {	"scratch",	"scratch",	DAM_PIERCE	},
    {   "peck",		"peck",		DAM_PIERCE	},
    {   "peckb",	"peck",		DAM_BASH	},
    {   "chop",		"chop",		DAM_SLASH	},  /* 21 */
    {   "sting",	"sting",	DAM_PIERCE	},
    {   "smash",	 "smash",	DAM_BASH	},
    {   "shbite",	"shocking bite",DAM_ELECTRIC	},
    {	"flbite",	"flaming bite", DAM_FIRE	},
    {	"frbite",	"freezing bite", DAM_COLD	},  /* 26 */
    {	"chomp",	"chomp",	DAM_PIERCE	},
    {   "thrust",	"thrust",	DAM_PIERCE	},
    {	"shock",	"shock",	DAM_ELECTRIC	},
    {   "thwack",	"thwack",	DAM_BASH	},
    {   "flame",	"flame",	DAM_FIRE	},
    {   "chill",	"chill",	DAM_COLD	},	/* 32 */
    {   NULL,		NULL,		0		}
};

/*
 * Attribute bonus tables.
 */
const	struct	str_app_type	str_app		[51]		=
{
    { -5, -4,   0,  0  },  /* 0  */
    { -5, -4,   3,  1  },  /* 1  */
    { -3, -2,   3,  2  },
    { -3, -1,  10,  3  },  /* 3  */
    { -2, -1,  25,  4  },
    { -2, -1,  55,  5  },  /* 5  */
    { -1,  0,  80,  6  },
    { -1,  0,  90,  7  },
    {  0,  0, 100,  8  },
    {  0,  0, 100,  9  },
    {  0,  0, 115, 10  }, /* 10  */
    {  0,  0, 115, 11  },
    {  0,  0, 130, 12  },
    {  0,  0, 130, 13  }, /* 13  */
    {  0,  1, 140, 14  },
    {  1,  1, 150, 15  }, /* 15  */
    {  1,  2, 165, 16  },
    {  2,  3, 180, 22  },
    {  2,  3, 200, 25  }, /* 18  */
    {  3,  4, 225, 30  },
    {  3,  5, 250, 35  }, /* 20  */
    {  4,  6, 300, 40  },
    {  4,  6, 350, 45  },
    {  5,  7, 400, 50  },
    {  5,  8, 425, 55  },
    {  6,  9, 440, 60  }, /* 25   */
    {  6,  9, 450, 63  },
    {  7, 10, 460, 66  },
    {  7, 10, 470, 69  },
    {  8, 11, 480, 72  },
    {  8, 11, 490, 75  }, /* 30	 */
    {  9, 12, 500, 78  },  
    {  9, 13, 510, 81  },
    { 10, 13, 520, 84  },
    { 11, 14, 530, 87  },
    { 11, 14, 540, 90  }, /* 35  */
    { 13, 15, 550, 93  },
    { 13, 15, 560, 96  },    
    { 14, 16, 570, 99  },
    { 14, 16, 580, 102 },
    { 15, 17, 590, 105 }, /* 40  */
    { 16, 18, 600, 108 },
    { 16, 19, 610, 111 },
    { 17, 19, 620, 114 },
    { 17, 20, 630, 117 },
    { 18, 20, 640, 120 }, /* 45  */
    { 18, 21, 650, 123 },
    { 19, 21, 660, 126 },
    { 19, 22, 670, 129 },
    { 20, 22, 680, 132 },
    { 21, 23, 690, 135 }  /* 50 */   
};



const	struct	int_app_type	int_app		[51]		=
{
    {  3 },	/*  0 */
    {  5 },	/*  1 */
    {  7 },
    {  8 },	/*  3 */
    {  9 },
    { 10 },	/*  5 */
    { 11 },
    { 12 },
    { 13 },
    { 15 },
    { 17 },	/* 10 */
    { 19 },
    { 22 },
    { 25 },
    { 28 },
    { 30 },	/* 15 */
    { 32 },
    { 34 },
    { 36 },	/* 18 */
    { 38 },
    { 40 },	/* 20 */
    { 42 },
    { 44 },
    { 46 },
    { 48 },
    { 50 },	/* 25 */
    { 51 },
    { 52 },
    { 53 },
    { 54 },
    { 55 },     /* 30 */
    { 56 },
    { 58 },
    { 59 },
    { 60 },
    { 61 },     /* 35 */
    { 62 },
    { 63 },
    { 64 },
    { 65 },
    { 66 },     /* 40 */
    { 67 },
    { 69 },
    { 71 },
    { 73 },
    { 75 },     /* 45 */
    { 77 },
    { 79 },
    { 81 },
    { 83 },
    { 85 }      /* 50 */
};



const	struct	wis_app_type	wis_app		[51]		=
{
    { 0  },	/*  0 */
    { 0  },	/*  1 */
    { 0  },
    { 0  },	/*  3 */
    { 0  },
    { 1  },	/*  5 */
    { 1  },
    { 1  },
    { 1  },
    { 1  },
    { 1  },	/* 10 */
    { 1  },
    { 1  },
    { 1  },
    { 1  },
    { 2  },	/* 15 */
    { 2  },
    { 2  },
    { 3  },	/* 18 */
    { 3  },
    { 3  },	/* 20 */
    { 3  },
    { 4  },
    { 4  },
    { 4  },
    { 5  },	/* 25 */
    { 5  },
    { 5  },
    { 5  },
    { 6  },    
    { 6  },     /* 30 */
    { 6  },
    { 6  },
    { 7  },
    { 7  },
    { 7  },     /* 35 */
    { 8  },
    { 8  },
    { 8  },
    { 8  },
    { 9  },     /* 40 */
    { 9  },
    { 9  },
    { 9  },
    { 10 },
    { 10 },     /* 45 */
    { 10 },
    { 11 },
    { 11 },
    { 11 },
    { 12 }      /* 50 */
};



const	struct	dex_app_type	dex_app		[51]		=
{
    {   60 },   /* 0 */
    {   50 },   /* 1 */
    {   50 },
    {   40 },
    {   30 },
    {   20 },   /* 5 */
    {   10 },
    {    0 },
    {    0 },
    {    0 },
    {    0 },   /* 10 */
    {    0 },
    {    0 },
    {    0 },
    {    0 },
    { - 10 },   /* 15 */
    { - 15 },
    { - 20 },
    { - 30 },
    { - 40 },
    { - 50 },   /* 20 */
    { - 60 },
    { - 75 },
    { - 90 },
    { -105 },
    { -120 },   /* 25 */
    { -125 },   
    { -130 },
    { -135 },
    { -140 },
    { -145 },   /* 30 */
    { -150 },
    { -155 },
    { -160 },
    { -165 },
    { -170 },   /* 35 */
    { -175 },    
    { -180 },  
    { -185 },
    { -190 },
    { -195 },   /* 40 */
    { -200 },
    { -205 },
    { -210 },
    { -215 },
    { -220 },   /* 45 */
    { -225 },
    { -230 },
    { -235 },
    { -240 },
    { -245 }    /* 50 */
};


const	struct	con_app_type	con_app		[51]		=
{
    { -4, 20 },   /*  0 */
    { -3, 25 },   /*  1 */
    { -2, 30 },
    { -2, 35 },	  /*  3 */
    { -1, 40 },
    { -1, 45 },   /*  5 */
    { -1, 50 },
    {  0, 55 },
    {  0, 60 },
    {  0, 65 },
    {  0, 70 },   /* 10 */
    {  0, 75 },
    {  0, 80 },
    {  0, 85 },
    {  0, 88 },
    {  1, 90 },   /* 15 */
    {  2, 95 },
    {  2, 97 },
    {  3, 99 },   /* 18 */
    {  3, 99 },
    {  4, 99 },   /* 20 */
    {  4, 99 },
    {  5, 99 },
    {  6, 99 },
    {  7, 99 },
    {  8, 99 },    /* 25 */
    {  8, 99 },
    {  8, 99 },
    {  9, 99 },
    {  9, 99 },
    { 10, 99 },    /* 30 */
    { 10, 99 },
    { 10, 99 },
    { 11, 99 },
    { 11, 99 },
    { 12, 99 },    /* 35 */
    { 12, 99 },
    { 12, 99 },
    { 13, 99 },
    { 13, 99 },
    { 14, 99 },    /* 40 */
    { 14, 99 },
    { 14, 99 }, 
    { 15, 99 },
    { 15, 99 },
    { 16, 99 },    /* 45 */
    { 16, 99 },
    { 16, 99 },
    { 17, 99 },    
    { 17, 99 },
    { 17, 99 }     /* 50 */
};



/*
 * Liquid properties.
 * Used in world.obj.
 */
const	struct	liq_type	liq_table	[]	=
{
/*    name			color	proof, full, thirst, food, ssize */
    { "water",			"clear",	{   0, 1, 10, 0, 16 }	},
    { "beer",			"amber",	{  12, 1,  8, 1, 12 }	},
    { "red wine",		"burgundy",	{  30, 1,  8, 1,  5 }	},
    { "ale",			"brown",	{  15, 1,  8, 1, 12 }	},
    { "dark ale",		"dark",		{  16, 1,  8, 1, 12 }	},

    { "whisky",			"golden",	{ 120, 1,  5, 0,  2 }	},
    { "lemonade",		"pink",		{   0, 1,  9, 2, 12 }	},
    { "firebreather",		"boiling",	{ 190, 0,  4, 0,  2 }	},
    { "local specialty",	"clear",	{ 151, 1,  3, 0,  2 }	},
    { "slime mold juice",	"green",	{   0, 2, -8, 1,  2 }	},

    { "milk",			"white",	{   0, 2,  9, 3, 12 }	},
    { "tea",			"tan",		{   0, 1,  8, 0,  6 }	},
    { "coffee",			"black",	{   0, 1,  8, 0,  6 }	},
    { "blood",			"red",		{   0, 2, -1, 2,  6 }	},
    { "salt water",		"clear",	{   0, 1, -2, 0,  1 }	},

    { "coke",			"brown",	{   0, 2,  9, 2, 12 }	}, 
    { "root beer",		"brown",	{   0, 2,  9, 2, 12 }   },
    { "elvish wine",		"green",	{  35, 2,  8, 1,  5 }   },
    { "white wine",		"golden",	{  28, 1,  8, 1,  5 }   },
    { "champagne",		"golden",	{  32, 1,  8, 1,  5 }   },

    { "mead",			"honey-colored",{  34, 2,  8, 2, 12 }   },
    { "rose wine",		"pink",		{  26, 1,  8, 1,  5 }	},
    { "benedictine wine",	"burgundy",	{  40, 1,  8, 1,  5 }   },
    { "vodka",			"clear",	{ 130, 1,  5, 0,  2 }   },
    { "cranberry juice",	"red",		{   0, 1,  9, 2, 12 }	},

    { "orange juice",		"orange",	{   0, 2,  9, 3, 12 }   }, 
    { "absinthe",		"green",	{ 200, 1,  4, 0,  2 }	},
    { "brandy",			"golden",	{  80, 1,  5, 0,  4 }	},
    { "aquavit",		"clear",	{ 140, 1,  5, 0,  2 }	},
    { "schnapps",		"clear",	{  90, 1,  5, 0,  2 }   },

    { "icewine",		"purple",	{  50, 2,  6, 1,  5 }	},
    { "amontillado",		"burgundy",	{  35, 2,  8, 1,  5 }	},
    { "sherry",			"red",		{  38, 2,  7, 1,  5 }   },	
    { "framboise",		"red",		{  50, 1,  7, 1,  5 }   },
    { "rum",			"amber",	{ 151, 1,  4, 0,  2 }	},

    { "cordial",		"clear",	{ 100, 1,  5, 0,  2 }   },
    { "magic potion",         "multi-coloured", { 0,   1, 10, 0, 16 }   }, 
    { NULL,			NULL,		{   0, 0,  0, 0,  0 }	}
};



const struct weight_type weight_table [ ] =
{
    { "slender" },
    { "slim"    },
    { "average" },
    { "stocky"  },
    { "heavy"   },
    { NULL      }
};                   

const struct eye_type eye_table [] =
{
    { "blue"   },
    { "green"  },
    { "brown"  },
    { "black"  },
    { "white"  },
    { "clear"  },
    { "red"    },
    { NULL     }
};
      
const struct height_type height_table [] =
{
    { "short"    },
    { "midget"   },
    { "average"  },
    { "tall"     },
    { "giant"    },
    { NULL       }
};     


const struct hair_type hair_table [] =
{
    { "blond"   },
    { "red"     },
    { "black"   },
    { "brown"   },
    { "white"   },
    { "blue"    },
    { NULL      }
};       

const struct sorcerer_type sorcerer_table [] =
{
	{	"Briotic",		CRYSTAL_JET,
		{	"Soul steal", "Heal", "Death burst", "Ressurect", "Demon", "Angel", "Blade Drain", "Divine Protection" }
	},
	
	{	"Aphotic",		CRYSTAL_CARN,
		{	"Light spear", "Dark energy", "Shadow", "Engulf Shadow", "Light flare",  "Aurora Beast", "", "" }
	},

	{	"Pyretic",		CRYSTAL_BLOOD,
		{	"Flame blast",	"Fire shield", "Flame Beast", "Frost blast", "Flame blade", "Frost blade", "", "" }
	},

	{	"Hydrotic",		CRYSTAL_AQUA,
		{	"Water spike",	"Water shield", "Bubble", "Typhloyd", "Brittalize", "", "", "" }
	},

	{	"Aeratic",		CRYSTAL_AMETH,
		{	"Fly", "Lightning", "Syphloyd", "Electric blade", "Air Cyclone",  "", "", "" }
	},

	{	"Terratic",		CRYSTAL_QUARTZ,
		{	"Earthquake",	"Rock blast", "Material skin", "Gollum", "Crystal rain", "","", "" }
	},

	{	NULL, 0, { "", "","", "","", "", "", "" }  }
};
