/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik Stfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

/***************************************************************************
*	ROM 2.4 is copyright 1993-1998 Russ Taylor			   *
*	ROM has been brought to you by the ROM consortium		   *
*	    Russ Taylor (rtaylor@hypercube.org)				   *
*	    Gabrielle Taylor (gtaylor@hypercube.org)			   *
*	    Brian Moore (zump@rom.org)					   *
*	By using this code, you have agreed to follow the terms of the	   *
*	ROM license, in the file Rom24/doc/rom.license			   *
***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#if defined(macintosh)
#include <types.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#endif

#include "include.h"

extern int  flag_lookup args((const char *name, const struct flag_type *flag_table));

/*
 * Snarf a mob section.  new style
 */
/*
 * Snarf an obj section. new style
 */
void load_objects( FILE *fp )
{
    OBJ_INDEX_DATA *pObjIndex;

    if ( !area_last )   /* OLC */
    {
        bug( "Load_objects: no #AREA seen yet.", 0 );
        exit( 1 );
    }
 
    for ( ; ; )
    {
        sh_int vnum;
        char letter;
        int iHash;
 
        letter                          = fread_letter( fp );
        if ( letter != '#' )
        {
            bug( "Load_objects: # not found.", 0 );
            exit( 1 );
        }
 
        vnum                            = fread_number( fp );
        if ( vnum == 0 )
            break;
 
        fBootDb = FALSE;
        if ( get_obj_index( vnum ) != NULL )
        {
            bug( "Load_objects: vnum %d duplicated.", vnum );
            exit( 1 );
        }
        fBootDb = TRUE;
 
        pObjIndex                       = (OBJ_INDEX_DATA *) alloc_perm( sizeof(*pObjIndex) );
        pObjIndex->vnum                 = vnum;
        pObjIndex->area                 = area_last;            /* OLC */
        pObjIndex->new_format           = TRUE;
	pObjIndex->reset_num		= 0;
	newobjs++;
        pObjIndex->name                 = fread_string( fp );
        pObjIndex->short_descr          = fread_string( fp );
        pObjIndex->description          = fread_string( fp );
        pObjIndex->material		= fread_number( fp );
        pObjIndex->extra_flags          = fread_flag( fp );
        pObjIndex->wear_flags           = fread_flag( fp );
           /* Object class Needed to load rot objects here */

	pObjIndex->level		= fread_number( fp );
        pObjIndex->weight               = fread_number( fp );
        pObjIndex->cost                 = fread_number( fp ); 
        pObjIndex->plevel               = fread_number( fp );
        pObjIndex->exp                  = fread_number( fp );
        pObjIndex->xp_tolevel           = fread_number( fp );

        /* condition */
        letter 				= fread_letter( fp );
	switch (letter)
 	{
	    case ('P') :		pObjIndex->condition = 100; break;
	    case ('G') :		pObjIndex->condition =  90; break;
	    case ('A') :		pObjIndex->condition =  75; break;
	    case ('W') :		pObjIndex->condition =  50; break;
	    case ('D') :		pObjIndex->condition =  25; break;
	    case ('B') :		pObjIndex->condition =  10; break;
	    case ('R') :		pObjIndex->condition =   0; break;
	    default:			pObjIndex->condition = 100; break;
	}
 
        for ( ; ; )
        {
            char letter;
 
            letter = fread_letter( fp );
 
            if ( letter == 'A' )
            {
                AFFECT_DATA *paf;
 
                paf                     = (AFFECT_DATA *) alloc_perm( sizeof(*paf) );
		paf->where		= TO_OBJECT;
                paf->type               = -1;
                paf->level              = pObjIndex->level;
                paf->duration           = -1;
                paf->location           = fread_number( fp );
                paf->modifier           = fread_number( fp );
                paf->bitvector          = 0;
                paf->next               = pObjIndex->affected;
                pObjIndex->affected     = paf;
                top_affect++;
            }

	    else if (letter == 'F')
            {
                AFFECT_DATA *paf;
 
                paf                     = (AFFECT_DATA *) alloc_perm( sizeof(*paf) );
		letter 			= fread_letter(fp);
		switch (letter)
	 	{
		case 'A':
                    paf->where          = TO_AFFECTS;
		    break;
		case 'I':
		    paf->where		= TO_IMMUNE;
		    break;
		case 'R':
		    paf->where		= TO_RESIST;
		    break;
		case 'V':
		    paf->where		= TO_VULN;
		    break;
		default:
            	    bug( "Load_objects: Bad where on flag set.", 0 );
            	   exit( 1 );
		}
                paf->type               = -1;
                paf->level              = pObjIndex->level;
                paf->duration           = -1;
                paf->location           = fread_number(fp);
                paf->modifier           = fread_number(fp);
                paf->bitvector          = fread_flag(fp);
                paf->next               = pObjIndex->affected;
                pObjIndex->affected     = paf;
                top_affect++;
            }
 
            else if ( letter == 'E' )
            {
                EXTRA_DESCR_DATA *ed;
 
                ed                      = (EXTRA_DESCR_DATA *) alloc_perm( sizeof(*ed) );
                ed->keyword             = fread_string( fp );
                ed->description         = fread_string( fp );
                ed->next                = pObjIndex->extra_descr;
                pObjIndex->extra_descr  = ed;
                top_ed++;
            }

            else if ( letter == 'O' )
	    {
		PROG_LIST *pOprog;
		char *word;
		int trigger = 0;

		pOprog			= (PROG_LIST *) alloc_perm(sizeof(*pOprog));
		word			= fread_word( fp );
		if ( !(trigger = flag_lookup( word, oprog_flags )) )
		{
		    bug( "OBJprogs: invalid trigger.",0);
		    exit(1);
		}
		SET_BIT( pObjIndex->oprog_flags, trigger );
		pOprog->trig_type	= trigger;
		pOprog->vnum	 	= fread_number( fp );
		pOprog->trig_phrase	= fread_string( fp );
		pOprog->next		= pObjIndex->oprogs;
		pObjIndex->oprogs	= pOprog;
	    }
 
            else
            {
                ungetc( letter, fp );
                break;
            }
        }
 
        iHash                   = vnum % MAX_KEY_HASH;
        pObjIndex->next         = obj_index_hash[iHash];
        obj_index_hash[iHash]   = pObjIndex;
        top_obj_index++;
        top_vnum_obj = top_vnum_obj < vnum ? vnum : top_vnum_obj;   /* OLC */
        assign_area_vnum( vnum );                                   /* OLC */

    }
 
    return;
}

/** OLC Inserts here **/


/*****************************************************************************
 Name:	        convert_objects
 Purpose:	Converts all old format objects to new format
 Called by:	boot_db (db.c).
 Note:          Loops over all resets to find the level of the mob
                loaded before the object to determine the level of
                the object.
		It might be better to update the levels in load_resets().
		This function is not pretty.. Sorry about that :)
 Author:        Hugin
 
****************************************************************************/
void convert_objects( void )
{
    int vnum;
    AREA_DATA  *pArea;
    RESET_DATA *pReset;
    MOB_INDEX_DATA *pMob = NULL;
    OBJ_INDEX_DATA *pObj;
    ROOM_INDEX_DATA *pRoom;

    if ( newobjs == top_obj_index ) return; /* all objects in new format */

    for ( pArea = area_first; pArea; pArea = pArea->next )
    {
        for ( vnum = pArea->min_vnum; vnum <= pArea->max_vnum; vnum++ )
	{
	    if ( !( pRoom = get_room_index( vnum ) ) ) continue;

	    for ( pReset = pRoom->reset_first; pReset; pReset = pReset->next )
	    {
		switch ( pReset->command )
		{
		case 'M':
		    if ( !( pMob = get_mob_index( pReset->arg1 ) ) )
			bug( "Convert_objects: 'M': bad vnum %d.", pReset->arg1 );
		    break;

		case 'O':
		    if ( !( pObj = get_obj_index( pReset->arg1 ) ) )
		    {
			bug( "Convert_objects: 'O': bad vnum %d.", pReset->arg1 );
			break;
		    }
		    if ( pObj->new_format )
			continue;

		    if ( !pMob )
		    {
			bug( "Convert_objects: 'O': No mob reset yet.", 0 );
			break;
		    }

		    pObj->level = pObj->level < 1 ? pMob->level - 2			: UMIN(pObj->level, pMob->level - 2);
		    break;

		case 'P':
		    {
			OBJ_INDEX_DATA *pObj, *pObjTo;

			if ( !( pObj = get_obj_index( pReset->arg1 ) ) )
			{
			    bug( "Convert_objects: 'P': bad vnum %d.", pReset->arg1 );
		        break;
			}

			if ( pObj->new_format )
			    continue;

			if ( !( pObjTo = get_obj_index( pReset->arg3 ) ) )
			{
			    bug( "Convert_objects: 'P': bad vnum %d.", pReset->arg3 );
			    break;
			}

			pObj->level = pObj->level < 1 ? pObjTo->level
			    : UMIN(pObj->level, pObjTo->level);
	            }
		    break;

		case 'G':
		case 'E':
		    if ( !( pObj = get_obj_index( pReset->arg1 ) ) )
		    {
			bug( "Convert_objects: 'E' or 'G': bad vnum %d.", pReset->arg1 );
			break;
		    }

		    if ( !pMob )
		    {
			bug( "Convert_objects: 'E' or 'G': null mob for vnum %d.",
			     pReset->arg1 );
			break;
		    }

		    if ( pObj->new_format )
			continue;

			pObj->level = pObj->level < 1 ? pMob->level
			    : UMIN( pObj->level, pMob->level );
		    break;
		} /* switch ( pReset->command ) */
	    }
	}
    }

    /* do the conversion: */

    for ( pArea = area_first; pArea ; pArea = pArea->next )
	for ( vnum = pArea->min_vnum; vnum <= pArea->max_vnum; vnum++ )
	    if ( (pObj = get_obj_index( vnum )) )
 		if ( !pObj->new_format )
		    convert_object( pObj );

    return;
}



/*****************************************************************************
 Name:		convert_object
 Purpose:	Converts an old_format obj to new_format
 Called by:	convert_objects (db2.c).
 Note:          Dug out of create_obj (db.c)
 Author:        Hugin
 
****************************************************************************/
void convert_object( OBJ_INDEX_DATA *pObjIndex )
{
    int level;

    if ( !pObjIndex || pObjIndex->new_format ) return;

    level = pObjIndex->level;

    pObjIndex->level    = UMAX( 0, pObjIndex->level ); /* just to be sure */
    pObjIndex->cost     = 10*level;


    pObjIndex->new_format = TRUE;
    ++newobjs;

    return;
}


/*****************************************************************************
 Name:		convert_mobile
 Purpose:	Converts an old_format mob into new_format
 Called by:	load_old_mob (db.c).
 Note:          Dug out of create_mobile (db.c)
 Author:        Hugin
 
****************************************************************************/
void convert_mobile( MOB_INDEX_DATA *pMobIndex )
{
    int i;
    int type, number, bonus;
    int level;

    if ( !pMobIndex || pMobIndex->new_format ) return;

    level = pMobIndex->level;

    pMobIndex->act              |= ACT_WARRIOR;

    /*
     * Calculate hit dice.  Gives close to the hitpoints
     * of old format mobs created with create_mobile()  (db.c)
     * A high number of dice makes for less variance in mobiles
     * hitpoints.
     * (might be a good idea to reduce the max number of dice)
     *
     * The conversion below gives:

       level:     dice         min         max        diff       mean
         1:       1d2+6       7(  7)     8(   8)     1(   1)     8(   8)
	 2:       1d3+15     16( 15)    18(  18)     2(   3)    17(  17)
	 3:       1d6+24     25( 24)    30(  30)     5(   6)    27(  27)
	 5:      1d17+42     43( 42)    59(  59)    16(  17)    51(  51)
	10:      3d22+96     99( 95)   162( 162)    63(  67)   131(    )
	15:     5d30+161    166(159)   311( 311)   145( 150)   239(    )
	30:    10d61+416    426(419)  1026(1026)   600( 607)   726(    )
	50:    10d169+920   930(923)  2610(2610)  1680(1688)  1770(    )

	The values in parenthesis give the values generated in create_mobile.
        Diff = max - min.  Mean is the arithmetic mean.
	(hmm.. must be some roundoff error in my calculations.. smurfette 
got d6+23 hp at level 3 ? -- anyway.. the values above should be approximately right..)*/

    type   = level*level*27/40;
    number = UMIN(type/40 + 1, 10); /* how do they get 11 ??? */
    type   = UMAX(2, type/number);
    bonus  = (int)(UMAX(0, level*(8 + level)*.9 - number*type));

    pMobIndex->hit[DICE_NUMBER]    = number;
    pMobIndex->hit[DICE_TYPE]      = type;
    pMobIndex->hit[DICE_BONUS]     = bonus;

    pMobIndex->mana[DICE_NUMBER]   = level;
    pMobIndex->mana[DICE_TYPE]     = 10;
    pMobIndex->mana[DICE_BONUS]    = 100;

    /*
     * Calculate dam dice.  Gives close to the damage
     * of old format mobs in damage()  (fight.c)
     */
    type   = level*7/4;
    number = UMIN(type/8 + 1, 5);
    type   = UMAX(2, type/number);
    bonus  = UMAX(0, level*9/4 - number*type);

    pMobIndex->damage[DICE_NUMBER] = number;
    pMobIndex->damage[DICE_TYPE]   = type;
    pMobIndex->damage[DICE_BONUS]  = bonus;

    switch ( number_range( 1, 3 ) )
    {
        case (1): pMobIndex->dam_type =  3;       break;  /* slash  */
        case (2): pMobIndex->dam_type =  7;       break;  /* pound  */
        case (3): pMobIndex->dam_type = 11;       break;  /* pierce */
    }

    for (i = 0; i < 3; i++)
    pMobIndex->ac[i]         = interpolate( level, 100, -100);
    pMobIndex->ac[3]             = interpolate( level, 100, 0);    /* exotic */

    pMobIndex->wealth           /= 100;
    pMobIndex->size              = SIZE_MEDIUM;
    pMobIndex->material          = str_dup("none");

    pMobIndex->new_format        = TRUE;
    ++newmobs;

    return;
}

void load_classes( void )
{	char *word;
	int i;
	FILE *fp;
	char path[MSL];
	MAX_CLASS = 0;
	sprintf(path, "%s%s", CLASS_DIR, CLASS_FILE );
	if( ( fp = file_open(path, "r") ) == NULL )
	{	perror(path);
		exit(1);
	}

	for( word = fread_word(fp) ; str_cmp(word, "$") ; word = fread_word(fp) )
	{	if(!str_cmp(word, "Name") )
		{	MAX_CLASS++;
			if(MAX_CLASS != 1)
				class_table = (struct class_type *) realloc(class_table, sizeof(struct class_type) * MAX_CLASS );
			else
				class_table = (struct class_type *) malloc(sizeof(struct class_type) * MAX_CLASS );
			class_table[MAX_CLASS-1].name = fread_string(fp);
			continue;
		}

		if(!str_cmp(word, "who") )
		{	class_table[MAX_CLASS-1].who_name = fread_string(fp);
			continue;
		}

		if(!str_cmp(word, "Attr") )
		{	class_table[MAX_CLASS-1].attr_prime = fread_number(fp);
			continue;
		}

		if(!str_cmp(word, "Wpn" ))
		{	class_table[MAX_CLASS-1].weapon = (int *) malloc(sizeof(int) );
			*class_table[MAX_CLASS-1].weapon = fread_number(fp);
			continue;
		}

		if(!str_cmp(word, "Gld") )
		{	for(i = 0; i < MAX_GUILD; i++ )
				class_table[MAX_CLASS-1].guild[i] = fread_number(fp);
			continue;
		}

		if(!str_cmp(word, "Adpt") )
		{	class_table[MAX_CLASS-1].skill_adept = fread_number(fp);
			continue;
		}

		if(!str_cmp(word, "Thac") )
		{	class_table[MAX_CLASS-1].thac0_00 = fread_number(fp);
			class_table[MAX_CLASS-1].thac0_32 = fread_number(fp);
			continue;
		}

		if(!str_cmp(word, "Hp" ) )
		{	class_table[MAX_CLASS-1].hp_min = fread_number(fp);
			class_table[MAX_CLASS-1].hp_max = fread_number(fp);
			continue;
		}

		if(!str_cmp(word, "Mna") )
		{	class_table[MAX_CLASS-1].fMana = fread_number(fp);
			continue;
		}
		if(!str_cmp(word, "End" ) )
			continue;

		logf2("Unknown word in load_class");
	}
	file_close(fp);
	return;
}

#define FLAG_READ(string, value )  \
				if(!str_cmp(word, string) ) \
				{	value = fread_flag(fp); \
					continue;				\
				}							

void load_races( void )
{	char *word;
	FILE *fp;
	char path[MSL];
	int tmpMax =1;
	int resist;

	sprintf(path, "%s%s", RACE_DIR, RACE_FILE );
	if( ( fp = file_open(path, "r") ) == NULL )
	{	perror(path);
		exit(1);
	}

	for( word = fread_word(fp) ; str_cmp(word, "$") ; word = fread_word(fp) )
	{	if(!str_cmp(word, "Name") )
		{	tmpMax++;
			if(tmpMax == 2)
				race_table = (struct race_type *) malloc(sizeof(struct race_type) * tmpMax );
			else
				race_table = (struct race_type *) realloc(race_table, sizeof(struct race_type) * tmpMax );
			
			race_table[tmpMax-2].name = fread_string(fp);
			continue;
		}

		if(!str_cmp(word, "Pc" ) )
		{	race_table[tmpMax-2].pc_race = fread_number(fp);
			continue;
		}

		if(!str_cmp(word, "Imm" ) )
		{	race_table[tmpMax-2].imm_only = fread_number(fp);
			continue;
		}
		
		if(!str_cmp(word, "Res") )
		{	for( resist = 0 ; resist < MAX_RES  ; resist++ )
				race_table[tmpMax-2].resist[resist] = fread_number(fp);
			continue;
		}
		FLAG_READ("act", race_table[tmpMax-2].act );
		FLAG_READ("aff", race_table[tmpMax-2].aff );
		FLAG_READ("off", race_table[tmpMax-2].off );
		FLAG_READ("form", race_table[tmpMax-2].form );
		FLAG_READ("parts", race_table[tmpMax-2].parts );

		if(!str_cmp(word, "End" ) )
			continue;
		logf2("Unknown keyword in load_races()");
	}
	race_table[tmpMax-1].name = NULL;
	file_close(fp);
	return;
}

void load_pc_races( void )
{	char *word;
	int i;
	FILE *fp;
	char path[MSL];
	MAX_PC_RACE = 0;

	sprintf(path, "%s%s", RACE_DIR, PC_RACE_FILE );
	if( ( fp = file_open(path, "r") ) == NULL )
	{	perror(path);
		exit(1);
	}

	for( word = fread_word(fp) ; str_cmp(word, "$") ; word = fread_word(fp) )
	{	if(!str_cmp(word, "Name") )
		{	MAX_PC_RACE++;
			if(MAX_PC_RACE != 1)
				pc_race_table = (struct pc_race_type *) realloc(pc_race_table, sizeof(struct pc_race_type) * MAX_PC_RACE );
			else
				pc_race_table = (struct pc_race_type *) malloc(sizeof(struct pc_race_type) * MAX_PC_RACE );
			pc_race_table[MAX_PC_RACE-1].name = fread_string(fp);
			continue;
		}

		if(!str_cmp(word, "Who") )
		{	pc_race_table[MAX_PC_RACE-1].who_name = fread_string(fp);
			continue;
		}

		if(!str_cmp(word, "Pnt") )
		{	pc_race_table[MAX_PC_RACE-1].points = fread_number(fp);
			continue;
		}

		if(!str_cmp(word, "ClsMlt") )
		{	pc_race_table[MAX_PC_RACE-1].class_mult = (int *) malloc(sizeof(int) * MAX_CLASS );
			for(i = 0; i < MAX_CLASS ; i++ )
				pc_race_table[MAX_PC_RACE-1].class_mult[i] = fread_number(fp);
			continue;
		}

		if(!str_cmp(word, "Skills") )
		{	for(i = 0; i < 5 ; i++ )
				pc_race_table[MAX_PC_RACE-1].skills[i] = fread_string(fp);
			continue;
		}

		if(!str_cmp(word, "Stats") )
		{	for( i = 0; i < MAX_STATS ; i++ )
				pc_race_table[MAX_PC_RACE-1].stats[i] = fread_number(fp);
			continue;
		}

		if(!str_cmp(word, "MStat") )
		{	for( i = 0; i < MAX_STATS ; i++ )
				pc_race_table[MAX_PC_RACE-1].max_stats[i] = fread_number(fp);
			continue;
		}
		if(!str_cmp(word, "MCity"))
		{	pc_race_table[MAX_PC_RACE-1].mCity = fread_string(fp);
			continue;
		}

		if(!str_cmp(word, "size") )
		{	pc_race_table[MAX_PC_RACE-1].size = fread_number(fp);
			continue;
		}
		if(!str_cmp(word, "End" ) )
			continue;

		logf2("Bad word in load_pc_races()");
	}
	file_close(fp);
	return;
}

void fwrite_material()
{	int i;
	int tmp;
	struct material_type *mat;
	FILE *fp;

	if( ( fp = file_open(MAT_FILE, "w") ) == NULL )
	{	perror(MAT_FILE);
		return;
	}

	for( i = 0; material_table[i].name != NULL ; i++ )
	{	mat = &material_table[i];
		fprintf(fp, "Mat %s~\n",  mat->name );
		fprintf(fp, "Float %d\n",  mat->floatable );
		fprintf(fp, "Ignit %d\n", mat->igniteTmp  );
		fprintf(fp, "Mallb %d\n", mat->malleable );
		fprintf(fp, "Strng %d\n", mat->strength );
		fprintf(fp, "Solid %d\n", mat->solidTmp );
		fprintf(fp, "Redtp %d\n", mat->redTmp );
		fprintf(fp, "White %d\n", mat->whiteTmp );
		fprintf(fp, "Meltt %d\n", mat->meltTmp );
		fprintf(fp, "Smelt %d\n", mat->smeltTmp );
		fprintf(fp, "Evapt %d\n", mat->evapTmp );
		tmp = (int)(mat->density * 100);
		fprintf(fp, "Dense %d\n", tmp );
		continue;
	}
	fprintf(fp, "%s\n", END_CHAR);
	file_close(fp);
	return;
}
#define NUMBER( string, var )		\
			if(!str_cmp(word, (string) ) )	\
			{	var = fread_number(fp);		\
				continue;					\
			}

void fread_material()
{	int tmpMax = 0;
	FILE *fp;
	struct material_type *mat;
	char *word;
	float tmp;

	if ( ( fp = file_open(MAT_FILE, "r" ) ) == NULL )
	{	perror(MAT_FILE);
		exit(1);
	}

	for( word = fread_word(fp); str_cmp(word, END_CHAR) ; word = fread_word(fp) )
	{	
		if(!str_cmp(word, "Mat" ) )
		{	if( tmpMax == 0 )
			{	tmpMax++;
				material_table = (struct material_type *) malloc(sizeof( struct material_type ) * tmpMax);
			}
			else
			{	tmpMax++;
				material_table = (struct material_type *) realloc(material_table, sizeof( struct material_type ) * tmpMax+1);
			}
			mat = &material_table[tmpMax-1];
			mat->name = fread_string(fp);
			continue;
		}

		NUMBER("Float", mat->floatable);
		NUMBER("Ignit", mat->igniteTmp);
		NUMBER("Mallb", mat->malleable);
		NUMBER("Strng", mat->strength);
		NUMBER("Solid", mat->solidTmp);
		NUMBER("Redtp", mat->redTmp);
		NUMBER("White", mat->whiteTmp);
		NUMBER("Meltt", mat->meltTmp);
		NUMBER("Smelt", mat->smeltTmp);
		NUMBER("Evapt", mat->evapTmp);
		if(!str_cmp(word,"Dense") )
		{	tmp = fread_number(fp);
			mat->density = tmp/100;
			continue;
		}
	}


	material_table[tmpMax].name = NULL;
	file_close(fp);
}
